<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：用户控制器
 * +------------------------------------------------------------------------ 
**/  

class userControl extends adminControl {
	public $ControlName = "用户管理";
	private $cid;//父分类
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			
		),
		//用户权限功能
		"user"  => array(
			"index"        => "查看用户",
			"search"       => "搜索用户",
			"add"          => "添加用户",
			"del"          => "删除用户",
			"pledit"       => "批量修改用户名称",
			"pleditpass"   => "批量修改用户密码",
			"pleditcid"    => "批量修改所属角色",
			"pledittype"   => "批量修改用户状态",
			"pleditlogs"   => "批量修改操作日志"
		)
	);	
	
	public function __construct($conf){
		parent::__construct($conf);
		$this -> cid = $this -> p("cid",$this -> user["rid"],"1");
	}
	
	/**
	 * 查看用户
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."user/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}role order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		$upids = $wxfl -> getParentId($this -> user["rid"]);
		$zids = $wxfl -> getParentId($this -> cid);
		
		if(count($uzids)>0) unset($uzids[0]);
		
		if($this -> user["rid"] == "0"){
			$where = "";
		}else{
			if(is_array($uzids) && count($uzids)>0){
				$where = " where `rid`!='".$this->user["rid"]."' and `rid` in(".implode(",",$uzids).")";
			}else{
				$where = " where `rid`!='".$this->user["rid"]."' and `rid`='".$this -> user["rid"]."'";
			}
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select *,(select `name` from {$this->conf['prefix']}role as r where r.id=u.rid limit 0,1) as rname from {$this->conf['prefix']}user as u {$where} order by `rid` asc,`id` asc {$limit}");
		
		
		$records = $this -> db -> count("{$this->conf['prefix']}user","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=user&a=index&page={page}&cid=".$this->cid,"./index.php?c=user&a=index&cid=".$this->cid);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=user&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."user/index.php";
		exit();
	}
	
	/**
	 * 搜索用户
	**/
	public function search(){
		if(!file_exists(MYDECMS_PATH.$this->template."user/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$searchkey = isset($_GET['searchkey']) ? $this->glstr($_GET['searchkey'],6) : "";
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}user order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		$upids = $wxfl -> getParentId($this -> user["rid"]);
		$zids = $wxfl -> getParentId($this -> cid);
		
		if(count($uzids)>0) unset($uzids[0]);
		
		if($this -> user["rid"] == "0"){
			$where = " where `name` like '%".$searchkey."%'";
		}else{
			if(count($uzids)>0){
				$where = " where `rid` in(".implode(",",$uzids).") and `name` like '%".$searchkey."%'";
			}else{
				$where = " where `rid`='".$this -> user["rid"]."' and `name` like '%".$searchkey."%'";
			}
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select *,(select `name` from {$this->conf['prefix']}role as r where r.id=u.rid limit 0,1) as rname from {$this->conf['prefix']}user as u {$where} order by `rid` asc,`id` asc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}role","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=user&a=index&page={page}&searchkey=".urlencode($searchkey)."&cid=".$this->cid,"./index.php?c=user&a=index&cid=".$this->cid);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=user&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."user/index.php";
		exit();
	}
	
	/**
	 * 添加用户
	**/
	public function add(){
		if(!file_exists(MYDECMS_PATH.$this->template."user/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}role order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);

		if(count($uzids)>0) unset($uzids[0]);
		
		$v = array("id"=>"","name"=>"","menuqx"=>"","qx"=>"","actionlog"=>"","sort"=>"100");	
		
		include MYDECMS_PATH.$this->template."user/add.php";
		exit();
	}
	public function addAction(){
		
		$username     = $this -> p("username","","2");
		if($username == ""){
			$this -> msg("用户名不能为空","",false,3);
		}
		
		$password     = $this -> p("password","","2");
		if($password == ""){
			$this -> msg("用户密码不能为空","",false,3);
		}
		
		$password1     = $this -> p("password1","","2");
		if($password1 == ""){
			$this -> msg("确认密码不能为空","",false,3);
		}
		
		$password = md5($password);
		if($password != md5($password1)){
			$this -> msg("新密码与确认密码不一致","");
		}
		
		$type     = $this -> p("type","","2");
		if($type == ""){
			$this -> msg("用户状态不能为空","",false,3);
		}
		
		$rid     = $this -> p("rid","","2");
		if($rid == ""){
			$this -> msg("用户所属角色不能为空","",false,3);
		}
		
		$actionlog     = $this -> p("actionlog","1","2");
		if($actionlog == ""){
			$this -> msg("日志开关不能为空","",false,3);
		}
		
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}user order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		
		if(count($uzids)>0) unset($uzids[0]);
		
		if($this->user["rid"]!="0" && !in_array($this->cid,$uzids)){
			$this -> msg("您账号所属角色权限不能给非它下属角色添加新用户","",false,5);
		}
		
		$menuqx    = $this -> readContent($this -> p("menuqx",array(),"2"));
		$qx      = $this -> readContent($this -> p("qx",array(),"2"));
		
		if($this -> user["rid"] !=="0"){
			foreach($menuqx as $kk=>$vv){
				if(is_array($vv) && count($vv)>0){
					foreach($vv as $kkk=>$vvv){
						if(!isset($this->qx["menuqx"][$kk][$kkk])) unset($menuqx["menuqx"][$kk][$kkk]);
					}
				}
				if(!isset($this->qx["menuqx"][$kk])) unset($menuqx["menuqx"][$kk]);
			}
			
			foreach($qx as $kk=>$vv){
				if(is_array($vv) && count($vv)>0){
					foreach($vv as $kkk=>$vvv){
						if(!isset($this->qx["qx"][$kk][$kkk])) unset($qx["qx"][$kk][$kkk]);
					}
				}
				if(!isset($this->qx["qx"][$kk])) unset($qx["qx"][$kk]);
			}
		}
		
		$this -> db -> query("insert ignore into `{$this->conf['prefix']}user` (`rid`,`username`,`password`,`regdate`,`type`,`count`,`actiontime`,`enddate`,`endip`,`actionlog`) value ('".$rid."','".$username."','".$password."','".strtotime(date("Y-m-d H:i:s"))."','".$type."','0','".strtotime(date("Y-m-d H:i:s"))."','".strtotime(date("Y-m-d H:i:s"))."','".$this->getIp()."','".$actionlog."')");
		$this -> addlog("添加用户成功【".$this -> readContent($username)."】");
		$this -> msg("添加用户成功","./index.php?c=user&a=index&cid=".$this->cid,true);
	}
	
	
	/**
	 * 删除用户
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}user order by `id` asc");
		$wxfl = new mydecmsWuXianClass($clist);
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		
		if(count($uzids)>0) unset($uzids[0]);
			
		if($this -> user["rid"]!="0" && is_array($id)){
			foreach($id as $k=>$v){
				if(!in_array($v,$uzids))unset($id[$k]);
			}
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}user where `id` in(".implode(",",$id).")");
		}else{
			if($id != "" && in_array($id,$uzids)) $this -> db -> query("delete from {$this->conf['prefix']}user where `id`='".$id."'");
		}
		
		$this -> msg("批量删除用户完毕","./index.php?c=user&a=index&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改用户名称
	**/
	public function pledit(){
		$id      = $this -> p("id","","2");
		$ids     = $this -> p("ids","","2");
		$username    = $this -> p("username","","2");

		if($id == "" || $ids =="" || $username == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$idarr = array();
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}user order by `id` asc");
		$wxfl = new mydecmsWuXianClass($clist);
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		
		if(count($uzids)>0) unset($uzids[0]);
			
		if($this -> user["rid"]!="0" && is_array($ids)){
			foreach($ids as $k=>$v){
				if(!in_array($v,$uzids))unset($ids[$k]);
			}
		}
		
		foreach ($ids as $k => $v){
			if(in_array($v, $id)) $idarr[] = $k ;
		}
		
		try{
			foreach($idarr as $v){
				if($username[$v]=="" || $username[$v] == NULL) continue;
				$this -> db -> query("update {$this->conf['prefix']}user set `username`='".$username[$v]."' where `id`='".$ids[$v]."'");
			}
			$this -> addlog("批量修改用户数据【".(is_array($id) ? implode(",",$id):$id)."】");
			$this -> msg("批量修改数据成功","./index.php?c=user&a=index&cid=".$this->cid,true,5);
		}catch (Exception $err) {
			$this -> errlog("批量修改数据出错<br><p>".$err->getMessage()."</p>");
		}
	}
	
	/**
	 * 批量修改用户密码
	**/
	public function pleditpass(){
		$id          = $this -> p("id","","2");
		$password     = $this -> p("password","","2");
		$password1     = $this -> p("password1","","2");
		if($id == "" || $password == "" || $password1 == ""){
			$this -> msg("提交的数据错误","");
		}
		$password = md5($password);
		if($password != md5($password1)){
			$this -> msg("新密码与确认密码不一致","");
		}

		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}user order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		
		if(count($uzids)>0) unset($uzids[0]);
		
		if($this -> user["rid"]!="0" && is_array($id)){
			foreach($id as $k=>$v){
				if(!in_array($v,$uzids))unset($id[$k]);
			}
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}user set `password`='".$password."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}user set `password`='".$password."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改用户密码【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改用户密码成功","./index.php?c=user&a=index&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改所属角色
	**/
	public function pleditcid(){
		$id          = $this -> p("id","","2");
		$newcid     = $this -> p("newcid","1");
		if($id == "" || $newcid == ""){
			$this -> msg("提交的数据错误","");
		}

		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}user order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		
		if(count($uzids)>0) unset($uzids[0]);
		
		if($this -> user["rid"]!="0" && is_array($id)){
			foreach($id as $k=>$v){
				if(!in_array($v,$uzids))unset($id[$k]);
			}
		}
		
		if($this->user["rid"]!="0" && !in_array($newcid,$uzids)){
			$this -> msg("您账号所属角色无权限修改选中用户修改到目标所属角色","",false,5);
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}user set `rid`='".$newcid."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}user set `rid`='".$newcid."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改所属角色【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改所属角色成功","./index.php?c=user&a=index&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改用户状态
	**/
	public function pledittype(){
		$id          = $this -> p("id","","2");
		$type     = $this -> p("type","1");
		if($id == "" || $type == ""){
			$this -> msg("提交的数据错误","");
		}

		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}user order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		
		if(count($uzids)>0) unset($uzids[0]);
		
		if($this -> user["rid"]!="0" && is_array($id)){
			foreach($id as $k=>$v){
				if(!in_array($v,$uzids))unset($id[$k]);
			}
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}user set `type`='".$type."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}user set `type`='".$type."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改用户状态【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改用户状态成功","./index.php?c=user&a=index&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改操作日志
	**/
	public function pleditlogs(){
		$id          = $this -> p("id","","2");
		$logstype     = $this -> p("type","1");
		if($id == "" || $logstype == ""){
			$this -> msg("提交的数据错误","");
		}

		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}user order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		
		if(count($uzids)>0) unset($uzids[0]);
		
		if($this -> user["rid"]!="0" && is_array($id)){
			foreach($id as $k=>$v){
				if(!in_array($v,$uzids))unset($id[$k]);
			}
		}
		
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}user set `actionlog`='".$logstype."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}user set `actionlog`='".$logstype."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改操作日志【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改操作日志成功","./index.php?c=user&a=index&cid=".$this->cid,true);
	}

	/**
	 * 清空用户
	**/
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}article");
		$this -> addlog("清空用户表数据");
		$this -> msg("清空表数据成功","./index.php?c=user&a=index",true);
	}
}
?>