<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：用户操作日志管理控制器
 * +------------------------------------------------------------------------ 
**/  

class useractionlogsControl extends adminControl {
	public $ControlName = "用户操作日志管理";
	private $pageCode;//分页源代码
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
		),
		//用户权限功能
		"user"  => array(
		)
	);
		
	public function __construct($conf){
		parent::__construct($conf);
	}
	
	/**
	 * 查看用户操作日志
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."useractionlogs/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$where = "";
				
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select *,(select `username` from {$this->conf['prefix']}user where id=u.userid limit 0,1) as username from {$this->conf['prefix']}user_action_logs as u {$where} order by `id` desc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}user_action_logs","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=useractionlogs&a=index&page={page}","./index.php?c=useractionlogs&a=index");
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=useractionlogs&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."useractionlogs/index.php";
		exit();
	}
	
	/**
	 * 搜索用户操作日志
	**/
	public function search(){
		if(!file_exists(MYDECMS_PATH.$this->template."useractionlogs/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$searchtype = isset($_GET['searchtype']) ? $this->glstr($_GET['searchtype']) : "1";
		
		$searchkey = isset($_GET['searchkey']) ? $this->glstr($_GET['searchkey'],6) : "";
		if(empty($searchkey)){
			header("Location: ./index.php?c=useractionlogs&a=index");
		}
		
		$where = "";
		
		switch($searchtype){
			case "1":
				$where = " where `userid` in (select id from {$this->conf['prefix']}user where `username` like '%".$searchkey."%')";
				break;
			case "2":
				$where = " where `userid`=".$this->glstr($searchkey,1)."";
				break;
			default:
				$where = "";
				break;
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select *,(select `username` from {$this->conf['prefix']}user where id=u.userid limit 0,1) username from {$this->conf['prefix']}user_action_logs as u {$where} order by `id` desc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}user_action_logs","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=useractionlogs&a=search&page={page}&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype,"./index.php?c=useractionlogs&a=search&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=useractionlogs&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."useractionlogs/index.php";
		exit();
	}

	
	/**
	 * 删除用户操作日志
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}user_action_logs where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("delete from {$this->conf['prefix']}user_action_logs where `id`='".$id."'");
		}
		$this -> addlog("批量删除用户操作日志【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除用户操作日志成功","./index.php?c=useractionlogs&a=index&page=".$this->page,true);
	}
	
	/**
	 * 删除选中记录用户操作记录
	**/
	public function deluserlogs(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}user_action_logs where `userid` in(select `userid` from {$this->conf['prefix']}user_action_logs where `id` in(".implode(",",$id)."))");
		}else{
			$this -> db -> query("delete from {$this->conf['prefix']}user_action_logs where `userid` in(select `userid` from {$this->conf['prefix']}user_action_logs where `id`=".$id.")");
		}
		$this -> addlog("删除选中记录用户操作记录【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("删除选中记录用户操作记录成功","./index.php?c=useractionlogs&a=index&page=".$this->page,true);
	}
		
	
	/**
	 * 清空用户操作日志
	**/
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}user_action_logs");
		$this -> addlog("清空用户操作日志数据");
		$this -> msg("清空用户操作日志数据成功","./index.php?c=useractionlogs&a=index",true);
	}
}
?>