<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：程序后台根控制器
 * +------------------------------------------------------------------------ 
**/  

class adminControl extends mydecmsClass {
	
	public $db;//数据库链接
	public $conf;//配置信息
	public $config;//程序设置对象
	public $user;//当前登录用户
	public $qx;//当前登录用户后台操作权限
	public $starDate;//程序运行开始时间
	public $template = "template/";//模板目录
	public $page = 1;//当前页码
	public $control="index";
	public $action = "index";//默认调用方法
	
	public function __construct($conf){
		$this -> starDate = microtime(true);
		parent::__construct();
		$this -> control = isset($_GET["c"]) ? $this ->glstr($_GET["c"],5) : "index";
		$this -> action = isset($_GET["a"]) ? str_replace("Action","",$this ->glstr($_GET["a"],5)) : "index";
		$this -> db = new mydecmsMysql($conf["db"]["mysql"]);
		$this -> conf = $conf;
		$this -> conf['prefix'] = $conf["db"]["mysql"]["prefix"];
		
		$this -> config = $this -> db -> fetch_first("select * from {$this->conf['prefix']}system order by id asc limit 0,1");
		
		if(!$this -> config){
			$this -> errlog("网站的配置表数据记录为空<br>请登录mysql数据手动添加数据");
			exit();
		}
		
		$this -> config['wjt'] = json_decode($this -> config['wjt'],true);
		$this -> config['water'] = json_decode($this -> config['water'],true);


		$thisUser = array();
		if(isset($_COOKIE["mydeCmsAdmin"]) && strlen($_COOKIE["mydeCmsAdmin"])>0){
			$mydeCmsAdmin = $this -> Strencode($this -> readContent($_COOKIE["mydeCmsAdmin"]),$this->conf["secretKey"],false);
			preg_match("/\[userid=(?<userid>[0-9]+)\]\[username=(?<username>[^\]]{1,26})\]\[ip=(?<ip>[^\]]+)\]\[time=(?<time>[0-9\.]+)\]\[actiontime=(?<actiontime>[0-9\.]+)\]/u",$mydeCmsAdmin,$thisUser);
			
			if(!isset($thisUser["userid"])){
				$this -> loginout();
			}
			
			$this -> user = $this -> db -> fetch_first("select * from {$this->conf['prefix']}user where `id`=".$thisUser["userid"]);
			if(!$this -> user){
				$this -> loginout();
			}
			
			$qx = $this -> db -> fetch_first("select `id`,`name`,`menuqx`,`qx`,`actionlog` from {$this->conf['prefix']}role where `id`=".$this -> user["rid"]);
			
			if(!$qx && $this -> user["rid"]!="0"){
				$this -> errlog("您的账号【".$this -> user["username"]."】当前所属的角色权限不存在，请联系管理解决");
			}
			
			$this -> qx = array("id"=>$qx["id"],"name"=>$qx["name"],"menuqx"=>unserialize($qx["menuqx"]),"qx"=>unserialize($qx["qx"]),"actionlog"=>$qx["actionlog"]);
			
			if($this -> user["type"]=="2"){
				$this -> errlog("您的账号【".$this -> user["username"]."】已被管理员设置为禁止登录");
			}
			
			$ip = $this->getIp();
			
			if($thisUser["time"] != $this -> user["enddate"] || $thisUser["actiontime"] != $this -> user["actiontime"] || $thisUser["username"] != $this -> user["username"]){
				$this -> loginout();
			}
			
			$date = strtotime(date("Y-m-d H:i:s"));
			
			if(($date-$thisUser["actiontime"])/3600>15 && ($date-$thisUser["actiontime"])/3600/24<2){
				$this-> db -> query("update {$this->conf['prefix']}user set `actiontime`='{$date}' where `id`=".$this -> user["id"]);
				setcookie("mydeCmsAdmin",$this -> Strencode("[userid=".$this -> user["id"]."][username=".$this -> user["username"]."][ip={$ip}][time=".$this -> user["enddate"]."][actiontime={$date}]",$this->conf["secretKey"]),time()+3600*24);
			}else{
				if(($date-$thisUser["actiontime"])/3600/24>=2){
					$this -> loginout();
				}
			}
		}else{
			if($this -> control!="login"){
				$this -> loginout();
			}
		}
		
		$this -> page = $this -> glstr($this->p("page",1));
		
		if($this -> user["rid"]!="0" && !in_array($this -> control,array('login','index'))){
			if(!isset($this -> quanxian['open'][$this -> action])){
				if(!isset($this -> quanxian['user'][$this -> action]) && !isset($this -> qx['qx'][$this -> control][$this -> action])){
					exit("您无权限进行此操作");
				}
			}
		}
	}
	
	
	
	/**
	 * 添加操作日志
	 * $logcontent => 日志内容
	**/
	public function addlog($logcontent){
		if($this->config['actionlog']=='2') return;
		if($this -> qx['actionlog']=='2' && $this -> user['actionlog']=='2') return;
		if($this -> user['actionlog']=='2') return;
		$this -> db -> query("insert ignore into `{$this->conf['prefix']}user_action_logs` (`userid`,`content`,`date`) value ('".$this->user['id']."','".$this->writeContent($logcontent)."','".strtotime(date("Y-m-d H:i:s"))."')");
	}
	
	
	
	/**
	 * 操作提示
	 * @param $msg => 提示信息
	 * @param $url => 页面要跳转到的地址
	 * @param $ok  => true为操作成功，false为操作错误
	 * @param $s   => 页面跳转倒计时秒数
	**/
	public function msg($msg,$url="",$ok=false,$s=5){
		include MYDECMS_PATH.'template/system/msg.php';
		exit();
	}
	
	/**
	 * 退出登录
	 * 
	**/
	public function loginout()
	{
		setcookie("mydeCmsAdmin", "", time() - 3600);
		$this -> gotourl("./index.php?c=login&a=login");
	}
	

	/**
	 * 跳转页面
	 * $url => 目标页面
	**/
	public function gotourl($url,$msg=""){
		exit('<!DOCTYPE html><html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /><style type="text/css">*{padding:0; margin:0;}</style><title>跳转页面中。。。</title></head><body><p>'.$msg.'</p><script type="text/javascript">parent.window.location.href="'.$url.'";</script></body></html>');
	}
	
	function __destruct(){
		//echo round(microtime(true) - $this -> starDate,3);
	}
}
?>