<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：程序前台根控制器
 * +------------------------------------------------------------------------ 
**/ 

class frontControl extends mydecmsClass {
	public $db;                 //数据库链接
	public $config;             //程序设置对象
	public $action = "index";   //默认调用方法
	public $mb;                 //判断是否为手机端
	public $url;                //当前的URL
	public $conf;               //数据库链接配置
	//public $starDate;//程序运行开始时间
	public $tpldir;             //模板目录
	public $SpiderArr = array
	(
		'baidu'     => '百度蜘蛛',
		'360spider' => '360蜘蛛',
		'sogou'     => '搜狗蜘蛛',
		'google'    => '谷歌蜘蛛',
		'bing'      => "必应蜘蛛"
	);
	
	public function __construct($conf){
		//$this -> starDate = microtime(true);
		parent::__construct();
		$this -> mb = $this -> isMobile() != false ? ".m" : "" ; 
		$this -> url = "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
		if(isset($_GET["a"]) && $this ->glstr($_GET["a"],5)!="") $this -> action = $this ->glstr($_GET["a"],5);
		$this -> db = new mydecmsMysql($conf["db"]["mysql"]);
		$this -> conf = $conf;
		$this -> conf['prefix'] = $conf["db"]["mysql"]["prefix"];
		$this -> config = $this -> db -> fetch_first("select *,(select `tplfolder` from {$this->conf['prefix']}tplsubject where `folder`=s.softtpl limit 0,1) as tpl from {$this->conf['prefix']}system as s order by id asc limit 0,1");
		
		//记录蜘蛛
		if($this -> config['spider'] == "1") $this -> add();
		
		if(!$this -> config){
			$this -> errlog("网站的配置表数据记录为空<br>请联系网站管理员登录mysql数据手动添加数据");
			exit();
		}
		
		$this -> config['wjt'] = json_decode($this -> config['wjt'],true);
		
		$this -> tpldir = $this->config["softdir"]."moban/".$this->config["softtpl"];
		
	}
	
	/**
	 * 返回模板路径
	 * $tplname => 模板文件名
	**/
	public function getTpl($tplname,$cache = false,$cacheTime=3600){
		if($cache){
			if(file_exists(MYDECMS_PATH."cache/{$tplname}{$this -> mb}.php")){
				$date = filemtime(MYDECMS_PATH."cache/{$tplname}{$this -> mb}.php");
				if($date && strtotime(date("Y-m-d H:i:s")) - $date < $cacheTime) return MYDECMS_PATH."cache/{$tplname}{$this -> mb}.php";
			}
		}
		
		if(!file_exists(MYDECMS_PATH."moban/{$this->config['softtpl']}/{$this->config['tpl']}/{$tplname}{$this -> mb}.php")){
			return false;
		}else{
			if($cache){
			
			}
			return MYDECMS_PATH."moban/{$this->config['softtpl']}/{$this->config['tpl']}/{$tplname}{$this -> mb}.php";
		}
	}
	
	/**
	 * 文章分类url
	 * $v => 文章分类记录信息数组
	**/
	public function flurl($v){
		$url = $this -> config['webwjt'] == "2" ? '{weburl}{softdir}index.php?c=category&a=index&id={cid}' :$this -> config['wjt']['category'];
		$url = str_replace(array('{weburl}','{softdir}','{cid}','{urlname}'),array($this->config['weburl'],$this->config['softdir'],isset($v['id']) ? $v['id']:'',isset($v['urlname']) ? $v['urlname'] : ''),$url);
		return $url;
	}
	
	/**
	 * 文章url
	 * $v => 文章记录信息数组
	**/
	public function wzurl($v){
		$url = $this -> config['webwjt'] == "2" ? '{weburl}{softdir}index.php?c=article&a=index&id={id}' : $this -> config['wjt']['article'];
		$url = str_replace(array('{weburl}','{softdir}','{cid}','{urlname}','{id}'),array($this->config['weburl'],$this->config['softdir'],isset($v['cid']) ? $v['cid'] : '',isset($v['urlname']) ? $v['urlname'] : '',isset($v['id']) ? $v['id'] : ''),$url);
		return $url;
	}
	
	/**
	 * 文章链接锚文本
	 * $v => 文章记录信息数组
	 * $i => 取标题数组指定段索引
	**/
	public function wztitle($v,$i=0){
		if(!isset($v['title']) || $v['title'] == "") return $v;
		$title = explode(" ",$v['title']);
		if(isset($title[$i]) && $title[$i] != ""){
			return $title[$i];
		}else if(isset($title[0]) && $title[0] != ""){
			return $title[0];
		}else if(isset($title[1]) && $title[1] != ""){
			return $title[1];
		}else{
			return $v;
		}
	}
	
	/**
	 * tag标签url
	 * $v => tag标签
	**/
	public function tagurl($v){
		$url = $this -> config['webwjt'] == "2" ? '{weburl}{softdir}index.php?c=tag&a=index&urlname={tag}' : $this -> config['wjt']['tag'];
		$url = str_replace(array('{weburl}','{softdir}','{tag}'),array($this->config['weburl'],$this->config['softdir'],urlencode($v)),$url);
		return $url;
	}
	
	
	/**
	 * 记录蜘蛛爬行日志
	**/
	public function add()
	{
		$ip = $this ->GetIp();
		$gltype = $this -> db -> count("{$this->conf['prefix']}glspider","id"," where `ip`='{$ip}'");
		if($gltype>0) return false;
		$spider = $this -> GetSpider();
		if($spider){
			return $this -> db -> query("insert ignore into {$this->conf['prefix']}spiderlogs (`name`,`url`,`date`,`ip`) value ('".$spider."','".$this -> url."','".strtotime(date("Y-m-d H:i:s"))."','".$ip."')");
		}
		return false;
	}
	
	/**
	 * 判断是否为$SpiderArr数组中的蜘蛛
	**/
	private function GetSpider()
	{
		$useragent = strtolower($_SERVER['HTTP_USER_AGENT']);
		foreach($this -> SpiderArr as $k => $v)
		{
			if (strpos($useragent, $k) !== false){
				return $k;
			}
		}
		return false;
	}
	
	/*移动端判断*/
	private function isMobile()
	{ 
		// 如果有HTTP_X_WAP_PROFILE则一定是移动设备
		if (isset ($_SERVER['HTTP_X_WAP_PROFILE']))
		{
			return true;
		} 
		// 如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
		if (isset ($_SERVER['HTTP_VIA']))
		{ 
			// 找不到为flase,否则为true
			return stristr($_SERVER['HTTP_VIA'], "wap") ? true : false;
		} 
		// 脑残法，判断手机发送的客户端标志,兼容性有待提高
		if (isset ($_SERVER['HTTP_USER_AGENT']))
		{
			$clientkeywords = array ('nokia',
				'sony',
				'ericsson',
				'mot',
				'samsung',
				'htc',
				'sgh',
				'lg',
				'sharp',
				'sie-',
				'philips',
				'panasonic',
				'alcatel',
				'lenovo',
				'iphone',
				'ipod',
				'blackberry',
				'meizu',
				'android',
				'netfront',
				'symbian',
				'ucweb',
				'windowsce',
				'palm',
				'operamini',
				'operamobi',
				'openwave',
				'nexusone',
				'cldc',
				'midp',
				'wap',
				'mobile'
				); 
			// 从HTTP_USER_AGENT中查找手机浏览器的关键字
			if (preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT'])))
			{
				return true;
			} 
		} 
		// 协议法，因为有可能不准确，放到最后判断
		if (isset ($_SERVER['HTTP_ACCEPT']))
		{ 
			// 如果只支持wml并且不支持html那一定是移动设备
			// 如果支持wml和html但是wml在html之前则是移动设备
			if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html'))))
			{
				return true;
			} 
		} 
		return false;
	}
	
	function __destruct(){
		//echo round(microtime(true) - $this -> starDate,3);
	}
}

?>