<?php

/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright http://www.mydecms.com/ All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 文件说明：整套程序根类
 * +------------------------------------------------------------------------ 
**/ 


class mydecmsClass {
	
	private static $runType = false;
	
	public function __construct(){
		
		if(self::$runType) return;
		
		//转义$_GET传递的数据
		if(!MAGIC_QUOTES_GPC && isset($_GET)) $_GET = $this -> writeContent($_GET);
		
		//转义$_POST传递的数据
		if(!MAGIC_QUOTES_GPC && isset($_POST)) $_POST = $this -> writeContent($_POST);
		
		//转义$_COOKIE传递的数据
		if(!MAGIC_QUOTES_GPC && isset($_COOKIE)) $_COOKIE = $this -> writeContent($_COOKIE);
		
		//转义$_FILES传递的数据
		if(!MAGIC_QUOTES_GPC && isset($_FILES)) $_FILES = $this -> writeContent($_FILES);
		
		self::$runType = true;
	}
	
	/**
	 * 贤诚建站系统版本义
	**/
	public $version = "4.0";
	
	/**
	 * 保留指定类型的字符
	 * @param $name    => 要传值的表单名
	 * @param $default => 默认值
	 * @param $type    => 1为GET，2为POST，3为Cookie，4为server
	 * @return string
	**/
	public function p($name,$default="",$type="1"){
		switch($type){
			case "2":
			case "post":
			case "POST":
				$return = isset($_POST[$name]) ? $_POST[$name]: $default;
				break;
			case "3":
			case "cookie":
			case "COOKIE":
				$return = isset($_COOKIE[$name]) ? $_COOKIE[$name]: $default;
				break;
			case "4":
			case "server":
			case "SERVER":
				$return = isset($_SERVER[$name]) ? $_SERVER[$name]: $default;
				break;
			default:
				$return = isset($_GET[$name]) ? $_GET[$name]: $default;
				break;
			
		}
		return $return;
	}
	
	/**
	 * 保留指定类型的字符
	 * @param $content => 
	 * @param $type    => 1整数，2小数，3字母，4汉字，5小数+字母+下划线，6数字+字母+汉字
	 * @return string
	**/
	public function glstr($content,$type=1){
		if(strlen($content)<1) return $content;
		switch($type){
			case 1:
				$content = preg_replace("/[^0-9]/u","",$content);
				break;
			case 2:
				$content = preg_replace("/[^0-9\.]/u","",$content);
				break;
			case 3:
				$content = preg_replace("/[^a-zA-Z_]/u","",$content);
				break;
			case 4:
				$content = preg_replace("/[^_\x{4e00}-\x{9fa5}]/u","",$content);
				break;
			case 5:
				$content = preg_replace("/[^0-9\.a-zA-Z_]/u","",$content);
				break;
			case 6:
				$content = preg_replace("/[^0-9\.a-zA-Z_\x{4e00}-\x{9fa5}]/u","",$content);
				break;
			case 7:
				$content = preg_replace("/[^0-9\.a-zA-Z_\x{4e00}-\x{9fa5}\@\#\%\+\-\.\,\/]/u","",$content);
				break;
		}
		return $content;
	}
	
	/**
	 * 将字符串或者数组中的特殊字符转义
	 * @param unknown_type $contentStr
	 * @return string
	**/
	public function writeContent($contentStr)
	{
		if($contentStr=="" || $contentStr == NULL) return $contentStr;
		if(is_array($contentStr)){
			foreach($contentStr as $k => $v){
				$contentStr[$k] = is_array($v) ? $this -> writeContent($v) : addslashes($v);
			}
			return $contentStr;
		}
		
		return addslashes($contentStr);
	}
	
	
	/**
	 * 将字符串或者数组中已经转义的特殊字符还原
	 * @param unknown_type $contentStr
	 * @return string
	 */
	public function readContent($contentStr)
	{
		if(is_array($contentStr)){
			foreach($contentStr as $k => $v){
				$contentStr[$k] = is_array($v) ? $this -> readContent($v) : stripslashes($v);
			}
			return $contentStr;
		}else{
			return stripslashes($contentStr);
		}
		
	}
	
	/*
	 * +-------------获取IP地址---------------
	 */
	public	function getIp(){
		if ($_SERVER['REMOTE_ADDR']){
			$ip = $_SERVER['REMOTE_ADDR'];
		}elseif (getenv("REMOTE_ADDR")){
			$ip = getenv("REMOTE_ADDR");
		} elseif (getenv("HTTP_CLIENT_IP")){
			$ip = getenv("HTTP_CLIENT_IP");
		}else if(isset($_SERVER['SERVER_ADDR'])){
			$ip = $_SERVER['SERVER_ADDR'];
		}else {
			$ip = "未知";
		}
		return $ip;
	}
	
	/*
	 * +-------------遍历创建文件夹函数---------------
	**/
	public function createDir($dir){
		try{
			if(!file_exists($dir)){
				$this -> createDir(dirname($dir));
				mkdir($dir,0777);
			}
		}catch(Exception $err){
			$this -> errlog("创建目录【".$dir."】失败，请检查是否有写入权限");
		}
	}
	
	/*
	 * +-------------遍历删除文件夹函数---------------
	**/
	public function delDir($dir){
		try{
			if(file_exists($dir)){
				if(is_dir($dir)){
					$handle=opendir($dir); 
					while (false !== ($file = readdir($handle))){//遍历文件夹下所有文件
						if ($file != "." && $file != "..") {
							if(is_dir("{$dir}/".$file."/")){
								$this -> delDir("{$dir}/".$file."/");
							}else{
								unlink("{$dir}/".$file);
							}
						}
					}
					closedir($handle);
					rmdir($dir);
				}else{
					unlink($dir);
				}
			}
		}catch(Exception $err){
			$this -> errlog("删除目录【".$dir."】失败，请检查是否有写入权限");
		}
	}
	
	/*
	 * +-------------错误提示函数---------------
	 * | $msg => 错误信息说明
	 * +---------------------------------------
	 */
	public function errlog($msg){
		exit('<!DOCTYPE html><html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /><title>错误提示 - 贤诚建站系统</title><style type="text/css">*{ padding:0px; margin:0px;}body{ background:#FFF;}#mydeCms{max-width:560px; margin:50px auto; border:1px solid #D6DFE6; background:#F9F9F9; border-radius:10px;-moz-box-shadow:4px 4px 12px -2px rgba(88,103,125,.5);-webkit-box-shadow:4px 4px 12px -2px rgba(88,103,125,.5);box-shadow:4px 4px 12px -2px rgba(88,103,125,.5)}#mydeCms h1{font-size:18px; text-indent:20px; line-height:45px; border-bottom:1px solid #D6DFE6; color:#555; position:relative;letter-spacing:2px;}#mydeCms h1 span{ font-size:13px; font-style:normal; position:absolute; top:0px; right:10px;font-weight:normal;}#mydeCms h1 span em{ font-size:14px; color:red; font-style:normal; font-weight:normal;}#msg{background:#FFF;}#msg table{min-height:80px;}#msg td{padding:8px; line-height:35px; font-size:18px; color:#666;}#msgcontent{ padding:5px;border-radius:3px; color:red;letter-spacing:2px;}#copyRight{ height:35px; overflow:hidden; line-height:35px;border-top:1px solid #D6DFE6; font-size:12px; color:#666; text-align:center;}#copyRight a{ text-decoration:none; color:#666;}#btn{ background:#FFF; padding-bottom:10px;}#btn a{ display:block; text-align:center; width:135px; background:#28B5D6;border-radius:3px; color:#FFF; text-decoration:none; line-height:35px;}#btn a:hover{background:#20A3C5;}</style></head><body><div id="mydeCms"><h1>错误提示</h1><div id="msg"><table width="100%" border="0" cellpadding="0" cellspacing="1"><tr><td valign="middle"><div id="msgcontent">'.$msg.'</div>'.(isset($_SERVER['HTTP_REFERER']) && isset($_SERVER['HTTP_HOST']) && strpos($_SERVER['HTTP_REFERER'],$_SERVER['HTTP_HOST'])!==false ? '<div id="btn"><table border="0" cellpadding="5" cellspacing="5" align="center" style="margin:0px auto;"><tr><td valign="middle"><a id="upa" href="javascript:history.go(-1);">返回上一步</a></td></tr></table></div>':'').' </td></tr></table></div><div id="copyRight">Copyright &copy; <a href="http://www.mydecms.com/" target="_blank">MYDECMS</a> All rights reserved. </div></div></body></html>');
	}
	
	/*
	 * +------字符串简单加密和解密函数------------
	 * | $charString  => 要加密或者解密的字符串
	 * | $secretKey   => 加解密用的密匙
	 * | $encode      => true为加密，false为解密
	 * +---------------------------------------
	 */
	public function Strencode($charString,$secretKey,$encode=true){
		$chrArr=array('a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',
					  'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
					  '0','1','2','3','4','5','6','7','8','9');
		if(!$encode){
			if(strlen($charString)<14)return false;
			$verity_str=substr($charString, 0,8);
			$charString=substr($charString, 8);
			if($verity_str!=substr(md5($charString),0,8)){
				//完整性验证失败
				return false;
			}    
		}
		$key_b     = !$encode?substr($charString,0,6):$chrArr[rand()%62].$chrArr[rand()%62].$chrArr[rand()%62].$chrArr[rand()%62].$chrArr[rand()%62].$chrArr[rand()%62];
		$rand_key  = $key_b.$secretKey;
		$rand_key  = md5($rand_key);
		$charString       = !$encode?base64_decode(substr($charString, 6)):$charString;
		$texlen    = strlen($charString);
		$reslutstr = "";
		for($i=0;$i<$texlen;$i++){
			$reslutstr.=$charString{$i}^$rand_key{$i%32};
		}
		if($encode){
			$reslutstr=trim($key_b.base64_encode($reslutstr),"==");
			$reslutstr=substr(md5($reslutstr), 0,8).$reslutstr;
		}
    	return $reslutstr;
	}
}
?>