<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：mysql数据库操作类
 * +------------------------------------------------------------------------ 
**/  

class mydecmsMysql extends mydecmsClass {
	
	/**
	 * mysql数据库配置数组
	 * 
	 */
	private $conf;
	
	/**
	 * 数据库连接句柄
	 * 
	 */
	public $link;
	
	public function __construct($conf){
		parent::__construct();
		$this->conf = $conf;
	}
	
	/**
	 * 连接数据库
	 * @param $dbName 要连接的数据库名
	 */
	public function connect($dbName){
		try {
			if($this->link && $dbName == $this->conf['dbname']){
				
				return $this->link;
				
			}else{
				
				$link = @mysql_connect($this->conf['host'].($this->conf['port'] != '3306' ? $this->conf['port'] : ''), $this->conf['user'], $this->conf['pass']);
				
				if(!$link) $this -> errlog("数据库连接失败，请检查数据库配置文件config/db.php是否是填写正确！");
				
				mysql_query("SET NAMES '{$this->conf['charset']}'",$link);
				
				$result = mysql_select_db($this->conf['dbname'],$link);
				
				if(!$result){
					mysql_query("CREATE DATABASE {$this->conf['dbname']}",$link);
					$result = mysql_select_db($this->conf['dbname'],$link);
				}
				if(!$result) $this -> errlog("没有找到【".$this->conf['dbname']."】的数据库！");
				
				$this->link = $link;
				
				return $link;
			}
		}catch (Exception $err) {
			$this -> errlog("SQL语句执行失败，请检查SQL语句是否正确！<br><p>".$err->getMessage()."</p>");
		}
	}

	/** 
	 * 直接返回记录关联型数组
	 */
	public function keyList($sql,$fescape=true){
		$arr = array();
		$result = $this->query($sql,false);
		while($row = $this->fetch_array($result)){
			$arr[] = $fescape ? $this -> fieldEscape($row) : $row;
		}
		return $arr;
	}
	
	/**
	 * 从结果集中取得一行作为关联数组.
	 * @param unknown_type $result
	 */
	public function fetch_array($result)
	{
		try {
			return @mysql_fetch_array($result, MYSQL_ASSOC);
		}catch (Exception $err) {
			$this -> errlog("SQL语句执行失败，请检查SQL语句是否正确！<br><p>".$err->getMessage()."</p>");
		}
	}

	
	/**
	 * 获取第一行数据
	 * @param unknown_type $sql
	 */
	public function fetch_first($sql,$fescape=true){
		try {
			$query = $this->query($sql,false);
			
			$result = mysql_fetch_assoc($query);
			
			return $fescape ? $this -> fieldEscape($result) : $result;
		}catch (Exception $err) {
			$this -> errlog("SQL语句执行失败，请检查SQL语句是否正确！<br><p>".$sql."</p>");
			
		}
	}
	
	/** 
	 * 获取记录总数
	 */
	public function count($dbname,$filed="id",$where=""){
		$num = $this->fetch_first("select count({$filed}) as `num`  from $dbname $where ");
		return isset($num['num']) ? $num['num'] : 0;
	}
	
	
	/** 
	 * 清空表记录
	 * @see db_interface::truncate()
	 */
	public function truncate($table){
		
		$table = str_replace('-table-',$this->conf['prefix'],$table);
		
		if(strpos($table,$this->conf['prefix']) === false) $table = $this->conf['prefix'].$table;
		
		return $this->query("TRUNCATE $table",false);
	}
	
	
	/** 
	 * 返回mysql数据库版本
	 * @see db_interface::version()
	 * 
	 */
	public function version(){
		
		return mysql_get_server_info();
		
	}
	
	
	/** 
	 * 执行SQL语句
	 * @see db_interface::query()
	 */
	public function query($sql,$fescape=true){

		try {
			if(!$this->link) $this->connect($this->conf['dbname']);
			
			$result = mysql_query(str_replace('-table-',$this->conf['prefix'],$sql),$this->link);
			
			if(!$result){
				$this -> errlog("SQL语句执行失败，请检查SQL语句是否正确！".$sql);
				return false;
			}
	
			return $fescape ? $this -> fieldEscape($result) : $result;
		 }catch (Exception $err) {
			//$this -> errlog("SQL语句执行失败，请检查SQL语句是否正确！<br><p>".$err->getMessage()."</p>");
			exit('出错2');
			
		}
	}
	
	/** 
	 * 插入新数据SQL语句
	 * @see db_interface::insert()
	 */
	public function insert($sql){

		try {
			if(!$this->link) $this->connect($this->conf['dbname']);
			
			$result = mysql_query(str_replace('-table-',$this->conf['prefix'],$sql),$this->link);
			
			if(!$result){
				$this -> errlog("SQL语句执行失败，请检查SQL语句是否正确！".$sql);
				return false;
			}
			return mysql_insert_id();
		 }catch (Exception $err) {
			exit('出错2');
			
		}
	}
	
	//读取数据库数据是还原转义数据
	public function fieldEscape($array)
	{
		if(!is_array($array)) return $array;
		
		foreach($array as $k=> $v){
			$array[$k] = stripslashes($v);;
		}
	
		return $array;
	}
	
	
	/** 
	 * 关闭数据库连接
	 * @see db_interface::close()
	 * 
	 */
	public function close(){
		
		if($this->link) mysql_close($this->link);
		
	}


	public function __destruct(){
		
		$this->close();
		
	}
	
}

?>