<?php 
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：分页类
 * +------------------------------------------------------------------------ 
**/  


class PageMydecms
{
	public  $mydeCmsCount;           //总记录数
	private $mydeCmsSize;            //每页记录数
	private $mydeCmsPage;            //当前页
	public  $mydeCmsPageCount;       //总页数
	private $mydeCmsPageUrl;         //页面url
	private $mydeCmsPageStartUrl;    //起始页
	private $mydeCmsPageStopUrl;     //结束页
	private $mydeCmsIndexPageUrl;    //首页(特殊用途，比如可以写目录)
	
	/**
	 * 构造函数
	 * @param $mydeCmsCount        => 记录数
	 * @param $mydeCmsSize         => 每页显示记录数
	 * @param $mydeCmsPage         => 当前页码
	 * @param $mydeCmsPageUrl      => 分页URL
	 * @param $mydeCmsIndexPageUrl => 默认首页
	 * @return string
	**/
	function __construct($mydeCmsCount=0, $mydeCmsSize=10,$mydeCmsPage=1,$mydeCmsPageUrl,$mydeCmsIndexPageUrl="")
	{	
		$this -> mydeCmsCount = $this -> glstr($mydeCmsCount);
		$this -> mydeCmsSize  = $this -> glstr($mydeCmsSize);
		$this -> mydeCmsPage  = $this -> glstr($mydeCmsPage);
		$this -> mydeCmsIndexPageUrl  = $mydeCmsIndexPageUrl;
		$this -> mydeCmsPageLimit = ($this -> mydeCmsPage * $this -> mydeCmsSize) - $this -> mydeCmsSize; 
		
		$this -> mydeCmsPageUrl       = $mydeCmsPageUrl;
		
		if($this -> mydeCmsPage < 1) $this -> mydeCmsPage =1;
		
		if($this -> mydeCmsCount < 0) $this -> mydeCmsPage =0;
		
		$this -> mydeCmsPageCount  = ceil($this -> mydeCmsCount/$this -> mydeCmsSize);
		
		if($this -> mydeCmsPageCount < 1) $this -> mydeCmsPageCount = 1;
		
		if($this -> mydeCmsPage > $this -> mydeCmsPageCount) $this -> mydeCmsPage = $this -> mydeCmsPageCount;
		
		$this -> mydeCmsPageStartUrl = $this -> mydeCmsPage - 2;
		
        $this -> mydeCmsPageStopUrl = $this -> mydeCmsPage + 2;
		
        if($this -> mydeCmsPageStartUrl < 1){
		
            $this -> mydeCmsPageStopUrl = $this -> mydeCmsPageStopUrl + (1 - $this -> mydeCmsPageStartUrl);
			
            $this -> mydeCmsPageStartUrl = 1;
        }
        
        if($this -> mydeCmsPageStopUrl > $this -> mydeCmsPageCount){
		
            $this -> mydeCmsPageStartUrl = $this -> mydeCmsPageStartUrl - ($this -> mydeCmsPageStopUrl - $this -> mydeCmsPageCount);
			
            $this -> mydeCmsPageStopUrl = $this -> mydeCmsPageCount;
			
            if($this -> mydeCmsPageStartUrl < 1) $this -> mydeCmsPageStartUrl = 1;
        }
	}
	
	
	/**
	 * 返回首页代码函数
	 * @return string
	**/
	private function mydeCmsPageHome()
	{
		if($this -> mydeCmsPage != 1){
			return "    <li class=\"page_a\"><a rel=\"nofollow\" href=\"".($this -> mydeCmsIndexPageUrl <>"" ? $this -> mydeCmsIndexPageUrl : $this -> mydeCmsPageReplace(1))."\"  title=\"首页\" >首页</a></li>\n";	
		}else{
			return "    <li>首页</li>\n";
		}
	}
	
	/**
	 * 返回上一页代码函数
	 * @return string
	**/
	private function mydeCmsPagePrev()
	{
		if($this -> mydeCmsPage != 1){
			return "    <li class=\"page_a\"><a rel=\"nofollow\" href=\"".(($this -> mydeCmsIndexPageUrl <>"" && $this->mydeCmsPage-1 ==1) ? $this -> mydeCmsIndexPageUrl : $this -> mydeCmsPageReplace($this->mydeCmsPage-1)) ."\"  title=\"上一页\" >上一页</a></li>\n";
		}else{
			return "    <li>上一页</li>\n";
		}
	}
	
	/**
	 * 返回下一页代码函数
	 * @return string
	**/
	private function mydeCmsPageNext()
	{
		if($this -> mydeCmsPage != $this -> mydeCmsPageCount){
			return "    <li class=\"page_a\"><a rel=\"nofollow\" href=\"".$this -> mydeCmsPageReplace($this->mydeCmsPage+1) ."\"  title=\"下一页\" >下一页</a></li>\n";
		}else{
			return "    <li>下一页</li>\n";
		}
	}
	
	/**
	 * 返回尾页代码函数
	 * @return string
	**/
	private function mydeCmsPageLast() //尾页
	{
		if($this -> mydeCmsPage != $this -> mydeCmsPageCount){
			return "    <li class=\"page_a\"><a rel=\"nofollow\" href=\"".$this -> mydeCmsPageReplace($this -> mydeCmsPageCount)."\"  title=\"尾页\" >尾页</a></li>\n";
		}else{
			return "    <li>尾页</li>\n";
		}
	}
	
	
	/**
	 * 输出显示分页函数
	 * @param $pageDivId        => 分页代码中div的ID
	 * @param $isPC             => 显示类型(true为电脑端，否则为手机端)
	 * @param $goto             => 是否提供输入框页码快速跳转(true允许，否则为不允许)
	 * @return string
	**/
	public function mydeCmsShow($pageDivId='page',$isPC=true,$goto=true) {
		$str  = "<div id=\"".$pageDivId."\" class=\"pages\">\n  <ul>\n  ";
		$str .= "  <li>总记录:<span>".$this -> mydeCmsCount."</span></li>\n";
		$str .= "    <li><span>".$this -> mydeCmsPage."</span>/<span>".$this -> mydeCmsPageCount."</span></li>\n";
		$str .= $this -> mydeCmsPageHome();
		$str .= $this -> mydeCmsPagePrev();
		
		if($isPC){
			for($page_for_i = $this -> mydeCmsPageStartUrl;$page_for_i <= $this -> mydeCmsPageStopUrl; $page_for_i++){
				if($this -> mydeCmsPage == $page_for_i){
					$str .= "    <li class=\"on\">".$page_for_i."</li>\n";
				}else{
					if($page_for_i==1 && $this -> mydeCmsIndexPageUrl <>""){
						$str .= "    <li class=\"page_a\"><a href=\"".$this -> mydeCmsIndexPageUrl."\" title=\"第".$page_for_i."页\">";
						$str .= $page_for_i . "</a></li>\n";
					}else{
						$str .= "    <li class=\"page_a\"><a href=\"".$this -> mydeCmsPageReplace($page_for_i)."\" title=\"第".$page_for_i."页\">";
						$str .= $page_for_i . "</a></li>\n";
					}
				}
			}
		}else{
			$str .= "    <li class=\"on\">".$this -> mydeCmsPage."</li>\n";
		}
		
		$str .= $this -> mydeCmsPageNext();
		$str .= $this -> mydeCmsPageLast();
		if($goto){
			$str .= "    <li class=\"pages_input\"><input type=\"text\" value=\"".$this -> mydeCmsPage."\"";
			$str .= " onkeydown=\"javascript: if(event.keyCode==13){ location='";
			$str .= $this -> mydeCmsPageReplace("'+this.value+'")."';return false;}\"";
			$str .= " title=\"输入您想要到达的页码\" /></li>\n";
		}
		$str .= "  </ul>\n  <div class=\"page_clear\"></div>\n</div>";
		return $str;
	}
	
	
	
	/**
	 * 将非数字字符过滤掉
	 * @param $idstr        => 要过滤的原字符串
	 * @return string
	**/
	private function glstr($idstr){
		return preg_replace("/[^0-9]/u","",$idstr);
	}
	
	/**
	 * 替换分页标签
	 * @param $page        => 页码
	 * @return string
	**/
	private function mydeCmsPageReplace($page)
	{
		return str_replace("{page}", $page, $this -> mydeCmsPageUrl);
	}
	
}
/*-------------------------实例--------------------------------*
$page = new PageClass(1000,5,$_GET['page'],'?page={page}');
$page = new PageClass(1000,5,$_GET['page'],'list-{page}.html');
$page -> mydeCmsPageWrite();
*/
?>