<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：上传文件类
 * +------------------------------------------------------------------------ 
**/  

class UpFileClass
{
	private $FileNameInfo = array();            //要上传的文件信息数组
	private $RestFileName = "";                 //上传后的文件重命名
	private $SaveDir = "";                      //文件保存目录
	public $FileUrl = "";                      //文件上传后的访问URL
	public $NewFileUrl = "";                   //文件上传后的访问URL
	public $msg = "";                              //操作返回文本提示
	public $fileType = false;                  //文件默认后缀
	private $isUpType = array(".gif",".jpg",".png",".bmp",".ico");//默认允许上传的文件的后缀
	
	//构造函数(上传的文件名称，返回文件上传后的URL，允许上传的后缀文件，保存文件目录，新命名文件)
	function __construct($FileNameInfo,$FileUrl,$isUpType = array(), $SaveDir="", $RestFileName="")
	{
 		if(is_array($FileNameInfo) && count($FileNameInfo)>0) $this -> FileNameInfo = $FileNameInfo;
		if($SaveDir != "") {
			$this -> SaveDir = $SaveDir;
			$this -> createFolder($this -> SaveDir);
		}
		if($RestFileName != "") $this -> RestFileName = $RestFileName;
		if(!is_array($isUpType) || count($isUpType)>0)  $this -> isUpType = $isUpType;
		$this -> FileUrl = $FileUrl;
 	}
	
	function Up()
	{
		if(count($this -> FileNameInfo)<1 || !isset($this -> FileNameInfo['name']) || !isset($this -> FileNameInfo['tmp_name']) || !isset($this -> FileNameInfo['type']))
		{
			$this -> msg = "上传出错";
			return false;
		}
		
		if($this -> FileNameInfo == "" || empty($this -> FileNameInfo['name'])){
			$this -> msg = "请选择要上传的文件";
			return false;
		}
		
		$this -> fileType = $this -> GetFileType($this -> FileNameInfo['type']);
		if(!$this -> fileType){
			$this -> msg = "没有检测出上传的文件后缀";
			return false;
		}
		
		if(!in_array($this -> fileType,$this -> isUpType)){
			$this -> msg = "上传的文件后缀不允许上传";
			return false;
		}
		
		$extend =explode("." , $this -> FileNameInfo['name']);  
		if(count($extend)<1)
		{
			$this -> msg = "上传的文件后缀不允许上传";
			return false;
		}
		$va= count($extend) - 1;
		if(!in_array(".".$extend[$va],$this -> isUpType)){
			$this -> msg = "上传的文件后缀不允许上传";
			return false;
		}
		
		if(!$_FILES)
		{
			$this -> msg = "请选择要上传的文件";
			return false;
		}
		
		$newfile = $this -> RestFileName == "" ? $this -> FileNameInfo['name']:$this -> RestFileName. $this -> fileType;

		if(!move_uploaded_file($this -> FileNameInfo['tmp_name'],$this -> SaveDir.$newfile))
		{
			if(!file_exists($this -> FileNameInfo['tmp_name']) || !copy($this -> FileNameInfo['tmp_name'],$this -> SaveDir.$newfile))
			{
				$this -> msg = "文件上传失败";
				return false;
			}
		}
		$this -> NewFileUrl = $this -> FileUrl.$newfile;
		$this -> msg = "上传成功！";
		return true;
	}
	
	//判断文件类型，返回扩展名
   function GetFileType($fileName){ 
		switch($fileName){	
			case "image/gif": $ok=".gif";break;
			case "image/pjpeg": $ok=".jpg";break;
			case "image/jpeg": $ok=".jpg";break;
			case "image/jpg": $ok=".jpg";break;
			case "image/png": $ok=".png";break;
			case "image/x-png": $ok=".png";break;
			case "image/bmp": $ok=".bmp";break;
			case "image/x-icon": $ok=".ico";break;
			case "application/zip": $ok=".zip";break;
			case "video/avi": $ok=".avi";break;
			case "application/vnd.rn-realmedia-vbr": $ok=".rmvb";break;
			case "audio/mpeg": $ok=".mp3";break;
			case "audio/wav": $ok=".wav";break;
			case "text/plain": $ok=".txt";break;
			case "application/msword": $ok=".doc";break;
			case "application/vnd.ms-excel": $ok=".xls";break;
			case "application/vnd.ms-powerpoint": $ok=".ppt";break;
			case "application/msaccess": $ok=".mdb";break;
			case "text/plain": $ok=".log";break;
			case "text/html": $ok=".html";break;
			case "text/html": $ok=".htm";break;
			case "application/x-javascript": $ok=".js";break;
			case "text/xml": $ok=".xml";break;
			default: $ok=false;break;
		}
	return $ok;
    }
	
	//创建目录函数
	function createFolder($path){
	if(!file_exists($path)){
		$this -> createFolder(dirname($path));
		mkdir($path,0777);
	}
}
/*
实例
$upfile = new UpFileClass($_FILES["upload_file"],"http://localhost/mydecms2.0/",array(".gif",".jpg",".png",".bmp",".ico"),"./up-file/");
$upfile -> Up();
echo("[提示结果]". $upfile -> msg . $upfile -> NewFileUrl ."[/提示结果]");

*/
}
?>