<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：图片水印类
 * +------------------------------------------------------------------------ 
**/ 

class mydecmsWater
{
	private $config;//水印配置数组
	
	public function __construct($config){
		$this -> config = $config;
		if(!isset($this -> config['img'])) $this -> config['img'] = "../upfile/images/water.png";//水印图片地址
		if(!isset($this -> config['positon'])) $this -> config['positon'] = 5;//水印位置(1:顶部居左, 2:顶部居右, 3:居中, 4:底部局左, 5:底部居右)
		if(!isset($this -> config['alpha'])) $this -> config['alpha'] = 100;//水印透明度
		if(!isset($this -> config['top'])) $this -> config['top'] = 2;//水印距离顶边
		if(!isset($this -> config['right'])) $this -> config['right'] = 2;//水印距离右边
		if(!isset($this -> config['bottom'])) $this -> config['bottom'] = 2;//水印距离底边
		if(!isset($this -> config['left'])) $this -> config['left'] = 2;//水印距离左边
	}
	
	/**
	 * 图片加水印（适用于png/jpg/gif格式）
	 * 
	 * @param $srcImg 原图片
	 * @param $positon 水印位置 
	 * @param $savepath 保存路径
	 * @param $savename 保存名字
	 * 
	 * @return 成功 -- 加水印后的新图片地址
	 *          失败 -- -1:原文件不存在, -2:水印图片不存在, -3:原文件图像对象建立失败
	 *          -4:水印文件图像对象建立失败 -5:加水印后的新图片保存失败
	 */
	function imgWater($srcImg, $savepath=NULL, $savename=NULL)
	{
		$temp = pathinfo($srcImg);
		$name = $temp['basename'];
		$path = $temp['dirname'];
		$exte = $temp['extension'];
		$savename = $savename ? $savename : $name;
		$savepath = $savepath ? $savepath : $path;
		$savefile = $savepath .'/'. $savename;
		$srcinfo = @getimagesize($srcImg);
		if (!$srcinfo) {
			return -1; //原文件不存在
		}
		$waterinfo = @getimagesize($this -> config['img']);
		if (!$waterinfo) {
			return -2; //水印图片不存在
		}
		$srcImgObj = $this -> image_create_from_ext($srcImg);
		if (!$srcImgObj) {
			return -3; //原文件图像对象建立失败
		}
		$waterImgObj = $this -> image_create_from_ext($this -> config['img']);
		if (!$waterImgObj) {
			return -4; //水印文件图像对象建立失败
		}
		if($waterinfo[0]*2>$srcinfo[0] || $waterinfo[1]*2>$srcinfo[1]){
			return -5;//图片小于水印图片尺寸大小
		}
		switch ($this -> config['positon']) {
		//1顶部居左
		case 1: $x= $this -> config['left']; $y = $this -> config['top']; break;
		//2顶部居右
		case 2: $x = $srcinfo[0]-$waterinfo[0]-$this -> config['left']; $y = $this -> config['top']; break;
		//3居中
		case 3: $x = ($srcinfo[0]-$waterinfo[0])/2; $y = ($srcinfo[1]-$waterinfo[1])/2; break;
		//4底部居左
		case 4: $x = $this -> config['left'] ; $y = $srcinfo[1]-$waterinfo[1]-$this -> config['bottom']; break;
		//5底部居右
		case 5: $x = $srcinfo[0]-$waterinfo[0]-$this -> config['right']; $y = $srcinfo[1]-$waterinfo[1]-$this -> config['bottom']; break;
		default: $x=$y=0;
		}
		imagecopymerge($srcImgObj, $waterImgObj, $x, $y, 0, 0, $waterinfo[0], $waterinfo[1], $this -> config['alpha']);
		switch ($srcinfo[2]) {
		case 1: imagegif($srcImgObj, $savefile); break;
		case 2: imagejpeg($srcImgObj, $savefile); break;
		case 3: imagepng($srcImgObj, $savefile); break;
		default: return -5; //保存失败
		}
		imagedestroy($srcImgObj);
		imagedestroy($waterImgObj);
		return $savefile;
	}
	
	
	function image_create_from_ext($imgfile)
	{
		$info = getimagesize($imgfile);
		$im = null;
		switch ($info[2]) {
		case 1: $im=imagecreatefromgif($imgfile); break;
		case 2: $im=imagecreatefromjpeg($imgfile); break;
		case 3: $im=imagecreatefrompng($imgfile); break;
		}
		return $im;
	}
}
/*
 * 使用实例
 * 
$img = new mydecmsWater();
echo $img -> imgWater("dacu.png");
*/
?>