<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：无限分类
 * +------------------------------------------------------------------------ 
**/  

class mydecmsWuXianClass{
	
	public $newArrData; //全新的多维数组
	
	/**
	 * 构造方法
	 * @param $data 必须为数组类型，并且要是二维数组，第二维数组的键必须有id、sort、cid这三个键
	 * 实例如下：
	 * $data = array(
	 * 		array("id"=>1,"name"=>"女装","sort"=>5,cid=>0[,"键"=>"值"]),
	 * 		array("id"=>2,"name"=>"大码女装","sort"=>5,cid=>1[,"键"=>"值"]),
	 * 		array("id"=>3,"name"=>"男装","sort"=>5,cid=>1[,"键"=>"值"]),
	 * );
	 */
	public function __construct($data){
		if(!is_array($data)){
			//mydecmsfun::errMsg("无限分类传入的参数不是二维数组，所以无限分类无法正常运算！");
		}
		if(!isset($data[0]) || !isset($data[0]['id']) || !isset($data[0]['sort']) || !isset($data[0]['cid'])){
			//mydecmsfun::errMsg("无限分类参数传入的二维数组中第二维数组的键必须包含不id、sort、cid这三个键，否则将无法运算！");
		}
		
		$this->foreachList($data);
		
	}
	
	/**
	 * 遍历传入的二级数组并处理
	 * @param unknown_type $data
	 */
	public function foreachList($data){
		$this->newArrData = array();
		foreach ($data as $k => $v){
			$keys = array_keys($v);
			if(count($keys)>0){
				foreach($keys as $vv){
					if($vv=="cid"){
						$this->newArrData[$v['cid']]["ids"][] = $v['id'];
					}
					$this->newArrData[$v['id']][$vv] = $v[$vv];
				}
			}	
		}
	}
	
	/**
	 * 给子分类排升序
	 * @param unknown_type $data
	 */
	public function restSort($data){
		if(!is_array($data)) return array($data);
		$arr = array();
		foreach ($data as $v){
			if(isset($this->newArrData[$v]['sort'])){
				$arr[$this->newArrData[$v]['id']] = $this->newArrData[$v]['sort'];
			}
		}
		if(count($arr)>1) asort($arr);
		return $arr;
	}
	
	/**
	 * 返回一个条记录
	 * @param $id ID
	 */
	public function getRead($id){
		return isset($this->newArrData[$id]) ? $this->newArrData[$id] : false ;
	}
	
	/**
	 * 返回一个无限分类的Select表单控件
	 * @param $startId 开始分类ID
	 * @param $valueId   默认选中的ID
	 * @param $selectId select控件ID
	 */
	public function getSelectArr($cid=0,$startId =0,$text_index = "&nbsp;"){
		if($cid===0 || $cid==="0"){
			$arr = array();
		}else{
			$arr = array();
			$newArr = array("value"=>$cid,"text_index"=>"","name"=>"");
			if(isset($this -> newArrData[$cid]['name'])){
				$newArr['name'] = $this -> newArrData[$cid]['name'];
			}else{
				$newArr['name'] = "未知分类";
			}
			for($i=0;$i<$startId;$i++){
				$newArr['text_index'] .= $text_index;
			}
			$arr[] = $newArr;
		}
		
		if(isset($this->newArrData[$cid]['ids'])){
			$startId++;
			$ids = $this->restSort($this->newArrData[$cid]['ids']);
			foreach ($ids as $k => $v){
				$child= $this->getSelectArr($k,$startId);
				if(is_array(current($child))){
					foreach ($child as $vv){
						$arr[] = $vv;
					}
				}else{
					$arr[] = $child;
				}
			}
		}
		return $arr;
	}
	
	/**
	 * 一直往上返回父分类数据
	 * @param unknown_type $id
	 * @return unknown|boolean
	 */
	public function getParentList($id){
		$arr = $this->getParentId($id);
		$newArr = array();
		if(is_array($arr) && count($arr)>0){
			foreach ($arr as $k){
				if(isset($this->newArrData[$k])){
					$newArr[] = $this->newArrData[$k];
				}
			}
			return $newArr;
		}else{
			return array();
		}
	}
	
	
	/**
	 * 一直往上找父分类
	 * @param unknown_type $id
	 */
	public function getParentId($id){
		$arr = array();
		if(isset($this->newArrData[$id]['cid'])){
			$arr = $this->getParentId($this->newArrData[$id]['cid']);
		}
		
		array_push($arr,$id);
		
		return $arr;
	}
	
	/**
	 * 一直往下返回子分类数据
	 * @param unknown_type $id
	 * @return unknown|boolean
	 */
	public function getChildList($id){
		$arr = $this->getChildId($id);
		$newArr = array();
		if(is_array($arr) && count($arr)>0){
			foreach ($arr as $k){
				if(isset($this->newArrData[$k])){
					$newArr[] = $this->newArrData[$k];
				}
			}
			return $newArr;
		}else{
			return false;
		}
	}
	
	/**
	 * 一直往下找子分类
	 * @param unknown_type $id
	 * @return multitype:
	 */
	public function getChildId($id)
	{
		$arr = array($id);
		if(isset($this->newArrData[$id]['ids'])){
			foreach($this->newArrData[$id]['ids'] as $v){
				$newarr = $this->getChildId($v);
				$arr = array_merge($arr,$newarr);
			}
		}
		return $arr;
	} 
	
}

?>