<?php
/**
 * PHP SDK for weibo.com (using OAuth2)
 * 
 * @author Elmer Zhang <freeboy6716@gmail.com>
 */

/**
 * @ignore
 */
class OAuthException extends Exception {
	// pass
}


/**
 * ΢ OAuth ֤(OAuth2)
 *
 * Ȩ˵Ҳο΢ƽ̨ĵ{@link http://open.weibo.com/wiki/Oauth2}
 *
 * @package sae
 * @author Elmer Zhang
 * @version 1.0
 */
class SaeTOAuthV2 {
	/**
	 * @ignore
	 */
	public $client_id;
	/**
	 * @ignore
	 */
	public $client_secret;
	/**
	 * @ignore
	 */
	public $access_token;
	/**
	 * @ignore
	 */
	public $refresh_token;
	/**
	 * Contains the last HTTP status code returned. 
	 *
	 * @ignore
	 */
	public $http_code;
	/**
	 * Contains the last API call.
	 *
	 * @ignore
	 */
	public $url;
	/**
	 * Set up the API root URL.
	 *
	 * @ignore
	 */
	public $host = "https://api.weibo.com/2/";
	/**
	 * Set timeout default.
	 *
	 * @ignore
	 */
	public $timeout = 30;
	/**
	 * Set connect timeout.
	 *
	 * @ignore
	 */
	public $connecttimeout = 30;
	/**
	 * Verify SSL Cert.
	 *
	 * @ignore
	 */
	public $ssl_verifypeer = FALSE;
	/**
	 * Respons format.
	 *
	 * @ignore
	 */
	public $format = 'json';
	/**
	 * Decode returned json data.
	 *
	 * @ignore
	 */
	public $decode_json = TRUE;
	/**
	 * Contains the last HTTP headers returned.
	 *
	 * @ignore
	 */
	public $http_info;
	/**
	 * Set the useragnet.
	 *
	 * @ignore
	 */
	public $useragent = 'Sae T OAuth2 v0.1';

	/**
	 * print the debug info
	 *
	 * @ignore
	 */
	public $debug = FALSE;

	/**
	 * boundary of multipart
	 * @ignore
	 */
	public static $boundary = '';

	/**
	 * Set API URLS
	 */
	/**
	 * @ignore
	 */
	function accessTokenURL()  { return 'https://api.weibo.com/oauth2/access_token'; }
	/**
	 * @ignore
	 */
	function authorizeURL()    { return 'https://api.weibo.com/oauth2/authorize'; }

	/**
	 * construct WeiboOAuth object
	 */
	function __construct($client_id, $client_secret, $access_token = NULL, $refresh_token = NULL) {
		$this->client_id = $client_id;
		$this->client_secret = $client_secret;
		$this->access_token = $access_token;
		$this->refresh_token = $refresh_token;
	}

	/**
	 * authorizeӿ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/Oauth2/authorize Oauth2/authorize}
	 *
	 * @param string $url ȨĻصַ,վӦصַһ,վӦҪдcanvas pageĵַ
	 * @param string $response_type ֵֵ֧ code token ĬֵΪcode
	 * @param string $state ڱͻص״̬ڻصʱ,Query Parameterлشò
	 * @param string $display Ȩҳ ѡΧ: 
	 *  - default		ĬȨҳ		
	 *  - mobile		֧html5ֻ		
	 *  - popup			Ȩҳ		
	 *  - wap1.2		wap1.2ҳ		
	 *  - wap2.0		wap2.0ҳ		
	 *  - js			js-sdk ר ȨҳǵؽΪjs-sdkص		
	 *  - apponweibo	վӦר,վӦòdisplay,response_typeΪtokenʱ,Ĭʹødisplay.Ȩ󲻻᷵access_tokenֻjsˢվӦø
	 * @return array
	 */
	function getAuthorizeURL( $url, $response_type = 'code', $state = NULL, $display = NULL ) {
		$params = array();
		$params['client_id'] = $this->client_id;
		$params['redirect_uri'] = $url;
		$params['response_type'] = $response_type;
		$params['state'] = $state;
		$params['display'] = $display;
		return $this->authorizeURL() . "?" . http_build_query($params);
	}

	/**
	 * access_tokenӿ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/OAuth2/access_token OAuth2/access_token}
	 *
	 * @param string $type ,Ϊ:code, password, token
	 * @param array $keys 
	 *  - $typeΪcodeʱ array('code'=>..., 'redirect_uri'=>...)
	 *  - $typeΪpasswordʱ array('username'=>..., 'password'=>...)
	 *  - $typeΪtokenʱ array('refresh_token'=>...)
	 * @return array
	 */
	function getAccessToken( $type = 'code', $keys ) {
		$params = array();
		$params['client_id'] = $this->client_id;
		$params['client_secret'] = $this->client_secret;
		if ( $type === 'token' ) {
			$params['grant_type'] = 'refresh_token';
			$params['refresh_token'] = $keys['refresh_token'];
		} elseif ( $type === 'code' ) {
			$params['grant_type'] = 'authorization_code';
			$params['code'] = $keys['code'];
			$params['redirect_uri'] = $keys['redirect_uri'];
		} elseif ( $type === 'password' ) {
			$params['grant_type'] = 'password';
			$params['username'] = $keys['username'];
			$params['password'] = $keys['password'];
		} else {
			throw new OAuthException("wrong auth type");
		}

		$response = $this->oAuthRequest($this->accessTokenURL(), 'POST', $params);
		$token = json_decode($response, true);
		if ( is_array($token) && !isset($token['error']) ) {
			$this->access_token = $token['access_token'];
			//$this->refresh_token = $token['refresh_token'];
		} else {
			throw new OAuthException("get access token failed." . $token['error']);
		}
		return $token;
	}

	/**
	 *  signed_request
	 *
	 * @param string $signed_request ӦÿڼiframeʱͨCanvas URL postĲsigned_request
	 *
	 * @return array
	 */
	function parseSignedRequest($signed_request) {
		list($encoded_sig, $payload) = explode('.', $signed_request, 2); 
		$sig = self::base64decode($encoded_sig) ;
		$data = json_decode(self::base64decode($payload), true);
		if (strtoupper($data['algorithm']) !== 'HMAC-SHA256') return '-1';
		$expected_sig = hash_hmac('sha256', $payload, $this->client_secret, true);
		return ($sig !== $expected_sig)? '-2':$data;
	}

	/**
	 * @ignore
	 */
	function base64decode($str) {
		return base64_decode(strtr($str.str_repeat('=', (4 - strlen($str) % 4)), '-_', '+/'));
	}

	/**
	 * ȡjssdkȨϢںjssdkͬ¼
	 *
	 * @return array ɹarray('access_token'=>'value', 'refresh_token'=>'value'); ʧܷfalse
	 */
	function getTokenFromJSSDK() {
		$key = "weibojs_" . $this->client_id;
		if ( isset($_COOKIE[$key]) && $cookie = $_COOKIE[$key] ) {
			parse_str($cookie, $token);
			if ( isset($token['access_token']) && isset($token['refresh_token']) ) {
				$this->access_token = $token['access_token'];
				$this->refresh_token = $token['refresh_token'];
				return $token;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	/**
	 * жȡaccess_tokenrefresh_token
	 * ڴSessionCookieжȡtokenͨSession/CookieǷtokenжϵ¼״̬
	 *
	 * @param array $arr access_tokensecret_token
	 * @return array ɹarray('access_token'=>'value', 'refresh_token'=>'value'); ʧܷfalse
	 */
	function getTokenFromArray( $arr ) {
		if (isset($arr['access_token']) && $arr['access_token']) {
			$token = array();
			$this->access_token = $token['access_token'] = $arr['access_token'];
			if (isset($arr['refresh_token']) && $arr['refresh_token']) {
				$this->refresh_token = $token['refresh_token'] = $arr['refresh_token'];
			}

			return $token;
		} else {
			return false;
		}
	}

	/**
	 * GET wrappwer for oAuthRequest.
	 *
	 * @return mixed
	 */
	function get($url, $parameters = array()) {
		$response = $this->oAuthRequest($url, 'GET', $parameters);
		if ($this->format === 'json' && $this->decode_json) {
			return json_decode($response, true);
		}
		return $response;
	}

	/**
	 * POST wreapper for oAuthRequest.
	 *
	 * @return mixed
	 */
	function post($url, $parameters = array(), $multi = false) {
		$response = $this->oAuthRequest($url, 'POST', $parameters, $multi );
		if ($this->format === 'json' && $this->decode_json) {
			return json_decode($response, true);
		}
		return $response;
	}

	/**
	 * DELTE wrapper for oAuthReqeust.
	 *
	 * @return mixed
	 */
	function delete($url, $parameters = array()) {
		$response = $this->oAuthRequest($url, 'DELETE', $parameters);
		if ($this->format === 'json' && $this->decode_json) {
			return json_decode($response, true);
		}
		return $response;
	}

	/**
	 * Format and sign an OAuth / API request
	 *
	 * @return string
	 * @ignore
	 */
	function oAuthRequest($url, $method, $parameters, $multi = false) {

		if (strrpos($url, 'http://') !== 0 && strrpos($url, 'https://') !== 0) {
			$url = "{$this->host}{$url}.{$this->format}";
	}

	switch ($method) {
		case 'GET':
			$url = $url . '?' . http_build_query($parameters);
			return $this->http($url, 'GET');
		default:
			$headers = array();
			if (!$multi && (is_array($parameters) || is_object($parameters)) ) {
				$body = http_build_query($parameters);
			} else {
				$body = self::build_http_query_multi($parameters);
				$headers[] = "Content-Type: multipart/form-data; boundary=" . self::$boundary;
			}
			return $this->http($url, $method, $body, $headers);
	}
	}

	/**
	 * Make an HTTP request
	 *
	 * @return string API results
	 * @ignore
	 */
	function http($url, $method, $postfields = NULL, $headers = array()) {
		$this->http_info = array();
		$ci = curl_init();
		/* Curl settings */
		curl_setopt($ci, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
		curl_setopt($ci, CURLOPT_USERAGENT, $this->useragent);
		curl_setopt($ci, CURLOPT_CONNECTTIMEOUT, $this->connecttimeout);
		curl_setopt($ci, CURLOPT_TIMEOUT, $this->timeout);
		curl_setopt($ci, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ci, CURLOPT_ENCODING, "");
		curl_setopt($ci, CURLOPT_SSL_VERIFYPEER, $this->ssl_verifypeer);
		curl_setopt($ci, CURLOPT_SSL_VERIFYHOST, 1);
		curl_setopt($ci, CURLOPT_HEADERFUNCTION, array($this, 'getHeader'));
		curl_setopt($ci, CURLOPT_HEADER, FALSE);

		switch ($method) {
			case 'POST':
				curl_setopt($ci, CURLOPT_POST, TRUE);
				if (!empty($postfields)) {
					curl_setopt($ci, CURLOPT_POSTFIELDS, $postfields);
					$this->postdata = $postfields;
				}
				break;
			case 'DELETE':
				curl_setopt($ci, CURLOPT_CUSTOMREQUEST, 'DELETE');
				if (!empty($postfields)) {
					$url = "{$url}?{$postfields}";
				}
		}

		if ( isset($this->access_token) && $this->access_token )
			$headers[] = "Authorization: OAuth2 ".$this->access_token;

		if ( !empty($this->remote_ip) ) {
			if ( defined('SAE_ACCESSKEY') ) {
				$headers[] = "SaeRemoteIP: " . $this->remote_ip;
			} else {
				$headers[] = "API-RemoteIP: " . $this->remote_ip;
			}
		} else {
			if ( !defined('SAE_ACCESSKEY') ) {
				$headers[] = "API-RemoteIP: " . $_SERVER['REMOTE_ADDR'];
			}
		}
		curl_setopt($ci, CURLOPT_URL, $url );
		curl_setopt($ci, CURLOPT_HTTPHEADER, $headers );
		curl_setopt($ci, CURLINFO_HEADER_OUT, TRUE );

		$response = curl_exec($ci);
		$this->http_code = curl_getinfo($ci, CURLINFO_HTTP_CODE);
		$this->http_info = array_merge($this->http_info, curl_getinfo($ci));
		$this->url = $url;

		if ($this->debug) {
			echo "=====post data======\r\n";
			var_dump($postfields);

			echo "=====headers======\r\n";
			print_r($headers);

			echo '=====request info====='."\r\n";
			print_r( curl_getinfo($ci) );

			echo '=====response====='."\r\n";
			print_r( $response );
		}
		curl_close ($ci);
		return $response;
	}

	/**
	 * Get the header info to store.
	 *
	 * @return int
	 * @ignore
	 */
	function getHeader($ch, $header) {
		$i = strpos($header, ':');
		if (!empty($i)) {
			$key = str_replace('-', '_', strtolower(substr($header, 0, $i)));
			$value = trim(substr($header, $i + 2));
			$this->http_header[$key] = $value;
		}
		return strlen($header);
	}

	/**
	 * @ignore
	 */
	public static function build_http_query_multi($params) {
		if (!$params) return '';

		uksort($params, 'strcmp');

		$pairs = array();

		self::$boundary = $boundary = uniqid('------------------');
		$MPboundary = '--'.$boundary;
		$endMPboundary = $MPboundary. '--';
		$multipartbody = '';

		foreach ($params as $parameter => $value) {

			if( in_array($parameter, array('pic', 'image')) && $value{0} == '@' ) {
				$url = ltrim( $value, '@' );
				$content = file_get_contents( $url );
				$array = explode( '?', basename( $url ) );
				$filename = $array[0];

				$multipartbody .= $MPboundary . "\r\n";
				$multipartbody .= 'Content-Disposition: form-data; name="' . $parameter . '"; filename="' . $filename . '"'. "\r\n";
				$multipartbody .= "Content-Type: image/unknown\r\n\r\n";
				$multipartbody .= $content. "\r\n";
			} else {
				$multipartbody .= $MPboundary . "\r\n";
				$multipartbody .= 'content-disposition: form-data; name="' . $parameter . "\"\r\n\r\n";
				$multipartbody .= $value."\r\n";
			}

		}

		$multipartbody .= $endMPboundary;
		return $multipartbody;
	}
}


/**
 * ΢V2
 *
 * ʹǰҪֹsaetv2.ex.class.php <br />
 *
 * @package sae
 * @author Easy Chen, Elmer Zhang,Lazypeople
 * @version 1.0
 */
class SaeTClientV2
{
	/**
	 * 캯
	 * 
	 * @access public
	 * @param mixed $akey ΢ƽ̨ӦAPP KEY
	 * @param mixed $skey ΢ƽ̨ӦAPP SECRET
	 * @param mixed $access_token OAuth֤صtoken
	 * @param mixed $refresh_token OAuth֤صtoken secret
	 * @return void
	 */
	function __construct( $akey, $skey, $access_token, $refresh_token = NULL)
	{
		$this->oauth = new SaeTOAuthV2( $akey, $skey, $access_token, $refresh_token );
	}

	/**
	 * Ϣ
	 *
	 * ϢSDKὫÿ΢API͵POST DataHeadersԼϢ
	 *
	 * @access public
	 * @param bool $enable ǷϢ
	 * @return void
	 */
	function set_debug( $enable )
	{
		$this->oauth->debug = $enable;
	}

	/**
	 * ûIP
	 *
	 * SDKĬϽͨ$_SERVER['REMOTE_ADDR']ȡûIP΢APIʱûIPӵRequest HeaderСĳЩ$_SERVER['REMOTE_ADDR']ȡIPûIPһ̶IPʹSAECronTaskQueueʱʱпܻɸù̶IPﵽ΢APIƵ޶APIʧܡʱʹñûIPԱ⡣
	 *
	 * @access public
	 * @param string $ip ûIP
	 * @return bool IPΪǷIPַʱfalse򷵻true
	 */
	function set_remote_ip( $ip )
	{
		if ( ip2long($ip) !== false ) {
			$this->oauth->remote_ip = $ip;
			return true;
		} else {
			return false;
		}
	}

	/**
	 * ȡµĹ΢Ϣ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/public_timeline statuses/public_timeline}
	 *
	 * @access public
	 * @param int $count ҳصļ¼ĬΪ50
	 * @param int $page ؽҳ룬ĬΪ1
	 * @param int $base_app ǷֻȡǰӦõݡ0Ϊݣ1ΪǣǰӦãĬΪ0
	 * @return array
	 */
	function public_timeline( $page = 1, $count = 50, $base_app = 0 )
	{
		$params = array();
		$params['count'] = intval($count);
		$params['page'] = intval($page);
		$params['base_app'] = intval($base_app);
		return $this->oauth->get('statuses/public_timeline', $params);//ǽӿڵbugܲȫ
	}

	/**
	 * ȡǰ¼ûעû΢Ϣ
	 *
	 * ȡǰ¼ûעû΢Ϣû¼ http://weibo.com ڡҵҳпͬͬfriends_timeline()
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/home_timeline statuses/home_timeline}
	 * 
	 * @access public
	 * @param int $page ָؽҳ롣ݵǰ¼ûעûЩעû΢ҳܲ鿴ܼ¼ͬͨܲ鿴1000ҡĬֵ1ѡ
	 * @param int $count ÿηصļ¼ȱʡֵ50ֵ200ѡ
	 * @param int $since_id ָ˲ֻIDsince_id΢Ϣsince_idʱ΢Ϣѡ
	 * @param int $max_id ָ˲򷵻IDСڻmax_id΢Ϣѡ
	 * @param int $base_app ǷֻȡǰӦõݡ0Ϊݣ1ΪǣǰӦãĬΪ0
	 * @param int $feature ID0ȫ1ԭ2ͼƬ3Ƶ4֣ĬΪ0
	 * @return array
	 */
	function home_timeline( $page = 1, $count = 50, $since_id = 0, $max_id = 0, $base_app = 0, $feature = 0 )
	{
		$params = array();
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}
		$params['count'] = intval($count);
		$params['page'] = intval($page);
		$params['base_app'] = intval($base_app);
		$params['feature'] = intval($feature);

		return $this->oauth->get('statuses/home_timeline', $params);
	}

	/**
	 * ȡǰ¼ûעû΢Ϣ
	 *
	 * ȡǰ¼ûעû΢Ϣû¼ http://weibo.com ڡҵҳпͬͬhome_timeline()
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/friends_timeline statuses/friends_timeline}
	 * 
	 * @access public
	 * @param int $page ָؽҳ롣ݵǰ¼ûעûЩעû΢ҳܲ鿴ܼ¼ͬͨܲ鿴1000ҡĬֵ1ѡ
	 * @param int $count ÿηصļ¼ȱʡֵ50ֵ200ѡ
	 * @param int $since_id ָ˲ֻIDsince_id΢Ϣsince_idʱ΢Ϣѡ
	 * @param int $max_id ָ˲򷵻IDСڻmax_id΢Ϣѡ
	 * @param int $base_app ǷڵǰӦȡݡ1ΪƱӦ΢0ΪơĬΪ0ѡ
	 * @param int $feature ΢ͣ0ȫ1ԭ2ͼƬ3Ƶ4. ָ͵΢ϢݡתΪΪ0ѡ
	 * @return array
	 */
	function friends_timeline( $page = 1, $count = 50, $since_id = 0, $max_id = 0, $base_app = 0, $feature = 0 )
	{
		return $this->home_timeline( $since_id, $max_id, $count, $page, $base_app, $feature);
	}

	/**
	 * ȡû΢Ϣб
	 *
	 * ûķnϢû΢ҳ淵һµġ˽ӿҲû·΢
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/user_timeline statuses/user_timeline}
	 * 
	 * @access public
	 * @param int $page ҳ
	 * @param int $count ÿηص¼෵200Ĭ50
	 * @param mixed $uid ָûUID΢ǳ
	 * @param int $since_id ָ˲ֻIDsince_id΢Ϣsince_idʱ΢Ϣѡ
	 * @param int $max_id ָ˲򷵻IDСڻmax_idᵽǰ¼û΢Ϣѡ
	 * @param int $base_app ǷڵǰӦȡݡ1ΪƱӦ΢0ΪơĬΪ0
	 * @param int $feature ID0ȫ1ԭ2ͼƬ3Ƶ4֣ĬΪ0
	 * @param int $trim_user ֵuserϢأ0userϢ1userֶνuidĬΪ0
	 * @return array
	 */
	function user_timeline_by_id( $uid = NULL , $page = 1 , $count = 50 , $since_id = 0, $max_id = 0, $feature = 0, $trim_user = 0, $base_app = 0)
	{
		$params = array();
		$params['uid']=$uid;
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}
		$params['base_app'] = intval($base_app);
		$params['feature'] = intval($feature);
		$params['count'] = intval($count);
		$params['page'] = intval($page);
		$params['trim_user'] = intval($trim_user);

		return $this->oauth->get( 'statuses/user_timeline', $params );
	}
	
	
	/**
	 * ȡû΢Ϣб
	 *
	 * ûķnϢû΢ҳ淵һµġ˽ӿҲû·΢
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/user_timeline statuses/user_timeline}
	 * 
	 * @access public
	 * @param string $screen_name ΢ǳƣҪûUID΢ǳƣһʱ򣬽ʹøò 
	 * @param int $page ҳ
	 * @param int $count ÿηص¼෵200Ĭ50
	 * @param int $since_id ָ˲ֻIDsince_id΢Ϣsince_idʱ΢Ϣѡ
	 * @param int $max_id ָ˲򷵻IDСڻmax_idᵽǰ¼û΢Ϣѡ
	 * @param int $feature ID0ȫ1ԭ2ͼƬ3Ƶ4֣ĬΪ0
	 * @param int $trim_user ֵuserϢأ0userϢ1userֶνuidĬΪ0
	 * @param int $base_app ǷڵǰӦȡݡ1ΪƱӦ΢0ΪơĬΪ0
	 * @return array
	 */
	function user_timeline_by_name( $screen_name = NULL , $page = 1 , $count = 50 , $since_id = 0, $max_id = 0, $feature = 0, $trim_user = 0, $base_app = 0 )
	{
		$params = array();
		$params['screen_name'] = $screen_name;
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}
		$params['base_app'] = intval($base_app);
		$params['feature'] = intval($feature);
		$params['count'] = intval($count);
		$params['page'] = intval($page);
		$params['trim_user'] = intval($trim_user);

		return $this->oauth->get( 'statuses/user_timeline', $params );
	}
	
	
	
	/**
	 * ȡָһûtimeline
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/timeline_batch statuses/timeline_batch}
	 *
	 * @param string $screen_name  ҪѯûǳƣðǶŷָһ20
	 * @param int    $count        ҳصļ¼ĬΪ50
	 * @param int    $page  ؽҳ룬ĬΪ1 
	 * @param int    $base_app  ǷֻȡǰӦõݡ0Ϊݣ1ΪǣǰӦãĬΪ0
	 * @param int    $feature   ID0ȫ1ԭ2ͼƬ3Ƶ4֣ĬΪ0
	 * @return array
	 */
	function timeline_batch_by_name( $screen_name, $page = 1, $count = 50, $feature = 0, $base_app = 0)
	{
		$params = array();
		if (is_array($screen_name) && !empty($screen_name)) {
			$params['screen_name'] = join(',', $screen_name);
		} else {
			$params['screen_name'] = $screen_name;
		}
		$params['count'] = intval($count);
		$params['page'] = intval($page); 
		$params['base_app'] = intval($base_app);
		$params['feature'] = intval($feature);
		return $this->oauth->get('statuses/timeline_batch', $params);
	}

	/**
	 * ȡָһûtimeline
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/timeline_batch statuses/timeline_batch}
	 *
	 * @param string $uids  ҪѯûIDðǶŷָһ20
	 * @param int    $count        ҳصļ¼ĬΪ50
	 * @param int    $page  ؽҳ룬ĬΪ1 
	 * @param int    $base_app  ǷֻȡǰӦõݡ0Ϊݣ1ΪǣǰӦãĬΪ0
	 * @param int    $feature   ID0ȫ1ԭ2ͼƬ3Ƶ4֣ĬΪ0
	 * @return array
	 */
	function timeline_batch_by_id( $uids, $page = 1, $count = 50, $feature = 0, $base_app = 0)
	{
		$params = array();
		if (is_array($uids) && !empty($uids)) {
			foreach($uids as $k => $v) {
				$this->id_format($uids[$k]);
			}
			$params['uids'] = join(',', $uids);
		} else {
			$params['uids'] = $uids;
		}
		$params['count'] = intval($count);
		$params['page'] = intval($page); 
		$params['base_app'] = intval($base_app);
		$params['feature'] = intval($feature);
		return $this->oauth->get('statuses/timeline_batch', $params);
	}


	/**
	 * һԭ΢Ϣnת΢Ϣӿ޷Էԭ΢вѯ 
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/repost_timeline statuses/repost_timeline}
	 * 
	 * @access public
	 * @param int $sid Ҫȡת΢бԭ΢ID
	 * @param int $page ؽҳ롣 
	 * @param int $count ҳص¼෵200Ĭ50ѡ
	 * @param int $since_id ָ˲ֻIDsince_idļ¼since_idʱѡ
	 * @param int $max_id ָ˲򷵻IDСڻmax_idļ¼ѡ
	 * @param int $filter_by_author ɸѡͣ0ȫ1ҹעˡ2İˣĬΪ0
	 * @return array
	 */
	function repost_timeline( $sid, $page = 1, $count = 50, $since_id = 0, $max_id = 0, $filter_by_author = 0 )
	{
		$this->id_format($sid);

		$params = array();
		$params['id'] = $sid;
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}
		$params['filter_by_author'] = intval($filter_by_author);

		return $this->request_with_pager( 'statuses/repost_timeline', $page, $count, $params );
	}

	/**
	 * ȡǰûתn΢Ϣ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/repost_by_me statuses/repost_by_me}
	 * 
	 * @access public
	 * @param int $page ؽҳ롣 
	 * @param int $count  ÿηص¼෵200Ĭ50ѡ
	 * @param int $since_id ָ˲ֻIDsince_idļ¼since_idʱѡ
	 * @param int $max_id  ָ˲򷵻IDСڻmax_idļ¼ѡ
	 * @return array
	 */
	function repost_by_me( $page = 1, $count = 50, $since_id = 0, $max_id = 0 )
	{
		$params = array();
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}

		return $this->request_with_pager('statuses/repost_by_me', $page, $count, $params );
	}

	/**
	 * ȡ@ǰû΢б
	 *
	 * nᵽ¼û΢Ϣ@username΢Ϣ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/mentions statuses/mentions}
	 * 
	 * @access public
	 * @param int $page ؽҳš
	 * @param int $count ÿηص¼ҳС200ĬΪ50
	 * @param int $since_id ָ˲ֻIDsince_id΢Ϣsince_idʱ΢Ϣѡ
	 * @param int $max_id ָ˲򷵻IDСڻmax_idᵽǰ¼û΢Ϣѡ
	 * @param int $filter_by_author ɸѡͣ0ȫ1ҹעˡ2İˣĬΪ0
	 * @param int $filter_by_source Դɸѡͣ0ȫ1΢2΢ȺĬΪ0
	 * @param int $filter_by_type ԭɸѡͣ0ȫ΢1ԭ΢ĬΪ0
	 * @return array
	 */
	function mentions( $page = 1, $count = 50, $since_id = 0, $max_id = 0, $filter_by_author = 0, $filter_by_source = 0, $filter_by_type = 0 )
	{
		$params = array();
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}
		$params['filter_by_author'] = $filter_by_author;
		$params['filter_by_source'] = $filter_by_source;
		$params['filter_by_type'] = $filter_by_type;

		return $this->request_with_pager( 'statuses/mentions', $page, $count, $params );
	}


	/**
	 * IDȡ΢Ϣ
	 *
	 * ȡID΢ϢϢͬʱء
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/show statuses/show}
	 * 
	 * @access public
	 * @param int $id Ҫȡѷ΢ID, IDڷؿ
	 * @return array
	 */
	function show_status( $id )
	{
		$this->id_format($id);
		$params = array();
		$params['id'] = $id;
		return $this->oauth->get('statuses/show', $params);
	}

	/**
	 * ΢idŻȡ΢Ϣ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/show_batch statuses/show_batch}
	 *
	 * @param string $ids Ҫѯ΢IDðǶŷָ಻50
	 * @return array
	 */
    function show_batch( $ids )
	{
		$params=array();
		if (is_array($ids) && !empty($ids)) {
			foreach($ids as $k => $v) {
				$this->id_format($ids[$k]);
			}
			$params['ids'] = join(',', $ids);
		} else {
			$params['ids'] = $ids;
		}
		return $this->oauth->get('statuses/show_batch', $params);
	}

	/**
	 * ͨ΢ۡ˽ţIDȡMID
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/querymid statuses/querymid}
	 *
	 * @param int|string $id  Ҫѯ΢ۡ˽ţIDģʽ£ðǶŷָ಻20
	 * @param int $type  ȡͣ1΢2ۡ3˽ţĬΪ1
	 * @param int $is_batch Ƿʹģʽ01ǣĬΪ0
	 * @return array
	 */
	function querymid( $id, $type = 1, $is_batch = 0 )
	{
		$params = array();
		$params['id'] = $id;
		$params['type'] = intval($type);
		$params['is_batch'] = intval($is_batch);
		return $this->oauth->get( 'statuses/querymid',  $params);
	}

	/**
	 * ͨ΢ۡ˽ţMIDȡID
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/queryid statuses/queryid}
	 *
	 * @param int|string $mid  Ҫѯ΢ۡ˽ţMIDģʽ£ðǶŷָ಻20
	 * @param int $type  ȡͣ1΢2ۡ3˽ţĬΪ1
	 * @param int $is_batch Ƿʹģʽ01ǣĬΪ0
	 * @param int $inbox  ˽ЧMIDΪ˽ʱô˲0䡢1ռ䣬ĬΪ0 
	 * @param int $isBase62 MIDǷbase62룬01ǣĬΪ0
	 * @return array
	 */
	function queryid( $mid, $type = 1, $is_batch = 0, $inbox = 0, $isBase62 = 0)
	{
		$params = array();
		$params['mid'] = $mid;
		$params['type'] = intval($type);
		$params['is_batch'] = intval($is_batch);
		$params['inbox'] = intval($inbox);
		$params['isBase62'] = intval($isBase62);
		return $this->oauth->get('statuses/queryid', $params);
	}

	/**
	 * 췵΢ת΢б
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/hot/repost_daily statuses/hot/repost_daily}
	 *
	 * @param int $count صļ¼󲻳50ĬΪ20
	 * @param int $base_app ǷֻȡǰӦõݡ0Ϊݣ1ΪǣǰӦãĬΪ0
	 * @return array
	 */
	function repost_daily( $count = 20, $base_app = 0)
	{
		$params = array();
		$params['count'] = intval($count);
		$params['base_app'] = intval($base_app);
		return $this->oauth->get('statuses/hot/repost_daily',  $params);
	}

	/**
	 * ܷ΢ת΢б
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/hot/repost_weekly statuses/hot/repost_weekly}
	 *
	 * @param int $count صļ¼󲻳50ĬΪ20
	 * @param int $base_app ǷֻȡǰӦõݡ0Ϊݣ1ΪǣǰӦãĬΪ0
	 * @return array
	 */
	function repost_weekly( $count = 20,  $base_app = 0)
	{
		$params = array();
		$params['count'] = intval($count);
		$params['base_app'] = intval($base_app);
		return $this->oauth->get( 'statuses/hot/repost_weekly',  $params);
	}

	/**
	 * 췵΢۰΢б
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/hot/comments_daily statuses/hot/comments_daily}
	 *
	 * @param int $count صļ¼󲻳50ĬΪ20
	 * @param int $base_app ǷֻȡǰӦõݡ0Ϊݣ1ΪǣǰӦãĬΪ0
	 * @return array
	 */
	function comments_daily( $count = 20,  $base_app = 0)
	{
		$params =  array();
		$params['count'] = intval($count);
		$params['base_app'] = intval($base_app);
		return $this->oauth->get( 'statuses/hot/comments_daily',  $params);
	}

	/**
	 * ܷ΢۰΢б
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/hot/comments_weekly statuses/hot/comments_weekly}
	 *
	 * @param int $count صļ¼󲻳50ĬΪ20
	 * @param int $base_app ǷֻȡǰӦõݡ0Ϊݣ1ΪǣǰӦãĬΪ0
	 * @return array
	 */
	function comments_weekly( $count = 20, $base_app = 0)
	{
		$params =  array();
		$params['count'] = intval($count);
		$params['base_app'] = intval($base_app);
		return $this->oauth->get( 'statuses/hot/comments_weekly', $params);
	}


	/**
	 * תһ΢Ϣ
	 *
	 * ɼۡΪֹظϢϢһᱻԡ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/repost statuses/repost}
	 * 
	 * @access public
	 * @param int $sid ת΢ID
	 * @param string $text ӵϢѡ
	 * @param int $is_comment Ƿתͬʱۣ01۸ǰ΢2۸ԭ΢3ۣĬΪ0
	 * @return array
	 */
	function repost( $sid, $text = NULL, $is_comment = 0 )
	{
		$this->id_format($sid);

		$params = array();
		$params['id'] = $sid;
		$params['is_comment'] = $is_comment;
		if( $text ) $params['status'] = $text;

		return $this->oauth->post( 'statuses/repost', $params  );
	}

	/**
	 * ɾһ΢
	 * 
	 * IDɾ΢Ϣע⣺ֻɾԼϢ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/destroy statuses/destroy}
	 * 
	 * @access public
	 * @param int $id Ҫɾ΢ID
	 * @return array
	 */
	function delete( $id )
	{
		return $this->destroy( $id );
	}

	/**
	 * ɾһ΢
	 *
	 * ɾ΢ע⣺ֻɾԼϢ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/destroy statuses/destroy}
	 * 
	 * @access public
	 * @param int $id Ҫɾ΢ID
	 * @return array
	 */
	function destroy( $id )
	{
		$this->id_format($id);
		$params = array();
		$params['id'] = $id;
		return $this->oauth->post( 'statuses/destroy',  $params );
	}

	
	/**
	 * ΢
	 *
	 * һ΢Ϣ
	 * <br />ע⣺latlongʹãڱǷ΢Ϣʱڵĵλãֻûgeo_enabled=trueʱλϢЧ
	 * <br />ע⣺Ϊֹظύû΢Ϣϴγɹ΢Ϣһʱ400󣬸ʾ40025:Error: repeated weibo text! 
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/update statuses/update}
	 * 
	 * @access public
	 * @param string $status Ҫµ΢ϢϢݲ140, Ϊշ400
	 * @param float $lat γȣǰ΢ڵĵλãЧΧ -90.0+90.0, +ʾγѡ
	 * @param float $long ȡЧΧ-180.0+180.0, +ʾѡ
	 * @param mixed $annotations ѡԪݣҪΪ˷Ӧü¼һЩʺԼʹõϢÿ΢԰һ߶ԪݡjsonִʽύִȲ512ַ鷽ʽҪjson_encodeִȲ512ַݿԶ磺'[{"type2":123}, {"a":"b", "c":"d"}]'array(array("type2"=>123), array("a"=>"b", "c"=>"d"))
	 * @return array
	 */
	function update( $status, $lat = NULL, $long = NULL, $annotations = NULL )
	{
		$params = array();
		$params['status'] = $status;
		if ($lat) {
			$params['lat'] = floatval($lat);
		}
		if ($long) {
			$params['long'] = floatval($long);
		}
		if (is_string($annotations)) {
			$params['annotations'] = $annotations;
		} elseif (is_array($annotations)) {
			$params['annotations'] = json_encode($annotations);
		}

		return $this->oauth->post( 'statuses/update', $params );
	}

	/**
	 * ͼƬ΢
	 *
	 * ͼƬ΢ϢĿǰϴͼƬСΪ<5M 
	 * <br />ע⣺latlongʹãڱǷ΢Ϣʱڵĵλãֻûgeo_enabled=trueʱλϢЧ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/upload statuses/upload}
	 * 
	 * @access public
	 * @param string $status Ҫµ΢ϢϢݲ140, Ϊշ400
	 * @param string $pic_path ҪͼƬ·, ֧url[ֻ֧png/jpg/gifָʽ, Ӹʽ޸get_image_mime]
	 * @param float $lat γȣǰ΢ڵĵλãЧΧ -90.0+90.0, +ʾγѡ
	 * @param float $long ѡȡЧΧ-180.0+180.0, +ʾѡ
	 * @return array
	 */
	function upload( $status, $pic_path, $lat = NULL, $long = NULL )
	{
		$params = array();
		$params['status'] = $status;
		$params['pic'] = '@'.$pic_path;
		if ($lat) {
			$params['lat'] = floatval($lat);
		}
		if ($long) {
			$params['long'] = floatval($long);
		}

		return $this->oauth->post( 'statuses/upload', $params, true );
	}


	/**
	 * ָһͼƬURLַץȡϴͬʱһ΢
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/statuses/upload_url_text statuses/upload_url_text}
	 *
	 * @param string $status  Ҫ΢ıݣݲ140֡
	 * @param string $url    ͼƬURLַhttpͷ
	 * @return array
	 */
	function upload_url_text( $status,  $url )
	{
		$params = array();
		$params['status'] = $status;
		$params['url'] = $url;
		return $this->oauth->post( 'statuses/upload', $params, true );
	}


	/**
	 * ȡб
	 *
	 * ΢ٷб顢ħϢ࣬͡Ƿŵȡ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/emotions emotions}
	 * 
	 * @access public
	 * @param string $type "face":ͨ飬"ani"ħ飬"cartoon"顣ĬΪ"face"ѡ
	 * @param string $language "cnname"壬"twname"塣ĬΪ"cnname"ѡ
	 * @return array
	 */
	function emotions( $type = "face", $language = "cnname" )
	{
		$params = array();
		$params['type'] = $type;
		$params['language'] = $language;
		return $this->oauth->get( 'emotions', $params );
	}


	/**
	 * ΢IDĳ΢б
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/comments/show comments/show}
	 *
	 * @param int $sid Ҫѯ΢ID
	 * @param int $page ؽҳ룬ĬΪ1
	 * @param int $count ҳصļ¼ĬΪ50
	 * @param int $since_id ָ˲򷵻IDsince_idۣsince_idʱۣĬΪ0
	 * @param int $max_id  ָ˲򷵻IDСڻmax_idۣĬΪ0
	 * @param int $filter_by_author ɸѡͣ0ȫ1ҹעˡ2İˣĬΪ0
	 * @return array
	 */
	function get_comments_by_sid( $sid, $page = 1, $count = 50, $since_id = 0, $max_id = 0, $filter_by_author = 0 )
	{
		$params = array();
		$this->id_format($sid);
		$params['id'] = $sid;
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}
		$params['count'] = $count;
		$params['page'] = $page;
		$params['filter_by_author'] = $filter_by_author;
		return $this->oauth->get( 'comments/show',  $params );
	}


	/**
	 * ȡǰ¼ûб
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/comments/by_me comments/by_me}
	 *
	 * @param int $since_id ָ˲򷵻IDsince_idۣsince_idʱۣĬΪ0
	 * @param int $max_id ָ˲򷵻IDСڻmax_idۣĬΪ0
	 * @param int $count  ҳصļ¼ĬΪ50
	 * @param int $page ؽҳ룬ĬΪ1
	 * @param int $filter_by_source Դɸѡͣ0ȫ1΢ۡ2΢ȺۣĬΪ0
	 * @return array
	 */
	function comments_by_me( $page = 1 , $count = 50, $since_id = 0, $max_id = 0,  $filter_by_source = 0 )
	{
		$params = array();
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}
		$params['count'] = $count;
		$params['page'] = $page;
		$params['filter_by_source'] = $filter_by_source;
		return $this->oauth->get( 'comments/by_me', $params );
	}

	/**
	 * ȡǰ¼ûյб
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/comments/to_me comments/to_me}
	 *
	 * @param int $since_id ָ˲򷵻IDsince_idۣsince_idʱۣĬΪ0
	 * @param int $max_id  ָ˲򷵻IDСڻmax_idۣĬΪ0
	 * @param int $count ҳصļ¼ĬΪ50
	 * @param int $page ؽҳ룬ĬΪ1
	 * @param int $filter_by_author ɸѡͣ0ȫ1ҹעˡ2İˣĬΪ0
	 * @param int $filter_by_source Դɸѡͣ0ȫ1΢ۡ2΢ȺۣĬΪ0
	 * @return array
	 */ 
	function comments_to_me( $page = 1 , $count = 50, $since_id = 0, $max_id = 0, $filter_by_author = 0, $filter_by_source = 0)
	{
		$params = array();
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}
		$params['count'] = $count;
		$params['page'] = $page;
		$params['filter_by_author'] = $filter_by_author;
		$params['filter_by_source'] = $filter_by_source;
		return $this->oauth->get( 'comments/to_me', $params );
	}

	/**
	 * (ʱ)
	 *
	 * nͼյۡ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/comments/timeline comments/timeline}
	 * 
	 * @access public
	 * @param int $page ҳ
	 * @param int $count ÿηص¼෵200Ĭ50
	 * @param int $since_id ָ˲ֻIDsince_idۣsince_idʱѡ
	 * @param int $max_id ָ˲򷵻IDСڻmax_idۡѡ
	 * @return array
	 */
	function comments_timeline( $page = 1, $count = 50, $since_id = 0, $max_id = 0 )
	{
		$params = array();
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}

		return $this->request_with_pager( 'comments/timeline', $page, $count, $params );
	}


	/**
	 * ȡµᵽǰ¼ûۣ@ҵ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/comments/mentions comments/mentions}
	 *
	 * @param int $since_id ָ˲򷵻IDsince_idۣsince_idʱۣĬΪ0
	 * @param int $max_id  ָ˲򷵻IDСڻmax_idۣĬΪ0
	 * @param int $count ҳصļ¼ĬΪ50
	 * @param int $page ؽҳ룬ĬΪ1
	 * @param int $filter_by_author  ɸѡͣ0ȫ1ҹעˡ2İˣĬΪ0
	 * @param int $filter_by_source Դɸѡͣ0ȫ1΢ۡ2΢ȺۣĬΪ0
	 * @return array
	 */ 
	function comments_mentions( $page = 1, $count = 50, $since_id = 0, $max_id = 0, $filter_by_author = 0, $filter_by_source = 0)
	{
		$params = array();
		$params['since_id'] = $since_id;
		$params['max_id'] = $max_id;
		$params['count'] = $count;
		$params['page'] = $page;
		$params['filter_by_author'] = $filter_by_author;
		$params['filter_by_source'] = $filter_by_source;
		return $this->oauth->get( 'comments/mentions', $params );
	}


	/**
	 * IDϢ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/comments/show_batch comments/show_batch}
	 *
	 * @param string $cids ҪѯIDðǶŷָ50
	 * @return array
	 */
	function comments_show_batch( $cids )
	{
		$params = array();
		if (is_array( $cids) && !empty( $cids)) {
			foreach($cids as $k => $v) {
				$this->id_format($cids[$k]);
			}
			$params['cids'] = join(',', $cids);
		} else {
			$params['cids'] = $cids;
		}
		return $this->oauth->get( 'comments/show_batch', $params );
	}


	/**
	 * һ΢
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/comments/create comments/create}
	 *
	 * @param string $comment ݣݲ140֡
	 * @param int $id Ҫ۵΢ID
	 * @param int $comment_ori ת΢ʱǷ۸ԭ΢01ǣĬΪ0
	 * @return array
	 */
	function send_comment( $id , $comment , $comment_ori = 0)
	{
		$params = array();
		$params['comment'] = $comment;
		$this->id_format($id);
		$params['id'] = $id;
		$params['comment_ori'] = $comment_ori;
		return $this->oauth->post( 'comments/create', $params );
	}

	/**
	 * ɾǰû΢Ϣ
	 *
	 * ע⣺ֻɾԼۣ΢ûɾ˵ۡ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/statuses/comment_destroy statuses/comment_destroy}
	 * 
	 * @access public
	 * @param int $cid Ҫɾid
	 * @return array
	 */
	function comment_destroy( $cid )
	{
		$params = array();
		$params['cid'] = $cid;
		return $this->oauth->post( 'comments/destroy', $params);
	}


	/**
	 * IDɾ
	 *
	 * ע⣺ֻɾԼۣ΢ûɾ˵ۡ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/comments/destroy_batch comments/destroy_batch}
	 *
	 * @access public
	 * @param string $ids ҪɾIDðǶŸ20
	 * @return array
	 */
	function comment_destroy_batch( $ids )
	{
		$params = array();
		if (is_array($ids) && !empty($ids)) {
			foreach($ids as $k => $v) {
				$this->id_format($ids[$k]);
			}
			$params['cids'] = join(',', $ids);
		} else {
			$params['cids'] = $ids;
		}
		return $this->oauth->post( 'comments/destroy_batch', $params);
	}


	/**
	 * ظһ
	 *
	 * ΪֹظϢһ/ظϢһᱻԡ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/comments/reply comments/reply}
	 * 
	 * @access public
	 * @param int $sid ΢id
	 * @param string $text ݡ
	 * @param int $cid id
	 * @param int $without_mention 1ظвԶ롰ظ@û0ظԶ롰ظ@û.ĬΪ0.
     * @param int $comment_ori	  ת΢ʱǷ۸ԭ΢01ǣĬΪ0
	 * @return array
	 */
	function reply( $sid, $text, $cid, $without_mention = 0, $comment_ori = 0 )
	{
		$this->id_format( $sid );
		$this->id_format( $cid );
		$params = array();
		$params['id'] = $sid;
		$params['comment'] = $text;
		$params['cid'] = $cid;
		$params['without_mention'] = $without_mention;
		$params['comment_ori'] = $comment_ori;

		return $this->oauth->post( 'comments/reply', $params );

	}

	/**
	 * ûUIDǳƻȡû
	 *
	 * ûUIDǳƷûϣͬʱҲû·΢
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/users/show users/show}
	 * 
	 * @access public
	 * @param int  $uid ûUID
	 * @return array
	 */
	function show_user_by_id( $uid )
	{
		$params=array();
		if ( $uid !== NULL ) {
			$this->id_format($uid);
			$params['uid'] = $uid;
		}

		return $this->oauth->get('users/show', $params );
	}
	
	/**
	 * ûUIDǳƻȡû
	 *
	 * ûUIDǳƷûϣͬʱҲû·΢
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/users/show users/show}
	 * 
	 * @access public
	 * @param string  $screen_name ûUID
	 * @return array
	 */
	function show_user_by_name( $screen_name )
	{
		$params = array();
		$params['screen_name'] = $screen_name;

		return $this->oauth->get( 'users/show', $params );
	}

	/**
	 * ͨԻȡûԼûµһ΢
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/users/domain_show users/domain_show}
	 * 
	 * @access public
	 * @param mixed $domain û磺lazypeoplehttp://weibo.com/lazypeople
	 * @return array
	 */
	function domain_show( $domain )
	{
		$params = array();
		$params['domain'] = $domain;
		return $this->oauth->get( 'users/domain_show', $params );
	}

	 /**
	 * ȡûϢuids
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/users/show_batch users/show_batch}
	 *
	 * @param string $uids ҪѯûIDðǶŷָһ20
	 * @return array
	 */
	function users_show_batch_by_id( $uids )
	{
		$params = array();
		if (is_array( $uids ) && !empty( $uids )) {
			foreach( $uids as $k => $v ) {
				$this->id_format( $uids[$k] );
			}
			$params['uids'] = join(',', $uids);
		} else {
			$params['uids'] = $uids;
		}
		return $this->oauth->get( 'users/show_batch', $params );
	}
	
	/**
	 * ȡûϢscreen_name
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/users/show_batch users/show_batch}
	 *
	 * @param string  $screen_name ҪѯûǳƣðǶŷָһ20
	 * @return array
	 */
	function users_show_batch_by_name( $screen_name )
	{
		$params = array();
		if (is_array( $screen_name ) && !empty( $screen_name )) {
			$params['screen_name'] = join(',', $screen_name);
		} else {
			$params['screen_name'] = $screen_name;
		}
		return $this->oauth->get( 'users/show_batch', $params );
	}


	/**
	 * ȡûĹעб
	 *
	 * ûṩcursorֻǰ5000עid
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/friendships/friends friendships/friends}
	 * 
	 * @access public
	 * @param int $cursor ؽα꣬һҳ÷ֵnext_cursorһҳprevious_cursorĬΪ0
	 * @param int $count ҳصļ¼ĬΪ50󲻳200
	 * @param int $uid  ҪȡûID
	 * @return array
	 */
	function friends_by_id( $uid, $cursor = 0, $count = 50 )
	{
		$params = array();
		$params['cursor'] = $cursor;
		$params['count'] = $count;
		$params['uid'] = $uid;

		return $this->oauth->get( 'friendships/friends', $params );
	}
	
	
	/**
	 * ȡûĹעб
	 *
	 * ûṩcursorֻǰ5000עid
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/friendships/friends friendships/friends}
	 * 
	 * @access public
	 * @param int $cursor ؽα꣬һҳ÷ֵnext_cursorһҳprevious_cursorĬΪ0
	 * @param int $count ҳصļ¼ĬΪ50󲻳200
	 * @param string $screen_name  Ҫȡû screen_name
	 * @return array
	 */
	function friends_by_name( $screen_name, $cursor = 0, $count = 50 )
	{
		$params = array();
		$params['cursor'] = $cursor;
		$params['count'] = $count;
		$params['screen_name'] = $screen_name;
		return $this->oauth->get( 'friendships/friends', $params );
	}


	/**
	 * ȡû֮Ĺͬעб
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/friendships/friends/in_common friendships/friends/in_common}
	 *
	 * @param int $uid  ҪȡͬעϵûUID
	 * @param int $suid  ҪȡͬעϵûUIDĬΪǰ¼û
	 * @param int $count  ҳصļ¼ĬΪ50
	 * @param int $page  ؽҳ룬ĬΪ1
	 * @return array
	 */
	function friends_in_common( $uid, $suid = NULL, $page = 1, $count = 50 )
	{
		$params = array();
		$params['uid'] = $uid;
		$params['suid'] = $suid;
		$params['count'] = $count;
		$params['page'] = $page;
		return $this->oauth->get( 'friendships/friends/in_common', $params  );
	}

	/**
	 * ȡû˫עбб
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/friendships/friends/bilateral friendships/friends/bilateral}
	 *
	 * @param int $uid  Ҫȡ˫עбûUID
	 * @param int $count  ҳصļ¼ĬΪ50
	 * @param int $page  ؽҳ룬ĬΪ1
	 * @param int $sort  ͣ0עʱĬΪ0
	 * @return array
	 **/
	function bilateral( $uid, $page = 1, $count = 50, $sort = 0 )
	{
		$params = array();
		$params['uid'] = $uid;
		$params['count'] = $count;
		$params['page'] = $page;
		$params['sort'] = $sort;
		return $this->oauth->get( 'friendships/friends/bilateral', $params  );
	}

	/**
	 * ȡû˫עuidб
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/friendships/friends/bilateral/ids friendships/friends/bilateral/ids}
	 *
	 * @param int $uid  Ҫȡ˫עбûUID
	 * @param int $count ҳصļ¼ĬΪ50
	 * @param int $page  ؽҳ룬ĬΪ1
	 * @param int $sort  ͣ0עʱĬΪ0
	 * @return array
	 **/
	function bilateral_ids( $uid, $page = 1, $count = 50, $sort = 0)
	{
		$params = array();
		$params['uid'] = $uid;
		$params['count'] = $count;
		$params['page'] = $page;
		$params['sort'] = $sort;
		return $this->oauth->get( 'friendships/friends/bilateral/ids',  $params  );
	}

	/**
	 * ȡûĹעбuid
	 *
	 * ûṩcursorֻǰ5000עid
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/friendships/friends/ids friendships/friends/ids}
	 * 
	 * @access public
	 * @param int $cursor ؽα꣬һҳ÷ֵnext_cursorһҳprevious_cursorĬΪ0
	 * @param int $count ÿηص¼ҳС5000, ĬϷ500
	 * @param int $uid Ҫȡû UIDĬΪǰû
	 * @return array
	 */
	function friends_ids_by_id( $uid, $cursor = 0, $count = 500 )
	{
		$params = array();
		$this->id_format($uid);
		$params['uid'] = $uid;
		$params['cursor'] = $cursor;
		$params['count'] = $count;
		return $this->oauth->get( 'friendships/friends/ids', $params );
	}
	
	/**
	 * ȡûĹעбuid
	 *
	 * ûṩcursorֻǰ5000עid
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/friendships/friends/ids friendships/friends/ids}
	 * 
	 * @access public
	 * @param int $cursor ؽα꣬һҳ÷ֵnext_cursorһҳprevious_cursorĬΪ0
	 * @param int $count ÿηص¼ҳС5000, ĬϷ500
	 * @param string $screen_name Ҫȡû screen_nameĬΪǰû
	 * @return array
	 */
	function friends_ids_by_name( $screen_name, $cursor = 0, $count = 500 )
	{
		$params = array();
		$params['cursor'] = $cursor;
		$params['count'] = $count;
		$params['screen_name'] = $screen_name;
		return $this->oauth->get( 'friendships/friends/ids', $params );
	}


	/**
	 * ȡǰ¼ûĹע˵ıעϢ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/friendships/friends/remark_batch friendships/friends/remark_batch}
	 *
	 * @param string $uids  ҪȡעûUIDðǶŷָ಻50
	 * @return array
	 **/
	function friends_remark_batch( $uids )
	{
		$params = array();
		if (is_array( $uids ) && !empty( $uids )) {
			foreach( $uids as $k => $v) {
				$this->id_format( $uids[$k] );
			}
			$params['uids'] = join(',', $uids);
		} else {
			$params['uids'] = $uids;
		}
		return $this->oauth->get( 'friendships/friends/remark_batch', $params  );
	}

	/**
	 * ȡûķ˿б
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/friendships/followers friendships/followers}
	 *
	 * @param int $uid  ҪѯûUID
	 * @param int $count ҳصļ¼ĬΪ50󲻳200
	 * @param int $cursor false ؽα꣬һҳ÷ֵnext_cursorһҳprevious_cursorĬΪ0
	 * @return array
	 **/
	function followers_by_id( $uid , $cursor = 0 , $count = 50)
	{
		$params = array();
		$this->id_format($uid);
		$params['uid'] = $uid;
		$params['count'] = $count;
		$params['cursor'] = $cursor;
		return $this->oauth->get( 'friendships/followers', $params  );
	}
	
	/**
	 * ȡûķ˿б
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/friendships/followers friendships/followers}
	 *
	 * @param string $screen_name  Ҫѯûǳ
	 * @param int  $count ҳصļ¼ĬΪ50󲻳200
	 * @param int  $cursor false ؽα꣬һҳ÷ֵnext_cursorһҳprevious_cursorĬΪ0
	 * @return array
	 **/
	function followers_by_name( $screen_name, $cursor = 0 , $count = 50 )
	{
		$params = array();
		$params['screen_name'] = $screen_name;
		$params['count'] = $count;
		$params['cursor'] = $cursor;
		return $this->oauth->get( 'friendships/followers', $params  );
	}

	/**
	 * ȡûķ˿бuid
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/friendships/followers friendships/followers}
	 *
	 * @param int $uid ҪѯûUID
	 * @param int $count ҳصļ¼ĬΪ50󲻳200
	 * @param int $cursor ؽα꣬һҳ÷ֵnext_cursorһҳprevious_cursorĬΪ0
	 * @return array
	 **/
	function followers_ids_by_id( $uid, $cursor = 0 , $count = 50 )
	{
		$params = array();
		$this->id_format($uid);
		$params['uid'] = $uid;
		$params['count'] = $count;
		$params['cursor'] = $cursor;
		return $this->oauth->get( 'friendships/followers/ids', $params  );
	}
	
	/**
	 * ȡûķ˿бuid
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/friendships/followers friendships/followers}
	 *
	 * @param string $screen_name Ҫѯûscreen_name
	 * @param int $count ҳصļ¼ĬΪ50󲻳200
	 * @param int $cursor ؽα꣬һҳ÷ֵnext_cursorһҳprevious_cursorĬΪ0
	 * @return array
	 **/
	function followers_ids_by_name( $screen_name, $cursor = 0 , $count = 50 )
	{
		$params = array();
		$params['screen_name'] = $screen_name;
		$params['count'] = $count;
		$params['cursor'] = $cursor;
		return $this->oauth->get( 'friendships/followers/ids', $params  );
	}

	/**
	 * ȡʷ˿
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/friendships/followers/active friendships/followers/active}
	 *
	 * @param int $uid ҪѯûUID
	 * @param int $count صļ¼ĬΪ20󲻳200
     * @return array
	 **/
	function followers_active( $uid,  $count = 20)
	{
		$param = array();
		$this->id_format($uid);
		$param['uid'] = $uid;
		$param['count'] = $count;
		return $this->oauth->get( 'friendships/followers/active', $param);
	}


	/**
	 * ȡǰ¼ûĹעֹעָûûб
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/friendships/friends_chain/followers friendships/friends_chain/followers}
	 *
	 * @param int $uid ָĹעĿûUID
	 * @param int $count ҳصļ¼ĬΪ50
	 * @param int $page ؽҳ룬ĬΪ1
	 * @return array
	 **/
	function friends_chain_followers( $uid, $page = 1, $count = 50 )
	{
		$params = array();
		$this->id_format($uid);
		$params['uid'] = $uid;
		$params['count'] = $count;
		$params['page'] = $page;
		return $this->oauth->get( 'friendships/friends_chain/followers',  $params );
	}

	/**
	 * ûϵϸ
	 *
	 * ԴûĿûڣhttp400
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/friendships/show friendships/show}
	 * 
	 * @access public
	 * @param mixed $target_id ĿûUID
	 * @param mixed $source_id ԴûUIDѡĬΪǰû
	 * @return array
	 */
	function is_followed_by_id( $target_id, $source_id = NULL )
	{
		$params = array();
		$this->id_format($target_id);
		$params['target_id'] = $target_id;

		if ( $source_id != NULL ) {
			$this->id_format($source_id);
			$params['source_id'] = $source_id;
		}

		return $this->oauth->get( 'friendships/show', $params );
	}

	/**
	 * ûϵϸ
	 *
	 * ԴûĿûڣhttp400
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/friendships/show friendships/show}
	 * 
	 * @access public
	 * @param mixed $target_name Ŀû΢ǳ
	 * @param mixed $source_name Դû΢ǳƣѡĬΪǰû
	 * @return array
	 */
	function is_followed_by_name( $target_name, $source_name = NULL )
	{
		$params = array();
		$params['target_screen_name'] = $target_name;

		if ( $source_name != NULL ) {
			$params['source_screen_name'] = $source_name;
		}

		return $this->oauth->get( 'friendships/show', $params );
	}

	/**
	 * עһû
	 *
	 * ɹ򷵻عע˵ϣĿǰע2000ˣʧ򷵻һַ˵Ѿע˴ˣ򷵻http 403״̬עڵID400
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/friendships/create friendships/create}
	 * 
	 * @access public
	 * @param int $uid ҪעûUID
	 * @return array
	 */
	function follow_by_id( $uid )
	{
		$params = array();
		$this->id_format($uid);
		$params['uid'] = $uid;
		return $this->oauth->post( 'friendships/create', $params );
	}
	
	/**
	 * עһû
	 *
	 * ɹ򷵻عע˵ϣĿǰע2000ˣʧ򷵻һַ˵Ѿע˴ˣ򷵻http 403״̬עڵID400
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/friendships/create friendships/create}
	 * 
	 * @access public
	 * @param string $screen_name Ҫעûǳ
	 * @return array
	 */
	function follow_by_name( $screen_name )
	{
		$params = array();
		$params['screen_name'] = $screen_name;
		return $this->oauth->post( 'friendships/create', $params);
	}


	/**
	 * ûUIDעû
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/friendships/create_batch friendships/create_batch}
	 *
	 * @param string $uids ҪעûUIDðǶŷָ಻20
	 * @return array
	 */
	function follow_create_batch( $uids )
	{
		$params = array();
		if (is_array($uids) && !empty($uids)) {
			foreach($uids as $k => $v) {
				$this->id_format($uids[$k]);
			}
			$params['uids'] = join(',', $uids);
		} else {
			$params['uids'] = $uids;
		}
		return $this->oauth->post( 'friendships/create_batch', $params);
	}

	/**
	 * ȡעĳû
	 *
	 * ȡעĳûɹ򷵻رȡע˵ϣʧ򷵻һַ˵
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/friendships/destroy friendships/destroy}
	 * 
	 * @access public
	 * @param int $uid ҪȡעûUID
	 * @return array
	 */
	function unfollow_by_id( $uid )
	{
		$params = array();
		$this->id_format($uid);
		$params['uid'] = $uid;
		return $this->oauth->post( 'friendships/destroy', $params);
	}
	
	/**
	 * ȡעĳû
	 *
	 * ȡעĳûɹ򷵻رȡע˵ϣʧ򷵻һַ˵
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/friendships/destroy friendships/destroy}
	 * 
	 * @access public
	 * @param string $screen_name Ҫȡעûǳ
	 * @return array
	 */
	function unfollow_by_name( $screen_name )
	{
		$params = array();
		$params['screen_name'] = $screen_name;
		return $this->oauth->post( 'friendships/destroy', $params);
	}

	/**
	 * µǰ¼ûעĳѵıעϢ
	 *
	 * ֻ޸ĵǰ¼ûעûıעϢ򽫸400
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/friendships/remark/update friendships/remark/update}
	 * 
	 * @access public
	 * @param int $uid Ҫ޸ıעϢûID
	 * @param string $remark עϢ
	 * @return array
	 */
	function update_remark( $uid, $remark )
	{
		$params = array();
		$this->id_format($uid);
		$params['uid'] = $uid;
		$params['remark'] = $remark;
		return $this->oauth->post( 'friendships/remark/update', $params);
	}

	/**
	 * ȡǰû˽б
	 *
	 * ûn˽ţߺͽߵϸϡ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/direct_messages direct_messages}
	 * 
	 * @access public
	 * @param int $page ҳ
	 * @param int $count ÿηص¼෵200Ĭ50
	 * @param int64 $since_id IDֵsince_id󣨱since_idʱģ˽šѡ
	 * @param int64 $max_id IDmax_id(ʱ䲻max_id)˽šѡ
	 * @return array
	 */
	function list_dm( $page = 1, $count = 50, $since_id = 0, $max_id = 0 )
	{
		$params = array();
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}

		return $this->request_with_pager( 'direct_messages', $page, $count, $params );
	}

	/**
	 * ȡǰû͵˽б
	 *
	 * ص¼ûѷ50˽šߺͽߵϸϡ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/direct_messages/sent direct_messages/sent}
	 * 
	 * @access public
	 * @param int $page ҳ
	 * @param int $count ÿηص¼෵200Ĭ50
	 * @param int64 $since_id IDֵsince_id󣨱since_idʱģ˽šѡ
	 * @param int64 $max_id IDmax_id(ʱ䲻max_id)˽šѡ
	 * @return array
	 */
	function list_dm_sent( $page = 1, $count = 50, $since_id = 0, $max_id = 0 )
	{
		$params = array();
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}

		return $this->request_with_pager( 'direct_messages/sent', $page, $count, $params );
	}


	/**
	 * ȡ뵱ǰ¼û˽ûбû˽
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/direct_messages/user_list direct_messages/user_list}
	 *
	 * @param int $count  ҳصļ¼ĬΪ20
	 * @param int $cursor ؽα꣬һҳ÷ֵnext_cursorһҳprevious_cursorĬΪ0
	 * @return array
	 */
	function dm_user_list( $count = 20, $cursor = 0)
	{
		$params = array();
		$params['count'] = $count;
		$params['cursor'] = $cursor;
		return $this->oauth->get( 'direct_messages/user_list', $params );
	} 

	/**
	 * ȡָû˽б
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/direct_messages/conversation direct_messages/conversation}
	 *
	 * @param int $uid ҪѯûUID
	 * @param int $since_id ָ˲򷵻IDsince_id˽ţsince_idʱ˽ţĬΪ0
	 * @param int $max_id  ָ˲򷵻IDСڻmax_id˽ţĬΪ0
	 * @param int $count ҳصļ¼ĬΪ50
	 * @param int $page  ؽҳ룬ĬΪ1
	 * @return array
	 */
	function dm_conversation( $uid, $page = 1, $count = 50, $since_id = 0, $max_id = 0)
	{
		$params = array();
		$this->id_format($uid);
		$params['uid'] = $uid;
		if ($since_id) {
			$this->id_format($since_id);
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$this->id_format($max_id);
			$params['max_id'] = $max_id;
		}
		$params['count'] = $count;
		$params['page'] = $page;
		return $this->oauth->get( 'direct_messages/conversation', $params );
	}

	/**
	 * ˽IDȡ˽
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/direct_messages/show_batch direct_messages/show_batch}
	 *
	 * @param string  $dmids Ҫѯ˽IDðǶŷָһ50
	 * @return array
	 */
	function dm_show_batch( $dmids )
	{
		$params = array();
		if (is_array($dmids) && !empty($dmids)) {
			foreach($dmids as $k => $v) {
				$this->id_format($dmids[$k]);
			}
			$params['dmids'] = join(',', $dmids);
		} else {
			$params['dmids'] = $dmids;
		}
		return $this->oauth->get( 'direct_messages/show_batch',  $params );
	}

	/**
	 * ˽
	 *
	 * һ˽šɹķϢ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/direct_messages/new direct_messages/new}
	 * 
	 * @access public
	 * @param int $uid ûUID
	 * @param string $text ҪϢݣıСС300֡
	 * @param int $id Ҫ͵΢ID
	 * @return array
	 */
	function send_dm_by_id( $uid, $text, $id = NULL )
	{
		$params = array();
		$this->id_format( $uid );
		$params['text'] = $text;
		$params['uid'] = $uid;
		if ($id) {
			$this->id_format( $id );
			$params['id'] = $id;
		}
		return $this->oauth->post( 'direct_messages/new', $params );
	}
	
	/**
	 * ˽
	 *
	 * һ˽šɹķϢ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/direct_messages/new direct_messages/new}
	 * 
	 * @access public
	 * @param string $screen_name ûǳ
	 * @param string $text ҪϢݣıСС300֡
	 * @param int $id Ҫ͵΢ID
	 * @return array
	 */
	function send_dm_by_name( $screen_name, $text, $id = NULL )
	{
		$params = array();
		$params['text'] = $text;
		$params['screen_name'] = $screen_name;
		if ($id) {
			$this->id_format( $id );
			$params['id'] = $id;
		}
		return $this->oauth->post( 'direct_messages/new', $params);
	}

	/**
	 * ɾһ˽
	 *
	 * IDɾ˽šûΪ˽ŵĽˡ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/direct_messages/destroy direct_messages/destroy}
	 * 
	 * @access public
	 * @param int $did Ҫɾ˽ID
	 * @return array
	 */
	function delete_dm( $did )
	{
		$this->id_format($did);
		$params = array();
		$params['id'] = $did;
		return $this->oauth->post('direct_messages/destroy', $params);
	}

	/**
	 * ɾ˽
	 *
	 * ɾǰ¼û˽š쳣ʱ400
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/direct_messages/destroy_batch direct_messages/destroy_batch}
	 * 
	 * @access public
	 * @param mixed $dids ɾһ˽IDðǶŸһIDɵ顣20磺"4976494627, 4976262053"array(4976494627,4976262053);
	 * @return array
	 */
	function delete_dms( $dids )
	{
		$params = array();
		if (is_array($dids) && !empty($dids)) {
			foreach($dids as $k => $v) {
				$this->id_format($dids[$k]);
			}
			$params['ids'] = join(',', $dids);
		} else {
			$params['ids'] = $dids;
		}

		return $this->oauth->post( 'direct_messages/destroy_batch', $params);
	}
	


	/**
	 * ȡûϢ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/profile/basic account/profile/basic}
	 *
	 * @param int $uid  ҪȡϢûUIDĬΪǰ¼û
	 * @return array
	 */
	function account_profile_basic( $uid = NULL  )
	{
		$params = array();
		if ($uid) {
			$this->id_format($uid);
			$params['uid'] = $uid;
		}
		return $this->oauth->get( 'account/profile/basic', $params );
	}

	/**
	 * ȡûĽϢ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/profile/education account/profile/education}
	 *
	 * @param int $uid  ҪȡϢûUIDĬΪǰ¼û
	 * @return array
	 */
	function account_education( $uid = NULL )
	{
		$params = array();
		if ($uid) {
			$this->id_format($uid);
			$params['uid'] = $uid;
		}
		return $this->oauth->get( 'account/profile/education', $params );
	}

	/**
	 * ȡûĽϢ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/profile/education_batch account/profile/education_batch}
	 *
	 * @param string $uids ҪȡϢûUIDðǶŷָ಻20
	 * @return array
	 */
	function account_education_batch( $uids  )
	{
		$params = array();
		if (is_array($uids) && !empty($uids)) {
			foreach($uids as $k => $v) {
				$this->id_format($uids[$k]);
			}
			$params['uids'] = join(',', $uids);
		} else {
			$params['uids'] = $uids;
		}

		return $this->oauth->get( 'account/profile/education_batch', $params );
	}


	/**
	 * ȡûְҵϢ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/profile/career account/profile/career}
	 *
	 * @param int $uid  ҪȡϢûUIDĬΪǰ¼û
	 * @return array
	 */
	function account_career( $uid = NULL )
	{
		$params = array();
		if ($uid) {
			$this->id_format($uid);
			$params['uid'] = $uid;
		}
		return $this->oauth->get( 'account/profile/career', $params );
	}

	/**
	 * ȡûְҵϢ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/profile/career_batch account/profile/career_batch}
	 *
	 * @param string $uids ҪȡϢûUIDðǶŷָ಻20
	 * @return array
	 */
	function account_career_batch( $uids )
	{
		$params = array();
		if (is_array($uids) && !empty($uids)) {
			foreach($uids as $k => $v) {
				$this->id_format($uids[$k]);
			}
			$params['uids'] = join(',', $uids);
		} else {
			$params['uids'] = $uids;
		}

		return $this->oauth->get( 'account/profile/career_batch', $params );
	}

	/**
	 * ȡ˽Ϣ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/get_privacy account/get_privacy}
	 * 
	 * @access public
	 * @return array
	 */
	function get_privacy()
	{
		return $this->oauth->get('account/get_privacy');
	}

	/**
	 * ȡеѧУб
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/profile/school_list account/profile/school_list}
	 *
	 * @param array $query ѡʽarray('key0'=>'value0', 'key1'=>'value1', ....)ֵ֧key:
	 *  - province	int		ʡݷΧʡID
	 *  - city		int		зΧID
	 *  - area		int		ΧID
	 *  - type		int		ѧУͣ1ѧ2С3רУ4С5СѧĬΪ1
	 *  - capital	string	ѧУĸĬΪA
	 *  - keyword	string	ѧУƹؼ֡
	 *  - count		int		صļ¼ĬΪ10
	 * keywordcapital߱ѡһֻѡһĸcapitalѯʱṩprovince
	 * @access public
	 * @return array
	 */
	function school_list( $query )
	{
		$params = $query;

		return $this->oauth->get( 'account/profile/school_list', $params );
	}

	/**
	 * ȡǰ¼ûAPIƵ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/rate_limit_status account/rate_limit_status}
	 * 
	 * @access public
	 * @return array
	 */
	function rate_limit_status()
	{
		return $this->oauth->get( 'account/rate_limit_status' );
	}

	/**
	 * OAuthȨ֮󣬻ȡȨûUID
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/get_uid account/get_uid}
	 * 
	 * @access public
	 * @return array
	 */
	function get_uid()
	{
		return $this->oauth->get( 'account/get_uid' );
	}


	/**
	 * û
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/profile/basic_update account/profile/basic_update}
	 * 
	 * @access public
	 * @param array $profile Ҫ޸ĵϡʽarray('key1'=>'value1', 'key2'=>'value2', .....)
	 * ֧޸ĵ
	 *  - screen_name		string	ûǳƣΪա
	 *  - gender	i		string	ûԱmСfŮΪա
	 *  - real_name			string	ûʵ
	 *  - real_name_visible	int		ʵɼΧ0Լɼ1ע˿ɼ2˿ɼ
	 *  - province	true	int		ʡݴIDΪա
	 *  - city	true		int		дIDΪա
	 *  - birthday			string	ûգʽyyyy-mm-dd
	 *  - birthday_visible	int		տɼΧ0ܡ1ֻʾա2ֻʾ3˿ɼ
	 *  - qq				string	ûQQ롣
	 *  - qq_visible		int		ûQQɼΧ0Լɼ1ע˿ɼ2˿ɼ
	 *  - msn				string	ûMSN
	 *  - msn_visible		int		ûMSNɼΧ0Լɼ1ע˿ɼ2˿ɼ
	 *  - url				string	û͵ַ
	 *  - url_visible		int		û͵ַɼΧ0Լɼ1ע˿ɼ2˿ɼ
	 *  - credentials_type	int		֤ͣ1֤2ѧ֤3֤4ա
	 *  - credentials_num	string	֤롣
	 *  - email				string	ûַ
	 *  - email_visible		int		ûַɼΧ0Լɼ1ע˿ɼ2˿ɼ
	 *  - lang				string	԰汾zh_cnġzh_twġ
	 *  - description		string	û70֡
	 * дbirthdayʱԼ
	 *  - ֻʱ1986-00-00ʽ
	 *  - ֻ·ʱ0000-08-00ʽ
	 *  - ֻĳʱ0000-00-28ʽ
	 * @return array
	 */
	function update_profile( $profile )
	{
		return $this->oauth->post( 'account/profile/basic_update',  $profile);
	}


	/**
	 * ýϢ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/profile/edu_update account/profile/edu_update}
	 * 
	 * @access public
	 * @param array $edu_update Ҫ޸ĵѧУϢʽarray('key1'=>'value1', 'key2'=>'value2', .....)
	 * ֧õ
	 *  - type			int		ѧУͣ1ѧ2С3רУ4С5СѧĬΪ1
	 *  - school_id	`	int		ѧУ룬
	 *  - id			string	Ҫ޸ĵĽϢIDΪ½Ϊ¡
	 *  - year			int		ѧݣСΪ1900󲻳ǰ
	 *  - department	string	Ժϵ߰
	 *  - visible		int		ŵȼ0Լɼ1ע˿ɼ2˿ɼ
	 * @return array
	 */
	function edu_update( $edu_update )
	{
		return $this->oauth->post( 'account/profile/edu_update',  $edu_update);
	}

	/**
	 * ѧУIDɾûĽϢ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/profile/edu_destroy account/profile/edu_destroy}
	 * 
	 * @param int $id ϢѧУID
	 * @return array
	 */
	function edu_destroy( $id )
	{
		$this->id_format( $id );
		$params = array();
		$params['id'] = $id;
		return $this->oauth->post( 'account/profile/edu_destroy', $params);
	}

	/**
	 * ְҵϢ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/profile/car_update account/profile/car_update}
	 * 
	 * @param array $car_update Ҫ޸ĵְҵϢʽarray('key1'=>'value1', 'key2'=>'value2', .....)
	 * ֧õ
	 *  - id			string	ҪµְҵϢID
	 *  - start			int		빫˾ݣСΪ1900Ϊݡ
	 *  - end			int		뿪˾ݣ0
	 *  - department	string	š
	 *  - visible		int		ɼΧ0Լɼ1ע˿ɼ2˿ɼ
	 *  - province		int		ʡݴIDΪֵ
	 *  - city			int		дIDΪֵ
	 *  - company		string	˾ƣΪֵ
	 * provincecity߱ѡһ<br />
	 * idΪգΪ½ְҵϢcompanyΪidǿգΪ£companyѡ
	 * @return array
	 */
	function car_update( $car_update )
	{
		return $this->oauth->post( 'account/profile/car_update', $car_update);
	}

	/**
	 * ݹ˾IDɾûְҵϢ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/profile/car_destroy account/profile/car_destroy}
	 * 
	 * @access public
	 * @param int $id  ְҵϢĹ˾ID
	 * @return array
	 */
	function car_destroy( $id )
	{
		$this->id_format($id);
		$params = array();
		$params['id'] = $id;
		return $this->oauth->post( 'account/profile/car_destroy', $params);
	}

	/**
	 * ͷ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/avatar/upload account/avatar/upload}
	 *
	 * @param string $image_path Ҫϴͷ·, ֧url[ֻ֧png/jpg/gifָʽ, Ӹʽ޸get_image_mime] ΪС700KЧGIF, JPGͼƬ. ͼƬ500ؽš
	 * @return array
	 */
	function update_profile_image( $image_path )
	{
		$params = array();
		$params['image'] = "@{$image_path}";

		return $this->oauth->post('account/avatar/upload', $params);
	}

	/**
	 * ˽Ϣ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/account/update_privacy account/update_privacy}
	 * 
	 * @param array $privacy_settings Ҫ޸ĵ˽áʽarray('key1'=>'value1', 'key2'=>'value2', .....)
	 * ֧õ
	 *  - comment	int	Ƿҵ΢0ˡ1עˣĬΪ0
	 *  - geo		int	ǷϢ01ĬΪ1
	 *  - message	int	ǷԸҷ˽ţ0ˡ1עˣĬΪ0
	 *  - realname	int	Ƿͨң0ԡ1ԣĬΪ0
	 *  - badge		int	ѫǷɼ0ɼ1ɼĬΪ1
	 *  - mobile	int	Ƿֻͨң0ԡ1ԣĬΪ0
	 * ϲȫѡ
	 * @return array
	 */
	function update_privacy( $privacy_settings )
	{
		return $this->oauth->post( 'account/update_privacy', $privacy_settings);
	}


	/**
	 * ȡǰûղб
	 *
	 * ûķ20ղϢûղҳ淵һµġ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/favorites favorites}
	 * 
	 * @access public
	 * @param  int $page ؽҳ룬ĬΪ1
	 * @param  int $count ҳصļ¼ĬΪ50
	 * @return array
	 */
	function get_favorites( $page = 1, $count = 50 )
	{
		$params = array();
		$params['page'] = intval($page);
		$params['count'] = intval($count);

		return $this->oauth->get( 'favorites', $params );
	}


	/**
	 * ղIDȡָղϢ
	 *
	 * ղIDȡָղϢ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/favorites/show favorites/show}
	 * 
	 * @access public
	 * @param int $id ҪѯղID
	 * @return array
	 */
	function favorites_show( $id )
	{
		$params = array();
		$this->id_format($id);
		$params['id'] = $id;
		return $this->oauth->get( 'favorites/show', $params );
	}


	/**
	 * ݱǩȡǰ¼ûñǩµղб
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/favorites/by_tags favorites/by_tags}
	 *
	 * 
	 * @param int $tid  ҪѯıǩID'
	 * @param int $count ҳصļ¼ĬΪ50
	 * @param int $page ؽҳ룬ĬΪ1
	 * @return array
	 */
	function favorites_by_tags( $tid, $page = 1, $count = 50)
	{
		$params = array();
		$params['tid'] = $tid;
		$params['count'] = $count;
		$params['page'] = $page;
		return $this->oauth->get( 'favorites/by_tags', $params );
	}


	/**
	 * ȡǰ¼ûղرǩб
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/favorites/tags favorites/tags}
	 * 
	 * @access public
	 * @param int $count ҳصļ¼ĬΪ50
	 * @param int $page ؽҳ룬ĬΪ1
	 * @return array
	 */
	function favorites_tags( $page = 1, $count = 50)
	{
		$params = array();
		$params['count'] = $count;
		$params['page'] = $page;
		return $this->oauth->get( 'favorites/tags', $params );
	}


	/**
	 * ղһ΢Ϣ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/favorites/create favorites/create}
	 * 
	 * @access public
	 * @param int $sid ղص΢id
	 * @return array
	 */
	function add_to_favorites( $sid )
	{
		$this->id_format($sid);
		$params = array();
		$params['id'] = $sid;

		return $this->oauth->post( 'favorites/create', $params );
	}

	/**
	 * ɾ΢ղء
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/favorites/destroy favorites/destroy}
	 * 
	 * @access public
	 * @param int $id Ҫɾղ΢ϢID.
	 * @return array
	 */
	function remove_from_favorites( $id )
	{
		$this->id_format($id);
		$params = array();
		$params['id'] = $id;
		return $this->oauth->post( 'favorites/destroy', $params);
	}


	/**
	 * ɾ΢ղء
	 *
	 * ɾǰ¼ûղء쳣ʱHTTP400
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/favorites/destroy_batch favorites/destroy_batch}
	 * 
	 * @access public
	 * @param mixed $fids ɾһ˽IDðǶŸһIDɵ顣20磺"231101027525486630,201100826122315375"array(231101027525486630,201100826122315375);
	 * @return array
	 */
	function remove_from_favorites_batch( $fids )
	{
		$params = array();
		if (is_array($fids) && !empty($fids)) {
			foreach ($fids as $k => $v) {
				$this->id_format($fids[$k]);
			}
			$params['ids'] = join(',', $fids);
		} else {
			$params['ids'] = $fids;
		}

		return $this->oauth->post( 'favorites/destroy_batch', $params);
	}


	/**
	 * һղصղرǩ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/favorites/tags/update favorites/tags/update}
	 * 
	 * @access public
	 * @param int $id ҪµղID
	 * @param string $tags ҪµıǩݣðǶŷָ಻2
	 * @return array
	 */
	function favorites_tags_update( $id,  $tags )
	{
		$params = array();
		$params['id'] = $id;
		if (is_array($tags) && !empty($tags)) {
			foreach ($tags as $k => $v) {
				$this->id_format($tags[$k]);
			}
			$params['tags'] = join(',', $tags);
		} else {
			$params['tags'] = $tags;
		}
		return $this->oauth->post( 'favorites/tags/update', $params );
	}

	/**
	 * µǰ¼ûղµָǩ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/favorites/tags/update_batch favorites/tags/update_batch}
	 *
	 * @param int $tid  ҪµıǩID
	 * @param string $tag  Ҫµıǩݡ
	 * @return array
	 */
	function favorites_update_batch( $tid, $tag )
	{
		$params = array();
		$params['tid'] = $tid;
		$params['tag'] = $tag;
		return $this->oauth->post( 'favorites/tags/update_batch', $params);
	}

	/**
	 * ɾǰ¼ûղµָǩ
	 *
	 * ɾǩ󣬸ûղУ˸ñǩղؾñǩĹϵ
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/favorites/tags/destroy_batch favorites/tags/destroy_batch}
	 *
	 * @param int $tid  ҪµıǩID
	 * @return array
	 */
	function favorites_tags_destroy_batch( $tid )
	{
		$params = array();
		$params['tid'] = $tid;
		return $this->oauth->post( 'favorites/tags/destroy_batch', $params);
	}

	/**
	 * ȡĳûĻ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/trends trends}
	 * 
	 * @param int $uid ѯûIDĬΪǰûѡ
	 * @param int $page ָؽҳ롣ѡ
	 * @param int $count ҳСȱʡֵ10ѡ
	 * @return array
	 */
	function get_trends( $uid = NULL, $page = 1, $count = 10 )
	{
		$params = array();
		if ($uid) {
			$params['uid'] = $uid;
		} else {
			$user_info = $this->get_uid();
			$params['uid'] = $user_info['uid'];
		}
		$this->id_format( $params['uid'] );
		$params['page'] = $page;
		$params['count'] = $count;
		return $this->oauth->get( 'trends', $params );
	}


	/**
	 * жϵǰûǷעĳ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/trends/is_follow trends/is_follow}
	 * 
	 * @access public
	 * @param string $trend_name ؼ֡
	 * @return array
	 */
	function trends_is_follow( $trend_name )
	{
		$params = array();
		$params['trend_name'] = $trend_name;
		return $this->oauth->get( 'trends/is_follow', $params );
	}

	/**
	 * һСʱڵŻ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/trends/hourly trends/hourly}
	 * 
	 * @param  int $base_app ǷڵǰӦȡݡ1ʾڵǰӦȡݣĬΪ0ѡ
	 * @return array
	 */
	function hourly_trends( $base_app = 0 )
	{
		$params = array();
		$params['base_app'] = $base_app;

		return $this->oauth->get( 'trends/hourly', $params );
	}

	/**
	 * һڵŻ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/trends/daily trends/daily}
	 * 
	 * @param int $base_app ǷڵǰӦȡݡ1ʾڵǰӦȡݣĬΪ0ѡ
	 * @return array
	 */
	function daily_trends( $base_app = 0 )
	{
		$params = array();
		$params['base_app'] = $base_app;

		return $this->oauth->get( 'trends/daily', $params );
	}

	/**
	 * һڵŻ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/trends/weekly trends/weekly}
	 * 
	 * @access public
	 * @param int $base_app ǷڵǰӦȡݡ1ʾڵǰӦȡݣĬΪ0ѡ
	 * @return array
	 */
	function weekly_trends( $base_app = 0 )
	{
		$params = array();
		$params['base_app'] = $base_app;

		return $this->oauth->get( 'trends/weekly', $params );
	}

	/**
	 * עĳ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/trends/follow trends/follow}
	 * 
	 * @access public
	 * @param string $trend_name ҪעĻؼʡ
	 * @return array
	 */
	function follow_trends( $trend_name )
	{
		$params = array();
		$params['trend_name'] = $trend_name;
		return $this->oauth->post( 'trends/follow', $params );
	}

	/**
	 * ȡĳĹע
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/trends/destroy trends/destroy}
	 * 
	 * @access public
	 * @param int $tid ҪȡעĻID
	 * @return array
	 */
	function unfollow_trends( $tid )
	{
		$this->id_format($tid);

		$params = array();
		$params['trend_id'] = $tid;

		return $this->oauth->post( 'trends/destroy', $params );
	}

	/**
	 * ָûıǩб
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/tags tags}
	 * 
	 * @param int $uid ѯûIDĬΪǰûѡ
	 * @param int $page ָؽҳ롣ѡ
	 * @param int $count ҳСȱʡֵ20ֵ200ѡ
	 * @return array
	 */
	function get_tags( $uid = NULL, $page = 1, $count = 20 )
	{
		$params = array();
		if ( $uid ) {
			$params['uid'] = $uid;
		} else {
			$user_info = $this->get_uid();
			$params['uid'] = $user_info['uid'];
		}
		$this->id_format( $params['uid'] );
		$params['page'] = $page;
		$params['count'] = $count;
		return $this->oauth->get( 'tags', $params );
	}

	/**
	 * ȡûıǩб
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/tags/tags_batch tags/tags_batch}
	 * 
	 * @param  string $uids ҪȡǩûID20ŷָ
	 * @return array
	 */
	function get_tags_batch( $uids )
	{
		$params = array();
		if (is_array( $uids ) && !empty( $uids )) {
			foreach ($uids as $k => $v) {
				$this->id_format( $uids[$k] );
			}
			$params['uids'] = join(',', $uids);
		} else {
			$params['uids'] = $uids;
		}
		return $this->oauth->get( 'tags/tags_batch', $params );
	}

	/**
	 * ûȤıǩ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/tags/suggestions tags/suggestions}
	 * 
	 * @access public
	 * @param int $count ҳСȱʡֵ10ֵ10ѡ
	 * @return array
	 */
	function get_suggest_tags( $count = 10)
	{
		$params = array();
		$params['count'] = intval($count);
		return $this->oauth->get( 'tags/suggestions', $params );
	}

	/**
	 * Ϊǰ¼ûµûǩ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/tags/create tags/create}
	 * 
	 * @access public
	 * @param mixed $tags ҪһǩÿǩĳȲɳ7֣14ַǩ֮öżɶǩɵ顣磺"abc,drf,efgh,tt"array("abc", "drf", "efgh", "tt")
	 * @return array
	 */
	function add_tags( $tags )
	{
		$params = array();
		if (is_array($tags) && !empty($tags)) {
			$params['tags'] = join(',', $tags);
		} else {
			$params['tags'] = $tags;
		}
		return $this->oauth->post( 'tags/create', $params);
	}

	/**
	 * ɾǩ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/tags/destroy tags/destroy}
	 * 
	 * @access public
	 * @param int $tag_id ǩID
	 * @return array
	 */
	function delete_tag( $tag_id )
	{
		$params = array();
		$params['tag_id'] = $tag_id;
		return $this->oauth->post( 'tags/destroy', $params );
	}

	/**
	 * ɾǩ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/tags/destroy_batch tags/destroy_batch}
	 * 
	 * @access public
	 * @param mixed $ids ѡҪɾtag ididðǶŷָ10ɶtag idɵ顣磺553,554,555"array(553, 554, 555)
	 * @return array
	 */
	function delete_tags( $ids )
	{
		$params = array();
		if (is_array($ids) && !empty($ids)) {
			$params['ids'] = join(',', $ids);
		} else {
			$params['ids'] = $ids;
		}
		return $this->oauth->post( 'tags/destroy_batch', $params );
	}


	/**
	 * ֤ǳǷã轨ǳ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/register/verify_nickname register/verify_nickname}
	 *
	 * @param string $nickname Ҫ֤ǳơ4-20ַ֧Ӣġ֡"_"š
	 * @return array
	 */
	function verify_nickname( $nickname )
	{
		$params = array();
		$params['nickname'] = $nickname;
		return $this->oauth->get( 'register/verify_nickname', $params );
	}



	/**
	 * ûʱ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/search/suggestions/users search/suggestions/users}
	 *
	 * @param string $q Ĺؼ֣URLencoding,мòҪֿո
	 * @param int $count صļ¼ĬΪ10
	 * @return array
	 */
	function search_users( $q,  $count = 10 )
	{
		$params = array();
		$params['q'] = $q;
		$params['count'] = $count;
		return $this->oauth->get( 'search/suggestions/users',  $params );
	}


	/**
	 * ΢ʱ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/search/suggestions/statuses search/suggestions/statuses}
	 *
	 * @param string $q Ĺؼ֣URLencoding
	 * @param int $count صļ¼ĬΪ10
	 * @return array
	 */
	function search_statuses( $q,  $count = 10)
	{
		$params = array();
		$params['q'] = $q;
		$params['count'] = $count;
		return $this->oauth->get( 'search/suggestions/statuses', $params );
	}


	/**
	 * ѧУʱ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/search/suggestions/schools search/suggestions/schools}
	 *
	 * @param string $q Ĺؼ֣URLencoding
	 * @param int $count صļ¼ĬΪ10
	 * @param int type ѧУͣ0ȫ1ѧ2С3רУ4С5СѧĬΪ0ѡ
	 * @return array
	 */
	function search_schools( $q,  $count = 10,  $type = 1)
	{
		$params = array();
		$params['q'] = $q;
		$params['count'] = $count;
		$params['type'] = $type;
		return $this->oauth->get( 'search/suggestions/schools', $params );
	}

	/**
	 * ˾ʱ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/search/suggestions/companies search/suggestions/companies}
	 *
	 * @param string $q Ĺؼ֣URLencoding
	 * @param int $count صļ¼ĬΪ10
	 * @return array
	 */
	function search_companies( $q, $count = 10)
	{
		$params = array();
		$params['q'] = $q;
		$params['count'] = $count;
		return $this->oauth->get( 'search/suggestions/companies', $params );
	}


	/**
	 * ûʱ뽨
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/search/suggestions/at_users search/suggestions/at_users}
	 *
	 * @param string $q Ĺؼ֣URLencoding
	 * @param int $count صļ¼ĬΪ10
	 * @param int $type ͣ0ע1˿
	 * @param int $range 뷶Χ0ֻעˡ1ֻע˵ıע2ȫĬΪ2ѡ
	 * @return array
	 */
	function search_at_users( $q, $count = 10, $type=0, $range = 2)
	{
		$params = array();
		$params['q'] = $q;
		$params['count'] = $count;
		$params['type'] = $type;
		$params['range'] = $range;
		return $this->oauth->get( 'search/suggestions/at_users', $params );
	}


	


	/**
	 * ָһƥ΢
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/search/statuses search/statuses}
	 *
	 * @param array $query ѡʽarray('key0'=>'value0', 'key1'=>'value1', ....)ֵ֧key:
	 *  - q				string	Ĺؼ֣URLencode
	 *  - filter_ori	int		ǷΪԭ0ȫ1ԭ2תĬΪ0
	 *  - filter_pic	int		ǷͼƬ0ȫ12ĬΪ0
	 *  - fuid			int		΢ߵûUID
	 *  - province		int		ʡݷΧʡID
	 *  - city			int		ĳзΧID
	 *  - starttime		int		ʼʱ䣬Unixʱ
	 *  - endtime		int		ʱ䣬Unixʱ
	 *  - count			int		ҳصļ¼ĬΪ10
	 *  - page			int		ؽҳ룬ĬΪ1
	 *  - needcount		boolean	ؽǷؼ¼trueءfalseأĬΪfalse
	 *  - base_app		int		ǷֻȡǰӦõݡ0Ϊݣ1ΪǣǰӦãĬΪ0
	 * needcountͬᵼӦķֵṹͬ
	 * ϲȫѡ
	 * @return array
	 */
	function search_statuses_high( $query )
	{
		return $this->oauth->get( 'search/statuses', $query );
	}



	/**
	 * ͨؼû
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/search/users search/users}
	 *
	 * @param array $query ѡʽarray('key0'=>'value0', 'key1'=>'value1', ....)ֵ֧key:
	 *  - q			string	Ĺؼ֣URLencode
	 *  - snick		int		ΧǷǳƣ01
	 *  - sdomain	int		ΧǷ01
	 *  - sintro	int		ΧǷ飬01
	 *  - stag		int		ΧǷǩ01
	 *  - province	int		ʡݷΧʡID
	 *  - city		int		ĳзΧID
	 *  - gender	string	ԱΧmСfŮ
	 *  - comorsch	string	Ĺ˾ѧУơ
	 *  - sort		int		ʽ1ʱ䡢2˿ĬΪ1
	 *  - count		int		ҳصļ¼ĬΪ10
	 *  - page		int		ؽҳ룬ĬΪ1
	 *  - base_app	int		ǷֻȡǰӦõݡ0Ϊݣ1ΪǣǰӦãĬΪ0
	 * вȫѡ
	 * @return array
	 */
	function search_users_keywords( $query )
	{
		return $this->oauth->get( 'search/users', $query );
	}



	/**
	 * ȡϵͳƼû
	 *
	 * ϵͳƼûб
	 * <br />ӦAPI{@link http://open.weibo.com/wiki/2/suggestions/users/hot suggestions/users/hot}
	 * 
	 * @access public
	 * @param string $category ࣬ѡĳһƼûĬΪ default·Уؿб<br />
	 *  - default:ע
	 *  - ent:Ӱ
	 *  - hk_famous:̨
	 *  - model:ģ
	 *  - cooking:ʳ&
	 *  - sport:
	 *  - finance:̽
	 *  - tech:IT
	 *  - singer:
	 *  - writer
	 *  - moderator:
	 *  - medium:ýܱ
	 *  - stockplayer:ɸ
	 * @return array
	 */
	function hot_users( $category = "default" )
	{
		$params = array();
		$params['category'] = $category;

		return $this->oauth->get( 'suggestions/users/hot', $params );
	}

	/**
	 * ȡûܸȤ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/suggestions/users/may_interested suggestions/users/may_interested}
	 * 
	 * @access public
	 * @param int $page ؽҳ룬ĬΪ1
	 * @param int $count ҳصļ¼ĬΪ10
	 * @return array
	 * @ignore
	 */
	function suggestions_may_interested( $page = 1, $count = 10 )
	{   
		$params = array();
		$params['page'] = $page;
		$params['count'] = $count;
		return $this->oauth->get( 'suggestions/users/may_interested', $params);
	}

	/**
	 * һ΢Ƽ΢û 
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/suggestions/users/by_status suggestions/users/by_status}
	 * 
	 * @access public
	 * @param string $content ΢ݡ
	 * @param int $num ؽĿĬΪ10
	 * @return array
	 */
	function suggestions_users_by_status( $content, $num = 10 )
	{
		$params = array();
		$params['content'] = $content;
		$params['num'] = $num;
		return $this->oauth->get( 'suggestions/users/by_status', $params);
	}

	/**
	 * ղ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/suggestions/favorites/hot suggestions/favorites/hot}
	 *
	 * @param int $count ÿҳؽĬ20ѡ
	 * @param int $page ҳ룬Ĭ1ѡ
	 * @return array
	 */
	function hot_favorites( $page = 1, $count = 20 )
	{
		$params = array();
		$params['count'] = $count;
		$params['page'] = $page;
		return $this->oauth->get( 'suggestions/favorites/hot', $params);
	}

	/**
	 * ĳ˱ʶΪȤ
	 *
	 * ӦAPI{@link http://open.weibo.com/wiki/2/suggestions/users/not_interested suggestions/users/not_interested}
	 *
	 * @param int $uid ȤûUID
	 * @return array
	 */
	function put_users_not_interested( $uid )
	{
		$params = array();
		$params['uid'] = $uid;
		return $this->oauth->post( 'suggestions/users/not_interested', $params);
	}



	// =========================================

	/**
	 * @ignore
	 */
	protected function request_with_pager( $url, $page = false, $count = false, $params = array() )
	{
		if( $page ) $params['page'] = $page;
		if( $count ) $params['count'] = $count;

		return $this->oauth->get($url, $params );
	}

	/**
	 * @ignore
	 */
	protected function request_with_uid( $url, $uid_or_name, $page = false, $count = false, $cursor = false, $post = false, $params = array())
	{
		if( $page ) $params['page'] = $page;
		if( $count ) $params['count'] = $count;
		if( $cursor )$params['cursor'] =  $cursor;

		if( $post ) $method = 'post';
		else $method = 'get';

		if ( $uid_or_name !== NULL ) {
			$this->id_format($uid_or_name);
			$params['id'] = $uid_or_name;
		}

		return $this->oauth->$method($url, $params );

	}

	/**
	 * @ignore
	 */
	protected function id_format(&$id) {
		if ( is_float($id) ) {
			$id = number_format($id, 0, '', '');
		} elseif ( is_string($id) ) {
			$id = trim($id);
		}
	}

}