﻿/// <reference path="../plugs/jquery-1.7.2.js" />

var UserClass = function () {
    var me = this;
    var pbs = {
        callback: [],
        currentCallback: function () {

        },
        init: function () {
            Jade.ajax("UserServer", "GetCurrentUser", { childSpace: "" }, function (d) {
                if (d && !d.exception) {
                    Easy.apply(me, d);
                }
                if (me.callback != null) {
                    Easy.each(me.callback, function (fn, i) {
                        if (Easy.isFunction(fn)) {
                            fn.call(me, d);
                        }
                    });
                }
            });
            pbs.initLoginEvent();
        },
        getHead: function () {
            if (me.UPic) {
                return Jade.imgUrl + me.UPic;
            } else {
                return Jade.imgUrl + "/nopic/head.jpg";
            }
        },
        register: function (fn) {
            me.callback.push(fn);
        },
        isLogin: function (fn) {
            if (me.USERID > 0) {
                fn();
            } else {
                me.currentCallback = fn;
                if ($(".right-login").length > 0) { return false; }
                $.get("/htmltpl/login.html", {}, function (d) {
                    $("body").append(d.toString());
                })
            }
        },
        initLoginEvent: function () {
            $(document).on("click", ".prv-img", function () {
                $(".right-login").remove();
            });
            $(document).on("click", ".right-login .loginbot", function () {
                $(".right-login .error").text("");
                var vs = {};
                vs.name = $(".right-login .name").val();
                vs.pwd = $(".right-login .password").val();
                if (vs.name == "" || vs.pwd == "") {
                    $(".right-login .error").text("用户名或密码不能为空.");
                    return false;
                }
                Jade.ajax("UserServer", "Login", vs, function (d) {
                    if (d && !d.exception) {
                        Jade.User.init();
                        $(".right-login").remove();
                        me.currentCallback();
                    } else {
                        $(".right-login .error").text(d.errors);
                    }
                });
            });
        }
    };
    Easy.apply(me, pbs);

    return me;
}

//当前用户信息
Jade.User = new UserClass();

Easy.ready(function () {
    Jade.User.init();
});