﻿Jade.Validation = Jade.V = {
    version: "1.0.3",
    /*
    * 验证激活方式
    */
    mode: "blur",
    /*
    * 验证信息显示样式
    */
    type: 0,
    typeCss: ["j-v-under", "j-v-after", "j-v-float", "j-v-icon"],
    css: {
        info: "j-v-info",
        error: "j-v-error",
        success: "j-v-success",
        loading: "j-v-loading"
    },
    regExp: {
        //不能为空
        w: {
            reg: /[\w\W]+/,
            text: '不能为空!'
        },
        //字符串（字母+数字）
        s: {
            reg: /^[0-9a-zA-Z]+/,
            text: "只能输入字母和数字!"
        },
        //邮箱
        e: {
            reg: /^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/i,
            text: "邮箱格式不正确!"
        },
        //手机
        m: {
            reg: /^13[0-9]{9}$|14[0-9]{9}|15[0-9]{9}$|18[0-9]{9}$|17[0-9]{9}$/,
            text: "手机号码格式不正确!"
        },
        //座机
        t: {
            reg: /^((0[0-9]{2,3})-)([0-9]{7,8})(-([0-9]{3,}))?$/,
            text: "电话号码格式不正确!"
        },
        //邮编
        p: {
            reg: /^[0-9]{6}$/,
            text: "邮编格式不正确!"
        },
        //QQ
        q: {
            reg: /^[1-9][0-9]{4,}$/,
            text: "QQ号码格式不正确!"
        },
        //数字
        n: {
            reg: /^[0-9]+\.?[0-9]*$/,
            text: "只能输入数字!"
        },
        //整数
        i: {
            reg: /[+-]\.?[0-9]+/,
            text: "只能输入整数"
        },
        //浮点数
        f: {
            reg: /^([\d]+|([\d]+[.]?|[\d]+[.]?[\d]+))$/,
            text: "只能输入数字"
        },
        //时间
        time: {
            reg: /^([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$/img,
            text: "时间格式不对,格式为 HH:mm:ss"
        },
        //日期
        date: {
            reg: /^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)(\s+([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?$/img,
            text: "日期格式不对,格式为:yyyy-MM-dd HH:mm:ss"
        },
        //中文
        c: {
            reg: /^[\u4E00-\u9FA5\uf900-\ufa2d]+$/,
            text: "只能输入中文!"
        },
        //昵称限制中文、英文、数字、_、
        nick: {
            reg: /^[0-9a-zA-Z\u4e00-\u9fa5]+[0-9a-zA-Z\u4e00-\u9fa5\u2669-\u266f_-]*$/i,
            text: "只能输入中文、英文、数字和下划线(_)!"
        },
        //url
        u: {
            reg: /^http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\’:+!]*([^<>\"])*$/,
            text: "URL格式不正确!"
        },
        //身份证号码
        idc: {
            reg: /^(\d{6})(18|19|20)?(\d{2})([01]\d)([0123]\d)(\d{3})(\d|X)?$/,
            text: "身份证号码格式不正确"
        }
    },
    /**
    * 设置提示信息显示格式
    */
    setType: function () {
        var me = this, b = Easy.getBody();
        Easy.each(me.typeCss, function (c) {
            Easy.DOM.removeClass(b, c);
        });
        Easy.DOM.addClass(b, me.typeCss[me.type]);
    },
    /**
    * 注册样子规则
    * @param name datatype 名称
    * @param reg 正则表达式
    * @param text 验资不通过提示信息
    * @param isover 是否覆盖原有的
    */
    registe: function (name, reg, text, isover) {
        var me = this;
        if (me.regExp[name]) {
            if (isover) {
                me.regExp[name] = { reg: reg, text: text };
            }
        } else {
            me.regExp[name] = { reg: reg, text: text };
        }
    },
    /**
    * 返回正则表达式
    * @param vt 类型
    */
    getReg: function (vt) {
        var me = this, regx = null,
		lenReg = /(\d+)-(\d+)/,    //字符长度
        strLenReg = /\*(\d+)-(\d+)/,    //字符长度
        chLenReg = /c(\d+)-(\d+)/,      //中文长度
        numLenReg = /n(\d+)-(\d+)/,    //数字长度                    
        unameLenReg = /u(\d+)-(\d+)/;  //用户名 

        if (strLenReg.test(vt)) {  //限定长度以内的任意字符
            var g = strLenReg.exec(vt);
            eval("regx = {reg:/^[\\w\\W]{" + g[1] + "," + g[2] + "}$/,text:'请输入" + (g[1] == g[2] ? g[1] : (g[1] + "到" + g[2])) + "个任意字符!'}");
        } else if (chLenReg.test(vt)) { //限定长度以内的中文字符
            var g = chLenReg.exec(vt);
            eval("regx = {reg:/^[\\u4E00-\\u9FA5\\uf900-\\ufa2d]{" + g[1] + "," + g[2] + "}$/,text:'请输入" + (g[1] == g[2] ? g[1] : (g[1] + "到" + g[2])) + "个中文字符!'}");
        } else if (numLenReg.test(vt)) {    //限定长度以内的整数
            var g = numLenReg.exec(vt);
            eval("regx = {reg:/^\\d{" + g[1] + "," + g[2] + "}$/,text:'请输入" + (g[1] == g[2] ? g[1] : (g[1] + "到" + g[2])) + "个数字!'}");
        } else if (unameLenReg.test(vt)) { //用户名
            var g = unameLenReg.exec(vt);
            eval("regx = {reg:/^\[a-zA-Z0-9._]{" + g[1] + "," + g[2] + "}$/,text:'请输入" + (g[1] == g[2] ? g[1] : (g[1] + "到" + g[2])) + "个字母或数字!'}");
        } else if (lenReg.test(vt)) {
            var g = lenReg.exec(vt);
            eval("regx = {reg:/^[\\w\\W]{" + g[1] + "," + g[2] + "}$/,text:'请输入" + (g[1] == g[2] ? g[1] : (g[1] + "到" + g[2])) + "个任意字符!'}");
        }
        else {
            vt = vt == "*" ? "w" : vt.replace('*', '');
            regx = me.regExp[vt];
        }
        return regx;
    },
    /*
    * 初始化验证
    */
    init: function (dom) {
        var me = this;
        me.setType();
        var ips = dom.getElementsByTagName("input");
        var area = dom.getElementsByTagName("textarea");
        var sels = dom.getElementsByTagName("select");
        Easy.each(ips, function (p, i) {
            var hid = Easy.DOM.getAttribute(p, "hideid");
            if (hid) {
                var hp = Easy.get(hid);
                if (Easy.DOM.getAttribute(hp, "datatype")) {
                    me.required(p);
                    Easy.on(p, me.mode, function (p, e) {
                        me.valid(hp, e, 1, p);
                    });
                }
            } else {
                if (Easy.DOM.getAttribute(p, "datatype")) {
                    me.required(p);
                    Easy.on(p, me.mode, function (p, e) {
                        me.valid(p, e, 1);
                    });
                }
            }
            me.makeInfo(p);

        });
        Easy.each(area, function (p, i) {
            if (Easy.DOM.getAttribute(p, "datatype")) {
                me.required(p);
                Easy.on(p, me.mode, function (p, e) {
                    me.valid(p, e, 2);
                });
            }
            me.makeInfo(p);
        });
        Easy.each(sels, function (p, i) {
            if (Easy.DOM.getAttribute(p, "datatype")) {
                me.required(p);
                Easy.on(p, "change", function (p, e) {
                    me.valid(p, e, 3);
                });
            }
            me.makeInfo(p);
        });
    },
    /*
    * 判断控件是否必填
    * @param dom 要判断的HTML控件
    */
    required: function (dom) {
        var dt = Easy.DOM.getAttribute(dom, "datatype");
        if (dt && dt.indexOf("*") > -1) {
            var lbl = $(dom).parent().find("label");
            if (!lbl.length) {
                lbl = $(dom).parent().parent().find("label");
            }
            if (lbl && lbl.html() && lbl.html().indexOf("<span class=\"x\">") == -1) {
                lbl.html("<span class=\"x\"></span>" + lbl.html());
            }
        }
    },
    /*
    * 执行验证
    * @param p 要验证的HTML控件
    * @param e 触发验证的事件
    * @param t 验证控件类型, 1:input, 2:textarea, 3:select
    * @param refp 要验证的HTML控件对应的显示控件, 如xtype='auto' 该参数就是保存值的控件, p为显示文字的控件
    */
    valid: function (p, e, t, refp) {
        var me = this;
        var reg = Easy.DOM.getAttribute(p, "datatype");
        var v = p.value, errmsg = Easy.DOM.getAttribute(p, "errmsg"),
		nullText = Easy.DOM.getAttribute(p, "nullText");
        if (reg) {
            if (reg.indexOf(";") > -1) {
                var rgs = reg.split(';');
                var r = true;
                Easy.each(rgs, function (o, i) {
                    if (o.indexOf('|') > -1) {
                        var ar = o.split('|');
                        var bl = false;
                        Easy.each(ar, function (a, j) {
                            bl = bl || me.doValid(a, v, p, t, errmsg, refp);
                        });
                        if (!(bl && r)) {
                            return false;
                        }
                        return Easy.CONFIRM;
                    }
                    r = r && me.doValid(o, v, p, t, errmsg, refp);
                });
                return r;
            } else {
                return me.doValid(reg, v, p, t, errmsg, refp);
            }
        }
        return true;
    },

    /*
    * 执行验证	
    * @param reg 验证规则的名称
    * @param v 从控件中获取到的值,用于验证
    * @param p 要验证的HTML控件
    * @param t 验证控件类型, 1:input, 2:textarea, 3:select, 0:表达提交之前验证
    * @param errmsg 如果是错误时要要显示的错误信息
    * @param refp 要验证的HTML控件对应的显示控件, 如xtype='auto' 该参数就是保存值的控件, p为显示文字的控件
    */
    doValid: function (reg, v, p, t, errmsg, refp) {
        var me = this;
        var ajaxurl = Easy.DOM.getAttribute(p, "ajaxurl");
        //		if (refp) {
        //			p = refp;
        //		}
        if (reg.indexOf("*") > -1 && v == "") {
            me.make(p, errmsg || "不能为空!", t);
            return false;
        } else {
            if (reg == "*") {
                me.clear(p);
                if (v == "") {
                    me.makeInfo(p);
                }
                return true;
            }
            reg = reg.replace(/\*/g, "");
        }
        if (reg.indexOf("=") > -1) {
            reg = reg.substring(1);
            if (v != Easy.get(reg).value) {
                me.make(p, "两次输入的字符不一致", t);
                return false;
            } else {
                me.clear(p);
                if (Easy.DOM.hasClass(Easy.get(reg), me.css.error)) {
                    me.valid(Easy.get(reg), null, t);
                }
                if (Easy.DOM.hasClass(Easy.get(reg), "j-v-error-border")) {
                    me.valid(Easy.get(reg), null, t);
                }
                return true;
            }
        } else {
            if (v) {
                if (reg == "ajax" && v) {
                    if (t == 0) { //表达提交之前验证
                        var v = $(p).attr("valided");
                        return v == "true" || v == undefined;
                    }
                    if (ajaxurl) {
                        var pms = Easy.String.parseQueryString(ajaxurl);
                        if (pms.classname && pms.methodname) {
                            me.makeLoad(p);
                            var vs = Easy.Form.getValues(p.form);
                            Easy.each(vs, function (v1, p) {
                                if (/<[\s\S]*?>/img.test(v1)) {
                                    delete vs[p];
                                }
                            });
                            Jade.ajax(pms.classname, pms.methodname, vs, function (d) {
                                if (d.exception) {
                                    me.make(p, d.message, -10);
                                    return false;
                                } else {
                                    me.clear(p, -10);
                                    return true;
                                }
                            });
                        }
                    }
                }
                else {
                    var rgex = me.getReg(reg);
                    if (!rgex) {
                        rgex = new RegExp(reg);
                    }
                    if (!rgex.reg.test(v)) {
                        me.make(p, errmsg || rgex.text, t);
                        return false;
                    } else {
                        me.clear(p);
                        return true;
                    }
                }
            }
        }
        return true;
    },

    /*
    * 表单提交前验证
    * @param form 要验证的表单
    */
    validForm: function (form) {
        var me = this, el = Easy.Form.getElements(Easy.get(form));
        var isv = true;
        Easy.each(el, function (p, i) {
            var dt = Easy.DOM.getAttribute(p, "datatype");
            var hid = Easy.DOM.getAttribute(p, "hideid");
            var v = p.value;
            if (dt || hid) {
                if (hid) {
                    var hp = Easy.get(hid);
                    dt = Easy.DOM.getAttribute(hp, "datatype");
                    v = hp.value
                }
                if (dt && dt.indexOf("ajax") > -1) {
                    var dreg = dt.replace(";ajax", "");
                    Easy.DOM.setAttribute(p, "datatype", dreg);
                    isv = isv && me.valid(p, null, 0);
                    if (v) {
                        if ($(p).attr("valided") == "true") {
                            isv = isv && true;
                        } else {
                            if ($(p).attr("valided") == "false") {
                                Jade.V.make(p, null, 1);
                                isv = isv && false;
                            } else {
                                isv = isv && true;
                            }
                        }
                    } else {
                        isv = isv && dt.indexOf("*") == -1;
                        if (!isv) {
                            Jade.V.make(p, '不能为空或格式错误!', 1);
                        }
                    }
                    Easy.DOM.setAttribute(p, "datatype", dt);
                    return isv;
                } else {
                    isv = isv && me.valid(p, null, 0);
                    if (!isv) {
                        return false;
                    }
                }
            }
        });
        return isv;
    },
    /*
    * 显示错误信息
    * @param input 验证错误的html控件
    * @param errmsg 错误信息
    * @param t 判断是否为ajax回调时执行, -10 为ajax回调
    */
    make: function (input, errmsg, t) {
        var me = this, $dom = $(input);
        var top = $dom.offset().top;
        var left = $dom.offset().left;
        var width = $dom.width();
        var errorHtml = "<span class='jv j-v-error' " + "style='top:" + top + "px;left:" + (left + width + 10) + "px;' "
							+ "title='" + errmsg + "'>" + (me.type == 2 ? "<i></i>" : "") + (me.type == 3 ? "" : errmsg) + "</span>";
        if (t == -10) {
            $dom.attr("valided", "false");
        }
        if ($(input).is(":radio")) {
            top = $dom.last().offset().top;
            left = $dom.last().offset().left;
            width = $dom.last().width();
            errorHtml = "<span class='jv j-v-error' " + "style='top:" + top + "px;left:" + (left + width + 20) + "px;' "
							+ " title='" + errmsg + "'>" + (me.type == 2 ? "<i></i>" : "") + (me.type == 3 ? "" : errmsg) + "</span>";
            $(input).last().after(errorHtml);
        } else if ($(input).is(":checkbox")) {
            top = $dom.last().offset().top;
            left = $dom.last().offset().left;
            width = $dom.last().width();
            errorHtml = "<span class='jv j-v-error' " + "style='top:" + top + "px;left:" + (left + width + 40) + "px;'"
							+ " title='" + errmsg + "'>" + (me.type == 2 ? "<i></i>" : "") + (me.type == 3 ? "" : errmsg) + "</span>";
            $(input).last().after(errorHtml);
        } else {
            if (!$dom.parent().find("span.jv").length) {
                $dom.addClass(me.css.error + "-border").attr('title', errmsg).after(errorHtml);
            } else {
                $dom.removeClass(me.css.success + "-border").addClass(me.css.error + "-border").attr('title', errmsg);
                $dom.parent().find("span.jv").removeClass(me.css.success).removeClass(me.css.loading)
					.addClass(me.css.error).attr('title', errmsg).html((me.type == 2 ? "<i></i>" : "") + (me.type == 3 ? "" : errmsg));
            }
        }
        if (me.type === 2) {
            $dom.parent().find("span.jv").width(Jade.getTxtInnerWidth("span", errmsg, "jv j-v-error"));
        }
    },
    /*
    * 清除错误信息
    * @param input 清除错误信息的html控件
    * @param t 判断是否为ajax回调时执行, -10 为ajax回调
    */
    clear: function (input, t) {
        var me = this, $dom = $(input);
        var top = $dom.offset().top;
        var left = $dom.offset().left;
        var width = $dom.width();
        var succHtml = "<span class='jv j-v-success' " + "style='top:" + top + "px;left:" + (left + width + 10) + "px;'>" + (me.type == 2 ? "<i></i>通过" : "") + "</span>";
        if (t == -10) {
            $dom.attr("valided", "true");
        }
        if ($dom.is(":radio")) {
            top = $dom.last().offset().top;
            left = $dom.last().offset().left;
            width = $dom.last().width();
            succHtml = "<span class='jv j-v-success' " + "style='top:" + top + "px;left:" + (left + width + 20) + "px;'>" + (me.type == 2 ? "<i></i>通过" : "") + "</span>";
            $dom.last().after(succHtml);
        } else if ($(input).is(":checkbox")) {
            top = $dom.last().offset().top;
            left = $dom.last().offset().left;
            width = $dom.last().width();
            succHtml = "<span class='jv j-v-success' " + "style='top:" + top + "px;left:" + (left + width + 40) + "px; '>" + (me.type == 2 ? "<i></i>通过" : "") + "</span>";
            $dom.last().after(succHtml);
        } else {
            if ($dom.parent().find("span.jv").length) {
                $dom.removeClass(me.css.error + "-border").removeAttr('title');
                $dom.parent().find("span.jv").removeClass(me.css.loading)
					.removeClass(me.css.error).addClass(me.css.success).removeAttr('title').html((me.type == 2 ? "<i></i>通过" : ""));
            } else {
                $dom.removeClass(me.css.error + "-border").after(succHtml);
            }
        }
        if (me.type === 2) {
            $dom.parent().find("span.jv").width(Jade.getTxtInnerWidth("span", "通过", "jv j-v-success"));
        }
    },
    /*
    * ajax验证是的等待过程
    * dom input对象
    */
    makeLoad: function (input) {
        var me = this, $dom = $(input);
        var top = $dom.offset().top;
        var left = $dom.offset().left;
        var width = $dom.width();
        var errorHtml = "<span class='jv j-v-loading' " + "style='top:" + top + "px;left:" + (left + width + 10) + "px;'"
								+ " title='正在验证...'>正在验证...</span>";
        if (!$dom.parent().find("span.jv").length) {
            $dom.attr('title', "正在验证...").after(errorHtml);
        } else {
            $dom.attr('title', "正在验证...").parent().find("span.jv")
			.removeClass(me.css.error).removeClass(me.css.success).addClass(me.css.loading).html("正在验证...");
        }
        if (me.type === 2) {
            $dom.parent().find("span.jv").width(Jade.getTxtInnerWidth("span", "正在验证...", "jv j-v-loading"));
        }
    },
    /*
    * 编写提示信息
    * dom input对象
    * msg 要提示的文本
    */
    makeInfo: function (input, msg) {
        msg = msg || Easy.DOM.getAttribute(input, "info");
        if (!msg) {
            return;
        }
        var me = this, $dom = $(input);
        var top = $dom.offset().top;
        var left = $dom.offset().left;
        var width = $dom.width();
        var errorHtml = "<span class='jv j-v-info' " + "style='top:" + top + "px;left:" + (left + width + 10) + "px;'"
								+ " title=\"" + (msg.replace("\"", "“")) + "\">" + msg + "</span>";
        if (!$dom.parent().find("span.jv").length) {
            $dom.attr('title', msg).after(errorHtml);
        } else {
            $dom.attr('title', msg).parent().find("span.jv")
				.removeClass(me.css.error).removeClass(me.css.success).addClass(me.css.info).html(msg);
        }
    }
};
Easy.ready(function () {
    Jade.Validation.init(document);
});