<?php

//引入核心文件
require_once '../common.php';

//后台模板目录
$smarty->template_dir = SITE_DIR.'admin/view';

//模板编译目录
$smarty->compile_dir = SITE_DIR.'cache/compile_A';
//模板缓存目录
$smarty->cache_dir = SITE_DIR.'cache/Tpl_A';

//关闭模板缓存
$smarty->caching = 0;

//显示验证码
if($Action == 'checkcode'){
	$ValidateCode = new ValidateCode();      //实例化一个对象
	$ValidateCode -> doimg();
	$_SESSION['LoginValidateCode'] = $ValidateCode -> getCode();
	exit();
}

//是否登录
if($AdminLogin->CheckLogin()){
	//退出系统
	if($Action == 'logout'){
		$AdminLogin->Logout();
		header("Location: ".WEB_URL."/admin/index.php");
		exit();
	}
	
	//实例化后台操作类
	$AdminControl = new AdminControl();
	
	//绑定用户权限
	$AdminControl->UserPower = $_SESSION['Power'];
	
	//后台操作
	if($Action !== '' && $Action !== 'logout'){
		require_once SITE_DIR.'admin/'.$AdminControl->Action($Action).'.Action.php';
		//后台操作提示信息
		if(isset($AdminShowMessage)){
			//将提示信息赋值给模板
			$smarty->assign('AdminShowMessage', $AdminShowMessage);
			//提示信息页面
			$smarty->assign('AdminPageHTML', 'showmessage.html');
			//显示后台模板
			$smarty->display('index.html');
		}	
		exit();
	}
	
	//位置判断
	if(isset($_GET['location'])){
		$Location = $_GET['location'];
	}
	else{
		$Location = '';
	}
	
	$smarty->assign('DOMAIN', $_SERVER['SERVER_NAME']);		//域名
	$smarty->assign('AUTHORIZATION_CODE', AUTHORIZATION_CODE);		//授权码
	
	//根据位置显示模板
	if($Location == ''){
		$smarty->assign('PHP_OS', PHP_OS);
		$smarty->assign('SERVER_SOFTWARE', $_SERVER ['SERVER_SOFTWARE']);
		$smarty->assign('PHP_VERSION', PHP_VERSION);
		$DataBase->open_db();
		$smarty->assign('mysql_size', $DataBase->CalcFullDatabaseSize($DataBase->dbname, $DataBase->conn));
		$smarty->assign('mysql_version', mysql_get_server_info());
		$DataBase->close_dblink();
		$smarty->assign('upload_max_filesize', ini_get('upload_max_filesize'));
		$AdminPageHTML = 'admin_index.html';		
	}
	else{
		$AdminMenu = $AdminControl->Menu($Location);
		if(is_file(SITE_DIR.'admin/'.$AdminMenu.'.Menu.php')){
			require_once SITE_DIR.'admin/'.$AdminMenu.'.Menu.php';
		}
		$AdminPageHTML = $Location.'.html';
	}
	//将后台页面内容模板文件名称传递给页面主模板
	$smarty->assign('AdminPageHTML', $AdminPageHTML);
	//显示后台模板
	$smarty->display('index.html');
}
else{
	//后台管理登录
	if($Action == 'login'){
		//是否提交表单
		if($AdminLogin->IsPost(array('TxtUserName', 'TxtPassword', 'TxtValidateCode', 'InputKey'), 'Submit')){
			//判断来路
			if($AdminLogin->CheckHttpReferer(array(WEB_URL.'/admin/index.php', WEB_URL.'/admin', WEB_URL.'/admin/')) == true){
				//定义过滤方法
				$AdminLogin->CheckPostFun = array(
					'TxtUserName' => array(array('ToUtf8', 'trimall', 'DeleteHtml', 'strip_tags'), 'CheckAdminUserName'),
					'TxtPassword' => array(array('ToUtf8', 'trimall', 'DeleteHtml', 'strip_tags'), 'CheckAdminPassword'),
					'TxtValidateCode' => array(array('ToUtf8', 'trimall', 'DeleteHtml', 'strip_tags'), 'CheckAdminVcode'),
					'InputKey' => array(array('ToUtf8', 'trimall', 'DeleteHtml', 'strip_tags'), 'CheckInputKey')
				);
				//过滤提交的信息
				if($AdminLogin->CheckPostValue()){
					//过滤后的用户提交的数据
					$UserPostValue = $AdminLogin->Post;
					//判断inputkey
					if($AdminLogin->CheckValue($UserPostValue['InputKey'], $_SESSION['input_key'])){
						if(CheckVCset('login') == true){
							//判断验证码
							if($AdminLogin->CheckValue(strtolower($UserPostValue['TxtValidateCode']), $_SESSION['LoginValidateCode']) == false){
								header("Location: ".WEB_URL."/admin/index.php");	//验证码不对
								exit();
							}
						}
							//连接到MYSQL并打开系统数据库
							$DataBase->open_db();
							//查询用户名
							$DataBase->sel('adminuser', "WHERE `username` = '$UserPostValue[TxtUserName]'");
							//关闭数据库连接
							$DataBase->close_dblink();
							if(count($DataBase->Result) == 1){
								//比对用户密码
								if($AdminLogin->CheckValue(set_password($UserPostValue['TxtPassword'], $DataBase->Result[0]['key']), $DataBase->Result[0]['password'])){
									//销毁inputkey和验证码确保只能使用一次
									$_SESSION['input_key'] = '';
									$_SESSION['ValidateCode'] = '';
									//实例化文件操作类和加密解密类
									$File = new File();
								    $Encry = new Encry();
								    //生成缓存文件目录名
									$userdirname = $Encry->encrypt($DataBase->Result[0]['id'].$DataBase->Result[0]['username'].$DataBase->Result[0]['password'].$DataBase->Result[0]['key'], $DataBase->Result[0]['key']);
									//生成缓存文件名
									$filename = $Encry->encrypt($DataBase->Result[0]['username'], $DataBase->Result[0]['key']);
									//创建缓存文件目录
									$File->CreateDirs('cache/userlogin/'.$userdirname);
									//创建缓存文件
									$File->CreateFile('cache/userlogin/'.$userdirname.'/'.$filename.'.txt');
									//写入缓存文件内容
									$File->ModifyFileContent(up_loginfile());
									//关闭文件
									$File->CloseFile();
									//设置SESSION
									$_SESSION['UserId'] = $DataBase->Result[0]['id'];
									$_SESSION['UserName'] = $DataBase->Result[0]['username'];
									$_SESSION['Password'] = $DataBase->Result[0]['password'];
									$_SESSION['SessionKey'] = $DataBase->Result[0]['key'];
									$_SESSION['Grade'] = $DataBase->Result[0]['grade'];
									$_SESSION['Power'] = $DataBase->Result[0]['power'];
									unset($_SESSION['LoginValidateCode']);
									unset($_SESSION['input_key']);
									header("Location: ".WEB_URL."/admin/index.php");
									exit();
								}
								else{
									header("Location: ".WEB_URL."/admin/index.php");	//密码错误
								}
							}
							else{
								header("Location: ".WEB_URL."/admin/index.php");	//用户名不存在
							}				
					}
					else{
						header("Location: ".WEB_URL."/admin/index.php");	//InputKey不正确
					}
				}
				else{
					header("Location: ".WEB_URL."/admin/index.php");	//提交的数据不合法
				}	
			}
			else{
				header("Location: ".WEB_URL."/admin/index.php");	//来路不正确
			}
			//销毁inputkey和验证码确保只能使用一次
			$_SESSION['input_key'] = '';
			$_SESSION['LoginValidateCode'] = '';
		}
	}	
	//生成input_key
	$_SESSION['input_key'] = generate_rand_string(50);
	//将input_key赋值给模板
	$smarty->assign('InputKey', $_SESSION['input_key']);
	//显示模板
	$smarty->display('login.html');
}

?>