<?php

//后台操作类
class AdminControl extends UserRequest{
	
	private $AdminAction;	//后台操作
	
	private $AdminMenu;	//后台菜单
	
	public $UserPower;	//用户权限
	
	private $BasiActioncPower;	//普通管理员基本操作权限
	
	private $ActionPowerClass;	//普通管理员可选操作权限
	
	private $MenuPowerClass;	//普通管理员可选页面访问权限
	
	//初始化
	function __construct(){
		$this->AdminAction = array(
				'canceltop', 'settop', 'delmsg', 'delselmsg', 'reply', 'edit', 'upsiteinfo', 'upvisit', 'upbest',
				'upmail', 'upsafety', 'upannouncement', 'upnav', 'ckselmsg', 'checkmsg', 'adduser', 'deluser',
				'edituser', 'dbmanage', 'data_import', 'set_pw', 'clearall', 'clearallcheck'
		);
		$this->AdminMenu = array(
				'siteinfo', 'visit', 'best', 'mail', 'safety', 'announcement', 'nav', 'messagecheck', 'recycle',
				'adminuser', 'adduser', 'edituser', 'dbmanage', 'set_pw'
		);
		$this->BasiActioncPower = array('set_pw', 'settop', 'canceltop', 'reply', 'edit', 'delmsg', 'delselmsg', 'checkmsg');
		$this->ActionPowerClass = array(
				'0' => array('upvisit'),
				'1' => array('upnav'),
				'2' => array('upannouncement'),
				'3' => array('ckselmsg', 'checkmsg', 'delmsg', 'delselmsg'),
				'4' => array('clearall', 'clearallcheck', 'ckselmsg', 'checkmsg', 'delmsg', 'delselmsg')
		);
		$this->MenuPowerClass = array(
				'0' => array('visit'),
				'1' => array('nav'),
				'2' => array('announcement'),
				'3' => array('messagecheck'),
				'4' => array('recycle')
		);		
	}
	
	//判断后台操作
	function Action($GetAction){
		$Check = false;
		//判断操作是否有权限
		if($this->UserPower !== 'Administrator'){
			$PowerArr = array();
			$UserPower = explode('-', $this->UserPower);
			foreach ($UserPower as $k => $v){
				if($v == 1){
					foreach ($this->ActionPowerClass[$k] as $p){
						array_push($PowerArr, $p);
					}
				}
			}
			foreach ($this->BasiActioncPower as $bap){
				array_push($PowerArr, $bap);
			}
			$PowerArr = array_unique($PowerArr);	//去除重复
			if(in_array($GetAction, $PowerArr) == false){
				return 'nopower';
				break;
			}	
		}
		//检查操作是否合法
		foreach ($this->AdminAction as $key){
			if($GetAction == $key){
				$Check = true;
				return $key;
				break;
			}
		}
		//如果无权访问则显示'Access Denied'
		if($Check == false){
			echo 'Access Denied';
			exit();
		}		
	}
	
	//后台页面判断
	function Menu($GetLocation){
		$Check = false;
		//判断访问是否有权限
		if($this->UserPower !== 'Administrator'){
			$PowerArr = array();
			$UserPower = explode('-', $this->UserPower);
			foreach ($UserPower as $k => $v){
				if($v == 1){
					foreach ($this->MenuPowerClass[$k] as $p){
						array_push($PowerArr, $p);
					}
				}
			}
			array_push($PowerArr, 'set_pw');
			if(in_array($GetLocation, $PowerArr) == false){
				return 'nopower';
				break;
			}
		}		
		//检查访问是否合法
		foreach ($this->AdminMenu as $key){
			if($GetLocation == $key){
				$Check = true;
				return $key;
				break;
			}
		}
		//如果无权访问则显示'Access Denied'
		if($Check == false){
			echo 'Access Denied';
			exit();
		}		
	}
	
	//-------------------------------
}

?>