<?php

//管理员登录和注销类
class AdminLogin extends UserRequest{
	
	private $UserId;	//管理员ID
	
	private $UserName;	//管理员用户名
	
	private $Password;	//管理员密码
	
	private $SessionKey;	//SESSION秘钥
	
	private $Grade;		//用户等级
	
	private $Power;		//权限
	
	//开启SESSION
	public function open_session(){
		session_start();
	}
	
	//结束SESSION
	public function close_session(){
		$_SESSION = array();
		session_unset();
		session_destroy();		
	}
	
	//判断SESSION是否存在
	private function isset_session(){
		if(isset($_SESSION['UserId']) && isset($_SESSION['UserName']) && isset($_SESSION['Password']) && isset($_SESSION['SessionKey']) && isset($_SESSION['Grade']) && isset($_SESSION['Power'])){
			$this->UserId = $_SESSION['UserId'];
			$this->UserName = $_SESSION['UserName'];
			$this->Password = $_SESSION['Password'];
			$this->SessionKey = $_SESSION['SessionKey'];
			$this->Grade = $_SESSION['Grade'];
			$this->Power = $_SESSION['Power'];
			return true;
		}
		else{
			return false;
		}
	}
	
	//验证是否登录
	public function CheckLogin(){
		if($this->isset_session()){
			if($_SESSION['UserId'] !== '' && $_SESSION['UserName'] !== '' && $_SESSION['Password'] !== '' && $_SESSION['SessionKey'] !== '' && $_SESSION['Grade'] !== '' && $_SESSION['Power'] !== ''){
				$Encry = new Encry();
				$File = new File();
				$dirname = 	$Encry->encrypt($_SESSION['UserId'].$_SESSION['UserName'].$_SESSION['Password'].$_SESSION['SessionKey'], $_SESSION['SessionKey']);			
				$filename = $Encry->encrypt($_SESSION['UserName'], $_SESSION['SessionKey']);
				if(is_dir(SITE_DIR.'cache/userlogin/'.$dirname)){
					if(file_exists(SITE_DIR.'cache/userlogin/'.$dirname.'/'.$filename.'.txt')){
						if(strtotime("now") < $File->ReadFileContent('cache/userlogin/'.$dirname.'/'.$filename.'.txt')){
							$return = true;
						}
						else{
							//登录超时
							$File->CloseFile();
							$this->Logout();
							$return = false;
						}
					}
					else{
						//缓存文件不存在
						$return = false;
					}
				}
				else{
					//缓存目录不存在
					$return = false;
				}
			}
			else{
				//Session不正确
				$return = false;
			}
		}
		else{
			//Session不存在
			$return = false;
		}
		return $return;
	}
	
	//退出登陆
	public function Logout(){
		$Encry = new Encry();
		$File = new File();
		$dirname = 	$Encry->encrypt($_SESSION['UserId'].$_SESSION['UserName'].$_SESSION['Password'].$_SESSION['SessionKey'], $_SESSION['SessionKey']);
		$File->delDirAndFile('cache/userlogin/'.$dirname, true);		
		$_SESSION['UserId'] = '';
		$_SESSION['UserName'] = '';
		$_SESSION['Password'] = '';
		$_SESSION['SessionKey'] = '';
		$_SESSION['Grade'] = '';
		$_SESSION['Power'] = '';
		$this->close_session();
	}
	
	//获取用户名
	public function GetUserName(){
		if($this->CheckLogin()){
			$return = $_SESSION['UserName'];
		}
		else{
			$return = "";
		}
		return $return;
	}
	
	//获取用权限
	public function GetUserPower(){
		if($this->CheckLogin()){
			$return = $_SESSION['Power'];
		}
		else{
			$return = "";
		}
		return $return;
	}	
	
	//---------------------------------
	
}

?>