<?php

//用户请求处理类
class UserRequest{
	
	public $Post;	//用户提交的内容，如果过滤通过，则是过滤后的值
	
	public $ErrorInfo;	//错误信息
	
	public $CheckPostFun;	//验证方法
	
	//数据比对
	/*
	 * $PostValue需要比对的值
	 * $CorrectValue正确的值
	 * $IsNull是否允许为空，默认不允许
	 */
	public function CheckValue($PostValue = '', $CorrectValue = '', $IsNull = false){
		if($IsNull == true){
			if($PostValue == $CorrectValue){
				return true;
			}
			else{
				return false;
			}
		}
		elseif($IsNull == false){
			if($PostValue == '' || $PostValue == null || $CorrectValue == '' || $CorrectValue == null){
				return false;
			}
			else{
				if($PostValue == $CorrectValue){
					return true;
				}
				else{
					return false;
				}
			}
		}
		else{
			return false;
		}
	}
	
	//是否提交表单
	/*
	 * 如果提交则返回提交的所有值
	 * $PostButtonName 表单按钮name
	 * $PostKey 提交的各个表单控件的name
	 */
	public function IsPost($PostKey = array(), $PostButtonName){
		if(isset($_POST[$PostButtonName])){
			$return = true;
			for($i=0; $i<count($PostKey); $i++){
				if(isset($_POST[$PostKey[$i]])){
					$Value[$PostKey[$i]] = $_POST[$PostKey[$i]];
				}
				else{
					$return = false;
					break;
				}
			}
			if($return == true){
				$this->Post = $Value;
			}
			return $return;
		}
		else{
			return false;
		}
	}
	
	//来路判断
	/*
	 * $CorrectReferer正确的来路，可以是字符串，可以是正则表达式，可以是数组，支持多个来路
	 * $pattern判断模式，0普通模式判断是否相等，1正则匹配模式
	 */
	public function CheckHttpReferer($CorrectReferer, $pattern = 0){
		if(isset($_SERVER['HTTP_REFERER'])){
			if($pattern == 0){
				if(is_array($CorrectReferer)){
					if(in_array($_SERVER['HTTP_REFERER'], $CorrectReferer)){
						return true;
					}
					else{
						return false;
					}
				}
				else{
					if($_SERVER['HTTP_REFERER'] == $CorrectReferer){
						return true;
					}
					else{
						return false;
					}
				}
			}
			elseif($pattern == 1){
				if(is_array($CorrectReferer)){
					$return = false;
					foreach($CorrectReferer as $v){
						if(preg_match($v, $_SERVER['HTTP_REFERER']) == 1){
							$return = true;
						}
					}
					return $return;
				}
				else{
					if(preg_match($CorrectReferer, $_SERVER['HTTP_REFERER']) == 1){
						return true;
					}
				}
			}
			else{
				return false;
			}
		}
		else{
			return false;
		}
	}
	
	//判断提交信息的合法性
	/*
	 * $Check = array($PostKey => array($SafetyFun, $CheckFun));
	 * PostKey 表单input名称
	 * SafetyFun 安全过滤函数，可以是数组，支持多个函数
	 * CheckFun 验证函数，可以是数组，支持多个函数，验证通过则返回过滤后的数据，否则返回False，暂不支持带多个参数的函数
	 */
	public function CheckPostValue(){
		$Check = $this->CheckPostFun;
		$PostInfo = $this->Post;
		$ErrorInfo = array();
		foreach($Check as $Key=>$value){
			//安全过滤
			if(is_array($value[0])){
				foreach($value[0] as $SafetyFun){
					//如果是数组则循环过滤
					if(is_array($PostInfo[$Key])){
						foreach ($PostInfo[$Key] as $k => $v){
							$PostInfo[$Key][$k] = $SafetyFun($v);
						}
					}
					else{
						$PostInfo[$Key] = $SafetyFun($PostInfo[$Key]);
					}
				}
			}
			else{
				//如果是数组则循环过滤
				if(is_array($PostInfo[$Key])){
					foreach ($PostInfo[$Key] as $k => $v){
						$PostInfo[$Key][$k] = $value[0]($v);
					}
				}
				else{
					$PostInfo[$Key] = $value[0]($PostInfo[$Key]);
				}
			}
	
			//验证合法性
			if(is_array($value[1])){
				foreach($value[1] as $CheckFun){
					//如果是数组则循环验证
					if(is_array($PostInfo[$Key])){
						foreach ($PostInfo[$Key] as $k => $v){
							if($CheckFun($v) == false){
								if(in_array('['.$Key.']['.$k.']', $ErrorInfo) == false){
									array_push($ErrorInfo, '['.$Key.']['.$k.']');
								}
							}							
						}
					}
					else{
						if($CheckFun($PostInfo[$Key]) == false){
							if(in_array($Key, $ErrorInfo) == false){
								array_push($ErrorInfo, $Key);
							}
						}
					}
				}
			}
			else{
				//如果是数组则循环验证
				if(is_array($PostInfo[$Key])){
					foreach ($PostInfo[$Key] as $k => $v){
						if($value[1]($v) == false){
							if(in_array('['.$Key.']['.$k.']', $ErrorInfo) == false){
								array_push($ErrorInfo, '['.$Key.']['.$k.']');
							}
						}						
					}
				}
				else{
					if($value[1]($PostInfo[$Key]) == false){
						array_push($ErrorInfo, $Key);
					}
				}
			}
		}
		if(count($ErrorInfo) == 0){
			$this->Post = $PostInfo;
			return true;
		}
		else{
			$this->ErrorInfo = $ErrorInfo;
			return false;
		}
	}
	
	//--------------------------------	
}

?>