<?php

//定义系统常量
define("IN_SYSTEM", TRUE);

//定义系统目录常量
define("SITE_DIR", dirname(__FILE__).'/');

//检测是否安装
if(is_dir('install') == true){
	if(file_exists('install/install.locked') == false){
		header("Location: install/index.php");
		exit();
	}
}

//引入数据库配置文件
require_once SITE_DIR.'config.php';

//引入Smarty模板引擎
require_once SITE_DIR.'include/smarty/Smarty.class.php';

//载入所有类
$ClassDir = SITE_DIR.'class/';
$ClassFileList = scandir($ClassDir);
$ClassFileNum = count($ClassFileList);
for($i = 2; $i<$ClassFileNum; $i++){
	if($ClassFileList[$i] !== 'index.html'){
		require_once $ClassDir."$ClassFileList[$i]";
	}
}
//自动加载
function __autoload($ClassFileName){
	require_once SITE_DIR.'class/'.$ClassFileName.'.Class.php';
}

//载入所有函数
$FunDir = SITE_DIR.'function/';
$FunFileList = scandir($FunDir);
$FunFileNum = count($FunFileList);
for($i = 2; $i < $FunFileNum; $i++){
	if($FunFileList[$i] !== 'index.html'){
		require_once $FunDir."$FunFileList[$i]";
	}
}

//判断是否手机端浏览
if(isMobile()){
	define("IS_MOBILE", TRUE);
}
else{
	define("IS_MOBILE", FALSE);
}

//分页参数
if(isset($_GET['page'])){
	$page = get_request('page');
}
else{
	$page = 1;
}

//动作参数
if(isset($_GET['action'])){
	$Action = get_request('action');
}
else{
	$Action = '';
}

//销毁变量
unset($ClassDir, $ClassFileList, $ClassFileNum, $FunDir, $FunFileList, $FunFileNum);

//实例化数据库类
$DataBase = new MysqlDb($DbHostAddress, $DbUserName, $DbPassword, $DbName, $DbTabpre);

//连接到MYSQL并打开系统数据库
$DataBase->open_db();
//读取站点配置信息
$DataBase->sel('setting');
$SiteInfo = $DataBase->Result;
//第三方统计代码去除转义
$SiteInfo[6][2] = stripslashes_d($SiteInfo[6][2]);
$SiteInfo[6]['value'] = stripslashes_d($SiteInfo[6]['value']);
//公告内容去除转义
$SiteInfo[7][2] = stripslashes_d($SiteInfo[7][2]);
$SiteInfo[7]['value'] = stripslashes_d($SiteInfo[7]['value']);
//处理logo地址
$SiteInfo[37]['name'] = 'ADMINLOGOURL';
$SiteInfo[37]['value'] = $SiteInfo[3]['value'];
if($SiteInfo[3]['value'] == ''){
	$SiteInfo[3][2] = $SiteInfo[1][2].'/'.$SiteInfo[2][2].'/images/logo.png';
	$SiteInfo[3]['value'] = $SiteInfo[1]['value'].'/'.$SiteInfo[2]['value'].'/images/logo.png';
}
else{
	if(CheckURL($SiteInfo[3]['value']) == false){
		if(preg_match('[/]', $SiteInfo[3]['value']) == true){
			if(substr($SiteInfo[3]['value'], 0, 1) == '/'){
				$SiteInfo[3][2] = $SiteInfo[1][2].$SiteInfo[3][2];
				$SiteInfo[3]['value'] = $SiteInfo[1]['value'].$SiteInfo[3]['value'];
			}
			else{
				$SiteInfo[3][2] = $SiteInfo[1][2].'/'.$SiteInfo[3][2];
				$SiteInfo[3]['value'] = $SiteInfo[1]['value'].'/'.$SiteInfo[3]['value'];
			}
		}
		else{
			$SiteInfo[3][2] = $SiteInfo[1][2].'/'.$SiteInfo[2][2].'/images/'.$SiteInfo[3][2];
			$SiteInfo[3]['value'] = $SiteInfo[1]['value'].'/'.$SiteInfo[2]['value'].'/images/'.$SiteInfo[3]['value'];
		}
	}
}
//处理自定义回复内容
$SiteInfo[29][2] == stripslashes_d($SiteInfo[29][2]);
$SiteInfo[29]['value'] == stripslashes_d($SiteInfo[29]['value']);
if($SiteInfo[26]['value'] == 'TXT'){
	$SiteInfo[29][2] = DeleteHtml($SiteInfo[29][2]);
	$SiteInfo[29]['value'] = DeleteHtml($SiteInfo[29]['value']);
}
//关闭数据库连接
$DataBase->close_dblink();

//实例化Smarty
$smarty = new Smarty;
//模板编译目录
$smarty->compile_dir = SITE_DIR.'cache/compile';
//模板缓存目录
$smarty->cache_dir = SITE_DIR.'cache/Tpl';
//配置文件目录
$smarty->config_dir = SITE_DIR.'include/smarty/config';

//调试----
$smarty->compile_check = true;
$smarty->debugging = false;

//将站点配置信息定义为常量并赋值给模板
for($i = 0; $i < count($SiteInfo); $i++){
	$ConfName = $SiteInfo[$i]['name'];
	$ConfValue = $SiteInfo[$i]['value'];
	define($ConfName, $ConfValue);
	$smarty->assign($ConfName, $ConfValue);
}

//设置时区
date_default_timezone_set(TIMEZONE);

//模板目录
$smarty->template_dir = SITE_DIR.SITE_TPL;

//局部不缓存
function smarty_block_nocache($param, $content, $smarty){
	return $content;
}
$smarty->register_block('nocache', 'smarty_block_nocache', false);

//实例化登录类
$AdminLogin = new AdminLogin();

//实例化用户请求处理类
$UserRequest = new UserRequest();

//开启SESSION
$AdminLogin->open_session();

//如果在登录有效时间内有操作则延长登录有效时间
if($AdminLogin->CheckLogin()){
	$Encry = new Encry();
	$File = new File();
	$dirname = 	$Encry->encrypt($_SESSION['UserId'].$_SESSION['UserName'].$_SESSION['Password'].$_SESSION['SessionKey'], $_SESSION['SessionKey']);
	$filename = $Encry->encrypt($_SESSION['UserName'], $_SESSION['SessionKey']);
	$File->ReadFileContent('cache/userlogin/'.$dirname.'/'.$filename.'.txt', "w+");
	$File->ModifyFileContent(up_loginfile());
	$File->CloseFile();
}

//当前时间赋值给模板
$now_time = date('Y-m-d H:i:s');
$smarty->assign('now_time', $now_time);

?>