<?php 

//判断手机访问
function isMobile(){
	if(isset ($_SERVER['HTTP_X_WAP_PROFILE'])){
		return true;
	}
	if(isset($_SERVER['HTTP_VIA'])){
		return stristr($_SERVER['HTTP_VIA'], "wap") ? true : false;
	}
	if(isset($_SERVER['HTTP_USER_AGENT'])){
		$clientkeywords = array(
				'nokia',
				'sony',
				'ericsson',
				'mot',
				'samsung',
				'htc',
				'sgh',
				'lg',
				'sharp',
				'sie-',
				'philips',
				'panasonic',
				'alcatel',
				'lenovo',
				'iphone',
				'ipod',
				'blackberry',
				'meizu',
				'android',
				'netfront',
				'symbian',
				'ucweb',
				'windowsce',
				'palm',
				'operamini',
				'operamobi',
				'openwave',
				'nexusone',
				'cldc',
				'midp',
				'wap',
				'mobile'
		);
		if(preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT']))){
			return true;
		}
	}
	if(isset($_SERVER['HTTP_ACCEPT'])){
		if((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html')))){
			return true;
		}
	}
	return false;
}

//获得客户端IP地址
function GetClientIp($type = 0){
	$type = intval($type);
	if(isset($_SERVER)){
		if(isset($_SERVER["HTTP_X_FORWARDED_FOR"])){
			$ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
		}
		elseif(isset($_SERVER["HTTP_CLIENT_IP"])){
			$ip = $_SERVER["HTTP_CLIENT_IP"];
		}
		else{
			$ip = $_SERVER["REMOTE_ADDR"];
		}
	}
	else{
		if(getenv("HTTP_X_FORWARDED_FOR")){
			$ip = getenv("HTTP_X_FORWARDED_FOR");
		}
		elseif(getenv("HTTP_CLIENT_IP")){
			$ip = getenv("HTTP_CLIENT_IP");
		}
		else{
			$ip = getenv("REMOTE_ADDR");
		}
	}
	$long = ip2long($ip);
	$clientIp = $long ? array($ip, $long) : array("0.0.0.0", 0);
	return $clientIp[$type];
}

//获得浏览器版本
function browser_info(){
	$agent = strtolower($_SERVER["HTTP_USER_AGENT"]);
	$browser = null;
	if(strstr($agent, 'msie 9.0')){
		$browser = 'msie9';
	}
	elseif(strstr($agent, 'msie 8.0')){
		$browser = 'msie8';
	}
	elseif(strstr($agent, 'msie 7.0')){
		$browser = 'msie7';
	}
	elseif(strstr($agent, 'msie 6.0')){
		$browser = 'msie6';
	}
	elseif(strstr($agent, 'firefox')){
		$browser = 'firefox';
	}
	elseif(strstr($agent, 'chrome')){
		$browser = 'chrome';
	}
	elseif(strstr($agent, 'safari')){
		$browser = 'safari';
	}
	elseif(strstr($agent, 'opera')){
		$browser = 'opera';
	}
	return $browser;
}

//根据IP地址显示地区（通过淘宝网）
function GetIpInfo($ip){
	if($ip !== ""){
		$url='http://ip.taobao.com/service/getIpInfo.php?ip='.$ip;
		$result = @file_get_contents($url);
		$result = json_decode($result,true);
		if($result['code']!==0 || !is_array($result['data'])){
			$return = "未知地区";
		}
		else{
			if($result['data']['country'] == "中国"){
				$return = $result['data']['region']."省".$result['data']['city']."市";
			}
			else{
				if($result['data']['city'] == "内网IP"){
					$return = "本地局域网";
				}
				else{
					$return = $result['data']['country'];
				}
			}
		}
	}
	else{
		$return = "未知地区";
	}
	return $return;
}

?>