<?php 

//cookie处理
function cookie($name, $value = '', $option = array()){
	$config = array(
			'prefix' => '', 
			'expire' => 0, 
			'path' => '/', 
			'domain' => '', 
	);
	if (!empty($option)) {
		if (is_numeric($option))
			$option = array('expire' => $option);
		elseif (is_string($option))
		parse_str($option, $option);
		$config = array_merge($config, array_change_key_case($option));
	}
	if (is_null($name)) {
		if (empty($_COOKIE)) return;
		$prefix = empty($value) ? $config['prefix'] : $value;
		if (!empty($prefix)) {
			foreach ($_COOKIE as $key => $val) {
				if (0 === stripos($key, $prefix)) {
					setcookie($key, '', time() - 3600, $config['path'], $config['domain']);
					unset($_COOKIE[$key]);
				}
			}
		}
		return $_COOKIE;
	}
	$name = $config['prefix'] . $name;
	if ('' === $value) {
		return isset($_COOKIE[$name]) ? json_decode(MAGIC_QUOTES_GPC ? stripslashes($_COOKIE[$name]) : $_COOKIE[$name]) : null;
	} else {
		if (is_null($value)) {
			setcookie($name, '', time() - 3600, $config['path'], $config['domain']);
			unset($_COOKIE[$name]);
		} else {
			$value = json_encode($value);
			$expire = !empty($config['expire']) ? time() + intval($config['expire']) : 0;
			setcookie($name, $value, $expire, $config['path'], $config['domain']);
			$_COOKIE[$name] = $value;
		}
	}
}

?>