<?php 

//将数组转为字符串表示形式
function array_to_String($array, $level = 0){
	if(!is_array($array)){
		return "'" . $array . "'";
	}
	$space = '';
	for($i = 0; $i <= $level; $i++){
		$space .= "\t";
	}
	$arr = "Array\n$space(\n";
	$c = $space;
	foreach($array as $k => $v){
		$k = is_string($k) ? '\'' . addcslashes($k, '\'\\') . '\'' : $k;
		$v = !is_array($v) && (!preg_match("/^\-?[1-9]\d*$/", $v) || strlen($v) > 12) ? '\'' . addcslashes($v, '\'\\') . '\'' : $v;
		if(is_array($v)){
			$arr .= "$c$k=>" . array_to_String($v, $level + 1);
		}
		else{
			$arr .= "$c$k=>$v";
		}
		$c = ",\n$space";
	}
	$arr .= "\n$space)";
	return $arr;
}

//截取长度
function cutout_str($string, $len = 20, $end = '...'){
	$con = mb_substr($string, 0, $len, 'utf-8');
	if ($con !== $string) {
		$con .= $end;
	}
	return $con;
}

//数组转为常量
function array_defined($arr){
	foreach ($arr as $k => $v) {
		$k = strtoupper($k);
		if (is_string($v)) {
			define($k, $v);
		} elseif (is_numeric($v)) {
			defined($k, $v);
		} elseif (is_bool($v)) {
			$v = $v ? 'true' : 'false';
			define($k, $v);
		}
	}
	return true;
}

//将数组键名变成大写或小写
function array_change_key_case_d($arr, $type = 0){
	$function = $type ? 'strtoupper' : 'strtolower';
	$newArr = array();
	if(!is_array($arr) || empty($arr))
		return $newArr;
	foreach ($arr as $k => $v) {
		$k = $function($k);
		if(is_array($v)){
			$newArr[$k] = array_change_key_case_d($v, $type);
		} 
		else{
			$newArr[$k] = $v;
		}
	}
	return $newArr;
}

//不区分大小写检测数据键名是否存在
function array_key_exists_d($key, $arr){
	return array_key_exists(strtolower($key), array_change_key_case_d($arr));
}

//根据大小返回标准单位 KB  MB GB等
function get_size($size, $decimals = 2){
	switch(true){
		case $size >= pow(1024, 3):
			return round($size / pow(1024, 3), $decimals) . " GB";
		case $size >= pow(1024, 2):
			return round($size / pow(1024, 2), $decimals) . " MB";
		case $size >= pow(1024, 1):
			return round($size / pow(1024, 1), $decimals) . " KB";
		default:
			return $size . 'B';
	}
}

//数组转对象
function array_to_object($arr){
	if (!is_array($arr) || empty($arr)) {
		return null;
	}
	return (object)$arr;
}

//将数组中的值全部转为大写或小写
function array_change_value_case($arr, $type = 0){
	$function = $type ? 'strtoupper' : 'strtolower';
	$newArr = array();
	foreach($arr as $k => $v){
		if (is_array($v)) {
			$newArr[$k] = array_change_value_case($v, $type);
		} 
		else{
			$newArr[$k] = $function($v);
		}
	}
	return $newArr;
}

//获得常量
function get_defines($name = "", $value = null, $type = 'user'){
	if($name){
		$const = get_defined_constants();
		return defined($name) ? $const[$name] : $value;
	}
	$const = get_defined_constants(true);
	return $type === true ? $const : $const[$type];
}

//去空格，去除注释包括单行及多行注释
function compress($content)
{
	$str = "";
	$data = token_get_all($content);
	$end = false;
	for ($i = 0, $count = count($data); $i < $count; $i++) {
		if (is_string($data[$i])) {
			$end = false;
			$str .= $data[$i];
		} else {
			switch ($data[$i][0]) {
				case T_COMMENT:
				case T_DOC_COMMENT:
					break;
				case T_WHITESPACE:
					if (!$end) {
						$end = true;
						$str .= " ";
					}
					break;
				case T_START_HEREDOC:
					$str .= "<!--\n";
					break;
				case T_END_HEREDOC:
					$str .= "-->\n";
					for ($m = $i + 1; $m < $count; $m++) {
						if (is_string($data[$m]) && $data[$m] == ';') {
							$i = $m;
							break;
						}
						if ($data[$m] == T_CLOSE_TAG) {
							break;
						}
					}
					break;

				default:
					$end = false;
					$str .= $data[$i][1];
			}
		}
	}
	return $str;
}

//获得变量值
function _default($varName, $value = ""){
	return empty($varName) ? $value : $varName;
}

//打印常量
function print_const(){
	$define = get_defined_constants(true);
	foreach ($define['user'] as $k => $d) {
		$const[$k] = $d;
	}
	p($const);
}

//二维数组去重函数
function assoc_unique($arr, $key) {
	$tmp_arr = array();
	foreach ($arr as $k => $v) {
		if (in_array($v[$key], $tmp_arr)) {//搜索$v[$key]是否在$tmp_arr数组中存在，若存在返回true
			unset($arr[$k]);
		} else {
			$tmp_arr[] = $v[$key];
		}
	}
	sort($arr); //sort函数对数组进行排序
	return $arr;
}

?>