<?php

//获得当前时间
function GetNowTime(){
	$timezone = TIMEZONE;
	//设置时区
	date_default_timezone_set($timezone);
	//返回当前时间
	return date('Y-m-d H:i:s');
}

//获得几天前，几小时前，几月前
function date_before($time, $unit = null){
	$time = intval($time);
	$unit = is_null($unit) ? array("年", "月", "星期", "天", "小时", "分钟", "秒") : $unit;
	switch (true) {
		case $time < (NOW - 31536000) :
			return floor((NOW - $time) / 31536000) . $unit[0] . '前';
		case $time < (NOW - 2592000) :
			return floor((NOW - $time) / 2592000) . $unit[1] . '前';
		case $time < (NOW - 604800) :
			return floor((NOW - $time) / 604800) . $unit[2] . '前';
		case $time < (NOW - 86400) :
			return floor((NOW - $time) / 86400) . $unit[3] . '前';
		case $time < (NOW - 3600) :
			return floor((NOW - $time) / 3600) . $unit[4] . '前';
		case $time < (NOW - 60) :
			return floor((NOW - $time) / 60) . $unit[5] . '前';
		default :
			return floor(NOW - $time) . $unit[6] . '前';
	}
}

//日期格式化
function hd_date($time, $format = 'Y-m-d')
{
	return date($format, $time);
}

//计算脚本运行时间
function runtime($start, $end = '', $decimals = 3){
	static $runtime = array();
	if($end != ''){
		$runtime [$end] = microtime();
		return number_format($runtime [$end] - $runtime [$start], $decimals);
	}
	$runtime [$start] = microtime();
}

?>