<?php 

//递归创建目录
function dir_create($dirName, $auth = 0755){
	$dirName = str_replace("\\", "/", $dirName);
	$dirPath = rtrim($dirName, '/');
	if (is_dir($dirPath))
		return true;
	$dirs = explode('/', $dirPath);
	$dir = '';
	foreach ($dirs as $v) {
		$dir .= $v . '/';
		is_dir($dir) or @mkdir($dir, $auth, true);
	}
	return is_dir($dirPath);
}

//多个PHP文件合并
function file_merge($files, $space = false, $tag = false)
{
	$str = ''; //格式化后的内容
	foreach ($files as $file) {
		$con = trim(file_get_contents($file));
		if ($space)
			$con = compress($con);
		$str .= substr($con, -2) == '?>' ? trim(substr($con, 5, -2)) : trim($con, 5);
	}
	return $tag ? '<?php if(!defined("HDPHP_PATH")){exit("No direct script access allowed");}' . $str . "\t?>" : $str;
}

?>