<?php 

//获取与设置请求参数
function get_request($var, $default = null, $filter = null){
	$var = explode(".", $var);
	if (count($var) == 1) {
		array_unshift($var, 'request');
	}
	$var[0] = strtolower($var[0]);
	switch (strtolower($var[0])){
		case 'get' :
			$data = &$_GET;
			break;
		case 'post' :
			$data = &$_POST;
			break;
		case 'request' :
			$data = &$_REQUEST;
			break;
		case 'files' :
			$data = &$_FILES;
			break;
		case 'session' :
			$data = &$_SESSION;
			break;
		case 'cookie' :
			$data = &$_COOKIE;
			break;
		case 'server' :
			$data = &$_SERVER;
			break;
		case 'globals' :
			$data = &$GLOBALS;
			break;
		default :
			echo 'Error!';
	}
	if(empty($var[1])){
		return $data;
	} 
	elseif(isset($data[$var[1]])){
		$value = $data[$var[1]];
		$funcArr = is_null($filter) ? array('htmlspecialchars','strip_tags') : $filter;
		if (is_string($funcArr) && !empty($funcArr)){
			$funcArr = explode(",", $funcArr);
		}
		if(!empty($funcArr) && is_array($funcArr)){
			foreach($funcArr as $func){
				if(!function_exists($func))
					continue;
				$value = is_array($value) ? array_map($func, $value) : $func($value);
			}
			$data[$var[1]] = $value;
			return $value;
		}
		return $value;
	} 
	else{
		$data[$var[1]] = $default;
		return $default;
	}
}

//是否为AJAX提交
function ajax_request(){
	if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest'){
		return true;
	}
	else{
		return false;
	}
}

//请求方式
function _request($method, $varName = null, $html = true)
{
	$method = strtolower($method);
	switch ($method) {
		case 'ispost' :
		case 'isget' :
		case 'ishead' :
		case 'isdelete' :
		case 'isput' :
			return strtolower($_SERVER['REQUEST_METHOD']) == strtolower(substr($method, 2));
		case 'get' :
			$data = &$_GET;
			break;
		case 'post' :
			$data = &$_POST;
			break;
		case 'request' :
			$data = &$_REQUEST;
			break;
		case 'Session' :
			$data = &$_SESSION;
			break;
		case 'cookie' :
			$data = &$_COOKIE;
			break;
		case 'server' :
			$data = &$_SERVER;
			break;
		case 'globals' :
			$data = &$GLOBALS;
			break;
		default :
			echo 'Error！';
	}
	if (is_null($varName))
		return $data;
	if (isset($data[$varName]) && $html) {
		$data[$varName] = htmlspecialchars($data[$varName]);
	}
	return isset($data[$varName]) ? $data[$varName] : null;
}

//HTTP状态信息设置
function set_http_state($code){
	$state = array(
			200 => 'OK',
			301 => 'Moved Permanently', 302 => 'Moved Temporarily ',
			400 => 'Bad Request', 403 => 'Forbidden', 404 => 'Not Found',
			500 => 'Internal Server Error', 503 => 'Service Unavailable',
	);
	if(isset($state[$code])){
		header('HTTP/1.1 ' . $code . ' ' . $state[$code]);
		header('Status:' . $code . ' ' . $state[$code]);
	}
}

//是否为SSL协议
function is_ssl(){
	if (isset($_SERVER['HTTPS']) && ('1' == $_SERVER['HTTPS'] || 'on' == strtolower($_SERVER['HTTPS']))) {
		return true;
	} elseif (isset($_SERVER['SERVER_PORT']) && ('443' == $_SERVER['SERVER_PORT'])) {
		return true;
	}
	return false;
}

?>