<?php 

//验证管理员登录用户名
function CheckAdminUserName($username){
	$pattern = '/[A-Za-z0-9_]+/';
	if(preg_match($pattern, $username)){
		return true;
	}
	else{
		return false;
	}
}

//验证管理员登录密码
function CheckAdminPassword($password){
	return true;
}

//验证编辑管理员密码
function CheckEditUserPW($password){
	if($password == ''){
		$return = true;
	}
	else{
		if(CheckAdminPassword($password) == true){
			$return = true;
		}
		else{
			$return = false;
		}
	}
	return $return;
}

//验证管理员登录验证码
function CheckAdminVcode($Vcode){
	$pattern = '/[a-zA-Z0-9]*/';
	if(preg_match($pattern, $Vcode)){
		return true;
	}
	else{
		return false;
	}
}

//验证登录inputkey
function CheckInputKey($inputket){
	$pattern = '/[a-zA-Z0-9]*/';
	if(preg_match($pattern, $inputket)){
		return true;
	}
	else{
		return false;
	}
}

//判断是否开启
function IS_ON($Value){
	switch ($Value) {
		case 'ON':
			$return = TRUE;
			break;
		case 'OFF':
			$return = FALSE;
			break;
	}
	return $return;
}

//跳转页面，并结束执行
function GoToUrlExit($gotourl){
	echo "<script type='text/javascript'>window.location.href='".$gotourl."'</script>";
	exit();
}

//Header方式跳转页面，并结束执行
function HgoToUrlExit($url){
	header("Location: ".$url);
	exit();
}

//提示信息
function ShowMessage($MessageContent, $IconImg = 0, $Additional = "", $GotuUrl = "", $CheckUrl = "", $ReturnUrl = 1){
	//将$smarty定义为全局变量
	global $smarty;
	//模板编译目录
	$smarty->compile_dir = SITE_DIR.'cache/compile';
	//模板缓存目录
	$smarty->cache_dir = SITE_DIR.'cache/Tpl';
	//模板目录
	$smarty->template_dir = SITE_DIR.SITE_TPL;		
	//将提示信息赋值给模板
	$smarty->assign('MessageContent', $MessageContent);		//提示信息内容
	$smarty->assign('IconImg', $IconImg);		//提示图标
	$smarty->assign('Additional', $Additional);		//附加信息
	$smarty->assign('GotuUrl', $GotuUrl);		//跳转链接
	$smarty->assign('CheckUrl', $CheckUrl);		//确定链接
	$smarty->assign('ReturnUrl', $ReturnUrl);		//返回上一页链接
	//显示提示信息页面模板
	$smarty->display("showmessage.html");
}

//默认审核状态
function NewMessageCheck(){
	$SysCheckSet = MESSAGE_CHECK;
	if($SysCheckSet == 1){
		$return = 0; 
	}
	elseif($SysCheckSet == 0){
		$return = 1;
	}
	else{
		$return = false;
	}
	return $return;
}

//保密选项
function SecretOptions($SArr, $Option){
	switch(count($SArr)){
		case 1:
			$return[0] = 0;
			$return[1] = 0;
			$return[2] = 0;
			break;
		case 2:
			if($SArr[1] == 1){
				$return[0] = 0;
				$return[1] = 1;
				$return[2] = 0;				
			}
			elseif($SArr[1] == 2){
				$return[0] = 0;
				$return[1] = 0;
				$return[2] = 2;				
			}
			else{
				$return = false;
			}
			break;
		case 3:
			$return[0] = 0;
			$return[1] = 1;
			$return[2] = 2;
			break;
		default:
			$return[0] = 0;
			$return[1] = 1;
			$return[2] = 2;			
	}
	if($Option == "secret"){
		return $return[1];
	}
	elseif($Option == "privacy"){
		return $return[2];
	}
}

//修改管理员登录文件内容
function up_loginfile(){
	$return = strtotime("now") + 1800;
	return $return;
}

//QQ号码加密函数
function qqEncrypt($qq){
	if($qq == ""){
		$return = $qq;
	}
	else{
		//先检测几位数
		$len = strlen($qq);
		$s = substr($qq, 0, 2);
		$e = substr($qq, $len-1, 1);
		$c = '';
		$a = '*';
		for($i = 1; $i <= $len-3; $i++){
			$c .= $a;
		}
		$Eqq = $s.$c.$e;
		$return = $Eqq;
	}
	return $return;
}

//手机号码加密函数
function phoneEncrypt($phone){
	if($phone == ""){
		return $phone;
	}
	else{
		$IsWhat = preg_match('/(0[0-9]{2,3}[\-]?[2-9][0-9]{6,7}[\-]?[0-9]?)/i',$phone); //固定电话
		if($IsWhat == 1){
			return preg_replace('/(0[0-9]{2,3}[\-]?[2-9])[0-9]{3,4}([0-9]{3}[\-]?[0-9]?)/i','$1****$2',$phone);
		}else{
			return  preg_replace('/(1[358]{1}[0-9])[0-9]{4}([0-9]{4})/i','$1****$2',$phone);
		}
	}
}

//邮箱地址加密函数
function emailEncrypt($str) {
	if($str == ""){
		return $str;
	}
	else{
		if (strpos($str, '@')) {
			$email_array = explode("@", $str);
			$prevfix = (strlen($email_array[0]) < 4) ? "" : substr($str, 0, 3); //邮箱前缀
			$count = 0;
			$str = preg_replace('/([\d\w+_-]{0,100})@/', '***@', $str, -1, $count);
			$rs = $prevfix . $str;
		} else {
			$pattern = '/(1[3458]{1}[0-9])[0-9]{4}([0-9]{4})/i';
			if (preg_match($pattern, $str)) {
				$rs = preg_replace($pattern, '$1****$2', $str); // substr_replace($name,'****',3,4);
			} else {
				$rs = substr($str, 0, 3) . "***" . substr($str, -1);
			}
		}
		return $rs;
	}
}

//生成JS Write代码
function CreateJsWriteCode($text){
	return "document.write(\"$text\");";
}

//处理权限信息
function AdminUserPower($PostArr){
	$visit = '0';
	$nav = '0';
	$announcement = '0';
	$messagecheck = '0';
	$recycle = '0';
	if(in_array('visit', $PostArr)){
		$visit = '1';
	}
	if(in_array('nav', $PostArr)){
		$nav = '1';
	}
	if(in_array('announcement', $PostArr)){
		$announcement = '1';
	}
	if(in_array('messagecheck', $PostArr)){
		$messagecheck = '1';
	}
	if(in_array('recycle', $PostArr)){
		$recycle = '1';
	}
	return $visit.'-'.$nav.'-'.$announcement.'-'.$messagecheck.'-'.$recycle;	
}

//权限分析
function AdminPowerAna($Power){
	$PowerArr = explode('-', $Power);
	$return['visit'] = $PowerArr['0'];
	$return['nav'] = $PowerArr['1'];
	$return['announcement'] = $PowerArr['2'];
	$return['messagecheck'] = $PowerArr['3'];
	$return['recycle'] = $PowerArr['4'];
	return $return;
}

//计算备份文件大小
function backupSize($backDir){
	$size = 0;
	//读取备份文件目录
	$backup_dir = scandir($backDir);
	//遍历每一个文件
	foreach($backup_dir as $v){
		if($v !== '.' && $v !== '..'){
			if(is_file($backDir."/".$v)){
				$full_url = $backDir."/".$v;
				$size += round(filesize($full_url)/1024, 1);
			}
		}	
	}
	return $size;
}

//后台操作提示信息
function AdminShowMessage($message, $gotourl, $jump, $color = '#093', $addinfo = ''){
	$return['message'] = $message;
	$return['gotourl'] = $gotourl;
	$return['jump'] = $jump;
	$return['color'] = $color;
	$return['addinfo'] = $addinfo;
	if($jump == 1){
		echo "<meta http-equiv=refresh content='5; url=".$gotourl." '>";
	}
	return $return;
}

//系统默认邮件回复内容，HTML格式
function SysReplyHtmlMail(){
	if(CUSTOM_REPLY == 1){
		$email_reply_content = CUSTOM_CONTENT;
	}
	else{
		if(MAILTYPE == 'HTML'){
			$email_reply_content = file_get_contents(SITE_DIR.'include/email_reply_content.html');
			$rtime = date('Y-m-d H:i:s');
			$email_reply_content = str_replace('{S_NAME}', SITE_NAME, $email_reply_content);
			$email_reply_content = str_replace('{S_URL}', WEB_URL, $email_reply_content);
			$email_reply_content = str_replace('{time}', $rtime, $email_reply_content);
		}
		elseif(MAILTYPE == 'TXT'){
			$email_reply_content = "您在".SITE_NAME."(".WEB_URL.")的留言已被管理员回复，请登陆查看。";
		}
	}
	return $email_reply_content;
}

//获取当前执行脚本文件名
function GetPHPfilename(){
	$arr = explode("/", $_SERVER['PHP_SELF']);
	return $arr[count($arr)-1];
}

//判断验证码是否开启
function CheckVCset($Action){
	$VCset = explode('-', CHECKCODE);
	if($Action == 'post'){
		if($VCset[0] == 1){
			$return = true;
		}
		else{
			$return = false;
		}
	}
	elseif($Action == 'login'){
		if($VCset[1] == 1){
			$return = true;
		}
		else{
			$return = false;
		}		
	}
	return $return;
}

?>