<?php

//防注入
function check_input($value){
	if(get_magic_quotes_gpc()){
		$value = stripslashes($value);
	}
	if(!is_numeric($value)){
		$value = "'" . mysql_real_escape_string($value) . "'";
	}
	return $value;
}

//剔除HTML标签
function DeleteHtml($str){
	$str = trim($str);
	$str = strip_tags($str,"");
	$str = ereg_replace("\t","",$str);
	$str = ereg_replace("\r\n","",$str);
	$str = ereg_replace("\r","",$str);
	$str = ereg_replace("\n","",$str);
	$str = ereg_replace(" "," ",$str);
	$str = ereg_replace("&nbsp;"," ",$str);
	return trim($str);
}

//生成随机字符串
function generate_rand_string($length){
	$chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
	$password = "";
	for( $i = 0; $i < $length; $i++ ){
		$password .= $chars[mt_rand(0, strlen($chars) - 1)];
	}
	return $password;
}


//删除所有空格
function trimall($str){
	$qian = array(" ", "　", "\t", "\n", "\r");
	$hou = array("", "", "", "", "");
	return str_replace($qian,$hou,$str);
}

//判断是否是正整数
function check_zzs($varnum){
	$string_var = "0123456789";
	$len_string = strlen($varnum);
	if(substr($varnum,0,1)=="0"){
		return false;
		die();
	}else{
		for($i=0;$i<$len_string;$i++){
			$checkint = strpos($string_var,substr($varnum,$i,1));
			if($checkint===false){
				return false;
			}
		}
		return true;
	}
}

//密码加密
function set_password($password, $key){
	$pw = md5($password);
	$pw_b = $pw.$key;
	$pw_c = md5($pw_b);
	$pw_d = crypt($pw_c, $key);
	return sha1($pw_d);
}

//数据安全处理
function data_format(&$data, $func = null){
	$functions = is_null($func) ? array('htmlspecialchars','strip_tags') : $func;
	if(!is_array($functions)){
		$functions = preg_split("/\s*,\s*/", $functions);
	}
	foreach($functions as $_func){
		if (is_string($data)){
			$data = $_func($data);
		} 
		elseif(is_array($data)){
			foreach($data as $k => $d){
				$data[$k] = is_array($d) ? data_format($d, $functions) : $_func($d);
			}
		}
	}
	return $data;
}

//加密方法
function encrypt($data, $key = null){
	return encry::encrypt($data, $key);
}

//解密方法
function decrypt($data, $key = null){
	return encry::decrypt($data, $key);
}

//转义处理
function addslashes_d($data){
	if(is_string($data)){
		return addslashes($data);
	}
	if(is_numeric($data)){
		return $data;
	}
	if(is_array($data)){
		$var = array();
		foreach($data as $k => $v){
			if(is_array($v)){
				$var[$k] = addslashes_d($v);
				continue;
			} 
			else{
				$var[$k] = addslashes($v);
			}
		}
		return $var;
	}
}

//去除转义
function stripslashes_d($data){
	if(empty($data)){
		return $data;
	} 
	elseif(is_string($data)){
		return stripslashes($data);
	} 
	elseif(is_array($data)){
		$var = array();
		foreach($data as $k => $v){
			if(is_array($v)){
				$var[$k] = stripslashes_d($v);
				continue;
			} 
			else{
				$var[$k] = stripslashes($v);
			}
		}
		return $var;
	}
}

//生成序列字符串
function md5_d($var){
	return md5(serialize($var));
}

//Hash函数
function hash_f($data, $len){
	$hash = crc32($data) & 0xfffffff;
	return $hash % $len;
}

//字符串仅允许长度等于1
function strlen_only_one($str){
	if(strlen($str) == 1){
		return true;	
	}
	else{
		return false;
	}
}

//仅允许为0或1
function only_z_or_o($str){
	if($str == 1 || $str == 0){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证授权码
function CheckAuthorizationCode($Code){
	if($Code == ''){
		$return = true;
	}
	else{
		if(strlen($Code) == 19){
			$pattern = '/^([0-9]{4})(-)([0-9]{4})(-)([0-9]{4})(-)([0-9]{4})$/';
			if(preg_match($pattern, $Code) == true){
				$return = true;
			}
			else{
				$return = false;
			}
		}
		else{
			$return = false;
		}
	}
	return $return;
}

//验证模板
function CheckSitetpl($Sitetpl){
	$pattern = '/[0-9a-zA-Z_]/';
	if(preg_match($pattern, $Sitetpl) == true){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证编辑器选择
function CheckSelEdit($SelEdit){
	$EditArr = array('kindeditor', 'baidu');
	if(in_array($SelEdit, $EditArr)){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证logo地址
function CheckLogoUrl($LogoImgUrl){
	if($LogoImgUrl == ''){
		$return = true;
	}
	else{
		if(CheckURL($LogoImgUrl) == true){
			$return = true;
		}
		elseif(CheckIsImgFileName($LogoImgUrl)){
			$return = true;
		}
		else{
			$return = false;
		}
	}
	return $return;
}

//验证是否图片文件名
function CheckIsImgFileName($FileName){
	if(preg_match('[^.+\.(jpg)|(gif)|(bmp)|(jpeg)|(png)$]', $FileName)){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证IP地址
function CheckIpAddress($IpAddress){
	if(preg_match('/(25[0-5]|2[0-4]\d|[0-1]\d{2}|[1-9]?\d)\.(25[0-5]|2[0-4]\d|[0-1]\d{2}|[1-9]?\d)\.(25[0-5]|2[0-4]\d|[0-1]\d{2}|[1-9]?\d)\.(25[0-5]|2[0-4]\d|[0-1]\d{2}|[1-9]?\d)/', $IpAddress)){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证域名
function CheckDoMain($DoMain){
	if(preg_match('/[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+.?/', $DoMain)){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证IP地址和域名
function CheckIpAndDomain($str){
	if(CheckIpAddress($str) == true){
		$return = true;
	}
	elseif(CheckDoMain($str) == true){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证SMTP服务器地址
function CheckSmtpServer($ServerAddress){
	if($ServerAddress == ''){
		$return = true;
	}
	else{
		$return = CheckIpAndDomain($ServerAddress);
	}
	return $return;
}

//验SMTP服务器端口
function CheckSmtpPort($Port){
	if($Port == ''){
		$return = true;
	}
	else{
		if(check_zzs($Port) == true){
			$PortArr = array('25', '2525', '587', '465', '994');
			if(in_array($Port, $PortArr)){
				$return = true;
			}
			else{
				$return = false;
			}
		}
		else{
			$return = false;
		}
	}
	return $return;
}

//验证邮件类型
function CheckMailtype($Type){
	if($Type == 'HTML' || $Type == 'TXT'){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证验证码选项
function CheckCodeOption($postvalue){
	if($postvalue == 'newpost' || $postvalue == 'adminlogin' || $postvalue == 'null'){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证导航栏目复选框
function CheckNavCheckbox($boxvalue){
	if(check_zzs($boxvalue) == true || $boxvalue == 'SelAll'){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证导航栏目排序编号
function CheckNavOrder($OrderID){
	return $return;
}

//验证排序方式
function CheckOrder($order){
	if($order == 'DESC' || $order == 'ASC'){
		$retrun = true;
	}
	else{
		$retrun = false;
	}
	return $retrun;
}

//验证链接打开方式
function CheckUrlTarget($Target){
	if($Target == '_self' || $Target == '_blank'){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证勾选留言数组
function CheckSelMsg($SelMsg){
	if(is_string($SelMsg) == true){
		$return = true;
		$SelMsgArr = explode(',', $SelMsg);
		foreach ($SelMsgArr as $v){
			if(check_zzs($v) == false){
				$return = false;
			}
		}
	}
	elseif(is_array($SelMsg) == true){
		$return = true;
		foreach ($SelMsg as $v){
			if(check_zzs($v) == false){
				$return = false;
			}
		}		
	}
	else{
		$return = false;
	}
	return $return;
}

//验证编辑管理员权限设置
function CheckEditUserPower($power){
	$PowerArr = array('visit', 'nav', 'announcement', 'messagecheck', 'recycle', 'ispost');
	if(in_array($power, $PowerArr)){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;	
}

//验证数据库备份文件名
function CheckDbBackfile($filename){
	if($filename == 'IsPost' || $filename == 'SelALLBox'){
		$return = true;
	}
	elseif(preg_match("[([0-9]{14})(_)([A-Za-z0-9]{10})]", $filename)){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//填写留言ajax验证
function AjaxCheckInput($inputname, $value){
	switch($inputname){
		case 'NickName':
			if($value == ''){
				$ShowMsg = '称呼不能为空！';
			}
			else{
				if(strlen_nickname($value) == true){
					$ShowMsg = '<img src="'.WEB_URL.'/include/images/checkok.png'.'" width="20" height="20" />';
				}
				else{
					$ShowMsg = '昵称格式不对！';
				}
			}
			$return = TRUE;
			break;
		case 'QQ';
			if($value == ''){
				$ShowMsg = 'QQ号码不能为空！';
			}
			else{
				if(check_qqnum($value) == true){
					$ShowMsg = '<img src="'.WEB_URL.'/include/images/checkok.png'.'" width="20" height="20" />';
				}
				else{
					$ShowMsg = 'QQ号码格式不对！';
				}
			}
			break;
		case 'QQnr';
			if($value !== ''){
				if(check_qqnum($value) == true){
					$ShowMsg = '<img src="'.WEB_URL.'/include/images/checkok.png'.'" width="20" height="20" />';
				}
				else{
					$ShowMsg = 'QQ号码格式不对！';
				}				
			}
			else{
				$ShowMsg = '';
			}
			break;
		case 'Phone';
			if($value !== ''){
				if(CheckPhone($value) == true){
					$ShowMsg = '<img src="'.WEB_URL.'/include/images/checkok.png'.'" width="20" height="20" />';
				}
				else{
					$ShowMsg = '手机号码格式不对！';
				}
			}
			else{
				$ShowMsg = '';
			}
			break;
		case 'Mail';
			if($value !== ''){
				if(CheckMail($value) == true){
					$ShowMsg = '<img src="'.WEB_URL.'/include/images/checkok.png'.'" width="20" height="20" />';
				}
				else{
					$ShowMsg = '邮箱格式不对！';
				}
			}
			else{
				$ShowMsg = '';
			}
			break;
		case 'ValidateCode';
			if($value !== ''){
				if(strtolower($value) == $_SESSION['PostValidateCode']){
					$ShowMsg = '<img src="'.WEB_URL.'/include/images/checkok.png'.'" width="20" height="20" />';
				}
				else{
					$ShowMsg = '验证码不对！';
				}
			}
			else{
				$ShowMsg = '验证码不能为空！';
			}
			break;
		case 'MessageContentText';
			if($value !== ''){
				$ShowMsg = '<img src="'.WEB_URL.'/include/images/checkok.png'.'" width="20" height="20" />';
			}
			else{
				$ShowMsg = '留言内容不能为空！';
			}						
	}
	return $ShowMsg;
}

//验证昵称
function strlen_nickname($nickname){
	if($nickname == ""){
		$return = false;
	}
	else{
		if((strlen($nickname) <= 21) && (strlen($nickname) > 2)){
			$return = true;
		}
		else{
			$return = false;
		}		
	}
	return $return;	
}

//验证QQ号码
function check_qqnum($qq){
	if($qq == ""){
		$return = true;
	}
	else{
		if((5 <= strlen($qq)) && (strlen($qq) <= 10)){
			if(check_zzs($qq) == true){
				if(substr($qq, 0, 1) >= 0){
					$return = true;
				}
				else{
					$return = false;
				}
			}
			else{
				$return = false;
			}
		}
		else{
			$return = false;
		}
	}	
	
	return $return;
}

//验证手机号码
function CheckPhone($PhoneNum){
	if($PhoneNum == ""){
		return true;
	}
	else{
		if(preg_match("/^1[345789]{1}\d{9}$/", $PhoneNum)){
			return true;
		}else{
			return false;
		}
	}	
}

//验证邮箱
function CheckMail($MailAddress){
	if($MailAddress == ""){
		$return = true;
	}
	else{
		$expression = "/\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/";	//定义正则表达式
		if(preg_match($expression, $MailAddress)){                       //用正则表达式函数进行判断
			$return = true;
		}else{
			$return = false;
		}		
	}
	return $return;
}

//验证URL地址
function CheckURL($UrlAddress){
	if(preg_match('/^((https|http|ftp|rtsp|mms)?:\/\/)[^\s]+/', $UrlAddress)){
		$return = true;
	}
	else{
		$return = false;
	}
	return $return;
}

//验证ICP备案号
function CheckIcpId($IcpId){
	if($IcpId == ''){
		$return = true;
	}
	else{
		$expression = "([A-Z0-9]{5,50})";
		if(preg_match($expression, $IcpId)){
			$return = true;
		}
		else{
			$return = false;
		}
	}
	return $return;
}

//验证保密选项
function CheckSecretOptions($SecretOptions){
	if(strlen($SecretOptions) == 1){
		$expression = "([0-2]{1})";
		if(preg_match($expression, $SecretOptions)){	//用正则表达式函数进行判断
			$return = true;
		}else{
			$return = false;
		}		
	}
	else{
		$return = false;
	}
	return $return;
}

//直接验证通过，用于无需验证的数据
function CheckOK($Value){
	return true;
}

//检查验证码
function CheckValidateCode($ValidateCode){
	if(strlen($ValidateCode) == 4){
		$expression = "([A-Za-z0-9]{4})";
		if(preg_match($expression, $ValidateCode)){	//用正则表达式函数进行判断
			$return = true;
		}else{
			$return = false;
		}		
	}
	else{
		$return = false;
	}
	return $return;
}

//检查PostInputKey
function CheckPostInputKey($PostInputKey){
	if(strlen($PostInputKey) == 50){
		$expression = "([A-Za-z0-9]{50})";
		if(preg_match($expression, $PostInputKey)){	//用正则表达式函数进行判断
			$return = true;
		}else{
			$return = false;
		}
	}
	else{
		$return = false;
	}
	return $return;	
}

//不能为空
function CheckNull($Value){
	if($Value == ""){
		$return = false;
	}
	else{
		$return = true;
	}
	return $return;
}

//将留言内容中的HTML代码转换为字符串
function ContentHtmlToStr($content){
	if(EDIT == 0){
		$return = htmlentities($content, null, 'UTF-8');
	}
	else{
		$return = $content;
	}
	
	return $return;
}

?>