<?php 

//session处理
function session($name = '', $value = '', $session_auto_start = true){
	if(is_array($name)){
		ini_set('session.auto_start', 0);
		if(isset($name['name'])){
			session_name($name['name']);
		}
		if(isset($_REQUEST[session_name()])){
			session_id($_REQUEST[session_name()]);
		}
		if(isset($name['path'])){
			session_save_path($name['path']);
		}
		if(isset($name['domain'])){
			ini_set('session.cookie_domain', $name['domain']);
		}
		if(isset($name['expire'])){
			ini_set('session.gc_maxlifetime', $name['expire']);
			session_set_cookie_params($name['expire']);
		}
		if(isset($name['use_trans_sid'])){
			ini_set('session.use_trans_sid', $name['use_trans_sid'] ? 1 : 0);
		}
		if(isset($name['use_cookies'])){
			ini_set('session.use_cookies', $name['use_cookies'] ? 1 : 0);
		}
		if(isset($name['cache_limiter'])){
			session_cache_limiter($name['cache_limiter']);
		}
		if(isset($name['cache_expire'])){
			session_cache_expire($name['cache_expire']);
		}
		if($session_auto_start == true){
			session_start();
		}
	}
	elseif($name === ''){
		return $_SESSION;
	}
	elseif(is_null($name)){
		$_SESSION = array();
		session_unset();
		session_destroy();
	}
	elseif($value === ''){
		if('[pause]' == $name){
			session_write_close();
		}
		elseif('[start]' == $name){
			session_start();
		}
		elseif('[destroy]' == $name){
			$_SESSION = array();
			session_unset();
			session_destroy();
		}
		elseif('[regenerate]' == $name){
			session_regenerate_id();
		}
		elseif(0 === strpos($name, '?')){
			$name = substr($name, 1);
			return isset($_SESSION[$name]);
		}
		elseif(is_null($name)){
			$_SESSION = array();
		}
		else{
			return isset($_SESSION[$name]) ? $_SESSION[$name] : null;
		}
	}
	elseif(is_null($value)){
		if(isset($_SESSION[$name])){
			unset($_SESSION[$name]);
		}
	}
	else{
		$_SESSION[$name] = $value;
	}
}

?>