<?php

require_once 'common.php';

//检查文件或目录权限
function getChmod($filepath){
	return substr(base_convert(@fileperms($filepath),10,8),-4);
}

//需要检查的目录和文件
$CheckList = array(
		'attached',
		'attached/baidu_images',
		'attached/kind',
		'attached/kind/image',
		'cache',
		'cache/compile',
		'cache/compile_A',
		'cache/tpl',
		'cache/tpl_A',
		'cache/userlogin',
		'data',
		'data/backup',
		'data/backup/20190405204126_2YkmGlt0uB',
		'install',
		'data/backup/20190405204126_2YkmGlt0uB/20190405204126_all_v1.sql',
		'include/editor/baidu/php/config.json',
		'config.php'
);

//判断是目录还是文件
function CheckForD($if){
	if(is_file($if)){
		$return = '文件';
	}
	elseif(is_dir($if)){
		$return = '目录';
	}
	return $return;
}

//执行检查操作
$CheckResult = array();		//创建数组用于存放检查结果
$key = 0;
$CheckOK = true;
foreach($CheckList as $v){
	$i = $key++;
	$CheckResult[$i]['n'] = $v;
	if(getChmod('../'.$v) == '0777' || getChmod('../'.$v) == '0666'){
		$r = '<span class="ok">[可写]√</span>';
	}
	else{
		$CheckOK = false;
		$r = '<span class="no">[不可写]×</span>';
	}
	$CheckResult[$i]['r'] = $r;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>ZTJMessage 安装程序</title>
<link href="css/style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="js/script.js"></script>
</head>

<body>

<div class="box">

<div id="header">
<img src="images/logo.png" /><span>版本：3.5 Beta</span>
</div>

<div id="loac">
<b style="color:#F00; font-size:24px;">1.运行环境检测</b>
&raquo;
2.系统设置
&raquo;
3.安装数据库
&raquo;
4.设置管理员账号
&raquo;
5.完成安装
</div>

<div class="check">
<?php 
foreach ($CheckResult as $r){
?>
<?php echo CheckForD('../'.$r['n']); ?>&nbsp;<?php echo $r['n']; ?>  <?php echo $r['r']; ?></br>
<?php 
}
?>
</div>

<div id="next">
<?php if($CheckOK == true){ ?>
<div style="font-size:12px; color:#00A600;">恭喜您！权限检测通过，您可以继续安装</div>
<input name="next" type="button" onclick="ToSystemSet();" value="下一步" />
<?php
}
else{
?>
<div style="font-size:12px; color:#F00;">权限检测未通过，您必须解决上面的问题才能继续安装</div>
<input name="next" type="button" value="下一步" disabled="disabled" />
<?php } ?>
</div>

</div>

</body>

</html>
