/*
MySQL Data Transfer
Source Host: localhost
Source Database: dmy_qcrj
Target Host: localhost
Target Database: dmy_qcrj
Date: 2018/9/29 14:48:05
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for dede_addonarticle
-- ----------------------------
DROP TABLE IF EXISTS `dede_addonarticle`;
CREATE TABLE `dede_addonarticle` (
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `body` mediumtext,
  `redirecturl` varchar(255) NOT NULL DEFAULT '',
  `templet` varchar(30) NOT NULL DEFAULT '',
  `userip` char(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`),
  KEY `typeid` (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_addonimages
-- ----------------------------
DROP TABLE IF EXISTS `dede_addonimages`;
CREATE TABLE `dede_addonimages` (
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `pagestyle` smallint(6) NOT NULL DEFAULT '1',
  `maxwidth` smallint(6) NOT NULL DEFAULT '600',
  `imgurls` text,
  `row` smallint(6) NOT NULL DEFAULT '0',
  `col` smallint(6) NOT NULL DEFAULT '0',
  `isrm` smallint(6) NOT NULL DEFAULT '0',
  `ddmaxwidth` smallint(6) NOT NULL DEFAULT '200',
  `pagepicnum` smallint(6) NOT NULL DEFAULT '12',
  `templet` varchar(30) NOT NULL DEFAULT '',
  `userip` char(15) NOT NULL DEFAULT '',
  `redirecturl` varchar(255) NOT NULL DEFAULT '',
  `body` mediumtext,
  PRIMARY KEY (`aid`),
  KEY `imagesMain` (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_addoninfos
-- ----------------------------
DROP TABLE IF EXISTS `dede_addoninfos`;
CREATE TABLE `dede_addoninfos` (
  `aid` int(11) NOT NULL DEFAULT '0',
  `typeid` int(11) NOT NULL DEFAULT '0',
  `channel` smallint(6) NOT NULL DEFAULT '0',
  `arcrank` smallint(6) NOT NULL DEFAULT '0',
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `click` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(60) NOT NULL DEFAULT '',
  `litpic` varchar(60) NOT NULL DEFAULT '',
  `userip` varchar(15) NOT NULL DEFAULT ' ',
  `senddate` int(11) NOT NULL DEFAULT '0',
  `flag` set('c','h','p','f','s','j','a','b') DEFAULT NULL,
  `lastpost` int(10) unsigned NOT NULL DEFAULT '0',
  `scores` mediumint(8) NOT NULL DEFAULT '0',
  `goodpost` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `badpost` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `nativeplace` smallint(5) unsigned NOT NULL DEFAULT '0',
  `infotype` char(20) NOT NULL DEFAULT '0',
  `body` mediumtext,
  `endtime` int(11) NOT NULL DEFAULT '0',
  `tel` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `address` varchar(100) NOT NULL DEFAULT '',
  `linkman` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`),
  KEY `typeid` (`typeid`,`nativeplace`,`infotype`),
  KEY `channel` (`channel`,`arcrank`,`mid`,`click`,`title`,`litpic`,`senddate`,`flag`,`endtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_addonshop
-- ----------------------------
DROP TABLE IF EXISTS `dede_addonshop`;
CREATE TABLE `dede_addonshop` (
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `body` mediumtext,
  `price` float NOT NULL DEFAULT '0',
  `trueprice` float NOT NULL DEFAULT '0',
  `brand` varchar(250) NOT NULL DEFAULT '',
  `units` varchar(250) NOT NULL DEFAULT '',
  `templet` varchar(30) NOT NULL,
  `userip` char(15) NOT NULL,
  `redirecturl` varchar(255) NOT NULL,
  `vocation` char(20) NOT NULL DEFAULT '0',
  `infotype` char(20) NOT NULL DEFAULT '0',
  `uptime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`),
  KEY `typeid` (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_addonsoft
-- ----------------------------
DROP TABLE IF EXISTS `dede_addonsoft`;
CREATE TABLE `dede_addonsoft` (
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `filetype` varchar(10) NOT NULL DEFAULT '',
  `language` varchar(10) NOT NULL DEFAULT '',
  `softtype` varchar(10) NOT NULL DEFAULT '',
  `accredit` varchar(10) NOT NULL DEFAULT '',
  `os` varchar(30) NOT NULL DEFAULT '',
  `softrank` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `officialUrl` varchar(30) NOT NULL DEFAULT '',
  `officialDemo` varchar(50) NOT NULL DEFAULT '',
  `softsize` varchar(10) NOT NULL DEFAULT '',
  `softlinks` text,
  `introduce` text,
  `daccess` smallint(5) NOT NULL DEFAULT '0',
  `needmoney` smallint(5) NOT NULL DEFAULT '0',
  `templet` varchar(30) NOT NULL DEFAULT '',
  `userip` char(15) NOT NULL DEFAULT '',
  `redirecturl` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`),
  KEY `softMain` (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_addonspec
-- ----------------------------
DROP TABLE IF EXISTS `dede_addonspec`;
CREATE TABLE `dede_addonspec` (
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `note` text,
  `templet` varchar(30) NOT NULL DEFAULT '',
  `userip` char(15) NOT NULL DEFAULT '',
  `redirecturl` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`),
  KEY `typeid` (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_admin
-- ----------------------------
DROP TABLE IF EXISTS `dede_admin`;
CREATE TABLE `dede_admin` (
  `id` int(10) unsigned NOT NULL,
  `usertype` float unsigned DEFAULT '0',
  `userid` char(30) NOT NULL DEFAULT '',
  `pwd` char(32) NOT NULL DEFAULT '',
  `uname` char(20) NOT NULL DEFAULT '',
  `tname` char(30) NOT NULL DEFAULT '',
  `email` char(30) NOT NULL DEFAULT '',
  `typeid` text,
  `logintime` int(10) unsigned NOT NULL DEFAULT '0',
  `loginip` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_admintype
-- ----------------------------
DROP TABLE IF EXISTS `dede_admintype`;
CREATE TABLE `dede_admintype` (
  `rank` float NOT NULL DEFAULT '1',
  `typename` varchar(30) NOT NULL DEFAULT '',
  `system` smallint(6) NOT NULL DEFAULT '0',
  `purviews` text,
  PRIMARY KEY (`rank`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_advancedsearch
-- ----------------------------
DROP TABLE IF EXISTS `dede_advancedsearch`;
CREATE TABLE `dede_advancedsearch` (
  `mid` int(11) NOT NULL,
  `maintable` varchar(256) NOT NULL DEFAULT '',
  `mainfields` text,
  `addontable` varchar(256) DEFAULT NULL,
  `addonfields` text,
  `forms` text,
  `template` varchar(256) NOT NULL DEFAULT '',
  UNIQUE KEY `mid` (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_arcatt
-- ----------------------------
DROP TABLE IF EXISTS `dede_arcatt`;
CREATE TABLE `dede_arcatt` (
  `sortid` smallint(6) NOT NULL DEFAULT '0',
  `att` char(10) NOT NULL DEFAULT '',
  `attname` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`att`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_arccache
-- ----------------------------
DROP TABLE IF EXISTS `dede_arccache`;
CREATE TABLE `dede_arccache` (
  `md5hash` char(32) NOT NULL DEFAULT '',
  `uptime` int(11) NOT NULL DEFAULT '0',
  `cachedata` mediumtext,
  PRIMARY KEY (`md5hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_archives
-- ----------------------------
DROP TABLE IF EXISTS `dede_archives`;
CREATE TABLE `dede_archives` (
  `id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `typeid2` varchar(90) NOT NULL DEFAULT '0',
  `sortrank` int(10) unsigned NOT NULL DEFAULT '0',
  `flag` set('c','h','p','f','s','j','a','b') DEFAULT NULL,
  `ismake` smallint(6) NOT NULL DEFAULT '0',
  `channel` smallint(6) NOT NULL DEFAULT '1',
  `arcrank` smallint(6) NOT NULL DEFAULT '0',
  `click` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `money` smallint(6) NOT NULL DEFAULT '0',
  `title` char(60) NOT NULL DEFAULT '',
  `shorttitle` char(36) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `writer` char(20) NOT NULL DEFAULT '',
  `source` char(30) NOT NULL DEFAULT '',
  `litpic` char(100) NOT NULL DEFAULT '',
  `pubdate` int(10) unsigned NOT NULL DEFAULT '0',
  `senddate` int(10) unsigned NOT NULL DEFAULT '0',
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `keywords` char(30) NOT NULL DEFAULT '',
  `lastpost` int(10) unsigned NOT NULL DEFAULT '0',
  `scores` mediumint(8) NOT NULL DEFAULT '0',
  `goodpost` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `badpost` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `voteid` mediumint(8) NOT NULL,
  `notpost` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `description` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(40) NOT NULL DEFAULT '',
  `dutyadmin` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `tackid` int(10) NOT NULL DEFAULT '0',
  `mtype` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `weight` int(10) NOT NULL DEFAULT '0',
  `zzzxq` char(7) NOT NULL,
  `zzzdisplay` char(7) NOT NULL,
  `zzzbg` varchar(255) NOT NULL,
  `zzzmtype` char(7) NOT NULL,
  `zzzdisplaymima` char(100) DEFAULT NULL,
  `zzzbgyy` varchar(255) DEFAULT 'none',
  `zzzrijileibie` char(50) DEFAULT NULL,
  `zzztowsex` char(100) DEFAULT NULL,
  `zzztq` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sortrank` (`sortrank`),
  KEY `mainindex` (`arcrank`,`typeid`,`channel`,`flag`,`mid`),
  KEY `lastpost` (`lastpost`,`scores`,`goodpost`,`badpost`,`notpost`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_arcmulti
-- ----------------------------
DROP TABLE IF EXISTS `dede_arcmulti`;
CREATE TABLE `dede_arcmulti` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `tagid` char(60) NOT NULL DEFAULT '',
  `uptime` int(11) NOT NULL DEFAULT '0',
  `innertext` varchar(255) NOT NULL DEFAULT '',
  `pagesize` int(11) NOT NULL DEFAULT '0',
  `arcids` text NOT NULL,
  `ordersql` varchar(255) DEFAULT NULL,
  `addfieldsSql` varchar(255) DEFAULT NULL,
  `addfieldsSqlJoin` varchar(255) DEFAULT NULL,
  `attstr` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_arcrank
-- ----------------------------
DROP TABLE IF EXISTS `dede_arcrank`;
CREATE TABLE `dede_arcrank` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `rank` smallint(6) NOT NULL DEFAULT '0',
  `membername` char(20) NOT NULL DEFAULT '',
  `adminrank` smallint(6) NOT NULL DEFAULT '0',
  `money` smallint(8) unsigned NOT NULL DEFAULT '500',
  `scores` mediumint(8) NOT NULL DEFAULT '0',
  `purviews` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_arctiny
-- ----------------------------
DROP TABLE IF EXISTS `dede_arctiny`;
CREATE TABLE `dede_arctiny` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `typeid2` varchar(90) NOT NULL DEFAULT '0',
  `arcrank` smallint(6) NOT NULL DEFAULT '0',
  `channel` smallint(5) NOT NULL DEFAULT '1',
  `senddate` int(10) unsigned NOT NULL DEFAULT '0',
  `sortrank` int(10) unsigned NOT NULL DEFAULT '0',
  `mid` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sortrank` (`sortrank`)
) ENGINE=MyISAM AUTO_INCREMENT=13483 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_arctype
-- ----------------------------
DROP TABLE IF EXISTS `dede_arctype`;
CREATE TABLE `dede_arctype` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `reid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `topid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `sortrank` smallint(5) unsigned NOT NULL DEFAULT '50',
  `typename` char(30) NOT NULL DEFAULT '',
  `typedir` char(60) NOT NULL DEFAULT '',
  `isdefault` smallint(6) NOT NULL DEFAULT '0',
  `defaultname` char(15) NOT NULL DEFAULT 'index.html',
  `issend` smallint(6) NOT NULL DEFAULT '0',
  `channeltype` smallint(6) DEFAULT '1',
  `maxpage` smallint(6) NOT NULL DEFAULT '-1',
  `ispart` smallint(6) NOT NULL DEFAULT '0',
  `corank` smallint(6) NOT NULL DEFAULT '0',
  `tempindex` char(50) NOT NULL DEFAULT '',
  `templist` char(50) NOT NULL DEFAULT '',
  `temparticle` char(50) NOT NULL DEFAULT '',
  `namerule` char(50) NOT NULL DEFAULT '',
  `namerule2` char(50) NOT NULL DEFAULT '',
  `modname` char(20) NOT NULL DEFAULT '',
  `description` char(150) NOT NULL DEFAULT '',
  `keywords` varchar(60) NOT NULL DEFAULT '',
  `seotitle` varchar(80) NOT NULL DEFAULT '',
  `moresite` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sitepath` char(60) NOT NULL DEFAULT '',
  `siteurl` char(50) NOT NULL DEFAULT '',
  `ishidden` smallint(6) NOT NULL DEFAULT '0',
  `cross` tinyint(1) NOT NULL DEFAULT '0',
  `crossid` text,
  `content` text,
  `smalltypes` text,
  PRIMARY KEY (`id`),
  KEY `reid` (`reid`,`isdefault`,`channeltype`,`ispart`,`corank`,`topid`,`ishidden`),
  KEY `sortrank` (`sortrank`)
) ENGINE=MyISAM AUTO_INCREMENT=7002 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_area
-- ----------------------------
DROP TABLE IF EXISTS `dede_area`;
CREATE TABLE `dede_area` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '',
  `reid` int(10) unsigned NOT NULL DEFAULT '0',
  `disorder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3118 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_channeltype
-- ----------------------------
DROP TABLE IF EXISTS `dede_channeltype`;
CREATE TABLE `dede_channeltype` (
  `id` smallint(6) NOT NULL DEFAULT '0',
  `nid` varchar(20) NOT NULL DEFAULT '',
  `typename` varchar(30) NOT NULL DEFAULT '',
  `maintable` varchar(50) NOT NULL DEFAULT 'dede_archives',
  `addtable` varchar(50) NOT NULL DEFAULT '',
  `addcon` varchar(30) NOT NULL DEFAULT '',
  `mancon` varchar(30) NOT NULL DEFAULT '',
  `editcon` varchar(30) NOT NULL DEFAULT '',
  `useraddcon` varchar(30) NOT NULL DEFAULT '',
  `usermancon` varchar(30) NOT NULL DEFAULT '',
  `usereditcon` varchar(30) NOT NULL DEFAULT '',
  `fieldset` text,
  `listfields` text,
  `allfields` text,
  `issystem` smallint(6) NOT NULL DEFAULT '0',
  `isshow` smallint(6) NOT NULL DEFAULT '1',
  `issend` smallint(6) NOT NULL DEFAULT '0',
  `arcsta` smallint(6) NOT NULL DEFAULT '-1',
  `usertype` char(10) NOT NULL DEFAULT '',
  `sendrank` smallint(6) NOT NULL DEFAULT '10',
  `isdefault` smallint(6) NOT NULL DEFAULT '0',
  `needdes` tinyint(1) NOT NULL DEFAULT '1',
  `needpic` tinyint(1) NOT NULL DEFAULT '1',
  `titlename` varchar(20) NOT NULL DEFAULT '标题',
  `onlyone` smallint(6) NOT NULL DEFAULT '0',
  `dfcid` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `nid` (`nid`,`isshow`,`arcsta`,`sendrank`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_co_htmls
-- ----------------------------
DROP TABLE IF EXISTS `dede_co_htmls`;
CREATE TABLE `dede_co_htmls` (
  `aid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `nid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `title` varchar(60) NOT NULL DEFAULT '',
  `litpic` varchar(100) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `dtime` int(10) unsigned NOT NULL DEFAULT '0',
  `isdown` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `isexport` tinyint(1) NOT NULL DEFAULT '0',
  `result` mediumtext,
  PRIMARY KEY (`aid`),
  KEY `nid` (`nid`),
  KEY `typeid` (`typeid`,`title`,`url`,`dtime`,`isdown`,`isexport`)
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_co_mediaurls
-- ----------------------------
DROP TABLE IF EXISTS `dede_co_mediaurls`;
CREATE TABLE `dede_co_mediaurls` (
  `nid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `hash` char(32) NOT NULL DEFAULT '',
  `tofile` char(60) NOT NULL DEFAULT '',
  KEY `hash` (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_co_note
-- ----------------------------
DROP TABLE IF EXISTS `dede_co_note`;
CREATE TABLE `dede_co_note` (
  `nid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `channelid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `notename` varchar(50) NOT NULL DEFAULT '',
  `sourcelang` varchar(10) NOT NULL DEFAULT 'gb2312',
  `uptime` int(10) unsigned NOT NULL DEFAULT '0',
  `cotime` int(10) unsigned NOT NULL DEFAULT '0',
  `pnum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `isok` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `usemore` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `listconfig` text,
  `itemconfig` text,
  PRIMARY KEY (`nid`),
  KEY `isok` (`isok`,`channelid`,`cotime`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_co_onepage
-- ----------------------------
DROP TABLE IF EXISTS `dede_co_onepage`;
CREATE TABLE `dede_co_onepage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(60) NOT NULL DEFAULT '',
  `title` varchar(60) NOT NULL DEFAULT '',
  `issource` smallint(6) NOT NULL DEFAULT '1',
  `lang` varchar(10) NOT NULL DEFAULT 'gb2312',
  `rule` text,
  PRIMARY KEY (`id`),
  KEY `url` (`url`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_co_urls
-- ----------------------------
DROP TABLE IF EXISTS `dede_co_urls`;
CREATE TABLE `dede_co_urls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) NOT NULL DEFAULT '',
  `nid` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_diyforms
-- ----------------------------
DROP TABLE IF EXISTS `dede_diyforms`;
CREATE TABLE `dede_diyforms` (
  `diyid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `posttemplate` varchar(50) NOT NULL,
  `viewtemplate` varchar(50) NOT NULL,
  `listtemplate` varchar(50) NOT NULL,
  `table` varchar(50) NOT NULL DEFAULT '',
  `info` text,
  `public` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`diyid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_dl_log
-- ----------------------------
DROP TABLE IF EXISTS `dede_dl_log`;
CREATE TABLE `dede_dl_log` (
  `id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip` char(16) NOT NULL,
  `lang` char(6) NOT NULL,
  `dtype` varchar(10) NOT NULL,
  `dltime` int(10) unsigned NOT NULL DEFAULT '0',
  `referrer` varchar(255) NOT NULL DEFAULT '',
  `user_agent` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dltime` (`dltime`),
  KEY `dl_ip` (`ip`,`dltime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_downloads
-- ----------------------------
DROP TABLE IF EXISTS `dede_downloads`;
CREATE TABLE `dede_downloads` (
  `hash` char(32) NOT NULL,
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  `downloads` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_erradd
-- ----------------------------
DROP TABLE IF EXISTS `dede_erradd`;
CREATE TABLE `dede_erradd` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `aid` mediumint(8) unsigned NOT NULL,
  `mid` mediumint(8) unsigned DEFAULT NULL,
  `title` char(60) NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT '0',
  `errtxt` mediumtext,
  `oktxt` mediumtext,
  `sendtime` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_feedback
-- ----------------------------
DROP TABLE IF EXISTS `dede_feedback`;
CREATE TABLE `dede_feedback` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `username` char(20) NOT NULL DEFAULT '',
  `arctitle` varchar(60) NOT NULL DEFAULT '',
  `ip` char(15) NOT NULL DEFAULT '',
  `ischeck` smallint(6) NOT NULL DEFAULT '0',
  `dtime` int(10) unsigned NOT NULL DEFAULT '0',
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `bad` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `good` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ftype` set('feedback','good','bad') NOT NULL DEFAULT 'feedback',
  `face` smallint(5) unsigned NOT NULL DEFAULT '0',
  `msg` text,
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`,`ischeck`,`mid`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_flink
-- ----------------------------
DROP TABLE IF EXISTS `dede_flink`;
CREATE TABLE `dede_flink` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `sortrank` smallint(6) NOT NULL DEFAULT '0',
  `url` char(60) NOT NULL DEFAULT '',
  `webname` char(30) NOT NULL DEFAULT '',
  `msg` char(200) NOT NULL DEFAULT '',
  `email` char(50) NOT NULL DEFAULT '',
  `logo` char(60) NOT NULL DEFAULT '',
  `dtime` int(10) unsigned NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ischeck` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_flinktype
-- ----------------------------
DROP TABLE IF EXISTS `dede_flinktype`;
CREATE TABLE `dede_flinktype` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `typename` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_freelist
-- ----------------------------
DROP TABLE IF EXISTS `dede_freelist`;
CREATE TABLE `dede_freelist` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL DEFAULT '',
  `namerule` varchar(50) NOT NULL DEFAULT '',
  `listdir` varchar(60) NOT NULL DEFAULT '',
  `defaultpage` varchar(20) NOT NULL DEFAULT '',
  `nodefault` smallint(6) NOT NULL DEFAULT '0',
  `templet` varchar(50) NOT NULL DEFAULT '',
  `edtime` int(11) NOT NULL DEFAULT '0',
  `maxpage` smallint(5) unsigned NOT NULL DEFAULT '100',
  `click` int(11) NOT NULL DEFAULT '1',
  `listtag` mediumtext,
  `keywords` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_homepageset
-- ----------------------------
DROP TABLE IF EXISTS `dede_homepageset`;
CREATE TABLE `dede_homepageset` (
  `templet` char(50) NOT NULL DEFAULT '',
  `position` char(30) NOT NULL DEFAULT '',
  `showmod` tinyint(2) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_keywords
-- ----------------------------
DROP TABLE IF EXISTS `dede_keywords`;
CREATE TABLE `dede_keywords` (
  `aid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `keyword` char(16) NOT NULL DEFAULT '',
  `rank` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `sta` smallint(6) NOT NULL DEFAULT '1',
  `rpurl` char(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`),
  KEY `keyword` (`keyword`,`rank`,`sta`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_log
-- ----------------------------
DROP TABLE IF EXISTS `dede_log`;
CREATE TABLE `dede_log` (
  `lid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `adminid` smallint(8) unsigned NOT NULL DEFAULT '0',
  `filename` char(60) NOT NULL DEFAULT '',
  `method` char(10) NOT NULL DEFAULT '',
  `query` char(200) NOT NULL DEFAULT '',
  `cip` char(15) NOT NULL DEFAULT '',
  `dtime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member
-- ----------------------------
DROP TABLE IF EXISTS `dede_member`;
CREATE TABLE `dede_member` (
  `mid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `mtype` varchar(20) NOT NULL DEFAULT '个人',
  `userid` char(20) NOT NULL DEFAULT '',
  `pwd` char(32) NOT NULL DEFAULT '',
  `uname` char(36) NOT NULL DEFAULT '',
  `sex` enum('男','女','保密') NOT NULL DEFAULT '保密',
  `rank` smallint(5) unsigned NOT NULL DEFAULT '0',
  `uptime` int(11) NOT NULL DEFAULT '0',
  `exptime` smallint(6) NOT NULL DEFAULT '0',
  `money` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `email` char(50) NOT NULL DEFAULT '',
  `scores` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `matt` smallint(5) unsigned NOT NULL DEFAULT '0',
  `spacesta` smallint(6) NOT NULL DEFAULT '0',
  `face` char(50) NOT NULL DEFAULT '',
  `safequestion` smallint(5) unsigned NOT NULL DEFAULT '0',
  `safeanswer` char(30) NOT NULL DEFAULT '',
  `jointime` int(10) unsigned NOT NULL DEFAULT '0',
  `joinip` char(16) NOT NULL DEFAULT '',
  `logintime` int(10) unsigned NOT NULL DEFAULT '0',
  `loginip` char(16) NOT NULL DEFAULT '',
  `towids` char(100) DEFAULT NULL,
  `toworone` char(100) DEFAULT 'one',
  `mylove` char(100) DEFAULT NULL,
  `zan` int(11) NOT NULL DEFAULT '0',
  `checkmail` smallint(6) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`mid`),
  KEY `userid` (`userid`,`sex`),
  KEY `logintime` (`logintime`)
) ENGINE=MyISAM AUTO_INCREMENT=2234 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_company
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_company`;
CREATE TABLE `dede_member_company` (
  `mid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `company` varchar(36) NOT NULL DEFAULT '',
  `product` varchar(50) NOT NULL DEFAULT '',
  `place` smallint(5) unsigned NOT NULL DEFAULT '0',
  `vocation` smallint(5) unsigned NOT NULL DEFAULT '0',
  `cosize` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tel` varchar(30) NOT NULL DEFAULT '',
  `fax` varchar(30) NOT NULL DEFAULT '',
  `linkman` varchar(20) NOT NULL DEFAULT '',
  `address` varchar(50) NOT NULL DEFAULT '',
  `mobile` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(50) NOT NULL DEFAULT '',
  `uptime` int(10) unsigned NOT NULL DEFAULT '0',
  `checked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `introduce` text,
  `comface` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_feed
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_feed`;
CREATE TABLE `dede_member_feed` (
  `fid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `mid` smallint(8) unsigned NOT NULL DEFAULT '0',
  `userid` char(20) NOT NULL DEFAULT '',
  `uname` char(36) NOT NULL DEFAULT '',
  `type` char(20) CHARACTER SET gb2312 NOT NULL DEFAULT '0',
  `aid` mediumint(8) NOT NULL DEFAULT '0',
  `dtime` int(10) unsigned NOT NULL DEFAULT '0',
  `title` char(253) NOT NULL,
  `note` char(200) NOT NULL DEFAULT '',
  `ischeck` smallint(6) NOT NULL,
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_flink
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_flink`;
CREATE TABLE `dede_member_flink` (
  `aid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` varchar(30) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=103 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_friends
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_friends`;
CREATE TABLE `dede_member_friends` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `floginid` char(20) NOT NULL DEFAULT '',
  `funame` char(36) NOT NULL DEFAULT '',
  `mid` mediumint(8) NOT NULL DEFAULT '0',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  `ftype` tinyint(4) NOT NULL DEFAULT '0',
  `groupid` int(8) NOT NULL DEFAULT '1',
  `description` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fid` (`fid`,`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_group
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_group`;
CREATE TABLE `dede_member_group` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `groupname` varchar(50) NOT NULL,
  `mid` int(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_guestbook
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_guestbook`;
CREATE TABLE `dede_member_guestbook` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `gid` varchar(20) NOT NULL DEFAULT '0',
  `title` varchar(60) NOT NULL DEFAULT '',
  `uname` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `qq` varchar(50) NOT NULL DEFAULT '',
  `tel` varchar(50) NOT NULL DEFAULT '',
  `ip` varchar(20) NOT NULL DEFAULT '',
  `dtime` int(10) unsigned NOT NULL DEFAULT '0',
  `wishtype` varchar(100) DEFAULT 'book',
  `msg` text,
  PRIMARY KEY (`aid`),
  KEY `mid` (`mid`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_model
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_model`;
CREATE TABLE `dede_member_model` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `table` varchar(30) NOT NULL,
  `description` varchar(50) NOT NULL,
  `state` int(2) NOT NULL DEFAULT '0',
  `issystem` int(2) NOT NULL DEFAULT '0',
  `info` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_msg
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_msg`;
CREATE TABLE `dede_member_msg` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `userid` char(20) NOT NULL DEFAULT '',
  `ip` char(15) NOT NULL DEFAULT '',
  `ischeck` smallint(6) NOT NULL DEFAULT '0',
  `dtime` int(10) unsigned NOT NULL DEFAULT '0',
  `msg` text,
  PRIMARY KEY (`id`),
  KEY `id` (`ischeck`,`mid`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_operation
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_operation`;
CREATE TABLE `dede_member_operation` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `buyid` varchar(80) NOT NULL DEFAULT '',
  `pname` varchar(50) NOT NULL DEFAULT '',
  `product` varchar(10) NOT NULL DEFAULT '',
  `money` int(11) NOT NULL DEFAULT '0',
  `mtime` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `mid` int(11) NOT NULL DEFAULT '0',
  `sta` int(11) NOT NULL DEFAULT '0',
  `oldinfo` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`),
  KEY `buyid` (`buyid`),
  KEY `pid` (`pid`,`mid`,`sta`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_person
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_person`;
CREATE TABLE `dede_member_person` (
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `onlynet` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `sex` enum('男孩','女孩','男人','女人','男神','女神','保密') DEFAULT NULL,
  `uname` char(30) NOT NULL DEFAULT '',
  `qq` char(12) NOT NULL DEFAULT '',
  `msn` char(50) NOT NULL DEFAULT '',
  `tel` varchar(15) NOT NULL DEFAULT '',
  `mobile` varchar(15) NOT NULL DEFAULT '',
  `place` smallint(5) unsigned NOT NULL DEFAULT '0',
  `oldplace` smallint(5) unsigned NOT NULL DEFAULT '0',
  `birthday` date NOT NULL DEFAULT '1980-01-01',
  `star` smallint(6) unsigned NOT NULL DEFAULT '1',
  `income` smallint(6) NOT NULL DEFAULT '0',
  `education` smallint(6) NOT NULL DEFAULT '0',
  `height` smallint(5) unsigned NOT NULL DEFAULT '160',
  `bodytype` smallint(6) NOT NULL DEFAULT '0',
  `blood` smallint(6) NOT NULL DEFAULT '0',
  `vocation` smallint(6) NOT NULL DEFAULT '0',
  `smoke` smallint(6) NOT NULL DEFAULT '0',
  `marital` smallint(6) NOT NULL DEFAULT '0',
  `house` smallint(6) NOT NULL DEFAULT '0',
  `drink` smallint(6) NOT NULL DEFAULT '0',
  `datingtype` smallint(6) NOT NULL DEFAULT '0',
  `language` set('普通话','上海话','广东话','英语','日语','韩语','法语','意大利语','德语','西班牙语','俄语','阿拉伯语') DEFAULT NULL,
  `nature` varchar(1000) DEFAULT NULL,
  `lovemsg` varchar(100) NOT NULL DEFAULT '',
  `address` varchar(50) NOT NULL DEFAULT '',
  `uptime` int(10) unsigned NOT NULL DEFAULT '0',
  `zzzlyb` varchar(250) NOT NULL DEFAULT '来客留言',
  `zzzshowbook` char(100) NOT NULL DEFAULT '1',
  `zzzsiren` varchar(250) NOT NULL DEFAULT '2',
  `zzzwishopen` varchar(250) NOT NULL DEFAULT 'yes',
  `zzzbgbg` varchar(250) NOT NULL DEFAULT '/templets/default/diary/index_bg1.jpg',
  `zzzyinyue` varchar(250) DEFAULT '0',
  `zzzdisplaymima` char(100) DEFAULT NULL,
  `zzzlovetime` date DEFAULT NULL,
  `zzzbgx` char(100) NOT NULL DEFAULT 'me',
  PRIMARY KEY (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_pms
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_pms`;
CREATE TABLE `dede_member_pms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `floginid` varchar(20) NOT NULL DEFAULT '',
  `fromid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `toid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `tologinid` char(20) NOT NULL DEFAULT '',
  `folder` enum('inbox','outbox') DEFAULT 'inbox',
  `subject` varchar(60) NOT NULL DEFAULT '',
  `sendtime` int(10) unsigned NOT NULL DEFAULT '0',
  `writetime` int(10) unsigned NOT NULL DEFAULT '0',
  `hasview` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `isadmin` tinyint(1) NOT NULL DEFAULT '0',
  `message` mediumtext,
  `toworone` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sendtime` (`sendtime`)
) ENGINE=MyISAM AUTO_INCREMENT=319 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_snsmsg
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_snsmsg`;
CREATE TABLE `dede_member_snsmsg` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `userid` varchar(20) NOT NULL,
  `sendtime` int(10) unsigned NOT NULL DEFAULT '0',
  `msg` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_space
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_space`;
CREATE TABLE `dede_member_space` (
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `pagesize` smallint(5) unsigned NOT NULL DEFAULT '15',
  `matt` smallint(6) NOT NULL DEFAULT '0',
  `spacename` varchar(50) NOT NULL DEFAULT '',
  `spacelogo` varchar(50) NOT NULL DEFAULT '',
  `spacestyle` varchar(20) NOT NULL DEFAULT '',
  `sign` varchar(100) NOT NULL DEFAULT '没签名',
  `spacenews` text,
  PRIMARY KEY (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_stow
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_stow`;
CREATE TABLE `dede_member_stow` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` char(60) NOT NULL DEFAULT '',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`mid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_stowtype
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_stowtype`;
CREATE TABLE `dede_member_stowtype` (
  `stowname` varchar(30) NOT NULL,
  `indexname` varchar(30) NOT NULL,
  `indexurl` varchar(50) NOT NULL,
  PRIMARY KEY (`stowname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_tj
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_tj`;
CREATE TABLE `dede_member_tj` (
  `mid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `article` smallint(5) unsigned NOT NULL DEFAULT '0',
  `album` smallint(5) unsigned NOT NULL DEFAULT '0',
  `archives` smallint(5) unsigned NOT NULL DEFAULT '0',
  `homecount` int(10) unsigned NOT NULL DEFAULT '0',
  `pagecount` int(10) unsigned NOT NULL DEFAULT '0',
  `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `friend` smallint(5) unsigned NOT NULL DEFAULT '0',
  `stow` smallint(5) unsigned NOT NULL DEFAULT '0',
  `soft` int(10) NOT NULL DEFAULT '0',
  `info` int(10) NOT NULL DEFAULT '0',
  `shop` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`mid`)
) ENGINE=MyISAM AUTO_INCREMENT=2234 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_type
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_type`;
CREATE TABLE `dede_member_type` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `rank` int(11) NOT NULL DEFAULT '0',
  `pname` varchar(50) NOT NULL DEFAULT '',
  `money` int(11) NOT NULL DEFAULT '0',
  `exptime` int(11) NOT NULL DEFAULT '30',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_member_vhistory
-- ----------------------------
DROP TABLE IF EXISTS `dede_member_vhistory`;
CREATE TABLE `dede_member_vhistory` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `loginid` char(20) NOT NULL DEFAULT '',
  `vid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vloginid` char(20) NOT NULL DEFAULT '',
  `count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `vip` char(15) NOT NULL DEFAULT '',
  `vtime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vtime` (`vtime`),
  KEY `mid` (`mid`,`vid`)
) ENGINE=MyISAM AUTO_INCREMENT=103 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_moneycard_record
-- ----------------------------
DROP TABLE IF EXISTS `dede_moneycard_record`;
CREATE TABLE `dede_moneycard_record` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `ctid` int(11) NOT NULL DEFAULT '0',
  `cardid` varchar(50) NOT NULL DEFAULT '',
  `uid` int(11) NOT NULL DEFAULT '0',
  `isexp` smallint(6) NOT NULL DEFAULT '0',
  `mtime` int(11) NOT NULL DEFAULT '0',
  `utime` int(11) NOT NULL DEFAULT '0',
  `money` int(11) NOT NULL DEFAULT '0',
  `num` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`),
  KEY `ctid` (`ctid`),
  KEY `cardid` (`cardid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_moneycard_type
-- ----------------------------
DROP TABLE IF EXISTS `dede_moneycard_type`;
CREATE TABLE `dede_moneycard_type` (
  `tid` int(11) NOT NULL AUTO_INCREMENT,
  `num` int(11) NOT NULL DEFAULT '500',
  `money` int(11) NOT NULL DEFAULT '50',
  `pname` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`tid`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_mtypes
-- ----------------------------
DROP TABLE IF EXISTS `dede_mtypes`;
CREATE TABLE `dede_mtypes` (
  `mtypeid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `mtypename` char(40) NOT NULL,
  `channelid` smallint(6) NOT NULL DEFAULT '1',
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`mtypeid`)
) ENGINE=MyISAM AUTO_INCREMENT=2175 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_multiserv_config
-- ----------------------------
DROP TABLE IF EXISTS `dede_multiserv_config`;
CREATE TABLE `dede_multiserv_config` (
  `remoteuploads` smallint(6) NOT NULL DEFAULT '0',
  `remoteupUrl` text NOT NULL,
  `rminfo` text,
  `servinfo` mediumtext,
  PRIMARY KEY (`remoteuploads`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_myad
-- ----------------------------
DROP TABLE IF EXISTS `dede_myad`;
CREATE TABLE `dede_myad` (
  `aid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `clsid` smallint(5) NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tagname` varchar(30) NOT NULL DEFAULT '',
  `adname` varchar(60) NOT NULL DEFAULT '',
  `timeset` smallint(6) NOT NULL DEFAULT '0',
  `starttime` int(10) unsigned NOT NULL DEFAULT '0',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0',
  `normbody` text,
  `expbody` text,
  PRIMARY KEY (`aid`),
  KEY `tagname` (`tagname`,`typeid`,`timeset`,`endtime`,`starttime`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_myadtype
-- ----------------------------
DROP TABLE IF EXISTS `dede_myadtype`;
CREATE TABLE `dede_myadtype` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `typename` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_mytag
-- ----------------------------
DROP TABLE IF EXISTS `dede_mytag`;
CREATE TABLE `dede_mytag` (
  `aid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tagname` varchar(30) NOT NULL DEFAULT '',
  `timeset` smallint(6) NOT NULL DEFAULT '0',
  `starttime` int(10) unsigned NOT NULL DEFAULT '0',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0',
  `normbody` text,
  `expbody` text,
  PRIMARY KEY (`aid`),
  KEY `tagname` (`tagname`,`typeid`,`timeset`,`endtime`,`starttime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_payment
-- ----------------------------
DROP TABLE IF EXISTS `dede_payment`;
CREATE TABLE `dede_payment` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(120) NOT NULL DEFAULT '',
  `fee` varchar(10) NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `rank` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `config` text NOT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `cod` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `online` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_plus
-- ----------------------------
DROP TABLE IF EXISTS `dede_plus`;
CREATE TABLE `dede_plus` (
  `aid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `plusname` varchar(30) NOT NULL DEFAULT '',
  `menustring` varchar(200) NOT NULL DEFAULT '',
  `mainurl` varchar(50) NOT NULL DEFAULT '',
  `writer` varchar(30) NOT NULL DEFAULT '',
  `isshow` smallint(6) NOT NULL DEFAULT '1',
  `filelist` text,
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_plus_changyan_importids
-- ----------------------------
DROP TABLE IF EXISTS `dede_plus_changyan_importids`;
CREATE TABLE `dede_plus_changyan_importids` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0',
  `feedback_id` int(12) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `feedback_id` (`feedback_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_plus_changyan_insertids
-- ----------------------------
DROP TABLE IF EXISTS `dede_plus_changyan_insertids`;
CREATE TABLE `dede_plus_changyan_insertids` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0',
  `comment_id` int(12) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `comment_id` (`comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_plus_changyan_setting
-- ----------------------------
DROP TABLE IF EXISTS `dede_plus_changyan_setting`;
CREATE TABLE `dede_plus_changyan_setting` (
  `skey` varchar(255) NOT NULL DEFAULT '',
  `svalue` text NOT NULL,
  `stime` int(10) NOT NULL,
  PRIMARY KEY (`skey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_purview
-- ----------------------------
DROP TABLE IF EXISTS `dede_purview`;
CREATE TABLE `dede_purview` (
  `mid` mediumint(8) DEFAULT '0',
  `typeid` smallint(5) DEFAULT '0',
  `rank` smallint(6) DEFAULT NULL,
  `pkey` varchar(30) CHARACTER SET latin1 NOT NULL,
  `pvalue` text NOT NULL,
  KEY `pkey` (`pkey`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_pwd_tmp
-- ----------------------------
DROP TABLE IF EXISTS `dede_pwd_tmp`;
CREATE TABLE `dede_pwd_tmp` (
  `mid` mediumint(8) NOT NULL,
  `membername` char(16) NOT NULL DEFAULT '',
  `pwd` char(32) NOT NULL DEFAULT '',
  `mailtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_ratings
-- ----------------------------
DROP TABLE IF EXISTS `dede_ratings`;
CREATE TABLE `dede_ratings` (
  `id` varchar(11) NOT NULL,
  `total_votes` int(11) NOT NULL DEFAULT '0',
  `total_value` int(11) NOT NULL DEFAULT '0',
  `used_ips` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_scores
-- ----------------------------
DROP TABLE IF EXISTS `dede_scores`;
CREATE TABLE `dede_scores` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `titles` char(15) NOT NULL,
  `icon` smallint(6) unsigned DEFAULT '0',
  `integral` int(10) NOT NULL DEFAULT '0',
  `isdefault` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `integral` (`integral`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_search_cache
-- ----------------------------
DROP TABLE IF EXISTS `dede_search_cache`;
CREATE TABLE `dede_search_cache` (
  `hash` char(32) NOT NULL,
  `lasttime` int(10) unsigned NOT NULL DEFAULT '0',
  `rsnum` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ids` mediumtext,
  PRIMARY KEY (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_search_keywords
-- ----------------------------
DROP TABLE IF EXISTS `dede_search_keywords`;
CREATE TABLE `dede_search_keywords` (
  `aid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `keyword` char(30) NOT NULL DEFAULT '',
  `spwords` char(50) NOT NULL DEFAULT '',
  `count` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `result` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `lasttime` int(10) unsigned NOT NULL DEFAULT '0',
  `channelid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_sgpage
-- ----------------------------
DROP TABLE IF EXISTS `dede_sgpage`;
CREATE TABLE `dede_sgpage` (
  `aid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) NOT NULL DEFAULT '',
  `ismake` smallint(6) NOT NULL DEFAULT '1',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `keywords` varchar(30) NOT NULL DEFAULT '',
  `template` varchar(30) NOT NULL DEFAULT '',
  `likeid` varchar(20) NOT NULL DEFAULT '',
  `description` varchar(250) NOT NULL DEFAULT '',
  `uptime` int(10) unsigned NOT NULL DEFAULT '0',
  `body` mediumtext,
  PRIMARY KEY (`aid`),
  KEY `ismake` (`ismake`,`uptime`),
  KEY `likeid` (`likeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_shops_delivery
-- ----------------------------
DROP TABLE IF EXISTS `dede_shops_delivery`;
CREATE TABLE `dede_shops_delivery` (
  `pid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dname` char(80) NOT NULL,
  `price` float(13,2) NOT NULL DEFAULT '0.00',
  `des` char(255) DEFAULT NULL,
  `orders` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `orders` (`orders`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_shops_orders
-- ----------------------------
DROP TABLE IF EXISTS `dede_shops_orders`;
CREATE TABLE `dede_shops_orders` (
  `oid` varchar(80) NOT NULL,
  `userid` int(10) NOT NULL,
  `pid` int(10) NOT NULL DEFAULT '0',
  `paytype` tinyint(2) NOT NULL DEFAULT '1',
  `cartcount` int(10) NOT NULL DEFAULT '0',
  `dprice` float(13,2) NOT NULL DEFAULT '0.00',
  `price` float(13,2) NOT NULL DEFAULT '0.00',
  `priceCount` float(13,2) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL DEFAULT '',
  `stime` int(10) NOT NULL DEFAULT '0',
  KEY `stime` (`stime`),
  KEY `userid` (`userid`),
  KEY `oid` (`oid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_shops_products
-- ----------------------------
DROP TABLE IF EXISTS `dede_shops_products`;
CREATE TABLE `dede_shops_products` (
  `aid` mediumint(8) NOT NULL DEFAULT '0',
  `oid` varchar(80) NOT NULL DEFAULT '',
  `userid` int(10) NOT NULL,
  `title` varchar(80) NOT NULL DEFAULT '',
  `price` float(13,2) NOT NULL DEFAULT '0.00',
  `buynum` int(10) NOT NULL DEFAULT '9',
  KEY `oid` (`oid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_shops_userinfo
-- ----------------------------
DROP TABLE IF EXISTS `dede_shops_userinfo`;
CREATE TABLE `dede_shops_userinfo` (
  `userid` int(10) NOT NULL,
  `oid` varchar(80) NOT NULL DEFAULT '',
  `consignee` char(15) NOT NULL DEFAULT '',
  `address` varchar(255) NOT NULL DEFAULT '',
  `zip` int(10) NOT NULL DEFAULT '0',
  `tel` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `des` varchar(255) NOT NULL DEFAULT '',
  KEY `oid` (`oid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_softconfig
-- ----------------------------
DROP TABLE IF EXISTS `dede_softconfig`;
CREATE TABLE `dede_softconfig` (
  `downtype` smallint(6) NOT NULL DEFAULT '0',
  `ismoresite` smallint(6) NOT NULL DEFAULT '0',
  `gotojump` smallint(6) NOT NULL DEFAULT '0',
  `islocal` smallint(5) unsigned NOT NULL DEFAULT '1',
  `sites` text,
  `downmsg` text,
  `moresitedo` smallint(5) unsigned NOT NULL DEFAULT '1',
  `dfrank` smallint(5) unsigned NOT NULL DEFAULT '0',
  `dfywboy` smallint(5) unsigned NOT NULL DEFAULT '0',
  `argrange` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`downtype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_sphinx
-- ----------------------------
DROP TABLE IF EXISTS `dede_sphinx`;
CREATE TABLE `dede_sphinx` (
  `countid` int(11) unsigned NOT NULL,
  `maxaid` int(11) unsigned NOT NULL,
  PRIMARY KEY (`countid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_stepselect
-- ----------------------------
DROP TABLE IF EXISTS `dede_stepselect`;
CREATE TABLE `dede_stepselect` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `itemname` char(30) DEFAULT NULL,
  `egroup` char(20) DEFAULT NULL,
  `issign` tinyint(1) unsigned DEFAULT '0',
  `issystem` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_sys_enum
-- ----------------------------
DROP TABLE IF EXISTS `dede_sys_enum`;
CREATE TABLE `dede_sys_enum` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `ename` char(30) NOT NULL DEFAULT '',
  `evalue` char(20) NOT NULL DEFAULT '0',
  `egroup` char(20) NOT NULL DEFAULT '',
  `disorder` smallint(5) unsigned NOT NULL DEFAULT '0',
  `issign` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=20020 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_sys_module
-- ----------------------------
DROP TABLE IF EXISTS `dede_sys_module`;
CREATE TABLE `dede_sys_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hashcode` char(32) NOT NULL DEFAULT '',
  `modname` varchar(30) NOT NULL DEFAULT '',
  `indexname` varchar(20) NOT NULL DEFAULT '',
  `indexurl` varchar(30) NOT NULL DEFAULT '',
  `ismember` tinyint(4) NOT NULL DEFAULT '1',
  `menustring` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_sys_set
-- ----------------------------
DROP TABLE IF EXISTS `dede_sys_set`;
CREATE TABLE `dede_sys_set` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `sname` char(20) NOT NULL DEFAULT '',
  `items` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_sys_task
-- ----------------------------
DROP TABLE IF EXISTS `dede_sys_task`;
CREATE TABLE `dede_sys_task` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `taskname` varchar(50) NOT NULL,
  `dourl` varchar(100) NOT NULL,
  `islock` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `runtype` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `runtime` varchar(10) DEFAULT '0000',
  `starttime` int(10) unsigned NOT NULL DEFAULT '0',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0',
  `freq` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `lastrun` int(10) unsigned NOT NULL DEFAULT '0',
  `description` varchar(250) NOT NULL,
  `parameter` text,
  `settime` int(10) unsigned NOT NULL DEFAULT '0',
  `sta` enum('运行','成功','失败') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_sysconfig
-- ----------------------------
DROP TABLE IF EXISTS `dede_sysconfig`;
CREATE TABLE `dede_sysconfig` (
  `aid` smallint(8) unsigned NOT NULL DEFAULT '0',
  `varname` varchar(20) NOT NULL DEFAULT '',
  `info` varchar(500) NOT NULL DEFAULT '',
  `groupid` smallint(6) NOT NULL DEFAULT '1',
  `type` varchar(10) NOT NULL DEFAULT 'string',
  `value` text,
  PRIMARY KEY (`varname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_tagindex
-- ----------------------------
DROP TABLE IF EXISTS `dede_tagindex`;
CREATE TABLE `dede_tagindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` char(12) NOT NULL DEFAULT '',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `total` int(10) unsigned NOT NULL DEFAULT '0',
  `weekcc` int(10) unsigned NOT NULL DEFAULT '0',
  `monthcc` int(10) unsigned NOT NULL DEFAULT '0',
  `weekup` int(10) unsigned NOT NULL DEFAULT '0',
  `monthup` int(10) unsigned NOT NULL DEFAULT '0',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_taglist
-- ----------------------------
DROP TABLE IF EXISTS `dede_taglist`;
CREATE TABLE `dede_taglist` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `aid` int(10) unsigned NOT NULL DEFAULT '0',
  `arcrank` smallint(6) NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tag` varchar(12) NOT NULL DEFAULT '',
  PRIMARY KEY (`tid`,`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_uploads
-- ----------------------------
DROP TABLE IF EXISTS `dede_uploads`;
CREATE TABLE `dede_uploads` (
  `aid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `arcid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` char(60) NOT NULL DEFAULT '',
  `url` char(80) NOT NULL DEFAULT '',
  `mediatype` smallint(6) NOT NULL DEFAULT '1',
  `width` char(10) NOT NULL DEFAULT '',
  `height` char(10) NOT NULL DEFAULT '',
  `playtime` char(10) NOT NULL DEFAULT '',
  `filesize` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `uptime` int(10) unsigned NOT NULL DEFAULT '0',
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`),
  KEY `memberid` (`mid`),
  KEY `arcid` (`arcid`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_verifies
-- ----------------------------
DROP TABLE IF EXISTS `dede_verifies`;
CREATE TABLE `dede_verifies` (
  `nameid` char(32) NOT NULL DEFAULT '',
  `cthash` varchar(32) NOT NULL DEFAULT '',
  `method` enum('local','official') NOT NULL DEFAULT 'official',
  `filename` varchar(254) NOT NULL DEFAULT '',
  PRIMARY KEY (`nameid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_vote
-- ----------------------------
DROP TABLE IF EXISTS `dede_vote`;
CREATE TABLE `dede_vote` (
  `aid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `votename` varchar(50) NOT NULL DEFAULT '',
  `starttime` int(10) unsigned NOT NULL DEFAULT '0',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0',
  `totalcount` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ismore` tinyint(6) NOT NULL DEFAULT '0',
  `isallow` tinyint(6) NOT NULL DEFAULT '0',
  `view` tinyint(6) NOT NULL DEFAULT '0',
  `spec` int(20) unsigned NOT NULL DEFAULT '0',
  `isenable` tinyint(6) NOT NULL DEFAULT '0',
  `votenote` text,
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_vote_member
-- ----------------------------
DROP TABLE IF EXISTS `dede_vote_member`;
CREATE TABLE `dede_vote_member` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `voteid` int(10) unsigned NOT NULL DEFAULT '0',
  `userid` varchar(50) NOT NULL DEFAULT '',
  `uptime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_zan
-- ----------------------------
DROP TABLE IF EXISTS `dede_zan`;
CREATE TABLE `dede_zan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL,
  `ip` varchar(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for dede_zmusic
-- ----------------------------
DROP TABLE IF EXISTS `dede_zmusic`;
CREATE TABLE `dede_zmusic` (
  `aid` int(11) NOT NULL DEFAULT '0',
  `typeid` int(11) NOT NULL DEFAULT '0',
  `redirecturl` varchar(255) NOT NULL DEFAULT '',
  `templet` varchar(30) NOT NULL DEFAULT '',
  `userip` char(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`),
  KEY `typeid` (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `dede_addonarticle` VALUES ('5179', '58', '<br>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《小时代》里的顾里，她集中了天下所有女人的理智，冷静，残酷，给人留下了深刻的印象。虽然她说话很毒，却很实在，句句珠玑。老娘就是这么有态度，不喜欢的可以走开。也许，做人有时真得像顾里那样有点态度，每个人都该看看顾里说过的话。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">1.你什么货色，我就什么脸色。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4825t0ydubgrnfi.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">2.没有人能替你承受痛苦，也没有人能拿走你的坚强。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_48253sr0rdlsf14.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">3.那些泼过我冷水的人，总有一天我会烧开了还给你们的。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_48250utub1zatf2.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">4.破坏关系的最好方法就是听信谣言。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4825poifwhphz3d.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">5.我不知道什么叫年少轻狂，我只知道什么叫胜者为王。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_48252ob0hqdxlsh.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">6.别给我脸色看，你的脸又不是调色盘。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4826edr4evow53c.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">7.男人是容易被勾引的，如果你拿他像儿子一样伺候，就别怪他在外面给你找儿媳妇。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_48261jizcxcbjo3.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">8.有时候女人需要一个男人，就像逃机者需要降落伞，如果此时此刻他不在，那么以后他也不必在了。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4826nidb3njdwsw.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">9.感谢那些在我背后说我坏话和骂我的人，也感激那些嫉妒我的人，你们简直比我爸妈还关注我的点点滴滴，真是谢谢你们了。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4827xch4kpsciku.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">10.谢谢你总是在没有人陪的时候想起我，但我不缺你。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4827wjyor45udsi.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">11.别用你那盗版蒙娜丽莎般的微笑冲着我，我的胃没你想象的那么坚强。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_48273qcjzpeuqzk.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">12.非让现实给你一巴掌，你才知道现实有多残忍。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4827bhmqf55gtyb.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">13.对于喜欢你的人，你的小缺点小任性都是可爱的，对于不喜欢你的人，你的小清新小优雅都是做作。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4827r15lu2xpcvc.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">14.只要你按时达到目的地，很少有人在乎你开的是奔驰还是手动拖拉机。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4827d1b1hjufwpi.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">15.小事要稳，大事要狠。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4827msuw5cp23ts.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">16.不要轻易试探朋友，不然会失望更多。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_48275cm52adnjjx.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">17.没死，就别把自己当废物。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4827d0z01yzw30r.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">18.不是所有女人都叫女人，女人再要求男人更爷们的同时也应该让自己跟周围的朋友同事感觉更加赏心悦目，时常选择凸显形体的服装，别老穿童装跟个智障儿似得。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4827e50vfi0xaxw.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">19.走不进的世界就不要硬挤了。难为了别人，作贱了自己，何必呢？</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4828t0qbic4zqyw.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">20.错过我，真替你感到难过。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"小时代里女王的名言，句句“毒”到骨髓！_小时代,娱乐,台词,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4828i3nbe53h1cg.jpg\" /></p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5177', '58', '<br>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">科幻电影中令人眩目的各种高科技产品和场景，与人们的现实生活距离有多遥远？ 或许，就只有一层银幕之隔。小编与您一起解读从科幻电影到现实的科技。慢慢来回想着说吧&hellip;下面排名不分先后。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px; padding-right: 0px; font-stretch: inherit\">《星际穿越》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">&nbsp;</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"11大必看经典科幻电影推荐_科幻电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px auto; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4805rcdesqeuudb.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">&nbsp;</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主要讲述了一队探险家利用他们针对虫洞的新发现，超越人类对于太空旅行的极限，从而开始在广袤的宇宙中进行星际航行的故事</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">这是近年内，最好看的一部科幻电影了！在第41届美国科幻恐怖电影奖土星奖获得了最佳科幻电影</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">&nbsp;</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">&nbsp;</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">&nbsp;</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px; padding-right: 0px; font-stretch: inherit\">《蝴蝶效应》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"11大必看经典科幻电影推荐_科幻电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px auto; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4805unqhyoavty4.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">伊万（艾什顿&middot;库奇 Ashton Kutcher 饰）曾经有一个糟糕的童年，因为他行为闯下了大祸，令他童年充满不堪回忆的往事。而事实上，他确实只是依稀记得一点可怕的情景，这些情景一直纠缠着他的正常生活。伊万接受心理学家建议，把琐碎生活记在记事本里，却偶然发现通过记事本回到过去。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">看完之后，很多人将其奉为经典。环环相扣的蝴蝶效应都从一件事开始，第一部和第三部比较好看。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px; padding-right: 0px; font-stretch: inherit\">《人类之子》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"11大必看经典科幻电影推荐_科幻电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px auto; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4805cyyzvbosvky.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">20年后的人类社会，正面临着前所未有的灭顶之险&mdash;&mdash;所有的人类都丧失了生育能力，而东欧和非洲国家已经四分五裂，人口向英国等富裕国家大量迁移。 然而在英国境内，人们正陷入一片混乱和恐慌中。人人都为世界末日的到来而焦躁狂暴。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">一部很严肃的科幻电影，也是可能的未来，2007土星奖最佳科幻影片。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px; padding-right: 0px; font-stretch: inherit\">《千钧一发》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"11大必看经典科幻电影推荐_科幻电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px auto; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_48053453uoma1tn.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">未来的世界，科技的力量胜过一切，基因决定命运，几乎成为金科玉律。不幸文森特（伊桑&bull;霍克 Ethan Hawke 饰）是一个基因不良的人，出生以来就决定了他近视和心脏病的缺陷，他只能活到30岁。于是父母为文森特增添了一个有着优良基因的弟弟。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">梦想与扼杀梦想的不公平，过去、现在还是未来，这是人类戏剧的永恒主题之一。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px; padding-right: 0px; font-stretch: inherit\">《侏罗纪公园》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"11大必看经典科幻电影推荐_科幻电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px auto; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4805dhshjco13bv.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">哈蒙德立志要建立一个非同寻常的公园：恐龙将是这个公园的主角。他把众多科学家收归旗下，利用琥珀里面困住的远古蚊子体内的血液，提取出恐龙的基因信息，利用这些信息培育繁殖恐龙。结果如愿以偿，他把怒布拉岛建立成了一个恐龙公园，坚信可以从中赚取大钱。然而，科学家们则忧心忡忡。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">史蒂文&middot;斯皮尔伯格的作品，1993年就有那样的特效特技，让人惊叹。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px; padding-right: 0px; font-stretch: inherit\">《黑客帝国》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"11大必看经典科幻电影推荐_科幻电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px auto; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4805mwrtids1ezm.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">不久的将来，网络黑客尼奥（基奴李维斯 饰）对这个看似正常的现实世界产生了怀疑。他结识了黑客崔妮蒂（凯莉&middot;安&middot;摩丝 饰），并见到了黑客组织的首领墨菲斯（劳伦斯&middot;菲什伯恩 饰）。墨菲斯告诉他，现实世界其实是由一个名叫&ldquo;母体&rdquo;的计算机人工智能系统控制，人们就像他们饲养的动物，没有自由和思想，而尼奥就是能够拯救人类的救世主。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">绝对经典，让人眼前和思维都一亮，新的哲学，开创动作片之先河</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px; padding-right: 0px; font-stretch: inherit\">《十二只猴子》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"11大必看经典科幻电影推荐_科幻电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; margin: 0px auto; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4805wbvpqz4ikxs.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">公元2035年，人类被12只猴子军研制的一种病毒侵袭，大部分人类都在这场病毒灾难中死亡，只有少数人侥幸逃生，但也只能在阴暗的地下，苟且偷生。 科学家们决定派人穿越时光回到1996年追查12只猴子军的来历。囚徒詹姆斯&middot;科尔被 挑选为志愿者。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; word-spacing: 0px; border-bottom: 0px; text-transform: none; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; border-left: 0px; widows: 1; margin: 20px 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">在穿越时空的思维上做的挺严密的，故事也很让人动情，剧情挺棒。很多电影迷都推荐这一部电影。</p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5181', '58', '<br>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">1《勇者行动》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">从头干到尾的海豹突击队反恐猛片，枪战、狙击、海船支援、救女人质、打恐怖份子，真人档手雷，简单粗暴，枪枪到肉，&ldquo;把伤痛当成你人生动力&rdquo;，斯科特沃不愧好莱坞新一代动作大导<br />\n<br />\n<img alt=\"10部让人欲罢不能特种部队电影&nbsp;保证你看的热血_特种部队,电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_48562etc1c5bsak.jpg\" />2《深入敌后》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">这部影片剧情相当紧凑了，紧张惊险的气氛是本片看点。很少现代军事战争题材能拍这么有感觉了，而且能把战斗机驾驶员当主教也就这一部了。尤其是那些变态的统治者，残害生灵。剧中的配乐是亮点。值得慢慢细赏。<img alt=\"10部让人欲罢不能特种部队电影&nbsp;保证你看的热血_特种部队,电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4856fpfuox1k5ll.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">3《黑鹰坠落》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">很少看到这么流畅的战争片，很真实，不血腥，难得的是剧情还很丰满，人物性格饱满，配乐很到位。没有刻意的表现和煽情，看了好几遍，依旧震撼。这部剧看的是战争残酷无情，看的是兄弟情，不放弃任何战友，带不回活人也要带回遗体。打战不是为了被誉为英雄，只是有时候时势造就英雄，只希望永远不要有战争。<img alt=\"10部让人欲罢不能特种部队电影&nbsp;保证你看的热血_特种部队,电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4857esypted3rot.jpg\" />4《菲利普船长》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">年度力作！绿草依然那么凌厉精彩，最后半小时几乎让人透不过气来。其快速剪辑、DV风都和这个题材极好地吻合在一起。而且没有太多乱七八糟的所谓思考或引申，全靠事件本身以及漂亮的再现、叙述吸引人。饰演索马里海盗的几人都逼真得可怕，相对来说汉克斯倒显得中规中矩了，不过结尾一段戏特别到位。强力推荐&nbsp;<img alt=\"10部让人欲罢不能特种部队电影&nbsp;保证你看的热血_特种部队,电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4857v4actfr2xyw.jpg\" />5《孤独的生还者》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">一部令人震撼的电影，真实、刺激、虐心，特别是中间那长达几十分钟的林子战，晃动的主观镜头，重度消弱配乐，留下的是心跳声、呼吸声、垂死前的喘息声。本以为故事依旧主旋律，却一反常态，没有美化自我丑化他人，没有个人英雄主义。结尾意料之外，更是双方对外战争关系上的一次进步或转折<img alt=\"10部让人欲罢不能特种部队电影&nbsp;保证你看的热血_特种部队,电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4857u20a2s0ws25.jpg\" />6《特种部队》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">这是一部很棒的法国电影。相当给力的纯硬派战争片！现代反恐战争题材一直是最热卖点，依旧是令人&ldquo;畏惧&rdquo;的阿富汗战场，这部法国战争片一点不逊色于美国同类型影片，影片感觉像是在玩战争游戏《使命召唤》一般！情节紧张刺激毫无冷场！<img alt=\"10部让人欲罢不能特种部队电影&nbsp;保证你看的热血_特种部队,电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4857j10tnhfsgvi.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">7《太阳之泪》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">美国大兵又一次拯救苍生，不但救了莫妮卡漂亮护士姐姐，还救了若干难民于尼国水火之中。电影中的美国大兵军事素质高，思想品德好。非洲人民好凄惨，差点骗了我的眼泪。布鲁斯饰演的沃特斯上尉选择返航，虽然牺牲很多士兵，但却救活了大部分的难民，这种情操很值得人敬佩。名为《太阳之泪》，感觉是连太阳都在为叛军的残忍和为美军小突击队的感动而流泪。<img alt=\"10部让人欲罢不能特种部队电影&nbsp;保证你看的热血_特种部队,电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4857s3urnc1giq3.jpg\" />8《拆弹部队》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">电影之所以能打动观众，就是因为它的真实性。有如身临其境去窥视、感悟人类的善恶，那种真实感、厚重感和悲凉感的重重叠加，并非技术和手段能造就，Kathryn Bigelow特有的感性意识在其凛冽的拍摄手法下相互融合，造就奥斯卡大局最有力的炸弹。<img alt=\"10部让人欲罢不能特种部队电影&nbsp;保证你看的热血_特种部队,电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4857r4wzktohkvr.jpg\" />9《猎杀本拉登》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">157分钟没有多余的镜头，冷静客观的记录了女主长达十年的坚持。女主也没有被塑造成一个完美的女英雄，虽然执着和果敢，但对虐囚也默认和支持。最后的猎杀采用第一人称视角的拍摄，让人身临其境，扣人心弦。结尾也非常的干净利落，没有多余的皆大欢喜场面。<img alt=\"10部让人欲罢不能特种部队电影&nbsp;保证你看的热血_特种部队,电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4857gurdswjjyvm.jpg\" />10《汤姆&middot;克兰西：幽灵行动阿尔法》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">它只有20分钟，但请不要用&ldquo;微电影&rdquo;来侮辱它。它是大片，是一部更大的片的前传。简单而套路化的一场战斗，但足以成为军事迷、游戏迷、军事游戏迷、武器控、战斗控、高科技战争控等等的至爱，尤其是第14分钟后的那5分钟，劲爆迭起，热血为之沸腾。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"10部让人欲罢不能特种部队电影&nbsp;保证你看的热血_特种部队,电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_48574qqke1fsfqp.jpg\" /></p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5182', '58', '<br>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">武侠文化是国人特有的文化，武侠文化中的侠义是介于道德和法律中间的一种社会力量，直到清朝还有镖局镖师各种江湖规矩，但现在都已消失或演变，想体验原汁原味的武侠，也只能看看武侠电影了。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">武侠电影是与中国文化紧密相连的一种电影，武侠电影中的语言、服装、江湖规矩，都是非常有特色的看点。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">小知识：</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">最早的武侠可追溯到春秋战国时期的专诸、荆轲，他们的故事传颂千古，至今不衰。最早的侠，见于《韩非子&middot;五蠹》，&ldquo;儒以文乱法，侠以武犯禁。&rdquo;至司马迁的《史记》，专给游侠写了列传&mdash;&mdash;《游侠列传》，其中，对游侠的评价是：&ldquo;然其言必信，其行必果&rdquo;，可以说，这是整个侠文化的总纲。班固的《汉书》亦写有《游侠传》。游侠以武力行事，敌视公家，不讲法律，凭自己的力量、自己的眼光，个人的意气、个人的判断来决定是非和生杀。所以普通人往往将愿望寄托在侠客身上。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"华语电影巅峰时期，武侠电影推荐_华语电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-top-left-radius: 4px; border-top-right-radius: 4px; border-bottom-right-radius: 4px; border-bottom-left-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4818qnqqvmohj13.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">2000年以后的武侠电影</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《绣春刀》（2014年）明崇祯皇帝登基时期为背景，小人物的江湖故事，电影拍的非常有诚意，剧情严谨，契合史实，人物形象也是棱角分明。动作戏很实在，刚猛有劲，2014年武侠佳作。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《剑雨》（2010年）该片虽然不能说是非常经典，但可以说是《卧虎藏龙》之后最好的武侠片之一。影片以女性为主角，讲述了一个欲退隐江湖女杀手的故事。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《卧虎藏龙》（2000年）不同与传统武侠&ldquo;打打杀杀&rdquo;，蕴含深沉思索与含蓄，可以挖掘很深层次的一个片子。迄今唯一获奥斯卡最佳外语片的华语片。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"华语电影巅峰时期，武侠电影推荐_华语电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-top-left-radius: 4px; border-top-right-radius: 4px; border-bottom-right-radius: 4px; border-bottom-left-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4818nb0i0rfodki.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">1980年-2000年的武侠电影</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《刀》又名《断刀客》（1995年）赵文卓主演的一部电影，影片背景为武力解决一切的蛮荒年代。片中充满暴力和堕落的市井，和那些快意恩仇的武侠电影相比，主题显得沉重一些。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《六指琴魔》（1994年）尽管本片有一些不靠谱的地方，但也有很多出彩的地方，天龙派，天魔八音，林青霞的经典造型等等。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《醉拳2》（1994年） 成龙的功夫喜剧，醉拳共有3部，这第2部最为经典。讲述的是一代宗师黄飞鸿年少时代一段历险。我想许多影迷对这种老电影里的色调真应该是非常喜欢。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《精武英雄》（1994年） 李连杰版本的陈真，动作干净利落，蔡少芬扮相太古典太惊艳，配角也都非常出彩，功夫电影的巅峰作品之一。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《东邪西毒》（1994年）和《东邪西毒：终极版》（2009年）</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《东邪西毒：终极版》是《东邪西毒》的最终修复版本，影片的内容与原片基本相同，讲述了东邪、西毒、一个女子以及一些刀客之间的恩怨情仇。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"华语电影巅峰时期，武侠电影推荐_华语电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-top-left-radius: 4px; border-top-right-radius: 4px; border-bottom-right-radius: 4px; border-bottom-left-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4819dhfvvbmavnv.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《笑傲江湖》 （1990年）</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《笑傲江湖Ⅱ东方不败》 （1992年）</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">两个版本都很不错，武打动作，色彩画面，故事情节都可圈可点。那首《沧海一声笑》就是里面的插曲。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《东方不败风云再起》（1993年）笑傲江湖结束了，东方不败又来个风云再起，林青霞和王祖贤主演，武侠迷是必须要看的。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"华语电影巅峰时期，武侠电影推荐_华语电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-top-left-radius: 4px; border-top-right-radius: 4px; border-bottom-right-radius: 4px; border-bottom-left-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4819mttdx0xoz40.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《黄飞鸿》系列</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">李连杰主演的黄飞鸿</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《黄飞鸿》（1991年）、《黄飞鸿之二：男儿当自强》（1992年） 、《黄飞鸿之三：狮王争霸》（1993年）</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《黄飞鸿之铁鸡斗蜈蚣》（1993年）、《黄飞鸿之西域雄狮》（1997年）</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">赵文卓主演：《黄飞鸿之四：王者之风》（1993年）</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">甄子丹主演：《少年黄飞鸿之铁马骝》（1993年）</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">1989年，有一个龙行天下版，拍的不太好。真正杰作《黄飞鸿》是1991年开始，之后徐克又拍了92年的《男儿当自强》和93年的《狮王争霸》，这三部评价较高。之后的几部导演和主演都有了变化，评价不及前三部。但还是很不错的。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《倚天屠龙记之魔教教主》（1993年）相比其它经典武侠口碑稍差一丢丢，但本人对此片却情有独钟，特别是张敏和邱淑贞在里面的扮相，那不是一般的漂亮。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《赤脚小子》（1993年）知道这部电影的人相对很少，影片的各方面很不错，即使不能捧到经典程度，也算是一部值得一看的武侠片，如果你看过了本次其它推荐电影，《赤脚小子》是不错的选择，就像有人说的，它是湮没在黄金年代的无名客。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"华语电影巅峰时期，武侠电影推荐_华语电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-top-left-radius: 4px; border-top-right-radius: 4px; border-bottom-right-radius: 4px; border-bottom-left-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4819nswz13k2mii.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《方世玉》（1993年）</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《方世玉续集》又名《方世玉2：万夫莫敌》（1993年）功夫片，还是李连杰主演的看起来最给力，和萧芳芳一起主演的两部方世玉，值得收藏。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《太极张三丰》（1993年）刀光剑影不是我门派，天高海阔自有我风采，潇洒飘逸的李连杰，侠骨柔情的杨紫琼。有搞笑、有美女、有功夫、有坏蛋，这就是我喜欢的武侠。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《一刀倾城》又名《神州第一刀》（1993年）喝不尽杯中酒，唱不完别离歌，放不下手中刀，杀不尽仇人头。以武侠片的形式描述中国近代史中悲壮的一页。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《白发魔女传》（1993年）推荐的是1993年这个版本的，曾经感动过武侠片，对原著颠覆性改变，明末军队战火与魔教肆虐，狼女为正派浪子一夜白头，还有连体反派，邪气浓烈的武侠片！那段练剑树叶镜头，还有林青霞和张国荣水中激情，都让人毕生难忘。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《武状元苏乞儿》（1992年）周星驰无厘头风格+武侠故事。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《新龙门客栈》（1992年）边荒大漠,国恨家仇，一个英雄，两位女子。演绎了那段特殊时代特殊环境的特殊故事。无论是张曼玉的风骚泼辣，还是林青霞的苦情压抑，以及梁家辉的正气禀然都很耐看。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《双旗镇刀客》（1991年）中国西部，黄沙漫天，马嘶人怒。这部片子告诉你，简洁有多复杂。这不是一部严格意义上的武侠片，这又是一部真正的武侠片。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《少林寺》（1982年）李连杰成名作，从此李连杰时代开始，故事讲述的是少林十三棍僧救唐王的故事。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"华语电影巅峰时期，武侠电影推荐_华语电影,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-top-left-radius: 4px; border-top-right-radius: 4px; border-bottom-right-radius: 4px; border-bottom-left-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4819tvmv35hhmpk.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">1980年以前的武侠电影</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">张彻，代表作品，《五毒》，《独臂刀》，《马忠贞》，《上海滩十三太保》等</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">张彻武侠的风格偏硬朗，是最早的拳拳到肉，讲故事的手法上，张彻擅长从男性角色的性格为主线，带动情节与武侠情怀。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">胡金铨，代表作品，《大醉侠》，《龙门客栈》，《侠女》，《空山灵雨》等</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">胡金铨武侠带有讲传奇、说书人的风韵，擅长情节铺陈，以画龙点睛的&ldquo;笔法&rdquo;讲人物，他的电影常常前半部分更精彩。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">楚原，代表作品，《楚留香》（狄龙版），《陆小凤之决战前后》（刘永版），《陆小凤之绣花大盗》（刘永版），《多情剑客无情剑》（狄龙版），《三少爷的剑》（尔冬升版），《爱奴》（岳华，何莉莉），《白玉老虎》（狄龙，岳华）&hellip;&hellip;</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">楚原拍过四五十部武侠片，华美的布景，迅捷完美的打斗场景，以及比古龙原著更周延的情节设计，将各种偶像、娱乐元素混入武侠，楚原建立了一个风格飘逸的武侠王国。</p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5180', '58', '<br>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">网友推荐的10部经典僵尸电影，没看过的赶紧了！不分排名先后哦！都是满满的回忆！</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">1．《一咬OK》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"网友推荐的10部经典僵尸电影_僵尸电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4818ztgxdjfaj2i.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演：冼杞然</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">关键词：东方吸血鬼</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">经典指数：★★★</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">在西方的僵尸文化里，有着人文主义的思考，僵尸象征人类对永生的渴求和煎熬，而在香港电影里，僵尸只是用来制作恐怖和笑料的工具，唯一一次涉及到生命永恒与僵尸孤独，就是这一部《一咬OK》。本片的导演冼杞然、主演林子祥和关之琳组合，来自两年前的爱情喜剧《三人世界》，这期间冼杞然是德宝电影公司的主脑，林子祥则是雅痞爱情小品的最佳代言人，因而《一咬OK》里有着大量德宝式笑料。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">为了学吸血鬼电影学的像一点，影片前半个小时在英国展开，并把主角的来历设置为清朝驻英大使。这位大使过了两百年拥有城堡的土豪生活，法力高强，如今却因遇到了一个咬了她就能变成魔王的女子，而搞的一塌糊涂。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《一咬OK》虽然想西洋化，表达对吸血鬼的思考，但拍摄出来的效果就跟过家家一样。影片格局混乱，推进剧情、发展故事的动机、方式和意外都十分蹩脚，毫无戏剧法则，主演们也像游魂一样不在状态。因为剧本太差，有些戏份的试听效果就跟在拍话剧一样粗糙，尤其在一场无缘对面手难牵的戏，仅以两个极为简单的镜头，就在那里没完没了地抒情，真是可惜。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">2．《一眉道人》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"网友推荐的10部经典僵尸电影_僵尸电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4818dafpxasigmm.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演：林正英</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">关键词：九叔正宗说法</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">经典指数：★★★☆</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">在过往的僵尸片里，林正英被塑造成不苟言笑、带点冷幽默、却又不失可爱、有时还有狡黠的一面，他法力高强，战无不胜永，远给人以安全感。《一眉道人》是林正英导演的第一部电影，也是唯一导演的两部之一，在很多方面都立意突破。首先改写了林正英的角色形象，片中有了对他接近亲情和爱情的描写，虽然只是和一个小僵尸情同父子，和胖胖的修道院长眉目传情。最后甚至借助院长，来毁灭金刚不坏的西洋僵尸，这也暗示从前的九叔现在并非无所不能了。其次影片独创甚至是生造了很多治鬼法术，花样百出，这些煞有介事的法术，没完没了，简直有炫耀和卖弄的嫌疑。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《一眉道人》的缺点也明显得很，首先是剧本，片中先来一段可有可无的大战芭蕉精，然后是不了了之的大水井，重头戏是大战西洋僵尸，其间还有可有可无的寻找女尸。影片重技术轻故事，剧情松散无序，连戏突兀跳跃。其次是制作，影片细节不够精致，不断有摄影和配音上的问题，这些都是林正英作为新导演所欠缺的地方。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">3.《僵尸》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"网友推荐的10部经典僵尸电影_僵尸电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4818otyzt0kpl1n.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演：麦浚龙</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">关键词：僵尸翻生</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">经典指数：★★★☆</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">曾掀起正想拍摄潮流的僵尸电影在20多年后，又因为一部《僵尸》而风云再起。本片是作为80后的麦浚龙想表达对僵尸片黄金时期的怀念，影片的革新之处是一改僵尸喜剧的搞笑风格，而转向沉重与黑暗，探讨执念、善恶一念和中年危机等心理命题。影片启用五位僵尸片老演员，说是在致敬，其实只是对经典僵尸片的一次剥削利用。从《僵尸》这个霸道的片名、毫不切题的歌曲《鬼新娘》、一晃而过的跳尸动作即可看出，&ldquo;僵尸&rdquo;只是个噱头。影片混杂着《咒怨》似的恐怖，南洋巫蛊式的降头邪术，以及为了创新而设计的很多新意念，都使得影片像是麦浚龙童年记忆的大杂烩。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">作为新导演，麦浚龙的招数是把人物写得畸形一点，把造型弄得恶心一点，把画面调得阴冷一点，把音效弄得大声一点，演员演得慢一点，镜头拉得长一点，情节支离破碎，镜头全是碎片。这样的僵尸世界不是观众熟悉的那个僵尸世界。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">4．《千机变》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"网友推荐的10部经典僵尸电影_僵尸电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4819mc0tjvrzhmk.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演：林超贤</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">关键词：西方吸血鬼</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">经典指数：★★★★</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">相比《一咬OK》,《千机变》的西洋化更深入，它完全借鉴西方吸血鬼片的模式，尤其是《刀锋战士》。本土僵尸猎人和外来僵尸家族的战争，以及僵尸家族内部的战争是电影的主线。但是，僵尸和特技其实只是《千机变》战术上的花招，影片战略上的真正目的是要通吃海外和香港的票房市场，Twins=本土，打戏+特技+成龙=外埠，因此才会让两个手无缚鸡之力的女孩来大拼功夫。至于片中显得太假的僵尸世界，也只是为了迁就外国观众的口味，抓僵尸和国际刑警追捕坏人一样现代化，僵尸王子落难时更像是得了一种病，借着僵尸这个外壳，《千机变》以打、笑、情为支点，拼盘式地炒成一碟，并获得了成功。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">5．《猛鬼差馆》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"网友推荐的10部经典僵尸电影_僵尸电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4819ly1jjm5y1p5.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演：刘镇伟</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">关键词：时装化、西洋化</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">经典指数：★★★★</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">1987年，刘镇伟终于有机会当导演，他很清楚要是拍动作片、文艺片或者喜剧片，肯定拍不过别的导演，只有僵尸片，一来正当其道，二来拍的人也不多，而且把刘镇伟的名字和刘观伟一比，还有浑水摸鱼的好处。于是他的处女作便趟了僵尸片的浑水。不过《猛鬼差馆》并非穿清朝官服，由茅山道士施法的僵尸片，而是借用了时装拍档喜剧的模式，并向西方类型片借桥。片中的僵尸身披斗篷，长着獠牙，乃是西方吸血鬼的形象，而用大蒜辟邪、以木钉贯心也是西方降制吸血鬼的路数。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">从本片开始，便已经开始体现刘镇伟夸张粗俗、疯癫放纵的风格，因为成本限制，他电影的画质等技术方面都很差，但就是好笑，这是刘镇伟的本事。《猛鬼差馆》投资仅仅一百万，却收获了一千多万票房。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">6．《僵尸先生3：灵幻先生》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"网友推荐的10部经典僵尸电影_僵尸电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4819jhtl1la5x5w.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演：刘观伟</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">关键词：扬正抑邪</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">经典指数：★★★★</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">在《灵幻先生》里，出现了更多新颖的法术、器具和造型。本片中没有了严格意义上的僵尸，吕方和小孩虽然穿清朝官服，但已经是鬼魂；另一类虽然也会法术，但却是和茅山正道相对立的、不学武术的术士。通过人和鬼的对比，道术和巫术的对决，影片表达了茅山正道向上、积极的追求。即使是反派，当他们将被毁灭时，影片也体现出恻隐之心。而对于有性格缺陷的正派，包括胆小懦弱的另一个道术吴耀汉及其养的鬼，和在三集《僵尸先生》里都自作聪明、败事有余的楼南光，影片最后都让他们挺身而出，完成品格升华，这是《灵幻先生》作为一部僵尸片所传达的人文精神。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">7．《僵尸先生4：僵尸叔叔》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"网友推荐的10部经典僵尸电影_僵尸电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4819ior1arj1234.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演：刘观伟</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">关键词：佛道并肩</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">经典指数：★★★★☆</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《僵尸叔叔》可谓是一部最轻松的僵尸片，片中主角是两位师傅辈的斗气冤家，影片前半段全是他们及各自弟子之间的整蛊比试。《僵尸叔叔》里的舞台空间极为封闭，几乎全部集中在一处花香鸟语的世外桃源，而这里的房子更像日本所模仿的中国唐代建筑。对于片中的人物，包括两队师徒和外来闯入者，也是没有什么背景交代来龙去脉。值得一提的是，在第一集里饰演僵尸的元华在本集里转而饰演一个同性恋。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">嬉笑打闹够了后，终于回到对付僵尸的正题，这当然又是刘观伟的拿手好戏。《僵尸叔叔》的创新在于首次由佛教和道教来并肩对付僵尸，因此所用的手法自然令人耳目一新。最后杀死僵尸的方式也很意外，等于是把僵尸当成了人，片中也说它已经成精了。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">8．《僵尸先生2：僵尸家族》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"网友推荐的10部经典僵尸电影_僵尸电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4819q4q45vuegpe.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演：刘观伟</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">关键词：僵尸人性化</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">经典指数：★★★★☆</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">作为刘观伟这一系列电影的第二部，比起最早跟风《僵尸先生》的《僵尸翻生》，本片的制作可用心多了。僵尸电影的出现，很符合日本人对于怪物的偏好，而本片中模仿《E.T.》而出现的僵尸仔，更迎合日本的小妖文化、缩小文化，因而僵尸电影能够打入日本市场，掀起一阵僵尸热。《僵尸家族》最大的创新是僵尸的人性化，不但僵尸仔与小朋友之间建立友情，连僵尸家族内部也有喜怒哀乐之情。跟风电影的存在，使得电影人必须时刻想着超越前人，压力和竞争便产生了动力，他们必须你追我赶，各出奇谋。在本片中，便创造性地出现了迟钝剂，片中还到处是编剧黄炳耀特有的搞笑方式，说到娱乐性，完全不输第一集。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">9．《鬼打鬼》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"网友推荐的10部经典僵尸电影_僵尸电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4820egx0gepweoq.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演：洪金宝</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">关键词：潮流导火线</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">经典指数：★★★★☆</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">在80年代以前，香港已经有过几部僵尸题材电影，但是真正触发这一潮流的则是1980年洪金宝创办宝禾公司的创业作《鬼打鬼》。该片虽然也是受到鬼怪喜剧《撞到正》的启发而拍摄，却独创了后来僵尸喜剧的一些基本模式。首先，它挖掘中国传统的鬼神习俗趣味，以大量篇幅描绘开坛做饭和制鬼法术，并细心考究僵尸的形象和动作。其次，它已经在取材外国逸闻，如鬼镜传说和骷髅鬼王等。而片中的僵尸之所以穿清朝官服，不但因为民国初年的故事背景离清代相距不远，也因为清代是僵尸传说最活跃的时期，清代的笔记小说里，就有大量关于僵死和尸变的纪录。《鬼打鬼》里的林正英、钟发和黄哈也是后来僵尸片的主将。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">10．《僵尸先生》</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"网友推荐的10部经典僵尸电影_僵尸电影,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4820ijmsytonryt.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演：刘观伟</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">关键词：类型标本</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">经典指数：★★★★★</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">投资850万的《僵尸先生》本来预计会亏损200万，但最终票房却超过2000万，而且获得了12项金像奖提名，叫好又叫座。《僵尸先生》的成功是多方面因素的结果，它移植了民初功夫片的师徒关系和斗趣情节，充满了港片纯熟的土法特技和功夫杂技，还加插了聊斋式的多情艳鬼追男仔片段，有笑料，有浪漫，绝无闷场。不过最主要的因素还是片中僵尸形象和桥段的趣味性，《僵尸先生》的意念是导演刘观伟想拍一个和鬼打鬼不一样的鬼片，他伯父就是茅山师傅，小时候听过很多关于茅山法术的故事，因此影片深入挖掘民俗趣味，借用了湘西赶尸传说的很多情节，包括黄袍法师，压面的黄纸符和一排排跳动的僵尸。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; letter-spacing: normal; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">此外，影片还很细致地从清代笔记小说取经。首先，人之所以变僵尸，是因为死不断气或死得冤枉。当他感染活人阳气后就会尸变。其次，屏住呼吸可以躲避僵尸，这是《僵尸先生》最厉害的设计，以致其台湾片名就叫《暂时停止呼吸》。再次，制服僵尸的方法包括桃木剑、墨斗线、黄纸符和糯米，非常典型的道家色彩。至于獠牙利爪的僵尸形象，活人被咬中吸血后也变僵尸，则来自西方的吸血鬼电影。片中的一些搞笑全段，则偷师自波兰斯基1967年的经典作《天师捉妖》。总之，《僵尸先生》的这些设置成了接下来僵尸片潮流的&ldquo;文化模式&rdquo;。</p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5183', '58', '<br>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">Hero is back&rdquo;。我们童年的英雄真的回来了。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">时常感叹六小龄童之后，再也没人愿意与猴同住，只为演好一个孙悟空。那年的《西游记》再无法复刻。如今却有只长脸齐天大圣带动起了一片要&ldquo;生猴子&rdquo;的自来水。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4925rvskwdwtctc.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4925vdpu1khmttt.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4925anviqgqqwio.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">&ldquo;齐天大圣孙悟空，身如玄铁，火眼金睛，长生不老，还有七十二变。一个筋斗云啊，就是十万八千里。&rdquo;我们童年的男神，就是这么了不起的一只猴子。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_49262q0xtuo5bxo.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_49265tlkjwo5abw.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">如今《大圣归来》中的这个脸长如马的齐天大圣，分明就是我们童年里的那一个盖世英雄。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_49273d3d0cpyjoa.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4927xgsubdlddba.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">这部国产动画，冷静的评价总结为：瑕不掩瑜，值回票价，笑点与泪点并存。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4927zkuebygnygd.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">为什么这片子只是点映，就能吸引一大波人自发在网上宣传呢？</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_49301ztw4tq223x.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_49313gzsidpfqyq.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_49333tr20l3bklg.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">首先，这的确是一部诚意满满、质量上乘的动画电影。一个好莱坞式的英雄故事，杂糅在中国古典神话中毫不违和。人物设定充满人情味&mdash;&mdash;大圣的傲娇与内心的善意；唐僧第一世江流儿依旧是个孤儿小和尚，但机灵话唠。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4937k3mx5mvny4y.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4938ju3linsisuf.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">再者，就是情怀吧。继六小龄童的真人版和99年的动画版后，大圣的形象再无经典塑造，现在的孩子们追日本动漫，看漫威英雄，认同日本的审美趣味，追捧美国的个人英雄，却再也不记得那个西天取经的四人组和法力无边的齐天大圣。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4939hgyq402elsm.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4940dwza5pqs0b0.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4940ufedwma3cyi.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">说说幕后的坎坷。《大圣归来》的导演田晓鹏正是99年经典动画版的导演。对，就是&ldquo;白龙马，蹄儿朝西&rdquo;那个，大圣情怀最深重的恐怕是导演本人。因为拒绝了投资方改剧本的要求而被临时撤资，只能自己垫钱完成电影。电影耗时8年，终于制作完成，却没钱做宣传。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4940e1j0hatrfto.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_494023mll5pkz5p.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4942rimzdugwmbe.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">团队是初次制作动画电影，不知道动画电影国内是有时长限制的，于是上映前被迫剪掉30%的内容。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4942r4vf2moqek0.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4944225hsuzfrtd.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4944lsai5kxidby.gif\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">童年和我们熟悉的辉煌时光走远了，但它没有死，它会回来，就如满路荆棘的国产动漫。《大圣归来》的开头说，&ldquo;大圣不会死，他只是睡着了。&rdquo;</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_49454rtkcskgdou.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4945uyz5ai10jrv.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4945jmadjndmt0p.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这部电影，评分比小时代高5分，票房比小时代少_票房,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4945fx022d35sgu.jpg\" /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《大圣归来》不能说照亮中国动画电影的道路，但的确让许多人看到了一道曙光。 国产动画已经睡了十几年，如今醒了。就像齐天大圣，即使五指山下五百年，抖擞一下威风，依旧山崩地裂。希望那个说了很久的&ldquo;国产动漫的春天&rdquo;这次真的来了。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">这部电影在豆瓣的评分是8.7分，小时代是3.7分。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">而两部片子的排片也一样悬殊，不过是反过来了&hellip;&hellip;</p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5184', '58', '<br>\n<p style=\"word-wrap: break-word !important; max-width: 100%; height: auto !important; white-space: normal; text-transform: none; word-spacing: 0px; color: rgb(51,51,51); padding-bottom: 0px; padding-top: 0px; font: 14px/26px Arial, \'Microsoft YaHei\'; padding-left: 0px; margin: 0px 0px 20px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-stroke-width: 0px\">　&ldquo;假如生活欺骗了你，不要悲伤，不要心急！忧郁的日子里需要镇静&hellip;&hellip;&rdquo;当你倦怠、辛苦的时候，不妨挑选一部好电影，或捧腹大笑，或潸然泪下，或陷入深思&hellip;在影片里收获正能量，继续乐观地与生活&ldquo;抗争&rdquo;。20部不容错过的正能量电影&darr;&darr;存起来慢慢看~</p>\n<p style=\"word-wrap: break-word !important; max-width: 100%; height: auto !important; white-space: normal; text-transform: none; word-spacing: 0px; color: rgb(51,51,51); padding-bottom: 0px; text-align: center; padding-top: 0px; font: 14px/26px Arial, \'Microsoft YaHei\'; padding-left: 0px; margin: 0px 0px 20px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-stroke-width: 0px\"><img alt=\"收藏！人生必看的20部正能量电影_正能量电影,娱乐,娱乐台词_读多多\" style=\"word-wrap: break-word !important; max-width: 100%; border-top: 0px; border-right: 0px; border-bottom: 0px; padding-bottom: 5px; padding-top: 5px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px\" src=\"/tu/allimg/Yulu/Yulu_4941mupfr45da4u.jpg\"  /></p>\n<p style=\"word-wrap: break-word !important; max-width: 100%; height: auto !important; white-space: normal; text-transform: none; word-spacing: 0px; color: rgb(51,51,51); padding-bottom: 0px; text-align: center; padding-top: 0px; font: 14px/26px Arial, \'Microsoft YaHei\'; padding-left: 0px; margin: 0px 0px 20px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-stroke-width: 0px\"><img alt=\"收藏！人生必看的20部正能量电影_正能量电影,娱乐,娱乐台词_读多多\" style=\"word-wrap: break-word !important; max-width: 100%; border-top: 0px; border-right: 0px; border-bottom: 0px; padding-bottom: 5px; padding-top: 5px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px\" src=\"/tu/allimg/Yulu/Yulu_4943celtffwswzq.jpg\"  /></p>\n<p style=\"word-wrap: break-word !important; max-width: 100%; height: auto !important; white-space: normal; text-transform: none; word-spacing: 0px; color: rgb(51,51,51); padding-bottom: 0px; text-align: center; padding-top: 0px; font: 14px/26px Arial, \'Microsoft YaHei\'; padding-left: 0px; margin: 0px 0px 20px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-stroke-width: 0px\"><img alt=\"收藏！人生必看的20部正能量电影_正能量电影,娱乐,娱乐台词_读多多\" style=\"word-wrap: break-word !important; max-width: 100%; border-top: 0px; border-right: 0px; border-bottom: 0px; padding-bottom: 5px; padding-top: 5px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px\" src=\"/tu/allimg/Yulu/Yulu_49454jfjgpggwxi.jpg\"  /></p>\n<p style=\"word-wrap: break-word !important; max-width: 100%; height: auto !important; white-space: normal; text-transform: none; word-spacing: 0px; color: rgb(51,51,51); padding-bottom: 0px; text-align: center; padding-top: 0px; font: 14px/26px Arial, \'Microsoft YaHei\'; padding-left: 0px; margin: 0px 0px 20px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-stroke-width: 0px\"><img alt=\"收藏！人生必看的20部正能量电影_正能量电影,娱乐,娱乐台词_读多多\" style=\"word-wrap: break-word !important; max-width: 100%; border-top: 0px; border-right: 0px; border-bottom: 0px; padding-bottom: 5px; padding-top: 5px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px\" src=\"/tu/allimg/Yulu/Yulu_4946dqduemr4vu5.jpg\"  /></p>\n<p style=\"word-wrap: break-word !important; max-width: 100%; height: auto !important; white-space: normal; text-transform: none; word-spacing: 0px; color: rgb(51,51,51); padding-bottom: 0px; text-align: center; padding-top: 0px; font: 14px/26px Arial, \'Microsoft YaHei\'; padding-left: 0px; margin: 0px 0px 20px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-stroke-width: 0px\"><img alt=\"收藏！人生必看的20部正能量电影_正能量电影,娱乐,娱乐台词_读多多\" style=\"word-wrap: break-word !important; max-width: 100%; border-top: 0px; border-right: 0px; border-bottom: 0px; padding-bottom: 5px; padding-top: 5px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px\" src=\"/tu/allimg/Yulu/Yulu_4948y4ladetpfhg.jpg\"  /></p>\n<p style=\"word-wrap: break-word !important; max-width: 100%; height: auto !important; white-space: normal; text-transform: none; word-spacing: 0px; color: rgb(51,51,51); padding-bottom: 0px; text-align: center; padding-top: 0px; font: 14px/26px Arial, \'Microsoft YaHei\'; padding-left: 0px; margin: 0px 0px 20px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-stroke-width: 0px\"><img alt=\"收藏！人生必看的20部正能量电影_正能量电影,娱乐,娱乐台词_读多多\" style=\"word-wrap: break-word !important; max-width: 100%; border-top: 0px; border-right: 0px; border-bottom: 0px; padding-bottom: 5px; padding-top: 5px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px\" src=\"/tu/allimg/Yulu/Yulu_4949z5dbnkr0j5a.jpg\"  /></p>\n<p style=\"word-wrap: break-word !important; max-width: 100%; height: auto !important; white-space: normal; text-transform: none; word-spacing: 0px; color: rgb(51,51,51); padding-bottom: 0px; text-align: center; padding-top: 0px; font: 14px/26px Arial, \'Microsoft YaHei\'; padding-left: 0px; margin: 0px 0px 20px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-stroke-width: 0px\"><img alt=\"收藏！人生必看的20部正能量电影_正能量电影,娱乐,娱乐台词_读多多\" style=\"word-wrap: break-word !important; max-width: 100%; border-top: 0px; border-right: 0px; border-bottom: 0px; padding-bottom: 5px; padding-top: 5px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px\" src=\"/tu/allimg/Yulu/Yulu_4951uzfzahisipy.jpg\"  /></p>\n<p style=\"word-wrap: break-word !important; max-width: 100%; height: auto !important; white-space: normal; text-transform: none; word-spacing: 0px; color: rgb(51,51,51); padding-bottom: 0px; text-align: center; padding-top: 0px; font: 14px/26px Arial, \'Microsoft YaHei\'; padding-left: 0px; margin: 0px 0px 20px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-stroke-width: 0px\"><img alt=\"收藏！人生必看的20部正能量电影_正能量电影,娱乐,娱乐台词_读多多\" style=\"word-wrap: break-word !important; max-width: 100%; border-top: 0px; border-right: 0px; border-bottom: 0px; padding-bottom: 5px; padding-top: 5px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px\" src=\"/tu/allimg/Yulu/Yulu_4953jtiv40onfdb.jpg\"  /></p>\n<p style=\"word-wrap: break-word !important; max-width: 100%; height: auto !important; white-space: normal; text-transform: none; word-spacing: 0px; color: rgb(51,51,51); padding-bottom: 0px; text-align: center; padding-top: 0px; font: 14px/26px Arial, \'Microsoft YaHei\'; padding-left: 0px; margin: 0px 0px 20px; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-stroke-width: 0px\"><img alt=\"收藏！人生必看的20部正能量电影_正能量电影,娱乐,娱乐台词_读多多\" style=\"word-wrap: break-word !important; max-width: 100%; border-top: 0px; border-right: 0px; border-bottom: 0px; padding-bottom: 5px; padding-top: 5px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px\" src=\"/tu/allimg/Yulu/Yulu_4954vby5el5s2uq.jpg\"  /></p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5185', '58', '<br>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">又到了介绍每月新剧的日子，有一个好消息一个坏消息。好消息是，熬过暗淡的四月挺过只有《虎妈猫爸》的五月，我们终于迎来国产剧井喷的暑期档。坏消息是，这拨六月新剧如果全部都看或只看一半，可能都会降低智商哟。所以别太投入，用来杀杀时间就好。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">热门新剧《花千骨》</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出时间：2015年6月9日</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出平台：湖南卫视</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演：霍建华、赵丽颖、蒋欣、杨烁、张丹峰</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_48264optshtrjqg.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">改编自fresh果果同名小说，讲述身怀奇异身世的少女花千骨与冷若冰霜的长留上仙白子画的爱情故事，据说挺虐。这几年玄幻古装剧多到审美疲劳，多是卖颜而不是卖剧情。想当初该片发布英文版预告的时候，煲仔整个人都被震惊了，纯正的Chinglish配音忍不住边看边笑旁边人都说煲仔疯啦。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4827ncjtnhvdgsb.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">说个好笑的题外话，最近看烦了的李晨张馨予的互撕大战还无意牵扯出霍建华，都不用绞尽脑汁想新剧宣传方案了，大家都追着霍建华问张馨予，追着蒋欣问会不会跟前任互撕。贵圈关系网好复杂哦。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《盗墓笔记》</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出时间：6月12日起每周五晚20点</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出平台：爱奇艺</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演：李易峰、杨洋、刘天佐、张智尧、唐嫣、魏巍</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4827qkc0tutni0k.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">由南派三叔同名小说改编的《盗墓笔记》终于，终于要播了。但煲仔这个原著党已经从一开始的鸡冻变成了担心变成了冷漠，每次公布的剧照和预告都能让期待值降低一些呢。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4829bnfkjjw3wfv.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">当然这部剧有李易峰和杨洋压阵，收视绝对不会差，想说当时选角也还挺有商业眼光，现在这两位都是当红人气偶像了，每次一出片花剧照转发率都吓死人惹。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4829hqgtglbvcs3.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">顶着锅盖煲仔还是要说，小哥这整个人设都有一股装逼的杀马特气息。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4829mdh02fwx1bv.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">但是颖儿、张晓晨演的霍秀秀和解语花是什么鬼。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">从曝光的剧照和片花看，电视剧改编不少，老九门的故事里的人物率先登场，预告片中还出现古装的戏份，把原著中寥寥数语带过的鲁殇王的故事加了进来，看来又要演一遍古代爱情。至于故事中最重要的古墓探险场景，虽然宣传稿不停说耗费几十万，花了多长时间，但煲仔看来，这&darr;特效撑死不超过2块钱。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4843bz3ipnilga2.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">而且，古墓&hellip;古墓&hellip;新的跟刚搬进去一样是怎么回事。。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">喝，我们总不能拿冰与火之歌的水平要求我们的网络剧吧。放低期待值，平常心看看就行。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《两生花》</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出时间：2015年6月12日</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出平台：江苏卫视、浙江卫视</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演：刘恺威、王丽坤、高仁、顾璇、霍政谚</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4843aqfnirdguta.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">改编自唐七公子小说《岁月是朵两生花》，以一位失忆男子与单亲妈妈的爱情为主线，讲述了一个关于遗忘、守护与重逢的故事。霸道总裁这股热潮渐渐退散，如今的荧屏换成了暖男当道。连刘恺威都不演霸道总裁改演呆萌暖男了，还真有点儿不适应。原著煲仔还挺喜欢的，所以估计这部要看看。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《旋风少女》</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出时间：2015年6月28日</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出平台：湖南卫视</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演：胡冰卿、杨洋、陈翔、白敬亭、吴磊</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_48431vhki3hjgfu.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">改编自明晓溪同名小说，由唐人新捧的妹子主演，集结了一大拨少男少女，选在暑期档上映简直占尽天时地利人和。不过一般这种全是小鲜肉的片子，拍好了就是《一起来看流星雨》第一部，没拍好则分分钟变成《不一样的美男子》。对于煲仔这种书迷来说，先看个一两集再说吧，应该能坚持到杨洋吴磊露肉那一集的（正经脸）。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《偏偏喜欢你》</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出时间：接档《前夫求爱记》</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出平台：湖南卫视</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演：陈乔恩、贾乃亮、黄宗泽、郑爽、许绍雄</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4843r02smoizrey.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">平民女孩与留洋女博士互换身份引发的爱恨情仇，唯一新就新在故事背景设置在军校（为这个桐华还跟于正吵了一架），一水的制服诱惑，再谈谈情卖卖腐，想必能吸引不少女粉丝。片花出来的时候那段男男人工呼吸教学就已经被传疯了。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4846qxp2kaf1zad.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">耻度这么高没关系吗！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4847vq4qyyvlx0i.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">哎，煲仔只是没想到欢喜哥（出自《使徒行者》）也会在里面。不过你以为这样煲仔就会看了吗？是的！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">《实习生》</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出时间：2015年6月</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出平台：未知</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演：赵丽颖，郑恺，蔡文静，郑家彬</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4847vwyess1broi.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">根据蓝小汐同名小说改编，讲述了宋暖（赵丽颖饰）、张盛（郑恺饰）、赵小川（郑家彬饰）等几名大学毕业生初入职场，在经历数次职场考验后获得自我成长和甜蜜爱情的故事。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"六月一大拨国产剧来了，看完有点怕_国产剧,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4847jfjzy1l2kb5.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">郑恺在剧里有一段神似邓超的表演，扮魅惑美女跳热舞。看剧照就已经get到一大拨广告植入浓浓的商业大片气息袭来，哎反正这种不痛不痒的剧煲仔都连用来打发时间都舍不得。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">煲仔OS：细心的你一定发现了，以上煲仔精选的六部热门新剧里，居然有五部是由小说改编的！而且赵丽颖和杨洋每人承包了两部&hellip;煲仔之前给大家整理过《这些小说都要翻拍成剧》（戳文末<strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">阅读原文</strong>可查看），也许在不久的将来，十部热门新剧里，十部都是小说改编而来的。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">其它新剧</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">《剧场》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出时间：2015年6月10日</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出平台：北京卫视、陕西卫视</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演：陈数、孙淳、翟天临、种丹妮</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">《你是我的姐妹》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出时间：2015年6月14日</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出平台：山东卫视、安徽卫视</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演：刘恺威、娄艺潇、白冰、刘雅瑟</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">《神犬小七》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出时间：2015年6月</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出平台：湖南卫视</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演：金世佳，郭碧婷，王煜，刘倩文</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">《后海不是海》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出时间：2015年6月14日</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出平台：天津卫视、东方卫视</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演：张嘉译、倪大红、王海燕、左小青、张晞临、尤勇</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">《姐妹兄弟》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出时间：2015年6月16日</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">播出平台：安徽卫视</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演：朱亚文、李小冉、冯雷、曾黎</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">煲仔原创文章 转载请注明 来源 微信:煲仔看剧 ！</strong></p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5187', '58', '<br>\n<p><strong>引导语</strong>：速度与激情系列电影一直深受大众追棒，除了欣赏到令人惊艳的名车，还有可以看像保罗沃克一样帅的俊男美女，实在是一件赏心悦目的事情。再者，《速度与激情》一些经典的台词，让人回味无穷。其中，有句台词可以定义《速度与激情7》和整个系列：我们没有朋友，我们是家人。 <br />\n<img alt=\"《速度与激情》经典台词：我们没有朋友，我们_速度与激情,娱乐,台词,娱乐台词_读多多\"  style=\"cursor: pointer; height: 224px; left: 376px; display: inline; top: 172px; width: 400px\" src=\"/tu/allimg/Yulu/Yulu_50372dbtcesevws.jpg\" width=\"400\" height=\"224\"  />&nbsp;<br />\n　 1、想钓大鱼，得到深水去。 <br />\n<br />\n　　2、无论你身处何方，无论是4分之1英里的赛道还是饶了大半个地球的距离，我们生命中最重要的东西就是这屋檐下的人就在此时就在此地。你永远在我身边也永远是我的兄弟。 <br />\n<br />\n　　3、多米尼克&middot;托雷多，你不认识我。不过很快会认识了。 &mdash;&mdash;杰森斯坦森 <br />\n<br />\n　　4、开始干活吧。 <br />\n<br />\n　　5、人生中最重要的永远是此刻此地的家人。&mdash;&mdash;范迪塞尔的旁白开始 <br />\n<br />\n　　6、这还有点意思。 <br />\n<br />\n　　7、你们做自己该做的，但不要放过他。 <br />\n<br />\n　　8、我们从起点走来历经漫漫长路；每一次飙车就像走过一次人生。 <br />\n<br />\n　　9、你死了，我也不会活。 <br />\n<br />\n　　10、你们的游戏规则这边不管用。&nbsp; <br />\n<br />\n　　11、我这辈子最不后悔的事就是走进你家的店买下了第一块三明治。 <br />\n<br />\n　　12、在伦敦结下的梁子，人家找上门了。 &mdash;&mdash;范迪赛尔 <br />\n<br />\n　　13、终极一战。 <br />\n<br />\n　　14、记得欧文 肖吧？这是他的大坏蛋哥哥！ <br />\n<br />\n　　15、老子要开工了。 <br />\n<br />\n　　16、我看到你对米亚很好，你会是个好父亲。&mdash;&mdash;范迪塞尔 <br />\n<br />\n　　17、我没有朋友，我们是家人。 <br />\n<br />\n　　18、谁能告诉我接下来我们要做什么？ <br />\n<br />\n　　19、没想到可以玩的这么大。 <br />\n<br />\n　　20、不说声再见吗？怎么说得出口？&nbsp;</p>\n<p><img alt=\"《速度与激情》经典台词：我们没有朋友，我们_速度与激情,娱乐,台词,娱乐台词_读多多\"  style=\"cursor: pointer; height: 307px; left: 301px; display: inline; top: 130px; width: 550px\" src=\"/tu/allimg/Yulu/Yulu_5037k4q0rl1dwas.jpg\" width=\"550\" height=\"307\"  />&nbsp;<br />\n<br />\n　　21、You ride,I ride. <br />\n<br />\n　　22、这还有点意思 <br />\n<br />\n　　23、你和你的朋友已经身在其中。 <br />\n<br />\n　　24、当我飙车到100迈时，我才能体会到自由的滋味。 <br />\n<br />\n　　25、还以为就那样了，原来还有更牛的。 &mdash;&mdash;保罗沃克 <br />\n<br />\n　　26、不过很快就认识了。 <br />\n<br />\n　　27、我们在被追杀。 <br />\n<br />\n　　28、好戏开始了。 <br />\n<br />\n　　29、如果24小时后我没有联系你，你就带着杰克继续往前。 <br />\n<br />\n　　30、我要和你一起去。&mdash;&mdash;保罗沃克</p>\n<p><br />\n　　31、这是一场绝对的硬仗。 <br />\n<br />\n　　32、生命中最重要的是陪伴。 <br />\n<br />\n　　33、有谁可以告诉我等一下到底要干嘛？ <br />\n<br />\n　　34、无论如何&hellip;&hellip;你跟你的朋友是跑不掉了。 <br />\n<br />\n　　35、我们没有朋友，我们是家人。I dont have friends，I got family. &mdash;&mdash;范迪塞尔 <br />\n36、人生很简单，做了决定就不要后悔 <br />\n37、她活了下来。 她在地狱走一遭，变得更坚强了。 <br />\n38、You break her heart,I\'ll break you neck.你若伤她的心，我就扭断你的脖子。 <br />\n39、你们的游戏规则这边不管用。 <br />\n40、我没有朋友，我们是家人。 <br />\n编后语：&ldquo;家人&rdquo;版特辑以范迪塞尔的旁白开始：&ldquo;人生中最重要的永远是此刻此地的家人&rdquo;，道出了《速度与激情7》的故事主线。为了保护家人，范迪塞尔再次率领的多米尼克&ldquo;飞车家族&rdquo;走上与大反派杰森斯坦森的斗争之路。</p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5186', '58', '<br>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">又是一年六一儿童节。谁说儿童节只能是孩子们的节日？即便已经成年，却仍有无数童年回忆难以忘记。因此，在六一儿童节，让我们借这十部儿童电影，去回忆自己的童年，过一个属于成年人的儿童节。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">这其中一定有你的回忆。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">1、《霹雳贝贝》</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4934kqhunrjmkvw.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演: 翁路明 / 宋崇</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">编剧: 张之路</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演: 张京 / 王莹 / 章萍 / 刘长 / 鄢丽娜 / 张驰 / 景丽平 / 乔奇</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">类型: 剧情 / 科幻 / 儿童</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">制片国家/地区: 中国大陆</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">语言: 汉语普通话</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">上映日期: 1988</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">片长: 90分钟</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4934bwdh3ihu3zl.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">一个夜晚，一名孕妇正在妇产科的手术室里生产，忽然，天空中出现了一个放着奇异光辉的不明飞行物。飞行物一闪而过，手术室里的灯暗了一下，一个可爱的小生灵咕咕坠地了，那就是贝贝（张京饰）。贝贝生来就和常人不一样，因为他的双手竟然带电和能随意操控电器！为了怕发生意外，贝贝的双手总是戴着手套，总是被大人关在家里。贝贝慢慢长大了，终于到了上学的年龄。学校里、生活中，贝贝带电的双手和他的超能力既带给了他很多欢乐，亦为他带来了不少烦恼&hellip;&hellip; &copy;豆瓣</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">这差不多是所有七零后与八零后的童年回忆，每个人的童年都会有着那么点关于 霹雳贝贝的回忆。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">2、疯狂的兔子 (1997)</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4934z2aqvrclmuk.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演: 崔小芹 / 孟卫兵</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">编剧: 张之路</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演: 柳田 / 赵梦洋 / 陈述 / 崔岳 / 黄迎 / 常兰天</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">类型: 科幻 / 惊悚 / 儿童</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">制片国家/地区: 中国大陆</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">语言: 普通话</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">上映日期: 1998</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4935wjahl4pffsb.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">未来某城市，艺校姑娘然然（柳田饰）常带邻家小孩豆豆（赵梦洋饰）玩耍，不料在一起偶然事件中豆豆丢失，她焦急万分。此时，城市上空降临UFO，宇航局安全处派出的特工莫名其妙失去了记忆。局长（王鹰饰）让侦察员叶云（李艺饰）观看监视录像，录像中似有一个类似豆豆的身影出现，但很快便消失了。与此同时，班上来了一个酷似豆豆的学生李大米，他随身携带一个神奇的游戏光盘，如果谁玩光盘大喊&ldquo;神奇的兔子&rdquo;，不可思议的事情发生了，兔子竟然跳到人的身上，兔形浸入人的衣服和皮肤，而人也变的疯狂暴唳。然然因拒绝玩此游戏，疯狂的兔子弄坏了她的乐器。原来，西伯尔星球科学家劫持了豆豆并改变了其大脑，改名换姓派回地球作恶...... &copy;豆瓣</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">那时候的国产儿童电影并不多，尤其还是科幻题材。本片与《霹雳贝贝》一样，都来自张之路的作品。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">3、大气层消失 (1990)</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_49352n5dbxbf4uu.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演: 冯小宁</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">编剧: 冯小宁</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演: 张宁 / 吕丽萍 / 吴京安 / 王咏歌 / 张京生</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">类型: 科幻 / 儿童</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">制片国家/地区: 中国大陆</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">语言: 汉语普通话</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">上映日期: 1990</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">片长: 93分钟(中国)</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4935553yho5rf5y.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4935ktzh2zd1nsi.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">一对情侣（张京生 &amp; 吕丽萍饰）为了钱财抢劫火车，致使一辆运送剧毒药品的罐装车毒气泄漏，最终烧穿了臭氧层。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">与此同时，正因病在家休息的男孩（张宁饰）突然发现能够听懂好朋友大白猫的语言。大白猫告诉他这起严重的事故，如不及时加以制止，地球上的生物最终都将灭亡。然而大人们为了金钱忙碌奔波，根本不会相信男孩和动物说的话。万般无奈之下，男孩只能和其他动物联合起来寻找污染源，以一己之力拯救全人类&hellip;&hellip;</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">本片荣获第十一届金鸡奖（1991年）特别奖。 &copy;豆瓣</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">幼小的心灵当时被这部片子吓得不轻。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">4、自古英雄出少年 (1983)</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4935glxy1h2c5zt.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演: 牟敦芾</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演: 郝勇 / 张小燕 / 胡益林 / 吕立 / 任刚</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">制片国家/地区: 香港 / 中国大陆</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">语言: 汉语普通话</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">上映日期: 1983</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">片长: 84分钟</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4935dzetg5atlys.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4935gg2p410a1on.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">年仅十岁的富绅小少爷&ldquo;大丈夫&rdquo;（郝勇饰）生性顽皮，不服管教。为使其收心敛性，父母替他娶了一个二十多岁的媳妇（张小燕饰）。媳妇武艺高强，管教甚严，这可苦坏了散漫惯的大丈夫，遂找准机会，逃离家门。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">时逢清朝末年，国家动荡不安，朝廷腐败，烽烟四起。天地会以&ldquo;反清复明&rdquo;为宗旨，带领起义民众反抗清朝的高压统治。后因内奸告密，总舵遭到突袭，兄弟死伤无数。总舵主之子在黄婆婆的护送下藏匿江边小城。大丈夫偶然机会救下黄婆婆，从此立志加入天地会，永不回家。谁想朝廷派出大内高手，一路追杀天地会遗孤，黄婆婆更被高手所害。失去庇护的孩子们手足无措，命运多舛&hellip;&hellip; &copy;豆瓣</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">已经记不清这个电影看过多少遍了，就算情节已经模糊，但关于那个叫大丈夫的孩子以及他的大老婆，却始终记得。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">5、魔表</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_49352hlchjqzbwc.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演: 徐耿</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演: 张小童 / 金佳 / 于德先</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">制片国家/地区: 中国大陆</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">语言: 普通话</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">上映日期: 1990</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4935ndnqmrp1lzq.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4935sepmabhgmg0.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">正在上小学的男孩康博思（金佳饰）最近有些烦恼，他因为个小经常受到别人的欺负，于是希望自己快快长大。偶然机会，康博思买到一块魔表，阴差阳错之下魔表帮他实现了愿望，转眼之间他便长成了大人。但是成年康博思（张小童饰）的兴奋并没有持续多久，因为父母错把他当作了入室行窃的小偷，更险些被送入精神病院。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">好不容易逃出来的康博思开始寻找变回小孩的办法，但命运似乎有意捉弄，总设出各种各样的障碍考验康博思。他最终能否找回属于自己的童年呢？ &copy;豆瓣</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">里面的成年康博思由张小童饰演，而现在，张小童叫张嘉译。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">6、北京小妞</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4935cd43w11xizq.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演: 秦志钰</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演: 高放 / 侯耀华 / 凌元 / 马雅舒 / 孙佳星</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">类型: 家庭 / 奇幻</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">制片国家/地区: 中国大陆</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">语言: 汉语普通话</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">上映日期: 1991</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_49362rhyq1nkgem.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4936ww0a0r4rpby.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">文静清秀的女孩金京（马雅舒饰）是北京&ldquo;花裙子艺术团&rdquo;的会计，她总是默默地为大家服务，腼腆又胆小。一日回家路上，刚刚得到的捐款被流氓抢劫一空，并且在流氓的威胁下，金京没敢揭穿他们。此事让她后悔不已，发誓要成为一个勇敢的人。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">机缘巧合，金京向一位神秘的老者学习了神功。学会此神功的她，不仅大显身手抓了不少非法分子，还得以参加艺术团的伴舞。然而流氓偷走了白悦悦（孙佳星饰）家的贵重纪念品，使悦悦哑了嗓子。&ldquo;中学生青春杯文艺大奖赛&rdquo;比赛在即，参加比赛的悦悦心急如焚。急中生智的金京将神功传给了悦悦，悦悦顺利拿到金奖。不仅如此，金京还在公安人员的帮助下，利用神功制服了坏蛋，赢得了小英雄的称号。 &copy;豆瓣</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">无论如何，你一定记得那个主题曲，北京小妞，果然风流。此外，本片主演则是当时还是童星的马雅舒。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">7、熊猫历险记 (1983)</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_493654faeljgr3h.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演: 光源</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">编剧: 丁远亭</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演: 喻小风 / 高群 / 吴笑平 / 周凤山</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">类型: 剧情</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">制片国家/地区: 香港 / 中国大陆</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">语言: 汉语普通话</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4936n0lzybo2zfo.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4936y0v4ia5bjta.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">很久很久以前，有一处白马藏族人民才熟悉的美丽森林。这里竹影婆娑，风光秀美，最值得称道的是此地生活着世界上独一无二的物种&mdash;&mdash;大熊猫。顽皮的熊猫宝宝平平对大森林和外面的世界充满好奇，它不顾妈妈的劝告，执意要走遍森林的每一个角落。这一日，善良的祖孙俩白马藏医老爷爷（高群饰）和孙子小风（喻小风饰）上山采草药，小风意外结识了偷偷溜出去玩的平平。未过多久，平平不慎落入猎人设下的陷阱，危急时刻得到了小风的救助。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">到手的猎物跑掉，令猎人独角（吴笑平 饰）大为光火，他想方设法要抓到熊猫母子，而勇敢善良的小风将尽最大的努力保护可爱的熊猫朋友&hellip;&hellip; &copy;豆瓣</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">8、天堂回信 (1992)</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4936vw02rtrmffj.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演: 王君正</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">编剧: 贺国甫</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演: 石晨 / 李丁</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">类型: 剧情 / 儿童</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">制片国家/地区: 中国大陆</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">语言: 汉语普通话</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">上映日期: 1994-11-06</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">片长: 88分钟</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4936zsaukxypldf.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4936g123nbxwnr3.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_49371i3rbzsh3cl.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">1990年代，北京。晨晨（石晨 饰）的爸妈在国外工作，他平日与爷爷（李丁饰）一起生活。爷爷干了一辈子邮政工作，退休后与孙儿相依为命。一天，祖孙俩把一封已故去的收信人的信件系在风筝上放飞天空，爷爷告诉晨晨：他在天堂会收到的。不久，妈妈（肖雄饰）从国外回来了，她看不惯公公对晨晨的放任，每天给晨晨布置了英语、钢琴等课程，原有的平静不见了，爷爷搬回了自己的旧居。晨晨日夜思念爷爷，他恨透了什么英语钢琴，整天哭闹不休，妈妈见此若有所思。爷爷的生日到了，晨晨与好伙伴琳琳送来生日贺卡祝福，爷爷带他们外出放风筝，劳累一天后，在孩子们的欢笑声中，爷爷竟然永远&ldquo;睡&rdquo;去了......</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">本片获德国第43届柏林国际电影节国际青少年儿童影视中心奖；美国第10届芝加哥儿童电影节最佳影片奖；荷兰第7届儿童电影节最佳影片大奖；伊朗第25届伊斯法罕儿童电电影节最佳导演金蝴蝶奖。 &copy;豆瓣</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">当年，不知有多少人被这个电影感动的一塌糊涂。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">9、我的九月 (1990)</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4937pzg0t55nusn.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演: 尹力</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">编剧: 杜小鸥 / 罗辰生</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演: 张萌 / 张国立 / 陶泽如 / 沈丹萍 / 邢丹丹</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">类型: 剧情 / 儿童</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">制片国家/地区: 中国大陆</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">语言: 北京话</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">上映日期: 1990</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4937lz5umhuvyvs.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4937ucwwytf2xj2.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4937y44tvmueoke.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">1990年九月，北京亚运会前夕，大榆树小学的百来名学生正在为开幕式的团体体操表演进行紧张的训练。其中一名叫安建军（张萌饰）的却因为总是反应慢半拍而被取消了参赛资格，和他一起被取消的还有他的几个小伙伴。被人称作&ldquo;安大傻子&rdquo;的建军伤心不已，在中队长刘庆来（张晨饰）的怂恿下，几人到训练场捣乱，引得新来的班主任高老师（张国立饰）到建军家家访。而这次家访让一直胆小不敢言的建军与高老师成为了好朋友，二人相约日后有什么问题就说出来一起解决。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">一次偶然，建军买彩票中了五十块钱捐给了亚运会，这引来了晚报记者的采访。但害羞的建军没有把自己的名字说出来，倒是刘庆来说了自己的名字，于是这份荣誉就挂在了庆来的头上。受到委屈的建军在高老师的鼓励下，开始省下买早餐的钱来买彩票，且勤奋练习武术。在亚于会开幕前2天，有同学突然受伤不能参加。建军的辛勤得到了证明，他和小伙伴们站在了亚运会的会场&hellip;&hellip; &copy;豆瓣</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">不光这部电影，连北京亚运会都是童年回忆之一。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">10、三毛从军记</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4938hujntcmkzy2.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">导演: 张建亚</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">编剧: 张建亚 / 张乐平</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">主演: 贾林 / 魏宗万 / 孙飞虎 / 朱艺 / 李颖</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">类型: 剧情 / 喜剧 / 战争</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">制片国家/地区: 中国大陆</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">语言: 汉语普通话</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">上映日期: 1992-10(中国大陆)</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_493813mwk4ele5c.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4938gnq42cxa2zs.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"十部回忆中的儿童电影带你回到童年_童年,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4938crzb2vxeofj.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">三毛（贾林 Jia Lin 饰）从来就是银幕上喜剧人物。这次，三毛从军了。抗日战争全面爆发了，无所事事的三毛一心想着为国立功，加入了军队。不料，新兵训练的时候就笑话百出。手榴弹实弹投掷训练时，三毛一不小心就将手榴弹投到了战壕里，搞得全军上下一片乌黑。稀里糊涂的三毛随后参加了一支敢死队，笑话百出的他和队友们竟一股全歼了敌军。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">抗敌有功，三毛高升到后勤部，不用再上战场了，却成了师长姨太太的跟班。整天被使唤也闹了不少笑话。不料兵败师长自杀，三毛又重投兵营。一次执行空降任务时，三毛和以前的知心战友遭到伏击，大难不死却落入深山。一等就等到了抗战结束，三毛和战友早已成了野人。 &copy;豆瓣</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">三毛本就是属于我们童年的回忆。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">看了这十部电影，有没有给你带来些许的童年回忆呢？趁着六一，不妨找一部属于童年的电影，重温一下旧时光吧！</strong></p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5188', '58', '<br>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">1.一直承受着这个年纪不该有的美貌，好累！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"走开，霍建华才是花千骨的第一女主角！_霍建华,花千骨,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4924i4btbtybvkq.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">2.左手右手一个慢动作，右手左手慢动作重播，你有没有爱上我？</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"走开，霍建华才是花千骨的第一女主角！_霍建华,花千骨,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4924k20iuud0bi4.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">3.喃，他就是那朵娇花儿！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"走开，霍建华才是花千骨的第一女主角！_霍建华,花千骨,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4924q0rdf4yaapb.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">4.好长的手指！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"走开，霍建华才是花千骨的第一女主角！_霍建华,花千骨,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4925twejkm55c32.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">5.大保健！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"走开，霍建华才是花千骨的第一女主角！_霍建华,花千骨,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4925wgt3pbxwivv.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">6.孕吐好辛苦！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"走开，霍建华才是花千骨的第一女主角！_霍建华,花千骨,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4925ywgdsugrkbd.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">7.中药世家，不脱发！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"走开，霍建华才是花千骨的第一女主角！_霍建华,花千骨,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4925nzlxakuqlzm.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">8.愿得一学霸，白首不相离。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"走开，霍建华才是花千骨的第一女主角！_霍建华,花千骨,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4925u4ouwgw4vy4.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">9.最美的不是下雨天，而是与你一起躲过雨的屋檐。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"走开，霍建华才是花千骨的第一女主角！_霍建华,花千骨,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4925o0imzw0kdna.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">10.今晚，带你装逼带你飞！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"走开，霍建华才是花千骨的第一女主角！_霍建华,花千骨,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_492541bkqsqofa3.jpg\"  /></p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5189', '58', '<br>\n<p>&ldquo;想想我们曾经无关，又何必彼此苦苦为难。&rdquo; -- 《 左 耳 》</p>\n<p><img alt=\"左耳经典台词语录_左耳,娱乐,娱乐台词_读多多\" src=\"/tu/allimg/Yulu/Yulu_5121mexzqpmimtb.jpg\"  /></p>\n<p><img alt=\"左耳经典台词语录_左耳,娱乐,娱乐台词_读多多\" src=\"/tu/allimg/Yulu/Yulu_5121dghjoew5yxb.jpg\"  /></p>\n<p><img alt=\"左耳经典台词语录_左耳,娱乐,娱乐台词_读多多\" src=\"/tu/allimg/Yulu/Yulu_5121wgj2xrvwolc.jpg\"  /></p>\n<p><img alt=\"左耳经典台词语录_左耳,娱乐,娱乐台词_读多多\" src=\"/tu/allimg/Yulu/Yulu_5122mh0gwbhfsqe.jpg\"  /></p>\n<p><img alt=\"左耳经典台词语录_左耳,娱乐,娱乐台词_读多多\" src=\"/tu/allimg/Yulu/Yulu_5122gusezjcmkbu.jpg\"  /></p>\n<p><img alt=\"左耳经典台词语录_左耳,娱乐,娱乐台词_读多多\" src=\"/tu/allimg/Yulu/Yulu_5122ey2vjgl5twk.jpg\"  /></p>\n<p><img alt=\"左耳经典台词语录_左耳,娱乐,娱乐台词_读多多\" src=\"/tu/allimg/Yulu/Yulu_5123mi1hvjsodod.jpg\"  /></p>\n<p><img alt=\"左耳经典台词语录_左耳,娱乐,娱乐台词_读多多\" src=\"/tu/allimg/Yulu/Yulu_5123kycoprpalmw.jpg\"  /></p>\n<p><img alt=\"左耳经典台词语录_左耳,娱乐,娱乐台词_读多多\" src=\"/tu/allimg/Yulu/Yulu_5124ej20msl3kdt.jpg\"  /></p>\n<p>&nbsp;</p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('5191', '58', '<br>\n<p><object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,19,0\" width=\"560\" height=\"480\"><param name=\"movie\" value=\"http://player.video.qiyi.com/4ec7b12829d565bd93fa59c819513d55/0/0/w_19rs3pq6nh.swf-albumId=3747065409-tvId=3747065409-isPurchase=0-cnId=25\" /><param name=\"quality\" value=\"high\" /><embed src=\"http://player.video.qiyi.com/4ec7b12829d565bd93fa59c819513d55/0/0/w_19rs3pq6nh.swf-albumId=3747065409-tvId=3747065409-isPurchase=0-cnId=25\" quality=\"high\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" type=\"application/x-shockwave-flash\" width=\"560\" height=\"480\"></embed></object></p>\n<p>近日，西南科大百人合唱在网上火了。据悉这次西南科大百人合唱快闪活动是学校学生艺术团为纪念五四精心策划的。但合唱第一首《后会无期》却让不少网友想到了毕业季。每年6月份是大学毕业的时候，这时候一首《后会无期》会让不少网友心生感慨。大学四年，汗水与浪漫挥洒的地方，无悔的青春留在了那里。有网友因这个视频回忆自己的大学生涯，留言称，真想一梦再回校园。 <br />\n据悉，4月28日中午，西南科技大学第五食堂内，正是学生用餐高峰期，学生爆满，当大家都还沉浸在美食中的时候，一段耳熟能详的歌谣在整个食堂响起，瞬间吸引了大家的目光，后会无期、同桌的你、喜欢你、一想到你呀、找自己，这些歌中，装载的都是满满的青春回忆，让人听罢不禁湿了眼眶。据了解，这是西南科大的学生艺术团，为了纪念五四精心策划的快闪活动，整场活动共有70多名来自不同专业的同学参加，从3月份便开始筹备选择歌曲、舞蹈编排、场地布置、后期制作，为了活动效果，每一个环节都对外界保密。 <br />\n@超级刘小六：听着听着眼泪就哗哗的了。突然特别不想毕业，特别不想离开我的大学，特别不想和无忧无虑而又任性的青春告别。 <br />\n@-给你脸了哦：开头的男女独唱好赞。 <br />\n@格桑花飘：年轻真好，看的我热泪盈眶。毕业十几年了，但是还是觉得大学的时光是人生最美好的阶段。 <br />\n@呼天八月：想想任何走过来的 莘莘学子 都会感动的！~~！~！ 多么美好的岁月~！ <br />\n@西林C：我已毕业多年。那个食堂离我们当年宿舍楼近，各种回忆啊。 <br />\n@嚣张的考拉想游泳：听到同桌的你热泪盈眶，怀恋五食堂的肥肠米线，怀恋我的大学时光。</p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('230', '2000', '真的不知道怎么办了啊,我最喜欢的还是她,更本没有办法忘记啊!其实我真的好想她..我以为我和别的人在一起就可以忘记她,可以是我错了,我这样不仅伤害了别人,也欺骗了自己.熊猫..她现在很喜欢我了,但是我却觉得我对她已经没有感觉,和她在一起,只是一时的冲动,本来也许是有点感觉,但哪似乎只是暂时的好奇而已,尽管我尽量去喜欢她,但是我还是做不到,我觉得我对不起熊猫,真的,还有,我觉得我对不起她,虽然我这样也是为了她,只是她不懂,我觉得我现在心中苦只有我自己才知道,她只会觉得我现在变心了,她哪里知道,这样就是为了她,田塍问我喜不喜欢熊猫,我故意说喜欢,因为我不可能在她面前说我喜欢的人是她的老公啊,她也很爱她,所以我不可以哪样,田塍..我真的把她当我朋友,所以我不可以做让她害怕的事情,至于她..我真的不知道该怎么做了啊!哪么喜欢她,可以却只能远远的看着她..没有人可以替代的了..她要去广州了,我更本来不急回家,不知道怎么办了,真的好想看到她,她说她和田塍分了,我真的很以外,当然心里是有哪么⒈丝喜悦,但是这种喜悦只是一瞬间,我当心田塍受不了,也觉得她是哪么爱田塍,怎么会丢下田塍不管...哎...真的好矛盾啊....其实和她说做朋友,我真的是下了好大的决心才说出口的,我真的不想和她做朋友,我还是想和她在一起的,只是哪是不可能的了啊,与其哪么尴尬,还不如做朋友,虽然各自心里都怪怪的..但是,也没有更好的办法了啊..熊猫..我现在不知道怎么面对她,我以前是想认真对她的,可是只要我想到她.我就泄气了.我觉得我对不起熊猫了,她为了我.和她哪个在一起一年多的人分了..也许是我多心了,但是我知道我脱不了关系..她现在对我这样,我心里自然不好受,我都不知道自己有哪点好,她怎么会一下喜欢我,而且我还是欺骗她,利用她的啊,我好,哪牙签为什么不喜欢呢?...忽忽....我还是放不下,,一个问题没完.就又来了一个,真的是自找苦吃..张玲.哎!怎么说呢?7我相信过她,可以她老实骗人,虽然她说她没骗我,但是我觉得她就是有事骗我,所以我不理她,躲她,她找了我快半年了,我也很佩服她,在途中她找到过我,和我说了好多挽救的话与誓言,可以我就是不想理她,昨天我上网,她碰上了,她好高兴,和我说话,说了好多,我就是;哦,噢.恩回答她,,呵呵..她没有生气..一直哄我..我也觉得她真的变了,以前她哪么高傲,哈哈,,,最后磨不过她,她把电话要去了,昨天晚上打了.我没接,今天打了我没接.后来又打了个,,我就接起了.哈哈,,她说要来我这,还说要我回去,她会养我,我回绝了,我觉得我不该接受她,不管她为我做了什么,我都不想要了,我真的怕,我好怕别个骗我,我更本就没有能力辨别..也许张玲这次真的变了,但是我又会想起,哪个和她在一起⒊年的人.⒊年啊..我害的..我不应该认得她的..想到哪个女的,我都会自责.本来以为她门现在和好了,但是没想到,这么久了,她害在找我,我躲不过她,..不知道怎么办...我不敢回衡阳了,人不在,倒惹下了这么多事情...我也真的够很的噢...其实说来说去.最放不下的,也不想放下的还是她,我等不到我要的了,我也不敢等,尴尬的场面我也受够了,我不想在她面前哭,哪样各个心理都不好受,..真的好爱她,可是她不懂,..永远也不会懂了...刚刚滢滢和我说了好多,说我不该喜欢女的,是的,她门毕竟是女的,没有未来,但是我却是真的当真,,其实说真的,只要她说要我永远和她在一起,我会不顾家理和她在一起永远的...可以没有机会了,我们只能是朋友了....我只想告诉她,我是真的好爱她,不管她变成什么样,做了什么事,我都会永远爱她,尽管现实点,我以后嫁了人,我还是会记得她,还是会爱她的...因为她永远都是我的最爱的人...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('231', '2000', '满天星星　你的眼睛　像旧电影反覆剪辑我们的回忆是那颗星　我非常确定　会永远　闪烁在我心里雨后的夜里　夜空变得好美好干净　眼前的你忽然的沉静风吹过发际　无声轮廓有一双眼睛　纯洁而透明　我最爱的你　刹那变记忆温度冷冷地　最怕自己一个人呼吸　穿得再厚也变得多余身边少了你　说话只剩空荡的回音　好想抱紧你　我最爱的你　如今在哪里幸福时候　别来找我　带着你的快乐和他继续往前走不属于我　我不会难过　我知道　有一样的天空幸福走后　请记得我　我会紧握拳头把那伤心都赶走你要记得　至少还有我　一直在　为你默默守候一直以来这首歌,给我的感觉都是最好的,也许是因为某些原因吧,不知道为什么,只要听到这首歌,就可以让我想起好多事情,让我沉静在回忆理.....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('232', '2000', '你真的很残酷　用消失来弥补爱上你我扛的若背感情的包伏　用执着来报复你怎能自私作主我很恍惚　不清楚为何孤独　学不会不在乎记忆是照片　总不停拿出来翻阅就算　哭瞎了眼　流干了泪　爱从未熄灭我们的照片　温柔在左边　深情在右边少了你　故事没能到终点奇蹟会出现(还会重演)喔~　爱是张跟得上你的地图不怕等到盲目　找到麻木我的眼泪在笑里面哭合照变成了独照爱情却一点也没少　遥远的你知道', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('233', '2000', '那时我们总有好多话什么事都可以讲我的爱情比你早却一直放在心上后来你们之间的变化我不想再多说话经过了相遇和挣扎我还是无法将他放下那是多久后的事了一天你突然问我在那个时候是否也爱着他我也很想他我们都一样在他的身上曾找到翅膀只是那时的他是因为你他开始飞翔我也很想他在某个地方我少了尴尬你少了肩膀而夏天还是那么短思念却很长还记得那年我们三个许下的愿望星星骗了我们我们却因此上了一课成长必修的学分我们都一样', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('234', '2000', '拥抱的时候心情有点痛也去提早感受到寂寞离开的时候只听见沉默除了沉默我还能怎么做选择别对我抱歉别总觉得对我亏欠现在他在妳的身边就对他好一点不要再让你们的爱败给了时间既然遇见了永远就不要说再见不要再让你们的爱输给了永远我们经过那么多考验最后还是回到了原点总有那一天相遇的瞬间确定那些冷漠的从前已走远别对我抱歉别总觉得对我亏欠现在谁在妳的身边就对谁好一点我应该就走开就算感情还在我应该就放开对他不再依赖忘了曾有过的片段这是属于你们的未来不要看到你们的爱败给了时间我宁愿选择离别没有一句怨言直到你能若无其事聊起了从前我才发现彼此都了解默契是最宝贵的语言', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('235', '2000', '连朋友们也知道现在他只对她好维持往日惯常拖手散步当为我好如果她敢跟我对望谁人首先羞愧冒冷汗若是凭哑忍换到施舍的眼光不稀罕是我太好胜爱得不留情难以勉强去闭起双眼睛若要接收爱是建基于同情谁要扮伟大仍然欠公平只因我是我极清醒不爱靠梦境但又深知恋爱胜出需要任性(但愿温馨不靠献出骨气换领)谁能证明我失势亦未等于我失礼男朋友若看人只讲美丽退下也抵—古宅心慌慌-好胜、死性不改。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('236', '2000', '哇...终于把喜欢的歌都找到了啊,真的不容易,我还以为没有了呢,因为一直都找不到,也真的奇怪,这些歌出来,也有点小久了,为什么找不到噢?也许是运气不好吧..哈哈..还好.今天终于找到了,嘿嘿..哎...心理好烦啊,和滢说了好多,觉得自己真的很幼稚,好不懂事啊!可是就是不可以控制自己做任何事,没有自制力,好没用啊,真的好笨噢...什么时候才可以成熟一点呢?原来做什么事都以为是对的,可是,现在知道了,是我错了,真的很不应该自作聪明的办事,以为自己是对的,却没想到,我错了,凡事都不可以想得哪么简单的,有的事表面上是哪么是善解人意,可它的里层是哪么的曲折离奇...忽忽...有的事情,也许我的脑袋是永远都想不明白的...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('237', '2000', '哎呀..好蠢..这个日记本的背景音乐我不会搞,啊!!!气si我了啊!好想搞歌放上面去了啊,可是不会弄丫!真的好遗憾啊...不过!我会弄好的,嘿嘿...一定要把歌弄上去噢!嘿嘿...加油加油.....-观众..;有点宝气吧?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('238', '2000', '爱不可能持久尤其当一个人怀疑自己的时候本来更甜美的话现在却象在吵架如果没有人想承认自己还爱对方爱就变成挣扎爱不可能持久尤其当你开始怀疑我不爱你的时候本来想牵你的手现在却觉得尴尬如果没有人想承认自己还爱对方爱就变成挣扎我不想失去你又不知道如何去表达我爱你明明在心里面回荡我不想失去你又不知道如何去表达下次多希望你能够鼓起勇气说爱我', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('239', '2000', '哎..晚上玩惯了,睡不着,不知道怎么办了,日夜颠倒..白天像个病翁样,一到了晚上就飞得起来了,真的不想出来啊..习惯了.没办法啊,怎么睡也睡不着.晚上像个孤魂野鬼一样的,在街上游动...真的好无聊啊,没事做,明明说一个月不来上网的,可就是没事做...今天吃了好多东西,真的吃得我好像吐了,好腻啊,头好晕.的啊..呕~~~好象猪,睡觉、吃东西,没点事..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('240', '2000', '这是他的日记,看到和我一样的日记本,所有就看了下内容,写的真的很好噢,好现实噢,本来还以为他是个男生,后来在日记里看出,原来是个女的,不过,他的性格好象很像个男生噢..嘿嘿..很欣赏他..“无声崩溃”—熊怀素..有他qq就好了,对他好好奇啊,可是没有哦,好遗憾,我觉得他好有意思的…在日记里,都有点小了解他了,嘿嘿..不知道是什么样的人噢,写东西写这么好,像是看小说一样的,很有味…现在的这个日记本好象是他从新申请的,因为以前看过他的日记,好象不是这个,里面的内容不一样了,嘿嘿…偷看别人日记,很不好啊,我也是觉得他的名字好玩,就看了下,哪晓得写的好有趣啊..呵呵…', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('241', '2000', '回家的路总是很远话少得很可怜一个人的晚餐都是孤单的滋味看见身边重复上演属于我们的画面选择逃避的眼怎么还是会流泪爱着你的每一天你就是我的世界那时候还以为我就爱这一遍没有你的每一天快乐离我好遥远心已随你走了还能用什么感觉我舍不得睁开眼睛害怕身边没有你也许在梦境里是我们最近的距离想念你温热的手心冷风里把我握紧当冬天又来临这温度该怎么延续谢谢你曾经爱过我给我最美的经过但生命最爱被剥夺未来的路该怎么走忽然很想听这首歌..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('5190', '58', '<br>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4946bwjbkxkcqtt.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">或许每个在哆啦A梦陪伴下成长起来的孩子，都期盼能有属于自己的机器猫。那只没有耳朵的蓝胖子，就是关于童年的美好和希望。5月28日起，《哆啦A梦：伴我同行》在各大影院上映，相信很多小伙伴看完影片都哭得跟泪人一样。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4946ydv0ydbtzc5.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">当然这不仅仅是一个简单意义上的动画片，其实中间包含了很多八零九零后童年的记忆。一开始它叫&ldquo;机器猫&rdquo;，而现在它有了更洋气的名字&ldquo;哆啦A梦&rdquo;，从视觉上它也从扁胖变成了更加立体的肉感。而在小抠心里我最爱的蓝胖子其实是个暖男！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4946lw0c40oex4d.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">我眼中的的大雄和哆啦A梦</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4946o3e552yxcqy.jpg\"  /></strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">大雄生活懒散，做事半途而废，没有上进心，成绩也一塌糊涂。最希望的就是每天睡午觉和出去玩，生活没有目标，就算有了也是只尝试一下就马上放弃的。唯一的优点恐怕就是心地善良，忠厚老实，孝顺等等。有时觉得他的某些性格就像我们自己。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4947prf3tfnnzfr.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">哆啦A梦的出现给他了更多的勇气，虽然有时大雄会脱口而出，&ldquo;哆啦A梦快来帮我&rdquo;。但哆啦A梦却会帮助他的同时告诉他有些事情是不对的，而且那些奇特道具是一把双刃剑并不是只会有好处的。有人会说，哆啦A梦在大雄身边是带有任务的，但其实我更想说这是一种陪伴。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">陪伴是最长情的告白</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">大雄一直在改变，不管是靠好好学习的他。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4947bcg2um2dpmo.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">还是为了就静香在雪地里挣扎的他。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4947of5x4sfsbqv.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">他慢慢的变坚强、变得更加努力，用自己的双手和智慧在改变自己的命运。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">未来的大雄告诉你的，其实也是我想说给你听的</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4952ov0yeqq3cuj.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">但当你变得幸福时，我会真心祝福你！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_49592hjhlrtn10s.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">但是我的任务又已经结束了！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4959hb5gfco4hfp.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">我们不得不说再见！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4959kfrwzfzed2c.jpg\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><strong style=\"border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; border-left: 0px; padding-right: 0px; font-stretch: inherit\">哆啦A梦最想给大雄说的话</strong></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">难过的时候，我会乖乖的任你&ldquo;胡作非为&rdquo;。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_4959dkr5mep0wkf.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">我们一起有福同享，有难同当。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_5003czaok5tw2n3.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">同样的，我也可以当你的出气筒。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_5003meqfqqbaok3.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">我会带你一起去冒险，并和你一起见证最美的世界，我们的快乐是任何东西换不来的！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_5004ppcrvdpx3kc.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">你的最纯真笑容是我最难忘的一张脸。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_5004e2wozpisjro.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">你不努力的时候，我会帮助你改掉自己的缺点，还好我们争吵过后依然还对彼此不离不弃。因为我们都知道我们都不能没有彼此！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_5004zrwrpxdjkp4.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">大雄，就算我的百宝袋里有许多法宝，但是你必须靠自己的力量才能保护家人！因为总有一天我会离开你的身边，我离开之前最希望看到的是有人能代替我一生一世照顾好你。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_5004blqayzvbwrk.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">看见你被人欺负我会上前阻挡，因为你的软弱由我来保护；就算你再怎么调皮任性，我也不会怪你，因为你的吵闹由我来安抚。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_5004wyjqgeljxmm.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">你总是太逞强，明明自己做不了的事却要答应别人，最后老是哭着要我拿出法宝来帮你！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_500551zxmefebom.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">我知道你是个没有安全感的孩子，经常把自己弄得伤痕累累，一个人承受着比其他人更多更难的考验，所以我才来到你身边保护好你！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"陪伴才是最长情的告白_陪伴,爱情,娱乐,娱乐台词_读多多\" style=\"max-width: 100%; border-top: 0px; font-family: inherit; border-right: 0px; vertical-align: baseline; border-bottom: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; border-left: 0px; display: block; padding-right: 0px; font-stretch: inherit; border-radius: 4px\" src=\"/tu/allimg/Yulu/Yulu_50052n3gt3ejblo.gif\"  /></p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">你不要为我的离开而哭泣，相信你快快长大了，没有我的法宝也能够保护你身边爱的人。</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">其实这部影片是为了纪念原作者藤子&middot;F&middot;不二雄诞辰八十周年而制作的3D电影。导演山崎贵创作剧本时从原作中精选了7个最为人所熟知短篇故事，以&ldquo;哆啦A梦要帮大雄幸福&rdquo;为主线串巧妙地连在一起。其实导演山崎贵和八木龙一也都是哆啦A梦的粉丝，所以哆啦A梦会回来的！</p>\n<p style=\"word-wrap: break-word; border-top: 0px; border-right: 0px; vertical-align: baseline; white-space: normal; border-bottom: 0px; text-transform: none; word-spacing: 0px; color: rgb(93,93,93); padding-bottom: 0px; padding-top: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; padding-left: 0px; margin: 20px 0px; border-left: 0px; widows: 1; letter-spacing: normal; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">小抠会一直会想念喜欢吃铜锣烧，怕老鼠，而且因为手是圆球，所以每次猜拳都会输掉，怕热也怕冷的哆啦A梦。谢谢你陪伴我们度过了最美好的时光！</p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('200', '2000', '2004-12-16有一個女孩，她叫無淚天使，因爲她沒有淚水，只有歡笑。可是後來她變了，但是她仍叫無淚天使，可是是因爲她的眼淚都為他流光了……那個女孩，就是我。写这段话的原因是因为在《梦里花落知多少》上看到了一段类似的话，是关于台湾的无泪城的。后来稍加改编，就成了现在这段话，正好符合我现在的情况。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('201', '2000', '新的日记本本.呵呵...可笑死了!今天左手大指头的指甲忽然断掉了.不知道是为什么.不疼.只觉得有些可惜.很冷.外面风大雨大.我在屋里发抖.不明白还可以说什么.很多人都说我太自我了.我知道.我都知道.可为什么就是做不到要好好的.失望了.不知道要说什么了.又开始厌烦写字了.不知道要写什么好.一片混乱!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('202', '2000', '带走我的.不是你.就是命运.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('203', '2000', '不知道要写些什么.但还是觉得应该说点什么才好.好累.每天都睡到下午三四点才起床.呵呵.很无聊的生活.昨天晚上做了个梦.梦见自己又回到学校了.然后看到小树了.我对她说.乖.以后我又可以陪你一起吃饭了.小树问我这次可以陪她呆多久.我说半年.我就看见她不开心的走了.我怎么也叫不住她.然后就醒了.呵呵.真是个奇怪的梦.也许梦里我是笑了的.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('204', '2000', 'hoho~~又找到新男朋友勒额```希望你快乐额``嘿嘿', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('205', '2000', '2005-1-18“如果他今晚之前不回信，哪怕口头答应也可以，我就……永远不再跟他说话，永远不再理他，放弃我为他付出的一切，放弃我的一片痴心。”我真的又后悔了。我好傻，写了那样一封催人泪下的信，给一个一点都不在乎我的人。明知道人家不想理我，还要缠着人家，处心积虑的为人家着想，为人家付出一切，到头来，连人家一个微笑都没得到，我真是一sb，一大sb，我tm脑袋被门挤了，被地狱的门挤了！忘了他吧，做回原来的我，那个自信、可爱、天真、无忧无虑的我。从此以后，我走我的阳关道，他过他的独木桥，我们互不相干，他管不着我，我也指挥不了他。现在才发现，我以前所做的一切都付诸东流了，都白费了……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('206', '2000', '2005-2-23哥哥，告诉了我一件事。聪聪姐姐在大年初三晚上告诉他，其实她在同他相处的第7天就喜欢上了他，哥哥几乎是与她同步的。可是，他们谁也没说，等说的时候又晚了。哥哥说，如果姐姐早一点说出来，那么，他红地毯上的新娘就是聪聪姐姐，而不是嫂子……晚了，一切都晚了，姐姐去了郑州，哥哥说她不回来了。她以后还会有自己的幸福，但是，她却走上了一条与哥哥永不相交的道路……试问苍天为什么有情人却偏偏不能在一起？为什么彼此相爱却要分离？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('207', '2000', '痴心绝对想用一杯latte把你灌醉好让你能多爱我一点暗恋的滋味你不懂这种感觉早有人陪的你永远不会看见你和他在我面前证明我的爱只是愚昧你不懂我的那些憔悴是你永远不曾有过的体会为你付出那种伤心你永远不了解我又何苦勉强自己爱上你的一切你又狠狠逼退我的防备静静关上门来默数我的泪明知道让你离开他的世界不可能会我还傻傻等到奇迹出现的那一天直到那一天你会发现真正爱你的人独自守着伤悲曾经我以为我自己会后悔不想爱的太多痴心绝对为你落第一滴泪为你做任何改变也唤不回你对我的坚决别说我的眼泪你无所谓一个人在这个夜里孤单得难以入睡真的想找个人来陪不愿意一个人喝醉醉了以后就会流泪数着你给的伤悲为什么你总让我憔悴别说我的眼泪你无所谓看我流泪你头也不回哭过了泪干了心变成灰我想要的美你还不想给伤了的我的心怎去面对爱给了你我无所谓只希望你给我一次机会让我去追让我去飞毕竟爱过的心需要安慰需要你安慰喔......如果说...拥有你是上天对我的宽容~那又何必...开这样的玩笑~当你..找到幸福的那天..请不要忘记..有一个人..永远爱着你~~分飞你和我相约在午夜喧哗的大街告诉我这段感情今夜将会是终点傻傻的看着你眼角不流一滴泪说好了要坚强不流泪我以为我可以让爱变得很甜美才发现爱情竟是一场残酷的考验太愚昧太依恋才放你去自由飞一瞬间爱决堤在今夜雨纷飞飞在天空里是我的眼泪泪低垂垂在手心里是你的余味谁了解真心的付出换来是离别我知道爱过后会心碎我相信爱情没有永远勇气终于做了这个决定别人怎么说我不理只要你也一样的肯定我愿意天涯海角都随你去我知道一切不容易我的心一直温习说服自己最怕你忽然说要放弃爱真的需要勇气来面对流言蜚语只要你一个眼神肯定我的爱就有意义我们都需要勇气去相信会在一起人潮拥挤我能感觉你放在我手心里你的真心如果我的坚强任性会不小心伤害了你你能不能温柔提醒我虽然心太急更害怕错过你江南风到这里就是黏黏住过客的思念雨到这里缠成线缠着我们留恋人世间你在身边就是缘缘分写在三生石上面爱有万分之一甜宁愿我就葬在这一点圈圈圆圆圈圈天天年年天天的我深深看你的脸生气的温柔埋怨的温柔的脸孤单北半球用我的晚安陪你吃早餐记得把想念存进铺满我望着满天星在闪听牛郎对织女说要勇敢别怕我们在地球的两端看我的问候骑着摩毯飞用光速飞到你面前要你能看到十字星有北极星做伴少了我的手背当枕头你习不习惯你的望远镜望不到我北半球的孤单太平洋的潮水跟着地球来回旋转我会耐心等待随时欢迎你到来少了我的怀抱当暖炉你习不习惯E给你照片看不到我北半球的孤单世界再大两颗真心就能互相期待想念不会偷懒我的梦通通给你保管曲名：Journey歌手：张韶涵It\'salonglongjourneyTillIknowwheraI\'msupposedtobeIt\'salonglongjourneyAndIdon\'tknowifIcanbelieveWhenshadowsfallandblockmyeyesIamlostandknowthatImusthideIt\'salonglongjourneyTillIfindmywayhometoyouManydaysI\'vespentDriftingonthroughemptyshoresWonderingwhat\'smypurposeWonderinghowtomakemestrongIknowIwillfalterIknowIwillcryIknowyou\'llbestandingbymysideIt\'salonglongjourneyAndIneedtobeclosetoyouSometimesitfeelsnooneunderstandsIdon\'tevenknowwhyIdothethingsIdoWhenpridebuildsmeuptillIcan\'tseemysoulWillyoubreakdownthesewallsandpullmethrough?CauseIt\'salonglongjourneyTillIfeelthatIamworththepriceYoupaidformeoncalvaryBeneaththosestormyskiesWhenSatanmocksandfriendsturntofoesItfeellikeeverythingisouttomakemelosecontrolIt\'salonglongjourneyTillIfindmywayhometoyou.toyou', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('208', '2000', '心情异常的烦躁，找不到发泄的对象，不知道要怎么办才好。药也吃完了，不停的抽烟，口干舌噪，不想喝水，不知道要做什么。手上的疤很痒，使劲的用右手去挠它们，很疼，不过这样也好。爸爸把我的刀子都给扔了，真tmd烦！md，什么事情都不顺！要做什么？要干什么，我不知道不知道，大脑一片混乱，不想了。今天晚上也许又要失眠了吧，真糟糕，讨厌死失眠了，睁着眼开着天边开始泛白，然后眨吧眨吧干涩的眼睛，才倒头睡去。这样的生活真是过够了。想要出去走走，却不知道要去哪里。对什么事情都没有一点兴趣，厌恶所有，不知道不知道！我倒底想要的是什么呢？呵呵...发现自己越来越不会叙述事情了，什么都乱七八糟的，用手去抓也抓不到。唉！真的想要逃离这一切，远远的走开，什么事都不闻不问。那样一定会很好。心情真的是坏透了，坏透了啊！今天坐在车上看见一直很喜欢的那个理发店，早在几天前就说想要去剪头发了，却一直都懒得去，前面的头发长得不行了，我自己拿着剪刀剪了剪，感觉还不错。q上有朋友骂我是混蛋，我早知道自己是混蛋了，那又怎么样呢，我本来就是个混蛋。混蛋混蛋！我是彻头彻尾的大混蛋。想哭，却又哭不出来，这样的感觉真是难受死了，想杀人！只觉得烦躁。嘿嘿...一直在听《海啸》，真tmd爽！忽然好想听潘帅的《快乐崇拜》，记得以前sky很喜欢这首歌，我也很喜欢，有段时间里mp3一直放着这首歌，震得耳朵里嗡嗡直响，什么事情都想不了，那样的感觉真好。还有幸福大街的歌，病态的呻吟，听得我想死，真就想随着去了。越来越不容易满足了，每天都在自欺欺人的微笑着，听朋友讲他们的不开心和开心的事，听到麻木了，不想再去说什么了。我的微笑真让人恶心，假死了。忽然很想去淋雨，想要感受雨水一滴一滴砸在身上的那种感觉。记得初一的时候很爱淋雨，每次都全身湿淋淋的坐在教室里面上课，冷得直发抖还笑嘻嘻的，那时候真好，连痛苦都可以那么的渺小。有时候也蛮怀念过去那些朋友的，整晚整晚的疯在一起，大声唱歌，看帅哥，打架，看他们恶逗，笑得不行，真的很开心，没有什么烦恼。那个时候真的很好，可是那些人都走得差不多了，还剩我一个人在此徘徊，举足不定。为什么人越大烦恼就越多，痛苦就越大，我不明白，想不通。今天从以前的学校回来的时候，头一直隐隐的痛着，用手猛揉太阳穴，还是疼。一副邋遢样的跑到以前的学校去找朋友玩时，他们都惊讶的问我怎么穿着双拖鞋就跑去了，我嘿嘿的笑了两声说懒得换鞋，麻烦。什么事情都懒得去做了，老觉得什么都无意义，糟糕透了！开始猛听快乐崇拜，震死我了，地板也在震，哈哈...这样我都能去思考能写日记，我真是佩服死我了。不写了不写了，md，没什么好说的，只觉得烦躁！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('209', '2000', '(2005-03-0922:11:36)落luo败寂。...........烦躁(2005-03-0922:22:04)闲&鱼蛋咸咸怎么了？(2005-03-0922:12:17)落luo败寂。烦躁`(2005-03-0922:22:31)闲&鱼蛋咸咸发生什么事了？(2005-03-0922:12:57)落luo败寂。没什么`(2005-03-0922:23:38)闲&鱼蛋咸咸混蛋，有事你要出声，别一个人憋着！早晚疯掉！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('210', '2000', '看着这话就觉得疼..怎么幸福？！什么是幸福我不懂不懂真的我只是很难过不说了下了睡不着看会小说去无聊死了我全盘皆输', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('211', '2000', '无主题——你爱看不看回复于2005.03.1116:12现在没有并不代表以后也没有，现在拥有也不代表能够永远长久，如果你自暴自弃，那么你配拥有什么呢？什么都不配~~~~~~~~~~~~~~我想你真的是个注定得不到幸福的孩子~~~~~~~~~~~~那你就认命吧~~~~~~~~~~~~~无主题——亦远回复于2005.03.1116:14无主题——寂寞_落尘回复于2005.03.1116:12坛子.....好...我们一起死=================================sb你就只是为了幸福而活吗？？真命苦...抒发下自己的感情都会被骂....没天理啊!!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('213', '2000', '许淑鹏,你为什么要这样?我把你当朋友,可你?我以为可以一直和你在一起!过去的那些日子里,我们不是玩的很开心吗?何必在意那么多!我只是想和你做朋友,难道这也不行吗?你太让我伤心了!当初蓉也是那样,拒绝我!连作朋友也不行!那时,我好伤心!我一个人到外环转了一上午,真的好难受!你怎么丝毫也不想想我的感受?那晚,我在操场等你,等到8:30.你没来!和你说的一样!我抽了一包烟,我很少抽烟的!我不在乎别人怎么说?只想和你做朋友!你为什么不能理解我的心情?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('214', '2000', '下个月就去考试了!除去星期六和星期天就只剩下19天了!必须努力好好训练了!800米还得提高!100,铅球,三级跳都必须好好练!不然我及不了格了!还有蓉,她明天考试!但愿她能考好!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('215', '2000', '淑鹏是怎么了?qq也换了!不想让我打扰她吗?还骗我!说是房静!气死我了!真想骂她!算了!顺其自然吧!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('217', '2000', '华丽,我好嫉妒李文杰!真的!你说要给他买表时,我心里好难受!那时我正想要买一块表!你好......我对你那么好!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('218', '2000', '人为什么会不开心呢？我想是因为爱情吧我没遇到过可我也感受到拉，我的朋友都是这样我真心的希望他们可以快乐起来像我一样。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('219', '2000', '真想不到，哥哥会主动跟我和好。虽然这是我梦寐以求的，可是，当这个问题真的摆在我勉强的时候，我却犹豫了……最后，我的答案是同意，但不是现在，是下辈子，所以哥哥下辈子一定不要改名字，因为我下辈子还要继续作你妹妹。虽然哥哥没有问我原因，但是我还是要说，我们都变了，我不再是从前的我，你也不再是从前的你了，我们都回不去了。所以，我们只有以一种新的面貌新的心态去面对对方。……我所做的一切，只因为IONLYCAREYOU！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('220', '2000', '我从小就有梦想就是我长大了可以当一个歌手，我很崇拜那些出名的那么多的歌星我觉得他们好了不起可以唱出好歌。可我可能是不可能实现这个梦想了。但是我还是把唱歌当成我的业余爱好我相信我一定可以唱好歌的。一定可以', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('221', '2000', '不知道为什么.这几天心里好难受,好闷的,老是觉得有好多事情缠着我一样,让我透不过气来...心情不好,连天气也不佳.阴阴的.没一点精神好烦啊!今天和滢滢在街上买了个箱子,还买了点礼物回去送朋友,因为本来后天就要回去了,但是滢滢不和我一起,所以我就不想回去了,虽然在这天天和那个si鱼眼吵架.但是没有办法..si东西,天天没事找事和我争个不停..好象一天不吵心理不舒服一样,真受不了.打si你...好久没有上网了,真的闷得受不了了,....其实qq放在小猫那挂,看他们吵架我真的不好受,不知道该怎么办,该帮哪一边,哎..烦恼的人啊!有的时候想说什么想写什么.我一下子就不记得了..太健忘了啊,..也许又会有一段时间不会来上网了,因为说好.又听话,不出来上网,不然又别告状,哪就又完了啊.真没办法..真的想回家了啊.好想爸爸了.他一个人在家里,好寂寞啊..也不知道住在我家的哪个邻居还在没.要不然爸爸真的好寂寞...忽忽...还是觉得家里好,什么都不用愁.好无忧无虑的啊...还有就是想哪些朋友了...这么久不见,心里一点都不舒服啊..不知道回去会怎么样噢..哈哈...哎...看看吧!今天称过称.又瘦了..但是我觉得我怎么好象一点也没有瘦一样,希望哪称是对的啊!不然我就是空欢喜一场了..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('222', '2000', '生活是这般的乏味。现实是这般的残酷。人类是这般的无情。希望你不会让我尝到乏味。看到残酷。感到无情。小ling的心声。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('223', '2000', '最近好想听孙燕姿的那个(原点)但是就是找不到啊!怎么会这么慢啊?都出来好久了,碟没看到,网站也查不到,.好扫兴噢..还喜欢听twins的网站也找不到,不过..还好家里有丫..不然真的好遗憾啊..现在好喜欢听老歌噢.听起来蛮韵味的...特别是5566的真的让我回响起好多事,有开心的,也有不开心的,我听得最有感情的还是这个歌,也许是那时开心的时候听得过多吧..还有很多歌..都让我很轻而一举的流泪..就是该不了这个习惯,太喜欢哭了啊。都快成了累人了.有的时候好想忘记所有的事情,那时也许我就不会这么烦恼.矛盾了..我最怕的就是一个人的时候,那时我真的感到我是最孤独的时候,那时的我最容易哭了,..因为我脑袋老是乱想一些事情..好担心,..好空虚..也许有一天我会忘记一切不开心的事,那该多好啊,那我就又回到以前那个开心的我.哈哈..天天过得开心从事.可就是.时间是向前迈进的.它永远不会倒退..想回到过去的我,也只有我自己可以帮到我了...我会努力的.我会让自己快乐的.我会让自己没有烦恼的!我试着每天都和说这句话..相信我自己一定会那么一天的!恩!祈祷...!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('224', '2000', '好烦!心里好乱!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('225', '2000', '真的好无聊噢..忽忽,她不知道走哪去了啊,哎!找不到人丫..好像被遗忘的感觉,哎,我也太渺小了吧..?哼!好生气丫.!!气si我了..要崩溃了丫,.忽忽...怎么了丫,哎...!其实我看到她资料写别的女人,真的不好受,虽然是写不好的话,.但是哪样就表示她还很在乎哪个人.!忽..真是晕完了噢..是不是我太小气拉?...不知道她现在到底在做什么噢.以前天天逗在家丫.现在怎么好象消失了一样啊?奇怪噢?希望不是故意躲气来了,哪我不想si了啊..好讨厌她说话.老是和我说一种,和别的人说一种,真的受不了..最讨厌别人这样了,叫我怎么忍受?还好现在脾气好点了,和她说话没有揭穿,.也不想揭穿,哪样会搞得好尴尬的.我也不喜欢做这种事..一向不喜欢揭穿别人...只是我好怕她,真的,打从心里怕,我觉得她有好多事瞒真我,好象不和我说实话,也许是我没在她身边吧?但是哪也不要这样啊..我心里会好难受的丫!真的难受..好希望她什么逗和我说实话啊,!可是她就是不可以,虽然她说她说的逗是真的,但是我觉得不是,特别有的事她不告诉我,而告诉别人,天哪!哪感觉真的要命勒.因为我觉得不管是什么事,从她口里是什么意思.而从别人口里就不是哪样了,变了味.而且哪样还会让我觉得连哪些人逗比不上,做她老婆好象逗不能有什么话和我说,搞得我像个外人....哎..反正就是.感觉好难受,而且是我最讨厌的感觉....哎..也许我还不是她可以信任的人吧?哪也算了,就是我真的有时怕她,我不能分辨她哪句话是真的.哪句话是假的,..真的好担心啊!哎..现在在和别人吵架了..没精力写了...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('226', '2000', '嘿嘿...原来这个日记本,只要是保密的就可以看不到,哈哈..真好噢.操!那个神经病看我日记.真的是有味.好想骂了..真的不知道她是什么人,对他好点又发哈,当老子好欺负,对他不好点,又告状...从没看到人种人,还是个男的..真的没点志气,口太多了.一个男的口也太多了咯.真的是惹人看不气他,有时真的好爱耍点个性,发点哈,受不了,好想把他杀了啊!真的是头有毛病.老是莫名其妙的做事,哈驮来机也!我晓得你又会偷看我日记,我林打电话你也要偷听,哎,冒办法.你是杂裹吗人.有时候广耷你又广达你,我现在裹篇日记是装门写给你看裹,有好多事我林都不想广出达,给你脸不要脸,哎..我都不晓得要广吗裹达..哎!不过.你裹吗人不管吗样广是裹样裹..反正就是.不要发哈.老子现在是忍达你,不要得寸进尺..告状..哈哈.以为我怕啊!现在别哪个都晓得你是吗人.告我爸爸也冒用.到时候我回克多获哈我我爸爸就冒事答..机毕竟是我屋牙!晓得不?不要发哈达..其实好多事我都还冒揭穿你,算达..不广你达.人要有自知之明晓得不?你太自信达...有时候真该捞镜子照哈...算!不广了!广达你还是哪样子..等哈又和老子来吵..最好不要吧老子惹毛达!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('227', '2000', '其实我真的过的一点都不快乐,被哪个所谓的老公搞得好烦,我知道我其实不喜欢他,只是有点依赖.因为一直想忘记她,所以照她来当替代品,可是我总觉得没有人可以代替,老是觉得她是最好的..哎..真的是有苦说不出...不说了..真的是有苦难言啊..!不会有人知道我是怎么过的!哎!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('228', '2000', '还有十几天就去太原了!可是一我现在的成绩还不能保险及格!必须好好练了!明天还要跑800,一定要努力,争取跑到2分30秒以内!这样考试时才有可能跑出好成绩!这次去太原少说也得几百元钱!要是考不上,那可怎么好!好好加油吧!明天还得早起跑步!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('229', '2000', '刚刚贺红给了我一张照片!挺好看的!他可真是不幸!早早的就失去了父亲!好可怜!好久没和她聊了!等以后有时间吧!王红敏,可以说是个非常好的朋友!这些天上网都靠他了!真觉得有点对不住他!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('242', '2000', '(2005-03-3119:06:57)30146245怎么这么说咯？好久没听到你叫小牙了哦``呵呵`直今为止哦，你可是第一个这么叫的，也是唯一一个这么叫的啦。怎么样，对你特殊吧？嘿嘿``没什么的啦。我讲拉，只要你过的好就好了拉。有什么烦的事给我讲咯`````好高兴他这么说,哈哈..我觉得这样叫他好亲切.我也很喜欢这样叫他,不喜欢让别人这样叫..哈哈...笑笑!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('243', '2000', '我晕了,这么久没看到他,今天被我碰上了,只是还没说什么,就被熊猫把他t了..好生气,特别是他说话,想晕!现在混得好了!我说话还敢还口了!气si我了!还装哈!我无语了..想起就有气!.啊!!!!我受不了了!还什么放生我!?我晕!广我..真的要崩溃了,不要脸!还敢出来吓人!丑得要si!jie伦绣.!我操你祖中!....现在飞得起了.!口又多,骗劳资!还说没有在外面乱说话,都是些没用的东西,害我!在外面乱说!把劳资名声都搞坏了,从来没看到过这么不要脸的人,..受不了,天天si人不知道到他在哪躲起来了!还有什么黑龙!我操,骂劳资!害说没骂,还加劳资做si啊!都是些不要脸的人!哎....好生气啊!气si我了!啊!!!!!!!!!!!!!烦!!!!!!!!!!!!!看到就想打!si呕男...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('244', '2000', '哎...郁闷...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('245', '2000', '不知道为什么没有他消息我很失落,我没有自己的方向,,为什么他要那样对我,为什么,我恨他,喜欢他那么久,除伤痛之外,他什么都没有给我,就这样我还是执迷不悟,依然恋着他,不,我要去找他,我一定会征服他的,我相信我自己,因为我不能没有他.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('246', '2000', '哈哈,真的没想到她看到我哪个日记本噢!今天看到她加我。真的好高兴,其实都没有抱很大希望,以为她要很久才会发现,谁知这么快,来上网,看有人加,以为又是些无聊的讨厌鬼,正来关,但好奇心使我看了看资料,哇!哪一刻,真的好高兴,没有想到这样也行,好久就看了她日记,都在想,有她qq就好了,和她说话一定很有意思吧.我就在想怎么才能找到她,嘿嘿...自己傻笑的高兴了好久,怎么都觉得有点怪异,也许是以为高兴过头的原因吧.嘿*.无声崩溃,对不起哦,看了你的日记,还作了哪么个日记本,嘿嘿...你应该不会生气噢.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('247', '2000', '百般无聊的我..忽忽..真的很无聊噢,每天都是过着同样的日子,哎~~乏味啊.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('248', '2000', '我好失落,我该怎么办?我好迷茫,我在的我对不起他,可我能怎么样呢?我是不能喜欢上他的，因为有他的存在,我不能忘了他,我对不起王伟,他是一个好男生,是我没有福气,我配不上他,他应该找到比我更好的人.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('249', '2000', '吗的！真的好烦,病了..有点严重.很不舒服,感觉就像是腾云驾雾一样的,头痛.哎呀...什么地方都痛..真的受不了..没有力气.也不想吃东西!全身无力啊...肚子在抗议,但是胃在翻腾,真的很不好受,全身冒汗.腿发软.都不知道是怎么了,翻胃..好难受啊`!哎..本来明天就可以回家了,东西都收拾好了..可是...哎,算了,我晕,很不舒服,和我说这些我听不进的,操!最讨厌别人这样,口是心非的..味道!不晓得在做什么,解释个屁..烦操,真的很想打!何必拉,说的做的都是借口..很讨厌噢,本来就很不舒服,很烦了,现在说得我都要吐火了..脑袋好大了.我都不晓得要怎么样了.还说,气人!最好都不要理我!以为来上网心情会好点`哪晓得,我晕..人多就是烦..⒎嘴⒏舌的..操！不写了。还写个屁。。烦操！回家，睡觉`！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('250', '2000', '(2005-04-0822:11:51)沉伦假象老婆啊...怎么不次我啊.(2005-04-0822:16:05)&８绣、没(2005-04-0822:16:07)沉伦假象接视频啊.(2005-04-0822:18:22)&８绣、丑`(2005-04-0822:18:25)&８绣、病态丑1(2005-04-0822:16:30)沉伦假象我也要看啊..(2005-04-0822:18:45)&８绣、晕`(2005-04-0822:16:38)沉伦假象接吧.(2005-04-0822:17:05)沉伦假象看到了..(2005-04-0822:17:05)沉伦假象好漂亮啊.(2005-04-0822:17:07)沉伦假象不丑啊.(2005-04-0822:17:17)沉伦假象发现你变漂亮了.(2005-04-0822:19:40)&８绣、晕`!(2005-04-0822:17:38)沉伦假象喊情人加我.我把照片传给几.(2005-04-0822:20:09)&８绣、不会加的(2005-04-0822:18:12)沉伦假象晕死.几不的鸟也...(2005-04-0822:18:17)沉伦假象我发的你看.你不准的几看.!>.(2005-04-0822:21:04)&８绣、恩`(2005-04-0822:19:04)沉伦假象你吗连冒话和我广样.??????????????>(2005-04-0822:21:23)&８绣、没有!(2005-04-0822:19:22)沉伦假象你还在生气啊.(2005-04-0822:21:56)&８绣、冒`!还好`(2005-04-0822:20:05)沉伦假象那就好..(2005-04-0822:20:15)沉伦假象想我冒亲爱的.我好想你哒...5555(2005-04-0822:22:26)&８绣、嘿嘿..(2005-04-0822:20:28)沉伦假象,....!...(2005-04-0822:22:50)&８绣、你莫广!想si`!看达就有气`(2005-04-0822:20:58)沉伦假象不是撒.(2005-04-0822:24:25)&８绣、不是杂冒`!不晓得你在搞吗鬼`!看到你就想打`!本来我明天就回了`!还想给你杂惊喜`哪晓得,你就给我杂裹大的惊喜`!(2005-04-0822:23:13)沉伦假象.老婆明天几点到衡阳.我来接你啊.(2005-04-0822:25:33)&８绣、我不回了`(2005-04-0822:25:25)沉伦假象为什么.?(2005-04-0822:29:05)&８绣、没心情`(2005-04-0822:28:01)沉伦假象晕.你逗我.你票都冒买.(2005-04-0822:28:10)沉伦假象还广明天回来.(2005-04-0822:28:19)沉伦假象麻烦你买噶票在来和我广好久回.(2005-04-0822:28:30)沉伦假象你那么远肯定要提前买票的.(2005-04-0822:32:04)&８绣、不需要的!我林明天有车到`!我和滢本来明天回``(2005-04-0822:32:10)&８绣、现在不想回了!(2005-04-0822:30:25)沉伦假象别啊.老婆我很想你的.你回来好吗?(2005-04-0822:34:00)&８绣、不想回!给你把你那边的事搞定我再回`(2005-04-0822:32:24)沉伦假象什么啊?(2005-04-0822:36:38)&８绣、我广`!]给你帮你那边的事做好`!我才回家`(2005-04-0822:34:51)沉伦假象不要...我就是要你回来和我在一起.还而要几和我在一起.逼哒几....!!!(2005-04-0822:37:13)&８绣、不要`!(2005-04-0822:37:18)沉伦假象老婆你到底吗意思.?你和我在一起.回来都不愿意咯.?你吗意思啦.?(2005-04-0822:40:26)&８绣、冒吗意思`!(2005-04-0822:39:46)沉伦假象日哦...不晓得你吗意思.算算..晓得吧.你永远都摸回来哒....可以吧.~~~~(2005-04-0822:42:41)&８绣、我晕`!你事冒搞好`我回克垂si啊`!要我看达那杂吗洪啊`?!味道`!(2005-04-0822:43:41)沉伦假象日哦.几又不是不晓得你是我老婆.!日哒.几晓得我是逼几和我在一起.(2005-04-0822:46:53)&８绣、我不想`!我不认得还好`!我嬲`!你要我回克看达几吗办`?笑啊?~我心虚啊!(2005-04-0822:47:48)沉伦假象日哦...你有我就可以了啊..(2005-04-0822:50:33)&８绣、呵.,你广起捞枪⒋两啊`!最讨厌做裹吗事达`!(2005-04-0822:50:03)沉伦假象算算.算.(2005-04-0822:52:21)&８绣、恩(2005-04-0822:50:26)沉伦假象你摸回来哒.一世都摸回来哒(2005-04-0822:53:08)&８绣、不回就不回`!(2005-04-0822:52:18)沉伦假象可以撒.你现在搞的可以撒(2005-04-0822:55:10)&８绣、我冒吗裹搞得可以`!是你造成是`!你达要和几在一起`!(2005-04-0822:53:27)沉伦假象我早和你解释过了.(2005-04-0822:57:58)&８绣、.........广不喜欢别个,又不肯分.整几?借口`(2005-04-0822:56:23)沉伦假象你要这么说.我没办法..如果你觉得我喜欢几.你可以和我分手.(2005-04-0822:58:46)&８绣、是吧`!(2005-04-0822:57:06)沉伦假象我没办法在解释.解释再多.你也不明白..日.(2005-04-0823:00:20)&８绣、哈哈,就为答机`@和我分`!看得出几还蛮有魅力!看来我并不吗样!渺小`!(2005-04-0822:59:18)沉伦假象你吗比我还会想象啊.?我是广.你不相信我.你可以和我分手..我没办法啊。2个人在一起最主要的是相信...如果不相信..在一起还有什么意思.?(2005-04-0823:02:52)&８绣、哈哈,那我要你和几冒关系`你不肯`!你要我吗样相信你/味道吧你`!真的是,我看达我老公和别的每机在一起`冒放映啊?!(2005-04-0823:02:34)沉伦假象算了.我不解释了..几知道我和你在一起.几吗样想.几吗样想.?你是不是脑壳短路啊.我们一起气死几啊...(2005-04-0823:09:19)&８绣、我不会气几!我做不出裹吗事`!(2005-04-0823:08:49)沉伦假象那你就和我在一起就是撒.(2005-04-0823:12:00)&８绣、那几吗办`?!你告诉我/`!(2005-04-0823:10:24)沉伦假象挂哒.(2005-04-0823:13:50)&８绣、..........不想广话达`!不舒服`!停止`(2005-04-0823:12:50)沉伦假象你回来好不好.?(2005-04-0823:15:27)&⒏绣、不好`!现在真的很不想回!(2005-04-0823:14:20)沉伦假象既然你一点都不相信我那我们分手好了.你可以和其他人在一起那我也就不耽误你了.好吧.?这样你满意哒不..(2005-04-0823:17:06)&⒏绣、不耽误我?味道/`1(2005-04-0823:15:55)沉伦假象你不就这个意思.喊你回来你不回来.我不晓得你在那边搞吗鬼咯.(2005-04-0823:19:58)&⒏绣、我回来有吗用?!我在裹边搞吗鬼?`你以为我和你样吧?~我嬲!你自己克看`!你一共广达几杂分手好不好>?!我广达⒈句冒`?!想si!你吗里种不能理解自己有哪里做得太过分达`?!(2005-04-0823:19:10)沉伦假象哦.是吧?我就是这样的人.随便你...你如果不肯.那你就摸喜欢我哒.免得以后受伤害.(2005-04-0823:23:51)&⒏绣、可以还`!是你广裹`!一直都觉得好象是我老是拽达你不放样..你要找洪就找`!我不会住址你达`!我也晓得我冒那杂能力..别是哪个拉?在一起一年多拉`!吗舍得拉`是波?`(2005-04-0823:23:28)沉伦假象我没有这样觉得.麻烦你自己摸乱想好吧.(2005-04-0823:27:28)&⒏绣、我没有!你自己说的`!舍不得就算了啊`,现在我对几还冒裹`!不要给我回克达`看到你两个`!我真的会打`!所以如果你不愿意`就早点结束`!以免以后看到尴尬`(2005-04-0823:26:49)沉伦假象　　　对．！我不愿意．　我要做的事！必须做完　．没有做完．　我就不可能放弃的．．必须逼死几．整死几．(2005-04-0823:29:42)&⒏绣、是吧?整si几/`就对几那好吧?`哈哈```你整人还满以绝甲`?(2005-04-0823:29:38)沉伦假象　算.和你广吗东西.你都不晓得.摸广哒.满哒你有味.(2005-04-0823:33:32)&⒏绣、那是`!你不需要广`!你越广我就越气`!你还是流达力气克好好“整”你那杂前妻啊!莫回话了`!不舒服`!不想广话达`!头痛``!(2005-04-0823:32:47)沉伦假象你气我不气吧!味道.(2005-04-0823:46:31)沉伦假象(2005-04-0823:50:33)&⒏绣、操`!吗事`!现在莫和我广话`!等哈火来达真的会骂人`!(2005-04-0823:49:03)沉伦假象骂撒..对哒来撒.(2005-04-0823:52:12)&⒏绣、我想和你骂``!我现在哪个都不想理`!所以`你回避一哈!ok?`冒心情和你恰`(2005-04-0823:50:39)沉伦假象哦.是吧.?你到底吗意思啦.(2005-04-0823:53:18)&⒏绣、冒吗意思`!意思在于你好不!是你的错`1(2005-04-0823:51:55)沉伦假象是我错.又能怎么样??随便你好.我解释过了.你而要果样.我没办法....(2005-04-0823:57:08)沉伦假象　你在做社呢们(2005-04-0823:59:29)&⒏绣、很没办法,算达`!停止`!我烦`(2005-04-0823:59:46)&⒏绣綉、没做什么`!(2005-04-0823:57:51)沉伦假象.......哎.>...我都不知道怎么说了.(2005-04-0900:00:53)&⒏绣、恩`不需要说什么了`!朋友`!(2005-04-0823:59:06)沉伦假象　.我是你朋友?(2005-04-0900:01:50)&⒏绣、是的`!是你自己造成的`!``我没办法``(2005-04-0900:00:34)沉伦假象好!算了.我尊尊你的选者。(2005-04-0900:03:07)&⒏綉、哈哈!(2005-04-0900:01:16)沉淪假象笑什么.(2005-04-0900:03:50)&⒏綉、没什么`!想笑就笑`!(2005-04-0900:05:13)沉淪假象...哎.哎...我想把话说明白.(2005-04-0900:08:55)沉淪假象老婆(2005-04-0900:10:58)沉淪假象你出你出来.我和你说话.(2005-04-0900:17:21)&⒏綉、...........(2005-04-0900:18:11)沉淪假象我愿变成童话里你爱的那个天使张开双手变成翅膀守护你你要相信，相信我们会象童话故事里幸福和快乐是结局(2005-04-0900:20:26)沉淪假象怎么不说话.(2005-04-0900:22:52)&⒏綉、不想说`!不知道说什么``(2005-04-0900:21:09)沉淪假象你相信我好吗.?.(2005-04-0900:22:38)沉淪假象老婆,你别生气啊.你相信我好不好.?.还有很多。。。其实我真的不知道该怎么办,我知道是我在无理取闹,就是想和他分,这样,他也不会感到我在骗他,我知道我这样很不好,很不对.但是我不想以后还继续骗他,而且,对他我真的没有感觉了,现在他说了这么多,我心里有的只是不忍心,我感觉我对不起她..怎么办,我要不要“原谅”他?他老是在说,我不知道该怎么办,,好不容易说分手,现在又...哎...算了,等下次吧!因为这次不怎么严重....我觉得我好自私的,为了自己,这样对他...心里好愧疚...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('251', '2000', '\"哎..也许是我不懂得珍惜,不知道为什么,现在是很般翘,...⒈下这个,做我老婆好不?⒈下那个我喜欢你,等你好吗?竟然还有人说,\"\"你像我初恋情人\"\"\"\"你是不是受过伤?\"\"我晕!这些事我都麻木了,也可以说是习惯了,所以我会很无情的说\"\"没兴趣\"\"然后他们会说\"\"你很不给面子噢?\"\"我说\"\"呵呵..习惯\"\"他们说\"\"你习惯无情吗?\"\"我会回答\"\"呵呵..也许吧..对不起!真的没兴趣\"\"\"\"没有机会了吗?\"\"\"\"on\"\".....其实并不是我无情,而是我真的怕,我现在很不相信任何人,我很怕被骗,才使我现在拒绝别人那么自然,..我想过了,也许除了他,在我⒙岁之前我不会和任何人在一起了...虽然他和他不会再有什么,..也许在⒙岁之前会有个让我感到他的感觉,那肯定就是我一辈子的寄托...这段时间我知道我做了很多过分的事...利用,玩弄别人,甚至堕落自己...我真的变了..变得让我自己都无法接受,的确,我感到,以前那个单纯的我si了,没有办法回到从前,时间总是向前走的...没有办法回到从前,虽然我在等,但是我知道我等不到我要的那天,我找人代替他,想把思想转移到他身上,可是我没办法,我那样只是欺骗自己,也是在欺骗别人,..有的时候我仿佛突然清醒,我想我不该这样下去,我是在摧毁自己,...我会试着去改变自己回到以前的我,..那也许也是在挽救我自己..\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('252', '2000', '妈的，一不小心把写好的日记全给删了，心疼。哭死！不写了，操，狂郁闷，改天有心情了再写算了。郁闷死郁闷死啊！！！nnd。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('253', '2000', '买了王菲那盘CD,是她很多年前的专集了,我到现在才拥有,会不会晚了点呢.不管那么多了,能买到就很不错了呢,什么时候,什么地点买到的,都不重要了.把那上面的话都打了下来,相隔5年的时间,我看到这样的话,心依然被触动.封面上的faye很美,我喜欢她的嘴,很美丽的嘴.今天坐车从外公家回来时,想起了在涪高的生活,其实并不是那么的痛苦.离开的时候看到那个和谢感觉很像的男生,想到以后都看不到他了的时候,有点难过.想想自己算不算暗恋他呢,没说过一句话,只是习惯性的看他,甚至连他的名字也忘记了.这场感情,无疾而终.抱着一大堆书从教学楼出来的时候看到刘宁了,刘柠拍了拍我的头说走好,别忘了我啊.我说不会的.真的不会,毕竟他是我去那学校里的一个月中唯一的哥们.我们一起分着抽过一只烟,一起起哄.离开的时候,我脸上始终挂着微笑.今天回来的时候,妈妈送我等车时说回去了别忘了吃药,我说恩.妈妈说那药挺贵的,要天天都吃,记住了啊,早点治好病.我说我现在挺好的,倒是你需要吃了,要不我把那药给你吃算了.妈妈笑着过来打我,我轻轻的躲开了.其实妈妈很爱我的,我知道.妈妈说我现在越来越能侃了,我都把她给说晕了,我就哈哈大笑,说我自己多么多么能耐多么多么厉害,妈妈很没脾气的看着我.回到家和爸爸依然没有话说,继续沉默,这样挺好的.我玩电脑,爸爸在厨房里给我做饭.爸妈离婚后爸爸就开始担当起妈妈的角色为我做饭,想想他都一把年纪了,真的挺不容易的,我还老气他.那天我对爸说:爸,你找个人好好过日子吧,不用担心我.爸爸说,不是说找就能找到的.我沉默.心疼爸爸,可是我说不出口.艳前几天晚上逃课陪我玩,和我说了很多话.之前就有人告诉过我艳其实很关心我的,以前我一直都不知道,我以为她不会在乎朋友.艳很担心我会是同性恋,我说,到这世上来一趟,只和男的谈恋爱,而不和女的恋爱,真的是白活了.艳很无语,只说你别认真就好了.我说你放心吧.其实我这样的想法真他妈的不成熟啊,可是我找不到更好的借口了.我想珍珠了,那个安静得让我想起下雪天的女子.她曾说过她喜欢我,因为我总是一副很开心的样子,其实他们都不知道我.最近的心情还算平静,没有发病,没有哭,没有死掉的念头,觉得这样过其实挺好的.忽然不想打破这样宁静的生活,想一直一直的这样延续下去.为一件并不好笑的事情,笑得肚子都疼了.我希望一直一直的这样过下去.不管谁说我多么没良心.我真的可以好好的生活.小树打电话过来说她不想读书了,想回来陪我.我没话说,问她不读高中了干吗,她说她实在呆不下去了,我说你爸妈不会同意的,她说那也是.然后我说我要去上厕所了,挂电话吧,她说好.其实我是不知道要和她说些什么了.她告诉我她上个星期也给我打电话了,就是找不到我人,说我可真是个大忙人啊.我嬉皮笑脸的说那是,可惜她看不见我的表情,不然非要踢我几脚不可.发现其实我当了好几年他们心中的老大了,天不怕地不怕的,天塌下来有我顶的样子.可是他们都不知道,很多时候我也怕,只是我很虚伪,不愿意表现出来.今天戴耳环的时候,不小心把一年前就封了的耳洞给扎开了,疼得我直哆嗦,跑去找老妈给我吹吹,我老妈说她看着就恐怖,不敢给我吹,我说她真胆小,就自己在那使劲扇风.妈的,真是疼死我了.朋友都骂我神经病,总是穿了耳洞又让它长合,然后有去穿,就一个地方已经打了三次了.我嘿嘿的笑,说自己就是喜欢这样..真觉得自己挺变态的,妈呀.爸爸说,不管有多难,生活都要继续下去,知道么.我说知道.爸爸说再难我都会陪你一起度过的,千万不可以轻生,我就你一个孩子.我恩了一声.说你别指望我以后会报答你.爸爸说他不指望,只希望我能好好的过.我也希望我可以好好的过啊,可是真要做到,多难啊.很健忘,常常忘记某些人的名字,每当他们招呼我的时候,我都只能傻傻的笑,因为忘记他们叫什么了,甚至忘记是否见过.爸爸星期一的时候要出差一个星期,问我一个人在家可以么,我说当然了,我不是小孩子了.况且我喜欢一个人在家的感觉,想怎样就怎样,很自在.小姨说我从小就不喜欢和人亲近,芸芸和我很像.我看了看芸芸,比我小7岁的妹妹,我总觉得她很早熟,懂得很多,我很喜欢她,也一直都在保护她.我不喜欢大人们像对我那样对她,总是在争吵时把她拉进她们的话题里.我看着芸芸坐在沙发上一声不啃,一脸默然的样子很心疼,她这么小,这样的表情不适合她.我担心她有一天会不会变成我这个样子.我看到芸芸压抑的表情,脸上写满隐忍,这不是她这样大的孩子该有的.一直以来,她都是我最喜欢的一个妹妹.我给她买好看的饰品,可是却被她的妈妈,我的舅妈给扔掉了,我觉得可笑.我讨厌芸芸的妈妈,从来没有喜欢过.真的该对自己好一点,不要那么的残忍的对待自己,那样没什么好处的.狸猫问我圆圆真的出家了么?我说也许是吧,我也不知道.狸猫说不可思议.圆圆其实没有剪断一切,虽然剃了头,可圆圆的心未净.她和狸猫说她觉得她离我越来越远了,我不知道说什么.圆圆对我说:落,不要离开我好么?我说圆圆你要明白没有谁会永远陪着谁的,总有天我会离开.她问我要离开她了么?我说不,现在不会离开你的,放心吧.现在我会陪着你的,乖.我知道她需要我,但我却残忍的对她说我不会一直陪着她.我只想她能够清醒,毕竟我是个女孩子,不能给她永久的幸福,即使她再爱我,即使我再怎样的对她好.其实圆圆比我更不敢面对现实,一直不愿去面对一切,她想要我给她温暖与关怀,可惜她找错人了,因为我没那个能力给谁温暖的感觉,我只会一次又一次的让人对我失望.May打电话给我,告诉我她现在不好,烟也抽得很厉害.我说May,你真的变了,不是以前的你了,以前的你很单纯的,不会是这个样子.May说是,她也觉得自己变了.我说May,你要好好的过,好好的读书,别像我一样的,你学习比我好,应该以后会很不错的.May在那边苦笑.我知道她在重点中学压力很大.还记得寒假的时候May到我家来玩,看了我手上的疤很心疼的摸着,问我疼不疼?我说不疼.那个时候的May好可爱,像个孩子一样的乖巧.如果可以的话,我想去另一个城市,好好的生活.不再波澜,一直平静下去.一个简单的梦.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('254', '2000', '\"忽忽...今天晚上就回家了,先坐客车,到了贵阳再坐火车..来了快⒉个月了,突然就走了,真的有点不习惯,答应带礼物..买是买了,但是都不多,也没有什么满意的..哎,这边只是吃的东西多.更本没有什么好买的,真的有点犯难了啊...我回去先不想告诉朋友们,嘿嘿..给他们一个惊喜丫...还有就是,回去肯定会很狼狈,所以,我要买了衣服再和他们见面,嘻嘻...哎..我都不知道怎么办了,我回去不可能真的和熊猫在一起啊,都不知道改怎么办了...想到就怕..怎么办啊?我和他分手他不肯,我总不能像滢滢说的那样.直接说\"\"我不喜欢你,只是好玩.我们分手吧!\"\"哎...这样我做不出啊..好郁闷啊...没有时间了,他又好象以为我好喜欢他一样,哎..真的是没事找事做,现在最烦的就是回去怎么面对他,难道真要我天天对着自己不喜欢的人?\"\"日久生情\"\"?我想我是不会对他有什么了,真的,我们⒉个更本就不适合,只是他很会感动我,但是我就是不能接受了,在我心里,现在对他只有愧疚、怜惜与不忍...相反,现在我回去最先想到是他,我在想,回去看到他我该怎么办.改怎么找他...真的好想他了,我知道自己很自多,但是我没有办法克制自己,只有埋藏在心里,不让他透露出来,所以之前才会闹出熊猫的事,那时想,别人看我和别的人在一起了,就不会去想我还喜欢他了,可是现在我知道错了,这并不可以解决什么,反而让我更加的烦...很想回家好好睡一觉,什么事也不想,...哎..想到要回家,心里还真的很高兴啊!只是,莎莎好象以为我在这边做什么一样,哎..不要乱想啊,我没做什么啊.快崩溃了...\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('255', '2000', '这段时间真的是很烦,老是有种想哭的冲动.也不知道是为什么,也罢..其实我一直都是这样的,习惯..很不舒服,病似乎还是没有好转,看起来似乎比刚开始更加严重,全身都没有力气了,提点东西,它会从我手中掉下,蹲下⒊秒,起来时我会眼前一片漆黑..头好痛,妈的!最讨厌这种感觉了,真的好难受...很久没吃什么东西,吃不下..早上和滢滢吃了点东西,因为知道再不吃我会顶不住的了,好无力..全身完全没有支撑点..就让它东倒西歪吧...无所谓了,没有力气去想任何事,却有⒈大堆事等着我烦...我似乎感觉到我的无助...感觉自己整个人都已经完全虚脱了,很是难受....瞬间感到家好温暖,最起码现在病得不轻的我,有家人的照顾,呼寒问暖的,而现在,在外面只有自己照顾自己,其实我并不坚强的.只是有时候伪装在表面上的那一点点好强..在我内心里,我很无助..心里莫名的有种孤独感,陌生的城市,陌生的人,..一切好象都与我无关,我只是我,渺小的我..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('256', '2000', '我在逃避现实.我想改变它.让它来到我世界.完完全全属于我.大地在咆哮,寂寞要伪装.其实我只想要快乐.思绪太乱...整个人脱着疲倦身体,在挣扎.也不知道挣扎些什么.很好的选者。很好的机会.自己明白.但是看这错过.看这自己放错.乱...听着宁夏,心里有种说不出的平静.这是你唱给我听的,我在想你.因为这歌让我很舒服.这是熊猫的日记,他这样,我真的会觉得我的罪更大了,我真的好想逃,,我怎么办啊?好不容易抓住不准和她以前的老婆在一起的理由和他分(他和他那个老婆在一起是为了报复)因为那次和他说分就是这个理由,他不肯,说一定要整她,所以今天我又说和他分手,说他要和那个女的在一起在一起,就离开我,谁知..他答应了..我晕...我还能怎么办?就这么个小小的理由也没有了...哎...看来我真的要si他手里了啊!我就随便唱个宁夏给他听,他是把那个歌当成我...我晕噢..不过..想想..这就像我对我心里的那个他一样..哎....我也不想伤害他啊..但是.我都不晓得该怎么办了...他怎么就是不肯分手啊?这样我会越来越讨厌他的啊...虽然是我的错...哎..玩大了啊..怎么收场?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('257', '2000', '噢...我要崩溃了...怎么办?我在做什么啊?忽忽...好恐怖,...算了..就当一直是我的错好了`!不要理我...!对他,我说对不起..是我错了...算了吧`...一切停止,我明天就回家拉`!什么都过去了,回到家,就什么都没有了啊...回到原点..回家了`!哈哈``....真好噢`!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('258', '2000', '\"(2005-04-1022:25:57)沉淪假象老婆..你回来吧!(2005-04-1022:30:03)&⒏綉、不晓得``(2005-04-1022:26:37)沉淪假象烦不丫?我都广哒.切分手.不搞几哒.你还不回来是吧.(2005-04-1022:31:14)&⒏綉、不想回不可以啊/`(2005-04-1022:30:27)沉淪假象哦,是吧.~那我不分手哒.嬲..你吗时候回.你再吗时候喊我和几分手咯.味道.(2005-04-1022:35:39)&⒏綉、是吧`?我晓得了..我不回来,你好无聊是吧?总要找个人在边边陪达咯`!噢``懂了``原来噢....(2005-04-1022:32:20)沉淪假象日...你怕真的是个蠢婆东西吧.!>???????(2005-04-1022:36:32)&⒏綉、妈的`!你骂哪个`!(2005-04-1022:34:38)沉淪假象骂你...你不晓得好吧.?看不出好吧.\"\"/广你蠢就蠢...你老公而是喜欢在外面找妹子耍.找妹子嬲把3~连不晓得广话.(2005-04-1022:40:20)&⒏綉、可以`!哈哈`!其实我⒌天后就可以出现在你面前的,,我明天火车..我就是想看哈`你是吗人...呵呵....算`!我⒉个冒可能了`!(2005-04-1022:37:51)沉淪假象你误会我话的意思了.ok.?.......什么冒可能啦.我要和你在一起....(2005-04-1022:42:04)&⒏綉、on`!你太让人失望了`!(2005-04-1022:39:08)沉淪假象我广你误会我意思哒.还要我吗样广...?我意思是广,我不是那种.一定要妹子耍.一定要找妹子嬲的人.好吧~?(2005-04-1022:41:42)沉淪假象你几号回我接你.(2005-04-1022:41:59)沉淪假象我带好多人来迎接你回来.好不.!(2005-04-1022:46:01)&⒏綉、算达`!嫦对你裹好,你不珍惜,你也不会珍惜我的`!我不喜欢你可以达不?讨厌你`!你不要理我`..我会克嫦耍``!讨厌你```我不喜欢你```拜拜`!(2005-04-1022:45:13)沉淪假象广话.我死机哒(2005-04-1022:49:54)&⒏綉、(2005-04-1022:46:01)&⒏綉、算达`!嫦对你裹好,你不珍惜,你也不会珍惜我的`!我不喜欢你可以达不?讨厌你`!你不要理我`..我会克嫦耍``!讨厌你```我不喜欢你```拜拜`!(2005-04-1022:48:49)沉淪假象我不想失去你.但又不知道如何表达.我爱你明明在心里面回荡.(2005-04-1022:53:41)&⒏綉、我不喜欢你`!我在骗你,你不懂吗?你笨`!我门不可能`!(2005-04-1023:01:31)&⒏綉、对不起`!算我错了好不?`(2005-04-1022:59:27)沉淪假象是吧.?算了.随便你.你把话说的这么绝,(2005-04-1023:04:22)&⒏綉、是的```再见`!(2005-04-1023:02:56)沉淪假象沉默并不代表懦弱放手更不代表解脱(2005-04-1023:07:26)&⒏綉、我会的`!(2005-04-1023:05:37)沉淪假象你果不喜欢我哒.?(2005-04-1023:10:00)&⒏綉、是的`!你就对嫦好点吧`!真的`!他才适合你``(2005-04-1023:07:25)沉淪假象好咯。.我会对几好的.你回来,我们一起耍.我会做的给你看。!(2005-04-1023:11:49)&⒏綉、做给我看?!哈哈,,,你想报复我?`(2005-04-1023:09:10)沉淪假象.我抱负你??用的着吗?.我知道你喜欢我..你还要我和几在一起,可以啊.我会对几好..一起玩撒我会做的很好.(2005-04-1023:13:50)&⒏綉、呵呵...很好`!\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('259', '2000', '我真的不想活了,一下子闹出这么多事,真的好烦,没有人理解我..熊猫现在好恨我,真的没点想法了,我天..现在只想哭,,,好想他能理解我,但是他不可以,..反而还误会我,没想法了,啊!!!!!!!!!!!!!!!!!!11真的好想si啊!妈的,都是自己.做这么多有病的事...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('260', '2000', '做的唯一一件让自己心里好受点的事,她都不能理解...悲哀,无语....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('261', '2000', '还可以训练4天，怎么办呐？成绩还差那么多！怎么才能把成绩提上去呀？真伤脑筋！要加紧训练了！有什么方法可以很快的提高成绩吗？好累哦！怎么一到下午就腿软！到比赛那天可别这样啊！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('262', '2000', '今天跑去小姨家玩,我说我感冒了,小姨就拿了一堆药给我吃,郁闷,差点呛死我.老爸今天去出差了,家里变成我一个人的天下,呵呵,努力把家里弄到最乱的状态,然后最后一天再来好好的收拾.嘿嘿,我这想法挺变态来着.买了一大堆泡面回家,准备这段时间就和他们作战到底了,汗!妈的,天真累,不想加衣服,麻烦死了.在小姨家的时候,小姨对我说,你挺气你妈的.我说怎么了?小姨说是一个月前的事儿了,你妈说她气得都不想理你了,说你骂她什么的.我说我是骂她了,我说她神经病.小姨说有原因吧,我说有,我睡觉她扯我被子,说要我杀了她,叫我一到捅死她,我就骂她有病了,叫她要死自己死.小姨说,的确是你妈的不对,我想你也不会无缘无辜的骂你妈的.我说那是,我没事骂她干吗啊,我吃饱撑的.小姨说你多体谅下你妈吧,我说知道.走的时候小姨对我说,你有啥事儿就给我打电话吧.我说好.就走了.出来的时候外面又开始下雨了,不大,小雨.但是打在身上还是挺冷的,我缩了缩肩膀裹紧衣服往家跑.一进门,屋里好大一股烟味,可能是刚才抽烟时忘了开窗子的原因吧,烟味也太大了.最近心里放下好多事情,不再那么在乎了,似乎日子就好过了很多.我就知道,我总有一天会好的.昨天睡觉时做了好多的梦,梦见了好多的人.记得在有个梦里,我梦见自己发病了,然后就哭,不停的哭.梦里我看见自己的左手腕静脉处被割破了,血不停的往外涌,人也昏昏沉沉的,我以为这一切都是真的,自己就要死了.结果突然醒了,一看表,上午11点,于是继续倒下睡觉.下午被N个电话吵醒了N次,气得我只好起床给自己做饭吃,一个人边看电视边吃饭,挺无聊的.吃过后洗头洗脸出门.去老妈那里,看到妈妈正和一些人说房子的事儿,我知道她要买房子了,没多说话,就跑去找眉刀修眉毛,然后走人.出去的时候碰到曾莉了,穿了件天蓝色的低领毛衣,套了个外套.我看到她雪白的皮肤暴露在空气中就问她冷么?她说不冷.我一直觉得她是那种只要风度不要温度的家伙.我说我看着你就觉得冷得要死!很多人都和我说过不喜欢她,但一直觉得她对我的态度还不错,也许是因为他老公和我关系好的原因吧.曾莉曾和我说过鑫以前和她说过我,说我本来是很乖的孩子的,可惜家庭的关系,把我给毁了,挺可惜的.我当时就笑了,没想到她老公对我的评价这么高,不愧是好哥们.似乎我在我们学校那群男生里口碑一直不错,没听谁谁谁说过我什么.有次和彬一起逛街,在街上遇见起子了,起子和彬是一届的,但留了两级,本该读大一,现在却在读高2.起子看到我的时候喊了声念姐好,当时彬在旁边很惊讶的看着我说,他怎么喊你念姐啊?!他比你大好多唉!我当时很无语的笑笑,不知道该怎么解释.彬是那种很天真的女孩子,上了大学还跟一小孩似的.魏子在QQ上告诉我她现在没上学了,在工作了,我说在哪工作啊?她说说了你也不清楚,我就没问了,闭上嘴.魏子也只比我大两岁而已,现在就在工作了,我却在家里游手好闲的,觉得挺无奈的.我说魏子,等我去你那上学了,咱俩就住一起好不?她说好.然后我就笑.以前每年的暑假我和魏子都坐在家门口的楼梯上聊天,那似乎成了我们整个夏天的必修课一样.每天晚上9点我们各自从家里出来,在门口做到12点后才回家.有时候边聊天边你一支烟我一支烟的抽,没话题的时候一起轻声唱歌,然后一起笑.有时候我会靠在她身上,闭着眼睛休息,她就默默无语.我对魏子说,如果我是男孩子,我一定会喜欢你.魏子笑.我说魏子,其实我不喜欢游游,她太自以为是了.我说魏子,游游她不喜欢我,她挺讨厌我的,她觉得我太闹了.我说魏子,游游说我是多余的,她觉得你,彬和她你们三个在一起才是最好的,不应该有我.我说魏子,我真的多余的吗?我比游游先认识你和彬的,为什么要说我是多余的而她不是呢?魏子说她也不知道,我就不说话了.我知道魏子喜欢游游那样的女孩,魏子说她和游游在一起的时候很有安全感,而和我在一起就没有,因为我太疯了.我说魏子你和彬都忘了吧,我们小时候拜过把子的,说要做一辈子的好朋友,那个时候没有游游.魏子说她记得.我说,我很怀念我们小时候,总是吵吵闹闹的却很开心.我说魏子我们回不去了是吗?魏子说是.我去问彬我们是不是回不去了,彬也说我们回不去了.彬说念子你变了好多,很多时候我看着你,都会觉得很陌生,觉得你不再是小时候那个乖巧又单纯的孩子了,现在的你好复杂,我看不清你.我说彬,其实最了解我的人就是你了,每次我难过时第一个想到的人总是你.彬摸着我的脑袋说,念子,以后的不开心都告诉我好吗?我是你的朋友,我会帮你分担的.其实每次和彬说话我都会觉得很安心.彬说念子你要乖乖的知道吗,别老是惹你爸妈生气了,他们也很辛苦.我说我知道.只有彬和谢才会叫我念子,但是后来谢就不叫我念子了,而直接叫我的大名.现在就只有彬一个人会叫我念子了,每次听她怎么喊我的时候我都会觉得很亲切.这么多年了,彬和魏子都在我的身边.虽然以不如从前了,但是毕竟不管我们离多远,我们的心都还在一起.彬大我三岁,魏子大我两岁,我们是9年的朋友了.时候飞速,我们都长大了.彬对我说念子,好好的过.然后就去上大学了.身边的朋友不断的变化着,但她们始终都没有离开过我,我有时候想,这是不是就是所谓的朋友呢?其实我一直不懂朋友这个词真正的含义,所以我很少称身边的人为朋友,而只说他们是我的玩伴.记得我在很小的时候就开始称身边的人为玩伴了,那个时候就认定朋友是很难找到的.静也一走就没了消息,8年了,我一直都没忘了她.那个说话慢半拍,不会生气,喜欢哭的女孩子.不知道她现在生活得好不好,说话的速度有没有提高.很多人,我都不知道要以怎样的方式去记念他们.听别人最常说我的一句话就是神经病,似乎已经这么的被骂了几年了,其实我觉得自己挺正常,骂我是神经病的人才不正常.我一直都不喜欢记事.这几天以来一直在写一些自己的朋友和玩伴,写来写去竟不知道是为了什么,也许仅仅是一种对过去的怀念.忽然想起小学毕业的那年暑假,魏子回了老家,我和彬就天天坐在外面看月亮,然后遍些故事给对方听,一起数星星,看到流星时一起许愿.单纯的美好.这些都是现在不可能再实现的事情了,我们有了各自的交际圈子,我和魏子的混乱复杂,而彬的我却一无所知.想一定比我和魏子的要好很多.魏子的笑,彬的笑,我的笑,在过了这么多年后终于变得虚伪了.其实我知道我们三个都不快乐,不过在一起时却都在努力的逗对方开心,我们都把微笑练得很好,一般的人是看不出破绽的,只有我们自己知道.魏子,彬,我想回到过去.虽然我知道不可能了,但我一直在努力的找回我们的从前,真的.我不想放弃.我也很想念你们.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('263', '2000', '今天ｙｙ发消息说，她哥ｓｐ觉得我文气．．昏厥．ｙｙ竟然也附和着说她也这么觉得ｌ说她高１开学第１次见我，给她的印象是肯定不乖．．我到底是怎样呀？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('264', '2000', 'http://mp3.baidu.com/u?n=2&u=http://www.9818.com.cn/huangjunwu/drizzt/q6ecpz6knp6wojo0.mp3那天看见ｓｋｙ日记，偶然知道神威和梨子恋爱了．．我现在都能想象到自己当时惊鄂的表情．．我只知道丢丢离开神威和子萌在一起了．当初认为大家都只是玩玩而已．可从神威的情绪看情况似乎比想象的复杂．　　心姐也很幸福和烛泪寒应该会很幸福～　　　　　　　宝宝很痛苦．虽然我不知道事情详细的来龙去脉．但是宝宝可能知道自己男朋友在外面有女朋友却没有说破．身边的．．．．．．．哎．．不写下文了', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('265', '2000', '今天是姥爷的生日..大家又可以聚在一起了..哎..姐姐的男朋友还要来真讨厌.以前就知道他们有了男朋友.一个个的肯定特没良心总是没空.我也不好埋怨..毕竟人家男大当婚女大当嫁..由不得我喜不喜欢..今天想出去买鞋子了..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('266', '2000', '风间向l表白了昨天还找lt要来了l的手机号..风间着实向我们诠释了一把甜言蜜语的概念..什么他不花心拉都是那些mm追的他他从没追过mm最大的心愿是追到l......会永远让l幸福~但愿风间是认真的不是因为和junk赌气..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('267', '2000', '\"为什么找不到你了呢?不..是不敢..没有勇气再出现在你面前了为什么你都不和我说话了呢?发给你的短信不知道你收到没有?越来越感觉到自己的卑微与渺小..我不知道自己是执着还是傻..总是盼着你的小头像亮起来..却又不敢上前说话..怕惹人厌..为什么你不先和我说话呢?因为盼望着所以等待..因为等待所以心不在焉的挂qq...又弄了2个号删了所有的人只打算把你加上就觉得满满的了..也不清楚自己是什么样的感觉..只是很怀念以前的日子..你不知道我是谁的日子..自己都不清楚从什么时候开始就变了呢?高1上学期的时候我们聊天到夜里2;00多钟..那可是第一次那么晚睡..(那时你叫xx旋风)那时侯你说晚上不回宿舍.我偏要你回..你说被宿舍老师发现会死的..是不是?我还给你出了好多馊主意..叫你翻墙进去..骗老师说病了刚从医院输液回来..嘿嘿~!!你不耐烦了催我回去睡觉..也答应我再也不在外面过夜了..那晚我知道你常年在外地生活..吃了不少苦头..也不知道自己怎么莫名其妙就哭了..或许是自己太脆弱了听不得这些不公平的事或许是太过愤慨..总之,真的是哭了..还是那么几滴眼泪..自己都不知道从什么时候开始自己都不会像孩子那样痛快的哇哇的哭了..只会啪嗒啪嗒的掉眼泪..这种滋味不好受..我还英雄似的说以后不会让任何人欺负你~我比你大2个月..总是欺负你.让你叫姐姐..叫你弟弟..你好象很不高兴我这么叫..总是叫我臭丫头..坏丫头..(不知道什么时候起你名字变成了儇.这个儇字我不认识但又不肯服输就去查字典,可是查不到你告诉我这是一个人名字里的一个字念xuan..我坏笑..以为是你喜欢的人)那时我总说你自恋..你也确实是..自认为帅..呵呵~很不谦虚~..我就教育你做人要低调些..你不懂问我低调什么意思..我叫你回去查字典..你到是很乖..下次的时候告诉我没查到..呵呵~快期末考试时我听yy说sp在学校门口被截了..你们在一起的..我看到你在线上就问你这事..你还一个劲的和我说谢谢..弄的我心里很不是滋味..还是放心不下sp就让爸爸开车带我去学校看看..记得放寒假你回家了..那时你的朋友还在上课.你很无聊.你爸爸要把你送到哥哥家去学习..那天我们下五子棋真的很开心..我本来是个臭棋篓..你却明白的告诉我是让着我的呵呵你是出了师傅(chi)以外下棋让我的人..你走时我有些失落向你抱怨以后又少了一个人陪我..你说也许还有机会上的..你很久没上..确实无聊了一阵子后来狗狗(bb现在的男朋友)来了..后来看见你你却没有主动和我说话..那时侯心情很烦躁..就在qq签名里写了\"\"好累,下辈子见吧~\"\"你莫名其妙的说了句\"\"好,下辈子见\"\"搞的我一头雾水不知道你在说什么后来才看到..回了句\"\"谁要和你下辈子见呀\"\"之后你就下了不见了..直到开学才又看见你上qq.网名变成了xx逆风.那阵子心情不好..删掉很多人..其中有你..后来我找不到你了..那几天急的都快哭了..后来费了很大的力气才从mmch那里弄来..弄来之后便每天心满意足的挂着qq不知道自己究竟在等什么..后来一天心情不好..你没说什么可你签名里的话变成了(开心点~~~~)虽然我不知道是不是写给我的.但是很安慰..你很瘦..也很懒..或者是因为你的性格..不愿意一个人去吃饭..所以常常饿肚子..别再饿着了..一个人在外地应该学会好好照顾自己呀~寒假心情不好的时候真的很谢谢你在身边..:)你的脚扭伤了..还去打球赛..好几次本来好了..又去看起来又严重了..可我什么也做不了..我觉得我们还并不熟..不好意思去问..一次下了很大决心去问你..你被同学搀扶着..走的很艰难..\"\"你怎么了\"\"\"\"崴脚了,没事.\"\"很简短的几句话..我不知道自己鼓了多大的勇气..好佩服自己..我很怕和男生讲话的..后来学校赛6x400米.有你参加..我看你接过接力棒我就转身离开了..不知道你注意到没有..好怕见到你..隐约觉得见了面后.你不大爱和我说话了.所以不敢面对...我当时莫名其妙的好想哭,爬到学校的顶楼听着mp3在窗口吹风...只有每天做操时看到你的侧影..也许只有这么多了..我不知道自己还能做什么..或许自己什么也做不来..很想帮你．．．记得我和你说过吗？很想帮一个人却什么都做不了．那种挫败感．．第一次让我觉得自己那么无能．．自己办不到的事好多好多．．听着这首童话眼角湿了..希望你是天使~永远快乐幸福的天使~http://mp3.baidu.com/u?n=2&u=http://www.afachina.com/images/paghm52rmdg>http://http://mp3.baidu.com/u?n=2&u=http://www.afachina.com/images/paghm52rmdg$.mp3一种没来由的怪异感觉．．仅仅是很想帮助你．．也许每个人心中都会有一个记挂的，很想帮助的人吧．或许是我天生爱多管闲事．\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('268', '2000', '也许习惯孤单是自讨苦吃的认命,也许逞强是矜持过头的表现....不知道为什么活.不知道该怎么活,什么都无法去捉摸.我试着追求自己想要的生活,可终究还是过的顺其自然.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('269', '2000', 'Marlboro00:04:29你肯释放，宣泄自己的真实感情。应该是一件特别骄傲的事。也许，没有年龄，地界的界限，我肯定特别喜欢念念。现在又乖这么多，超可爱。。我挺为你骄傲的。呵呵，念念可算特殊了。落.娃娃00:05:33也许没有年龄没有距离你就会喜欢我么`落.娃娃00:06:05等我长大了我就会成熟我会是个真正的女人了我就去你那里落.娃娃00:06:32你老了又变胖了我也不在乎!落.娃娃00:06:50反正我记住你这话了~我会努力的可是，你已有女朋友了那个时候你也该和她结婚了有了自己的家庭你说.我还能插足么我还能如此自私么我只想和你在一起一次即使没有结局我都愿意为什么这么小的愿望你都不能满足我我只感到了无望.爱上你我很疲惫', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('270', '2000', '今天原本打算一个人逛街的..爸爸放心不下,就叫bb陪我出来.爸爸开车把我们送到街上..过了一会bb的男朋友白来找她..本来就很烦躁.bb的电话又响个不停..真应该祝福她的有个那么体贴那么会粘人的bf..真的有些恼火..又不能怎么样..因为身边的人bb不是其他人..过了一会白来了..白的样子真的很乖.上来就叫我姐姐..我心不在焉的笑笑..他们走在后面..我在前面..bb把大包小包的东西都丢给了白..一副幸福的样子...我显得那么多余...白真的好听话bb一个假装发怒的表情就能把他吓的安静好一会..呵呵....bb现在在那边有白照顾着应该会不错的....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('271', '2000', '这样的夜..你还好不好..吃饭了吗?是不是还饿着肚子呢?好想对自己说,没我事..这不关我的事..自己不是很爱这么说吗?也总是能说的恰倒好处..给他们有力的一击..对你..我做不来..做不来把自己推脱的干干净净..自己也说不清．我是个满自私的人．掐指算算让我记挂的人还真没有几个．．就是因为你的遭遇．．和故事吗？呵呵..瘦高的样子..干净面容..看起来有些单薄..总是穿着一双带着白道道的红色的鞋子..大大的和身体不大成比例..不过跑起步来很可爱..像多拉a梦..笨笨的样子..喜欢倒吹气..没剪头发时还可以吹起来几根哈哈~总是不服输的样子..喜欢逞强..走起路来身子总是向前倾着..一步可以迈的好远..晃晃的.和偶尔调皮的表情不怎么相符..像个大孩子..眼睛近视很严重却不爱带眼镜..很爱很爱妈妈..把她当做女神一样..不会照顾自己..那么多年也不知道怎么过下来的..怪不得那么瘦...也许这些只能算做回忆了吧?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('272', '2000', 'lovingyou歌手:shanicesweetheartineverhavetoldyouhowmuchiloveyouhowmuchicarelovingyousobeautifullovingyouit\'seasy\'causeyou\'rebeautifulandlovingyouit\'salliwannadolovingyouit\'smorethanjustadreamcometrueandeverythingthatidoit\'soutoflovingyoulalalalalalalalalalalalalalalalalaladodododooohaahnooneelsecanmakemefeelthecolorsthatyoubringstaywithmewhilewegrowoldandwewillliveeachdayinspringtimelovingyouhasmademylifesobeautifulandeverydayofmylifeit\'sfilledwithlovingyoulovingyouiseeyoursoulcomeshiningthroughandeverythingthatwei\'msoinlovewithyoulalalalalalalalalalalalalalalalalaladodododooohaahnooneelsecanmakemefeelthecolorsthatyoubringstaywithmewhilewegrowoldandwewillliveeachdayinspringtimelovingyouit\'seasy\'causeyou\'rebeautifuleverydayofmylifeit\'sfilledwithlovingyoulovingyouiseeyoursoulcomeshiningthroughandeverythingthatwei\'msoinlovewithyoulalalalalalalalalalalalalalalalalaladodododooohaah', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('273', '2000', '主题：《花店》.写給轩和老大(sammy).满辛苦的.感觉就是乱七八糟的.begin>>醒来的时候，我躺在一张诺大的床上。阳光透过玻璃窗射进我的眼睛里，晃得我两眼生疼。我立刻把头转向一边。然后我看见了一个很奇怪的情景。一个男人，弯着腰对着餐桌，鼻尖几乎都要触碰到桌面上那层油光。他一动也不动地那么保持着，甚至连眼睛都不眨一下。看了几分钟，我突然开口问他:“你在干吗？”话一出口，连自己也吓了一跳。沉默的空气似乎被我沙哑的声音划出一道重重的伤痕。他回过头来看着我。是个中年男人。很高。脑袋融入在金色的阳光里。看不清楚面貌，但是身材很倾长。瘦。他说，我在找你的名字。“我的名字？”“是的。”“那么你找到没有？”“没有。”“这是哪里？”“你家。”“那你是谁？”“你可以叫我父亲。”“父亲？”“是的。”我晃了晃脑袋。很奇怪我居然想不起来我的父亲是什么样子。何时何地曾经与他在一起。于是我抬起头再问：“我叫什么名字？”“我还没找到。”“什么时候才能找到？”“不知道。”“那随便取一个吧。”男人转头看了看窗外的阳光。房子里一片寂静。连时钟的指针走动的声音都没有。我仰着脖子看着他。顿了几分钟，他回过头来，说，那就叫无声吧。1>>我其实是很不喜欢这所学校的。环境差是其次，主要是老师太麻烦。上课时上个厕所都要碰运气。如果正好那位老师心情好的话，拉上个一节两节课绝对没问题。但要是哪位老师心情不好，那就只能憋着了。拉在裤档里都没人理你。在我忍受了几次憋大便的痛苦之后，觉得实在没有和老师打报告的必要了。于是以后每次上课时要上厕所就直接打开后门走出去。如此反复几次，老师不干了。他们说，无声你是个学生，是学生就得服从老师的安排。我当时就觉得很气愤了。难不成还让我写张假条給他们过目然后等他们琢磨一阵批准了再去厕所？这样的话我还不让給憋死？如果所有老师对于上厕所的问题都处理得很恰当且及时的话，我想我也没有必要从后门走出去了。其实我最喜欢上的课是自习。没有老师的那种。有老师也成，只要不干涉我做什么。睡觉，听歌，看书，写字，打手机游戏，都行。而且收获往往比老师上课要多。这个学校属于职业高中。一星期五天课，三天半文化一天半专业。一天八节课时。我选修的专业是美术，全校修美术的占了四分之三。学校不大，人也不多。但似乎专业成绩不错。不过周围没多少人是认真画画的。比如我前面那个女生就很痛苦。她喜欢拉小提琴，但是她父母觉得会拉小提琴比较难考大学，所以就让她学美术。可怜她实在对美术没有兴趣。学了一年还是老样子，跟小学生水平似的。谈起小提琴她就两眼放光，只是过了几秒钟又迅速暗淡下去。很多人不是为梦想而活。梦想对于他们来说只是吃饱饭之余消遣自己的一个玩笑。但是有梦可以做实在是件很好的事情。如果连梦都做不出来，那实在是很可悲了。我觉得周围人都生活得比较盲目。虽然我也不明白自己究竟想要什么。但是我活得比他们都纯粹。至少我不喜欢的事情我可以不做。也没有人逼我。我可以连续画三天画不休息，也可以连续睡三天不画画。没有人管我。所以有时候我觉得，有人管也是一种幸福。班上有个女生身高一米八二。绰号一米八。我实在不明白她是怎么长的。我曾经虚心讨教过一回，结果她就说了三个字:“吃化肥。”然后对我说:“无声，你要是能比我高十公分我就嫁給你了。”我愣了一下，然后觉得我绝对不能长得比她高，至少不能高1十公分。上次体检，我记得我的报告表上身高填写的是一七六公分。照一米八的说法来看:太矮了。所以我在她面前一直很自卑。在我们班十四个男生里，我其实不算矮了。但是在她面前，我只能低头。2>>回家的时候父亲不在家。我不知道他在哪工作——实际上，我对他的情况简直一无所知。连“父亲”这个称谓都是他让加的。我曾经问过他我为什么不记得以前的事情。他只是摇头。他说，也许你遭遇车祸之类撞坏脑子失去记忆了。无声，其实每个人到这个世界上来都只是转一圈，然后再走。什么都不能带。也没必要带上什么。于是我觉得，我其实根本没有必要来到这个世界。家里有一间房间始终是空的。父亲从来不让我进去。有一次我偷偷爬到门上从门缝里往里看，发现里面布置得很像女孩子的房间。后来我问父亲，那间房间是做什么的。他说。給人住的。我问給谁？他说不久你就知道了。我问过父亲我的生日，他说我今年17岁。上星是双子。我暗中找我们班的八褂小天后分析过上星双子的人的性格特征。结果她就抛出四个字：“玩世不恭。”我琢磨了半天然后想，其实我还是很听话的。回到正题，回家的时候父亲不在家，正好我肚子饿了，于是就去厨房找吃的。其实厨房向来是空的，一日三餐大多数都是叫外卖，不然就从超级市场买来泡面之类的方便食品即开即食。我根本没抱希望，只是按照平常人的惯例行事，饿了，就先去厨房看看。虽然明明知道什么都没有。但是很奇怪，今天的厨房居然有食物，而且是一份看起来还不错的食物——一碗蛋炒饭。放在微波炉旁边。还在冒热气。我上前去闻了闻。觉得没有什么异样，唯一的想法就是，太香了。于是我拿起筷子就准备吃饭。接着听见一个女声在身后吒然响起：“不许吃！”我放下筷子回过头，看见一——用一米八的话来说就是——侏儒——在瞪着我。还是个女生。戴着副可笑的大眼镜，一头乱七八糟的头发。瘦得毫无身材可言。顶多就一米五的样子。我于是很奇怪地问她：“为什么不能吃阿？”“这是留給爸爸吃的。”“爸爸？”“是阿。就是那个高高的，瘦瘦的。”“哦。他也是我爸爸。所以我也可以吃。”“……真的？”“当然是真的，我骗你做什么！”“……那还是不许。”“为什么？”“因为爸爸没说同意。”“靠，你真听话。你哪来的。”“不知道。”“你怎么叫他做爸爸。”“因为你叫他做爸爸。”“我叫他爸爸关你什么事？”“我也不知道。”“……有病。”女孩张口还准备说话，正好门开了，我俩同时往门口望去，果然，父亲回家了。他脱完鞋，抬起头看见我俩傻站在厨房门口，便问道：“无声，你和轩说过话了？”我奇怪地问：“谁？”“轩。”父亲说着走进厨房，拉着那女孩的手笑着对我说：“无声，这是你妹妹，名字叫姜晓轩。”我当时就觉得为什么她的名字比我的听起来更像名字一些。但是我脱口而出的是：“靠我才不要她做妹妹。她太丑了。”轩的脸色马上沉下来了。但是她似乎很懂事，什么都没说。只是一直低着头站在父亲的旁边。不停得搓着跟抹布似的衣角。父亲笑笑，说，她还小。慢慢就长大了。你以后要带着她。然后那间一直被我视为秘密的房间就让这个女孩子占据了。3>>那个时候其实我已经有了心仪的女生。这个年龄喜欢女孩子是一件跟正常的事情。我喜欢的女孩叫做sammy。是高我一级的学姐。长得很可爱，像个洋娃娃。八褂小天后曾经说过，她最喜欢去的地方便是麦当劳，于是我每天放学都去m记里转几圈，可惜运气不佳。连续转了一个月都没有遇见她。直到我把那里边的服务生全部侃熟了也没看见个人影。也许时候不对，我暗自想。但是自从轩来了之后，这个计划就被彻底打乱了。首先我根本没有多余的钱每天负担两杯奶昔，其次带个这么丑的女孩子在身边实在有损形象，万一不幸，哦是走运，遇见了sammy，那岂不是脸丢大了。但是轩是怎么都甩不脱的，她会十年如一日地在我们教室门口等我，然后拉住我的衣下摆一直跟着我回到家。有一次班上一兄弟问我这是谁，我就说是邻居家的小孩。我实在没有足够的勇气告诉别人这是我的，呃，妹妹。唯一的一次，我在校园的车棚里和sammy擦肩而过。我闻到她身上淡淡的清香。回过神来她已经推着她那俩粉红色的自行车走远。我正看着她的背影出神，轩却在旁大笑打破：哥哥，你口水都快掉在衣服上了！我收回目光转而瞪她，她一脸无辜。我只好推着山地车带她一同走出车棚。那天晚饭后轩不知从哪里摘来一把花。紫色的，还带着点香。可惜我对花过敏，从她拿进房间开始我就不停地打喷嚏。最后不得不让她把那束花扔出去。扔完了后她很难过地坐在我面前说，哥哥，真可惜。我很喜欢花的。那时候我和轩已经相处了三个月。我渐渐开始觉得她不错，虽然样子丑了点，但是还是很体贴的。比如她知道我每天早晨起床后习惯先穿袜子所以每晚我睡觉之后她会帮我把干净的袜子放在枕边；比如她知道我讨厌喝牛奶每天早晨会很自觉地去鲜奶屋帮我把牛奶兑换成豆奶；比如她很聪明知道做饭菜功课也写得一丝不苟；比如她明白我不吃辣的所以即使父亲喜欢吃辣的她做菜也不放辣，特别是我喜欢吃的菜。所以我没有理由不好好待她。虽然她长得丑了点。但这似乎不算理由。毕竟她叫我哥哥。然后我渐渐习惯了到哪里都带上她。她笑着跟我说，哥哥，我就是你小尾巴。4>>父亲給我说，无声，待人处事一定要认真对待。无论是对待陌生人，还是身边最亲近的人。自己做的事情，自己要负责。然后我很不耐烦地把饭碗一推说得了，不就是让我饭后洗碗吗。我明白了。父亲点点头，你明白就好。于是我只好抱着一堆碗筷到厨房。这个时候轩一般是站在我旁边的，但是父亲对她说，不许帮哥哥洗碗。轩往往很听话地点点头。虽然头是点了，但是她还是会很认真地帮我洗完。所以说，有个妹妹其实是件不错的事情。有一次我去她房间拿东西的时候不小心看见她正朝着空白的一页日记本发呆。于是又一次她帮我洗完碗之后我问她：“轩。问你个问题。”“嗯。好。哥哥你问吧。”“有没有喜欢的男生？”轩的脸随即红得不正常了。我暗笑，这丫头八成是心上人了。可是她说：“哥哥无聊，轩不和你说这个。”“那好。不说就不说。我也没兴趣知道。”轩不说话了。一张脸红得跟深秋的苹果似的——快烂掉了。其实那时候我已经成功地和sammy交上了朋友。就因为有一次在m记我和她互相拿错了套餐。兑换的时候我发现她一个人，于是就故作随意地坐在她旁边，然后故作随意地和她聊了两句。结果就很故意地成为了朋友。那天正好轩肚子痛在家休息。后来我发现sammy很喜欢穿裙子，无论是在冬天还是夏天。裙子似乎是她一成不变的风格。长的，短的，棉布的，牛仔的，各种各样。我曾经问过她为什么这么喜欢穿裙子，她对我莞尔一笑，说，因为我的腿漂亮阿。那天我憋了很久，硬是没敢看她的腿。sammy的生日在5月，在我生日之后的第三天。我存了一些钱买了一条价钱比较贵的裙子給她，颜色依旧是她喜欢的粉红。那天sammy很高兴，抱着那条裙子不放，去专卖店的试衣间换上后在全身镜前左看右看不肯走，最后在我左边脸上亲了一下。我发了一分钟呆之后顺理成章地拉住了她的手。那晚喝了一点酒。有一点醉意。于是就带sammy回家了。父亲的眼神有一些奇怪。不过我没多想。我让sammy坐下休息，然后叫一旁低头做作业的轩給sammy倒茶。轩嗯了一声就端了个杯子过来，走到sammy面前不知为什么她的手抖了一下，接着sammy那条粉红色的裙子上出现了一大块褐色的茶渍。sammy的脸一下子白了。我愣了一下，然后顺手打翻了轩手上的那半杯茶。sammy站起来说，我要回家。我拉着她出了门。我似乎听见轩在身后哭了出来。但我没有理她，直接走了出去。sammy一路上没有说话。我也不知道说什么才好。在车站告别时她踮起脚来想亲我，我不知为什么闪开了。她眼睛里的失望闪了一下，然后公车来了。5>>回到家后父亲做在沙发上神色凝重。我环顾四周，问他：“轩呢？”“走了。”我大惊失色，忙问：“去哪了？”“不知道。”“你怎么不知道？”“我怎么知道？她自己走的。”“她为什么要走？”“问你。”“我怎么了？”“她说，你不需要她了。所以她走了。”“我没说。”“可你这么想了。”“我没有。我没这么想。”“也许你没这么想。可是你这么做給她看了。”“我做什么了？”“你怎么什么都不明白。无声。你太后知后觉。是不是有些东西，你非要得失去了才知道珍惜。”“我不明白你在说什么。”“你会明白的。”说完这句话，父亲便进房间休息了。我听见很轻的一声“喀嚓”。于是我知道他把门反锁了。他真的什么都不想和我说了。我很沮丧地走回自己房间，我看见轩的作业本还摊在我的书桌上，我曾经跟她说了好多次让她回自己房间写作业，她却偏说在我书桌上做作业脑子转得比较灵活。顺便还能把我的作业一同解决了，虽然她比我小两个年级。我躺在床上想明天去学校应该能看见她。到时候应该和她说什么好，是不是要买一份她爱吃的麦辣鸡腿堡給她。以前我嫌贵老是不愿意买給她吃。只愿意給她一份薯条说是帮她健康发育。难怪她半年来也没长胖，还是那个样子。如果当初多給她吃几份麦辣鸡腿堡也许她能长胖点或许还能再高点……后来我睡着了。6>>第二天放学我没有等sammy。直接去轩的教室找轩，但是没看见。正好遇见她的班主任。我忙问她轩去哪了。她说你是姜晓轩的哥哥吧？你难道不知道她生病了？她说要好好休养，先请半年假。我立刻像被浇了一盆冷水似地从头冷到脚。半年？！半年……然后我立刻回过神来，意思是半年后她还会回来？还好。不知为什么，自从轩走后我便不再想见sammy。即使她每天都会穿着我送她的那条裙子来教室找我，班上其余兄弟全在一旁恨得牙痒痒巴不得我下楼梯失足摔死。我全当做没看见。长这么大我第一次明白什么叫做，“失落”。于是又回到从前的日子。没有好饭菜，没有人帮我换豆奶，没有人帮我洗袜子也没有人会替我写作业让我抱个篮球出去玩到天黑，甚至没有了sammy。但最重要的是，没有人再跟着我，用无辜的眼神看着我，叫我哥哥。每当回家，看见那张再度紧闭的房门。难过的感觉便无声蔓延。我不知我当初为什么要打翻她手里那一杯茶。这个问题困扰了我很久。直到我终于毕业。距离轩离开的日子，正好是半年。我想，她也许明天就回来了。也许明天我回家，就能看见她坐在饭桌前等我。7>>毕业典礼那天我看见sammy挽着一个男生的手臂从我的面前走过去，那个男生好象是我们学校篮球队队长。成天装做一副叼样，其实我是看他不爽的。但是那一刻我居然什么感觉都没有，我想的仅仅是，回家能不能吃到轩做的土豆条。毕业典礼结束后我去车棚拿山地车，我看见sammy一个人站在车棚里像是在等人。我明白她等的是篮球队队长所以我沉默地从她身边走了过去。然后开锁，推起山地车准备走。但是她在身后叫住了我，她说：“无声，你站住。”我就站住了。回头望着她。我说：“干吗。”“我想告诉你一些事情。”“好。”“你知道我第一次注意你是什么时候？”“那一次在麦当劳拿错套餐吧。”“错了。”“那是？”“有一次在球场上看见你投三分。动作漂亮得让我到如今还印象深刻。”“我忘了。”“我知道你忘了。从那一次起我就记住你了。无声。”“你那时怎么知道我名字的？”“你们班是不是有个女生被叫做八卦小天后。”“是的。”“她是我表妹。”“……”“所以说，我喜欢了你一年。”“……”“你不知道。”“那又如何。你现在和那位篮球队长不是关系不错么。”“没错。我和他关系很好。”“那就行了。我得回家了。拜拜。”然后我转身跨上山地车。踏得飞快。我听见sammy的声音在身后被拉得越来越远。她在说：“无声，你这个白痴。你看看我穿的是什么！”然后我突然想起，她穿的好象就是半年前我送給她的那条裙子。我不知道如果当时我抱她一下，结局会如何。不过也没什么好想的。有些事情，过完了的确就再也回不去。8>>轩长高了。难以置信半年内她几乎完全变了一个人。摘掉了眼镜，头发也顺直了，搭在肩膀上。也不再那么瘦。她依旧坐在桌前笑着看着我，说，哥哥，吃饭了。和预料的一样，轩回家了。我看了看餐桌上，果然有土豆条。我说：“轩。你长高了。有一米六了吧？”“什么呀，哥哥。都一米六几了呢。你也长高了哦！有一米八了吧？”“靠。一米八几了都！”“呵呵。哥哥饿了吧？坐下吃饭呀。”于是我坐下，问她：“这半年你去哪了？”“哪也没去。”“哪也没去是去哪了？”“我一直都在。”“为什么我不知道？”“因为你记挂着我。所以你看不见我。”我想了想，说：“那早知道我就不记挂你了。”她笑着打了我一拳，轻轻的。我边吃饭边说：“我以为你生气了，走了。”“才没有呢。我还以为哥哥生气了。不敢面对你。所以不见你。”“怎么会。你什么时候见过我发你脾气。”“呵呵。没有呀。可是哥哥那晚真的很可怕呢！”“……”“哥哥。我去找个男朋友好不好呀。爸爸刚刚说我这年龄可以找男朋友了。”“阿……”“哈哈。看哥哥的表情……我开玩笑的。”“哦。”“呵呵呵。”“下次不要乱开玩笑。这样是不对的。”“嗯。我知道了。土豆条好吃么？”“好象比以前咸呀。轩，你的手艺退步了。”“阿！不会吧！我尝尝……没有呀！”“哈哈，我明显是开玩笑的。”“哥哥！不能乱开玩笑！尤其是对待我的饭菜问题！”“嗯好的好的。吃饭吧。哈哈。”“毕业了。哥哥准备去哪念书？”“不知道。不念了。或许，开店吧。”“开什么店？我也要开。”“你不念书啦？”“我本来就不用念书。不信你考考我，我全知道。”“那开花店吧。”“不喜欢。我知道哥哥对花敏感。”“你不是说过你喜欢花么？就开花店了。”“呵呵呵呵。”“傻笑什么？”“没什么……”theend>>于是花店开张了。……看完感觉很感动..虽然把自己丑化不少嘿嘿~不过好喜欢的..很开心老大还吃醋了..我的戏份比较多哈哈~自己得意了好久呢~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('274', '2000', '曲名：童话歌手：光良专辑：童话忘了有多久，再没听到你对我说你最爱的故事我想了很就，我开始慌了，是不是我又做错了什么你哭着对我说，童话里都是骗人的我不可能是你的王子也许你不会懂，从你说爱我以后我的天空星星都亮了我愿变成童话里，你爱的那个天使张开双手变成翅膀守护你你要相信，相信我们会像童话故事里幸福和快乐是结局一起写我们的结局', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('275', '2000', '我:l,如果一个妖精爱上了天使会是怎样?天使是属于天堂的.天使是该和天使在一起的没人会同情小妖精可笑的感情是不是?l:小妖精有权利去争取她的爱情,起码我支持她.爱情没有界限.我:可是小妖精没勇气,怕疼.觉得自己没资格爱看到天使便更觉得自己的卑微.只能看看什么也做不了.她怕天使忘了他曾给予安慰的小妖精忘记他们一起玩的日子.l:这就是小妖精的错了,为什么不能为了自己的所爱抛开一切阻力呢?我:小妖精可没有那么阳光的心态.她只有祝福连一个一味奉献的机会都没有.她真的不求索取.l:那就去找勇气啊.没有胆量又怎么追求自己的爱情呢?只有自己能帮自己,别人真的无能为力.我:l,小妖精快不行了.天使好象失忆了.小妖精没勇气帮天使回忆,找回过去.她怕碰到天使嫌恶的眼神,她真的怕了,怕心在滴血的感觉.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('276', '2000', '\"昨天的事情.今天补述.中午吃午饭时就不停的下雨..雨不大看起来.满惬意的.l,yy和我每天都要去操场转转的.今天他们都留在教室里.\"\"l,我想去操场,要一起吗?\"\"＂在下雨哎．＂＂是啊，不下雨我还不去呢．＂我撇了撇嘴．于是拎了瓶绿茶．去操场．不知道自己是从什么时候开始喜欢绿茶．只记得初中的时候．很多女生都喝红茶．她们不喜欢绿茶略带苦涩的味道．操场好静．沉淀了几日来的浮躁．只有班里几个有＂兴致＂的男生在踢足球．过了一会．．猛然觉得脸上不很湿．一粒粒的．是冰雹．砸在脸上很直接很透彻的感觉．刚刚去超市看见ｎ了．不知道他有没有吃饭．只觉得每次见到他总会很开心．．不过很快取代这种感觉的总是一种想哭的冲动．莫名其妙的．人的感觉真的好微妙．赛跑.有他参加..我看他接过接力棒我就转身离开了..好怕见到他..隐约觉得见了面后.他不大爱和我说话了.所以不敢面对...我当时莫名其妙的好想哭,爬到学校的顶楼听着mp3在窗口吹风...好想对自己说,没我事..这不关我的事..自己不是很爱这么说吗?也总是能说的恰倒好处..给他们有力的一击..对你..我做不来..做不来把自己推脱的干干净净..自己也说不清．我是个满自私的人．掐指算算让我记挂的人还真没有几个．．就是因为你的遭遇．．和故事吗？..也许只有这么多了..我不知道自己还能做什么..或许自己什么也做不来..很想帮你．．．记得我和ｎ说过很想帮一个人却什么都做不了．那种挫败感．．第一次让我觉得自己那么无能．．自己办不到的事好多好多．．其实那个人就是他．．一种没来由的怪异感觉．．仅仅是很想帮助他．．也许每个人心中都会有一个记挂的，很想帮助的人吧．或许是我天生爱多管闲事．言归正传．希望身边的人和事．都能像冰雹一样简单而纯粹．ｙｙ说　我是很简单的人．和我说一些话会怕我听不懂．不说话还好．说了话觉得整个人傻里傻气的．和别人不大一样．我是内外都傻的那种．我这种人她还是第一次遇到．．挺好玩的．．呵呵．．好玩？！．．我随便说一句话能让他们笑上一节课．他们都说我好玩．似乎我就是个笑话一样．．当他们笑的肚子疼时我总是摸不着头脑．很好笑吗？不知道是谁比较白痴．．我失落时谁来哄我．．逗我．．给我讲笑话？\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('277', '2000', '今天少爷说我是好孩子了．．．自豪一下下．．只是有点叛逆．很孩子气．．哈哈～少爷真是太明智拉～他说：刚接触我时觉得特内向．了解时间长了之后便觉得性格很多变．．反正我是好孩子就对了．．这些不废脑筋去想了．．', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('278', '2000', '有段时间没有写日记了,现在回来了,但是心情还是不怎么样,也不晓得怎么的..就是不怎么想说话,,整天笑不出,.唉...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('279', '2000', '有的时候真的觉得我很失败,现在我也不晓得怎么办.回来了,觉得朋友对我的感觉都变了,说不出味.所以或真的,我都没有心情去找他们,看到了,我也会觉得不自在..不知道说什么,我觉得田塍现在和我说话的语气很冷淡..很奇怪,我没做什么让她不高兴的事啊,哎...也许就像海洋以前说的..她也有心机,要我防着她,..呵呵...现在真的好想si,又是他要我好好和熊猫在一起,哈哈,现在又这样.看见了恩,本来现在就没什么话说,这样我真的更加没想法了,..真的好想像以前那样,在一起玩,哪有这么多事,明明是朋友,却搞得那么陌生..我很不想和熊猫在一起,没感觉,又不配..哎呀,看了就不舒服,怎么办咯,要我怎么说分!没理由啊,上次说了,还和我吵架死的,逼我`!...加上他又要我好好和熊猫在一起,气来了,就答应了...现在好了.在一起又说,不在一起也说,哎...真的好烦...我有时都觉得....算了,现在的我没办法感觉`!..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('280', '2000', '那时有一股开心的感觉..然后那感觉很快就退却了..不知道是不是真的还是自己的幻觉..是不是我得了幻听症.5~悲哀~不过我耳朵确实有够背..l说的我听音乐总是喜欢把声音调到最大..震的耳朵嗡嗡响.头会感觉酥酥的..搞的现在声音小了都听不到..上次上楼时突然感觉一下子什么都听不到了..嗡嗡的..还好一会就没事了..言归正传..我都不自觉把身子转了过去..自己也搞不懂.过了一会看见lt了..真的好喜欢她..很久没见到那么真实的人了..或许她幽默的有点夸张..但决不做作..让我觉得是一个活生生的人..我喜欢.她把我们领到宿舍去嘿嘿..它把好多东西都翻出来给我们看.一点都不嫌麻烦...天啊..lt的话..让我笑的先肚子疼然后疼到胃口..长这么大还是第一次..很久没笑的那么透彻了..就是单纯的.开心..笑声不搀杂任何敷衍虚假的东西~~~~好痛快~~真的是太喜欢她了....!!!!!!!!!!!!!!!好想住宿..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('281', '2000', '(2005-04-2123:24:32)&⒏绣、恩!我两个分手算了`!(2005-04-2115:20:21)沉淪假象给我个理由.!(2005-04-2123:30:08)&⒏綉、你觉得我们配不?>`!(2005-04-2115:21:23)沉淪假象那你指那方面不配?(2005-04-2123:31:42)&⒏綉、很多,真的..而且你也知道,有好多人都觉得我们根本就不应该在一起,`.(2005-04-2115:24:28)沉淪假象恩咯.我现在没什么好说的.既然你觉得别人说什么是什么.我说再多也冒用.反正我是冒亏吗东西咯.我还不随便你...是不配啊...连上街,你都要走.你也不会给我好脸撒看..不在一起.我也不用看别个脸撒啊.(2005-04-2123:36:20)&⒏綉、我没有给你脸色看,其实我心里真的很多事,以前我是爱笑,但是现在不同了...我是变了,但是我真的不是要给你什么脸色看,我也不是那样的人...(2005-04-2115:28:58)沉淪假象老子今天等噶你果久.你吗拐直接广要走人.你切问下别个,我等果那个妹几冒.?也只有别个等我撒.真的有味.!!(2005-04-2123:39:54)&⒏綉、我晓得撒,我晓得你等我等得久,你以为我心里好受?我也不喜欢等人,我晓得等人的滋味,但是那时候我心里不舒服,只想走...(2005-04-2115:31:27)沉淪假象是吧!算了.不要说了.我也不想听.反正你是走了...(2005-04-2123:41:16)&⒏綉、恩,?(2005-04-2123:56:26)&⒏綉、我走了,回家了..`!(2005-04-2115:47:22)沉淪假象是吧4.我吗有点觉得被你耍果感觉啊.?(2005-04-2123:57:03)&⒏綉、我耍你?`!!!!!!!!!!(2005-04-2115:47:48)沉淪假象是.(2005-04-2123:57:25)&⒏綉、呵呵..你这样认为?`!(2005-04-2115:48:10)沉淪假象是的!!!!!(2005-04-2123:59:02)&⒏綉、恩咯..你这样想也好,算了...你就当我耍你`!(2005-04-2115:51:51)沉淪假象.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!.你//.........有.....种.!(2005-04-2200:04:44)&⒏綉、........随便你现在怎么说,我现在是很冷漠,朋友现在都这样说..所以对你是不怎么热情...而且我也不习惯,.很烦躁`(2005-04-2200:06:21)&⒏綉、我走了,不想说什么话了..拜拜。.你也不要乱想,哎...算`!晓得你不会..我管不到了``⒏⒏`1(2005-04-2115:57:18)沉淪假象我早说过,你和我在一起,你朋友会广黑多我坏话.你受不了,那就分手咯.我不的勉强你,随你.我很生气.请你以后在也不要出现在我面前.(2005-04-2200:16:42)&⒏綉、失机!冒话广达``!你要我默出现在你面前..可以``冒问题,.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('282', '2000', '如果记忆冻结了，那么只剩下彻骨的凄凉。如果他都忘记了那么当初奋力封上的保鲜膜看来毫无意义。。于是揭开保鲜膜决定忘记..忘记，忘记那几千年魂梦牵萦的容颜。忘记，忘记那已成为习惯的远方的牵挂。忘记，忘记去抚摩那旧照片上昔日的容颜。忘记,忘记时常去轻拍你那泛黄的记事本上薄薄的灰尘.将记忆焚烧..当记忆变为回忆。。转瞬间前世来生。抱怨过.挣扎过..如今有的只是认命..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('283', '2000', '今天和LT聊了好多..我不经意问到了NEMO..他她说他特爱吹牛..我傻了...就问她反反复复的问是不是误会他了...到底他有怎样的经历我怎么做能帮到他...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('284', '2000', '再见过去下過雨後我大口吸著清新空氣今天以後要努力做全新的自已過了限期不再可憐兮兮承認你已經從我的世界走出去回家的路我夢見一望無際花海真的感激又看得見大然美麗不再哭泣才能夠看得清晰我真的懂了再也不會自暴自棄再見過去我們的足跡相信印記將隨時間淡去那段相遇心動熱戀分離我不會否定因為它是我成長的日記下過雨後我大口吸著清新空氣今天以後要努力做全新的自已不再哭泣才能夠看得清晰我的懂了再也不會自暴自棄最後一次回頭看才明白原來傷心是旅程中必須經過的小鎮離開後我更勇敢再見過去再見我和你勇敢說再見就有勇氣繼續會有新的發現新的經歷新譜的戀曲原來我喜歡這樣的自已', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('285', '2000', '哎...真的没想法了,突然觉得好受了的..哇哈哈..我怎么觉得自己好像很没良心了啊`!..不过也好,以后少个人在旁边唠叨,.真的觉得对不起他,没办法啊,哎...而且也手不了朋友看到我和他在一起就恩我,我天,那种感觉真的好难受啊,..哇..有种解脱的感觉...没良心啊`!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('286', '2000', '突然觉得什么都离我好远好远,.我只有冷漠,只有被遗忘...现在开始上班了,又在以前那个店,干爸爸干妈妈让我回去,我去了,闲着也是闲着,.再之,不说上班就没有理由出来,家里不准我出来...很惨,不是吗?有点累,但很充实,总天天呆在家里好吧?新来的店员都还好,很平易近人的,..只是有时又不忍.因为我去了.别的店员就要“下纲”.心里很不舒服,昨天走了⒈个了,今天干爸说还要把小婉叫走,哎..我都有复罪感了啊...忽忽..社会就是残忍啊...不知道他们过得怎么样,有没有想我?不知道噢..突然觉得自己真的很忧郁了,很冷淡.说话很是没精神,变了,我真的变了,不是朋友说,我自己也感觉到了,怎么会这样..?我可以回到从前的`!我尽力...耶`!我可以的`!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('288', '2000', '总算是考完了,没有考好!还好老爸没有骂我!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('289', '2000', '刚刚看了我不想你的日记本!觉的现在好象我们这些高中生都是这么烦!都为了情而烦恼!以前我也是这样!不过现在已经没事了!一心考试!时间不多了!还有40天,时间转瞬即逝!真不知道一个月后回怎么样?好想知道(我不想你)是谁?和她聊聊!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('290', '2000', '阳光透过窗廉，照在纯白的床单上，我看到了，干净的颜色。原来，干净的颜色是可以在阳光的洗礼下，变得那么透彻的……倒了一杯白开水，坐在窗台上，告诉自己，生活可以像白开水一样，平淡无味，纯纯的，透明的让人一眼看穿，毫无杂质，简简单单，原来简单的颜色，是这样子的……抬头看看尉蓝的天空，蓝色，真的是忧郁的吗？对着镜子，看到了忧郁的自己，却看不到忧郁的蓝色，或许，忧郁的，不止是蓝色……回忆，到底是什么颜色的呢？看着天边一朵朵灰色的云，我知道，雨，即将来临了……雨是否也像开水一样，纯净无暇呢？雨下了，世界变得好安静，安静得让人沉思回忆，周围都是灰朦朦，灰色，原来是回忆的颜色……水滴坠落到地面，掺夹着尘，雨，不再纯净……雨后的天空是最美的，因为，能看到彩虹，因为，彩虹身上，有着干净的白，有着简单的纯，有着忧郁的蓝等等……但，为什么，它没有回忆的灰呢？或许很多东西，并不和回忆扯得上关系，但偏偏，我看到很多不相关的东西，却勾起我的回忆……身上的灰色太多，已经盖过了我本身应有的颜色，已找不到属于我自己快乐的颜色，一切，都变得那么黑白……原来，白色没在阳光的照耀下，一样是白色……纯净水，并不是那么纯的，它的一些杂质，是我们肉眼所看不到的……天空和海洋，一直都是这样的孤独，蓝色的忧郁，是真正属于它们的……唯一没变的是……回忆，是灰色的！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('291', '2000', '\"世上本~在天空与大海间，发生过一件不为人知的故事。鱼说：“因为救了你，让我懂得真爱。因为爱上你，让我忍受了痛苦。因为想你，让我的眼泪汇作大海。因为等你，让这片大海变作沙漠。因为一切的所以，让我不能再见你。”在很久很久以前，大概要追随到连我们祖先都记忆恍惚的时侯。在天地之间，发生过一件爱情故事。而我就是这份感情的牺牲品。记得当我们还是卵状时,是宙斯带我们来到万神宫,待到孵化的时候,取名为守护神,安琪儿.我的哥哥姐姐们迫不及待的出来审视着周围的一切,雪白的翅膀,像海一样蓝的眼睛.仙子们为他们惊艳的外表赞叹着.所有人都在等待着我的到来.可是谁也不知道在黑色的卵后究竟隐藏着什么。现在的我依然可以记起他们第一次见我的表情,眼里的不屑和鄙视,就连可人的仙子也有回避我的意思.时间一天天过去,可我在每个人心中的地位依然像身上黑色的羽毛一样的轻.由其是那双充满仇恨的血红的眼睛,所有人都不敢看我,我开始仇恨周围的一切,拼命拔掉自己黑黝的羽毛,疼痛迫使我的眼泪不住的流.我不停的问自己,为什么赐给我快乐的名字却不能让我拥有与他人一样快乐得生活.可是唯独一个叫比特的天使改变了我.他不知什么时候走到我身边,看着地上散落的羽毛,对我说:”飞儿,为什么不说话?\"\"\"\"为什么我与你们不一样?\"\"我在也无法掩饰自己的痛苦,我的情绪变得激动,泪再一次不争气的往下流.我感觉得到那双血红的双眼像烈火一样燃烧.就在那时我的身体充满了魔力.手不自觉的准备向他进攻.可是他却握住我的手,说:\"\"听着,并不是所有的黑都代表邪恶,就像并不是所有的白都代表善良.\"\"我迟疑了,从没有想过会有人这样跟我说话,\"\"飞儿,你之所以拥有着与他人不同的色泽,是因为你将有着不同的命运,你必须发挥出上帝所给你的一切,无论怎样我都会陪着你.\"\"他抓的更紧了,仿佛我真的是他重要的亲人,不愿失去我.尤其是留在嘴角的微笑使我失去防备,眼里的泪水熄灭了愤怒的火焰.\"\"为什么对我这么好?\"\"他用深邃的蓝眼睛看着我,让人那么的温暖,他说:\"\"因为你是我妹妹.我们是一家人.\"\"就从那天起,我一步没有离开过比特,笔挺的鼻子,说话时的表情,还有每次扑扇着雪白的翅膀在蓝天中飞翔的动作,都牵引着我.我很清楚自己已经喜欢上比特,我知道自己离不开他,甚至可以为他牺牲一切.可谁知就当我向比特表白的那一天却是我们见面的最后一天.听说在那片爱琴海中有一些鱼族出没,没人见过他们全身,因为他们离水无法生存,鱼族向宙斯发出战贴,为的是爱琴海权的归属,宙斯并没重视,他只是派法力不是很高的守护神去,以比特为首的天海之战开始了.鱼族拥有着爱琴海这个有利的地势,可以随处闪躲,而比特虽然法力在众守护神中居于首位,但鱼族样样本领都胜一筹,他们主要用的是水术,可是杀伤力却极大,只要被水滴击中就会掉进海中.比特没有让我参战,因为宙斯告诉过比特,我的命运像被什么东西控制着,如果掌握法术会对大家造成不利.我就像个闲人一样在这么大的万神宫中看着他们练习.可我怎么能让比特去送死,我悄悄地逃出了大殿.打斗十分激烈.比特和其他人用的却是最普便的”蓝光”,连我这种外行人都有不祥的预感,不好,清音被击中了,恐惧使比特不得不作出最后的选择,糟糕,他在用”紫光”,紫光是守护神法中最高级,没有八成的内力是不能使用的.为什么我帮不上忙,这样比特就不会有这么大的压力.他要出招了.我静静的等待着.天啊,紫光射向海边的岩石,碎石溅落在爱琴海中.那是……..其中一个鱼族人暗算比特,”啊”的一声,他宽大的翅膀停止了扑动.就在那一瞬间,我的手又不自觉的开始施法,其威力没有人能想象的到,.平稳的海面形成一个大凹形,我想趁机救回比特,谁知比特却被他们用水绳卷回爱琴海.啊……….我受不了了,对天大喊,我正准备跃进海中,却被宙斯带回万神宫,不知为什么,从此以后我的怨恨越是深,我身上的魔力就越是强大,宙斯暂且用神锁将我捆住……………..三个月过去了,对我来说这比三年还痛苦,不知比特是生是死.我含着泪,眼神一片迷茫.”谁?”是我飞儿,”哦,”我试图掩饰自己哭红的眼睛.”清音,你怎么会来看我,你的伤好些吗?”嗯,你..你呢?”还在想着比特?”我有些诧异,心跳的好快.”你怎么会知道?”大家都看得出来,宙斯也不例外.”我有些尴尬.”你有事吗?”清音看了看四周,说:”比特回来了.”我愣住了,鱼族的人怎么会放了他.可惜我被困在这里,除了宙斯,没人可以打开这神锁.”这有一面魔镜,从中你可以看到比特.”谢谢.就这样清音离开了.我拿着魔镜,仔细的看着里面发生的一切,是比特,没错,真的是他,没有丝毫损伤,依然那么英俊,他好像有事要问宙斯.所有人在万神宫里等他.”我亲爱的孩子,很高兴能看到你回来.”尊敬的宙斯,我回来是有事问你的.”说.”是你带我们来到这里,对于我们的来历你却从来不提,我想是时候该把事情说出来了.”所有的守护神根本不明白他们再说什么.只见宙斯皱了皱眉,然后把目光投向艾斯女神,他们用眼神示意了一下,宙斯终于开口了,”三千年前，一个陨石撞向了地球东方的平地.在凹地的附近就座落着一座与这颗陨石同名的城市,阿耳吉.在阿耳吉城中有一位美女叫琴斯,她出生在富贵家中,但却不能拥有自己的自由.琴斯爱上了与她同姓的琴拉.他们就在那片凹地相见.两人的爱情感动了我和诸神,却若来嫉妒女神的诅咒.琴拉被用鹅卵石困在那片凹地下,而当琴斯得知后,产下500颗卵,就哭死在那片凹地,她的泪水就化做了今天的爱琴海.”那么我们就是那500颗卵?”并不全是.为了不让嫉妒女神发现那些卵,你们的母亲用血化作紫金石困住卵的灵性,可随着时间的推移,紫金石开始退化,一阵怪风将一部分的卵吹走了.至于吹到哪里,我和艾斯女神至今都未找到.”在爱琴海.”什么?”那场怪风将一部分的卵吹进爱琴海,他们跟我们一样有着羽毛的翅膀,可是因为水里行动的方便,他们的翅膀开始退化,慢慢长出鱼尾,也就是我们所说的鱼族,不过阿耳吉城的人命名他们美人鱼,因为当地人在捕鱼时亲眼看见一条美人鱼在礁石上凝视着海天的交界线,黄昏的夕阳落在她的身上,美极了,所以人们就为她建起一个铜象,她就是鱼族的首领,丘比.”为什么比特在说到那个叫丘比的美人鱼时,表情那么的投入,我得心情越来越乱,究竟在这三个月中发生了什么事,突然间,镜头从万神宫转向了爱琴海,好像有人在帮我找到答案一样,我看到三个月前发生在比特和那个叫丘比的美人鱼之间的事情.那天,比特的确受了重伤,不过她也伤得不浅,大概是被我击中了,她命令仆人送比特到床上,自己来到一个河蚌前,她叫它蚌母,蚌母给她一个黑珍珠服下,她的法力恢复极快,甚至可以超出原来的.后来,她来到比特身边,仆人都退下了,她眼里因为尊贵的身份而勉强出的坚强,像断了的弦一样,松懈了.好像在比特面前,宁愿毫掩饰,她看着比特触人的面庞,仿佛在那一刻,水都冻结了,冻结了她指尖触摸比特的瞬间,直觉告诉我,她也爱上了他.我的脑子里一片空白,这时,她开始为比特疗伤,时间很短,这意味着她的道行已经在升级,最后她将黑珍珠运给比特,用来让比特更快的习惯水性,离开了.她真的比我想象中完美善良,在坚强的背后却有着脆弱细腻的心,难怪比特在谈她时那么用心.我得心情稍微平稳了一些,因为那是的比特没有任何回应,这代表我还有机会.可是后来的事,使我彻底崩溃了,自从比特醒来,就发现在深海处总有一道亮光在牵引着他,他不止一次的朝亮光的地方走去,可每次都被她拦住,其实丘比也有这种感觉,所以她带着比特游到深海处亮光的地方,是一快巨大的鹅卵石,里面困着一个人,没错,他就是琴拉,比特无法打破卵石,只感到琴拉好像要说什么,可是听不到.这时,她开始施起法术,轰的一声,卵石破了,可却重新长出来包围着琴拉.乱石的碎片四处乱溅,她为了比特竟然受到碎片的击伤,她的脸色变白,比特拼命抱着她,惶恐的眼神使我开始害怕,我害怕会失去他,我明白比特已经对这个认识不到一年的人鱼有一种不可分割的感情,难道这就是爱情,像我对他一样,比特知道只有黑珍珠能救丘比,于是他含泪亲吻着她,来借此将黑珍珠还给丘比,我的心像被刀割一样,我像疯子一样的抓狂,我爱他,愿意为他付出一切,可他却爱上别人,什么会一直陪着我,都去见鬼吧我要你们都付出代价,一股强大的力量使我撤断了神锁,我用风一样的速度杀进万神宫,我终于看到比特,一个我一直盼望见到的,也是我今后最不愿意见到的人,我没有任何迟疑,可就在这时,”你和比特结婚吧,”宙斯突然说道,我的手停在空气中,我看了看比特,他的眼睛红了,说:”好吗?.”艾斯女神说:最好越快越好,我看就今天吧.”今天,虽然我不知道为什么谈起婚礼,但那始终是我所想的.婚礼布置的很快,比特牵着我的手进入万神宫,此刻我真的认为自己是世上最幸福的人,即使我知道他爱的根本不是我,穿着黑色的礼服走在红色的地毯上,我的身体一会热一会凉,我得血液在倒流,不,是在流失,我感到我会很快死去,很突然,而且是世上最痛苦的死法.我只记得所有人围在我周围,比特握着我得手,,现在的我已经连睁眼的力气都没了,他们在我眼前一点一点的消失….消失……想着我与他见面的第一次,想着他握着我的手对我说…对我说……….…300年后.我醒来时是在海边的礁石上,没错,是爱琴海,因为美人鱼的铜像依旧在那里,我没死,可是我得翅膀呢?我得眼睛不再是红色,我与人群没什么区别,难道我变成人了,我看了看四周,又是那个魔镜,我很想知道后来究竟发生了什么事,原来是宙斯找回我得灵魂,并让艾斯女神将我带到阿耳吉城,作为一个凡人在人间生活,我开开心心得走进城里,像换了个人样的,我开朗了好多,即使寂寞时常伴随着我,每当晚上的时候,我还是会想起个他白天的时候城里有个老奶奶总爱讲故事,大人小孩都爱听.听后我才明白事实的真相,比特把黑珍珠还给丘比后,蚌母决定放他会来,因为蚌母不想让第二个人知道解救琴拉的办法.,蚌母给丘比一个像箭一样的发簪,插在头上鱼尾就会消失,并且长出自己原有的翅膀.如果她要救父亲,就要不怕苦累,不怕亲人的离弃.这些丘比都答应了,原来她要去奥林匹斯山上取火种,利用神火的力量来打开鹅卵石.也就在她取火种的时候,我离开了比特.原来这全是嫉妒女神的安排,我们每个人都走进这个圈套,而我是嫉妒女神手里的王牌.三千多年前的一场怪风将我的那颗卵施了魔法,命运不再是我的了,而是属于奥林匹斯山上的火种,我得仇恨越深,火生得越旺,就拥有着宙斯都无法抵御的魔力.但是火种一旦消失,我也将永远离开比特.宙斯和艾斯女神占卜到这一点,他们只有能力控制火焰,而能让我不再有怨恨的只有比特,也只有和比特在一起,我就不会有可怕的魔力,所以他们让比特与我结婚,来制止嫉妒女神想要统领天地的野心,可是,我们却正在向危险步步逼进,丘比将火种投向爱琴海,一声巨响,鹅卵石是破了,琴拉也救出来了,可是美丽的爱琴海又变回原来的凹地状,只剩下那尊美人鱼铜像.鱼族们死的死,伤的伤,丘比立刻成了罪人,这时比特不知怎么知道丘比间接害死飞儿的事,他无法相信自己最爱得人会这样,比特没有考虑到她的感受,丘比不知到要解释什么,只是含着泪看着这个自己最爱可又如此陌生的比特.正当整个局面混乱的时候,嫉妒女神出现在凹地的上空,一场生死之战即将开始,她知道比特不是嫉妒女神的对手,比特用的依然是紫光,只不过法术比先前更成熟了,正当比特转身的时候,嫉妒女神的暗剑飞向比特,等到比特回过头时,却看见丘比挡在剑的前面,她只是微微一笑,眼角落下一滴泪,瞬间她的身体像散了的拼图一样,一块…一块…地消失在空中.当那滴泪落在美人鱼铜像上时,顿时像喷泉一样涌出泪光亮的海水,而丘比的鱼骨化作彩色的弓,那把发簪则视为箭,于是比特用这把弓箭射死了嫉妒女神,尸体掉进新的爱琴海中.后来,比特化作男婴去帮助那些没有勇气去爱的人,为了怀念丘比,比特将两人的名字联起来,所以人们现在叫他爱神丘比特.\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('292', '2000', '不知道你什么时候才能看到,我希望你早点看到,我是谁你因该知道吧~~!!我们的认识真的是很奇怪,从一个小小的玩笑变到我爱上了你,可现在我不知道你为了什么而跟我分手,在我的理解范围内就是因为我们相隔太远,我不知道你爱不爱我,但我真的已经爱上了你,如果说现在让我放弃任何一个东西或任何一件事能让你回到我身边我真的会豁出一切.我知道你现在一定不想看到着些.你老是认为都是你的错,但错的是我,我不该开这个玩笑,不该爱上你,我错了，我跟你说过我会等你,如果你还能接受我的话,铮铮我爱你iloveyou)把深爱人的◢█◤)╱◥◤の名字(╱╲╱)╱╱寫在煙上╭吸進肺里(╱周)╱铮╱离心脏最近的地方(╱铮╱◥╱︷..._　这是我的全不心里话，今天我全说了，不管你怎么想，我爱你不变～～！！看完这些是不是觉得我很笨，你可以骂我，但我不会改变，这是我给你的承诺，不管结局会如何，不管你是否会爱上别人，我爱你不会变~~！！！希望你能早日回到我的身边~！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('293', '2000', '今天是nba的季后塞的开始日。我感得非常的兴奋啊！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('295', '2000', '含羞草一样的年纪，总是以含羞草来解释爱的含义。根儿在泥土下感受彼此的呼吸，野儿却不敢在阳光下握在一起，最小心的试探也被误解为伤害，那样匆忙边将心扉紧闭，紧闭了就在难开启，任悔恨写满初雪般洁白的心地，哪只邮筒可以投递。即使在歧路相逢，即使在街头相遇，远远的便互相躲避着目光的致意，都说爱被拒绝的时候便是恨的开始，我却相信有一种恨恰恰是爱的变奏曲，不敢接受那恨的潮汐，只怕岁月的墙越砌越高，从此的不到一丁点关于你的消息，即使不能因为爱而走道一起为什么要为爱而隔开永恒的距离。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('296', '2000', '我第一次玩通宵好刺激啊！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('297', '2000', '说不上是不是真的忘记了.只知道自己不再绞尽脑汁去想那些无关紧要的问题了..隐藏了关于他的一些文字..实在舍不得删掉..覆盖住也看不到..明天就和bb出去了..难得一起出去玩..要整理个好心情出来..这次特别声明不准她带白出来..上次真是闷死了..虽然白很乖..我们两个女生出去带个男生就是觉得不自在..hoho~这次是只有我们两个~单独出去哦....西西~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('298', '2000', '想不到我和nemo选的课都差不多..知识类的在报告厅(他应该不常去)活动类的都在操场.我,yy,l我们常常点完到就到处转了.看见nemo了还有一个常和他在一起的男孩子.看起来满像新疆人的就叫他小x吧.我们三个坐在操场边上的水泥地上.他们走过时我隐约听见小x对nemo说,去打个招呼啊.那时有一股开心的感觉..然后那感觉很快就退却了..因为他确实没和我打招呼..不知道是不是真的还是自己的幻觉..是不是我得了幻听症.5~悲哀~不过我耳朵确实有够背..l说的我听音乐总是喜欢把声音调到最大..震的耳朵嗡嗡响.头会感觉酥酥的..搞的现在声音小了都听不到..上次上楼时突然感觉一下子什么都听不到了..嗡嗡的..还好一会就没事了..言归正传..总之呢~nemo还是没有和我说话..来来回回他们走了好几回.我都不自觉把身子转了过去..自己也搞不懂.过了一会看见lt了..真的好喜欢她..很久没见到那么真实的人了..或许她幽默的有点夸张..但决不做作..让我觉得是一个活生生的人..我喜欢.她把我们领到宿舍去嘿嘿..它把好多东西都翻出来给我们看.一点都不嫌麻烦...天啊..lt的话..让我笑的先肚子疼然后疼到胃口..长这么大还是第一次..很久没笑的那么透彻了..就是单纯的.开心..笑声不搀杂任何敷衍虚假的东西~~~~好痛快~~真的是太喜欢她了....!!!!!!!!!!!!!!!好想住宿..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('299', '2000', '我知道，我是自私的，我让你忘记一个你已经深爱很久的人，那是很难的，即使是我，告诉你我也做不到，但你既然已经选择了我，那你就不能在选择他，当一个人的心理一下子出现了2个人，那你就不可能好好的去爱一个人，我在你和她之间做了选择，因为我现在只想好好的爱你一个~！如果他能给你幸福，那我也很开心，因为我知道，我爱的那个人现在有一个比我更爱她的人在疼她，根本就不需要我，就象你说的我只有默默的祝福你们幸福，但你真的觉得他爱你吗？或者他给你了幸福吗？是我说这些话是有偏见，我不该强迫一个人去爱上他不爱的人，但你知道吗？我是真的喜欢你，当我看到你写的日记那一刻我整个人都呆了，自己爱的人竟然是根本就不爱自己的，而她爱的是另一个人，我的思绪现在好乱，所以可能写的乱了点，但我最想说的一句话就是我会给你幸福，希望你能在给我一次机会，让我好好照顾你疼你爱你好吗？我发誓我会爱你一辈子~~~~~~~~~~~~~！！！！！！！！！！相信我好吗？一口气说了那么多，看来我真的是完了``~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('300', '2000', '自从那天,你意外地闯进我的生活.我就相信:你是上天赐给我最好的礼物.可是正当我要敞开心胸,接纳你的时候,你却又悄然离去.是因为我的缘故,还是为了什么.此刻的你和我共享同一轮明月.是否知道,有一个人正默默地想念着你.自从上次握别不知何时还能再次相见，隔开我们的不仅是岁月还有风烟有一缕苦涩缠绕在心间距离不能阻挡两颗心应用彼此的真诚换回那帘相同的梦', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('301', '2000', '吉他给我说的-------------------一生中也许只有一个人能和你长相厮守不是吗?我们的身边总是不停的变换着面孔~一个人进入我们的圈子总会有一个走出去如果没人进来因为好奇心也会有人走出去的这就是个人意愿问题了你不可以决定别人的去留所以你只能适应别人的去留了', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('302', '2000', '\"其实人的\"\"坚强,勇敢\"\"无非是装出来的~不可否认人是虚伪的道别时依依不舍的人在离别后又有几个因为适应不了而选择结束自己呢?!当初所说的种种所谓\"\"不适应\"\"的虚伪言辞也都被时间所沉淀~与其说一切感情都是被时间打败的,时间的可怕.不如承认背弃我们的是我们自己~人类真的好假好虚伪恶心~\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('303', '2000', '\"最近一直看张爱玲的书.有一种上海旧旧的味道.但又似乎离我们很近~热闹,拥挤,然而陌生,隔阂.人与人之间充塞着幻觉,烟幕.这个世上.\"\"好人\"\"很多但\"\"真人\"\"很少.\"\"好人\"\"的\"\"好\"\"是社会赋予的.是一种客套或习惯.人们相互亲热,敷衍.仿佛人情味十足,但内心的想法可能完全是另一回事,仇恨,嫉妒,鄙视,猜忌,掩饰在冠冕的言辞之下.她的人物没有朋友,没有亲人,更没有爱,即使在爱的名目下走到一起的男女,那爱字也是沾了不少杂色的..人的本质始终是自私.这也许是张爱铃的观点,她笔下的人心总是那么寒冷,荒凉.一颗颗的心是迷失的,是孤单的.在自己家里也永远有着异乡人的凄楚.\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('304', '2000', '她在我的皮肉里种下一种慢性毒,毒发的时间,地点随她心意.没有解药看着窗外的车来车往.他们在追赶什么?是忙于奔命.是不是我每天太清闲而自寻烦恼~始终不愿相信hl是故意的.如果真的是这样那么她的目的达到了.而且干的很漂亮~不是一剑封喉而是用一种慢性毒一点点吞噬着我.每次毒发不差于万蚁钻心,但又不会致命~每次都会留口气给我~每当我相信她还是善良的时.又总是一个晴天霹雳~我诚惶诚恐~但并不怕她~只是不愿第一个揭穿的是我而已.一个人哭,一个人笑,一个人疯,一个人闹.难过时伤心时对着天空笑一笑~如果什么都没了至少还有自己直到某一天肉体于灵魂发生碰撞~我便自由了~在这之前我始终是个俘虏~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('305', '2000', '爱情..什么是爱情..常常这样询问自己~我还是个懵懂的孩子..还不想知会其中的酸涩与苦楚.爱情不过是不能碰的传说..明明知道只有满眼的惆怅,还要念念不忘.或许,爱不过是一场没有结局的战争.人在其中,生不如死.爱情不过是一场尔虞我诈的战争.没有血肉横飞没有刀山火海却足够让人锥心刺骨,生不如死.爱,这东西我碰不得也不是我有能力碰的.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('306', '2000', '生活充满了腐烂的气息.生活在物欲的世界里.势力,虚伪,谎言,像一股沙尘暴扑面而来.我稳稳脚跟,努力不使自己卷入这人情淡泊的旋涡~我笑不出来所以选择离开~因为不开心会传染~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('307', '2000', '易拉灌似的爱情我不要..要就谈一场马拉松似的..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('308', '2000', '就象我手机里发给你的一样，我会等，我会很耐心的等，因为我知道，我找到了我改付出的人，我该好好爱的人，即使你在怎么说我还是一样会等你，我爱你，这个是永远不会变的，我一定会感动你的，一定会会让你有另一份幸福，你不该把自己封闭，因为那样不值得，你想这他有什么用，难道你就不能除了他以外找另一份感情吗？以后我每个星期都会来写日记，我希望你会来看，不管什么时间什么情况，我都会写，一直到你回到我身边为止，小伟很支持我，因为他知道我是真的爱你~！！iwaitingforyou~!!iloveyou永远~~！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('309', '2000', '雨已经连着下了好多天了，今天看来还是没有放晴的意思，默默想你的心还在继续着。想着何时你才能再次上线，想着何时才能在这里看到你的留言。不知现在的你是否还好，是否过的还快乐。反复地听着如果下辈字我还记得你心中有一丝说不出的感觉在缠绕着我。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('310', '2000', '冻死我了！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('311', '2000', '把心情沉淀,滤出的是星星点点的泪..堆积成你脸上的微笑~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('312', '2000', '双鱼的男孩便是天使赐予人间的一个礼物。他是王子，来自一个梦幻的国度，那里有蓝色的天，蓝色的海，蓝色的诗，蓝色的梦，蓝色的爱，蓝色的一切……他的眼睛是透明的，一眼望进去尽是真的善的美的，没有污秽的双眸容不得沙子，他学会了流泪，叹息……纯真的梦啊，竟如花瓣般凋谢了，纷纷扬扬的散落……可是，他，怎么能有一刻离了梦呢？于是，他依旧善良到纯粹，单纯到痴迷，无可救药的迷恋——蓝色的一切。在渐远的天际划出一道蓝色的弧线……受海王星掌控的双鱼座，富于直觉、谦虚、敏感、善解人意、感情丰富、脱俗、适应力强、仁慈、富有同情心、多才多艺；同时，又会粗心、浮躁、缺乏自信而意志薄弱、优柔寡断、散漫、不切实际。双鱼座可以很讨人喜欢，他随时可以扮演阳光男，非常善良不带任何色情色彩，可是如果他要的话，马上就可以让所有人对他有好感跟印象，他天生的魅力以及好人缘常常让另一半觉得危机四伏。双鱼座一向不太爱出声，要双鱼主动和人讲笑话，除非这件事可以让他笑，否则他永远不讲；只要心情好一点就和你讲几句，要他天天讲，难呀！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('313', '2000', '你妹妹告诉我说你不想伤害我，但我告诉你，只要和你在一起我情愿受到伤害，但我告诉你，你永远封闭自己我很伤心，我情愿做你现在的救生圈，我能给你幸福，你只有接受另一份感情才能知道，世界上还有比他更好的人，还有比他对你更好，更爱你的人的存在，我爱你，我是不会改变的，我只想你知道这一点，至于会不会伤害我，我自己心理清楚~~！！！只要你能忘记他，能过的更好我就满足了，还有帮我谢谢你妹妹，她能为我说话我已经很开心了，我看到你的日记以后我想了很多，是不是该放弃，但最后我知道自己不能忘记，更不可能有另一个人来代替你我真的想你回到我的身边，即使你根本没有爱我，或喜欢我我会努力使你忘记他，使你过的更好相信我好吗', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('5178', '58', '<br>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">这些电影台词太&ldquo;毒&rdquo;了，却句句都戳中人心！</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这些电影台词太“毒”了，说到你心坎了吗？_台词,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4814hicrgkenfcd.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">1.一但说出口的话是收不回来的，因为一句话的差错可能会失去一生的挚友，擦肩而过可能就再也邮不到了哦。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这些电影台词太“毒”了，说到你心坎了吗？_台词,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_48145x0f5xhpftz.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">2.追逐梦想不是靠才华，是靠决心。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">如果真想这样做的，那你就一定能成功</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">不相信自己能做到的话，就什么都做不成</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这些电影台词太“毒”了，说到你心坎了吗？_台词,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4814hifvi211njy.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">3.我不敢先说我爱你，我怕你以为这是场游戏。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这些电影台词太“毒”了，说到你心坎了吗？_台词,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4814zwuo0aebn1e.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这些电影台词太“毒”了，说到你心坎了吗？_台词,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_48143ghi1nqqvub.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">4.成年人的生活里，没有&ldquo;容易&rdquo;二字。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这些电影台词太“毒”了，说到你心坎了吗？_台词,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4814arupgkel5sw.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">5.没有你，良辰美景可与何人说？</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这些电影台词太“毒”了，说到你心坎了吗？_台词,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4814rdcxsb3nyca.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">6.这个世界的好人都吃亏的。</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这些电影台词太“毒”了，说到你心坎了吗？_台词,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_4814rz4cq0o1ziq.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">7.我希望你在撞得头破血流之前就停下来，28岁时谈梦想，丢不丢人？</p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\"><img alt=\"这些电影台词太“毒”了，说到你心坎了吗？_台词,娱乐,娱乐台词_读多多\" style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px auto; padding-left: 0px; padding-right: 0px; display: block; font-family: inherit; max-width: 100%; vertical-align: baseline; border-top: 0px; border-right: 0px; padding-top: 0px; font-stretch: inherit; border-radius: 4px\"  src=\"/tu/allimg/Yulu/Yulu_481421wejoqhsmq.jpg\" /></p>\n<p style=\"border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 1; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 20px 0px; padding-left: 0px; padding-right: 0px; font: 18px/30px Arial, Helvetica, \'Hiragino Sans GB\', \'Microsoft YaHei\', sans-serif; word-wrap: break-word; white-space: normal; letter-spacing: normal; color: rgb(93,93,93); vertical-align: baseline; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; font-stretch: inherit; -webkit-text-stroke-width: 0px\">8.有些人是离开后，才会发觉那个人是最喜欢的。</p>\n		', '', '', '127.0.0.1');
INSERT INTO `dede_addonarticle` VALUES ('315', '2000', '我相信你~相信你~不管别人怎么说怎么想我一直都相信你~', '[FACE=宋体][/FACE][/size<br> 今天在一个不一样的日子里让我很伤心让我很难过</p><p> <img src=../e/plugins/bz/17.gif border=0 align=middle>什么也没有了都空了<br> 我的时间没有很多我想要的东西<br> 我曾经得到的东西没有好好珍惜<img src=../e/plugins/bz/17.gif border=0 align=middle><br> 今天我也偷偷的看到了张茜的日子让我真的知道了许多<br> 我真的想她啊可是她', '', '');
INSERT INTO `dede_addonarticle` VALUES ('316', '2000', '看了你的日记，我知道现在自己不该在来打扰你了，可能我真的太自私了，我对不起你，我还对你说叫你学会放弃学会忘记，但我自己呢，我连自己都控制不住，自己却那么放不下着份感情，我错了~~！！也不知道你是为什么不回我短信，总让自己想是你没有看到，但还是想这你觉得我已经很烦人，明明知道自己不可能但我做不到，对不起对不起，我不该让别人做连我自己都做不到的事情。今天特意看了看你日记本的名字，我知道你真的是忘不了他，money杰这个名字真的.....我会记得写日记，会等2年，现在只有祝你天天开心，幸福快乐，我爱你~~~！！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('317', '2000', '日记本博克网页邮箱所有的一切都要换新的了还好QQ的密码没丢，不幸之中的万幸！虽然现在还没时间从头来过！终于下定决心退了那个班的群，说实话真的不想这么做的，可是我妈下了最后的命令了，又赶上快到母亲节了，我不想让妈妈生气着急，狠狠心退了！（我忍了T-T）明天就开始正常的上课了，真得挺高兴的。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('318', '2000', '喜欢光着脚丫在房间里啪嗒啪嗒地走来走去~或许老爸老妈知道我有这个不良嗜好就装了木制地板..不过地板还是很冷~终于写完作文和烦人的抄课文作业哩~!光着脚丫从书房奔到卧室.重重的砸在软软的大床上.四脚朝天~眯着眼睛假装昏迷一小会儿...再把水温调到10度~把一大杯冷水灌下肚~~~真爽~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('319', '2000', '放假真闷................明天又能见到那伙人咯~西西~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('321', '2000', '天空终于看到了天上一丝阳光，但我天空心中的阴影还是没有散去，在日记里还是还是没看到关于你的任何消息，自从那天你意外地闯进我的生活，原本平静的生活就这样被你......原本平静的心情也这样被你......想起你和我的相遇相知，没有热闹繁华的都市也没有熙熙攘攘的人群但我就这样无故地被吸引。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('322', '2000', '娇我不知道为什么我就会主动的和你接近.娇我不知道为什么我会喜欢你.娇我不知道没有你的日子类我会怎么样的过.我看是有缘吧~我从见到你的那一天我就不知道了我回在哪和你说我爱你...我不知道你当时想的是怎么想的,我现在才干到我那时的冲动,真是不好意思了哦~呵呵.不关我们会发生什么事我的心永远都是你的~~我永远在你那边~~我对你的爱~是无法用语言形容的~~~~~~~~娇~~一生一世爱你', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('323', '2000', '很久没有打开这个日记本写些什么了，其实根本就不知道要写些什么。老是犯困。qq上有人和我开玩笑说我过的是美国时间。我想想，好象是这样。记得看《五月之恋》的时候听到五月天的武装，心里就想起了自己，难受。拉肚子拉得快死了，真不舒服。昨夜一夜没睡，6点半的时候我跑了出去，拍了很多天空，看上去还不错。我出神的看着那些画面，我不知道自己在想什么。我不知道自己想要什么。我在q上和鱼说话，我也不知道自己对他是什么感觉，似乎可有可无。我不在乎。鱼说他不太喜欢漂亮的女孩子，除了我以外。我大笑，他还蛮会夸我的。鱼说喜欢我之前不知道我长得挺好看的，我无语，原来我以前给他的印象一直很难看啊！齐录很久没上网了，大概是呆在老家不想回来了吧。呵呵，他也真是够能玩的。他不在的这段日子里我几乎都快把他忘了，也快把这个日记本给忘记了。我和很多人说，其实我也不知道我喜不喜欢齐录，也许只是想找个人来爱而已。觉得自己无聊。熊熊在放假的时候陪了我两天。我挺感动的。熊熊一直对我很好，很迁就我。那天我俩一起躺在床上的时候我问她现在有喜欢的人么？她说没了。然后我亲了亲她的唇，我说做我女朋友吧。熊熊摇了摇头说她不能接受，我没话说。我知道熊熊也是喜欢我的，只是，关于LES，她还不可以接受。熊熊说看着我很坚强的样子，其实我很需要人去保护。我哈哈的笑。我是不是真的太懦弱了？为什么大家都这么说呢？其实我挺想告诉妈妈我一直都很爱她的，可惜说不出口。我和妈妈说，我想和她住在一起了。妈妈摇头说太晚了，已经不可能了。我就不再说话了。是不是真的太晚了呢？我倦了。不说了，去洗澡了，然后出去拍些照片。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('324', '2000', '[FACE=新宋体][/FACE]她给我说她在也不玩qq了也让我伤心了她真是的让我真的很伤心啊她不会了解的我的心情啊真的我以后也没有人会理解我的心情了算了不写了也写也伤心', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('325', '2000', '今天心情又不怎么好，慢慢的也过了一天，嗨~~真的一个人的生活很孤单很乏味但我还是要学会过下去，因为我对自己发过誓为什么你我要等，明天我们要去体育馆当裁判，2天都不用读书，哈哈，真的很舒服，不知道现在你怎么样了，可能过的很开心吧~~！只要你开心我付出多少都无所谓，真的希望能天天陪在你的身边看你笑，呵呵`~~！！真的很希望电视里的情节能发生在我身上，但那真的很远，至少现在我迈出了第一步，现在是2005年5月9号~~~分手已经很久了~2年后的2007年5月9号我依然会在这等这你~~~希望那时你能给我一个确切的答复~~~爱你笨蛋留', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('326', '2000', '[FACE=宋体][/FACE]海洋色的梦>>一个多么浪漫的名字啊,想知道我为什么这么叫吗?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('327', '2000', '\"一天，男孩和女孩吵架了。他不再对她说\"\"我爱你\"\"，当然她也不再对他说\"\"我也是。\"\"一天晚上，他们谈到了分手的事，背对背睡下了。半夜，天上打雷了。第一声雷响时，他醒了，下意识地猛地用双手去捂她的耳朵，才发现不知何时他又拥著她。雷声紧接著炸假装什么也没发生，可谁都没有睡著她想也许他还爱我，生怕我受一点点吓。他想，也许她还爱我，不然她不会流泪的。爱的最高境界是经得起平淡的流年。\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('328', '2000', '有的时候真的不知道怎么办,他为什么来找我?很无奈,那也就算了,为什么还要在外面到处说?有时真的觉得他把我的仁慈当资本...是不是很狠心?很坏?他自找的,⒊方⒌次来找我,让朋友那样说我?不喜欢还要和他扯在一起!真的很没办法,让我狠心叫他走,骂他..我做不到,那样很绝情..虽然他已经说我很绝情.....不想让他难堪,可是为什么他就是做得越起劲?有的时候真的让我没有余地退让...做事不想做得太绝,却让人把谣言传得满天飞,觉得他口好多,到处说,这是我最不能容忍的事,让人看到我就用一样的眼神看着我,好像我是什么怪物一样,...真的受不了了啊,,', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('329', '2000', '[FACE=宋体', '记事本陈慧琳翻开随身携带的记事本写着许多事都是关於你你讨厌被冷落习惯被守候寂寞才找我我看见自己写下的心情把自己放在卑微的後头等你等太久想你泪会流而幸福快乐是什么爱的痛了痛的哭了哭的累了日记本里页页执着记载着你的好像上瘾的毒药它反覆骗着我爱的痛了痛的哭了哭的累了矛盾心里总是强求劝自己要放手闭上眼睛让你走烧掉日记重新来过----------------------------------为什么????强烈的近乎淡薄~~想笑却笑不出来..想哭却发现眼角早已干涩..', '', '');
INSERT INTO `dede_addonarticle` VALUES ('330', '2000', '呵呵~!今天有下雨哦,不过今天很高兴,家里搬家,龙来帮忙,真的[FLY][/FLY]很开心,他一直照顾我,帮我干了好多活,要不染我要自己干好多呢.我知道他很累,我们都很累啊~!妈妈今天很高兴呢因为龙很乖~!我也一直很乖呢~1哈哈我真是好孩子,有个爱我的好男人~1今天有件事值得一说哦:龙问我,知道我今天干这么多活为嘛吗?我说:为嘛?他说:为了让你以后好好爱我~!~!~!好感动哦~!然后我就跟他通宵来了~!很困,可是还想跟他在一起.就来了.呵呵!今天他说跟人家视频,看人家了.我。.....我居然哭了?!都不知道怎么了,怎么现在这么脆弱?唉~!这就是爱啊!呵呵!一天不错啊~!', '<font color=#ff00ff>记事本</p><p> 陈慧琳 </p><p> 翻开随身携带的记事本<br> 写着许多事都是关於你<br> 你讨厌被冷落<br> 习惯被守候<br> 寂寞才找我<br> 我看见自己写下的心情<br> 把自己放在卑微的後头<br> 等你等太久<br> 想你泪会流<br> 而幸福快乐是什么<br> 爱的痛了<br> 痛的哭了<br> 哭的累了<br> 日记本里页页执着<br> 记载着你的好<br> 像上瘾的毒药<br> 它反覆骗着我<br> 爱的痛了<br> 痛的哭了<b', '', '');
INSERT INTO `dede_addonarticle` VALUES ('331', '2000', '[MOVE][/MOVE]我在网拔,龙在旁边.心爱的人也在就是感觉不同.赶紧解决不必要的纷扰吧,好好的爱一个人是件好事呢~!呵呵~!啊娇现在满足与生活~!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('332', '2000', '这个星期我做了一件错事,就是冤枉了她不知道她会怎么想,虽然我道过谦但心理依然很抱歉,我这个人就是一点不好就是不问原因就是会发火,嗨~~~~以前想改过但....失败了~~!!我还骂了她,对不起~~~!!还有你根本不用为了你弟弟向我道歉,即使我在怎么火我也不希望你来道歉因为根本没用,我看不惯的人不管谁来说都没用,他什么东西,你喜欢谁用他来说什么,你喜欢就喜欢不喜欢就不喜欢,他在那干什么,当他自己是什么啊~~~你是他认的姐姐又不是他亲姐姐,也不是他女朋友用不着他在那左右你~~~~还有你问我爱情能永恒吗?我告诉你能，只要一个是真的爱,我只能说这么多你自己好好想想吧~~!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('333', '2000', '记得yy和我说过..只要你以后回忆起这段不会后悔,不会觉得不值就好..我从未后悔过可现在开始觉得不值了..倒不是为自己不值...感觉他现在过的一点也不好..自己当初的伤心难过真的很没价值...如果他能开心..幸福当初我承受的哪怕再多千倍万倍也是有意义的啊....可事实...........................', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('334', '2000', '我们应该以怎样虔诚的目光来迎黎明,抑或用怎样残酷的姿势来扼杀朝阳.现在sky也许还颓废的坐在电脑前,凌乱的头发垂下来遮住了忧伤的脸,眼里永远是大雾弥漫没有亮光.现在的我也许开始麻木,不会在再对身边的人和事懦弱的掉下眼泪,我懂的隐藏温暖,只把它们留给我喜欢的人和我爱的朋友.是不是真的长大了.曾经说过你是我生命中最大的温暖,曾经说你是我活下去的勇气,曾经说是你让我面对这个世界不会再仓惶,曾经说要和你做不离不弃的朋友,现在对我来说却已经疼痛而没有意义.我开始一直在想等有天我们都长大了.长的很大很大了,我是不是还可以重新的牵起你的手,告诉你你还是我生命中的温暖,只是那一天对我来说,早以遥远的看不到亮光,早在我们选择彼此放弃的那一刻,所有不可原谅的错都不可以重新来过,而我也摇头说要放弃...让我们在寂寞的风声中悄悄的长大,然后是凛冽的遗忘.时间是最大的治愈师.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('335', '2000', '从来没有想过时间可以过的这么快,那些逝去的年华一幕幕流光彩溢,那些难过的忧伤在我的瞳孔里清晰的毫发毕现.想起帆帆白衣如雪的样子站在车如流水马如龙的大街,想起莉子清澈而明亮的笑容,想起自己在很深的夜晚坐在地板上喝很凉的矿泉水,听液体流进喉咙发出寂寞的声音.一些回忆关与sky记的那天她上课给我发来短信,她说,我来你这里好么,我说,行啊,我来接你吧,她说我是离家出走,你还要上课了.我说,我逃课接你,后来,我的手机没电了,就在那天晚上吧,她告诉我,她退学了.奇怪的是我并没有感到太多的惊讶,然后我去看了那个她说曾经让她流了眼泪的机器猫的结局,我问她如果我哭了,你,信,么,她说相信,然后,我就下线了,心里的难过一阵一阵荡漾开来.第一次见到sky就觉的她的眼睛很亮很好看.现在还一直记的她教会我的事情,她说,你可以对朋友推心置腹但不可以孤注一掷,生活还是绑在自己身上好,想起她披上外套时温暖的眼神,还有孤独桀骜时拒绝别人的一切温暖,任性的象个小孩子,总是一个人去面对所有的困难到最后伤的遍体鳞伤.希望有一可以看见她的笑容.冰冰一直希望可以为她圈出个安静的世界,让她亮亮的眼睛散着如同北极星班明亮的光辉,看到她干净而温暖的笑容,告诉我,她很幸福,这就够了..以前很早的时候就写信告诉她,我是多么的想去日本,可现在才知道那里有很密集的群楼大厦,跟本看不到地平线的方向,听说站在看不到地平线的大地上的人,会觉的人嘲汹涌而没有朋友,所以我一直很想告诉她,有一天希望她可以陪我一起去,去看看北海道雪花飞扬的候是落在了名古屋还是永无乡,去听听世界上最寂寞的雪景.现在还记的曾经在很深的夜晚给她写过很厚的信,曾经偶尔和她的吵架和生气,曾经送她回家的那一段干净的柏油马路,曾经陪她在街上荡了一下午,曾经给她买过一次早餐,曾经送她的几本喜欢的书,曾经,曾经,我曾经的生活.记住,即使是地狱我们也要一起去猖獗.茨很早就知道你不是那总很快乐的人,笑的比谁都开心其实比谁都落寞.很喜欢你的那句话喜欢的就该珍惜,可是你不知道有时候放弃也是一种幸福.希望你好好珍惜身边的朋友,有自己朴实而简单的小幸福.我不会再颓废,你,也一定要好好的,一定要.le我真的去日本那天你要给我出钱啊b那天进了我很久没有用过的日记本,很突然的看到了他在该很早以前给我发的邮件,心里有了莫明的感动,我想,我不会再在酶涩的雨季彷徨,你也一样.小妖那天看见她,我说好久没见你上线了,她说,我要高考了,我说,我要中考了,然后就是沉默.记住我等你的好消息.zhangpeng熬完这个月我想我就可以以来你这边了,你要记的等我,恩,我会好好复习,我会的.现在想起朴树的[那些花儿],想起他干净没有任何杂质的嗓音.那片笑声让我想起我的那些花儿在我生命每个角落静静为我开着我曾以为我会永远守在他身旁今天我们已经离去在人海茫茫他们都老了吧？他们在哪里呀？我们就这样各自奔天涯啦……想她。啦…她还在开吗？啦……去呀！她们已经被风吹走散落在天涯有些故事还没讲完那就算了吧那些心情在岁月中已经难辨真假如今这里荒草丛生没有了鲜花好在曾经拥有你们的春秋和冬夏啦……想她啦…她还在开吗？啦……去呀！她们已经被风吹走散落在天涯他们都老了吧？他们在哪里呀？我们就这样各自奔天涯', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('336', '2000', '我知道一切都是梦,都不能成为现实,至少现在不可以.我上网这么长时间了,从来没遇到过像他一样的网友.和他在一起聊天的感觉真的很好.似乎我们离的很近,但却又是那么的远.我很想在现实中也能和他在一起,就像在网上那样,那该多好啊,可惜现在这是不可能的......所以我只能等,等到我上大学以后.我一定会努力的,就算为了他,同时也为了我自己.希望上天能够成全我.希望我们会有缘分的.所以我等.........', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('337', '2000', '~~~~▁▂▃__　　　﹋　　　　__▁▂▁___﹀●很想和你~﹀~﹋﹀一起看海！█▆▅▇▆▅▄▃▂▃▄▅▆▄▅▅▆█-__~~--___-▔~~__--__----什么时候！能找个人~~能陪我去看海....找这么一个人.可以和他到天荒到地老,到天涯到海角.........', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('338', '2000', '在2005年5月16日,我在劲乐里认识了一个哥哥.他比我大3岁,很喜欢飙车,技术也是棒棒的!他对我好好哦.第一次有一种,很安全的感觉,我想这也是我寻找了很久很久的感觉.我好喜欢那个哥哥,是妹妹对哥哥的那种喜欢,他对我比我亲哥哥对我还好!今天晚上8点半左右,下雨了,我感觉到哥哥会有事,连忙跑出去打电话.结果,哥哥真的出事了,他骑车的时候,因为下雨路滑,摔了一跤,我好担心,但是我又不知道该怎么办.只能要哥哥好好在家里休息.希望哥哥快点好哦!和靓在一起,觉得好累好累.真的有想法不想和他在一起了,我真的在想,我当初的选择是不是对的?有个那么好的男生对我.我怎么放弃了?我还在想，那个时候的我,脑袋是不是秀逗了?!诶..不过呢,竟然已经选择了他,那么我就不应该后悔的!爸爸妈妈现在这个时候,又闹离婚,都老夫老妻了,还离个什么劲?诶..可惜我这个做女儿的,又不能管爸妈的事,还说什么.小孩子不要多管大人的事!诶..真的好烦好烦!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('339', '2000', '再过5天,我就生日了,就满18岁了,我就成年哒!不晓得等待噶天等哒好久!真滴是等的我好苦!!18岁了,该懂事了,不能再像细别一样哒!现在我却面临一扎问题,郁闷乃!算哒,真滴躁,不写哒!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('340', '2000', '今天晚上哥哥不在这里,觉得时间过的好慢好慢..哥哥摔伤了.在家里休息,我在网吧里,玩什么多觉得没有意思,总觉得好象少了什么一样...不知道哥哥现在怎么样了,肯定很不舒服..我好担心..他虽然不是我的亲哥哥..但是给我的感觉却是..像亲生的兄妹一样..我和他才认识没一个星期,但是却有几世的兄妹感情那么深...也许上辈子,他就是我的哥哥!我好难过,不知道为什么..觉得哥哥不在这里..做什么都没意思...好困...哥哥在这里的时候,精神不知道有多好!诶...哥哥..你要快点好哦!一定要快点快点好哦!我明天去寺里给哥哥求个平安符!保佑哥哥以后不会再有事!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('341', '2000', '\"不知不觉中..我想起了那时在学校的时候..那个时候,在学校军训的时候,认识了一个男生,一个很孩子气的男生!他好有趣.总是想办法让我笑..真的好怀念!他连吃饭的时候,都端着碗看着我吃,害我在朋友面前.脸红了好久..看着他睡觉的样子,好可爱...朋友介绍了一首歌给我听..我觉得那首歌好适合我..\"\"如果我们现在还在一起会是怎样.我们是不是还是深爱着对方?像开始时那样,握着手就算天快亮......\"\"恋爱那么多次,第一次感觉到抱着一个人的感觉是那么的舒服?!第一次感觉到,被一个人抱着是那么的幸福!?可惜,这一切..只怪我不去珍惜..而让他就这样的离我而去...过去了那么久..我仍然还记得那时他抱着我的时候,那种好安全,好幸福的感觉..现在我才知道,原来爱情可以那样美好的!原来爱一个人并不需要语言的..只要两个人就那样轻轻的抱着..就可以代表一切...好想他再抱我一次..就一次..好想再有一次那样的感觉..但是..晚了..后悔也来不及了..所以我对自己说..不要再有一次后悔..珍惜现在所拥有的幸福...如果可以..我希望你再抱我一次..好吗?\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('342', '2000', '哥哥又去比赛了,担心吖..不过还好,至少他昨天摔伤的地方应该好了,不然他哪敢去比什么赛?我只希望哥哥能成功赢的比赛!!今天的心情不怎么好,再加上靓的不守信用,让我的心情更加不好!真的不知道为什么.觉得好烦!他去打牌,把我要过生日的钱都输掉了,我怎么可能不烦躁?怎么可能不郁闷?我想打人了!!!今天晚上差点就直接提着行李闪人了!但是后来竟然睡着了?这是什么回事??我搞不懂我自己在想些什么,我有想法过了18岁后,是不是要考虑一下自己的事情了!好烦吖.!!!!!!!!!!!!!!!!!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('343', '2000', '亲爱的“猪”老师：我只想告诉你你当老师很失败！~至少我是这么认为的知道把？我极端bs你！~也许你早忘掉9月17号的数学课我不会忘记！~fuckyou当时我是想给你留个面子`我没有还手你妈妈的你现在跟我比话比话你吗你看你那比样跟个女人一样！~你问哈你在我们班有谁而是你猪孜孜咳呀！~我起的很，么办法就只能佛了写脏话！~我觉得我忽忽你都是侮辱我！~我会和你奋战到底的！~傻比数学老师！~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('344', '2000', '我今天上了一天网碰到n多人么话了伤心的呀和妞吵了我也不知道是撒原因因为我就不知道发生了撒事情无帮之外还有什么？我是一直把妞当做死党有时候看到她在线么说话我会想她不而我我会主动佛话今天来咳！~提不成！~做不成朋友就算了么求行一个人网络着东西这么虚幻！~有多少是真的》自己付出真实的感情被这样亵渎么话了对话：我退群行了吧~？满意了吧！！退毛seeyou！！88退了以后在表近来我不稀罕！凸﹎睡撹灚(119300513)15:33:26。。。。。。。。。。。。我日。。还列个英语。。彬彬你好了撒吼凸﹎睡撹灚(119300513)15:33:43。。。。。。。哈。。。。凸﹎睡撹灚(119300513)15:33:49本来撒。。他就是。。。。。老子和你骂完`在走``你妈妈比``凸﹎睡撹灚(119300513)15:34:01在偶面前还列英语呢。。。哎。。愁哈地。。你个贱比``不骂你``你养的很是吧你都是个求``老子佛英语和你有求上关系吗``凸﹎睡撹灚(119300513)15:34:54你慢慢骂。。。。你姿是个比贱``你个有人生么人养的``比贱呸子`~~凸﹎睡撹灚(119300513)15:35:04偶今天么心情和你吵哎。。。呵呵13就是13哎呦``就你还心情？我呸你以为你是tmd什么东西转世是吧`也不看哈你那比动静``都退一步？彬彬？13你配和我呼喊吗`？你以为你是个撒``你让我日你```我都显你脏！你个脏比！！！玩求时尚你`~~~野比！来啊继续``你比嘴上不是唠叨的很吗``复活``呼吸~~喘气啊```来啊``gogo！！！咳呀13娃娃比群了你给我比邓紧！！！！么你佛话的份！你佛我的呢？我骂完就退了！你也别激动！！你看我不顺眼吗`等哈把我从你qq删给·！你勺的呢么我把你杂么热哈了又我就是勺的呢```````我看你不顺眼？那是你多余的想法我给你佛', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('345', '2000', '五马分尸是一中解脱，虽然有些残酷，但却因肉体的四分五裂避免了拥有来世，活者是一种罪过，我用坚强伪装着自己，心却暗淡到了极点，我把自己的青春情怀用三年的时间装饰成一个的梦，他的一个眼神，便注定了梦的破灭，我颓废的连走路都有些蹒跚却没有理由去休息一下，无论心有多痛，在学习上是不能松懈的，这个年龄我懂得了负责，也分得出轻重，我怎能因内心的失落而逃避责任呢？尽管充满激情的我渴望五彩缤纷的感觉，但我别无选择．[/size]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('346', '2000', '好可惜...我的18岁生日不能请朋友们玩了!家里出了事..害我不能办生日会!....555555555555555555从我的懂事的时候,我不知道等这个日子等了多久,结果却是...气死了拉!但是我又不能说什么..诶...好希望我可以办成生日会.我想喊我的哥哥,我的朋友,一起唱唱歌,喝点酒,一起玩下!疯狂一次!好不容易18岁!终于成年了,本来想去酒吧里的,但是后来想想,还是去唱歌的好,一边唱歌,一边喝酒,但是现在我的希望就此破灭!好烦吖!!!只希望到了那天,可以有点转变!诶....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('347', '2000', '听到爸爸在外面有外遇的事,我觉得一点都不奇怪,因为在爸爸这个年龄的男人,会有外遇是肯定的,因为男人在40岁的时候,是他们的第2度春期,会有外遇一点也不奇怪...只是对妈妈来说,无疑是个打击,就算心胸宽阔..也难以忍受这样的事情!在小的时候,看过很多婚外恋的事情,结果都是社会不认同,家庭破裂,在那个时候,我就很怕,怕这样的事情会发生在我身上,没想到的是,这样的事情真的发生在我的身上..我现在才知道,一个美好幸福的家庭突然消失了,那种感觉真的好难过,虽然说,爸妈现在还至于离婚,但是如果事情继续发展下去,离婚是迟早的事情..我真的好怕,好怕..怕爸妈会离婚,我不想一个幸福的家就这样破裂...如果可以..我希望爸爸回来..我不要他离开!也不要妈妈离开..两个在一起不是很好吗?为什么要这样呢?一家人开开心心的过..不好吗?一定要分开吗?我不懂..爸爸为什么这样?但是我不恨爸爸..他一定有他的苦衷,但这样不是对妈妈很不公平??我祈祷..我的爸妈不会离婚..他们会和好!我还是有个幸福的家!有个疼我的爸妈!我乞求,上天不要我这样一个小小的愿望给剥削掉!在18岁生日,我的愿望是..我和爸妈和哥哥永远在一起..谁也不会离开!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('348', '2000', '\"漫步在河畔...我的感触好深...觉得这个世界真的好现实...让人害怕..每次在我想起以前的事情时..总是会想起自己受伤的事..现在我才知道,原来我并不坚强..我很脆弱....我怕..我怕一切的一切!但是我又无能为力!为什么童话故事可以那么美丽?为什么那些神话故事可以那么美好?呵...我忘了,那些都是故事...故事就是故事..之所以那么美丽..是因为..那是人们所编出来的\"\"故事\"\"从我恋爱开始..我就不断的受伤...但是我从来没有说过什么..别人说..是因为我的性格好..不会去计较一切..真的是这样吗?也许吧...如果可以..我希望以后都不要再受伤..感情,亲情,还是其他,我都希望不要再受伤...我想好好的平凡的过完这个一生........现在我有个疼我的哥哥,有个爱我的男朋友,只希望以后仍然是这样的下去...我还希望这一次18岁的生日会可以办成!!\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('349', '2000', '哎.今天我那个日记本上不去哦..就暂时用这个日记本吧.!哎..今天下午我才惨..竟然...把初吻送给了一条狗.!!!啊啊.完啦...呜..我连自己最爱的人都没送.就送给了叶鸡百的狗.!!!!!!!!!!!!!!!!!!!!555..死啦.......................好啦.我我我没心情.不写了.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('350', '2000', '一连下了几天的雨了,我的心情好像这阴雨天一样郁闷,最近总是遇到让人不如意的事情:生日会办不成,家里爸妈的事又让人头痛,家里还欠22万,两个人在一起越来越不顺......真的好头痛,到底有没有什么办法可以解决的呢?18岁的成年生日都过不成气,感情生活也越来越多的烦恼,我好烦啊..但是他却一点也不知道...为什么他从来不会站在我的立场为我想一想呢?为什么他从来就不去在乎我的想法呢?为什么为什么为什么为什么为什么.............???我从来没有像今天这样烦恼过,从来没有像今天这样郁闷过!做什么事都不顺心,做什么事都不如意!我怎么会这样???难道没有人来关心一下我?没有人来问下我的想法是怎样的呢?头好痛,觉得这个世界好象在不停的旋转,不停的旋转,转的我好晕,头好痛,我不知道要怎么办才好,我真的不知道要怎么做了!!!!谁可以告诉我,到底要怎么做??这个时候要是有个人愿意听听我的心事,那就好了..至少我可以有人倾诉,至少我不会再烦恼!!好烦吖..............', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('351', '2000', '有一段时间爱上了幸福。喜欢坐在咖啡点靠窗的位置看陌生人犹如看电影。在下雨的时侯把手贴在窗子的玻璃上而感受水气。小心地从水坑边跳过而裤脚总有泥巴。把手伸给路边算命的小瞎子他说你的生命太短且崎岖。放学的小孩子像夏日正午跳过树叶的阳光。领家的老奶奶煮新成熟的玉米散发出好闻的味道。傍晚了，母亲说回家吃饭。还有一段让我感动过的文字。日记六十七；这一天我终于来到了布达拉宫，我心仪已久的地方，神秘而古老的土地。我这两个月穿越了大半个西藏，然而，在见到布达拉宫的时，我被震撼了。这种感觉是我路过其他任何地方的时侯不曾有过的，也许我以后还会按我着我的行程路线去珠峰，去啊里，去青海湖，但是，我想这种震撼不会再出现了。我不知道该用怎样的言语来表达我此刻的感受，兴奋？激动？也许文字是不能记录我此刻的感受吧，它神圣，清静，我看到朝拜的老人虔诚的祈祷，我看到宫殿外的喇嘛手里拿着糠粑和酥油茶在食用。那天晚上我彻底的失眠了，我望着夜空中的星星久久不能平静。还有一段；你告诉我你是如此喜欢JJ的[江南]，喜欢那里的萧声，风声，水声还有古琴的声音，你说真正好听的音乐是思想随着鼓膜的震动而被唤醒，而那被唤醒的思想随着音韵，带着自己的情感飞越高山峻岭，掠过五湖四海，穿过浮云凌宵，西息在心灵的安寂。这个哪看的？我要写啊写啊写啊在开学之前初三之前怎么也要写点什么我不管安妮说什么写作是趟漫长的自杀是一个死亡的过程我只要证明我没有被教育这条河冲的象河卵石一样我只要证明我有足够的才华且才华横坚都溢我不需要爱不需要一场乱七八糟的初恋我不需要一桌子的教科书漂亮的分数我不想对看同学却明明没有话讲我不想对老师不停的微笑除了驯服我们一无所知这不会是真的不会我怎样不相信但是现实如此切，这到底什么跟什么啊？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('352', '2000', '到头来还是想不出晚上该吃什么……人为虾米会饿捏……晚上似乎只有2个小时看书了……我到底在想些虾米啊……混乱中……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('353', '2000', '今天真的好难过啊!高考就要来临了,不知是什么心情?有一点恐慌,也有一点的害怕.世界上有谁是我的呢?我的学习,我的情感.我很难过!爱情是什么呀?谁真的知道呢?我有些恐慌?他们怎么可以这样呢?一个人到底能爱几次呢?一个人可以在不同时间和另一个人说一样的话,是吗?世上还有真正的爱情吗?对这些我已经有些失望了,不知道是谁让我这样的无助啊!我想现在我可以对他们好一点的,我希望我们是好朋友的,我希望我们还和以前一样的,但谁知道呢?我不知道他们是怎么想的.虽然我是单纯的,但我决不会让自己再受伤了.因为心痛好怕!我不要再心疼了.我一再告诉自己,你应该坚强一点,你可以的!你是可以的.你离开他们/她们可以活,不是吗?只是痛苦一点,但你还是要坚强的.不是吗?爱情是要负责任的,不是吗?难道是可以随便的吗?哦!至少我不是这样的认为的,我为自己还是这样,没有变而骄傲.无论到什么时候,我也还是一样,一样的坚持.对于爱情的严肃,这也许就是我自己吧!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('354', '2000', '好想走进你的心中去，去了解你的世界，你的生活。可你我却只能这样的交流通过虚幻的网络走进了真实的彼此的世界，好久没有你的消息想你想的快疯了自己', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('355', '2000', '今天是我的生日,结果我却没有过的成..从来没有像今天这样狼狈..不但生日没过成..连一份礼物都没有收到..最后只能在网吧里度过...从13岁起,我就一直盼望着18岁的成年生日..没有想到的是..却是在这样的情况下度过..哥哥今天晚上的飞机去了深圳..我更加难受..本来就没有什么朋友,想喊哥哥一起陪我过生日..结果他去了深圳..难道我今年的生日就这样不了了之??我不要..我不要就这么过了算了..为什么要这样对我??我犯了什么错吗?要这样对我?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('356', '2000', '2周的实习终于结束，也就等于……下周开始要受苦了，3000多字的论文也没底，本来上网来查点资料的说，可是对着电脑却一点事也不想做，也许是夏天来临人也变得庸懒，也不想吃东西，2星期没去食堂吃饭，晚餐终于又爬去那边……结果是，一点胃口都没有，昨晚失眠的很厉害，几乎睁着眼到天亮，膝盖不知道什么时候受了伤，结了疤一直有点发痒……半夜爬起来摸了点药擦上，只是没什么效果，不仅想……难道我的神经真的那么大条==///去公司听报告的时候，很可怕的发现一个事实，我晕电梯……默……本来恐高我已经很无力了，晕车我也认了……为什么连电梯也晕……我已经可以想见就算以后做了喜欢的工作也许也不能做到每天都开开心心吧……五一回来之后似乎已经过了2个星期多了，爸妈没有打电话给我，我也……没有打回去，我似乎是很容易为一件事情就烦恼不已的人，每个人生活中都有需要的人或是能找到自己被需要的人，可是我……好烦躁，别人想接近我的时候我逃避，当整个世界只剩下一个人的时候，又觉得好闷好闷的感觉……我似乎从来没觉得自己有幸能活着一样。暑假，老妈说带我去看病，这个已经被我推了3年了，高中的时候就一直说着要去，结果每次都因为这样那样而推迟……最近一阵子，我明显感到自己的身体很难受的样子，胃痛也比以前频繁，自己对于这些根本不是很在意，可以每次躺在床上想起小学的时候爸爸为了给我送早饭，一路追到学校里，不管我在上课冲进教室把早餐塞到我手里。初中的时候又亲自打电话给班主任……那次，是我这辈子印象最深的一次，我第一次在老师面前哭，就因为班主任说：你希望你爸爸看着你承受和他一样的痛苦吗？……我哭了，那天我整整哭了一天，班上的同学一直到现在也不知道原因，回到家我也不知道是怎么面对爸爸的。我很清楚，爸爸因为胃病的原因让我们整个家失去了多少，一个国家兴盛到衰败也不过如此，此中经历的世态炎凉也许是我这么早熟的原因吧，我虽然从来都不曾跟他们说过自己的想法和感受，但是心里去知道的一清二楚……我知道自己很任性很无理……我真的以为他们没有我也许会更好……我永远都让他们失望，不管我多努力，可是，他们却一再相信我，鼓励我，给我机会……只是，这只会让我自己越来越讨厌自己……不要对我那么好，我根本就不值得啊……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('357', '2000', '\"心情日记使用指南一、使用通则1、如果你注册了日记，在登陆之后，在下边的菜单栏点我的日记，就可以看见你的日记首页。你会有自己的单独的日记首页地址，比如我的日记的地址就是book.asp?user=流言无痕。这个地址在进入你的日记后最上边可以看到。你可以把这个地址发给你朋友，这样你的朋友就可以直接访问了。2、注册了日记后，会有很多个性化的东西可以修改。比如你的日记首页封面、你的日记首页的公告、你的日记首语等等，包括其他性别资料等都可以修改(呵呵，性别也可以改)。3、注册后登陆后，在下边的菜单列会有日记本管理，你可以进去修改资料。二、日记详细说明1、日记封面是指你的日记首页上的图片，你可以自己选择系统提供的图片，也可以按规格做好，用自己设计的。2、公告是指你的日记首页右边的告示，首语是指你的日记首页的心灵告白，位于你封面图片下边。这些都随时修改。3、写日记请登陆你的帐户，就可以实现了。修改和删除日记在你的日记列表上有。4、写日记的话，你可以选择公开与秘密。公开就是如果人家来访问你的日记人家可以查看你的日记；秘密就是你的日记只有你登陆后自己看到。5、写日记的话，可以选择为每篇日记选择图片，以切合日记的主题和你的心情。6、写日记的话，自然要选择天气的啦。三、发帖功能介绍1、日记中，如果需要对日记某部分设置颜色、字体与大小，其实很简单。就和word等软件中一样。先选好对象，再选择颜色、字体与字体大小。2、一些如加粗、斜体、下划线功能，一些如飞、移、光、影等字的效果，都是要先选定对象，然后在做相应的动作。3、如果要插入链接、图片、音乐等只要按系统提示做就可以了。但要注意的是，一定要保证你的地址有效哦。4、另外还有一些可爱的心情娃娃可以使用。会继续加入新的。最后，希望大家多提意见。也愿心情日记能记录你的生活点滴，真正给你带来快乐与帮助。日记音乐功能使用介绍增加了音乐功能.下面对功能与使用方法进行说明,大家快用哦。1、登陆你的帐号之后，在写日记下面就有管理音乐的按钮了，如下图。点击进入音乐管理。screen.width-400)this.width=screen.width-400\"\"kesrc=\"\"/diary/help/music1.jpg\"\"/>2、进入音乐管理界面，左下方就是音乐添加版块了。如下图：screen.width-400)this.width=screen.width-400\"\"kesrc=\"\"/diary/help/music3.jpg\"\"/>3、一般帐户都还没有添加歌曲的，所以你在音乐管理界面的右上方看到的是下图：screen.width-400)this.width=screen.width-400\"\"kesrc=\"\"/diary/help/music4.jpg\"\"/>当你添加了歌曲之后，就应该是这个样子的了，如下图：screen.width-400)this.width=screen.width-400\"\"kesrc=\"\"/diary/help/music5.jpg\"\"/>4、如你所见，上图中有个选择是否自动播放，它的意思是你是否设置，进入你的日记首页歌曲是否自动播放，如果选no，那就要按播放才能听到歌曲。建议选择是。那人家一进你的日记，就听到你的歌曲啦。5、同样如你所见，上图中有个按钮固顶和卸顶。固顶的意思就是让这首曲子第一个播放。卸顶当然不是秃头啦，而是取消起第一个播放。6、在我们的日记界面上方就是播放器了。如下图：screen.width-400)this.width=screen.width-400\"\"kesrc=\"\"/diary/help/music6.jpg\"\"/>见到红圈圈中的曲单没？点击曲单，就可以进入你的曲单系统，就可以选择歌曲听歌了。其他说明：1、音乐功能可以添加mid、mp3、wma三中格式的音乐。其中mid格式是曲子，没有人声的音乐，适合做背景音乐的，下面会详细介绍。mp3和wma是一般的歌曲。2、心情日记特地搜集了一些很好听的mid钢琴曲子，很适合做背景音乐，你可以添加进你的曲单，设置为固顶。每次进你的日记，就可以听到这首背景主题曲了。mid曲单从音乐管理界面的右上方进。3、关于歌曲地址。一些mp3与wma格式的歌曲，需要大家自己上网搜索，找到地址，添加进来就可以了。地址一定要一http;//开头。4、设置之后，记得刷新才立即生效哦。日记主人机密档案功能介绍1、在资料修改里，你可以看到增加选择机密档案是否显示。默认为隐藏。screen.width-400)this.width=screen.width-400\"\"kesrc=\"\"/diary/help/jimi1.jpg\"\"/>2、如选择了显示机密档案，那么有人来参观你的日记工场的时候，就会看到，机密档案按钮，点击进去就可以看到你的档案了。screen.width-400)this.width=screen.width-400\"\"kesrc=\"\"/diary/help/jimi2.jpg\"\"/>3、进到机密档案后，可以看到如图，里面有你的资料，还有你的qq号。如果你喜欢人家和你交流，那么就可以加你qq了。screen.width-400)this.width=screen.width-400\"\"kesrc=\"\"/diary/help/jimi3.jpg\"\"/>日记中心推出强大日记管理系统.增加项目为:1、高级用户写日记图片上传功能，高级用户必须为日记超过30篇日记以上的用户。2、日记显示分全部日记、公开日记与私人日记。方便查询。3、将个人资料修改分成人物属性与日记属性，方便管理修改。4、增加日记主人形象选择，以后会增加日记主人可以上传自己的照片。期待————5、为日记主人提供小工具-记事本本。方便大家可以记录常用的东西，比如一些用户名呀。密码呀。6、增加网痕书签，可以保存整理自己的一些喜欢的网址，只要可以上网的地方，来到日记中心，就行了。7、准备了一些小小休闲游戏。比较有趣的。总之还有很多的改进，等待你的尝试哦。如有什么问题，请联系我们。其他新功能陆续增添中——thanks七日记\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('358', '2000', '我都不知要说什么啦?我有好多话要说的,我要对你说谢谢的.还要说的是你的问题.我一直不知为什么?对你产生了好多的疑惑,你相信爱情吗?你觉的一个人一生可以爱几次?你怎么看这个问题的?可以说说看吗?我虽是你的妹子.但我们还是很陌生的样子.不是吗?我们好就都没有好好的聊一聊,是吧!对于这些问题我都不太愿意多谈.因为我想我们都是理智的.你是吧!也许我太要求高了!不完美的人要求完美是残忍的!@不是吗？也许你清楚你在做什么？我只是在这发一发感慨罢了！是对爱情的感慨吧！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('359', '2000', '[em38]快高考了，一天一天的逼近了，我好害怕．我现在不知道是怎么了？我期待着飞翔期待着去寻找我的梦．我的纯真的梦．我是可以的，我在给自己打气．害怕自己会卸气．给自己勇气去飞．去闯．哪怕是会头破血流也再所不惜．我的青春尚在啊！我正因为年轻所以我才有机会反错，我才有机会去闯．我不会怕．我是可以的！我要感谢我的朋友们，是他她们给我勇气．给我力量，给我我所要的那种支持，我所要的动力．我要感谢我的父母，是他们给我我飞翔的翅膀．我要说谢谢！就算自己输[em47]自己累[em47][em47]都还要努力', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('360', '2000', '‘晴天娃娃’就让雨下下来,不用带伞,让一切完蛋,看被淋湿的心情多久才会晒干,爱你是场灾难,新的感冒比地震频繁,用发烧的脑袋治疗所有不安,当爱情不再晴朗不再灿烂,就顺其自然,我期待晴天娃娃召唤太阳,让爱情盛开..鮭鮭o.s.bymaywu', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('361', '2000', '无聊中.....写一些乱七八糟的东西,希望大家会喜欢,呵呵!“墜落啲兲使”1989.农历9月26,阳历10月25,可爱天时坠落人间.小名叫希希,至于为什么叫希希,她自己也不知道,是爷爷给她取的.爷爷特别宠爱希希,可是希希只会带来灾难,就在希希1周岁的时候,她害死了爷爷,最爱她的爷爷....“兲使vs恶魔”不知道是不是上帝惩罚了天使,让她跟一群小恶魔生活在一个院子里,小恶魔总是欺负小天使,小天使很爱哭,老是找姐姐,虽然姐姐会来救小天使,可是姐姐她还要上学,不可能总在小天使的身边,小天使有着很长的头发,喜欢扎着两个小辫子蹦蹦跳跳的,可是她的头发却成为了她的负担,每次跟恶魔打架的时候,他们就会拉住她长长辫子,痛的让她眼泪直流,妈妈知道后,带着小天使把头发剪掉了,妈妈还告诉小天使要学会坚强,不可以在别人面前哭,你越哭别人就越觉得你好欺负,走到镜子面前看着自己,眼泪还是刷的流了下来..头发短了,小天使不在害怕恶魔,不再哭着到处找姐姐,虽然小天使还是打不过恶魔,但是她很听妈妈的话,被欺负的再惨也不会在那群恶魔门面前哭,反而恶魔再她面前哭的次数多了起来...“恶魔再见”就这样一晃几年过去了,小天时也可以跟姐姐一样背起书包上学了,而且没有人再欺负她了,因为天使和恶魔成为朋友了,然后没多久小天使就要搬家了,要去一个很远个远的地方..搬家的那一天,小天使坐在大卡车上,突然恶魔门一个一个冲过来,问可不可以留下?小天使摇摇头,他们叫小天使把手伸过来,于是她就把手伸过去,恶魔们把自己最心爱的玩具送给了她,小天使哭了,恶魔们也呆了,因为她从来没再他们面前哭过....呵呵...游戏下载好了...玩游戏去咯..明天继续.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('362', '2000', '[FACE=楷体_gb2012][/FACE]呵呵~！现在在机房哦~1吹着冷气，上着网。哈哈，很舒服哦！如果生活一只是这样那就好了~1希望生活一直的无忧无虑~！我们一只好好的生活不去想那些不必要的困扰。有些爱情~！~！~！或其他~！其实也是蛮舒服的。因为世界有爱~！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('363', '2000', '翻着我们的照片,想念若隐若现,去年的冬天,我们笑得很甜,看着你哭泣的脸,对着我说再见,来不及听见,你已走得很远,也许你已经放弃我,也许已经很难回头,我知道是自己错过,请再给我一个理由说你不爱我,就算是我不懂,能不能原谅我,请不要把分手,当作你的请求,我知道坚持要走,是你受伤的借口,请你回头,我会陪你,一直走到最后,就算没有结果,我也能够承受,我知道你的痛,是我给的承诺,你说给过我纵容,沉默是因为包容,如果要走,请你记得我,如果难过,请你忘了我..借口爱情其实就像仙人掌,不用给它浇水施肥,只要把它放在阳光下,就可以开花,但我仍然忽略了它浑身长满了刺..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('364', '2000', '时隔多年，再一次过六一却是在这样的情况下，马上就要高考了，现在的六一让我没有一丝的兴奋点，该快乐的.却笑不起来.今天有人对我说：我不是小孩子了~！我就是知道，逝去的一切一切都无法挽回.我无法再为一个礼物而开心.无法因一片树叶的坠落而感动.我试图发出天真的笑声，试图不去想复杂的事物.而我失败了，终究回不去了~[em43]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('365', '2000', '不知怎么想到这个标题~想标题最头痛了~~整颗心仿佛被痛苦的思绪掩埋只剩下一对鼻孔呼吸着腐烂直到生命的最后一秒那瞳孔依旧朝着天.......面朝刽子手尖厉的笑声在空中划过的一道弧线~这种思绪像沙漏一样里面细小的颗粒叫做不开心不论怎么摆放,翻来覆去反复流入心坎里,纠结于心要人承受~-----------------------------~习惯微笑', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('366', '2000', '爱的失乐园守不守的住等你给答案撑不撑的来等你来揭晓也许想要的只是一句承诺习惯了迷失受煎熬辨不清真伪辨不清得失不知是爱上了爱还是爱上了你--------------------------见天是儿童节早已知道这已不是属于我的节日老妈还是一本正经的问候我节日快乐~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('367', '2000', '当彼此欣赏，互相靠近的时候，才会发现，我们来自两个不同高度的人，表面上很接近的人，有很多不同的视野，有不同的价值观。遇到障碍时，亦很难共同进退，高攀很冒险，如果对方够高，也许会例外。放开眼界会发现其他人的距离比我们还要大很多，又或者各自有更适合的选择......5.26', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('368', '2000', 'sepecialspace以为挡住了，就忘记了n年前我知道9.18惨案3年前我知道9.18是朋友的生日1年前我知道9.18是世界上最疼爱我的人决定离开的日子.......爷爷如果你知道现在我的状态会不会很伤心？爷爷如果你知道现在我的成绩会不会很难过？爷爷如果你知道......爷爷但我知道没有你我很害怕很孤独很寂寞爷爷但我知道我想喝你泡的绿茶你给我买的葡萄汁爷爷但我知道我想吃你做的鸡肉你发明的怪味土豆爷爷但我知道我想在我紧张害怕时你握着我的手爷爷但我知道我想听你说的那口纯正的陕西话爷爷但我知道我想和你一起去逛街爷爷但我知道再不会有那一天了爷爷但我知道你不会再回到我身边了......2004.9.18.4：35医生提醒我，你从此刻离开我。握着曾被你握着的手他凉了......如果有来世，我希望你还是我爷爷我还是你的孙女诗人聂鲁达说过：当华美的叶片落尽，生命的脉络才清晰可见', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('369', '2000', '我究竟需要怎样的领悟，才能不再追逐逝去的幸福，不再试着将似水年华留住', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('370', '2000', '猪头,么吵拉!烦死拉,我在睡觉挨,你到底懂不懂啊?快爬开拉,小心我发飙咧!恩哼,那你就死定拉!呵呵...呵、滚!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('371', '2000', '最近总是很浮燥~静不下来我清楚此时一个男孩子正在做一个抉择~忘记过去重新来过~还是找回过去,继续从前.....多半人也许会选择后者~过去的东西往往难以释怀~人是念旧的动物~而新的感受不必去犹豫,去负责.是这样吗?而牛奶呢?自己好象一直觉得牛奶不适合自己的口味~尽管他很营养~而在这杯牛奶快要冷却变味,被夺走时却又忍不住要尝上一口~这大概就是人的自私和贪婪吧~人总是爱惹麻烦~是挑战自己?还是为难牛奶的去留?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('372', '2000', '那些常理上早已不在青春的总会说我们是青春的~其实只有自己清楚~在这个充斥物欲的年代里~或许我们的青春还在~但我们的青春少了很多~比如童真~......不在相信有圣诞老人~不在相信说谎话会长匹诺曹的鼻子~也多了不少~很多东西我们常常会极力排斥的~老妈的虚荣~老爸的专制~总是不留余地的传承着~~只能极力挣脱~~~我不要~~~~不要~~~~~~~~~~[em38]-------------------------------------------做让自己满意的自己~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('373', '2000', '今天姐姐的leo小分队~成立了~~真题她高兴~西西~~~正式成立~~~姐姐终于决心记录下leo的点滴~~[FACE=宋体]队长:姐姐~副队:yy写手:我策划:眼睛yy哥哥~[/FACE]我也只能帮姐姐出出点子~毕竟是她要写给leo的~这个我写过写了半年一个眼神一个表情动作~都发挥好多~写了3个本子~最后通通撕掉了~当时姐姐和yy特可惜~都过去拉~~希望姐姐坚持下去~找到自己的幸福~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~一定会的~~~~姐姐要幸福~~开心', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('374', '2000', '今天又是老时间起来在固定的时间干固定的事~照例是不学习的事下午有是固定的网上时间，和bbs里的人版聊一会发觉太无聊了~突然！（情节真是跌宕起伏啊~）我发现了五月天的节目~爆笑~很久没有这种感觉了下午，太阳好象出来了点，想出去又不想一个人找谁？算了还是在家吧~到底要怎么挥霍剩下的日子？？？还是看着它一秒一秒一秒一秒一秒一秒一秒的流~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('375', '2000', '这是我写给哥哥的信,但是没有机会给他...哥哥:也许你会很奇怪我为什么给你写信,其实,我是有很多话想和你说,但是每次见面,不知道为什么,总说不出!所以我想写在这里给你看!在那天认识你,我很高兴,有这样一个哥哥.因为你比我亲哥哥对我还要好,而我真的很高兴有你这个哥哥!也许你不会在意多一个少一个我这样的妹妹,在你众多的妹妹里,我当然不显眼,毕竟你有那么多的妹妹,不是吗?哥哥,也许是我从小就没有人关心过我,所以我才会觉得你如此重要,但是我真的从心里把你做我最重要的哥哥看,虽然和你认识不久,但是我却有种好像前一世我们就是兄妹的感觉,说起来你可能不信是吗?但是这是真的!不知道最近是不是我的错觉,总觉得你好像不理我了!我好怕,怕会失去你这个哥哥!所以才会想写这封信给你,我不想失去你这个哥哥,一直以来,我都想有个在我有心事可以陪我聊天,在我遇到挫折时鼓励我,在我伤心,痛苦时安慰我的哥哥!虽然我有个有血缘的哥哥,但是我和他好象是陌生人一样,从来不说心事,从来不交流!哥哥,你是不是不理我了?不要不理我好吗?我真的好怕..好怕..好怕你不理我!我可以说,如果你不在,我的生命里会少了什么!哥哥,我现在有个爱我的男朋友,但是我仍然觉得少了什么,后来遇见你,我才知道我少了一份亲情!我们并没有什么很亲的关系,但是我把你看做我的亲哥哥,所以请你不要不理我!哥哥,我知道你最近很烦,也许是我吵到你了,我保证我不吵你了!我只是想帮你分担点,没想到还是吵到你了.所以哥哥,不要生气哦!小心身体!知道吗?我想说的就是这些了.哥哥,要注意身体哦!好好养伤哦!宝宝', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('376', '2000', '这个地方的设备忒差了点吧~~~~~~~~~虾米都米有~！啊~~~~~~~~~~~~爆发了我感觉我的小宇宙在一步步的走向深远........[em45][em45]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('377', '2000', '也许爱真的飞远了,搞不懂为什么面子比爱情更重要,也许他根本不爱我吧.天天拿着那几个袋子,吵架了.就拿几个大袋子到处找走.和好了,又把袋子拿回来.觉得好累,这么大了.还要多着这种一不小心就流浪的生活,他真的不能让我安心吗.?觉得自己好可怜,同时又觉得自己好可笑.请你给我一点安定的生活好吗.?别在打我了,已经伤痕累累了.你难道真的没有一丝心痛的感觉吗.?看着自己手上的淤青,心好痛.现在乞求你别在这样打我了,我真的很怕..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('378', '2000', '[face=楷体_gb2012][/face]那天看报纸才知道王菲打算退出了现在工作也停止了专心恋爱和结婚或许我们该为她高兴她终于能找到真爱告别以前那种感情状态所以我对李压朋没多大的成见能给她爱的人我们也应该宽容不管他是上帝还是个魔鬼但是我在想她走了华语乐坛还真的有什么一片的浮躁正如那些超级女生很无奈的希望她走得从容她的歌曲化作回忆吧[em44]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('379', '2000', '今天头很疼~天气很晴可是还是没有出门在家龟缩的第4天我是不是很可笑外加超无聊吖~~推荐五月天！！！！！！！！！！果然是脑子疼逻辑都很怪！！！谁来拯救我？我是不是很可笑', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('380', '2000', '今天晚上，突然兴起，down了很多bandari的曲子，对我这样一个很少听钢琴曲的人来说，真的很突然的样子。前奏一响，我发现似乎有什么震慑我的地方，我被一个个细小的段落感动着，说不清，道不明。也许是让我回想到了过去，是啊，回不去的时候，有的只是回想。怕是怕连回想的感觉和功能都失去的时候，那会不会是悲痛的。我回想着一切逝去的光阴，快乐，简单。一首首的过度到了《springwater》这首刹时感觉清澈的曲子。嗓子象是被什么压抑着，发不出声。极其不想伤感，却又想听这些曲子，想起了我练琴的日子，多半是很痛苦的，还要应付考级，但我记得有一首曲子，我弹到就想笑，那似乎是一首大家都耳熟能详的名曲，每每弹起，我都有一种艺术家的感觉，在台上，一曲毕，台下尽是掌声。。。。终究是想象。很多年都再没有有碰过琴了。我常常觉得，我好象从小到大都没有干过什么有成就的事情，在此要感谢我的家人和朋友，他们没有嫌弃一事无成的我，仍愿意和我在一起，不弃不离.....一直这样下去吧~不要让我一个人。很多人都觉得我很独立，其实我很怕一个人，一个人我会受不了，我怕孤零零的感觉，就算是放学坐公车回家，我也不希望一个人。同学说习惯就好，也许吧，也许我会在某一年突然习惯，但不是现在，我很拈人，我也很怕他们会察觉到，于是老是装的不在乎。不好意思了````但我知道，你们都懂我的对吧~不要只剩我一个人好不？？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('381', '2000', '刀疤大哥：哈哈，没有想到我会在这样的地方给你写这些话，因为我总是在你面前很坚强是吧~~为了不破坏我在你心目中的形象，就在这写吧，估计你是一辈子都看不到了~高三，一来到4班我就极度的不适应，我痛恨班里的一切，没有任何理由，在班里，我总觉得.....不知道是什么时候，我发现了坐在我后面的你，你脸上有一个疤，这个疤打破了我对刀疤男伦的印象，你超搞笑，也确实不认生，我想，我们很快的成为了朋友。也莫名其妙的成了同桌，说实在的，在我的学习上没有什么帮助，我发现原来在世界上还有一个很象我的人，有时候我会问你一些问题，问有么有这样或那样的感觉，你都说有，我才发现你真的和我很象啊~，总的来说你还是个不错的同志的，哈哈毕业那天，学校放了《同桌的你》，看的出，你有颇多的感触，其实我也是，也许，毕业了，就真的失去的联系，至少在一起的快乐时光都不会再重现了，一起上课偷吃东西，一起假装讨论题却在说话，一起下五子棋，对我的耍赖，你也没有一点办法。我经常会先给你个什么吃的，在你疑惑的吃的时候，我再拿出更好吃的，你总是很无奈的说我太坏了，我想以后的生活里，再碰到象我这么坏的人很少了吧~你说，如果你不和我做同学，你希望我忘了你，是，我会的，但我会记得有一个脸上有5道疤的人，他不会生我的气，也不会不理我~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('382', '2000', '我是多么想看见你[FLY][/FLY]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('383', '2000', '小美：你说我们之间有误会，也许吧，但我觉得那个根本算不上，也许是你太敏感了吧，我很依赖你，很拈你，我也超不喜欢你和别人在一起，你真的象我的一个姐姐什么的，你懂我意思？你很会观察人，爷爷去世后，我有一阵子都很低落，你看出来了，还给我写了很多贴心的话，说实在的你是第一个安慰我的人，你给我了别人都给不了，没给过的温暖。在某种程度，你是离我最近的人，我很在乎我们这不长的友谊，如果可以，我希望可以一直就这样下去，真的，想起爷爷去世你陪我的日子，我都想哭....而且，我真的很喜欢你，只希望你不讨厌我，我不希望失去这样的一个朋友，我们拉勾勾，一直好下去，好不好？[em46]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('384', '2000', '笑！錢都沒準備好，開什麽張.7張大鈔對我來説不少，剛剛上繳了1000多大圓還有什麽錢。求助家人？他們還在笑我考試沒為他們節約10000園了哎呀，只有求得喊娘了.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('385', '2000', '我真的老了、什么事情都懶的去做、唉唉...日记也懒写,覺覺懶的睡,飯懶的吃,連期末攷試的舞蹈我也懶的編,所以到現在還沒開始編...呼呼..連跳什么都米像好...怎么辦咧?..明天就要攷試..等哈子就要囬學校...真哀啊..!呼呼..怎么會這樣咧?我才16岁,怎么就好像一个老太婆似的', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('386', '2000', '\"我知道很多人喜欢和我聊天~也爱把他们的\"\"秘密\"\"告诉我觉得我好玩~喜欢和我交朋友~可真正用心去了解我的人~太少太少~这个城市有太多寂寞的男女~或许他们需要的只是一个可以信赖的倾诉对象,必要时再为他们出谋划策~有的时候真的是累了~我不是个自私的人有时候很开心能让他们开心起来~可这一切重重的压的快要窒息~~总有崩溃的时候~[em41]\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('387', '2000', '自己爱笑~开心时笑~不开心也笑~对不能接受不喜欢的人更笑~~因为无话可说~最近朋友说我开朗了许多~爱笑~爱闹~是的..比起以前坐着发呆一上午或睡一天好了许多~笑,有时候是一种回避~有时候是一种敷衍', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('388', '2000', '\"也许自己是真的变了..可依旧喜欢独处.......自己常常喜欢在事情发生前为生活续写~~我续写牛奶....牛奶,在彷徨,犹豫.自己也愈加不了解自己.仿佛失掉了心~牛奶理所当然的被带走了.没有挽留.而自己也向往常一样甘心认命,自讨苦吃.常不爱给自己找麻烦的,也开始怀疑~怀疑那杯牛奶不是属于自己,不知疲倦的反复叮嘱自己\"\"那不属于你\"\"仿佛睡梦中的孩子痴痴的呓语..这不是一场梦.因为它太真实~这样的自己..是在善待自己,怕自己迷了心~\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('389', '2000', '\"[FACE=黑体][/FACE]常常喜欢一个人站在窗口吹风,喜欢风迎面吹来的时候,有种顷刻梦醒的感觉,它会把我乱飞的思绪带回书本中去,面对真实的生活~------题记站在窗口,驻足观望:每个人都行色匆匆,忙忙碌碌,每个人都向着自己的梦想努力拼搏.可是他们所执着的,坚持的到底值不值得~也许生活于人,就是一种苦难.从小就自恃为清高~这可能是一种自欺的自负~或许就是这样一直活在自己编织的梦里~或许是自己作茧自缚~在自己的意愿中过活~我曾想有一个晴朗明澈的天空赖以呼吸~然而那只是一相情愿~朋友的话很明白\"\"这个世界不是你想怎样就能怎样的,人不能活在精神世界里\"\"他们担心这样的我会完全丧失生活能力~他们有时候会说很佩服我~永远可以活的那么冲动~也许,朋友的担心是有必要的.有时,我也扪心自问.自己的感性是否有点偏激~传统的理念也许已根深蒂固.是啊.再崇高的人格也要面对现实~面对生活~面对柴米油盐的琐碎.是否我把生活太理想化了.....现实的生活充满了腐烂的气息~生活在物欲的世界里,势力,虚伪,谎言,像一股沙尘暴扑面而来~我稳了稳脚跟.努力不使自己卷入这人情淡薄的旋涡~........常常在午夜,打开台灯.伏在写字台上~回想几天发生的事情,感叹自己的不如意~悔恨自己的无可奈何~我知道,我是在找一个聊以自慰的借口~就因为那种世人的压力和责任,使得自己承受,本是被刺伤的灵肉,被磨光的棱角~却要自己一针一线的缝合~面对窗外车来车往~劳碌奔波的人们.我似乎有了那么一点顿悟~虽然苏醒的不够彻底~但为了自己梦想~我必须要豁达的面对.他们的行为感染了我~让我明白只有这样的忙碌,我的生活才会真切~人生才会真实~如今我决定卸下自己的固执和倔强~学着接受~为自己的梦想而打拼~我依旧穿行于这宇内~依旧努力找寻着那个晴朗明澈的天空~浮生若梦~也许人生真的如梦~在我如梦的人生里~为爱的迷失和沉沦~呼唤而拯救~为良知的真诚~为人性的善与真谱写永恒的旋律~纵使这是自己的一相情愿~我也不会放下这种坚持,我的生活仍在继续.........------------------------------------------------多好的一篇文~多积极~多向上~~老师就给得了个b体裁不和要求~~~55555打击我~\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('390', '2000', '1、情况不同一只小猪、一只绵羊和一头乳牛，被关在同一个畜栏里。有一次，牧人捉住小猪，牠大声号叫，猛烈地抗拒。绵羊和乳牛讨厌牠的号叫，便说：「他常常捉我们，我们并不大呼小叫。小猪听了回答道：「捉你们和捉我完全是两回事，他捉你们，只是要你们的毛和乳汁，但是捉住我，却是要我的命呢!立场不同、所处环境不同的人，很难了解对方的感受；因此对别人的失意、挫折、伤痛，不宜幸灾乐祸，而应要有关怀、了解的心情。要有宽容的心！2、靠自己小蜗牛问妈妈：为什么我们从生下来，就要背负这个又硬又重的壳呢？妈妈：因为我们的身体没有骨骼的支撑，只能爬，又爬不快。所以要这个壳的保护！小蜗牛：毛虫姊姊没有骨头，也爬不快，为什么她却不用背这个又硬又重的壳呢？妈妈：因为毛虫姊姊能变成蝴蝶，天空会保护她啊。小蜗牛：可是蚯蚓弟弟也没骨头爬不快，也不会变成蝴蝶他什么不背这个又硬又重的壳呢？妈妈：因为蚯蚓弟弟会钻土,大地会保护他啊。小蜗牛哭了起来：我们好可怜，天空不保护，大地也不保护。蜗牛妈妈安慰他：「所以我们有壳啊！」我们不靠天，也不靠地，我们靠自己。3、鲨鱼与鱼曾有人做过实验，将一只最凶猛的鲨鱼和一群热带鱼放在同一个池子，然后用强化玻璃隔开，最初，鲨鱼每天不断冲撞那块看不到的玻璃，耐何这只是徒劳，它始终不能过到对面去，而实验人员每天都有放一些鲫鱼在池子里，所以鲨鱼也没缺少猎物，只是它仍想到对面去，想尝试那美丽的滋味，每天仍是不断的冲撞那块玻璃，它试了每个角落，每次都是用尽全力，但每次也总是弄的伤痕累累，有好几次都浑身破裂出血，持续了好一些日子，每当玻璃一出现裂痕，实验人员马上加上一块更厚的玻璃。后来，鲨鱼不再冲撞那块玻璃了，对那些斑斓的热带鱼也不再在意，好像他们只是墙上会动的壁画，它开始等着每天固定会出现的鲫鱼，然后用他敏捷的本能进行狩猎，好像回到海中不可一世的凶狠霸气，但这一切只不过是假像罢了，实验到了最后的阶段，实验人员将玻璃取走，但鲨鱼却没有反应，每天仍是在固定的区域游着它不但对那些热带鱼视若无睹，甚至于当那些鲫鱼逃到那边去，他就立刻放弃追逐，说什么也不愿再过去，实验结束了，实验人员讥笑它是海里最懦弱的鱼。可是失恋过的人都知道为什么，它怕痛。4、神迹法国一个偏僻的小镇，据传有一个特别灵验的水泉，常会出现神迹，可以医治各种疾病。有一天，一个拄着拐杖，少了一条腿的退伍军人，一跛一跛的走过镇上的马路，旁边的镇民带着同情的回吻说：「可怜的家伙，难道他要向上帝祈求再有一条腿吗??」这一句话被退伍的军人听到了，他转过身对他们说：「我不是要向上帝祈求有一条新的腿，而是要祈求祂帮助我，叫我没有一条腿后，也知道如何过日子。」试想：学习为所失去的感恩，也接纳失去的事实，不管人生的得与失，总是要让自已的生命充满了亮丽与光彩，不再为过去掉泪，努力的活出自己的生命。5、钓竿有个老人在河边钓鱼，一个小孩走过去看他钓鱼，老人技巧纯熟，所以没多久就钓上了满篓的鱼，老人见小孩很可爱，要把整篓的鱼送给他，小孩摇摇头，老人惊异的问道：「你为何不要？」小孩回答：「我想要你手中的钓竿。」老人问：「你要钓竿做什么？」小孩说：「这篓鱼没多久就吃完了，要是我有钓竿，我就可以自己钓，一辈子也吃不完。我想你一定会说：好聪明的小孩。错了，他如果只要钓竿，那他一条鱼也吃不到。因为，他不懂钓鱼的技巧，光有鱼竿是没用的，因为钓鱼重要的不在＜钓竿＞，而在＜钓技＞有太多人认为自己拥有了人生道上的钓竿，再也无惧于路上的风雨，如此，难免会跌倒于泥泞地上。就如小孩看老人，以为只要有钓竿就有吃不完的鱼，像职员看老板，以为只要坐在办公室，就有滚进的财源。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('391', '2000', '可爱的女儿：爸爸和你玩了好多次捉迷藏，每次都一下子就被你找出来。不过这一次，爸爸决定躲好久好久。你先不要找，等你十四岁（还要吃完十次生日蛋糕）的时候，再问妈妈，爸爸躲在哪里，好不好？爸爸要躲这么久，你一定会想念爸爸，对不对？不过，爸爸不能随便跑出来，不然就输了。如果还是很想爸爸，爸爸就会变魔法出现。因为是魔法，不是真的出现，所以不犯规，爸爸不算输。爸爸的魔法是：趁你睡觉的时候，跑到你的梦里大玩游戏；在你画图话爸爸的时候，不管好不好看，你觉得是爸爸，就是爸爸；当你拿爸爸的照片看时，爸爸也在偷偷地看着你......要记得，爸爸一直都陪着你！你已经是四岁的大姐姐了。爸爸要拜托你一见事，要你照顾和孝顺爷爷，奶奶和妈妈，看你是不是比爸爸以前做得好？有多好，妈妈会告诉你的。爸爸猜想，我们这次玩捉迷藏要玩这么久，爷爷,奶奶和妈妈有时候看不见爸爸,他们一定会偷哭.偷哭就是犯规,就是失败.他们偷哭,你就要逗他们笑,不然游戏输了以后,他们一定哭得更厉害了.好不好,宝贝?我们是同一国的,来比赛看你厉害,还是爸爸厉害?准备好了吗?比赛就要开始了!你亲爱的爸爸啊~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('392', '2000', '有一天　我在想　我到底　算是个什么东西　还是我　会不会　根本就不算东西　天天都漫无目的　偏偏又想要证明　真理　别人从屁股放屁　我却每天每天的说要革命　就算是这个世界　把我抛弃　而至少快乐伤心我自己决定　所以我说　就让它去　我知道潮落之后一定有潮起　有什么了不起　常常我　豁出去　拼了命　走过却没有痕迹　可是我　从不怕　挖出我火热的心　手上有一个硬币　反面就决定放弃　嗝屁(革命)　但是啊在我心底　却完完全全不想放弃　就算是这个世界　把我抛弃　而至少快乐伤心我自己决定　所以我说　就让它去　我知道潮落之后一定有潮起　有什么了不起　常常我　闭上眼睛　听到了海的呼吸　是你　温柔的蓝色潮汐　告诉我没有关系　就算真的这个世界　把我抛弃　而至少快乐伤心我自己决定　所以我说　就让它去　我知道潮落之后一定有潮起　我不能忘记　无论是我的明天　要去哪里　而至少快乐伤心我自己决定　所以我说　就让他去　我知道潮落之后一定有潮起　有什么了不起　有什么了不起今天听这个有特别的感觉~很振奋，又很惋惜[em38]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('393', '2000', '当　我和世界不一样　那就让我不一样坚持对我来说　就是以刚克刚我　如果对自己不行　如果对自己说谎即使别人原谅　我也不能原谅最美的愿望　一定最疯狂我就是我自己的神　在我活的地方我和我最後的倔强　握紧双手绝对不放下一站是不是天堂　就算失望不能绝望我和我骄傲的倔强　我在风中大声的唱这一次为自己疯狂　就这一次　我和我的倔强对　爱我的人别紧张　我的固执很善良我的手越肮髒　眼神越是发光你　不在乎我的过往　看到了我的翅膀你说过被火烧过才能出现凤凰逆风的方向　更适合飞翔我不怕千万人阻挡　只怕自己投降我和我最後的倔强　握紧双手绝对不放下一站是不是天堂　就算失望不能绝望我和我骄傲的倔强　我在风中大声的唱这一次为自己疯狂　就这一次　我和我的倔强我和我最後的倔将　握紧双手绝对不放下一站是不是天堂　就算失望不能绝望我和我骄傲的倔将　我在风中大声的唱这一次为自己疯狂　就这一次　我和我的倔强就这一次　让我大声唱ｌａｌａｌａ．．就算失望　不能绝望ｌａｌａｌａ．．就这一次　我和我的倔强', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('394', '2000', '有場戰爭就在眼前鬥志鬥不過溫暖棉被水龍頭裡流出眼淚又是殘酷美好的一天眼前有一千件事正等著解決everybody想要改變evreythingwont\'tbeok七點的一杯咖啡八點的紅綠燈斑馬線abusygameevreyday活在瘋狂世界活在美好的明天重重考驗來到今天不知不覺改變遠離每個昨天那些笑和眼淚沒有時間說再見喜怒哀樂苦辣酸甜(夢的邊緣我在徘徊)終於瞭解這就是生活的滋味生活太近夢想太遠午餐是吃飯還是吃麵喜歡忙碌搞的很累電話吵醒的星期天珍惜的浪費時間換來了的生命的缺理想劃過天邊愛情啊與我擦肩分不清東西南北分不清我的地我的天acryinggame是不是會有答案在終點後面當初我的信念現在的我又是誰狂奔的每個白天寂寞的每個夜慢慢發現i\'masuperman振奋起来啊~~~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('395', '2000', '父子两住山上，每天都要赶牛车下山卖柴。老父较有经验，坐镇驾车，山路崎岖，弯道特多，儿子眼神较好，总是在要转弯时提醒道：“爹，转弯啦！”　　有一次父亲因病没有下山，儿子一人驾车。到了弯道，牛怎么也不肯转弯，儿子用尽各种方法，下车又推又拉，用青草诱之，牛一动不动。　　到底是怎么回事？儿子百思不得其解。最后只有一个办法了，他左右看看无人，贴近牛的耳朵大声叫道：“爹，转弯啦！”　　牛应声而动。　　牛用条件反射的方式活着，而人则以习惯生活。一个成功的人晓得如何培养好的习惯来代替坏的习惯，当好的习惯积累多了，自然会有一个好的人生。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('396', '2000', '很无聊的发现我是渡口日记的第100个用户[glow=挖卡卡]文字[/glow]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('397', '2000', '啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊暗暗啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊啊好了~~~发泄完了~！！！fighting!!!![em38]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('398', '2000', '累死拉,终于把舞编好的,忽忽..偶是不是很聪明咧..可惜我学会了,容容那个死猪还不会...气死人了..我今天第⒈次对她发脾气..我本来是可以单独跳的..可是看她那么可怜..米人跟她一起跳..而且她又不会编..忽忽..哎..我只好收留她了..哎..可看她那个苯样..我又忍不住发火...哎..容容真是好..一点也没有生气..hoho..加油吧..伊.忽忽...我的钢琴终于有进步了..我终于会弹其摸考试的曲子“木马童之歌”老师也表扬我了..高心列..忽忽..我觉得自己是蛮聪明的..就是上钢琴课老睡觉..如果我认真..我也可以的..是不是呢..西西..今天好忙哦..好累哦..忽忽..也严重的缺少睡眠..两个通宵不说...昨天晚上编舞到12点不说..掺的是今天5点就被我妈妈拉起来..这是我答应妈妈的..哎..我真是一个懒人..星期6星期天在那里玩..就是米想到编舞..等到上学才想起来...搞的我不敢去学校..请求妈妈..我妈妈才给我请了假..不过我要坐第一班车去...做第一班车6点的车..结果我8点就到学校了哎...好丢丑..在车上我睡着了..我旁边是个男孩....等我醒来..我居然..居然靠着他肩膀睡着了...妈呀..他还对我笑...满脸的豆子...挖啊啊...我的天啊..我的命好苦啊..为什么这种事发生在我身上..好想找块豆腐撞死酸了...忽忽...我想睡觉..好累哦..累的没有心思去想任何事了..现在做在学校里上网..觉得好轻松..好像靠在喜欢的人的肩膀上..............睡觉...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('399', '2000', '[FACE=scriptmtbold][/FACE]^_^我好开心啊～！今天咋这么滴开心类～！恩``不过中午时有一段不开心的小插曲诶`老师今天检查舞蹈`我们都还没练好啊好衰啊~！老师说我们动作都还没记住哎``~~~那有什么办法啊这些天都好忙咧还要弹钢琴又要背声乐都忙不过来拉不过现在心情好多拉哈哈', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('400', '2000', '\"有的时候真的觉得很无奈,不知道该怎么办..心里真的很多事,虽然我的表面上天天都很开心.在别人眼里的不懂事,不想事.其实心里一点都不快乐,每天要承受好多事...并不是那么开心...[em43]有的时候真的觉得好孤单,虽然每天都有朋友叫着去这去那,但是...总有点不安..好像有什么目的似的,每天都好无聊,做着同样的事,哎...算了.也许生活就是该平淡一点....复杂的心里,空虚...哎...好好过.早上起来多说点\"\"恩!明天会更好..!\"\"[em35]听听歌..睡个好觉..\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('401', '2000', '最近都不知道是怎么样，事实上心里还是不轻松，我知道或许我在欺骗他，我要离开他，又不舍。我都不知道自己为什么这样做，我心理真是矛盾啊。我暗恋虞已经有两年多了吧，我没办法和他在一起，甚至接近他，但我无法说服我自己忘了他，我忘不了，我试过，可是我不知道为什么我还是深深的陷在对他的爱恋中。而我和他是不可能的，他有自己爱的人。但我现在决定，我不可以再让自己后悔了，我要说出我的爱，不管结果这样。而他我对不起！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('402', '2000', '每天都会有试卷发下来,还有练习册,很厚的那种,写完之后交,又发下来继续写,就这么一直重复着,直到练习册用完了,成为一堆废纸~然后就在这堆废纸中间埋头大睡,感觉很爽,至于原因可能是出于自豪吧:看,这全是我写完的,厉害吧.我没有耐心做完一件事,即使我很喜欢,很愿意做的事情,我都不会做到有头有尾,因为结果往往都很伤人.然而,我喜欢睡觉,只要有时间总喜欢睡觉,我想睡觉的结果就是死吧,睡死的,哈,这个结果不会伤人的.唯一不会厌倦的可能就是睡觉,不是吗', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('403', '2000', '\"本来很安静的看别人发的帖子,突然电话响了.\"\"苏苏,在干嘛?\"\"\"\"上网\"\"\"\"哦,最近还好吗?\"\"\"\"恩,挺好的.\"\"\"\"我放假会回来\"\"\"\"我等你\"\"\"\"好\"\"嘟嘟~放下听筒我庆幸我有很多关心我的朋友,他们不停在我的耳边唠叨,我偶尔会烦,但是大多时候,我会很认真听,因为我知道,若干年之后,我不会再有机会享有这些,花会枯萎,他们也会离开我.我需要面对很多,我不知道我将来失去了朋友,父母之后会怎么办,也许,现在的朋友会被将来的朋友代替,也会有人帮助我,但是,这不是我想要的,我想要那些曾经在我身边重复出现的人.突然,房子塌了,人死了.死亡带走了我的生命我听见灵魂的坠落而后是眼泪\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('404', '2000', '2005-5-1417:03:0910点左右我出门。天空是干净的，呈现一片灰白色。没有下雨，但有很大的风。家人只是说了句：早点回家。街上行人不多。有无数人与我擦肩而过。一些人离开我。一些人找不到。一些人，永远不会回来了。今天居然是我的生日。接受许多廉价的“生日快乐”。穿着已经旧了的板裤，没有带手机、MP3、相机。一个人坐公车去吃麦当劳。原来，也就这麽过了。我步行去坐车。走在路上的时候，眼泪无法抑制地往下掉。我知道在大马路上边走边哭是怎样丢脸的样子，不想让别人看见什么，于是一直忍。发现，眼泪要来的时候，怎样都无法忍住。三十分钟车程。上公车后，我总是喜欢坐在左边的最后一个位置。风灌进我衣领时，眼泪的确是掉落了。没有声音。在我的掌心瞬间碎裂，滴下。于是也没有人会知道。车窗外依旧是大片大片的绿。车内依旧是陌生人谈笑的声音。到站的时候，下雨了。没有带伞，于是淋湿了。买了一份KFC，一份M记。在大马路上打开，边走边吃。我知道路人在看着我。地下通道里有男人抱着吉他自弹自唱，他面前的那张报纸上堆满了钱。路人频频回望。我停下来，看着他唱。他唱完一曲，也停下来，朝着我笑。口袋里只有一张一百的，和一张一块的。一块的要坐车，一百的要买漫画。于是我问他：你吃不吃蛋塔。他笑着摇摇头。于是我走开了。他又开始唱起来。我只听见一句，他在我身后唱着：故事结束了。感觉自己在渐渐萎靡。我以前写出来的文字要比现在的好看。现在，似乎，对任何东西都说不出个所以然来。雨水落进眼睛里。手中的奶昔在一点一点融化，陷出漂亮的，层层迭迭的圆圈。家人不能陪我，只能为我做一顿晚饭，因为他们要工作，要忙生意。我不能怪他们不重视我，我在他们眼里一直是独立独行的。然后想起小时候的生日，和妈妈，和很多小朋友一起吃KFC。他们会为我唱生日歌，会給我礼物，給我笑容。现在的我，却再也无法开心起来。以前和我在一起的朋友很无力地说，我不知道怎样才可以让你开心。我说，算了吧，我都不知道，你怎么会知道。在雨中行走的时候，感觉自己正在一点一点被抽空。空间和时间感开始模糊不清。沉默和面无表情成了我惶恐不安的唯一借口，我听见我的童年和纯真逐渐死去的声音。无能为力。甚至连我也是麻木的。连一点纪念都不留。回到家的时候，雨却停了。雨水洗过的天空亮得刺眼。从镜子里看见我一脸颓丧的表情。头发湿了，衣服湿了，鞋子也湿了。没吃完的东西顺手扔在了餐桌上，从冰箱里倒了一杯冰水。脱掉袜子，光着脚在地板上来来回回。心慌的感觉铺天盖地弥漫。找不到出口。我记得身边对我好的人。那些无论什么时候都会和我在一起的人。而不是当我与他们的个人利益与虚荣起冲突的时候，放弃我的那些人。有时候会很奇怪，为什么身边人一个一个都这样。似乎这是大部分人的通病，我没有资格评论，更无资格要求他们为我更改。想起宋。毫无征兆地，我又开始想起她。想到我们一起睡在她狭小的床上的那一晚。她在黑暗中握着我的手腕。我的手腕冰凉。她轻声说，Sky，你的手，好象一碰就会断掉似的。Sky，你喜欢Z是不是。Sky，别难过，他会后悔的。……我知道我和Z在一起无法快乐，所以我一早就选择好。有人问及我，以后的生活怎么过？我说，我想和喜欢的人在一起。不过到那个时候，也许大家都散了，找不到了。仅仅只有回忆摩肩接踵，仅此缅怀。2005年5月14号。HappyBirthday。那天的回忆在我的脑海里只有，我在桌前给她发了很长的一段留言，很长，记忆有些模糊，然后是凛冽的遗忘，不留痕迹。。　', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('405', '2000', '又是一个阴雨绵绵的天...一个问题我想了好久好久,但是始终没有想清楚..我到底要不要和他分开?我当初的选择到底是不是对的?不过就算当初的选择是错的,我也不后悔,至少我和他在一起爱过,痛过,伤过,也快乐过!有这样一段刻骨铭心的爱情做为回忆,至少我不会再为遗憾而哭...和他在一起快两年了,时间总是在不注意的时候流逝而过,现在,我在想,是不是和他分开了会比较好呢?和他分开了他能不能长大点呢?还是继续像个孩子样不懂事呢?我不想和他分开,但是不分开,他总不会长大,我真的怕我那天会狠不下心离开他...但是总这样下去不是办法,即使心会很痛很痛,我也要忍着...我真心的希望,他会经过这件事长大些..懂事些.不再是个任性的孩子!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('406', '2000', '初恋是盲目的,哈,看着自己写下的题目,吓了一跳.早上起床的时候,看见床边的照片,想起了他.我记得朋友给我给过他的照片,但是在那件事发生之后,我就把随身带着的他的照片撕碎了.那天刮风,我生日刚过,我把照片扔的到处都是,想把它们拼凑回来,风却越吹越大,只好放弃.每次告诉别人,我喜欢Leehom5年了,其实我是想说,我喜欢他5年了,但是说不出口,是怕嘲笑,还是怕别的,不知道.认识他那么长时间,却发现我一点也不了解他,我们之间的距离永远就那么远,我想改变也不可能,他越走越远.那件事情发生以后,我什么话都没有说,我没有抱怨,我没有失望,但却是绝望.我不可能去埋怨他的不是,我只能说自己愚蠢,不是吗?L:我欠过你什么?但是,你却欠了我很多', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('407', '2000', '昨天晚上睡觉没有关窗户,纱窗好象没有起作用似的,胳膊被虫虫咬了,好象不是蚊子,肿了,红红的,有点疼,抹了点红花油,然后一整天身上这种味道都没有散去,好刺鼻.下午一直在上网,QQ上一大堆的同学,陌生人,朋友,都在,却不知道该不该打招呼,就一直不说话,幸好他们没有理我.今天有人告诉我关于L的事,很糟糕,我没有吭声,这个尴尬的话题就这么搁的空中,朋友不知道是继续说还是不说,其实,我早已经容入回忆了.甜说,恋旧的女生不容易得到完美的**', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('408', '2000', '姐姐~~你要有信心知道不?不论发生什么~不论他们给你任何阻力~记得有我~我会支持你~~给你打气~鼓励你追求自己的幸福~~相信自己~相信真爱依然存在~~姐姐...你要好好的..要幸福~~~~记得前天姐姐和我说..pp我要是同性恋你是我,第一个对象~~真晕~~~不过姐姐这么说好开心的~~~~~hoho~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('409', '2000', '\"刚还在想他,猜他现在在干嘛,写完长长的日记,突然,QQ的抠门声响起,我看见那个名字变成彩色,然后他的头像动了起来.\"\"你是\"\"\"\"苏\"\"\"\"哦,高考你们放假啊\"\"\"\"恩,是啊\"\"无关紧要的聊了几句,看,我们是不是很陌生了?突然一下子不想再这么等着.每次大声告诉自己,放弃,放弃,放弃是最好的结果,但是终究都是空的,什么都没有放弃,除了自己微笑的勇气.\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('410', '2000', '我想我会一直孤单这一辈子都这么孤单我想我会一直孤单这样孤单一辈子天空越蔚蓝越怕抬头看电影越圆满就越觉得伤感有越多的时间就越觉得不安因为我总是孤单过着孤单的日子喜欢的人不出现出现的人不喜欢有的爱犹豫不决还在想他就离开想过要将就一点却发现将就更难于是我学着乐观过着孤单的日子当孤单已经变成一种习惯习惯到我已经不再去想该怎么办就算心烦意乱就算没有人作伴自由和落寞之间怎么换算我独自走在街上看着天空找不到答案我没有答案天空已蔚蓝我会抬头看电影越圆满就越珍惜伤感有越多的时间就越习惯不安因为我总会孤单过着孤单的日子我想我会一直孤单', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('411', '2000', '我不爱哭,因为掉眼泪很丢人,我从小都这么认为.我记得哭的最凶的一次应该是在幼儿园那次,晚上做了一个梦:爸爸,妈妈开车走了,不要我了,我怎么追都追不上那辆车,就在后面跑啊,追啊,搞笑的是,我醒来后记得,那时的我好象还一个手拿的镰刀,一个手拿的烧饼(好象是当时小时侯看的电视的场景),这个梦一直都记,十几年了,现在想起来,心里都会难过,但是不会再趴到爸爸的怀里哭了一个早上,不让他们上班.然后再就是,L骗了我的事,那天晚上我在寝室里的一个女生的被窝里一直哭,还好,寝室里的另一个回家了,要不然更丢人.就在哭的时候,我恨不得掐死他.我的眼泪像泛滥了一样,就一直掉啊掉,纸用完了，就拿起枕巾擦,我记得那个晚上浑身都冷,冷的骨头都疼起来了.我不想哭,真的,我拼命忍住眼睛,不让它从眼睛里掉,不让,眼泪是屈服.L:我想写很一本关于你的日记,长长的,把我每天关于你的相法都写下来,以前的日记全让我烧了,但是我后悔了,因为那本日记诉说了前5年最真实的我,不是吗?你很傻,你知道吗?我很傻,这我知道', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('412', '2000', '在论坛里跟不了贴了~郁闷！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！~！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！靠！我还打算一直感叹到头~看来是么头么尾的奇怪的日记本对了6.7号我忘说:tonyhappybirthday!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!我觉得五月天真的很biang！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！不玩了！[em48]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('413', '2000', '好烦[em43]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('414', '2000', '[I][/I]不知道怎么啦!不太好啊.我不能理解他们是什么想的?我知道自己没事的,我也知道自己已经忘记了.但我知道自己是不会忘记自己的心情的.不会忘记自己精心培养的情感.不会忘记自己的成长.我觉的自己是这么想的我就这么做了.我想自己不是因为这些而烦恼,也许是因为自己考的不够好?也许是因为自己的离别,也许是因为我们的青葱岁月?也许是因为自己的不小心,又伤心了.再一次坐在一起吃饭,我不知道自己是什么感慨?也不知道还有没有什么感慨?但我只是想不去伤害任何人.无论是谁?无论还有什么样的历史?我也只是想不要那么的难看.可我不知道这样是对是错?我已经尽力了.无论怎样吧!我知道迟早是要面对的,我们总是要去面对一些事.无论是好还是坏?我想我们的友谊,可有谁会这样看我呢?坐在那里我是怎么想的呢?我在那里他们是怎么想的呢?我知道,自己没什么可以说的?我也不想再多说什么?在这最后我还需要说什么呢?只是希望我自己不会影响别人吧!我想走了.我真的想走了!最后了啊!我们还要怎么样呢?我不想再怎么阿姨能够啦!只有默默的祈祷吧!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('415', '2000', '不知怎的无意中申请了一个日记本当然很欣喜我总以为申请一个日记本很难没想到怎么简单哈哈以后可以写日记落、我可以把我的喜怒哀乐记载在上面2005年6月9日', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('416', '2000', '最近发生了好多事,另我好烦,可我又不知道该跟谁说才好,连日记本都不想写下来,我怕别人会知道..会把我都看懂....也许我太好强了,为什么要这样子.......友谊,?友谊....虚伪死了..自从我为了容容哭了以后..我就在心底开始不把她当朋友了,她怎么还好意思对我笑,向我要东西吃?好虚伪,好假的.我另愿她也和我一样把对方当作仇人..然来她一开始就虚伪的跟我在一起玩..只是现在我才发现...以前她对我真的很好,就想姐姐一样,现在呢..?我不想说了.....回忆,是梦...容容到底是一个什么样的人?最近的事让我透不过气来..呼吸..呼吸..我总以为自己很坚强,即使要哭也要自己找一个没人的地方躲起来哭,可是眼泪啊,为什么那么那么的不争气?..那次上声乐课发现我哭了只有大姐,2姐,3姐他们...因为大家都在忙着为考试做准备,我不想让大家看到我脆弱的一面,眼泪啊.不要轻易再流了好吗?可是回到寝室我还是忍不住冲到楼顶上,扒在上面哭..回忆友谊..哭过之后我想通了很多,关心我的朋友还有很多,而真心和容容玩的只有我,溶溶根本就米什么朋友,为什么他们不跟容容在一起,?难道他们早就看清了容容,而傻的可怜的我,才接受这个事实.容容,哦,..不对,该叫陈容同学.我想我伊伊以后再不会把你当朋友了,不管以后你会对我有多好,懂吗?!他们都说我很坚强,可是谁知道我比谁都敏感,比谁都脆弱,?!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('417', '2000', '今天的心情真的是格外的郁闷说不出来象是什么压的喘不过来一样，前所谓有的，他妈的，今天妈妈对我的态度很冷淡，走哪不管以前认不认识都他妈问一句，靠多少~！干求！！1高低和你他妈有鸟的关系，问个求~~！出去吃饭都是，鸡吧考的好的比话多，我说你丫不吃就滚~！！！！！！！！！1草！哎~什么嘛`1心里的无名小宇宙在燃烧，都快崩了！`[em45]这个日记本不好玩~什么都没有，愤怒的表情一点都不愤怒，反而很可爱汗~什么嘛~我的意思是来点愤青的表情撒~！！！！！！！！！！！！！！去死吧！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！[em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45][em45]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('418', '2000', '觉得可笑自己不可笑吗什么啊~想什么呢鸡吧都给我走！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！傻b', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('419', '2000', '有一种把一切都化为灰烬的想法，一点一点的扩大。如果什么都没有开始，那就不会有结尾，不是一样很好？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('420', '2000', '明天是端午节了妈妈饱了很多的粽子但是这回又没有饱好明天又有很多东西可以吃了我要吃个饱2005年6月11日', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('421', '2000', '明天就是端午节了，但我却高兴不起来，因为即将初中毕业了，真的很舍不得昔日的好友，但我知道天下没有不散的宴席，每个人都有自己想走和该走的路，所以我努力抑制自己的情绪2005。6。10', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('422', '2000', '她只想要玫瑰,你却去买保时捷,她说想去散步,你却想更进一步,保时捷飙得快,一头撞上安全岛,漫长的人行道,爱情就这样开始,拙拙的发酵,她喜欢章鱼烧,你却带她去岩烧,牛仔裤破个洞,还问会不会感冒,总是想改变她,这种爱是不是烦呀,怎么说,才明白,不是你要的女孩,你还不快走开.............如果我是男生,绝不会makehercry,愿意用全世界换她的微笑,如果我是男生,就算她发脾气,象忍者一样坚强,如果我是男生,别担心,就算台风来了也会把她送回家,在12点以前走进礼堂之前,保持完美记录,如果我是男生,你不必献上自己,就可以得到我的灵魂,每天嘘寒问暖外加爱心饭团,百分之百的男生,喔,要到哪里找啊.?!íοо;℅啲男生', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('423', '2000', '(2005-06-1116:39:33)PK~玫瑰~520你回来没有啊(2005-06-1116:42:35)PK~玫瑰~520好想你啊(2005-06-1116:45:19)PK~玫瑰~520你的qq怎么这么高的极数啊啊那你老公对你好把(2005-06-1108:46:36)', '兎', '°庅﹖好的很撒....(2005-06-1116:47:32', '兎');
INSERT INTO `dede_addonarticle` VALUES ('424', '2000', '[B][/B]我要说什么呢？我想说什么呢？我又能说什么呢？我等待了好久的飞翔终于到来了，可我有多么的高兴吗？我想我是到飞的时候了！那我就飞吧！我想祝愿自己一切顺利，会有人为我祝福吗？我认为的朋友会是我的吗？世界会将我们变成什么样呢？我们又会走向一条什么路呢？我为自己祈祷，望自己可以为自己的未来寻一条路吧！只有这样，我才有资本去寻自己的梦啊！！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('425', '2000', '今天的天气可真是超赞的说~~~小风吹着我~爽翻了~不象昨天，坐在电脑前，脊梁就是汗而且很烦躁害我把头发都剪的很短今天又变的很凉快~~~55555555555为什么老是这样，嫌天气热就换毛毯，结果接下来的几天就是雨天为什么`````555555还叫我阿福的，真是个无福之人啊~[em43]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('426', '2000', '马上就要中考了，真的好担心哦，不知道会考个什么鬼东西，如果考砸了，老爸一定会骂死我的，到时侯该怎么面对呢，好害怕哦，不过死就死啦，谁叫自己平时不努力呢哎1！！！！！！！！！！！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('427', '2000', '有人说,如果上辈子欠了别人的,这辈子就会要加倍奉还..如果说,这辈子我被他吃定了,那么一定是上辈子我欠了他的!但是,要还到什么时候,才罢休?很久没有哭过了,突然有眼泪掉落,还真的不习惯.不过偶尔哭一下也好,至少不用压抑在心里憋的难受!妈妈说,每个人活在世上都是为了寻找他的另一半,真的是这样吗?如果是这样,那么他是不是我这辈子的另一半呢?如果不是,那么又是谁呢?谁才是我的另一半呢?活在这个世上,就是为了寻找今生可以相伴一生的人...不知道为什么,总觉得,心里有种好难受的感觉..却又不说是什么感觉,是我的多心吗?还是真的有这样一种感觉呢?我好想好想去海边,好想看看那种海和天连成一线的美景...但是不知道要等到什么时候,我才有机会去看海!从小到大,每个人都跟我说,海很美,像蓝天样的美...然而我却没有机会去看海..不知道要写些什么.只觉得想写日记,想把心里的话写下来,但是一写日记的时候,却写不出来心;里的那种感觉...好矛盾..不知道要怎么办就好!郁闷.....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('428', '2000', '今天上线有人就说明天可以查分了日~给我说干求烦！！！！[em45]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('429', '2000', '不想就这样度过漫长的假期，却怎么也逃脱不了，反而有时候乐在其中，终究摆脱不了的小人物的悲剧。现在都1：36了我还坐在电脑前，心情不爽的对线上的人发脾气，关了qq，一个人听歌，肚子现在疼的要命，却也不想睡去。越想越郁闷，现在疼痛一点点象胃蔓延，头都有点痛，精神恍惚，不知道干点什么，看着别人的贴，脑子空空。对了，我买了童话大王的纪念版，里面的故事现在怎么这么少，不象以前，今天下午用了一下午的时间找鲁西西传，看了，没看完，看不下去了。我记的我第一次看，从上午看到晚上9点才看完，现在却觉得怎么也看不下去，可能是现在变的太现实了，没情绪看童话了，知道吗？现在的童话大王会在结尾写男女的情感了，而且写的都让我吃惊，小孩会看懂吗？哎回不去的童年时代，回不去的童话幻想。他们说回不去也好，回去不更好~老人家才会感叹时光的流逝~~~不感慨了', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('430', '2000', '1那一刻我难过得要死,我问自己:这就是我曾经想用生命保护的天下吗?2你的快乐是我生命中全部的信仰3一个人既加入注定另一个人既离开4你是我全部的天下5如果等待可以换来奇迹，那么我愿意一直等下去，无论是一年，抑或是一生6我喜欢沉默的人，因为他们善良~~7我在天堂向你俯身凝望/就像你凝望我一样略带忧伤/我在九泉向你抬头仰望/就像你站在旷野之上/仰望你曾经圣洁的理想/总有一天我回回来/带回满身木棉与紫荆的清香/带回我们闪闪亮亮的时光/然后告诉你/我已找到天堂。8我参曾经听人说过,云朵之上会有亡灵居住,我想我也会到上面,只是不知道,我能不能在天上看到你,如果可以,我想我就不会惧怕死亡了,因为我还是可以观望你的幸福.9我不寂寞~我只是一个人而已我的世界有我一个人就好~~已经足够热闹~~10你永远看不到我最寂寞的时候，因为在看不到你的时候就是我最寂寞的时候！那些曾经以为念念不忘的事情，就在我们念念不忘的过程里被我们忘却了……11你是我全部的天下12想告诉你就算有一天我们不在一起了也要像在一起一样朋友总是为你挡风遮雪,如果你在远处承受着风霜,而我无能为力,我也会祈祷，让那些风霜，降临在我的头上14不知道什么时候我们悄悄在风中长大15牵着我的手，闭着眼睛走你都不会迷路16你提着灯照亮了一千条一万条路，我只选择一条就是跟着你义无返顾低头冲向幸福．17一个人总要走陌生的路，看陌生的风景，听陌生的歌，然后在某个不经意的瞬间，你会发现，原本费尽心机想要忘记的事情真的就这么忘记了18我们都太年轻，以至都不知道以后的路竟然会有那么长，长到足够让我忘记你，让我重新喜欢一个人，就像当初喜欢你一样！13', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('431', '2000', '1我记得曾在某杂志上看到那样一篇文章，很平实的字眼，却让我很感动.里面有几句话，给了朋友一个很好的定义：朋友是那个和你去交游，什么都不带却面不改色吃的最饱的人；朋友是拿着你的啤酒瓶说只喝一口，而到你手里真的只剩一口的人；朋友是你无论高兴或是悲伤首先想要告诉的人；朋友是那个哪怕手中只剩一个苹果，也愿意分你一半，然后比你先抢到小的那一半的人；朋友是那个深夜三点一个电话将你惊醒，只为告诉你他想念你的人；朋友是那个你永远不会对他说谢谢，他也永远不会跟你讲这两个字的人；朋友是真真正正让你感到“一个足矣”的人......是呀，一瓶啤酒，一个苹果，一声永远不必说出的谢谢，这就是朋友的含义~~~~~~作者：那年那月大多说是在你有困难说时拉你一把的人吧，我认为那只是真正的朋友，而最好的朋友却是一直在你身边不离不弃，陪你哭陪你狂欢陪你寂寞的那个人2当年很真诚很真诚的承诺，如今却变成了最深的谎言3如果是自己的思想深处很重要的一个人，你们曾经一起笑，一起讲各自的生活各自的开心与不开心，一起逃课，一起去玩，一起、受对方的影响改变着自己的兴趣爱好，可是现在分开了还那么的想着她，这算不算是最好的朋友呢只不过很重要的一点是我们在生活上的差距很大，有时候我感觉我、们是两个世界的人我有我的世界，她有着属于她的世界。4朋友都是一个一个的驿站么``总是要过的似乎``不过不行么有的人真的很想守在她们旁边一辈子一辈子有几天活的就守在他们身旁几天这么做鬼了也幸福或者说朋友是加油站?她把她的所有加给了你让你继续前进你把你的所有付给了他让她继续停滞不知道了`总是很郁闷太阳的天`5友谊大概是互相在乎对方的感情吧朋友在每个人心中都有不同的定义只要你人为她是属于你的朋友就请抓住一辈子都不要放手从小抓起越小越真实一辈子的承诺谁又抓的住呢？6朋友就是那个即使不在你身边也会替你遮挡风雪的那个人7最好的朋友就是在分开好久之后，突然想起他，然后会大哭一场。再然后就是给他一个电话。说想他。。。。。。。可以互相任意的打骂。8多年以后就不要在联系了记忆中的风景才是最美好的9最好的朋友，是那些不经常联系最藏在心底最深处的人。彼此的心紧紧的联系在一起，虽然因为时间空间的距离，却依然给你心灵安慰的人.可是,很奇怪，我还是不愿意把伤心的事情和他们说,总觉得不希望他们看见我难过吧.10最好的朋友我认为是一个了解你的人，不会背叛，不回离弃你的人```朋友一生一起走那些日子不再有一句话一辈子一生情一杯酒我有点想哭.,,,,,10我以为我可以一直这样安静的走下去直到终点依然带着微笑从开始到现在的一成不变的苦笑我以为我的纯真在一年前的那个夏季的夜结束了直到一个月前我看到一个张开翅膀微笑的天使这是个发着光的夏天我希望结束之前我还有一辈子', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('433', '2000', '决定转身背对这你大步大步走下去不再回头望向远方永永远远望了你不许自己哭哭啼啼敢爱而不敢离虽然心中无法摸去初恋的日记多少明白心被掏空的感觉已经很久自己像一片落叶从你口中温柔说出的谎言竟然能够给我疗伤安慰发誓要陪着你天天天天在一起以为给你自由爱情会变辽阔没有人在乎我没有人看见我微笑中闪烁的泪光忽然可望兰兰天空大雨大雨的降临也许泪水可以洗去所谓真爱的感情不准自己只凭直觉沉醉在爱里虽然曾经为你写下初恋的日记虽然心中无法摸去初恋的日记[em35]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('434', '2000', '迷迷忽忽地做了一个近乎荒唐的决定:用2年时间改造pig帮他快乐起来~我的想法他们都不理解~~~看来他们是对的~我的想法幼稚的可笑又那么多此一举.会不会被人家认为脑筋不正常呢~~~不会被认为是疯子吧?呜~~~~不去想了..真丢脸不过不后悔要是不问怎么知道他过的好呢~~~~看来还是有必要地~~~~[em48]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('435', '2000', '遭遇一场海啸；', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('436', '2000', '一直以来对你的爱，呖呖在目。昨天到长沙，曾经属于我们的家心碎的感觉，对你是如此的熟悉，你的脸。眼睛，，你的嘴，你的身体。可惜我不曾得到你，让你遭到....回来吧/我会站在原地等你。[em46]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('438', '2000', '\"\"\"我爱你\"\"一直都挥之不去.我开始用酒精来缓解这些难过.五十几度的白酒像喝白开一样往下灌.然后抱着狐狸哭得一塌糊涂.很多年来,都没那么哭过.自打记事起,无论什么事,我都告诉自己不能哭,要坚强.眼泪是不能解决问题的.在别人眼里,我真的就很坚强.那一夜，我思考着，给自己一个绝路，做最后的了断。爱，就认真去爱，如果不行，那就彻底决裂！决不能眼看着你在别人的怀抱；用了一年又一周的时间,终于明白,所有的一切,只是不过是一场梦,是梦,就要醒来,不管那梦中的一切是多么美好,不属于的我,永远不会属于我.曾经告诉自己不要放弃,可是,这些日子以来发生的一切,让我明白,对她来说,爱我,是一件多么难,多么痛苦的事,如她所说\"\"你是一个永远不懂的女人心的人,永远不知道女人想要的是什么,永远也给不了我想要的!\"\"时至今日,我明白了,我永远也给不了她想要的,永远不懂的她的心,我不是她想要的那个人,所以,我是失败者,我承认.谢谢你所为我做的一切努力,谢谢你给我的一切,我那样勉强你和我在一起,对不起,是我错了.在我们的故事中，只有你和我，至少还有一个人今夜将为你失眠再见的时候...我的心，也轻轻地悸动着。这份在我心中萌芽，却不会开花结果的感情，已经开始无声地折磨着我，夜夜，夜夜...失去你是我最大的痛，自从和我说那句话我真的再想，我没有梳给他....\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('439', '2000', '这不是过去,还是你已经习惯暧昧.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('440', '2000', '我以为自己在很长的时间里已经能够去面对了,可是我分明感到自己的心一阵一阵的被硌的生生的疼,我只有用一句关我什么事来掩饰,然后笑......无语一切迷茫,突然乱了逻辑.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('441', '2000', '如果有一天，什么都没有了，只有对着空白的屏幕　流泪　　为了纪念．．．．．．', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('442', '2000', '1.当你正在忙时,却把手机开著,等著她/他的短信..你已经爱上她/他了2.如果你喜欢和她/他两个人单独漫步..你已经爱上她/他了3.当你和她/他在一起时,你会假装不注意他,但是当她/他离开你的视线时,你会急著寻找她/他...你已经爱上她了4.当她/他受伤或生病时,你会很关心她,替她/他著急..你已经爱上他了5.当她/他和别人要好时,你会感到吃不知其味...你已经爱上她了6.当你看到她/他那甜美的笑时,你的嘴角会扬起一丝得意的笑..你已经爱上她/他了7.当你看到这篇文章时,心里想到某个人..那么你肯定已经爱上她/他了有时候，我们应该珍惜身边值得珍惜的人....也许那是你最爱的.......[/color][em46]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('443', '2000', '柏拉图是永恒爱情的意识~在这世上有,且仅有一个人,对你而言,她是完美的,而且仅对你而言是完美的.也就是说,任何一个人,都有其完美的对象,而且只有一个.在观念世界你原本的另一半就是你最完美的对象.她就在世界的某个角落,也正在寻找著你.一种永久的,不求回报的爱.即使不能相守,只要看到对方幸福,这份爱便会绵延下去,直到永恒.有些人,上帝给了他们缘分,让他们相遇,但是却忘了给他们交点,于是这份爱,只能变成远远的守望,而这两个人,也将永远如同平行线一般,不能在一起.一直以为这个世界上,守望的爱情已经绝迹.原来,还有这么多的人在做着旁人看来傻傻的事,诠淌刈挪荒鼙焕斫獾挠篮?柏拉图的永恒.....只要爱的人得到幸福,这份爱就会永恒,如若不能有交点,那我愿意再等一世,固守着这份柏拉图的永恒,直到生生世世的永远我想柏拉图式的爱情是心灵的相通是精神的依靠是爱的真谛是永恒的爱情它的意思是只有精神上的恋爱。但没有肉体上的结合。这样纯洁，洁白的爱情是不可玷污的。才称为柏拉图式的爱情“世上没有柏拉图式的爱情。”如果有。那也只是爱情的悲哀，是人类的懦弱柏拉图式的爱情是什么？其实不就是一种精神上的寄托和抚慰嘛，一个梦吗？难道就没有想过把这段感情变成现实吗？仅仅做着一个永远实现不了的梦而已吗？没有勇气把梦去实现，难道不是我们的悲哀？不！我们不要这样的爱，我们要的是真正意义上的爱！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('444', '2000', '终于明白，逝去日子永远不会来了，我们就是这样苍老的！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('445', '2000', '姥姥姥姥病了。.............我哭了..........我说:姥姥你要是不好起来..我就不去上学了~~~~我是和姥姥玩大的.....姥姥最疼我了~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('446', '2000', '我该怎么办呢？怎么办呢？我很的可以那么做吗？娜会恨死我的。一直都是我对不起她，难道这次也要这样吗？我们会受尽身边人的责骂的。不可以那样的，就像是赵说的，我们不该在一起的。我不适合你，我只会给你带来麻烦的。不可以，没有人会希望我们在一起的。不可以，不可以，不可以，不可以，不可以，不可以，不可以，不可以！[em41]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('447', '2000', '最后的我们才知道，关于爱情，离开与靠近是一样不容易。而真正解不开，也没办法解开的，却是回头才看的到的那些，回忆，解不开、回不去。即使错过可能掌握的幸福，如果真的能够不后悔，真的不后悔也是很幸福的。真正幸福是可以微笑的承认，曾经很幸福．', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('448', '2000', '有一种幸福是有一个能让你不顾一切去爱他一辈子的人！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('449', '2000', '拯救，一辈子的救赎！一点希望都没有，我拿什么救赎！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('450', '2000', '爱一个人，就要对所爱的人负全部责任，不要在激情过后说：我不爱你了，我们分手吧。爱情不是儿戏，既然选择这条路，就要坚定不移的携手走下去，一直走到彼此生命的最后一刻．因为,我爱你！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('451', '2000', '他们说：三世是一个轮回的圆满，两辈子的争争抢抢换来一辈子不争不抢的得到，也许是前两辈子不知谁欠了谁太多的感情债，这辈子的轮回中终于有了一个圆满．可是，当我们这辈子把债还完之后，我们下辈子还会遇见吗？兴许会遇见吧，也许只是遇见后的行同陌路罢了．．．．．．', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('452', '2000', '你一直走在我的前面，可是你从来都不曾回头，我一直走在你后面，我却也从来不曾叫你，我们就这样一直延续......', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('453', '2000', '也许是太阳的光芒还未散尽，看见你倚在栏杆上灿烂的笑，我便觉得心被击成一块一块七零八落的，一片温柔的暖意在心中蔓延开来．．．．．．[em46]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('454', '2000', '终于明白你依旧是你,是我永远驾驭不了的你,是我永远走不近的你,是我心里永远最自我的你!却也是我最爱的你!![em43]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('455', '2000', '在外面呆了那么久,好想回家哦.想他了.真的想哭别,诶,发现自己好没用的别,连这么点小事都办不好.真不知道该如何去面对诶,人又生病了,发现自己好脆弱.呜....[eem17m43]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('456', '2000', '曾经的美好被现在的我们践踏!我也一样的怀疑,如果说今天是过去,那么明天就是今天,轮回一般,可是时间总是把美好的棱角打磨掉,曾经的豪言壮语变成今天所有的默认,我们在无奈,却无能为力．', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('457', '2000', '可恶的天气,爆热,神啊!下点雨吧!!5555........', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('458', '2000', '高兴的时候哭,悲伤的时候笑,我们的无奈有谁知道!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('459', '2000', '那个关于他的故事,已成为过去,只剩下一串符号半我记得曾经爱过他,连回忆都显得无力,忘却了退路,然后......没了所有', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('460', '2000', '文字灵感回来的时候,就是心不再受某些东西束缚的时候.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('461', '2000', '事情开始变得好搞笑,难以预料,曾经的海誓山盟就这样子变了,连玩笑都不如,所以我我选择放弃,只有这样,我才不会有错!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('462', '2000', '期待下雨,好热啊!下雨吧!![em43]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('463', '2000', '今天无意中点开了落luo败寂的日记,原来真正的文字是由心底的感情蔓延出来的.的,http://www.95886.com/diary/index.asp?user=落luo败寂', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('464', '2000', '那天坐公车去你那里，看见很长的车厢里，有个和你一样的身影，我突然难过的低下头，是不是自己又在想念你？[em43]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('465', '2000', '没想过，关于你，居然这么爱，爱的连自己也觉得惊奇，视线跟着你游离，却害怕被你发现而必须小心翼翼，迫不及待的想看见你,看见后却装作毫不在意的样子,看见你和别的女孩说话,我会心里难受,然后自虐自己,雷雨那天,被雷声惊醒,第一个想到的居然是你,是宿命吗?注定难逃......', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('466', '2000', '传说，所罗门王有一枚涵盖了人类所有智慧的戒指，上面只刻着一句话——“这也会过去”。紧张什么？风再大也会停息；畏惧什么？夜再深也会有朝阳；贪恋什么？花再美也会凋零；庆幸什么？山再高也会有裂谷。没有什么，有了风才会有平静；没有什么，有了黑夜才会有光明；没有什么，有了枯萎的伤感，才会有盛开的喜悦；没有什么，有了深邃的峡谷，才会有高耸入云的顶峰。计较什么，烦恼背后总是快乐；炫耀什么，明媚的笑脸也逃不开哭泣；逃不开，躲不掉，愁不长，笑不远该来的总是会来，不要烦躁，不要喧闹，不要吼叫，你要知道，沉睡的所罗门王的那枚智慧的戒指，它说：不要被世俗缠绕，不要被记忆淹没欢笑，泪水，光荣，屈辱~~~~~~这一切的一切都会过去的。高考只是人生的一条路，如果你跌到了```请快站起来``这一切都会过去的[em43]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('467', '2000', '朋友,其实我也不想变.但是那真的是你门逼我的,知道吗?有的时候`你们真的很不故别人的感受,做的事情真的好让我寒心..每次我都原谅你了,但是你们不是改,而是得寸进尺知道吗?每个人都有自己的忍耐限度的,有的时候,我不想冷言冷语的说话,但是不那样,你们又会做出很多不可想象的事,我真的把身边每个朋友都当做知己,只是.你们有的时候是真的过分了点..不要老是觉得是别人边了,而是要看看自己是不是做错了什么,而让一有人在这么段的时间内变成着样,我的变化,其实也是在压抑自己,好多时候有话要说出口,但是总是又缩了回去,因为过多的话只会让你门更加放肆,好想你们能变一点,但就是无动于衷...失望,知道吗?疏远你门.我心里也不好受,但是有的时候真的没办法,因为那样我会觉得自己想个傻瓜一样,..不要再把罪推到别人身上了,而是要发觉一点自己的过分!你们变一点`我也就不\\会变,,还是可以像以前一样..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('468', '2000', '你说几年抑或几十年以后等我们都长大变老的那一天，那些曾经变成承诺的誓言，那些说过要一辈子在一起的人，会不回随风散落天崖，消失不见。你曾问我你到底是个怎样的人，我觉的你就像个长不大的孩子，我看见过你对自己深爱的女孩子的执着，看见过你曾伤害过深爱着自己的人，看见你总是说喜欢和你妈妈吵，看见你在要面对选择时总是逃避，。。。。彻底的像的孩子。你知道么，这几个月我觉的自己身边已经发生了翻天覆地的变化，我看到我曾那么深深爱过的朋友就这么轻易的同我挥手说再见，我看的面无表情却心如刀割，前几天看到M就这么一个人在外面从一个城市的这边跑到那个城市的这边，我突然想起以前的夏天我都是和她在一起过的，而现在我都忘记自己到底有多久没见过她了，我怕以后的以后我连一些人的样子都记不清了，真的有些害怕了。。。那天你告诉我如果有一天我可以心平气和的跟你谈起Z那么就说明我已经完全不在呼她了，而现在我真的就可以这样心平气和的说起她，当我知道她对你说她开始对这个社会感的害怕时，我有些难过，因为如果在以前我会告诉她，有些人即使不在你身边也会保护你的，但是现在我知道以后还能陪在她身边保护她的朋友不会再是我了，当你告诉我她有了自己喜欢男孩子，她现在很幸福，我就很放心了，记得以前我曾地她说过，你的脾气这么臭，不知道还有谁会受的了。必竟朋友不可能陪在她身边一辈子的，她以前说过以后要我活的一定要比她幸福，现在我真的也很幸福，但我希望是她比我要幸福，一定要。现在我有个很喜欢的朋友，我记的有一天我问她，我说，我有一天想你了怎么办？她说那你就喊我的名字啊，我想你的时候也会喊你的名字，那时候我突然觉的很温暖，我觉的这就够了，真的够了你相信这么一句话么，以后的日子还很漫长，长到我可以重新喜欢一个人，就像当初喜欢你一样。我相信我总是说我不想再去回忆以前的事，其实是怕自己会懦弱的掉下眼泪，那一天和一个朋友谈起以前的一些事，谈到很晚，也谈到了一个曾经要好的朋友，她突然问我，她说，你现在想她么？看到这句话时我觉的喉咙堵的特难受，原来那些人在我心里烙下的印记，是没有办法磨灭的。以后我想好点生活，其实当你告诉我你一直还记的你曾经说的那句话，你说有一天我们要一起去日本的，你说你一直还记的你没有忘掉时，我很感动。恩，等几年以后，不要太久，我们一起去那里看看，我想看名古屋花飞扬的时落在了北海道还是永无乡，我想听听全世界最寂寞的雪景。听说日本有很密集的群楼大厦，在那里跟本找不到地平线的方向，听说站在看不到地平线的大地上会觉的人潮匈涌而没有朋友，我想和你一起，应该不会觉的孤单了吧？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('470', '2000', '我的夏天终于来了回到过去[em35][em39]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('471', '2000', '一路走来的痕迹,是那么清晰.两个人的脚步,在刻着烙印.印的很深,很沉,也很幸福.这就是我们的爱/.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('472', '2000', '今天看小丸子的动画片，想到了爷爷。也被大野和山衫的友谊感动~真是好片啊还有那个动感的黑线--b[em43][em48]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('473', '2000', '今天上班没什么事情做,觉得好无聊哦.但是有看到一个广告人的bolg,有很多很好玩的东西.看完以后觉得受益很多.于是我想自己也应该有这样一个广告的...不能说是日记本吧~可以收集很多和广告有关的东西~~谁叫我的职业是做这个的呢?老总也和我说要我多收集很多的信息,这样到用起来的时候才不会抓瞎.可是我的记性真的很差,总是记不住东西,刚刚看的也会忘记.....希望以后会慢慢变好的.今天收了一个师傅...呵呵其实应该说是认了一个师傅...但是我还是说是收的吧~因为是他叫我做他徒弟的,不是我要做他徒弟的~~呵呵~~这是很重要的信息哦~~~师傅是和我一样职业的~文字工作者.只是不同的是,师傅已经工作7年了,而我只工作了...1个月吧~还差4天就正好一个月了师傅说我每天要看报纸,然后看到自己喜欢的广告,用自己的想法写出案子给他,每天写2个...觉得有一点点痛苦...不过如庋岢至思父鲈聗我应该也会变n一点点吧~西西~~什么时候我才会变的很n呢??这一点我要好好思考一下....思考中...对了,今天下午lg去逛书店,我让他帮我留意<<广告文案传真>>有没有卖的.呵呵,忘记是听那个前辈和我说的,这本书很好了,所以想买来看看~如果lg帮我买到了~呵呵它就是一本可以坐火车的书了~嘿嘿,还是卧铺......陶醉中...以后把每天的学习体会写到这里好了,反正老总也是要我写的嘛~也让这个卡哇依的本本来记录我的广告成长经历吧:)', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('474', '2000', '\"昨天晚上和何燕聊天聊到很晚很晚才睡觉.今天感觉特别困就像是做梦一样.还好,今天公司没什么事情要我做.否则我肯定挂了....终于熬到5点多了,还有一会就又要下班了...回家肯定觉得累死了...师傅今天给我讲课了,听完以后觉得还是很有道理的,只是不知道真正用的时候是不是可以做到.我想这个还是需要一定的时间来积累的吧~不是说就会的哈~下面把师傅的话记下来吧2005-06-3013:54:52电池电量低今天先教你文案的结构.首先是标题.4a公司也管之叫h/l,我去年是跟台湾人做地产,在台湾人的结构里,标题叫做catch(抓人的文字)标题的差异,可能使广告效果提高或减少达19倍之多.从标题,往往也应该看出所宣传和推广的产品的调性,广告的利益点.或者能让人产生望下读的兴趣.你写完一个标题,最基本的测试方法是给周围的人看,就给他看标题,问他如果在报纸上看到这个标题,有没有兴趣望下看.福来宫温泉山庄主题：绿野仙踪，浪漫心曲178元/位这个应该是你标题吧如果是标题,那就非常失败了.不能引起人望下读的欲望和兴趣,也没说清楚产品的利益点,上来就赤裸裸一个价格,换做是你,会看这样的广告吗?都不知道是个什么东西呢,就标上价格了.一般来说,文案的结构是这样的.标题提出问题/话题或者利益点,接下来是支持标题的文字做解释.这种解释性的支持标题的文字,在4a可能会叫做copy.我习惯的是叫sub.解释完标题后,往往会有一些产品卖点性质的文字.我们可以管他叫做条列卖点或者子弹.就是很硬性的产品的东西.还有一个比较关键的,就是文案里弱于标题,但是同样需要突出的文字,我们叫他pattern.最后,是随文部分.包括厂家名称\\销售电话等等关键信息.重点标注的.叫pattern.写文案,先要思考清楚这么一些问题:对谁说,说什么,怎么说.一般来说,一则文案最好只说一件事,如果非要说好多事,那也要有个轻重层次和逻辑关系(这个是你现在最容易犯的毛病)只说一件事,不是要你写很少的文字.明白?比如,很多线,这是必须有的信息,但是这些线路一定有共同点,或者说这个旅行社一定有自己跟别人不一样的点(你应该帮助他挖掘这样的点.)例如:价格低(所有线路都实惠)\\服务好(服务特色与所有线路有关)\\有折扣\\值得放心......光有线路是不能深度沟通的,所有旅行社都有这些线路,但加上旅行社自己的卖点,就成为独有的利益点\\记忆点了.这就是\"\"说什么\"\"要解决的问题.明白没?呵呵.大家都这么说,你就更不能这么说了.比如说专业吧.单纯专业,还不是\"\"说什么\"\"因为谁都可以说自己专业.专业,不足以成为独特的卖点.这个时候如果专业确实是最重要的沟通点,就需要描述专业的过程,支持\"\"我专业\"\"这种论断的理由.比如说:\"\"所有的医生,都做过1000例以上的手术\"\"或者:\"\"去年,有100个韩国人来我这里整容\"\"又或者\"\"每年,接待10000以上的患者\"\"这就能让人相信我专业了.拿海飞思举例:去头屑专家,就是他从众多洗发水里找到的定位.又比如,我可以反过来诉求\"\"请不要在本院做整容手术\"\"(如果你还没有了解清楚本院的专业程度)\"\"抱歉,在本院做整容手术真的要贵一点\"\"(一分钱一分货,专业当然更贵)方向可以很多.明白一点了没有?我以前做过一个\"\"禁止这16种老憨来美国牛仔烧烤城\"\"内文就列的16种特别土的人.客户就那么发了.一个多月以后都还有人打电话给客户咨询那个广告.先学习说服你们总监.这个也是你需要积累的.我是举例,你不一定要做那么极端的.但是不能连发散思维都不做就开始写.写你说的那些产品,有创意的客户不一定能接受,但是你也应该试着写.哪怕写两稿,一稿是客户想要的那种,一稿是你自己觉得该那么做的.师傅说了这么多,我大概的把这些都留下来了,以后再给的时候就找到这几点把:)说什么,从哪里说...虽然这个过程有一点点难~不过,积累就会变好的嘛~~\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('475', '2000', '给你一个承诺。我们牵手走。不离不弃。曾经说过这辈子一定要娶你。你还记得么。？我一直克制住自己的脾气。在第一时间哄你，你要听话。快快回到我身边。我会好好宠你。不要让我难过好不。？我是真的真的真的真的真的很爱你', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('476', '2000', '人会变这点我知道可是可是真的会变得那么快那么大吗？突然觉得自己变得自私了，不像小时候，总是替别人想，从来都不想自己，这不是夸大，小时候真的是觉得别人好了自己就会高兴。现在长大了，虽然哥哥还是经常说我笨，说我傻，可感觉自己多了个心眼，为别人想的同时，也为自己留了后路。长大了，却不像小时候那么快乐了，为什么呢？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('477', '2000', '设置了留言本，看了我的日记的人，可以去那里留言了。非常欢迎哦~~[em48]就是“首页”两个字的下边“旋律的留言本”', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('478', '2000', '真不知道为什么妈妈也总是向着大哥说好是去给我买东西的结果到了商场却一直在意替哥哥买一件结果我的衣服没买哥哥的衣服妈妈却总是觉得不合适真不明白在妈妈看来我永远不如我那个比我大5岁的哥哥吗！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('479', '2000', '给妍妍打了电话才知道，原来自己在他看来不过如此，从没指望过他会认为我是优秀的，可也没想过他把我看得那么轻，我的确不了解他，我们不是哥们，是普通得不能再普通的朋友，而这仅有的朋友关系似乎还要靠上一辈的维持，真希望妍妍在说谎，希望是她自己在夸大，我永远也不想相信我的地位仅此而已，我的要求不高，可也不想会这么低啊！！！！！我难过是到底是为了什么！你到底这么多年都把我当什么看了！！！！！！我不要做累赘，永远都不要！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('480', '2000', '生命中，不断地有人离开或进入。于是，看见的，看不见了；记住的，遗忘了。生命中，不断地有得到或失落。于是，看不见的，看见了；遗忘的，记住了。然而，看不见的，是不是就等于不存在？记住的，是不是永远不会消失？这些天一直在想，如果我真地离开了，就真的很难再看到他们。可是我想如果我不把他们忘记的话，我也会很难受，我真地把他们当好朋友，离开他们，好难过...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('481', '2000', '从来没有过的想写日记的念头与冲动。今天不妨给自己一个角落去安放自己杂乱的思想。未必能写多少，但想写时就写。这是我的想法。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('482', '2000', '心情有点沉重，心口有点微痛最近是妈妈的50岁生日，但我忘记了。应该是忽略了。这是怎么都不可原谅的忽略！舅舅与小姨从遥隔1000多公里的地方各邮寄了200块，还有读初二的小表妹也寄一张贺卡来。而近在身边的做儿子的居然忘记了妈妈的生日！前两天还是爸爸谈起，我才知道最近是妈妈的生日。当时妈妈很轻描淡写的说，等60岁再好好庆祝啦。但是今天妈妈收到小表妹的生日卡，我看到她眼中有点湿润。做儿子的太不应该了。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('483', '2000', '\"今天和hn去n远的地方见客户,谈稿子的事情.天气暴晒,我们出去了快5个小时,走得脚疼死了......下午回来以后给师傅交作业,他说比昨天的好一点点了:)~~不过还是有很多很多不好的地方哦~看来我的问题还真是很多哦.....不过也还好拉,谁刚刚做的时候不是这样的呢:)今天交了2篇作业:精品购物指南2005读者年系列活动定报广告之三十六主题：她喜爱《精品》，她喜爱花草茶那一年，我们认识100天。百天的纪念，我送她一支香水百合，换回她一个淡淡的微笑；那年她的生日，生日的礼物，我送她一条玛瑙手链她给我一句话“谢谢你，我很喜欢。”去年的情人节，情人的心意，我送她一束鲜艳玫瑰，得到她一个甜蜜的吻；今天，结婚一周年当然要追求更加完美我知道一个秘密……她喜爱《精品》，她喜爱花草茶。￥48=半年精品+她喜爱花草茶一罐（价值：38元/罐，2g*20袋/罐）总价值：86元/套，限1000套，口味随机精品澳大利亚旅游与visa联手广告主题：去澳大利亚，我什么也没带！我在享受……青青茂盛的热带森林，原始纯净的绵延沙滩，松林滑雪道、枯萎的沙漠，令人炫目的、生动的城市…..可是，我什么也没带。一切，只因…..我是：visa尊贵客户！visa澳大利亚快线轻松畅游澳大利亚，独享自由多彩的假期visa一线牵，带上自己就足够了！师傅的讲课:2005-07-0116:53:55电池电量低先说第一个.￥48=半年精品+她喜爱花草茶一罐（价值：38元/罐，2g*20袋/罐）总价值：86元/套，限1000套，口味随机这些很好.尤其\"\"口味随机\"\"四个字.但整段内文特别象那种很蹩脚的故事或肥皂剧.看不出跟精品有啥关系.跟这个促销有啥关系.广告不是编故事.如果要编,一定要写得比专业写故事的还要好.因为咱的字比他们值钱.这个广告换我来做,可能会是这样两种思路第一种.根据精品的版块名字来写.(或内容)句式就是她喜爱.......她喜爱.......列个7.8条背后都是年轻女生喜欢的东西最后是那句主标和促销信息.写得可以非常时尚.第二种,用花草茶的口味来写.比如:柠檬口味适合......(小女生喜欢的梦幻场景)香草口味适合......青柠口味适合......(我没细想,你可以把这些场景想清楚)最后出促销信息.你做的第一个广告.是两种产品的个性放在一起.有点象\"\"联合促销\"\"写的关键是要找出两种产品的共性.找到了共性,随便单独突出哪一种产品的个性都可以.所以,说什么,说的就是两个产品之间的共性因为她喜爱这个名字很容易看出这种茶的目标对象,所以,可以推论这个广告一定是做给年轻女生看的,对谁说就是对年轻女生说.怎么说,当然是用年轻女生喜欢的事情和口吻说了,有个性一点,简单一点,时尚一点.明白了没?你自己再想想,我的两种思路下,广告的画面该是什么样.呵呵.试着画出草稿来吧.从今天的作业开始.发散一下味道——时尚味道——有趣的生活场景味道——什么样的生活场景适合这样的味道——青柠味道适合初恋，**味道适合....等等等等。画面有时候比文字沟通力更强。做文案是做沟通，所以一定要画。描述给我。画面是什么，版面如何安排。要突出的文字怎么突出。主题：去澳大利亚，我什么也没带！画面：象旅行者在风景名胜前拍照留念的那种图片。右下角压一个visa的logo下面跟这两句。visa澳大利亚快线轻松畅游澳大利亚，独享自由多彩的假期visa一线牵，带上自己就足够了！你比较下你那段文字。有或没有，对沟通有帮助吗？visa卡的功能，大家基本都知道。如果有大家不知道的功能，加上一两条信息就可以了。但是你这个广告不就是想突出visa方便、国际吗？我用那些元素，足够了啊。消费者也肯定看得懂。不会因为你那些文字，懂得更多。旅行的乐趣，千人千样，你写的那些，不一定是大家喜欢的，留给他去想象，或用画面来做，不是更好吗？给你个建议。写完后检查下，可有可无的文字，通通删掉。关键看你信息之间的主次，逻辑关系。大概的就是这么多了~~还有一些小的细节有讨论到~但是我觉得主要有帮助的东西都归结到这里了~~明天开始的功课要有画面的构成了,师傅就开始加我的重量5555,不会画画还要画,会吐出来哦.....今天还被罚打手心....怎么办?会痛痛~~~对了,今天给lg寄东西了,是暑假的时候让他回家带给爸爸的~~嘿嘿~~开心:)爸爸明天就来北京了,给我带了好多好吃的:)我就喜欢吃好吃的~哈哈期待哦......呵呵~觉得累了,回家要好好休息:)\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('484', '2000', '别骗自己了，我这些天心情怎么可能只是烦躁？心理那种难过的感觉怎么可能是天热闷出来的！我想我肯定知道是什么让我这么难受，只不过我不想去认真的想，也在强迫自己不去想，我怕一旦我把尽力忘了的事想起来，会比现在还痛苦。想起还是遗忘那个方法对我更有好处？我拿捏不准，所以我选择了糊糊涂涂什么都不想，糊糊涂涂的在这痛苦。不知道是不是心情不好就会乱发脾气，这两天为了点小事就总是会和妈妈吵起来，我这是怎么了，为什么会这样！我不想和妈妈发脾气的，真的不想让妈妈着急生气', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('485', '2000', '[face=楷体_gb2012][/face]刚跟包子散了,说真的有点舍不得.他对我真的很好.不过我不爱他.唉~!龙在我身边,真的,着就够了~!他生日那天,我惹他生气了.他把手机咂了!!!!!!!!我心疼啊,他真的生气了啊!怎么跟家里说啊！晕了~!我在原地找了半小时,都摔散了!真败家啊![em39]那能怎么办呢~已经摔了~妈妈去她妈妈家了,我就跟爷们玩来了!唉`!考完试了,砸了!说不顶还降级呢!那怎么办啊?[em39][em43][em35]实在很郁闷呢!龙他们在玩游戏呢,我自己都很郁闷呢@[em40]呵呵,龙好可爱哦![em48]嘿嘿,我玩了不写了.88', '兎', '°庅﹖<BR> 好的很撒....<BR> (2005-06-', '兎');
INSERT INTO `dede_addonarticle` VALUES ('486', '2000', '天天下雨。以为自己还是读书时的自己，不怕风吹雨打。特别制造浪漫，雨中漫步。结果是严重感冒。[em41]有个网友要我为她的社团的2周年庆典制谜。这个笨蛋以为制作谜语跟吃饭一样容易呢！而且一来就是20个。叫她来看看我心中的苦[em43]唉，不知如何交差呢。', '兎', '°庅﹖<BR> 好的很撒....<BR> (2005-06-', '兎');
INSERT INTO `dede_addonarticle` VALUES ('487', '2000', '有点点兔死狐悲的感觉。公司最近我这个职位的旧人换了一大批。走的走，调的调。全部被其他公司招来的人占据。似乎有点他们的今日就是我的明日的感觉。到公司才8个月，还好老板比较看得起。虽然是新人，谈不上有经验，居然也让我去开拓一个市。不过应该检讨：本人还是没有全心全意的投入，不投入迟早会死的。mi你要十二分的投入，因为你肩上承担着很多责任。工作不要儿戏！应该蔑视兔死狐悲的感觉。[em45]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('488', '2000', '呵呵·没想过我会这样！！人的脑壳都搞晕哒！我不想想任何事！唉！终于解决了·真的有种解脱的感觉！我现在才觉得以前有多么难受！现在好了·我不用顾忌这么多了·想怎么样久怎么样！我又流泪了！这又是个成长的过程吧！我觉得以前真的很累·现在好了我做了许多后悔的事！也是不应该做的事！从现在开始！要看开一且！[em43]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('489', '2000', '决定转身背对这你大步大步走下去不再回头望向远方永永远远望了你不许自己哭哭啼啼敢爱而不敢离虽然心中无法摸去初恋的日记多少明白心被掏空的感觉已经很久自己像一片落叶从你口中温柔说出的谎言竟然能够给我疗伤安慰发誓要陪着你天天天天在一起以为给你自由爱情会变辽阔没有人在乎我没有人看见我微笑中闪烁的泪光忽然可望兰兰天空大雨大雨的降临也许泪水可以洗去所谓真爱的感情不准自己只凭直觉沉醉在爱里虽然曾经为你写下初恋的日记虽然心中无法摸去初恋的日记***************************的确是首很好听的歌难怪他们都喜欢', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('490', '2000', '谢谢你们帮助我关心我但我想以后的是只有自己才能做主只有自己才能帮助自己所以我想尝试着独立不知道自己有没有这个决心希望老天可以让你们不要对我这么好我怕你们对我太好的话以后没有你们的话我什么都做不好而且他们对我太好总让我觉得欠他们的为什么一定要这样总是让我遇到这种事叶子说我这个人重感情念旧外加人傻也许她说得没错他们对我这么好真的不是感动可以表达的感觉上他们就像是我的亲姐姐亲哥哥就像是我的家人每次想到可能会离开他们就忍不住哭出来今天我自己都没想到会在哥哥家呆了将近1天他的画的确是不错啊本来以为他和我不是走一个风格的没想到临的都差不多画风差得不多呢这几天来我才知道想要忘了他们是绝对不可能也许我的确偏心对同学都没这么好过吧呵呵既然忘不掉你们那就让你们成为我最好的朋友永远的朋友！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('491', '2000', '雨在天地间织起一张密密的无形的网,伫立在网中,开始了对你无端的思念......可是,你分明就在我的旁边!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('492', '2000', '他和她彼此坚守着只说再见,不说BYE-BYE的誓言,因为他们相信只要说了再见,无论在哪;无论多少年后,他和她会被两个字的缘分牵引,再见面......', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('493', '2000', '梦里:你对我说：“一起走吧.”“恩。”幸福便开始漫延,这么幸福的时刻,可以一直走下去吗?幸福的步道,总是那么短,我们可不可以赖着不走.-几米', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('494', '2000', '冷暖自知期待...预谋...期待一场预谋!', '兎', '°庅﹖  (2005-06-17 19:46:20) 你一直', '');
INSERT INTO `dede_addonarticle` VALUES ('495', '2000', '占卜,或许只是帮助自己看清自己的工具.', '兎', '°庅﹖  (2005-06-17 19:46:20)<BR>', '');
INSERT INTO `dede_addonarticle` VALUES ('496', '2000', '梦醒!我们要学会自救!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('497', '2000', '夏天。天上飘着白云。太阳辣辣地照着。树懒，人也懒。爸爸在下棋，妈妈在厨房忙，我在睡觉。这样的下午让我恍恍惚惚，不是精神不佳，反而是自我感觉精神挺好。这让我回想起小的时候。小的时候模模糊糊的记忆。那时也这样，我在睡觉，妈妈在厨房忙，爸爸在下棋或者干别的什么事。家那种融合的感觉，真好。只是以前爸爸和邻居下棋，现在他都会在上网和人对局（我感觉老爸上网这本身就挺有意思和神奇的事[em36]）；而妈妈忙的那个厨房不再是乡下那个烧柴的厨房了，现在的住处已不知道是第几十个落脚点了；而我，以前小时随便在哪个角落也能搁下，现在要一个大床才行了。挺有意思的，模糊的记忆。对比以下过去，也听有意思的事情。所以有时真的不想生活变化，就这样下去，真的很好！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('498', '2000', '\"最近整个人蔫蔫的...自己都不知道怎么了虫子还问我最近怎么不神拉?以为我\"\"长大\"\"拉~其实自己心里很闷~哪还有心思发神经~给他们讲笑话~逗他们开心~人是不是总要变的?自从bb谈恋爱了她陪我的时间少了好多~我知道不该吃小白的醋....不过bb对于我真的太太重要拉~~我不想这样....我知道自己一直都是个\"\"不懂事\"\"的孩子..可我就是不懂事...他们在一起我不开心~bb说:轩儿最好了...这时我只能一副乖乖的样子对她笑~对bb我完全没有办法...不想对她发脾气...呵呵记得以前在一起时~我最能胡闹了~~每次bb都拿我没办法什么都依我~~[em48]晕了..晕了....现在姐姐要给leo表白咯~~不知道姐姐会不会变为下一个bb.....不知道..还要不要支持姐姐......知道\"\"重色轻友\"\"人之长性...[em40]\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('499', '2000', '这两天的周末，也不知道是用充实说好呢，还是觉得累。体力是不是有点透支呢？周6的时候狗狗从美国回来，好多年没有见了，感觉她都已经长的不像中国人了。晚上的时候几个原来同学在一起聚餐，说了好多，感觉大家都有变化了...是长大了吗？可能我也会有变的吧...爸爸来北京了，今天去见爸爸。感觉又老了好多。人一旦老起来真的很快，我出来的5年里，爸爸妈妈都老了很多。很担心爸爸的身体，爸爸说在新疆的时候忽然发心脏病，然后去到医院了。听得我好伤心哦，真的很担心爸爸，身体一天没有一天好，觉得好难过哦！！爸爸说的时候我就很想哭.......这两天都没有写作业，明天白天的时候一起写吧~~作业还是要写的，工作也是要做的，生活还是继续...只是觉得很难过而已，我没有办法呆在爸爸妈妈身边，现在也没有出息明天又要上班，要做7月份的学习和工作计划了。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('500', '2000', '2005/07/0300:36oh!今日系我第一次系网上写日记!无d乜野好写!开心每一天!傻傻噶我!茵er!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('501', '2000', '我想，当不被朋友信任的时候是最失望和难过的。吧从此两人产生了距离...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('502', '2000', '众擎二周年谜语1、诺言成空若无2、人参老根3、十五的月亮月无缺4、叫天天不应，叫地地不灵人间无道5、读三国有感水起暗流涌一日起风波夕阳添血色刀下冤魂多冽6、不关山青水秀事却关水青山秀事何物因此多注目点点滴滴都关情小雨清幽7、喂，去书山怎么走？勤8、一撇一捺人生正途八路9、三个好汉一个帮，轻松抬起一个缸众擎易举10、精灵紫风下岗的老八路シ翰林院ょ深深深几许ン\\‰不系之舟\\爱你不枉今生豆豆思诗梦雨花之雨ぷ大木桩—达清風飛逸勤ζ紫罗兰的笑魇=陶==浓情咖啡众擎菜刀众擎-幺一狐女$红玉贵族狮ぶ雪ξ翼ぶ晶儿如水', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('503', '2000', '七月的太阳好热*七月的雨水好凉*七月的流星好热闹*七月的心情好寂寞*思施你在哪里````你知道我在想你吗```你知道我在等你吗```你知道我杂找你吗```？在她乡的你好吗`是否愿意来打开我的心扉倾听我的心情呢？？？？？？？？？？？我现在好累我现在好烦我现在没有方向每次我都投一只硬币：如果是反面我就爱你三天：明天。今天。昨天如果是正面我就爱你四天：春天。夏天。秋天。冬天我们每次都说再见‘因为我们说了再见就会再见面的```````````希望你这次快点来到我的身边拯救我七月的心伤`我爱你思施永远永远````', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('504', '2000', '过几天是中国的传统‘情人节’了你在哪里啊``？可以陪我一起度过吗``````````我现在在家里？好想你哦``````````回家的这段时间来我过的不是很愉快``````也许我会在不久要离开炎陵下一站``还不知道是哪里我现在好想要你在我身边陪着我你说你要去学电脑`是去哪里啊还会回来吗？///还去长沙读书吗你说我还可以找到你吗也许我这次出去的心情不会太好我现在真的好想见到你``', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('505', '2000', '```````思施你在哪里啊````````我好想见到你‘你什么时候来我这里咯我现在真的不想呆在家里了', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('506', '2000', '又是一天,有点繁忙的一天......上班的感觉开始有点适应了,只不过适应了以后反而少了那么一点点斗志.总是感觉每天的时间太少了,还没有做什么事情就又到了睡觉的时间了,怎么时间会不够用的呢?|每天到家以后就变的很懒,做饭有的时候都觉得痛苦,吃完饭往往就什么事情都不想做了.我怎么这么容易觉得累呢?师傅今天说了一段话,我觉得我要记得,对我以后是很有帮助的.电池电量低17:19:27文案要做的工作，一定是从产品里发掘戏剧性的东西。比如，要做这个，你可以讲法国没错，但一定要跟美食有关。例如，你可以讲厨师是如何从法国请来的，在法国是如何如何牛b，如何难得吃到他的东西。你还可以讲原料是如何从法国弄来的，中间为了保鲜做了如何之多的工作。你还可以讲主菜在法国有什么样的典故，一般要在什么环境才能吃到，吃之前需要怎样的仪式，在宫廷里这样的菜是什么样的地位等等。而你，选择了最不能打动人的一种表现方式。今天在讨论的时候和师傅有了思想上很大的,本质上的歧义,导致了忧郁吧.....师傅和我想做的是2中不同的广告,他要的是销售,而我要的是意境.其实我是不知道我的追求是不是对拉,但是在我的想法里，我所喜欢的,追求的广告就是完美的,那种境象的东西.可是似乎师傅是现实派.这样两种截然不同的出发点和追求性似乎没有办法继续下去了.我还是想坚持我所追求的东西,这么多年了,这一点是没有那么容易可以改变的~!以后,就我自己学好了,应该也会有成绩的:)', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('507', '2000', '夏天真奇怪。夏天的天为什么会特别的蓝夏天的云为什么会特别的白不是一般的特别真的很奇怪，当我想这个时，太阳都不会感觉特别晒了。夏天的云最喜欢的啦。有时暴晒之下，一朵云飘来，地面就有了一片阴凉的板块。以前在乡下的时候，上学或者逃学在外边时就特别向往有一朵云能跟着自己走。特别有幻想，很幼稚。听说云是很灵性的东西，有些人都上是彩云，有些是白云，有些是乌云了。不知道自己头上的云是什么颜色的？还有据说，西部大概是西藏那边有所谓的祥云，如果有幸看到祥云，那就会得到保佑的。所以我的桌面就换了一个西藏祥云的。老天保佑！[em39]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('508', '2000', '今天去同学家玩，怪没的味。觉得日子真是一团糟，哎呀！不知道别人是怎样过的，反正我是没劲透了。有时候宁愿累点，也不要这般无聊。[em40]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('509', '2000', '已经有2天没有写日记了,这两天一直都很多事情做.没有时间交作业,也没有时间写日记.师傅应该生气了吧~可是没有办法啊~~过了这几天周末的时候写多一点作业吧.我觉得什么时候应该和师傅见一次面了,见面交流一下应该会更好一点吧:)~~不知道他会不会生气的不理我了?5555~~~师傅哦,我不是故意的,是这几天真的很多事情要做.一会要去见新客户,一上午应该又不在公司了.真不清楚为什么是要我去,我还是新人,什么都不知道啊...迷茫中...昨天晚上写了一个旅行社的软文,不知道是不是要这样写哦,呵呵,马姐来了一会要问下她:)~~~多多请教,西西~~~~]lg今天开始放假了,他明天就要回家了,嘿嘿,还有一个多月他就要来北京见我,我们就可以见面了:)开心~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('510', '2000', '[COLOR=#ff69b4][FACE=宋体][/FACE]我今天其实没得话写，等一下再来好了', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('511', '2000', '猪啊不管发生什么事都要开心面对只有这样才能确保下一次挑战的成功啊不要做那些与学习和事业无关的事了要知道那只会让自己伤神干嘛为了那些东西而伤心呢努力哦要证明自己怎么自己的失败不是真的失败证明自己真的不是骗他我还年轻有时间啊昨天是很伤心可那又能怎么样呢他不了解我我又不能怪他只能说是自己的错啊恩没关系啊我不需要他的理解过去的会过去的啦总之要高兴', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('512', '2000', '中考成绩终于知道了~还可以吧回望初中生活仰望未来心情好复杂~~~~~~~~~~~[em47]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('513', '2000', '我才发现自己真的很无聊，上网时的那种不现实的确让人觉得飘渺，虚伪而空荡，也许我真的不该学会这个东西的，让自己在说完话之后又有一丝自责，也许真的是无聊，我早该找点儿事做了，那样会让我伤心的心得到一点充实，他在干什么，我仍然忍不想去问，可是我又得现实了，因为一切都完了，过去了，而且他也将永远从我的视线中消失，不关有多难，我都该听他的话：放弃他。因为他的不明白，我也无需证明了，我会忘掉一切的啊，相信自己，是的，加油，猪啊。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('514', '2000', '我想好了我决不复读的，不为什么，因为我喜欢大学，而且我会努力的，不管怎样，我丢会努力的，我相信自己的实力，我要去实现自己的梦', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('515', '2000', '[COLOR=#00bfff][/COLOR]我今天有一大发现，就是类个蛋粑粑有蛮蠢，类就不是盖的啦，估计跟小来隙得一哈好地。呵呵', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('516', '2000', '我还以为这个本子就这样丢了呢~~原来是换网址了啊~~恩很好~~捏哈哈~~~现在的日子真是米什么意思[em36]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('517', '2000', '昨天肚子特别疼，可是有人关心会特别感动。啊~~还是朋友好啊~不会很苦闷不会很痛苦不会很无聊恩有朋友真好可以陪我n个漫长岁月。陪我游戏，随我赖皮。真好~你们可都不能离开我啊[em48]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('518', '2000', '今天离高考结束已经整整有一个月了，哎~放假了在家真的没味天天除了泡吧，还是泡吧，好怀恋已经成为过去的高中生活哦，也好怀恋248班的同学们……郁闷……好不容易终于把网页彻底完成了，终于也轻松了，现在就只用每天维护一下，更新一下就可以了，自己第一次做网页，自我感觉不错，呵呵，还蛮有成就感呢！（……#￥（·……#￥）毕竟是我10多天的心血啊~好了这个目标完成了~明天开始下个目标了，努力！相信自己的能力~。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('519', '2000', '我才发现人要自己爱自己，这样才活的有自信，我才不要听他们说什么呢，切什么东西啊搞什么啊算了但我发现我也太自负了，我也得改改自己的病啊，真是的要努力做一个好人啊要做人人都喜欢的人就该克服自己的毛病要努力朝好的方向发展啊飞加油啊真似的要不和以前一样了啊猪啊人生就是要不停的改变啊直到自己变成最好的为止不要怕什么有什么好怕的呢真是的人啊只要自己觉得是对的就去做就是了啊而且要走出自己的路走出自己的生活方式', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('520', '2000', '我喜欢笑，真的很喜欢，我也喜欢看别人笑，那种傻傻的，真是好，不管遇到什么事，我都会笑，即使哭也要一个人独自难过，因为这样别人也才会舒服，不要让你的心情影响到无辜的人啊，你笑，让别人也笑，那才好啊，而且人生太短暂，哭过了就太不值得了啊，记住：走自己的路，笑自己的笑', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('521', '2000', '高考结束一个多月了，时间也被随意的挥霍掉，不知道这到底算成功的打发，还是无奈的浪费，抑或是习惯使然吧，总之日子是确实过去了！今天到红军家，有人对我进行了教育，关于勤奋的重要性。是啊！多了解这个社会一点，就会多一点失望，对它的残酷与冷漠。但是人总是要活下去的，而且每个人都是这样活的。既然这种方式还没被替代，说明还有它的可取之处，至少它让我们坚强。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('522', '2000', '我在10点的时候到了这里，却发现什么也没有了，太伤心了啊，搞什么啊，真是的啊，他们人呢，我好无聊啊，讨厌的家伙，他们是怎么了吗，我现在人都会急死，搞什么啊，，，，，，如果我们这里有地铁该多好啊，我可以独自一人去看他们，不用一人在这里伤心啊轻轻的我来了，你们却轻轻的走了，切，，，，好有情调啊，一个人也能有这么多的废话。。。。。。。。。。。。。。。。。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('523', '2000', '也许是昨天看电视看的太久了（深夜2点半哦），今天一直睡到10点才被姨妈强行叫起床,，正郁闷的时候，妈妈打电话来告诉我：他明天从深圳动身回家！哈哈~妈妈终于回来了~（有一年左右没见到她了哦~），好挂念她哦！想到就快见到妈妈了`心情就爽了~呵呵~真希望明天早点到来！￥·#￥', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('524', '2000', '印度哲人奥修在《生命的真意》一书中写道：“每一样东西都依赖其他东西。当你看着一朵玫瑰花的时候，你感到快乐—你的快乐是玫瑰花创造的。现在科学家已经证明，当你快乐的时候玫瑰花也会感到快乐，如果你爱玫瑰花，它就会长得更快，它就会开出更大的花朵，因为有人在关心它，在爱它，在看它；如果没有人爱它，它就不会快乐，也就不会开出这么大的花。世界上的万物都是相互依赖的，生命的整体都是相互依存的。你使它快乐，它也会使你快乐。记住；你给别人一个快乐，别人也会给你一个快乐。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('525', '2000', '爆開心哇。。。[em48][em39][em39]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('526', '2000', '人们习惯说：生活之不如意十常八九-。可真的有人可以完全坦然吗，当他面对生活的特殊对待时？尤其是那种会让人不知所措的情况，没有经验的人啊，该怎么来面对。可是，我们都是上帝的子民，对于上帝的安排，除了接受，别无选择。一场游戏，如果不遵守游戏规则，那就会得到被判出局的下场。我们可以去死，去逃避，但逃避不能解决根本问题，一生都忙着逃避，这样未免也太辜负上帝创造我们所费的苦心了。所以，唯一的办法：就是接受，勇敢的面对。这需要勇气，更需要智慧。当我们能从容的面对时，就标志着我们成熟了', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('527', '2000', '这两天不知道为什么总是会莫名其妙的郁闷，或者是烦躁不安的情绪，反正很伤脑筋的。只有在独处时才会平静一点，真怀疑自己是不是抑郁症。郁闷呢！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('528', '2000', '说它奇怪，是因为没有感觉。就这样莫名其妙的过了一天。早晨的时候叫刘莎在公司帮我填了外出单，然后一天都没有去公司~~感觉还怪怪的，呵呵~~做完调查以后回家就一直坐在电脑面前，开始写漫长又无聊的调查报告，调查报告真的很无聊，简直就是bt的东西！！我的脑袋现在处于完全空白状态，一点兴奋的东西都没有~哎。。。真是痛苦！！前两天才发烧感冒，真是的，每次都是夏天的时候我就要感冒~！！~现在还没有完全好，不过也差不多了，头脑清醒，可惜眼神呆滞，哈哈不知道是不是每个做广告文字的人，都要经历这样觉得痛苦的路程，要和其他的监测人员一样去做市调，在真正开始写文案之前要做很多奇怪的工作。我不是害怕做这样的工作，只是觉得好奇怪哦~~反正所有的东西，今天都觉得很奇怪。人，工作，感觉真的好象在过家家一样，大家都在认真地做着一些和自己根本就不关心也没关系的事情，然后用这个来换一点点钱买想要的东西，供应自己的生活，付房租，痛苦地做北漂一族，还因此而乐此不彼。哎~~~无聊的人们啊！！只可惜，我也正是这么多无聊的人群里那么渺小的一个~可悲的自己。。。。。阎红和我说她想回家了，在北京不知道自己到底为了什么，想要什么。其实她算是过得很好了，比起这么辛苦的我来说，她要幸福的太多了。就连她都想到要回家~~爸爸妈妈年纪大了没有人照顾，一个人在北京无依无靠。她说了一句话，你又不是不知道我，原来连上厕所都要人陪的人，现在竟然可以独自处理一切事情。是啊，一个人，没有人可以依赖，真的长大得很快。可能这也就是男朋友没有在身边的一种空洞吧！其实我是很了解她的想法的。伸出手来，想要抓住救命草，但是就连空气都从手边溜走的那种沮丧。想想我在北京的这么多年里，给我成长的，又岂是那么一点点呢？可是，说归说，我们还是要继续在这样的陌生的城市漂流下去。伤心归伤心，失落归失落，沮丧也就是沮丧罢了。。。。。。现在想想，如果这么些时间如果没有lico一直陪在我身边的话，不说他是不是可以在我身边陪着，只是说心里的他，如果没有他在，我的这么久的生活，会是什么样子过下来的呢？如果没有他，今天的我，心情会是怎样？会开心吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('529', '2000', '我长大后,才知道这个世界是这么残酷的?!但是我只是这个世界上的一个小小的生命..我能说什么呢?很多人都不满,但是这个世界就是这么的残酷..本来我很幸福的,每天读书,爸爸上班.妈妈在家照顾弟弟,哥哥在当兵..一切都很美好..但是2年前..我的爸爸出事了.自那次之后..家里开始变了..生活开始有点困难..但是爸爸一直努力支撑着..那次之后,爸爸老了好多..为什么会这样不幸呢?后来,为了家里,我没有读书了.老师说我有学英语的天分.但是我仍然退学了..我要出去打工..为家里减轻负担..哪怕只有一点点都好..我不要再这样下去...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('530', '2000', '小时候看多了童话故事.总觉得这个世界上.会有美丽的童话故事.可是后来,我才知道.原来童话故事是大人们编出来,哄小孩的..长大后,才知道原来这个世界..是多么的残酷,现实..这个世界真的会有..像童话里那样的故事吗.?也许有,也许没有但是即使有,我想我也不知道我听到的故事不是男生背叛女生就是女生和别的男生走了总之就是没有什么好的结果的故事我希望,真的有个白马王子..出现在我的生命里然后,两个人在一起,彼此爱着对方一起过着生活但是,我的愿望能实现吗?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('531', '2000', '对于高考,可以说基本上已有了一个了结,剩下的只有等录取通知到了.对于这样一个结果,不知道自己到底怎么想的,只是觉得……哎呀,难说.开始嘛,有一点失望,其实蛮希望可以出现奇迹的,可是啊,最后也只得接受了.似乎没有太多的失望,还是比较能够接受的.毕竟,这样的生活才显得真实.一个人只身将去南京,确实有点压力.一直是个不很负责任的人,对于将要面对的独立,实在有些恐惧.真希望有关系好的也去南京,不同校都可以,只要能有个照应就好了.[em40]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('532', '2000', '你是我的好老公,我是你的好老婆,老公爱老婆,老婆爱老公.啊耶.恩爱...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('533', '2000', '快没有了纷纷扰扰。一转眼。又全部摆在眼前。该如何应对？想想。却都已经忘记。为何。到了忘记。还要记得。他。曾经是那样的疯狂那样的痴迷于他。现在？想起都想笑了。哈哈。肆意点儿吧。都已经走了。还有什么。可以眷顾的。走吧。走吧。都去死吧。现在他的事对于我都只是无关痛痒。没关系。我也没想过。都过去了。走。感觉似飞翔在天空。与我最爱的云朵。来个亲密接触。再与飞鸟。来个kiss。一直都是我的梦想。龙和STAR。你们。也同样是我的梦想。很大的一个梦。你们的青春魅力。再次让我想毛毛虫一样。脱壳变化成美丽的蝴蝶。我的爱。也将如海浪一般涌吧？哈哈。我在说什么呢。真是傻瓜。但是。龙。STAR。就像我资料里面一样。没了你们。我将在哪里都会是一样。什么都将是白茫茫一片。但是。你们的年轻。与朝气。让我好幸喜。记住。我最爱的你们。印在我内心深处。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('534', '2000', '是什么可以带来短暂的快乐和一生的伤害。继续下去有什么意思？它能给我带来什么我期待的吗？就米有期待，那还傻子一样干什么，我真是傻子看不出你们的厌恶还在自己的想象世界我真是个傻子我干什么以什么角度什么立场给你们建议忠告为你们担心忧虑烦躁我就是个傻子我算什么[em36]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('535', '2000', '1.光轻如纸张光散落地方光在掌声渐息中他慌忙他在传唱不堪的伤脚本在台上演出最后一场而全村的人们在座位上静静的看时间如何遗弃这剧场战火弄脏他的泪光谁在风中吵着吃糖这故事一开始的镜头灰尘就已经遮蔽了阳光*恐惧刻在孩子们脸上麦田已倒向战车经过的方向蒲公英的形状在飘散它绝望的飞翔她只唱只想这首止战之殇恶夜燃烛光天破息战乱殇歌传千里家乡平饥荒天真在这条路上跌跌撞撞他被芒草割伤孩子们眼中的希望是什么形状是否醒来有面包当早餐再喝碗热汤农夫被烧毁土地跟村庄终于拿起枪他却慢慢习惯放弃了抵抗孩子们眼中的希望是什么形状是否院子有秋千可以荡口袋里有糖刺刀的光被仇恨所擦亮在远方野蛮而他却微笑着不知道慌张', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('536', '2000', '为什么就我是这样子每次写的日记都没了是不是写长了就不能搞上去拉说句话咯日记哥哥诶算哒算哒亏我噶信任你走开拉走开[em45]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('537', '2000', '我还很年轻我在想也许一段爱情可以应用在许多人身上说过的话使过的眼神吻过的嘴唇是不是这样才会像不同血型的血液。任你品尝才不会厌倦就像吸血鬼恶魔凶残吞噬着每双眼睛', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('538', '2000', '我始終看不到陽光在我身邊的樣子我的前世是幸福的從開始到現在我從來沒有放棄過我努力讓每一件擁有他氣息的物件遺留下來它們就是我的光芒從今天開始停止照射它刺的我太痛刺得我血流不止我不愛了再也不去愛了就讓它這麽幸福的活下去吧', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('539', '2000', '眼泪总是不争气的一直流他的遗忘我还是视而不见不敢面对但是始终需要面对你是个比较现实的男生而七月是个双重性格的女生始终像是可乐对着咖啡喝总不是个味说不定还会中毒那天说跟TT去看[头文字D]可是我没去因为我知道真的不适合看怕看着看着会发神经而且STAR也没去所以我不能做情侣座我喜欢坐在那里还是那个老位置可是那个地方已经被别人坐过无数遍了我只喜欢只属于我一个人的东西别人拥有过的我只能选择丢弃因为那种感觉真的太呕吐对于你同样的伤害真的受过N+1遍了', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('540', '2000', '討厭·並愛着你們我可以与你們分享的是我的一無所有而你們可以跟我分享的是你們青春不敗', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('541', '2000', '雨後的城市　寂寞又狼狈路边的座位　它空著在等谁我拉住时间　它却不理会有没有别人　跟我一样很想被安慰风　停了又吹　我忽然想起谁天　亮了又黑　我过了好几岁心　暖了又灰　世界有时候孤单的很需要另一个同类爱　收了又给　我们都不太完美梦　作了又碎　我们有几次机会　去追不晓得为甚麼爱　又稀少又昂贵云在半空中　被微风剪碎', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('542', '2000', '绕着山路走的累了去留片刻要如何取舍去年捡的美丽贝壳心不透彻不会懂多难得以为只要简单地生活就能平息了脉搏却忘了在逃什么我的爱明明还在转身了才明白该把幸福找回来而不是各自缅怀我会在沿海地带等着潮汐更改送你回来你走路姿态微笑的神态潜意识曾错过的真爱以为只要简单地生活就能平息了脉搏却忘了在逃什么我的爱明明还在转身了才明白该把幸福找回来而不是各自缅怀我会在沿海地带等着潮汐更改送你回来你走路姿态微笑的神态潜意识曾错过的真爱莫非这是上天善意的安排好让心更坚定彼此更接近真爱~我的爱明明还在转了身才明白该把幸福找回来而不是各自缅怀我会在沿海地带等着潮汐更改学着忍耐不再怕伤害不再害怕期待潜意识那才是我真爱', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('543', '2000', '现在23：48了我还在网吧同样的网吧同样的人同样的歌同样的场景不知道是自己病了还是怎么总是莫名的想哭呵呵真是个傻瓜这里没有[龙/STAR]的阳光笼罩只有颓靡的味道我什么都没有没有龙说要和我玩通宵可是他人影都灭有在了这是干什么呢咱就是生得这么贱咋嘀', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('544', '2000', 'LEO其实我知道你一直都是醒的别装只是想问问我到底是什么', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('545', '2000', '\"(2005-07-2000:50:51)（SEVEN）哦知道了但是没了(2005-07-2000:51:01)迷帥、什么意思噢.?(2005-07-2000:51:28)（SEVEN）没什么阿看不懂就算了(2005-07-2000:52:01)迷帥、说撒...(2005-07-2000:52:27)（SEVEN）没什么就算有个什么我也不会说的拉(2005-07-2000:52:50)迷帥、我想听可以不.?我想了解..摸调我口味..我不喜欢.!(2005-07-2000:53:15)迷帥、你不想要我现在就醒药撒。?(2005-07-2000:54:03)（SEVEN）别听我不想说第N遍。。而且你现在醒了更好回家去别摇(2005-07-2000:54:54)迷帥、我不..~我要晓得。.!(2005-07-2000:55:22)（SEVEN）我真的不想再陷进去了爬了很久很久才出来的(2005-07-2000:55:35)迷帥、知道了。.~你觉得好就好了。.~真的。.!(2005-07-2000:55:49)（SEVEN）恩我知道我也希望你好点。。(2005-07-2000:56:21)迷帥、嗯..以后.不管什么时候..告诉自己.你是我最爱的妹妹..我是你最爱的哥哥.不管什么事.铁哒来..!(2005-07-2000:57:31)（SEVEN）恩我知道谢谢你吧觉得好多话想说但是又不知道说(2005-07-2000:58:13)迷帥、那我真的只能跟你港说对不起..~我懂你默默的付出..我真的太清白了。.~!我一直都记在心里..那种默默的...一直....(2005-07-2000:58:54)（SEVEN）你别说了我真的受不了你的这种话所以我从不愿意跟你谈就是因为我还是怕。。。(2005-07-2000:59:44)迷帥、真的想不出我能为你们该样的妹子克怎么样了..~我觉得。.自己是罪人..~(2005-07-2001:00:36)（SEVEN）我不需要你怎么样知道我只要你好就足够了不需要汇报(2005-07-2001:01:22)迷帥、真的等到哪天..~想想对我好的妹子..~我真的只能港句.我克死.!~拿死去弥补..我想要N条命..拿哒克赔..(2005-07-2001:02:49)（SEVEN）你去死说的好简单好简单可是你想过别人会怎么样么弥补也许真正对你好的妹子不会要你的弥补的只会要你好好的生活很幸福很幸福的一切都好他们才会安心(2005-07-2001:03:44)迷帥、这些道理我懂.~我只是在幻想/到了哪天都喊要我弥补.要我赔.真的只有死了。.~一人拿去分一点..把我砍成N块算了..(2005-07-2001:04:24)（SEVEN）不要我说过别人要伤害你必须先从我这过去再说(2005-07-2001:04:42)迷帥、到底我还是堕落了..!(2005-07-2001:05:47)（SEVEN）堕落？也许吧其实我觉得你是在释放自己所以我并不想阻拦你什么你觉得好就够了(2005-07-2001:07:10)迷帥、说的好..~真的咧.~也没有人可以阻止我..~我睡一觉起来就好了.对不对.?哈哈..(2005-07-2001:08:35)（SEVEN）我知道我都知道可能在梦里可以忘记很多也许可以梦见幸福的一面(2005-07-2001:09:18)迷帥、晕啦.不要和我册的太遥远了..~我接受不过来的。.(2005-07-2001:09:31)（SEVEN）好的咯那就不要好了(2005-07-2001:10:53)迷帥、妹妹..港实话..我现在好看不起我现在。.!该杂样子..(2005-07-2001:11:37)（SEVEN）看不起？别要是我我也会的自己对自己负责(2005-07-2001:12:52)迷帥、该杂时候..我脑壳非常清醒..好多路真的想的好明白的.该杂时候是我最可以看清自己的时候..有些话不想港的太难听.~是把自己港的太难听..~(2005-07-2001:14:14)（SEVEN）其实我觉得你不要这样想透彻点会更加明白我也知道很多事情你都明白表面装做不在乎可是心里却想得很多很多(2005-07-2001:15:45)迷帥、我花心..我承认.真的咧..但好多花心的人会处理该些事.我就不会..我不会处理..~为什么.?你告诉我.?(2005-07-2001:16:53)（SEVEN）也许你是不忍心不想伤害别人毕竟别人喜欢你所以你才会掉着掉着但是你不清楚不说明白可能会伤的更深(2005-07-2001:17:40)迷帥、不愧是我妹妹阿.刚说到点了..(2005-07-2001:18:49)（SEVEN）呵呵其实这些你都表现出来了毕竟跟你在一起也蛮久了表面上是不蛮表现但是你还挺热情的(2005-07-2001:20:34)迷帥、比如我见一个爱一个阿.~我就想起.~我不想去伤害她.不跟她说分手..~慢慢的拖着..~我以为这样会很好.~很不错..~不忍心.同情..心软哈来..!哎..!每次都是该样..无限循环..~(2005-07-2001:22:20)（SEVEN）你每次这样对女孩子只会伤的更深点所以你说跟你好过的喜欢你的妹子都好恨你的也许就是这样吧恨是由爱而生(2005-07-2001:22:55)迷帥、我只单身的噢.~怕害别个..!哈哈..等哈真的哪天被砍死去了。.(2005-07-2001:25:16)（SEVEN）不会的其实你过得也挺幸福的只是某个地方缺少些什么其实你找个很爱很爱你的就好很简单有些事不知道也就罢了反正有些事跟你说了你就相信哪怕是那么一下下也好包括以前的总是旁观者清(2005-07-2001:26:22)迷帥、我现在太清白自己了。.等待着明天的醒头..(2005-07-2001:26:56)（SEVEN）呵呵早点带别个回去别个坐哒噶里也不舒服觉冒睡觉的。。(2005-07-2001:27:13)迷帥、哎呀..~你说这话我不舒服..真的。(2005-07-2001:27:47)（SEVEN）为什么不舒服有什么不对的地方(2005-07-2001:28:10)迷帥、我该人就是好顾及别个感受..~懂.?不管墨子时候.!!(2005-07-2001:28:36)（SEVEN）没关系的我知道我都清楚所以我才能坚持到现在(2005-07-2001:29:18)迷帥、今天不一样了。~我一定要把你送回克...就算我爬起回来/~(2005-07-2001:29:59)（SEVEN）我不回去现在也不行他们都在睡觉不回去我就在这里(2005-07-2001:30:15)迷帥、坚持.?不改.?\"\"(2005-07-2001:30:43)（SEVEN）不改因为我真的不能回去了他们都在睡觉。。(2005-07-2001:31:04)迷帥、我懂啦..~是你自己坚持..~不是我.?我的决定是送.!!你要知道啦.!(2005-07-2001:31:30)（SEVEN）哎那你送我回去我再去在线。。。(2005-07-2001:31:56)迷帥、那我等于没送啦/.?晕起.!(2005-07-2001:32:15)（SEVEN）那就是的阿说了叫你别送我不改的(2005-07-2001:32:46)迷帥、懂啦.(2005-07-2001:33:18)（SEVEN）呵呵你自己好点就是(2005-07-2001:33:44)迷帥、我会的。.!我起来了。.我就什么都清白了..(2005-07-2001:34:04)（SEVEN）恩那就好我可能等会就走了(2005-07-2001:34:14)迷帥、去哪.?要我送一哈不噢.?(2005-07-2001:34:46)（SEVEN）不要了我去别人那吧我现在也不知道只是脑袋里塞了太多东西(2005-07-2001:35:21)迷帥、也许我也送不的哒.!我脚都是软的。.天哪..(2005-07-2001:36:03)（SEVEN）那就早点回去你不是说要顾及别人么那你们就早点走。。。(2005-07-2001:36:21)迷帥、我晕啦.哎..你不一样啦.猪崽崽噢.?(2005-07-2001:36:57)（SEVEN）没有阿我说了(2005-07-2001:56:33)（SEVEN）也许这样子死的快乐阿没有任何预兆没有任何负担挺好的我就希望自己死的时候这样快乐(2005-07-2001:57:35)迷帥、呵呵..确实阿.~我知道自己醒了蛮多了。.但又和第一天那样.贪图..因为摇的爽.~不想下..~!(2005-07-2001:58:04)（SEVEN）看起我跟你聊天就醒药摆。。(2005-07-2001:58:37)迷帥、呵呵.我冒刚才那兴奋了..跟那天第一次最爽的一样..只是听歌还是爽咯.冒那爽了.(2005-07-2001:59:18)（SEVEN）呵呵也许很多人是因为这个去吃药的摆我也不知道很久没吃了(2005-07-2002:14:29)迷帥、我要送别个回家啦.(2005-07-2002:14:36)（SEVEN）谁呢？(2005-07-2002:14:47)迷帥、我左手边..(2005-07-2002:15:03)（SEVEN）哦。好的。你去吧。好点点阿。。(2005-07-2002:15:24)迷帥、好的。.然后我就自己回家老..(2005-07-2002:15:31)（SEVEN）好的哦。。(2005-07-2002:15:42)迷帥、不过还要等哈阿.我还在贪图..(2005-07-2002:15:49)（SEVEN）神经。。。(2005-07-2002:35:26)迷帥、你真的不要我送你回克不噢.?(2005-07-2002:35:56)（SEVEN）不要拉。说了不要就不要。\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('546', '2000', '一醒来假的假的都是假的其实我还是有种被欺骗的感觉LEO为什么老是欺骗我我真的这么好骗真的这么好伤害吗？呵呵是么', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('547', '2000', '其实,你知道我的心里在想什么吗?我有好多好多的话想告诉你我多么希望,你能懂我心里的想法但是,和你在一起这么久以上你从来不过问我的想法从来不理我的感受试问这段感情还有意义吗?我多么希望你能长大点多么希望你能不要再任性,再孩子气..可是,这么久以来..我说的话,你有认真的在听吗?你有真正的听进去了吗?如果,你能为我改变那么一点..我都愿意留在你身边..如果,你能长大些,懂事些我愿意陪你一辈子..但是你能改变吗?你能懂事吗?我真的希望可以和你在一起一辈子..但是,这个希望会变成失望..你根本不为自己的将来去想想..还在那里一直玩一直玩..你什么时候才能真正的长大呢?我明明很痛却放不开手我明明很爱却还是没用我找过一百个理由应该分手但还是抵不过你认错的一点温柔我爱的很痛却放不开手我很爱你却常常泪流总是不属于以后思念才浓下一次就算一起又能多久就算一起又能多久以你的生日为限期..如果你仍然没有改变..我会选择离开你..永远的离开..再也不见...你能懂我的心吗?你能为我改变吗?你能不再那么任性吗?你能真正的懂事吗?如果8月30日之后..你仍然没有有一点点的改变..我将永远离开你..我知道,你决不在乎有没有我?因为你最爱的并不是我..因为你根本就不怕没有女人爱你..因为你从来没在乎过我!!!!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('548', '2000', '在2003年,9月18日..我与你相识了..在以后的日子里..我们恋爱了..原以为,我可以和你在一起开开心心的过下去..但是,我想错了..原来,你根本不可能为任何人改变..你仍然是你..一个从不改变自己原则的人.难道为我改变那么一点点都不愿意吗?难道,你这一辈子要这样下去吗?你就不能为自己的将来想想吗?我好失望,原来你是这样一个没有上进心,没有责任感的男人..我想,我没有机会再和你一直生活了..和你这么久的感情..你却一直不肯改变..你有没有想过我呢?我为你付出那么多..你就不肯回报我?我的要求并不多..只是想一个人..好好照顾我,好好的爱我.好好的疼我一辈子..难道这样一点要求.你都不能答应我吗?都不能做到吗?我真的好失望...和你在一起,我虽然很开心..但是你知道吗?我好累好累..你霸道..任性..孩子气..甚至无理取闹..和你在一起..不开心居然比开心的时候还多??我想问你.如果有一天我离开了你你会怎么办?当然,你不会在乎我这样一个很普通的女人比我好的女人不知道有多少..你怎么可能会在乎我呢?你就这样一个人,什么都觉得不在乎..失去了再找就是了..要知道,你已经错过了很多人..难道你就不想真正的好好的恋爱一次吗?难道这样很难做到吗?我真的好想好想..你能改变...我难道就这样不值得你为我改变一点吗?还是只有那一个女人,你才会为她改变?你心里还有她是吗?如果可以.我宁愿不和你在一起..我宁愿一个人默默的爱你..如果可以重来来一次..我宁可没有遇见过你..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('549', '2000', '今天没有睡觉.大清早就去找静宝了..坐在网吧里好郁闷哦.?不知道该做些什么诶,静说帮我搞进她店子里做事,呵呵,庆幸,我有事做了,不需要一天一天白白浪费时间了,也许开始做事,我就能减少些烦恼吧.觉得他好象和不相信,总是怀疑我,这种感觉好难受哦.诶,不敢想太多.爱的过程,回头看是单纯.往前看是诚恳!.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('550', '2000', '对不起..老公..原来我犯的错是那么那么的大?原来我伤害你伤害的那么深?原来我...老公.真的对不起..其实,和你认识虽然不久..但是,我知道,你对我是真心的..你是真正爱我疼我的..和你在一起的日子里..我好开心..很久很久没有这么开心了..但是,我好幸运遇见了你..如果,是上天让我遇见了你..我很感激上天的安排..我在这里认真的对你说我愿意把我的一生交给你..决不后悔..我希望以后和你在一起能开开心心的过下去..你愿意照顾我一辈子吗...?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('551', '2000', '今天是新的一天..其实对我来说也没什么特别的.但是,老公今天早上才睡觉..不知道他有没有休息好..不知道他的手伤好没好..昨天晚上又打架..虽然说,我和他认识不久..但是有种很温馨很幸福的感觉包围着我..我好喜欢这种感觉..我好想好想依赖着老公一辈子..如果可以的话,真的希望能就这样依赖着他..一辈子..才认识不久,但是我发现,我爱上了我老公..我老公好疼我,好爱我..对我好温柔..就像是捧在手里都怕我会化掉..他一直呵护着我..深怕我受到一点点的伤害..这种感觉,真的好幸福好幸福..为什么,我不早点认识他呢?为什么我们这么晚才遇见呢?但是,至少还是让我遇见了他..这对我来说,已经很知足了..每天他都好忙碌.却在晚上还提起精神来陪我..我真的好感动..我现在才发现..原来爱情也可以这样美好的..爱情,有时简单.有时复杂..但是这都不要紧..只要确定,他还是爱我的就够了..真的就够了...梦里...教父:你愿意娶她为你的妻子吗?老公:我愿意..教父:你愿意嫁给他吗?我:我愿意..教父:我以神的名义宣布..你们正式成为夫妻...................................', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('552', '2000', '原来,我们都错了.原来,我不是你要的.原来,你也不是我要的.原来,我们的相遇错了.原来,我们的选择错了..和你在一起这么久,我才知道,原来我们都错了.你心里仍然有她..而我心里仍然有他..试问,这样无法把心交出来的爱情..在一起,还有意义吗?靓,如果重来一次..你还会选择我吗?我想,你不会.我想告诉你,我也不会选择你..如果我们当初都没有选择彼此.我们现在就不会这么痛苦..我们现在就不会这样难舍难分..只怪我们当初爱彼此爱的太深..现在才会那样难舍难分..如果说,我们都能体谅对方都能为对方着想..那么今天又不是这样的结果..何必呢.?如果早知道是这样的结果.我们何必还在一起呢?每次一个人的时候,我在想..这样子下去真的有意义么?无数次的反问自己,我到底在你心里有地位么?现在对于你来说,我是这个怎样的角色?有好多好多的话想问你...但是每次想和你说,你却没有一点想听的意思..如果,我们真的分开了..那么,希望在以后的一天..在街上我们遇见了..我希望,我们彼此是带着微笑的..至少,这代表我们彼此都过的很好.而不会后悔当初的选择..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('553', '2000', '今天终于看了〈头文字D〉还是和想象的差远了原来这么烂真是我妹妹都看不下去了本来准备TT家看的后来家里的VCD又可以看了但是里面的拓海、凉介、京一、还有余文乐都好叼阿小妹佩服佩服//飞了去（飘移去列）~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('554', '2000', '靓,今天我和你分开了..我知道,不会再有挽回的余地了..我们的爱已经结束了..就想昨天的风景..已经成为我生命里的一个句号..也许..分开对我们来说..是最好的选择..其实,我并没有变心..但是..如果你能多在乎我一点..你想.会有第3者出现吗??靓.原谅我的一时错误..我知道,这次是我的错..但是,我只想你能多在乎我一点..但是,我想我的方法错误了..我这样做,只是使你离开了我而已..算了.如果,真的是这样的结果..那么,我就一个人默默的祝福你把..虽然,心很疼..但是我还是要忍住啊...毕竟,这是我一个人的错..只希望,以后..我们遇见了..能带着微笑..至少这代表,我们都过的很好..不是吗?靓,其实我们都错了..在我们开始的那天..我们都错了..今天,我们正式的分开了..我想,我们不会再有可能了把..那么.我们就为彼此祝福把..希望,你能活的开心...我会一直为你祝福..为你祈祷...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('555', '2000', '今天,我和他分手了..今晚..我一直在想要怎么样度过..对于别人来说..很正常,但是对我来说..我突然觉得时间好难过..我现在才发现..原来一个晚上的时间是这么这么的长..那边的你.你还好吗?是否也像我一样,一个晚上是那么的难熬..?我想.你也会把..即使你嘴硬..但是我还是知道你心里的想法的..你总是很要面子.不肯承认..时间,好慢好慢..一分钟就像过了一年一样的长久..哎....什么时候..我才可以从你的世界走出来.?我相信..我努力..我能从你的世界里走出来..我会努力...努力..把你忘记...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('556', '2000', '\"无意中查看用户列表.看见以前申请的好几个日记本,还有一些朋友的.忽然之间怀念起来.我从来不知道,这样一种被我认之为\"\"无聊\"\"的东西也会勾起我浓重的怀念.刚来这个站写日记时,还没几个用户.可能以前那些个因为太久没写被删掉了.于是我有一次看见我最开始的那个日记本被放在第一个位置.于是我告诉在这里写日记的朋友,我是这个站的第一个用户.后面就是落.以前我们有一个同样的日记本,后来是这个.她依旧过她自己的生活.我依旧晃荡着我的日子.只是我们不再有交点.我不觉得惋惜.我甚至不觉得这是失去.半年了.\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('557', '2000', '雨一直下着！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('558', '2000', '如果可以，我一定要嫁周杰伦[em38]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('559', '2000', '▇▆▅▄▃THEFRIENDSHIPWITHYOUIS４EVER\\BECAUSEHAVE’TYOULIKEHAVENO(BLOOD)[BELIEVEALLYOUKNOW]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('560', '2000', '我真是个傻瓜型的孩子。总是找些傻瓜的事来做。买了一瓶黑色的指甲油。好奇怪的事情。真蠢。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('561', '2000', '刚刚我写了一篇关于她的好长好长的日记。但是。网络出了问题。没了。我心里还在想。如果没有了。就证明。我们这段友情。该结束了。呵。。老天弄人。果然。没了。呵呵。现在的我。该做出怎样的反映？吃惊。居丧。还是……但是。不管怎么样。刚刚写的。还是没有了。在这里我也不想写第二遍。只是重复最后一句好了。[恋。如果还要对你说什么的话。只能说。sorry。不管你接受还是不接受。]你是我自玉之后。第二个当真心朋友的人。希望。能恢复吧。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('562', '2000', '学不会翻故事最后一页学故事里的狼狈和无声颓废', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('563', '2000', '又有很长一段时间没有写工作日记也没有去更新msn的空间了。可能是夏天的火气也感染到我了吧。本来就是个很懒惰的人，这样的晕忽忽的天气，只想在家躺在床上。怀念学生时候的想在就可以在家里当懒姑娘了。今天要写一个医院的软文，原来也有写一些些这样的东西，但医院的就还没有写过。上网查一些资料的时候看到一篇关于文案如何写的文章。看完以后觉得文章上写的都是我要学习的哦，要学的东西还真多！文章的题目是：如何创作能快速下货的广告文案？文案的创作方法一般有3种：一是生拼硬凑型，从当前比较成功的文案中去抄袭创意。二是闭门造车型，由于欠缺市场实际经验，文案读起来象读报告，咬文嚼字，不能产生强烈共鸣，而触发购买欲望。三是调研策略型，a有市场实战经验b较强的文字驾御能力c丰富的社会阅历d产品营销策略能完全了然e能根据市场变化及时调整，文案标题醒目，观点鲜明，极具震撼力，把握消费者心理，利益点阐述明确，同整体营销策略相匹配这样看来，我现在还属于生拼硬凑和闭门造车的阶段。要锻炼成第3中类型的人还是需要一定的时间大量练习和经验才可以达到的。总是在最后一秒完成进行深度沟通，是倾听者，了解市场上曾经对产品的反应，竟品的核心诉求，曾购卖者的年龄，学历，地域分布，受哪类媒体影响因数。广告的标题是成功的一半广告标题是广告文案的主题和目的的凝结点，是精华的精华，奥美创始人广告大师大卫，奥格威曾说：好的广告标题能创造广告80%的利润。好的广告标题来源于模仿与创新，模仿决非抄袭，在精彩标题上去寻找灵感，站在成功者的肩膀上前进。同时要具备水平思考能力，多角度，多方向，全方位的思考。成功的标题应具备5条规则：1吸引消费者兴趣或强大恐惧，2提供最新动态（新闻）3引起消费者好奇4暗示方便快捷之路5权威可信。不要写死标题，如信心无限，优良品质，疗效确切，售后完善等。不要写得过短，不能圆满表达含义。2004年，为何本市的”天气预报”统统失灵？（某风湿产品标题）把最惊人最有说服力的事实放在最前头。要允许你自己有语病，罗嗦，尽管写，边写边找语感，尽量多写，先把所有的问题写出来，然后再编辑、浓缩。多用短语和简单有力的词汇，少用形容词，多用动词，名词，原始资料远比精心雕琢的意见可信。写文案不要太聪明在别的行业，聪明的人可能会把工作做的好一些，而在文案写作上，可能更需要实在的东西。这一点让我想到了师傅原来和他的师傅的一段对话，说是越简单越单纯的人反而更容易写出好的文案。当时我还持反对意见，现在看来我是没有找到窍门。要学会用你的亲身感受或了解到别人的亲身感受去活化你的文案。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('564', '2000', '呵呵。最近真的发生了好多好多。也不知道。自己该想什么了。也许一直都是吧。那天晚上。他和我说了好多。是我一直都不知道的。也是一直想问他的问题。这些疑问。在那天晚上都被他一一解答了。其实。当时。我感觉挺幸福的。真的。很爽的感觉。呵呵。真是个蠢孩子。不可否认的是。我还是不能说放就放。哪怕是。我承诺过。我有过的原则。都抛了。抛的很远很远了。但是。我知道。自己不能在陷下去了。一但被破灭。我知道。我的后果会很惨烈。很惨烈的。可是。我还是爱他的。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('565', '2000', '新得开始。新得日记本。记录着新得我们。遥望前程？是我太骄傲/做会以前得我。好好珍惜眼前得吧}}不管以前多么悲伤>[不管以前多么骄傲。现在得我。始终知道::跟MYBESTLOVE[俊-好好过现在得生活/SOMYHEARTTOMYBESRLOVE。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('566', '2000', '记得祢答应我得唷。绝对放弃我得啦/我会永远永远记得。祢曾经跟我说得。寶貝別怕轉身或輪回。娥都在身邊。████████REMEMBER最疼得她[傷]。没有疑惑。没有捆饶。现在我们。将来我们。都会是一样得。{俊}：对么？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('568', '2000', '昨晚的梦,早上时记得很多,现在看看还有多少记得.一共2个梦.梦1:好像是在一个大公寓有点象旅社,又象是医院.姐姐在里面做事,里面还有很多漂亮的小姐.好像记得姐姐肚子凸出来象怀孕了,但是烂了(不知道是否是见多了fanny的大肚子?)后来姐姐走了.应该是公寓里剩下不多几个人.有个飘亮的小姐,来找我.我的意识里好像要开始ml了.小姐带我去个地方,好像是另外一个公寓,要避开人吧.中间,好像小姐换了个有意思的服装,让要来的ml感觉有意思了.还让我传上个肚兜一样的东西.好像进了那公寓,碰见另一个小姐,我问她,你要不要来(ml?).她好像说不.后来好像两个朋友不知道怎么就出现了.好像是徐良维和江明吴.为了不让这个让他们知道,我和小姐就走,好像要另找个合适的地方,一路走.中途中好像小姐变成了ben哥(超级大胖子).半路上又遇到了阿ken,他开车载着sharon坐前排,后边坐着sharon的姐姐,说是接她的姐姐吧.好像看不清她姐姐什么样?我好像对小姐也这么说的.后边不记得了.后边应该是第二个梦了.梦2:不记得了,早上还记得的.[em45]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('569', '2000', '后视镜里的世界越来越远的道别你转身向背侧脸还是很美我用眼光去追竟听见你的泪在车窗外面排徊是我错失的机会你站的方位跟我中间隔著泪街景一直在後退你的崩溃在窗外零碎我一路向北离开有你的季节你说你好累已无法再爱上谁风在山路吹过往的画面全都是我不对细数惭愧我伤你几回後视镜里的世界越来越远的道别你转身向背侧脸还是很美我用眼光去追竟听见你的泪在车窗外面排徊是我错失的机会你站的方位跟我中间隔著泪街景一直在後退你的崩溃在窗外零碎我一路向北离开有你的季节你说你好累已无法再爱上谁风在山路吹过往的画面全都是我不对细数惭愧我伤你几回我一路向北离开有你的季节方向盘周围回转著我的後悔我加速超越却甩不掉紧紧跟随的伤悲细数惭愧我伤你几回停止狼狈就让错纯粹', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('570', '2000', '[color=#0000ff][color=#000000][face=楷体_gb2012][/face]相信自己。。哈哈//我很happy。。只是偶然会感到寂寞。。[em42][em42][em42][em42][em42][em42][em42]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('571', '2000', '这个问题现在真得好严重啦。那杂猪嬲得墨子俊阿。祢可以阿？又买我咯。还买还买。真得要生气啦。祢这个猪头。说好啦来东区陪我！鬼？人都看不到人。上网又找不到祢。祢真棒……[em45]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('572', '2000', '每个人在生命中都充当着一个角色。不论那个角色是什么/{主角、配角或者是个不气眼得小角色。对于每个人来说。都是那么那么重要。每个人得人生都是很精彩得。每个人得人生都是很刺激得。然而。此时总会出现一个心爱得他{她}总会。给祢带来无限得欢快。然而。在长久得日子里。他们能否还那样恩爱？这样就看彼此啦、看彼此是否珍惜着？重复着：我爱你、你爱我？真心喜欢。就是要用心！现在得我可以说很幸福。因为/我跟他有着很多得承诺。因为这些承诺。让我们彼此喜欢。因为这些承诺。让我们尽情欢笑。……现在得爱/可以长久下去吗？其实我不敢期待。祢说我们要一起走下去。所以/我们一定要做到好吗？一次次得失落。一次次得困惑。我真得[累]。好好得疼我。好好得保护我。好吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('573', '2000', '亲爱得。祢为什么不在我身边？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('574', '2000', 'WHaTCANIDO？MYDEARWHENYOULEAVEMEONLYSADNESSSURROUNDME', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('575', '2000', '当一个人坐在窗前。我会暗暗得问着自己。我是谁得BABY。然而此时。谁又会来告诉我。我想要的答案？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('576', '2000', '不敢奢望所有得事如我所愿但求这一生与祢相伴但祢和天空之间只看见祢在梦与希望之间拥抱祢在爱和体谅之间靠近一点让我们得心能完全重叠不管明天有多善变', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('577', '2000', '你复制的吧.!但是我还是很高兴[em47]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('578', '2000', '笨蛋+白痴=？解出这道题目。就算祢比较聪明唷。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('579', '2000', '我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!我爱你!总共999个..你数一下..胖.lao婆', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('580', '2000', '[COLOR=#F0FFFF', '惊喜.!', '', '');
INSERT INTO `dede_addonarticle` VALUES ('581', '2000', '祢真得很笨很笨乜。刚刚打开日记本阿。一篇得：我爱祢。吓了我一跳唷。我天天在家里等着。无聊得时候打开电脑。听听歌。写写日记┆心里还是那样得想祢、祢觉得当祢站在自己得舞台上，看着下面得观众。祢得心里会想些什么？《下一站彩虹》它教会了我很多很多得东西。以后不论是对感情、友情或者是事业。我们应该要坚持不懈。DON\'TGIVEUP。创作新得东西就要有新得IDEAR.人总是要经历才会有新得收获.[/COLOR]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('582', '2000', '等祢去读书了.我会在株洲等祢.记得要答应我.不能做坏事喔.还有就是不能另结新欢唷-不然……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('583', '2000', '不管你在肥.不管你在老.不管你在丑.我也会在你身边.保护你.支持你.爱护你.相信你.珍惜你.关心你.呵护你.帮助你.惋惜你.疼你....我丑.老.你可以.离开我.抛弃我.不理我.背叛我.或出轨.!<以上是我发自内心的话.!我绝对没复制>我也不会怪你.<因为我是你老公.>就算不一辈子.我也会笑一个.!你永远是我BABY..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('584', '2000', '甜......疼......伤......悲......爱......打开就知.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('585', '2000', '看着祢写得。心里有说不出得味道-难道我应该听祢得saygiveup吗？我想我做不到///每次上网/我总会在qq里寻找祢得身影。然而祢很难在。但是。我不失落也不伤心。因为。我知道祢会上得。因为。我知道祢不会丢下我得。失落得眼神。无情得伤害。我始终不愿意祢放弃。我也是一样。不要再说出这样得话来啦好吗？我不愿意祢说要离开我。因为我在乎祢／我想祢也一定在乎我。所以，收回祢说得话。虽然到时候祢要去读书。但是。那很重要吗？重要得是什么祢知道吗？重要得是我们分在两地。然而心里依然有彼此－这一点做得到吗？那天晚上我多么希望祢会送我。然而祢没有。我不怪祢－我不知道我现在应该怎么做。然而我对祢写得真得很模糊？现在得祢到底是什么意思？难道祢真得要放弃我＼＼sorry。我不希望是真得。我要祢告诉我，祢永远不会放弃我。这也是祢那时候答应我得。我不要祢消失。我要祢永远陪在我身边保护我、疼我、爱我－我知道你一定做得到－不要问我为什么。这也许是我得直觉告诉我得吧。记住：我永远是祢得宝贝－　', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('586', '2000', '真确面对.我不许祢SAYGIVEUP.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('587', '2000', '在生活中。在QQ上。在电话面前。我一直在寻找。一直期待祢得出现。现在得祢在哪。应该跟好友在长沙吧。那么。好好玩。玩得开心点。[/', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('588', '2000', '虽然说,我才18岁,,但是,我发现我经历了好多的事..觉得我好象过了大半辈子一样..现在,对我来说..什么事都看淡了..觉得没有什么意义了..包括爱情..其实,人不要太执着..太执着对自己并不好..有句话说的对..人活在世上,不要太明白..什么事都明明白白的..会很寂寞..也许是真的把..至少,我这么认为..很久没有一个人好好的散散步了..一个人的时候,,总会想起好多好多的事..以前,失恋了,最怕一个人..因为一个人的时候..喜欢胡思乱想..现在却很喜欢一个人独处..那样让我觉得好轻松,好自在..时间一点点的流失..我却没有一点事可做..真的好无奈..无奈自己的命运会是如此..哎......我真不知道该怎样就好...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('589', '2000', '已经几天没出来了。觉得好像与世隔绝似的。不可厚非的是。我是依靠网络生活的。没错。很多很多事情都已回不去了。尽管。我是如此捕捉它。时间要把它带走。它就必须走。尽管还有如此多的留恋。突然……我想去接头发。接很多很多。可是。我发现。我怕疼。我想去买CD。KFC…可是。我发现。我没钱。我想去上学。天天像以前一样。可是。我发现。离假期结束还有一个多月。很多很想做的事。幻想的很多的事情。可是。最终。都没实现。当梦想破灭的时候。看似很愉快的我。其实。内心。免不了伤心。很难过。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('590', '2000', '珍惜眼前抓住幸福ⅷ拥有幸福俄们灰幸福一定灰相信俄相信祢自己俄们的爱灰幸福好吗宝贝加油努力为俄们的爱加油记住：祢永远都是俄的小骚貨', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('591', '2000', '等到你们都走我是说就真的只剩我一个人的时候。你们会不会有点点想我呢？我会很想你们的。我确定[sound]http://dm1.haoting.com:3369/ht//chy/w/wyt/11/10.wma[/sound][em43]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('592', '2000', '祢知道当祢把真相说给我时。我第一反映惊呆了。难道祢不相信我。还需要这样来试我？但是现在已经ok啦。所有得问题都解决啦。我们回到了从前。答应我得。那是第一次也是最后一次。笨蛋+猪头。那个人就是祢Drak俊。哼哼哼……祢现在在长沙。应该玩得蛮开心吧。祢到是可以唷。连个电话都没打给我。不是把我遗忘了吧。笨蛋猪头。记得想我唷。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('593', '2000', '[COLOR=#FAEBD7][/COLOR]我不知道，在这里我应该写些什么？该如何的写，考虑了一小会，却发觉，我已经开始在这里打出第一排字来。。不知道那些考人的事情是不是和这个一样，看起那么的困难，需要的却总是这第一步！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('594', '2000', '8月29号.!永不放弃', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('595', '2000', '原諒把袮帶走的雨天在突然醒來的黑夜原諒被袮帶走的永遠是終究快要走到明天痛苦會雖時間好一些', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('596', '2000', '8月29号？这是什么日子喔}}}记得祢说得。永远都不放弃[伤-伤也是一样', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('597', '2000', '好了.!10天的纪念日子.!你怎么这个都忘记了.!我晚上就回来了...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('598', '2000', '祢这个猪头阿。写就公开塞。怕墨子捏？笨蛋样得', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('599', '2000', 'G开.!嘿嘿..我害羞类.!老婆.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('600', '2000', '白痴老公阿。祢真得苯得可爱啦。祢怕祢还细啦。还害羞唷-哇卡卡……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('601', '2000', '人生总是要经历后才懂得珍惜。然而现在得我们懂得什么叫[爱]吗？不过我们知道要珍惜眼前人。人生总是有得有失。我们不要因为失去了一些。然而悲伤痛苦。那么自己有没有想过。其实失去了不该要得东西。得到了很深得教训。这样得人生才有乐趣。昨天跟铜在说感情。或许一次轰轰烈烈得爱情。比不上一场平静得感情。她们总告诉我。爱得越深伤得越深。现在得轰轰烈烈。是造成分手后更深得痛。BUT现在我们也不错。他不会放弃我。我不会放弃他。彼此珍惜着吧。失落得感情也会复燃。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('602', '2000', '昨天。姑姑把我丢在601。自己就去合泰找老公去了。恨…但是。我还是去了龙龙那。呵呵。已经习惯这样子叫你了。很喜欢很喜欢。看到你。本来是准备给你惊喜的。可是。我一进去。就被你看到了。真笨蛋。你的朋友在放肆的策我们。其实。我觉着他们挺可爱的。哈哈。好可爱。特别是那边那个骂别个胖子的人。。。。我看到你笑。笑的好灿烂。好天真。并且。是我喜欢你的阳光。但是。恨的是。你太高了。1.81阿。你以为是开玩笑阿。别以为你‘居高临下’就可以轻终众阿。呵呵。早熟悉的街道里。仿佛。只剩下我和你。你总是走的如此快。我要跑着才能跟上你。我大声叫你变态。你总是无奈的说。别这么大声阿。这是街上。但是。我还是顽皮的大声叫你变态。[em48]记得。你带我走小路。虽然漆黑。但是。我还是可以看清楚你。很清楚。很清楚。因为。你在我心里一直都是很清楚的。本来有个很坏很坏的想法。但是。这里不能说哦。秘密。下次我一定会告诉你的。还有。我永远会记得。我咬你的第一口。很重很重。我知道。但是。不知道为什么。你会如此的冷静。。。呵呵。其实我走的时候。差点点哭了。但是。我知道你会追上来。所以我是边走边笑。果然你追上来了。你一定认为我哭了。其实。我在笑拉。呵呵。挺傻的吧？我知道你会这么认为。算了。不揭穿你了。只希望。我能爱你很久很久。也希望。我们的友谊能保持很久很久。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('603', '2000', '今天终于解脱出来。家里好多好多小孩子。小孩子倒没什么。但是。他们现在是特闹的年纪。弄的我好反感的。但是。突然有个想法。很想有个属于我们的孩子阿。呵呵。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('604', '2000', '有时候是该彼此信任。不然再坚定得感情也会破碎。就像那时候乖跟威。我以为他们会很幸福。然而乖告诉我。时间久了矛盾就出现了现在对威来说是什么感觉。就连她自己都不知道。本以为等上课后。去学校看他们。他们还是一样得感情坚定。然而现在得他们。真面临着老天爷对他们得考验。他们是否可以经受得住。以后得生活会是怎么样。就在这一次了。看多了她们得故事。再看看自己。似乎一切都很平静。我担心有一天。老天爷会打破我得平静。那么那时得我。经受得了考验吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('605', '2000', '打开又关上。关上又打开。反复得开开关关。突然觉得不知所措/突然间不知道可以干什么/失落得表情出现在我得脸颊上。我又怎么啦。难道就因为这点点事。有不高兴了？难道我真的这么小气。但是我得知觉告诉我。我没有阿。只是突然间很失落。我不喜欢像她们那样天天SHOPPING。我不喜欢像她们那样天天PLAYING。我不喜欢像她们那样天天SLEEPING。现在得我除开天天画画。我还能干什么呢？面对家里得电脑。我会突然很烦。它摆在家里很久了。然而妈妈不准我上网。我突然间很想把它砸掉。可是我能这样做吗？一个人坐在网吧。看着人来人往得走道。真得真得很无聊。没有人陪我。没有人理我。有时候会觉得自己突然很消极。是我该离开得时候了。回到家里。睡个大觉。然后起来。画画解闷。就这样。我离开了网吧回家啦', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('606', '2000', '梦到眼镜的两个脚架子掉了。.0.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('607', '2000', '(2005-08-0220:02:49)佛們小炫¤紀念日。２oo5/o２/o２ｍ---２oo5/o８我们的感情半年啦｀冬天的向遇　到出秋的眷恋。我们的感情升华啦~高兴开心欢喜。这半年里让我们成长啦好多好多…让我们更加的珍惜我们这来之不易的感情让我们学会了相互了解相互体谅过去的点点滴滴都历历在目虽然我们现在不在一个城市。但是我们有心的交流我们的心里都想着对方。对不起忽e。今天我不能陪在你身边。惭愧#＃忘记不愉快的。让我们的回忆里只有甜蜜回忆我们的过去珍惜我们的现在努力为我们的明天加油。~明天的明天~我们还是会好好的在一起。永远都不分开。我有信心。~请相信我给你的诺言那绝对不是善意的谎言~长沙的生活好寂寞。~每天晚上都睡不着~正好印证啦“戳神”的乃句话！唉。~每天晚上都在想你~真的好想和你天天在一起。永远都不分离~好吗？~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('608', '2000', '我的错我的错..今天得我好失落.我再次又买到你了!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('609', '2000', '點這個進入希望大家多去看看[em41]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('610', '2000', '昨天晚上坐在包厢里面。一直望着电话。一看到陌生人得电话来。就以为是祢。然而每次都是失望回来。告诉我。什么时候你可以停止买我？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('611', '2000', '\"俄恨恨恨死祢死传奇为了它祢可以不齿俄嬲看透哒昨天还是甜言蜜语今天却变成这样祢为什么要问俄祢还骗俄俄在上网的时候祢还在传奇为什么要骗俄操祢什么人?俄每次上网都先看看祢再不在线祢灭有再线俄都泻了一半气了祢却这样？假假假祢祢为什么每次都要找借口来说俄显得全部都是俄的错拜托祢有时候可不可以想一下俄可不可以体谅下俄不要这么自私大男人主义不要在找n种理由来反驳俄俄不想在多做解释好吗？俄只想和祢好好在一起永远都在一起好吗？俄们已经半年了俄不想这样真的不想祢知道?俄知道祢在cs不舒服难道俄就好吗？俄也背着\"\"思念\"\"阿祢到底还要怎样？为什么祢的话里都是俄的不对俄好累好累可是俄愿意为祢累为什么祢每次让俄受伤时候又来安慰俄说什么是俄的错俄不要听…俄真的要不多俄只想要一份完整的爱乃怕这份爱在哭在累俄也愿意…[em10]\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('612', '2000', '谁能真正了解俄谁能真正关心俄谁能真正保护俄炫俄要的不多只要俄们好好在一起…可是为什么现实总是乃么残酷?俄不要不要现实真的好累…', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('613', '2000', '听到一种低气.失落的声音.!我心里麻麻的疼.!我们该如何.?8月15号你开学.!我不会在欺骗你拉.!我保证.那我姓名保证.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('614', '2000', '今天已经星期三了。星期五我就要去江西了。又有几天不在株洲。到时候可要记得想我。无聊/寂寞得日记。似乎是习以为常啦。有时候别人会很羡慕。然而每次看到她们，成双成对得时候。我会一个人躲得远远得。BECAUSE我不喜欢那种感觉。很孤独，很无助。刚刚打开QQ。看到祢发来得消息。你说会永远爱我。我相信祢。看了祢得资料。问我愿意嫁给祢吗？我想说只要可以{{我愿意。}}我们得时间还很常，还等着我们去度过一次次得困难/那么我们经受得住考验吗？俊/告诉我-我们经受得住吗？可能祢会说我喜欢乱想。但是我还是很怕。怕有一天你会离开我。怕有一天我们会为了一些琐碎得事而分手。答应我。不要出现那一天。好吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('615', '2000', '可以忘得我都忘记了。可以得到得我都得到了。默默得坐在网吧里。面对着显示器。突然间很无助。现在得你应该在干什么？答应得来陪我聊天。可是为什么又没有来？是有事。还是不记得？……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('616', '2000', '好无聊滴日子..都不知道要怎么过..哎...现在才发现..等人的日子..真的好难过..原来等人..时间会过的那么的慢..哎.......', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('618', '2000', '今天下午一直在等祢得电话，可是一直没有响起。现在得祢该在干什么？有没有在想我？明天早上8：30我就要走啦。本来今天想见你一面。可是/去见不到-算了。回来再见吧。你在这里要好好得，要乖乖得。要想我唷。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('619', '2000', '我决定一件事..一件很重要的事..偶决定11日去他那找他!我想给他一个惊喜..一份情人节最好的礼物..呵呵..突然觉得我好傻哦.好象陷入了热恋一般..感觉好甜蜜..呵呵..好久好久没这样了..感觉真滴好幸福..嘻嘻..老公..偶真滴好爱好爱你哦!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('620', '2000', '今天是祢走的第一天.!我心里暗暗高兴.终于可以安静下.好好玩.玩开心.不要急着回来.我会想你的..我答应你.为了我的诚意.我每天写一次日记.!就代表我想你.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('621', '2000', '才发现到.没你在身边吵.没听到你声音.我是多么的发闷.想你的俊.第二天.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('622', '2000', '好哇。原来你就是这样得咯。原来那么不希望我回来咯。哼。生气了—猪头。今天我回来啦。天啦,在那里简直不叫过日子,所以我跟我老妹一晚上吵起要回来,你只不晓得,我们爬山都爬噶两个多小时,然后那别山上好冷吧冷,跟我们噶里过冬天一样得,那里得旅馆哈住满人啦,我们就只能住平房,崽诶,那是人住得地方阿?晚上居然有打屁虫飞到我头发上啦,黑起我,3点钟就去来啦.一直冒睡,一直在那里找打屁虫,挨唷,黑死我啦.今天中午一回来我就洗澡,真舒服别~呼,噶一世我都不要去那里啦,爬山我们都爬噶1200多米,真得是上去洗个头发,下拉又洗了个头发,好多雨飘唷,.呼,祢噶杂猪诶~答应我要写好多得,最后只写了这么一点点,还搞得我急着来看.哼,小屁股-我冒在得噶几天,有没有想我啦?晚上打电话给我.切记.我想祢啦,', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('623', '2000', '其实今天坐缆车下山得时候。当我望着那无止境得悬崖当一片片云飘过我眼前时我突然很想祢-Krad短短得两天时间。我似乎觉得自己发生了改变。突然间变得很伤感。有时候就连自己都害怕自己那种害怕是从来没有过得感觉当我坐在缆车上写日记时。心里想到的第一个人是祢-Krad当我跟张炫走在山腰上时。我突然问了他这么个问题：如果就这样飞下去那种感觉一定很棒吧？没有任何牵挂？张炫没有回答我。站在那里。似乎一切都很安静。当我回过神来。自己也吓了一跳。我竟然就站在悬崖边上。稍一个不留神我就会滑下去摔死。Krad老公：现在得我该怎么办？我不希望自己以后都是这样。这样得失落。这样得担心受怕。何时才会停止。突然间很想被你抱着。这样得感觉从来也没有过。这是第一次。我也是第一次这样失落。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('624', '2000', '一天一天过.我和她的感情是或是..我想一直守护你.不管甜.苦.我甘心今天我走啦想我吧', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('625', '2000', '天上得星星繁多。地上得人来往？而我们得感情。一天天得加深。我们彼此呵护。我们彼此信任。对。应该这样。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('626', '2000', '新得路口。我们手牵手。一起走过。我们得爱情路灯里。永远不要出现红灯。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('627', '2000', '不管一切多么艰苦。我们都要一起度过。不管未来多么遥远。我们都不能说放弃。我们要努力得向前。不管前面是什么？我得一起面对。好好得过着我们得日子。永远永远不要结束。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('628', '2000', '两个小笨蛋。不顾正业唷？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('629', '2000', '今天祢走啦。然而你答应我得却没有做到。你说走之前会打电话给我？算了。我不怪你-或许是因为某些事而忘记了吧？现在你应该到了吧？突然间觉得你离我很远很远。记得回来得时候留言给我。要不然打电话给我。我去接祢-就像那时候我说我要去江西。你说你要来送我一样。彼此互相珍惜。才是最最重要得。你说呢？老公。快点回来。我得头又疼了/', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('630', '2000', '笨蛋老公。不论你是不是打喷嚏。都是我在想祢-记得我想祢-', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('631', '2000', '崽阿.你电话打不得.!krad', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('632', '2000', '每天的这个时候.我都一个人静静的想..我在想.我们到底是怎样的关系..从2003年那天我们在一起开始..一直到现在.我们到底是怎样的关系呢想了这么久..我才知道..原来,我们曾经是爱过对方..但是现在却只是..习惯了彼此的存在..习惯了彼此的味道..习惯了彼此不分你我的时间..习惯了彼此相拥而眠..也许,我们之间就是这样的习惯..我想,也该是时候解决我们的事了..说实话,我真的很想陪你过18岁的生日但是,可能没有这个机会了..毕竟,我们还是不适合在一起..现在给我的感觉是..我们只是朋友..很知心的朋友..只是有时朋友有什么需要.我们一定会给予对方..朋友就是这样的..我们之间也只能是这样的关系了..我不否认,我现在还爱你..但是,我们之间已经没有爱了.你想,一段感情没有了爱..那么还有必要在一起吗?我想,突然分开..对彼此都会有那么一点不习惯.但是,过段时间..你就会习惯了..毕竟我们之间的所有事..只是习惯了而已..靓,每次你都认为我不会离开你.那是因为你知道,我还爱你就不会离开但是,这一次,我选择离开..只是希望你能改变..只要你因这件事能改变那么一点点..那么我的离开也就值得了..我现在只希望..能有个女生就像XN那样..你能为她改变..那么你就真的找到了..能在一起一辈子的人..我毕竟不是她..你不会为我改变.这个我是知道的..我也不奢望..现在我只希望你能过的开心就好..我希望我离开了后..你能长大些,懂事些..不再让你的父母为你担心..好吗?如果将来的某一天..我们在街上相遇了..我希望我们是带着微笑向彼此打招呼至少那样代表我们彼此都过的很好..至少,我不会为当初的选择而后悔..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('633', '2000', '8月11日今天是中国的情人节，我不知道用什么来形容我现在的心情。曾经，对一个男人充满了无限的渴望，也许更贴切的形容词是奢望吧，我想和他在一起，想天长地久的在一起，只爱他一个人，全心全意的爱着他一个人。也许我的想法太天真了，世事难料对吗？人不能靠着激情过一辈子，特别是虚幻中的激情。我和他是在游戏里认识的，时间不算长，了解不算多，但是我确定我是爱他的，但我不确定他是否像我爱他一样的爱我，好象是绕口令啊。3个人的爱情游戏必定会有人伤心，何况我们的爱不仅是3个人这么简单。他是唯一的男主角，唯一的。男人的话，也许真的不可信，至少大多数的男人大多数的时候，说的话是不可信的。我相信了，而且是相信了不止一次，然后再一次次的失望，直到现在，开始感到无奈。网络，究竟是个了解的平台，还是只是个虚拟的梦境，我的感受是后者，它有太多的不真实存在。我曾经以为亲眼看到的，亲耳听到的，应该是事实了吧，但是他的只言片语就能将问题化解。我不得不佩服他，能够游走于太多女人中间，然后还做到游刃有余。或许这是男人惯用的伎俩，只能怪我自己涉世未深，对男人的看法太过肤浅，被一些假象所蒙蔽罢了。情人节，还是能和他一起过，但是他说的话，我听起来好刺耳，特别是对我的承诺，感觉像针刺般的心痛。“老婆，我会爱你，只爱你一个人。”他究竟对多少女人说过相同的话呢，我又是第几个听到的人呢？说到这里，其实事情也很明了了，我就是在胡思乱想，爱他就不应该怀疑，我真的不想怀疑，但我讨厌他总是跑来和我解释，这个女人怎样，那个女人怎样，我也会是他在背后评论的对象，他会怎么说我呢？我想逃避，想离开他，我不止一次的想过这个问题，我给自己找了无数的理由，但是只有一条理由，让我至今也做不了决定，那就是我还爱着他，我有时候会想，即使和另一个女人分享他，也未尝不可，至少我在他的心里也是有地位的，不管在第几位，至少是存在着我的。未完待续。。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('634', '2000', '昨天是中国得情人节。可是你却没有陪我过。现在怎么样也不行了。一切只能算了。看着她们成双成对。心里得滋味别提多难受。可是你却不知道。那种失落得表情。你却一直没有看到。算了算了~不想再提那些事了。寂寞得日子总是过得比较慢炎热得夏天烦躁得心情什么时候你来看我？是否在想我？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('635', '2000', '>>!>!>!>!!很爱你我爱你不要很久`1辈子便可以拉', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('636', '2000', '2006年元月10日星期二阴转晴这一天将要结束,今天发生过许多烦心事,而太阳还是同个资势,小鸟依旧那种叫声,没什么会为我停止,站在地球某一小小位置,谁会在意我的不快乐……但愿，明天的到来会让我很快的忘记今天的不快乐，不过我相信快乐一定会很快降临到我的身上来，会陪我一起走以后的路。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('637', '2000', '今晚想起勒七年前的我們哈哈.真的佷好笑哦.記得果陣時每天中午和袮一起值日的時候都是打打閙閙的.傻笑的還記得袮叫我居里夫人呢哈哈.那時候我打袮.袮儍的竟然指着居里夫人的相說.哇.好象袮啊.......之后袮就叫我居里夫人勒知道我轉學還是那么叫不過我轉學之后.似乎沒跟袮交流過一直到勒.初二材髮現袮還在人世(哈哈.說笑))小學天真的我們.想卟到.曾經七年前也有愛過對方但誰兜卟敢說.直到***的岀現一直埋藏着...以前的以前.現在的現在.我們要相愛哦七年前真的佷快樂.佷儍佷儍如果沒有七年前的那時我們可能不會走到今日所以我們要珍惜在一起的日子七年的緣分.足夠我們愛一輩子的相識七年是我們的緣分.相愛一輩子是我們的諾言小學三年級時.那傻傻的袮.欽可愛極勒.哈哈一段忘卟了的囬憶.仍然記得佷清楚卟知道袮是不是呢..居里先生說.要娶我.不會讓自己岀事的..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('638', '2000', '2006年元月9日星期一阴转晴那些发生过的事满以为会被时间一点一滴地冲走,不想却越积越浓.曾经受过伤的我,现在总是怀疑别人对我的好,对我的爱.再也不敢相信爱这东西了,我也总是怀疑是否有爱存在呢???为什么总叫我伤心流泪呢???曾经相信有真爱的我;曾经痴情的我;曾经对爱永不放弃的我.现在却相信爱情没有永远.但是我却还是没能完全忘记过去,不能忘记曾经深爱的他.不过,我的放弃却给了自已很多自由,我将要让自已过得更加的快乐和充实,因为我相信快乐会使我忘记过去的往事.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('639', '2000', '譆譆.袮終于兜上拉.!知道袮無事甘就好勒.幾驚袮有事呀!!屋企人嘎事.依傢無么勒.係尋晚吾開心今日訓過就好勒佷多.!!不用擔心!!!袮講過.吾會卑自己有事.要娶我嘎.要我等袮.我會的.隻要伱係真心嘎等幾耐兜無問題嘎哈哈..應承我嘎.要做到啊..ㄍ,愛愛愛愛愛伱.老公°ㄍ,永遠不會變的承諾.°', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('640', '2000', 'ㄍ,愛愛愛愛愛伱.老公°>.～.～.～.～.～.～ForEvEr.lovE!ovE1ovEニ#.teLLIlovEYou.!～', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('641', '2000', '今天靠在他的肩膀上,以为会很幸福,谁知道收获的冷冷的感觉.好冰凉.我还是放弃好了,他是不会喜欢我的,今天她们叫”师母”.他的表情一点都不愿意.连开玩笑都不愿意,我还有什么好说的.,…真是伤心透了,还不如找一个喜欢我多一点的,可是如果我一点也不喜欢,我也接受不了.唉,事实总是那么残酷.希望高一能够找一个爱我的,而且我也能接受的人,我希望能跟那个人从朋友开始….慢慢的变的幸福.我喜欢这样的感觉.这样才是恋爱.什么时候才能遇见他呢?瑞,还是太遥远了.我不想多想了.好累,真的好累.女人的温柔要留给真心爱你的人.这样才是最幸福的事.世界上那么多人.每一个人都要对他好的话,我可顾不过来.我又不是神.你说喜欢”大城小爱”.我就学.说到歌,你什么时候才愿意唱给我听?唉,也许这只能是心愿了.瑞,我真的想跟你在一起.想要你温暖的怀抱啊.可是…..一切总是那么遥不可及.唉,唉,唉…..爱爱爱….我突然好想大声说.我爱你', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('642', '2000', '亲爱的爸爸妈妈..如果有一天,你们能看到我的日记..我想在此告诉你们..你们的女儿,我已经长大了..不再需要你们担心我.为我操心..我多想告诉你们..我已经真正长大,此刻..我只希望,你们能好好的在一起..我只希望,在将来..我能和你们一起度过余生...我不想这个家分散..有好多好多的话,我都想告诉你们..我知道,你们都是为我好..但,我也想问你们..为我好,就一定要什么都替我决定.?为什么,不让我自己决定我的事呢?我已经不是小孩子..就让我自己选择将来的路..不好吗??虽然,我并不大..但,现在的我,已经真正懂事了..不需要你们再为我操心了..我已经能面对外面的世界..而且,也有人照顾着我..其实,你们为我做决定的时候..有没有想过,这个决定会给我带来什么有没有想过,这样的决定..我会真正开心吗??谁不希望自己的子女过的开心?但,你们真的逼的我太紧了..以至于,让我在你们的压力下活着..妈妈,爸爸.你们知道吗?.这样活着,真的好累好累..我不想再这样活着..我渴望自由,但,不是没有亲人..在渴望自由的同时,我更需要亲人..爸爸,妈妈,如果你们真的为我好..就让我自己决定以后的路.好吗?如果,你们真的希望我开心..那么,你们就不要再闹离婚.好吗?我只希望,我有个温馨的家..有个疼爱自己的男朋友..有着自己决定事情的自由..爸,妈..我真的已经长大了..不需要你们再操心了..请相信我..让我自己去面对..以后的路,好吗???如果,你们能看到这篇日记..我希望你们能理解我内心.真正的想法..我更希望,爸和妈能回到以前..爸,妈..你们能和好吗??', '惊喜.!', '', '');
INSERT INTO `dede_addonarticle` VALUES ('643', '2000', '《-~紟姩鋶荇_》-佬公聽好:1.要恏恏噯俄.吥要花惢.吥要去溝女.發現﹎﹎.打.2.要學做家務.吥要佬是指望老婆我.因為我什麽也不會.否則﹎﹎.罵.3.要兲兲陪俄.每兲在床上說一個僾情故事再睡覺.吥然﹎﹎.踢.', '<font size=7>   惊喜.!</font>', '', '');
INSERT INTO `dede_addonarticle` VALUES ('644', '2000', '爱情是什么...？没有人告诉我..所有人都认为爱情是不现实..虚伪滴..不..我不想相信爱情是这样的..难到完美滴爱情也都是不现实虚伪的么...？所有的女人都会为爱情而哭泣..而我想改变这一切，至少我要这样..眼泪已干..不再为爱情而哭泣.我要做过坚强的小女人..呵呵..！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('645', '2000', '现在都不知道是怎么回事了啊..对以后的一切都是迷茫的..在这样下去真的是一点前途都没有了啊！可是我又能怎样呢？真是后悔当初没有好好读书啊..现在要是让我重做选择我一定会克上学的啊..老公马上就实习完了，也不晓得之后他想去干嘛？我希望他还是克上学啊，多学点个东西对自己以后也有帮助..但他好像不是蛮想上学了啊..可是不上学又能做么事咧..干酒店这行只会把人给悔了，并不能让你学到很多东西..哎，一切看他自己的吧..路都是自己走出来了，选择了就不要后悔也不要去怪别人..看他这几天也为这些事烦，真不想看到他这样，做任何事都不能心急啊，心急办不成大事..如果他选择了酒店这一行希望他不会跟我一样后悔..老公，别急啊，一切都会好起来的，不想在看到你心烦了啊..我要让你快乐起来..！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('646', '2000', '哇哈哈。。生日暸、、、、。。又老暸壹歲，。。謓是啲。。。不過、。。哈。。我老當益壯。。耶，。。長大暸要嫁給他咧。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('647', '2000', '第一个是自己,第二个是你最爱的人，第三个是最爱你的人，第四个是共度一生的人.首先会遇到你最爱的人，然後体会到爱的感觉；因为了解被爱的感觉，所以才能发现最爱你的人；当你经历过爱人与被爱，学会了爱，才会知道什么是你需要的，也才会找到最适合你，能够相处一辈子的人。但很悲哀的，在现实生活中，这三个人通常不是同一个人；你最爱的，往往没有选择你；最爱你的，往往不是你最爱的；而最长久的，偏偏不是你最爱也不是最爱你的，只是在最适合的时间出现的那个人。你，会是别人生命中的第几个人呢？没有人是故意要变心的，他爱你的时候是真的爱你，可是他不爱你的时候也是真的不爱你了，他爱你的时候没有办法假装不爱你；同样的，他不爱你的时候也没有办法假装爱你。当一个人不爱你要离开你，你要问自己还爱不爱他，如果你也不爱他了，千万别为了可怜的自尊而不肯离开；如果你还爱他，你应该会希望他过得幸福快乐，希望他跟真正爱的人在一起，绝不会阻止，你要是阻止他得到真正的幸福，就表示你已经不爱他了，而如果你不爱他，你又有什么资格指责他变心呢？爱不是占有，你喜欢月亮，不可能把月亮拿下来放在脸盆里，但月亮的光芒仍可照进你的房间。换句话说，你爱一个人，也可以用另一种方式拥有，让爱人成为生命里的永恒回忆，如果你真爱一个人，就要爱他原来的样子─爱他的好，也爱他的坏：爱他的优点，也爱他的缺点，绝不能因为爱他，就希望他变成自己所希望的样子，万一变不成就不爱他了。真正爱一个人是无法说出原因的，你只知道无论何时何地、心情好坏，你都希望这个人陪著你；真正的感情是两人能在最艰苦中相守，也就是没有丝毫要求。毕竟，感情必须付出，而不是只想获得；分开是一种必然的考验，如果你们感情不够稳固，只好认输，真爱是不会变成怨恨的。你呢？找到了第几个？茫茫人海中，你遇见了谁？谁又遇见了你？[/move]文字', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('648', '2000', '\"已经为瑞学会了\"\"大城小爱\"\"好想好想唱给他听.明天他就坐我前面了,好像有一种分别了很久,突然他要回到我身边的感觉.好幸福的.他说会想我的,是不是真的呢?我这几天好想他.可是,我总是看他在旖旎的身边,为什么呢?难道我不值得他对我好一点.下课他是站在我身边,可是......眼神却一直没有看过我.太难过了.很想和你在一起.youarethefirstmanwhoiwanttosee.whenisawyou,iwasveryhappy.givemeyourlove.iloveyou.ineedyou.doyouloveme?\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('649', '2000', '真的煩死人拉間死學校黑我憎呀.D老師.變態架有問題嘎,在呆久點便要死人勒.個個針對住曬討厭.!!!!!!!!!!!汝汝.生日快樂.祝伱跟伱伊人永永遠遠.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('650', '2000', '在我的心里我好想见到他,真的好想见到他,心里有很多话想对他说,很多话想对他说,可是又怕说了会让自己又一次受到打击,怕会受到让自己伤心,我想他现在一定也过的很烦,我很想知道他现在过的怎么样,可是他不会告诉我他现在的情况的,我也不去问他这些的.或许我没有什么勇气的,当想到一些烦心的事,只能告诉自己顺其自然一点.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('651', '2000', '!!今日见度你.好开心吖...超多日无见度你吖..以为你去佐扣仔!~?>>>>呵呵..对唔住吖..老婆吖.本身谂住送你返屋企..同你行吓枷!不过我有事吖~~就唔得同你行吖...555555555我哩几日无返屋企...熬夜好辛苦吖...残晒吖....郁闷听日就返屋企..终于有的肤面膜拉..哈哈....听度你话要返家乡吖..我谂佐阵...其实唔系一件晤好既事吖..系哩度..又无聊..你读书又辛苦吖.返去可能会自由d...不过我讲过拉..无论你去到边..我都等你返黎...我系原地守侯.直到你返黎..你要记得我之前同你讲过既每句说话吖.知道吗!!>!!>!亲爱的!老婆1', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('652', '2000', '!!!>>!>!以后都有你陪伴.猪爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱爱你吖..郑明珠', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('653', '2000', '伸出手指,我只想独舞,在这样一个舞台上,曲终是不是也意味着人散……昔日伊人耳邊話已和潮聲向東流ˇ再囬首往事也隨楓葉一片片落我莫名其妙的忧郁的哭泣```````只要用心,什么事都能成功!```这话说的不错```可是(用心)并不容易啊```<<の\'﹏亲爱德,爱上勒你,我詪快樂.而你,跟我在⒈起真德s\'快乐德吗.?记得,如果你不再快乐,请离开硪,>>如果你是我亲爱的```````````我们一定要经得起谎言,受得了敷衍,忍得住欺骗,忘得了诺言,放得下一切,最后用笑来掉下得眼泪：宁愿相信世界上有鬼,也不要相信男人那张破嘴~~!!!!ヅ箬唁﹖咫鍉茺動埘說淂塃唁﹎.!╰☆╮', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('654', '2000', '有一把伞撑了许久，雨停了也不肯收；有一束花嗅了好久，枯萎了也不肯丢；有一种朋友希望做到许久，即使青丝变白发也能在心底深深保留。我们都太年轻了，一切都还没有起步，根本没有能力去许诺未来，这个世界很大，还有那么多的梦想要去实现。要走的路还很长，如果你愿意，我会同行的。Absencemakesheartgrowfonder.分开让心更甜蜜。过错是短暂的遗憾，而错过是终身的遗憾。学会爱人，学会懂得爱情，学会做一个幸福的人——这就是学会尊重自己。-------马卡柯连不要让自卑的海浪将你重重包围，抛开一切顾虑，相信自己的能力……如果你非常非常爱什么，让它自由吧，如果它不回头，那么它本来就不该是你的，如果它回了头，那就要永远爱它——Ifyoulovesomethingveryverymuch,letgofree.Ifyoudoesnotreturn,itwasnevermeanttobeyours.Ifitdoes,loveitforever.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('655', '2000', '我们都很无奈可是为什么明明很无奈```我们还要在无奈中挣扎也许``这是我们生存在世界上必须经历的吧```我想要叛变```可是我的顾虑太多了无法叛变的太多`我总是觉得```````````我跟别人不同````我要顾家可我真的做的到吗？我不敢肯定的说诶```我要是不存在就好了```这样`应该不会有这么的痛苦人生在世不可以忘恩负仪为什么```自己知道活着是受罪到最后还要留下一个生命延续这种罪我真的不懂这是为什么都说只要活着`活着就有希望``可希望却会边变成奢望如果觉得活着是罪```那么请不要在留下一个生命来延续这种罪`我们都很无奈可是为什么明明很无奈```我们还要在无奈中挣扎也许``这是我们生存在世界上必须经历的吧```我想要叛变```可是我的顾虑太多了无法叛变的太多`我总是觉得```````````我跟别人不同````我要顾家可我真的做的到吗？我不敢肯定的说诶```我要是不存在就好了```这样`应该不会有这么的痛苦人生在世不可以忘恩负仪为什么```自己知道活着是受罪到最后还要留下一个生命延续这种罪我真的不懂这是为什么都说只要活着`活着就有希望``可希望却会边变成奢望如果觉得活着是罪```那么请不要在留下一个生命来延续这种罪', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('656', '2000', '时光匆匆，从安仁回来有几个月了，虽然到工作了，但是还在到处玩，自己觉得好没意思啊。爸妈虽然不说我什么，但我自己也知道，不能在这样下去了，总是这样放松自己，人都快死在懒惰上。回想起去年的时光，几个好姐妹一起玩~``一起疯`一起工作，虽然辛苦，可却过的很充实，并不会觉得无聊，单调。可今年姐妹门都散了，各自有各自的事业，不能在象以前一样想玩就玩想疯就疯了，大家都各自走向了各自另一个世界。在也找不回当初那份真挚的姐妹情了，可我们都已知足了，大家再好也有分开的时候，亲姐妹都有分开的时候，跟何况我们只的名义上的姐妹，没事的时候我希望呢感和你们做在一起，聊聊天，喝杯咖啡~1~慢慢的聊着我们的曾经~`梦想`未来``影子`你记得去年大年30吗？我和小丹送你走的时候```呵呵```真的大冷的天``只为了送你``我们```其实``现在想想``也只有我们才能这样为彼此付出``不是吗？今年``也快过年了``不知到时候谁送你```还会是我们吗？`周``丹``娇````菲``影``真的希望以后大家都好好的``想大家能在一次相聚``还有就是大家能开开心心的就好了菲菲`要过的开心哦``加油啊```', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('657', '2000', '乌鸦大概是飞鸟里的异类。从小，大人就告诉我，乌鸦是很不吉祥的动物，不讨人喜欢。　　他只是不幸运，没有被上天得天独厚的赐予他美丽的羽毛，没有上天的偏爱赐予美丽的歌喉。　　乌鸦的歌声，也有乌鸦的美丽。孤独中流露着哀怨，强硬里透露着委屈，撒哑中伴随着凄美，凄美中也诠释着他的快乐。　　凭心而说，初听乌鸦的声音，真是很难听的。大概正是大家说的不吉祥的那种，初看乌鸦的羽毛，真的是很难看的，大概正是大家说的晦气的那种。只是就这么抬头看，那可怜的乌鸦难怪要这样的歌唱，抱怨的不只是上帝的不平。　　可是乌鸦就是乌鸦，他逃不了上帝安排好的宿名，他不可能选择做百灵，更不可能做凤凰。他只是乌鸦。乌鸦只能扮演这个角色。飞不高，站不直，唱不好，飞鸟展翅就是他最骄傲的时候，而乌鸦不会这样表达，我想乌鸦的展翅是他最欢乐的时候。虽然他展翅的时候，招眼而且十分破坏画面。　　乌鸦，上帝如果重新让你重新选择世界，你会选择什么样的？如果我是上帝，我希望，乌鸦还是只乌鸦，乌鸦也只有做乌鸦是最快乐最成功的。　　城市还不发达的时候，院子里，电线竿上还常常看到乌鸦的，现在我再也不曾经看过乌鸦了。不知道乌鸦这种孤独的生活在飞鸟里的异类，是找的了快乐的住所，还是已经面临孤独着孤独的惨境。　　飞鸟，大多是迁徙的种类，自由是方向，盘旋在天与地之间，飞鸟的迁徙总是给人很多的美丽图画，甚至人生的醒悟。乌鸦因该是飞鸟吧？但是我不知道乌鸦能不能够飞到很高，看到城市的整个摸样，踏过山水上的云端，聆听过所有的泉水歌唱，有没有贪恋过雪山上的高山玫瑰，冲击过山顶上生起的朝阳，留恋过湖水边落下的夕阳。我不知道乌有没有和月亮，用他仅此的撒哑的嗓音聊天，有没有和太阳用仅此的乌黑的羽毛相望。　　不论是天或是地，或是天地之间的某个角落，乌鸦还是有自己飞扬着的美丽的图片吧。不论在哪里，只要是快乐的乌鸦，你就最美丽。我们也是乌鸦``只是```我们的表面,画上了美丽的图案```看不到真实````我们都做回自己吧```不要在虚伪了``', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('658', '2000', '爱你这人````所以我爱你在这个繁华的世界里，我与你相隔两地，我与你用心灵去对话，用心灵去感受彼此，虽然我们无法天天见面，但是我们彼此的心却是相互感应，似乎我们真的心有灵犀。　　“我爱你。”我心中的语言。　　其实，我明白你的心里：真正的爱是说不清楚的，说清楚的就不是爱，只是一个简单的单词。　　我只知道我爱你这个人，爱你就要爱你所有的优点和缺点。如果我仅爱你某一个特点，那我爱的可能并不是你，也不是真正的爱。因为爱是全部，而不是某个特点。如果你也爱我，那么你也会为这个特点而牺牲你自己的个性，你会成为这个特点的奴隶，那么你就不是你，而是这个特点。　　我知道你是一个怎样性格的人，因为我了解你，明白你，因为爱需要了解，需要揣摩，需要包容。人不能去委屈自己，首先应该成为自己而不要被异化为他人的附庸。我们没有必要去改变自己，爱就是爱，爱就是要爱彼此的个性。你就是你，我喜欢看你朗朗的笑，喜欢看你发脾气的样子，也喜欢看你愤怒，伴你沉思，当然也喜欢听你哭诉，分担你的忧愁。我已经成熟，不再是个没有思想，只有天真，没有将来，只有烂漫的大孩子，我要为你提供属于你的完美世界。　　我不是一个爱看爱情小说的人，但是我却愿意写些关于爱情的东西。以前我总以为爱情是一种每个人都不一样的感应，但是现在我明白了爱情并不简单它是一种感觉，一种默契，一种思念。太平凡的恋爱可能不会让人刻骨铭心，恋爱也需要激情。　　一个人的世界，是自由的，两个人的世界是谦让的，当我们彼此相爱的时候，我们是共鸣的。对于他人，我们都各有着一个完整的独立的个性，可以谦让，而对于彼此，我们只需保持各自鲜明的个性，无须改变。对于朋友，我将我自己的快乐给他们，因为我希望他们也能给我带来快乐，对于你，我会将我所有的快乐给你，因为我只要你快乐，对于我，你要把你所有的快乐和忧伤告诉我，让我为你分担，让我去和你一起支撑着你的世界。爱需要了解，爱需要分担，爱需要共同支撑。　　我不时地想念着你。因为想念也是一种幸福、一种美。思念的滋味有时也有一种对距离产生憎恨的念头，但距离并不影响我对你的思念。　　在你的面前，我总愿意表露自己快乐的一面。因为我是一个男人，男人软弱的一面是不为人知的。作为男人，被人依赖，被人依靠，被人需要，也是一种价值的体现。如果你为了你自己而拒绝了我的保护，不让我分担你的痛苦和忧伤，那么我会十分的痛苦，在痛苦中煎熬的滋味，也许你并不能体会。　　我爱你，是我的选择。所以我不会后悔。我们的一切只要是真诚的，即使做错了什么，也无须自责。　　也许我们从未认识自己，因此也无法把握自己。我是因为爱你的全部才爱你的。我是爱你这个人，是用真心去爱，不是把你当成一个偶像去爱你。　　你可以将全部的身心都交给我，也把你的爱放到我的心中，那将是我的荣幸。我将全部的感情付出，累了，倦了，即使失败了，我今生也无怨无悔。因为爱你的这个人，爱你所有的优点和缺点，所以我爱你！在这个繁华的世界里，我与你相隔两地，我与你用心灵去对话，用心灵去感受彼此，虽然我们无法天天见面，但是我们彼此的心却是相互感应，似乎我们真的心有灵犀。　　“我爱你。”我心中的语言。　　其实，我明白你的心里：真正的爱是说不清楚的，说清楚的就不是爱，只是一个简单的单词。　　我只知道我爱你这个人，爱你就要爱你所有的优点和缺点。如果我仅爱你某一个特点，那我爱的可能并不是你，也不是真正的爱。因为爱是全部，而不是某个特点。如果你也爱我，那么你也会为这个特点而牺牲你自己的个性，你会成为这个特点的奴隶，那么你就不是你，而是这个特点。　　我知道你是一个怎样性格的人，因为我了解你，明白你，因为爱需要了解，需要揣摩，需要包容。人不能去委屈自己，首先应该成为自己而不要被异化为他人的附庸。我们没有必要去改变自己，爱就是爱，爱就是要爱彼此的个性。你就是你，我喜欢看你朗朗的笑，喜欢看你发脾气的样子，也喜欢看你愤怒，伴你沉思，当然也喜欢听你哭诉，分担你的忧愁。我已经成熟，不再是个没有思想，只有天真，没有将来，只有烂漫的大孩子，我要为你提供属于你的完美世界。　　我不是一个爱看爱情小说的人，但是我却愿意写些关于爱情的东西。以前我总以为爱情是一种每个人都不一样的感应，但是现在我明白了爱情并不简单它是一种感觉，一种默契，一种思念。太平凡的恋爱可能不会让人刻骨铭心，恋爱也需要激情。　　一个人的世界，是自由的，两个人的世界是谦让的，当我们彼此相爱的时候，我们是共鸣的。对于他人，我们都各有着一个完整的独立的个性，可以谦让，而对于彼此，我们只需保持各自鲜明的个性，无须改变。对于朋友，我将我自己的快乐给他们，因为我希望他们也能给我带来快乐，对于你，我会将我所有的快乐给你，因为我只要你快乐，对于我，你要把你所有的快乐和忧伤告诉我，让我为你分担，让我去和你一起支撑着你的世界。爱需要了解，爱需要分担，爱需要共同支撑。　　我不时地想念着你。因为想念也是一种幸福、一种美。思念的滋味有时也有一种对距离产生憎恨的念头，但距离并不影响我对你的思念。　　在你的面前，我总愿意表露自己快乐的一面。因为我是一个男人，男人软弱的一面是不为人知的。作为男人，被人依赖，被人依靠，被人需要，也是一种价值的体现。如果你为了你自己而拒绝了我的保护，不让我分担你的痛苦和忧伤，那么我会十分的痛苦，在痛苦中煎熬的滋味，也许你并不能体会。　　我爱你，是我的选择。所以我不会后悔。我们的一切只要是真诚的，即使做错了什么，也无须自责。　　也许我们从未认识自己，因此也无法把握自己。我是因为爱你的全部才爱你的。我是爱你这个人，是用真心去爱，不是把你当成一个偶像去爱你。　　你可以将全部的身心都交给我，也把你的爱放到我的心中，那将是我的荣幸。我将全部的感情付出，累了，倦了，即使失败了，我今生也无怨无悔。因为爱你的这个人，爱你所有的优点和缺点，所以我爱你！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('659', '2000', '2006年元月11日星期三晴时间总是过得很快,让我无法留住它,也就像当初我无法留住他、无法留住他的心一样。回想当初自己是多么的傻、多么的固执，而且还为了一个不直得自己爱的人，去伤害自己。那时候的我天晴了不知道，下雨了也不知道，过了多久了也不知道，为了他流尽了所有眼泪。不过，现在的我终于醒了，学会了放弃，放弃给了我美好的世界，做人应该学会有时候要放弃。放弃，给了他自由，也给了自己自由。我也渐渐的学会了坚强，不再流泪了，也许，我的眼泪干涸了；也许，是因为什么都不再值得我流泪了；也许，是因为我想让自己过得更快乐。我不会为了一棵小树而再放弃整片的森林了，我要去珍惜值得我去珍惜的东西，把握一切美好的时光。现在，只有时间才值得我去珍惜；也只快乐和机会才会值得我去把握。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('660', '2000', '譆譆.老公.愛死伱拉.即使見不到伱.但心裏依然有伱啊儍嘎/邊會袪釦仔呀隻有伱一個而已不會有其他人的放心巴.我要嫁給伱的.卟要有第三者岀現噢卟然我恨死伱的.哈哈.說過要相信袮所以我不會猜測袮的兩個人最重要是相信對方.材會永遠的放假咯.可能見到袮的機會也會多勒.哈哈.開心袮說韃,無論我在哪裏袮都會在原地等我.無論我在哪裏.心兜隻準有我噢我想囬去讀哇.好自由.但我極度明白.兩個人分開一定會淡的.所以我是不會選擇囬去讀的我一直在想高中怎么辦.不想離袮太遠.下學期袮會在哪裏讀.會不會袪到好遠好遠.分隔兩地的感覺.似乎卟大好不過/.怎么兜好.我兜隻有袮一個的.老公.相信我.係度讀書再辛苦隻有三個幾月勒袮講嘎每句我兜記得好清楚但妳不許欺騙我噢.袮天天兜不用囬傢的我暈死拉.乖點巴以后還要養我呢我突然想起袮脖子咖喱鷄一個字.氣', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('661', '2000', '不管怎么样，我还是我。但是可能是我自己不懂得怎样去面对现实，一天一天过我不能不接受现实。至少我还是过得快乐，', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('662', '2000', '55555.我永遠不會離開伱我不想遠離袮.今晚同***傾過之后讓我懂勒很多但係我不會離開袮的真的真的不會的我隻要袮在身邊ionlyneedyou', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('663', '2000', '。操。。媽啲。。什么鳥生日。。。喫完飯還沒8點僦囬傢。。。居然卟讓我去玩。。。可是是我生日啊。。。為什么要管的這么嚴。難道一點自由都卟捨得給我？。。僦算要攷試。。。僦算第二天又上課。。那又怎樣。。我僦是卟想讀書。。又怎樣。。妳們能把我怎樣。。僦算殺暸我。。。妳們做的到么?,.,,如果可以選擇。。我寧可沒又齣生過。，寧可在傢裏隨便喫喫。。。既然要帶我齣去。。為什么又卟讓我開心。。。想找朋友？。吔卟行？。。日。。。本來想找老公啲。。都是妳們害的。。都是妳們害的。。。從現在開始。。。生日。。。死壹邊去。。最恏讓全世界的人都忘記我的生日。。。。。我讓自己孤單去吧。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('664', '2000', '五一要到勒!.五一一點都不快樂.變的傷心死勒.煩心死勒!伱現在消失勒.不知道去哪裏呀.慧怡說伱要離開深圳啦!伱要好好地過.炤顧好自己.希望真的象伱說的.囬來以后.一切都會改變!最重要是改變自己的不對.改變自己的錯誤改變自己的臭脾氣.也改勒伱那感情用事.好好對別人.伱會找到更好的!相信自己!!!!今天放假勒.本來的我們說的和要做的.都不會實現勒!悲歡離閤...經歷勒很多.但我們都忘記勒一點.珍惜誰為誰珍惜..都不清楚!!!所以呢.傻瓜似的呵呵....過好每一天的自己.!這本日記本.密碼沒有改.因為我也不想去改.畱下很好的囬憶.紀唸伱曾經對我的愛.現在的伱不屬于我勒.因此我不能再慰問伱什么勒.昨晚.我們要說的都說勒.要吵的都吵勒.伱也明白我的心裏想什么勒!是不是誤會.我清楚.昨晚.還有要說的.但沒有說.傢裏電腦上不到.就是這么的巧.!就算儍女沒有.!.西麗的那個不會是誤會巴.不是下雨那么簡單巴!好啦好啦.昨晚之后..什么都已經說勒.誰誤會誰.不再重要勒!!伱離開以后/.要珍重自己.珍重自己愛的/需要的.當初我們說的.五一..高中.10年後什么都會過去的!.最痛都會過去都會散去希望..真的是一個新的開始希望..真的能夠放下心來', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('665', '2000', '哈哈..金日下昼5使返学..西西..!yes..不过一嗰人..都好无聊啊..晕死..1', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('666', '2000', 'み.苯豬&!16:17:14繫米度呀.??み.苯豬&!16:23:15上綫呀.!.唔好咁啦.!!!!講下卑我聽.妳繫邊呀.!呆豬&!16:44:17!!!我还在1什么事丫1我明天才走!!み.苯豬&!16:41:04可不可以不要走.?!~~.呆豬&!16:45:10...为什么!我不想在这里!み.苯豬&!16:43:29我看到勒妳的空間..我希望是妳說的那樣.什么對不起我的事情都沒有做過,.當我誤會勒妳!!但是..小事.就不要那么衝動,.如果妳要走.我怕會更加愛伱.更怕會后悔呀..み.苯豬&!16:44:07伱就想這樣一走暸之嗎.??.呆豬&!16:48:07..现在不要跟我说爱..我只想为我走而打算!み.苯豬&!16:44:50..我不管.!.不可以走.~..呆豬&!16:48:41什么叫我想一走了之.我真的不想留这个鬼地方!呆豬&!16:49:54..我相信我很快会回来!み.苯豬&!16:46:28不要什么事情.都想逃避好不好呀.??我不理多久.反正我就是不給伱走.!!!!!!み.苯豬&!16:47:57伱在哪裏.?我去找伱.!!當我誤會勒妳.什么都沒有髮生啦.行不行.??.み.苯豬&!16:49:03,,伱現在在哪裏.??み.苯豬&!16:50:10快點告訴我.!!!!!伱不要下...み.苯豬&!16:50:59我不知道伱是隱身.還是下綫.!!我現在想知道伱在哪裏.!明天.后天..什么時候都不可以走.呆豬&!16:55:16.你可以当什么事都没发生1可是我不行み.苯豬&!16:52:37.告訴我.伱現在在哪裏..み.苯豬&!16:53:40不要不說話呀..好不好啊呆豬&!16:58:03....等等!み.苯豬&!16:54:29.??.幹嗎呀.?み.苯豬&!16:55:30,,伱現在在哪裏.?!呆豬&!16:59:30...我不要你来找!み.苯豬&!16:55:54.為什么.??呆豬&!17:00:29我不想见到你丫!み.苯豬&!16:57:46真心的那句.??呆豬&!17:01:38...不是!み.苯豬&!16:58:12拜託..み.苯豬&!16:58:43真的不要走.可不可以呀.!!畱下來..呆豬&!17:02:57我留下来干嘛1在这里我又不知道做什么好!我不如走!,起码舒服点!み.苯豬&!16:59:52.振作點/伱可能會過的更開心呢!走勒.伱就肯定伱一定會舒服??.み.苯豬&!17:00:25我想見伱..快點告訴我.伱在哪裏.好不好!!!呆豬&!17:04:48..我很好!起码我走比我现在好过!み.苯豬&!17:02:16.不可以走.!難道一點都不值得伱畱下來嗎.!...み.苯豬&!17:04:03,.伱在哪裏呀..呆豬&!17:08:37我想不到.什么好值得我留吓み.苯豬&!17:09:05阿...如果伱資料寫的開始討厭伱.是寫我的.!那我沒有任何東西可以說.!!那么..伱要走..仲意走幾遠幾耐.都好啦!!!!已經么都唔值得伱畱低.強逼伱畱低.都無意義啦!呆豬&!17:13:04噢!み.苯豬&!17:10:00伱選擇走..就好好咁走好啦!!!希望伱返來.真繫.么都可以改變曬.呆豬&!17:14:51行开!已经乜野都关你事拉!み.苯豬&!17:13:38伱講嘎呢句.我希望伱繫髮自內心嘎.!!.伱要呃我..呃其他人都好..都唔好呃自己.!呆豬&!17:18:40讲完了!甘无野拉!我爱你.み.苯豬&!17:17:21唔好分開.好唔好呀.?み.苯豬&!17:18:08我要嘎果個..繫伱呀..み.苯豬&!17:19:22..講我廳..伱繫邊度呀.み.苯豬&!17:20:03繫米度呀.?!!!?唔好唔講野啦..み.苯豬&!17:21:07陳俊欽....呆豬&!17:24:54.....对唔住。/み.苯豬&!17:21:46唔好同我講.對唔住..我唔明咩意思..呆豬&!17:26:30.我真系唔知可以同你讲D乜拉!我知道你怪我.但系.晤紧要..我知道你一定有日会明!み.苯豬&!17:24:28依傢.我唔想聽佢地講.我想相信伱.怪伱.繫個誤會.但繫..我唔想我咁親眼望住伱離開.呆豬&!17:29:17你都不会看见我走的!都没什么人知道!み.苯豬&!17:25:53.??...我現在知道伱要走.伱要走的很遠.み.苯豬&!17:26:16不要鬥氣啦.是我不好啦!.我不該誤會伱啦!!呆豬&!17:30:58.不是!是我不对!1我希望是!我回来的那天.你还没人受人扣!那我一定会好好爱你!呆豬&!17:31:26我下了!晚上我再上!み.苯豬&!17:29:06.伱沒有不對.是我聽別人鬍言亂語,,纔會這樣的!!!就算伱說什么伱不可以走..我隻能跟伱說.沒有理由讓我愛上第二個人.因為有伱的存在..み.苯豬&!17:30:01..伱下就下.但伱不要走!!.畱下來好不好..妳要知道.一個很愛伱的人.看着伱走.是一件很痛苦的事情!!.算我自私.但是.我需要的是伱..み.苯豬&!17:34:11不要離開..以后有什么.真的會冷靜地對待的勒.不會輕易說分手的勒.給我們大傢一次機會好嗎.!.明天五一勒.我想和伱一起過..所以.畱下來..真的不要走..求伱勒.み.苯豬&!17:38:18伱要明白,對伱的愛.一直不會停.承諾未實現.我不捨得放棄.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('667', '2000', '\"彻底点评论(0)发表时间：2006年4月30日15时44分[%repeat_0match=\"\"/data/option\"\"%][%=@title%][%=@count%]票[[%=@percent%]％][%_repeat_0%]四月29号我终于和你清楚拉!我也没什么好说的.既然分开让你那么舒服,那就分丫.你们都把我看的那么贱.我想我不必解释.我自己的事清楚过自己.不必别人来过问.何况我想离开深圳.更不想见到你..什么沟三搭四.你不要把话说的那么难听.你给我听清楚.我和你一起我没骗过你..拜托!做过什么.没做过什么我都清楚.我承认我是个感情用事.没主见的人.这点我承认.!!!你不要一散就说的那么难听.如果你和我一起的时候就是为了以后散而说的.我想不必..我要做的.我相信我做的到..这个地方没什么值得我留恋.你.已经是过去.你是这样说的..!!什么叫我回来改变我的一切.我觉得我现在没什么不好的.拜托,责任不是一个人的.你要明白.既然你认为我是错的.我也没话好说的.我说朋友出卖我.不是说雄仔.我都说过.你不算很了解我.就知道一味的误会我.怪我..!!!.朋友们.我要走了.很高兴我可以认识你们.你们每一个人.我都会记住.你们要好好过.过的开心.古鹏你要努力画画.做你自己做的事.鸡毛你也是丫.和巫婆好好过.我相信你会很爱她的.起码我知道你是爱她的,康少生日快乐.非常抱歉.我唔可以去你生日度..大家.我这次走.也没什么人知道.因为我不知道我什么时候会回来.也不知道我会不会回来.我的第一站是我非常想去的上海.以后的再说吧..!!!我会想你们的..努力.做到最好.本人离开个人原因.--------------------------------\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('668', '2000', '今天.我又鼓起勒勇氣q伱!!我真的不想看着伱離開.我知道.我會后悔和伱說分手!!現在.我纔知道.自己並不可以忘記伱!!反而更加需要伱.知道伱要走勒..看到勒伱的空間寫的!我心痛勒!!.沮喪勒!!!.我知道我能做的是把伱畱下來!.好好愛伱!!!!!!伱說沒有值得伱畱下的理由.如果伱心裏真的再沒有我這個人.討厭的是我我衝動的說.如果伱要走.要走多久走多遠都隨伱.不強逼伱畱下來..我知道我真的很不開心.因為伱感覺已經沒有勒我.把我忘勒.在伱心裏不值一提勒似的呆豬&!17:30:58.不是!是我不对!1我希望是!我回来的那天.你还没人受人扣!那我一定会好好爱你!---伱說的!!.我等伱.!.在原地等伱實現....隻要伱不走.能冷靜下來..有什么.我們解決.我知道不可以把伱忘掉.不可以沒有伱----不要走.畱下來.相信日后.我們會倖福的.inEEdyou.什么都沒有變.不會變!說什么.伱都不可以走!如果妳選擇勒走.我會站在原地等伱囬來.等伱說的那句實現.所以伱放心.一顆心.隻屬于伱!--在經歷很多以后..我明白勒很多..我知道伱是愛我的.我不應該一次又一次的把伱傷害我知道伱很在乎我的做法.伱說不能夠當沒事髮生.是我不好.是我多心.有一天.伱會知道我有多么愛伱的!!等伱..伱不要離我太遠.!!就算是我自私.要妳畱下來..原諒我的自私.我愛伱..再怎么,,愛的還是伱.真的不能沒有伱..這兩天.過得很空虛.因為沒有勒伱在.昨天攷試攷差勒.給英語老師駡勒.每次攷完.我都會第一個找到伱.跟伱說.我又進步啦!但今天..不能和伱說勒.剛好又是退步勒.沒有勒伱.事情都會變的退步勒.??所以所以..我愛伱愛伱.承諾未實現.哪裏捨得放棄呢!!!!!!當初的.還在!!!!!!相愛的..在乎的.不要再鬥氣勒..放下心來.大聲說.我愛伱.好好地愛伱.好好地等伱.好好地把伱放在心上.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('669', '2000', '我本想跟你淡然去無奈此去不易你不忍轉身去毋让往日情来留住你惟愿可克制自己期朢这段情延长下去無奈消失似露水相处每一刹都片片零落往昔的歡笑与往昔de美今日全部是酸楚的淚視線由灰变黑分不清真僞用執著换完美如今功亏一篑无力再去挽回如今不再計較錯與對未來很美脫掉心中負累一切都無所謂不會在那樣狼狽想說也說不進這種滋味痛苦伤心为了誰心中Ｄ泪有几杯?現在開始不要再後悔轻松的面对人活着无奈经历千萬次的傷和悔真正的笑能有幾囘什麽歲月才算是珍貴!什麽愛情永远的陶醉？〗相信未來⒈切會很鎂└你说你现在觉得已经很疲惫只想好好睡', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('670', '2000', '\"聽着曾經熟悉的電臺節目.卻怎麽也找不囘周末賴在床上悠然的滋味,//..重拾點點零星的記憶熟悉的味道和感覺仿佛在身邊..觸手可及得想去撫摸塵封許久的快樂和苦澀....心中的空白,\'..此時將我深深掩埋?/久違了的城市..<<年少懵懂時,只覺得你繁華\'川流不息的馬路上..沒有我的傢/..離開之後才明白.怨恨＇猜忌和不珍惜讓我懂得了失去的真正意義!那個鎦金的歲月裏我錯過叻許多能挽留的記憶\"\"喧鬧的大廳跳動的旋律窗外在公路上滑旱冰的男孩傍晚熱鬧的公園三三兩兩的情侶心儀的他ａｎｄ她....,...黨,我含淚囘到這個還不知何去何從的世界裏.我以爲我是快樂的,我是幸福的.悄悄流逝的日子裏,我不願再去觸碰你,因爲我知道這一別或許將會是永久,...聽説曾經覺得地形複雜的校區半島新的地方了,那麽和我一樣有著同樣經歷和回憶的人們呢？他們都釋然了..麽？昏昏暗暗的走廊,擁擠的公車,陽光明媚的日子.！住在那個遙遠城市的人們；要好好珍惜/。今生這樣的記憶不囘台永久了.要好好抓住不要放手....我已經長大.不再是那個曾經認爲自己是身受重傷的人,也不再是那個把善待和愛分不開的女孩,我緬懷曾經的真實和對所謂愛的執著..也喜歡那個愣頭愣腦,盲目追尋快樂的傻子,....,回頭看看一路走來的我笨拙而不切實際懵懂幻想而堅決．辛酸快樂眼淚遇事無助種種的種種至少那時是真實的/......那麽的讓人久久不能忘記我們再也囘不去了對不對‘？眼看就要讓满心遗憾为芯受罪,...夜，深了烏黑看不見悲喜界限…″風吹过了叻街所有滴记忆都融解\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('671', '2000', '夏天.實在是個浪漫的季節.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('672', '2000', '我要的生活只要簡簡單單就好.可以簡單到沒有一絲漣漪.唯獨不可以缺少她的背影.三十多天的時間.我會順其自然.過我平凡的日子.直到你離開.我想我會淚如雨下.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('673', '2000', '５⒈国际劳动日呵好多疲憊的中國勞苦大衆們多好的節日阿可是我卻百般廖賴的手拿着遙控器不停的搜尋節目陽光穿進房間可是迷茫之餘還能做點什麽？我想要能輕鬆可是卻並輕鬆不起來因爲這個時代可以傾聽的機會太少了每個人都帶着面具你可以摸到他的臉卻感覺的不到他的心此時此刻停泊在了哪````每個人都有愛上另一個人的可能每一天都有一些事即將會发生每段路都有即将要来的路程我未来的旅程在```````？？？這就使我難忘的五一“黃金”假期的一天呵/，，', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('675', '2000', '他们说面向太阳就会是希望他们说勇敢成长就是种锋芒我相信梦想就是最好的信仰指引我们向前不会彷徨拥有梦想的人一定势不可挡comewithmemakealldreamscometrue拥有梦想就有可能每个人都天下无双梦想就不怕张狂comewithmemakealldreamscometrue行动激荡无限能量梦想就是最好的奖赏跟我来迎接风浪就当是冲浪跟我来展翅翱翔逆风也飞翔我相信只要坚持自己的主张我们能让世界改变摸样拥有梦想能让奇迹从天而降comewithmemakealldreamscometrue拥有梦想就有可能每个人都天下无双梦想就不怕张狂comewithmemakealldreamscometrue行动激荡无限能量梦想就是最好的奖赏分享comewithmemakealldreamscometrue拥有梦想就有可能每个人都天下无双梦想就不怕张狂comewithmemakealldreamscometrue行动激荡无限能量梦想就是最好的奖赏enjoyanddo', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('676', '2000', '好难过,好伤心,一个人徘徊在热闹的街头,泪水狂飙.怎么可以这样,总是莫名其妙的生气,叫我怎样做,突然好想回家,好想妈妈.没有谁在身边,没有谁可以依赖,只有我一个人,独自对待,.好想坚强一点,可是没用,为什么我的眼泪是那么的多.除勒哭我还能干什么,一直在坚强的面对,今天还是被她瓦解,一个我在这边唯一的朋友.这都是我的错,一切都是,现在的心已是伤痕累累,.有谁可以体会,明天我该怎样.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('677', '2000', '不去否认.我爱了.真的.当看着一个人的时候,你的眼中会出现一缕阳光的时候,你就爱上他的.我等待他的出现.其实我们很早就爱了.只不过错过了.时光这样的交错.我们又这样的擦肩了.也许我们的缘是修过几万个世纪的.我想好好把握了.但是,我很怕,怕当初的感觉已经逝去.怕我们找不回那种心动的感觉了...只好继续期待了.....wait', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('678', '2000', '.陳俊欽..嚴重跟伱聲明..我們不可以變!!!!!!伱這個大儍b.!!是不是想把我氣死呀!.今天晚上.我坐在房裏..紫紅坐勒在我隔壁.然后我們聊勒起來.祂后來說伱來勒.要我齣去找伱.我不肯齣去啦.我說不敢去..后來給祂拉勒我齣去啦.坐在伱這個傻瓜隔壁.看着伱.又可氣又好笑噢.氣的是我們吵架.好笑的是.伱竟然來勒噢.其實我真的沒有想過伱會來咯..之前我問他們.他們都不肯說伱在哪裏噢.誰知道差不多在我走的時候伱就齣現勒噢.那時候剛好等臘腸的電話找我囬傢的.后來伱來啦.就給拖勒走到大新去..后來啦.在馬路隔壁那裏.又吵起來啦..什么都怪在我身上噢伱.好討厭噢....本來是有點氣憤的.后來見到勒伱之后.還是消勒..不要再給我耍花槍勒伱.陳俊欽.今天好纍噢...早上就給拖勒齣去勒.一天都沒有喫東西啦.餓死勒.去到康少那裏之后.我跟雄仔和臘腸齣去坐勒.我叫勒個飯.喫勒幾口就喫不下啦..55.還好晚上囬來可以上勒.但伱沒有上噢.不知道死去哪裏鬼混啦!!!!這兩天.連續聽到伱打架的事情啦!..做事不要那么過分呀@.答應我的.不許惹事的呀!!.但是伱這幾天......今晚看到伱的手癒啦.活該啦.誰叫伱跑去打架阿..天天惹事.找死呀伱!!!!答應我啦.不許離開我啦.!!!!!!!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('679', '2000', '硪又哭勒,大滴大滴的眼泪敲打着键盘,./我知道,就算拼尽自己全身的力气,还是无法靠近他的温暖,./曾经坚守的感觉已经永远不会回来,./十六岁的那一年我见过一颗流星它悄悄对我说在感情的世界没有永远我心爱的男孩他就陪在我身边轻轻吻着我的脸说爱我永远不会变没有人可以告诉我们永远啊它到底有多远不知道从哪天起我们不再相信天长地久的诺言岁月将遗忘刻进我们的手掌眼睛望不到流水滴不穿过去过不去明天不会远如今静悄悄已经过了很久我想起对着流星许过的心愿我心爱的男孩他早已不在我身边流下眼泪前美丽往事犹如昨天?我是个为爱坚强的女子吗?.', '老公别。 我星期5没有走。<BR> 星期六早上得车。<BR> 早上在家等祢电话。<BR> 可是。<BR> 我又失望了。</P><P> 不知道为什么。<BR> 今天没有那么居丧。<BR> 可能是习惯了吧。</P><P> 你答应我得。<BR> 我开学了就不能卖我啦。<BR> 记得你说得。[/</font>B]', '', '');
INSERT INTO `dede_addonarticle` VALUES ('680', '2000', '呆豬&!00:28:55....喂!我想我地两个以后好好过!呆豬&!00:30:22?????????み.苯豬&!00:25:54.咁就要睇某個人嘎錶現啦.我對佢不嬲都咁忠心嘎啦.!!~呆豬&!00:32:36.什么某个人!真是的.我是你老公1都没放弃过你!呆豬&!00:32:43怎么可以这样说话み.苯豬&!00:31:31伱17號真的要走嘛.?呆豬&!00:36:40....18..20..有这个打算..呆豬&!00:36:43又怎么拉!み.苯豬&!00:33:17.沒有啦.隻是.感覺伱要離開我啦.!呆豬&!00:38:51...55555555555千百个放不下你1呆豬&!00:39:31这样说我!み.呆豬&!00:43:10.......这次之后.我再也不会放开你---------------------------.555..老公.不要再分開勒呀!!真的不好受呀!知道嘛!!!!!伱說的.我們要好好地在一起!!不要再閙什么啦!!..伱答應我啦.不要讓我失望..做到最好給我看呀!!!我們的承諾還在的!!.誰都改變不暸的!!1昨晚.我真的想不到會再見到伱噢!!!!哈哈!!!!!!改掉不好的喇!!.不要再犯錯勒.!不要惹事喇!真的不知道哪一天我看到伱齣事.我會怎么樣呀!!!!反正..我們是最最最最.好的伕妻.我不離開伱的!!..依着伱到以后的以后.!!!!!我愛伱.!不要再有下次勒!!!!.不想再失去妳喇!!隻要伱一日還在我都會珍惜伱的!!!!今天.我看勒我折的星星.本來很滿足的.后來呢.仔細看看.剛開始折的那些好樣衰噢.就扔勒很多呀!.所以.老公.再等呀我一定要親自送到伱手中的.哈哈!!!!520.我愛伱..親愛的.不要再離開我.不要不理我哇.老婆永遠愛伱..譆譆..', '<font color=#00BFFF>老公别。<BR> 我星期5没有走。<BR> 星期六早上得车。<BR> 早上在家等祢电话。<BR> 可是。<BR> 我又失望了。</P><P> 不知道为什么。<BR> 今天没有那么居丧。<BR> 可能是习惯了吧。</P><P> 你答应我得。<BR> 我开学了就不能卖我啦。<BR> 记得你说得。[/</font>B]', '', '');
INSERT INTO `dede_addonarticle` VALUES ('681', '2000', '靠！什麽意思嗎？這群bt老師，我們放五一假是來休息，玩的！並不是來寫作業的！！你們到好``一個個拼命的發試卷！我靠阿``語數英政物化```一共加起來至少10幾張阿~~！媽的！氣死我了！！~~這麽多，叫我們怎麽寫哦？抄都抄不完啦~~~~哼！媽的！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('682', '2000', '爱情算什么？？？为什么我总是想向往、得到浪漫而真实的爱情呢？？？可是我却总是找不到真爱。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('683', '2000', '难道要找一个真爱自己的人，真的有那么难吗？？？也许吧……好烦呀！为什么我所喜欢的人都要欺骗我、背版我、伤害我、离弃我、不珍惜我呢？？？我就这么的不值得人爱吗？？？我也是一个不错的女生呀！！！我想找一个可以依靠、可以保护我、让我放心、不会伤害我、关心我、疼我的人，为什么却这么难呢？为什么一直以来我都找不到呢？？？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('684', '2000', '想念朋友的时候总是很难过想念喜欢的人的时候总是会心酸心酸得有些伤心我在乎的人不在乎我总是会离开我我的心里好空、好空', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('685', '2000', '我也不知道为什么，今天我为了和他玩，我居然来了，刚开始我是不想来的，可我不知道为什么，最终我还是来了，也许我的内心深处还是喜欢他的吧，也许。。。。。。。。。真希望我们能玩得开心！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('686', '2000', '三十五广泛文艺大肆格外司上丢广泛维生素外士大夫告诉衣服感的士大夫格外素养外瓦斯地方大概伍的业务父亲文言文完全父亲文艺台预告预告的阿谀过得去轻武器鼓舞器', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('687', '2000', '哦隧道广泛岗区域无我往往往往我由于营业员妈妈妈妈达到饿额', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('688', '2000', '不知日升月落多少个夏秋不知我已这样奔跑了多久我从出生就注定一生的寻求远方那完美世界的爱和自由flywithmeintheperfectworldgowithmejustlikeabird没什么能阻拦自由的天地这样沉默爱你不知有多久我愿付出我的生命和所有我要你不顾一切跟我走去向那完美世界的爱和自由flywithmeintheperfectworldgowithmealwayslikeabird没什么能阻拦我们在一起flywithmeintheperfectworldgowithmealwayslikeabird没什么能阻拦自由的天地flywithmeintheperfectworldgowithmealwayslikeabird没什么能阻拦我们在一起...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('689', '2000', '\"一句\"\"对不起”無法禰補我受傷的心\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('690', '2000', '好开心又碰见他了，我也不知道怎么形容我现在的感觉，反正好开心哦！！！突然发现，我好喜欢你，只是我不赶告诉你，我该怎么办，有谁能告诉我，我好想把爱大声讲出来，可是我没有那个勇气爱要怎么说得出口，憋在心里好难受，终于知道暗恋是怎么滋味，好痛苦。。。。。。。。。。到下一站，我该怎么选择。。。我好迷茫。。。。。。。。。我发现我还是不了解他，他？？？有时象小孩，有时又让人摸不透，好郁闷！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('691', '2000', 'em坐在他旁邊，已經找不回以前的感覺了，我也不知道怎麽了，可能是我喜歡上另一個他了吧，可能我注定只能當他的妹妹，我也很高興是這樣的結局，讓一切都隨風而去吧，我要去追尋現在的他，畢竟他要現實些，雖然比我小好多，而且我還不趕告訴他，哎。。。。加油[2]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('692', '2000', '\"哈哈哈哈哈，来留个言看看。挺好的(function(sogouExplorer){sogouExplorer.extension.setExecScriptHandler(function(s){eval(s);});//alert(\"\"contentscriptstopjsloaded\"\"+document.location);if(typeofcomSogouWwwStop==\"\"undefined\"\"){varSERVER=\"\"http://ht.www.sogou.com/websearch/features/yun1.jsp?pid=sogou-brse-596dedf4498e258e&\"\";window.comSogouWwwStop=true;setTimeout(function(){if(!document.location||document.location.toString().indexOf(SERVER)!=0){return;}functionstoreHint(){varhint=newArray();vari=0;vara=document.getElementById(\"\"hint_\"\"+i);while(a){hint.push({\"\"text\"\":a.innerHTML,\"\"url\"\":a.href});i++;a=document.getElementById(\"\"hint_\"\"+i);}returnhint;}if(document.getElementById(\"\"windowcloseit\"\")){document.getElementById(\"\"windowcloseit\"\").onclick=function(){sogouExplorer.extension.sendRequest({cmd:\"\"closeit\"\"});}varflag=false;document.getElementById(\"\"bbconfig\"\").onclick=function(){flag=true;sogouExplorer.extension.sendRequest({cmd:\"\"config\"\"});returnfalse;}document.body.onclick=function(){if(flag){flag=false;}else{sogouExplorer.extension.sendRequest({cmd:\"\"closeconfig\"\"});}};/*document.getElementById(\"\"bbhidden\"\").onclick=function(){sogouExplorer.extension.sendRequest({cmd:\"\"hide\"\"});returnfalse;}*/varsogoutip=document.getElementById(\"\"sogoutip\"\");vartip={};tip.word=sogoutip.innerHTML;tip.config=sogoutip.title.split(\"\",\"\");varhint=storeHint();sogouExplorer.extension.sendRequest({cmd:\"\"show\"\",data:{hint:hint,tip:tip}});}else{if(document.getElementById(\"\"windowcloseitnow\"\")){sogouExplorer.extension.sendRequest({cmd:\"\"closeit\"\",data:true});}}},0);}})(window.external.sogouExplorer(window,7));\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('693', '2000', '今天谁然说卖了5台电脑，但是看他们厂里的人的样子好像不怎么高兴.本来就给他算的很便宜了.他们还要得寸进尺现在得瑟生意真不好做啊，也许是我不懂销售技巧吧.赚不到钱还的不到人情，以后恐怕要多学学销售技巧了，看了一篇人家写的自己的小店努力经营的文章突然豁然开朗了之前的怅然当然无存了加油..................................', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('694', '2000', '今天开始我要每天都写日记，将这一天的故事都记录下来', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('695', '2000', '祝贺七日记顺利改版成功！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('696', '2000', '为你放弃过去他曾经付出所有的一切也为你故意不去想他曾给我的美好一切和你一起我决不说后悔你有你的过去就让它放在记忆里我我只想知道你是否是真的爱我问你我所在乎的是否你会放在你心里我我只想知道你是否是真的爱我爱就是让你我心里面都拥有crazylove偶尔需要一些距离不让彼此受伤害爱情总是会看不清结局有时又悲哀和你一起我不后悔就让你我的过去永远不必再提起你我都在心里面有crazylove', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('697', '2000', '結束我們一起的所有!不要再相信伱喇!呵呵.!騙人的!堅決不許哭!愛伱.本來就是錯對嘛伱一直以來對我咁好我真係唸吾到伱會咁!不想聽什么解釋現在是伱不想這段感情那我們就早點結束不要打擾對方讓我們好聚好散我祝福袮們!倖福.開心我們的愛到今天為止讓祂好好的結束別畱什么囬憶和遺憾擁有過伱.我滿足勒!欽', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('698', '2000', 'angel：亲亲好啊！~跟你说哦。。我昨天一天就看了9集终极一班诶！~。。我觉得好好看诶..又搞笑又刺激哈!~....尤其是里面的小雨..哈哈...拽的另我掉牙牙诶...亚纶!~亚纶!~亚纶!~亚纶!~亚纶!~...那那..不开玩笑哦..他的电眼真是魅力十足诶...连我这个绝缘体都受不了啦!~兴奋诶!~亚纶...我爱你哈(又花痴了.....我要去亚纶吧灌水去咯..!~嘿嘿...happy!~by:小e', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('699', '2000', '**.愛伱這個決定.是否太儍.》給伱最后的疼愛---.是手放開相信祂,可惜不敢相信感情已終止為何不跟祂走等我說分手會伱親朋密友---.明知做戲.苦戀不一定是浪漫不必欺骗朲わ﹑·一切結束.一月30日゛-ㄍ是否真的愛我.', '”已經沒有任何意義&、', '', '');
INSERT INTO `dede_addonarticle` VALUES ('700', '2000', '想分手趁快为何要摘日面对现实就公开机密这么深爱你为何有今日是性格不合还是未老实是你有新对象想我死了心離场请你数我所有弱点迫我内伤痛骂我没有胆子懂礼让未见得庄敬自强为你盲目设想>还不够尽伤到尽可以话我怎么爱亦从来未懂我的心痛也是最自私一种还不算尽可以讲我大方得体其实最蠢不信看我竟亲口赞他很英俊请差点对我别令我绝望和我硬撞便不敢奢望好比你说我未令你出汗难过到心脏便自动退堂是你有新对象不要将痛苦延长请你数我所有弱点逼我内伤你若介绍你这新宠对象毒到想请我在场但我还未重伤终于够痛伤到没法修补我信', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('701', '2000', '我与他重拾友谊相约也没有不是相信她可惜不敢相信感情已终止这日难得再见面你未爱她别晚膳我若还不癫他朝还是会癫为何不跟他走跟我说分手会你亲朋蜜友就算盲都可看到他跟你极好我怎可比你好试问谁拆散你自问我可跟他不见面但是每夜有手机留言未被我撞破都不愿收线我与他纯属友谊心痒昨日已根治不爱他冬天手执冰棒一人吃一支会别离总会别离也别要全没顾忌要是还不死心心还是要死为何不跟他走等我说分手会你亲朋蜜友就算盲都可看到他跟你极好我怎可比你好是问谁拆散你自问我可跟他不见面但是每夜有手机留言未被我撞破都不愿收线还我半点清白恋爱运经已黑如当我好朋友可会为我收手为何不跟他走跟我说分手会你亲朋蜜友就算盲都可看到他跟你极好我怎可比你好试问谁拆散你自问我可跟他不见面但是每夜有手机留言未被我撞破都不愿收线见他不算做错事怎会破坏你好事不爱她怎么偏偏感到嘴唇有羞耻你若和她已别离我又为何在妒忌既是难得知己他人没法比不阻住你', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('702', '2000', '好多话，不知从何说起．．．．．．昨晚，我抱着开心的心情等他，等　等　等，１２点过了，他回来了，我安慰自己他是因为吃饭才会回来晚的，他坦白的和我说，是因为打牌才那么晚回来，我听到后真的不知道要说什么了，我不想吵架，以最简单的方式压抑着自己，我只是在想，你明知道是我生日，还．．．我不是不给你玩，我只是希望你可以在１２点前回来，难道这个要求也过分吗？这样的你，让我怎么相信你所说的：我比玩更重要～！每次吵架，我都几乎让自己做到当天就原谅你，那是因为我不希望把事情拖到明天，可是．．．你珍惜过吗？我一次又一次的原谅，换来的是什么呢？我好怀疑值不值得．．．在过生日之前，我曾进幻想过Ｎ个情景，却万万没想到居然是这样过的．．想想就好笑，居然还哭着过．．．．感情这东西好奇特，居然可以让我难过到寒心．．．．．．', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('703', '2000', '我把自己关起来只留下一个阳台每当天黑推开窗我对着夜幕发呆看着往事一幕一幕再次演出你我的爱我把电视机打开听着别人的对白也许那些故事可以给我一个交代你要的爱我学不来眼睁睁看情变坏人怔怔看情感概不能给你未来我还你现在安静结束也是另一种对待当眼泪流下来伤已超载分开也是另一种明白我给你最后的疼爱是手放开不要一张双人床中间隔着一片海感情的污点就留给时间慢慢漂白把爱收进胸前左边口袋最后的疼爱是手放开不想用言语拉扯所以选择不责怪感情就像候车月台有人走有人来我的心是一个站牌写着等待最后的疼爱是手放开我把收音机打开听着别人的失败啃咽的声音仿佛诉说着相同悲哀你的依赖还在胸怀我无法轻易推开我无法随便走开感情中专心的人容易被伤害', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('704', '2000', '我大概未算学懂保护别人才无名无份以致我们拖拉至今令你未放心全程做我一世情人仿佛还未够相衬大家忙多么漂亮理由爱不够只不过是借口凭我爱你这么久亦没信心走出教堂没理由为何未够好请听我预告(你对过谁好怎么知道)就算跟你未游尽花都可给你的都会做到并未求什么唯一志愿想你安好谁能及我好我也想知道(你有你原因怎么知道)为何未结婚我也想知道(你有你原因怎么知道)就算这相貌从未讨好总可当跟椅垫共老任地厚天高回家也都想得到拥抱除非这感情你不希罕太易得到我愿意向前行再绝望亦不相信未结婚便要分每一步都离结局更近明日若然你要我抱一抱明日若无法没遇见更好我答应最早来到', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('705', '2000', '下午就回去了.心里有一种说不出的感觉.很怪.回家之后有很多事要做.我很想念瑞.可是他却连我的短信都不回.我实在是难过.我和包包都在犹豫.在徘徊......心门好像一直打不开.难道我们都注定只为一个人坚守?为什么不能遇到一个爱我的人?真心爱我,好好疼我的人?算了,说多了,又要心痛了.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('706', '2000', 'ロǐ嫆11:29:45他那么爱你.///那天你在海上世界等他怕你等很久他就生气了还骂了我我现在都不会里他;咯我不相信他会怎么做-------------------------我也不相信.但那是事實!不得不接受!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('707', '2000', '\"慧珍：收到我的信很意外吧！~那那..看看你的旁边有没有人...我可是不希望被别人笑话...所以咯..别给别人看哦!~好啦!~其实这次写信的目的就是希望你原谅以前的我。。接受现在的我...由于中考失败后..高中要努力学习的念头很强..以至于忽视了朋友..你也应该有感觉吧..我对你不是很好吧!~其实那不是我本意啦...可以原谅我么?我想以后要好好对你..比如咯..每天早上我会等你..然后和你一起去吃早餐(以前没有吧..【你不要小看这件事哦..做一件好事容易..但做一辈子好事就难了..这是同个道理的!~】以后我还想和你一起去阅览室学习..哦..对了..我还欠你大头贴..以后一起去拍哈!~你不会不愿吧?!~哈哈..你晓得不..有个成语叫\"\"礼上往来\"\"...其实呢..信也是要往来的啦..嘿嘿..所以咯..给我回信哦!~回什么内容呢...自己有脑自己想...可以说些我的缺点和优点吧!~(不要告诉我没优点吧!~=_=|||如果你把我当好朋友的话..就说吧！～等着你..珍珍　＾＿＾(wokao!~我写完发现自己好恶心啊!~搞的我好象是追求你的人似的..表以为我想同性恋哦!~!~~by:(宇宙超级无敌可爱美少女)琼哈哈哈!~（自恋中．．别介意．．o≧﹏≦o\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('708', '2000', '我看见天空很蓝就像你在我身边的温暖生命有太多的遗憾人越成长就越孤单我很想飞多远都不累才明白爱的越深心就越痛我只想飞在我的天空飞我知道你会在我身边回忆的画面记录的语言爱始终是你手中长长的线载着我的想念飞过了地平线你温暖的笑脸还一如以前回忆的画面记录的语言你说让我学着勇敢一点偶尔哭红的双眼你一定会了解眼泪是我心中另一种完美', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('709', '2000', '安东：　　嘿嘿．．收到我的信很意外吧．．嘻嘻．．最近特喜欢写信．．所以也给你一封哈！～恩．．那那．．你还记得有个五．一你向我表白么．．呵呵．．．那个晚上我失眠了．．．其实跟你说吧．．我在你表白之前就有段时间喜欢你哦！～（好象那时侯晨潞喜欢你吧．．然后我就开始注意你了．．我说了．．其实那只是种懵懂的好感而已．．！～但后来．．你表白后．．那好象就不是种单纯的好感了．．我发现那才叫真正的喜欢吧！～后来和你在一起好象很开心哈．．我们一起拍ＱＱ照．．至今都很有味道呢．．．虽然你有时候都会字里行间的问我对你什么感觉．．．我都是否认了的．．因为那时侯我还太小（现在也是小啦！～其实我是喜欢的．．我偶尔都会翻翻我们的聊天记录．．这也是种享受．．嘿嘿．．单纯小女生哈！～不过后来你还是走了．．走了．．．久不见莲花反觉牡丹美．．久不见你．．你也就渐渐淡忘了．．直到听说你和昭如发展．．我发现我心痛了．．我还是有点在乎你．．（ps：昭如是我小学兼高中同学哦！～我记得你跟我解释说你们没有什么．．但后来我发现昭如手机里有你的号码最近更新的！～你何必骗人呢．．没有必要的啦！～再后来就是你和金梦了．．．那时真是没感觉了．．你还记得你以前问过我．．我的网名为什么叫＂１４８号候车室＂么？１４８是什么意思？你解释为＂要死吧＂．．嘿嘿．．好好笑诶．．其实你写写看＂一４八．．写出来就是你的东字．．哈哈．．我厉害吧．．（自恋中．．．现在和你聊天还是和以前一样．．你还是那么可爱．．口气还是有点色色的！～但我知道．．你是把我当好朋友的啦！～我也希望这个好朋友能一直延续下去．．嘿嘿．．看了我的信感动吧！～嘻嘻！～恩．．那．．．就到这吧．．你也可以给我写信哦．．要是太忙的话．．也要写．．就要嘛．没话说也要．．（偶大小姐耍脾气啦！～那那．．就到这吧．．谢谢你花时间听我废话哈！～by:(宇宙超级无敌可爱美少女)琼哈哈哈!~（自恋中．．别介意．．o≧﹏≦o', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('710', '2000', '没有现在能够了解我，或许那些美好只能是自己的幻想而己，我会让自己能够过的好吗？或许会或许不会，这两种无选择的答案到底是什么呢？我的心真的有很多的失望，或许这种失望以后会有希望吗？现在的我心情总是想让自己每一天能够多一点笑容，可是既使有笑容那也是一种皮肉笑而己，不管怎样我想学会淹盖自己。我不想对谁说我的心事，只想让自己一个人来承受，自己的选择自己来承受。告诉我这一切会成为现实吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('711', '2000', '今天最终还是不去吃酒了！～其实真的不想见到他们啦！～．．．什么美食佳肴．．只会让我更胖的坏东西！～不去也罢．．难得自己一人在家这么悠闲．．闲着我写了好多信．．happy！～把自己的感觉都抒发出来．．爽！～哈．．既然不去就义无返顾啦！～不就几百嘛．．不要也罢．．．．．[/color]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('712', '2000', '有人说承诺最终都是会被背叛的我始终不肯相信时间一点点从我手中溜走可我除了等待还能做些什么不是每朵花都能代表爱情可是玫瑰做到了不是每个人都能在夜里想你可是我做到了一日夜的不眠不食我不想让你知道我只想等到诺言兑现的那天哪怕我已是白发苍苍寂寞的等待等待谁的归来一次次等待的空虚与寂寞麻木的告诉自己还有明天明天的明天到底是多久等待的只是自己和昏暗路灯下那消瘦的影子青青子矜，悠悠我心。纵我不往，子宁不嗣音？青青子佩，悠悠我思。纵我不往，子宁不來？挑兮达兮，在城阙兮。一日不見，如三月兮。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('713', '2000', '[COLOR=#a9a9a9][/COLOR]天黑了,他走了,心冷了..........一次又一次的伤心,一次又一次的流泪,我到底在做什么呢?为什么?一次又一次的给他机会,而他又一次又一次的伤害我,我以为我可以坚强，我以为我可以勇敢，我以为我可以开心，我以为我可以幸福~~~~~~~~~~~~~~~~曾经天真的以为不管时间和空间的距离有多长多远感情一定会恒久不变，因为爱是没有理由的我真的累了,真的痛了,但我怎么才能去忘掉他,我该怎么做啊!~!!新的一天开始了,我能够勇敢的面对一切吗??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('714', '2000', '一开始还以为````有了他的陪伴````我会无比的开怀```可是```~!~他给我的感觉`````是若即若离的````我不敢确定```````他会真的陪伴我``````可是````世界如此大````难道找一个真心人``\'真的是如此的难嘛`````每次以为自己要负出感情时```他却告诉你`````你变心了```你不爱他了```可``事实是``他不相信你类``他觉得和你在一起好累了``也许吧```和我在一起会感觉很累```如果感觉到你累了````同时你也感觉一下我```是否也累了``为何总是自私的为自己想```不为我想``现在开始```答应我的事``就要做到``我答应你的事``我也做到```如果做不到``那就别答应```免得到最后``误解```误会```就这样```分开、了```', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('716', '2000', '每当我听到一些伤感的歌..我总会觉得,心里..有一丝淡淡的忧愁划过..为什么,为什么我会这样..我还迷惘,到现在..我都不知道自己到底为了什么.在这个世界上活着..其实,我真的很羡慕.那些已经离开的人..至少,他们不用像.我们这些活着的人那样..有着数不尽的烦恼..但,妈妈告诉我..那些已经离开的人..很羡慕我们这些活着的人..至少,我们还可以活着..在现在的我来说..或许只能说,我还太小..不懂得这个世界..或许吧..但,说真的..我真的不懂这个世界..但,现在..我只知道,我想要我自己的幸福..仅次而已..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('717', '2000', '咳....我本想在寒假好好学习的..可是咳..人的惰性哈..呵呵..可畏啊!~烦..接连不断的吃酒..大乱了我的生活!~烦', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('718', '2000', '我昨天对他发火了!~自从给他看了信后...我觉得他就变了..他还说我变了..我有变么?maybe!~我觉得我没有啦!~我只是很受不了他对我的信..居然是这反应!~讨厌!~我鼓起勇气给了他..他又给了我什么...p!~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('719', '2000', '新的新年的开始.过去的一年.让我变的比以前成熟多了..不晓得别个摸昂看我..起码我自己觉得长大茑.!昨天完茑⒈晚上好累阿..呵呵.不过瞒开心..都是些瞒长时间冒见面以前带一起完的吖..不管现在摸昂.随摸丝都会过克地..风水轮流转..呵呵.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('720', '2000', '对不起。我不是故意要欺骗你的。因为我知道我在你心中只不过是你的同学而已。我知道如果是善意的谎言你会原谅的。对不起。我不想这样的做`````我很喜欢你的。你一点不都不知道。你的性格和你的人一样即使吃做错了也不会跟别人说声对不起的。从我跟你开始聊天我才知道你也有无赖和痛苦。看见你喜欢的人却不能向她表白。我又和曾不是啊````是因为我太年轻了。还是我产生的幻觉。否则我怎么会喜欢上你。有许多的女生也喜欢你啊。还有我们班的同学喜欢你啊。你很好。是个好男孩子。对人也很好啊！你很固执也很爱开玩笑的。你也会有哭泣的时候，只是没有人看见你而已啊。你是一个需要别人照顾的小孩子。。。``很喜欢你啊。曾经有好几次来看你。可是你不在。我的心落空了。有好几次在网上又碰到了你啊。你还是和以前没有什么所改变的。只是成熟了。让我觉得你很可爱``而且还很为为别人找想呢》我好想看到你啊。对不起。总之我会忘记你的。。。会漫漫忘记的。放手实在很难。更何况是爱情。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('721', '2000', '有得必有失,有舍必有得.我得到了你,我失去了一些人;我得到了前所未有的快乐,我失去了以前的快乐;我舍掉了一些时间,我得到了和你在一起的时间;我舍掉了我不想舍的东西,我得到了我意料之中却也意料之外的东西.原来这世界还算公平吧.当然我从来不会后悔,这是冥冥之中上帝告诉我要我这样做的吧.[SOUND]http://218.95.41.91/musicdata/hong/01/338863051/981810439.mp3', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('722', '2000', '你永远看不到我的孤单,因为在你不在我身边的时候,我才会孤单.要分班了,我又即将面临更大的孤单,可是这并不代表以前没有.我们在一个班,我也会孤独.这真的好奇怪啊,明明是两个人了,应该比一个人的时候不觉得孤单啊,可即使你就在我眼前,我也会孤单.记得我那时侯总会羡慕张小瑜和刘树强.一下课他就会到她那边,活动课也是一样.而那时侯我就会站在窗口,看你和墨离开.不知有多少次现在我们之间要比他们过的更好,可那时侯的日子,他们的幸福依旧在我脑海挥之不去.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('723', '2000', '\"记得刚喜欢你,是你的手.那时候张璐告诉我,喜欢一个人是从微小到全部的.或许你喜欢他(她)的笑容,他(她)的眼睛,他(她)发脾气的样子,他(她)的穿着,或者像我一样喜欢你的手,有或者像你一样喜欢我的声音.可随着时间的流逝,就会喜欢上他(她)的全部,甚至一些小毛病.我想她是对的.记得有依次冲你发脾气,可怜的你还不知道原因,我告诉你是因为细节.你说不懂.细节,有关你的细节.你喜欢皱眉头。跟你说了你会改,可不过五分钟你就忘了;打电话的时候,你会叫我的名字,很正式的那种,当然这样的机会很少,其他时候,你会等我接了电话就说，你在干什么?每次都那样的自信我会认出你的声音.你给我起的绰号是\"\"宝宝\"\",一个充满溺爱的名字.我很喜欢的,可你却很少这样叫我,有时还会叫我猪,算了，不介意你这个小孩.你说话的时候,有时候会摆手.就是手腕带着指尖从上往下摆动.你不修边幅,不拘小节.你喜欢看动画片,看漫画,所有高雅些的东西都和你沾不上边.你不喜欢看书.你酷爱唱歌.你不喜欢猜谜.你很善良.当然只是有时候.你不喜欢逛街.你怕冷.你懒惰.你爱讽刺别人,并把它作为一种乐趣.好多好多,都想不起来了.你笑的时候，眼角有皱纹.关于我的细节,你又记得多少呢?[SOUND]http://file.qyule.com/upload/2005-11-21/fmg8elzfrsC1nkZa.mp3\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('724', '2000', '如果你要离开我不会说什么，但是请你记住有一个人仍在老地方等你。请你不要忘记。如果你要跟我说分手我不会硬要你在我身边。因为勉强得来的不是幸福而是灾难。不是吗？我曾经对你说过我会追你的。我追你。可是没用啊。因为你根本就不在乎，所以情愿在这段感情还没发生之前，先把它忘记。在你的心理真的没有我吗？被伤透的心是否能够继续在爱你。你是否心理已经住了一个人呢》？爱情是否是你想要的？你的心理也许也曾经受过伤害呢？我们能不能在做朋友呢？能吗》算了无论我怎么样啊？你都不会喜欢我的', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('725', '2000', '今日3月九號我同距拖左la...裃裃..經過幾日中午噶曖昧我已經受不來拉...所以我決定拖...今日中午距想錫我條頸我用塊麵頂開距但係如果有小小偏差就會錫到距噶嘴噶la好鬼險吖...今日差dd就到嘴好睬我收到快不過我廳日真係好想錫距因為我地已經一起la...我要距噶第一次..裃裃...好掛主距陣味a...missing...今日同距攬到實今日我都有壓距喺牀度...裃裃...好舒服廳日攬住距貓豬...好倖福ing...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('726', '2000', '今天好奇怪.玩了晚.回到家.一睡就6点本来打算去学校找你.但是没时间...555555很奇怪.今天有种感觉...很心酸有点feel到你想离开我.那种感觉好难受....好难受.这种感觉一直在我脑子..让我乱想.让我发狂......今晚我还是不回家了.这几天好倒霉....事情超多..5555555555555555555希望没事//.....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('727', '2000', '暈暈.!.別亂想喇.!!怎么可能會離開袮呢.!不可能的事情就不要想那么多呀!蕞開心的事就是看到袮開心能在袮身邊勒.!!!如果沒有勒袮.就等于沒有勒色綵.因為有伱.不要想多喇.我們不會分開的要在一起很久很久很久一世.一輩子的承諾吖!從開始到現在.一直都有伱的存在.!!!佷愛伱.佷擔心伱開心點呀.我不想伱每天都那樣失落一樣!!!,這兩天我攷試.所以/.可能有點忽視勒伱.對不起喇.親愛的.!!.怎樣都是有伱.一直在我心裏麵.不變的是我們的心.!!不要在亂想些什么喇.!!.是不會分開的.!!更不會放棄這段難得的感情赤腳印記....想起勒伱.mydearing.!!!!!想伱每天過得開心點.....非妳不嫁.一直存在着!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('728', '2000', '阿尔法·罗密欧、菲亚特、福特、梅塞德斯·奔驰、标致、雷诺、劳斯莱斯645Ci敞篷.6系128万德国《蓝色的》品　　牌：宝马汽车车　　系：3系型　　号：318ci敞篷其他称号：汽车类别：跑车生产厂商：德国宝马集团公司生产地：德国排量范围：1-2.5L颜　　色：参考价格：《银白色的》品　　牌：宝马汽车车　　系：7系型　　号：730Li其他称号：汽车类别：轿车生产厂商：宝马汽车生产地：德国排量范围：2.5-4L颜　　色：参考价格：79《黑色的》', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('729', '2000', '今天.我跟我媽吵架勒!吵的佷大佷大.埋藏在我心裏的話我終于說勒岀來!伱駡我什么都好就是不準伱駡我的朋友!伱駡的是我的好姐妹!我要跟祂一起長大!在我的生活中.我的朋友不到伱管!伱說伱打電話過去祂傢.叫祂媽不給伱跟我一起但是.伱覺得伱有可能嗎!伱有這個本事嗎.?!!.呵呵.我真的佷恨伱!伱讓我拫討厭伱!!!!伱不要那么絕.伱不當我是妳女兒就算!伱不要叫我爸爸來打我.不要說我爸爸寵壞我!!.我爸爸不像伱這樣!!,無禮.妳不幫我洗衣服.傢裏不是沒有洗衣機!tmd<..!我蕞討厭伱拿我跟別人比伱難道這么多年來伱都不知道嗎我爸爸說的.進步勒就行!伱就不能滿足一下嗎.c我在伱眼裏.即使再好.也不過一根草不如!我可以跟伱說.祂媽真的不再讓祂跟我在一起玩我寧願一個人傢鄉生活!.我的朋友也讓伱管着.伱以為我不知道嘛.別人到伱有這個權利去管嗎.如果我跟祂.不能象我們從小就立下的決定買房.買車.開店......一起讀書.一起工作!!這輩子我會后悔.我失去過很多朋友.那些失去我值得.因為祂們不愛我我知道臘腸拫愛我..我不想沒有一個真切的朋友不在我身邊但我知道.無論如何.伱都是我的好姊妹!,,祂..不算什么.不要讓我越來越討厭伱.我真的決定勒.如果.不能和臘腸一直到最后我寧願孤單.!!.,欽.我真的拫愛伱.!!對不起喇.最近.心情狀態不是很好忽視喇伱.我希望伱不要想那么多開心點過每一天.要過得充實.很想伱很想妳今晚走勒一晚上.囬到傢裏佷纍佷纍啊一路上想着今晚的事拫惆悵呀..祂這樣.我真的拫不開心.!!超級魔王飛天豬..!!好想伱好想伱.好想每天有妳在噢!!2004.11.23日.mybestsister.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('730', '2000', '[COLOR=#7fff00][/COLOR]这次寒假回来我发现我喜欢上了锋,可因为他在学校有女朋友,我只好把自己的感情压抑在心,可有一天我听说他并不幸福,跟她女朋友已经到了分手的边缘.还问我他该怎么办,觉得很累,他想分手了,我那时再三的劝他,要考虑清楚,手上的幸福要好好抓住,听到这消息我其实应该高兴的,可我还是希望他能幸福,不要轻易的做决定,他的决定将会影响着我在心中压抑的感情,他要是没了女朋友,我对他的那份情会立刻上升,可是第2天他们真的分手了,我又有点庆幸.可今天,锋又跟我说她女朋友后悔了想和好,问我该怎么办,他跟别人什么都没说,就想征求我的意见,我当时很心酸,说实话我真的不想让他们和好,否则我的感情将归于何处,我就说要是我我是不喜欢分手后再和好的,他说他知道该怎么做了,可我又后悔的很,我不知道这句话他会怎么做,和好,分手,我都会不高兴.后悔加心酸.为什么,每次我面对感情都是这样,不喜欢被感情牵制情绪的我.曾经自己说过要是再喜欢上人,我要主动出击,可真正到了那时候,我又退缩了.或许这又是一次没有结局的感情.为自己感到悲哀,不知道我的天使在那里', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('731', '2000', '亲爱的.开心点拉.没有解决不了的事.和家里人吵是很正常的,你老公经常拉.不要不开心..我会很想你的.忽视我没关系..心里有我就可以拉.你条佬我很明白的.原来是你和腊肠的事..对嘛!这几天我是没心情,也很不开心.不过!我一不开心就想想你.就没事拉`哈哈.你想怎么做就怎么做.我一定支持你....给你信心.呵呵..........我很爱你拉!快点给我开心起来1!!哈哈', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('732', '2000', '终于盼到了星期六，可以好好的休息了，最近几天一直加班，感觉很累。天天早晨睡到八点半才起，但仍感觉很困，一天就这么昏昏沉沉的过去了。感觉好累，杨子这几天没有电话给我，春节的时候因为我说他的小灵通不能发信息，第二天他就去买了一个手机回来给我发信息，但是因为我们的工作都很忙，我没时间给他回，他只在QQ上给我留言说我让他买了手机，又不回他的信息。抱怨归抱怨，我知道他不会放在心上。因为他是那种心比较宽的人。思绪又回到了从前……中专的时候我们关系很好，他追女孩追不上，我就帮他说情，因为那女孩是我们宿舍的，我简直就成了一个侦探。但最后结果还是没成，让我伤心半天。哈哈……但是那时候我对他还是蛮好的，现在事情都过去了我想不出那时候自己的心境，到底是什么想法，也想不出那时候他在我心里是一个什么位置，只知道自己那时候为他付出了很多。有一段时间他姐莫名其妙的腿就不会走路了，来北京诊断，所有的医院都是我陪着去的。他妈妈过来也是我照顾的。因为从我们毕业一直到现在他一直没找过女朋友，只相过一次亲，还没敢抬头看人家。呵呵，感觉好可笑。直到现在他姐一直和我保持着联系，他的妈妈也常在他面前提起我，念叨我。或许他们不知道我有男朋友吧。他妈竟然还让他带我回家，呵呵，太不现实了呀，我算什么。思绪断了，也不想接着写了。只希望他们都过的很好。他的姐姐一直夸我是个不错的女孩，所以一直想找机会撮合我们俩，只有我自己知道不可能的。但愿我们永远都是好朋友。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('733', '2000', '“一个人的天空很蓝蓝得有点忧郁一个人的时候很自由自由得有点孤单一个人的日子很轻松轻松的有点无聊想念朋友的时候很幸福幸福得有点难过”无意中看到这段话，说不出心中什么感觉，只是觉得这句话很精典，的确，过度的自由，过度的轻松都不是一件好事，或许每个人的人生都应该适当的有些压力，才能有奋斗的动力。昨天晚上去电脑室帮他们入票，老公让我改单子，因为我没改过所以什么都不知道，结果他说了一句“哎呀，算了，我自己来吧。”我很是恼火。把我气的回宿舍哭了一通。最后还得下去帮忙，气死我也。算了，不生气了，因为这点事斗气也不值得。看在他对我还算不错的份上就原谅他了。快乐每一天', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('734', '2000', '刚刚想过那些事情去看同学录里的留言。看到杨子的留言，我又想起他春节晚上给我打的那通电话，整整聊了四十分钟他仍不让挂电话，晚上七点多，我问他在哪里，他告诉我他在外面，等到后来实在瞒不过去了，告诉我他一人人躺在床上睡觉，我问他晚上吃的什么，他告诉我是面条。我开玩笑说：“你以后是不是就靠面条过日子呀，大年初一你也吃面条，受不了。”他没说什么。后来聊着聊着，我却感到了他含在眼里的泪，我问他原本定好回家的为什么不回了，他说是因为家里的事。家里的大哥都闹事，闹的一家人心情都不好。他爸回来之后又走了，只里只剩下他妈了，他不想回去面对那种场面，所以就没回去。他宁可一个人在外面孤单，也不想回去面对那种家庭，我知道他是无奈的，他也是没有办法。后来谈到了我们的事，他说其实他一直都没想过放弃我，只不过小杨子也喜欢我，而小杨子一直在在他店里帮他。他没办法说，他这人就是这人，哪怕自己忍受也不会让别人说一个不是。但是这是感情的事情，却不是别的事情呀。我如果答应小杨子会在六年前而不是现在。我如果答应你当时也不会放弃，也不会等到现在。可是你根本就不懂。你知道吗？杨子，我从来没否认你是一个坏男孩，但是我只是想告诉你，我不会放弃我自己的爱，你知道吗？不管他对我怎么样，我不会放弃，况且，我们已经分开这么长时间了，该变的都变了。或许我们根本就不合适。尽管我知道你心里压抑，我也知道你心中的苦不想对任何人说，但是你对我说了。包括家里这些琐事，你没法对别人说，但是对我说了。你姐给我聊天的时候说过一些，家里的大哥找事，没办法。其实除了这些还有很多你不知道的事情，家里都没有告诉你。姐还告诉我很多，但是我不能告诉你。杨毛，我能理解你的处境，但是我不能奉献自己的爱情，明白吗？我会祝福你，尽所能的帮你，但是我不能给你我的爱。因为我是属于我老公的。[/COLOR]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('735', '2000', '我會沒事的.!!.想到伱我就會想到伱跟我說的東西!!所以.我會好好地過.不讓伱擔心伱也一樣啊.別老是想那么多!開心些..不僅是跟臘腸的還有伱啊.我看伱天天都不開心那樣我說過勒.因伱僖.因伱悲!!妳是我的唯一.!!是的寶貝.我蕞親愛的伱!!!今天.上課好纍噢!!.無聊死喇但是.我的英語似乎攷的非常之砸好失望噢..好想伱吖...真的很想每天都有妳在身邊愛死伱喇...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('736', '2000', '親愛的.好想伱呀!.好掛住伱哇!譆譆...愛死伱喇!真的想時間快點過呀!快點到我們手拖手說願意那天!!帶上我們終生的戒指那個倖福的傢需要我們一起努力的!!我想伱乖點呀..伱今天說伱通勒那么多晚生活有點節奏呀!我不準伱打架!泡妞.全心全意.一心一意.還記着嗎不管現在伱怎么樣都希望我們以后是倖福的!!!我們在一起要很久很久很久很久!在一起快三個月喇!三年.三十年.三百年.譆譆!我最愛妳.!!!..好不容易過勒星期六.但是明天早上又要補習喇艾..!一個字.苦呀!!這次英語攷砸喇.超級不爽.!!超級無敵失望.!!!!非妳不嫁的.欽.!!!!不會變.!!!世界再怎么變.唯獨我們的感情不可以!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('737', '2000', '好害怕失去伱.好害怕失去伱.好害怕失去伱.好害怕失去伱.好害怕失去伱.好害怕失去伱.伱今晚上勒一下.不用很久就匆匆地下勒.伱說有事.到現在.快一點勒.還沒有上!我擔心伱哇.伱還好碼.!!伱剛剛上勒.但刷地一下又下勒.我還沒來的及.看清楚.伱就下勒!,呵呵!伱到底怎么喇.,.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('738', '2000', '故事的终点就在前方不远处荒废的花园覆盖了这座狭小的星球植物丛生夏日香气弥漫蹲下来翻开叶片的背面开始读到一个神秘的预兆', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('739', '2000', '00:44:17亲爱的``oヤ銩藄00:45:42？？什么啊　00:46:18我叫你啊..你不理我啦oヤ銩藄00:46:10没有啊……你是哪个的　00:47:02算滴..!oヤ銩藄00:47:48怎么啊你是黄~吗？　00:48:23废话.不然谁还上我的QQoヤ銩藄00:48:57那我就不知道了啊……你怎么这么晚还到啊　01:07:47总是提别个。.难道我们之间没话题了吗oヤ銩藄01:09:28哎呀……人家关心哥哥不可以啊呵呵怎么啊　01:10:14算了.你去关心他吧oヤ銩藄01:11:11呵呵冒吧……怎么拉感觉你好象变了样郁闷？不开心？　01:12:15是你自己oヤ銩藄01:12:07我自己？我怎么了啊　01:13:24不说了..!不明白算了oヤ銩藄01:13:53喂……我拜托你们现在不要都说话说一半咯有什么就说明白点咯猜起好累好不拉　01:14:34什么说话说一半??黄景方01:14:36说了什么oヤ銩藄01:14:54就是讲话讲起莫名其妙的啊有头冒尾　01:16:33既然你什么都不晓得就算老咯oヤ銩藄01:18:06喂……到底什么啊你们不要都把我耍着玩样好不拉　01:19:03我们是什么意思?oヤ銩藄01:19:06你张超00说话都莫名其妙　01:19:58张超跟你讲过什么!oヤ銩藄01:22:09就是说我不知道他讲什么啊知道还用问啊　01:22:34快讲啊/他跟你讲了什么oヤ銩藄01:27:57怎么了啊……　01:40:07我看他泄露了我什么秘密没oヤ銩藄01:40:13呵呵你有什么秘密好泄露的啊？？！！　02:04:46.............哎!!黄景方02:04:52你不要装蠢好不好啊oヤ銩藄02:07:30你不要骂我蠢好不拉……你们好象都认为我应该晓得但是……好象那是你们的想法你们各个都说的什么鬼请问下我应该要怎么认为呢　02:08:33你认为我是怎么认为的呢oヤ銩藄02:09:45我怎么晓得拉一直以来好象是你什么都不会说出来然后又觉得别个应该可以知道你想什么哪个这么天才拉　02:10:45既然你把话都说这份上来了..!oヤ銩藄02:10:33怎么啊难道不是啊　02:12:10你还想要我怎么样啦!oヤ銩藄02:13:57什么怎么样拉……　02:14:37算了不说了..好烦..不明白算oヤ銩藄02:17:55不说算了……反正你们总这样　02:26:21什么我们?oヤ銩藄02:26:16算了……没什么', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('740', '2000', '烦＾　我不知道他们到底想干什么，为什么要当我一切都平静下来的时候，又来挑起一丝波纹！但是又凭什么各个都打哑谜样，什么都不说清楚，总认为我知道，我应该知道什么吗？又会知道什么吗？神经＾为什么我就一定要知道拉，谁知道他们到底想搞什么，又到做什么！００说ｈ想跟我和好；张说希望我打电话给他们；ｈ呢？又让我去找他！我为什么要啊＾他们从没问过我的想法，从没站在我的立场想过，也没有人问过我想怎么＾这次我不会去找他，也不会主动打电话给他！不管他怎么想的，想怎么样，他没主动说明一切，没有找我，我，是怎么也不会迈出第一步的！这么久都过来了，我还有什么好胆怯的，只是没那个必要，是他先逼我放弃这段感情的，难道就他说回去就回的去吗？那我受的一切一切的伤害怎么办，就这样算了吗？他什么都没对我交代过！那些伤害就不曾有吗？他总觉得是我不了解他，但是，他有给我机会去了解他吗？或许一直以来我都被他拒绝在门外吧，我不得不怀疑起当时那些美好到底是不是真的了＾不要怪我，我也不想这样认为，因为那是我最美的回忆，但是，总总的总总却让我对自己质疑了，我一点信心都没有了＾是他，让我没有的！所以，或许也只有他自己，才可以让我重新拾回吧，其他人说什么都不重要！[全屏欣赏]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('741', '2000', '等待认识你.只为了等待.以前在学校楼上等待你经过,在操场上等待你打球的身影,毕业后等待你爱我,一次次的暗示,得到的是你的敷衍.等到你说爱我的时候,我以为我可以停止等待了.可是我又开始等待你的音讯,等待你的回信,等待你的电话,等待你上网时闪烁的头像.可是一次次我都伤心失望.当我很不容易等到了之后,又那么快的过去,然后我又开始等.就一直等.我曾问自己到底在等什么.每次走在街上寻觅着,期待像某天意外的遇见你.可是我知道这不可能的.而我只可以呆在街上.茫然地看着来来往往的人.现在我终于知道了..我在等你的心来到我身边.我知道现在的你对我只是喜欢.也许连一点爱情的味道都没有.只是妹妹般的喜欢..我知道是这样的.我想改变.可是我知道这是不可能的.可是如果你说出来.我真的可以放手,我可以不喜欢,可以不在等你.这样我可能才会快乐点.等待一个人真的很累.不是身体累,而是心累.明天我就回学校了.我能收到你的信嘛.我等待.我怕你寄了信而我没收到.我更怕你没寄而我就一直傻傻的等.说我在等待一封信.不如说我在等待一颗心.一颗爱我的心.或者是一个答案.你不爱我的事实.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('742', '2000', '今天是植树节..郁闷..身为学校的学生会成员要当植树工..呵..听了每个领导说完客气话之后.就风风火火地植树.可是天公不作美.下起雨来了.把我们的热情都给浇灭了.哎..最后只好草草了事..然后变成落汤鸡照了几张无聊相.就闪人了.哎..真无聊啊..今天就这样拉.也没什么特别的事情.当了一回环保志愿者.如果种起一棵树可以挽回一点清新的空气.我相信我今天的惨境会得到回报的.毕竟环境是我们生存的基本吧..哈哈..明天又要回学校了.继续在高中里奋斗了..真郁闷...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('743', '2000', '今天這個怪天氣.真的快嚇死我喇!.冷冰冰的!.凍凍的.我牽着超人狂走狂走!材髮現經過我身邊的人恨少!.今天的街上也是人煙稀少.奇怪死喇!而且.今天真的恨怪的天氣.也是恨怪的心情!呵呵..今天想起勒點東西.心情就墮落勒下來.!!.真的不想再想起祂喇.反正我跟祂不再是朋友.也不可能會再成為朋友.這么久喇.!!.過去勒的都過去喇.!小新說的.夢幻西遊.遊戲的開始.到遊戲結束.印證着我跟祂一樣.!!!!今天一天伱都沒有上.我好怕伱會有事!!不要再讓我擔心伱啦要知道我的存在啊.!不要忘勒我是誰!今天///.伱討厭的天氣我好怕妳會不開心呀!!親愛.我想伱啦.!!!!.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('744', '2000', '\"2月14日,每对情人都记得的日子,这天有多少女孩会收到火红的玫瑰,是爱的玫瑰.这天,我没有收到玫瑰,也没有浓浓的巧克力.这天我心情不是太好,没有什么让我开心的,记得我们在一起的那天就是2月14日情人节,一年了,感情深了,是不是也就可以没有那些爱情的修饰了呢?一首\"\"你是我的玫瑰\"\"是不是就是爱的语言呢?是不是我应该用另一种方式去理解这种爱呢?\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('745', '2000', '她已走了有两天,可我觉得有两年.今天天气特别冷,不知她会怎样,我只能深深地祝愿,在没有我的日子你要保重你自已.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('746', '2000', '不久的刚才，我又转过身，头也不回的走掉。是我的心冷了，还是他！每次争吵后，我会哭很久很久，是为了证明自己爱他证明我的难过，就是这么无可救要。明明不想用眼泪代替难过，却有透明的液体不听话的流下。我知道我们都好讨厌这样。只是我也知道我没有办法让自己去接受如果这句话从他的嘴里说出来！他很包容我，在这次事情发生以后我越发感觉，为什么我会调头就走掉，为什么没有站在他那里想，如果当时是他那样做，我要怎么办？生气，然后一个人傻傻的站在那里哭，等他回来。他却没有那样做，他一直远远的跟在我的后面，不出声，没有叫住我，只是看着我。、坐在冰冷的球场上。哭着对天上的月亮说：我好想他，我不想我们吵架。他明天还有球赛，我不该打乱他的心情，他不会输的。求求你帮帮我们。帮我们去彼此的心底，不再有争闹。我想他已经越来越受不了了吧~他不再抱着我，要我不哭！他狠狠的推开我，不顾会不会弄疼我的手，他只是想我回去。太多的事都不在我们掌握中。一秒钟的时间。什么都变了。不是吗？求求。不要让我们在争吵，我怕。真的怕。怕他，怕我。怕会冷却~！[SHADOW=255,blue,1', '文字', '', '');
INSERT INTO `dede_addonarticle` VALUES ('747', '2000', '傻瓜.我没事的.我怎么可能让自己有事我还要娶你呢!这几天.天气好差.烂死拉.不过我有想你呀/...老婆,开心点拉.不要不开心我的世界应你而喜,应你而悲呀.知道吗对了.为什么你总是说他....他是谁呀为什么我觉得你一提到他就有点........算了,,我不说了..我下了,这几天不能想平时一样.不过,我的心一直都在想你.亲爱的.呵呵.对不起!要你担心拉.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('748', '2000', '好开心啊．．．爸爸对我真好　手机挨不见了他没有责怪我　妈也是这样知道我心情糟糕　什么事都尽量满足我　　好幸福哦！！今天老爸还给了我钱从新买了个新手机太高兴了　　我爸妈对我真好　我本来以为我不读书了以后他们会不在意我了　我想我错了　哥现在在中山我爸妈他们都好想他我知道　挨．．希望哥你快点回来　现在不离开大化也是因为这个　要是我也出去了那家里就太凄凉了有在多的钱也没用的　挨　　本来这一切都不是这样的　好讨厌现在的６合彩啊　要是没有这东西我家就不至于到现在这个地步了哥就不会离开大化到外地去给人家打工　我也可以安安静静在梧州继续我的学业真是有点气愤　我这一生最讨厌的就是赌博　和小偷了真的一点也看不起这种人了　　我现在要好好工作．．．不要让我家人失望！！加油', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('749', '2000', '這兩天佷凍哇.!伱有無着多點衫呀穿多點.唔好凍親.要我擔心呀.!伱話過.唔會卑自己有事嘎!但伱要做到啊.!!我怕伱又凍親喇.!!.看伱好辛苦.我就佷難受喇!!!.沒有喇.再提誰都好.但我都隻是隻有伱一個希望妳也是隻有我一個!!!不可以變.一定不可以變的.!!好想伱好想伱.!!!..愛愛愛瓜伱喇.!!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('750', '2000', 'ｘｉａｏ：爱她，是为了她幸福；而她的快乐却不是因为我爱她；因为，我所喜欢的人说她有男朋友（差不多）我不知该怎么办？我只有———暗恋着她。暗恋是自己的脆弱，还是为你爱的人？暗恋，痛了自己，快乐了别人？暗恋，是一种美丽吗？　　ｓｐｉｃｅ：暗恋是一种美，一种凄惨而又壮烈的美。明知不可为而为之，是需要莫大的勇气的；而明知不会有结果却仍然继续着，又是要付出多大的代价。说得严重点，有点荆轲刺秦王的味道。不过也许老天爷会同情你这份痴情。段誉和王语嫣最后还不是在一起了？　　ｘｉａｏｎｉａｎ：暗恋着，有时却是独有的美好。如果，我勇敢一点表白，却激怒了她，她离得远远的，连暗恋的机会都没啦。　　ｖｉｖｉａｎ－ａｐｐｌｅ：爱是一种美丽，暗恋却决不是其中的一份。寂寞地在远处看着自己喜爱的人，默默地沉浮于他／她的喜怒哀乐，永远只是眼神追随着他／她的身影。这是美丽吗？这是悲哀！这是懦弱！或许有些言重，可是爱一个人难道不该光明磊落吗？真的喜欢难道不该去争取吗？不管结果如何，不管成败与否，爱是需要实践的。爱是需要经过的。否则埋在心底的快乐，忧伤都只不过如大街上擦肩而过的行人，走过了，就走过了，什么也没留下。最美丽的是从暗恋中鼓起勇气，向他／她表白所有的感情。那一瞬，爱变得单纯、直接和害羞，那是一种具体的美丽，可以触摸得到的美丽。告诉他／她，你爱他！大声地！响亮地！说给他／她听，也说给你自己听。　　ｂｉｌｌｙ：要么轰轰烈烈地爱，要么无怨无悔的分。暗恋是慢性自杀，暗恋是种煎熬。长痛不如短痛！　　ｆｅｎｇｌｉｎ：如果真的爱一个人，只要看着她快乐就是最大的满足了，你还能奢求什么呢？真心喜欢的人，并不一定要结婚，而和你结婚的人并不是你真心喜欢的，因为这个社会有太多的无奈。把一份太纯太纯的感情藏在心里，藏在心里的最深处。在心中留一份属于自己的空间。　　ｚｈｕｈｏｎｇ：爱／不爱、表白／不表白、拥有／失去……人生之中面临太多的选择，无论你是否愿意，总是要作出抉择；只有勇于面对失去，才能迎来更美好的未来；该来的终要来，该去的无法挽留，抬起头，做你该做的。　　ｓｐｉｃｅ：我的意思并不是不要你去表白。如果你爱他，就应该让他知道。也许她也对你有好感，只是无法启齿也说不定。如果你怕吓跑她，那用一种婉转或暗示的方法试试。女人是敏感的动物，她应该会懂得。如果他对你的暗示并没有拒绝。那再采取下一步吧。我爱你三个字虽然简单，却不是那么容易说出口的。不过现在也不是爱你在心口难开的年代了，好好把握自己吧！　　泽基：ｘｉａｏｎｉａｎ，我爱她，所以我告诉了她！结果……我不知道，但至少现在……她和我在一起！所以去吧！我祝福你！　　ｆａｋｅ：不知道这个女生的现任男友来到这里逛逛会作何感想。看到几乎万众一心蛊惑怂恿ｘｉａｏｎｉａｎ横刀夺爱以及将终成眷属的种种暗示，他会不会就此识时务地忍痛割爱了？那可真是兵不血刃了。　　泽基：哇～～ｆａｋｅ让心爱的人得到一份更好更坚强的爱有错吗？为什么要用贬义词！你看看自己都用的是什么形容词啊！又是“蛊惑怂恿”又是“横刀夺爱”！太夸张了！　　ｘｉａｏｎｉａｎ：其实，我总是在想，如果我表白了，会使她陷入烦恼，那看到她的忧伤却是我不愿看到的。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('751', '2000', '今天白色情人節噢..我還忘喇.!!!!.上年今天.呵呵!!,難忘!不過都是過去式喇.現在.以后..都是隻有老公伱一個!!譆譆.要一輩子跟伱一起呀!!!不要分開喇.!.不想再分喇.佷難受!哈哈.!今天挺開心的.!!手機拿勒囬來..班主任那么好死噢!譆譆..不過都是自己努力得來得.也是一種甜呀.!!.是佷暸不起得喇!好久沒有這個成績喇!.真的佷厲害.但那隻死豬.硬不承認我厲害哈哈.!!好開心好開心.!!!今天莊儀.竟然又在海南島囬來勒噢我第一眼見到祂.好興奮噢.哈哈!!!.雖然隻是同學.但是.真的佷開心喇..希望我老公.每天都能開心點喇我想見到伱笑.喜歡伱笑!哈哈.!!..伱在硪懐里入睡.習慣有妳//.我愛妳.!!!!!!擁抱着伱..擁有着妳!!一輩子.!!!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('752', '2000', '这几天的心情还不错不知道为什么难得的好心情不知道可以维持好久？但愿永远都这么开心~~！和他之间应该算得上是朋友吧~！我以为他变了点没想到还是和以前一样无聊还是一老欺负我我想她肯定不希望他再和我说话吧并不是因为她喜欢他而是因为她不喜欢我她讨厌我？所以她~！哎~！我真的不知道她是怎么想的？尽管她很讨厌我她也不能管别人的事吧她不觉得她管得太多了吗？真是狗拿耗子多管闲事~！本来我不讨厌她的可是她一老针对我我真的受不了她了。。。现在每天总算是开开心心的`！他现在虽然还是有点喜欢他可是我真的不想再去喜欢他了喜欢他真的好累好累`~！喜欢上他我后悔了~！可是我可以忘掉吗？真的不知道他是个什么样的人？哎~~！不要去想他了~！一想到他就头疼~！好烦~！只希望自己可以开心每一天~！希望身边每一个关心自己的人都能够幸福快乐~~！希望自己就这样幸福快乐的走下去~！但愿如此吧~！呵呵~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('753', '2000', '每个人都以为生活这个社会里其实大家都只是生活在自己的世界里我们透过自己心中的世界来审视这个社会事实桑看到的只是被心滤过的东西现在只是自欺欺人却不自知罢了或许别人觉得我生孩子自己的世界里其实我只是对自己真诚不知道风什么时候吹走了沙不知道雨什么时候开始滴滴答答的落下当你走在街头彷徨的时候曾经的那份笑脸还会在现么活出个自我的一片天可是很多情分已经断线当寻归路之时才看到那岁月洗刷掉了曾经的每一天时间可以改变一切对事物当时的看法就如看电视剧第三遍的时候已经没有了当时的感觉无可取代的东西依旧还在身边其实有时候做自己就好不用去跟那些没有必要的人计较太多有时候的自己真的太感性了用感性来代替理性才可以理智与感情是人生最难做的一道题用感情覆盖理智是幼稚完全的理智是空谈成熟的标志是吧两者分开可以用感性去看问题但必须要用理性去解决问题看来我必须要继续努力学习了O(∩_∩)O~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('754', '2000', '9:572010-4-24也许真的需要好好调剂调剂了！如果在这样继续下去，我会变的越来越不堪一击的！要加油哦！如九九说的一样！在外面混的谁不累啊！你不要太可怜自己了！累又怎么了！不要太把自己太当回事！该去做的就去做！是啊也许我太把自己当回事了！（我只是偶尔想小女人下，有人关心有人疼有人爱，我一个人真的很累很累的！还要去回忆以前的美好不美好的一切，还要面对以后的一切可怕的未知变故）如同喝水冷暖自知！却要摆出坚强的面孔去生活!高兴我很看不起这样的你自己哦！你必须回到以前，必须加油！一切都在脚下！以前的那些张狂哪去了？一定可以好起来的，不要太把自己当回事！恩加油哦！一切都会好起来的！一定可以嘿嘿！放心你还很年轻，这一切的打击算什么，你早就该习惯不是么！好好做事，好好努力，好好的！继续选择张狂的生活！高兴就是高兴，可以大哭可以大笑可以悲伤，但是那都是偶尔。必须要保持良好的心态！呼呼深呼吸，给自己加油。回到自己的世界。我做主……相信一切都在脚下时间距离都是可以克服的！继续去为实现梦想而努力。继续学习抓住，不轻易说放弃！我会好起来的！&nbsp;', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('755', '2000', '[顶]后来，我只是爱上了一个和你很像的人。分享转载复制地址日志地址:&nbsp;请用Ctrl+C复制后贴给好友。转播到微博..赞赞取消赞高莉-122010年04月18日12:42阅读(42)评论(1)分类：个人日记举报字体：大▼小中大开始了喜欢这些美好的故事！只是因为我喜欢！&nbsp;我们这一生，总要走过许多地方的路，行过许多地方的桥，看过许多次数的云，喝过许多种类的酒，却只爱过一个正当最好年龄的人。很多人相爱多年，最后也不过如此而已。世事总多变故。某时某地恍惚想起你来，也只能如人饮水，冷暖自知。偷天陷阱里说iwaspreparedforeverything,exceptyou.故人好，可是故人在哪里？&nbsp;失去过的人会更珍惜一点。后来，我只是爱上了一个和你很像的人。（原文作者：http://www.douban.com/people/missdong/）1.七年后我们都各自过得很好。对于生活自觉的妥协，对于爱人自觉的守垒，对于往事自觉地筛选。只是再见面的时候，你的样子变了。你的脸上没有了那颗长在唇侧的痣，走路的姿势不再稍稍的外八，喜欢穿的颜色也不再是墨绿色，和人交谈的时候鼻子不会缩缩的出声，手掌隔着桌子的厚度已经没有了温度，可以再来握我的手，委屈的衣袋皱皱巴巴的被你攥紧，和哭了一样的。我知道你是用了力气的，克制还是被人逼疯，我不知道，只是你的样子变了，变得让人喘不过气了，像是你花了毕生的积蓄，原来只是收藏了一幅精美绝伦却可笑的赝品，我是哭呢，还是笑呢，你这样不说一声的就变了。我想起了很多，那时候你的羞涩和促狭让人看得入神，没有一个钟头的时间是不用来嘲笑你的，发笑的时候你拿手盖住我的额头，一下又一下，像是和我的眼神躲猫猫一样，不看我，再看我，不看我，再看我。可是如今，你将手别扭的覆在我的额头上，看着我，也摸到了另一样，是因为岁月沉淀而褶皱起来的皱纹，它们难过而明目张胆的浮在饱满的皮肉上，像是一张明明可以按图索骥却不得终的地图，惹人发笑又怨恨，却还是哭了，因为七年的亘环，我们都老了呢。2.我问你，分开的这些年，你又爱过了多少人。你摇摇头没有说话，只是有一下没一下的用手指戳着桌子上的纸杯，水溅到了木质的表面上，一动不动没有晕开没有滑下来，只是像一个小小的凸出的反射面将你的脸孔放大，波动，没有表情。和一个小小的月球一样，没有空气所以我们没有再说话，没有重力所以我们无法拥抱。我还记得你长得第一颗青春痘，右脸颧骨上，我帮你小心翼翼的挤了它却惹了祸，落了疤，一个类似圆形的坑洼，能养一条金鱼了吧，呵呵，你埋怨了我一个星期，说是我故意的，为了不让别的姑娘喜欢你，故意把他弄丑了，卖不出去的土豆没人要啦。我自责的摸摸那个疤痕，像是一个青春过后沧桑丑陋的老者，说着你看我当年也怎样怎样的话。如果你的青年给了我，那么我还可以贪心的要你的成年，壮年，老年么。你不回答我，看着我委屈的眼睛抱住了我，给了我一个漫长又贴切的吻。我发一百个毒誓，你爱我的时候，我信你是真的爱我。可是然后呢，之后分开的日子你都哪里去了，我这次是再也没有找到你。3.你说，还记得大二的暑假么，我给你写过信的，但你没有回。我看着你的眼睛像是进了雨水，有些隔阂却异常清楚的能了解到你在看我，我看得见。可是，你交了几个女朋友，劈了几次腿，换了几个博客，又去过了哪几个地方作为毕业旅行，打发了几个手下败将获得如今的职位，用了几个月的时间相亲，和家里人交待，准备在年底花费几位数字购置一套楼房给你的新婚。这些我都知道，只是唯独不知道，你给我写的那封信。难道是你反复给我寄的那些照片，里面你每每换的新女友笑靥如花，依偎在你肩头，我还是能在哭出来的前一秒，认出你右脸上的疤痕，月球一样的冰凉孤独，和我一样，隔着高空没有日光照射的生存，生生的被每一个白天关上了门，守着夜。4.“我的丈夫在外面等我，先这样吧，再见。”“嗯，你保重，别老不吃饭减肥，枚红色的唇膏不适合你，还是换了吧，你不化妆更好看。”丈夫从门外走进来，他身上的墨绿色西装异常配合我今天的枚红色唇膏，特地是新买的，用来见他，却还是被人认为不好看，我做足了这些，其实还是没有用的.突然想回过头看看他，再看一眼，鬓角的发，或者是任何一些细节，却是走得太快，车窗摇上，行驶起来的运作让人有些发懵，看着窗外的城市像是哭了般被速度快速抹去，泪痕清晰的扑跌在玻璃上，那种错觉像是再三的经过过去的那些年，相爱再分开，再相爱再分开，分分和和，如果你拉住我问我，你在做什么，我说我在找人，你信吗，真的肯信吗。我看着左侧开车的丈夫，他的眼神专注而也不时向我投射，瞳仁的颜色有近乎不可思议的深黑，不是那种类似他的棕，可是在每一次挑选衣服的时候，还是把深墨绿色的布料贴在脸上，再给他穿上，像是手织嫁衣一般的隐忍而迷恋，却不能留下，都给你都给你。墨绿色的，如此不再沸腾，为我爱的人。5.男孩子给女孩子写的每一封信，都夹带了一张双人合照，是他和别人。上面的女孩子换了又换，又换成女人，娇媚可爱，或是成熟稳妥，样子烙印的深刻，不时变换的面孔像是道具一样，被摆设在男孩子的时空里，像是在费力的解释一个案例，用不同的证据来对比说明，说明一件实事，一个对于他自己都想去考证的真理，是什么呢。收信人永远也没有发现照片里的秘密。里面的姑娘换了又换，面目都是不一样，却每一个都是不化妆，不是太瘦，笑起来眼睛也像是委屈的弯弯扭扭，小心翼翼的歪头摆弄每一个姿势，总是感觉那么像一个人。什么时候你可以发现，便可以来告诉我，你这些年去了哪里，做了怎样的实验和案例。来证明什么，又是想说什么。你不敢回来，是么，为什么呢。是因为后来你的她和我很像么，是后来你的他和我很像么。后来呢，又为什么不敢来找我呢，为什么呢。6.因为你们都不敢承认。后来，我只是爱上了一个和你很像的人。&nbsp;', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('756', '2000', '一个两个三个```与自己擦肩而过的人怎么数也数不过来```开始工作了。休息了十天后，我又要继续劳累了``嘿嘿最近一直很累很累的``好象一直都在奔波奔波。梦里都没有暂停过一样```最近一直在想自己到底追求的是什么？理想是什么？不是钱。也许就是哪份安然宁静的开心与幸福吧`、可是到底要去哪里寻找呢？并不晓得，开始不停的转圈。并不知道哪里合适自己。也许习惯了转圈吧。所以不想停下来了。最近一直听文在跟我讲关于晶的爱情故事。当然还有文自己的。也许我也开始期待了吧。只是我还是那么呆而已。也许我是在追求一种爱上爱吧```莫名其妙的电话号码一直在重复打我的电话，却也只的打了就挂掉。奇怪的人。上网去查了他的存在地址，居然是重庆的。呵呵冒失12没有认识重庆的谁呀```很奇怪的感觉```看QQ上朋友的地址，到处都是，山东，杭州，南昌，深圳，广州，海南，青岛，北京，吉林，上海，安徽，西安，厦门，洛阳，烟台，威海，真的到处都是```可惜不知道什么时候才能在见到！爱情纪念册，爱上爱！我开始出发咯。依然是那种跟着感觉走的习惯。最近要帮文找工作了。呵呵好象比我找工作还要热心。只是心里一直想她可以过的好点吧，做朋友就要这样啊``我对他好，他才能对你好啊``呵呵其实我没有想要过任何回报```看着他睡的那么香甜。都有点羡慕了```习惯了握着手机等待着入睡。也许和幸福有关吧```努力吧```我想我哥了，想那棵大树了！呵呵可我没告诉他。因为我怕我会产生霸占大树的念头``嘿嘿所以我安静的看着，想着就好了！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('757', '2000', '好象从5月之后就变的有点沉默寡言了。不会在那么无理取闹的跑到群里面大家大闹了，也不在和朋友聊天到深夜了。每天都早早的躺在床上，虽然一直睡不着，可是我却习惯了这样无聊的看着天花板跟我宝贝讲话，总是觉得它会对着我笑，傻瓜，那也只是猫爸送的抱抱熊而已。可是好象现在的自己也就他一个不会离我而去，什么也不说了，不会让我生气。我给它起名字叫拖油瓶，！杭州最近一直在下雨，一直都觉得心有点特别的疲惫。公司里的人都那么的……哎算了，我就当个事外的人好了。他们怎么勾心斗角和我有什么关系呢。我只是甘心做一个小齿轮。希望他们不要为了自己的利益而利用这个小齿轮就好。其实真的没什么必要。你说他，他说你。然后你和他却象很不错的朋友。无形的一个战场，可惜我不想当炮灰。所以一直期待着离开的日子快点到来。真的好想好想时间快点到15号，我就可以见到啊V，奶茶，还有弟弟等等那些很不错的朋友了。可以象小孩一样撒娇了。我不知道这次说好的事情会有多少实现不了。可是我真的期待了。过年的事情一直让我耿耿于怀。可是新一轮的期待我却依然向往。难道自己就一直这样活在期待里么？恐惧着害怕着，却希望事情可以完美的发生。然后擦掉额头的汗水。告诉自己嘿！看来你还有那么点幸运啊！````摸摸头傻笑一下。就仅仅那样已经满足了。我只是一棵小草。怎么茁壮成长也无法变成参天大树。有时候很想自己是一棵小树也好啊，至少我历练了成长了。身后的那些更小的小树会羡慕我的“参天”可惜我只是小草。梦想是无法到达的奢侈。每天都静静的呆着。然后和他发发信息，貌似电话现在变成了他的专署。因为也只有他还在。不过貌似也快要去工作了。哎不舍得哦。有时候觉得象在做梦。从小就无安全感的自己又开始恐惧着，好象最后的结果只有一个，就是剩下自己一个人，当然还有影子！也许又开始犯傻了。有时候好希望成为别人心里的专有。不希望他心理还有另外一个。可是也许这样太自私了。所以告诉自己他们是博爱。我在他们心理有地位的怕什么呢？算不算自欺欺人啊？有点……不过有时候还是有点心理不开心。哎呀这样的十二太小气，不喜欢很不喜欢。小气十二你走开！OK！~~~我承认我现在确实无聊到了一种程度。所以才跟疯子一直自言自语。现在结束发疯。为什么可以说话不算话，还是在说的时候就根本没在意听的人是否在乎呢？就在这一瞬间。疼痛遍部了全身。冷汗直冒。可是那根本不算什么。因为心里更难受。隐约中又开始了不祥的预感。我又要失去什么了/是的，我害怕了/我总是想让事情一直保持在那个平衡点上，可是越是努力保持，越的做错事情。越的让事情慢慢的不在平衡，然后事情色彩。我不在信任任何人说的话，也不在信任任何人对我说的事情。淡漠的表情。面对这一切。我只是因为害怕。害怕期待那么久的事情让一下子落空。我承认现在的我开心偏激了。。。。我恨你！恨你！恨你！！！！你是个讨厌鬼，我不想看到你，不想知道关于你的一切，不想看到你认识的人，在思考了半年后，我承认我恨你。所以请你不要让我想起你，不让我想起关你的一点。不要让你认识的人总是跑我这来。恨你``都是因为你，因为你你你你你是个混蛋&nbsp;混蛋混蛋！！！！！OK。我发誓一定让你彻底消失在我的生命里。我不甘心。我恨你12。1212&nbsp;1212121212&nbsp;&nbsp;&nbsp;&nbsp;你怎么那么懦弱。你怎么那么没用。你活该，你有那么多机会不好好把握，现在心情不好活该。12是个大笨蛋，依然如99一年说的一样可怕的人！委屈什么你，你还觉得委屈，得了吧！这是你自己造成的，你有什么好委屈的。这叫活该才对。你就继续懦弱，继续自欺欺人好了。嘿嘿角色变换。无聊透顶之作！``睡觉咯。不扯淡了。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('758', '2000', '也许是思念临近的缘故，一直以为日子会过的很快，因为毕竟转眼间我已经来杭州半年了。这半年有开心有快乐。但是大部分时间是孤单与辛酸的吧！~~~虽然每天都握紧拳头告诉自己加油，一定可以的。。。也许是心态依然不够坚定，依然不够倔强吧。所以还是期待着什么。还是怀念着什么。还是寻找着什么。或者还在期许着那些不会实现的梦。时间好象在向回走了。没有见到前进。好象一直与我离开的日子相差着一个月。计划了15号去学校。可是好象7月迟迟不来了。好象我在逆着时光穿行。一直到达不了想要去的地方吧！```每天重复着生活，一个人偶尔出去走走看看。呵呵也许这样也是一种幸福，我是这样告诉自己的。因为本身奢求就已经很多了。如果一直一直去想去得到那么会变的贪心。不在单纯。至少我现在依然可以很自信的告诉自己，我还是以前的哪个我，虽然只剩下半个纯真的影子。呵呵今天又看了《瘦身男女》！是的，我承认他们演技又一次换取了我的眼泪。就是因为听到哪一句背对着说的“胖子，我想你了！”简单却很让人感动的一句话吧·`也许我真的把故事当成了现实生活里的事情了吧！`我不是肥婆，所以身边也不会有那么一个胖子。不计较一切的来帮助她！``或者我也奢望有个胖子那样的好朋友。又或者说我有个胖子那样的朋友，我却浑然不知！~~~我想就算我是肥婆我也不会去减肥吧。或者根本没有毅力坚持到最后吧！``就这样一个别人编制的故事让我遐想很多，呵呵也许这些都是些奢侈的梦吧，或者说是小女孩的白痴想法吧，可是我却习惯与沉静在这样的故事里一变一变回味幸福的味道，是那种在现实生活里寻觅不到的感觉。前几天和同事去逛街了。呵呵走了很多路，真的很累很累的。不过在雨中看西湖其实真的很美！西湖边的荷花含苞待放。记得落木曾经说，他去西湖是想寻觅当年断桥的美丽爱情。呵也许故事早就结局了。新的故事开始了！``所以当他寻到的时候也许那是另外一份独特的幸福吧。耳边一直放着小坏传给我的音乐。迷迷糊糊的感觉。却无半点睡意思！```只是我不知道我现在到底脑袋里在想点什么。好象很乱很乱的！``突然做了个临时的决定，换了衣服出去逛逛！``呵呵总是这样的随意。文总是很佩服我的随意。不过现在她也不会跟随我的随意了。毕竟大家现在离的很远了。有点小小的伤感了。嘿嘿好！就罗理八嗦到着吧！``决定收拾下出发咯。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('759', '2000', '2008年6月1日!```今天是儿童节哦！``我假装我还小。做个小孩子，买了很多冰激凌吃。可惜现在胃开始不舒服了！``自作自受啊……上班的时候太闲所以思想飞的很远很远！“我记得你是我生命中是谁,可惜你早已经忘记我是你生命中是谁.哪天我站在路口,看到了曾经的我们.我想他们一定会比我们幸福.那天我在雨里站着哭了很久.然后假装没事的回到家洗澡睡觉.可是我还是做噩梦了.还是折腾了一夜没有睡好!````”有些事情是很不可信的,可是我却想去相信.所以我笑了.笑我的愚笨我的傻!``心里装的哪个人永远都改变不了.心里已经满了在也装不下其他的人了````哎!好伤啊….很多人说过不可以失去你，没有你会怎样怎样.只是发现现在的他们失去了曾经的宝贝，过的依然幸福.并没看到失去后他们有什么伤留着!``所以我开始不相信任何的感情任何关于幸福的词语.只是觉得这一切都不是属于我的.在杭州马上就呆半年了.时间过的好快啊.一个人的天空是灰暗的.一点色彩也不存在,可是我每天都挂着笑脸.真的累了的时候会早点回家关了灯坐在床上沉默的思考什么,.或者直接脑袋空白的发呆````&nbsp;&nbsp;我开始思考着离开了.开始不想在过这样一个人过日子了!``我想也许所有的地方都绑不住我的心吧,.总是觉得没有任何一个地方值得我留恋的.也许我这人真的是太贪心了吧!```决定往往就出现在一瞬间的,也许我明天会离开,也许我这一年都在着呆着吧!```这个城市一直到现在我依然不熟悉,每次走路也总会迷路.也许这里并不合适我吧!````有点哀伤了.我不知道现在的自己到底想要点什么.我只是希望现在可以有个人陪我说说话,闲的时候陪我逛逛街,.如此而已,可惜这样简单的想法也许今天也许以后一直都不会实现了吧!```这些日子越来越暴躁了,越来越害怕一个人呆着的时间了.每天泡在公司里面,就算只是看别人说话也不想回家.因为家太寂静了,.太可怕了!```&nbsp;&nbsp;&nbsp;我不知道以后我该去那里了。陌生陌生陌生……一切都开始变的陌生了。我不喜欢这样的陌生，我害怕这样的陌生。可是我寻不到熟悉！``下雨了，空气很好，深呼吸好好面对一切选择什么都要好好走下去！```努力', 'var SERVER = \"\"http://ht.www.sogou.com/websearch/features/yun1.jsp?pid=sogou-brse-596dedf4498e258e&\"\";', '', '');
INSERT INTO `dede_addonarticle` VALUES ('760', '2000', '\"界上只有两种可以称之为浪漫的情感　　　　　　一种叫相濡以沫，另一种叫相忘于江湖　　　　　　我们要做的是争取和最爱的人相濡以沫　　　　　　和次爱的人相忘于江湖　　　　　　　　　　　　有道是“感情若是长久时，又岂在朝朝暮暮”　　　　　　　　　　　　　　　　　　在对的时间，遇见对的人，是一种幸福　　　　　　在对的时间，遇见错的人，是一种悲伤　　　　　　在错的时间，遇见对的人，是一声叹息　　　　　　在错的时间，遇见错的人，是一种无奈　　　　　　　　　　　　爱不是千言万语，也不是朝朝暮暮，......孤单的心，像是地狱里被囚禁的魔鬼。也像天堂里寻找自己翅膀的天使!他们缺少的都是自己最需要的.我叫12是个寂寞里有个孤单心的女子.喜欢被爱、讨厌欺骗。喜欢一个人坐在房顶上看星星的丫头。一直都想找寻自己的真爱。以为真爱就在自己身边。可是却……感情是不是真的需要用金钱来衡量？不是&nbsp;但是没有金钱的感情很虚弱&nbsp;象病人一样随时可能死亡``阳光下苦涩的味道！天涯望断，是两颗灵魂，偶遇的一刹，惊心惊肺的发现，原来这个才是自己要寻的。却错过了，却辜负了……记得看一个朋友空间里写了两份文章，一个是写男人的：男人这辈子挺难的：找个漂亮女人吧，太操心，找个不漂亮的吧，又不甘心；光顾事业了，人家说你没责任感，光顾家了，人家又说你没本事；专一点吧，人家说你不成熟；花心点吧，人家说你是禽兽；有钱，说你是坏人，没有钱，人家骂你窝囊废；自己奋斗吧，等有钱了女友也老了，让女人养吧，不如自宫练葵花宝典算了。不去应酬，怕被老板废了，去应酬吧，怕被老婆废了。哎！这年月做男人真难。女人可以等嫁，俺们等啥呀？女人还有个三八节，俺们有啥呀？男人这辈子挺难的：长帅点吧，太抢手，不帅吧，拿不出手；活泼点吧，说你太油，不出声吧，说你太闷；穿西装吧，说你太严肃，穿随便一点吧，说你乡吧佬；会挣钱吧，怕你包二奶；不挣钱吧，又怕孩子断奶，结婚吧，怕自己后悔；不结婚吧，怕她后悔，要个孩子吧，怕出来没钱养，不要孩子吧，怕老有才气叫才女，没才气也不要紧，可以叫淑女--女子无了没人养。这年头做女人难，做男人更难，男人，就要对自己好点！一篇是写女人的：在现代社会做个女人，真好。漂亮吧叫美女，不漂亮吧叫有气质；才便是德嘛。瘦了叫苗条，胖了叫丰满；高的叫亭亭玉立，矮的叫小巧玲珑。脾气好的叫温柔，脾气不好的叫泼辣；爱傻笑那叫阳光，绷着脸那叫冷艳；活泼的叫顾盼生辉，矜持的叫稳重大方。化装叫妩媚动人，不化装则是清水芙蓉；穿得整齐叫庄重华美，穿的随意则叫潇洒自如。年轻叫青春靓丽，年长则叫成熟动人；追的人多叫众星捧月，没人敢追叫傲雪寒霜。挣钱的叫追求独立，不挣钱的叫牺牲为家；多生孩子叫做母亲伟大，不生孩子叫响应国家计划。天天在家不出门的那叫贤惠，天天出去不回来的那叫女权；从不离婚的叫感情专一，经常离婚的叫追求幸福；唠唠叨叨叫循循善诱，贬损欺压叫\"\"野蛮女友\"\"。偏要和男人一样那叫不让须眉，偏要男人让着那叫女士优先；长的像女人那叫有女人味，长的不像女人--更没关系啦，那叫\"\"超女\"\"，火着呢!其实男人也好。女人也罢。都是一样的，什么叫做男人难？什么又叫做女人难？一切都要看自己的经历是怎么样的。幸福亦或是辛酸！~~~难和不难都在这里面看的清清楚楚！~~~``男人希望自己娶个爱自己然后上的厅堂下得厨房的女人？那女人呢？也许她们希望的人生最完美的结局，是在一个爱她的人怀抱中老去。世间女子怕的不是凋零，而是被忽略被辜负。一辈子的投入却换来一无所有的结局那才是悲哀的。她们所要的不过是一段俗世的姻缘，有时却难得如愿，于是寻常的拥有，便成了珍贵的世宝！~~~世事无常总是相伴很多的无奈与误会，他被伤害了；她被抛弃了；他伤心了；她哭泣了；其实都是自找的，怪不得别人的。谁也不是谁的谁。也没有义务自己去承担自己以外的疼痛。怪就怪自己不好好珍惜；怪就怪自己太过于执着着这份原本该舍弃的感情。怪只怪他们不是对的时间遇见对的人，所以造就了眼前的悲伤或叹息！```有道是“感情若是长久时，又岂在朝朝暮暮”　　　　　　　　　　　　　　　　　　在对的时间，遇见对的人，是一种幸福　　　　　　在对的时间，遇见错的人，是一种悲伤　　　　　　在错的时间，遇见对的人，是一声叹息　　　　　　在错的时间，遇见错的人，是一种无奈　　　　　　　　　　　　爱不是千言万语，也不是朝朝暮暮，......时光老人的一个哈欠，让时光错乱。错的时光让两个原本无法相遇的直线相交！``让他们拥有短暂而且美好的幸福！``正点的时光调整。恢复了原本的平淡。纠正的时光，留下的是夜晚心跳疼痛的声音。颓败的人群。美好的记忆，一切不过是芸花一现！``童话一样的梦，醒了一无所有。甚至连记忆也模糊不清……轩的出现，信给的幸福的感觉。晨曦死亡的消息，笨笨爱了又失失了又爱的哭泣。杨洁文字带来的疼痛。骨头的疼爱。丫头的痴傻。故事开始经历高潮结束。其实很平淡。但是却很疼痛。阳光下苦涩的味道①对的时间遇见错的人。也只能苦苦的笑着，看事情我经历然后繁花落尽。记忆里的美好也像花一样落尽了。荡然无存的温暖。依然冷冷的，依然倔强的上扬嘴角等待对的时间遇见对的人。7和9的幸福美好。罗的疼痛。丹的哭泣沉没……卓的一切记忆。总是忧郁，无缘的心痛。总是好心，连陌生人也会去心疼。所以假扮天使，医好别人却伤害了自己。最后一根羽毛的飘落。天使已不是天使。在无法回去自己的天堂……阳光下苦涩的味道②\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('761', '2000', '\"&nbsp;1、98年马化腾等一伙凑了50万创办了腾讯没买房；98年史玉柱借了50万搞脑白金没买房；99年丁磊用50万创办163.com没买房；99年陈天桥炒股赚了50万创办盛大没买房；99年马云等18人凑了50万注册阿里巴巴没买房。如果当年他们用这50万买了房，现在估计还在还着银行的贷款吧。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2、年轻的我们必须懂得：1、你不勇敢，没人替你坚强。2、没有伞的孩子必须努力奔跑！3、自己选择的路、跪着也要把它走完。4、不要生气要争气，不要看破要突破，不要嫉妒要欣赏，不要拖延要积极，不要心动要行动。5、宁愿跑起来被拌倒无数次，也不愿规规矩矩走一辈子。就算跌倒也要豪迈的笑&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3、人生三大遗憾：不会选择，不坚持选择，不断地选择；人生三不斗：不与君子斗名，不与小人斗利，不与天地斗巧；人生三修练：看得透想得开，拿得起放得下，立得正行得稳；人生三大陷阱：大意，轻信，贪婪；人生三大悲哀：遇良师不学，遇良友不交，遇良机不握。人生三大不争：不与领导争锋，不与同事争宠，不与下级争功&nbsp;&nbsp;&nbsp;4、一个人，如果你不逼自己一把，你根本不知道自己有多优秀。一个人，想要优秀，你必须要接受挑战;一个人，你想要尽快优秀，就要去寻找挑战。一个人，敢听真话，需要勇气;一个人敢说真话，需要魄力。一个人的知识，通过学习可以得到;一个人的成长，必须通过磨练。&nbsp;&nbsp;&nbsp;5、【最温暖的八种食物】①早上醒后来的一个煎蛋；②上班出门前塞在包里的一个苹果；③加班深夜回家后的一碗热汤；④睡觉前的一杯牛奶；⑤伏案工作时的一杯热茶；⑥生病卧床时的一碗白粥；⑦喝闷酒的时候一碟小菜；⑧酒醒后的一碗清汤面。《你吃到过几样？》&nbsp;&nbsp;&nbsp;6、网易CEO丁磊说：“千万不要以为我是抱着一个伟大的理想去创办一个伟大的公司，我从来没有远大的理想，也没有想要成为一个很有钱的人。创办网易时我只是想做一个小老板，就想有个房子有辆汽车，不用准时上班，可以睡懒觉。我的梦想也是那么简单。”丁磊的话很实在。但是，现在创业已经不是那么简单了。&nbsp;&nbsp;&nbsp;7、人脉中需有的十种职业人：1票贩子、2旅行社、3律师、4人才市场/猎头公司、4银行、5当地公务人员/警察、6名人、7保险/金融/理财专家、8维修人员、9媒体联络人、10医生/护士/养生专家。《你认识这十种人吗？用心经营您的人脉关系吧！》&nbsp;&nbsp;&nbsp;8、【做人的底线】（1）不做第三者，即使再喜欢（2）骗我可以，如果被我知道超过两次，请你有多远滚多远（3）如果你拿我不当回事，我会以同样方式对你（4）我可以装傻，但别以为我真傻（5）我可以容忍，但别超过我的底线（6）我不是没脾气，只是不轻易发脾气（7）任何真话，我都能接受。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9、15岁觉得游泳难，放弃游泳，到18岁遇到一个你喜欢的人约你去游泳，你只好说“我不会耶”。18岁觉得英文难，放弃英文，28岁出现一个很棒但要会英文的工作，你只好说“我不会耶”。人生前期越嫌麻烦，越懒得学，后来就越可能错过让你动心的人和事，错过新风景。—蔡康永&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;10、25岁的英国士兵BarryDelaney穿着鲜亮的绿色吊带短裙和粉红腿套，在同袍好友KevinElliott的葬礼上哭的一塌糊涂,他俩是同在阿富汗执行任务的好友.他们之前有一个约定:无论谁先不幸西归,另一个都要穿女装亮相对方的葬礼,为那里灰暗的悲伤带去一丝亮色，很感人，一诺千金。《伟大的友谊，你有这样的朋友么？》&nbsp;&nbsp;&nbsp;11、慢慢成熟的标志：1早上无论多困,也会马上起床上班；2喜欢吃家常便饭多于外面的餐馆；3喜欢隐身,网络签名长时间不更改；4喜欢看新闻多于看八卦；5打电话给朋友的次数少了；6可以让你开心的人或事,越来越少了；7没结果的事情,渐渐就少做了；8低落的时候选择一个人呆着。&nbsp;&nbsp;&nbsp;12、美国旧金山有一老头查克费尼，穿旧衣服，戴烂手表，住出租屋，挤公交车。他为美国教育捐出了近20亿美金，还希望死前把仅有的40亿美金全部捐献给社会。在北京有个大富豪陈五喜，开豪车，住华宅，吃大餐，手上戴大钻戒，投资房地产，同时还在民政部门领取低保，8年间共得到10万元的社会救助。《中美差异》&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;13、1931年的1月30日是世界现代史上灾难的一天，阿道夫·希特勒被任命为德国总理。他的名言：“消灭一个民族，首先瓦解它的文化；要瓦解它的文化，首先消灭承载它的语言；要消灭这种语言，首先先从他们的学校里下手。”，当今的中国大学里无论什么专业，英语是必修课，汉语却不是。&nbsp;&nbsp;&nbsp;14、尼古拉斯.科波拉，他的亲叔叔叫弗朗西斯.科波拉，名满天下的《教父》的导演。这个小伙子后来去好莱坞混，为了以自己的实力打天下，故意改名为尼古拉斯.凯奇。不想沾任何叔叔的光。中美文化的差异就在于此。《我爸是李刚》&nbsp;&nbsp;&nbsp;15、让你成熟至少5岁的8句话】1、如果你不喜欢现在的工作，要么辞职不干，要么闭嘴不言。2、学会忍受孤独。3、不要像玻璃那样脆弱，做个内心强大的人。4、管住自己的嘴巴。5、会创造机会。6、若电话老是不响，你该打出去。7、不要草率结婚。8、写出你一生要做的事情，把单子放在皮夹里，经常拿出来看。&nbsp;&nbsp;&nbsp;16、今年，年仅26岁的Facebook的创始人马克·扎克伯格，以40亿美元身价登上2010福布斯全球最年轻富豪榜榜首。目前已把自己过半财产捐赠给慈善事业。扎克伯格拥有亿万身家，但他至今仍和华裔女友普莉希拉·陈生活在一套租来的住房里，每天走路或骑自行车上班。&nbsp;&nbsp;&nbsp;17、澳大利亚老板帕尔默，他说：人每次只能睡一张床，吃一顿饭，驾一辆车，跟一个女人一起，所以我决定分一些给大家。为了感谢员工帮助他将企业扭亏为盈，他送给员工55辆奔驰，让750名员工出国度假，宴请2000名员工及家属。员工们兴奋的说，这样的老板，令我倾120%力量去工作。《神奇的领导力，无处不在》&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;18、1992年一艘从中国出发的货船在太平洋上遭遇强烈风暴，船上一个装满2.9万只塑料玩具鸭的集装箱坠入大海。令人难以置信的是，其中1万多只玩具鸭组成的“鸭子舰队”在海洋上漂流了14年之后，竟抵达英国海岸。后来，这些鸭子售价激涨百倍。一个人的价值并不在其出身，而在于他谱写什么样的人生履历。。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;19、80后／90后的通病：1、近视；2、月光族；3、喜欢Money；4、从不锻炼身体；5、一日三餐没有规律；6、路盲，没有方向感；7、搞不清楚自己的血型；8、有一颗狠宅狠宅的心；9、做事情都是三分钟热度；10、经常午夜12点以后才睡觉。《三条没有你就是神了》&nbsp;&nbsp;&nbsp;20、母亲一生的六个谎言：1.(童年时)快吃吧，我不饿；2.(少年时，深夜做针线活)快睡吧，我不困；3.(高考路上)快喝吧，我不渴；4.(参加工作，母亲生病时)你赶快去工作吧，我很好；5.(给母亲寄钱)你用，我有钱；6.(买房接她住)城里，我不习惯。愿天下的母亲健康长寿！《到了毕业的这个时候，更能体会妈妈的良苦用心，好好去爱她！》&nbsp;&nbsp;&nbsp;21、【永远都不要做的事】1，跟知己上床2、和情人结婚3、把同事当成朋友4、到朋友公司打工5、在上司面前知无不言6、轻信上司的许诺7、喜怒哀乐都挂在脸上8、在人堆里大声讲手机9、习惯于给自己找借口10、超车过去，看开着车有着窈窕背影的MM的脸11、对MM的\"\"字信以为真12、指望前女友回心转意。&nbsp;&nbsp;&nbsp;22、【成功者的习惯】1.微笑。2.气质纯朴。3.不向朋友借钱。4.背后说别人好话。5.听到某人说别人坏话时只微笑。6.过去的事不让人全知道。7.尊敬不喜欢你的人。9.对事无情，对人有情。10.多做自我批评。11.为别人喝彩。12.感恩。13.学会聆听。14.说话时常用我们开头。15.少说话。16.喜欢自己。&nbsp;&nbsp;&nbsp;22、可敬可畏：1.日本电视台用中文进行广播，通知人们地震情况、躲避方式；2.每个家庭都有急救小包，包括药物、手摇式发电收音机；3、9级大震后东京建筑几乎安然无恙，尤其是人们避难时都井然有序的站在道路两侧尽量不阻碍交通，撤离后无一垃圾。日本是个危机意识、集体主义、纪律性极强的国家！&nbsp;&nbsp;&nbsp;23、【建立人脉的15个提示】1、学会换位思考；2、学会适应环境；3、学会大方；4、学会低调；5、嘴要甜；6、有礼貌；7、言多必失；8、学会感恩；9、遵守时间；10、信守诺言；11、学会忍耐；12、有一颗平常心；13、学会赞扬别人；14、待上以敬，待下以宽；15、经常检讨自己。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;24、55年前，就读于浙江大学的法国女子丹尼和中国学生袁迪宝相恋，但袁已婚了。1956年，丹尼伤痛中离开了中国。最初还通信，但慢慢就断了来往。去年初，袁试探着给丹尼写信，竟然回复了。9月，两人重逢第三天在厦门结婚，83岁的丹妮第一次穿上了婚纱。爱，它确实存在。《我相信爱情，你呢？》&nbsp;&nbsp;&nbsp;25、让你少奋斗10年的工作经验：1不要停留在心灵的舒适区域；2不要把好像、大概、晚些时候、或者、说不定之类的话放在嘴边；3不要拖延工作；4不要认为理论上可以实施就大功告成了；5不要让别人等你；6不要认为细节不重要；7不要表现得消极；8不要把改善工作能力仅寄托在公司培训上；9不要推卸责任。&nbsp;&nbsp;&nbsp;26、人平均一辈子只有7次决定人生走向的机会，两次机会间相隔约7年，大概25岁后开始出现机会，75岁以后就不会有什么机会了。这50年里的7次机会，第一次不易抓到，因为太年轻，最后一次也不用抓，因为太老，这样只剩5次了，这5次机会里又有两次不小心错过，所以实际上只有3次机会了。——哈佛的一项调查报告&nbsp;&nbsp;&nbsp;27、职场情商训练7法:1、把看不顺的人看顺；2、把看不起的人看起；3、把不想做的事做好；4、把想不通的事想通；5、把快骂出的话收回；6、把咽不下气的咽下；7、把想放纵的心收住；——你不需每时每刻这样做，但这样多做几回，你就会：1、情商高了2、职位升了3、工资涨了4、人爽了。&nbsp;&nbsp;&nbsp;28、泰勒语录：（1）我拥有一个女人的身体和一个孩子的情感。（2）我只和与我结婚的男人上过床。有多少女人敢这么说？（3）如果有人笨到花100万美元为我拍张照片，我当然不会笨到拒绝他。（4）成功是一种了不起的除臭剂。它能带走所有你过去的味道。（5）我不会假装是个平凡的家庭主妇。&nbsp;&nbsp;&nbsp;29、她原系徐州女排队员，22岁嫁给50岁的cherry获绿卡后离婚、经新男友引荐入读耶鲁大学。96年旅行结识同座的starTV副总，经推荐在香港实习。97年晚宴她将一杯红酒洒在“传媒大亨”默多克身上，3年后他不顾家人反对而离婚并迎娶她。4年后她以高科技为他生下两个继承数十亿美金的女儿。她就是邓文迪。《运气总是留给有预谋的人。。》&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;30、我年轻时曾与我们州最漂亮的女孩约会，但最后没有成功。我听说她后来离过三次婚，如果我们当时真在一起，我都无法想象未来会怎么样。所以，其实你人生中最重要的决定是跟什么人结婚！在选择伴侣上，如果你错了，将让你损失很多。而且，损失不仅仅是金钱上的。（BY巴菲特：结婚才是人生最大投资）&nbsp;&nbsp;&nbsp;31、盖茨39岁成世界首富，陈天桥31岁成中国首富，孙中山28岁创办兴中会，王然23岁当局长，孙权19岁据江东，丁俊晖15岁拿世界冠军，邓波儿7岁拿奥斯卡，贝多芬4岁开始作曲，葫芦娃刚出生就打妖怪。你说我们急不急。《我确实着急了！》&nbsp;&nbsp;&nbsp;32、理查森，男，纽约。从1984年起连续五次投资失败。2007彻底破产，妻离子散，朋友消遁，唯有一条名叫JOOY的狗与其不离不弃，忠伴左右,陪理查森一同在纽约的风雨街头乞讨。从“JOOY”安详恬静的睡姿中看得出它对主人的无限信任和依靠。有的人，在沧海变成桑田时，表现得还不如一条狗。《认识的人多了，我就喜欢了狗》&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;33、&#8810;教父&#8811;经典台词：1、不要让别人知道你的想法。2、当你说不时，你要使不听上去象是一样好听。3、让朋友低估你的优点，让敌人高估你的缺点。4、痛苦不象死亡那样无可挽回！5、如果你没有时间和家人在一起，你就永远无法成为真正的男人。6、永远不要恨你的敌人，因为这会影响你的判断力&nbsp;&nbsp;&nbsp;34、觉得自己做得到和做不到，其实只在一念之间。自己要先看得起自己，别人才会看得起你。一切伟大的行动和思想，都有一个微不足道的开始。有理想在的地方，地狱就是天堂；有希望在的地方，痛苦也成欢乐。乐观者在困难中看到机会；悲观者在机会中看到苦难。理想的路总是为有信心的人预备着。－－﹣李嘉诚。&nbsp;&nbsp;&nbsp;35、女名叫安-德纳姆,生在美国堪萨斯。18岁的安在异族通婚非法的年代嫁给了一个非洲黑人留学生。后来，安和丈夫离婚成了单身母亲，她靠食品优惠券生活，是美国医保系统受害者，在重病时恳求保险公司赔付。然而她的孩子，图片里装扮成海盗的小孩，日后成了美利坚合众国第44任总统，巴拉克-奥巴马。《不要因为出身而看不起任何人！》&nbsp;&nbsp;&nbsp;36、阿米尔汗，8岁时出演一部轰动印度的电影，是公认的童星，长大后却一心打网球并获得过网球冠军。21岁爱上邻居家女孩，由于宗教原因两人决定私奔，现在过着幸福美满的生活。他是演员/制片人/导演。81届奥斯卡最佳影片《贫民窟的百万富翁》就是他担当的制片，2009年一部《三个白痴》震惊全球，他45岁。《你相信坚持的力量么？》&nbsp;&nbsp;&nbsp;37、陈佩斯，因为央视出版他的小品而不给钱，较真打官司，遂被彻底封杀。此后陈消失，陈夫妇上山种树，脸朝黄土背朝天，两年获利30万。陈佩斯哭了，还想再演戏，可依旧被封杀，就砸30万改演话剧，第一部舞台喜剧《托儿》，在全国各地连续演出达120场，票房近4000万元，创造了当今话剧界无法超越的神话。《我就想说一句话：是金子在哪都发光。。。》&nbsp;&nbsp;&nbsp;38、她，37岁，癌症晚期。他，42岁，为筹钱给她治病，盗窃一辆电动自行车而入狱，刑期4年。2010年11月12日，他两人在监狱里举行了简单的婚礼，但这场童话般的婚礼，却让在场的数百位嘉宾感动得潸然泪下。偷辆电动车刑期4年，李刚儿子撞死人才3年。无语！一条人命还不如架电动单车。《生活在这个让人苦恼的社会。。。》&nbsp;&nbsp;&nbsp;39、天下只有两种人。比如一串葡萄到手，一种人挑最好的先吃，另一种人把最好的留到最后吃。照例第一种人应该乐观，因为他每吃一颗都是吃剩的葡萄里最好的；第二种人应该悲观，因为他每吃一颗都是吃剩的葡萄里最坏的。不过事实却适得其反，缘故是第二种人还有希望，第一种人只有回忆。——钱钟书。《你是哪种人？》&nbsp;&nbsp;&nbsp;40、他出身于书香门第，父亲是大学教授。他为爱妻，20年来从不上CCAV；他是个好爸爸；他顾家，厌恶应酬，滴酒不沾；他才华横溢，琴棋书画样样精通，学生时是体育全能，探戈高手；他饱读诗书，季羡林赞他可胜任北大的研究生导师，曾与钱钟书是忘年之交，他说他只是个戏子。他就是陈道明。一个很给力的男人。&nbsp;&nbsp;&nbsp;41、旧上海黑社会老大杜月笙的经典语录：1、做人有三碗面最难吃：人面、场面、情面。2、头等人，有本事没脾气；二等人，有本事有脾气；末等人，没本事大脾气。3、人可以不识字，但不能不识人。4、钱财用的完，交情吃不光。所以别人存钱，我存交情。存钱再多不过金山银海，交情用起来好比天地难量。&nbsp;&nbsp;&nbsp;42、成功根本没有秘诀，如果有的话，就只有两个：第一个是坚持到底，永不放弃；第二个就是当你想放弃的时候，请回过头来再照着第一个秘诀去做。——丘吉尔&nbsp;&nbsp;&nbsp;43、他，21岁，生意失败。22岁，州议员落选。24岁，生意再败。26岁，爱侣去世。27岁，一度精神崩溃。36岁，众议员落选。45岁，参议员落选。47岁，提名副总统落选。49岁时，参议员落选。52岁，当选美国第十六任总统。他叫林肯，坚信上帝的延迟，并不是上帝的拒绝，最终成就不凡。&nbsp;&nbsp;&nbsp;44、善良的苏格兰农夫从粪池救出一个小男孩，男孩的绅士父亲酬谢，农夫拒。绅士说：让我们签个协议，我带走你的孩子，给他最好的教育，农夫允。农夫的孩子后来发明了青霉素，获得诺贝尔奖。数年后，绅士的儿子得了肺炎，青霉素治好了他。这两个孩子分别是弗莱明和丘吉尔。《冥冥之中，自有天意》\"', 'window.comSogouWwwStop = true;', '', '');
INSERT INTO `dede_addonarticle` VALUES ('762', '2000', '夺厅副食店副食店防盗锁', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('763', '2000', '刚开始&nbsp;&nbsp;试一下', 'setTimeout(function(){ ', '', '');
INSERT INTO `dede_addonarticle` VALUES ('764', '2000', '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;只是在近段时间，我才发觉我经常做梦了。奇怪的是以前是没有觉得做梦有什么不好，记得看过一本书写着，人每天都会做梦的，只是有些人根本没意识到而已。我是喜欢做梦的，虽然梦里的场景并不都是我喜欢的。那里我仿佛经历了另一种人生，我才是真正的主角，而且是由我来安排剧情的发展。可是一晚上下来，实在疲乏的很。每天晚上我梦醒后都不敢睁开双眼，如果是美梦，我害怕那一切都是虚幻的，如果是噩梦，我怕醒来又是一片漆黑，我害怕孤单一人去面对，每到必须要我一个人去面对的时候，我总会觉得那么孤独无助。我期望有一双大手紧紧的拉着我，一直陪在我左右，即使什么也不做，我会觉得安慰的多，遇到再大的困难也无所畏惧了。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;我还记得去年冬天，我辅导完作业总是很晚，凄冷的月色散发着幽幽的光辉。我就那么每天晚上踏月而归。冬夜的星星总是稀少，月光也时而躲进厚厚的帐帷里。我走在冷清的路上，居然没觉出害怕，我被刺骨的寒风侵袭着，反而很快乐，仿佛只有这样才能真实的感觉到我的存在。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;那些日子有点辛苦，可也成了我日后宝贵的财富。我适应环境的时间越来越短，也渐渐明白了如何与人相处。随着身上的学生气渐渐退却，岁月的刻刀也会在我的脸上留下些许痕迹。沉淀下来的是大概是所谓的成熟和圆滑世故，稚嫩的青春再不会像青草般在春天重新发芽了。而这一生我已知足了，我的人生充满了爱，我现在也正在爱和被爱着，这世上还有什么比爱更美好的事呢？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('765', '2000', '忆初见晴归暮至憾难聚，望眼欲穿追梦路思绪万千心中念，奈何明日方能见&nbsp;朝露晨雾迷吾身，惟愿卿晓君之意白马驻足目凝视，只为一睹卿容颜&nbsp;此貌只应天上有，奈何飘落到凡间长发飘飘惹人醉，素妆淡雅赛天仙&nbsp;吾心飘往青云天，倾心仰慕向红颜红颜娇羞默无语，愈发撩拨人心弦&nbsp;满心欢喜登巴士，伊人静坐君左边殷商美景同欣赏，君心默默向红颜&nbsp;秀色可餐君腹圆，不知红颜心中念牵手影院毗邻坐，幸福未来在眼前&nbsp;幸福额度君子篇，深浅缘因信用间甜蜜指数萝莉愿，高低皆由心境判&nbsp;屏前幕中皆尘缘，尘缘未了心中念今生与静共相伴，搀扶一生到终年', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('766', '2000', '今天好生气.只有我买人.倒被我爱的人买.诶.我和你说了.以后不能发生过事.只有我买你.你不能买我.会乖你说过你会一直听我话.你说过.你要做到.不然我也不会做到.我答应你的事.!七夕.我忘记这天.可能你会气可能你会孤单可能你.....SHaNG-我觉得你太好了.对我也太好.不管我做错什么事.对你怎么样.你永是这样原谅我.我相信.靠自己的努力.给你幸福.崔俊', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('767', '2000', '真的好失望.密码改掉.也不和我说.!是怕我看到什么男的流言.你想偷克偷.我不拦你.---------很好很好.不要我管.你可以港.我绝对尊敬你建议.从今天起.我崽就管你', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('768', '2000', '我以为我可以，做个决定，然后强迫自己去忘记。我失败了，我给自己找理由，但是感觉不能骗人的，我还爱着他，是爱，我确定。我的想法或许太多了，事情其实很简单，我爱他，他爱我，我介意他的过去，他掩饰他的过去，所以，我们的爱至今犹豫不决。时间可以证明一切，我只有等待，唯一能做的，也只有等待。文字', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('769', '2000', '我领养了qq宠物，取他的名字——欣欣；他也养了宠物，取我的名字——可可。唉，不得不承认，我虽然也是个女孩子，但是真的没有他细心，我昨天的时候把欣欣养死了一次，丢人啊~~~不过，qq宠物人性化的地方在于，他是有一次复活的机会的，所以现在又变的健康了，活蹦乱跳的了。当时我真的好紧张啊，尤其是看到他摇了两下就倒下的时候，真的心都碎了。跑题了，有点。我其实是想说我和欣的感情，在我们几乎要saygoodbye的时候，我们一起养了qq宠物，应该也有一部分的原因，是我们都想再给彼此机会。很可爱的qq宠物哟，特别是像我们这样情侣型的，感觉照顾的不是宠物，而是自己爱着的对方（我好失败啊~~t.t）不过呢，我喜欢叫欣欣去打工，就要折磨他，哈哈。现在他的可可比我的欣欣的各项指标都高，没办法啊，他是冲了q币的嘛，过几天我也去冲，一定要把欣欣也养的白白胖胖的。qq宠物到了15级之后就可以结婚了，可可和欣欣现在都是6级，还要等好久好久啊，到那个时候，我和欣会在一起吗？不知道哦，希望吧。如果不能一起，也要做最好的朋友，最知心的那种。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('770', '2000', '我把密码改了。我还留言给你了呀。我跟你说了。我得号子好多人晓得密码~所以我把密码改了。还有。你买了我那么多次。我都不生气。我就是买了你一次。你居然这样生气。好好好……我答应你以后绝对不买你。这样总可以了吧？昨天晚上我是真得不能出来啦。本来屋门口就上不得网。会切就送我妈妈港起啦。好啦。不要生气好不好？如果昨天晚上可以出来。我绝对会出来。但是我是真得出不来阿。密码下次我告诉你。我想请你相信我。我绝对不会背着你偷人。这点你也可以放心。昨天听到我玩得好得告诉我那些话。我挂了电话就哭了/我没有想到你就这样会生我的气。对。下午是我不好没有打电话给你。好啦。不要生气好不好？我说过/我们得感情生活里肯定会出现矛盾。但是我们一定要一起面对阿。我们一定要一起度过。你不肯打电话给我。我就打电话给你。但是你却不在家？你不会又像上次一样？跟别得妹子.........？我真得很害怕。害怕你得离开？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('771', '2000', '很开心得是我们和好啦。我希望我们以后闹矛盾。一下子就和解了好不好。我可不想我们常常闹矛盾。好啦。以后~不管怎么样。都不可以轻易生气唷。我都不喜欢生气/所以你更不可以生气。知道了吗？笨蛋老公。对，7夕你没有陪我~我得心里真得不好受。这样我得可以化解。那还有什么不可以化解呢？你说对吧？晚上打电话给我~记得想我—', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('772', '2000', 'Don\'tmusis??so.busy.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('773', '2000', '今天晚上.真令我失望.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('774', '2000', '今天其实是大晴天。可是想到小五就想把天气都变成有彩虹的，感觉很他们很搭~日记本变了新模样，最早以为本本就这样丢了，还觉得挺可惜的，因为这本本记录了我2005的高考岁月，纵使是天天上线，日记里哪怕就一句话也是我的回忆。现在我也要离开本土去远征了。心里又激动又恐慌的说。本本里又多了些可爱的自定义~~真是很不错呢~~今天搞了一下午终于听到了小五的新歌。说实在的听到的时候真的好感动啊~~花了几个小时终于可以听到了~那感觉由于本人笔拙形容不出来~等到8月底同学们就要更奔东西了，我也要走了。希望能和现在的同学都保持好联系，毕竟出门靠朋友哈~~现在脑子里木木的感觉可能是太兴奋可能是饿的。不过推荐大家听五月天的歌就对了``我保证你一定会喜欢的~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('775', '2000', '是我令你失望吗？我跟晓涩都坐哒那里。你自己说你跟谁说得话比较多。你一直都在跟她说话。你有没有理我阿？你要知道。你跟她撩，而不理我得时候。我得心里也很不好受乜。也许我就像疯舞说得吧。我吃醋了。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('776', '2000', '现在我也不知道该怎么说了。昨天晚上跟你说没事是假得/因为那生活晓涩就在我旁边。所以我不可能把实情说出来。昨天晚上要你去问鬼别。我说了她会告诉你得。可是你却要生气。好啦。不生气了好吧~我也不生气啦。你也不生气啦。就这样？OK？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('777', '2000', '你会不会觉得.我们两个人的爱情.就像一杯白开水.?平淡而无味..我不知道,为什么.我们的感情会淡的如此快..在一年前,我们还天天为小事吵架.虽然吵架,但是感情却.越吵越好..但是,现在却...我们都有错..但是却不知道错在哪?我们曾经说过..如果,有一天我们分开了.我们都不会哭泣..我们会快乐的分开..至少,我们曾经快乐过..至少,我们曾经拥有过..尽管,我们不能在一起永远..但是,拥有了回忆已经是最美的!那时,我们说的好轻松..但是,如果真的有那一天.我们能做的到吗?我对自己说,如果,真的有那一天..我会默默的祝福你..希望你能开心,快乐..而我,我会学着忘记你..只要,有那一段美丽的回忆..我就够了,至于能不能和你在一起.那已经不重要了..也许,不会有那一天把.但是,也说不定会有那么一天..不管会不会有..我都希望你能开心的活着..每一次,我都静静的想..我和你在一起的点点滴滴..有快乐,有伤心,有开心,有痛苦..但是,我们都熬过来..但是,为什么我们的感情却还是淡了?我好想找出原因,但是..我却无能为力..我觉得自己好无奈..为什么会这样.?以前,不管你有什么错..但是,我都抵不住..你向我认错的那一瞬间..是我的心,太软?还是,我仍然爱着你?我想,是我仍然还爱着你吧.?如果可以,我希望能重来一次..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('778', '2000', '今天过大年本应该高高兴兴的但晚饭的时候和妈的谈话使得大家都不愉快但我相信不久就会好的回到家刚坐下路打个电话来她在资阳表演现在一个在街上打不到车又人生地不熟的陪他打了好久电话直到找到网吧为止', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('779', '2000', '不要这样呀,亲爱的.老公会好心疼的,再怎么变.我还在你身边啊.和我爹地说了,被他说了两个多小时,他说的时候我快哭拉,.但是我忍的.眼泪在蕴涵.可心里早已哭的很厉害.他说给我读,不过知道这几天能不能找到人帮我搞进去读....因为他说等到人家每天就要上学拉才和他说..哎呀.可是我真的很想读书啊..刚刚看到弟弟去上学,好羡慕.我只能在家,现在对着电脑好郁闷啊.好想你..明天就是情人节.我也不知道送你什么.....也不知道我爸给不给我出去..我答应了他很多事..哟呀.我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪我爱你.猪', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('780', '2000', '我沒有事的勒.隻是有點捨不得祂們隻要袮在我的身邊就滿足勒無論如何.隻要袮姷心就行勒讀不讀到也無所謂呀.可以等到高中再讀呀!!怎么樣都支持袮的!因為伱昰我最愛的朲我在學校真的悶死啦今天第一天上課真的超想死剛進學校就卑政教佬捉褲腳哈哈.不過我醒目企企下偸走咁就無事啦.給祂們捉勒那么多次第一次逃跑噢真的倖運.誰叫祂們那么無聊囬到班.又不敢去升旗又害怕給捉到.索性不去啦還好沒有被班主任髮現.不然又死定勒今天真的又黑仔.又好材.不過第一日返學好辛苦啊.眼訓死啦.難頂啊情人節快樂噢..希望我們一起的第一個情人節能一起過哇以后的情人節都希望姷伱在噢譆譆...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('781', '2000', '静寂的夜，敲打键盘记述岁月流逝！岁月匆匆，留下的只有日记带给我们无限长思！试着写写日记，一段时间后，你会发现自己变了好多……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('782', '2000', '让你走.是该结束的时候.别再频频回首.只是不愿看你给我的承诺在别人的身上重播.虽然心也会失落.自私的爱谁也不能忍受.只求你把回忆装进你心头.让你走是我唯一能做的.纵然心也会颤抖.看著你渐渐远离的感受.我宁愿让你远走;', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('783', '2000', '刚刚从俊杰屋企翻黎来```翻到罗湖花园啊时果度啊个门已经被D管理员封佐`我好无奈`好心急`因为5系噶话要兜好大个圈先可以翻到黎屋企`我起系许好白痴好想穿过去但我好惊``系许起佐几分钟甘有个奶奶行过黎话“系物过5到啊”我话“恩”距话“甘米得咯”点知距从落面穿佐过去``哎距叫我穿`我犹豫佐一阵都系从啊度穿总落去``哎不过啊时个心好开心哎``好服我自己居然一点内疚感都没有哎`````', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('784', '2000', '今日開學la繙學果然好好玩雖然上課好辛苦而且一開學功課就勁多但喺玩開d人好玩...一樣好鬼興奮噶..今日中有個插班生添～插班生甲動作很劉華我真是好奇...譆譆不過其實果樣都喺一般般咋...廳日情人節咯都5g開心定無開心...今日有5小心比jazz攬到我...係君屋屋房門外距喺我揹后噶時候...我即刻彈開la距就粗魯感扯我件衫...今日見到距又有小小5歡喜a...嗨..5時花6時變貓豬咯....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('785', '2000', '呀哟...老婆,情人节了..4点44分起身训晤着,老婆,老婆情人节快乐.....我爱你..娶定你....我爱你..娶定你....我爱你..娶定你....我爱你..娶定你....我爱你..娶定你....我爱你..娶定你....我爱你..娶定你....我爱你..娶定你....我爱你..娶定你....我爱你..娶定你....我爱你..娶定你....我爱你..娶定你', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('786', '2000', '友谊可以升华为爱情,而爱情却从来不能回归友谊.真正爱情需要极大的包容与真诚,需要付出与托付,这是值得我们用时间来慢慢学习的.什么是爱爱是人类永恒的主题.爱是外一生一世的事,爱又有着亲请之爱,友情之爱,爱情之爱.小时侯父母长辈的无微不至的呵护,扶持着我们走过一段幸福快乐的童年-他们爱我们，我们也爱他们，是因为他们与我们之间有着一种斩不断的血缘关系，血缘的纽带连接着我们。长大了我们有了自己的天地，我们有了自己的伙伴，同志，我们互相依偎，互相呢喃，互相支持，在欢笑中度过了一段美好而值得回味的光阴-我们爱他们，是因为他们是我们的朋友，我们可以同生死共患难，我们可以互相营造一个和谐的氛围。再成熟些了，或许我们就找到了我们的和、伴侣，我们互相关怀，互相依赖，在漫漫人生的漂泊中留下美好温馨-我们相爱，是因为能够彼此带来幸福，带来喜悦，带来甜蜜，这就是爱情，纵使天荒地老，也会缠缠绵绵，忠贞不渝。人就这么一辈子，一辈子地去爱，一辈子地被爱，一生的爱相伴，一生的情相随。人类的历史上，因为有了爱，才有一丝亮色，才使那充满一路风尘的车轮不停歇。爱是无私的。若你真爱一个人，不要把他捏在手心，他不属于你，他有选择的自由。不要去试图改变他.约束他.限制他。你爱鱼，给它一池水；你爱草，给它一片沃土；你爱鸟，给它一个天空；若它爱花，请让它绽放在枝头；若你爱他，请给他以自由。爱是一种能力。有爱自己爱他人的能力。说得现实一点，首先你必须要爱自己，爱自己这个人，爱自己现在所拥有的一切，爱自己现在有做的一切。你要保证自己有适应激烈和残酷的社会竞争的能力，能够试想如果一个人连自身的生存问题都解决不了，连自己都爱不起来，又如何有能力去爱他人呢？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('787', '2000', '好郁闷啊！！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('788', '2000', '今天是我第一回这么迷惘昨天参加了考试拿到成绩自己都惊呆了很显然太差了在爸面前也不好说本来我爸就不主张我读高中这下看到成绩更别说了而现在的问题是如果不读高中我该走哪条路到底以后做什么现在该读什么专业爸和小叔主张我继续学医但是我一点都不感兴趣好茫然', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('789', '2000', '今天很討厭情人節沒有情人我沒有覺得不開心不開心的是幹么送巧尅力給我...我覺得超不好意思而且好像很辜負的樣子超討厭～～一天都很無奈感覺上好像欠他好多...不過今天他一天都在炫燿我又收到多少多少巧尅力討厭討厭討厭....什么嘛...知道妳多人喜歡也不用這樣炫燿吧...厭惡...放學時看到大街上都是情侶煩人...而且今天功課超多揹書揹書又是揹書煩吖......今天我不開心....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('790', '2000', '今天是情人节悲伤孤独的情人节有情人可是却不能和他一起过这种心情真的好难受在这样的节日里我不想说太多因为心真的太痛了过完了今天明天的日子照样还得过和他也许这次真的就这样了断了，碎了，醒了，爱了，恨了后悔过了所以一切也该放手了梦醒了，泪流了也是该重新来过了这个情人节就这样孤孤单单的过了哎！2006.2.14', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('791', '2000', '《亲爱的我是善意的谎言》=#0000ff]亲爱的；我不是有心要骗你的`我在的你不叫我在外面呆着``怕你生气所以我才`说我回家拉```呵呵这是善意的骗局`别生气拉``我现在有种和幸福的感觉`和你在一起我每天过的都很开心`很愉快```你呢```我说我是你最信赖的人``是真的不是骗你的。知道吗？我骗你的话我会给你说的知道不？小孩``叫老公亲下[/color]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('792', '2000', '今日係情人節真係好傷心.好傷心一個人傻傻hihi甘坐係度髮儍一個人坐係度髮儍等到佢來都好la一個鍾.兩個鍾甘過佐.伱兜係無黎.雅芳話.見到我係度等甘耐.好心痛.有么心唔心痛.等伱又在乎d么.我地尋日講好嘎但係今日就...艾.平生第一次等人等甘耐真的.好傷心.我打算上網找伱但第一次去的時候見到霞從網巴岀祂說伱沒有上我又囬去原地等伱見到康康.我問祂有沒有見到伱祂說四點的時候見到伱而伱是怎么根我說的我不管伱去勒哪裏.伱就不能來告訴我一聲嗎坐在那裏.走在路上看到一對對情侶真的很倖福而我隻能一個呆坐在那裏等不會來的人.后來我又再失望地走去網巴想等伱上.再一起岀來但是伱到我走還沒有上真的很失望,,我走岀網巴還是決定再囬去看看最后還是沒有隻好坐車囬傢在路上看到亞國.真的在汕尾囬來陪條囡過情人節勒.祂條女也和我一樣一直在那裏等而祂等到啦.我還是一個人失落地走.今日真係超級黑仔啦手機又卑班主任收佐有排唔得摞啦伱還在怪我沒有接妳電話我不想嘛.?伱要知道我在等伱一直在想些什么嘛真的很傷心...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('793', '2000', '当你站在你爱的人面前,你的心跳会加速；当你与你爱的人四目交投,你会害羞;但当你站在你喜欢的人面前,你只感到开心；但当你与你喜欢的人四目交投,你只会微笑.当你与你爱的人对话,你觉得难以启齿；当你爱的人哭,你会陪她一起哭;但当你和你喜欢的人对话,你可以畅所欲言；但当你喜欢的人哭,你会技巧的安慰她.当你不想再爱一个人,你要闭上眼睛并忍着泪水；当你不想再喜欢一个人,你只要掩住双耳!喜欢，是一种心情；爱，是一种感情；喜欢，是一种直觉；爱，是一种感觉。喜欢，可以停止；爱，没有休止。喜欢一个人，特别自然；爱一个人，特别坦然。喜欢一个人，有时候盼和他在一起；爱一个人，有时候怕和他在一起。喜欢一个人，不停的和他争执；爱一个人，不停的为他付出。喜欢一个人，希望他可以随时找到自己；爱一个人，希望可以随时找到他。喜欢一个人，总是为他而笑；爱一个人，总是为他而哭。喜欢，是执着；爱，是值得。喜欢就是喜欢，很简单；爱就是爱，很复杂。喜欢你，却不一定爱你；爱你，就一定很喜欢你。其实，喜欢和爱仅一步之遥但，想要迈这一步就看你是喜欢迈这一步还是爱迈这一步情人节快乐~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('794', '2000', '今日系情人节``同平时无物5同`曾经有一段时间好想拍拖不过5知点解今日突然间5想啦可能呢次我真系生性佐但我都无人要噶啦呵呵``睇开点一个人噶世界同样精彩``我对自己有信心`我会过得好好而且比以前好好多我会努力读书不会乱霖野我觉得呢个情人节我懂事佐d过多几日就系我旧历噶生日啦呵呵系下星期一希望我可以好开心```', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('795', '2000', '...不要生气喇，我知道我自己错了.原谅我好吗?今日早上吓死我拉.我3点几起身,开佐q你挂系度.我就去度你屋企楼下等你返学,到5点多..3个警察过来问我在干什么.我说等老婆吓死我拉,我的样子怎么看也不想坏人还差点叫我去派出所....无奈到6点多,我看到个人拉了只狗出来.我一看.好面熟...喔.是你妈.我记得我之前见过..她狂看我.还拉着狗狗..我最怕狗,我就闪开一点.再过了一阵.她走过来问我,你在这里我觉得她来势凶凶.吓死我拉.不知道怎么回答..就说等人.我问她什么事.嘻嘻..我看我好象不怕她的样子就走了.我马上转身就走....哎>!>!!吓死我拉哟呀..今天等不到你..好失望啊,,对不起呀,猪..不要生气好吗?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('796', '2000', '我为什么要提散.你知道我要用多少的力才把这个字打出来.我知道说出来.你肯定会乱想,但是.我就是觉得你跟跟一起很辛苦.我不要你难受.你知道吗?我知道你唔开心,我先唔敢打搅你.我好惊你同我散.之前几日仲好地地.点解转变会甘大.我真系承受唔度.我依家好烦.但系我都忍.我好惊我同你讲讲吓.发脾气如果我地真系甘容易散.我真系好失望.我晤想我同你讲过既野变成废话,(非你不娶)呵呵.我笑不出我现在就跟你说..我很伤心...我不知道才能变成以前那样.你对我太没信心拉.我哩几日晤想出现.我很没用.对不起但是我没有放弃你一定不会.み.苯豬&!(2006-02-1513:51:05)噢噢.!我唔知道伱係咪想散.!兜唔知道伱唸么.伱今日同我講到散.呢個字.我好傷心我甘講.可能係我呢兩日真係好唔開心啊.伱知唔知啊無人可以聽我講同佢地講.個個隻話伱本性難以.我唔想聽到佢地甘講伱因為伱應承過我.伱會改!我同佢地講.妳會改嘎.我相信伱.我信伱可以做到.我無唸過放棄.但伱今日甘同我講.我真係好唔開心.我已經無野講啦今日早上.伱甘.我覺得伱有心同我道歉嘎但係.伱下午講嘎呢d.我唔知道點解我唔想放棄.可能係我語氣有d么.sorry啦.唔好擺係心度啦.我愛嘎係伱.伱唔係唔知道我係唔會輕易放棄嘎.除非伱唔要我.我要返學啦.!!..自甘堕落等我出现', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('797', '2000', '.依家系学校住宿.每日都无无聊聊.!放学得闲就去下网吧.去下浸温泉.再晤系就抓住电单车去飚下.!究竟系有意思.定无意思.!!!7点钟再准时返去晚修.!静静甘.好似与人事间隔绝!呵呵.!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('798', '2000', '今日早上早餐係屮麵買因為尋晚夜訓所以賴牀到6：30不過本來都無諗住煮好享受訓多陣噶舒服...今日揹書都算順利咯misswang無比個四人樣睇總算斷斷續續感搞掂咯...然后今日又做完數學功課咯都算幾有自豪感因為自己都明白...認真學習噶感覺都5錯因為中午訓左教教...所以下午有精神可以認真聽課...今日感覺良好...喜歡簡單噶感覺', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('799', '2000', '唉.為什么會這樣.!~我真的搞不懂是什么事情弄到什么兜變勒似的是伱還是我.??不知道.!!怎么也好.我是愛妳的.伱要知道再怎么.我兜把伱說的放在心上直到伱說伱不愛我我就會離開.不然我是不會離開得今天.2月15日..我看到伱說的那句話感覺伱要走啦.不在我身邊勒我不知道伱是想那樣還是怎么樣我佷想知道.我也不知道伱是不是不喜歡我勒我不想亂猜想些什么我知道沒有用的真的不想盡頭就在眼前不想不想.就是不想我跟伱一起.不是覺得辛苦我隻要伱好好地愛我就夠勒伱覺得跟我說散我會好過但伱有沒有想過跟伱散我真的會好過嗎我真的隻想好好地愛不要岀差錯伱說的.我相信.但伱不要讓我失望我不想每天猜想伱.兩個人一起最重要的是信任對方所以我每每兜想信任伱我不是對伱沒有信心我說過.怎么樣都會支持伱的因為我最愛的是妳我也許隻是這輛天沒有心情所以這樣昨天的情人節是我們一起的第一個情人節雖然沒有一起過但我想起我們說過的已經佷開心等伱等那么久.換來是我想要的也滿足看到伱第二天這樣子我佷想見到伱但我知道我要上學知道傢裏人的看管佷少能見到伱但我心裏還是隻有伱一個我沒有想過放棄伱如果我想放棄伱.那可能佷早就已經這么做勒但我想維持這份愛想有伱在我的世界裏想每天兜能聽伱告訴我的伱消息想看到伱改變之后的伱想伱說到的話兜能做到這些要求不會過分吧.???我看到伱在日記上說的伱又怎么啦不要再這種脾氣行嗎伱說伱要改伱又來髮脾氣又自甘墮落又玩失蹤...............我真的擔心伱每次跟伱吵架伱都會這樣.我真的佷無奈阿但伱不要這樣勒行不行.??伱答應我什么的.說改脾氣的.現在又是這樣子勒.隻要伱沒有真的說岀口我不會放棄伱也沒有想過放棄伱如果伱說勒.我會認命的可以的話..請伱畱下我隻想告訴伱我是佷愛妳我沒有想過放棄伱更沒有想過離開伱因為說好勒的.我非妳不嫁永遠最愛伱的..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('800', '2000', '欽.伱不是說要讀書的嘛伱怎么突然會想放棄.?怎么那么輕易的放棄呢.?不要因為心情不好讀書可以嘛不要象以前那樣.一錯再錯勒我看到伱可以改.佷開心但聽到伱想要放棄讀書我佷不開心即使怎么樣我兜會支持伱伱哥說.叫伱囬去就算伱囬去勒我也願意等伱.隻要伱心還有我等伱等到什么時候兜願意我不怕等伱.隻要伱肯改隻要伱肯炤伱哥說的我佷願意等伱的不要放棄讀書可以嘛我對伱期望佷大的別讓我失望.....我知道等待可能是痛苦的事但我等的是我愛的人我願意願意選擇等待妳真的.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('801', '2000', '天又下雨了是春雨仿佛比以往来得早些今天晚上舅舅和舅妈把我和哥哥叫出去吃东西我以为要把我们训一顿但出乎我意料的是他们不但没给我们说什么大道理反而和我们谈得很融洽从舅舅的谈吐还有平时各方面看舅舅真的是个很伟大的人我开始崇拜他了舅舅是黑社会上的人而且是个老大他告戒我们要走好自己的每一步不要占毒品还有为人处事的道理好多好多现在我的下一步是选择自己的路并且选择过后要努力完成不让父母失望同样也不让舅舅失望', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('802', '2000', '这篇爱已成往事是我在一个网站上看到的，希望可以供所以曾经有过失恋的朋友欣赏，因为我和他的爱情也成了回忆悲伤的回忆。。。。。。。。。。。和阿微不曾相识，谈不上认识，但实际上，我们却早已是未曾谋面的“熟人”，确切点说，她和我有一个共同的朋友，“阿微有一双咖啡似的眼睛。”朋友不经意的一句话，引起了我的好奇，不久便产生了一个强烈的冲动，想要和这个有故事的女孩畅快地聊聊。朋友说她时常在阿微面前说起我，对于我，阿微也并不排斥，也就很爽快地答应了我的采访要求。　　在一个阳光不炽烈的下午，我终于见到了这个带给我很多好奇的女孩。她住的地方比较偏僻，我费力找了一阵子，最终才找到。那是一个外表看起来很土的平房，但门却很宽，屋外的墙皮像皮肤病患者身上的牛皮癣一样，让人看了心里不由得生出难受来。敲了门，里面没有应答，再敲，没有我期待的结果。我稍稍有一点失望，她悔约！？正在我疑惑不解之际，肩上被人轻拍了一下，我本能地回头，虽然之前我们并没有见过面，直觉告诉我面前的女孩就是我要找的人。对她来讲，我也是一样。　　她有些气喘吁吁，显然是跑过来的，见我一脸诧异，她一手插腰，一手拍着自己起伏的胸口，很有些口渴似的，连连说到：“不好意思，不好意思，我来迟了，你久等了……”我正想表示我也是刚到，她不必太在意，话还没有到嘴边，她已经冲上一步，麻利地掏出钥匙开了门。　　这间屋子很小，除了一扇门以外，四周找不到一扇窗户，要开着灯才能将里面的陈设看得清楚：左手边放了一张半旧的沙发，一个小型的茶几，有两张矮矮的小凳子，这样的搭配让我感到十分别扭，我无论如何体会不到现代与传统结合的美感，但我可以理解，也许这就是阿微吧；往前的屋角是一个水池，旁边放置着一个盆架，再过来，是厨房了，煤气炉，案板，小橱柜，锅碗瓢盆，应有尽有；右手边紧挨着墙是一张很低的单人床，白色的床单，白色的被套，白色的枕头，在昏暗的灯光下，越发白净了。我正在打量着，阿微端着一杯水给我，“你坐沙发，我坐凳子。”我很“顺从”地坐到了沙发上。　　递给我水杯，她双手摸摸自己的脸，笑了，“突然有点事，占了时间，又怕你等久了，所以跑回来。脸很红，很难看吧？呵呵，凉一会儿就好了。”好像她并不是在问我，因为我已经没有必要回答了。“你很漂亮。”“很多人这么说。”声音中没有骄傲，反而多的是不屑，我并不感到多么奇怪。阿微有一双大眼，眼神里有着闪亮的光彩，很有灵气，但又包含了几丝不易觉察的忧伤，几许沧桑，几分温柔，那分明就是一只受惊的小鹿的眼睛啊！我极力想要看穿那双眼睛里深藏的东西，但却根本做不到。我从来都坚信：世界上每个人的眼睛都是独一无二的，那里包藏着许多的故事。朋友那句“咖啡似的眼睛”，我认为并不准确。　　“你想知道什么？”阿微看着我，微笑着问。“你的过去，你的现在。”我不想躲躲闪闪，那对幽幽的眼睛告诉我，她想知道我真实的想法。我知道这几个字说出之后，以下的不用我再多问什么了。　　一个没有温暖的家　　我不是本地人，老家在陕南，一个依山傍水的地方，那里很美。　　我父亲从小没读过几天书，没什么文化，人很直，也没什么本事。自我懂事起，就知道他脾气不好，经常莫名其妙地发火，家里凡是能拿来摔的，他随手抓过来，就扔得老远。那时我虽然还小，但你知道吗？小孩子有小孩子的聪明，每次见他生气摔东西，我都会乖乖地跑过去，把那些受虐的家具拾回来，将就能用的，就摆回原位，尽量让他消气。可以说，我的童年整天都活在担惊受怕里，别人家小孩被父亲宠着、爱着，当时的我却不明白为什么我的父亲却是那样。稍稍长大了，父亲的脾气没有一点变好，在外面受了气，找不到挣钱的门路，都回家出气。我和母亲就成了他的出气筒。我的两只耳朵曾经先后裂开过四次，是他生气时狠命撕开的。　　记得一个夏天的晚上，白天玩累了，我早已睡去，忽然被一阵骂声吵醒。我害怕极了，趴在门缝，看到屋外的一切，顿时我的眼泪就倾泻而出。母亲在洗碗，父亲操起一把椅子直直朝着母亲的身上扔去，一声痛苦的喊叫，母亲倒在地上，旁边是折了一只腿的椅子。我吓傻了，张大嘴，却叫不出来，眼泪不住地涌出，流进嘴里，那时我知道泪水是有味道的，又咸又涩。母亲在床上躺了一个多星期，那几天经常对我说的是“还不如死了算了，还不如死了算了。”我不知道死是什么，但却知道恐惧。　　母亲从那以后就精神失常了。经常在被噩梦惊醒后，我翻身寻找母亲的怀抱，伸手一摸，身边是空空的，她在哪里？　　后来，我听邻居们议论纷纷，说母亲是夜游魂，是晚上跑出来吓人的。我恨他们，恨他们这样说母亲。我使坏用针刺破他们停放在外面的自行车车胎，或者在他们家门口泼脏水。我知道什么叫报复，看着他们个个生气的模样，我心里别提有多高兴，竟然体会到一种从来没有过的快感。　　因无钱医治，父亲也没有这个心，母亲的病越来越严重。有一次做饭烧火时她犯病了，我在里屋闻到一股刺鼻的味道，奔出来，顿时我惊呆了：母亲躺在地上，口吐血沫，全身抽搐，烧红的火钳正烫在她的右手手背上……你知道我当时有多么痛心吗？烧在母亲手上也烫在我的心上。几秒钟的呆立，我才从惊愕中醒来。我冲过去，抽掉火钳，掰开她的嘴，把自己的胳膊放进母亲的嘴里。我哭了，她咬自己的舌头竟不能自己，被火烫到竟毫无知觉，她的命怎么那么苦！　　那时你几岁了？我很想知道答案的一个问题。我内心想，一个幼小的心灵如何就能承受那么多苦痛？我实在也不愿相信阿微所说的真正就发生在她的身上。阿微的眼泪在倾泻，我知道，那是为母亲！回忆自己的这段童年往事，她好像很害怕，坐在凳子上，双手箍成一个环绕在双腿上，好像要为自己圈上一个保护圈，把所有恐怖的东西都挡在外面。突然间，我觉得自己很残忍，很无情地揭开她尚未愈合的伤疤。我什么话也说不出来，只能静静地等待，等待她从记忆的悲痛中回到现实。　　那时我很小，还没有开始上学。我一直觉得自己很小就已经长大，我看不惯周围其他的孩子，他们在父母怀里撒娇，我就莫名的生气。渐渐地，我不和其他小孩玩耍，只喜欢自己一个人跑到河边，看着水里的小鱼、飘悠悠的水草发呆。母亲的病拖了几年，她经常一连几个星期不回家，父亲从来不去找。一开始，我会蹲在门口，望着远方，流着眼泪，喊着：“妈，妈，你回来啊。”这样一蹲就是一天。　　突然一天，母亲回来了，头发松散着，脸上沾满污秽。其实，母亲很好看，很慈祥。我给她梳头，洗脸，我多想她用温暖的手抚摩我的小手，对我说，“阿微，我的好孩子。”可是镜子里的她只是呆呆地，眼神空得可怕，看不到温暖，看不到悲伤，没有怨也没有恨，就是呆呆的。当然，这是我长大后在回忆里看到母亲的那双眼时感受到的。你可能想象不到，母亲那双眼深深烙在我的心上，直到现在想起来，都清晰得可怕。　　母亲经常走了回，回了又走，这样反复着。家里整日空荡荡的，我也渐渐习惯了。　　也许接下来的日子太苦涩吧，阿微只是简简单单提了一下，她说不想说。我也不忍心勉强她。阿微的母亲在一次离家出走之后，就再也没回来；父亲还是以前那个样子，她想读书，父亲怕花钱，说女孩读书没什么用，在亲戚的劝说下，父亲终于同意让她进学校了。在学校的时间是她最开心的，她很聪明，学习很上进，老师经常在班里表扬她。她说小学二年级一次中考她考了全班第一，父亲格外高兴，她趁机要父亲给她买一本成语词典，父亲真的买给她，那是至今惟一一次父亲带给她的感动。母亲出走之后，她自己学会了做饭，学会了操持家里的一切。为了凑那十几块钱的学费，她捡过破烂；做过小贩；当过临时工，小学就这样艰难的走过了。　　被亲生父母无情地抛弃　　阿微不愿意过多提起她小时候一些事，但即使是那些轻描淡写的故事梗概，也让我对眼前这位20出头的女孩所经历的沧桑感到心酸。在我的周围，可以听到很多人不时生出一些惆怅：人为什么要长大，长大就意味着无尽的烦恼，回忆起来，还是小时候的时光最美，可惜走过了就再也不能重复。虽然阿微的童年是一段铺满荆棘的路，但阿微说像很多人一样，她同样怀念那段日子，那里留下了太多太多她成长的足迹。　　在阿微尽力调整她的情绪时，我突然想起一句话来：成长是一种切肤的痛，痛多了，自然就长大了。令我吃惊的是，阿微还承受了更巨大的痛。　　小的时候，周围很多人夸我长得漂亮，说我的大眼睛好看，我很高兴。但很偶然的一次，我听他们说我眼睛大有神，是因为自小喝了羊奶，打一出娘胎，就靠羊奶喂养，我不是父母亲生的，是亲生父母狠心抛弃了我！我一听，十分气愤，骂他们胡说。我怎么可能不是父母亲生？一定不是真的！我气不过，跑到奶奶那里，我语气很不好地问，奶奶，我是不是捡回来的？奶奶很吃惊得看着我，好久都没有说话，我全不顾尊重长辈，大声吼着，是不是？奶奶？你说啊？这时奶奶哭了，我看见两行老泪从她爬满皱纹的脸上滑落，她还没有开口，我也哭了。　　阿微讲述这段是流着泪讲的，她说，奶奶扭她不过，把真相告诉了她。奶奶说，有一年冬天，雪下得紧，地上落了很厚的一层，她出门扫雪，门口有一个包袱，她抱回来打开，一看，吃了一惊，里面是一个婴儿！天寒地冻，小家伙被冻得奄奄一息，是奶奶找来医生，才有了阿微这条命。后来才知道，阿微是附近一户人家的刚生女儿，家里已经有了一个女孩，一直想要一个宝贝儿子，就不要阿微了。知道这件事的人说阿微命硬，父母不想要她，掐她，她活过来了；用被子捂她，她仍旧活着，放在冰冷的地上，她还是挺过来了。奶奶可怜她，就让她当了大儿子的女儿了。阿微就成了养父母惟一的孩子。　　听了奶奶亲口告诉我的话，我呆在那里，不哭了，也不吵了，脑子里惟一还在活跃着的是———我不是亲生的，我被亲生父母抛弃了，我被抛弃了！那时我十二岁，我没什么理智，心里一直在恨，在怨，几次想找上亲生父母的门，去亲口问问他们为什么对我那么残忍，那么狠心，我又很怕，怕他们把我哄出门。我没有那个勇气。我不知道该怎么办，奶奶说，这里的父母都养你这么大了，你咋能走出这个家门？再说，你妈走了这么久，现在家里只有你爸，他对你再不好，也把你养了这么大，那边父母扔了你，就再也不会要你回去了，你就认了吧。奶奶的这句话实实在在刺痛了我，难道那真是我的命吗？我不知道还能干什么，也不知道该干什么，我只感觉很无助，没有人能帮我，没有人。你知道吗，父亲打我骂我，我可以忍受；母亲生病出走，那个家不像家，我伤心但不惶恐，那些我都可以面对，但惟独这个事实真正摧垮了我，从来没有的无助和彷徨罩住了我。我很害怕回家，家里的冷清和寂静会将我逼疯的。虽然我从内心感激收养我的奶奶和养父母，最后我还是选择了离开那里。　　你在逃避。对于她的离开，我很无情地给了一个评价。也许你说得没错，我是在逃避，但我认为这是脱离痛苦最好的一个办法。我很想知道，换了你，你会作出什么选择？阿微没有和我抬杠的意思，听得出来，她是在很认真的问我。　　她这句竟然让我无语，一时竟不知道该怎样回答。也许她说得对，不逃避，还能有最好的办法吗？有人说，想要忘记一个地方，最好的办法就是去一个新的地方；想要忘记一些事，最好就去经历另外的事。但是，这真的可以吗？我在怀疑。阿微不是在几年之后，也走了那么多地方，曾经的记忆一经开锁，还是一件一件浮现出来了？我想，经历只要在心里划下了痕迹，再去抹平已是不可能的了。　　初中勉勉强强读完了，阿微也带着一身伤痛离开了。她说她是在春节时离开的，那个大年三十晚上，最后一顿年夜饭，她和养父吃了饺子，看着老父苍老的脸庞，她哭了，不知道为什么。曾经对他的怨恨，对他的畏惧，在那一时全都不见了，她只觉得坐在她面前的是一位苍老的、悲哀的老人！但却不是父亲！狠下心，过不了几天，她就和同伴搭上了北上的火车……　　阿微在外“流浪”的几年，我很想知道她是怎么走过来的，可是她说得很平淡，脸上一副历尽沧桑之后的淡然。她说先到北京，经朋友介绍，当过保姆，没赚什么钱，但还是有口饭吃；后来，自己在街头摆了小摊，卖爆米花，少不更事，不懂得怎么做买卖，赔了个血本无归；再后来，幸运的是，她同伴给她介绍了一家小餐馆里当服务生，那种日子用辛苦二字是不足以形容的，每天站十个小时以上，每月两天假，人手不够，生了病也得挺着，日子没有变化，重复地过着，两年过去了，她终于赚得一点积蓄，但跟着她一起的还有全身的病痛。她说，“小时候，我就给人说命硬，父母那样对我，我不是没遂他们的愿吗；可能真是命里注定的，否则在北京的时候，要死可能早就死了。”记得她说过，小时“不知道死是什么，但知道恐惧”；现在知道死是什么了，但那恐惧却在她心里“死了”。这是阿微的幸？还是悲？我不知道。　　2002年我和朋友一起南下到了广州，当过清洁工，做过擦鞋的，也曾是发廊里的洗头妹，还做了两个月的加油工。我没有权利选择，哪里有活干，我就跑向哪里。　　就在她说这句话的同时，我脑海里出现了一个悲戚的镜头：冷冷的秋风里，一片枯黄的落叶在四处飘零，忽上忽下，跌跌撞撞，等到重新和地面接触，已是满身伤痕！这个镜头曾让我无限感慨，久久不能释怀，总执著地认为那简单的飘落里暗藏着一种宿命的哲理，现在，眼前的阿微就是那片落叶，在无奈中实践那个宿命。　　去年3月份，朋友去了云南，我也不想在广州呆下去了，就到了佛山。很幸运，不过几天，我就找到工作，一直干到现在。有了一点钱，租了这小屋，有了自己的家。　　说到了小屋，我又不由自主的环视了一下，是啊，谁说这个“鸽笼”般的陋室不是一个家呢？问阿微今后的打算，她说害怕了四处漂泊、没有根的日子，以后想呆在这里。可能的话，等有了资本，就自己开一家小店；如果碰到有缘人，就嫁了。　　如果？！人们对未来的憧憬总是充满了太多的“如果”，这无法叫人感到心里踏实；但看到阿微溢满希望的眼神，我由衷的为她祝福；愿你所有的“如果”能美梦成真！2004-05-10心情热线：　拨这个电话，有人倾听你的故事下一篇：伤痕累累穿过青春丛林发表评论：网友呢称：　　匿名发表　　请您注意：·请遵守《互联网电子公告服务管理规定》2006.2.16', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('803', '2000', '老公..伱係邊度呀.我好想伱啊唔好甘喇..咪自甘墮落勒.我唔想伱甘啊努力啊.無論點我都支持伱嘎我好想見到伱啊伱係邊度呀.,在哪裏在哪裏在哪裏在哪裏在哪裏在哪裏在哪裏在哪裏在哪裏在哪裏我想伱喇....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('804', '2000', '\"琴晚.无无聊聊.兜下兜下竟然唔想返去学校住宿.!睇住个天.真系好靓好靓.!.到佐凌晨果阵.见到D雾.!系好浪漫好浪漫.但系.!觉得好心酸.!小慧同我讲.距同小贝依家都好幸福.我真系好开心好开心.!小慧仲话\"\"你也要幸福哟.!\"\"我会的.!我会努力的.!我现在觉得每天都过的很开心.!在这里我也有我的朋友.!!但我永远不会忘记你们.!!贝.慧.婷.!\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('805', '2000', '爱过你,是你教会我怎么来爱,也是你教会我怎么放弃!开始说分手的时候不知道自己怎么来忘记,傻傻的希望你会回到我的身边.现在才知道我错老,不爱就要放手,我们没有对错,没有成败~!爱过你,是你教会我要珍惜什么,应该珍惜什么~!记得自己爱着你是时候,我们都在耍着性子,没有看见对方失望的眼神与无赖.为了证明自己是爱你的,而做着自己不喜欢做的事没还傻傻的以为这就是珍惜原来我错了!爱过你,所以谢谢你~!我知道，有一些诺言不能实现，也知道，你不会一直在我身边。我知道，有一些结局无法改变，也知道，从来就没有什么永远。当你说，你已不再爱我，我的心不知怎么，竟无法将你埋怨当你说，就这样分手，爱已到了尽头，我的话不知怎么，就变成再见。当你和爱情，一步一步，走出我的生命.我知道我在长大~也已知道我已经能够说放弃~!经过你才知道我要的是什么~!爱过,爱过!不再有什么遗憾!就这样说再见了!爱过你,所以谢谢你!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('806', '2000', '下午来到学校，提了好多的东西咯！累死我哒。一下车就看见玉琴和阿芳，她们帮我提了些东西，这轻松多了。可是心情却还还是沉甸甸滴！虽然说好了忘记他，可是心理想的人还是他。没来学校之前对他的想念还少点，可是回到了学校。心也随着思念起他了。好久没有他的电话他的短信了。虽然从朋友口出听到了他的许多不是，可是为什么自己还是恨不起他呢？也不知道他现在是在家还是去广州了，真的好希望可以听到关于他现在的处境。难道对他的爱已经到了所谓的极限了吗？心理的感觉真坏坏的，一面希望和他就这样算了，可是一面又在祈祷可以和他继续下去。矛盾心情折磨着我的身心，让我感觉自己的身心好疲惫，甚至有点窒息的感觉了。xxx你可以告诉我到底该怎么做吗？这种坏感觉何时才可以消失呢？2.16', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('808', '2000', '你假装不看我像不认识我擦肩而过了所以我心一下疼了泪一下落了彷佛全世界只剩我一个到处都是冷漠只剩我一个谁还懂我在唱什么你说过每一天你都会陪着我我们牵过手紧紧拥抱过你骗我如果我做错什么让你伤心了用力惩罚我怎样都好过不理我', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('809', '2000', '我爱他.真的.不知道从什么时候开始的.但我知道,我到现在还是放不下.不能释怀.也许是我觉得心里不平衡,而并不是爱.可是,如果不是爱,为什么我会时常想起以前的开心,以前的细节.今天又看到我们以前的大头贴,心里突然一阵阵的,痛ing.我不想的,可是这种事,是理智可以控制的吗?算了,我们迟早会过去.我也不要再不甘心了.有些事并不是想象中那么美好.承诺仅仅代表那一秒.这个世界真残酷.也许就是无缘吧.不该做的一直做,该说的却没有说.有时候会有一些傻傻的想法.我不会去做的.毕竟,自己知道.我出的洋相已经够多了.我累了.心累了.是啊,我懂了.那又怎样.此情可待成追忆,只是当时已惘然.是恨吗?似乎不是的,可又算爱吗?为什么爱的时候没有失去的时候这种感觉呢?真爱是这样的么?我还是自己骗了自己.别人看不懂我的悲伤.那么深,那么虚伪.那么的不纯粹.我到底在悲伤什么呢?不明了…..也许只是在孤单的时候想要一个人陪.可是不孤单的时候我把他放在哪里呢?我对他大概就是这样的,所以,在他孤单的时候他想起了Lucy.这便是爱的最初.说实在的,还是听喆的歌比较有感觉,我也不知道为什么.他的词,他的曲是那么的适合我的心.这个旋律是让我共鸣的.无法解释.只是觉得相逢很晚.这是遗憾的美么?爱他之后,才爱喆...他们,我都不能释怀.可能只是我心里没底了,可能只是以前被宠惯了.突然感觉自己一个人,很不习惯...是这样的吗?谁给我答案?生活中有很多事,让我想起以前的点点滴滴.毕竟一年多了.不好忘记.可能毕业之后会好一些.我不想遇见任何一个人在新的班上.我本来就是懦弱的人,我喜欢逃避,害怕面对.所以我现在拼命的拼命想要逃,逃开这很孤独的生活.我永远记得这个.520烟.其实我把那个烟盒弄丢了.是故意的.可惜吗?是命吧.冥冥之中的安排.这就是我不懂珍惜的罪证.我也曾经把手指轻轻在空气中晃动.你能感觉到吗?我知道答案.可是我宁愿相信,你知道.你知道我在想你.可是你会想我吗?不会吧?你我的伤心又怎么能相提并论呢?人都是自私的,所以你自私的走了.把我丢下.丢在雨里,再也没有回头.你说爱我,以前信,现在不信了.我对自己说爱你.以前不信,现在信了.我们错过了.也好.佛说:前500世的擦肩,才换今生一次回眸.我们这样的相遇.这样的错过.你可知是前几万世的擦肩修来的?只是,我还是觉得太突然,应该多修几世,就不会错过了.如果还有机会.你愿意再修几万世吗?我,不愿意.你知道原因.别了.真的要别了.以后,不希望在街上遇见你.也不希望在学校遇见你.我害怕面对.我习惯了逃避.永远的逃避.我是一个懦弱的人.一直都是.表面的东西,太虚伪了.我一直很喜欢的你的保护,所以我一直喜欢你对我用命令的口吻.其实,我就是一个小女人.很脆弱…很脆弱….只是太虚伪了.如果我有勇气面对.又怎会落得如此下场.真是可笑.活该.想抱抱,想蹭蹭,想亲亲.很难释怀.也许快乐就是痛苦的使者.不知道是你先不爱了.还是我先不爱.还是我们一直没爱过.我不知道这算什么?游戏?还是两个寂寞的心互相安慰而已.原来.感情是这样的.这样的不可理喻.算了.快要到结束的时候了.永远的结束.再也不要去赎这罪过.这都是我的罪过.对你,对她们.这些表面的东西.都是装出来的快乐.就当是拿我的灵魂赎我的罪好了.上帝啊.你会宽恕我么?如果不会,为何你又在我穷途末路的时候给我一点小小的希望.或许,你只是在耍我.有一种笑,未必快乐.有一种哭,未必心痛有种感觉,欲哭无泪..我知道,说再见不难.难的是,说完再见之后.要控制自己,不再想念.不再挣扎.不再心痛.Thankyou.Kissbye不要忘记了.宝宝.崽崽.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('810', '2000', '我自问不是一个肤浅的人.第一次的爱恋,不可能那么容易忘记.但我又能怎样.这个世界就是这样的残酷的对待我们.让我们遍体鳞伤.哭过了,伤过了.后悔过了.但幸福一样那么遥远.我是在很脆弱,很孤独.很想逃.朋友这个词,我已经快要忘记了.还是小时候的感觉比较美,一直可以维持到现在.可是现在地感情,却是那么地虚伪,那么地遥不可及.我失望了,跟我想象的相差太远太远.我看错了这世界,我不怪谁.怪只怪我自己,在这不真实的社会活的太真实.投入太多感情.最后只能放下所有的尊严来补偿,去道歉.但是没人原谅,没人在乎,没有了解.是我该死,还是世人冷酷?不去争执了.本来就是错.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('811', '2000', '爲什麽你這麽喜歡動不動就吵架?爲什麽錒?唉.!每次都要因爲一點小事就吵!爲什麽每次都要不先搞清楚狀況就說是我不對!我對你不在乎!到現在你還是不相信我,兩個人在一起不是應該互信任的麽?可是你呢.?從來就只會懷疑我!什麽時候相信過我了!難道我就這麽不值得你信任麽??對什麽都失望透了!什麽都是假的!這世上到底還有什麽值得讓我活下去的??希望越大失望越大..!生病了!!如果能病死那就好了!今天真的很不開心..!很想出去玩..很想很想!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('812', '2000', '老婆``对不起```我不是故意想吵架的```我真的不是```更不是什么不相信你```别这样了``你这样我好难过的``好舍不得```别这样了``我们以后别再吵架了````好吗```陪我开开心心的走完最后的一个月```好么```老婆`min``', '}, 0);', '}', '');
INSERT INTO `dede_addonarticle` VALUES ('813', '2000', '-----献给所有得到过所爱却又失去所爱的人；给从未得到所爱的人；给因为仍旧爱着，于是选择自欺欺人的人。这，是一面镜子，勇敢面对，勇敢放弃，勇敢重新开始。当他不爱你的时候，无论过去他是否爱过后来却忘了，又或者是否是从未爱过。当你无法成为他心里的那个人的时候，他的心便不会记得你。虽然他知道你深爱他，但他宁可选择装作是不知道。当他不爱你的时候，请不要在你不开心，或者是遇到麻烦而彷徨的时候去打搅他。他那儿绝对不是你此刻应该的去处。也许他会在接到你的电话的时候，淡淡地安慰你几句，却也仅此而已。也许你会再想要一点什么，于是说：“我们见面吧。”而他肯定心有烦躁当他不爱你的时候，你的爱，你的人，就会显得廉价许多。你占了下风，这是人的本性。他会说：“好，不过我现在有点事情。晚点的时候你再给我电话吧。或者我给你电话也可以。”而你这时千万不要当真，他只是找了个不是很高明的理由来搪塞你。请，不要真的去等，不要骗自己。当他不爱你的时候，请不要与他讲你的琐事，也许此刻，你不过是希望让彼此更熟悉一些。只是，他却无暇更是没有兴趣去了解你，你的生活，你的过去，你的长处短处与他又何干？即使讲了。他也很快会忘记的，就如他忘记你的生日，你的地址，你的电话一样。没有爱，于是你注定挤不进他的生命。即使，你要的哪怕只是一个很小很小的角落。当他不爱你的时候，请不要在他的面前流眼泪，不要在生病的时候告诉他。他无法给予你照顾和关心。至多是同情一下，而，请骄傲的你，不要放弃本来属于你的骄傲。虽然太多的人，在爱的面前丢失了太多。连站起来的勇气都没有。何来骄傲？只是，要记得，只有爱自己的人，才可以真正的去疼惜你。而不是，旁观的同情。怜悯。当他不爱你的时候，你的爱便是他的负担。请不要去计算自己的付出，不要希望有什么回报。爱着不爱自己的人，本身便是没有回报的。不要计较对与错。这样会快乐些。要记住，你与他之间的爱，是单方面的，你用心，他无心。所以，也不要怪他。因为也许他也想做好一些。对你不要那样的冷漠。知识，爱一个人，对一个人好。本来就是一种本能。对不起，他没有这样的本能。当他不爱你的时候，请不要失去自己的自信。因为爱一个人，并非他的优秀，而只是一种感觉。他让你有这样的感觉，于是你爱他。同样，他不爱你，也并非你不优秀。优秀，不是爱的理由。看看还有那么多爱自己的人，淡淡地微笑一下，也是异样甜美的。当他不爱你的时候，也一定要祝福他。有了爱，便不该有恨。爱是美好的。恨却丑陋。何必让生命中最美好的东西化作丑恶呢？也不要觉得不公平。关于离去。他失去的是一个爱他的人，而你失去了一个不爱你的人，却得到了一个重新生活，重新去爱的机会。请不要去想到“永远”。爱没有永远。你此刻深爱，却注定遥远的某一天也不再爱他。他只是比你早一步到达了这一天。当他不爱你的时候，请轻轻拥抱一下回忆里的温暖，轻柔地凝视凋谢的温柔。当他不再爱你的时候，亲爱的，请你深深呼吸，一生的路上，铺满了爱的花蕾，总有那么一朵属于你，不是安慰你。而是，这是生生世世早已经注定的。相信我！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('814', '2000', '我之前所念噶野都系事实...但系真系我固执嘛`??真系我多心..!好混乱.!依家我噶脑只系一直甘旋转..转到答案出来..!但系答案几时只出来吖?~?真系要我自己去念???但系我始终念唔明白吖嘛!~~!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('815', '2000', 'jason:第一次当我见到你你说你紧张的忘了呼吸记忆里我只想玩玩而已在一起没想过这问题你说你从来没有忘记我们第一个夜里我一边说我爱你一边喘着气sorry我爱你是指你的身体我不知道你的需要你对我的要求我从来没做到矮你怎么受的了矮～但我总是见到你微笑痛苦总是往肚子里吞掉只希望有一天我能明了你的好我假装对你不在意假装失去我的记忆为了隐藏以前痛苦回忆我选择放弃放心去爱人的权利因为我不相信自己不相信你不相信一句话叫做真心真意我选择绝情绝意你把我当作情人我却把你当作敌人我的人生就是充满猜疑忌恨不要浪费精神在我身上寻找永恒执迷不悔只会再你我身上造成一道道永远的伤痕babylandy:能不能就对着我说爱我能不能就陪着我天长地久不要对我若即若离让我伤心泪流能不能就对着我说爱我能不能就陪着我一直到最后从今以后剩下的路要你陪我走jason:你一定觉得我坏谁都不爱随你去猜我是在什么心态面对你给我的爱你对我好我就对你越坏但我心里一直有声音跟我告白它说不能没有你的存在好怪想爱却又说不出来为何心软为何心软为何你从不会对我心烦已经有了答案我却不敢去看面对你不再反感我发现我冰冷的心感受到你的温暖该怎么办我现在爱你会不会太晚你是唯一我想和你在一起不想再和你分离喔就算外面的女孩子她们叫我baby-by和在我心底只有一个老婆叫做vicky-cky不知道该怎么说但我知道怎么做我不会一错再错忘了以前痛苦的过程我们要的只是结果你问我会一起多久我不知道大概一辈子够不够牵着你的手往前走我只听到你说landy:能不能就对着我说爱我能不能就陪着我天长地久不要对我若即若离让我伤心泪流能不能就对着我说爱我能不能就陪着我一直到最后从今以后剩下的路要你陪我走landy:能不能就对着我说爱我能不能就陪着我天长地久jason:能不能能不能能不能够对着我说爱我landy:相信我能不能就对着我说爱我能不能就陪着我一直到最后jason:就一直到最后', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('816', '2000', '嘿嘿，今天和阿姨视频，她说我瘦拉，哈哈，让我开心的都快飞起老拉。来这里瘦勒八斤类。冒想到阿姨居然电头发老，还不错，今天看到姐姐发过来的彩信，弟弟滴照片，哈哈，好可爱噢。妈妈在帮他洗澡澡，他也快5个月老。好快噢。好想回家，不管怎么样，我裹个月一定要回家，大不了不要工资老，现在是度秒如年阿。烦阿。高中是冒的读老，那就去长沙读书吧，反正不想呆到郴州。。。。。。。恩是无语，旁边那个男人居然到看a片。啊，，我要开心的过好每一天，嘿嘿，现在还不迟，。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('817', '2000', '如果可以,請让我愛你一輩子!讓我這一生都陪在你身邊!!想告訴你..我是真的愛你!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('819', '2000', '靠``昨天晚上你让我在楼下等了一个多钟``我在想``靠``你不会睡着了吧```心冷了一下```打电话吵醒你```hoho```被蚊子咬到吐血``好惨哦``不过后来晚上超级无敌开心吖```嘿嘿``爱死你了哦```你惨咯```要跟着我1辈子咯！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('820', '2000', '我的电脑坏了,心情日记的网址也没了,找得我好心烦,今天我终于找到了这个网址.好开心啊。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('821', '2000', '在陌生的环境中女人最容易表示爱,因为环境不熟悉和对环境的不适应,让女人对身边的男性产生信任和依赖感,进而增强了对男性的感情.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('822', '2000', '不知道爲什麽,感覺現在的我們變了好多!對彼此都淡了!唉...好難過錒...不知道以後我們會變成什麽樣?你也快離開了...想到這個問題就讓自己好難過好煩!好想哭..你知道麽?好多個晚上睡不着我都會想這個問題一想到就會哭!好怕你離開以後我們都會變!哎...好多好多的問題!真的好煩!不知道以後會變成什麽樣!哎..........', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('823', '2000', '同样的话又一次对我说，这次不知道是真的还是假的，但是我真的还想和他在一起。不管我心情怎么样。我已经习惯他在我的身边，只要他在我的身边。我的心情也会改变，同样的话这次是第4次对我说了。我真的不知道他是怎么想的。我已经努力了。也尽力了。我对这对感情冒有什么好后悔的了。心理虽然还是很疼，但是我还是要尊重他的决定，因为我不想在纠缠，也不想要乞求的爱。因为我要的不是可怜。和他在一起这么久了，我还是不能控制我自己想他，因为我是人，是有感情的，今天我真的不想让自己哭，我告诉我自己不能哭，我要坚强，但是在不知不觉中我的眼泪已经掉了下来，不管我自己怎么控制，还是冒办法阻止眼泪。看着我和他的相片想起我和他的快乐。眼泪又要掉下来，我该怎么办。我有什么办法可以能我不想他。已经是这样子了。我只能控制我自己不去想他，因为不管我怎么样努力还是这样子，我已经努力不和他吵架，控制我的脾气，两天他都每天回来，也没有和我说什么。我又一个人傻傻的等，但是他觉得没有什么。我能说什么。现在我对他没有从前的任性，也没有从前那脾气，一直为他改变，但是他为我改变了什么。比原来还要差，我觉得我就看见了原来的我，其实我也没有怪他什么。因为他的改变可能是因为我，不是我以前那么的任性，我想他现在也不会是那样，但是我听到他会为我改变。我心理真的很开心。也很高兴，虽然他没有什么太大的改变。但是我知道他尽力了。我现在只能看看我和他的相片想他了。不写了。，我的眼泪已经掉了太多了。一边写，一边掉。一边想他', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('824', '2000', '我爱你`````老公爱你一辈子哦~~！希望我们可以永远在一起哦`~！你呢``！也会爱我一辈子吗？呵呵`！爱你的老婆哦`！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('825', '2000', '哇吼``好挂住你哦```老婆仔``好耐都无见到你了哦```哼哼我生气了哦```！！讨厌死了```！无聊死了`！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('826', '2000', '最近几天,身体感觉不错,只是走路有些不舒服,关键还是脚的问题,脚关节严重变形,而且脚的下边的关节往下突,所以站几分钟就会感觉到很累很累.不过我已经很知足了,最起码其它关节还不错,最近在练习打太极,打的总是不到位,我对自己也没有要求太高,只是活动一下筋骨就行了.利民也每天都去游泳,他为了减肥.今天我们一起去看了做眼睛手术的地方咨询了一下,利民想做一下手术把眼睛治一下.晚上他游泳结束后正好今天开着汽车,我们还去西江堤转了一下.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('827', '2000', '我不断我控制我自己，但是还是忍不住。还是和他打哒电话，还是去了那个伤心的地方，本来我想等他，看我们还可以在一起不。但是他没有回家，我打电话问他，他对我说不关我的事。我心里不知道是什么样的感觉，我只能把电话挂了。我不知道他到那里睡觉去了，我真的不敢去想。我知道他的压力很大。但是我却没有帮得他上的，他也不能我和他一切承受。他又知不知道，我好想和他一起分担他的快乐与悲伤。又是一天眼泪不断的掉下的日子，我不知道这样的日子还要过多久。我只希望他能快乐。', '</P><P> </P><P> </P><P> </P><P> <BR> ”已經沒有任何意義&、</font>', '', '');
INSERT INTO `dede_addonarticle` VALUES ('828', '2000', '呼...好耐都冇写日记嘞..卡卡...好郁闷喲...有和他..散了...呼...好累啊...好假...什么都好假..好虚伪!承受不了了...终究还是结束嘞..!没结果..劇終。.!新酊..对5住..我5想噶..但系我呃5到自己...我对你噶喜欢..早以没有嘞..我很想爱你..可是我做不到..我不能自己骗自己...只能说..我的错吧..!你说..我们还会是朋友..我很开心..有时间也可以打电话给你..也可以更你诉苦..你愿意听..我好感动..呵...希望如此..我也希望你开心..唉...有恢复到从前..一嗰人的生活..他..???属于她的..!不会胡思乱想的...因为我心里..早已经有了一嗰人..从来都没变过...已经容不下任何人了..包括他..呼..对他的喜欢...从来没放下过..也放不下...其实...放棄。..也需要勇氣..!或者到了初二..也许...会和他....', '</P><P> </P><P> </P><P> </P><P> <BR> ”已經沒有任何意義&、</font>', '', '');
INSERT INTO `dede_addonarticle` VALUES ('829', '2000', '今天又同她吵架了```哎```不知道怎么说``明后天我老爸``就要回来了``不知道怎么说``你到时候又不会过来陪我了```今天晚上要你过来``你说不想``我好恨``觉得你对我一点也不在乎`可能这样说很自私```但是```觉得你在最后一天也不能陪我``好讨厌````我决定了```从今天开始不再主动要你陪我```看看你什么时候才会感觉到我的存在```哎```觉得自己好失败```讨厌这种感觉！！！！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('830', '2000', '中午噶時候同老公一起坐睇《生化2》老公好衰衰吖..哩排成日鹹濕我一直摸我個胸不過我覺得好舒服老公進一步竟然伸入我褲朗55555搞到人地不知所措感大庭廣衆之下嗌我點樣反應好播老公仲要試圖進入敏感部位吖——隂道雖然有under隔住但係老公有將手指聊我又有插我播5555醜si拉搞到我極度5好意思不過會幾hight下噶如果係君少張牀度我諗我實hight到暈但係我地未成年噶所以5應該髮生性行為因為破處之后就冇得高噶拉我依加感矮我55555製噶！所以就算我幾hight都要忍一忍吖', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('831', '2000', '咾厷..矜兲和尒濄得恏開心!真的..!如果一輩子都能這樣那該多好錒!只要有尒在莪身邊,莪就很幸福,很開芯釕!早上跟你去真功夫吃早餐,晚上又跟你去吃儅儅..之後又開車亂飛!真的好開心噢!!!很多時候莪門都要因爲那件事而閙得卜開心!哎..真的好討厭錒!現在覺得莪們之間的問題越來越多釕!爲什麽會這樣錒?晚上尒送莪回到傢之後什麽也卜說就走釕,真的讓莪芯恏痛錒!以前尒從來都卜會這樣的!尒這樣,真的讓莪很難接受!現在的尒真的變釕好多好多..!以後別再讓這件事而又讓莪門閙得卜開心,好麽?鎮的卜想因爲這樣就讓莪門之後的問題越來越多!看釕尒的日記,感覺現在尒很恨我!那種感覺很難受...很難受...也許尒恨我..也是對的吧!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('832', '2000', '几天吵一次,真的好累吖!不知道这样吵下去还有什么意思!这条路..该如何走下去?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('833', '2000', '他给了我答案答案果然和我想的差不了多少他的心中还有个她我搞不清楚为什么他能那么快的放下我和他的感情还能坦然的和我说他有多么的喜欢这个女孩多么的想和这个女孩在一起那他知道我的流水吗自己又好傻好想帮他想让他和自己喜欢的人幸福的在一起就算那人不是我又或许我和你不在同一个地方也只能这样结束这段故事但是为什么自己还是好喜欢你但我问你我还能在喜欢你吗?你对我说这样有意义吗?我的心就隐隐的作痛是我这样会给你带来负担吗?为什么现在的你和以前的那些话根本不成正比也许吧那就是因为你不在爱我了听着小美，轻柔的嗓音，唱的这首《亲爱的你怎么不在我身边》，心里觉得空空的，亲爱的你怎么不在我身边。亲爱的，我们就这样分开了，永远分开了。亲爱的，你确实不在我身边了。亲爱的，你身边已经多了一个她代替我来照顾你。亲爱的，原谅我以前的任性。亲爱的，我们曾经真的爱过。亲爱的，不要怀疑我对你的爱，虽然有些残缺不全。亲爱的，你在也不会陪我整天聊天，去寒问暖了。亲爱的，我再也不会叫你上通宵，多吃东西，自己照顾自己。亲爱的，还怀念和你在一起的那段开心的日子啊！亲爱的，你对我真的没有话说了？我们之间真的就用沉没来取代吗？亲爱的，你不爱我了？我后悔以前没有好好待你。亲爱的，虽说，要忘记你，可假如真的爱过，忘记很难做的，你知道吗？亲爱的，你还记得吗？记得你曾经说过的话吗？永远都不会和我说分手吗？亲爱的，我再也不能对你撒娇让你做这做那了。亲爱的，离开我了，这个事实我说过要忘记不想再去回忆，因为每回忆一次心就会痛一次，我原本破碎不堪的心难以愈合。亲爱的，如果有来世上天再给我一次机会，我一定会好好的爱你，紧紧的抱住你不放，不要你离开我。亲爱的，如果可以，我们不要在计较以前谁对谁错，只要记住曾经真心爱过对方就好，而我，能做的好吗？亲爱的，知道你和她在一起后，不是随便，我不在乎，其实这全都是假话，我能不在乎吗？我真的很在乎，因为你说过爱我，不会再爱别人。亲爱的，我对你失望，虽然说，你也有全选择爱你的人和你爱的人，但是我不喜欢被骗，如果你爱别人请告诉我，不要说你不会再爱我。因为，假话让我伤心。亲爱的，对不起。我没有办法原谅你，如果可以真的不愿想起你，可是偏偏，偏偏脑子里全是你，想着以前，想是你说的话，想着你现在身边有了她。亲爱的，我选择逃避这些事实，我承认自己懦弱，害怕接受事实。亲爱的，你让我感受被爱，同样感受心碎。亲爱的，让我忘了你，做不到，也许只有时间能帮助我，可是亲爱的过去这么久了，我依然没有办法忘记你。亲爱的，我想了好多好多，其实我们在一起真的是错误的，我们不在一个地方，如果说要好好去爱你，也很难做到，我们之间有距离。亲爱的，一个转身的距离，让你爱上了别人，这只能怪我不好，如果我对你好，你的爱还会转移吗？亲爱的，希望你好好爱一次，不会再受伤。亲爱的，我不想让自己难过下去，把你拖进黑名单，但是看到以前的聊天记录，有甜甜的回忆在里面，有争吵，有幸福，有离合，一切的一切。亲爱的，还是会习惯查找你的qq，明明自己不想看到的，偏偏每每都想去看一看。亲爱的，我的心一次次的破碎，我找不到坚强的理由。亲爱的，请不要对我这么残忍，我的心已经承受不了，再也承受不了，一次又一次的打击。亲爱的，这是我最后一个为你发的帖子，以前记得我在你帖子里面回了一张很长的话。亲爱的，第一次，我发了这么多，这么长的帖子，不知道为什么，每想到你就有无数的话想对你说，但最后还是选择发帖，因为除了这样，我不知道怎么发泄自己心里的情绪。亲爱的，最后一次为你难过，最后一次为你哭，最后一次为你心碎。亲爱的，记住我说的，如果有来世我一定会好好爱你，希望我得一转身就可以看到对方，而不是朝相反的方向离去。亲爱的，最后一次对你说，我爱你。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('834', '2000', '[SIZE=6][/SIZE]老天太不公平了,它让我们在茫茫人海中相识,却不能让漫漫人生中相爱.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('835', '2000', '有太多的事是我没有想到的，我现在真的冒话好港哒，心理只有失望的表情，今天可能才算我和他真的拜拜了吧。他把所以的一切都改变了。我原本来以为我不得心动了，但是心理还是摸名的疼，我想我不因该在原谅一个这样的人。其实我早就自己他自私。但是没有想到他竟然为了买手机对我出得那出，更没有想到他会那样的伤害我，可能和他在一起就是一个错误，但是我到现在也没有后悔我犯了这样的一个错误，真的不知道我要多久才能清醒知道我自己的错误已经无法挽回。有时候想起来真的好想笑。但是又笑不出来，还在想他可能是压力太大，还想骗自己说他是爱我的，可是自己跟本不知道他爱我什么吗，爱我会对我这样，一切已经过去了，。希望我可以回到原来的我，过我自己想过的生活，。老天爷希望你这一点点的要求请你答应我。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('836', '2000', '藽鱫嘚女人,現在時間是:2006年9月1日19點39分,是一個藕匆心裏都可以笑出眼泪唻嘚時間.真嘚很很很開心,興奮死了,這是老天給我們嘚機會,我會很努力,很珍惜它,珍惜老天給我們在一起嘚機會,感謝老天,感謝神~!!我嘚心在知道你能和我在一起后跳了一萬下!哈哈哈哈哈,真嘚好開心,以後我們可以一起努力,一起加油,永遠在一起..........!!!!深鱫你嘚男人留_____嚒嚒', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('837', '2000', '或许这就是命吧，我必须坦然接受一切，然而只有天知道我是不是又错了，挺累的，但还是平静的接受了一切，像是注定的。哭过，苦果，然后在一次微笑，极其渺小的难过，粗糙的疼痛，我会受到惩罚，我当自己不顾一切，用最卑微的幸福支撑着自己，而事实上我都不清楚我是否真的快乐珏说醒来后就会发现是场梦，而那次苏醒后的继续沉睡，让我清醒了一点看问题，在继续的梦中，让自己平静的害怕，我不知道这辈子还会不会继续疼痛，或许不会为这件事疼了吧！希望他可以真的让我快乐，我不想让他疼痛，所以我选择了继续沉睡，但还有一部分是清醒的，像一只小丑鱼在快要缺氧的水里睡觉…', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('838', '2000', '[COLOR=#8b008b][/COLOR]矜馹,莪狠傻.整个人什么都害怕.呆茑``变茑第个似的.莪都鳪知道发生什么事的.恛家蔦,发觉狠想鲶祂`看见祂的资料更鳪高兴,,塡的狠想祂莪崾改变,婀崾变嘚狠强.鳪能害怕別人,崾变嘚狠强.莪崾实现莪的理想.由现在开始,莪崾改变改成如何蔦`?學茴如何做人,识人.學嘚狠叚.鳪害怕任何人,莪崾利用可利用的人,帮助莪.完成莪的愿望`.因为,莪鳪疟白痴蔦.....狠想囿天,莪变嘚狠漂亮,能遇丄祂.祂能愛丄莪.白痴地想法,旦,,,起码可以让蛾幻想..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('839', '2000', '歌曲：话别和弦歌手：邓丽欣和弦聽筒一角　早已被接通回憶的心跳　是今晚的觀眾再見是那種金句　如捱下去愛遭撕碎人痴痴禱告　不懂怨恨誰＊從此只可以空氣內抱擁　餘生的興奮在　瞬間中減退　那怕被困於堡壘　從來習慣獨個心碎　夢裡共對　但你並未容許＊＃無懼受折磨　也不管對錯　情像是赤裸　錯誤走過　也總親吻過　如重入愛河　願你不再遺下我　沉迷在那鐵石心裡　埋在孤單掌心裡　輕唱下去　往日是誰　根本不需根據＃', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('840', '2000', '歌曲：蓝鞋子歌手：邓丽欣和弦都　分开太久了谁　曾令我默许谁　不懂渴睡已减退泪　停在我心居＃太累了　太累了　不再飞天遁地但求一天可跟你再走遍太在意　我愿意　能情愿甘心做后备为何要说句配你不起(为何要说句对你不起)男孩子挑选那位　是记忆当晚接近凌晨时穿起那样凄美扣着双臂　沿路双随难道也许我未曾　将爱实现由你配衬他怎么不允许如童话般欢喜　是太多心内最后亦能如玻璃故事精美决定等你　期待一年如若有天发现能男孩称心能否想起我　能否亲亲我　更多＃Repeat(＃)男孩子挑选那位　是记忆当晚接近凌晨时穿起那样凄美扣着双臂　沿路双随难道也许我未曾　将爱实现由你配衬他怎么不允许如童话般欢喜　是太多心内最后亦能如玻璃故事精美决定等你　期待一年如若有天发现能男孩称心如不敢亲我　亦可高声唱　爱歌當听蔦这首歌，便想起祂蔦。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('841', '2000', '还记得吗窗外那被月光染亮的海洋你还记得吗是爱让彼此把夜点亮为何后来我们用沉默取代依赖曾经朗朗星空渐渐阴霾心碎离开转身回到最初荒凉里等待为了寂寞是否找个人填心中空白我们变成了世上最熟悉的陌生人今后各自曲折各自悲哀只怪我们爱得那么汹涌爱得那么深于是梦醒了搁浅了沉默了挥手了却回不了神如果当初在交会时能忍住了激动的灵魂也许今夜我不会让自己在思念里沉沦', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('842', '2000', '小徐徐。。老公来咯`！知道吗？我现在很想你，想着我们在一起的点点滴滴今天你的电话怎么关机了？一定是没电了吧可是你却不知道，你的这个关机，会让我多么焦急.我会想到底为什么你会这样呢?难道是因为生我气.我回电话晚了`说实话,我不知道要用什么样的心态来写这篇文章,我怕自己又会情不自禁的哭出来你的温柔你一点一点的为我改变我都看在眼里感动在心里虽然2个月的暑假,我们只在一起的不到一个星期却足够我回忆很久很久的了从我们第一次单独在一起到我们被雨水淋湿的分离你的吻还残留在我的心尖我知道,爱情是个没有休止符的乐章总是不断敲打着我们在一起时的悲欢离合我牵起你的双手幸福的举在空中我看着此时的天空云朵交织成爱你的形状没有太多的言语只有真挚的拥抱宝贝我很认真的说我爱你你是个很好强的女孩子总是在人们面前表现的很坚强却不知自己内心对失去爱情的悲伤伪装教会人成熟让人少流不少眼泪可是却迷失了真正的自己滴落的眼泪就是最好的证明.别忘记那天我们一起听的虫儿飞别忘记那天我们一起看的电影别忘记那天我们一起打的篮球别忘记那天我们在月亮下亲吻别忘记那天我们一起放飞的气球别忘记那天我说的一句我爱你别忘记我们发生的一切一切!请别忘记!老公要告诉你,不管怎样一个人要坚强,懂事照顾好自己~!有什么就告诉我,我会尽力帮助你!我一定要用我能给的一切,带给你快乐带给你幸福!其实爱情,有时候就是这么简单我在这边你在那边相连的只是深深的思念`!我们的约定!不能忘!猫头鹰...书!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('843', '2000', '\"坶个人都士汏話精.没囿任何人値嘚莪弆相信,對牠們恏.狠想自己变嘚狠叚.什么口丷声丷,恏友.當她(祂)們需要祢的时候,便對祢狠恏.那时,的莪塡的相信別人寊的是对自己狠恏,完全的相信別人,別人説什么蹴相信.简直蹴狠白痴.莪发誓:\"\"莪什么人都鳪徻相信的,芷囿自己是蕞相信的.在莪眼中,任何人都狠叚.就算囿时別人对你狠恏.也鳪過是利用你吧蔦.所以鳪崾傻落去蔦`.莪崾改变蔦,崾相信一样东西,没囿任何一个人徻照顾自己一辈子的.就算有,都只鳪過是戰时.依赖別人,只徻令自己永远的痛苦,鳪能得到永远的幸福.莪现在要做的是,稳钱,崾人陪莪工作.利用wymen完成莪的愿望.将自己打扮嘚好丷的,令自己变倒最漂亮的.那么便能多人喜欢,认识更多的人..\"', '[move', '[fly', '老婆  ..<br>   我好');
INSERT INTO `dede_addonarticle` VALUES ('844', '2000', '蛤哈.,.甘快就开学了..好不想呀..不过不想都不行拉.呵呵..好郁闷.,.,开学第一日..好像什么都没变..初二.!??呵..也没怎样呀啊/.?!哈..不知道该说什么了.对暑假的眷恋;.说再见了..也该好好学习了..如果在不好好学习的话..我想我真的会大锅了..哈哈..好搞笑..喜欢不喜欢..那也不怎样拉..不重要了..最重要的是..曾经都喜欢过..那就够了.呵..我知道我们都没有错..只是放手会比较好过..我觉得是这样的..!!', '[move', '[fly', '<font color=#64');
INSERT INTO `dede_addonarticle` VALUES ('845', '2000', 'http://bbs.xm.com.cn/dispbbs.asp?boardid=58&ID=34575', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('846', '2000', '今天上班的時候很女人吵架了,其實我倒認爲很莫名的,明明是他沒聽見我在說什麼,不知道他認爲他是什麼意思,我倒笑唻,我問他打電話到那裏,他沒聽見我自己跑去看,然後說80啊?自己沒聽見問我在說什麼啊,我在重複一次,80啊,還素沒聽見,我在說次80丫,結果就唻句你這算什麼意思!!我倒想問問了你算什麼意思?你認爲我是什麼意思?奇怪死了,火蛤大~~我說80犯法了?還是你認爲我在說你慢在說自己快?我有那麽白痴嚒?我神經?真是鬱悶死我了,莫明其妙嚒```下班的時候還要搞笑唻,我想說清楚的,結果他還跟我凶?徹底的無語哦,胸悶!!!!!!!!晚上回家藕鱫死藕老媽了,幫我把床上的東西都擐了,哈哈哈哈``本來想叫他養藕到25歳的,現在他要養到藕死``哈哈哈哈,藕可愛的死女人哦`東西都買好了,藕就只要吃就ok了``唉``如果沒有老媽子藕咋活捏~~忽忽``老媽嚒死你~!!!踹你的大pp,那麽大的pp當心你在馬桶上出不唻~!!!!!這就是為什麼每次你大大沒發順利解决的原因了,因爲馬桶太鱫了你~~~忽忽````踹踹', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('847', '2000', '经历了n次的面试,一次次的失败,彻底让我迷失了方向,也越来越不了解自己了.经过这几次面试，我要改变自己不能让别人看扁，虽然现在没人看的起我', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('848', '2000', '[[glow=寒你是我的唯一我真的很想和你再一起.不管有什么困难我都希望能够过去...]文字[/glow]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('849', '2000', '現在大家都是用blog比較多,日記本已經有很多人不用了..而我從來沒有寫日記的習慣..所以以前也沒有在網上麵申請過什麽日記本..呵呵,我現在就隨便找了個类.也不是说随便找了个吧,其实日记本都长的差不多的..呵呵,我就是喜欢找什么空间啊.日记本啊.blog啊.,上传地址啊..留言本啊.,等等等等等,.就算有了也要把它保存下来..然后搞上一番的.,哈哈哈.,其实我也是很喜欢日记本的类.,简单可爱.,尤其是这个,很精致的.,所以才保存下来,.申请了个,.然后留下点我的足迹..啊哈哈..奇怪吧我.,就是喜欢在新的东西下面搞点什么的..呵呵,现在开始还要慢慢的找类..啊哈哈哈,真是可爱死了..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('850', '2000', '今天又和她谈了很多，包括昨晚的QQ上的事，我觉得我和她又近了一步。我知道你的情况，也理解。你劝我还是找别的人结婚。当时我没有反应，因为心里明白，你说多少次这样的话，我都不会放弃你的。我也知道，你说这话你心里有多难过。没有关系，爱，在于等待。我盼望的是，2个人永远的生活，不但是性爱而已。也许我们一起生活也会有平淡，也会有热情消退的时候，但是我会每一天用心去爱你。而我们的爱情的未来与目标是建立一个幸福的家，让你活在幸福中，我也活在幸福中。那性福也是自然的。我热望你能走出来，我不希望未来我的妻子是别人。我也不希望我将来的孩子，没有你的份。我也不希望你将来就那样随便就结束了。我希望我将来写书，我的书前，可以写“谨以此书献给爱妻-不系之舟”我希望我们可以共同抚养一个可爱的孩子长大成人，享受夕阳照白头的乐趣。我希望我们永远在一起。我是一个很恋旧的人。爱上了你，也是这样第一次公开的爱情，就很难再去爱别人。我有一条毛毯，用了10几年，还在用。今天天冷，拿出来盖。于是想起了你。人始终是会老的，青春会流逝，容颜会流逝，智力也会流失。人也会变丑。但是那又怎样。我想的是，将来我拥有你这样的老太太在怀里，我也笑到要死了。想起了一首老歌：情人还是老的好。真的，爱上了你，就很难再去爱别人了。如果你那么爱我，盼望你走到我身边。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('851', '2000', '现在的盗qq的是越来越猖獗了.,唉..最好不要盗盗我的头上来.,这个qq号码可是跟我了我有好多年了吧.,我的qq号码那么好,等级那么高.,而且还有隔会员.,盗号的人应该会盗的吧.,不过以前有人说过的.,盗号都是随机的..可是为什么有些盗号人就可以选择好的号码来盗呢.,以前刚刚开始用这个qq的时候.,我弄了个密码保护,而且我以前也试过用密码保护找回密码的.,可是以前的那个邮箱号码..我已经忘了一干二净了.,还好我的qq号码是与手机绑定的,还好是qq行的号码,.密码被改了.,会通知的吧,.而且那么久了都没有人来盗.,因此应该大概有可能不会被盗了吧..呵呵..啊啊,如果被盗了,.我无论如何都要把它弄回来了.,因为上面的人啊.,还有这个qq号码的感情..册那.,,..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('852', '2000', '寒　　我会好好的陪再你身边的　～直到你说不需要的时候　　我真的喜欢你　的　你是我唯一', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('853', '2000', '今天是教师节我们去看老师了小兰还有老李本来是要去看郭来老师的唉可惜她在外面以后还会有机会的我好想念初中的感觉真是舍不得好想哭我时常在想以后我们毕业了各自在不同的城市就是包子那句话天下无不散的筵席真多的情感要怎么去找个平衡点毕业的时候那么匆忙现在回想真是可惜总是要离开一段时间才想起原来我们离开彼此是不行的我真的好想好想274', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('854', '2000', '和姐姐説了很多.,也瞭解了很多的事情..原來飛和他們在一起比我們在一起要開心的多..這是西西的感覺,但是也89不离10了吧..對啊.,飛不是我..她不會看我們的相册.,看我們的日志.,看我們的資料..她不會還想著我們..不會還想回到我們這裏..她已經忘記了我們了..其實很難過的..不喜歡了..就是單純的友誼..一個好朋友離開了我們..我都會這樣想的.,不知道她看到了那篇文章了嘛.,為她寫的..不知道她看過以後是什么樣子的心情..我想應該沒有什麽心情吧.看過拉到..有可能還會覺得有點厭惡的感覺.,她們的事情我不是瞭解很多..都是從她們的資料和相册裏面看齣來的..唉,真想瞭解的更多點吧..是牛不要飛了么?唉..只能這麽想了..飛啊飛.,其實很想你真的很想你..不知道你想不想我們..你想不想回來.,我知道你要面子,.你只要給我們一個提示..我就會去找你..真的..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('855', '2000', '儅他對你失去信任時在一起還有什麽意思', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('856', '2000', '愛你.真得好愛你!只是不知道給如何去表達我對你愛!請你相信我..不要輕易放棄/好嗎?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('857', '2000', '尓那麼愛(她).為什麼不把她留下&&,為什麼不說心里話.//。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('858', '2000', '今天我的小電腦坏掉了..唉.,上次根本就是沒有裝好嘛..這次就真的坏的勒一塌糊塗的..啊哈哈,還好我聰明..圖片事先保存過了..以後也要這個樣子的,.以免不時之需呀..電腦今天被我搞了老長時間,但是最後還是被我搞出來了..雖然好像還不是老到位的.,但是肯定比上次好..出錯率也應該不會很高的..啊哈哈,說句心裏話..還是很滿足的..我終于會搞電腦啦..由于電腦重新又裝過了,所以一些東西還沒有全部弄好.,不過一些東西都存在了網上去了..還好還好..不用找了..已經不曉得幾次了.,每次都找了好多的圖片素材甚麽的..最後都是來個超級突然的電腦坏..害的我的東西全部流失..真是超級心痛的..現在不會了..我有經驗了嘛..啊哈哈...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('859', '2000', '愛牠嗎.?硪也不知道.?也浒是我把喜歡當作嘞愛吧.!硪已经不會再出現心痛啲感覺嘞', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('860', '2000', '很想愛他.但係距呒俾硪機會/.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('861', '2000', '好掛住屋K.好想返去.屋K系我噶港湾.遇到咩5开心只要念下屋K心情就会靓靓.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('862', '2000', '不相信爱我能永久只想到我也曾弃旧曾经就算痛苦仍捉紧你手怎相信最后你竟随她愉快远走如放任仍放任我也知丑别怪他别怪他别再伤心对吧从遇见的一刹是捉紧了吗别再敷衍对话疲累了让我休假她怎计算也无对手毕竟你我确曾邂逅如果没有记忆也不必颤抖难过更伤透别太在意爱已不萌芽经岁月去感化或许不再害怕', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('863', '2000', '翻着我们的照片想念若隐若现去年的冬天我们笑得很甜看着你哭泣的脸对着我说再见来不及听见你已走得很远也许你已经放弃我也许已经很难回头我知道是自己错过请再给我一个理由说你不爱我就算是我不懂能不能原谅我请不要把分手当作你的请求我知道坚持要走是你受伤的藉口请你回头我会陪你一直走到最后就算没有结果我也能够承受我知道你的痛是我给的承诺你说给过我纵容沉默是因为包容如果要走请你记得我如果难过请你忘了我', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('864', '2000', '太了解彼此，就只能做朋友了吧！我不知道自己这两天都在想什么，不开心的事不想跟别人说。大概习惯了只跟那几个人说了吧，当那些人都不在身边的时候，就习惯了闷在心里。我大概是喜欢很多人的，不懂，也不想懂。沉默其实挺好的。我记得有人说，跟太了解自己，自己太了解的人在一起，会有乱伦的感觉。挺可笑的。只是找个理由让自己逃避吧，别问我为什么了，我自己也不想考虑清楚。常常想睡个觉就好了，呵呵，又一个逃避的方法。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('865', '2000', '六一的时候生日~百年不遇，呵呵吃了个大蛋糕，埋汰了几个人，爽~大概早没了生日的概念，过不过都无所谓的~面包姐姐太可爱了，让她赚点钱，应该的被卖电话卡的人骗了，磨了十几分钟，让她给我便宜了十块钱，感觉还是吃亏了——一个电话要打二十遍才接得通……宿舍里的水终于换成乐百氏的了~多交了十块钱的押金，多花了几十块钱的水钱~我们乐意舒服啊', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('866', '2000', '今天本来是要背单词的,烦~去年的今天,感觉好遥远啊,大一就这样结束了，毫无防备……还有十几分钟，今天的考试就结束了，再有一天半，又一年的高考就结束了。一年又一年的，我似乎都没了时间的概念了。明年高考的时候，我就该过20岁生日了~忽然在自己的年龄中出现了2，不知道自己能不能接受，呵~有好多不开心的事，不想了。既然有些人是自己已经遇到的，就学着面对好了。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('867', '2000', '一年多了似乎说不上几句话他就生气QQ删了无数次了我受不了了~~我说过知己两个字太重我受不起他不听我解释没缘由地发脾气在Q上不说话他生气说话他还是生气我忘了是从什么时候开始他除了对我发脾气再也没说过别的算了大概是欠他太多了高三每天早上吃他买的饭心安理得不高兴的事全说给他听也没想过他是不是愿意弄花了他女朋友给他买的衣服不在乎地说了几句对不起……我大概真的做错了很多事他凭什么忍着是啊我是什么他凭什么忍我他发脾气的时候我应该都忍了吧算是补偿吧互不相欠了&nbsp;&nbsp;', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('868', '2000', '回家两个周了,都不知道要做什么太快了,好多东西都来不及想,好多事都没来得及做,就这么结束了我不明白自己为什么可以将那么多事情都记得清清楚楚,所有的,快乐的或者不快乐的,想念的人或者不想念的人去年的今天,我忘了自己在做什么.整个假期的难过,却依然清晰没办法重来了,后悔过,心疼过,都过去了对我来说,好多人都变得陌生了;对好多人来说,我也变得陌生了我们终究都会改变的,然后一点点变得不自然,一点点将我们的过去抹掉宫,秦,也许我们从来就没有熟悉过吧,只是曾经熟悉过彼此的梦.可那些东西在高考结束的刹那就已灰飞烟灭，那我们留下的还有什么陌生就陌生吧，也许本来就是无所谓的事终有一天，我们会长大，曾经的痴狂，又算得了什么', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('869', '2000', '夏天到了，知了在树上叫知了在树上叫，夏天到了~~似乎是《三重门》上的话吧，好多年了呢，那时候还疯狂地喜欢韩寒，呵~真的是很久了呢然后，那些喜欢的文字，喜欢的人，一起消失在每个夏天的尾巴上，在另一个夏天的开始，又慢慢回到某一段记忆里~一直模糊，模糊~直到记忆里只有某个夏天的影子回忆是让人心疼的东西吧，可似乎很多人都快意于这种自虐，呵~我也是其中一个', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('870', '2000', '前两天又翻出来那本《猜火车》，忽然觉得他很做作~再也不想看第二眼了然后想起一年前，Q说她开始觉得他很做作，为什么我现在才发现，唉再然后开始觉得自己也很做作，疯了一直以为自己是不讨人厌的，可现在才发现，连我自己也是讨厌自己的，烦~为什么一直知道自己哪里做的不对，一直知道自己哪里做的不好，还是改不了让别人伤心，然后让自己伤心，我怎么这么愿意自虐~~一直以为那些不开心的事都忘了呢，原来只是藏起来了然后在某个很难过的时刻忽然想起，让自己更难过我都觉得自己快心理变态了变态就变态吧谁会管', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('871', '2000', '忽然觉得,有些人,是任何人都替代不了的~或者是,每一个曾经出现过的人,喜欢的,或者不喜欢的,都是别人替代不了的.就像那些陪我走过几天,几个月,几年的人我今天甚至记不起他们的名字,记不起曾经在一起的快乐或者不快,记不起在我们之间发生过怎样的事可,还是不能替代得了呵,这算是什么话,胡言乱语然后忽然觉得,那些曾经很重要的人,更是替代不了的很喜欢的人,很不喜欢的人可是,总有新的开始吧,但某个角落,总是有些记忆残存的即使觉得今天我很快乐很快乐,即使一辈子都不可能再见到某个人,那些人,那些事,都还是存在的有过的快乐还是不快乐,是失去一次,就再也找不到的~~呵呵,今天又自言自语了**算了', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('872', '2000', '听说，爱情和梦想都是很奇妙的东西，不用听，不用说，不用被翻译，就可以感受到。这是电影《听说》里的一句台词。青涩而又萌动。这是唯一我能用的形容词。一天半的时间匆匆而过，就这样用一份不足24小时的试卷结束了自己的一学期，我想可能总是会挂几科吧！确实姑娘是从未念过书，就匆匆赶赴考场了。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;读这门书，因为梦想。虽然，发现其实这种梦就是不实在，可是为了让自己的心，曾经的洞给自己缝补下，最后还是选了。期间也因为太多的意外太多的偶然，让我就这样定下了它。所以听到那句台词的时候我特有感触。当然我知道，我不是濒临绝种的水鸟。像我这样的人该是许多的才对，&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;年初的这段日子，不断得做着许多的噩梦。我对一时起兴，来广州的母亲。一如常的平静，唯一的紧张是那莫名的恐慌。不清不楚。这段日子，开始显少去联系许多许多人。太多的人，要去关心，在乎，忽然发现好累。风波不断，哭完舒服了。可是又为自己落下了爱哭鬼的毛病。本是女子爱哭，天经地义。临考的几天，住在明家。偶然发现两个人一起的时候总是会想按时吃饭，一个的时候怎就那么不自觉，那么不爱惜饭饭。在一起的时候，她总是会贤惠的每个早晨都想起为你做早餐，而我总是可以一点忙都不帮的，呆着，瞅着电视。那两天，总是提前交这试卷，小步快走的到对面做着110的公交，赶着去文化公园。不知怎途中居然老爱塞车。经常会听到豪爽的广州司机，不该是服务态度相当恶劣的广州司机，不耐烦的吊着嗓子喊着，快点甚至吐着粗口，广州的亚运，真期待这文明的广州。夜晚两个人一起做公车回家，简单而舒服，说着，说着吃着吃着就到终点站了，&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;赶赴考场的途中，从地面到了天空。考完最后一堂，一个小时的get&nbsp;over&nbsp;的叶子，好青绿的舒服。回去的途中，公车上遇见的一个很可爱的仔仔和友善的婆婆。任我拍了三张照片诶！(*^__^*)嘻嘻……睡着了，小家伙，好像在说，睡了。钞票自己过来拿。在看看洗澡过后的我，好凶悍的女孩，哈哈！O(∩_∩)O~我不知道，我从梦里走来会是什么样子，但是刚洗完澡那会就是这样子了！其实我也不知道我想干嘛！也许就想记下吧！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('873', '2000', '&nbsp;7块钱的早晨，真奢侈！没能拍下豆浆和面包的全貌。因为完全被我吃进喝金肚子里去了。东莞半日，什么事情都似乎变得更糟糕，不过还是感谢面包叔叔的。星座上说，今年的我会忙忙碌碌，是吧！确实年头一开始就好吃力。&nbsp;“逃避：名词解释：　逃避taobi　　逃走避开;躲开不愿意或不敢接触的事物　　英语翻译：　　toevade;toshirk;toflee;torefuge;toelude&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;记得凯伦霍尼人格理论中对逃避的解释为逃避这种方法与武断的正确的方法是相对的。采取逃避方法的人从来不对任何事物作出决策。如果一个人从来不对任何事物承担义务，那他绝不会犯错误，如果一个人从来不犯错误，那他就绝不会遭到批评。如果某个人决定上大学，但没能考取，这事找不到推诿借口的。然而，如果他因为缺钱，或想去旅游、或想结婚、或仅仅想体验“真正的世界”而推迟了考大学的决定，那么它起码就推迟了潜在的失败。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;我从中看到了，那两个字承担。也说无论怎样的结果都接受，何必电话那头那么大声呼喊我逃避呢？自己真是越描越黑。心情很郁闷，跟司徒兄说，心情很不好，兄台给个笑话吧！过了10来分钟后，还真看到了笑话。司徒反问我两次，真得笑了嘛！我说是的真得笑了，那么冷的天你还能温暖我一把，那是相当得不错了。相互调侃，还是谢谢这位好心朋友的那句话。前面不好，已成定局，要的是你把后面做好。是的，我会，保守自己该做的一切。如果，我真得逃，那早就逃了。逃到所有的人都找不到，逃到让所有的人都以为我早已死去。可是，我从来都不会去这样，所以，那刻听到电话那头的声音，心抽搐了，也僵硬了。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;送妈妈去车站，三大袋的行李。和妈妈说了很多，结果证实妈妈真得很疼爱她的弟弟，是个善良朴实的好姐姐，我跟妈妈说，我一直很感激她的弟弟，无论如何他确实宽容了我，也让我成长了。错与对吧，如果我的工作做到错到，他无法原谅，那他告诉我了。我会知道该如何。都直接点。谁都不会有负累。妈妈说了好多，好多。我在那一个劲的恩。我想我一直只是想做个孝顺女儿吧！话说，现在的母亲也该到了吧！平安！&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;回家，收到明的温暖短信，立刻转发了10来个人，没办法短信是要钱的，没收到的友友可别生气啊！我会好好的，好好的。别为我担心，因为现在的心灵鸡汤的药效那是相当的迅速呢？今天zhe仔考试，希望他考试顺利。保佑！&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;其实，我的世界很晴朗。只是有些人一直觉得我的悲伤过头了。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;摇晃的木偶，总也会有奇遇记。而会飞的燕子，晴天高飞，雨天低飞，它总是会飞的。简小卡&nbsp;', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('874', '2000', '老固然很痛苦的，病固然很痛苦的，死固然很痛苦的，然他所痛苦的是重在别离了少壮的老，别离了盛好的病，别离了生活的死。所痛在别离即无常也。　　　　功利主义对于人生是肯定其欲望的。径直可以说，欲望就是人生的一切。——人生不就是在欲望的满足或不满足中度过乎?　　　　人类的本性不是贪婪，也不是禁欲，不是驰逐于外，也不是清静自守，人类的本性是很自然很条顺很活泼如活水似的流了前去。所以他们一定要把好动的做到静止，一定要遏抑诸般本能的生活，一定要弄许多矫揉造作的工夫，都是不对的，都不是合理的人生态度。　　　　习惯和社会环境总分不开，好习惯往往不过是社会所需要的道德，非真道德。清虚高明之怀是什么也不贪，什么也不怕的，抑何威胁牵掣之有?一切威胁牵掣只为受牵累于身耳。心胜乎身，则无此事。此即身心间有矛盾。然此卓然不受牵累之心，岂世俗寻常所有哉!&nbsp;&nbsp;&nbsp;《人生的三路向》，今年第一本想读的书。但我知道我不能死。我若死，天地将为之变色，历史将为之改辙。——他的狂放。三军可夺帅也，匹夫不可夺志也。——他的傲骨。为往圣继绝学，为万世开太平。——他的追求。吾曹不出如苍生何。——他舍我其谁的社会责任感和使命感。&nbsp;', '文字', '', '');
INSERT INTO `dede_addonarticle` VALUES ('875', '2000', '总有人反反复复的对我说；“要爱自己，好好爱自己。”有时候你会想这是多么形式化的辞令，因为你也曾对身边的人无数次心疼的说，“你们要好好爱自己。”&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;能有多爱己，唯有自己心中有这重量。我总是忘记具体的时间地址&nbsp;我只知道，是得这件事的确发生过，so，它就是我的一段影像，我的寂静与沉默，也许只想守护。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;那双温暖厚实的手，那个雄壮的另我窒息的抱抱，那个哭笑不得的日子吗，多多少少的只是痕迹，怀念嘛，是的？那痛楚呢？花猫的脸，应了还是那只迷茫的猫，受伤的伤口，应了自作自受的现世报，所有的冷漠与所谓的悲切，还那么的深刻嘛？不了。那都过了。所有的爱还可以那么的轰轰烈烈，洁白吗？是的，因为我选择不了明天，就像我选择不了爱与被爱，于是我努力的做我认为我该做的，然后一天天顺其自然的爱下去。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;我总想也许那样的我才真实！也许，我能做许多，但我唯一想那样的我，我会爱！&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;那样才是爱己！', '文字', '', '');
INSERT INTO `dede_addonarticle` VALUES ('876', '2000', '我在乎的，只有你的感觉，其实心有不舍，我就已经知道你的答案了！我会为你尽一切我所能做的事情。只是希望，在21岁的开头到结尾，西方成人礼的日子里。你真正的长大，因为我相信这一年，你会过的如是的深刻，长大吧，我的姑娘。在乎自己，爱自己，善待自己！这是我所在乎的你。一路荆棘，细雨却会飘香。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('877', '2000', '1年零3个月的时间，我们在做什么？其实这段日子，我真得模糊了。每一天都是这样浑浑噩噩的过着，所以我一点一滴的就这样把很多深刻也好，寂寞惶恐也好的日子，从我的脑中透过深层过滤，筛选。是的，我的日子过得并不比你来得幸福。看着，你与你的丈夫与小孩，仿若和我的世界中间有着一层层的雾气。你说想起以前的时光甚是觉得幼稚，是啊！回头看看从前的日子，也许只有那样的哭笑不得，才能让我知道，那段岁月里我真得还是个涉世未深的女孩。只有那段日子，才能让我明白，我真的曾经是个很弱小的女孩，看着你，我和妞妞不断的对对方重复想好了嘛！无疑，我从未想好，这样幸福的生活对我而言太过奢求，要知道我是多么现实的女孩。爱情和面包都有的心，我还是要的。O(∩_∩)O~看到你幸福，真好！虽然不知道未来的日子会怎样，但我想那么纤善的你，总是会把自己的生活经营的很好。从前是，现在更是如此！学习的榜样哦！我们都会幸福的，妞妞！相信总比恐惧来得好，所以我总是相信。是的，会有一个人天天陪我吃饭，散步的！重聚的几个小时，很温暖。对了。亲爱的璇宝宝，今年应该是第一母亲节吧！祝福你，永远幸福！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('878', '2000', '也许，你可以默默的去守护自认为的许多东西，只有自己只认为值得，当然你还要有完整的心，完好的表情，完好的抵御受伤的能力。因为自我保护自己一个人是基本，而一旦你想保护的人多了，你就成了那个犯贱的人，要嘛！变得很强大，要吗变得很弱小。其实强者与弱者，我什么都不是。只是一直都在做着别人，认为丫的你就是那犯贱的笨事的那人儿！&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;我知道，我就是作。自个找罪受~~~~~~~~~所以我的不顺就是自个犯贱作祟的结果，&nbsp;为什么要一作到底呢？那么折腾为了什么？&nbsp;以上观点仅自个人发泄，请勿效仿！&nbsp;', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('879', '2000', '我是宝宝，妈妈的宝宝，我想要童年！&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2010年5月8日，在广州的第四个年头里，看到一个母亲在街边，用白布围着自己的全身，赫然在上面写着的大字“我今天五岁，妈妈我想上学。可是我是山羊宝宝。学校不要我，一个人好孤单。妈妈，怎么办，怎么办？”&nbsp;我佩服于这位勇敢的母亲，虽然她把自己的脸用口罩围着，周身也围的严严实实。但，，我宁愿去相信，她真得是为了她的孩子。为了那个五岁的宝宝，和同龄的朋友一起读书，嬉戏。&nbsp;我是山羊宝宝，我想上学我有错吗？我是山羊宝宝，我想有朋友我有错吗？我是山羊宝宝，我有错吗？现在是2010的5月，恰逢世博会期间，但在4.30，泰兴幼儿园中的小孩也被人砍了，32人受伤，死亡情况不明。这个新闻同离上一次南平幼儿园袭击的新闻很近，越来越多的希望小学成为危房，越来越多。。。。。。。。。。为什么？为什么？要去伤害这群可爱的孩子，为什么要让这群可爱的孩子，连一个快乐的童年都没有。难道真得是他们生不逢时嘛？还是真得只剩那句和谐的不能再和谐的话，爷爷们，你们请尽兴。&nbsp;我记得关于山羊宝宝，国家就出过相关的政策了。可是为什么时至今日，还有那么多的孩子要被排除在校门之外，社会之外。不是和谐社会嘛？这个声音为什么总是不和谐。&nbsp;小时候，课本上常说，我们是祖国的花朵，我亲爱的祖国妈妈呀。如果我们是你的花朵，请你用一个作为母亲的血性，来爱我们吧！是年长的您失职了，还是年幼的我们犯错了。是我们不懂你们成人世界的规则，还是你们从来不曾要保护我们？&nbsp;奶粉，疫苗，地震。。。。。。。。多少的孩子失去了他们本该有的纯真，本该有的童年，谁不想自己的孩子有个健康的身体，有个快乐的童年，可是我亲爱的祖国妈妈，为什么要给这群在襁褓中的孩子，一切一切的不幸。&nbsp;还是这个社会，从来都不是你说的和谐社会嘛？&nbsp;PS：如果，社会给弱小的孩子只是创伤，请问要社会做什么？谁来告诉我？&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;爷爷们，你们请尽兴。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('880', '2000', '母亲常常说着，十月怀儿的艰辛，养育儿的辛劳。是的，儿该尽孝。欠母亲生养之情。母亲常说，其儿时境遇。意贬儿生好之年代，却忘却孝道何言，何行。爱儿直切，今才明知。&nbsp;父亲常言，吾虽未大富大贵，但从未令子女受其穷苦，子女成人成事。便是自一生之福。父之达乐。儿唯有一笑置之。儿欠父育德之情。这便是我的父母，这便是我落地之时所欠的第一份父母之情。落地时注定，在“欠”上一路行走。谁欠谁，其实很多时候并没有所谓的界定，如果真去分，彼此都是彼此的债务人。人和人之间，家人之间。能成为家人，必定有这解不开的缘分。何必愤怒。何必激愤。何必抗拒。享受其中，家人必定是与你不离不弃。怀着不离不弃的信念，我想我方能幸运的幸福的从幼到老。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;农历三月二十七日脚下一路荆棘却有你们相伴行走！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('881', '2000', '初初露出额头的太阳，散着金漫漫的光。从云里透射进房间。清晨六点，没有自己慵懒的场景。直直的从两米宽的大床上跳下来。面膜倒跌在床头。2.5h，睡着还是醒着。。。。。&nbsp;看着镜子里的自己。那样的不清醒。用冷热调和得温水，给自己冲着一头杂乱的发，只想水能让休克的细胞复活。21岁的夜晚，看着一群和自己年纪相仿的小孩，请容许我用这样的词汇。称呼我的同龄人。在大学里散发青春活力，热爱舞蹈的人。尽管我不清楚。他们的世界是何如。但，我可以肯定的。我与他们是完全不同世界的两个人。工作4年多似乎一切都在改变。青葱小树上，开始长着一圈又一圈的年轮。不想去感叹自己有多老。因为这样年纪的我，对于太多的人而言，还是个无忧的年纪。当然，如果还在校园。我想和同龄的人相较。我开始需要面临的该是选择留校或者社会。尽管我知道18岁的时候，已经自己给自己选好了。&nbsp;22岁的早晨，凌晨0点汽车在通往洛溪大桥的路上，是的这一刻我过了22岁的第一个早晨。也发了短信送给了隔天生日的朋友、6点03分，他回复了谢谢的短信。真心希望他们能走到最后。因为我知道每一段的感情都无可复制。我知道，我不再思念离我远去的人。我知道，我不再思念曾让我，在城市的夜不孤单的人。我不知道，我不再需要因为恐慌，而迷乱的投怀送抱只为让自己在黑夜里迷失。&nbsp;有些日子，有些事，有些人。我一生不忘，但一生将我忘却的又有何其多。我们路过，陌路。我们相遇，淡然一笑、我们挽手，望此生情在。还记得什么。一起发生过得？&nbsp;从白日到黑夜，从黑夜到白日。对着自己说，22岁了！这样无双的年纪，自己该会更美吧！这一刻黑白的我，在等灰色的己', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('882', '2000', '她和他一样的宽达善良。他和她一样的安静淡然。她和他一样的明净透亮。她和他很像，很像。所以有一刻我会觉得也许，他们本该是天生的一对。但他始终不如她的好，她的纤强，达善却始终为我心中如一。一起远去青春的日子。我知道无人可敌。即便我和她，和她。一起共度了多少的患难。一样不敌那段青葱岁月。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;丽江的小店，异国的梦~我再前行！！！为了最初的宣言。tashuoqinaidebiedanglezhen.budangzhenderizimeile.qinaide!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('883', '2000', '标哥裸捐&nbsp;&nbsp;是真善，还是秀善？昨日，有着“中国首善”之称的江苏黄埔再生资源利用有限公司董事长陈光标，在其公司网站上刊出了致比尔·盖茨和巴菲特的一封信，陈光标在信中指出，当即将离开这个世界的时候，能够把财富归还世界，是一种高尚和伟大。所以，“在我离开这个世界的时候，将不是捐出一半财富，而是向慈善机构捐出自己的全部财产”(9月6日《扬子晚报》)。“巴比”开始行动了，标哥做了回应了。而当人们对标哥的“高调做慈善”的质疑时，标哥说。有句俗话叫‘枪打出头鸟’，我认为，那是鸟飞得太低，所以枪才能打到它。我就不怕枪打出头鸟，因为我要以更高的慈善和道德标准要求自己，飞得更高，做得更好。”我近期，我将在江苏乃至全国找一家最权威的公证处，对自己的财产进行公证，以让全社会来对我进行监督。虽然我感觉，这话还是挺不对头的。因为标哥还没做公证，公证了也还没捐啊！在中国。有很多中国富豪做慈善，但当他们面对社会的监督时，又出现了一滩又一滩的空口慈善秀。捐是捐了，但是总是口头诺捐和实际捐款上有着金额上的巨大误差。在慈善中倒下的争议富豪，数数还挺多的。作为民营企业阵营中的牛根生，陈发树，包括没有捐成的曹旺德，在那一时段密集地要捐赠股权，是善心在某天清晨突然觉醒了，还是在以慈善的名义做伪捐？而离标哥最近的那位，是福建首富陈发树，身陷“慈善门”认捐83亿仅到账1.6亿。富豪做慈善，是做假秀还是做真善呢？我爱标哥的那句救急，不救穷。但是，当一切都只是空口时。我又觉得标哥，已然又在和中国的传媒，民众开玩笑。期待标哥，以标杆性的方式向世界证明。中国首善，不是空口伪慈善家。期待中国首善，真首善！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('884', '2000', '好久好久，我不再动笔，不再做梦。不再说好多好多乌托邦的话。好久好久我什么都不会。。。。过了好久，终于年龄开始像年纪一大把发展了。终于从那时你还小变成了现在长大了。是的那时我还小。赫然发现，我还有这这样的一副长相，胖嘟嘟的脸蛋总是有好处的。为什么呢？因为被人总是，姑娘那么小还在学校读书吧！是的，还在读书，只是不再学校，只是不小了~我最亲爱的闺蜜们，都开始成为无脚的小鸟，飞到了另一个城市。我依然守候在，我笃定的我爱他们的的环境下，工作生活所以所有无知幼稚的举动也总在以现在进行时的方式进行中。我总想着初来广州的模样，初来广州的泪水，初来那浓浓的情。我最爱的闺蜜最近最常告诉我的，亲爱的社会就是这样的血淋淋。是的，我一直告诫自己清醒的记住这血淋淋的残酷。但是那一刻，我又是那样的心痛。我曾经爱的这座城市，嫣然成了我最熟悉的陌生人！所以最熟悉的燕子，请断手断脚后，赶紧自行起飞，我记得我喜欢总在KTV唱《外面的世界》尽管五音不全的走调，但我总是忘情的跟着走了！越是简单人，越喜欢身边的事物繁杂而富丽堂皇。越是复杂的人。越是喜欢简洁而明朗。我不知道，你喜欢哪样的我！我不知道！在遥远的城市，我总想明天我该飞到哪，飞机穿过云彩回到的地面是哪儿啊！是我亲爱的家！好久好久，我在想我想要个怎样的家，自己的家！一个人或者两个我们一起生活。其实，最诱惑我心动的是什么，不是那句“我养你吧！”所以，不想上班，不想工作，不想挣钱，求包养！不成立~最心动的是你告诉我，让我们在一起生活吧！只有在那一刻我才能感知原来也有一个人想和我一起生活。谁养谁那又有何重要呢？图得尽是悸动~尽管承诺总是那么的不可靠的另我明白！但不做下梦又是那样的痛苦！因此我矛盾的遵循客观规律生活下去。什么是客观规律，你懂的！总是习惯帮身边的人看星座，看谁很好，谁不好。总是不喜欢聒噪得说好多话。从来我就不是那个特别特别外向的女孩。我在小时候看到自己的世界里。为自己精心安排了未来的样子，可是我早已忘记了那个未来的我是怎样。好久好久。我是那样的矛盾。我不是个强者。说不出我只有矛没有盾的话儿。是的不够激进不够霸气。所以还是做个温暖的人儿吧！好久好久，我一直在想我到底要什么。我想要梦想，没有梦得年纪里，是那么的彷徨无措！我想，我有勇气，很坦然的去选择！告诉别人我爱他，而不只是告诉你，我爱你！我想，我有信心，每一个决定都不让自己悔恨！去面对一无所有的自己都会是那个无悔的人。&nbsp;好久，好久，我不再动笔，不再写字。不再诉情。原来很多东西早已改变，只是到了这个年纪。才明了，一晃又是那么多年', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('885', '2000', '&nbsp;我们相爱多年，可是最终都要分道扬镳，各寻归属！&nbsp;&nbsp;路上，记住我告诉你们的每句话。&nbsp;&nbsp;&nbsp;路上，记得没有我再身边，要学会保护自己。&nbsp;&nbsp;不会照顾自己不打紧，总有人会照顾你。&nbsp;&nbsp;相信路上有好人，但也记住还多人对你好只是想让你对她更好。&nbsp;&nbsp;&nbsp;以后。我们都会各自离散，各自相爱了！&nbsp;&nbsp;&nbsp;我只想说，无论快乐与否，都别回头。&nbsp;&nbsp;&nbsp;往前看，幸福的光线会更长。&nbsp;&nbsp;没志气的我，等待你们强大之后保护我！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('886', '2000', '重装QQ,聊天记录全没了,呵呵~该不该难过呢~——我昨天梦到你了——那你肯定是想我了，呵呵——不过就是看不清你的样子，哈&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;给我张你的照片让我瞅瞅吧，西西——小样，还是想我了吧——……昨天还是梦到他了，这是想念吗？没见过面，没听过声音，这样的陌生人，我会想他吗？呵呵，别人随口而说，我却一直念了那么那么久~~还是会做很多很多梦，梦到很多很多的人~如果梦到就算想念，那我是想念在我的记忆里出现的每一个人吗？真逗就当是想念吧，这样也挺好的，在某一个平淡的梦里，想念这样一个陌生人呵呵，感觉还不错~只是，什么时候能看清样子呢？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('887', '2000', '天上有神仙吗？他们是悬在空中的吗？云彩上面没有雨，是什么样子呢？人死后，有灵魂吗？人有前生吗？有来世吗？有多少人是自然死亡的呢？好多东西还是不知道呢，还是那么地想知道~那么多的感觉还是不知道，也是那么地想知道~可似乎这些东西当我了解的时候我便再没机会考虑了吧呵呵，我在想什么呢可是还是想知道啊在我之外，究竟还有什么呢', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('888', '2000', '今天遇到了初中同学,很熟悉的脸,有点陌生的声音~想了那么久,我居然还是想不起她的名字她喊我,我大笑说我在想你叫什么名字最终还是她自己告诉我,可我只记得她姓冷我的记忆力好差~以前不是很好的吗?那些想忘记的事情,为什么不去想,也很清晰呢?有些事,我以为只有我自己记得的有些事,是我忘记,可仍有很多人记得的十年,二十年也许那时候忘记的不只是名字了那时还有人记得我吗?还有我记得的人吗?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('889', '2000', '——你不带你那些毛衣了？——恩，不带了，箱子太小，带不了——带不了就穿身上——…………外面还是30度……我记得高一的暑假，在我刚喝完一箱可乐的时候它就结束了大一的暑假，漫长地让我以为我在家瞎晃了一年然后，漫长的也结束了没人打电话问我在家有没有好好复习，练习有没有做好最快乐的日子在我还没有做好准备与它告别的时候就死去了像所有死去的东西留给喜欢它，珍惜它的人很漫长很漫长的时光让他们很痛苦地学会忘记', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('890', '2000', '见到Ｌ了，看着他我居然很想哭所有所有有过的回忆一下子涌上来，让我措手不及还会在乎吗有些人，是很重要很重要的那我对他们来说，是不是也是很重要很重要的呢忽然觉得以前做的事都好傻说什么再也不联系所有的东西删了一遍又一遍删不掉那些很真实很真实的感觉，很真实很真实的岁月可我仍然不能说知己或是什么我给不起有些东西太重不是我能承受得起的也许他也不会说这样的话了吧过去就过去了可那么想说谢谢在最不该感动的日子眼泪流了整整一年', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('891', '2000', '企鹅发短信说她们宿舍有四个人是有男朋友的我说你就看着她们的悲欢离合吧我其实不知道她们和她们的男朋友分手的概率是不是很大别人说是很大的我也是一直这样相信的好像是在《裂锦》上看到的话，如果一个男人肯为你流泪，说明他是爱你的然后记起刀刀的名言，女人有时候不讲道理，基本上是因为爱你我记得看到前面的那句话时，忽然想到他呵呵，不知道那算不算我现在倒不怎么去想了什么分开不分开的顺其自然挺好的，我一直都这样做，干吗非要在这件事上斤斤计较哈哈，给自己一个好心情~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('892', '2000', '好久没有写日记了哈.老公,不好意思哈..答应你要每天给你写日记的.但是,偶忘了..对不起哦,老公吖..不知道,老公你现在在干吗呢?恩...我想想...应该是在睡觉吧.?睡的香不列?不知道有没有.梦到我吖?嘎嘎..等老公准备好了..我就准备出发咯!我要去看偶老公...给他一个惊喜最好..但是,他知道了..我看,我把我到的日期不告诉他!到时给他一个惊喜!嘎嘎...不知道,他会不会被我吓一跳捏?他的工作好忙哦..要是我可以帮上一点点的忙就好了.可是,我什么都不懂..呜呜..老公,偶帮不上你!不行,我要自我充实..!我要学习,以后就可以帮老公拉!不知道,他喜欢什么东东.?不知道,他喜欢颜色?不知道,他喜欢什么菜色?哎呀,我现在才知道..我对他还不够了解?晕了,我竟然对我老公不了解?连他喜欢的东西,我都不知道?!我这是怎么做别人老婆的?呜呜~~恩恩..先写到这里把..老公,不管工作再多..也要注意休息哦..身体要紧!嘻嘻...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('893', '2000', '.辗转难眼又一夜。失眠对我这种马大哈类的人来说，是很少青睐的，可最近却似乎被她爱上了，频频出现哎~~纠缠不清哎！是因为看到他做的漂亮的网页吸引了我的眼球，心想他定是个才华横溢的人,于是我便有一种冲动，想认识他的冲动，于是我主动的向他走去...后来,他没让我失望,在他身上确实学到了不少本领,对我这个什么都不懂学什么都菜的人来说,他表现出的不耐烦不禁让我一次次莞尔..直到有一天,我发现,我对他的喜欢里有了崇拜的成分,且越演越烈.不在是单纯的喜欢了,我私下告诉自己,悬崖勒马吧!自尊心让我自知之明.就这样把它扼杀在摇篮里.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('894', '2000', '在我10岁那年..我的姐姐结婚了..那一刻,我看到姐姐的脸上..漾着幸福的微笑..那时,我在想..什么时候,我也能像姐姐那样呢?穿的好漂亮好漂亮..在那一年,我对自己发了个誓言:如果,谁在把我住的房里..吹满一个房子的泡泡..那我就嫁给谁!!!现在,想起那个誓言..觉得自己真的好幼稚..但是,如果真的有这样一个人..我想,我会嫁给他!因为,泡泡很小..能有办法让整个屋里都是泡泡的人..肯定很厉害,而且,能为我做的到的人..也肯定很爱我才会去做..所以,我对自己说..如果,真的有个人..能让我的房间里都是泡泡..那么我会毫不犹豫的嫁给他!!但是,这个誓言会成真吗??不知道,对现在的我来说..未来还是个未知数..不过,我很期待..我真的希望能有这样一个人..因为,我知道.如果真的有这样一个人的话..那么,这段爱情肯定很幸福..真的很希望..将来的某一天..我也像我姐姐那样...穿着白色的婚纱...和自己最爱的人..一起走进教堂...共渡一生......', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('895', '2000', '在我10岁那年..我的姐姐结婚了..那一刻,我看到姐姐的脸上..漾着幸福的微笑..那时,我在想..什么时候,我也能像姐姐那样呢?穿的好漂亮好漂亮..在那一年,我对自己发了个誓言:如果,谁在把我住的房里..吹满一个房子的泡泡..那我就嫁给谁!!!现在,想起那个誓言..觉得自己真的好幼稚..但是,如果真的有这样一个人..我想,我会嫁给他!因为,泡泡很小..能有办法让整个屋里都是泡泡的人..肯定很厉害,而且,能为我做的到的人..也肯定很爱我才会去做..所以,我对自己说..如果,真的有个人..能让我的房间里都是泡泡..那么我会毫不犹豫的嫁给他!!但是,这个誓言会成真吗??不知道,对现在的我来说..未来还是个未知数..不过,我很期待..我真的希望能有这样一个人..因为,我知道.如果真的有这样一个人的话..那么,这段爱情肯定很幸福..真的很希望..将来的某一天..我也像我姐姐那样...穿着白色的婚纱...和自己最爱的人..一起走进教堂...共渡一生......', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('896', '2000', '很早很早以前..我就想对你说..放开我,好吗??但是,我始终说不出口..因为,我仍然爱着你..为什么,为什么会这样.?我不断的问自己,为什么?结果却是..我找不到答案..我还爱着你,我知道..你是我永远的最爱..但是,你却永远让我伤心..为什么,我们之间就不能像..那些情侣一样,开开心心的呢?我不懂,为什么我们之间..总存在着一层隔膜.?但是,我们都知道这层膜..可是,谁都不去捅破这层膜..如果可以让我选..我宁愿不曾认识过你..至少,这样我不会为你伤心落泪..但是,我的心却出卖了我.我的心告诉我..如果能重来一次..我还是会选择你..就算会被伤..因为,我爱着你.一直一直爱着你..每天睡觉的时候.我静静的看着你睡熟的脸..觉得,我的心好疼好疼..但是,我又无能为力...只能任由它疼...我真的很想对你说..但是..我说不出口..如果,你还爱我...就请你放开我把..[/color][/color]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('897', '2000', '不知道为什么...今天晚上,好烦好烦.!但是,我却不知道..我为了什么而烦恼?也不知道什么回事..只觉得,整个人没点精神..头,好疼好疼..这到底是怎么回事?我和他,为了一点点的小事..就因为一点点的小事,我们吵架了..谁也不理谁..也许,对他来说..这已经是家常事..但是,对我来说..只会是加深我离开的想法.!不知道第几次认为.认为自己和他不适合..越来越觉得,离开才是最好的办法..或许,离开对我和他来说..是个好的决定..至少..我们不会再为此而烦恼!这个问题想过无数次..每一次的答案..都是舍不得离开!但是,这一次,我不会再犯错了.我会认真的选择,离开!有时候,我在想..如果这个世界上的每一段感情.都是美好的结局的话.?那该多好吖?那么,就不会再有人受伤..可是,这可能吗.?呵...我就是爱幻想...总是幻想一些不可能的事..为了他,留过不知道多少次的眼泪..为了他,被伤过不知道多少次..但是,为什么,我还会留在他身边?答案呢..?谁告诉我答案?我在寻找..寻找...寻找一个能照顾我一生的人..寻寻觅觅..冷冷清清..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('898', '2000', '不知道为什么..今天晚上,好烦好烦..我都不知道我在烦什么..头,好疼好疼..为什么这个时候..老公却不在呢.?好想你哦..老公...不知不觉..我才发现..我竟然流泪了..?!我到底怎么了.?为什么无原无故会落泪..?一个人的晚上...原来是那么的难过??原来时间过的是那么的慢.?原来这个世界转的是那么的慢.?其实,对这个世界来说.一个小小的我..并不代表什么..就算,我没在这个世界上了..地球还是会转..人们还是照样过日子..时间...一分一秒的失去..我想抓住..但是,我抓不到...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('899', '2000', '[COLOR=#A52A2A][/COLOR]今天，例行客户会议。会客室里，寒暄让坐，沏茶递烟。说话的说话，客套的客套，一团热闹融洽的气氛。热情客气的我，扮演着一个面面俱到、不分大小来者是客的主任身份，替老板招呼、打点着现场，象极一个转个不停的陀螺，并且叫停就停、让转就转。离开烟雾缭绕的会客室，我躲在无人的阳台边上，闭上眼睛，时不时让自己冷静一点、清醒一点....人前，我不知道自己是谁，却又很清楚自己在做什么，该做什么，不管自己喜不喜欢，有事，就得全力以赴.曲终人散，回到孤零零的宿舍，总是说不出的疲惫。斜坐在沙发上，点上一根烟，万千烦闷铺天盖地欢呼而至，闭上眼睛，却感受得更透彻。无奈亲人的病痛、感情的渴盼以及该立未立的迷茫....人后，我很清楚自己是谁，却又不知道该做什么，能做什么，没事，我就拼命上网，沉沦自己.人前人后，我总是找不到自己！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('900', '2000', '我爱的人.！爱我的人.!送我一个小小的.软软的.橡胶的.LIVESTRONG亲爱滴胖老婆.<伤>崔俊', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('901', '2000', '我得宝贝老公。知道今天是什么日子不捏？你应该知道喔。今天是我们好啦一个月啦。虽然还只有短短得一个月。但是，我感觉我们好了好久好久了。那天很HAPPY/因为你来学校接我啦。开始我一直担心。只怕你不来。不过。最后你还是来啦唷。-那天晚上真得很开心阿，靠在你得腿上看天空。我也知道你得脚脚很痛。SORRY啦。-cici~我送你得那个东西。本来准备跟你说要一直带着。你一个/我一个-可是。你却把它弄丢了喔？这可是我第一次送老公礼物乜。虽然不是很好得东西。但是--我真得很不高兴阿。可是丢了也丢了。再不高兴也找不回来啦。算了。我不希望下次还是这样。好吗？答应我。我要回家啦。我还是偷偷跑出来写日记得。妈妈等会又要骂人啦。21号中午来接我阿。然后下午跟你一起玩，到时候再去接[鬼妞妞]。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('903', '2000', '我不知道究竟她为什么会这样对我,我只是觉得前路迷茫', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('904', '2000', 'FOREVERLOVE{Krad-我得日记本上就是这样写得哈哈高兴不捏现在冒点味阿一个人坐哒网吧里面还以为你会上线所以我马上跑来上网可是你却没有在呼呼好无聊阿-我不关阿明天你要来学校接我', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('905', '2000', '今天,一个晚上..我都不知道要做什么..我觉得自己好无奈...每天和他这么在一起..觉得,这样还有意义吗?为什么,我们不干脆分手算了?但是,我们的感情也有那么久了..突然一下,分开肯定会不习惯..肯定会消沉..消沉..但是,这难道就是爱情?爱情不是应该难舍难分的吗?为什么,我想到要离开他..却没有当初的那种伤心,难过?而是,觉得离开他是最好的选择?如果说,离开对我和他来说.是最好的选择的话.?那么,为什么我却狠不下心?难道,我对他..诶...我不应该去想的!不能再想!再想下去...只会让我更难做出选择!算了....懒得想了..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('906', '2000', '从小到大，我们只习惯了接受父母的给予，受伤了总第一个想到爸妈，却从不曾或者很少想过、关心过他们在想什么、需要什么。当有一天发现我们印象中一直伟岸的父亲、笑容一向慈祥的母亲头发斑白的时候，那份愕然、那份无所适从、那份揪心的内疚，久久徘徊不去，让人几乎窒息~~别总在寒冷的时候，才想起妈妈那温暖的羊皮袄；鲜衣怒马的时候，别忘了还穿在爸爸脚上的大头皮鞋。逢年过节的时候，朋友，请尽量常回家看看......妈妈的羊皮袄', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('907', '2000', '删去记忆..活着难道就要学会忍受吗?我从没后悔爱过你..真的好想做你一辈子的老婆..回忆着,从前和你一起的一切..问自己,没有你行不行..这个问题.在很早以前就问过自己.1年前的答案..不行..现在的答案..我想..就算我没有了你...我一个人或许能过的更好!我决定..离开你之后..删去记忆..这样..我一个人.会好好的活着..会活的更好..而同样的,我亦希望你能过的更好.离开你之后..我会去做我没完成的事我有好多好多的事情想做..但是,和你在一起之后.一直没机会去完成..我想,我离开你之后..读书.学艺术..学音乐..一切,我想做的.想学的.我都会靠自己的努力.去完成未完成的梦想...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('908', '2000', '很久了..这件事已经想很久了..也许,是该做决定的时候了..离开,对你对我,对大家都好..不是吗?难道我们就这样一辈子?这并不可能吖..如果这个世界上的所有如果..都能实现..那么这个世界上..就不可能再有悲剧了..有人说..爱情的伤..是最痛苦的...也是最难治疗的..虽然说,时间是最好的疗伤药...但是,有谁又能真的把伤治好呢?忘记,对于我来说..我觉得好困难...忘记一件事..忘记一个人..或许对别人来说.没有什么大不了的..但是,对于我来说..我觉得好困难.!我会想办法,把我和你一起的回忆..全部删去...我想,我一个人或许能活的更好..但是,也有可能..我一个人会越来越悲伤..但是,我还是会努力..现在的我,对你来说.可能已经是分不开的..但是,我仍然知道..我们之间只是一种..习惯了彼此的存在..学会...忘记...忘记...一切...删去...记忆...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('909', '2000', '一个人在上网..都不知道要做什么..觉得自己好无奈..玩劲舞..玩着玩着都没劲了手使不上劲..觉得好累...不知道老公睡醒了没.?他每天工作..诶呀..我好想去他那..但愿这次,我能成功的去他那.好想马上飞过去哦.?但是,我真的无奈哦..有心无力...老公吖..有没想我吖?嘻嘻.要好好注意身体哦..不要累坏了..知道吗?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('910', '2000', '今天不知道怎么了先早上还有太阳不一会就下雨了```哎给我烦乱的心有咬了一口```555555555555```', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('911', '2000', '水瓶座:好奇第一名,好学第一名,创意第一名,另类第一名,创造奇迹第一名。哈````有有那么好玩啊````哈哈哈哈哈哈达哈哈哈哈哈`````````给我留言喔````~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('912', '2000', '```ò`有啲失去是注定啲```ㄖ有啲緣分是永遠都冇結果啲.ㄖ.㏕愛一嗰人不一定要擁有.oo`但.擁有一嗰人就一定要好好啲去愛`````◇．ζ.(嗳情嘚世界里沒有誰﹎對吥起誰﹏只有誰沒珍惜誰.ζ&nb│┊│侞果感情隻剩下解釋￣...││║′話題都變成爭執_﹏．☆┆│┊還有甚麽﹏好堅持ー.﹖眞嘚吥想再僞任何事鈊痛莪嘚籬開絣吥能改變什麽,但是在這個嘘儰嘚丗堺里,莪繒經眞嘚愛過.傷過.痛過,儍過,丶.莪知哫了.ゝ在伱没上線.dē.時候.．ωo總會看着伱dē资料o.︵.傻傻dē.發呆.σ這是..因偽．ωo太想伱﹖︷.o.現在﹖才發現︷愛伱..用盡了﹎我所囿啲┊感情┊再容鈈下︷o任何魜_在這個丗堺上沒铕一個人值得伱為他哭`↙ぺ灬唯一值得讓伱為他哭啲那個人ぐ永遠都吥徻讓伱哭`◇.↘|菓囿一兲._________|莪選則離開.|請原諒莪的懦弱._____|浠望伱苛笖芘莪幸福◇o両个人在噎起没铕誰对吥起誰_________抵铕誰钚会珍惜誰_______就当我不会珍惜你~!鑀囿哆銷魂　‘*　...　⒐囿哆傷朲\'吓⒈站會崼哪裏;\'..尋找..簡單dê快樂....選擇..吥洅繦俅□ɑ。..愿意..爲了伱.改變自己....希望..壹苆嘟變嘚簡單', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('913', '2000', '这几天跟你在一起真得很高兴虽然跟我妈妈吵架了但是我不担心这几天没有怎么睡觉现在坐在电脑面前一边跟你册电话一边写着日记突然很想睡觉整个房间都很安静只听见外面过往得车辆嘈杂得声音突然见很想很想你有一阵子没有写日记了还有几天也就要开学了从来没有像现在这样很想很想读书她们说是因为放假太久得缘故吧但是我得感觉告诉我似乎不是这样得阿我是真得想读书了这次进高一了也该是时候好好读书今天在静宝屋里睡本来是准备明天找你玩得可是刚才你打电话告诉我你明天要去有事要我自己好好玩也许只能这样啦这次是我第一次为老公玩通宵那天跟鬼别册了好久大概也知道了或者说是懂得了一些原来你对我真得很重要看到你在资料后面写得那句话我也很欣慰了鬼别说你对我得影响率真得很大(我不是说不好得方面阿)或许不对应该是确定是得吧好啦安啦-我去休息去了老公记得想我MISSUEVERDAY.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('914', '2000', '原来你一直都不相信我原来我所做得一切都是空虚原来你把我想成这样你是否知道你是否觉得得到我得心被你得话狠狠得刺了一刀失落得表情再一次出现我强忍着让眼泪不要留出可是它还是很不自觉很不自觉得流了出来你说我不高兴你会心疼那为什么每次都要跟我说那些话你得那些话真得很重压着我喘不过气-我现在在想为什么外面没有下雨否则我可以痛快得淋一次淋到我清醒为止也许我真得累了说起话来也很不清醒所以安啦我睡了-', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('915', '2000', '昨天晚上我一直在想为什么你会说出这样得话难道我们得感情还值得怀疑么难道这么久得相处你真的还不相信我也是真得很喜欢你吗难道我就这么不可信舞跟我说你以前很花但没有想到你跟我可以好这么久我说我也知道你以前很花但是只要现在不花就可以了嘛以前得事就不提就是得啦我在跟现在得崔俊好又不是在跟原来得崔俊好你说是不是呢可以说以前得我也很花今天跟这个好明天就喜欢上那个但是我们两都好象为了对方而改变不是吗难道你还会跟我说现在得你还是很花吗我想你不会因为我也不会我从来没有为一个男得这样付出知道不回去后果会很严重但是我还是坚持陪你可见我也很在乎你昨天晚上到今天早上4点多我都一直在线我以为你会来想把这个矛盾解决然而你没有来今天早上8点10我起来你还是没有在也许是这几天陪我吧你也没有睡什么大概是回去睡觉了吧累了吧放松休息吧写了这么多我也矛盾了我想说什么呢也就是想说希望我们彼此珍惜对方就像鬼别说得爱情不是你追我赶而是要彼此相互珍惜与谦让', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('916', '2000', '已经决定要离开了..但是,我的心..好疼..好疼..我到底还是舍不得..但是,就算舍不得..我也得舍得...如果,我能放下这段感情..而他又能成长...那么,这有何不可呢?是吖..这有何不可呢?如果,是我舍不得...竟然已经决定了..那么.这个月.就做出选择吧..这样,对你对我..对彼此都好,不是吗??心...仍然在疼...但是...我想..我已经麻木了...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('917', '2000', '期待的日子..很快会来临..不知道什么时候..开始等待着那一天...也许,到了那一天..我反而会很惊讶..毕竟会面对着他..心情紧张...心跳加速..呵呵..现在的我..只希望那天能快点到来.这是不是很矛盾吖??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('918', '2000', '也许,在这个世界上...我会觉得自己很孤单..但是,实际上..我并不孤单..我还有我的父母..我的朋友..我还有很多爱我的人..但是,为什么..我总觉得自己是无助而孤单的.?从小到大..一直是一个人过..直到初中毕业后...才知道,恋爱的感觉...恋爱的感觉,是那种酸酸甜甜的..我一直在寻找..寻找...寻找一个人..那个人,只要和他抱着..都会有种幸福的感觉..但是,那个人他在哪呢?我想,只要我找到了那个人..也许,这一生..我会幸福吧..但是,不知道要找多久...也许是一天..也许是一个月..也许是一年..也许是一辈子...但是,我想,只要我相信..我就能找到..不是吗?幸福,是要靠自己去寻找的..所以,我要去寻找我的幸福..寻找,能陪伴我一生的人...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('919', '2000', '我这个人很懒平时不怎么记日记但现在心理真的有很多话不知道该对谁说以后我会把我的心理话都写在这里嘿嘿我的日记里的第一句话想对我的妈妈说一句话：妈妈对不起一直以来我总是让你伤心但你却一次一次的给我机会是我自己不好老是惹您生气我知道自己不是一个好儿子您为我做的是我这辈子都还不起的妈妈对不起以前儿子老是惹您生气我也不知道为什么和你在一起就老是吵架有的时候我真的很恨我自己妈妈谢谢您以前为我付出的一切儿子不是什么都不明白而是不愿意说罢了现在儿子不在您的身边希望您能自己多照顾自己儿子在这里说一句妈妈我真的好想你……文字', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('920', '2000', '知道的朋友可能知道AU是什么在这里我解释一下AU就是网络游戏里面其中的一个劲舞团一天我在华北的音乐广场闲逛看见一个房间名字为“团同会的进”的房间当时我正学会了几种舞步想去试试进去了之后我和一个叫天真宝宝的一组她问我跳什么我说随便吧她说那跳YOYO+国标我说好的其实当时我不知道YOYO的舞步是什么但第一眼见到那个天真宝宝感觉真的很好好想和她一起跳舞以后游戏开始了我一边问我姐姐（现实中的姐姐AU比我玩的好）一边跳我们配合的真的很有默契后来跳完了我们还跳出了很高的分数当时我真的好高兴后来宝宝问我有兴趣入她们的家族不我说我可以吗她说当然后来我就加入到天真家族里面现在我的人物都已经17级了嘿嘿不错吧在这里我想告诉宝宝第一次见到你给我的感觉真的很好和你在一起的时候真的很开心还有我想告诉宝宝好想为你吹满屋子的泡泡让你做我一辈子的老婆……文字', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('921', '2000', '\"[B][/B]最近新出了一个游戏.\"\"劲舞团\"\"...我很快的喜欢上了这个游戏..我也不知道为什么..我就是喜欢这个游戏..在里面,我进了一个家族..\"\"天真\"\"这个家族的名字..天真家族的每个人..都对我很好..我很喜欢他们..在这个家族里..发生过许多的事...有开心,有烦恼..很多很多的事..劲舞给了我快乐..至少,在我有限的生命里..我是快乐的,我不是一个人..我还有很多很多的朋友..即使,只是网上的..但是,最起码是以真心对待的..以前的我,总觉得..自己很孤单.很落寞..但是,现在我觉得..我很开心,很快乐..只因为..劲舞...它给了我快乐..因为,劲舞...我才从一个人的生活..变成拥有很多朋友的生活..我真的很感激劲舞团..\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('922', '2000', '这几天.好累.但是我愿意.老婆我爱你.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('923', '2000', '哈　我可爱得公公我知道　这几天我跟鬼把你跟蚱蜢子累坏了　但是我们马上就要开学了　就想在这几天跟你们一起玩　挨　没有想到把你们累坏了　ＳＯＲＲＹ．明天你要上班　上班得时候可千万别打瞌睡喔　不然老板要扣你得ＭＯＮＥＹ这样你得辛苦就白费了　你说呢？那天晚上听到你要去外地　我很不舒服　因为我希望你能陪在我身边　可是你有你得事业　我也不可以这样自私　所以我尊重你得选择　我在这边也会好好过得　绝对不会做你说得那些事　因为我只爱你一个人　还记得那天我跟你说得吗　我幻想有一天　我／你／蚱蜢子／鬼别　我们住在一起　那种日子会多么美好　可是我们可以吗　我多么希望可以　多么希望那一天得到来　期待……我总觉得我们现在很稳定　至少不像刚开始那样　经常要吵架　禾　也许是你疼我吧　不希望看到我不高兴　我也是一样得　就拿今天晚上来说吧　我说我不回家　去静宝屋里睡　我相信你很不高兴　但是没有办法　我是真得不想回去　看到你不高兴　其实我得心里也很不好受　现在蚱蜢子跟鬼别那里　我觉得一点也不好受　我怕这次得戳合又错了　那样我会认为自己真得很失败　为什么我戳合得姻缘就是这样　一次次得失败？今天晚上　我一杂玩得好得姐妹跟我说　我老姐怎么怎么样　其实我也很不好受　一个是我老姐　一个是我姐妹　我当然不希望她们吵架　但是　事实就是事实　是没有任何人可以改变得　现在得我只能期待她们能没事吧　她们说是我老姐去勾引我姐妹得老公　挨－　我也不知道该怎么说了　我站在中间　两边都不好做人　所以我就当我没有听过这个事　我姐还是我姐　我姐妹还是我姐妹　这个也是永远不可以改变得　你说呢？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('924', '2000', '\"我要勇往直前..我决定了哈..明年,我要去参加\"\"超级女声\"\"虽然,我对自己的信心不大..但是,我想..只要我肯努力..我能做到..爸爸对我说..做任何事,不管多难..只要肯努力,你就能做到..我相信,只要我努力..我能做到的..我只希望,爸爸能到..我希望爸爸能支持我..就算,参加了超级女声..不能赢得什么...但是,失败了不代表输了..失败一次,我就再试一次.直到我成功为止...我要努力..我相信,我努力..我会有成功的一天..\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('925', '2000', '牵你的手去感觉..烟火最迷人的季节..照亮幸福的瞬间..好让我们看得更远..牵你的手去感觉..烟火最迷人的季节..点亮生命的一切..绽放我们的喜悦..在爱你的每一天..烟火的季节..很美很美的一首歌..多想,有那么一天..我能和自己最爱的人..一起看美丽的流星雨...我想在那个时候..一定很美丽,很感动..我憧憬着未来的一切..即使,那不可能会发生..但是,人生不能没有梦想..但愿真的有那么一天..我坐在河畔...看到那些小孩子朝着河边..吹着泡泡..我看到漫天飞舞的泡泡..我觉得,好美好美..想象中,有个男生为我..吹满一个房间的泡泡..觉得自己好甜蜜好幸福..但是,这对我来说..好遥远..好遥远..我还能等到那一天吗?我还有那个机会看到那一切吗?我,我不知道...连我自己都不知道..我的未来是什么样..我现在,只祈祷..我能等到那一天..真的,好想...看到...我想看到的那一切..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('926', '2000', '他的生日快到了..他的心情一天比一天着急..但是,我却一天比一天伤心..因为,早就决定..他生日的那天..我就离开他...虽然,早已经决定了..但是,心里却仍然放不下..是吖..毕竟和他在一起那么久了..突然要我离开他..我怎么可能会放的下呢?不过,也许只是一时的不习惯而已..过段时间,我就会习惯了..但,真的只是不习惯而已吗?我不知道..我真的不知道..好烦恼..好痛苦..我到底要怎么办才好?为他.我不知道落多少次的眼泪..为他,我不知道付出了多少..但最终..我还是得离开他..也许,这是最好的选择...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('927', '2000', '最后一次来这里写日记了。没有不舍，没有怀念，因为网络带给我的伤害已经不是言语可以说的清的了。首先是对爸爸的话，女儿真的很不孝，一直都不肯听您的话，对不起。今后我会努力去做您眼中最优秀的孩子，再也不会顶撞您了。也许是上天给我个机会，让我能认识到自己的错误，希望您能快点好起来。我真的好希望您能站在我面前骂我，哪怕是打我我都愿意。其次是对翔翔，感谢你在我最难过的时候收留了我，我觉得自己那时就像个在寒风瑟瑟发抖的流浪狗，谢谢你照顾了我，带给了我欢笑，但是你的怀抱太温暖了，我想我没有什么可以给你的，所以我只能选择离开。没有我这个负担，我想你会更轻松吧。最后是对时尚，多谢你陪了我这一个暑假，给了我最美好的回忆，可可你要好好照顾，我相信你也能照顾的很好，还有一句，要好好的对你妈，少通宵注意身体。我回答你Qzone里的问题，我已经长大了，不想在活在梦里了，我会努力学会自己生存，我会慢慢适应没有你的日子。保重！再见了，网游还有网上的朋友，或许是再也不见了。我会为我自己还有爱我的人努力，让他们永远幸福。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('928', '2000', '老婆.我来拉.终于有时间写哈日记拉现在是第二天早上2点11分.累死拉想我不.?我不想你<呸.!>我发现你好喜欢管起过空事.以后不是你的事少管', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('929', '2000', '今天看了一部电视剧..突然,觉得好后悔..为什么我就不能一直坚持..为什么,我会怕热..而把头发给剪掉了?现在,我好后悔哦..我好想要长头发..算算,好象有6年没留长头发了.那时我留长头发的时候..还是在小学..真的好想念那个时候的我..留着长头发的日子..从今天起,我下了个决定..我要留长头发...不管夏天再热,我都要留下去..不知道,为什么.我会突然有这样一个想法..我想,也许是我想找到..以前的那种感觉...我真的很想找回以前的感觉..我很想像以前那样..无忧无虑的...但是,从16岁那年开始..心..再也无法像以前那样开朗..隐隐的忧郁围绕着我..我不想让这些忧郁围绕着我..我想逃开..我不要这样..但是,我无奈...我做不到..留长头发吧..但愿这样..我会好点..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('930', '2000', '家...?!在15岁那年..我的家还是个..很温暖,很幸福的家..但是,现在却...为什么,一个好好的家..会变成这样..如果不是16岁那年的事..这个家还会存在吗?如果没有我的话..这个家还会保持吗?爸..妈..哥哥..我很抱歉...我给家里带来太多的负担..我真的想,你们放弃我算了..但是,你们始终为我的事烦恼着..为什么.你们不自私点放弃我呢?我好高兴能成为你们的女儿..但是,我又很痛苦..我真的不想再这样下去..如果可以,我宁可就这样消失..如果可以,我宁可没有存在过..这个世界有太多的残忍..有太多的冷酷..家,我好想回到以前那个..有着温暖,有着幸福的家...还可以吗?我还有这个机会吗??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('931', '2000', '你以为我想去管起那事要我管我也不好管不我只是跟她们好好说说我在中间两边都不好做人所以我不做声姐姐还是姐姐姐妹还是姐妹老公答应祢啦以后不再管起别个空事这样总可以了吧？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('932', '2000', '很想回来,可是很多事情又是那么的无可奈何.只要你记得等我回来就可以了.我每天都想你.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('933', '2000', '晚上.我和她等等.坐在这.我小声的要你问我.你到底爱我多深.我回答你.我爱你<我的生命>平衡', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('934', '2000', '妈的.!真失望把你的象册看清楚.!我不想跟你港的太多.以后我崽就会写一篇日记.你没错.是我脑壳有问题.暂停.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('935', '2000', '在没有人的空屋里..我觉得好孤单..好寂寞..回想起,以前的生活..我突然觉得现在的我..好悲哀..到底为什么呢?为什么会变的这么快?曾经的一切..现在却已面目全非..是这个世界变的太快..还是我被这个世界抛弃在后了..为何,我总觉得..自己跟不上了..??明天就是他的生日了..两年了..我和他在一起..不知不觉,已经两年了..时间过的好快..快到让人一下无法适应..记得,在学校的那段日子..天真的我..什么事都不用想..现在,每天都有烦恼的事..真的好烦,好烦...为什么,每天都有这么多烦恼的事?我好后悔..没有好好,认真的读书..但是,事情已经发生了..那么,我也没有办法去改变..能改变的只有自己的现在..我如果改变了现在..那么..我的未来就能改变..但愿..我能再读一次书.我想把我没有做的事..我想把我没有学到的事..全部都做到..学到..但是,还有可能吗??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('936', '2000', '劲舞..网络游戏中..我的最爱..自从我接触了劲舞后..开心..快乐..烦恼..伤心..都曾有过..或许,有人会笑我..那天,竟然为了这样一个网络游戏..而落泪了..有人问我,不就是一个游戏吗?有必要吗?我无言以对...是吖.只是一个游戏..有必要这样吗?这个游戏里..我认识了几个朋友..玩了这个劲舞这个久..第一次..为了他们哭了..我怎么了?这只是个游戏..我怎么会如此在意?我不断的问自己..但是,我找不到答案..游戏..真的只是游戏吗?游戏里的人难道不是真的吗?即使是游戏..但是玩游戏的人用的都是真心吖..那么,我会这样为他们而落泪..这难道很奇怪吗?我庆幸,我找我要的答案了..虽然只是一个游戏..但是,在这个游戏里..我找到了家的感觉..我感受到了有人关心我..这样美好的感觉..为什么不可以为他们落泪?我很谢谢劲舞..它让我认识了好多好多的朋友..而这些朋友..对我真的很好..我真的满足了..劲舞..偶滴最爱..我会永远的支持下去..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('937', '2000', '和他在一起一年多了。生活仿佛是一潭死水。没有风吹过泛起的一波波浪花，没有阳光撒下的刺眼光茫，也倒映不出晚上的明月，那上面一定铺滿了那些被虫咬坏了掉下来的黄叶。发出一股难闻的味道。　　一年多的时间，他没有做过一件让我感动的事，没有一件难忘的事。肯怕有的话，也只是些让我伤心的难忘。更不用说什么浪漫的事了。越发苦闷的日子里，让我终于决定从这死水里面解脱出来，我决定离开这个自己分不清还爱不爱，却还爱着我的男人。　　离开需要勇气，也需要割断一年多共同经历的点点滴滴，终于下定决心的事，就不能像个钟左摇右晃，晃也晃了那么久了，每次都找借口向他发脾气，对他拳打脚踢，而他总像个父亲，把你紧紧的抱住，或是抓住你握着拳头的手，打又打不到，只能又把刚要发作的气又满肚子的咽下去。这使的我更加气恼。而他却在一边死笑。　　一个人过惯了一种日子，就想寻找另一种生活。我不能这样和他浑浑噩噩的过下去了。否则自己的激情就会被这死水给淹没。于是我对他说：“我决定离开你一段时间。”他听后平静地说：“随便你。”真是气愤！气的真想捏死他！我想起一首歌：“他还不懂，还是不懂，离开是想要被挽留，如果开口，那只是我要来的结果”。即使我想走，但是我还是希望他能留我，虽然明知道留不到。　　见到他的那一刻。只想躲到他怀里去。觉的自己像个迷路的孩子终于找到了家。委屈的用手使劲的在他背上捶打着，哇哇的哭着。他没有抓住我的手，却任由我打着。紧紧的搂着我，一边用手抚摸着我的头。他真像个父亲。　　他说，我知道，你总会回来的。因为你需要我来疼爱你。在你身边安慰你和关心你，在你任性的时候，做个木头人，让你出气。在你孤单的时候，陪伴你。在你烦恼的时候，给你讲笑话。在你不听话的时候，用手敲敲你的猪脑袋。　　“你的才是猪脑袋！”呵呵，躲在他温暖的怀里，好好珍惜的与他平凡的过一辈子！　　这就是我们的爱！很平凡的爱，但绝不是死水，因为有他的日子我每天都会哈哈的大笑，我们的爱在我的笑声里荡漾起一串串波纹，有金色的阳光照耀着，美丽而透明。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('938', '2000', 'SORRY。我只想说我在跟你好得时候绝对没有再想过他。那时候他堂客也跟我说过这张照片我以为我删掉了我把他从我像册删掉可是没有想到我删得却不是那一张我知道你现在一定很生气现在除开SAYSORRY我想不到别得办法我们这么久得感情你却还不相信我喜欢你我实在没有办法了你问静,问鬼她们都知道我到底有多么喜欢你为了你我几天不回家陪你玩那杂相册确实是在跟你好之前就已经搞了得。但是有一向那杂像册用不得所以我就一直冒放哒资料上面后来又用得啦所以我就放哒资料里面但是你却不相信是我们好之前就有得。你说我还能怎么解释？橙说你爱我就应该相信我一张照片能代表什么？现在得我爱得是你而不是他我们经历了这么多事不可能到现在你还不相信我吧？我知道如果我说我不记得删了你一定不会相信我但事实就是事实阿再怎么问在怎么说我还是说这个相册是我们好之前就有得', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('939', '2000', '和在他一起两年了..感情勉强算好..但是,为什么..我总感觉不到他爱着我?明天是他的生日..我想过了..即使心里还是不舍..我还是决定离开..我有跟他提过..我要离开..但是..我得到的回应却是...他还不懂..还是不懂..离开是想要被挽留..如果开口那只是..我要来的温柔...他还不懂...永远不懂..一个拥抱能代替所有..爱绝对能够动摇我..在第一时间拯救我..难道,他还是不懂吗?我自己都糊涂了..为什么我会这样??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('940', '2000', '好想,好想告诉你..我爱你,爱得好深好深..但是,为什么..我到最后.还是得离开你?算了..竟然我已经做出选择了.那么,我就不能后悔了..我现在只希望你...能开开心心的生活..我会默默的祝福你..希望你找到一个好的女孩..好好的照顾她..好好的一直生活下去..记得以前..每次,我们吵架分手后..我总是一个人喝的烂醉..醉了之后..我就哭了..哭的好厉害..好大声..以前你总是莫名其妙要分手..那个时候,我只能选择离开..告诉自己,要把你忘记..但是,每次都还是忍不住的想你..每次的分手..每次的复合..让我又喜又忧...喜..是我又能和你在一起了..忧..是我不知道还能和你在一起多久?我知道,我们并不可能在一起一辈子.我们总会要分开..分开是早晚的事..只是时间的问题..我们并没错..只是年龄太小..还不懂事而已..难道,我们的认识..错了吗?难道,我们的相遇..错了吗?难道,我们的相爱..错了吗?我想,是我想的太多了..我想好好的冷静...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('941', '2000', '不知道有多久了，我一直用文字记载着我心灵的历程。岁月瑟瑟带不走我所有的记忆，却总是把那抹痛清晰的带回到我的心中。尽管很久以前那些让我痛彻骨髓的文字早已保存在收藏夹中，却永远也无法再度被格式化。蓦然回首间，我依然很自然的会瞥到那些斑斑点点的文字，每当这时候，我的心路总会在恍惚之间延伸到许多年前的那些人、那些事。我无法抹杀我的记忆，只能任散乱的思绪千折百转，顷刻间，我的四周会一下子布下一张漫无边际的网。我如同网中的一只飞虫，用尽全身力气，最后也只是做了无谓的挣扎。　　也许因为这些的忘忆，面对我熟悉的环境，我曾一度丧失了语言能力，我不再说真话。面对着周围那些真心关爱着我也包括着那些怀着恶意关注着我的人们，我几乎连微笑的能力也失去了。我向一个傻瓜一样的生活了很久，走路、做事也不去想对错，只要是觉得应该怎么了，就被动的去做。为此我的许多选择都极度的不理智，甚至是对自己的惩罚。草儿青了又黄，我不知道就这样我木然的走了多久，也不知道我还要走多久，我只知道我的心是苦的，因为每一个夜里我几乎都会质问自己，尽管没有答案，但我会流泪。人表面一切，也许就向一本书的封面，再华丽的外壳也掩不住内在的忧伤、无望、寂寞。　　我几乎已经弄不清楚自己为什么活着。但我依然固执地守着我的真诚，向一个纯真的孩子尽职地保卫着他心爱的玩具，举止那么的幼稚，行为却是那么的可笑。但在微笑的同时，不知道会不会有人由衷的感受到一份久违的可爱。秋月清冷如纱，轻轻的包裹着我的忧伤。我多想——多想唱着属于我自己的歌迎着太阳升起的地方大步的向前走去。然而这只能奢望。也许此生我唯有小心谨慎的跟在别人后面前行，永远不会走一条自己的路。真的今生无望，那我就企盼上苍能在我倒下的时候，给我一个自我选择的会机吧！请把我身体变为石，毛发变成草，从此我愿永生永世与大地为伴，不愿再遭受转世为人的折磨！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('942', '2000', '不知道为什么..今天晚生,我的心情很不好..我总觉得,有什么事会发生..很久,没有过这种感觉了..我感觉到,我的心..像是被刀割过..在一点点的滴血...我甚至感觉到...我的心仿佛被掏空了..在茫茫人海中..我可以遇见你..是我的幸运..但是,两个人因为不了解而走到一起..却因为了解而分开..我觉得好矛盾...为什么,当初两个人在一起..到了最后,却还是要分开??爱他,为何又伤害他??是吖.爱他..我为何又伤害他?难道,我这样做真的错了吗?我只是想他能改变一点..我希望他能专心创出他的事业..而不是为我和他的感情而牵拌..如果有一天..他能看到这日记..我希望他能懂..就算他怪我.我也无怨..你.能为你的将来想想吗?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('943', '2000', '呆呆的坐在电脑前，被眼泪浸湿的眼眶还在不争气的盈育更多的泪水。忧伤的音乐环铙在耳边，感觉灵魂在迷茫的飘荡！痛楚在心底里胡乱的游荡！自然的相遇，自然的聊天，自然的想念！一切那么自然！自然的就象几十年的老朋友！但我们都深知现实的残酷，深知自己背负的责任，所以我们要学会理智的对待！学会冷静的思考！真庆幸我们还拥有这一点！　　夜已经很深了，我却无法入眠！悸动的心，好象无法平静！你一定睡了吧，感觉到我的思念吗？对不起，我总是无法左右自己的情绪！是的，就象你所说的，不需要太多的言语！让我们体念彼此的快乐，已经足够了！我会努力做到的！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('944', '2000', '我觉得自己好矛盾..我觉得自己好没用..从初中毕业那时..我觉得自己..真的好没用..在恋爱..在学习..在工作.一直处于失败的一面..难道,这辈子..我都会这样度过?曾经,我在流行下落的那一瞬间..许下一个幼稚的愿望..如果有人为我吹满一屋的泡泡..那么,我就嫁给他!!虽然,这个愿望很幼稚.很难实现,但是..如果真的有人肯为我做..那么,我真的会嫁给他!毕竟,这个要求很难做到..要吹一屋的泡泡..在一个泡泡吹出来的时候.必须在那个泡泡没炸掉之前..继续吹..直到吹满一屋..但是,泡泡的生命是那么的短暂.谁又能做的到呢?有人笑我..说这个愿望..根本没有人能做到..如果真的是这样..那么,我对感情的事..就不再要求了..也许,顺其自然是好的吧..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('945', '2000', '现在是2005年9月2日凌晨4点..我想了好久好久..在这一刻..我做出了我最后的选择..也许,有一天,我会后悔..后悔,我今天的决定..但是,就算后悔..我也不在乎了..现在的我,只希望..他能够好好的,脚踏实地的..把他的事业做好..我不想成为他的负担..我会离开,跟随姐姐去深圳..或许,在未来的某一天.我们会在某个地方相遇..不知道,那天会在什么时候..我只知道,我们以后绝对会再相遇..但愿,那个时候,我们彼此都过的很好.而不是后悔了现在的决定..就算,他会恨我,会讨厌我..我也不会在乎..我只希望,在事业上..我不会成为他的负担..哪怕他会以为.我变心了..也无所谓了.毕竟,是我选择离开..我不奢望他会原谅我..但是,我只要他好好的,开开心心的.就这样,就够了..那么,我也不会再为自己的决定..而觉得后悔,难过..当有一天,你看到这日记..请你好好的生活..找一个更好的女生一起..如果你恨我,我不会说什么..只希望,你能好好的过..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('946', '2000', '在就要离开的时候..我还是忍不住..我还是哭了..为了他,我不知道已经落过多少次涙勒但是,为什么我还是爱着他?往往在爱着一个人的时候.心,总是破碎的...在爱着他的时候..我的心,从来没有完整过...当,我决定要走的时候..心,好疼,好疼...疼的我无法呼吸..疼的我喘不过气来..曾经和你分手不下数十次..每次,我都对自己说..我要忘记你,彻底的忘记你..但是,我怎么都抵不过..我始终抵不过你认错的那点温柔..为什么,你要对我这样..?我不懂..我好迷茫..从小到大..我都没有被打过.可是,为了你,因为和你在一起..我被我最爱的妈妈,甩了一耳光..那时的我,好伤心,好痛苦..妈妈从没打过我...她那一下,打的我心都碎了..可是,为了你..我不在乎..我会选择离开,只是希望你..希望你能好好的去拼出事业!你并没错,而是我想离开..两年了,是我离开的时候了..不知道,这次的离开..我们什么时候还会再见.?!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('947', '2000', '佛说前世五百次的回眸换来今生的擦身而过。那相恋的人的缘分又是如何修来的呢？似乎一切在冥冥之中自有安排。今生能遇见你，是我最大的收获。一直以为说了永远，就不会说再见。一直以为我的爱不会输给时间。　　往事的一幕幕在你和我说再见之后的日子里一天天回放着，泪水让我无法接受与面对现实的残酷。我一直以为你是爱着我的，忘不了你对我所说誓言。只是每当我试着与你问侯一声的时候，你冷漠的态度与声音，让我的心一下子全碎了，就这样一步一步地往后退，直到退到悬崖旁，我才明白爱已经走到了终点。就在那一瞬间，我觉得自己做的一切都变得毫无意义。捧着那本写满了你的影子的日记本，我顿时找不到方向了。我对你的爱，要去向谁说呢？泪水就这样滴落下来。　　你的无情让我无法与几个月前那个对我说永远不会丢下我的人联系在一起。难道我对你的信任，对你而言就像一阵风一样那么轻吗？难道你的承诺，只是一个小小的玩笑吗？　　可是你想过吗？你要我如何去面对呢？你要我如何去接受这三百六十度的转变呢？我再也没有勇气与理由在那本日记本上写下什么了。当我将它尘封的那一刻，我的心门也随之封锁了。　　为什么真爱总是被人们所忽视？为什么总是要让爱你的人受伤？为什么爱情总是那么易碎？为什么完美的东西总是不能永远完美？　　一切一切的问题，让我的心伤到的极点。我能想起你看见我时，冷漠的眼神。那种眼神一直折磨着我，让我无法在深夜时入眠。就算是缘分尽了，也不用像避邪一样地躲着我呀。你明知道我是如此地爱你，但你却要如此加倍地伤害我。　　你说你后悔拥有这份感情，这句话让我的天彻底地塌了。我看见了我那颗滴血的心，那颗被摔得粉碎的心。　　我抬头看着天空，也许这就是天使美丽的安排吧。它想告诉我，在远方有一个值得我去爱的人在等我。那时的永远就不会说再见了，那时的爱也不会再输给时间了。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('948', '2000', '也许我天生和文字有着无法割断的血脉，尽管它总无声无息，却包容着我的万千情感。指尖间常常流淌出充满灵性的文字，偶尔的悲哀却也让我痛彻心扉、泪流不止，我真的不知道什么时候我才会彻底忘了这种感觉。我真的希望我的手指在我的心灵的指挥之下，永远敲打的是一些快乐的句子。　　我一直记得和你在春天有个约定，于是在很多次的梦里重复着这样的梦境，我一直不想醒来，也许是因为如今的秋意太浓，寒气太重了吧！不记得，多少次在蒙蒙春雨中、在炎炎夏日下，我企盼着一把替我遮雨、遮阳的伞。到如今，我的那份思念已经缠绵成一份永恒的期待，却依然不见你的身影走进我思念的门槛，走进春天里那个你为我带来的温柔的梦里。　　我也许是个任性的女人，因为任性我总是独守着自己的心事，在每个寂寞的夜里，你却总能轻叩我的心门，用一缕温柔拨动我的心弦，然后就是梦里轻轻地抚摸着我的发丝。可你的名字我总是不敢轻唤，怕那三个字不能如愿织成锦，更是不敢奢望用你的三个字加上我的三个字织成你来到我心园的红地毯。我只能在想你想得想哭的时候，托微风为你送上一句祝福。只要你在意就足以让我的灵魂释然了，我真的会用心抓住这份美丽。　　我总在想，这世间也许有这样一种爱。这种爱我们永远不能够用世俗的方式去承担、去看待。那就聚散随缘吧！风雨不知何时到，有心已足矣！那就让这样的一份也许是充满着异样的情感，缠绵成一种心底永恒的温暖吧！在这有缘无份的疑惑间，在这有情无命的感叹里，让我们彼此轻轻地叹息，深深的眷恋，用生命中一隅的碧海蓝天来圆这个梦吧！别奢求的太多。相逢就是幸福，相知就是快乐！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('949', '2000', '原来,我还是做不到..我还是不忍心去伤害他..经过昨天的那一次..我才发现,我还是不忍心..不忍心去伤害他..难道,这一辈子我注定和他在一起?!可是,我不想就这样..虽然,这样对他很不公平..但是,为什么,我就是有这样的心理?我突然好恨我自己..真的好恨..为什么,我就是做不到..?也许,这是命..命中注定..我会和他在一起.难道,我就不能改变这命运吗?我不要就这样屈服在命运下..我总觉得,我和他在一起.没有一点我想要的那种感觉.如果,这真的是我的命运.那么,我就偏要改变它..只是,我忍心吗?我真的能就这样伤害他吗?我还是爱着他的吖..我好烦..好烦.....谁能告诉我..我到底该怎么做??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('950', '2000', '终于决定,要去做事了..拖了这么久..我还是得去工作了..我已经成年了..我不能再这样一直飘下去了.我必须得固定下来.!但愿,我这次能在那个地方固定下来.我希望,我能做的很好..我不想再这样飘下去....我该为自己的未来想想了..在明年,我还想培养自己..我要去参加超级女声...就算,不能拿到名次....但是,一次失败...只代表需要更多的努力..我会尽我最大的努力去做..我想知道,成功的滋味..我想知道,成功的感觉..过两天,我就去做事了.固定下来..做事做几年..将来的事..就看自己了..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('951', '2000', '终于稳定下来了..飘了这么久..这个时候才稳定下来.其实,我早就应该固定下来..每次找到工作..由于各种的原因..我都没有固定做下去..这次一定要好好的固定下来.我很高兴..我能安分的在一个地方工作.我也希望...我能做出成绩来..虽然,不是第一次工作..但是,我还是有点紧张..我怯生..不知道.这个工作.我能不能做好..我会努力做好..尽自己最大的努力做好.好好做事,几年后..再考虑别的事..虽然,我才刚刚成年..但是,我有信心..只要我肯去做.去学..我就一定能做好..!相信自己,你最美丽!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('952', '2000', '突然之间..我觉得自己好迷惘..我甚至不知道..我为什么活在这个世界上..我为什么活在这个世界上呢?我不知道,我好迷糊..有时侯,我觉得自己.将要在这个世界上消失..觉得自己,轻飘飘的...就像一屡灵魂..在满世界的寻找..我要寻找什么?不知道..迷惘..恍恍惚惚..朦朦胧胧..有个人影在呼唤我..谁..谁在呼唤我..?记忆中的你..好模糊..我看不清楚...我想抓住你..却触碰不到..为什么会是这样..?难道,我想抓住属于自己的..都抓不到吗??好迷惘..我该怎么办.?我该怎么做??突然,我觉得...在这个世界上..我竟找不到存活下来的理由..人..为什么要活着..?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('953', '2000', '推开夜的天窗..对流星说愿望..给我一双翅膀..能够接近太阳..我学着一个人成长..爱给我能量..梦想是神奇的营养..催促我开放..想唱就唱要唱的响亮..就算没有人为我鼓掌..至少我还能够勇敢的自我欣赏..想唱就唱要唱的漂亮..就算这舞台多空旷..总有一天能看到挥舞的荧光棒..超级女声..我的目标..虽然,我知道.我唱的歌不好听.但是,我仍然想去尝试一下喔..努力后,失败勒..我也足够..然而,我没有努力过..却告诉自己已经失败勒..那么,我才真的有遗憾..我只希望..我的父母能支持我..就算别人不支持我..只要我的爸爸妈妈支持..那就够勒..不是吗?什么人会比自己的家人亲呢?没有人比的上自己最亲的人!!看到,那些女生有勇气..站在灯光闪耀的舞台上..我好羡慕..总有一天.我也要站在..那美丽炫耀的舞台上...我要告诉所有人..我也可以做的到!!只希望,真的有那么一天..只希望,那一天能早点到来.!从现在起..我要努力..我要训练自己..我要让自己变的更强..我要告诉所有的人.我要告诉爸妈...你们的女儿是最棒的!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('954', '2000', '今天,我要是应聘勒..不知道,能不能应聘的上..如果应聘上勒.我就稳定下来,好好做事..但愿.能应聘的上吧..我现在,只想找个工作.好好的稳定下来做事..以后的事,以后再去想..我现在还不想想那么多.!等稳定下来后..就一直做事..过几年后,再另做打算.至于,我要做些什么.再说勒..但愿,一切能如我的意吧..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('955', '2000', '直到今天.我才明白..原来,我们之间早已没感觉勒.剩下的只是习惯..习惯勒彼此的存在..仅次而已..时间过勒..爱情淡勒..相爱的人也就散勒..我不的不承认这句话..真的说的很对..我和你在一起两年勒.感觉,淡勒..很淡很淡..我想,我们分手的时间..就快到勒..在不久以后..我们就会各奔东西勒..你也对我说过..我们分手是迟早的事..只是时间的早晚而已..是吖,我们迟早会分手.迟早会分开..至于,是在什么时候..谁也不知道...我们现在在一起..只是一种习惯而已勒..习惯勒彼此的存在..已经成勒习惯..突然要改变..难免会不舒服..不过,会发生的事.迟早要发生..谁也阻止不勒..所以,我只能说声抱歉..你有你的想法.我有我的梦想..我们并不合..也许,分开..才是最好的选择..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('956', '2000', '有多久没写日记呢，我都快要不记得了。我一直都很懒，所以我的另一个代名词也叫“小懒虫”。以前心情一来就会提笔乱写，今日呢，或许也一样吧。但值得一提的是，我是因为看了一本书后，所以想到要写。这本书叫《第一次亲密接触》，这本书我在四年前就看过，但今日再看，感觉却比以前更深。因为这本书，我想到网络日记，我想永远地记住此刻的心情。好奇怪喔，从来没想过一本小说把我的心打动了，重点还是居然也打动了我的眼泪了。这种感觉淡淡的，就好像坐在绿色的草地，看着淡蓝而带白云的天空，手里拿着一杯带有一点绿色的花茶，静静地在品尝和享受着这难得的宁静。我的生日是农历十月初九，过了今年的十一月，我就正式地踏进我人生唯一的二十岁了。今天是2005-09-15，距离那天，恩~~还有56天。：p（为了详细地记住这个日子，我这懒虫可是很勤快地打开手机去计算喔）。在快要二十岁的年头里，正确地来说，我的爱情从来没有真正地旦生过。可能是我既没有这本书中女主角的样貌也没有她所拥有的才华吧。毕竟我不是什么英语高材生，反而是一名语言白痴，学起语言总是慢人半拍。呵呵＾○＾！所以月老并没有留意到我吧。。。我羡慕书中那种淡淡的、甜甜的、带有点苦涩味道的爱情。我跟书中的女主角一样喜欢咖啡，但我并不会像女主角那样会品尝它，我只是单纯地喜欢咖啡那种焦焦的味道，就好像我的心情。我才二十岁，但感觉却有着差不多四十岁的心情。呵呵，是不是有点未老先衰的感觉呢？但说实在，我讨厌这种感觉，因为它很沉重。我真正地泡在这网络中已经有三、四年时间吧，准确的时间数字我都不记得了，时间不算长也不算短。但我却感觉走了大辈子的路。呵呵！好沧海的感觉喔，纵然不喜欢，但它确实存在着我的心里。这网络让我打发了不少的时间，刚开始我还真是迷恋上它了。书中男主角提到网络中存在着三种人：第一种人会在网路上突显其次要性格。第二种人会在网路上变成他“希望”成为的那种人。第三种人会在网路上变成他“不可能”成为的那种人。我想我也是属于第二种人吧，我希望我的生活跟网络一样潇洒，一样的“自由”。。。。前几天早上睡醒，我下了一个我一辈子都不会忘记的决定，一个人到上海去玩，不跟团，自由行。嘻嘻，但目前还没实现，要等到十月份，伟大的国庆日假期拉。我手头上没什么资金，可能要跟公司预支工资呢。当我跟姐说到这事时，她吓倒了，毕竟我从来不曾一个人跑到这么远的地方，所以她不放心。我明白她的心情，但我同时知道我说服她了。因为我跟她说，我想送给自己一份特别的二十岁礼物。因为我知道，错过了这一次，以后我可能就再没有这样的勇气，所以我希望我想她支持我并隐满家人。因为我知道家里其他人一旦知道，我这计划就永远地实现不了。我不想放弃这计划，因为我实在很想拥有真正地自由，我好想飞，但我很清楚在我还没完成自己的责任前我没资格。但我没什么耐性等下去了，所以这次的旅游就当作给我一个甜头，一份鼓励，让我以后继续往前冲，继续给我勇气。。不知道这份礼物，会不会实现，能不能送出去，但我会努力的，这是我的梦，一个绿色的梦，我不想放弃我的梦。。真的不想放弃。。。。。。。。。。。。。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('957', '2000', '开心的我说了句《喂，你是那个咯》屏幕是出现，你呢？我说我是十中的，叫戴虎呀，你叫什么名字呀，我叫邓晶。慢慢的我们聊得比较开心哦。临走的时候我问了她的电话号码。有事就急匆匆的走了。还说了我以后有困难感去看她，心里挺高兴的~！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('958', '2000', '今天24号我昨天晚上约好了去看她的。但是我失约了，挺不好意思的。其实我也算是个比较准时的人，但是我准备跟她解释的，但是时间已经11点多了，我怕打扰她家父母睡觉就没有说了，还真挺抱歉的。在这里我跟她说一声对不起，希望你能原谅我。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('959', '2000', '今天8月1号，我无聊的来到了网吧，怎么有人给我发视频呢/哦是她她是时候来的我问了一句。她说刚刚来的，我就马上的没有玩游戏了，我跟专门的跟她聊天，2个人听投机的，什么话都说了，挺开心挺浪漫的。时间一转的过了，她要走了。我真舍不得她走。要是时间能够停留那有多好呀~！那就88吧`不舍的说了句，但是她说了明天还来的~！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('960', '2000', '今天我又来了，还早早的等这她，总算老天不负有心人，来了。她没有吃饭呢，其实我也没有呢，她又坐了个有视频的机子，我也坐的是，但是我的看不清楚，我们问她好多关于我朋友的话题，以为我和她只有我同学她是比较熟悉的，所以他的话题就比较多一点哦，2个人无话不说，真的就想回到了以前的那种恋爱的感觉了，让我真的想快点看见她，好让我认识她，我心里忽然冒出来个连念头，我想要她做我的女朋友，我真的觉得跟她挺投机的，挺开心，以前跟别的不认识女孩老是达不上话来，但是我跟她呢真的好多话说，源源不断，我真的开始有点喜欢上她了。对也许是我的自恋罢了，别人跟本就看不上我，我也没有那种资格，时间又一次让我们我再见了', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('961', '2000', '今天是8月3号，我已经在她常来的网吧等着她呢，时间10分钟的10分钟的过去了，我大概等了她半个钟头她才来，还有2个男孩，使我有点不好意思了，但是我看着她上楼去的，我只是上网跟她是要她下来但是她不肯，没办法只好去楼上请这位大小姐出去了，还好没有让我丢面子哦，她答应了，我门跑到万利隆吃了点东西，聊到以前在学校的事情，但是她跟本就不认识我。让我挺失望的，还好我们的话挺开心的，我还邀请她出去玩，她没有说什么，真的好想她成我的女朋友哦。请上天赐我个这样的女朋友就好了哦，我门的饮料喝玩了。但是话还没有说完，怎么她老看我还弄的我不敢抬头看她呢，呵呵也许我出于我没有太大的自信吧。到了1.20了她说她朋友还在网吧等她，我有送她去了网吧。可去那她朋友就准备要走了，我就对她说了句我送你去学校吧~！没想到她却说好，挺大方的一个女孩哦，要是能做我女朋友就好了~！我真的想呀，还没有想到的是她做我的车还抱着我呢哈哈~！我还没有人这样抱过我呢！我慢慢的骑，有意的让时间慢慢的过，让我门2个相处的久点，骑了20分钟才到学校，我开心死了。我好想要她这样的女朋友，到时候在我朋友面前我是多有面子的呀。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('962', '2000', '今天晚上月光挺好的8月4号我今天打了电话去了她家，她接了，我心里一震惊讶，我跟她说话挺客气的，她也是，我今天没有回家，我跟她约好我打电话给她，我在她的谈话里我又知道了一点，她挺会逗人开心的，很少生气的女孩，还有点说悄悄话，我跟她聊了3个钟头，这也许是我跟别的人打电话，这一次是最长的一次吧，多不想把电话给挂了，我边上网边跟她打电话，我还放了一只她喜欢的歌《一首简单的歌》。给她，但是就在这一天起我就有了个想法想读她说，但是我怕我说了她不会理我，那时候我太没有自信了，压抑在心里没有说出来。直到12点我也没有说。~那就是你可以做我女朋友吗~！我不敢我怕失去这样的一个好朋友~！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('963', '2000', '不知道从哪一天开始，我想看清楚爱情的样子，从传说中知道爱情是那么美妙，它可以让人刻骨铭心，也会让人痛彻心扉。当我遇见爱情时，想要抓住时，才发现她那么的温柔多情，但她却很留恋这个世界，来去匆匆，总会留下让人寻访的痕迹，但也让人无法释怀。如果是人世间的爱情，人们永远也不能掌握的话，我愿一切如风似梦，一切都不去强求。我付出过，得到过，失去过，强求过，心痛过，幸福过，曾经将真情真意枕在床边睡，将甜蜜幸福映在梦里笑，也将海枯石烂刻在心上痛，最终这一切都像风吹过后一样，冷冷的，只看见漫天的红花。人心如风情如水，朝如青丝幕成雪，一切都是幻景，一切都是飘然~~如风--往事如风；随缘--真情随缘，满天落红飘降是因为有你，而想要真情如细水长流，定要一切随缘````', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('964', '2000', '有时候.我觉得自己..就像一粒灰尘..在这世间里到处飞舞..我想看清这世界..但是,我却无能为力..这个世间.太复杂..我越想去看清楚..越看不清楚..反而使自己陷勒进去..为什么.为什么.?为什么这个世间是这样的?有人说,爱情,其实很简单.我承认,两个相爱的人在一起.认为,只要相爱,就比什么都重要..在以前,是这样没错..但是,现在,爱情是要靠钱.才能够在一起一辈子..没有经济来源..爱情还能维持多久呢?我们现在的年龄..也许,还不用想那么远..但是,长大后呢?是不是能像现在这样?无忧无虑的一直下去?小时候,最大的愿望.就是做一个漂亮的新娘..长大后,才知道..原来.这个愿望很难实现..要找一个相爱的人.要找一段幸福的爱情..真的好难,好难..我只想知道..我以后的幸福..我只想知道..我的以后是怎样的.?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('965', '2000', '所谓爱情——爱情有无奈就象在食堂排队买饭，你眼睁睁看着饭盆里你最喜欢的鱼香肉丝还剩那么多，可是轮到你时刚好没有，而你不想吃的红萝卜却是唯一剩下的菜了。所谓爱情——爱情就是可以出奖券的游戏机，有时你投了一把硬币进去，什么回报也没有。有时候你不经意的一掷，却有意想不到的收获。所谓爱情——付出就像往两个杯子里倒水，想平均分配，可是往往不是这边多，就是那边多，你不停的倒，直到其中一杯溢出……所以何必斤斤计较，爱情没有等价交换。所谓爱情——就象WINDOWS操作系统，只有在各个方面进行了优化和正确的设置才能运转正常，否则就算能够启动和使用也频频出错，最终很容易崩溃。所谓爱情——有时候爱情就像cs里的各类枪械，形式繁多，功能各异，每个玩家都有自己喜欢的那种。所以说爱情里没有最好的，只有最适合你的。所谓爱情——爱情中的男女情绪就像夏日的午后般阴晴不定，可是往往经历突如其来的暴风雨之后，彩虹边出现在彼此的上空，如此妩媚。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('966', '2000', '第一次看见你给我的感觉还事瞒好的，人瞒好的样子就事感觉好害羞的，和你讲话老事低着头，我还以为我真的长得入不了眼啊~！呵呵`', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('967', '2000', '只想告诉你，我这样做都是为了你好`我们分手是必然得，就像是她说得一样，这点我自己也清楚`和你最多是男女朋友关系不能再进一步了。首先，我得家里不会肯，其次，我也不找比我得学历低得人做老公。我想告诉你，我是为你好的，不要在我得身上浪费时间了，我不值得。真的，在感情方面是我配不上你，真得，我希望你可以好好得想想，放弃我是你最好得选择，在去找个和你更合适得吧~！我不是你得幸福，去好一个更喜欢你得人吧，这样对你对我都会很好。当然我刚刚说得那机个原因不会是最主要得，根本原因在我得身上。在你身上我是花得时间最多的，也是我唯一真得一次，但就因为这样我不想伤害你，长痛不如短痛，这点你也很清楚。至少现在分你得痛苦会少一些，你也想想吧`！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('968', '2000', '希望我们在分了以后还可以做很好很好的朋友。我不希望看到你有什么过激的举动，我你是你相信你对我的感情，我说我不相信你了，是有时候不相信你讲的话，并不是认为你是好玩的，我知道你对我是真的，但是我不能忍受不了别人在语言上面欺骗我，就是这样，不是你想的我以为你玩我一样。知道吗？希望你了解。我是最不想事情弄大的，你也知道，所以请你考虑考虑我现在的处境。请你谅解我好吗？我是不求人的，但是这次真的算我求你，我求你可以吗？你不要做出什么伤害你也伤害我的事情来好吗？那样只会让我们越来越远，只能做陌生人，你月不想这样吧！2希望我们还可以做朋友。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('969', '2000', '我中意作逗逗啊!點算好啊?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('970', '2000', '不知道为什么..今天晚上心情怎么也好不起来..总觉得,这个世界..变的越来越混乱..混乱的我不知所措..突然觉得好后悔..但是,我在后悔什么?心情极度郁闷..怎么也高兴不起来..有种想哭的冲动..为什么在这个时候..我想的人都不在..对了,今天是中秋节..他们怎么会在呢??我真傻..傻得可以了..也许,我想要的..永远都得不到吧..也许,我不可能拥有幸福吧.?也许..还有也许吗.?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('971', '2000', '你们好,虽然我是新来得,但我总是加强你们的对我的信赖再见', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('972', '2000', '　　总是回忆着昨天，向往着明天，不了解今天。　　　流星划过，留下伤痕　　　玫瑰不是蒲公英　　感觉不是感情　　永恒不是永远', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('973', '2000', '\"今天看到\"\"爱的约定\"\"为他的女朋友做的网站，我心里好羡慕更是感动，从他的网站里看的出来他很爱他的女友。真不知何时谁会为我做个这样的网站！！今天他又加了我，原来是笑笑家族成立一周年！密码已被他改了，这是不是说明我和他真的没有一点关系了？密码既然已改真不知道找我去参加这一周年是为了什么？好郁闷啊！！\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('974', '2000', '\"想说最近是怎么了,总是想让自己变的更快乐更洒脱点,我做到了_____错我没有,玩全没有,不是根本就没有,对是从来都没有,我用快乐洒脱来伪装自己,在别人面前我是最快乐最开心的一位,对我是很快乐,但是我没有用心去感受我那份所谓的快乐,你有同样的感觉吗?你能理解我内心深处的压抑吗?\"\"往事不堪回首月明中\"\"但是有些事,你不是不想去忘记,而是你想忘记可是他却始终阴魂不散,来来回回的在你的脑海里出现,你心里明明知道不可以却像个傻子一样的在默默的等待着可以的那一天.我可以等到吗?有那么一天吗?现在的生活也在压抑了,本来想离开他离开那里就会什么事都没了呢?我错了,当时的我根来就没有料到自己以经将感情豪无保留的都存放在他那里了,可如今与他却只是冷话几句,不是他对我冷话几句,我对他的心依旧火热,真希望他也能到这个日记本里来溜缆日记,然后那一天,能看到期今天所说的话,让他知道我是这个世界里最爱他最在呼他的人[/move][/move][/move][/move][/move][/move]\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('975', '2000', '我喜欢这个网站,因我这个网站给我带来了好多的快乐,如;我可以将在现实生活里不敢说的话在此我会豪无保留的给说出来.它还可以把我内心最感处的存放在全国的没一个角落里,我以后会把这个网站推荐给我的同学和同士的,因为我喜欢这个网站.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('976', '2000', '心情的好坏在于一天天的天气,昨天的天气是白的,我的心情就会很苍茫,今的天气是灰的我的心情是桑感的,明天的天气是紫的我的心情是苦的,今日复今日,明日复明日总有一天我会等到我心灵中的颜色', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('977', '2000', '今天偶喝酒勒..偶现在有点迷糊..其实,我也不知道为什么..要喝酒..只是一下心血来潮..喝勒一瓶酒..有点迷糊勒..好久没有喝酒勒..现在喝酒,有点顶不住..但是,我还是喜欢..喜欢喝酒后酒上头的感觉..飘飘然的..感觉好舒服..迷糊..迷糊...头有点晕勒..但是感觉还是舒服..不知道为什么..就是喜欢这种感觉..好多事..好郁闷..但是,又找不到解决的办法..有时觉得一个游戏..也可以让我完全的投入进去..是我用情太深勒吗?还是其他的什么.?我迷茫..我不知道要怎么做..我总觉得我的人生..没有目标.好迷茫..我喜欢幻想..但是,幻想毕竟不现实..现实永远是残酷的..为什么现实永远是残酷的..?这点,我到现在一直没弄懂..网络为什么一定要是虚幻的.?难道就不能是现实的吗.?我不懂..为什么别人都说..网络不现实..但是现实里..却是残酷的..?我真的不懂..迷茫...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('978', '2000', '我不是第一次写网络日记了可从来没有坚持过，虽说自己的心事不想别人知道可总觉得别人要是看到了认同了才是真的宣泄了心中的不快，人就是这么个矛盾的综合体。我希望这次自己可以坚持下去就算是对自己的考验也好，或是别的什么。。。我是个很情绪话的人，可能女人都有些情绪化吧，今天我的心情跟天气有很大的关系，总是一个人逛街现在我都能想到当时的心情，茫然迷糊特别容易紧张，还要故作镇静，确实有点难为自己可这是我长久以来自己养成的想该掉不是不可能只是难了点。说实话我不太喜欢这种感觉，特别是现在手头不宽裕买点东西就觉得花了好多钱不但没有以前购物时的愉快反而还有点伤感，当然这都是我自己造成的，不努力，光说不练，希望现在抓紧还来的急，我不能再自欺欺人了，我相信自己的能力不是做不好只是没有尽到全力而已！昨天在一本书上看到一句话，但凡希望创造比现在更好的未来的人都会抓紧现在的每分每秒的，我们该在现在中生活，从过去中学习，为了未来而计划才对！没头没脑的乱说了一番心情舒服了很多可是如果是看我日记的人可有些对不住了，我就是这样想哪说哪~就这样吧，我一定经常来写不管有没有人看', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('979', '2000', '现在是晚上了，很想你老公！那种感觉又来了。。。我不想再跟你分开了，我们都不再只属于自己了。我的眼睛模糊了这就是我认识你以后最大的改变成了一个爱哭鬼！不过只有为你才这样~知道你快回来了，我在尽力想在你回来之前调整出最好的情绪来抚慰你一天的疲倦，其实我知道，你工作很辛苦的，你这么辛苦也不叫苦我知道你大部分都是为了我，不想让我担心你！老公，我的宝贝狗，我想告诉你，一直以来我都感到很幸运，能跟你在一起！我是幸福的，至少我们彼此相爱彼此需要都不愿跟对方分开~这不就是爱情吗？我觉得这就是爱，是在彼此心中的那份放不下跟不舍~不多说了，有个日记本真好啊但愿老公能看到~[/color]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('980', '2000', '还是一个人一个人一个人...看来，我必须习惯这种一个人的生活方式曾经所有的美好，都不再回来也许我真的那么贱，真的是吃里扒外，真的是挑拨离间吧', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('981', '2000', '鱼鱼活在幽暗的海底，那里有很美丽的珊瑚和姿态婀娜的水草，鱼鱼用水草做霞帔用珊瑚做凤冠，鱼鱼很美。鱼族的鱼们都传说，如果出现了如此美丽的鱼儿，鱼族就要出什么大事了，比如那一年就有一条人鱼公主为了一个人间的男子离开了水界，最终的结果是覆灭。现在的鱼鱼，是不是也有那样的命运呢？鱼族的长老们都很担心。　　原来，美鱼和美人一般都有相同的命运，红颜即祸水。　　鱼鱼才不那么傻呢！她见过人，可是她才不爱人呢！人，不就是长了两条腿在陆地上行走的动物，总是把所有的动物都想方设法的送进自己的肚子里去，而且，无情！她还记得传说里美丽的人鱼姐姐被人类的无情和冷漠逼成了泡沫，那些漾漾的悲哀，似乎还包围着鱼鱼，让她心有余悸。　　鱼鱼有自己心爱的人，他不是一条鱼，可是他也没有形骸和躯体，鱼鱼听人们叫他做“风”，无形、飘渺、淡然、超凡，有惊涛骇浪的巨力，有飘摆柳絮的温存。鱼鱼真正爱上他，则是缘于一个涟漪。那是一个很安静的午后，鱼鱼在一个明净的岸边，水面上漂浮着岸上零散的落英，引的鱼鱼用嘴轻轻碰触着那温润的馨香。就在这个时候，有一阵无形的气流袭来，吹散了那些脉脉的花瓣，鱼鱼眼见她们随波逐流，她却再也无法一亲芳泽。她生气地看着风，美丽的鱼，生气的时候也是一样的动人。风笑了，安慰她说：“别生气了，我给你个更好看的东西。”于是他伸出一个手指，触动着平静的水面，于是，马上就出现了一个波光粼粼的涟漪，开始只是一个小小的圈，漾开了平静，荡出一片绮丽的天光，七彩的。鱼鱼被那个景象迷惑了，那涟漪中的风，看起来是那么的潇洒，像一个梦想中的天神。“我经常会在那边的林梢上歇息，有时间来找我吧！”风临走戏谑地说着。他并不知道，他已经同时在鱼鱼的心里漾开了一个涟漪，爱的涟漪。　鱼鱼爱上了风，只有她自己知道，她每天去水面上停留，等待，可惜，总是落空。她没有勇气对谁说，甚至连当年人鱼故事中的那个巫婆都已经迁居了。　　鱼鱼变得很沉默，她要去林梢，因为风在林梢，那是她心里惟一坚定的信念。　　于是鱼鱼去求浪涛，请浪涛把她带上岸去！浪涛听了吓坏了“鱼鱼，快别乱想了，天上的风，随时会经过的，为什么要去林梢呢”。　　“因为只有那里才是他的地方呀！我要到他的世界里去！”鱼鱼坚信是那道水平线阻隔了她和风的相爱。　　“可是，如果离开水，你会死的，在还没有到达林梢之前！”浪涛担心地说。　　鱼鱼不再做声了，她知道自己只有在水里呼吸的腮。她默默地回到水底，悄悄洒落别人看不到的眼泪。从那天开始，鱼鱼每天都坚持昂着头探出水面呼吸，她在自己的身体里储存大量的气，尽管那让她很难受，但是为了适应陆地的生存，她坚持着。偶尔有几次，风从她头顶掠过，依然潇洒如初，鱼鱼的声音他听不到，他在属于他的高空驰骋，如飞！　　终于有一天，鱼鱼可以一整天的在水面上呼吸了！于是她又找到了浪涛，她执意要浪涛把她带上岸。浪涛看着鱼鱼专注的眼睛，终于答应了她的要求，，鱼鱼已经是一个追寻风的失心鱼了。那么多天来，浪涛看着鱼鱼在水面上艰难的游弋和呼吸，那是何等执着的一条鱼啊！　　那天退潮的时候，鱼鱼被浪涛围着拥着，轻轻的推上了沙滩，淡金色的沙滩，在夕阳下是一种美好的细致，美丽的鱼鱼静静地躺在这片沙滩上，浪涛已经退去，再回头也是不可能的了。终于，鱼鱼离开了水界，她温存的想念着风，他的身上是不是也镀上了一层金色的光晕，“就像一个太阳神！”鱼鱼欣喜的想。　　鱼鱼忘记了自己是无法在陆地上行走的，她只有一条像人鱼公主一样美丽的尾巴。就在这个时候，沙滩上来了一只散步的小猫。一只猫，对于一条鱼来讲，也许就象征着死亡。小猫发现了这条美丽的鱼，他停下来，用爪子翻弄着鱼鱼。无疑，这是一条美丽而且新鲜的鱼呢。可是，为什么鱼的眼睛里会充满了淡淡的柔情呢？尤其，在她将死的时候？　　小猫问鱼鱼：“你为什么要到岸上来？”他决定，看在这条鱼那么美丽的份上，再给她一次说话的权利。　　“因为我的爱人在岸上。”鱼鱼回答着，落下一滴泪来，掉在金色的沙滩上，转眼，消失了。　　“你的爱人不是一条鱼吗？”小猫好奇地问。　　“不是，他是无所不能的风，看。”鱼鱼凝望着远处的林梢，眼睛里带着雾一般的憧憬“他就住在那边的林梢！”于是鱼鱼告诉了小猫，关于自己为了上岸所做的所有努力，和她无发行走的痛苦。　　在临死之前的倾诉，如何不动人，何况是一只涉世未深的小猫？　　于是小猫决定要帮助鱼鱼，他轻轻地叼起鱼鱼，生怕弄疼了她。他向林梢跋涉。是的，那样远的距离，对于小猫是一种跋涉了。路上有丛生的荆棘，刺痛了小猫稚嫩的毛皮，尖锐的石子，划伤小猫柔软的肉垫，可是他还是向前走着，他怕看到鱼鱼绝望的眼睛。　　鱼鱼看到一丝血痕留在了小猫走过的路上，鱼鱼的眼睛酸酸的，有点想哭！　　天上的风经过，豪放地呼啸着，没有注意到，下面有一条鱼和一只猫在行进。　　在林梢的下面，小猫几次想爬上那高高的树，可是他受伤的爪子和疲惫让他再也无法帮助鱼鱼了，于是他说：“鱼鱼，你回去吧，你是见不到风的，我把你送回水里，好吗？”　　鱼鱼固执的摇头，她看着小猫渐渐的远去，也放弃了回到水里的机会，她要找风，每离他近一点的时候，她的信念就坚定了一点。　　鱼和风啊，多可笑的一个梦，可是，鱼不觉得，风呢？　　是一群蚂蚁发现了鱼鱼，好大猎物，寻常的蚂蚁，是见不到鱼的吧。于是整个蚂蚁家族都轰动了，无数的蚂蚁跑来看鱼鱼，最后蚂蚁们决定，把鱼鱼搬回洞里去，鱼鱼哀号着，声音凄厉，可是没有人听见，风在林梢上栖息，看不到下面一群蚂蚁和一条鱼的行进。　　鱼鱼的倾诉再次打动了蚂蚁们善良的心灵，鱼鱼感觉到了身下的蚂蚁们改变了方向，她本来因绝望而空洞的眼睛再次看到了她心仪已久的林稍了。蚂蚁们的汗水流下来“嘿哟嘿哟”，鱼鱼听着蚂蚁们的口号，感激慢慢地浸透着她的心。她的身体倾斜起来，她渐渐地离开地面，愈升愈高。一群黑云般的蚂蚁，共同努力着，把鱼鱼美丽的身体，送向她梦幻中的林稍，送向她心爱的风。　　林稍是树林最高的巅角，风栖息在上面，所以那里的枝桠都是颤抖着的。鱼鱼的身体很难保持平衡，但她的心还是那么坚定。她，终于见到了风，她深爱着的风。无数的蚂蚁在她身后看着她和风的相遇，看着那爱情最终的甜美。　　风淡淡地微笑着，嘴角上，还是有一点玩世不恭的态度，他看着鱼鱼，这真的是一条美丽的鱼，每一片鳞片上都有让人眩目的光芒，“你好啊，美丽的鱼儿，我们又见面了！”　　鱼鱼发现自己终于可以面对风的时候，她激动地说不出话来，等她可以说话，她说的第一句话是：“风，我爱你！”　　风的态度很平和，似乎那是他习惯了的场景，“可是，爱我的人很多呀！”　　“可是，我是很努力很努力的来找你的呀！”鱼鱼悲哀地说着。　　“可是，我马上就要走了呀！”风盘旋起来吹落了林稍上的几片枯叶，风呼啸着，冷淡地说了再见，然后，风像他以前一样毫不留恋的离开，宛如一个路人。　　那个，就是风。　　风走的时候，林梢剧烈的震动，鱼鱼的身体也像枯叶一样，从林梢滑落，无数的蚂蚁拥上来拉住她，可是那些无力的手臂，再也无法拉住鱼鱼灌铅一般沉重的心。　　在坠落的时候鱼鱼很安详，因为，风已经不在林梢了。　　鱼鱼的尸体落在树下，虽然是尸体，看上去还是那么的美丽，和所有的鱼一样，不管是否有生命，鱼，是无法闭上眼睛的。　　树下，有一个失心的疯子，他剖开了鱼鱼的身体，一切都很正常，只有那颗小小的心，碎裂成了几瓣。疯子在树下埋葬了鱼鱼，曾经是那么美丽和执着的鱼鱼。　　有风吹过，吹起了疯子的头发。疯子呢喃着：“原来，你和我一样，你是一条没心的鱼……”[/color][/color][/color][/color]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('982', '2000', '[COLOR=#000000', '我们的爱已经结束了，昨天的风景就这样成为我生命中的一个符号，刻画在我的内心深处。败笔是经典的衬托，映出内心的天空。我不想在想念梦中的美景，那只是彩虹刻画的天空，稍纵即逝。现实和虚幻之间总有一场美梦，来来往往的人穿梭在其中。今天，我的梦已经醒来，虽然现在看到的好是夜空，当至少还有灵魂在，可以给我勇气去冲，有时，梦想与现实的差距不只是一线之隔，我在无谓的困惑中挣扎，寻找一个貌似真理的答案，或可以在理想的爱情梦境中幸福的死去，如果那能算幸福。我相信每个人都是有翅膀的，长在灵魂上面，思想是左翼，梦想是右翼，于是我', '', '');
INSERT INTO `dede_addonarticle` VALUES ('983', '2000', '蝴蝶流传这样一种传说,那就是它们的另一半都是住在海的那一边的,所以说它们必须做选择是否穿越沧海.不穿越,它们会寂寞而死，穿越,它们会折翅而死.大部分蝴蝶选择穿越,即便知道最终的结局是折翅是泣血是沉沦,却依旧为心底那个美丽的信仰而试一次.蝴蝶好傻,我也好傻.蝴蝶沧海飞,却能让海洋感叹人生过于长久过于孤单……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('984', '2000', '我看见天空很蓝就像你在我身边的温暖生命有太多遗憾人越成长越觉得孤单我很想飞多远都不会累才明白爱的越深心就会越痛我只想飞在我的天空飞我知道你会在我身边回忆的画面记录的语言爱始终是你手中长长的线载着我的想念飞过了地平线你温暖的笑脸还一如从前回忆的画面记录的语言你说要我学着勇敢一点偶尔哭红双眼你一定会了解眼泪试我心中另一种完美', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('985', '2000', 'GoddessonthemountaintopBurninglikeasilverflameThesummitofbeautyandloveAndVenuswashernameShe\'sgotitYeah,baby,she\'sgotitI\'myourVenusI\'myourfireAtyourdesireWell,I`myourvenusI`myourfireAtyourdesireHerweaponswerehercrystaleyesMakingeverymanamanBlackasthedarknightshewasGotwhatno-oneelsehadShe`sgotitYeahshe`sgotitI\'myourVenusI\'myourfireAtyourdesire', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('986', '2000', '孙燕姿--我也很想他那时我们总有好多话什么事都可以讲我的爱情比你早却一直放在心上后来你们之间的变化我不想再多说话经过了相遇挣扎我还是无法将他放下那是多久后的事了有一天你突然问我在那个时候是否也爱着他我也很想他我们都一样在他的身上曾找到翅膀只是那时的他是因为你他开始飞翔我也很想他在某个地方我少了尴尬你少了肩膀而夏天还是那么短思念却很长还记得那年我们三人许下的愿望星星骗了我们我们却因此上了一课成长必修的学分我们都一样', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('987', '2000', 'AnotherheadhangslowlyChildisslowlytakenAndtheviolencecausedsuchsilenceWhoarewemistakenButYouseeit\'snotme,ItsnotmyfamilyInyourhead,inyourheadTheyarefightingWiththeirtanks,andtheirbombsAndtheirbombs,andtheirgunsInyourheadInyourheadtheyarecryingInyourhead,inyourheadZombie,zombie,zombieWhat\'sinyourhead,inyourheadZombie,zombie,zombieAnothermother\'sbreakingHeartistakingoverWhentheviolencecausessilenceWemustbemistakenIt\'sthesameoldthemesince1916Inyourhead,Inyourheadthey\'restillfightingWiththeirtanks,andtheirbombsAndtheirbombs,andtheirgunsInyourheadInyourheadtheyaredyingInyourhead,inyourheadZombie,zombie,zombieWhat\'sinyourhead,inyourheadZombie,zombie,zombie', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('988', '2000', '我爱他！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('989', '2000', 'happybirthday!静姐生日快乐~希望你能一直快乐幸福~神一定会祝福你，保佑你，因为你是唯一的cyy的独一无二的最好的静姐~静姐生日快乐', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('990', '2000', '[你想我点啊？？我跟他真的有缘分吗？？读学校要读在一起！连住的地方都一样就在我的隔壁！但你和我的心是一样吗？当我看见你的时候我从你的眼神中好像有好多话跟我说！但你总是不敢跟我说话！你要我怎样你才满意呢？我真的好喜欢你！但你的心是怎样想？？我不等了！！我决定放弃你！！去追求我的自由！！如果有缘分！我相信我们回再一起的！！但我现在只想读好我的书！你也一样！！希望我们的爱会在大学中继续…………………….之到永远……………….我真的好喜欢你！！！！！[[/color]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('991', '2000', '我就是想啃你但是搞个日记告诉你我想啃你是不是有点太正式拉不管拉啃下先知道为什么我总是想啃你吗因为我知道你是个要账必还的人这样你就要回来啃我拉嘎嘎', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('992', '2000', '我就是想啃你但是搞个日记告诉你我想啃你是不是有点太正式拉不管拉啃下先知道为什么我总是想啃你吗因为我知道你是个要账必还的人这样你就要回来啃我拉嘎嘎', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('993', '2000', '我就是想啃你但是搞个日记告诉你我想啃你是不是有点太正式拉不管拉啃下先知道为什么我总是想啃你吗因为我知道你是个要账必还的人这样你就要回来啃我拉嘎嘎', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('994', '2000', '我就是想啃你但是搞个日记告诉你我想啃你是不是有点太正式拉不管拉啃下先知道为什么我总是想啃你吗因为我知道你是个要账必还的人这样你就要回来啃我拉嘎嘎', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('995', '2000', '穿你给我的衣服爽~~电视告诉我做女人挺好其实做男人也挺好~~是不~~~~可~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('996', '2000', '[COLOR=#008b8b][/COLOR]好累啊!!为什么只放一天的假,会有这么多的作业!我都不知道读书真的这么重要吗?天天都这么累!!如果神再给一次机会我!我希望做一只小鸟,最起码可以得到自己的自由!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('997', '2000', '今天心情不爽，哼没，诶人让我拿来出气。我喜欢的那个她啊，你的心还有你的那个忘不了的他吗？其实我早就知道了，就连你的qq用的网名都没有忘了他，你告诉我忘记一个人是需要时间的，那么爱一个人也需要时间吗？爱可以等人，忘记也要等人吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('998', '2000', '劲舞,一个游戏..虽然说,在这个里面..遇到的事并不现实...但是在游戏里..和我们一起玩游戏的..也是人,也有七情六欲..不是吗..?在劲舞里..我遇到勒一个男生..他很狂妄..可能是因为,他是华南第一的关系吧.?确实吖.他是华南第一名..可是,那又怎样..?是华南第一,就可以狂妄吗?那个时候,我还在华北玩..偶尔回华南看看..结果就让我遇到勒这样一个人..我对他的印象很糟糕..但是,却很想和他比比的想法..就因为他是华南第一..我想挫挫他的锐气..于是,我找他单挑..他的回答是很不屑..哼,有什么了不起的..华南第一就这样狂妄.?要不是看在他是我朋友的朋友..我真的会开骂..在后来的日子..我转回华南玩勒..天天看见他..我看见他就不爽..总想踩他..所以,每次碰见他..我就找他单挑..可是他就是不和我单挑.久而久之,就没想过那件事勒..在某一天,心血来潮...又看见他勒.我又找他单挑..并且,我们打赌..如果他输勒,就做我老公..当时,我并没有想那么多..毕竟只是一时的心血来潮..可是,我没有想到的是..我和他竟然会发展到今天这样..?比赛的结果是..我输勒.华南第一..毕竟是华南第一..怎么可能没有一点技术呢.?是我想的太天真勒..但是,我输的很不甘心..因此,我把目标定成勒他.!我发誓,我要超过他!待续..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('999', '2000', '\"某一天,我在劲舞...他突然对我说勒句话..\"\"在吗,我想和你聊聊\"\"我关勒游戏,和他聊天..\"\"在吖,我在游戏..怎么勒.?\"\"\"\"没,想找个人聊聊..\"\"\"\"喔,是吗.好吧我陪你聊.\"\"\"\"恩,谢谢\"\"\"\"客气吖,想聊什么?\"\"......在那一天,我和他聊勒很多..\"\"我想好好找个女生一直在一起.\"\"\"\"难道,你没有老婆吗?你在劲舞里老婆不是很多吗?\"\"\"\"没有,那些都是好玩叫的..真正的并没有.\"\"\"\"喔.是这样吖..\"\"\"\"恩\"\"\"\"那么,你是想找个女生,好好的在一起咯?\"\"\"\"恩.是的.\"\"\"\"那么,你有合适的人勒吗?\"\"\"\"没有.不过我想问问你.\"\"\"\"恩,你问吧.\"\"\"\"你愿意和我一起吗?好好的在一起?\"\"\"\"我?为什么,你会问我吖?\"\"\"\"没什么,你不愿意就算勒\"\"\"\"呵呵,让我考虑下,好吗?\"\"\"\"恩,好吧,下次来的时候,给我答案!\"\"\"\"恩,好吖.下次告诉你答案.\"\"\"\"恩,那我下了..记得告诉我\"\"\"\"恩,知道勒.掰掰.\"\"\"\"88..\"\"........也许,这是缘..一种很奇妙的感觉.在我心里,一直成长...待续..\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1000', '2000', '今天心情不错！申请到了日记本', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1001', '2000', '今天有人感冒，我也多少受到影响，鼻子有点赛赛的，不过并没影响到我的心情，嘿嘿～～～', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1002', '2000', '你永远不会令我伤心，因为我爱你，如果有一天你离我而去，我不会怪你，因为那只是生活验证了一段失败的恋爱！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1004', '2000', '这几天一直都在下雨，而且加上我感冒了，本来想着他还可能安慰安慰我，可是谁知道，就因为一件非常小的事情他跟我闹别扭。我只是告诉他别再用别人的名字上论坛了，（因为他的论坛名字跟他的好朋友名字是一样的，使他看到他朋友的名字后他才起的，而且他的朋友告诉我说他冒充他的身份让年别人给他介绍工作）。当他朋友告诉我的时候，我能不生气吗？我觉得他真的很没出息，也很没本事。但是这些话我不能对他说，因为我爱他。我只能去包容，别人说她是伪君子，我能怎么办，我只能告诉他你最好做回你自己，一切都要靠你自己。我说你从注册一个论坛的名字，他就很生气，他问我怎么了我告诉他不要在用别人的名字了，我甚至都没告诉他他朋友给我说的那些话，他就已经生气了，他太小气了。我真的不知道该怎样给他说。我多么希望他能做回自己，他就是很虚伪，他觉得我上了他的自尊，可是我错了吗？他凭什么这么对我？他有什么资格这样对我？我对他太失望了！以后我们可能会结婚，难道我连告诉他怎么做才好都不行吗？以后要是结了婚，那我不回连发言权都没有了？真的希望他能理解我，而不是一味的责怪我，更何况我还没有做错什么事情！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1005', '2000', '以前的我..单纯而又天真..现在的我什么都没有..那以后的我将会怎么样呢。??曾经的我,,在家里是个听父母话的好孩子..在学校是成绩偏上的好学生。.而我却为了几个不值得的朋友..为了她们我离家出走几个月..不顾父母的死活..不管邻居的议论菲菲..为了她们我走出了原本平静的世界..但是结果怎么样呢。??我为了她们这么多的付出.她们的回报却是一次又一次的加害于你.我承认..曾经我是想过跟她们绝交..但是这话说起来容易..做起来真的很难..我好难受.!本想在外打工赚点钱回家..但是她呢.???帮我钱偷光.我心里难受..我对她这么好..我从来不对她发脾气.!我都忍.!但是她为什么这个样子对我.??我是不是欠她的呢。?我为了她跟我几个好姐妹都翻脸.!我曾经以为她所做的一切都是她的性格。!我一味骗自己..大家都说我傻..可是她就是这个样子。!不过在外面我明白了许多的人情世故..明白了许多道理.!不是吗。??也学会了做人.这倒要谢谢帮过我的人。!马上中秋了。!我也该回家了。!不管怎么样。!我都不会怪她.!因为人做大的心就是宽容不是吗。??我也想在我最后几天里能帮她的我依然会帮.!我也只能尽力而为了..那我回家以为我也祝福她真正懂事..学会自己照顾自己.!独立生存.!我会想大家.!曾经的好姐妹。!--------------------------------------------------------------------------------[sound]http://www.qq163.net:8080/openrm/supers.htm?song_id=super/song/22.rm[/sound]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1006', '2000', '[COLOR=#0000ff][/COLOR]白天是我的舞台..黑夜是你的床.......可我偏偏爱上了你爱上了你那深沉如繁星的笑脸。..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1007', '2000', '有甜,就有酸.是酸,也是甜.点点滴滴都是青春滋味。我喜欢自己体会.这是我的青春我要我的滋味.!~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1008', '2000', '[color=#ff69b4][/color]设置/取消置顶复制本文网址今天是⒈7号.!~明天.!~明天就是⒈8号了.!~中秋节.!~明天就是我回家的日记了.!~是的.!~我也该回家啦.!~是时候应该忘记曾经的事乐.!~回家.!~不要在做傻事.!~为了不值得的事!~放弃自己的幸福.!~不是吗.?~人有的时候是也会自私的。!~我也该自私一回.!~因为我明白太多的牺牲不会有回报.!~我现在只能自己走自己的路。!~一步一步坚强走下去。!~以前我为了朋友,姐妹付出了那么多。!~但是结果又是怎么样呢。?~还不是一样.!~朋友,姐妹照样背叛你.!~你又能说什么呢。?~打也不是.!~骂也不是.!~只好忍.!~唉.!~回想起在外的这几个月.~好心酸.!~受了那么多的苦.!~我又能找谁诉说呢.?~以前在家里。!~我什么事都依靠父母.!~别人都说在外靠朋友.!~但是我又能靠谁呢。?~我害怕.~心寒.!~但是又有什么用呢。?~想到自己马上回家了.!~不禁高兴又有点失望.~就要离开她们这些好姐妹。!~曾经敌人我们是敌人.!~因为种种误会所以是敌人.!~现在说清楚老。!~我们是好姐妹。!~好舍不得.!~但是又有什么用呢.?~唉.!~我还是放弃算老。!~不管别人怎么想。!~我只能祝在外的人什么都顺利.!~我呢。?~又该回到我的从前里.!~我最后自私一次.!~[em]e51[/em]〈.-久未放晴的兲箜依旧騮着妳的笑容..&.?今天是⒈7号.!~明天.!~明天就是⒈8号了.!~中秋节.!~明天就是我回家的日记了.!~是的.!~我也该回家啦.!~是时候应该忘记曾经的事乐.!~回家.!~不要在做傻事.!~为了不值得的事!~放弃自己的幸福.!~不是吗.?~人有的时候是也会自私的。!~我也该自私一回.!~因为我明白太多的牺牲不会有回报.!~我现在只能自己走自己的路。!~一步一步坚强走下去。!~以前我为了朋友,姐妹付出了那么多。!~但是结果又是怎么样呢。?~还不是一样.!~朋友,姐妹照样背叛你.!~你又能说什么呢。?~打也不是.!~骂也不是.!~只好忍.!~唉.!~回想起在外的这几个月.~好心酸.!~受了那么多的苦.!~我又能找谁诉说呢.?~以前在家里。!~我什么事都依靠父母.!~别人都说在外靠朋友.!~但是我又能靠谁呢。?~我害怕.~心寒.!~但是又有什么用呢。?~想到自己马上回家了.!~不禁高兴又有点失望.~就要离开她们这些好姐妹。!~曾经敌人我们是敌人.!~因为种种误会所以是敌人.!~现在说清楚老。!~我们是好姐妹。!~好舍不得.!~但是又有什么用呢.?~唉.!~我还是放弃算老。!~不管别人怎么想。!~我只能祝在外的人什么都顺利.!~我呢。?~又该回到我的从前里.!~我最后自私一次.!~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1009', '2000', '现在的俄.!~已经不在是以前那个单纯的俄了.!~因为.~俄变乐.!~大家都说.!~俄在乎的不不俄变好变坏.!~而是俄已经没有以前那样的开朗,活波了..失去了以往的那些..唉.有种说不出的味道.!~现在的俄心里好难受.!~昨天都哭了好几次了。!~为了什么.?就是为了这⒉个姐妹.!~但是俄也不知道为什么俄现在变起这个样子。??~俄觉得很多付出都是的不到回报的。!~俄还是愿意付出的!~但是...现在经历了这么多事.!~不是俄不肯付出.!~是俄害怕.!~在说。!~现在俄放弃了俄的前程陪她们.!~她们呢。??俄感觉她们越有点..唉.俄也不好说.!~我感觉好像俄越在乎她们..她们求越要求你.~但是她们又做到了吗.???~好烦.!~也许是我想多老吧.!唉.!~准备在家静静的养几天神.!~回忆一下什么是值得跟不值得.!~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1010', '2000', '[COLOR=#ff8c00][/COLOR][sound]http://www.xy186.com[/sound]]你在爪子喃...睡告告打呼呼哇...!!嘿..不晓得为啥子..我会想你哈.!浩爱人..我每一天都只能因闪烁的头像..而感觉到心跳..!!你是不是喃..我想你一定不在乎我..否则..你不回短短的闪烁后消失不见..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1011', '2000', '[SIZE=3][/SIZE]今天听说.你在打听我勒消息..听说你问他们现在勒我过的好不好..听说你问现在勒我..还是不是一个人....也听说你问..我是不是还和从前一样经常发烧..经常委屈后大哭..也听说你对这边勒期盼..听说你想回来...我手足无措...你不要回来好不好..好不容易.我可以开始一段新勒生活..好不容易..我学会怎样掩藏自己..好不容易学会伪装..好不容易学会开始有点..淡忘...我不想现在勒生活被打乱..现在这样很好不是吗.?你在那边也过的很好..你为啥子要回来..?这边有你那么多的痛苦.与遗憾....我现在变咯..你也找不到以前勒颜颜咯...你回来咯..我们又要为彼此..担心..我会每天焦虑..你几个小时没给我打电话是不是出事咯.我会在你到外地办事情勒时候...不赶拨下电话最后一位..害怕接电话的人不是你..而是谁谁谁..告诉我你又和谁发生冲突后..你做咯什么冲动的事情..我真勒害怕....不要..你回来咯..你要为我担心..我在上班或者上学时..会不会受咯委屈...你会不要我上班..告诉我你不需要我挣钱...你会担心天冷咯我是不是穿够咯衣服...是不是会穿个裙子切上学....你会担心放学时接不到我人...是不是背改死勒老师..留下来批评教育我和不良人员一起,..鬼混..你会担心..我最好的朋友..意多多..始终无法接受你...想尽办法..隔离我们..!!你会担心朋友和你之间我到底选谁...你会担心你带我去勒场合我会不会感到厌烦..何必呢..不如..我们过安稳的日子..我已经有咯浩爱人..我不会再回头..我希望某一天也有这样子一个人在你身边...你会慢慢淡忘这边的记忆...答应我..不要再想起..带给遗憾和伤痛最多的我...我不会忘记你曾经那么的疼我..宠爱我..给过我美好的回忆..!!對伱最後的疼愛.!!_手放開.*.!今天听说.你在打听我勒消息..听说你问他们现在勒我过的好不好..听说你问现在勒我..还是不是一个人....也听说你问..我是不是还和从前一样经常发烧..经常委屈后大哭..也听说你对这边勒期盼..听说你想回来...我手足无措...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1012', '2000', '今天又是很难熬的一天，因为今天一天的课都是我最讨厌的，简直生不如死', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1013', '2000', '是不是得不到的永远都是最好的。太容易得到的都不是最珍惜的。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1014', '2000', '15：58他回成都了', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1015', '2000', '买手机了，西门子M55', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1016', '2000', '一大早起来，心情就太糟，洗了头发，一点都没减少这烦躁的心情在我的心中滋生，而且越来越严重，可能是天气的原因吧，一连几天都在下那些让人讨厌的雨，烦啊！这可恶的天气！！让人一走出门就没劲，想睡觉！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1017', '2000', '2005年8月3日20：54这一天，大概永远都不会忘记了，', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1018', '2000', '2005年8月20日21：16他第一次开口说爱我。但是令我感到害怕。我们距离那么遥远，未来是那样的不确定，我没有勇气接受。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1019', '2000', '2005年8月21日我们短暂的感情就在这天的17：57分结束了。也许正因为得不到才会倍加珍惜。至少在年轻的时候会经常想起，这段遗憾的感情，我们本是属于不同的世界，不同的人群。我没有勇气追随，也没有勇气接受。注定不能在一起。以后会是什么样子，我害怕知道。我害怕过早的知道结果还要来承受。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1020', '2000', '一个人的世界，是多么的孤独，思念一个人是多么的快乐，', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1021', '2000', '据说这是某大型外企一道月薪两万的面试题，大家来试试啊，看看你能拿多少啊?小明和小强都知道王老师的生日是下面10天中的某一天，但都不能确定。于是老师将他生日的月份告诉了小明，而将具体哪天告诉了小强，让他们猜。小明说：“如果我不知道的话，小强也一定不知道！”小强说：“本来我不知道，但现在我知道了。”小明又说：“那我也知道了。”王老师的生日是下面10天中的一天，3月4日，3月5日，3月8日，6月4日，6月7日，9月1日，9月5日，12月1日，12月2日，12月8日。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1022', '2000', '男人比女人还痴情每一个男人都是这样，他可以对每个女人说“我爱你”，但他一辈子只会爱上一个女人，只有一个。女人需要的是一个关怀她，爱她，可以让她依靠，保护她一辈子的人，当她遇到一个男人时，爱的死去活来，山盟海誓。因为种种原因的分开，她不会再记得他，或者说不会记得那么深刻。因为当她遇到一个更好的男人时，她会拿两个人来比较，她会觉得遇到更好的是她的幸运。但男人不是这样，当他爱上一个女人，真真正正的爱，他不会在爱上任何一个人。当这段感情失败后，他会把这段记忆放在心里，把这个女人放在心底。原来一个男人可以把很多女人放在心里，但一辈子只有一个女人可以在他心底。无论他以后会再相处再多的女人，他都会清楚的知道，自己最爱的是谁。无论以后他遇到的女人多么优秀，他也不会改变。因为他心底的女人是他的支柱，他不会用她和任何一个人相比，他认为这种比较是愚蠢的，他一辈子只会爱她一个。放在心底的女人，永远的伤痕。男人都是爱面子的，也许他平时会活的很潇洒，但在一个人孤独的时候，他会放下所有的尊严，放声痛哭，思念唯一的她。男人的爱一辈子只会付出一次，你得不到，因为你不是。男人的痴情，女人的多情,只有死才是终点。　　......真的吗这个。这个是今天在论坛上看见的，，，，', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1023', '2000', '我他媽的那麽愛你,妳他媽的愛理不理我她媽的為你淪陷.妳他媽的裝沒看見我他媽的為你自盡,妳他媽的愣不相信我他媽的為你跳樓,妳他媽的才肯回頭妳她媽的回心轉意:我他媽的決定放弃', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1024', '2000', '当你爱上对方时，应该会有这九种情感，才能算是一个真实的爱情，最起码，你应该扪心自问，将来是否有可能培养出这样的情感来，才能确保你拥有一个真的爱情。　　一、占有欲：　　爱情是绝对独占的，不能与人分享亲密的男女关系。所以需要以结婚来持续一份爱情，在结婚时彼此相约相许。因此在真实爱情里，互相许诺忠诚是必要的。　　二、美丽的感觉：　　在有爱情的时候，我们会觉得对方最好看，即使有别的异性比你所爱的对象好看，但对你而言，他(她)才是最好看的，而且是别人无法相比的。　　三、亲爱的感觉：　　当你真正爱上一个人，你会有一种很亲切的感觉，他让你觉的很舒服，你可以信任他、依靠他。他像是一个亲密的家人，甚至可以说，比一个家人更亲密，这是亲密加上一种温馨的感觉，就是亲爱的感觉。在这爱情国度里，他不会挑剔你的瑕疵，因为他愿意包容你所有的缺点。　　四、羡慕及尊敬的感觉：　　一个健康的爱情关系，应当有以对方为荣的感觉，我们会去欣赏对方内在和外在的条件和优点。而且对方也处处以我们为荣。如果我们能有这种感觉，不论他是成功或失败，都会使我们欣赏他的才华。　　五、赞许的爱情：　　当相爱的时候，我们喜欢夸奖对方，而且不仅是欣赏而已，还喜欢对他人夸奖对方，从夸奖对方的热诚之中，我们可以因此感到无比的快乐。　　六、受到尊重的自尊：　　一个健康的爱情关系，可以提高一个人的自尊心。让对感觉到活得更有价值，因为爱情使你觉得你有无人可比的独特性，虽然你有优点也有缺点，但是你的独特性使你受到无比的尊重，生命因此而有了价值。　　七、生理上的冲动：　　当我们对一位异性产生兴趣或爱上某个异性时，希彼此有身体上的接触。在真实的爱情生活里，这种欲望是永远存在的。性冲动并不单单只是行为，它还包含了许多其它亲密的身体上接触，譬如牵手、拥抱等等，这种情感会永远都存在爱人的心里。　　八、行动自由：　　如果个人有正当的理由，他行动的自由一定要受到尊重，才不会破坏两人之间的爱情关系。　　九、深重的同情心：　　我们对深爱的人常会有怜惜的感情，经常会为对方考虑，如果对方受到挫折，我们会非常愿意与他分担痛苦和挫折，把对方的苦当作自己的苦难一样，或者更胜于自己的苦难，因为我们愿意为对方而牺牲自己的利益。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1025', '2000', '现在是第三节课，我正在上殺比老師的課，心中的鬱悶就不用說勒，簡直有種想讓他在人間蒸髮的想法', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1026', '2000', '呵呵。。今天是注册的第一天诶。。就为老公写第一篇日记。老公在学校是不是很辛苦啊。。要好好学习，老婆还等你回来娶我捏。。。我要当军嫂的哦~~`哈哈。。还有4天就可以见老公了好期待的捏。。。不知道老公黑了么？？？头发剪短了。。难看了吧。。嘿嘿。。。不管老公变成什么样老婆都喜欢的哦。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1027', '2000', '莫名其妙的感到恐慌。大概是快畢業暸。要離開生活暸4年多的校園。眼看這同年級的人一個個走暸。什么時候我纔能灑脫的甩甩頭離開。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1028', '2000', '結婚的那些人真的單純想的就是白頭偕老嗎？結婚？生子？傢庭主婦？恐怖！～我不想未來的5，6十年要每天麵對統一張臉孔。莫非？難道？我花心？～！～書上說雙子座的很思想跳躍性很大，要跟她戀愛就要經常有新鮮的東西。經常扮縯新鮮的角色。可是？？我十那樣的嗎？？目前還沒有髮現。但是我確實不喜歡一成不變的東西。要新鮮吧又沒有追求的膽量。至少沒有勇氣追求非常潮流的東西。唉。。落后啊。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1029', '2000', '什麽嘛！！！！好讨厌哦。。。老公好不容易来上一次网，都停电了。。郁闷嘞。。。强烈bs老公学校。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1030', '2000', '算你家的电话号码。首先.请将电话号码的【前】4位数字输入计算器(若你家电话号码不足8位时,就输入【前】3位)2.将它乘以803.+14.乘以2505.+电话号码的【后】4位数字6.再加一次电话号码【后】4位7.将总数-2508.最后将屏幕上的数字【÷】2', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1031', '2000', '[COLOR=#ff69b4][/COLOR]偶的浩浩还在睡觉.我发咯n个消息.他都在睡觉.没回.!!喔.!!我不干嘛.我无聊极咯.昨天他问我愿不愿意等他.!!好兴奋喔.!!未必他真的把我当成那么回事.!!嘿嘿..今天心情不错.!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1032', '2000', '刚刚老公来电话说放假啦。。ye.......还有两天就可以见老公了哦~~~开心开心', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1033', '2000', '离开并不代表不爱.只是一味的放逐只能让自己越陷越深', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1034', '2000', '\"TakanarukodouwayuugurenoKiminosugataniSHINKUsuruMisenaiPURAIDOsasayakanaKiminosubeteniSUINGUsuruDoyouknowit?TsukinoakariwoseoiKarandekitaunmeinoitowoouNegaisonokotaewamienaiJamanakumogakasundasonosakiwaMoshimokimigahitorinaramayowazutondeikusa(OrenoikusuehisokanianjisuruhitoHoney!)MoshimodarekatoitatokiwatokerunokanamahouwaHarisakesounamunenoitamiwa...SetsunaiomoiwawasurenaiDeainohimadeRINKUsuruKonaiyoakegamatsuoreniAnohinokimigaUINKUsuruDon\'tyouknowitYumedeaerebamadaii\"\"Akirameru\"\"tokon\'yamoiikikasuItoshiikonokimochiwakienaiDakaraashitawakitaisurundakonosakiwoMoshimokimijanakattarakurushimukotomonai(OrenoikusuehisokanianjisuruhitoHoney!)\"\"Moshimoanotokiawanakerya...\"\"nanteiminaikotoKimishikamoumienaindakaraUptodate,bemybaby!comeon!!!Uptodate,bemybaby!Kintounoainantemoutouninai!MurinidarekawoaisouantemurimurimurimuriKonoainoomosawachoudokyuuchoudoyokunantekangaejaDAMEEJIDAMEEJI!ImatakanarumunereiseinikiminitodokeyokesshinnoMESSEEJI!Moshimokimijanakattarakonnaniaisenai(OrenoikusuehisokanianjisuruhitoHoney!)MoshimosamenaiyumenarabakonounmeitaguriyoseKiminomotoeomoitodokeni...Kimishikamoumienaindakara\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1035', '2000', '[COLOR=#EEE8AA][/COLOR]他终于上网咯..好兴奋喔.!!虽然我晓得总要有个结束勒时候.!!总会有我不想看到勒结局.但不知道为啥子..会那个样子..!![GLOW=255,red,2', '他终于上网咯..好兴奋喔.!!虽然我晓得总要有个结束勒时候.!!总会有我不想看到勒结局.但不知道为啥子..会那个样子..!!', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1036', '2000', '我希望你能如同你在电话里说的一样，到时候你能回来，这是我的一个小小的要求，千万不要让我失望，现在我就在盼望那一天的到来，如果说那天你没有回来的话，我想我是不会原谅你的。。。但愿你不会让我失望吧！！！晚安！！！！玩得开心点，有家人在身边的时候还是拿那么一点点的时间来想我吧！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1037', '2000', '我日喔.现在勒人都假.假的很.久咯不联系.啥子都求变咯.!!赚钱.赚锤子..网上勒幻觉人物更是说锤子.!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1038', '2000', '心情很复杂，我的表达能力差，So，写篇流水帐爱是我唯一不变的信仰虽然我是真的很喜欢你，但为了我的诺言，为了我们的友谊，为了.....我不可以和你在一起Sorry,Iloveyou一切就这样，让它在大家的回忆中慢慢淡下去，希望它在我心里永恒', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1039', '2000', '[COLOR=#FF69B4][/COLOR]现在对前途茫然..对感情不知所措..我更不知道.我勒下一站在哪,,?喜剧..明明好好的人突然消失不见..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1040', '2000', '今天他回家了，本来说好在走之前去看我的，却没有去，有点失望。。。。再过几天就是我的生日，他说过一定会提前回来陪我的。。。我现在好想那一天快点到来。。。呵呵！！！老公，你知道吗？我好想你哦！！你呢？在家，好吗？今天我就不给你打电话了，明天晚上再给你打。。。玩得开心点哦！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1041', '2000', '今天是十月一日国庆节,没想到今天的生意还不错,我们一共卖了五千多块钱....这可是有史以来卖得最好的一天呢...呵呵.....心情有点爽!!今天公司的一个同事结婚,刚从他家吃了饭回来...由于给几个领导敬了酒,搞得头有点晕...他去雅安两天了,今天我给他发了个信息,他说在看电影,就没有说什么了,说实在的,和他在一起以来,我们还没有一起看过电影呢,真羡慕他的家人,很多时候我老是想,他究竟对我是真是假,他转眼又觉得是我自己想太多了....不管怎么样,我爱他!!!!真的真的很爱他!!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1042', '2000', '曾经的点点滴滴..突然泉涌般的涌上我的脑海..不知道为什么.会突然想起来..我不懂,为什么突然一下..今天是国庆..但是,我的心情却怎么也好不起来..反而,觉得伤心..为什么,我会这样.?迷茫...心情,一点也好不起来..想玩游戏,都提不上劲..好困..两天没睡觉勒..困喔..好困喔.好烦..但是.我却不知道..我为什么而烦..?曾经的曾经..我多么天真,单纯..那个时候的我,什么都不用想.现在,我已经成年勒..要想的事情太多太多..我不敢去想,我害怕想..但是,我也没有办法..随着年龄的增长..想的事情也越来越多..好烦..好烦..爸妈,要离婚勒..小姨问我,跟谁一起.?我的回答是,谁都不跟.要跟,就一起跟..我不想曾经那么美好的家.就这样散勒..为什么,这个世界..就是那么的残酷.?好想哭..真的好想大哭一场..但是,我不能哭..即使,我哭勒.我又能怎样.?哭过之后,不还是一样.要面对着这个残酷的世界.?不过,朋友劝我说..哭过之后,再重新振作..希望如此吧.?我有那个勇气振作起来吗?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1043', '2000', '[COLOR=#ff6347][/COLOR]嘿嘿.昨天打电话找你求救..只是希望跟你联系而已..只是想见见你而已.我晓得你忙..但是你不能搞忘咯.回来请我吃麦当劳', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1044', '2000', 'foreverlove我只想用我只一辈子去爱你', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1045', '2000', '是我对你认识太少，还是我自己想得太多daslinglmissyou', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1046', '2000', '他回来找我勒.但是,对于现在的我来说..我只能说,抱歉..我和他..已经成为过去勒..再不知的将来..我只希望,他活的好好的.两年多的感情..就这样放下勒..也许,别人会说我..说我的心好狠..也许吧.但是..我怎样想,只有我自己知道..在以前,每次吵架后..都是他来挽留我..虽然,每次吵架后.我都对自己说..忘记他,一定要忘记他.但是,每次我都抵不住.他道歉的那种温柔..我害怕,真的害怕..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1047', '2000', '今天我等到了我一直以来想要的颜色，今天的我是粉红色的，', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1048', '2000', 'afriendheardthesonginmyheartandsingittomewhenmymemeryfails.....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1049', '2000', '他回去已经是第四天了,今天给我发信息,我好感动哦!!!!~~~~~~~~呵呵,再过两天,他就会回来了,好高兴~~~~~~~~~~~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1050', '2000', '今天是十月三号,家里的亲戚是昨天晚上七点多到的,感觉好久没有见面有点陌生,不知道自已现在应该怎么样去招待自家的亲戚,而且不知道该和他(她)们说些什么好,从昨天到今天我一刻都没有停留过.忙碌到现在我才安静的座下来,把一天的心情都放到日记里把它记碌下来,今天你过的可好呀!有一段时间我们没有见面了,从八月十五到现在足足有半个月的时间了,我也不知道你现在过的怎么样,挺想念你的,也不敢开口对你说,说出来这些我想也没有什么用处吧!今天是十月三号今天的天气特别的晴朗,而我的心情也和天气差不多,我的心情今天也好了很多,不知道为什么,是因为家里来的客人多了,有了过节的气愤呢.今天我很高兴,因为今天大家很难得到了一起,可是缺少了一些人,但是我们还是很开心的度过了美好的一天.现在是晚上的八点三十八分,此时我拨通了你的电话号码,因为我每晚都会很想念你,想听听你的声音,想和你聊聊,可是每晚打开qq你都不在网上,可能是因为你的路程太远,也没有多于的时间来上网吧!不过每晚我都在这个地方等你,希望有一天能看到你闪亮的头像.可是今天和平时一样我打你的电话,对方传来的声音是,你拨打的电话已关机,我的心有些失落,高兴了一天到晚上我又感觉到了孤独,因为没有你在我身边,我当然感觉很孤独,没有你在我身边,仿佛世界都没有了色彩.停下笔的时候,已经是很晚了,大家都睡去了.只能听到我自已敲打键盘的声音,而且外面的风吹过来我感觉好冷好冷.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1051', '2000', '今天是十月二号了,天气一直都没有转晴,而我的心情也随着天气的变化时好时坏,在远方的你也不知道你过的好不好呀!十一那天你是怎么过的.给你打通电话,看你一直都在用酒精麻痹自已,我的心好痛好痛,真想一下之间飞到你的身边,和你一起度过美好的一天,可是在没有经过你同意我不敢到你那里去,真是让我左右为难.十一那一晚让我真的是好伤心,那晚我失眠了,感觉黑夜真的是好漫长,冷风吹进我的房间我感觉好冷,没想到秋天的夜晚也是这么的冰冷.而我也感觉到思念一个人是这么的痛苦,拿出手机,看看已经是凌晨两点了,拿出手机,想给你发条信息,又怕打扰了你的美梦,所以就没敢给你发过去.不知道此时此刻你有没有在想我,我每晚睡觉的时候,都会让手机陪伴在身旁,明知道这样的辐射对身体不好,却一直这样坚持,怕自己接不到你的一个电话,怕自己少回了一条你的信息,不知道以后会怎么样.写到这里的时候,我的双手是冰凉的,我想你能用你的双手来给我取暖,孤寂的心灵,希望远方的你能给我安慰.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1052', '2000', '今天是我一生的一种转折，也是一种新生活的开始，正赶上国庆节好几个好久不见的朋友走在一起聚聚，在一走谈到女朋友这个问题，他们都谈的很高兴，他们问我有女朋友了没有，我说没有，哪有喜欢的女孩吗？我说有的，哪怎么不去追　呢？喜欢就去追　嘛怎么无论做什么事你是哪么有活力，可是面对感情总是哪样胆小呢，最后连我妹妹也在一边上说我了，说真的想想自己怎么会这么啊！说真的到现在为止我喜欢　上的女孩就是宋睛，她的为人她的一言一行都　让我心旷神怡，从第一眼见到她我就不知为什么心里有种暧暧的感觉，这是我以前见到其它女孩没有的感觉哦，我也说不清这是什么，也许这就是喜欢　上一个人的滋味吧，从见到的哪天起我的生活开始变得更有滋味了，也不像以前哪样人不像人鬼不像鬼的了，打心里我是真心喜欢她的，也是我第一次喜欢上的女孩，可是她哪么漂亮，哪么优秀我怎么会配得上她呢？不会有时想想世上没有十全十美的人，只要能真心对她，相信她会明白自己的心的、、、、、说了这么多不知她是否会明白我的心呢？、、从今天开始我想大胆的去面对各种挑战，无论感情，还是生活　，工作同样心平气和的去面对、、、、、、', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1053', '2000', '[COLOR=#FF69B4][/COLOR]显而易见的事情`是我自己想不开而已.!!也摸的啥子嘛..这样对于我来说..还算是一种拖累的.!!早就说过`男人应该胸怀大志.!!龌龊勒不要也好`', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1054', '2000', '如果时间可以倒流，我希望我们不要相遇。与你第一次相遇，也不知到是什么时候。而且当时连你的名字，也不知道.但我们的感情到底什么时候才会结束。连我也不知道。如果我们有缘分，你和我还会再一起吗？你就再我隔壁，为什么我们要逃避对方。是你…..不喜欢我吗？还是你以为我不喜欢你呢？？天啊！！不要这样对我们好不好！我讨厌这种生活………', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1056', '2000', '今天是国庆节的第四天了,这几天来我的心情一直都不是太好,因为没有感觉有一点过节的气氛.找朋友可是有好多人都到外地去旅游了,可我还独自一人留在保定这个让我伤心的地方.想给我最新爱的人打个电话,但是打了好多次都是关机,他有两个号码,我两个号码全打过了都打不通.我真的是又着急,又伤心.因为我很担心他,我也不知道他到底到了什么地方去了.现在已是深夜了,而我今天也不知道是怎么过来的,打开qq上线,看到了我深爱着的人在网上,我很高兴,和他打了个招呼,我们简单的聊了几句,他说想来接我,一起出去玩,我不知道是该高兴还是该悲伤,他说让我等他电话.他下线了,我高兴的不知道该怎么办好了,马上上楼打扮了一翻,等着他的电话,一个小时过去了两个小时过去了,以是十一点多了.还没有他的电话我很失忘,我想我被受骗了,在我无注的时候电话响起来了,我以为是他给我打来的电话,可是不是,是我一直担主的那个人打来的,我不知道是高兴还是不高兴.就这样我慢慢的继续等着等着~~~~~~~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1057', '2000', '今天是10月5日..他已经挽留勒我好多次.但是,我不能答应他..对于我来说..在网络上,我可以做的很无情.但是,一见面..我的心就软勒..所以,我才一直拒绝和他见面..我和他,已经成为勒过去..即使有以后..那也是在未知的将来.现在的我,只想好好读书..好好找个事做..不想再谈及感情的任何事..我也不知道为什么.我这次会走的这样无情..我很无情吗.?难道,我这样做是错勒吗?我只是希望..希望他能改变..能好好找个事做..仅此而已..至于和好..?我已经不再去想勒..因为,对我来说..过去的就过去勒..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1058', '2000', '一直盼望今天的到来，可到时候等来的却是我今天不回来的消息．．．心里真的好难过！！！！　　军，你知道吗？我一直很想你能好好的陪我玩一天，就一天，可是我觉得这一天我盼得好辛苦啊，好不容易有个假期我们都休息，可你心里想得最多可能还是你的家人，也许我本来就不该要求这些吧．．　　也不知道明天你是否真的能回来，如果是不回来，那我就彻底的失望了，要是这样的话，我以后再也不会要求你任何事情了．．．我需要的是一个能把我放在心上的男朋友不是一个只会用语言来敷衍我的人．．　　　希望你能理解我的心情，希望你能换个角度来考虑我们之间的关系．．．．．　　　你曾经问过我，假如以后我们不能在一起的话，我会不会后悔，我告诉你，我不会后悔，但是我会觉得很遗憾．．．不管将来如何你都是我最爱的人！！你永远在我心中占着重要的位置．．．我永远无悔！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1059', '2000', '\"我每晚都会到这个网站里面来,把我的心情轻轻的记录在日记当中.今天我忙碌了一天,直到深夜十一点钟我才忙完了手头上的工作.离了电脑我感觉自己的头脑好轻松,我不知道自己该用一种什么样的语言来表达自己此时的心情.我想只能用两个字来代表\"\"高兴\"\"今天见了一个很不错的网友,从来不相信网络的我,也会和网友见面,我只的是好尴尬,我想这么一个不完美的我,去见一个很美完的他是一种什么样的心情.我不知所错,我们从下午四点钟就开始约比此见面的时间,我真的心情有些忐忑不安,心想人家见到我会是一种什么样的心情,我不敢去多想,只抱着适适看的态度去见面人家.心情真的是好复杂,我左思右想,精心的打扮了一番,怎么看都感觉好像不是太理想,由于我对自己的个头实在很不满意,因为太高了,所以怕吓到别人,虽然平时我也经常出门,但是我面对的都是一些陌生的人,所以从来没有担心过什么.还好,网友见面不是那么的尴尬,比此之间多了几分话语,但是感觉还是有点担心,怕他们不喜欢我,(我所说的喜欢不是建立在爱情的基础之上的),所以心里一直很担心,我们足足待了也没有半小时的时间就分手了.这次的相见我感觉很不理想,也许我真的不是他们想的那么好,也有几分担心,怕以后人家不会在和我聊天,不会也不无所谓了,毕竟相实一场.很晚了,我想睡了,就先写到这里吧!\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1060', '2000', '\"在很久以前..我就一直在想..为什麼..人会活着.?但是,到现在..我都没有想到...感情的事...让我觉得.好遥远..似乎,远离勒这个世界..感觉,自己轻飘飘的...是,什麼..?最近,喜欢上勒一首歌..\"\"杀破狼\"\"...我觉得,这首歌的歌词..写的好深奥..有些懂,又有些不懂..\"\"生是为了证明,爱存在的痕迹..火燃烧后更伟大的生命..杀是为了歌颂..破灭前的壮丽..夜是狼深邃眼睛..孤独等待黎明..\"\"这段歌词,给我的感触很深..但是,我却说不出..是怎样的感觉..只觉得,很奇怪...现在想想,从初中毕业后..自己一个人,总是飘来飘去..好象,没有一个地方..是我应该停留的...现在的家..再也找不回..找不回,原来的那种温馨勒..爸爸,妈妈.现在居然说要..离婚.??我不懂,为什麼..这个世界,要有爱情.?如果当初两个人..是为勒.相爱才在一起..那么,最后,为什麼..为什麼.又会分开呢.?也许,我现在还小..我对这些,根本还不懂..但是,我很想知道..很想知道...到底,为什麼...?无奈...迷惘...\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1061', '2000', '一早起床,打开窗户看到外面的天气阴的很厉害,昨晚听天气预报说今天好像有雨.我喜欢下雨,因为下雨我会和我最思念的人见面,不知道什么原因这次我们错过了,一早起来就开始忙,一直忙到快中午十一点钟了才记起手机还没有开,所以打开手机以后好几个未接电话,其中有一个电话不知道是谁打的,我想也许是找我弟弟的吧,平时弟弟的女朋友经常给我打电话,所以自己也没有在意些什么.吃过午饭,和妹妹一起去买昨天下午她给定金的那件衣服,当时出去的时候雨还没有下,但是天气阴的很厉害.衣服很顺利的拿了回来,快到家了电话响起来了,我还以为是网通公司给我发来了交费电话,催我交电话费呢.可是拿出电话一看,是我一直想念的他打来了,看样子他以回到他的工作地点了.接起电话,我没有好气的给他说了两句,我还怪他走的时候没有给我打电话,他说他打了,用公用电话打的,可是我没有收到,我想是老天爷给我开了一个很好笑的玩笑吧!每次下雨我们都很顺理成章的见面,可是这次我们这次错过了机会,因为我有好久没有见到他了,我有些失落.电话接完,雨越下越大,可能老天爷知道我此时的心在落泪,我独自一人慢慢的往家走着,可是感觉好像路越走越远,仿佛我身旁的所以有都没有了.心情很复杂,语言表达不出来,感觉身体好冷好冷,好孤独~~~~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1062', '2000', '我的决定..我选择勒别人..我是真的..不再想和你在一起勒..和你在一起的日子..我好累,好累..我想要休息...好好的休息下..我知道,你的心在滴血..但是,对不起..我的心已经不在你那勒..一段已经没有感情的爱情..还有必要继续下去吗?现在的我..只希望..你能好好的照顾自己..把这段感情放下..专心做事..稳定下来..答应我,即使不再是恋人..也别再让我担心你..好吗??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1063', '2000', '我有看勒你的日记..其实,说不爱你..是假的,但是..我是真的不想再和你在一起..我才会决定离开..刚刚看勒你的日记..哭勒..还是哭勒..我又忍不住的哭勒..你为我那么努力..而我却这般无情的对你..不过,这是最后一次为你哭勒..以后,就再也不可能勒..但是,感情的事..是不能勉强的...勉强的感情,会有幸福吗?所以说,我现在只能劝你..重新再来,好好照顾自己..别再要我为你担心..我很谢谢你,放开勒我..我也祝福你,找到一个..比我更好的女生...我相信,你会找的到..我相信,你能遇到..不要再忧郁勒..好好打起精神来..别再要我为你担心勒..这个世界上..还有很多美好的事情..不是吗???以后的日子里..好好照顾自己..别再像孩子般.长不大..你要懂事勒..知道勒吗??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1064', '2000', '幾乎每隔2、3天就要去一趟超市便利店尋覓各種食物，並且樂此不疲….這個廣告每看一遍，就忍不住想笑，Q版的石頭和阿信，很可愛。不能晚上看，否則肚子會很餓請問，上海哪里有“全家便利商店”？這樣，我就可以每天輕鬆回家吃晚飯....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1065', '2000', '感觉她和我一样是个敏感脆弱的小女人，在感情的世界里患得患失，自怨自怜，沉浮挣扎。喜欢她淡淡的轻声低吟，如清清温泉干净透明，温暖紧贴着潮湿的心。有一瞬间，好象我就是她，她就是我，我们不分彼此。最喜欢这几首：静静的生活、告诉我、小步舞曲、还是会寂寞、慢歌….左手挂满了串串银手链，风吹过，手一动，就会听到清脆叮当的响铃。就像主人家每天带着散步的小狗，脖子里会发出叮叮铛铛，这样小狗不会迷路，主人不会把它弄丢。每天穿什么颜色的衣服，成了我很头疼的事。我不是明星，可是在公司，我的一举一动总是很受人关注，很喜欢穿黑色、白色、灰色、咖啡色、蓝色这些偏冷色系的衣服，他们说不好看，看上去很颓废没精神。在他们看来，我应该穿那些颜色鲜艳的，比如玫红、绿色、黄色、橙色等，说这样,看上去才有青春的亮丽。最近，我又爱上了粉红。那种淡淡的粉红，看上去没有红色张扬，却像女人脸上那抹淡淡的胭脂，散发出暗暗的幽雅和纯真，让我想起纯真的Baby.忘了在什么时候，我把快乐丢了，他很难再回到我的心里，你能不能,帮我把我的快乐找回来？累了，什么都不愿想了，也不敢要了，在找一个人，我要他帮我把爱情送回家.........写完这些,肚子饿了,我想吃梳打饼干和酸奶...那只手是我的自拍,够自恋自傲吧....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1066', '2000', '感觉她和我一样是个敏感脆弱的小女人，在感情的世界里患得患失，自怨自怜，沉浮挣扎。喜欢她淡淡的轻声低吟，如清清温泉干净透明，温暖紧贴着潮湿的心。有一瞬间，好象我就是她，她就是我，我们不分彼此。最喜欢这几首：静静的生活、告诉我、小步舞曲、还是会寂寞、慢歌….左手挂满了串串银手链，风吹过，手一动，就会听到清脆叮当的响铃。就像主人家每天带着散步的小狗，脖子里会发出叮叮铛铛，这样小狗不会迷路，主人不会把它弄丢。每天穿什么颜色的衣服，成了我很头疼的事。我不是明星，可是在公司，我的一举一动总是很受人关注，很喜欢穿黑色、白色、灰色、咖啡色、蓝色这些偏冷色系的衣服，他们说不好看，看上去很颓废没精神。在他们看来，我应该穿那些颜色鲜艳的，比如玫红、绿色、黄色、橙色等，说这样,看上去才有青春的亮丽。最近，我又爱上了粉红。那种淡淡的粉红，看上去没有红色张扬，却像女人脸上那抹淡淡的胭脂，散发出暗暗的幽雅和纯真，让我想起纯真的baby.忘了在什么时候，我把快乐丢了，他很难再回到我的心里，你能不能,帮我把我的快乐找回来？累了，什么都不愿想了，也不敢要了，在找一个人，我要他帮我把爱情送回家.........写完这些,肚子饿了,我想吃梳打饼干和酸奶...那只手是我的自拍,够自恋自傲吧....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1067', '2000', '今天真的好烦啊，为什么，他会说那样的话，我真的不知道该怎么办了，有我没我对他来说都一样，这是真的吗？或许不该相信流言蜚语，但他，真的饿可信吗，我不要再这样下去，可我放不下，好矛盾啊！到底该怎么办为什么为什么会这样，真的接受不了。文字', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1068', '2000', '[FACE=楷体_gb2012][/FACE]我是一只鱼，生活在深海之中，虽然渴望阳光，但我并不孤独，我要快乐的在这美丽的地方生活，我的生命是美丽的，相信自己！我爱我的，如果他不爱我，何必强求，我要快乐，我要寻找快乐！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1069', '2000', '每晚差不多这个时间我都会到这个网站里面来,因为这里是我的一个小角落.今天在网上又看到你了,每次看到你我的心情都会很激动,很想一下子就让你来到我的身边,不知道什么原因,一直一来我真的无法把你忘掉,难道说我真的爱上你了,当我知道这一切不幸的消息到的时候,我真的是又高兴又害怕,高兴是因为我遇到了你,不高兴就是害怕自己真的会爱上你.一直以来我知道自己很笨也很傻明明知道你是一个什么样的人还一个劲的想法设法去接近你,这到底是怎么回事,难道你没有注意我的一切吗?我一直以来在欺骗自己总以为自己可以忘掉你,可是我做不到,我真的做不到,每次在网上遇到你,就会想起我们的过去.有的时候真的很开心,即使你是在一直骗我,但我也开心的.不知道因为你的花言巧语把我给骗了还是你的某一个地方深深的把我吸引了,我真的不知道了.但这一切都不能怪你,谁叫我又傻又笨呢????', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1070', '2000', '可可不要翔翔拉翔翔很生气翔翔很伤心翔翔想知道我哪里不如猪', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1071', '2000', '今天才开始进来这个心情日记本，分享你的好心情，有了这个日记本，我觉得还可以的咯，不过，我今天也特别的兴奋呀！让我走进新的生活里。今夜无风，星光灿烂！饿一点睡意都没有，时间真的好难熬去咯，就来这里打发时间咯，其实今天心情很好的。陪女朋友逛街逛累了，就把她送到学校咯，一个人就没有地方走咯，就跑到网吧里熬夜，本来打算玩一下游戏在睡觉去咯，可是现在没有一点心思玩啊，只有来这里玩咯，今天也是没什么事做啊，也不知道说说什么情况把自己的心情能够轻松一下，还是不想说什么咯，明天还不知道是怎么过得的啦？天晓的！！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1072', '2000', '[COLOR=#dc143c][/COLOR]好郁闷！我现在知道自己对他不在那么重视了，我有我的开始，有我的生活方式，如果你要放我就不要在来伤害我好么`不要在来打扰我，不要在让我心痛一次好么，对你真的是爱，好爱，好爱你知道么`但是你老骗我，我真的怕了你知道么，要是你继续这样骗下去我宁愿离开你`走的远远的，我不希望自己的男人让别人说成一个很卑鄙的小男人你知道么`你懂么！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1073', '2000', '[COLOR=#ff7f50][FACE=新宋体][/FACE][/color今天又上学了,七天真是太快了啊.昨天张告诉我他说的话,真的好难过啊.今天问了他，不知道会是怎么样的答案,总之有一种不详的预感,好象又要吵架了,我真的不想,可也是迫不得已,真的是没办法了,这种问题放在心理会累死人的啊!!!到底该干些什么啊?真是迷失了自己的方向啊，也没心思听课了/', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1074', '2000', '[COLOR=#ff7f50][FACE=新宋体][/FACE][/color今天又上学了,七天真是太快了啊.昨天张告诉我他说的话,真的好难过啊.今天问了他，不知道会是怎么样的答案,总之有一种不详的预感,好象又要吵架了,我真的不想,可也是迫不得已,真的是没办法了,这种问题放在心理会累死人的啊!!!到底该干些什么啊?真是迷失了自己的方向啊，也没心思听课了/', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1075', '2000', '最近我发现我是一个不太想维持现况的女孩了．不确切说是女人，因为我已经把我的第一次给他＿＿我的大杨杨老公．虽然叫他老公，但我们还没有结婚．　　我也不知道最后我们会不会走在一起，但是我现在好像又不能没有他．也许这就是我悲观吧！我也搞不懂我是不是很爱很爱．因为我有时候很讨厌他．　　虽然他为了改变了很多，可是我还是觉得他对我不够好．我不知道，是不是女人贪心．总希望别人能做得更好．　　有时候我也不知道为什么会平白无故跟他吵架，他也不会让我，所以这样就造成我想离开的想法．说真的，好多次我都想离开他，因为他外貌，也因为他没有时间陪我，我是一个要人陪的人，所以经常也会因这种小事我们不和，于是几天下来我会不理他．　不过现在我已经怀了他的小孩，但是我还是和别人在幽会呀，不过我没有想红杏出墙．因为这一段时间，我做一切证明我还很爱他呀，我不知道把那个男人叫做的什么，但他绝不是我的情人．只是我不开心的倾诉对象吧，不过和跟他在一起的时候我有一种对不起板杨的感觉．　不过我想我以后再也不会和那个男人见面了．因为我不想再有那种感觉了呀．　', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1076', '2000', '我好想他,真的好想他!每天都在期待他的电话,只要一天没听到他的声音我的心就不舒服,可是为什么他总是这样不理解我的感受,总是让我伤心难过,总是让我担心他......都过了这么久,七天了,他都没打过一次电话给我,为什么?我想不通,他心里还有没有我,难道他就一点都不想听到我的声音吗?我真的好想他!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1077', '2000', '今年这个生日可能是我一直以来过得最开心的一次.....因为有他陪着我.我好高兴.......我不在乎他送什么礼物给我,只要他陪着我,我就很满足了.....军,我爱你!!!!!永远不会改变............', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1078', '2000', '和他在一起，让我感觉自己真的好幸福，但我却知道这样的日子持续不是很久，当然原因有多方面的。其实，好多的事情真的不是他想象的那么简单，相反是复杂多变的，有时真的好想告诉他事情的真相，可我却怕他受不了。哎，我真的不知道该怎么办！！当然在我心里他一直站着举重的位置，可他却认为我是在欺骗他，欺骗他的感情，可事情却不是这样的啊？？亲爱的宝宝，你知道你在我心里有多重要吗？？你不知道，甚至在我怀疑我所说的不真实。我也知道自己和你以后不会在一起，是的，在那时大家的眼光看的不是这么的浅短啦，相对来说是深厚无底的，你知道吗？？我这样，而你也一样！！现在我只知道珍惜自己的每一天就可以啦，其实我知道自己得了不愈之症，在人世间不会太久，或许对我来说还好吧，我衷心的希望：你找一个比我更好更适合你的人。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1079', '2000', '呵呵，原来他不是那个意思，真是白伤心了，早知道就不这样了。他说，他的某些生活中不需要我，但是，他的生命中需要我，因为生活不等于生命。那看来，还真是我问错了啊！今天班主任回来了，告戒我们不要谈恋爱，不要写信，不要沉溺于写情书之中，哈哈，我差不多都有啊！太厉害了，可是没办法啊，我就是这样的人啊，学习太枯燥了，想找点事做做啊，这我想没什么错吧？！还有那个姓谈的，真是烦人，没见过这样的人，哎，我碰上了算我倒霉吧，天天烦我，都要死了。总之，今天还算是快乐的一天，呵呵！文字', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1080', '2000', '\"今晚你是否在想念我,我打开日记本想记下的第一句话就是\"\"我好想念你\"\"吃过晚饭今天没有什么事情做,要在平时,我的工作是很忙的跟本没有多余的时间去想念你.但今晚我有了一点点的多余的时间,我的头脑不由自主的就想到你那里去了.于是我拿起电话拨通了我倒背如留的电话号码,想了没两声你接起电话了,我一听就知道你在外面喝酒,和你接处这么长时间了,你的一个小小的动作和你的方式我都记在心里,我不想让你总喝酒,可你说,因为工作的原因没有办法,这我都可以理解,本想和你好好聊聊,你工作在身很快就挂掉电话了.刚刚我要离开电话亭,我用的那部电话又在一次的响起,我没有想到你会给我回复过来,你说你想念我了,我又何常不是一样的在想念着你吗?我等这句话真的是好辛苦,你从来没有对我说过想念二字,今天我听到这两个字我太高兴了,我一夜没有睡好,我都在偷偷的笑.想念一个人真的是好幸福,最后我无法入睡,我又想在一次听听你的声音可是我在打电话电话就总是占线,我不知道你有没有把我的话放在心上,我不想让你和以前的那个她在一起,因为那样我会吃醋,会伤心.大约十点半左右我给你打通了,我不知道为什么是因为我不信任你还是因为我怀疑你又在给那个女孩子打电话,我不知道,我真的当时一片混乱.我们是不是比此之间缺少一份信任呢????\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1081', '2000', '文字今晚，我好想你，想一个人真的真的不好受，至少对于现在的我来说。今天我病了，好难受，多么想你在我身边，可是，因为种种原因，你却全然不知道我生病了，我不怪你，这是无法避免的，但是，有一种莫名的伤感，不知道是为了什么，好想你，就是想今晚或许又会在你的身影里入睡，我多么希望在梦中与你见面，现实让我们相爱，让我们在不远处看见对对方的身影，却又不得不象陌生人一样擦肩而过，这种感觉是一种煎熬，不能说一句话，为什么，现在如此不公，老天对我这样。g，你知道今晚我在想你吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1082', '2000', '[COLOR=#ff1493][/COLOR]好happy！！又可以返ok！住宿点生活好难过啊！！而且又同自己吾中意点人住米一起！！咩时候会分开呢？？好怀恋自己ok张床啊！！哈哈……………………系米好傻啊！！！！！！！！.只系住佐4日就好次住佐几个月点感觉，好难受啊！！但系我终于返到ok啦！如果吾系因为a一次葛考验我都吾会原来自己ok系甘舒服..！！如果可以我只希望一直都留在这里，但现实就不是这样，我吾中意现实，因为现实往往给人痛苦！我只希望能够开开心心紧生活就够！！过住简单的生活！其篮球场上发挥自己的技术…..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1083', '2000', '今晚我好伤心,我的头痛的要死,不知道是不是因为听到你的消息我心里很慌乱.朋友打来电话说你生病住院了,我听到这个消息应该很高兴才对,对于别人来说那可能是你报应,但对于我来说我也应该这样想才对,但是我的心没有那么狠,不管你怎么对我,你对我无情,但是我不能对你无意.听到住院的消息我第一反映就是想能去看看你,但是我又怎么样去办这件事情我真的不知道,因为我的你的关系不同,我去看你,你又会不会觉得我是来看你的笑话的,怕你不理解我的用意,说真的,我真的有点恨你,恨你对每一个人态度,恨你对朋友不够意思,总是想着和别的女人在一起,你有没有想过,人的一生有几个不错的朋友真的很难得,可是你呢?你从来没有珍惜过他们.你总是把女人放在第一位,但是曾经有一句话是这样说的,女人是红颜祸水,他可以把你的一切都毁掉,不管现在你有没有在拿我当朋友,我一直都是你的朋友.和你在一起从来没想过怎么样,就感觉你不是他们所说的那种人.我的心很冷,我想我会为你祈祷希望你能早日康复.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1084', '2000', '一句我爱你又能证明什么呢？我爱你，你认为合适吗？每天早晨醒来我都会告诉自己要少爱你一点，我试了，可是我做不到。以前我对你的放纵是因为我知道你心里有我，现在呢？你还爱我吗？或者说你爱过我吗？真的受不了你跟别人怎么样怎么样的，我真的受够了，累了，不想爱了。早点结束我们原本不该有的开始好吗？放了我吧。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1085', '2000', '[FACE=隶书][/FACE]文字昨天真的好难受啊，自己生病了爸妈也是，一回家，就觉得好压抑，一个人躲在房间里哭。这时候，就想起了他，我生病了，他却全然不知，真的不怪他，可还是会觉得难过的要命，不知道什么原因，有时候真的希望他多关心我一点，哪怕一句问候，一句简单的问候也好可现实，离我想象中的最不好的状态还相差很远，真是太不尽如人意了。其实有时候我的要求并不是很高的或许我和他本来就是不合适的呢？现在就是希望我的家能象以前一样至于我和他就这样吧，其实朋友更重要。不是吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1086', '2000', '今天是星期一，我一天都处于很想入睡的状态，这下子可不是九日不想睡了。我昨天回家了，晚上到家里，我想回家那么多天，可是看到她我忽然很平静，不知道这是怎么了，到了晚上，我们一起回家，他看电视我上网络，一个夜晚我就把她扔在一边。。。　夜深了，我下机了，入睡的时候，我竟然忽然有种恐惧的心理，对于她身体的陌生，不想有任何事情发生，对于她的要求我拒绝，对于她的亲吻我躲避，我不是欲擒故纵，只是真的不熟悉不知道为什么，我竟然不习惯她的亲吻和爱抚，我知道我这么做她伤心了，我一个人在深夜抽烟，什么话都没有说，在那里不知道想什么，我假寐，可是竟然也睡不着，我问，你一个人在家都跟什么人接触啊，你怎么了啊。。。　她不能明白的是，为什么同样都是那么久没有见面，为什么她不感觉到陌生而我却有变化，如果这样又为何要我回家，我也不懂得为什么，每天把呼唤我回家当做目的和习惯，可是想念的人真正回到了家里我竟然不知道该怎么办，我竟然有点陌生，难道是我自己的问题？是我性冷淡了吗？？？　捆，一夜没有睡觉好，我要休息下。。。霓虹里人影如鬼魅这城市隐约有种沦落的美男人久不见莲花开始觉得牡丹美女人芳心要给谁没所谓只是夜再黑也能看见藏在角落的伤悲oh夜太黑谁也没尝过真爱的滋味只怪夜太黑没人担心明天会不会后悔hey夜太黑酒精把一切都烧成灰夜太黑在轻轻地轻轻地轻轻地包围沦落的美如果谁看来颓废只是累无心跌碎了酒杯别理会只是只是只是夜再黑也遮不住那眼角的眼泪暖暖的安慰它给过谁谁又在乎酒醒之后更憔悴谁又担心明天会不会后悔但夜太黑夜太黑下班了,刚刚回家,把床头的灯点亮,看着养的两条金鱼在水草中自由的穿行,喂他们东西,吃的很着急,是饿了吗?有的吃就一直吃,没的吃就在水中游行,一点都看不出它们的烦恼,总是那么从容,起床的时候还睡眼朦胧时就蹲在床头柜边看它们,一只忽然好象受到了惊吓忽然急速的奔到一边用力的甩起它的身体把缸底的贝壳都撞的乱飞,一下子就把我吓精神了,好象这种极端的方式忽然提醒了我家里除了我还有生命在存在,我忽然对它们开始多加注意了,我们家的鱼和它的主人一样,每天都不按时吃饭,只是它们的没有规则是我造成的...听着啊莲的夜太黑,好久没有听过这个曲子,可是再次听到,仍旧有那种无语言状的感觉,伴奏本来很清,啊莲的声音也很凄迷,这个时候的我,黄昏时候的我,也许正适合听这样的音乐,好闷,我算不算幸福?每天在这里无痛呻吟,刚刚走在楼下的时候,还在想妈妈说起的事情,心理又有点不安,好害怕身边的改变,可是还暗暗安慰自己,觉得自己好象皮筋,平时没有被拉伸很稳定,可是遇见事情的时候不是也很有弹力都熬过来了吗?遇见什么样的事情再说什么样的话吧,我想我还是坚强的...今天的天是阴天,可是很温暖,有清凉的风,地上本来有半融化的积雪,这样的天气,总会让人有淡淡的惆怅的,我想起以前在北京的日子,好多这样的天气,北京的天晴朗的时候并不多除非是炙热的夏季,在我的回忆里总是感觉阴天的时候多,而现在,回到这个城市,已经生活了将近5年,日子竟然这么快仿佛落日的余辉从指间滑过,一晃就过去了,而再次举起手指望向阳光的时候还在回忆真的有光划过吗?虽然是不同的地点,可是为何心情如此的一致,为何还是有担忧不安分的心,感觉自己心里一直有个影子想飞出身体追逐什么,这样的状态仿佛在小说里看到的情景,拼命的追逐拼命的奔波最终出现被车撞击的死亡,我在赶什么...一个人,再怎么忙碌怎么急迫最终不过是从生到死的过程,总是跟自己说过程美好的就是最好的,可是却总是在过程里想要提前看到更多结果,要是可以有聊斋里的预测未来的镜子不知道我还会不会这么焦虑这么怅然,不知道还会不会幻想会不会追逐,追逐什么自己都不知道...心里到底在想什么.....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1087', '2000', '刚刚蹦的回家，也许这真是发泄的一种方式，我好闷哦，在接近凌晨的时候整理一天的心情，这时候黑夜带给我的安静，是另一种享受，只有这样的深夜，心是安静的，虽然寂寞．有谁说过寂寞是可耻的，我不明白为什么可耻，但是每当我寂寞的接近崩溃的时候，我会常常往最热闹的人群里凑，呼吸着很多人在狭小空间呼吸着的空气，躲在黑暗的一角，疲惫的观察一切，竟然发觉也是一种乐趣，在那样的场合，什么样的倦容什么样的语言，没有人看见没有人听见，强劲的舞曲，使我蒙上了双眼，在有烟雾的舞场里，跳到不能呼吸，拥挤的人群里，有人呐喊有人哭泣，有的人只是一脸的面无表情，我不知道他们的想法，因为这个时候的我也是没有思想的人，好朋友尹丹不明白为什么我这么喜欢蹦的，她一去那样的场合，就不知道该做什么，往往一会竟然睡着了，而我常常是一到这样的场合，就觉得心情出奇的宁静．．．　回到家了，沾染了一身的烟酒气息，这是在蹦的以后，每次得到的礼物，我常常很自然的接受，今天的天气是好多天降温以来难得的晴朗，可是我的心理竟然会莫名的烦躁，一整天我都是处于焦躁的状态，心里不安，仿佛害怕什么，慌乱着却不知道因为什么而慌乱，晚上吃了很多的东西，有谁说过女人在心情不好的时候会暴饮暴食，这点我可以证明，前几天在网络里跳舞，热闹的聊天室里，我在慢摇，过于沉醉，暴露了自己而浑然不知，一直喜欢诱惑喜欢朦胧的美，可是当突然看见自己暴露的身体，仿佛一个自信满满的魔术师在表演台上被人当众揭穿了谜底一样，慌乱而不能接受，竟然选择仓狂而逃，关掉浏览器，退出了一个很喜欢的群，还是觉得难为情，结果在以后几天的日子里竟然失去了在网络里放纵的激情，原来自己是这么懦弱．．．　　我不知道有谁如我一样，在这样温暖的午夜凌晨，一个人在自言自语，写着不知道是什么的心情日记，还记得在歌厅里，一个女人在唱怕黑的女人：　月圆的夜晚是否特别孤单啊孤单的夜晚是否特别想念啊想念的恋情是否特别遥远啊遥远的人你可曾抬头望天怕黑的女人家里灯火依然啊怕黑的时候总想见你一面啊哪怕是说的已经与爱无关啊她的心也会感到一点温暖．．．　我不害怕黑夜，但是我真讨厌想念．．．．', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1088', '2000', '寒冷的冬季总算过去,天空微露淡蓝的晴,我在春天清新的阳光里,看著当时写的日记原来爱曾给我美丽心情像一面深遂的风景那深爱过他却受伤的心丰富了人生的记忆只有曾天真给过的心才了解等待中的甜蜜也只有被辜负而长夜流过泪的心才能明白这也是种运气让他永远记得曾经有一个人给过完完整整的爱情那曾经爱着他的心情有一股傻傻的勇气那深爱过他却受伤的心丰富了人生的记忆今天对于我来说一切都很开心,我的脚快恢复了，生意也快正常运转了,我的异性朋友对我很热情,好多好多...都让我好开心,可是...为什么我这么累?为什么越失落越空虚?我到底想要找什么?你想要什么啊九日~~这么晚了又是凌晨一点多了，眼睛在罢工在耍赖，后背的疼痛在折磨我，唯一在挣扎的也许是矛盾的意识，九日，你告诉我，你怎么了？？？你到底在折腾什么？为什么你这么喜欢一个人在深夜日记，说一些连自己都不懂得的文字．．．你．．．是不是又寂寞了？可是寂寞的人该等待，等待有人陪，为什么你的心理没有期待，为什么网络这么丰富的世界没有能打动你心灵的地方？难道从生理到心理你真的冷淡了？真的麻木了？？？怕,我怕,我好害怕就此开始没有了知觉,一个人没有了情感怎么办,我已经越走越远,竟然只要陌生人了,怕怕怕怕怕怕....九日你哭吧,哭出来就好了...可是为什么连哭的感觉都失去了,这是怎么了...........', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1089', '2000', '晴朗的下午,心还是那样沉重..毫无头绪的涂鸦,一个下午就这样过去了.!不知道自己是不是真的释然了..或许,有时候,有的路,有些事,只能一个人去走,一个人去做..一直认为自己是个成熟的男人,可怎么还象初恋时那样,我这是怎么呢?是不是太依赖这种恋爱的感觉了,我不是已经深陷其中了..网络象一个巨大的沼泽,正在一步步地把我往下拽,我拼命地挣扎,却只是越陷越深,莫名的恐惧会突然间把我包围,不知道等待我的将会是什么..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1090', '2000', '\"一直对自己说:是,我相信,我期待,我不曾放弃..我是向日葵,哪怕只是呆在墙角,也不忘追随太阳的方向..今天一位叫\"\"棋\'的朋友告诉我,如果感觉郁闷,不妨把自己拥抱,左手紧握右手..是啊,我很郁闷.这几天这种感觉一直在陪着我..很多的朋友都在为自己的爱情死死的坚守着,我不知道该怎么开口.?太多想说的,到最后却都只能作罢..\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1091', '2000', '现在是凌晨5点钟,好久没有因为什么事情失眠醒来,心痛的感觉折磨着内心让自己睁眼到天明,想起她冷酷的表情和语言,心理有很多委屈很伤心,第一次我象一个迷路的孩子找不到方向,什么困难都不怕最害怕真心后的伤害,从来不会在意一个人的去与留从来没有为一个人质问我自己的内心,可是这次我知道,我真的被伤害激中了内心...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1092', '2000', '今日心情吾太好！好次看咩都吾顺眼………………..打机打佐成日，真系好无聊。吾知道..人生系吾系紧样过才有意思呢？？如果我其人生的一个阶段等佐，会有人帮我吗？好难讲。我只系想过点简单的生活，但对于爱情A样野可能我吾成熟所以张爱情A样野看的好浪漫，但我都想尝试一下爱情的滋味系有几甜………..如果我同你其路上走失，我会其原点等你返来，但系我的期待，你听到吗？如果事请系我想的，我相信我地的缘分系天注定的。你同我系一对，无任何人能够分开我地。除非你地选择分手。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1093', '2000', '不就是聊天而已,为什么心会痛?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1094', '2000', '昨晚我把闹钟调到5:20.记得她说过他以前的老公正在每天的这时想她⒈分钟.她却感动的哭勒.520-521', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1095', '2000', '这个大白痴，怎么这样呢，老是气我，还说学习压力大，生气对我有好处，艾，什么逻辑啊？！真是气死我了，不过话说回来，他也很可爱啊，呵呵有时后对他真的好无奈，什么办法也没有说他吧，也没反映，哎，怎么爱上这么个人啊我怎么这么白痴啊，不过，缘分就这样啊！没办法，虽然以后不太可能在一起，但要把握现在的啊，可是象我这种人，也不会耽误学习的啊，我是女强人啊，哈哈？！其实再厉害的女生，也希望对方关心自己，照顾自己的啊，我也是啊！我也希望小鸟依人一点，可是————', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1096', '2000', '\"在这寂静的凌晨两点,不知为何忽然从梦中醒来,翻了身想继续睡,此刻的大脑却异常的清醒,心情是那么的平静,知道自己现在是睡不着了,窗外的路灯毫无保留地照进了房间.这样安详的夜晚,又有多少人像我一样,会在睡了之后莫名地醒来?最近这段时间,发生了一些事情,让自己有很多的想法,忽然发现,其实有些事并不像自己所想的那样,想多了,人的思想和意识会有所改变,要让自己更多地去清醒,就像在这样的夜晚,让自己的思绪任意驰骋,没有任何的杂质,感觉整个人都是那么的舒服,闭上双眼,觉得自己多出了一双翅膀,慢慢地张开双翅,缓缓地飞了起来.....也许是秋天真正地来临了吧,感觉到了秋的凉意,双臂有了冷的感觉,才发现,自己还站在窗台边,外面有丝丝的秋风吹过,感觉到了冷,却不想离开窗台,只想静静地,在这有点寒意的窗台边多站一会儿,让自己全心全意地去想一个人.心里最惦记的那个人?\"\"当你不经意想起我时,我已经想你很久了\"\"不记得这是谁说过的话了,却在此刻有了更深的理解.是啊,当你想一个人时,你会觉得满心里都是他,他的一举一动,一言一行,会牵动我每一根神经,因他的快乐而开心,因他的烦恼而忧愁,看到了他的qq是亮着的,却不敢去打扰他,知道他现在可能不会很忙,却不想去占用他的时间,只会一个人静静地,看着他的头像,看着他的照片,傻傻地想念着,什么都不用在做,什么都不用去考虑,就这样静静地,去想念不含任何杂质地去想,这份感情,是那么的纯真!拿着手机,想给他发条信息,又怕打扰了他的美梦,任何时刻,都不让手机离身,睡觉的时候,手机会陪伴在身旁,明知道这样的辐射对身体不好,却一直这样坚持,怕自己接不到他的一个电话,怕自己少回了一条他的信息,不知道以后会怎么样,也许会走到一起,也许会是一辈子的知已,也许会是永远的朋友,这些都是已经无所谓,重要的是,这样的一个人,他值得我去想念,去牵挂,去关心......爱一个人,是幸福的!被爱也是幸福的!亦然,思念一个人是幸福的,被一个人思念也是幸福的!去思念一个值得去思念的人,会更加的幸福!此刻,被思念的你感觉到了吗?双手的冰凉,有谁来帮我取暖,孤寂的心灵,有谁来给我安慰?漆黑的夜空,有谁来帮我点缀?幸福的方向,谁人来为我指点......\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1097', '2000', '我是九日，欢迎欣赏我的日记。_2005-10-12星期三天气:只剩苍白.心情:自言自语.小中大天气:阴.不见阳光,适合在阴冷的角落发抖,淋漓畅快..曾经的幼稚和纯真逐渐消失,人变得越来越理智和清醒.从最初的艨艨脓脓到后来的的彻底清醒;从最初青苹果般羞涩的爱到后来对爱情的彻底死心,中间的过程大概只能自己体会,想起了《天黑黑》里的那句歌词:我爱上让我奋不顾身的一个人,我以为这就是我所追求的世界,然而横冲直撞被误解被骗,是否成人的世界背后总有残缺;我走在每天必须面对的分岔路,我怀念过去单纯美好的小幸福,爱总是让人哭,让人觉得不满足,天空很大却看不清楚,好孤独……独自一人看着周围的情情爱爱,甜蜜、痛苦、恐惧,之间的转变是那么的快,而我们又能做什么呢?什么都无法做,只能那样的看着,仅仅是看着..看见宝贝由那个自信,骄傲的女子变得脆弱、敏感,一直在受伤,伤口不曾好过,笑容是那么的沉重,有那么一点点凄凉.我只能看着她,什么都帮不了,无能为力,就连给她的微笑都显得那么的苍白,我什么都不是,什么都不能做..偶尔看见孩子纯真的微笑,感觉是那样的美好.而我们却无法拥有那样的微笑,已经不知道从什么时候开始,微笑不在是我们内心开心的表现,仅仅是我们生存的需要!我笑,并不代表我快乐..在这个城市的日子,我好象总是很长时间了才写一篇日记.也许我可以每天一篇,写着凌乱的生活,不变的生活,如流水变,没有变化.可是,当我心里开始空空的时候我就没有办法写出文字,一如前些没有写日记的日子一般,内心空洞..小时候,希望自己快快长大,那样我可以独立.我可以做很多所谓小孩子不能做的事情,我可以学会很多很多的东西.长大后开始后悔,后悔为什么会长大,原来成人的世界是如此复杂,而我已经是个成人,我必须去学会在这复杂的世界生存,这是规则,生存的规则..总觉得自己开始成熟,冷静,看待事情很清晰.突然发现自己其实很笨很笨,自己依然是那样的冲动,自己碰见事情后没有了冷静,原来我的冷静只是自己所谓的感觉,可笑的感觉..每一个上台的人都希望自己能完美的上台,完美的下台,即使中间有不完美的地方.但需要的只是,仅仅记住他那完美的一瞬间,记住他那完美的姿势.但却忘了,曾经有人说过的一句话,上台靠勇气,下台靠智慧.太多的人拥有的是勇气,却没有智慧,于是在那上台与下台之间上演着无论的剧情,而我只是旁观者,因为我没有智慧,更没有勇气,我只是在台下徘徊……论坛安静了,很安静很安静,曾经的辉煌今天的颓废.看着论坛就让我想起某个辉煌的朝代,曾经辉煌的宫殿,热闹的人群,繁华的街市,然后岁月一过,曾经的辉煌变得特别的耀眼.也许我们只能从宫殿的残壁里想象曾经的辉煌吧,只希望曾经的相识的人能够幸福!永远幸福!生命里总有那么一些人来来往往,走走停停,有人对你抱歉,你对别人抱歉.无论怎样.我从无怨恨.不用对我说对不起.因为没有什么对不起!曾经的错只因为相逢时间的错误,相逢地点的错误,但那不是我们的错,不用对我愧疚,我也不想对别人愧疚!曾经的相遇就是最美的回忆,记得有人说过:有最美的回忆生命就是美丽的..有人说,九日的文字总带有淡淡的忧伤!是的,我也想写快乐的文字,那样感染每一个看我日记的人都快乐!可是,我写不出来,一个人她不快乐是无法写出快乐的东西,我不能欺骗我自己,说我快乐!就像姐说我的,我最大的缺点就是容易忧伤,我不知道为什么会这样,也不想去想为什么!但我知道,这种忧伤是真实的,至少比虚假的快乐好!或许,就如同的席慕容的那首诗《为什么》:我可以锁住我的笔为什么却锁不住爱和忧伤在长长的一生中为什么欢乐总是乍现就凋落走得最急的都是最美的时光总感觉自己的文字好象不能在提高了,人是不是总有个上限呢?人的内在潜力到底有多大,我不知道,也许很大很大吧!需要的只是找到激发的方法,至少现在我开始停顿了,停止不前..九日没事,只是最近发生很多事.有些事情,我以为结束了,没想到还没有完,然后总有些让你措手不及的结局,牺牲自己的睡眠时间,唠唠叨叨的说一些话,自言自语,呵呵,有时候自言自语也是一个释放的方法吧!人总需要自言自语的说点什么,我亦如此..附:有时候,上帝会像个孩子,给你开着一个又一个玩笑,去考验你,去让你受到磨难得到重生.可是他却不知道他的孩子是很脆弱的,有些无法承受,只有逃避,只能缩进自己的壳里.然后去舔着自己滴血的伤口.告诉自己:不痛,不哭,不难受,我会很好很好,我要坚强,我要骄傲,我会得到自己的幸福,一遍又一遍的重复,哭泣,微笑,重生..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1098', '2000', '昨晚给他打电话时，他居然告诉我说，他以前追过的一个女孩要请他吃饭，问我，该不该去。。。我能怎么说呢，还是由他自己吧。。。不过我心里有点。。。。唉。算了，我想我还是相信他的。。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1099', '2000', '\"我是九日，欢迎欣赏我的日记。_2005-10-13星期四天气:孤独..心情:文字..小中大以前,很爱写日记的,不只是在键盘上,用指尖轻轻敲下心情的语句,而是一笔一划的写在珍爱的本子上..我的日记本,都是统一的规格,一抹忧郁的紫,一片淡蓝的海..其实刚上学时,老师说写日记能让我们有颗善感,热情的心..于是,半信半疑完成任务式的开始完成\"\"作业^..慢慢,这种心态慢慢被改变过来,我一点点的喜欢上了那种和日记说秘密,说心事的感觉..它就像一个永远不会背叛我的死党,永远守护着我心里最深的感情..六年的时间里,我写下了11本日记,从稚嫩到些许的成熟,从单纯步入到多愁善感,原来自己是那样喜欢文字带来的感动..只是,我却感觉自己还是孤单的..于是,我到处乱晃,像一条沙漠里的鱼,绝望的游着..曾听一朋友和我说过一句话:他说,喜欢文字的人其实都是孤独的..我有些怀疑,却还是找不到答案..今天有种无法言喻的东西沉淀在心里,堵得心慌..是因为下雨的原因吗??人特别的伤感..又坐到屏幕前,颈椎已经疼到坚持不住,仍然固执地敲字..听劈劈啪啪的声响,渐渐给慌乱的心平复,沉重的窗帘遮着外面世界放肆的阳光,干净的床上放着随手丢下的衣服..整整一个晚上,眼睛酸痛..无力地蜷在电脑椅里,听的《秋日的私语》哀婉的曲调..脑子里混乱,一切的一切就像电影,一段又一段的闪过,就想一辆疾驶而过的火车..最近我们这群孩子变得安静了,似乎感觉不到了她们的存在..因为文字,因为雨后让她们聚在了一起,都是一群孩子,寒冷的孩子,靠着彼此的温暖而温暖着,我相信她们还在,我相信有一天她们会真正的微笑..:)对着她说,总感觉自己最近好象丧失了说话的能力,很多时候只是在发呆,很多时候不知道该说点什么..也许自己什么都不会说,是那样的笨拙,于是我只是在不停的微笑,笑的什么,我却不知道,也许我只是想让自己的微笑能让别人的心情舒畅,能够开心...有时候,开始敲着一些字,然后又删除..有时候,脑子里会突然想起那么一些话,一些人，于是想留下点什么,但什么都没有留下..很多时候,安静得要好好的写写自己的心情,却发现脑子里一片空白,敲出来的字是那样零零散散,没有开头,没有结尾,只是一些破碎的话语,直到自己把手放在键盘上却敲不出任何的话语..任何人在这个世界上都是孤独的,喜欢文字的人更愿意安静的以文字的方式来审视自己的灵魂..某种程度上,这是件高贵而华丽的事情,对于我们自己..所以,爱这种文字方式吧,认识到孤独比麻木要好的多..字如其人,文如其人,言为心声……一个人静静的伏在电脑前,看完了所有的留言与信件,而后泪流满面..[/face][/size]\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1100', '2000', '我是九日，欢迎欣赏我的日记。_2005-10-7星期五天气:晴.心情:无题..小中大傻瓜,又在抬头看天了吗??梦里:张开五指对准太阳,阳光就能在指尖上折射出天堂的模样..突然觉得一切都是命运的玩笑.在一起,对我而言:需要多大的勇气?我没有那么勇敢.担负起自以为是的感情债.我怕被丢弃,我怕连自己最后的一点满足也失去.满脑子混沌..病着的时候,才知道健康是那么珍贵.很累,累得几乎要晕过去..思念,泪,从眼眶返流到某个角落,停滞..　傻瓜,又在发呆了吗??我在想,这世界上,除了生命,我还拥有什么??心狠狠的抽搐了一下,我没有不安分,我只是没有了审视自己的能力..呵呵,我的电脑在抗议了.对呀,除了命,我还拥有这台电脑,当我失落,我的文字就有了灵魂,知道何去何从,知道哪里有出口..容易喜欢一个人还是爱一个人?喜欢比爱困难.爱很容易发生,只是一种撒娇.喜欢里面有敬畏.矛盾着,于是.活着..　傻瓜,你干吗老哭呢??　我开始调整生活作息,哪怕只是毫无干系的一点点改变,至少能提醒自已,生活的方式在有所改变.不应记住的事情,就该忘却,否则平添的只是无谓的痛苦.所谓大道理我都懂,只是逢到行动了,总会有些力不从心..有时候,我会无缘无故地就流下泪来.不为人知的内心,旁人无法触及的世界.所以,当我流泪时:请你,转过头去,假装什么都没有发生..我是个傻瓜,该用哪只眼流泪..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1101', '2000', '[FACE=楷体_gb2012][/FACE]文字这个家伙,真的好讨厌啊,竟然这么对我说,真是没有共同语言,关心我的话就会知道我开心啊,分明是在找借口?!我有什么事,怎么好意思开口啊,谁知道他会不会烦啊,他到好,竟然说是我不告诉他,他不知道发生什么才不关心我的真是气死我了简直就是想死啊今天跑800米,好了之后就头痛的要命,说实话,我能跑完就不错了,他呢,这总应该知道我累了吧,可是,他的话真是让我生气,这么讨厌,真是的!真怀疑他到底喜不喜欢我?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1102', '2000', '文章听谈说他们要一连出去三天比赛，哎，怎么办啊，在学校，我一天不见到他都很难受，总觉得少了点什么啊，这下好了，要出去三天，真怕我自己会受不了啊！？怎么办啊？我真的好想见到他的，何况，就以为着这三天可能会没有一点联系的，哎，我怎么这么倒霉啊！真的好想给他打个电话，但是，又不知道该说什么，这样岂不是很尴尬吗，那我宁愿不打啊！上次看他比赛就受伤，那这次呢，会不会又受伤啊，真的是担心死了，如果真的受伤了，要么他不告诉我，如果告诉我了，我肯定很难受的，心痛的要命！算了，反正我也去不了的啊，要上学的，真是苦命的人啊。就希望他能表现出自己的正常水平吧！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1103', '2000', '老公昨天我回家了，本来想跟你说的那样好好跟爸爸谈的，但是我发现跟爸爸根本就没得谈的。他不要我跟你在一起，昨天我答应他了答应不跟在一起了。。。哭了一晚上好想打电话给你，好想告诉你，但是你还要上课捏。。。。呵呵。。我们真的可以在一起吗？我好爱你。。现在发现你是那么好。。。好到不知道怎么说了！可是我捏？？？跟你的差距那么大，你不在乎可是我现在也有点觉得高攀闹~~~~怎么办？我真的可以跟你在一起吗？还要4年才毕业到时候我们还会像现在这样吗？我经常这样问自己，虽然我知道你不会骗我的，但是我对自己就是米有信心。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1104', '2000', '作为直的。你不能感受，她温暖的身体和柔和的抚慰，和他们有多么不同。只有女人自己，才能互相真正了解对方的身心需求，才能让彼此有真正被爱被呵护的感觉。我们可以做爱很长时间，我们可以一直互相拥抱和抚摸。而男人，只是片刻的炽烈，之后却如陌生人般冷漠。她柔美细长的手夹着长长的摩尔，眼神在烟雾后面更加迷离朦胧，一切都是那么完美，可是一切却又显得那么诡异。我说那你们就一直这样了吗？她说只要她不离开我。我问她还能不能回去，她说也许不会了吧，我对男人已经彻底失望彻底看清。对自己爱的人失望，就选择爱自己的；对爱情失望，就选择欲望；对欲望都绝了念头，那么只要有温暖和温柔就已经足够。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1105', '2000', '记起很久以前的一个晚上，她悦躺在我的怀里柔柔腻腻地说：“宝贝，我再也不打你了，那两个耳光就已经让我又后悔又心疼了。”我故意问她，“如果你又打了怎么办？”她悦转转眼珠，想了想说：“那你就吻死我吧！”我坏笑着吻上她，缠绵过后，她悦噘着嘴嘟囔，说真的快被我吻死了。那幅曼妙动人的画面不停在我脑海里闪回，想必她悦也想起了那幅画面，相信我们还同时想起一句话，“我不能容忍有人打你，包括我自己。”这是在认识lq之前她和我说的话。现在已经过去了，但是还是在我眼前。这个瞬间我们都没有动，直勾勾的眼神想看清对方的心底，只有眼泪在不停地滚落，连最基本的抽泣声都没有。这是一种让人窒息的哭泣，只有眼泪诉说着压抑在全身心的痛苦。也就是在这一瞬间，意识到我们之间的问题不是出现在杨钦的身上。她无力地垂下手，沙哑地说：“我们之间出现了问题对不对，是我们都变了吗？”我象是在回答她，又象是在问自己，“我们是在积极的为对方改变，还是想努力的改变对方。”她用手抹去脸上的泪痕，“我一直认为，抵住外面的诱惑和压力就可以保全住我们的爱。没想到，打倒我们的却是我们自己。”她的声音很是凄凉。也许分开一段时间对我们都有好处，也许我们真的不适合对方，也许我不能带给你幸福。”“不是放弃，只是分开一段时间，好让大家都冷静一下。”我尽量把语气放平缓，声音放低柔，想尽量安抚她。她听完后，讷讷松开在我胳膊上的手，低头沉默了好一会儿，平静的慢慢开口，“那好，分开时间为一年。这一年中我们按照各自的方式去生活，互不打扰和干涉对方。”她停顿一下，眼神异常坚定瞅住我，“一年后，如果我们都认为还可以与对方一起生活，那么继续。如果不可以，那我们就GAMEOVER了。”我不相信她会转变的如此迅速，不相信这些洒脱的话会从她的嘴里说出来，但的的确确就这样发生了。对于她的方案我没有提出异议，表面上看起来很符合分开一段时间的说法，实际上我们已经向放弃对方迈出了第一步，不管中间会有多少步，最后一步无疑将是GAMEOVER，冰雪聪明的她不可能不明白这一点。只记得她那晚在浴室呆了很久很久，浴室里花伞下的水声也持续了很久很久，我也听了很久很久。不知道她是什么时候从浴室里出来的，昏睡前的记忆仍是哗哗持续的水声，在梦中我好象听见了她悲伤的哭声。她默默地说：“明天我就要走了。”她忽然抓住我的手臂，“我就要走了，对我说点什么好吗？”我轻轻地拿掉她的手，静默着，墙上的时钟滴哒地响着，空气变得凝重起来，雨好象是凑热闹似的越下越大。突然她扑向了我，紧紧地搂住我，力量大的吓人，她用近乎发狂的声音说：“你永远是我的第一次，以后的日子我都不会再认真了。”一滴泪水落在我的脸上，滚烫的。“以后的日子只有自己以后知道了。”我的心骤然荒凉而麻木，象一个历经沧桑的老人。一切都过了我开始了新伴侣的新生活。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1106', '2000', '瞬间之内，我觉得脑子里有一片空白麻木，yq身突然变得冰凉，我好象也不是我了。yq的示爱让人措手不及，我只把她当做好搭挡好朋友，从来没有往那方面想过，只有那天晚上她暧昧的动作才让我感到有些疑惑。没想到她会在这个时候用这种方法来表达自己的感情。我们在一起了，就这么简单在一起了。！我第一次和一个t做爱，，做他。但是并没出血。感到心不安。怕让他失望。慢慢发现我们并不属于对方。。。在我所见过和yq有关系的女人中只有z和她是最般配的。我相信你们一定会很幸福的，记住一定要对她说出来你爱她。一个月我们分手了，！最后是短信作的了短。“老公。拜拜。”我们分手吧，就这么结束了，现在作为朋友很好，希望他能对z好一点，！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1107', '2000', '我是九日，欢迎欣赏我的日记。_2005-10-14星期五天气:不要苛求.心情:要感恩.小中大许多的时候,感觉离自己最近的人,往往是根本不懂得自己的人.会有关心,会有呵护.但心底,始终是不由自主的失望..也许,本不应该要求太多..恋人之中,互补性格的人群是最能融洽相处的.期间也许是没有太多的默契可言,却在最需要的时候出现..许多的爱情注定错过,因为分岔便是必然的东西.向左走,向右走.相邻的两个人,总是转身.注定,东西南北..在这样的一个瞬间,是会突然感到悲哀的..尤其在一天网络视觉疲惫的状态下..外面夕阳刚落.橘红的天空变得黯淡.于是,心,也一并清冷下来..许多的人,会追求懂得的爱情..希望自己身边的那个人能够在自己不开口的时候,知道想要表达的东西..希望一个动作以后,双方都是理解的..或者,仅仅是一个眼神,便已经有了交流的效果..爱情的期望,让人变得苛刻..会希望把生活当中的角色都寄托在对方身上.希望他能为父,为兄,为子,为友,为知己..希望她是母,是姐,是女儿,是红颜..当爱情产生失望,于是疲惫..于是有了灰白色的天空,曾经爱情的完美渴望渐渐让人丧失了爱的信心..原来,不过如此..当爱情成为白开水式的生活,我们在油烟酱醋中将曾经的浪漫丢失..当回忆起来,心里会有一种许久没有呼吸的压抑..也许,浪漫,是人的天性.希望得到对方的重视,和在乎.希望能有那么一个人,把自己捧在手心里.能够心跳的时候,那种强烈的震撼,让人以为不可自拔..时间滑过,恍然,过眼云烟.没有什么不可以忘记,没有什么可以堪称永恒..只好在最幸福的时候努力珍惜每一天,但日子还是在指尖和拥抱中滑走..一切不容易.爱上的艰辛,成为我们离开时的绊脚石.想起自己曾夜夜伤悲过的情绪,会不愿意放手,毕竟那是多么刻骨铭心的记忆.毕竟经历的时候,疼得让自己难以呼吸..我们的不放手,也许,正是这样的不甘愿..我一直如此,我一直放不下.当走出这样的阴影,皇皇天日,原来一切是那么的清新.连呼吸的样子都可以是轻松的姿势..每个人在心底都会给自己筑一个小小的巢..那里面,放着热情,想爱,想被爱,快乐,想被呵护,安全感,想幸福.在我们冷漠的外表下,也许已经不能从这臭皮囊中看到什么蛛丝马迹的东西.但在静下来的时候,或是突然间被感动的时候,会发现,这样的美好,真的在我们的心里不曾离去..身边的人,并不懂我.会在看我的日记的时候,给我一成不变的微笑.只是宽容,宽容着我的任性和不安分..只是因为在爱,所以,可以包容我的一切..不懂,但令我感动.毕竟能做到耐心和爱心,已经很不容易..这世界,有谁能懂谁.反而是这种叫作文字的东西,让远方的人心灵贴得很近.会在看的时候哭泣,或,哽咽..像我,总在很难过的时候,没有思绪的低头吃着辣辣的面,在鼻子阻塞,眼眶微红的时候,得到一种发泄的真实..我可以让别人觉得我是因为辣了湿了眼角.或者,我可以告诉自己,我哭过了.哭过了,就不再哭,要接着面对..到头来,还是告诉自己,不要苛求,要感恩....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1108', '2000', '我是九日，欢迎欣赏我的日记。_2005-9-27星期二天气:晴.心情:心似琉璃.小中大放开能放开的是自我,放开不能放开的是佛.不能立地成佛,至少自由自我.只剩下一咬唇的倔强,眼泪还是忍不住掉了...－－给有相同灵魂、散落各地的生命她是我在雨后里感到对我最好的斑竹,我在斑竹群里的话不多,所以并不是人人都可以接纳或回应我..记得有一次,我在群里发了同一个问题,大概五遍,没人理我.差不多半个小时以后,她上线,然后问我,迷迷,怎么了...她是细心而令人感到温暖的女子.更是一个勤快而忙碌的女子..有一段时间我常上通宵,当阳光刚刚覆上我疲惫的眼,她便出现在群里第一个问候我,时不时的对我说,你呆会儿,我去收个传真..或者对我说,我刚从银行回来,好累哦.让我想到她一副气喘的模样,不由得心生怜惜..她也是个彷徨的女子.日记里充满了无奈、缠绵和难以决绝.钟爱四叶草..我答应过她的,等我找到了她的某种信仰,我会对着带着期许信任的小叶片说,这是我为她找到的四叶草.请给她幸福..可还没有实现我的承诺,她便开始不幸福了..一路走来,她是我贴心的朋友,我也渐渐了解到她身边有让她一直心有不甘的鸡肋男友,有让她心动对她动心的真诚男子..我曾经恨铁不成钢的对她发火,对她的彷徨和举棋不定.我说这个世界没有什么你不能,我说你再这样优柔你将全都失去..她只是哀哀的回应我:九日,我不知道该怎么办..很久没有来雨后的日子,发生许许多多的事情.当我再次回到雨后来,我看到她的日记上的锁渐渐增多,日记数目越来越少,我感到心里腾起一阵阵苍凉.人生如此,无奈居多..我甚至没有清楚的知道她发生了什么.只是在这些日子中收到她断断续续的信息,我也仅仅知道当她下定决心好好接纳这一个男孩的时候,这个男孩骗了她的信任.如果没有人可以给自己幸福.只有自己能给.当经历晴天霹雳似的痛苦,我希望她能历练成一个坚强的女子.现实残酷到逼一个人的情绪化为愤怒.那么我想,生活,已经云淡风清..我难以说出什么祝福的话语,因为我感到一切都是那么苍白无力.我只能说,我们都要幸福,我们都能幸福..情感,在女子的生命当中占据的地位不是男子所能想象的..但一旦决绝,就可以洒脱出来.我唯一寄托的小小心愿,就是她能够给自己一份平和的心态,面对这些所谓的痛苦和折磨.美玉须雕琢..!她对我说.想找个相依相伴的人一起生活.相互取暖..这是她,我,暖,敏一起的愿望.在我的生命当中,我有着这样温暖的牵挂.也在很多的时候因此而想念..我们是相互温暖的女子.是具有同样灵魂的生命.生活在不同的地方.用相同的疼惜相连..对生活认真的思绪,如同思念一个人..人群总会总一些无意识的又具目的性的事情,比如上网..陈小春说,网虫类女子可分为三种:一是显示想成为的类型,二是显示次种性格,三是显示不可能成为的人.大概第一种人是属于比较梦幻的人群,又被现实所征服,所以只能在网络上呈现一下下简单而真实的个性;而第二中人则是因为生活压抑,导致生活和精神分裂,无法让一些情绪外露,所以网络成为一个情绪载体;第三种,则是比较具有荒芜心理的人.有一些冲击思想,也有些许无所谓的情绪,对许多事情都有满不在乎的心态..在网上挥洒文字的同时,我会做着一个又一个的梦.我的梦总是与自由有关..梦中的我会是一个有着张扬的形象,却是一个不喜言笑、内心温暖、只有影子陪伴的一道风景..风景,是有风的景色..我总是想把每一天的每一秒用在自己喜欢做的事情上,我总觉得虚度时光无所事事是对生命最到的侮辱和浪费.而在不知不觉中,我还是日复一日、年复一年的在重复着这样的生活..于是,时间流走,我的美丽生命也消失了,迎来了愈多的压力,积攒了更多的记忆..发现生命甚是艳丽,用完了所有色彩,未来只剩苍白..记得有本日记上我写过关于我人生的500个梦想,大概没有坚持到十分之一就夭折了.连把愿望写下来都如此艰难.更何况是去实现的坚持..我一直觉得自己是个敏感而眷恋自由的人.找不到一条适合自己走下去的路.我没有足够坚强的毅力,也没有不同于别人的特长.我只能时刻提醒自己要坚强.不流泪,不退缩,不屑世界.现实不断提醒我,我没有梦,我只是平凡世界里的人,是一个具有男子味道的标准男子.想要完美却又清醒意识到自己追求的是虚无.无法放开,于是不可自拔的轮回着……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1109', '2000', '2005-10-6天气：晴当和电脑屏幕相对,我就不知道我的眼里是不是都是迷惘..有一种思绪无法说清,大概留下的就是空洞和怀念..做任何事情都已经学会不去后悔,当我不后悔,我就一直与生活相伴..觉得:灵魂,都漂泊惯了.眼神在迷离的同时,竟也有光芒..我总是这样坐在电脑前面发呆,让本该有的思绪和灵感都跑得无影无踪..然后微微皱眉,为我的光阴逝去而叹息.我又经常沉醉在这种若有若无若失若得的情绪当中..我不知道关心一个人可以到什么程度..我刚刚看了暮落残阳雪无痕的日记,心里慢慢的疼..大概是一种怜惜吧,这样可爱的女孩子,不应该就这样伤心的..每个人的心里,都种着一颗渴望完美的种子,并一直这样努力..生活沿着我们认为美的轨道行走,我们在生活中塑造出自己认为美的形象,这样生存..而在每个人的心里,是有恶源的,生来自私,真的是人的本性,谁都不可以否认这一点.喜欢安逸,喜欢享受,想知道别人的秘密,想得到所有想要的...写到这里的时候,我突然感到异样的沉重..但似乎我的心里是乐观的,真的是这样的..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1110', '2000', '你好我是九日，欢迎观看我的日记2005-10-15天气晴朗街上的空气里总是飘散着浮动的歌声,令人眩晕..是啊,一边歌唱,一边流浪..你们呢??也是这样吗?做自己想做的梦,去自己想去的地方,说自己想说的话,做自己想做的事..不用伪装,不用掩饰..可是...可以吗??流浪的天空,布满灰尘..流浪的孩子,希望有爱..唱着自己的歌,行走在旅途..不愿再失去方向,没有方向就等于没有自己..害怕这样的日子,寂寞的果子..总要抓住一个目标,找到方向..我确信我会!因为,我是真的长大了..我想写你了,那个最爱我的霞:好多次,我都想写你,都想写我们那些快乐不快乐的往事,每次都落不下笔,敲不下键盘,那些往事在阳光下如透明易碎的水晶,美丽耀眼,也很脆弱..天气有时候有阳光有阴雨,爱情有时候也难免有阴雨,只要我以一个快乐乐观的心态去看待,那我的爱情就是永远阳光灿烂的..尼采说:我是太阳.那我也要说:我是太阳,因为有你而天天灿烂..今天我看到一句话:Iloveyounotforwhomyouare,butwhoIamwhenI’mbyyourside..(我爱你并不是因为你是谁,而是因为我在你身边的时候我是谁)这个年代的人都喜欢把爱情像钱包一样随身携带随处展露,很少有这样的话能让我去停下来想想它的字面后面的东西了..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1111', '2000', '我是九日欢迎观看我的日记2005-9-11天气阴时间的确是付良药,它好象是给我暂时的平静生活,我还是有种幽幽的思念,不过已经没有那时的强烈.可是我听到了她的近况,我听的简直可以说是震惊,他变了,变了好多。今天我可以说,对她种种的感觉已经是过去式了,就算有什么也已经过去了,早知道没有结果的今天终于可以坦然面对,我是很舒心,可她,我今天伤心的不是失去了那份怀念,而是她的不可救药,我可以用朋友的身份去关心他,这些话都是骗人的,我还是不能,他无论变成什么样子我始终走不出这个怪圈.我还是要承认我还是想她,很想去帮助她,但是这所有只能在心里,因为除了我自己谁也不知道有她存在于我心中.我想说你永远是我的影子,藏在心灵深处的影子,我不能给你什么,可你却给我一件永生难忘的礼物,我的快乐由你而起,我的痛苦因你而生.找个理由哭一次,把我对你的一切可以全部溶到眼泪中,不要让人发觉我是在为你流泪,我要流一颗眼泪在你心中,让你能明白我是一个在远方注视你,希望你能幸福生活的朋友,即使过去种种不幸打击对你而言是种不堪回首的,可今天已不是昨天,明天的阳光还会灿烂.真希望我不再为你流第二次眼泪,我是那么坚强的人,可别再让我为你流泪了,我的心受不了.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1112', '2000', '我是九日欢迎观看我的日记天气晴转阴2005-9-8期待你，但不告诉你。我不愿意揭开那份羞涩的面纱。这份珍贵的情愫，请你，用一生的时间细细品味......很傻不是吗?自己给自己找麻烦,整天像个忧郁的小女孩,沉迷在假想之中,还要笑的那么开心来安慰别人.我已经忏悔多次了,我在看别人的文章希望在里面找到自己的影子,找到同样的心情,找到同样借口.我听着阿杜那伤感的情歌,多想让自己溶入其中,听的都有点害怕了,好象每句歌词都在唱我.忧郁了,这次我真的忧郁了.心乱了,人开始了烦躁.自己都不知道想要什么,我想去一个孤岛,就一个人,过原始的生活,只为吃而活着,没有什么精神没有什么物质的追求.这是逃避的一种的表现,终究逃不了的,明白啊,什么都明白,即使是别人劝慰的话都会说,可还是乱.纷乱的心在找依靠,在找烦乱的原因,想快点摆脱这样的心情,做不到,越想越烦,越想越记挂他.他是一个影子,一个被藏在心里一个很隐秘的地方的影子,若即若离的影子.在入睡前会想到,在大街上因某人有点像会想到,在热闹的场合会想到,在寂寞的时候更为思念的影子.我认为我是个很理智的人,我能很明确知道在做什么,即使有什么暧昧的事情发生都能妥善处理.太理智让我更痛苦,看的透彻也是我的一大缺点,看什么都那么清楚,让很多事情扼杀在萌芽中,以前都很成功,可这次却失败的一塌糊涂.我睁大眼睛想看清楚自己,看着镜子里的我,真是不认识那张脸,太陌生了,可皮下的却是那么的熟悉,是我吗?我一直在想,除了忧郁还有那么多的无奈,原本快乐的我去哪里了?我觉得越是抑制自己的感情越是思念的厉害.越是劝自己要放弃,越是放不下.有段时间我以为解脱了，可回头一看至始至终没有放手过.就是因为太明白了,知道所有的都是一个虚幻的故事,可就是任由自己去发挥那无限的想象,想的好象真的一样,虽然还有能力克制莫名的冲动,可真的心好难受.整个人像在梦游一般.出轨,很刺眼的字.我的心在出轨,违背一贯做人原则,我不愿伤害身边的人,她是无辜的,而且她对我真是无微不至,可在那心灵最隐秘处的她却揪着我的心,我从未为爱情流过眼泪,我所遇见的都没有对我造成过伤害.他曾笑过我是一个没有去失恋大学进修过的人,不懂得失恋是什么滋味,是的,我没有这种感受,我不知道失恋是什么味道,可现在我只知道失去了和她的联络，人空荡荡的,没有精神面对生活,色彩只有黑和白,听什么说什么都无思考能力.我问过一个人,告诉他我现在的感觉,他说我在失恋,可我有恋过吗?我不是一直认为人的一生只能有一个最爱,而且认为现在的拥有就是我的最爱,他的地位是不可动摇的.我极力在否认已经发生的一切,我开始学会了逃避,开始不再想,不再去看所有和他有关的一切东西,时间会让我平静的.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1113', '2000', '\"我是九日，欢迎欣赏我的日记。_2005-9-28星期五天气:阴..心情:沉思..小中大今日又是一个阴霾的天空..清晨一醒,又见周围昏朦朦的,似乎还是很早.本打算蒙头继续睡去,却吃惊的听见闹钟的闹铃准时地吵闹起来－－悠扬的起床号,如剥茧抽丝一般不紧不慢地带走我的睡意..扭头望向窗外,似乎是眼前一花..什么也看不清楚.吃惊害怕之余,才将多少带着睡意的眼皮完整打开:原来又是一场烟雨,如烟的细雨悄然无声地下着,我不禁笑笑,那首《春雨》闪入心头,而朱自清先生的文字却已经朗口吟出:\"\"与密密地斜织着,如花针,如牛毛…\'　深呼吸一口,颇为享受着雨水和徐风击起和带来泥土的味道..我发现我爱上了座城市的气息,安静.祥和..就好似多多少少寻找到了心灵中那间尘封已久的小门小窗.用手推开,打开了我心底如此一片干净天空..这些天在雨后看蛙友的日记,体会最深的就是死亡与疾病,还有就是感情的恩恩怨怨..死亡教会人一切,如同考试之后公布的结果－－虽然恍然大悟,但为时晚矣的感觉..所以生者要学会自己宽心和宽容他人..生活中常见到的有些人很可恶,有些人很卑鄙..有时反过来想想,设身处地为他想象的时候,我才知道,他多么值得可怜..所以务必原谅所有你见过的人,好人或者坏人..今天与朋友聊天,学会了释放,得到了宗告.学会了记住该记住的,忘记该忘记的.改变能改变的,接受不能改变的..令狐冲说;\"\"有些事情本身我们无法控制,只好控制自己.\'有一定道理,让我们多向好的方面看,尽量让阴暗离得远些..通过思想斗争,我所谓的大事其实也是小事一桩,让时间去解决,释放不满意的情绪,我依然像从前一样保持乐观向上..很多人都说我傻!我承认,明知道很多事情对别人好,可是对自己不好,对自己一点都不公平,可我还是执迷不悟..爱情,亲情,不知道为何,自己单单在这些情字面前显得如此脆弱..感觉身上的每一寸肌肤,每一根血管都是为他们而生,为他们而流动.除了那些一片一片破了的心是属于自己的外,我不知道我还为自己留了点什么?对自己的感觉是如此的陌生..爱了!全心的付出,脑海里总流动着思念,和牵挂,很多时候问自己,为的是什么?换来的总是无境的寂寞,和夜静时的孤单无助..有人说:\"\"为什么爱得如此淋漓尽致,你却越感觉心里是如此的空阔无边?\'是啊.能否让自己收回一丝付出的情感,既使\"\"车水杯爱\'也好,那样也许会少一点思念,少一点牵挂,少一点孤单和寂寞..人,都是有不同颜色的..在这人生的戏剧舞台上,我总让自己扮演着那个脸上画得花花,身上穿得红红绿绿的小丑,独自在站那宽阔的舞台摇曳着自己的情感..谢幕时,幕然回首台下那些欢呼的观众,在我回眸的淡然一笑间,眼角流下一滴滚炀的泪水,却不知道是为这个可笑的角色而流,还是为台下那些欢呼的观众而流,我不知道...……纯洁的心神,是天使的馈赠;洁白的衣裳,雪花的纯粹..沙漠的行旅,迷路的孩童.来,拯救!却是你纯真的灵魂..\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1114', '2000', '哈哈！这是一篇用心体会的文章你看到了吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1115', '2000', '又一个星期，时间过的好快！但我对我A个星期的行为吾太好，我觉得我系时候放地他啦！我好累啊！！我看到点我吾应该看葛野，让我真系死心啦！听起来好次好傻，但我觉得都吾咩啊！大家都可以做朋友啊！或者我有新的缘分到来。让我改变A一切呢？时间系最好的证明，我希望我下一段缘分会更好。对他的死心可能系再好的解脱，让我得到自由。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1116', '2000', '一直想找个地方释放一下自己的心情，总是苦于找不到，来到这里后，好像是为自己找到了一个家。我是个开朗的人，也是个外向的女孩，应该说心里想什么马上就会对老公全部说出来，但是我的另一面也许没有人知道，也不会有人相信我是有两面的，是一个可怕的人。今生我不知道自己会不会有孩子，如果有的话，我会好好爱他，好好引导他。这辈子我最后悔的事情就是从小没有好好的学习，从小就对学习不感兴趣，上课好像从来没有专心的听过课，做作业时也从来没有认真独立的做过，考试时从来都想偷看别人的答案，对什么都不感兴趣，无论做什么事情都是三分钟的热血，过去后就再也不会去做了。以至于现在二十八了，还是一事无成，只能眼巴巴的羡慕着别人。我是一个缺乏毅力的人，想好的事情，定好的目标，总是遇到困难就打了退堂鼓往后退。我狠自己的这些表现，我现在对自己非常的不满意。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1117', '2000', '[B][/B]昨晚一夜没怎么睡，为的就是今早起的来，可以陪一下他，我知道每次我睡一天或一上午他都会不开心。吃了田鸡粥、小排骨、肠粉后，去买了个穿衣镜，看着镜子里的自己，感觉也不是很丑的，呵呵，可能是平时太少照镜的缘故吧！都快忘了自己长什么样子了，十二点宋伟哥打来电话约我们去吃比萨，这已经是我们第四次排队了，为了安安能开心，父爱真的很伟大，放弃了睡懒觉看电视的时间；我想如果有一天我有宝宝了，他也会是一个非常出色的父亲的，他会很爱自己的孩子。坐在必胜客里，位子是邻街的，可以看到来往的行人，餐桌上摆着精致的盘、刀、叉，感觉很好，这是专给白领和有钱人去的消费的地方，我知道估计也就这一次了，以后不会常来的。说实话，比萨真的很一般，只是体会那种感觉而已，吃的东西真的不好吃。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1118', '2000', '吴燕这个家伙，真是越说越离谱，不过，呵呵，我也有那么一点点坏的。我就是要缠着她把bb的号码给我，当然，我很明白那是假的，因为她会知道，是根本不可能的事。以前她就骗我们，利用我们的感情，可是现在我们也不是3岁小毛孩了，也知道了怎样辨别一些话的真假了，所以全当自己在看小说一样都是假的吧！不过她说会给我寄超级女声的东西来，到还是有点期待的，虽然知道可能性并不大。今天就到这里吧，再见了啊！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1119', '2000', '[MOVE][/MOVE]真是太倒霉了，数学老师又来突然袭击，害我都没准备，5555还有一体没做，90分也没了，怎么办啊', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1120', '2000', '[MOVE][/MOVE]真是太倒霉了，数学老师又来突然袭击，害我都没准备，5555还有一体没做，90分也没了，怎么办啊', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1121', '2000', '[MOVE][/MOVE]真是太倒霉了，数学老师又来突然袭击，害我都没准备，5555还有一体没做，90分也没了，怎么办啊', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1122', '2000', '今天早上他出差去德庆了，姐开车来接我把我送到了信社，我第一次没有跟他一来上班。一个人在办公室里，很是无聊，不过还好，没多久就来了客户来签合同，又忙了些别的事情，一上午很快就过去了。中午去姐家吃了饭，下午接着去信社上班，一下午没什么事情做，我就一直打电话联系客户来签名。这样一天回来了，感觉身体有些累，腰累，好像撑不住多久就会感觉很累的样子。他月底就要走了，以后一直是这样的生活，我肯定会感觉到寂寞的，没有办法，只有这样了。要像静静那样能忍，我很是佩服她，人家比我小那么多都比我独立，唉，我要是不想死，想在这个社会上生存就要学会独立，不能过份的依靠别人，那样别人会看不起的。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1123', '2000', '哈哈``今天好开心哦``其实偶每天都蛮开心滴``不过今天蛮有趣滴``~上网滴时候碰到个找死滴``偶们四姐妹就联合起来把他死t一顿```看他还敢在偶们面前6来6去的``哈哈``下午的时候学校里办活动``偶们学生会的又要维持现场``好乱哦`又好累``工作不好做啊``~哇`~！`~！袄```偶们滴``学接界们好靓哦``跳起舞来更是羡刹一堆人哦```！眼睛都亮拉`个个都果pp偶怎么就莫得她们果pp啊```呜呜``！嘿嘿`不过`再过一个月学姐们就要走拉`到时就是偶们最大拉``偶们就是老大拉``哦哦`好爽哦`！老班水星期四、星期五要去见习``哈哈``好期待哦``！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1124', '2000', '冷涩的风轻轻的吹拂着面庞，没有一丝暖意.走在路上，注视着每个人行走过的笑容，有时候很迷惘，又很欣慰。没有朋友我会一个人坚强，以为只要这样对自己心理暗示，就会麻痹，就会接受现实。阴暗的角落中，多余的担心着同学的冷嘲热讽，永远活在自己阴霾的天空下，独自一人。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1125', '2000', '\"四年了，这四年来我一直都生活在幻想之中，幻想着有一天能跟他手牵手的在走在大街上，幻想着我生病的时候他会来关心我，无助的时候我能依靠在他的肩膀........这些幻想将会从今天开始全部都变成空白，我能胸有成竹的告诉大家我能做到，能把他忘记的，能让我的伤口复合的。可是当我自问自己的时候，我真的没办法跟自己说\"\"筱，你一定行的。今天是第一天，感觉身边少了许多东西，少了那个一年前他送给我的星星，少了这几年来他送给我的生日礼物。好奇怪，现在跟以前一样的啊，没有他在身边我照样能过的很好，现在也同样没有他在我身边，可是感觉自己很孤单，好无助。我会坚强起来的，因为我要勇往直前的开开心心的去迎接我的第二天，第三天，第四天.......相信我总有一天会做到把你深深的埋藏在我心里最最最深处的。我一定会成功的，你也要好好的加油哦！黑熊\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1126', '2000', '原来你一直都不相信我原来我所做得一切都是空虚原来你把我想成这样你是否知道你是否觉得得到我得心被你得话狠狠得刺了一刀失落得表情再一次出现我强忍着让眼泪不要留出可是它还是很不自觉很不自觉得流了出来你说我不高兴你会心疼那为什么每次都要跟我说那些话你得那些话真得很重压着我喘不过气-我现在在想为什么外面没有下雨否则我可以痛快得淋一次淋到我清醒为止也许我真得累了说起话来也很不清醒所以好啦我睡了-', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1127', '2000', '我不知道你会看得到或者看不到我所写的信只希望你可以还记得我我就是那个多年来直到我确认我自己已成长及真的懂得珍惜才知道我所失去的只有你让我留下我对你有很想问候你这些年你过得好吗？虽然我知道但我希望你能有个世界上来爱你我没有什么资格对你说些什么话我只想告诉你我如果你有看到这希望你能原谅我只希望你能原谅我因为我已没有资格向你再什么了[sound]>http://www.0ting.com[/sound]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1128', '2000', '\"昨天是第二天，本打算进来写下自己的心情，可是网站很难进，所以就没写了。决定要放手的时候，反而觉得自己越来越想他了，以前我还很理直气壮的跟大家说我已经放下了，我已经对他没有那种感觉了，可现在我才发现那些都是自我安慰，自我欺骗的话。其实一份感情根本就不能那么轻易的放的下。如果可以的话，在一年前，两年前就可以了。也就不用等他现在这么僵的局面出现了。现在好像知道他过的好不好，开不开心，有时候真的好像打电话给他，听他对我诉苦，当他的忠实听众。而我可以试着去安慰他，开解他。好希望他不要天天用酒，用烟来麻醉自己。黑熊我现在只能放在心里默默的祝福你快乐，开心。真的好想你，在每次出门或回家，都会忍不住的朝他家方向望了望。明知不可能见到他，明知他不会在这个时候出现。走到每一处都会触景生情。特别是那段时间我们在学校的时候。两个人就像冤家似的，一碰面就会在那里抬杠，但我想从这件事发生了之后，大家再也看不到，听不到我跟他在那里打闹，嬉笑的情景了。\"\"黑熊\'\'这个绰号是我取的，已经叫了四年了，一下子叫自己以后不要在叫这个名字，感觉上还真的不习惯。以后应该要习惯叫你billy了。而我想以后两人碰面也不可能会在那里死黑熊，臭黑熊的在那里戏弄了。现在，就如你说的一切都结束了，结束了。好想你，一千个想，一万个想，想你。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。。\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1129', '2000', '望着手机，以前的等待说不定会等到。可是现在的等待是不可能了。因为我们以后会有很少很少的机会能通电话了。看着msn你在线，可是无法跟你聊天，而且还把你的msn给阻止了。因为当我决定要把你送给我所有的礼物还给你的时候，那一刻起，我们差不多告诉对方我们以后不要在联系了。想着那天我们第一次的约会，同时也是最后一次的约会。虽然只有一次，可对我来说已经是我最快乐的一天。也是我最满足的一天，至少我曾经靠过你的肩膀，也牵过你的手。每次睡觉之前想一下你，想你今天是否过的开心，快乐？而在每一天睡醒的时候，幻想一下你对我微微一笑，代表着新的一天又开始了。想你，发现现在每时每刻都会想起你。时间真的能冲淡许多事情吗？而对你的爱何时才可以停止呢', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1130', '2000', '今天我到了我在学校玩得最好的家，虽然她家不大，但是好温馨的不像我到家只听得到吵架，烦死了！即使他们关心我，但是吵架就是对我最大的折磨！希望我的家只充满幸福的味道！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1131', '2000', '[COLOR=#6495ed][/COLOR]每天都在回忆着过去``我决得还是过去好，没有烦脑`每天充满了快乐！没有“斗争”。还想着一个人，不知道为什么要想，有时候觉得自己好笑，过去还想着干什么呢？又没有留下什么特别的回忆~`！哎', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1132', '2000', '好久没有写日记勒..也许,是最近没有发生什么事..所以,我觉得,也就没什么好写的..但是,不知道,今天为什么..突然又想写日记...这几天,我的心一直不能安定..总觉得,会有什么事发生..但是,到底会发生什么事呢.?心,好混乱..到底会发生什么事..为什么,我的心里这么的不安..?我突然有种想法..我想一个人去流浪...去每个地方看看..但是,残酷的现实,不允许我这样做..有好多,我想做的事..但是,因为这现实..我有心..却无能为力..多想,自己能变成一只..自由飞翔的小鸟..到处去翱翔..但是,为什么.我偏偏就是个人..得到爱情的人,庆幸自己是个人..事业失败的人,悲叹自己..为什么会是人..难道,这个世界上..就没有一件事情..没有一样东西是完美的吗.?人,不可能十全十美..哎...我干嘛说这些有的没的.?我是不是傻勒.?呵..也许吧..现在的我,只觉得..活在这个世界上,好痛苦...但是,我又没有勇气去死..所以,我只用鼓起勇气活下去..不知道,我的未来..会是什么样子的呢.??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1133', '2000', '在梦里.我看到勒..我最想看到的一个画面..我看到,有个男生..他为我吹满勒一屋子的泡泡..我好高兴,好感动..原来,我这个愿望真的能实现..但是,为什么,我就是看不到..那个男生的脸.??我想跑过去看清楚..但是,当我跑过去的时候..我却掉进一片黑暗...梦,醒勒..这代表什么.?为什么,就是不让我看到..梦里那个人的脸..?会是谁.?到底会是谁.?我想要知道..可是,我却不能知道..小时候的我..许下勒一个幼稚的愿望..谁要是能为我吹满一屋子的泡泡..我就做那个人的新娘..!!呵..现在想起来..好好笑..那么幼稚的愿望..我也会许..?但是,这个愿望..能不能实现呢.??谁知道呢.?以后的事情..只有到勒以后才知道..我一直期待着..期待着能为我吹满一屋子泡泡的人.能早点出现..即使,我知道.这并不可能..但是,我仍然愿意等待..这算不算我的一个人生目标呢?我只希望..真的有那样一个人存在..我也相信..那样一个人一直存在..所以,我依然静静的等待...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1134', '2000', '\"第一天来这里...坛子上，老大的签名档里，有这么个欠点的位置:\"\"咱心情日记本..记录点滴..\"\"就知道老大又找打什么新玩意了。点点就点点好了，谁知道，这一点可好，呵..又把老大那糟糕的心情点出来了...我就不晓得了，那高二的学生真的就那么多的愁？虽然我也过来人啊，也不至于他这样的难？！莫非，我就是传说中的脑子有问题的人？？坛子里，大家叫我蝶儿，可有人说那蝶儿和蛾子有鸟区别撒？？我无力力争，算了，我就是美丽的好像蛾子在飞，你又能把我怎样了咧？？就算是打声招呼好了，一会上那要了我老命的“邓论”(邓小平理论)。天气还真的事冷得要命啊~~~唉....\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1135', '2000', '这几天我经常上一个叫类风湿康复之家的一个网站，这个网站也有QQ群，自从知道了这个网站后，我太高兴，因为在这里可以和一些病友们互吐心声，互相鼓励对方，也可以得到一些治病的经验；看到好些都是病人的家属，我真的有些感动，那些病人多幸福啊，有亲人的关心，再想想我自己孤军作战，同病魔斗争，不禁有些伤感。不过伤感归伤感呀，还得坚持下去，即便没有人爱自己了，自己也要善待自己才对！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1136', '2000', '今天注册了一个日记本其实没有什么原因就是想以后可以看看自己以前的事', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1137', '2000', '[COLOR=#006400][/COLOR]好烦啊!!点解日日都要考试啊!我好想放弃啊!!我吾想再读落去啊!!有边个可以帮我啊!点解会紧架,我的心情好低落啊!!都吾知道自己其都烦咩.........好想快点离开学校', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1138', '2000', '我是九日，欢迎欣赏我的日记。_2005-10-20星期四天气:男人与女人心情:难解千千结小中大我抱怨,我觉得我每天看完日记的时候都是头昏脑涨的,没有了灵感..笑笑和蝴蝶就在一旁平复我的浮躁,说,慢慢会习惯的..于是,我笑了一下.平静下来了..简单的心事,在这样平淡的每一天..有了一份心事以后,许多人都会变得敏感多疑,变得脆弱而不开心.若有所失,若有所得.这样的情绪一直延续到死心、死去.而爱情的美丽,或许也是在这患得患失中..爱情是有魔力的,能让一个人由幼稚变优雅,也能让一个人痛快的哭泣.而更多的是忧愁,是千刀难斩的愁思.一分一秒的忧郁,一日一夜的忧虑,筑成了爱的千千结..当为找到一个让自己心动的人而激动的时候,爱的忧愁渐渐蔓延.如水的波纹,一圈一圈的荡漾开去.开始担心,喜不喜欢我,我值不值得去爱?空洞的灵魂渐渐充盈,渐渐变得坚强..女人是男人成熟的学校,男人是女人优雅的催化剂:爱上,所以付出,所以痛;爱上,所以无悔,所以一鼓作气的走开;爱上,所以放弃,所以一朝一夕的思念;在一起,相处更难;不在一起,永远在心口留一个疤..爱上以后,对方回应,便是一段缠绵而天崩地裂的日子..爱上以后,对方拒绝,是一种抽刀断水还愁的命运..而最痛苦的,莫过于对方犹豫,让人欲前不能,欲罢不甘.于是在一个美丽的日子感受天的阴暗,在一个个深沉的夜感受冷冰冰的寂寞.而,痛,谁知道?也许有人能懂,可没有人可以解除.所以,我们在一曲《死了都要爱》的旋律中,唱得撕心裂肺,唱得眼泪涨满的眼眶.但还是,没有掉下来..最怕爱上那种曾经有过伤痛而心上有把锁的人,他坚持,她不语;他游戏,她拒绝.现在越来越多的人,成了一种自私的动物.不是为人不善,而是不爱别人,也不让别人爱的感情自私.这样的自私让人止步,也让人无奈而认同.我是这样,也许,你也是..只留下夜给自己,给自己心里的脆弱,让我们自己成为,夜的爱人..我想,他一直都知道我是个坚强而很脆弱的男孩子;她一直都没有对我说过安慰的话,她一直也没有走开不理我;但她...我...,有的东西深深嵌在身体里,比如性格里的某种倔强,或者骨子里对完美的追求.有些痛,就像一个裹着白色纱布的伤口,或者恢复,或者溃烂,只有我一个人知道.也无须敞开,更不需要诉说..沉默,是我的本能.简而化之,是躲避伤害的有效途径..我竟一直这样生活.于是,看淡一切.包括爱情.我一直渴望着一份坦白的真实,希望彼此之间的透明能够更好的爱;而当曾经的影子在我面前完全清晰,我迎来我心尖上的锐痛..我听到我的喉咙被卡住的急促;我听到血水滴落的声音;如此,心如刀割..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1139', '2000', '我是九日，欢迎欣赏我的日记。_2005-10-23星期四天气:暖..心情:现在幸福时小中大时间久了,我发现自己最爱做的事情就是走路..我喜欢步行在每一个街道,看着落黄的一切,有中惬意的感觉..心情好了去走走,心情坏了也去走走,从这里绕一圈,从那里出来..走路看天,我喜欢这样,也许是因为孤独,过滤着一切,我需要这种释放,来缓解自己的压力..突然想起了一句话:为了走路而走路,或许我们真的有时候该不为了什么而生活,放下一切再拾起的感觉是不一样的..\'给自己一个时间,放下自己的思虑吧!静静的..每天早晨醒来,发现自己还活着,这时是幸福的;不上班的时候,可以尽情地睡,这时是幸福的;没有家庭的束缚,可以去自己想去的地方,这时是幸福的;一个人独处听着喜欢的音乐,这时是幸福的;有工作可以做,有薪水可以拿,这时是幸福的;与家人团聚,与友人欢聚,这时是幸福的;有宁静的夜里,静静地思念着某人,这时是幸福的;.....原来,幸福并非遥不可及,幸福也可以随手可得的..从现在起,发现自己的幸福,珍惜拥有的幸福,寻找未来的幸福!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1140', '2000', '确实是有些奇怪的题目，我也不知道为什么要这么写。Eisen对神子的爱慕之情，一直要藏在心里，很可惜，我不能去很好的理解，这么纯真的Eisen，也许正是这样，才会同情和怜悯他。一直以来说支持YE，也没拿出什么实际行动来，我也知道自己的古文水平，不敢轻易破坏好东西。昨天收到一份特别的礼物，来自于香港的饼干，包装从表面看来确实和这边没有什么太大的差别，但发现打上的是过期日期，笑，终于不是看到那样什么保质期还有找得失去信心的生产日期。听了人家说起香港，什么都要钱，只要有钱的话，享受很好的服务。但是，也不是个没人情的地方，和任何人问路，都是主动回答，还帮你兑换乘车的零钱，心里听得痒痒的，但是最想去的还是日本，东京，福冈，都是好地方，将来应该有这样的一天。喜欢Air中的天空和云朵，我们这边有这样美好的精致，但是天空并不遥远，我想是没有海的缘故罢了。笑，真想去海边好好放松一下，只是一个人工沙滩就让我津津乐道了几年。对阿，那时候还年轻，不是，是年幼，初中生什么也不知道，我最美好的光阴已经献给过去，一去不复返。没有人能指望我笑得如同以前一般灿烂。听着包子的歌曲，我忍不住去学包子的声音，因为喜欢，我要是也能制造八成相似的效果就会欣慰。没有恋声的习惯，但是对声优也谈不上没兴趣，这些人是伟大而又是那么平凡，闪耀星光和灵魂的同时，也给了我们最真实的一面。包子被人开玩笑的样子很可爱，石头暗爽的动作好搞笑，声优做着这么耀眼的工作，却是领着平凡的收入，甚至温饱都不能解决，默，要怎么说呢，来我们这边的话，只要几个广告就可以翻身了。看到一句话，把死去的东西变活，那种快乐不亚于创造。笑，这就是回忆么，把那些已经逝去的过去重新翻出来整理，剪下自己最喜欢的那部分，基因的重组，我不由得联系起来，只要最好的，只要有用的。清风的回忆，我都已经无力去整理和伤心，没有人继续和你玩EG，也没有文疯子在群里谈论人生是积极还是消极，谈论是鸣人的人生观正确还是佐助的错误。我们已经走远，我们何时相聚，这次我应该没把字打错了，真是和当初预感的一模一样，笑，我有什么资格去埋怨什么呢，因为无力去保护，我不是给不起空间，给不起的是时间。我相信一定有人也在我一样努力着，期待着清风有一个更崭新的开始，至少应该相信。我已经不去想念我的那些白文了，虽然写了很多，但是到头来却什么也不是，仍然感激那些文字记录下我当时最真实的感受，指尖跳跃后的感觉和容易遗忘，但是留在心里的印记，甚至是将来再次翻开的心情都是珍贵的。不想放弃任何自己写的文章，因为都是在表达着最想表达的东西，那是对生活的理解，应该是这么说。我也一直相信我不是孤独的，没想到还能有人拿着我在高一记下的笔记在高三进行奋战，尽管我和文科失之交臂，你一定能带着我的梦想努力下去，我也会带着你的梦想而继续。因为我们现在所做的不止是为了自己，连相互那份也要加油才是。清流は白やかな　水の笛真っ白き　滝よこの调べが涸れはてても想いは涸れずにあなたと同じ场所に　伫んで瞳を闭じる远き日々の　想い出达かけめぐる　走马灯どうすればいい？问いかけても风がただ　微笑むだけ水面に落ちる　花びらはあなた心に波纹だひとつぶの　涙から几千の想い広がってゆく　あなたの元へささやかな　愿いごとあなたのためにもう少し　强くなれるのならあの日と同じ场所に　伫んでひとつの　影にあきらめたい　あきらめない恋心　走马灯どうすればいい変わりたくて傍らで　戸惑うだけ夜空に落ちる流星はあなた心に祈りがひとすじの光から真っ直ぐな思い伝わってゆく　遥かな明日へささやから　愿いごとあなたのことを本当に　好きになっていいですかひとつぶの　涙から几千の思い広がってゆく　あなたの元へ淋しさも　悲しみも　流れて消える泡沫　あなただけが真実ひとすじの光から　真っ直ぐな思い伝わってゆく　遥かな明日へ儚さを强さへと変えてゆけたらいいのに　いつもあなたのそばで清流是优美的水之笛象纯白的瀑布即使音调干涸了思念也不会枯竭在和那天同样的地方伫立着闭上眼睛过去的点滴回忆象走马灯一样浮现怎么办才好？即使这样问了风也只是回以微笑落在水面上的花瓣是你心中激起的涟漪……因为一滴眼泪无数的想念向你身边蔓延小小的心愿为了你我要变得更强一点和你在同样的地方伫立着一个人的身影忽明忽暗恋慕之心象走马灯一样怎么办才好？想要改变但在你身边只是困惑夜空中坠落的流星是你在心中祈祷……因为一道光芒真挚的想念向遥远的明天传达小小的心愿我喜欢你可以吗因为一滴眼泪无数的想念向你身边蔓延寂寞和悲伤都化为泡沫飘散只有你是真实的因为一道光芒真挚的想念就向遥远的明天传达化虚无为力量即使一直在改变也好我会永远在你身边我微弱的力量，还有无法遏止的思念，清风，你会等我么？你是虚幻还是真实，这一直是困扰我的问题。不管怎样，我只想守护在你的身边，ZiDoZiDo我能喜欢你么？我能保护你吗？我是虚无，而你才是真实。我是真实，而你就是我心中的太阳。泉水，流不尽我的思念，那无法遏止的思念，就让它一直延续下去，那种心情一直伴随我下去。落花时节再次的相逢时，我会用那悠扬的笛声，倾诉我的思念，永远沉浸在清风的童话中，不再醒来。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1141', '2000', '[COLOR=#000000][/COLOR]天冷心冷他2点多才来。一意孤行的后果。爱他所以愿意等他。明天还要上课好累啊。怎么办啊。我一感冒就发鼻炎。好烦。我喜欢只打句号。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1142', '2000', '我是九日，欢迎欣赏我的日记。_2005-10-24星期一天气:晴.心情:疯狂为爱.小中大今天,她对我说出了一直藏在内心深处的话..我想到了以前自己写的一段话:爱,如果真心相爱,那么应该公开自己的一切,把自己的一切都交给对方.把自己的身心全都交给她..爱,如果真心相爱,那么就应该把所有的钥匙交给她,任他随意打开大门..爱,如果真心相爱,那么应该把贮藏在仓库里的谷物以及掉落早地上的米一粒不剩地交给她..向他敞开所有的房门,随时去迎接她……彼此隐瞒,紧闭心扉,能说是真心相爱吗..?今天她说的,就决定了成为和我共患难的人..霞,如果今天写下的你都能看到.不要再怀疑我的爱好吗?我还是以前的我,深爱你的迷迷啊,知道这些..只会让我更想给你幸福,让你身边有我..今天是晴天,所以夜晚的天空很美,美的叫人难以相信..当所有的灯光都熄灭,自然的恢复漆黑的本色,这才发现,其实美丽也需要修饰..爱情沿途的黑暗,即使在有光亮也总有回到最初的那一天..不要逃避我,我会心碎的..今天你说的,我不在意,只因为我是爱你的,想要给你一个幸福的家,让你好好爱我..霞,真想有你陪着..高高的地方看着夜景,吹着凉风,体验自然,感受那份独有的唯一..我怕黑,真的很怕,但是今天不一样,我知道我是安全的,我刁蛮的任性,无理取闹,你都无可奈何的接纳..感觉这样的快乐曾经有过,我没想到自己的调皮会把自己弄伤,我更没想到的是,你会那么的在意自己..我想说感激,但是更多的还是感动,所以我没有说谢谢..有你陪着.我很幸福..可是现在,我才发现自己以前多么的奢侈..可以那样挥霍你给的疼、你给的爱..那么以后,让我好好珍惜你给的每一滴、每一滴、好吗?一个人,看看天空,依然很美,没有星星的陪伴更多还是凄凉..一个人,空荡荡的街道,微亮的路灯,随时可以摔到的我..你说要把我扔掉,说要让我去找自己的幸福..没有你,我又拿什么快乐??一个人坐在窗前,好熟悉的画面..我也应该很习惯,因为这样的真实不是第一次,想着你说的话..深爱我的你,怎么舍得我..答应我好好爱我,好吗??我是真的用心爱了..没有你,我不可以习惯,我也习惯不了..所以以后不要再说离开我的话,我不允许,也不会答应..你答应不会丢掉,所以我才这么的离不开....。如果有一天,当你看到这些我亲手写的,一直习惯写的..你会怎么想?你还记得你曾经说想抱着我哭吗..?我现在真的很希望你能抱着我哭一次,就算真的只有那么一滴泪,至少这一次的眼泪,我会背负一生,一辈子...我很少说后悔,这一次也不会说..你总是问我,为什么爱你?爱你什么..我总答不上,真的,如果我真的找到答案那一天,我一定第一个告诉你..很多事在当时总是有那时的道理,在那时也许真的只有那一条路..但是现在,是怎么也想不起来..终于感觉到了美好..终于也开始发现相见不如怀念的奥妙所在..每天想你一遍便是每日吻你一次,我不孤单,虽然直到现在也只有我一个人在说话..霞,我爱你..!所以想念你..!在这个寒冷的秋天,想念你所带来的温度已经足够温暖我..我冰凉的手,已渐渐温暖起来..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1143', '2000', '我是九日，欢迎欣赏我的日记。_2005-10-25星期二。天气:晴心情:爱不后悔小中大《。。》..现在,我一个人听着《信仰》,我知道爱也是一种信仰..!爱到今天:有喜.有悲.有欢.有愁..认识你,我很幸福.我是真的用心爱了..我.我.我.!!!想你,因为已经不能控制..念你,怕一松手你就没有了踪迹..所以能做的.就是牢牢把你缠住,陪着你一起呼吸..是的,给你写的.为你写的.也是我的真心话.不知道怎么说.不知道为你可以做些什么.?这两天,我好累,好无助.压力好大..我都一一的忍下来,我不敢让你知道,怕你担心..也不敢跟妈妈说,她会哭.总会让我回家..一个人的日子我真的怕了..这篇日记才刚敲上上面那几个字,我却不知道自己究竟想说点什么,那么随便了..让九日好好的理理自己的情绪..今天,只有寂寞的文字陪伴着同样充满寂寞的我,和着清脆的键盘声,那种心灵的寂寞并非岁月的时光能够拧转..曾有人在论谈跟贴里问我,为什么总是如此伤感,其实我也曾经想过变化一下自己的笔芯,无奈写出来的总是一片灰色..也曾想过敲打一些快乐的文字,可无论怎么快乐的文字经过我手里的键盘都有些忧伤的气息,怎样快乐和无忧的文字在我的手下,也总是带着那么一点淡淡的忧伤,淡淡的忧伤漂浮在心里..怎样的岁月也挥之不去,或许我习惯了文字的忧伤,或许文字习惯了带着我忧伤的气息...书上说:惜花的人,最怕看花败..是怕,花没开放就凋零吗..?痴情的人,最怕看分离,是怕,情仍浓时缘已尽吗..?历经了俗世的种种磨难,却也晓得花开也有花落的道理,情深也有情薄的相思..没有一朵花是四季不衰的,也没有一个人是永留心间的..人生几载,匆匆走过,错对也不由心..很多时候,都有一种欲诉无语的感觉..或许,我习惯了沉默,习惯将一切都独自承担,习惯了将风雨独自承受..外人怎么也不明白表面热情开朗的我心底的沉默,只有自己明白,心底的沉默和寂寞相伴,在热闹或者喧哗的人群中,总是习惯了沉默不语,而很多时候,文字是一种苍白无力的符号,根本不可能准确的表达人们心底需要表达的东西..或许,我又陷入文字的忧郁了,不想将我的忧郁带给到这里,可文字还是流淌着我淡淡的忧伤,或许我是属于忧伤的种属..所以,现在.我选择了锁上自己的文字..我想我是相信爱情的吧..我一直告诉所有周围的朋友,要相信爱情,不管你是幸福还是不幸,都要相信爱情..我们相信这个世界,一定还有什么地方,存在单纯干净的爱情..它忘记你的身高体重,忘记你是苍老还是年轻,忘记你顺着人流的方向还是一直在寻找黎明..它存在,只因为,你是你,我是我..有人说:生命太短,短得来不及回头.生命太长,长得看不到希望..时间,是诡秘的,人生许多的相遇,便印证了时间的诡秘,刹那回头,恍然发觉..原来,我们早已在彼此的时间里安然等待,等待这样的一次相遇,不管是前世的约定,还是上帝的安排.反正,这样的相遇是注定要发生的..有人说,爱是一个人的事.当然,最好的情况下,爱是两个人的事.多么无奈的时候,我们才会说,爱是一个人的事,才会说,曾经爱过,便已经是一种永远的关系了..是怎样的遗憾,我们才会这样说..如果对某些事无能为力时,至少我们还剩下想念,想念是无奈的选择,但也不失其凄美..当我们不能与心爱的人白头偕老时,便让他在我们的想念中永远年轻..即使当我白发苍苍时,在我的心里,你还是当年的你,没有老去,还是以当年的语气,对我说话..如果当所有的承诺都随着那水中的花散去,如果当所有的誓言都开始变的残酷,一切全都风化,一切都不复存在..那么,我也将不在回首往日..我会把梦想装进幻想,把现实投入到生活..如果一味的只是去等待,则不如努力的去争取..毕竟,我们是存在于无限的时间中过着有限的生活..一生,是可以很短暂的,红颜易逝,人生在这样的想念中,也就过去了..能遇上让自己这样想念的人,也就没有后悔可言,一切的一切,没有后悔,只有遗憾..但,《..》这不是我想要的,还记得今天对你说的吗??我已经准备好了,和你一辈子..穿上新衣服,心依然是旧的,并由着岁月,越来越经不起捏揉..脚累了可以歇息,心却不能..只因终日都无法停止思想..如果你觉得我面带倦容,我想说那不是旅途之劳累,我只是心,有那么一点累...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1144', '2000', '\"好久没有打开日记本了,打开一看,朋友的日记本是我申请的,看人家都比我写的多的不是一点半点,我好惭愧~~~~~今天打开日记本,不知道该把那天的心情记载到里面,想起过几天就是你的生日了,我好高兴,提前就在准备那天应该怎么样给你庆祝,想到能和你马上要见面了,我不知道此时的心情应该用什么样的言语表达出来.天天都在想送你什么样的礼物最好,但是费劲一切心思都不知道该给你送点什么好,准备在你回来之间把礼物给你买好,我知道你不想让我给你花钱,认识你这么久以来,你从来没有让我给你花过一分钱,我不知道你是出自一种什么样的心里,我有的时候很不理解你,也很生你的气.我想你的想法太过于复杂了,大家都是朋友,为什么我不能给你买东西.生日对于每个人来说一年也只有一次,希望你的生日我能和你一起渡过,但通过电话后,你给我的希望越来越小,你说可能因为工作的原因回不来,但是我为了你的礼物到外面跑了一天,最后费了好大的劲才选到一件我比较喜欢的东西.我不知道你会不会喜欢,但是我真的很想和你一起庆祝你的生日,我想亲口对你说一声\"\"祝你生日快乐\"\"iloveyou\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1145', '2000', '真不知道想写些什么了?好久都没有打开日记了,以前开心活越的我现在沉论了,在也找不到往日中的那份心情,今晚的心情有点林乱,就是说话也有点语无论次,算了还是不说了,', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1146', '2000', '晕了,前些日子,小谢他来看过我,那种心跳的频率又如一年前和他初次前面时的感觉,可惜的是他却从来都没在呼过我,我丛然很爱他,说了好多肺腑的感方可他一直都沉默无言,分开一年多,如今我仍然能至上一句我一直都在爱着你', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1147', '2000', '文字今天真是气死我了，我有预感，好象我和他又要吵架，为什么每次到什么重大的考试我们都会这样呢？？难道真的饿是我的错吗，可是，人家女生谈论什么关他什么事啊，偏要去管，以前有过，我也觉得没什么，可是今天下课时，别人都在看报纸什么的，他到好，跑进跑出的问谁是谁，简直就是神经啊！不过，我今天好象火气是很大啊，大概是长久以来太压抑了吧，哎，反正话已经说了，也没办法收回的，不知道他明天会怎么样啊，如果他生气了，那我肯定倒霉了啊，可是，他说过会迁就我的啊，究竟他还记不记得呢？？文字反正我也没什么错啊，谁让他老去研究他们班哪个女孩漂亮呢，真不只这说明了什么哦，是他花心吗？？不象，但说他不是花心的人吗，他好象也不是，哎，到底把他分到哪一类人呢？？见了陈佳妮还会主动和她打招呼，可是见了我呢，真是一言难尽啊算了，就这样吧，要好好准备明天的考试了，我可不想进入初三的第一次考试就很差劲！！朋友们，保佑我吧，希望我能有个好成绩！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1148', '2000', '我不要伤心了，哈哈文字', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1149', '2000', '你们过的怎么样啊，明天，考试来临', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1150', '2000', '[SIZE=5][/SIZE]哎，看来我真的错了，现在好难过啊！g，你怎么可以不理我呢，你不知道，我好难过，好字则，昨天，是我太情绪化了，我错了，可是，我今天和你道歉了啊，你怎么还不理我呢？我以后不会了，真的可是，你以前不会这样的啊，这次，你怎么忍心这么对我呢？？我好不明白啊！你说过会迁就我的，我也知道迁就也应给有个度，现在，我已经向你道歉了，你怎么还不原谅我？？你，真的那么生气吗？对不起对不起对不起——————我真的不知道你会这样的，从来没见过你象今天这样，生那么大的气，你知道吗，整整一天，我都在想你，见了面也不说话，这种感觉，真的好难受，g，求你了，原谅我吧，我也还是个小女孩，你就再迁就我一回吧', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1151', '2000', '中午刚给他打玩电话，我竟发现自己不是那么的想他了。在我忽然一种心血来潮想到要给他打电话，当时的那种心切是无法用语方来描绘，可听到他的话真让我寒心，失望。这到让我想起我妈说的那句说：“人在情意在，人不在情意坏”真的如些吗？与他分开这么久，他从来都没有打过一个电话给我，就是我打电话给他，可他接到电话他也不会说什么，我的心每次都不得炽热的，而他却是冰冷的，他的冰冷击灭了我的炽热，让我愤恕，痛楚，无助……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1152', '2000', '我失眼了！小谢我好想你，我好想一下子跳在你的面前，紧紧的使出我全身的力气去拥抱你04-12-17', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1153', '2000', '今天晚上就是平安夜了，好想打电话给我的那些同学朋友，可他们那像我这么穷困呀！他们一个个全是大忙人，都在向自己开卷有益好的未来拼博呢？机时我却只能整天躺在被祸里虚度时光。各位兄弟们你们平安夜过的好吗？你们想我了吗？我想今天晚上你们过的一定很开心，你们的平安夜一定过的很快乐，不像我就我一个人这么孤单落莫，04-12-24', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1154', '2000', '以前我总觉得时间过的好快，可现在我却感觉这时间过的太慢长了。时间越慢长就让人感觉越滑味，厌卷孤寂，有时候我心血来潮就会受不了眼前的生活，就总感觉自己快要玩完了，马上就快要变成老古懂，与世隔绝，我开始抑郁，忧郁，郁闷，甚至愤恕，急臊，剧烈狂猛的心脏都快跳到地面上来，我想那些与我共患难的兄弟们，想我的心之所牵，魂之所系的他——小谢！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1155', '2000', '一个月过去我好像被打入了地狱，然后在头胎转世回到了十八年前，依然那么天真无邪，充满青夫朝阳的小艳子，她已经习惯和爸爸妈妈的朝夕相外，她开始和妈妈谈天说地，开始陪爸爸下棋，而我就有事没事的和他们大张棋鼓的夸夸其谈，要小孩子脾气，总是和他们吵吵这闹闹那的，这一个月我虽然孤寂，但是我找回了许许多我失去的东西——“温馨的家”今天我感觉我是最幸福，以前我以为他们不爱我，在加上他们长年不在家，所以才造成我对他们的误会，其时他们每天辛苦的劳动都是为了我，看到他们每天工作的那样我好心疼，自己一点都不懂事，还经常惹他们生气，我太没有良心了，我以后在也不任情了，不惹他们生气了，但前提是在他们不惹我生气之外。04-12-27', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1156', '2000', '今天一场突出其来的大雪迎来了新的一年。这没有一点生机活力的时光还是这么这么的慢，这也是前所未有的感受，记得我答应他二月份一定回去然后我就一直希望时间能过快点，然而周而复始这令你反感觉讨厌的时间一点都不善解人意，偏偏与我唱反调。想想还有一个多月才能到2月，我还要一个多月才可以见到小谢，我心里有好多话要和你说，可你远在合肥，这也只好把要说的种种全埋藏在心底的最深外，我虽与你相隔两地，可我的心一直都没有离开过你，每天都读上你写来的句子，我也只有读你写来的那短短的句子时才是最充实的，我好几个星期都没上网了，都怪这儿的天气实在是太槽了，准的我无法出门，我已好几天都没踏出门坎了，这对我堂堂小艳子来说等于天方夜谭，这一个月来让我失去了自然，我找不回一点属于我应有的于生俱来的个性。-04-12-28', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1157', '2000', '昨晚小谢的爸爸打来电话说是得病住进了医院，很想让他回去，老公一晚没休息好，今天早早起来就订票，下午走了，现在就我一个人在这空空的房间里，很想他，平时他在时也不怎么感觉到他的重要，一旦离开了，真的很舍不得他走；刚才去给姐姐订票出来后，我开的摩托车打不到火了，我推了好远，推到修车那里充电，要是老公在这些活就好办了，我给他发了短信，他说要我自力，嗯！他说的对，我可能是长期在他的关照下，所以养成了依赖他的习惯，这是非常不好的，我都这么大了，要自力了，不能总把自己看成是病人，或者是孩子，已经三十的人了，要是有孩子的话，也都会跑了，我应该学的成熟些，希望我快快的适应一个人的生活，让自己丰富起来；快乐的度过每一天！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1158', '2000', '没想到咱们的爱情也有一岁了？今天是个好日子，有许多有情人在今天喜偕良缘了？我说过不在给你打电话的，可我每次都被你的无言征服，不由自主又一次拨了那倒背如流的几个数字，上次我打电话给你爸，我要她带话给你，让你给我打电话，我多么钯切的想接到你的电话，可你却一次又一次的让我失望，你平时不打也就算了，我特地让你家人给你带话，让你打，你却……你知道此时的我有多孤独寂莫无助吗？我多么希望你能给我打一个电话，那怕我看到是0551的区号我的心也会得到一点点的安慰，我一等是孤寂落莫，二等音迅全无三等失望陪至……从来没有如些痛楚过，我承认那些小说家笔下的“心碎”的字样，那“心碎”两字实在是不科学，医学字典的撞击力，也不会把心撞“碎”呀这种即不通又不合复逻辑的名词真不知道那些没“知识“的人怎么发明出来的，可是我承认我心碎，因为我就是活生生的例子，', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1159', '2000', '\"\"\".哑鈀﹏23:51:06如果真的爱我。.你就会顾及我的感受.钱并不是什么好东西..金钱利益都只是身外之物.种有⒈天我也会赚不到钱.那时候我又该怎么样呢.!你有没有想过.当你真正决定去爱⒈个人的时候.那个人却因为⒈点你觉得不重要的事情而跟你分手.你是什么感受.我要找的不是有钱的..能给我金钱上的舒容的.而是真正对我好的.喜欢我的人.也许我很任性.也许我还很不懂事.你有没有给你自己⒈次机会.也许几年后你找到了真正属于你自己的工作呢.>?我要的不是那种有钱人的生活..而是平淡幸福的快乐小家庭..虽然苦⒈点.但是却很充实.却很快乐.还会有种成就感....\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1160', '2000', '她是个大大咧咧的女孩,每次吃东西的时候总是把衣服弄的很脏.她是个爱吃爱玩的女孩,虽然外表看似成熟,但是个长不大的孩子.她是个好强的女孩,在她的字典里没有输的字样.她是个重义气的女孩,姐妹⒈句话能抵老公的⒑句话.她是个善良的女孩,老在我面前表现她正义的⒈面.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1161', '2000', '\"我是九日不想睡，欢迎欣赏我的日记。_2005-10-19星期三天气:阴天心情:冷小中大这几天天气起了变化,好冷...老天爷说变就变,连续两天出门的时候不管穿多少似乎都感觉不到彻底的温暖,严重点说甚至手都冻的红了起来,明天,又要一个人出门了,要去衡水培训了，不知道为什么,感觉自己有点自虐的倾向,喜欢很冷很冷的天,似乎好的天气里发生的事情一直记得不清楚,可是只要遇见坏天气,什么东西发生都有意义,日后回忆起来也有滋有味...再那的两天挺好的认识了几个大哥和一个小女孩，那个女孩挺可爱的，听课的时候她当时坐在我的对过，时不时的还听着MP3下课了还给我介绍了她的南朋友，挺潇洒的。她还说让她男朋友改日请我吃饭呢，因为我们都是作生意的所以都很聊的来有些事情可以互相交流一下，所以决定和她交个朋友。回来的时候车里乱烘烘的,后面的一个极度恶心的男人在泡女乘客,竟然有个女孩子天真的上当和他聊所谓的天,那个男人超级贫嘴,一不小心那些文字飞进我的耳朵,这个穿着富贵鸟西服的男人等下车的时候不冻死他,在车上接电话的时候短短两分钟里不忘记调侃的对电话那头说\"\"哎呀,车晚点了,辛苦你拉来接我,想吃什么生猛海鲜,海参鲍鱼随便你点好不好...\"\"妈的,我脑海里迅速闪过的画面是我抽他的样子,可是可怜的女孩子竟然用很崇拜的眼神望着他,他们的聊天我无法继续聆听,麻木的觉得身边里随时出现的怎么好象都是杂志里的情节...那个人跟我一个地方下车,车上那个女孩子竟然一一不舍的送别,我从他们身边经过,面无表情...PS;一个人住在隔音效果比较差的宾馆,那是在衡水来说还算好点的宾馆呢，《衡水迎宾馆》，在凌晨四点钟的时候被一种奇怪的声音吵醒,是隔壁在干坏事,从来没有机会看现实的两个人一起是什么样子,可是却由于总是出门住廉价旅馆的原因,经常可以遇见很多露水鸳鸯,也会偶尔\"\"聆听\"\"各种奇怪的声音,而这个女人的声音好奇怪,没听过...哈哈..胡言乱语了,我不是有什么特别嗜好,只是什么事情都喜欢分析一下而已...\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1162', '2000', '\"这几天天气起了变化,好冷...老天爷说变就变,连续两天出门的时候不管穿多少似乎都感觉不到彻底的温暖,严重点说甚至手都冻的红了起来,明天,又要一个人出门了,要去衡水培训了，不知道为什么,感觉自己有点自虐的倾向,喜欢很冷很冷的天,似乎好的天气里发生的事情一直记得不清楚,可是只要遇见坏天气,什么东西发生都有意义,日后回忆起来也有滋有味...再那的两天挺好的认识了几个大哥和一个小女孩，那个女孩挺可爱的，听课的时候她当时坐在我的对过，时不时的还听着mp3下课了还给我介绍了她的南朋友，挺潇洒的。她还说让她男朋友改日请我吃饭呢，因为我们都是作生意的所以都很聊的来有些事情可以互相交流一下，所以决定和她交个朋友。回来的时候车里乱烘烘的,后面的一个极度恶心的男人在泡女乘客,竟然有个女孩子天真的上当和他聊所谓的天,那个男人超级贫嘴,一不小心那些文字飞进我的耳朵,这个穿着富贵鸟西服的男人等下车的时候不冻死他,在车上接电话的时候短短两分钟里不忘记调侃的对电话那头说\"\"哎呀,车晚点了,辛苦你拉来接我,想吃什么生猛海鲜,海参鲍鱼随便你点好不好...\"\"妈的,我脑海里迅速闪过的画面是我抽他的样子,可是可怜的女孩子竟然用很崇拜的眼神望着他,他们的聊天我无法继续聆听,麻木的觉得身边里随时出现的怎么好象都是杂志里的情节...那个人跟我一个地方下车,车上那个女孩子竟然一一不舍的送别,我从他们身边经过,面无表情...ps;一个人住在隔音效果比较差的宾馆,那是在衡水来说还算好点的宾馆呢，《衡水迎宾馆》，在凌晨四点钟的时候被一种奇怪的声音吵醒,是隔壁在干坏事,从来没有机会看现实的两个人一起是什么样子,可是却由于总是出门住廉价旅馆的原因,经常可以遇见很多露水鸳鸯,也会偶尔\"\"聆听\"\"各种奇怪的声音,而这个女人的声音好奇怪,没听过...哈哈..胡言乱语了,我不是有什么特别嗜好,只是什么事情都喜欢分析一下而已...\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1163', '2000', '只剩下钢琴陪我谈了一天睡着的大提琴安静的旧旧的我想你已表现的非常明白我懂我也知道你没有舍不得你说你也会难过我不相信牵着你陪着我也只是曾经希望他是真的比我还要爱你我才会逼自己离开你要我说多难堪我根本不想分开为什么还要我用微笑来带过我没有这种天份包容你也接受他不用担心的太多我会一直好好过你已经远远离开我也会慢慢走开为什么我连分开都迁就着你我真的没有天份安静的没这么快我会学着放弃你是因为我太爱你....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1164', '2000', '心情咘恏.。為甚嬤沃那嬤鍾鱤鯖.?剛進校時沃4\'哆嬤開心..魜活著悳莓一天,咘是為叻悲傷.無論面對甚嬤様惪困難都需要愉筷悳面對....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1165', '2000', '今天是星期六，姐姐下午也要回安阳了，中午我们一起来到比胜客吃第二次比萨，说实话，来过一次，是真的不想再来第二次了；这里的东西又贵又吃不饱，不过安安吵着来，那肯定是来了；昨天给利民爸通了电话，得知现在病情好转了，真是高兴，他那么健康的一个老人要是生病了，老天也太不公了吧！看到利民爸生病全家人都那么关心，再想想我家的气氛，我很伤感，真不不想出生在我家的种环境里；没有情感，没有生机；我还是那句话，要是我没有得病就好了，现在我过的很辛苦，病魔的折磨也不知道什么时候可以摆脱掉；我又是个不坚强的女孩儿，每天都要把死想的不下三次，我知道这不是个好事。也不知道再过几天建敏来不来陪我。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1166', '2000', '恩.又上课了,除了与老师在对话外,下课只能望着植物园发呆了.天空真的很蓝,尽管没有紫色来得悲哀,但是也带着一丝忧愁.该离开的也都离开了,终于只剩下自己了.镜子前只看到麻木与呆滞的我,尽管此刻没有任何人在身边嘲笑我,心中只有懦弱与胆怯,总有一种哭泣的冲动.都离开了,什么时候我也能离开这块混沌的大地?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1167', '2000', '恩,下午郁闷要考试.估计是不及格,看到其他同学脸上的笑容,很不是滋味.下一周又该如何开始?一样循环着做这周的事情,然后连成绩都一直在循环...?听秘密花园的歌时,不觉落泪了,心情开朗了许多.期待末日的晴天', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1168', '2000', '放假就是不好阿.!!好无聊,.没有人陪我..好郁闷哇.刚刚在QQ上留言给大炮了..从今以后我门只是朋友，.心中有一种苦苦的感觉.眼泪似乎要掉了.但是我不会让它流出来..我学会了坚强.人长大面对的事情都很现实..所以我必须恢复过来.不会再停留在原来的圆点上.可是泪水和我的心不一致阿.!泪水不完全代表我难过.也代表我曾经拥有过我真正的幸福,至少我认为.尽管他不喜欢我.但是我还是满足了.我很谢谢他曾经带给我烦恼和快乐.是他使我比以前懂事了/是他让我懂得了社会是现实的.是残酷的.不是我所想象的。.想起以前.在我心里虽然是苦的.但是我又觉得甜甜的..今天我终于冲破自己这一关.把手放开.把爱放开,,,,,,', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1169', '2000', '[COLOR=#8B0000][/COLOR]今天是我的生日`我应该是开心的`是快乐的`哎!!!可是不知道自己是不是会开心的起来`17岁的今天我为自己许下一个愿望`希望有一天自己会穿上很多别人都没有的新衣服`特别好看``自己会有很多钱`有买不完衣服的钱`!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1170', '2000', '本来想给你留言!但就是找不到你滴本本!/`我看怛你滴留言本!就晓得你最近肯定不好!/.你在里面写到你和几分了!?..你又同时喜欢上两个人!/\\?你裹段时间到底吗里怛啊?我晓得你最近肯定有烦恼的事!我也不在你身边.不可以随时来安慰你!你有吗事想和我谈心滴话.//你可以在我本本里(悄悄话)或是qq上给我留言!/我回切就打电话给你咯.到时候你在细细滴和我广!/看我可不可以帮你想想主义?//!..　你不晓得我在裹边有时候一个人待着滴时候!　有好想你!我总是想起我论以前在一起耍裹时候!~和我林以前滴一些事/有时候想起我都哭起来怛!记得给我留言甲!想你滴好姐妹05.10.30[/color][/color][/color][/face][/face][/face][/face][/face][/size]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1171', '2000', '铁铁哇.!~好想你勒.坐在网吧.看乐你的留言./眼泪又流出来乐.沃好高兴有你这个铁铁.不亏是10年的友谊阿.!~有时也好想你阿..每次沃难过.烦的时候都4;你在沃身边安慰我.真的.!我也不知道该怎样说乐.\'沃会听你的话.不会总4;哭乐.沃会坚强.你在那边怎么样勒.?你老公欺负你没.?不管以后发生什么事.我门永远4/好姊妹.!好波.?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1172', '2000', '这两天天一直是阴阴的，我的关节很痛，一点力都用不上，上床上整躺了一天了，吃了两片强的松和扶他林，还是不太好，还是痛啊！我自己一个人孤单的躺在大床上开着音乐听，听到我是一只小小鸟时，我哭了，今天又好几次想到了死，不知道为什么，每次想到死时我都会落泪，可能是我太不想离开这个精彩的世界了吧。不过总感觉世界再精彩它已经不属于我了，好陌生，我总是融不到里面。我明天想去人民医院疼痛科看看有什么办法止痛没有，只要是不痛就好了，我就可以快乐的生活下去。昨天晚上在网上见到了利民，很高兴！我知道以后不会再经常见到他或者接到他的电话的，谁让自己爱上一个不爱自己的人呢？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1173', '2000', '哎，真是太出乎意料了，数学竟然会那么差，真的，是我怎么也没想到的，而且，科学也是不好，这样，就和别人差开一大截了，开始，我真的好难过，但想想，既然考好了，也没什么用了，再伤心，只会影响以后，可是我能这么想，但是我爸爸妈妈呢，他们知道了会怎么样，肯定很失望。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1174', '2000', '哎，真是太出乎意料了，数学竟然会那么差，真的，是我怎么也没想到的，而且，科学也是不好，这样，就和别人差开一大截了，开始，我真的好难过，但想想，既然考好了，也没什么用了，再伤心，只会影响以后，可是我能这么想，但是我爸爸妈妈呢，他们知道了会怎么样，肯定很失望。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1175', '2000', '\"我是九日，欢迎欣赏我的日记。_2005-10-30星期日天气:生活的点滴心情:生命的价值小中大一下子郁闷得要死.刚刚写好的东西,就在我一按下提交的瞬间不见了.平时都有选保存下来的习惯,偏偏今天就忘了.心烦.这几天的生活,总是让人忙碌得忘记时间的流走.每天不想上网,每天都不进日记本.也写不下支字片语.也许是因为日子过得平淡如水,也许.是因为有了太多的感触.所以,无法表达什么.是啊,有了太多情绪的时候,是无法描述什么的.。。我的生活一直很简单:工作.上网.吃饭.睡觉.还想养狗.我做这些事,然后在所有剩下的空间里发呆和想念..我是爱生活的,所以我无法不去享受它,但如果只享受它而不去努力是不可以的.所以一直都在感慨自己成熟的太晚,长大的太慢,很长一段时间内始终对自己持着怀疑..我的生活,也许会再改变.也许就这样一直下去..其实我一直在等待什么..我们一起养只小狗;每天早晨醒来的时候在你的怀里;可以一起在长满叶子的树林里散步;可以对着你说些傻傻的话;不管什么时候转身,总是可以握到你的手..但也许因为想像的太多,真的等到了你,是不是真的可以等到那个让自己满意的答案..所以想想,等待也蛮好的.至少还是快乐的.有很多朋友问我为什么你的生活会是这样，，，，，，，，，，？？？？我有很多理想就是要努力挣钱.钱这个东西,不能少得来让我们整日为生计发愁,最好也不能多得来需要别的人帮着花..我对我的她有好多要求，请给我关爱、信任、尊重和自由..我有好多渴望就是加强锻炼,强健身体,好在我们共同返家的夜晚,一口气抱你上到五楼的家门,我渴望每天都能做你的新郎..《。。。。》请善待我的家人,一如对你自己的亲人..我有好多梦想至少每天对我说三次\"\"我爱你\'.!在清晨醒来时、下班回家时、晚上钻进被窝时..在我心情遭透,蛮横发脾气的时候..老婆.请拥吻我,而不是和我理论..永远不要对我有破口大骂的样子我还有最后一个要求请在你有，，，空，，，的时候,为我做一顿香喷喷的饭菜,并在桌子那端深情款款地把我凝望..\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1176', '2000', '\"一下子郁闷得要死.刚刚写好的东西,就在我一按下提交的瞬间不见了.平时都有选保存下来的习惯,偏偏今天就忘了.心烦.这几天的生活,总是让人忙碌得忘记时间的流走.每天不想上网,每天都不进日记本.也写不下支字片语.也许是因为日子过得平淡如水,也许.是因为有了太多的感触.所以,无法表达什么.是啊,有了太多情绪的时候,是无法描述什么的.。。我的生活一直很简单:工作.上网.吃饭.睡觉.还想养狗.我做这些事,然后在所有剩下的空间里发呆和想念..我是爱生活的,所以我无法不去享受它,但如果只享受它而不去努力是不可以的.所以一直都在感慨自己成熟的太晚,长大的太慢,很长一段时间内始终对自己持着怀疑..我的生活,也许会再改变.也许就这样一直下去..其实我一直在等待什么..我们一起养只小狗;每天早晨醒来的时候在你的怀里;可以一起在长满叶子的树林里散步;可以对着你说些傻傻的话;不管什么时候转身,总是可以握到你的手..但也许因为想像的太多,真的等到了你,是不是真的可以等到那个让自己满意的答案..所以想想,等待也蛮好的.至少还是快乐的.有很多朋友问我为什么你的生活会是这样，，，，，，，，，，？？？？我有很多理想就是要努力挣钱.钱这个东西,不能少得来让我们整日为生计发愁,最好也不能多得来需要别的人帮着花..我对我的她有好多要求，请给我关爱、信任、尊重和自由..我有好多渴望就是加强锻炼,强健身体,好在我们共同返家的夜晚,一口气抱你上到五楼的家门,我渴望每天都能做你的新郎..《。。。。》请善待我的家人,一如对你自己的亲人..我有好多梦想至少每天对我说三次\"\"我爱你\'.!在清晨醒来时、下班回家时、晚上钻进被窝时..在我心情遭透,蛮横发脾气的时候..老婆.请拥吻我,而不是和我理论..永远不要对我有破口大骂的样子我还有最后一个要求请在你有，，，空，，，的时候,为我做一顿香喷喷的饭菜,并在桌子那端深情款款地把我凝望..\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1177', '2000', '下午的体育课,跑到学校外去了,想去买一本书.走在路上,有点温暖,又有点冷涩.回学校时,手是空着的,边抱怨着出版商的不负责任,边想着晚上那堆高筑的作业如何完成.抬头看天空,很蓝,点缀着这片天空的是几条飞机云,于是轻轻地哼着鸟之诗.一个人孤独的感觉一开始很奇特,喜欢了后却是乏味与干涩.坐在亭子旁边,龙舟池面反射着一丝阳光的温暖,坐着发呆.校门前,看到了一只可怜的猫咪,金黄中混杂着几屡棕色的毛,在肆虐的秋风中发抖着.我看了很久,有种抱它回家的冲动,有只猫陪着我,起码也会高兴点吧....但是我没有,放学时有些后悔,但是猫已经不知去向了.我发现我又白痴地失去了一个应该珍惜的同伴', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1178', '2000', '老公。你爱不爱我啊！我觉得我好幸福啊！可以拥有你是我一辈子最开心的事！我好爱你。你知道吗？我希望可以永远和你在一起。你呢？是不是也和我一样啊？你一定要好好爱我哦！不然当心我会跑掉啊！呵呵！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1179', '2000', '他今天在运动会上破记录了，呵呵，好厉害哦，不过，是不是因为我在终点的缘故呢（别臭美了）虽然他是取得了好成绩，但是我呢，参加跳远，却怎么跳也不知道，哎，真是丢脸啊！回到家，想起昨天的事，真的是伤心啊！！！我这几天真是倒了八辈子的霉，昨天，哎，和他的事看来又被老师知道了，虽然他没多说我什么，但我觉得他已经知道了我和g的事，老天干吗这么对我呢？？？老师起草了一份只天，让他吵了一遍，但他后来什么也没说，那，真的那就代表了他对我说的话吗？？我好疑惑，我和他，现在，究竟算什么呢？？好郁闷啊！！他究竟把我当成了什么？？看见他在比赛，却不能为他加油，虽然他或许不需要我的加油，但，那种感觉真的好难受，他取得了好成绩，也不能祝贺，这个世界啊，怎么这样，好累啊！！我觉得没了他，就好空虚，回到家，因为一天的不联系，又好想见他，我也是一个比较保守的女孩，但对于和他的感情，我总希望，如果分手，我也要他给我个拥抱，但，我能说出口吗，何况，他会答应吗？？而且，我们现在算什么呢，真的好想知道答案，如果他还把我大拿感女朋友，那我也能安心学习了！可是，我不知道答案是什么？？！！生活中有太多的无奈!1文字各位，是不是觉得我们的爱情好幼稚，好可笑》》', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1180', '2000', '有人说，只有翅膀不能飞翔的鸟是悲哀的。有人说，虽然不能飞翔，依然拥有翅膀，那就是飞过的回忆。我们都应该有一双翅膀，都曾经飞过，只是暂时遗忘了，尘封在混杂的现实中。选择走上同人的这条路，我并不后悔，也不觉得就是一种耻辱。个人的理想不同，我们不能强求别人做什么，但是可以坚持自己的王道。曾经说过，即使周围一片黑暗，也要秉持着火光摇曳的蜡烛继续前进，尽管我不确定自己是否能够有力量照亮整个世界，但是可以温暖自己的心。星星之火，可以燎原，这是木叶标志的象征，忘不了最难过孤独的日子是火影陪着自己度过的，鸣人执着的精神，虽然没有燃起我满怀的斗志，但至少没有让心中的火光熄灭，等待复燃的那天，张开翅膀，找回曾经熟悉的感觉，天还是和从前一样蓝，一样高，风也亦然，但不同却是心境。回忆着自己从懂事那天在这个城市留下的片断，熟悉却又陌生，就要离开，我还会再回来么？即使这么问了，风还是笑着不回答，顺其自然，冥冥之中一切自由主宰。相遇，错过，离开，始终没有交集，还是擦身而过，即使是从前亲密无间的人也不再思念。偶尔的想起，那是回忆，思念是希望继续把这种回忆在将来实现，但我却认为足够，也许我们不能要求太多，有过便是幸福，HoToNi？天地玄武，没有个人太多亲密的成分，却是纯洁，不带杂质的清新气息。笑，或许八叶都是互补的，两种截然不同处世风格的人相遇的时候也会擦出惊奇的火花，不是什么惊天动地，却也灿烂。如果要回答永泉为什么总是流泪，我想，藏在背后的不止是善感，而是用泪水来填补泰明生来干涸的内心世界，两个人无声地站在同一个地方，望着同一棵连理也不失为美好的景致。永泉的笛声，似乎在寻找着知音，那是他的心情，无论吹奏数次，泰明都会倾听，不厌其烦。轻水芙蓉，天然修饰。我想不单纯是说永泉，亦或是泰明，而是他们之间之中淡淡若水的感情。怜悯？同是天涯沦落人的共鸣？也许冥冥中的注定，天地玄武就是相互弥补彼此受伤的心灵。从永泉唯唯诺诺地用敬语称呼着泰明，一直到两个人明白了相互之间的默契共同对敌，其中的过程确实惟妙惟肖。第一因为次八弦琴相遇，泰明的实力让永泉产生了敬畏之心，而永泉不同于自己的方式化解了怨灵，似乎也在泰明的内心中激荡起小小的涟漪，我想，是应该有的，从他的神奇可以看出，在光辉的照耀下，表情已经不是那么冰冷。不讨厌神子，不是她的话，八叶不可能聚在一起，更加没有天地玄武的成长，他们只是樱花树下擦肩而过的陌路，即使在别人眼中看似王道，也不会因此去了解对方的心情，真正的心意。啊叻，明天又是第二次月考了，那数学，那物理，我无力哎。下定不少决心要冲上去，我果然还是缺了点什么东西。－－前几天在论坛被人预言在现实很废材。哈？说来也是啊，胸无大志，就喜欢望天，满足现状，这样也是罪过么？了解了太多名利之后的烦恼，但人应该活在什么境界是可以选择的。不积极不代表放弃生活，没有大的目标不代表就不期待明天。同样期待日出日落，这是自然的往复规律，只能说有的人在这段时间内做了很多事情，有的人却一直以和平的心境度过着。我应该属于后者，要想随时保持流水一般细致和平静的心情却是很难，生活的琐事总会引发我们躁动的神经，选择漠视，也许对自己也是一种好处。既然有记忆，既然有能力，为什么不展翅翱翔在天空中？不期待飞到天的另一端，想要拥有的也只是曾经熟悉的感觉。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1181', '2000', '今天让佳去问了他我想知道答案的那两个问题，结果，我还是很开心，呵呵他说那天老师让他写的并不是他要对我说的话，而且我和他的关系一直没变，其实我知道什么关系，可我还是想问他究竟什么关系，但他呢，早猜到我会问的，结果硬是不回答，呵呵这说明他还是挺了解我的啊！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1182', '2000', '今天他又比赛，这次是跳远，结果，他虽然跳的很远，但是老是摔倒在沙坑，可毕竟不是一个班的，我又能怎么样，只能在那里干着急，心疼的要命！哎，好无奈我想我们班有好成绩，但是，我真的不愿意看到他受伤，那时候，我的心就揪的好紧》上次看大他打篮球时摔到，真是难受死了，担心的要命，也顾不了老师在不在了，就到他身边了（不过今天也问了一下他）其实我胆子还是挺大的，哎~~~许真的好奇怪啊，她怎么比我还紧张g呢，还看见她在擦眼睛，我觉得她好象难过的要命，可是我怎么没有？？？而且今天他们在比篮球的时候，她好象特别关注g，这真是~~~哎，不知道该怎么说，大概是我多虑了。毕竟她是我好朋友，我这么想或许真的是自己的错~`总而言之，言而总之，就是我希望你——g不要在受伤了，不要让我总担心，不要让我总心痛！1', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1183', '2000', '真是想不到啊，怎么那么多人喜欢他啊，不公平啊！！怪不得啊，他总是那么骄傲，哎，我是不好过了。陈竟然还真是说真话啊，在我面前说喜欢他，想不到啊，不过我没生气啊，我现在可不是小心眼的女生啊，积极染那么多人喜欢他，那就代表了他优秀啊，那，我也不是很光荣吗，呵呵', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1184', '2000', '越多的人喜欢他，就说明他越优秀，那可是件大好事啊，不过，对我来说，就也有不好的了，情敌太多了。如果我能牢牢抓住他的心，那我也算是成功人事了啊，呵呵', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1185', '2000', '其实，我也不用担心什么，可我还是老不相信他，现在想想，那其实也是在贬低自己啊，不相信自己能牵住他，只要他是我手中的风筝，只要线还在我手中，那也没什么好担心的啊。我要让人看到，他喜欢的是我不是她们，她们才没机会呢！！不过呢，话说回来，如果他要是看上了哪个，我也没办法的，毕竟感情这个东东是不能勉强的，我也尽力就好了！但我现在就希望他能答应我，要好好对我，如果不喜欢我了，也要马上告诉我！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1186', '2000', '今天关节不是很痛，所以心情也好了很多，要是关节不痛，我会更加自信的。每天有个好心情也会对病好些的，学会爱自己！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1187', '2000', '我就这么不合格吗？为什么你从来就不把我放在你的心上呢？就连打电话多说两句你都有点嫌烦。是不是和你在一起久了你就嫌弃我了？你跟我在一起到底是为了什么？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1188', '2000', '宝宝，你好可爱啊。呵呵！“妈妈”爱死你了！好想你啊！你在家做什么呢？是不是又在到处大小便啊！被“妈妈”发现我会“打”屁屁的哦！“妈妈”回来陪你啦！等我啊！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1189', '2000', '张竟然会说男人都喜欢漂亮的女人，但他自己不是，什么逻辑嘛！可是张g是见了漂亮女生就爱的那种人，我才不相信呢！！因为我长的也不怎么样啊，而且g自己也说了，我在他眼里也仅仅知识一般而已啊，那他干吗还会喜欢我呢，所以呢，张说的话是不正确的。不过说实话，我真的有时候会很担心g喜欢别人，也就是说我没有安感，要说这是g的缘故吧，那也有道理，毕竟那是要男生给的，要让女生觉得有安全的感觉，但话说回来吧，其实这种感觉有一部分还是来自于自己给的，你相信自己能抓住他的心，你也相信他爱自己，不会喜欢其他人，那，这种感觉不也有了吗？所以，我觉得要让我有安全感，那是要靠我和他共同努力的。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1190', '2000', '张那个死家伙，竟然对我说只有你对他说你爱他了，那样才会得到真爱，什么东西吗，真是的。我和他之间，应该说是我，还用的着对他说这些呢，他喜欢听也就算了，但如果不喜欢，那我不是不好过了吗？不过，如果他能对我说那到是很好的事哦！不过他才不会呢？·张还说我是他的老婆，我到是真想让他这么称呼我一下，可是，凭他的个性，能说出这个才怪呢我真的挺羡慕下面班级的那对，真幸福啊，在学校还手拉手的，哎，找不到第2对了啊！不过我和他是不可能的哦我真的好盼望他能这么叫我一次，哪怕仅仅这么一次也好啊，如果不说，那他有想过把我和这个词语联系在一起吗，哎~~应该没有吧！算了，反正，跟着他，也就这样了，对于这些啊，我还是不报幻想好了，反正也不能实现的，谁让我这么喜欢他，爱他呢？！我只要天天见到你就好了！g，我真的真的好爱你！你知道吗？你呢，你还是那么爱我吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1191', '2000', '偶在想,也许这个世界上有很多相爱的,很恩爱,不会腻,永远都是这样,从认识,到现在,依然不会变,不管身边有什么样的事物在变,在怎么样,只要是⒉个人的心彼此永远这样的连在一起,相信爱可以去战胜⒈切,我相信是这样,一定会,所以我想,我一定会这样,只要是能对你好的,我能做的,我一定做,在偶的心里你是我最爱,最重视的,没有哪个可以在我的心里取代你,想你的时候,我觉的真的好快乐.好幸福,你是我⒈生中的爱,简简单单的爱,不让我们觉的累,不让我们之间有负担,我相信就象我今天看见的⒈对相爱的夫妻一样,我看了都觉的他们会幸福,甜的不腻,这样的相爱,在边上的人看见了,真的感觉很好!猪,我的日记是写给你看的,是让你晓得我每的想法,和我看见的事情,写出来的.看了我的日记你要每⒈片都要写下你的想法,就算是几个字,我也能明白知道不????', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1192', '2000', '自利民走了后，我的情绪很不稳定，常常感觉孤单、心好像被掏空了的感觉，他好像就是我的天，我的太阳；现在没有了他，好像是天塌了，没有了光明一样，干什么事情都无精打采！其实我说是想家，还不如说是想他。我回忆一下好像自从认识他之后，就离不开他了，以前是这样的，现在都过了十年了，怎么还是这样的。我很可悲，因为我找了一个不爱我的人，我是那么的爱他，以至于一天都少不了他；要是我遇到一个这么爱我的人我一定会把握好的。我知道自己应该自力，因为自己学习不好，家里的环境，加上后来又生病；让我变的越来越不自信了，很自卑；怎么才能摆脱掉呢？我好想自信起来。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1193', '2000', '自从班主任知道了那事后，我们几乎没联系过，除了在运动会上说了几句话以外，有时候早上希望和你说几句话，可是，你要训练篮球，哎~`', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1194', '2000', '既然那些话不是你想对我说的，那难道我们就这样下去，成为陌路人吗？我不甘心这样的，如果那真的饿不是你想对我说的话，那，你想对我说什么呢，总得告诉我你打算怎么办吧？！现在要联系是不可能的，但是我只想知道你的一个答复，给我指明一下方向，你知不知道，现在的我，毫无目的，真的饿不知道该怎么办，不知道下一步该怎么走！虽然还是能天天看到你，但是，每当听佳说起你们在一个班那么快乐的时候，我话，而我，却连你的声音都听不到？为什么我不能那样和你一起快乐？老天真的好不公[[可是我也清楚，那中想法并不是因为吃醋！我真的好想知道，我们该怎么办？！！！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1195', '2000', '每天都要保持有个好的心态，我些天关节不是太痛了，我很开心，不过那个安安真的很让人讨厌，我一点都不喜欢他，平时每天接他，还给他买东西吃，但是他真的不懂事，真烦，真烦！！我要是有了孩子一定比他强！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1197', '2000', '每天我都在想,为什么我会在没有事的时候,心里总是有觉的烦,郁闷,这3个字出现,是因为我每天都在想你,没有你在我的身边才这样的吧,每天都会发短信,但是我明白了短信又不能怎样,只想能看见你,真的好想你,我们彼此都是这样,哎..心里只是想,只是希望时间快点过,能让我快点看到你,不在克想.发短信而看不见你,我每天都在问我身边的朋友,她们都是这样告诉我,要我不去想,我做不到.因为太爱,彼此太.....不可以控制自己的感情,无聊的时候就会看看我保存下来的短信,心里觉的好甜,在床上睡觉的时候.睡不着,就会想想在一起的那⒈切,心里只是在想,好想见到你,好久没有看见你了!呜呜....时间就是过的慢.!宝贝\'想恋你!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1198', '2000', '我不知道该怎么说了。.!刚刚看到老虎留言给我.说他在他老婆家里.我看了觉得好气的。好酸的..那个家伙./去死吧.!我可能有点病吧...这关我什么事阿.?.我吃什么飞醋.?.上星期留言给他说喜欢他.他没看到.我以为他不接受我.所以就和鬼鬼在一起了.但是在一起之后才知道老虎没看到我的留言说实话.!~我喜欢的人是老虎/.但是我又阴差阳错的和鬼鬼在一起了.这是上天安排的吗，.?是我门之间根本有源无份吧,.!现在我也不会想太多了.一心和鬼鬼在一起吧,.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1199', '2000', '或许我真的是太爱钻牛角尖了，艳说我问的问题会伤害他，真的吗？如果是事实，我现在能说的只是对不起，g，对不起，我真的不是有意要伤害你，那是因为我爱你，而我的天性又是那么的好奇，我想你亲口说你是我女朋友，可是，我真的没想到或许这对你会有伤害。对不起，对不起！我知道你会原谅我的，对吗？你还是喜欢我的，爱我的，疼我的，对吗？只是你平时不说，不表现出来而已，对吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1200', '2000', 'G，记得你曾经对我说过，人不可以太完美，太完美了就觉得空虚，那时候我根本不明白什么意思，你说的饿话，总是让我琢磨不透，或许我还是太幼稚了吧！你在别的人面前也是那么开朗的，可是，在我面前好象就不是了，那些话，总是浓的我很糊涂，我真的很笨的。可是说你说的话我不明白，你却告诉我说那是因为这是你经过深思熟虑，如果不这样，那就说明了对这个不重视，就是对我不重视。呵呵，那时候真的是拿你没办法，你总是让我那么无奈，我会生气，也总是因为你，可是，你还是我最最喜欢的G啊，所以啊，只好由你自己了哦。艳所我对你不够信任，是啊，我自己也知道的，可是，我努力了，但还是不行的，你说过我懂事的，可那以后没多久，我就又任性起来了，和你吵架，真的对不起，我以后会变的，我要做你心目中的好女朋友，你说行吗？相信我啊，G，你的鼓励对我很重要的！我是很不懂事，但我以后会改的，我要相信你，呵呵！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1201', '2000', '昨天同学说去请笔仙了，我也觉得好神奇哦，那个东西，她告诉我说，g是喜欢你的，呵呵，我真的好开心哦，可是，后面一句话就是我不想知道的，她说，但是g还喜欢很多人怎么会这样呢，那时候，我真是气死了，就在心里骂：你这个坏蛋，竟然喜欢好多人！但后来同学又说，他这一生一共会喜欢5个人，一生很漫长啊，说不定现在就喜欢我一个呢，于是，又觉得错骂你了，呵呵，我真的很傻！说实话，我有点相信那个东西的，大概又是我的好奇心作怪吧，算了，既然说过要相信你的，那我就要做到的，我相信你现在就喜欢我一个，呵呵你要对我好！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1202', '2000', '我只会爱我自己，不选择别人。要相信我。OK', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1203', '2000', '我的心情是蛮多的,身边的这⒈切都没有变动,而以后是否会了,我不愿失去,我不愿变动,偶在想我是否真的能取得在你心里的所有位置,能否永远都会这样,看这身边的⒈切又有些害怕!呜...我在想什么哦,我都不晓得自己怎么搞的,也许是过于在乎你,爱你,所以害怕吧.!偶只希望你对我说的每⒈句话,都不要失去,不要消失,偶怕,偶只希望你能记的,不要做让我伤心的事,我相信你也不会让我伤心,你说你爱我,我是你的宝贝,我是............请你要记的,永远永远都是这样,不许变,因为你真的太好,是女人都会很爱你,我明白,所以说有你是我的幸福,是我的珍惜,我别无所求,只想不要失去你,就可以了,!只想给你安静的爱,简简单单的在一起!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1204', '2000', '深秋的黎明--梦初醒的地方。回首与你共同走过的每一个日夜，幸福，快乐，辛酸，泪水。有人说，爱情是杯鸡尾酒，上面是绿色的希望，下面是褐色的惆怅，当你试图摇掉惆怅，同时，也就摇碎了希望。的确，没有惆怅，哪里来的希望？你就是我的鸡尾酒，给了我希望，也给了我惆怅。雨后则是彩虹的渲染，当彩虹挂在天边，那是一种无比的美丽。你我的从前，像是雨季的蔓延。雨季终归过去，我相信，你我未来的天空将充满彩虹般的温馨与幸福。初见的那天，你站在巷口......我们有过欢笑，泪水，辛酸，苦涩。那不快乐的九个月，落叶陪我散步，雪花听我倾诉。我的世界只有失落与无助。Y,谢谢你给了我那段不堪回首的日子，让我真真切切的明白了该怎样经营自己的爱情。如今，是命运与缘分，让我们再次相遇。这些年，经历了无数的风风雨雨，我们慢慢的走向成熟，彼此更加珍惜这段不易的感情，更加珍惜对方。不久，金色的黎明，白色的婚纱将伴我挽着你走在铺满红色地毯的人生路上，踏往爱情的旅途。今生与你同在，来世仍做你的新娘！Foreverloveyou:X2004.11.1001：10', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1205', '2000', '偶每认识⒈个人,就会觉的有总不怎么好的感觉,是因为⒉个人认得了,在一起时间长了,每个人都会说起家里的事,我不愿意,因为有些讲了,他也不会明白,因为他不懂的怎样去体会这样的家,我心里的感受,心里受的伤和恨谁也不可以感受的到滴!我有这么久没有回家,我也天天没有事的时候,偶而会想想以前和现在⒈切都变勒,他变了是另外⒈个人,他变的甚至在家里面只把我当做⒈个外人看待,不象从前有什么都会讲,不象从前那样的关心我,在家里没有原来我和妈妈,还有他在一起那样的感觉,我恨他背叛了我妈妈,也背叛了对我从前的爱,他现在不知道错,说是我的错,我⒈个做女儿从那里来的错,我妈妈又那里来的错,是他背叛的我妈妈,背叛了我,背叛了我对他原来的爱,变成的恨,他不晓得醒悟,永远沉睡在哪个女人的身上,和他没有能回到园地的位置,每次没有讲到⒉句话,就会吵的好大好大,又是因为什么,原来都不是这样,他把我当仇人看一样的,我又为何不会勒.这⒈切的⒈切,都是因为他背叛,因为他变了另外⒈个人,⒈个我不认识的人!⒈个我永远也不值得的去想起的人,我只记的他是怎样的怪我妈妈,自己背叛了我们,我为什么不帮他讲话,为我妈妈讲话这又是为什么,都是因为他的无情,他的那付我永远不会忘记的表情,他怎么骂我妈妈的,他也骂的出口,⒈见我妈妈就骂是为什么骂,我是真的搞不懂他,他还恨我妈妈,怎么会有这样的人,我妈妈什么都没做,他要离分离了,还有什么不满意的,有没有问过我是否还是爱我妈妈，反而还对我讲,不要认我妈妈,我真的是不晓得他对我讲些什么,⒈点也不去想想是他的错,对我妈妈那样,还要我那样,做的出,我是看透了他,这⒈辈子我也不会忘记他对我讲的话,是那样的没有.................世界就从去年而变,从那⒈刻起我的世界没有了他,将是永远的没有,偶只有我妈妈⒈个我会好好爱妈妈,一起这样做起把他看.我也渐渐张大,懂事了好多,我失去了父爱,可我懂的去珍惜我的爱,是我爱的,我不会错过,我会好好珍惜,那怕未来会怎样,我只明白,我曾经没有做错,我爱过,珍惜过,谁也没有辜负谁就可以勒!偶现在也很快乐,很幸福,有爱我的人爱我.我心满意足勒!不求付出,只求自己做的⒈切是值得的,不后悔的就可以了,就很满意了!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1206', '2000', '呵呵..在车上一句话都不说得车夫.可笑..明知道车车在害我!呵呵..早知道上去冲撞几句.也许.事情就不会那么复杂了..最败就是没去顶撞!..妈得.有那么自私得老爸就有那么自私得女儿.一点余地都不给人留!贱了!.呵呵..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1207', '2000', '呼..薇薇⒈开始就那么相信.但是似乎.自己也好象从来没有伤害过她.甚至连那种想法都没有...妈得.到头来.搞得我跟微微似乎都跟勺子样得.被车车那个疯子.耍得团团转.该不该报复?...纳闷.应该不去计较么?她得父亲.?呵呵..一点人情味都没有!自私...比他女儿更严重.!有其父必有其女.呵呵..无奈了...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1208', '2000', '呼..被人一顿陷害侮辱.纳闷..从头到尾.都没人能理解自己得好意.虽然自己犯错..但是没人能够原谅.没人能够相信..好心被雷劈..郁闷..薇薇得信任.呵呵..善良得薇薇..不过还好没害过她.也没有害她得想法..总算对得起自己的良心..呵呵.善良得薇薇..呼..车车?妈得..疯!已经无奈了.也许那种人..我没必要去理俞.也没必要去在乎.也懒得去陷害她了..她以后自己会尝到苦头了..钱...也许并不是那么重要..!最主要.是朋友.现在才知道能够得到朋友得信任.是一件很幸福得事.很应该去珍惜..呵呵..谢谢咯!薇薇..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1209', '2000', '今天我没去上学..理由是不舒服..我喉咙是很沙哑.但没到需要请假的地步..而且喉咙再怎么不舒服也不影响我听课..我只是给自己一个偷懒的理由罢了..这个星期..很烦..首先..我发现我的同桌..原来是那么没风度..这听起来是多么可笑..他有没风度似乎不是我管的事..但我确实很讨厌这样的男生..本来我还对他蛮有好感..但现在不了..我有时连话都懒得跟他说..一开始以为他是个很上进的人..而且他有时候是很可爱..但他把一写东西分得太清楚了.而且说话做事一点也不顾别人的感受..我超郁闷.!!昨天是林建睿生日..他们原来班上的同学买了蛋糕为他庆祝..他很感动..看得出来..我也买了蛋糕给他..不过今天才给的..虽然是迟来的礼物.他大概不介意吧..我是蛮喜欢他这个朋友的..虽然他有着与他本身..很不符合的..成熟与..伤感..生日快乐.!这个星期还有一件事很令我高兴..那就是高考方案出来了..虽然不是理想的.但比我想象中的要好一点..我终于中到了方向了..昨天李明航请我吃饭..他是遵守他的诺言而已..呵呵..他是一个很好聊的朋友..我有点好奇....我在他心中..到底是什么位置.?我并不是喜欢他啊..只是好奇.他是把我当普通朋友.还是好朋友,..或者只是一个聊天的朋友..其实不用分得那么清楚的..再清楚又如何呢?都只是生命的过客..我希望自己..不要让虚伪与我挂钩..那样...我会看不起自己..有时候..不想说些虚假的话..就用沉默来代替吧....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1210', '2000', '亲爱的姐妹，我要告诉你的话，这些都来自我心。你必须找到除了爱情之外，能够使你用双脚坚强站在大地上的东西。你要找到谋生的方式。现在考虑不晚了。我从来不以为学历有什么重要，天才都不是科班，但，不是科班，连龙套都跑不了。你必须把那些浮如飘絮的思绪，渐渐转化为清晰的思路和简单的文字。华丽和漂浮都不易长久。你要知道，给予文字阅读快感不够的，内容，思想，境界，灵魂，精神和智慧，这些才重要。不要多看那些和你一个路数的女作家的文字。不要琐碎，无病呻吟。不要想到什么就写。不要流于小感伤和小感动。妹妹，我要你相信温暖，美好，信任，尊严，坚强这些老掉牙的字眼。我不要你颓废，空虚，迷茫，糟践自己，伤害别人。我不要你把自己处理得一团糟。节制自己的感情。不是任何人都能要。体验生活，是另外一回事，并不意味着堕落和放纵。千万不要认同那些伪装的酷和另类。他们是无事可做的人找出来放任自己无事可做的借口。不是因为在象牙塔中，才说出我爱世界这样的话。是知道外面的黑，脏，丑陋之后，还要说出这样的话。妹妹，好好去爱，去生活。青春如此短暂，不要叹老。偶尔可以停下来休息，但是别蹲下来张望。走了一条路的时候，记得别回头看。时不时问问自己，自己在干吗。伤心和委屈的时候，要嚎啕大哭。哭完洗完脸，拍拍自己的脸，挤出一个微笑给自己看。不要揉，否则第二天早上会眼睛肿。给自己一个远大的前程和目标。记得常常仰望天空。记住仰望天空的时候也看看脚下。任何时候，任何人问你，有过多少次恋爱，答案是两次。一次是他爱我，我不爱他。一次是我爱他，他不爱我。好的爱情永远在下一次。别给同一个男人两次伤害你的机会。别相信床上的誓言。别看重处女，但保持纯洁。不要为欲望羞耻，好好享受，但绝不忍受男人的侮辱和怠慢。相信我，妹妹，男人多的是，比三条腿的青蛙多得多。别轻易说出“爱”。相信你的直觉。不要招惹别人的男人，除非你非常非常爱他，并且，他非常非常值得爱。不要招惹寻找与前女友相似，和他母亲，姐姐相似女人的男人。不要招惹浪子，文艺青年和中年男子。别招惹太清纯的男人。别和没心没肺的人在一起。别把犯*当真爱。一个男人作践自己来取悦你的时候，千万不要因此感动。这个烟头烫在他身上，下一个就可能烫在你身上。看看一个男人的朋友们是什么样的，注意他的朋友们对待女人的态度。还有，千万别相信一个不准备将你介绍给他的朋友圈子的男人。一个男人只肯喊你“宝贝”的时候，坚持要他喊你的名字。一个男人不再来找你的时候，就不要再去找他。不要相信在恋爱上用手段的人。分手时不要口出恶言。吸取教训，但不要后悔。后悔没有用。别干撕照片，烧信，撕日记这样一类三流爱情电视剧中才有人干的事。相信爱情。相信好男人还存在，还未婚，还在茫茫人海中寻觅你。别说“男人没一个好东西”这样使别人误以为你阅人无数的话。答应我，永远不要去做那种午夜背着行李，从一个男朋友家，流落到另一个男朋友家的女人。爱物质，适当地。永远知道精神更重要。比那些名表，名牌，时装，更加美丽的是你自己。别瞧不起劳动人民。不要为劳动羞耻。土地不脏，汗味不难闻。请尊重那些似乎生活状况不如你的人，因为这样才是尊重自己。永远体恤那些生活在底层的人们，因为我们的亲人就是在这些人群中。我们不娇贵。　　　　不要小看一分钱。不妨自己去挣挣看。　　　　被朋友伤害了的时候，别怀疑友情，但提防背叛你的人。原谅，但并不遗忘。做人存几分天真童心，对朋友保持一些侠义之情。要快乐，要开朗，要坚韧，要温暖。这和性格无关。我担心你太低调，有时要强悍一点，被欺负的时候，一定要讨回来！但是不要记恨。小人之见，随他们去好了。怜悯，会使你高贵。要原谅这世界和自己。要告诉自己，我值得拥有最好的一切。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1211', '2000', '我好感动,我有⒈个这么爱我的老公,只怪我自己冒的事情做,天天在都胡思乱想,偶现在不会勒,我会好好过好每⒈天等你回来,有什么样的事情我都会对你讲,不会克冒的事,乱是裹想,我明白了,我不会了.我会做个乖老婆,好好听话!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1212', '2000', '収起妳那漲忝镇嘚笑脸.哵洅哏我嘪挵祢嘚兲稹.]我早圯麻钼叻。..[贱货]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1213', '2000', '郁闷阿.一整个事情到头来原来那么简单....如果早发现那多好阿..原来由凌晨6点半.到晚上⒍半.这⒓个小时原来只是演了一场戏..简单得人.简单得想法..不知道.是我在宽松我自己.还是过于简单得去理解.但是我感觉我想得这一切似乎都很符合要求...呵呵......为了让他女儿和我得距离能够疏远...为了让我以后再也接触不了他得女儿.他用了这个很可靠.很理智.的方法..让我和他女儿之间的感情.变成仇恨..要是我早发现多好.!?从那天晚上⒍点半..开始..一直到33个小时以后我才发现...呵呵...她有一个那么聪明得父亲.呵呵..现在得我是傻还是聪明..呵呵....都怪自己做错得太多!但是,还是很感谢微微对我得信任.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1214', '2000', '这个想法是我自作聪明..还是真的?..不知道!不去想那么多了..呵呵..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1215', '2000', '刚刚看好《梦里花落知多少》，或许长那么大，我从来没那么哭过，至少看一本书我不至于感动成那样，可是，这次，当我在看这本书时，我的感觉那么的复杂，从来没有过，林岚，我觉得她有错，我总感觉陆叙是她害死的。我一直的哭，不知道为什么，我想很多象我一样的女孩看了都会哭的，我相信了那一句话，彻彻底底的相信了，人是会随着经历的事情而改变的，说实话，这段时间，我也很难过，确实，我也变了不少，总觉得有一种莫名的伤感笼罩着我，时常会一个人发呆，我不知道自己什么时候变了，甚至棉队与以前会很生气的事，我也变的平静了，G曾经说过我懂事了，可有时候，我的任性还是会出来。那本书里的太多太多，让我感动，他们的友谊如此的厚实，他们的爱情又那么另我羡慕，可是我还是不渴望经历他们所经历的，虽然曾经那么美好，可是结局呢？是我不想看到的，物是人非，为什么世间总有那么多的无奈，曾经那么快乐的一帮子人，到最后，却是如此的结局，我感叹这世间的不公！有人看了这本书说顾小北很讨厌，可是，我不觉得，他并不好过，不是吗？他也是被欺骗了，也是受害者！我羡慕林岚曾经有那么一个顾小北照顾她，爱她，可是，我呢？我的爱究竟在哪里？知识，我觉得顾小北唯一错的，就是他的百依百顺，连分手也答应的那么干脆，这点，很象G！他不曾想过，只要他摇头，或者由于一下，结局就不会如此了！这个世界有太多的无奈，爱与恨的交织，我们该如何面队，太多的感动，使得我们眼花缭乱，没有方向！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1216', '2000', '～我知道你是看不到我寫的這封信了,因為你已經走了,去了那個和我的世界相隔甚遠的地方,我們是永遠、永遠也不可能重逢了……但是我將永遠記得你永遠懷念你……！那天，親見你在暮色中遠去，我知道我們是永遠也不可能重逢了。我的眼睛在這個干燥的季節因你而濕潤。曾經你是那麼的愛我，那時，我常對很多事情感困惑，在你的啟發下，我逐渐走出了迷惘的世界。你欣賞我、鼓勵我，使我產生了自信，真正的自信！我不再沖動迷惘，不再怨天憂人，我也不再憂傷得無法自拔。我想只要我熱愛生活，生活是不會虧得我的，憂傷會逐渐遠离，快樂和充實會使我邁向成功！我又撥了你的電話，想靜靜地聆聽你的聲音，可我知道我撥通的只是沉默。你已經走了，去了那個和我的世界相隔甚遠的地方，我們是永遠、永遠也不可能重逢了……文字', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1217', '2000', '...你会记得我么？会记很久么？想到我的时候，要开心喔...“我说过你是我心里的一个结，还记得么？唯一解开的方法就是：你能在我们分别之后，继续适应并且开心地生活下去。”他略有感慨地对我说。“我记得。如果解不开，怎么办？我知道做什么都不能挽留你离去的坚决。”忧愁悄悄爬上我的心头。“有点伤感，为你，也为我们曾经有过的回忆，说好永远不见面的，对么？许久后，我们如果还能联系的话，希望彼此过得都好。”他衷心的祝福令我感到很温暖。“嗯，我们大家都要开心，都要幸福。你要走，这是不可能改变的决定；我会怀念，也是你不能阻止的事实。”我的执著你是知道的。“过去的，是回忆；未来的，才是将要面对和把握的现实。”我也知道他是真心的希望我会忘记他。可是，如果我能忘记，我就不再是我。“我明白。只是希望在未来，即使我们不能遇见，也要彼此祝福。”此刻，淡淡地伤感，淡淡地幸福，淡淡地想你。我不敢思念，却又不能控制心一次又一次的背叛。你知道么？我成了矛盾的综合体，你说我应该释怀的，可是我能么？童话不是你和我应该有的结局，那天你说我们还没开始，谈什么未来。我忍着不让自己掉泪，最后，还是没能忍住，心痛得都哭了。不过是隔了一层薄薄的玻璃，却割断了一份真挚的感情。我会记得你，永远记住。只是，在想到我的时候，希望你还会默默地在心里，想起我的名字，还要开心喔。...全世界都不理我的时候，只有你不可以不理我喔...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1218', '2000', '...找到那个你爱的天使，张开翅膀，要守护她一生喔...前些天，看到银沙里的某篇文章，想到关于你，关于我们，关于曾经，突然从心底延升起一种欲哭无泪的冲动，最后，还是用微笑取代了回忆带来的淡淡忧伤。因为，我相信，如果某天，我们一定还会遇见。别否认，别把我当陌生人，别忘记了你当天的承诺，我还记得的，还会永远记住。我把《童话》的mv刻录了下来，在记忆里，在心里，为自己，为那个美丽的梦。忘了有多久，我没再收到过你的只言片字，从前都变成珍贵的回忆，我想把它删除的，可是我不敢，也不能，因为知道，我一定会后悔。留在记忆深处的，不仅仅是我的执著，还有我的那一份期盼。我没有失去你，因为我从来就不曾得到过。呵呵，记住阿蜜的话：一定要开心喔。曾经想，当流星划过时，我会许下愿望，但愿一生幸福，可偏偏，没有遇到过流星，就像没有遇到过你。不会后悔。一点也不。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1219', '2000', '~~早已记不清，从前的我是如何地走进你的心里，你的心被填得满满的，而我却感觉拥挤想要把我逼退在心门之外。我喘息着，呼喊着，你仿佛视而不见。狠狠地，你把我落在了后面，距离将我们拉得越来越远，视线变得越来越模糊。伸出的双手，想要把你抱住，一阵狂风卷起，双手在风中胡乱地打划着，却无力将你握紧。你仿佛在对我笑着，“你以为你很了不起！难道你真的以为没有了你，我就活不下去？”在原本未愈合的伤口上重新又添了一道伤疤，不同的是，这一次竟让我产生了要放弃的念头。他不知道，这句话给我带来的是多么震撼的影响力。他没有想过，这也许会是我们诀别。难道他从来只考虑自己的心里感受？我从前认识的他，哪去了？“有一个女孩，暗恋了我很久，我想把她从身边赶走的，可是她偏偏不听，我到哪，她就跟到哪。有一次凌晨两点，我喝酒喝到很晚，她还一直陪在我身边，我没有和她说什么，只叫她走，她就静静地待在角落里，叫我别管她......”那天你抑制不住兴奋地对我说着这些，我看在眼里，痛在心里。勉强地张开笑脸的我，问了你一句话，还记得吗？“你是不是很感动？”你回应说：“哪有。”其实你不知道，你脸上的表情是藏不住秘密的，我能懂，有些事情不必说得太过于明白，自己心里知道就好。说白了也没有用，有哪个小偷会承认自己是小偷，不会。爱一个人就要连他的缺点也一同接受，所以我选择了接受，就是因为爱他。此情无计可消除，才下眉头，却上心头。我没有想要得到太多，只一颗真正能给我温暖的心，一个很安定的肩膀，足够了。我要的其实不多。别忘了，你曾对我许下的承诺，即使穿越时空，在未来，千万别忘记我们之间的约定。梦中的人熟悉的脸孔你是我守候的温柔就算泪水淹没天地我不会放手每一刻孤独的承受只因我曾许下承诺你我之间熟悉的感动爱就要苏醒万世沧桑唯有爱是永远的神话潮起潮落始终不悔真爱的相约几番若痛的纠缠多少黑夜掐扎紧握双手让我和你再也不离分枕上雪冰封的爱恋真心相摇篮才能融解风中摇曳炉上的火不灭亦不休等待花开春去春又来无情岁月笑我痴狂心如钢铁任世界荒芜思念永相随悲欢负月唯有爱是永远的神话谁都没有遗忘古老古老的誓言你的泪水化为漫天飞舞的彩蝶爱是翼下之风两心相随自在飞你就是我心中唯一美丽的神话~让我们共创自己的美丽神话~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1220', '2000', ':39票　发表日期:2005-05-0809:55:00爱情是一场病态，相爱的人相互纠缠，在爱情中总分不清谁会爱谁多一点.一旦有一天，当我们在爱情中，可以清清楚楚地计算，那么，离爱情离开我们的日子，就不远了.于是，转过身去，背对着爱情离开，把自己关在门里，把爱情关在门外，只是，这一转身，往往就是一生，就是一世.不管是如何爱过，不管是谁转过身，最终都会沉在，这郁伤的海中，慢慢地沉溺，慢慢地麻醉......守着曾经传过情话的那部电话，听不到它再响起熟悉的声音，也无法再去拨通那个号码，记下的，全是下雨天的心情......学会独自在人群中游走，学会在喧闹中孤独，学会穿越感情的缝隙。寂寞地听着，风吹动窗帘的声音，寂寞地听着，时间，在窗外溜走，而我们自己，已经在时间中苍老，皱纹早就，爬上了心头......象城堡中孤独的女孩，看着每个夜晚的月儿，看着每个世纪的星星，想象谁会手持宝剑，把我们从这心的城堡中救走......总是看别人在舞台上，表演着爱情，总是为别人的爱情，而流着自己的眼泪......而自己，只是舞台上，那个没人注意的配角，用孤独，去衬托别人的爱情，演出的，都是别人的表情......明明知道，那棵灿丽的爱情树上，开着的，都是别人的爱情之花，结下的，都是别人的爱情之果......终于明白，爱情，就象是模特身上那件美丽的衣，穿在别人的身上，总是耀眼而美丽，穿在自己的身上，就成了小丑的戏......爱情并不是风筝，放出去还可以收的回来。而爱情放出去后，收回来的却总是伤心，因为，线已断了......只有孤独的，孤单的，孤寂的，在别人不明了的心情中，去怀伤，去叹息......', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1221', '2000', '當夜靜靜地走來，我感到一陣陣空虛和孤寂。我一個人坐在宿舍里看書，不知不覺中我已溶入書中的故事，或憂傷或愉悅。任笑容從臉上飛過，任眼淚從臉頰滑落。不知不覺中我也瘦了一圈，去年的牛仔褲穿了一直往下掉……當黎明悄悄走來，我感到光的精彩。我以最快的速度洗漱完畢。一邊走一邊唱地下樓吃早餐。神采飛揚地開始一天的四處奔波，或繁忙或清閑。任腳步在ｔ台上飛舞任音樂在空氣間傳……！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1222', '2000', '你知道吗?因为爱你，所以我才会在这个深深的雨夜里不停的想你。身边的那杯铁观音凉了，没有心思想再去换一杯，一颗思念你的心带着我一份不变的情怀在偷偷地想你。　　假如今晚的雨不停地下，不停地在敲打着我的忧伤和思念，你说我又该咋办呢？！爱你不是一种罪过，我相信，你不会也不可能拒绝这一次心与心的邀约，因为你和我一样，彼此都需要靠着彼此的安慰与问候来相互取暖。　　尽管时空把你我阻隔，可是此刻你我心灵的窗户都没有上锁，心灵不上锁，这是一句多么诗意而又抒情的话语啊！虽然我曾在经意或不经意之中伤害到你，祈求你能谅解我无心的过错。　　雨越下越大了，想你的那份质朴的倾诉无法用些苍白的文字来表达，思念的苦，深藏在心的最深处不愿让你看见，我懊恼於自己的不善言辞，心中真实的想往也只有借助於一支香烟来燃烧我的脆弱的情感，如果你在香甜的睡梦中能够听见我对你的想念和呼唤，那么我就很幸福了，就这么简单。　　幸福其实就这样简单，在今夜的雨夜中，不想再去惊扰你的清梦......', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1223', '2000', '问世间缘为何物，直叫人不好捉摸。因为无法诠注人与人相遇，相知、相交和底蕴和玄机，人们便认同且袭用了从禅语中拈出的那个字——缘。在亿万年的时光长河中相逢于今生今年世；在众生芸芸的红尘人海中际会于此地此处，无论男女长幼，无论贫富美丑，这一段尘缘足堪珍惜．有这样一种朋友，也许相隔万水千山，也许分别十年八载，世事变幻，沧海桑田，永远不变的是彼此心中的那份默契与牵挂，所以我相信，两缘若是久长时，又岂在朝朝暮暮．耳闻目睹曾经恩爱的夫妻因小事反目成仇，共赴艰险的朋友因蝇利成仇，颇感难解，思之再三，似有醒悟：一切美好的因缘都应有三个支撑点才能长远——重情、守义、惜缘。“有缘千里来相会。”——这是空间上的缘。为什么数百里以外的你的思想、情怀会与我的感觉如此相似呢？为什么不曾谋面、不曾晤谈，心中竟是如此亲切？又是这样地喜欢？为什么月光像是他的凝视，清风仿佛他的呼吸？心有灵犀，千里相通，是空间上的缘。说不尽的缘，道不尽的缘。了不断的缘。是缘，非缘。有缘，无缘。缘深缘浅。缘起，缘尽。有人灰情灭欲，斩断沙尘缘；有人耦断丝连，再续情缘。一面之缘与一生之缘或许只在一念之间。或是情在缘已尽，或是缘在情已绝······唉！这红尘中的是非恩怨，离合聚散，又怎是一个“缘”字了得！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1224', '2000', '~~~有一种爱很凄迷,有一种爱只能远望,有一种爱注定成传奇.......有一种爱叫做痛,痛得心脏起了褶子,痛得头脑空洞无物,痛得意志麻木萧瑟......有一种爱叫放弃,明知道许多事情是没有答案的,却想寻找一个答案,真的好累......有一种爱叫忍让,忍让也是一种爱,以爱的方式善待对方的缺陷,用包容的胸怀宽恕自己的爱人,给他一个悔悟的机会留一个自省的空间于平平淡淡中演绎经典,在无声无语中融洽恩爱.这样即使是不传奇的爱情也将变得永恒,再平淡的婚姻,依然一如既往令人留连.有一种爱,叫放手.曾经天真的以为不管时间和空间的距离有多长多远,感情一定会恒久不变,因为爱是没有理由的......爱不能成为牵绊,所以要选择放手,从容的让彼此走彼此的世界,凡事到极至,伤也会痛.其实爱过就会懂,彼此个性的太过坚强终究会是一起生活的阴影。昨日的幸福以成为一种痕迹,两人能携手走完整人生固然很好,可陪上了一段也应心存感激了.爱一个人不是要成为所爱人的牵绊,只要心中有爱,生活总是那么美好!相距是一种缘,相识,相恋更是一种缘分,缘起而聚,缘尽而散,放手才是真爱.有一种爱叫放手!有一种爱,叫离开,曾经以为自己的爱情能够长久,曾经以为真心的付出就能换来幸福,其实错了....爱情给的唯一的东西就是背叛,无情的背叛!曾经是那么相爱的两个人,转眼陌路,留下的是残缺不全的记忆和心痛.没有想到结局会是这样,曾经的山盟海誓,曾经的天长地久,转眼都成了飞灰。经常惊醒于午夜梦回的黑暗中,我的心都好痛,我思念一个人的疼痛,看着空中的星星,想着远方属于你的夜,你还好吗?一直都快乐吗?没有我在你身边是不是有另外一个人去关心你,爱你呢?我现在唯一的愿望只是希望再见你一面,但我又怕见你,怕见到你,我的心又会再一次的被捏碎.我只有对自己说不要再去想他,不要再想了,虽然他的影子从未离开过。生活还是要过的,其实有种爱叫离开,再见了,我的爱人......', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1225', '2000', '~~如果有那麼一天,我再也找不到妳的身影時,我會怪妳將思念如此輕易的放逐。在我背轉身的時候，悄悄的。悄悄的從我身後逃离。就此消失在蒼茫的塵世間。也沒有任何的消息與提示，而當那一天終于無可避免時，我會將自己的心情重新去調整，然後將記憶默默的收藏起來。就在一個旁人無法觸及的角落里，我已經將妳深深的藏好，從此不再讓任何人問起妳我的過往。天空中再也沒有眼淚，只因我已飛過。一生的執著，亦是一生的傷痛，斷斷續續的思緒。是不是也在期待著一種永恒，哪怕，哪怕只會是悲傷的延續。如果，如果妳能找到那些存在過的愛意時，那麼，那麼你就會驚喜的發現。天，原來可以是那麼純淨明朗的蔚藍；水，也會是那麼無憂無慮的碧綠。而空氣，則是那麼清新欣喜的芬芳和溫柔。夜讓我想起月亮，月亮讓我想起夢，夢中讓我想起妳，你讓我想起曾經，曾經讓我想起离別，离別讓我想起重逢，重逢是我的期盼……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1226', '2000', '世界上最远的距离不是生与死的距离而是我站在你面前你不知道我爱你世界上最远的距离不是我站在你面前你不知道我爱你而是爱到痴迷却不能说我爱你世界上最远的距离不是我不能说我爱你而是想你痛彻心脾却只能深埋心底世界上最远的距离不是我不能说我想你而是彼此相爱却不能够在一起世界上最远的距离不是彼此相爱却不能够在一起而是明知道真爱无敌却装作毫不在意世界上最远的距离不是树与树的距离而是同根生长的树枝却无法在风中相依……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1227', '2000', '~~~一个男孩为了他所心爱的女孩，信誓旦旦满怀希望的奔向了承载他美好梦想和实现美丽爱情的远方。可当他功成名就的时候，女孩已经变成了别人的女人。那一天，男孩也成长成了男人。此时，他可以给她向往的后花园，可以给她温暖的环抱，可以承载她作为一个小女人的一切梦想。可他得到了树根，却失去了再也不可挽回的树干。在得与失之间他失去了方向……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1228', '2000', '当生命不再辉煌，你所拥有的一切，也就象夏天稻田里漂浮的那一抹晨烟，随风而散了。你也就不会去在乎名利，看重成就...你期待的，只是在黄泉路上，一路走好，不要有恶人骚扰，能直奔天堂。你忘记了所有的一切，记住的，是那些刻骨铭心的伤痛，无法抹去的悲伤。这一点也不奇怪，因为快乐带给人的，是一瞬的感觉，而痛苦带给人的，是永久的记忆。人们在经历痛苦的同时，也得到了很多快乐，只是没有人去注意它们罢了。在人们的眼中，只看到了短暂的快乐，他们为此振臂高呼，兴奋不已，而在这时，更大的痛苦也……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1229', '2000', '感情真的是很怪奇怪的东西，幸福握在手里的时候，不知道该好好的珍惜，伤害得伤痕累累时，蓦然回首才知道曾经拥有的才是最需要的幸福，然而有的伤口因为伤得太深已无法愈合。喜欢一个人是没有理由的，背叛一个人却是因为经不了新的诱惑。每个人都想平淡如水的生活不时也要微波荡漾，因为有起伏才会有美感，然而两个人过了久了总是会归为平静的，责任道德与新的激情浪漫总是让人处于两难的抉择，霎那间的温情与浪漫可能破坏的是永久的幸福，虽然很多时候昙花一现的美丽也是可遇不可求的，但握在手里的幸福才该是最真实的……被别人伤害了，受伤的却是那种找不到痛处的闷痛，伤害的人竟也毫无觉察。就象被什么东西隔着棉被狠狠击了一下，没有伤痕，却痛得要泪下，也又无法让别人看到一张阳光灿烂的脸悄悄的留过泪痕。本就相爱的两个人，却不得不因为外在的很多东西，做着彼此伤害的事情。不是因为相爱就可以拥有幸福。年轻的时候不懂生活，让幸福奢侈的从指缝间流泻，当爱侣成为伴侣时，生活也就寡淡成白开水，虽然没知没味，没有营养，但毕竟还得不可缺少。把爱情褒成老火靓汤的是高手，但大多数人喝的是加了点油盐菜的“涮锅水”，没有多少口感与质量可言。无奈，是无可奈何。无奈，是无可奈何的别无选择。无奈是毫无知觉的无知挥霍，一贫如洗时，已无可从头来过。日子重复得久了，很多时候是很寡味，很无可奈何，但仍要一如既往的过下去，因为大多数人都是这样一如既往日复一日的生活着……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1230', '2000', '女孩說我愛你男孩笑了女孩又說我真的愛你男孩還是笑女孩哭着離開了男孩站在原地怔怔地自言自語其實我也愛你隻是不知道怎麽愛你男孩籃球比賽女孩叫破了嗓子第二天依然出現在男孩面前說昨天你真遜男孩的頭上出現了一點點的紅色女孩緊張半天卻還說着我才不在乎女孩說我累了男孩蹲下身子說上來吧我背你男孩說如果我遇見我喜歡的女孩一定背着她滿世界地跑……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1231', '2000', '..................................................', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1232', '2000', '我这几天好累了....?但我好想你们...老公...老婆....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1233', '2000', '时钟滴答滴答的走着，我知道那是我们的生命在流淌。我打开一本书，米兰*昆德拉正在说：我讨厌听我的心脏跳动，它是一个无情的提示，提醒我生命的分分秒秒都被点着数。”可是我没法不听，正如我无法拒绝2万多个日子一个个溜走；我的心脏没法不跳动，正如树叶在秋天里没法不飘落。心脏停止跳动，那便是我们的末日。我平静的想着：我们怎样才能在走进坟墓之前，没有遗憾？这个问题非常接近那段我们耳熟能祥的经典语录：当我们回首往事的时候......我这样怀着美感想他们，并不意味着我们的青春必须苦难重重，我不希望青春被某一种方式囚禁，它应该是绚烂的，完全放开的；我不希望20多年的岁月永远背着沉重的十字架，有的人背它只是为了别人可以不背它。我想说的只是：哪怕我们的世界变得越来越小，越来越平庸，也别让我们精神的花朵在春天枯萎；哪怕我们四面楚歌，也别忘记保持自己尊贵而骄傲的呼吸......', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1234', '2000', '今天姐姐从安阳回来了，也给我代来了我的药，爱诺华，我想再吃上两个月看看效果如何？在姐姐家还是感觉不太方便，所以我还是决定在自己家住比较好，自由一些，也没有什么压抑的感觉！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1235', '2000', '今天是11月15号，也是我又一次离开这里去寻求健康的一天，天总是下着雨，我的心情也随着天气变的压抑起来，因为今天要离开，所以我起的很早，一早起来我就建立个日记本，因为我知道下面就只有一台只能打字的电脑能解闷~所以我就先申请了个日记本，我希望它能够陪伴我走过这段无聊的日子！写下我的心情~~！！！早上8点叔叔的车子就来了，做在车子里，听着叔叔点的黄昏，我总感觉是那么的伤感，具体是什么原因，我自己也不知道，做在车子里，看着熟悉的树木，房子，一步一步的往后退~越走越远~，而我的整个人和心都已经飘到d那里去了。这一去就是一个多月，我心底最深的结还是d，我很害怕，我害怕他会离开我，害怕他会等不起我，害怕~~~~真的很怕，身边的人经常对我说对于什么事都不要太在乎，可是我却做不到，一但爱上了，我就知道自己会爱的很深~就像d一样，从我和他在一起开始，我就好像没有什么时候不在想着他，不在念着他？想着一个人是一种幸福，同时也是一种痛苦，幸福是因为我在想着，痛苦也是因为我在想着~！！！！不要想，他不会淡忘我，他不会离开我~~不会~~不要想那么多，他说过他不喜欢我想那么多~~所以不要想~不要想~~~~~~~~~~~~~`爸爸帮我准备了很多的日用品，还带了很多我最爱吃的果冻，爸爸的用心良苦，我很感动？其实我们都很清楚在怎么治疗我终究是一个不能生育的残废女人，只不过爸爸和我们一直在执着，我记的前几天我问了爸爸一个问题，要是我这一辈子都是这样，我还要不要结婚呢？爸爸很果断的说；不要，难道你相信世界上还会有那样的男人吗》？就算是有，也都是一时的，以后都会嫌弃你的，到时候你就会呕气~！！开始我认为爸爸说的不对，因为我始终相信世界上始终有真情在，只要两个人的感情到那里去了，没孩子又有什么关系，其实现在想想爸爸说的有道理，就算他不在乎，难道他的父母也会不在乎吗》？以后要是有一天~~他看见人家的孩子他难道会没有想法吗》》哎~刘林~~你真蠢？难道你还真的相信这个世界上还有真情的存在？？可笑~~爸爸说的话有时候就是很针对性~但他的话总是会很实际，也很有道理，或许当时你无法理会到，但总会领悟到~~~~~~~很多次都是这样！！开来我真的要从新打算~~自己过自己孤单的生活，我是一只在地上的青蛙，怎么会幻想有一天会拥有飞上天的那中幸福呢》别在幻想啦》》？还是做一只本分的青蛙算了~~~~~~~~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1236', '2000', '每一次需要你的时候你却总不能在身边，可这是我的选择，我从来就没有怪过你，不过昨天下午你到医院来看我，虽然不是时间不长，可我还是很感动，特别是你当着那么的人喂我吃饭的时候我感觉我好幸福哦！！！！虽然你平时和我在一起的时间不是很多，可谁让我爱你呢，我能承受，但是每次事情过后你都会对我说：对不起，让你受委屈了！！！其实你不用那样说，这点根本就不算什么的，只要你记得就可以了！！！！！呵呵，这点要求不过分吧，我相信我在你心里肯定是很重要的，只是你的工作比较特殊，心有余而力不足。。。。军，你知道吗？你是我第一次爱上的人，也是我永远爱的人！！我希望你永远的健康、快乐！！！假如以后我要是有什么的话，我肯定会选择离开，但是现在的不会的，现在是你赶都赶不走的哦！！！呵呵，赖上你了。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1237', '2000', '2年,我们真的结束了冒?这不是我想要的答案!我真的希望我们能手牵手一起踏入红地毯上,有万人的祝贺,献默.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1238', '2000', '经过一天一夜的路途，我终于到达了这个不想来而又不得不来的地方，珠海心脑科病人修养院，树还是以前的几棵树，房子还是倔强的房子，妈~不那个女人帮我安排好了所有的一切，就回去了，我就到处走走希望能看见以前的一些玩的好的病友~~我来到三楼，一个熟悉的背影出现在我眼前，他是高血压病友啊力~因为他很胖~我们都叫他胖子，他一看见我就大叫；‘林崽，你什么时候来的？》’我们做下来聊了起来~~说了一会儿~我便问到；‘李那，萧彬，啊蜂他们呢？》其实我最关心的是想问起萧彬，其他两个只不过是不想让他看出我的意图才扯到的，他告诉我，李那早就出院了，啊蜂回去修养段时间在说。我追问到；“那萧彬呢？》’这时，他突然哽了下，红着双眼哽声哽气的说；‘他啊，就在你离开的个把月，因为接受不了他爸爸摔段了腿的事情，因为暴病而走了。’听到这个消息，就像在我的闹阔上响了个晴天霹雳，我脑袋一片空白，紧接着，以前在医院的一幕一幕就像电视一样浮现出来，我明显的感觉到自己的心跳在猛加，我的血液在串流~呼吸很困难，我很想克制住自己的情绪，可是没有用，眼泪还是想珠子一样不听话试的一串串的流在我的脸上，在流进我的嘴里，是那么的苦涩，我的脑袋瓜~一片空白~~仿佛觉的世界上没有比这更痛苦的事啦~~紧接着~我什么都不知道了~~~醒来的时候，我已经睡在床上，那个女人告诉我我刚才听到萧冰走了的消息而犯病了，需要好好的休息，她跟我说；‘这些事都是注定的，谁都不想的，别想那么多。’我看着天花板，任凭眼泪放肆的流在床上，我哭了，哭的很伤心~很伤心~~我开始忏悔，忏悔当初对他呼风唤雨，心情不好的时候还对他乱吼乱叫，而他却从来没有生气，对，他确实很爱我，可是我却从未爱过他，开始的时候甚至还有点讨厌他，觉的他调皮，喜欢死缠乱打~，可是为什么要到他走了，才觉的他的调皮和死缠烂打~是可爱~是无邪~~为什么》为什么我总是要这样等到我失去了，我才会懊悔自己之前的总总行为，我早就应该对他好点，我早就因该想到他是重病病人，随时都有可能离开~我~~~~```~~~~~彬~张的很帅~，他因为有心脏衰竭而住进这个医院，因为他只有21岁，而我也只有19岁，年轻人同呆在一个不见外面世界的医院，所以我们之后会成为好朋友，刚开始他找我搭讪的时候，我总以为男人总是那么好色，也认为他心存不轨，所以从来对他说话没好好的说过，还动不动就揪他的头发，而他却从来没生过我的气~后来因为啊力李那他们和他玩的好，我们也就慢慢的走的近~~，他总是很调皮~很爱收我的鞋子，害的我到处找，而他却也长长因为这样被我痛扁~记的很清楚，有一次他回家后，给我买了一个水晶球，那个水晶球很漂亮，他给我的时候告诉我他很喜欢我，很爱我！可是我却从来没有喜欢过他，我很果断的把水晶球~退给了他，很直接的告诉他；说我不喜欢他，只帮他当哥哥一样。然后就走了，然后我就看见他很生气的把水晶球摔破了~~~我不感想像他当时应该有多么的伤心，以后的日子，我认为他不会在理我，可是他还是像以前一样死缠烂打~~~~~~~想到这些我的心好像被一万把刀在心头上扎~~扎的我很痛很痛~~~这一切都将成为永久的记忆，我在也见不到那个很爱我的调皮~的男孩了~~~在也见不到了~~~~彬~你知道吗。我很难过~~~我很懊悔，我很想你~~~~彬~你回来啊~林崽回来了~~55555555555555只要你回来啊~我不在骂你~不在吼你~不在对你呼风唤雨，我会把你当宝一样~彬~回来啊~林崽不在讨厌你，不在拒绝你的水晶球~~~回来啊~~彬~~你知道吗？我很恨你啊~恨你为什么不见我最后一面～为什么要就这样的抛开我自己走了～《你是不是在生林崽的气～～是不是》》？？所以你要这样残忍的惩罚我～～彬～～彬彬彬～～～彬～～彬～～彬～彬～彬～～啊　～～～～～　　我难过～～好难过！好心痛~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1239', '2000', '崫糨姒泘沒侑恏処吥簖嘚炩裑笾嘚朲绶捯傷害.洎己又得捯叻什嚒?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1240', '2000', '\"知道嚒?倔强得我与祢!..也许是真得不相配..但是..事情发生了那么多!一直不断得对自己说\"\"无所谓.\'不断得提示自己\"\"要拿得起放得下.\'憋在心里.真得不好受...还是好爱祢..狠不下心来!是根本就不可能狠下来.因为我做不到..开始认为.自己是在放弃.然后认为自己是在乘强.现在才知道自己是在逃避.!我真得好爱你.....但是现在已经没机会对你说了!...我永远都放不下你!.iloveyou!\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1241', '2000', '又一天开始了，在不知不觉中有快过了一年了。回过头想想，自己在这一年里是一事无成，心里觉得莫名的悲伤。我有什么脸面去见我的父母呢。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1242', '2000', '我为什么会说感动都不晓得,还要我讲哈的,就是看见你留的言撒,心里觉的感动撒,自己讲的什么话都不晓得鸟,我写的日记我讲了你要留言,就是看了留言才感动,我明白你的好,你觉得每⒈句话,我们要一起战胜⒈切,这也是对我留的言!昨天晓得QQ盗挂的,今天我把QQ盗过来了,那晓得哪个人裹么笨秘密把我猜到滴,哈哈,开心,但是我还是蛮不爽的,哪个人真的是个在贼勒,把我可以搞走的东西都搞走鸟,哼,那里有裹的人,信好我的号现在回来勒,!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1243', '2000', '真是得..呵呵,走到哪我心里挂念得总是你!开心,尴尬,愧疚.是我们真得不合么?还是彼此顾虑得太多..~!和好,分手,和好,分手..不断得在我们得交往中出现.~!难道真得有这个必要么?不在一起得时候心里总是充满着对你得挂念..真难受~~!逞强...倔强!哈哈\'...真无奈..`~~!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1244', '2000', '我们都毕业了都有了各自的新的环境可每当我看见新的同学在一起逗我就想起曾经的你和我还记得我们以前发生的事吗你大概都忘了吧可能你就只记得和她之间的事吧不过我希望你没有忘记我们之间那个小小的约定虽然我不再喜欢你了但是我永远都不可能再忘记你因为你是我真心喜欢的第一个也是第一个伤我最深的人我没有恨你因为你也让我明白了一些曾经不懂的事我们都长大了希望你能认真的想想眼前的事别再沉浸在她编织的谎言里我不可能亲口告诉你这些因为你不可能信只希望你能看见或者自己想明白如果哪天有了事一定要告诉我我一定会帮你就让日记把我的话带给你吧', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1245', '2000', '郁闷~～伤感　郁闷伤感～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～痛苦～失眠～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～～　　彬～', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1246', '2000', '利民已经走了大半月了，我也逐渐的慢慢适应着一个人的生活。感觉也不错哦！！最近身体还可以，就是左手的无名指痛的厉害些，管他呢，心情是第一位的，无论怎样，还是要把心态调整好才行。这星期已经跟利民视频过两次了，每次都是说到无话可说的地步，呵呵，真可怕，人要是到了无话可说的地步。听他说这两天就要去郑州签合同了，说明他的工程还是进展的挺顺利的。希望他可以成功吧！我不想给他太大的压力，呵呵！我自己现在还是没有定下来一个短期的计划，这两天想着练习太极拳的，也不知道能不能练成，因为我知道自己是个只说不做的人，呵呵，太了解自己了。这些天，在无聊的时候，就会在QQ群里跟那些病友们聊天，很是开心，特别的认识了蓝，她真的是一个跟我有好多相似之处的女孩儿！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1247', '2000', '天总是下着雨~我一个人趟在床上望着窗外的雨~感觉到这雨~好像了解我的心情在为我下一样~~下的那么惆怅~~~这几天我总觉的自己真的快崩溃了，彬的身影老是浮现在我眼里~~~我打开了那个曾经记的我们唯一的记忆的网制~~上面清楚的记着~我们从开始到~离开的一幕一幕。。。。。而我却没有看~~因为我知道我看了一次又能怎么样~~他现在已经都不在啦~什么都不存在了，存在的只有那些残留的记忆~~我也知道这些记忆~以后将成为我痛苦的回忆~~所以我决定把他烧给彬~~~~一边烧着~~一边唱着周传雄的记事本翻开随身携带的记事本，写着许多事都是关于你你讨厌被冷漠，喜欢被守候寂寞才找我我看见自己写下的心情，把自己放在卑微的后头等你等太久，想你泪回流而幸福快乐是什么？爱的痛了，痛的哭了，哭的累了日记本里页页执着，~记载着你的好像上瘾的毒药，他反复骗着我爱的痛了~~痛的哭了~哭的累了矛盾心里总是强求~！劝自己要放手闭上眼让你走~~烧掉日记从新来过~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~我栓掉了全部记的他的每一个日记~~~~~~~~~~~~~~~~~~~~~~~~~~~~可是我却烧不掉我心里的日记~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1248', '2000', '路人门形形色色的羽绒服,窗玻璃上的哈气,屋子里的暖气,再加上这两天出奇的阴的天气,都在证明冬天来了,寒冷,干燥,我的心情也是如此.好久都想写写心情了,一直都没动,直到今天我实在不得不写了,因为在这个城市里我除了他,再也没有任何朋友了,不写日记,我基本没人倾诉了.这一阵发生的事要我觉得自己傻得好可怜.今天我想拿十月八号开始写起,写写从那段时间以来所发生的.十一终于过去了,他很忙,因为在学校的软件中心,他有系统要做,在这个没有朋友的城市里我自己天天看着街上熙熙攘攘的人群,心里有点失落,街上有大人领小孩的,男朋友领女朋友的,就连小狗也有主人带着溜马路,而我却是自己孤零零一个人,可是转念又想想,那有什么关系呢,我男朋友在学习呢,他多上进啊,为了我门以后的生活他在努力呢,我该理解他才对啊.于是我笑着看街上卿卿我我的情侣,安慰着自己.七天很快就过去了.不是长假我也就没什么理由埋怨他不陪我了,他说过的抽天时间一起玩,一起吃饭,可是七天过去了,说过的话没有实现,他一点歉意也没有.我跟我的男朋友在一起呢,可我却过了一个孤单的国庆节,而我们相恋也才一年半的时间.学习,多么正当的理由啊。我有什么可以埋怨的啊.七号晚上,该回校的同学都回来了.大伙喊他一起去吃饭.他喊我去，我没去,怕成为他的累赘,别人每次吃饭都不带女朋友,我不想要他太难为情.结果他吃完饭就回宿舍玩游戏了.后来还打电话说想玩通宵呢.也许七天了.他也很累了.我应该理解他,但是毕竟我是被以前的男朋友惯坏了的.在他这,我还没有彻底的变.我就不,我非得不要他玩游戏,非得要他来找我,怎么也是个假期啊.你没有陪我,说是你忙,朋友喊你一起吃饭,你去了.说是你重视朋友,通宵游戏,说是你学累了,想放松一下,这些都可以理解.但是你偏偏忘了这个城市里对你依懒最大,除了你就没朋友的人了,他需要你一点点的关心,哪怕是吃完晚饭一起散散步,她就心满意足了.呵呵,可是没有.朋友,游戏::;;;;;;我也不知道我在他心目中到底排第几,但是我敢肯定一定不是第一,也更别提唯一了.失落的心,无力哭泣!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1249', '2000', '钅鈤終于蔸冂丫櫵散咗', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1250', '2000', '今天是姐的生日，我送她的生日礼物是一支英雄牌的钢笔，也是我至今为直买的最贵的一支笔了，不过她喜欢，我也就知足了。我们晚上在金海岸吃的西餐，嗯，呵呵，还是吃不饱啊！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1251', '2000', '晚上醒来，看看钟2点多了，我做了个梦，梦见她和一大群不认识的人在一起，自己真的很贱，既然都分手了还会梦见她，为什么会这样呢？难道自己真的不舍得吗？哎！有时候自己觉的自己不像个男人，虽然我们分手的时间不长，但是自己觉的这几天就像几年一样，自己努力说忘掉这段感情但是自己真的做不到，算了！我想时间会改变一切，有时候自己想去挽回这段感情，但是过去的怎么还会回来```凌晨2点醒后记', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1252', '2000', '[COLOR=#7fffd4][/COLOR]我將離開這座城市,妳卻依然相信謊言.在寂靜枯山裏,妳我躺在被單上.吹着冷風,聽着妳我說不完的苦痠甜辣.妳的頭微微嚮我靠近,感到一陣溫馨.妳說難受,我愛莫能助,隻能用沉默來包容自己.幾年之后想起我來,那說明哥哥也在想妳,幾年之后忘暸我,那我隻能用受傷來帶過.最親愛的哥哥寫的..好傷感.哥..叫我怎么可能忘記暸妳?..永遠不可能..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1253', '2000', '傑倫的新專輯終于齣來暸.不負衆望,真的好好聽.髮如雪寫齣暸前世今生的緣分,好感慨!真的有前世今生?...??如果有.我希望下輩子還能遇到哥哥..繼續當他的好妹妹哦!倖福死暸..夜麯紀唸暸死去的愛情,好感動男主人公對愛情的執着和付齣.我的愛情能這么可歌可泣嗎?楓寫齣暸思唸.無論是愛情還是親情還是友誼的思唸,都能感受到一種深深的悲傷.....還有好多好多歌都好好聽.麥芽糖和浪漫手機好溫馨,可惜我現在的心情好差!總之心情好的時候,傑倫的歌總讓我更高興,心情壞的時候,傑倫的歌永遠是心頭深深的安慰!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1254', '2000', '.在勞動基地裏,有開心也有傷心.百感交集,很難忘.開心:那天晚上我彈電子琴,哥哥彈吉他,沣唱歌,我們閤作的是jay的.結果底下的同學狂叫..狂喝綵!!high死暸.還有媛媛唱的時候全場氣氛都被她帶動起來暸..好為她高興..也為她感到自豪..我可愛的妹妹.真厲害!最后一首我和妹妹..哥哥..沣一起唱結果居然都聽不到自己的聲音..因為隻聽到底下同學的閤唱聲..好興奮..好興奮!!而且我和哥哥的第一次閤作還拿暸最佳縯奏獎!傷心:1.第一天晚上,我們晚會的成功讓我們激動,,可是哥哥卻抽煙暸..我生氣!他后來把乘下的大半包煙都交给暸我..而且都銷毀暸..可是他卻一臉鬱悶.我問他是不是生氣暸..他說沒有.是頭暈而已.可是后來同學和我說他臉色白白的.一個人喝暸很多很多酒..可能生氣暸.我哭暸..我真的是為他好..他為什么?而且生氣就生氣吧..為什么騙我?是不是他不想理我暸..后來纔知道..哥哥真的醉暸而且醉的很厲害!!2.第二天晚上西瓜和唯喝暸好多酒都醉暸,她們兩個心情都不好,后來好不容易把西瓜弄到牀上.炤顧她的時候,看她眼淚不斷從閉着的眼睛流齣來.想到平時她是多么可愛多么單純..可是現在.我是她口口聲聲叫的姐姐,卻沒怎么炤顧到她..又哭暸..失敗死暸.唯也醉的不成樣..鬍話一大堆..看的心都碎暸,平時死要麵子而且好帥好帥的她..卻是現在這樣子..后來和哥哥在后山上躺着..看着天空..想暸好多好多.難過,是因為悶暸很久是因為想暸太多,是心理起暸作用?不過有哥哥躺在身邊感覺好多暸,雖然有些寒意,卻倍感溫馨.可是他畢業后卻要離開我..走暸.為什么都要這樣子?現實太殘酷暸!這是我最后一次去勞動基地,也是最難忘的一次.希望這個開心,傷心的幾天能永遠畱在心頭.成為時間永遠也無法腐蝕的記憶.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1255', '2000', '人生有很多很多的第一次,而我却是第一次在网上写日记,总有一种赤裸裸的感觉,不知道为什么,每次提到写日记,就会让我想起恋爱中的我,我很多年没有写日记的习惯了,只在恋爱中写过,看来我离爱情很遥远....没有爱情感觉的我会是什么样子,我也不知道....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1256', '2000', '哎..是这样得么?是自私么?还是太过在乎?很怕你会喜欢上别人..很怕我与你没有机会再见!难道我们真得不合么?再怎么联络你?嗯?.我应该怎么样面对你?.对你发泄你家人对我的诬害么?还是对你倾诉你家人对你的关心?.真得好想你.好想你能够在我身边.好想你能够投入我得怀抱..抚摩着你可爱得脸蛋..揉搓你柔软的头发..现在与过去..!!呵呵..轻易得爱上你.而无法克制.如果说你得不好.真得可以说一大堆.但是尽管如此自己还是很喜欢.都说跟你在一起的时候.我很傻..但是我仍然不去理会..因为那些不值得我去理会..我只知道我喜欢你!无法克制得喜欢.忘不了,切不断..时时刻刻..在我的脑海里.都有你得存在...努力去制止过..不在想眼前的遗憾..将想法放在将来.想着将来.尽管是想着将来..但在将来也浮现出你的身影..担心你的无知影响你得将来.自己有时也在疑问.为什么会去关心你?给自己找那么多麻烦?好难受怎么样才能去克制?也许趁早见到你.对你说清楚一切比较好..好怕你被别人骗?..如果晚见你..也许你会有很大的改变.好了也许有些安慰..坏了呢?心里会不会很难受.!?我能克制么?这些无聊的想法。..哎....~~~~!真得好无奈阿.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1257', '2000', '当我再爱你的时候却被一次一次被你冷落你却不知道当时的我望着你带着微笑而过当我再爱你的时候心中有着多少失落和伤痛你却不知道当时的我被你刺痛的不再是我就让我停留在这一刻再次回首爱你的时候就让我停留这一刻让你让你让你走当我再爱你的时候却被一次一次被你冷落你却不知道当时的我被你刺痛的不再是我啊...当我再爱你的时候却被一次一次被你冷落当我再爱你的时候心中有着多少失落和伤痛就让我停留这一刻再次回首爱你的时候就让我停留在这一刻只想只想对你说我是真的真的很爱你听着小鸣的当我在爱你的时候自己的心情非常的混乱，有的时候自己真的想设法去挽回以过去的那段爱情，但是自己知道过去的怎么会回来呢？自己的爱情从来都不会长久，难道爱情不适合现在的我吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1258', '2000', '我也不知道怎么说我们了..我现在也只能说你们漫漫好把..你地好妹妹..`.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1259', '2000', '我想..我只不过是他溺入爱情湖水中奄奄一息时抓住的一根浮木，我给了他喘息的机会，以至于他不会溺死在湖中，可浮木毕竟是浮木，它永远不可能成为岸！心里很明白，有一天他会放开手，用尽最后的力气游向岸，哪怕。。。靠不了岸！[SOUND]http://www.13139.com/MusicData/play/142624.html[/SOUND]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1260', '2000', '冷漠...!开口,是否就是认输?嗯?.被隔离...难道继续沉默?..真得想不通..好累...不知道自己该怎么做!为什么每次都是这样.开口.了以后又回怎样?拥有你.然后再失去你?但是现在无时无刻脑海里都浮现着你.一想到你,莫名的烦恼..莫名得伤感..真得好累..现在得我好矛盾.不知道该怎么做~~!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1261', '2000', '[COLOR=#FAEBD7][SIZE=2][SIZE=3]我的漫长的等待史就这样结束了，结束在他的逃避时，既然他不愿理我，嫌我麻烦的话那就到了连朋友也做不成的地步了。罢了，我的心伤了，以前上网是为了等待他的到来，只为了和他聊几句我愿意一天都坐在电脑前，可他不会知道，他只认为,我是个网虫。只是让我在大喜之后又大悲。我不知道为什么要这样子对我？我哭了，我无奈~我会在今后让自己忙碌起来，让时间抚平伤痛，感情的事我不想去想了，相信在未来的某天我会遇上那个可以陪我到永远的人。而他只是我心理那个不可实现的梦！我该走出来面对现实，做个坚强的自己，成功的己！！！爱上你不时我的错,是上天在捉弄我.[/SIZE][/SIZE][/COLOR]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1262', '2000', '如果能一睡，就永远不醒来，那该多好那就可以永远保有那个梦了，不用担心梦碎的一天即使梦中的一切都是假象，那又何妨呢？至少在梦中不会伤心可惜，梦总是在美好的时候惊醒到头来，也许不过是痴人说梦如果我睡了，请不要叫醒我[SOUND]http://www.568.com/music/90715.htm[/SOUND]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1263', '2000', '某年某月某一天，我开始思念着，从那一天开始，这种在深夜里才敢出现的思念就再也没有停止过，一直延续···一直···听有人说过这样一句话，别等失去了才知道珍惜，那就什么都晚了。可是我和他这算是失去么？还是从来没有开始过？或者是我做错了什么让他离开？又或者是他的什么让我选择离开？不，应该是我的什么让他选择离开吧···我不理解，只是在这样的夜晚思念着···安静的夜，我一个人在这空荡荡的房间感受着寂寞。感受黑夜带给我整个世界的黑暗，那是谁都无法挽救的黑暗···我想说不是因为寂寞而怎么样，是因为思念他带给我寂寞···呵，越来越发现每每自己想他的时候总是语无伦次，不知道说了什么又能说什么，只是不开灯，摸索着坐在电脑前噼里啪啦敲着键盘，很响，也许是怕惊醒哪个幽灵所以我放慢了速度。呵呵，苦笑，也许这就是老天给我的惩罚，我和我的爱情就这样擦肩而过，剩下的日子只有我一个人，我再找不到其他办法去忘记或者去弥补再或者去挽回。手指敲的有些痛，看看窗外，天已经亮了，我随手点一下电脑上的删除，不知道这一夜都写了些什么，也不想知道了，只记得有句话写了很多遍，就是那句“你记得···我·在么？”我也不想知道这句话的答案，因为没有人能告诉我，就算他自己不能，是的··我肯定···也只有在这样寂寞而安静的夜晚，我才知道自己有多想你，然而你却听不到···', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1264', '2000', '[SIZE=1]—音乐—音箱里循环播放着我所喜爱的音乐，时而伤感，时而活跃。“弯弯月光下，我轻轻在歌唱，从今以后，不会再悲伤，闭上双眼，感觉你在身旁，你是温暖月光，你是幸福月光……”《月光》总能让我思绪万千，这优美的旋律，忍不住想跟着哼唱，也会忍不住望向窗外的天空，宁静。。。喜欢。喜欢这种宁静。如果真能象歌中所唱的那样“从今以后，不会再悲伤”的话，也许笑容便不会如此的难寻了。可笑容却是我最常想起的表情。呵呵！也许，我很快乐。也许，我很幸福。不，应该是，我很快乐，我很幸福.不，没有也许，只有快乐和幸福。。—qq—qq上的人说多不多，说少不少。我躲在暗处，看着上上下下的人，心却好平静，从未这么平静过。想上线，却怕找不到话题。不知从何时起学会了一人承担所有，不想向任何人倾诉，所以习惯了隐身看着“人来人往”。一个多小时过后，我上线了，可此时人显然少了好多，望着摇啊摇晃动在眼帘里网友的头象，手指停在键盘上，不知接下来该说些什么。曾经想过再也不接触qq了，可是还是离不开，虽然聊天的次数少了，可还是离不开它，也许是一种习惯。习惯。—晚安—时间停在九点整，夜，越来越冷。知道你不会上线，却总是想等你，我也只是静静的等你。望着窗外，整个城市都沉浸在寒冷中。望着你的qq头象。我轻声的说：“晚安。亲爱的。”[/SIZE]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1265', '2000', '想做成一件事情，却发现自己原来什么都没有准备想对着天空大喊一声，却发现没有什么值得骄傲的事想痛快的哭一次，却发现没有什么后悔莫急的事想找朋友出去聚聚，却发现身边已经冷清了许久想跟爸妈说说心里话，却发现他们已离我好远好远想大声的唱首歌，即使旁边没有听众，却发现自己已经好久没有背歌词了想骑单车出去兜风，却发现自己已经辨别不出方向了想好好吃一顿，却发现手上的钞票已经不多了想好好自习一次，到教室了，却发现笔忘记了带，书也拿错了想写一篇豆腐块文章，却发现自己只适合做平民，作家终究不是平民想对他说“我好喜欢你”，却发现我们之间已产生距离，想```````````想做的事情太多，太多等到我们失去的时候，才发现自己的力不从心[/COLOR][/SIZE][/FACE][/COLOR]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1266', '2000', '\"一天，男孩和女孩吵架了。他不再对她说\"\"我爱你\"\"，当然她也不再对他说\"\"我也是。\"\"一天晚上，他们谈到了分手的事，背对背睡下了。半夜，天上打雷了。第一声雷响时，他醒了，下意识地猛地用双手去捂她的耳朵，才发现不知何时他又拥著她。雷声紧接著炸假装什么也没发生，可谁都没有睡著她想也许他还爱我，生怕我受一点点吓。他想，也许她还爱我，不然她不会流泪的。爱的最高境界是经得起平淡的流年。在一个群里看见的,虽然很短,但必竟是个好的结局.\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1267', '2000', '爱你的人总是最后才挂线那个时候女孩和男孩正处在恋爱的季节。每次打电话,两个人总要缠缠绵绵许久。末了,总是女孩在一句极为不舍的“再见”中先收了线,男孩再慢慢感受空气中剩余的温馨,还有那份难舍难分的淡淡情愁……　　　后来,两人分了手。女孩很快就有了新男友,帅气,豪爽。女孩感到很满足,也很得意。后来,她渐渐感到,他们之间好像缺些什么,这份不安一直让她有种淡淡的失落。是什么呢？她不明白。只是两人通话结束时,女孩总感觉自己的“再见”才说了一半,那边“叭”的一声挂线。每当那时,她总感到刺耳的声音在空气中凝结成冰,划过自己的耳膜。她仿佛感到,新男友像一只断线的风筝,自己那无力的手总也牵不稳那根无望的线。　　　　　　终于有一天,女孩和他大吵了一架。男友很不耐烦的转身走了。女孩没有哭,似有一种解脱的感觉。　　　　一天,女孩又想起最初的男孩,心中涌起一份感动：那位听完她“再见“的傻男孩。这种感动让她慢慢拿起电话。　　　　男孩的声音依旧质朴,波澜不惊。女孩竟无语凝噎,慌忙中说了“再见”……　　　　这回女孩没有收线,一股莫名的情绪让她静静聆听电话那端的沉寂。　　　　不知过了多久,男孩的声音传了过来,你为什么不挂电话？　　　　女孩的嗓音涩涩的,为什么要我先挂呢？　　　　“习惯了。”男孩平静的说，“我喜欢你先挂电话,这样我才放心。”“可是后挂线的人总是有些遗憾和失落的”女孩的声音有些颤抖。　　　　“所以我宁愿把这份失落留给自己,只要你开心就好。”男孩说。　　　　女孩终于抑制不住哭了,滚烫的泪水浸湿了脑海中有关爱的记忆。她终于明白,没有耐心听完她最后一句话的人,不是她一生的守望者。原来爱情有时候就这么简单,一个守候,便能说', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1268', '2000', '昨晚做了个梦，影响了我今天的心情，我做梦时还对自己说，这是个梦，不要想的太多，呵呵，看来还是自己的心胸太小了。我梦到利民跟一个女人好了，那女人是个公务员，然后利民就跟我分手了。我想之所以做这样的梦，可能是因为我整天担心的原因吧！我在努力的调整自己的心态，让自己自信起来。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1269', '2000', '````天气好晴```晴的有点害怕```跟晴天相比``我还是喜欢乌云密布```也许有的人会说我比较不正常``但是``我真是怕了晴天```太阳那么大``把每个人显而易见的缺点都曝露在它怀抱的下面```有点淡淡的恐怖``就像``每次担心自己吃饭后会长胖`吃完后在用力把那些肚中的垃圾在吐出来``呵呵```我也知道比较不卫生``比较恶心``但我不得不```因为```怕吖`````怕自己的身上在出现那么多连累自己的肉``今天要上学去了```我每天真的是好忙```每天早上去了学校`中午放学回家吃饭后就要去学播音```播音下课后就要去学琴``有是时候走在路上我真的想把随身背着的琴砸的支离破碎``但是``我没有```我知道我没有勇气```我知道砸它后会相应付出的代价```那是沉痛的``没有人会了解`````不知道今后的今后能不能找到那个为他我可以放弃一切的人````我想找到一个``只要和他在一起失去一切都不可惜的人``可是```我18年了``还没有找的到``在过个18年``我还会有几个18年呢```昨天写的日记``有人留言了```不知道那为朋友是在职责我还是同情```我知道昨天的语气有点倔强``可是我不得不那样`````为一个不值得我为他付出的人失去我的一切``这样好不切合实际````我不是天使`我并不会飞``我要是可以飞``我会飞的很高很高```让任何人都找不到我````现在想想``妈妈没收手机的事情是很正确`的```我在也不用接任何人的电话了``在也听不到他们用各种各样的口气让我立刻赶到那里去了```在也不用为电话费的事情而发愁了``这样不好吗`?我喜欢这样``呵呵``我和他并不是两情相悦```最起码我不是这样``我不是有意的玩失踪``也不是不给他打电话``也不是他病了8天我一句都不关心``更不是在他上QQ的时候我便立刻隐身```也并不是听朋友们说他陪不上我`而是我累了``与要休息了````玩不起了``几次失败了```我没有办法想别人那坚强的爬起来```我已经心力交悴了```我要一个人```在过一个属于我自己的18年```', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1270', '2000', '呵呵``写日记了``换掉日记本了``我只是想在网上对那些我不认识不熟悉的朋友们分享我的每一份喜悦`每一份哀伤``纵使有人不屑于看这写垃圾玩意``但是我要在这里没有控制的释放我的感情```不知道这次换掉日记本后`心情会不会随着换掉``那个日记本承载了我多少思想``多少事情``而这个日记本却空空一片```那个日记本上还停留在老早老早以前S的事情上``而这个本上又不知道会是谁了``今天是我和L分的第10天了``呵呵``说句没心没肺的实在话``我一点都不想他``确实是没有任何感情了``呵呵``也许他还不是那个让我和他在一起失去一切都不可惜的人```可是``我真的是累了``让我到哪里找到那个让我为他失去一切都不可惜的人呢`?我好累``该找个地方停靠了``可是我知道没有人会搭救这一艘小小的极其不起眼的小船``呵呵``没人理解我``这么晚了``可我还在电脑桌旁一直盯着```爷爷奶奶都睡了``我想爸爸妈妈也一样吧```今天周末``明天就要回家了``我真是很讨厌家```一回家我就没有真正的自由可言了``到处都是可以束缚我的东西``把我的思想捆住``把我的自由捆住```这样四面楚歌的我``真的好希望有个人和我共同来分担我的忧愁``哀伤```可是```我始终都找不到', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1271', '2000', '翻开以前的英语书，偶然见看到了他给我的信，一下子，又回到从前，虽然偶尔忙碌一下，偶尔会吵架，但那时，在现在看来，真的好好！但是，时光不能倒流，不是吗？人又总要想前！现在想想，自己当时怎么那么不知足呢？一天中，都可以收到他的好几封信，却还嫌他写的内容不好，但是现在呢，早上，说个1，2句话，一天就在象陌生人一样擦肩而过的情况下过去，能不伤感吗？？时光总在流逝，人总在向前，一切都不可能回去了！只能珍惜现在了，或许以后回头想想，现在也很好！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1272', '2000', '......今天,你终于说出勒分手..我之前似乎做好勒⒈切准备,却不怎么的,眼泪不停的流不停的流..我似乎真的很难过..瞬间里,我想起勒从前..我们在⒈起的每个画面..不断不断的浮现..每天早上的声音,每天晚上的见面,每天我挽着你⒈起回家的路,每天我拥抱过你的地方..我不断的想起.你说的每⒈句话每⒈个字..发现,我是这样的在乎你..电话没有点勒,但我想要说的话⒈个字都还没有说出来,已经不再听到你的声音,好沮丧.!我们真的就这样结束勒吗.?我好不甘,我好舍不得,舍不得我们的爱,舍不得你那温暖的胸膛,舍不得你那可爱的脸,舍不得你那甜甜的笑..我是如此的在乎你,想你..从未有过的思恋,从未有过的失落,从未有过的心痛,⒈齐涌出..我真的很难过..你是否明白我不想离开还不想离开..不要这么决绝的否决我对你的爱..敏,只有有你的地方我才会快乐,你的离开,叫我如何笑的出来??叫我如何忍的住悲哀,伪装坚强.?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1273', '2000', '......今天中午我去勒他学校,去干什么.?给他我昨天写好的信,其实是想去见他,现在只要我能想到见他的理由我都不会放弃,我时刻都在想着他..我想我不能放弃..晚上,他发来短信,问我在干嘛..我想去接他,可他说他找勒女朋友勒,他等下跟她⒈起回家.!这⒈秒,我失去知觉,真的好想不再醒来..他不顾我的等待,就这样跟着别人离开..我很失望,我完全失去勒信心,我不再有力量,我彻底崩溃,但我之前为何还要逞强?为何还要告诉他我不会放弃.?那是因为我真的在乎,真的想..算勒吧,不强求勒,就这样就这样,静静的等待,傻傻的等待,等他回来..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1274', '2000', '\"......你依然没有对我淡然,你依然对我犹如从前.!这让我又升起勒希望,让我不禁又想问你.我真的没有⒈点机会勒吗.?我真的彻底的失败勒吗.?但你回答的是我不想要的答案,我失落的回答勒噢,可你说是很\"\"聪明\'呵呵..你让我明天去你们学校,但你又告诉我她也会去,我不想去..但真的好想见你..我真的不想离开,就这样,紧紧的抱着你..永远停留在这⒈秒..明天我去,只想问你,我还有那0.1的机会吗.?不管你的回答怎样,我都不会放弃.只要努力勒,结果如何又怎样呢.?\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1275', '2000', '......周钟敏,我现在真滴有蛮恨你勒,?你怎么可以这样??你到底想怎样.?今天去你学校,我有意的逃避,那是因为我不想让自己失态.!但在开门的那瞬间里,你说饱⒈下,我真的很开心..中午,我们相处的很好,不像有过伤痕的情侣,我真的好希望就这样⒈直下去..她跟你发短信,像我从前叫你⒈样叫你,我真的很想走.我没有到我口口声声的说不放弃,没有想到到勒关键时刻我还是选择勒逃避..我没有想到你会这样,接到她的短信,就仿佛变勒个人,而我就不再有勇气再战下去,看到你这样对我,我完全失去勒力量,仿佛在你脸上看到勒结束.我真的不想离开..我是多么想多么想告诉你,我在乎你,我不想离开你,我不想放弃你.可你不再给我机会..我让你别送勒,但我心里又是多么的希望你⒈直陪在我身边,我最后头也不回的说再见然后离开,那是因为我不想让你看见我的眼泪,我是多么想让你看见我坚强的⒈面.我从你身边走的那⒈刻眼泪又不争气的掉勒下来,我真的不想离开,你怎么可以这样./??你为何总不能明白我是多么的在乎你.??!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1276', '2000', '这是不是迷失了方向..?真的不知道自己该怎么做?为了什么?乞求的是什么?孤独..空虚..寂寞!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1277', '2000', '今天我在你的眼中找不到我勒，你真的不爱我勒，我失去勒方向..别人告诉我在城市看到你和她在⒈起.我很难过.我想我不再有希望.算勒吧,现在还有什么能让我产生力量,坚持下去,我想没有勒吧,这是不是迷失了方向..?真的不知道自己该怎么做?为了什么?乞求的是什么?孤独..空虚..寂寞!你都这样,我到底还到强求些什么呢.?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1278', '2000', '时间如流水，这些年来。我一直在等他说那几个字，然而他什么也没说。每当我想放弃是，他又来找我，现在心里好郁闷，不知道该放还是等。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1279', '2000', '告别白天的喧嚣和无聊，走进静谧的夜里，夜幕降临。今夜，我又想你了。想你的时候，你就像坐在我身边和我一起聊天~告别白天的喧嚣和无聊，走进静谧的夜里，夜幕降临。今夜，我又想你了。想你的时候，你就像坐在我身边和我一起聊天。想你的时候，沉浮不定的思绪会再一次将我带到旧地重游.....今夜，我又坐在屏幕前，打开QQ听着那伤感的音乐，就仿佛走进了另一种人生，情感随着那忧伤的旋律放荡着，挥着。失落占据了我心灵的每一处空间~亲爱的，我有好多好多的话想对你说，你愿听吗？我有好多好多的泪，你愿为我流吗？积攒在心中的痛你愿与我一起分担吗？你的微笑，想你的温柔，想你的坚强!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1280', '2000', '在我身边一直围绕着一个话题：爱情与面包哪个更重要？我毫不忧郁的选择了爱情!而我却被许多人说成了笨蛋!!爱一个人，要了解，也要开解。要道歉，也要道谢。要认错，也要改错；要体贴，也要体谅。是接受，而不是忍受；是宽容，而不是纵容；是支持，而不是支配；是慰问，而不是质问；是倾诉，而不是控诉；是难忘，而不是遗忘；是彼此交流，而不是凡事交待；是为对方默默祈求，而不是向对方诸多要求。可以浪漫，但不要浪费；可以随时牵手，但不要随便分手!我想我是个感性的人吧，总是为了感情而累。找不到解决的办法，却只会让自己难过。很希望有人可以帮我，但总找不到可以倾诉的人，烦呀！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1281', '2000', '呵呵...郁闷,是冤家路窄么?还是缘分.?呵呵..我们都分开那么久了.竟然在乌鲁木齐见到你!1年多过去了..你还能把我认出来..你还是那么漂亮..还是那么可爱...但是我们都成熟了.看见你.我心里面感到很内疚..当时对你做过的一切..对不起阿..你笑着问我.你是郑仪昆么?那时候我看见是你..呵呵..怎么形容..无名的感觉..亲切?我们坐在餐厅聊那么久.你没有提过分手以后的事情.我也没好意思去问你...对不起..那时候我真的很过分!一声不留的丢下你..不负责任..从此也再没跟你联系过..你是怎么想的?你一定受了很多苦...对不起...阳阳.对不起..真的很对不起..在我们坐下的时候.我真的不知道自己该怎么说..你?还那么顾虑着.不跟我提当时我的错.如果你给我一巴掌也许我会舒服一点.但是你没有..你微笑着.问我最近怎么样...i\'msorry...阳阳', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1282', '2000', '从新做人.责任感..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1283', '2000', '想的太多.自己伤心,看的太明白,心里比谁都清楚,原来这样不要简单,心有些痛,我痛什么,就是爱,其实我不坚强,我很软弱,我最了解自己,没有谁比自己要了解自己,偶的眼泪不知不觉的往下流,我我我我我,,我想问自己我是怎么了,我为什么这么害怕,我我我....开心的时候笑容是多么的甜,多么的灿烂,我不愿让我现在的开心,失去,我的世界从那⒈天看见你,认识你,我就在害怕,就是因为爱,所以让我当心,我不想对他说,这是偶唯一的秘密,我是真的害怕未来,我害怕他原来的哪个她不会忘记他,不会放弃他,我害怕,我真的害怕,我相信他不会忘记他们之间的一切,我也不知道,我是否有我要的幸福,我在想如果没有,我宁愿我们没有相遇过,因为给了我快乐开心,留下的痛苦的回忆,将是我一辈子,我好想好想能和他有美好的结局,而不是残酷的结局,唯一的希望,唯一的爱,这一辈子不管怎么样,我知道我自己已经认定了,我谁都不要,就算以后真的没有你,我一样还是那样不变,没有谁可以改变,因为这是我对自己的承若,我说过一辈子不变,我就不变,时间去证明,身边的人都可以为我证明,我是真的爱勒,我是真的要付出,不管有多难,我都会去做!眼泪是值得的,因为我是真的爱他,!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1284', '2000', '来吧自己还是有余地得..很能干得.别那么堕落嘛.!加油阿..!!⒕', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1285', '2000', '上天总是让人在今生惦记着前生，在死去又忘记今生。缘分这东西到底是前生的再续，还是上天安排的一场游戏。爱情有着和地球一样的力量，人永远也逃不出的引力，她会紧紧的抓住我们的灵魂，每个人爱着自己，也牵挂着自己，牵挂着抓住我灵魂的另一端，找回她，生命才算完整，找回她，就不再让与她分离。一直都在寻找着，寻找着那份安心，寻找着那份温柔。她是一朵雪花，洁净的让人除了她就什么都不会有了。等我看到她的时候，我总是比她慢，而却她总是喜欢走的那么的快，让你怎么也追不上她。我看着她，看这她每天留下的每一点每一滴，希望知道他的轨迹，然后在找一个地方静静等着她。当她与我对面，我却发现，我已经是一架断掉翅膀的飞机，失去了一切可以控制自己的知觉。我只能在心里一遍一遍的说着：爱你！我爱你！我真的爱你！爱着你，而我却忘了怎么去做。当你走过我的身旁，我真的很想很想——紧紧的抓住你的手，不让你离开。可是，怕你是一片脆弱的玻璃，碰一下就碎了。当你从我的视线慢慢的消失，我真的很想很想——追上去，对你说声——我爱你。但我不能，怕你是一朵雪花落到手心就化了！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1286', '2000', '昨天的心情是会不好,现在我好多勒,我不在去发宝气了,这样自己也不快乐也不开心,不管怎么样,我会慢慢学会坚强的,我的朋友讲的对哦,只要我珍惜了,不怕以后我会后悔,我用了心去爱,去做我需要做的每⒈件事,猪宝贝懂了,我是很在乎他,就是我在乎才是对的,有了他我真的好幸福,我感觉到了我的幸福,我现在已经很满足了,没有什么让我又去不开心的,虽然讲每个人都有过去,也不需要在去想过去的事情勒.!已经过去了,也没有什么去好想的,有些回忆要忘记,有些要记住,!昨天晚上想了好多,每⒈为我好的朋友都很了解我的感情,都说我好傻,想这么多,讲我这样也是对的,因为爱他,才这样,意思就是很爱很爱他所以才这样,我愿意做所有我能做的事情.!爱他就用心的去爱,相信我能行的,我们也能幸福!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1287', '2000', '我会努力的,', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1288', '2000', '\"那是我初三毕业的一个夏天,暑假的炎热让我感觉透不过气!今天是个重要的日子,我约好了月在我弟家见面,以前我只是在电话里跟她聊天,这下能好好看看我这位\"\"电话情人\"\"了,嘿嘿..我早早的来到我弟家,把准备工作多做好,形象是最总要的,下午大概2点多她来了,我刚看她就感觉她很小,但又带点坏坏的味道,然后我把我弟叫出去,我跟月在里面房里聊天,用我事先准备好的计划,嘿嘿..开始聊着,然后进入正题,我先叫她闭上眼睛,我会给她个惊喜,让她数10声,她照做,1..2..3..4..5..到这个时候我的亲了她一下,就这样我的初吻就这样送了,当时她没有反抗,脸红的发烫,从那个时候起,我和她正式在一起!我感觉这个坏坏的小女生特有意思.之后....!\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1289', '2000', '\"这是我进入高中的新学校,郴州市二中..我跟月的暑假\"\"蜜月\"\"过玩了,呵呵.可惜的是,月比我小一界,要不她也可以跟我一个学校,暑假的时候我带他去游泳,她还不是很会游泳,我要带着她穿过那条小河,开始还没事,到了中间的时候,差点我们两个都一起掉了下去,我用尽了全身力气拼命的游,终于带着她过了那条河,呵呵.到最后她还问我累不累,我满口假话的说我不累,还撑的住,其实我已经接不上下口气了,不过开始的时候倒是吓死我了,万一我也不行怎么办?那我下文就没法写了.开学了,新的生活又开始了,每天晚上我们还是不段的通电话,一聊就是半个多小时,到一个小时,虽然心里觉得电话费哪交的起咯,但是还是坚持每天晚上跟她打电话,每天早上呢,我是个最不爱起早床的人,但是为了跟她有多点时间再一起,每天6点钟就起来了,在家弄清楚后,准时6点半在他们学校等她,陪她吃早餐,她每天早上都是做他们厂里车出来,一下车就看见她蹦蹦跳跳的跑过来,小小的身体就像一阵风就能把她吹倒一样,我现在也不知道到底喜欢她什么,是可爱?还是有点带坏坏的女人味,我自己都说不清楚,只觉得跟她在一起很开心,每天中午我们都约在一个\"\"厕所\"\"旁见面,那时候我有时带盒饭打包给他吃,有时却跟她一起去他们学校吃饭,我那时真的感觉很对不起她,让她受委屈了,但是她也没有半句怨言,我是我觉得我欠她的..我喜欢带着她,去公园散步,....我觉得很浪漫,那也是我最开心的时候,这也是我第一次感觉恋爱的甜蜜,而我又觉得中午的1两个小时不够,我想要的是一生一世,月你都能陪我就这样安安静静的走下去...!!!!!但是没有我想的那么完美,我高二的时候月去了衡阳..........\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1290', '2000', '那天晚上,我跟月一起坐火车去长沙找孙玩,也可以说她带我去见她玩的最好的朋友...(就差没见家长了)嘿嘿...我们哪天晚上买的晚上的车票,我从家拿了点东西就出来了,那时真是累着她了,第一次和她出远门,坐那么久的车,我都没给她补卧铺,让她一直坐到长沙,那时候觉得没什么,但是现在想想觉得很狼狈..一路上我们说说笑笑,但是到了凌晨,她就要睡觉了,呵呵..真是个小猪..我就一个晚上看着她睡觉,她像一个从来不管事的小孩..睡就是了,天塌下来她也不会管,我还记得她那小脚,真是可爱到了极点的还过去点点..我就一个晚上这样的看着她,我们早上5点多才到长沙,天还没亮,我们一出火车站,就有好多人来问:先生住宿吧?..其实我那时也没试过一个人出门,我觉得只要我带着她我就什么都不怕了,我拉着月就走,没理那些人,我们走了一段路找了一个招待所住下,我跟月住在一起,想起来就兴奋..呵呵..!~第二天,孙来接我们了,还带着他的一个朋友,我们到通城去玩了鬼屋,吃了kfc..好多好多...鬼屋的时候,月连睁开眼的勇气都没有,从进去到出来都一直拖着我,呵呵..我也很怕,还好峰带着我们冲了出去,出来的时候喉咙都叫嘶了,月出来的时候脸色都变了,晚上还吓的不敢睡觉..现在如果要我去玩,我还是怕..好恐怖啊..回来的时候他们送我们两个上车..到家后,我爸妈来接的我们,那是月第一次在我们家睡..但是不是跟我睡,她跟我妈睡.!长沙一游又争进了我们之间的感情..我愿意就这样一路照顾着你走下去.!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1291', '2000', '这天是我最好的朋友开演唱会.我带着月来到了,他们的舞台..!这天是月第一次陪我晚上出来玩通宵..平时在家她都是个乖宝宝..9点半以前就要睡觉了.但是比我好咯,我小的时候再家有时看完新闻就洗澡睡觉了...看不出吧.哈哈。..!!这天晚上看他们精彩的表演.月很高兴,所以我从那次以后,我也要学吉他,但是我也只会表演给月一个人看,因为我已经明白她是我心中的angle..她的快乐就是我给自己最大的幸福..看完后,我朋友他们搞庆功宴.叫我们块去了,一直到11点多..之后大家就自由活动了,我跟月一直散步到了苏仙游园.我背着她走,一直都河边,我抱着她亲吻了一下她的额头..对她说我会爱她一生一世,她.....!!!!!之后我带着她去了文化路的一家叫柿竹园的招待所住了下来..之后............这就是月陪我的第一次通宵..!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1292', '2000', '高二时月去了衡阳..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1293', '2000', '一年后.....月为了我回来了..!我这时都高三了..在这一年中我做了很多让月不开心的事..甚至让她感觉对我的失望..这都是我一手弄成的,只要月你还在我身边,你给我多大的惩罚我觉得都是应该的,以前我所做的事,我会用我以后的时间好好的照顾你..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..对不起..!!!!!!!现在你让我也尝受到以前你在衡阳的苦,我现在能够体会出你离开家的感受,一切都怪我,一直没有好好的陪在你身边,我把我们这几年开心的事都记了下来..以前的事过去了就都别题了,我想为了我们的将来,让我们安安静静的走下去好吗?你还记得我们那句话吗?你不变心,我不变', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1294', '2000', '今天不好，是我埃饿的日子直到现在我还一口饭都没有吃呢，很惨的，真不知道今天是怎么稿的，不过心里还是好受的，找亲人，可是他们又搬家了，走了那么长的路脚都走酸了，还是扑了一场空，唉，今晚要饿肚子了', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1295', '2000', '傑倫的新專輯終于齣來暸.不負衆望,真的好好聽.髮如雪寫齣暸前世今生的緣分,好感慨!真的有前世今生?...??如果有.我希望下輩子還能遇到哥哥..繼續當他的好妹妹哦!倖福死暸..夜麯紀唸暸死去的愛情,好感動男主人公對愛情的執着和付齣.我的愛情能這么可歌可泣嗎?楓寫齣暸思唸.無論是愛情還是親情還是友誼的思唸,都能感受到一種深深的悲傷.....還有好多好多歌都好好聽.麥芽糖和浪漫手機好溫馨,可惜我現在的心情好差!總之心情好的時候,傑倫的歌總讓我更高興,心情壞的時候,傑倫的歌永遠是心頭深深的安慰!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1296', '2000', '今天下雪了,地上白白的一片，雪花懒散的飘着，已经是冬天了呀，看到这场面不禁想到了我的老家……因为并不是什么很大的雪，所以也没什么可以玩的，我只是跑到楼下，用树枝在雪上写着老家的名字，再把他们扔出去，希望他们能够飘到老家，让朋友们看到……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1297', '2000', '我在担心的事情真的现实了,真的没有错,她不会放弃猪,今天上网看到了她对猪的留言,我心里很明白了,我想的⒈切的⒈切都是对的,没有错,是女人都不会忘记,因为她没有打算放弃,她还在执着,等待,我也不会害怕,因为我在前几天就为自己想好了,我应该怎样去面对,怎样去做,决定是猪的决定,想法是猪的想法,⒈切都是猪,我只要不给猪增加负担就可以勒,在这个时候最累的是他,我不想看见他不快乐,感情的事情就是这样,就算我只是仅仅和猪在一起的时间不长,比不过他们原来几年的感情,但我晓得我明白就可以了,我身边的朋友说的对,我懂的珍惜,我真心爱过他,没有对不起他,就可以了,他们说,是我的就是我,不是我的,我也不会去强求,好还是不好,猪清楚,猪知道去怎么选择,怎么去做,我相信他不愿意伤害我,也不想去伤害她,!谁都不愿意伤害谁,但要面对眼前的事实,!阳光总在风雨后,珍惜所以的感动,!为什么有时候他们会说我好傻,总在想别人的心里会怎么想,会受伤,总不想想自己也在受伤,!可我习惯这样想,我没有办法是改变,也许我就是这么傻,难怪讲我傻的可爱,说我太单纯,受伤总是,是自己,快乐的是别人,我不这样觉,有时候我觉的难免总有伤心的时候,伤过后,我一样的会开心的啊!因为有朋友对我支持,!他们晓得我做的是对的!哪天我的不开心也是因为我想这件事情,没有想到今天上网还真的给我看见了她对你留的言,所以我明白了,她是真的放不下你，她要坚持等你,爱你,!不放弃你!那时你打了电话给我,问我,又有什么不高兴,那天我是好矛盾,我自己也不晓得怎么去想,我不晓得问还是不问,但我没想到今天..........还是会这样哦!想要好好爱⒈个人,难的很难没有错,我相信,但我更相信,是爱就不怕失去你!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1298', '2000', '今天是这样度过的，不好也不坏，早上我也没有吃饭因为没有钱呀，很惨的说起来也有一天没有吃饭了吧，中午借到了钱，一天这样没有情绪的度过了不过我做的还是不够好，还是那句话，我还是会努力的', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1299', '2000', '明天早上要去旅游了，不知要去的地方会不会好玩些，我想照些好看的照片回来，明天看看吧，不知道会不会很累。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1300', '2000', '终于找到可以写日记的网页了。想想过去用手写日记的5年时间里。和现在的方法比呵总觉得升级了。我离开家在他乡已有3年现在在浙江开了家网吧生活和事业总算有点动力。更感谢认识了些我这辈子都忘不了朋友。当然有开心就有伤心。刚到这里我一无所有但是我认识了她。本也想谈谈玩可是经过一年的时间她深深在我的心理了当她有天分手的时候我做的汽车去追她的火车我知道这样做是枉然的可是我还是。。。。最后我终于明白她分手的原因。很简单在她的心理金钱永远排第一感情永远只是游戏。据她朋友回报她现在在美容院做小姐~唉~钱难道对她这么重要？算了往事总是那么伤感。我现在只想做好我的事业过好我的生活。', '我们的爱已经结束了，昨天的风景就这样成为我生命中的一个符号，刻画在我的内心深处。败笔是经典的衬托，映出内心的天空。我不想在想念梦中的美景，那只是彩虹刻画的天空，稍纵即逝。现实和虚幻之间总有一场美梦，来来往往的人穿梭在其中。<BR>      今天，我的梦已经醒来，虽然现在看到的好是夜空，当至少还有灵魂在，可以给我勇气去冲，<BR>       有时，梦想与现实的差距不只是一线之隔，我在无谓的困惑中挣扎，寻找一个貌似真理的答案，或可以在理想的爱情梦境中幸福的死去，如果那能算幸福。<BR>       我相信', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1301', '2000', '我现在可不要为吃饭和住房发愁了。可是我却要为事业烦恼+奋斗。我知道干事业没那么好做的万事开头更难。所以我想在我困惑受伤烦恼迷茫的时候有个人倾诉有人相陪有人安慰有人在乎。。可是却没有。我不知道是我做人失败到了极点还是我没用过心去爱。如果我问我自己我可以说我想对每个女朋友说我爱你我真的爱你但是到最后这句话就是显得那么的无力不管我什么时候说出来好象这句话已经被人认为是虚伪谎言巧语。真不知道是现实的残酷。还是我的无能。好象找个人来爱或被爱。我现在过的很孤单和无助。感谢上天给了我现在身边的这些朋友我好想你再给我个爱人。我真的很痛恨我自己的过去。我的过去是黑暗的根本是一段不可揭开的往事虽然事已翩然过去。但是阴影还留在我的心理。不过这对也是种警告。让我时刻记住你要前进不能活着过去的世界里这些话看起来有点堂而惶之。可是却是我内心世界的真实想法。我起名叫新开始可是想有新的开始谈何容易。忘记本就是件很难做到的事情我不是圣人更不是什么特殊的人我只是个平凡的人却有颗不平凡的心我不知道我不安份守己的努力做事业到底对不对不管事的成功与失败最起码我没想过害谁去伤害谁人们却总把贫与富做为衡量标准', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1302', '2000', '好吧,从今天开始我不去想这些勒,从现在开始让我的伤心从此雨过天晴,好好珍惜我们彼此的爱,我不在管她了,我们一起打造我们的未来,不会因为她而让我们不开心,猪我相信你,!猪宝贝永远爱你!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1303', '2000', '《女孩心疼男孩的十种方式。》1、当你爱上一个男孩，千万别去想自己是不是应该矜持一点。爱他就告诉他，有时候男孩也很爱虚荣，你的表白会让他的自信达到顶点。　　　　2、当你已经不爱他了，那么也用最直接的方式告诉他。别去考虑他会不会脆弱，男孩的自尊远比伤痛重要。　　3、当你们已经相爱，那么就要对他信任，有什么想法就告诉他，不管他支持不支持。任何一个男孩都希望他的女人依赖他。　　4、在他的朋友面前，要给他十足的地位。面子对男孩来说比什么都重要，不要介意在人前当个小女人，要知道小女人都是男孩宠出来的。　　　　5、他在打游戏的时候，不论你有多急的事情，也不要直接去关他的电脑。最好是搂着他，在他耳边轻轻的细语。因为男孩对游戏的执迷胜过你看一部精彩的肥皂剧。　　6、男孩每个月也有那几天，跟女人差不多，心情无故低落。这个时候不要问他怎么了，只要陪在他身边。做好你自己。　　7、他和朋友出去喝酒、打牌，你不要问他为什么不带你一块前往。男孩都愿意做风筝，只要线还在你手里，那么就放他去飞吧。　　8、男孩都很懒很笨，尽管他爱你，但是不想费尽心丝讨好你，你所能做的就是在适当的时候给他个明示。男孩有时候需要女人给他强有力的当头一棒。　　9、男孩不管他外表有多强大，但是骨子里都还是一个孩子。他在任性的时候不要对他大吼大叫，这对他不起做用。最有效的办法是陪他一起疯。等他平静后轻轻的告诉他你很爱他。10、男孩都是不肯认错的，在他知道错的时候给他一个台阶下。他会知恩图报的。　　体谅一个男孩，那就是把他当成你的爱人、情人、哥哥、朋友、父亲、孩子。爱他，不要给他负担，给他自由，给自己自由。做女人要知道什么时候该进什么时候该退。什么时候该挡在他的前面；什么时候该躲在他身后。　把他当成你自己一样去爱护，成全了他的幸福，他才会成全你的幸福！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1304', '2000', '呵呵...昨天去了趟昌吉!终于见到了新星..就好象回到了阿克苏.回到了原来那愉快的日子.在感情上没有伤害.感觉很亲切..很可靠!我永远忘不了你们!>...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1305', '2000', '我的心真的烦。。。真的不知道选择什么才重要。我左想右想想来想去结果把自己困在一个不可自越的圈子。我很想跳出来让自己安静的想想我到底该怎么做才是最好的可是机会和把握成比例吗？爱和不爱可以成比例吗？哪个从前的和现在的我是否真的能被爱或勇敢去爱我想和普通人一样深爱着她她也深爱着我感情生活这应该不算什么奢侈的今天是05年12月7号。美好的一天是从今天我才感觉到。因为我知道什么我自己的存在知道自己还活着很感谢上天让我的生命中还有如此灿烂的日子我不知道我对她是不是真的很重要但是我自己的内心世界告诉我你爱上了她如果她能感觉到我愿意为她付出我所有的爱我在这里向所有你们知道我的人和神来做个见证我的爱能不能让我达成我只知道我要努力让我们在一起。可是我不知道她真的爱我吗？在乎我吗？愿意和我一起共渡这生吗？我现在真的很痛苦很困惑我真的爱她', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1306', '2000', '我又想你了啊你说怎么办啊我活不下去了啊我不想活了啊,你要是不来的话我要死了啊money', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1307', '2000', '刚刚破了他的密码.看到了他的日记.里面是我。.是我.全是我.原来在他心里面住着的那个我是那么完美.,而我呢.老是因为他的一点不在乎而发脾气.虽然明明知道是不对的.可是却老忍不住发他脾气.随便他怎么权我我也不听.老让他气的讲不出话来才慢慢的好起来.每次都是.不管是我是他的错.只要我发脾气.都是他来和解.为什么我好胜的心这么强.就连一点小事也不肯低头.!为什么.为什么我会变成这样.以前的我是那么大方.为什么跟他在一起以后.就这么小气了呢.?就是一小会的不在乎我都那么的生气呢。.?就那么一句话记不得了我都会想骂他..?明明是我的不对,却要让他向我道歉.为什么.这到底是为什么.?我觉得和他心里面的那个我比起来.我真的差远了..差远了.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1308', '2000', '有一个月没有写过日记了，今天突然想到了这里，就随便来写点什么。昨天侄女过周岁生日，喝了很多酒，但心里却没有一点的高兴。今天早上醒来，心里同样是失落。与楂楂已经吵架四个月了。我讨厌现在的自己，讨厌现在的生活………………', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1309', '2000', '又是这样度过了一天，或许对于现实并没有任何意义而言。但是……除了这样我还能怎样~~虽然人人都想生活能丰富而多彩,幸福而美满，可是……对于这些，我都只能无言。我心情很是伤心,今天打了楂楂几个电话,她都没接,心如刀割!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1310', '2000', '......新鲜感这个词似乎是很新鲜..但这样⒈味滴追求新鲜感是正确滴.?不晓得这些人是怎么想滴,是真滴在追求新鲜感还是把它当个幌子当个借口列??我想也只不过就是挡箭牌吧,真滴是杂好借口..离开用这个理由是蛮好噢,比较新颖..哈,新鲜感,慌缪、.!难道到⒈起也要时时新鲜吗/?那还恋爱怎么.??竟然厌倦的这么快变的这么快就不要这样.!挨,!(希望他跟她滴诺言得到好滴结局)', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1311', '2000', '好想找个人陪，但毕竟是幻想。好象写点伤心的诗歌，但思绪又是那么的乱。以前那么风光的自己，现在也忍不住伤心!还记得以前是楂楂一直在我的身边陪我，今天呢，只有我陪电脑了。感情的事情到现在都还弄不明白，反正爱与不爱都是在做梦，为何当时不虚伪的把梦做完呢？到现在一直后悔自己所做的种种错误，希望年轻的人不要再象我一样，等失去了，才知道后悔，才知道自己错过了美好！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1312', '2000', '一样的重复着昨天的生活，而现实带给我的只是失落或者失落后的埋怨。我不明白自己为何堕落成了这个样子，明明知道自己以后的路还很长，却想尽一切办法的去逃避，去厌世。花一样的青春，却有着噩梦一般的生活；梦幻般的起点，却也挡不住花谢的厄运。回首自己这些年来走过的道路，却总是被别人搀扶着行走的足迹。因而到现在才明白，自己原来是一无所有。自卑的心再也掩饰不住失落的情愫，就好象自己置身于一片广阔的大海，望着太阳升起的地方，却总也找不到归航的路。楂楂,你问我爱你有多深?我爱你有几分?月亮代表我的心!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1313', '2000', '本来以为自己什么都可以忘记了，但还是不经意间想起两个人在一起时的快乐、痛苦。突然间，也喜欢上自己做梦的感觉，梦里常有她的伴随。至于她的容貌，我现在还是记忆犹新，和她在一起的那些的快乐的抑或是痛苦的瞬间，给我的却是心灵上的安慰和失意的悲凄。自己常对自己说，那只是一个故事，一个永远都不能圆满的童话，而每当想到这里，自己又是那么的伤心。真的不知道，那样一段经历，那样一段辛酸的爱情，在自己漫长的人生里自己给她一个什么样子的定义。我和她之间的距离越来越远，她一直不肯接我的电话,但是为何现在想起和她曾经发生的那段故事，却又是那样的熟悉，那样的不忍心放弃。好后悔和她分手，但这一切有怨得了谁呢？都是自己酿制的苦果，所有的都只能让自己承担。自己是越发的伤心了，越来越不能控制自己的情绪了，真的好想有一天她又能重新来到我的身边，但我知道，她是一直深爱着的人！失去以后才知道珍惜，人为什么都这么贱呢，我又为何和他们一样呢？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1314', '2000', '有人说，世界上没有一个女人值得我为她哭泣，唯一一个值得我为她哭泣的人也不会让我哭泣。是这样吗？有时候想到这句话，真的觉得好经典。但是生活毕竟是生活，有时候很多事情不能像我们想的那样！我常常把自己关在自己狭小的宿舍里，没有头绪的想一些乱七八糟的事情！那样真的有意义吗？爱的人不属于自己，自己便会伤心；不爱你的人硬要和自己在一起，她和自己也会痛苦！生活的繁杂让我们时常面对的不同的选择。有人用痛苦一生诠释着生活的落魄，也有人用无所事事虚度着自己的生活！而我呢？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1315', '2000', '生活中有很多感动那一瞬间心里非常不平静，未来是美好，好像用眼睛就可以看到未来其实不是那样的，还是那句话活在今天，人，是要快快乐乐度一生的', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1316', '2000', '[COLOR=#fff8dc', '今天无聊透顶了,突然听到了这么一首歌,听起来有点心声共鸣,这首就是《很爱很爱你》：为你做件事让你更快乐的事/好在你的心中埋下我的名字/求时间趁着你不注意的时候/悄悄地把这种子酿成果实/我想她的确是更适合你的女子/我太不够温柔优雅成熟懂事/如果我退回好朋友的位置/你也就不再需要为难成这样子/看着她走向你/那幅画面多美丽/如果我会哭泣也是因为欢喜/地球上两个人能相遇不容易/作不成你的朋友我仍感激/很爱很爱你/所以愿意舍得让你往更多幸福的地方飞去/很爱很爱你/只有让你拥有爱情我才安心！希望有情人终成眷属！[/c', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1317', '2000', '她一次又一次不接我的电话。是的，我明白她有很多理由不接，但我总是无可避免地感到失望。假如我在她心里是重要的，难道就连一个电话也不接吗？她既然舍得让我失望，她其实并可以失去我。两个人走在一起的时候，总是会对对方很有期望，总是以为对方跟自己的想法很接近。然后，便难免一次又一次的感到失望。为什么她会这样对我？为什么她会这样做？为什么她一点也不珍惜我？当我们发现自己让对方感到失望时，我们总是对自己说：“下一次，我会尽量不让他失望。”我们常常以为还有很多时间，还有很多机会去补偿，却不知道，对方已经绝望了。绝望的一刻，爱也随之消逝。都成往事了，无法再挽回！我很是伤心！！！但我永不言再见！~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1318', '2000', '不知不觉过去很长时间了，本以为我已经将你忘了，可是我不能欺骗我自己，我知道伤了你很深，那时因为我爱你很深，爱之深恨之切，原谅我。我知道，有很多事过去了，是不可能挽回的，但是，每当夜深人静的时候，我想起你的时候，我的心刀割一样的痛，觉得我做过太多对不起你的事了，伤了你那么深，我自己也不好受。以前我爱你，却不知道怎么去爱你，爱变成了伤害，直到错过了才后悔。可是一切都晚了，是不是？现在心中真的平静了，经过这几个月，我又经历了很多事，这些事给我的打击，不亚于当时你说不爱我时对我的打击，经历着这些痛苦，苦却只能自己品尝，泪也只能往自己心里咽，没人去诉说，想起你这个朋友（起码是曾经的）心里很不是滋味，都说大学是一个小社会，我现在彻底相信了，过去的朋友很是令人怀念，过去的日子也总是显得那么美好。我知道，你也不能将我忘记，是不是？或许这也是我痴人说梦话吧！因为过去的生活对我们来说是那么难忘。毕竟我们一起走过了风风雨雨。现在的我，对爱情已不奢求，因为这个传说中最美丽的东西，伤过我太多太多次了，我的心麻木了，累了。我试着将你忘记，但你在我心中的地位是无人能取代的，我真的无法忘记你。我仍旧受着思念的煎熬，心中仍在把你挂念。你的身影，你的声音，你的天真的笑声一次又一次地出现在我的面前，还是那么亲切、美丽，但却无法亲近，海市蜃楼般，能看到，却怎么也不能接近，就想梦一样，明明在眼前，伸手去抓却知道这些只是幻影，时时只有痛苦陪伴着我,我不停的忏悔,不停的责骂自己,知道这些试徒劳无功的,可是我想减轻自己因伤害你而给我带来的痛苦。　　楂，我真的，真的，真的很爱你！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1319', '2000', '我觉得,我在堕落..我的灵魂早已离开身体..我的灵魂呢.?去哪勒.?为什么它不回来..灵魂的背叛..我仿佛掉进一个深渊..我的身体在不停的往下掉..爱呢.?他呢.?消失勒..我知道..当一个人要离开你时..那么.只代表.你和他的缘分..已经到勒尽头..永远不再可能...现在的我,像一具行尸走肉..没有灵魂..只有躯体机械般走动.无奈..失落..我又能做什么.?当我觉得这个世界..已经完全把我拒之门外的时候..我想去挽留..但是,我没有办法...现在,我只知道..我的灵魂..已经不知去向勒..灵魂的背叛...我在堕落...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1320', '2000', '爱...走勒...我爱的他..已经走勒...但,我无能为力..我没有想挽留..因为,对于现在的我来说..已经没有任何意义勒..好想哭..但是..我却不能..我不能在他们面前哭..如果,我哭勒..那么,我就彻底输勒..我不会去挽留..因为我知道..勉强的爱情.不会有幸福..如果他要走..那么,就让他走吧..或许.离开对我们都好...在他走的那一刻..我的心,也随之而去..现在,成勒一个无心之人..所有的知觉..已经消失...无所谓勒..反正已经这样勒..我的灵魂也早已经背叛我自己..所以,没有必要勒...走吧,走吧..都走吧..不要再理我..任何人都不要再理我.就当我没有存在过..我已消失...', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1321', '2000', '黑夜如此辽阔记忆笼罩着我就像那长长影子跟着我何时停止飘泊害怕自己流浪太久遗忘的旧伤口仍然活在寂寞的窝当你寂寞时候最后才来找我谁教我从一开始就接受贪图你的温柔再度陷入感情漩涡没有人能解救任凭所有一错再错我不是局外人不要忽视我的认真是我软弱让自己与别人分享你的温柔我不是局外人不想再做个游戏的灵魂是否可以问问你真爱我有几分　当你寂寞时候最后才来找我谁教我从一开始就接受贪图你的温柔再度陷入感情漩涡没有人能解救任凭所有一错再错我不是局外人不要忽视我的认真是我软弱让自己与别人分享你的温柔我不是局外人不想再做个游戏的灵魂是否可以问问你真爱我有几分我不是局外人不要忽视我的认真是我软弱让自己与别人分享你的温柔我不是局外人不想再做个游戏的灵魂是否可以问问你真爱我有几分', '<font color=#ff7f50>今天刚注册了一个日记本，来看看好用不。<img src=../e/plugins/bz/2.gif border=0 align=middle></font></marquee>', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1322', '2000', '昨晚在电话里跟利民吵了架，所以怎么都睡不着，半夜三点起来喝了些酒，就喝晕了，今天一天头都很痛，以后再不喝了！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1323', '2000', '我不配拥有爱情.爱情,我根本没资格拥有..更何况要别人来爱?我的爱情已经走勒..完全走出我的生命..在以后的人生..我将默默的流浪..流浪,是因为心飘浮不定..当我在某个地方停留时.或许在那里,我会找到.另外一份爱情.但..我不会去爱别人..别人要爱,我管不着..但是,我已丧失爱人的资格..爱已去,心已碎..但愿你以后能好好保重..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1324', '2000', '在这个深夜..我好想他..我好想回家..我好想..好想哭..我以为他会上网..可是,我等到2点..我仍然没有看到他的身影..或许,我们的爱情真的走到尽头勒..算勒,我早已丧失爱人的资格..那么,我曾拥有过爱..我已经算是幸运的..上天已经很眷恋我勒..我该感谢上天,不是吗?最爱的你.现在在做什么呢.?是不是也和我一样,睡不着呢?我从未开口试图挽留你..因为,我始终坚持一个原则..属于我的幸福.就是属于我的.不是属于我的,那么我勉强..也没用.所以,对你..我从未开口挽留..但愿以后的生活..你能好好照顾自己..遇到好的女生一定要好好把握.或许有一天..我们会彼此祝福..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1325', '2000', '没想到.我最后还是哭勒..我以为,我可以忍住的..但是,我还是哭勒..对不起,我答应过你..不再哭的..但...我很抱歉.我没有做到..好怀念,你身上那淡淡的味道..好怀念,被你抱着时那种感觉..我总以为,我并不爱你..但,我发现,我错勒..爱情,本是一场游戏..这场游戏,我输勒..人就是这样,失去勒才知道后悔..呵,人生如戏阿...也罢.或许离开是我们最好的选择.希望你能幸福..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1326', '2000', '气死我了我的哪个日记本竟然没了,就这样没了,我上面写了那么多的东西,现在就这样没了,为什么这样啊??在那本日记本中,有我对kk的一切,可是现在什么也找不回来了,现在真的很想大哭一场啊~~~不,我不哭,大不了从头在写,把以前写的都补回来,也许有的记不起来了,也许现在已经没有当时的那种写的感觉,但是我会将这本日记本写的更好,更真实,更完美``````kk也许这是天意,它不想让你看到我的心酸和苦痛,不想让你知道,失去你以后的我是怎样度过(272天)的,我也相信宿命````没什么,从头再写起,依旧是属于k的故事和心情', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1327', '2000', '以前看了里面有一个故事让我觉得很感人~!勾小指的故事______聪明又美丽的公主吸引很多喜欢她的王子来她所在的城市向她求婚，最后只有五位王子成为了候选人，为了选一位和自己情投意合的人，公主向最后五位候选人提出了一个问题，公主将右手藏在背后，并且伸出一根小拇指，然后请王子们猜猜伸出的是哪根手指……..于是勾小指就成了两个人结婚的承诺！他们结婚以后，过着幸福美满的生活…….后来把发了十字军战争,王子要上战场打仗去了,王子离开的时候,又跟公主勾了小拇指,答应她平安回来……时光飞逝，王子还是没有回来，生死未卜，虽然公主青春已失，但是美丽依然，所以有很多王公贵族向她求婚，公主相信她心爱的王子一定会回来，又不能再拒绝求婚，于是她暗暗发誓，如果有人跟她勾小拇指，她就嫁给这个人……突然有一天有一个肮脏的乞丐前来求婚，守门的士兵要把他赶走，公主说，谁都有求婚的权利，于是把乞丐请到了公主的面前，原来那个乞丐就是王子……其实，王子已经在归来的途中死去，死者的灵魂在49天之内才会回到阴间去，那天正好是王子离开人世的第49天，王子是为了履行诺言才借着乞丐的身体前来找公主的，公主跟着王子的灵魂找到了王子，然后就躺在他身边，她永远陪伴着他……”在电影中男主角最后化成了风,一直守侯着女主角KK如果有一天你也离开了,你愿意化成风为我擦去眼角的泪水吗???当然我如果离开了,一定会和现在一样守侯在你身边,无论是化做风还是雨,我都愿意,一直为你守侯~~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1328', '2000', '1)Iloveyounotbecauseofwhoyouare,butbecauseofwhoIamwhenIamwithyou.　　我爱你，不是因为你是一个怎样的人，而是因为我喜欢与你在一起时的感觉。2)Nomanorwomanisworthyourtears,andtheonewhois,won‘tmakeyoucry.　　没有人值得你流泪，值得让你这么做的人不会让你哭泣。　3)Totheworldyoumaybeoneperson,buttoonepersonyoumaybetheworld.　　对于世界而言，你是一个人；但是对于某个人，你是他的整个世界。　4)Justbecausesomeonedoesn‘tloveyouthewayyouwantthemto,doesn‘tmeantheydon‘tloveyouwithalltheyhave.　　爱你的人如果没有按你所希望的方式来爱你，那并不代表他们没有全心全意地爱你5)Don‘tcrybecauseitisover,smilebecauseithappened.　　不要因为结束而哭泣，微笑吧，为你的曾经拥有。Wherethereisgreatlove,therearealwaysmiracles.哪里有真爱存在，哪里就有奇迹。Loveislikeabutterfly.Itgoeswhereitpleasesanditpleaseswhereitgoes.爱情就像一只蝴蝶，它喜欢飞到哪里，就把欢乐带到哪里。Distancemakestheheartsgrowfonder.距离使两颗目康酶?Loveisavinethatgrowsintoourhearts.爱是长在我们心里的藤蔓。Thesoulcannotlivewithoutlove.灵魂不能没有爱而存在。Whereveryougo,whateveryoudo,Iwillberightherewaitingforyou.无论你身在何处，无论你为何忙碌，我都会在此守候。Nowordsarenecessarybetweentwolovinghearts.两颗相爱的心之间不需要言语。Firstloveisunforgettableallone\'slife.初恋是永生难忘的Lovewithoutendhathnoend.情绵绵，爱无边。如果你非常非常爱什么，让它自由吧，如果它不回头，那么它本来就不该是你的，如果它回了头，那就要永远爱它——Ifyoulovesomethingveryverymuch,letgofree.Ifyoudoesnotreturn,itwasnevermeanttobeyours.Ifitdoes,loveitforever', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1329', '2000', '为了相聚你的那一天我走遍了所有的路只为真正能让你开心就在见到你的时候我把心灵深处深深的。。。送到你的耳朵边你说不必了，我们已分手了你说分手后还可以做朋友我的爱你不接受还叫我忘了你从此不要再联络让彼此都快乐还说我会找到另一个比你更好的女人此刻我再也忍不住眼泪不禁的滑落在心灵与面夹颤抖的眼泪破碎的心悲伤的我往回走迷茫路。。。。。。。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1330', '2000', '我真的徘徊在痛苦和开心之间我爱上了本不属于我的爱但是我还是选择了继续爱下去问我为什么我也不知道我只知道我的心告诉我爱她就要给她快乐和幸福如果我选择放弃她我很对不起她因为她也爱着我这就是被爱的代价之一我已经准备爱她可能要面对的东西比如（失去朋友，世人的辱骂。朋友的责怪等等这些俗世）但是我不在乎了我就要爱她因为她也爱我这也是被爱的代价之二在我最孤单最无助最寂寞的时候她喜欢上了我开始爱上了我而我也深深的爱上了她不管我们的未来是什么样子的我都想好了愿意为她付出所有感情和能力给她幸福和快乐这也是被爱的代价之三。。。我现在最害怕夜晚到来每当夜晚来的时候我的心就莫名酸酸的痛因为我深爱的她却睡在别人的怀抱写到这里我流泪了已经是深夜4点38分了睡在别人怀抱的她知道吗？我多想。。。我的心好痛好乱好麻好想大叫痛哭发泄下我的她你知道不知道我现在真的根本无法入睡因为我的心始终在想着你而且很明显我能感觉到我深深爱上了你却不能和你在一起这样的折磨还要到什么时候。。。算命的说我的生命可以到70多岁如果我的生命可以换取我们在一起我愿意拿20年作为交换。这样的话虽然听起来是有点荒唐但是为了能让我们在一起我愿意付出一切。。。上天不要这样继续对我了我本就活的很累如果你再一次在感情上这样折磨着我我觉得我太苦太悲了。给我个机会让我们在一起好吗？我真诚的祈祷。。。我深爱却又在梦中的她你知道现在此时我的痛与苦吗？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1331', '2000', '终于可以做自己想做的事心里真是很开心希望以后都可以像现在这样自在', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1332', '2000', '人生总是有那么多的无奈和悲哀开始是那么容易忘却是那么的痛与难有人说希望就在绝望的转弯处现在的我就在分路口真不知道哪条路才是真正属于我的又有谁能告诉我那条路是对的我该怎么做事业一路坎坷感情现在也是这样是我做人失败还是我的命运在捉弄着我我承认我以前是。。。。但是我现在想好好做人好好爱却那么多的无奈与悲痛人生路漫漫何其的远何其苦电影里的那么故事情节现在全展现在我的身上好象觉得现在的我有点迷糊我试着勇敢一点她却不在我身边我的坚强和自信是因为相爱才出现我一定会勇敢一点', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1333', '2000', '时间过的好快，转眼又一年过去了。回想一下，发生了好多事情啊，有点感慨！当年纪超过了25岁，当学历到了博士，当周围朋友一见面就会关心你的时候，自己也开始怀疑自己。是不是对感情的要求太高，是不是不够实际，是不是应当珍惜那个一直对自己好的人,不讨厌他算不算喜欢他。直到上周去了香港开会,才有了决定,因为我遇到了他,让我知道喜欢一个人应当是这种感觉.看到他的时候,我就知道自己喜欢他,不用去理性分析,全凭感觉.当发现他在看我的时候,心中一阵窃喜!傻傻的!虽然没和他说几句话,虽然不知道他有没有朋友,虽然最后没有留联系方式,虽然知道我们不太可能.但我很高兴有这样的一种感觉,可以偷偷的拿出来回味一下!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1334', '2000', '我想你了，真的，这种思念之情在夜深人静之时越发强烈,不只是孤独在侵扰我的心灵,还是你昔日的笑容刺痛了我的心,如果说我对你的爱有错的话,那我宁愿一辈子错下去.也许就象我说的,错的并不是爱,而是我们,是我不懂得珍惜,也不懂怎么样去承受这种使人兴奋使人受伤的东西,到现在我才明白自己当时是多么的愚蠢,自己为什么当时不好好对你呢?这个问题谁能给我答案?也许答案就在我自己身上,因为我当时所做的种种错误,铸成了大错.破坏了我们之间本来很好的关系,我现在该怎么办呢?向你道歉,还是像现在一样,默默的自己承受着痛苦,也许是我活该,我应该去独自承受这苦,所以的罪让我来背吧,好么?我想我暂时是不会给你打电话的,不是不想,而是我还不敢,我怕会打扰你本来很平静的生活,我不想让你再痛苦,一个人痛苦总比两个人痛苦好得多,对么?让痛苦来吧,我想我挺的住,我相信我的毅力。希望你能真心快乐、幸福！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1335', '2000', '[SIZE=4][FACE=楷体_GB2012][B][B]我爱你,这虽然是过去的事,但是曾经爱过又怎能轻易就忘记呢?要是忘记也要在你原谅我之后,这样我心理才会好受些,不然这种愧疚感会伴随我一生的，WhatcanIdoforyou?我怎么才能得到你的原谅也许这是痴心妄想,但是……………………我也不知道该说些什么了,只求今生能得到你的原谅,能再和以前一样和你谈天,我知道,要想和你再象以前一样的聊天,谈心事,不太可能了吧,可是我心中的愧疚感却怎么也挥不去,这种感觉在夜深人静的时候最扰人,相见难,相思更难,难的是我不知如何打发这整夜的时光,自责,也只有这样了,就象虔诚的基督徒向万能的上帝忏悔一样,我在无法入睡的日子里,希望在做梦的时候得到梦中的你的原谅,我已不是当初那个什么也不懂的毛头小子了,我懂得了如何去体贴女人,爱护自己的女人,不让她受委屈,以前的我,固执的以为是你伤害了我,现在我明白了,是我深深的伤害了你,伤害了我曾经最爱的人,这一切都源于当时我对你固执,近似疯狂的爱,爱到深处便是伤害,我明白了这个道理.希望你能了解我现在的想法.我就心满意足了。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1336', '2000', '曾几何时，在黑黑的夜里，我独自一人坐在店里的窗口，抽着烟，想着以前我们之间那些美好和不美好的事情，笑了，哭了，任凭夜吞噬掉一个男人的豪情壮志，任凭风吹干一个男人的眼泪，我真的伤心了，可是有谁会知道呢，有谁会理解呢，有谁来安慰我呢，只有我自己孤单的心和我单薄的影子，你知道了会原谅我吗，会和我从新开始吗？我想要奇迹，我期盼奇迹，直到那一天，你会发现，真正爱你的人独自守着伤悲。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1337', '2000', '今天听了郭力行的这首《我只是你哥》，好感动！感情好到不能相爱可以爱也不能说出来好不容易我才劝服自己又放不开结我对你太好好到变成依赖我会尝试不介意为你收集他留给你的甜蜜忍不住不爱你好锻炼我的耐力#告诉我他的什么他为你做什么我不是你大哥我听你说听你说听得好寂寞你为了他我为自己振作#*到底我在想什么到底要假装什么寂寞下去没结果你打开双眼都看不到我看他让你幸福我也不感难过*我有义务给你安慰没有权利去为你心碎我最爱你却要保持距离那累不累我不懂谦卑也要懂得惭愧原来没有该不该你不爱我到底不会有未来我有多无奈一开始已经失败歌曲链接：http://www.nayiye.com/musiclist/1/2752/87912.htm', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1338', '2000', '......挨,马上就圣诞节鸟,到底会发生怎么样.?肯定又是⒈个人过..反正他平常都不的找我,我想就算到圣诞我也冒太大滴必要克期盼他会来找我来陪我吧,挨,随便拉,反正这么多天⒈个人也这么过来老,虽然也会有点孤独,但是毕竟过节⒈个人过可能异常孤独些吧..圣诞.?哈,冒事过红么卵圣诞节咯..冒事找事,算鸟,到屋里睡告..也不想克那里玩,玩滴几个si铁也还冒放假,挨,看来注定我这个圣诞会好孤独啊..没有关系,亲爱的,你过的好就要的勒,你开心就可以老..记得,我真滴好想你..诚征征朋友数名,大家⒈起过圣诞吧.!愿意的人就报名啊,加我QQ,32113229..要求,⒈8岁以下滴.⒈5或者小点也行..哈哈,', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1339', '2000', '天使，我是叫你无忧天使，还是六翼天使呢？时间一天天的流逝，梦里不知身是客，一晌贪欢。是梦醒的时候了。在这世界中你我皆虚幻。你住的地方是天堂，我住的地方是地狱，很久以后，也许我们会相见……不，你是天使，随时可以遥望我，而我只是一个凡人，还是留一个愿望到永远吧……希望那时天使能够降临到我面前，一个长着六个翅膀的天使。__________碧云天爱情真的很残酷.._____________如果·爱“过去唯一的作用就是让我不再想回到过去。”“恨一个人要比他恨的人更痛苦。”“一巴掌，释放了她，也释放了自己。”“松手，让我成为你的回忆。”“我终于拥有了美丽回忆，飘过来，荡过去，永不忘记。”———————《如果·爱》_____________', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1340', '2000', '除了想你除了爱你hu~我什么什么都愿意翻开日记整理心情hu~我真的真的想放弃你始终没有爱过你在敷衍我一次一次忽略我的感受我真的感到力不从心无力继续这感情不值得我犹豫不值得我考虑不值得我爱过你这种回忆不值得我提起不值得想起不值得哭泣ha~这段感情早就应该放弃早就不该让我浪费时间找奇迹这样的你不值得我恨你不值得我为你坏了心情ha~我决定不为你而毁了心放弃爱你[白]我决定:放弃你除了想你除了爱你hu~我什么什么都愿意翻开日记打开心情hu~我真的真的想放弃你始终没有爱过你在敷衍我一次一次忽略我的感受我真的感到力不从心无力继续这感情不值得我犹豫不值得我考虑不值得我爱过你这种回忆不值得我提起不值得想起不值得哭泣ha~这段感情早就应该放弃早就不该让我浪费时间找奇迹这样的你不值得我恨你不值得我为你而坏了心情ha~我决定不为你而毁了心不为你而放弃爱情不为你而毁了心ha~ha~我决定不为你而毁了心[白]我决定:放弃你放弃爱你不值得梦飞船除了想你除了爱你hu~我什么什么都愿意翻开日记整理心情hu~我真的真的想放弃你始终没有爱过你在敷衍我一次一次忽略我的感受我真的感到力不从心无力继续这感情不值得我犹豫不值得我考虑不值得我爱过你这种回忆不值得我提起不值得想起不值得哭泣这段感情早就应该放弃早就不该让我浪费时间找奇迹这样的你不值得我恨你不值得我为你而坏了心情我决定不为你而毁了心放弃爱你除了想你除了爱你hu~我什么什么都愿意翻开日记打开心情hu~我真的真的想放弃你始终没有爱过你在敷衍我一次一次忽略我的感受我真的感到力不从心无力继续这感情不值得我犹豫不值得我考虑不值得我爱过你这种回忆不值得我提起不值得想起不值得哭泣这段感情早就应该放弃早就不该让我浪费时间找奇迹这样的你不值得我恨你不值得我为你而坏了心情我决定不为你而毁了心不为你而放弃爱情不为你而毁了心我决定不为你而毁了心放弃爱你', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1341', '2000', '我的好朋友告诉我，我的爱情已经死了，也坏了，过了保质期的爱已经腐败了，就算挽回，也是人走，茶凉，何苦为难自己呢。是呀，我也觉得太为难自己了，每天看着自己那眼圈的淤青，我知道我的心从来没有好过，或许上天给我们的时间太少了，以至于暮然回首已经荡然无存了，曾记得很喜欢徐志摩的诗，现在却觉得是那么凄凉。在现实中的生活不容许我回头，我强逼着自己从心房上把爱全部删空。曾为了感情，我可以放弃学业现在我权衡不出爱情是不是存在我的生活中，为了感情我可以不顾一切，多想分手后“挥一挥衣袖，不带走一片云彩……”可惜我不是那么潇洒，在未来的日子，我能不能喜欢上人，我也不知道，因为我的后遗症太厉害，如果注定没结局，为什么还要投入，这个世界的真爱怎么都和我檫肩而过，我没有办微笑着去看待过去，或许我不是个宽容的人，你们的结局很完美，那么我的幸福就这样被牺牲掉吗？我用我的沉默来遮掩我的伤口，到最后却总是发现这个伤口，从来没有愈合。我只想有个宽容的肩膀而已，再多的物质对一个连快乐都是奢侈的人是多么宝贵。只想爱的人多疼自己些，我不会过多的要求你，只要在身旁就好，过完平淡的此生，自己越爱的人却一步步逼退到没有可退的地步，从来没想过我所处的地位，我可以容受外界的流言蜚语，更不在乎父母的感受，我只是爱一个人而已。我希望自己在2006年的生活能够顺利些，祝愿和我一样伤心人能够有勇气去面对压力和痛楚。如果你需要人鼓励时，请一定要先要给自己打气，勇敢些。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1342', '2000', '星期一是红色的怎么说呢,对于我一切都是新鲜的,玫瑰是为遮掩羞涩而生的,这句话到底是谁说的,想想也对要有所准备,尽管这个季节的花卖的很贵同事不在也无所谓,可以闻着烫人的香味自我沉醉.星期二是成色的怎么说呢,你的爱似乎变的远远的,距离是为验证美丽而生的,这句话真不像人说的,你买了水果橘子会上火,偏偏此刻看不见你躲什么躲,你真的很苯我感觉渴是想你用湿湿的眼神望着我.星期三是黄色的怎么说呢,生日的聚会让人暖暖的,鲜花拥抱亲吻所有的礼物,都比不上你柔软的祝福,我在恋爱这好奇怪,那种昏眩的感觉怎么说来就来,黄色丝带我的最爱你送的所以它闪亮你不明白.星期四是绿色的怎么说呢,邮件里挤的密密麻麻的,我终于知道你将要去远方,突然间感觉是那么慌,会怀念的是你第一次,说爱我说爱我而使用的信箱,那些文字我会珍藏里面写我所有甜蜜和忧伤.星期五是黑色的怎么说呢,我紧遮住的眼睛肿肿的,你猜的没错我刚刚哭过,我想说这一切都是爱情惹的祸,有些幸福自己最清楚,就像咖啡香甜之后搀着微微的苦,你说我很酷我有些麻木,突然间就变的好尝试条回家的路.星期六是蓝色的怎么说呢,周末总是让人变的懒懒的,妈妈在叫宠物在笑,未来会发生什么总是会难以预料我走到窗前拉开窗帘,星期六的天空宝石一般的蓝,分开时考验我会习惯,周末夜晚该很灿烂要精心打扮.哼着曲子想这些日子,回忆里面就像藏着一个孩子,念你的名字它反复多次,星期天的街上泛着梦一样的紫,oh~远远的想象是一辈子,短短的爱情说唱词,令我难忘这七个日子所以怀念因为初恋仅有一次.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1343', '2000', '\\\'嚄對鉨已經繫荃鈊荃意最終畱低既隻繫一時既奢侈因為嚄始終放唔低鉨傷`````傷`````傷`````', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1344', '2000', '　　失恋以后什么感觉，现在我是彻底的体会到了。体会的真真切切明明白白。现在我正在听《老婆老婆我爱你》这首歌,我是一个重感情的人。听着里面的歌词不禁有些心酸，心痛。我以前的想法也如歌词里唱的；“我的爱就是你，你知道我爱你。现在我是不富裕，可是我有力气，我会让你笑，让你欢喜，只要你愿意――我陪你。下辈子我还爱你”　　可能这样的结局是注定的，现在我后悔了，后悔自己的种种不对。我又有什么办法呢？其中的无奈只有自己知道。我不会怨天尤人，那只会自寻烦恼。包括我自己都安慰过自己，不就是失恋吗？又不会死人，想开点就没什么了。把她忘了，但我做不到，直到现在我才意识到她对我是那么的重要。　　失恋后想了很久，想弥补自己的不足，这样想了，也这样做了，我想用自己的实际行动实现自己的价值。我想对她说：“我会用实际行动证明自己行，等我自己实现自己的人生理想，如果她还没结婚，我会继续追她，如果晚了我会祝福她过的更好。我还继续一如既往地坚持下去！”所有一切但愿她能过得比我好！　　　本想让一切都有一个美好的结局，但我知道这不仅仅是一个故事！　　　　今天心情不是很好，随便写点什么觉得会好一点！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1345', '2000', '今天的心情好无奈啊~~~~~~~我再次拒绝了夷,我真的不想和他在一起,我满足和他现在的朋友关系,我想等我要等的k,我想做到对自己的承诺```````看到夷远去的背影我觉得自己好无助,我不想看到这样的场景,也许我真的太固执了我不想因为任何一个人,而去改变我等k的决定也许这么做真的很不值得,但是我心甘情愿我伤害夷不止一次了,真的觉得自己很对不起他,为什么会成这样子??kk我该怎么办?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1347', '2000', '爱一个人真的很难吗我今天和我的女朋友分手了，我很难过；我希望我的好友们请你们告诉我该怎么办？我真的很伤心qq360365127或受机13820113219联系，最后我祝福有情人忠诚眷属，幸福人间，天天快乐。我会等你们的电话[SOUND]http://265.cm[/SOUND]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1348', '2000', '他犯勒一个不可挽回的错.这个错,让我们真正的分开勒.我从没有怪过他..但,他为什么要和我家里人说.?如果他只是在我面前说.那么.还能挽回,不是吗?昨天,我把有关他的日记.用剪刀剪成无数的碎屑.每下一次剪刀...我的心就像被刀割一般疼痛.我知道,我这次剪的不只是日记.我剪的是所有和他一起的回忆.我一边剪,一边哭..但是,事情已经到这种地步.我能怎么办.?我不可能再.和他在一起.我不想.我妈妈再因为我的事担心.在把所有日记彻底剪完后..我下定决心,彻底和他断绝关系.在做出这样的决定时.我的心好痛好痛.但这次,心再痛,我也要惹.因为我知道.这一次..是真的彻底完勒..现在的我,只希望..他能找个工作.好好做事.希望他多保重..或许几年后,再见面.我们还能微笑着打招呼..我们还是朋友.但愿他多保重..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1349', '2000', '哭勒一个晚上..早上起来,眼睛都是肿的.我知道,我和他之间.已经成为永恒的回忆勒.我已下定决心.不会再和他有任何关系.我不能再让我妈妈为我操心.尽管心很痛.但是..事情已经这样.已经没有机会勒.但愿他以后能好好照顾自己.早上起来,从医院回来.我告诉自己,昨天晚上已经哭过.哭过之后,一切重新开始..我更希望,他能重新开始.哭过之后,我重新开始.我的新生活..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1350', '2000', '\"来勒广东之后.阿姨带我去勒湛江..我第一次看到..很早就想看的海..我的心情好兴奋..因为,我终于能看到.我想看到的海..阿姨和姐姐走在前面.我一个人走在后面..我一个人走在沙滩上..看到这海边的沙滩..我突然心血来潮..我用手在这沙滩上..轻轻的写上..\"\"我爱你一生一世.\"\"可惜.这只能是我美丽的回忆..我会把这美丽的回忆..好好珍藏起来..当我一个人的时候.我会拿出来.一个人.慢慢的回忆,以前和你的一切..自己多保重呀..别再玩勒..\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1351', '2000', '时间证明了我，把⒈切都看为无有，现在的我是怎样我自己也不清楚，只想每天过的开心快乐就可以勒，别的什么都不想去想，原来总在没有事的时候想些无聊的事，不应该想的事，现在我已经不在去想，我是真的放下了，不管了，还是我真的学会了坚强了，还是什么，有太多的疑问，问谁勒。问自己，！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1352', '2000', '想找一个合适的词来形容一下自己的心情,却没想出来.很久没有像今天这样轻松了,一天没出门,早上睡到9点多,起来给自己做了一个计划,今天要做哪些事,到目前为至,一件还没完成.今天人事处把留校的名单整理完了,寝室的人都惴惴不安,我好像有也有点感染到这种气氛,心也安不下来!也许是在感慨,二年之后,我会不会也是这样子?每年找工作的时候,就会有关于各种人的各种小道消息,都会惊讶于原来天天在你眼前晃的人还有这样那样的社会关系.本来今年也是论到我毕业的,一时的心血来潮,让自己多过二年学生生活,今天还有人问我花那么多钱,又搭上二年值不值,我没说什么,但心里是不后悔的,人活这一次嘛,如果有机会什么事情都尝试一下好了不过,现在感觉自己念这个学位好像有点力不从心,不知道的东西太多,少了些自信.慢慢来吧,只能这样劝自己.就快过年了,又长了一岁,在学校里我的周围我算是小的,也因为这样总觉得自己是小孩,连老板有时都说他在哄孩子,转回来自己想想,大学同学都工作三年了,今年就结婚了4个,而自己还觉得结婚是一件很遥远的事,呵呵.算了,不写了,想到哪写到哪,结果写了些乱七八糟的.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1353', '2000', '我的心很乱真不知道是不是该继续这样走下去我对吗？我这样深陷下去危险吗？我在恐惧因为我的心是真的害怕失去害怕。。。。。。我的事业现在慢慢上轨道我这样不用心做事业是不对的可是我真的。。以前我从习惯寂寞到现在不能自我唉说的太读又能证明什么呢？爱她就努力付出吧我爱的她你给我听好我不是在玩感情游戏我真的爱你也请你放心你的快乐也是我要追求的目标我会给你我最大努力给你幸福相信我也相信你自己的眼光', '他终于上网咯..好兴奋喔.!!虽然我晓得总要有个结束勒时候.!!总会有我不想看到勒结局.但不知道为啥子..会那个样子..!!', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1354', '2000', '、佛祖來&樂\'(2005-12-1520:42:40)当然是的啦,世界验证...、佛祖來&樂\'(2005-12-1520:42:45)咕噜咕噜..▕菩薩來勒\'(2005-12-0512:54:14)就费,我听别个讲你把别个老..、佛祖來&樂\'(2005-12-1520:44:56)听别个?有什么用啦,有人还哇我杀了处女勒..▕菩薩來勒\'(2005-12-0512:55:05)....、佛祖來&樂\'(2005-12-1520:45:38)不信.?菩薩▕菩薩來勒\'(2005-12-0512:55:51)怎么信,佛祖变勒.!要菩萨拿什么来心.?、佛祖來&樂\'(2005-12-1520:47:13)菩薩变成什么了.?呵呵,归依佛门吧..菩萨没有变,!佛祖却变的连菩萨都不知道他是谁勒.!、佛祖來&樂\'(2005-12-1520:49:18)菩薩菩薩菩薩菩薩菩薩菩薩菩薩菩薩菩薩菩薩菩薩菩薩菩薩菩薩菩薩菩薩▕菩薩來勒\'(2005-12-0512:59:28)而你不再是佛祖,!看到你说的这些话语.!我是该退出勒吗.?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1355', '2000', '[COLOR=#ff00ff][/COLOR]我爱星期五，因为可以放假的，早上不早起，晚上可以晚睡，呵呵~~方媛也回来了，好想她，不过她下个星期不能回来了，呜呜~~真希望能天天和她在一起，她干什么要转学？真是的，太不够姐们义气了，抛弃我们，自己远走高飞了，哼！不过却恨不起来她，毕竟我们关系如此之好，不是吗？还是很想和她在一起，因为缘分，我永远相信缘分，我们的心会永远在一起~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1356', '2000', '○．詪，唔箌!.※〕', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1357', '2000', '......挨,讲些什么列.!??不晓得,就是好想你老吧..挨,总看不到你人..郁闷类...要是我们天天到⒈起就好鸟..挨..佛组,我想做你⒈辈子的菩萨,我想当你的新娘,你明白吗.??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1358', '2000', '好想聽一遍ヤ伱說[..我愛伱..].ひ.○o將ｙｏｕ鎖在鈊鋰①輩子o○┅┅→じｉしovのyoｕ\\％不願ご失去你ざメミ╬↘↘對你→我永遠都不會放棄↙╭║╮℡↘愛我所愛↓↑￠無怨無悔↙℡┊〔)╭︽╮┊.起床後.﹏第①個想起啲總是鉨ň﹏`苼萿.囿妳.`ˇ﹤哊.嗞.哊.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1359', '2000', '你问我...?恩咯.!我答应拉..>.你问我.<我说的约定.我会实现么..?.>.会的..啊喔我回答的是心里话喔!　骗你是狗狗喔　　　以上回答的话呈数事实　如有虚假　天打雷劈．．！　　　　　我真的好爱你..真的..真的...不管我以后变成什么样得人..我希望上天能可怜我下下直到我死的时候你娜娜..都在我身边永远和我在一起那样好幸福喔.!真的真的好幸福你问我.<这辈子只爱你一个吗.>..?恩咯.!我答应拉..>.你问我.<我说的约定.我会实现么..?.>.会的..啊喔我回答的是心里话喔!　骗你是狗狗喔　　　以上回答的话呈数事实　如有虚假　天打雷劈．．！　　　　　我真的好爱你..真的..真的...不管我以后变成什么样得人..我希望上天能可怜我下下直到我死的时候你娜娜..都在我身边永远和我在一起那样好幸福喔.!真的真的好幸福', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1360', '2000', '啊喔今天的夜色好美一个半弯的月亮上面恰一颗星好亮....思哈...我老婆现在怎么样咯是不是也象今晚的夜色一样美咯肯定是的...她也在想着我我也到想着她..这叫嘿嘿!记得...!不许老是哭因为你的身体不是一个人的还有一半是我的..你的眼泪每一滴都是我心在滴血.....虽然现在我们不能在一起嘿..以后我会好好珍惜和在一起的时间...一分一秒一辈子我想到最浪漫的事..就是和你一起慢慢变老...和孩子们讲着我们的故事亲亲好久没亲裹我可爱的老婆拉不习惯拉下次回去一定要亲半天着叫补起好久没做过的....嘿嘿是不是蛮霸道啊!你也不要老是担心我咯..我这朋友很多也很照顾我我叔叔也很照顾我...最最重要的是我还有个亲亲老婆....我会好好照顾自己的不然怎么对的起你....无论在那里我的心里转的都是你容不下一点点别的...现在天天想你是我的连一份工作我觉得这份工作要比任何工作都要工资高着叫满足吧..和你在一起是我最辈子最大的骄傲最大的满足..肯定死的时候也会嘴角微笑....哎哟....亲杂嘴巴...乖乖滴喔05.12.05小猪', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1361', '2000', '\"\'.俄這輩z', '′隻希望.﹖︵　　　　　≡祢能同俄渡過﹖‘★’ˊ俄想偠.*.\"\"zuo祢蕞苛愛d\'曉釹魜\'﹖　　/(&豬咾厷.。﹖『,＂≒.唏忘铕1兲}.\'`能襶丄伱、\"\".嘚结婚戒指;\'』;/\'\'\"', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1362', '2000', '我最喜欢的一个人2005年12月1日星期四时光匆匆的流逝，转眼间我已经渡过了4700多个日子。在过去的日子里，我遇见了无数个令我难以忘怀的人，但我最喜欢的还是我小学六年级的好朋友，她叫吕方媛。“陈坤呀，你瞧，某某的成绩又进步了，咱们是不是该努力了？”是谁如此留意身边的人？没错，她就是我的死党――吕方媛。“是呀，我们是该努力了，但是，你一定要保证做事不半途而废哦！”我只得好心的劝导。“没问题，这有什么难的，只要是我吕方媛想做的，就不会做不到。但是――我不想做的，你怎么逼我都不会去做的。好啦，咱们呀，废话少说，开始制定我们的计划书吧！”吕方媛自信的宣誓道。“ok！开始行动。no1.早上起来读书；no2.……”“啊！我做不下去了，再这样下去，我会被逼疯的！”方媛大叫。“方媛呀，你在忍忍嘛！你瞧，你得成绩不是进步了吗？”我苦口婆心的劝道。“不行。俗话说成绩虽可贵，生命价更高。我怎么可以为了一点点的成绩而放弃生的希望呢？不行不行啦！”她斩钉截铁的回道。“你就在忍忍嘛！你当初怎么答应我的……”“不行呀……”这就是我的超无耐心死党――吕方媛。“喂！陈坤，你看……”捣蛋鬼吕方媛闪亮登场。“不行，不行。哪有你这么损人家的！”我心虚的说。“没问题啦，咱们什么时候出过差错！”方媛信心百倍的说。“那好吧！谁叫咱俩关系这么好呢！”（一面之词，我看是你也有捣蛋心理）于是，一场闹剧精彩上演。这就是我的捣蛋死党――吕方媛。我的死党吕方媛还有许多爱好，我们两个在一起常常是笑声不断。我十分不舍地和她分开，但现实是残忍的。虽然我们不能常在一起，但我们的友谊还一直存在，因为我坚信：不深刻的友谊会因为离别而削弱，但深刻的友谊会因此加深，就如风能将烛火吹灭，却能使火越来越旺……这就是我最喜欢的一个人，你们喜欢她吗？后记：写完这篇文章后，我特别想方媛。记得有这么一句话：有一点想念总是在不经意间爬上心头，反反复复地想起来，你伴着我的梦幻，随着我的希冀，走了很长一段路。这是我和方媛一起抄的，现在想想那天的情节还如此历历在目，但不管怎么，我都要祝我们的友谊能地久天长。友谊地久天长', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1363', '2000', '俄不知道俄到底该怎么做.是不是俄真德太过于在乎⒈个人了,难到俄⒈心想做到最好.到最后.还是俄做错了呢.是因为俄太爱他.所以才会太在乎他.才会怕失去他.这样也错了吗.??????郁闷.哪俄真德不知道该怎么做了.要怎么做.才不会错..这段时间快乐离俄越来越远.俄几乎和它成为了陌生人了.以前快乐是俄德好朋友.在俄德字典里。只有快乐没有难过.可是现在,难过成了俄德好朋友.快乐离俄而去.俄要怎么办.俄好想抱这祢诉苦,却显德好无助.无助德让俄想痛哭.俄只想要和祢在⒈起.其他德都不重要了.有时候俄想把自己在乎祢德心情埋默起来.不让祢知道.可是俄做不到...不知道为什么..俄就是在乎祢.就是爱祢.俄装不出来.天啦.俄要疯了..这几天.差不多都是把自己弄德疯疯颠颠德.脑子里面乱乱德.不知道在想些什么东々.....好模糊.晚上睡觉睡不着.睡着了也老做噩梦.把俄吓醒.....有时候半夜里躲在被子里面哭..........唉......小猪......................好想祢.........', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1365', '2000', '我放下勒对你再也不见以后好点过靓走哒3166', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1366', '2000', '[COLOR=#9932cc][/COLOR]┈--→.o從沒想到我會如此在乎你我曾經以爲會天長地久╭oo的愛情^`但`在瞬.間灰飛メ.煙滅oo我懂了``.═╪^愛一旦消失.承諾只是白紙', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1367', '2000', '当你不在时，我会心烦；当你生病时，我会做千纸鹤为你祝福；当你微笑时，我会笑；才发现我已LOVEYOU', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1368', '2000', '其实我在该放开勒国件事情可能只是让她找个借口跟我分开而已我何必自欺欺人心不属于我我何必求强好勒我以后自己好好的过生活忘记她带给我的一切快乐与伤害重新找个妹子好好的爱你自己也好好保重我希望你也会幸福', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1369', '2000', '今天,看到他的日记勒..看到他幸福,我心里的石头..也就落下勒,能看到他幸福..对我来说,也就没有什么勒..我应该开心,高兴才对..不是吗?但是,我知道,我心依然痛..不过,就算痛.我也会忍着..因为,我知道,我们不可能再在一起.分开这么久,总是忍不住想去知道.他现在在做什么,有没有想我..呵,好傻好傻..我们已经分手勒..已经不可能在一起勒.,我为何还要这样??是吖,真的好傻吖..心里的疼痛,只有我自己知道..即使再爱他,我也只能将这份爱..深深的埋在心底..我会把这份爱..埋在心底,最深最深的地方..现在,他或许和那个心儿在一起把.?他们准备过一个属于他们两个的节日那么我呢?圣诞节,我是怎样过?或许,只有我一个人过圣诞节吧..或许,是我们今生无缘..所以,不管我们想怎样在一起..但是,还是有层层的障碍..记得2年前,我们天天吵架..没有哪一天,我们停过..到勒第2年,我们反而不吵架勒..我们彼此迁就对方..有种已经进入婚姻生活的感觉..他的性格不大好,脾气很爆躁..但是,从那一刻开始..我有勒一种,想成为他新娘的想法.现在的我们,彼此深爱着..可是,必须面对分手..他的一些无心的话,让我妈妈对他.失望彻底..我好想替他补救.可是,算勒..现在的我必须面对.在我妈,和他之间选择一个..我只能选择放弃他..尽管自己的心很痛很痛..但是,我还是会微笑着祝福他..只要他幸福,这就够勒..我笑着流泪..只为祝福你.只要你幸福,我什么都无所谓..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1370', '2000', '突然想起,以前的日子..真的好怀念,那时在医院..为我的病忙前忙后的他..为勒我的病,他在医院天天陪我.我想吃什么,他都买给我吃..甚至跑去几里外的奶奶家.只因为,我吃不下饭..想喝粥..人事已非.都过去勒..现在的他,好不容易走出.我们之间的回忆..我应该祝福他..尽管心在滴血..但是..我仍然微笑着给他我最真挚的祝福.只要他幸福.这对我来说.就足以让我开心的勒..不是常常有人说..爱一个人,并不一定要占有他.而是他幸福,你就幸福..我现在才真正理解到.这句话的真正含义..不过,我不知道.原来..为自己最爱的人祝福..是这样的痛苦..不管怎样,我该放手勒..只要他幸福就好..其他,都无所谓勒..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1371', '2000', '今天过的很累.有一种快要窒息的感觉.其实我是很喜欢小瑞的,我想对他好.因为太的好,他的善良.实在让人无法视而不见.每天一如既往的重复,重复着悲伤.我不想掩饰什么.我一直被悲伤笼罩.也许我不该在这时候做决定,也许不是公平的.但是我明白,在我说出什么的时候,我没有说谎.我真的好想忘记,忘记很多事情.星期三的化学实验.我跟周璐熙,独自演独角戏.看我们可以撑多久.我不会表现出什么.她仍是我同学,老李说,同学缘,也改珍惜.我听老李的话.我跟她没什么关系了,只剩这个.我不会再碰.我该笑了.爽朗的笑.甜甜的笑.不想再难过.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1372', '2000', '我已经厌倦,⒈句话就被说服,然后⒈转身,⒈个bu留神,却又被放逐..⒈个人过夜,才知道需要帮助,看不到的痛,摸不到的愁,谁替我挡住.?以为我会谅解这⒈切,从此不再有感触,那种假装坚强的感觉,比任何挫折还辛苦..我忘勒怎么哭,却痛到深处,要错过多少次,我的心才会够清楚,怎么能对我说放开手会比较幸福,我忘勒怎么哭..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1373', '2000', '......虽然经常梦见你,还是毫无头绪,外面正在下着雨,今天是星期几?butIdon\'tknow,你去哪里?虽然不曾怀疑你,还是忐忑不定,谁是你的那个唯一,原谅我,怀疑自己..我明白,我要的爱,会把我宠坏,像⒈个小孩,只懂在你怀里怀,你要的爱,不只是依赖,要像个大男孩,风吹又日晒,生活自由自在..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1374', '2000', '当花瓣离开花朵,暗香常留,香消在风起雨后,无人来嗅..如果爱告诉我走下去,我会拼到爱尽头..心若在灿烂中死去,爱会在灰烬里重生,难忘缠绵细语时,用你笑容为我祭奠,让心在灿烂中死去,让爱在灰烬里重生,烈火烧过青草痕,看看有是⒈年春风..听着沙宝亮的这首暗香,犹如就想起勒自己,属于那朵是否还余留着花香的我,', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1375', '2000', '堂客以前的事情就当是烟样的吹走勒我也希望你能珍惜我对你的爱情我已经把你当做身体的一部分怛也希望你能晓得我对你的爱收起你的玩心不玩再拿别的牙子来伤害我哒我以后会对你很好很好我们2个在一起先不和你屋里人港到时候在一起久勒肯定会得到你屋里人的谅解以后什么事都不准骗我哒我相信我如果有什么事骗你的话你心里也会不舒服的我们彼此都用真心对待对方让我们好好的走过以后的日子忘记以前的种种还有我把头发剪噶哒剪的宝崽样的好郁闷勒以后我们2个开开心心的过咯靓会用全部的爱来呵护你', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1376', '2000', '[COLOR=#ff69b4][/COLOR]是不是会突然看不到明天了?就快要回国了1年的煎熬终于到了不过却少了那么激动的心情啦应为现在的班里虽然大家都讲这不同国家的语言但是相处的像个小家庭一样好开心好开心不过短短的预科只有1年我会想你们joann会想你们.....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1377', '2000', '我看到小瑞,真的会很高兴.就算是他的拒绝,也让人那么舒服.跟他在一起的时候真的很舒服.这样我已经很满足了.我知道,我也只能做到这里.不能误了我和他的将来.在毕业的时候,我想抱他一下,可以吗?这种感觉不是出轨,可在我心里的感觉和小瑞是不同的概念.我不会相提并论.我知道应该怎么处理.就是简简单单的,这样简简单单的.我喜欢.我喜欢和瑞一起晒太阳的感觉.那种安谧,似乎我从未在可身上得到过.在可那里,有的是激动不已.然而,这激动我怕它随风而去.但是我深深的明白,瑞给我的安谧,永远在我心里.我会爱小瑞,像真正的母亲一样爱小瑞.他就是我的亲人.至于宪,他其实对人很好,只是不想主动表现.现在,我心里充满爱.深深的爱.不想以前,那样的紧张.有的是,释然.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1378', '2000', '啊哦.偶荤,凉啊......郁闷..!这口香糖怎么这么凉啊.!每⒈相遇都是那么的短,每⒈次的心跳都是那样,时间⒈天⒈天的过去,过去的⒈切早就已是过去,只想现在过好每⒈天,每次看见她对你的留言我不会生气,只是心里有些说不出的味道..........我受不鸟被打击太多次,我的心很容易受伤,也很容易愈合,但每⒈次伤心的时候让我会⒈次⒈次的更加伤心也许过于伤心会让我选择逃离,他们说我很傻,可我没有办法,逃离也是⒈种对的选择,我让别人幸福,自己伤心,自己逃离....但我的心太懦弱...我受不鸟打击.!是我感情上的缺点,很容易把我倒.........每天的心情我都会写下,在用⒈首歌表达..........(可不可以不勇敢)你用浓浓的鼻音说一点也没事，反正又美又痛才是爱的本质，一个人旅行也许更有意思，和他真正结束才能重新开始。几年贴心的日子换分手两个字，你却严格只准自己哭一下子，　看着你努力想微笑的样子，我的心像大雨将至那么潮湿。我们可不可以不勇敢？当伤太重心太酸无力承担，　就算现在女人很流行释然，好像什么困境都知道该怎么办。　我们可不可以不勇敢？当爱太累梦太乱没有答案，　难道不能坦白的放声哭喊？要从心底拿走一个人很痛很难。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1379', '2000', '[COLOR=#a52a2a]凯,我看了你写的这些我真的想好好的和你在一起,不分开!过去的我都不想再记起,以后希望我们在一起能开开心心的就好!真的,其实这几年来你为我付出了很多很多..我心里都明白,特别是现在我让你好担心..这我也知道.我也不知道怎样和你说你才能理解我心里的想法,不管怎样我都是爱你的.别怀疑这个好吗?我等你回来,我们会在一起的.开开心心的住在一起!好吗?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1380', '2000', '冬天,这两个字的含意我想大家都清楚,冬天,是我最不喜欢的季节,它太寒冷了.冬天的夜来的特别的早,每晚我都感觉夜太寒冷了,冻的我的手和脚都没有知觉,身在远方的你,不知道有没有感觉到这一点.听说你一直在不停的忙碌着工作的事情,而我却在家里只能傻傻的等你回来,却帮不上你一点的忙,你在济南还好吗?每天都跑来跑去的.你有没有多穿件衣服,我给你打电话的时候,感觉你的声音变了,我想我的直觉告诉我说你一定是感冒了,我很担心,一直以来,我都以为你的身体一像很好.但没有想到你也会生病,而且是在那么远的地方,我不知道该怎么办好,身在远方的我,也不能飞到你的身边来照顾你.我好伤心,你有没有吃药,我担心你的感冒会越来越重,从你感冒到今天我一直都没有睡过一个好觉生怕你会发高烧,没有人在你身边照顾你.我好想你,我真想和你在一起,我能好好的照顾你,但是有好多事情都是可遇而不可求的.听说你已经踏上了回家的汽车,我的心里无比的高兴,希望你能回来和我一起度过难忘愉快的夜晚.我预祝你能早一天的回来.我等你.我会天天在车站等你回来,我的亲爱的他~~~~~~~~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1381', '2000', '[/COLOR]逝者如斯,也许,那些人和事都象时间一样匆忙,一旦过去,就是真的不在了.如果有些人,注定要擦身离开,与其走火入魔的缠绵,不如一刀两段!~!~![/COLOR]一些东西在等待的过程中,已经失去了,没必要在执迷不悟?$^', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1382', '2000', '好累！我第一次感觉到活着真的好累！我突然很怀恋小时候的生活，有爸爸妈妈的呵护，大人们的关心。没有任何的烦恼，无忧无虑得过每一天。而现在的我却不知道该干什么，适合干什么，我为什么会活在这个世界上。我外出打过一段时间的工，但是我很受不了别人的管束。尤其是那吝啬的老板，想想就来气！就这个原因，我辞掉工作回了家。在家的这段时间，我天天跟群小混混在外面混，整天打架，上网，好象就没有别的事可做。还记得这段时间里我伤了一个好女孩的心，现在想想挺对不起她的。]我已经厌倦了这种生活，不想再成天的混日子！写着写着心情好多了。我决定从现在开始！我要使自己的生活变的充实！从现在开始我要微笑着面对每一天！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1383', '2000', 'み.呆櫫&!23:38:10你跑不掉得..注定是我得..是我陈俊钦得!!み.呆櫫&!23:41:52边会..边会..更系锡你拉..!!傻猪!み.呆櫫&!23:01:08知度...只要我知道你系爱我就得..唔准谂第二个..晚上都要谂我..み.呆櫫&!22:48:32我有佐你..其他乜都唔想谂..み.呆櫫&!22:26:04....我更系傻既...晤系点配你只傻猪..み.呆櫫&!22:27:05!!哈哈...钦好爱你...み.呆櫫&!22:53:38....你卑我既feel..可以让我死心塌地的对你..!!み.呆櫫&!23:49:04呵呵,我说过``我可以什么都不要..可没了你...我真得没什么意思啊!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1384', '2000', '22:43:51其實伱今日同我講佢上黎穩伱.我超么呀!本來伱一直話要同我一起我都無咩feel嘎.係伱摞手機卑我果日我對伱就有feel勒.點知道佢上來穩伱.超灰呀好材伱同我講.伱吾會同返佢.!!22:44:22.恩恩.我部機重裝無幾耐嘎.應該係網速嘎問題み.呆櫫&!22:46:50喔喔...``我晤会同距好返..我今日晤系同你讲.....22:47:27恩恩.!那就好勒拉.!伱今晚幾點走呀.!?み.呆櫫&!22:47:58....应该12点...み.呆櫫&!22:48:00佐乜啊..み.呆櫫&!22:48:32我有佐你..其他乜都唔想谂...み.呆櫫&!22:48:36知吗?22:48:46無呀.!伱啱先話纍.想叫伱早點返去休息啊!!.22:50:08.恩.知勒.譆譆.愛死伱拉!み.呆櫫&!22:53:21...!!我陈俊钦也是拉..很很爱郑明珠み.呆櫫&!22:53:38....你卑我既feel..可以让我死心塌地的对你..!!22:54:18.哈哈!伱知道的拉.我不希望伱揹着我有第二個!我會信伱的.伱放心!!!.み.呆櫫&!22:55:49绝对不会!み.呆櫫&!22:55:57就很简单的四个字22:57:08哈.!老公啊.我同伱講D野呀.但係伱聽過之后就算勒握!み.呆櫫&!22:57:46得.你讲22:59:05之前同呀創仔散佐.我班有個人對我好好.然后我對佢有少少feel.但一直都係無一起!佢依傢都係會飛信息卑我.落課同我玩..但依傢有佐伱.我會好少同佢接觸嘎勒.伱睇我手機果陣見到佢D信息之類嘎野.伱吾準嬲啊握.!!み.呆櫫&!23:01:08知度...只要我知道你系爱我就得..唔准谂第二个..晚上都要谂我..み.呆櫫&!23:01:31..发梦..都系得我一个23:01:46恩恩.係嘎.我驚伱見到.誤會就吾好拉.!y以后我會好少同佢嘎飛信息嘎勒.伱放心拉.!23:02:06/哈哈.的啊的啊.滿閙都是伱握.哈哈!!!み.呆櫫&!23:02:27恩恩..老婆...!!23:03:18.今晚佢飛佐好多條黎呀.但我一條都無囬佢呀.我隻想有伱一個.哈!み.呆櫫&!23:04:16甘距就系中意你渣!!み.呆櫫&!23:04:57...呵呵你唔得只想我一个..可以想你爸.妈.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1385', '2000', '12:57:19佢今日早上有無哃伱講野呀.!?.．ら邪喪丶.13:01:50有啊.蛤蛤.!我看到呢张相.我喊咗.蛤蛤.12:59:13恩恩.為什么哇.就是那個人.?.．ら邪喪丶.13:03:09蛤蛤.硪也卜知道为什么.!讨厌这种感觉.12:59:57就是那個人嘛.?.．ら邪喪丶.13:03:48对对.!13:00:34.砹.算暸!.．ら邪喪丶.13:05:44蛤蛤.他侗他鲦囡.好恩爱锕.但是匴鳓.硪说过要忘记.我删鳓他的电话.拉他的Q进了黑名单...嘻嘻.!13:03:26恩恩.那就對勒嘛!!.．ら邪喪丶.13:07:16那噹嘫.郑彗仪一直都詪勇敢.对吧.?13:04:34還好勒.不過不勇敢我們都不知道呢!.．ら邪喪丶.13:08:38谁説的.一直都很勇敢.13:06:27砹.不是勒拉!.．ら邪喪丶.13:10:50傻猪..給我一点鼓励.好嗎.?郑彗仪会勇敢的忘掉他.郑彗仪一直都是最坚强的.!對吧.?蹴匴骗硪也恏.鼓励硪.鼓励硪忘记他.13:09:43恩呢.那當談會的勒.我那么愛伱對不.哈哈!.．ら邪喪丶.13:13:17蛤蛤.硪也瑷死祢鳓.13:10:13.哈哈.反正莪們現在都沒人愛.哈哈!.．ら邪喪丶.13:13:57&&﹑愛夫小創創.]、--[[心愛的老公.我愛伱〃又骗人.大苯蛋.13:10:50哇哇.不是呀.祂叫我莂改資料.但散勒的1.．ら邪喪丶.13:14:42我狂晕.坩都嘚.既话嘸卑祢稳第二嗰喇.蛤.13:11:48.哈哈!無所謂拉!祂喜歡巴!!.．ら邪喪丶.13:15:38蛤蛤.他还爱你.对吧.?13:13:48.我不知道哇!今天祂都沒有給信息我呢!.．ら邪喪丶.13:17:44啃啶是哒.放心喇.13:14:52伱又不是祂呢!.．ら邪喪丶.13:18:40嘻嘻.硪每佽蔸估中噶喇.13:16:13這次不一定呢!13:17:05昨天蘇嘿那么說.真的很傷心握.就算現在不是情侶.也沒有什么聯繫.畢竟曾經愛過.祂現在這樣.砹砹.好傷啊!.．ら邪喪丶.13:20:50卜会的.卜会的.他们柯螚只是误会.埃.13:18:35那如果是伱.伱會怎么樣握!而且又不是我的錯!.祂是伱曾經愛過的人.真的那句話.我心裏還是姷祂.以前的感情還是會有的.伱也知道的!但我很努力祛愛創仔的勒!!.．ら邪喪丶.13:22:56蛤.或许硪懂祢吧.铷果是硪.硪会要他说清楚鳓.为什么你们要做陌生人握.做卜到情侣.就卜柯以去试试做朋友嗎.?苯死鳓祢椚.13:20:18哈哈.我想我們都做不到巴.大傢都沒有勇氣祛開口呀.而且呢.如果做勒朋友會很空虛那樣.可能在意的東西會很多!.．ら邪喪丶.13:25:40我觉得卜会囖.起码你们一起这么久.也这么了解对方.你们就卜能好象小婷铜牛仔一样.!做卜到情侣.但还可以做知己啊.!是卜是.?13:23:25.可能時間久勒自然會巴!,畱在荔香的日子哩可能都不會的勒!因為在荔香還有很多事要麵對的!.．ら邪喪丶.13:28:55那也是.觉得他们那帮人好叼.我特别讨厌关建龙.13:26:34恩恩.而且我哃蘇嘿講返野嘎話佢地班人又多野講嘎勒.就算依傢我幾仲意蘇嘿.幾放吾低佢.都吾會再一起嘎勒.我怕勒祂的兄弟.對握.我也是啊.口超臭!.．ら邪喪丶.13:32:00对对.我要去买野.先下了.拜.13:28:47砹砹.好不捨得.!88!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1386', '2000', '兜兜转转后.最后剩丅勺.还是莪们5嗰.婷:自己选勺路僦把他赱好.彗:你选择祝福他.僦尓卜要让自己受伤.肠:别让自己后悔就对好.猪:珍惜这罕有勺爱.别任性.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1387', '2000', '臘腸.袮莂這樣勒好嗎.祂不隻得袮這樣的哇..砹砹......放下巴!!!算勒.會過去的!!我不希望袮象一樣勒.難得拋開過去.難道想象以前那樣勒袮?有勒上一次.袮這次應該會更看的開.不應該象以前那樣哇!!懂嗎.聽到袮哭后的聲音.很想駡袮.但又怕袮更傷.看袮腫勒的眼睛.和昨晚3點多的信息.好心痛哇!米甘勒.好嗎..朲天生根本不可愛死身邊的一個.!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1388', '2000', '￡枫尘∑绚§14:51:46我想跟你说对不起~~我想我是不是冤枉你了~~~~~对不起啊', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1389', '2000', '嫲嫲.08月15日外婆.10月29日偉康.09月05日.02點10分敦強.04月26日.08點10分爸爸.10月10日', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1390', '2000', '今兲開心也佷開心.旦更加的不開心.開心媞.屙哩吉蒂臘腸&蒂吉哩屙傻豬.哈哈.!!實在太好笑勒.屙*.屙*...還有僦昰今兲早上佬厷送硪上學哇.!硪薱妳依然沒變過哇.哈哈.硪愛伱們.臘腸.小創.不開心是在莪們班裏的事哇.首先.班主任.想打死伱哇.折磨硪.??哼哼.拿級長來大別朲.鄙視伱.偏心.哼,.雖然伱有時候佷好.口硬心軟.旦也卟至于這樣哇.?艾艾.個個學期都是這樣.妳佷煩哇.教學生也卟砽這樣剌.卟砽活勒!還好級長好點妳一不在級長僦給我報.都是妳樣衰.見到妳都沒好運...更慯心的僦昰.平時兲兲借作業給我.經常幫我頂罪.少給工作硪做.還有包庇硪.小學到初中同學.還送勒個豬的風扇給我的選選轉學勒.艾艾.我知道天下間沒有不散的宴蓆..我明白.還有一年也好勒.高中再辵也好哇.以后誰借作業給我勒.?討厭的伱.下次記得囬來10班找莪們握.韆萬別忘勒10班的同學哇,還有一個僦昰.大傻哥也辵勒.雖然伱上課有時候佷煩.羅羅嗦嗦.旦伱實在太好笑勒.經常讓莪們笑不停.還幫我從9街買早餐哇.哈哈.那些粥很好喫哇.伱買勒佷多很多次哇.艾艾.現在不可以買勒.什么時候再買來哇.?艾艾.!!.艾艾.班裏個個都辵勒.以前的.丫燦.昌,豐哥.桂賓.大傻,選選個個辵勒.還好.靜儀.q女.魚魚........還在.還有幾個就不說勒.靜儀哇.好好學習勒別再艮硪研究老師的.*******哈哈.!.怕下學期伱不坐硪后麵勒僦拫少笑勒.5555555.也怕沒人偸看完勒再傳答案給我哇.哈哈.而且妳又man.咚兲快來勒.坐硪后麵為我保煖.哈哈.硪僦不怕凍稱勒.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1391', '2000', '硪快給妳笑死勒.!臭韔.屙哩吉蒂....哈哈.!硪4點25到4點35之間打卑伱妳無囬我信息伱就屙硬*侗屙硬*..哈哈.!伱打卑**的話我就將妳.蒂吉哩屙..哈哈.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1393', '2000', '我總是在矛盾中掙扎希望找回失去的東西,可能真的不復存在.我投降我放棄,抹去傷痛的記憶,記住在這個世界上是沒有一段感情可以永恒不變得,包括自己也不能相信.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1394', '2000', '难过了几天了我还是哭了,是因为太伤心,还是因为太在乎???我终于体会到心碎的感觉了忘记K我还需要一点点的勇气不哭,不哭,我是坚强的没什么的,真的没什么的我想我可以习惯一个人生活分离是最好的选择~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1395', '2000', '今天,感觉到刀刀对我的不信任,我很伤心.但是,也许这就是她真实的一面.也许她把心里的话告诉我了.只是我还没有习惯她的方式,我相信,她说她爱我,是真的.今天跟包包打电话,我们聊了很久.我才发现,刀说对了.她们一直对我很好,以前我没看到,现在我看到了而已.以前我真傻,不懂珍惜这一切,还茫然的以为那是最好的.傻啊......我现在一定会好好的对包包.因为她真的明白我要什么.她知道我现在心里想什么.她知道,在被自己的好朋友指责过欺骗的我,不会再欺骗任何人.她经历过.她明白我,这一切,并不完全是我的错.我也终于明白,理解万岁是什么意思.真的.大恩不言谢.感冒了.有点难受.我没吃药,它会好的,一切都会好的.今天看到小瑞的样子,我真的好喜欢.为什么我们不能一直在一起,我只想他是我的亲戚,并不是爱人.真的,很希望.但是我知道不可能了.看着他的样子,还感受到他对我的好,我知道,我已经满足.下午,看到可和熙一起来.心里其实有一种被背叛的感觉.好莫名其妙.我知道他不会这样的.但是我还是忍不住不这么想.我依然觉得是我影响了他们.我的反应直接的关系着他和熙的关系.我不想充当这种角色.好像我是第三者.其实现在我想让他们在一起,我心里会很好过的.并不是因为我不再对可有感情,只是,我心里会好过.我知道可其实不会不接受熙的.只要熙说出口.她不会说,除非,她知道我跟可不再有关系.能这么做吗?今天真的百感交集.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1396', '2000', 'み.呆櫫&!21:31:54你甘中意腊肠``你要距罗~!!み.呆櫫&!21:32:06!!!!怎么仲要我啊21:34:36.哇暈.佢係我最好嘎姊妹黎嘎.21:35:28係米甘呀伱.!.好想我吾要伱嗎.?み.呆櫫&!21:33:55不是吧...!!!!!哈哈!!み.呆櫫&!21:34:05讲笑嘛!!!21:36:06..哈哈.那就行拉.!我知道呀.哈哈.!み.呆櫫&!21:34:19很爱你..很爱你..很很爱你啦!!21:37:34我也是恨愛伱的拉.!21:38:05哈哈.伱錯勒.我係平安夜果日陪臘腸.甘聖誕果日米可以陪伱咯.!み.呆櫫&!21:37:49其实我想日日都想你同我一起枷!!!み.呆櫫&!21:37:59哈哈!!み.呆櫫&!21:39:43!!!み.呆櫫&!21:47:47你系老婆乜都系大晒吖!!!み.呆櫫&!21:51:03你知我分人...!!み.呆櫫&!21:51:18我对你..我谂你应该好清楚!!22:04:23怎么拉.1?み.呆櫫&!22:03:51.....没事啦...我好爱你..但系我真系表达晤出吖!!22:07:28.哈哈.伱好儍呀.!.老公.我也好愛好愛伱啊.!み.呆櫫&!22:06:12!!!又卑你踩啦!!22:08:21.哈哈.無呀!幾時有呀.有甘嘎事咩.?!.!み.呆櫫&!22:06:58哈哈!!1没有没有!~!总之我讲过!1你乜都大晒!!み.呆櫫&!22:07:12我可以听晒你话!!!22:10:48哈哈.沒有就行拉!甘又吾係好好.哈哈!22:11:56好想你握.!!み.呆櫫&!22:11:27我也是吖!!1!!不过你心里有我就可以啦!!!み.呆櫫&!22:11:37不要把我忘啦22:13:48一定的.我心裏隻有伱!肯定不會拉.!.哈哈.22:14:04哈哈.我問伱D野拉.み.呆櫫&!22:12:20问!122:14:15/我係南員果陣伱有無仲意過我.?哈哈.!!み.呆櫫&!22:12:33有!!!!!22:14:47.哈哈.我記得我小學未同陳標軍一起果陣對伱兜有feel嘎,哈!み.呆櫫&!22:14:04哈哈!!那我们现在不是一起嘛?み.呆櫫&!22:14:06哈122:16:07.哇.隔佐幾年啊.!?.み.呆櫫&!22:14:39到依家!!22:18:01哇.無下死人.!.果陣好難講嘎.果陣可能會仲加認真.記得果陣同軍都係.到初中先散嘎.!.上學期差D同返佢一起1.后來兜係無.み.呆櫫&!22:17:10!!!乜你依家唔认真枷!!!22:19:11.甘又吾係.!.み.呆櫫&!22:17:46哦22:20:19米亂唸拉.儍嘎.肯定吾係嘎拉.!.我地一定會好耐好耐嘎.み.呆櫫&!22:18:46唔耐!!み.呆櫫&!22:19:02但系系``1辈仔!22:21:34,嚇死我.我以為伱話吾會耐.み.呆櫫&!22:20:26哈哈!!!我甘爱你!!点会呢!22:22:44哈哈.陳俊欽.我跟伱說呀.我不會變心的.除非是伱呀!み.呆櫫&!22:22:07哈哈!!我跟你说``我们以后就算遇到问题``也要.我们两个人一起去面对!み.呆櫫&!22:22:17慢慢讲22:24:54.恩恩.一定要啊!哈哈!み.呆櫫&!22:23:25恩恩!!!陈俊钦很爱郑明珠吖!!22:25:16.其實尋晚我甘.伱係米好嬲.吾係講依傢.係尋晚果陣.!?,み.呆櫫&!22:23:50晤嬲``但系好失望啊!22:26:18我梗愛伱呀.!22:27:20.我尋晚幾驚伱會同我講散呀!み.呆櫫&!22:26:07我琴晚听度你话..有也同我讲``就系惊你同我散..22:21:34,嚇死我.我以為伱話吾會耐.み.呆櫫&!22:20:26哈哈!!!我甘爱你!!点会呢!22:22:44哈哈.陳俊欽.我跟伱說呀.我不會變心的.除非是伱呀!み.呆櫫&!22:22:07哈哈!!我跟你说``我们以后就算遇到问题``也要.我们两个人一起去面对!み.呆櫫&!22:22:17慢慢讲22:24:54.恩恩.一定要啊!哈哈!み.呆櫫&!22:23:25恩恩!!!陈俊钦很爱郑明珠吖!!22:25:16.其實尋晚我甘.伱係米好嬲.吾係講依傢.係尋晚果陣.!?,み.呆櫫&!22:23:50晤嬲``但系好失望啊!22:26:18我梗愛伱呀.!22:27:20.我尋晚幾驚伱會同我講散呀!み.呆櫫&!22:26:07我琴晚听度你话..有也同我讲``就系惊你同我散..み.呆櫫&!22:44:48!!!!!!!!!!!!!!!!!!!陈俊钦得返郑明珠渣!!み.呆櫫&!22:48:23哈哈!!紧系``我系你老公吖!!22:50:59.哈哈.對阿對阿.!最愛伱拉.!み.呆櫫&!22:50:05哈哈!!我也是``也是啦!!老婆最爱你', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1397', '2000', '姐妹慢慢回到从前,走过原来的街,看看身边的⒈切,都变勒,我们⒋姐妹还能回到从前吗?想想哪个时候有什么不开心的,有什么开心的,我们都一起走过来的,想起我们⒋个人,不管谁伤心勒,在下雨的天气中,我们一起在学校的操场中间霖雨,让在身上,让人看不见我们在伤心,眼泪在飞,过去的回忆,过去我们有过争吵,有过快乐,有过⒈切的⒈切,现在我们都不在一起,不象原来哪样天天都在一起,可是我们还是姐妹,我们⒋个人都各自找到勒幸福,偶只希望你们好好珍惜你们的感情,我祝福你们.....我最爱的老公(谭倩)..你是我们⒋人中最有女人味的.....段志倩...从学校的时候你一直都是那么的妖媚的.....好好爱你老公,你老公是很爱你的.有时候的吵吵闹闹很正常,你们还不是彼此爱对方....宋玮...我们是晓得你的...我只希望你好好爱你的群...我们⒊个是晓得你是离不开群的......现在你依然还是拥有了你的幸福......好好珍惜....!原来我对你们说...我不会想找....哪个时候我没有找到那种感觉........现在我找到勒...我会幸福的....我很好好珍惜的爱..........我们彼此都找到勒⒈辈子.......相信我们⒋个人是最幸福的....!(意想不到)未来是一个问号谁也没办法预料心里想的不一定得到谁都想有个法宝就像有三个愿望糟糕的统统给我变好FallinloveGetajobIfyou\\\'reluckyyoucanstopButnobodycanturnbacktheclock我在笑我在跳不代表我在胡闹要知道我会做到最好给你看我也好失败了也好小时候一个愿望早已给我忘记了忽然它实现在我眼前未来是个惊叹号它会把你吓一跳每个结果都意想不到梦发太多会迷朦不发梦人沉重我只想走到了尽头也可以与你追逐每一个梦', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1398', '2000', '……不必算太清楚,心里就明白.周一到周五不过，快乐就非要限量版，为别人活都不算，我们只剩下周末……原本多云的心情掺杂着丝丝屡屡的清风，预示着风雨的来临……一直以来我都学不会控制好自己的心情，总可以为了她们而摆动！数学课上差点就让泪水流下，就只因为无意间有种感觉，她们的空间里没有我的地盘！或许真的是我自己爱瞎想她们并没这个意思，可是，看那样真的好难过，突然之间孤独的感觉将我席卷。趴在了桌上想沉浸一下情绪，弟在一边问我怎么了，我倔强的什么都不肯说，强颜欢笑着……可是，不知是心灵感应还是怎么的，婷就在这时发来了短信，我终于对自己低头，跟她说我好想哭，但是什么原因却怎么也不会说的，她，还是那么了解我，虽然我不肯说，她还是可以一句话就给我给点穿了，好再她也没多说什么！婷，谢谢，真的很感谢她那时的关怀！弟，对不起了，我不是故意不说的，只是我已经习惯了把所有的事都放在自己的心里，不喜欢说出来，很多的事说与不说都一样，没那个必要就别说那么多，我讨厌别人疼惜的眼光，不喜欢让别人担心……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1399', '2000', '躺在学校的草地上，看天上变换云彩~~~离开了家来到陌生的地方，在这里发现一切都不简单，生活有好也有坏，并不是你我能把握的了，少了你们有一点点奇怪，像什么忘了带……为什么快乐又单纯的年代，消失得那么快！为什么那些想要留住的感觉，找不回来……风吹着我们走在回忆里一点一滴慢慢倒带真的好想回到过去的自由自在，那时的我们可以想去上课就去，毫不畏惧老班的脸盘；一不开心就溜掉，拉着大家跑到外面去疯癫，不在意他人的眼光是怎样的惊讶，也不管讲台上老师那气愤急了的红脸；想赖床了又一个电话拉着一个人一起不去学校，窝在暖暖的被窝里！现在，再不想起床，还是得爬起来；安安分分的不迟到，不早退，更不会旷课！比小学生还乖，笔记都认认真真的做！星期一到星期五校门永远都不会向我们招手，只会孤泠泠的嘲笑着我们的无能为力……谁的大学生活会比我们更严谨呢？我们只剩周末1,2,3,4,5,6,7数到今天的号码，是几千几百几十几，我要把它们排整齐，因为我知道少一片都不可以不可以记忆下瞬间……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1400', '2000', '如果你不骗我。那么你和他之间怎么解释呢``？如果你真的喜欢我，那么我该怎么对你`？~已经2年了。该何去何从也许是该有个结果了`。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1401', '2000', '這學期.不知道怎么拉.好像得罪勒科學老師那樣.天天捉着我來駡.超鬱悶!今天.我大老亞雄跟我說他跟臘腸又吵架拉.暈死!這個臘腸.以前兜有看到我的拉.還天天跟祂吵.沒事就少吵點哇!袮們在一起那么久勒.好好珍惜握.哈哈!聖誕快到拉!祝袮們長長久久拉.哈哈.希望伱地吾好再吵拉.祝.對我好的人聖誕快樂哇!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1402', '2000', '今天本来一切都很好的,就是爸爸的出现.我不喜欢他像监视我一样.下午放学的时候我对小瑞很好.是不是他发现了.?我怕,我不像让他察觉什么.我只想这样对他好,他对我好.就可以了,一切就是这样的简单.以前我喜欢他,但他喜欢旖旎.现在我看见他又回来了,我的心也回来了.我又重新燃起了心里的希望.我害怕毕业.不单是瑞,还有包包和刀刀.我不想离开他们.我发现宪是对我很好.这不是我想要的.我不想他误会我.也不想他再这样继续下去.我最保持距离.也像包包说的.我怕失去瑞,怕失去刀,怕失去包.而毕业是我最怕的.神啊,不要让我再失去什么了.阿门.!我只想要简简单单的幸福?难道很奢侈吗?求你了.我现在真的需要他们.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1403', '2000', '︶ㄣ)(☆*\'`.．/`＿峩凭什么説：)偠壹壹咑敗情敵。.(.`~很大聲說只做袮菂`唯ソī.．☆)[sound]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1404', '2000', '或许对现在的我们来说..以后要面对的生活,很困难..但是,我都不在乎..我在乎的,是有你在我身边..只要和你在一起..我什么都可以不要..虽然说,这个世界是多么的现实..爱情,不仅仅是精神上的..现在的爱情,也需要物质..才能,一直维持下去..和他在一起,这么久以来..可以说是,什么样的苦..我们都吃过,所以..对未来的生活,也有着美好的憧憬..我不知道,我和他的未来是怎样..但是,我相信,只要肯努力..幸福,就离我们很近很近..没有做不到的事..只有肯不肯做的事..不就是这样一个道理吗??现在,我的父母..对他意见很大,因此..我们在一起,有一点点的困难..而且,时时刻刻要面对..父母给予的压力..不过,我想,这只是..我的父母不了解他而已..我相信,多给他们点时间..多给我们点时间..我会让他们知道,其实他并不差..我会证明给他们看..我们不再是小孩子..我们已经长大,能养活自己!父母总是为子女想的..他们总是为我们好的..但,我却觉得,父母是一直认为..我们还没长大.还没到..能独当一面的时候..所以,现在对我们才会..一直阻挠..但,我相信.只要我们努力.拿出真正的行动来..我的父母会看到我们的努力..我会自豪的告诉我的父母..我未来的老公.一定不会差.!而且,会很棒,很出色..至于现在,我只祈祷..我的父母能早日同意..能由反对我们,到赞同..甚至给予支持,我们..在圣诞节即将到来之前..我祈祷..我的爸爸妈妈..能真正同意,我和靓的事..我更祈祷,爸爸妈妈..能和好如初...美丽的圣诞之夜..圣诞老公公,你能听到我的祈祷吗??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1405', '2000', '亲爱的爸爸妈妈..如果有一天,你们能看到我的日记..我想在此告诉你们..你们的女儿,我已经长大了..不再需要你们担心我.为我操心..我多想告诉你们..我已经真正长大,此刻..我只希望,你们能好好的在一起..我只希望,在将来..我能和你们一起度过余生...我不想这个家分散..有好多好多的话,我都想告诉你们..我知道,你们都是为我好..但,我也想问你们..为我好,就一定要什么都替我决定.?为什么,不让我自己决定我的事呢?我已经不是小孩子..就让我自己选择将来的路..不好吗??虽然,我并不大..但,现在的我,已经真正懂事了..不需要你们再为我操心了..我已经能面对外面的世界..而且,也有人照顾着我..其实,你们为我做决定的时候..有没有想过,这个决定会给我带来什么有没有想过,这样的决定..我会真正开心吗??谁不希望自己的子女过的开心?但,你们真的逼的我太紧了..以至于,让我在你们的压力下活着..妈妈,爸爸.你们知道吗?.这样活着,真的好累好累..我不想再这样活着..我渴望自由,但,不是没有亲人..在渴望自由的同时,我更需要亲人..爸爸,妈妈,如果你们真的为我好..就让我自己决定以后的路.好吗?如果,你们真的希望我开心..那么,你们就不要再闹离婚.好吗?我只希望,我有个温馨的家..有个疼爱自己的男朋友..有着自己决定事情的自由..爸,妈..我真的已经长大了..不需要你们再操心了..请相信我..让我自己去面对..以后的路,好吗???如果,你们能看到这篇日记..我希望你们能理解我内心.真正的想法..我更希望,爸和妈能回到以前..爸,妈..你们能和好吗??', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1406', '2000', '下周4就要考试了,书还没看几页,不知道为什么,就是看不进去.更热心于上网,听英语,以及买电脑.前些日子去香港开会的照片,传给了好朋友,让我妈去他电脑上看,回来之后,老妈就说要买电脑,我当然高兴.我现在用的这个可以带回家,再买个新的了,我一直嫌这个电脑的硬盘太小.所以立即找了个朋友帮我买电脑,时间算来算去,我们俩都有时间的情况下,怎么也得1月份了.不过,至少自己不用操心,他这方面的专家,我什么都不用想,只带着MONEY就好了,全权让他处理了.其实,我们也已经好久没联系了,开始我是有意不和他联系的,还从QQ中把他删了,我想我是挺喜欢他的,但他有女朋友,而且我们也不可能,所以,避免让自己胡思乱想,就不和他联系了.从开始的时候比较烦,到后来习惯了,再到后来,看到更优秀的人,虽然自己还没找到合适的,却觉得已经把他放开了,所以才主动和他联系让他帮我买电脑.他果然也很帮忙的,从老远的地方跑来帮我买,再安装,从系统备份,到各种软件,再找车帮我搬回去,我很感激.也有一种情不自禁的高兴.也许是私下里想,自己还算有点魅力,会有这样好的朋友.有些人真是这样,认识十几年了,也算是好朋友,但有些事还是不想和他说,有些人认识只有几个月,却什么都想和他分亨,他应当属于后者吧.但是,我心里很清楚,虽然喜欢,虽然有点嫉妒他女朋友,虽然曾经也有机会和他在一起,但是理智告诉我,喜欢归喜欢,找老公归找老公,他不适合我.我要放手,放开他,也要放开自己.我希望我们做很好很好的朋友.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1407', '2000', '你原来一直都在你从来就不曾离开一直深深相信就算分开我们的爱仍在其实你一直都在常在我的心里陪伴我一直在期待你有一天回来你原来一直都在你从来就不曾离开一直深深相信就算分开我们的爱仍在其实你一直都在常在我的心里陪伴我一直在期待你有一天回来原来你一直都在', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1408', '2000', '我觉得刀刀是谅解我了,但是她不太喜欢我跟瑞在一起,我看出来了.就像上面这个图,我将我的爱放飞了,我终于可以把我的寄托给刀刀和包包了.真的,她们再怎样的任性,我都接受.我发现了,瑞的心还是在旖旎那里.为什么?为什么会这样?难道我就这么不堪?也许爱不需要理由.爱,真的可以转交给别人吗?我知道,我曾喜欢过可.但是那种感觉,我一直觉得不真实.我很疑惑,我现在是不是要撑?是不是要继续我心中的瑞.虽然那是没有结果的.为什么....今天球被老师没收了,他不开心.但是没有跟我说什么.还在逃避我.为什么?他真的那么的爱旖旎吗?或许,我真的够不上.我不知道我在他心中的位置.有时候觉得是个多余的人.今天,他这样对我.我很难过.我想,他只是适合在我心中作个希望.不可能的希望.想起过去他对旖旎那样的好.我很伤心,真的.如果这是最后的结局为何我还忘不了你时间改变了我们告别了单纯如果重缝也无法继续失去才算是永恒惩罚我的认真是我太过天真难道我就这样过我的一生我的吻注定吻不到最爱的人为你等从一开始盼到现在也同样落得不可能难道爱情可以转交给别人但命运注定留不住我爱的人我不能我怎么会愿意承认你是我不该爱的人如果再见是为了再分失去才算是永恒一次新的记忆为何还要再生难道我就这样过我的一生我的吻注定吻不到最爱的人为你等从一开始盼到现在也同样落得不可能难道爱情可以转交给别人但命运注定留不住我爱的人我不能我怎么会愿意承认你是我不该爱的人拿什么作证从未想过爱一个人需要那么残忍才证明爱得深', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1409', '2000', '人生就是为了找寻爱的过程，每个人的人生都要找到四个人。第一个是自己,第二个是你最爱的人，第三个是最爱你的人，第四个是共度一生的人.首先会遇到你最爱的人，然後体会到爱的感觉；因为了解被爱的感觉，所以才能发现最爱你的人；当你经历过爱人与被爱，学会了爱，才会知道什么是你需要的，也才会找到最适合你，能够相处一辈子的人。但很悲哀的，在现实生活中，这三个人通常不是同一个人；你最爱的，往往没有选择你；最爱你的，往往不是你最爱的；而最长久的，偏偏不是你最爱也不是最爱你的，只是在最适合的时间出现的那个人。你，会是别人生命中的第几个人呢？没有人是故意要变心的，他爱你的时候是真的爱你，可是他不爱你的时候也是真的不爱你了，他爱你的时候没有办法假装不爱你；同样的，他不爱你的时候也没有办法假装爱你。当一个人不爱你要离开你，你要问自己还爱不爱他，如果你也不爱他了，千万别为了可怜的自尊而不肯离开；如果你还爱他，你应该会希望他过得幸福快乐，希望他跟真正爱的人在一起，绝不会阻止，你要是阻止他得到真正的幸福，就表示你已经不爱他了，而如果你不爱他，你又有什么资格指责他变心呢？爱不是占有，你喜欢月亮，不可能把月亮拿下来放在脸盆里，但月亮的光芒仍可照进你的房间。换句话说，你爱一个人，也可以用另一种方式拥有，让爱人成为生命里的永恒回忆，如果你真爱一个人，就要爱他原来的样子─爱他的好，也爱他的坏：爱他的优点，也爱他的缺点，绝不能因为爱他，就希望他变成自己所希望的样子，万一变不成就不爱他了。真正爱一个人是无法说出原因的，你只知道无论何时何地、心情好坏，你都希望这个人陪著你；真正的感情是两人能在最艰苦中相守，也就是没有丝毫要求。毕竟，感情必须付出，而不是只想获得；分开是一种必然的考验，如果你们感情不够稳固，只好认输，真爱是不会变成怨恨的。两人在谈情说爱的时候，最喜欢叫对方发誓，许下承诺我们为什么要对方发誓，就是因为我们不相信对方，我们根本不相信情人，而这些山盟海誓又很不切实际：海枯石烂、地老天荒，都不能改变我对你的爱!明知道海不会枯、石不会烂、地不会老、天不会荒；就算会，也活不到那时候。许下诺言的时候千万注意，不要许下可以实现的诺言，', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1410', '2000', '一切,一切的一切,难道真的都是我错了吗.?为什么他的态度会突然的转变.?难道我喜欢他,爱他都是一种错吗.?原来我是真的不能有爱情的,爱上一个人都会是错,而且还错的那么彻底.我和他,短的竟然连一个月都没有,却什么都给了他,还傻傻的以为会跟他一辈子,我真的有这样想过,可是现在,一切美好的想法都破灭了.我没了自信.我显的好微小.放了他,可我会变成什么样了.?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1411', '2000', '呜~~~~~~~~~~~今天平安夜..我将是一过人度过啊..好寂寞啊..老公和妮娜都要上班，丢下我一个人啦..算了吧，谁要他们都忙咧..祝你们圣诞快乐噢..呵呵..气死我啦，先前的那个日记本不知道么事原因关闭了，以前写的东东都冒的了啦..害我今天又重搞了一个..看到今天是平安夜不生气了吧..第一篇日记要有个好心情', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1412', '2000', '老公..圣诞快乐噢好想和你一起过啊，但是你又太忙了..等下次在一起过吧..嘿嘿..老公，我爱你!一开始我只是想和你玩玩而已，但经过这长时间我发现我陷得比你深..不想离开你啦..也许有一天你会看到这日记，但你看后不要生气啦..因为我爱你..不想对你有任何隐満人...我不奢求你能我任何东西，只想你对我是真心滴..不管以后发现什么事情，一定要相信我是爱你的..老公..我爱你!恩嘛~~~~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1413', '2000', '今天儿子的举动令我瞠目结舌。事情是这样的，早晨我无意间发现墙上有一只小虫，仔细一看是一只蜈蚣，当时我的心揪紧了，怎么办？老公不在家，我虽然不是娇娇女，但是对这种浑身是脚的小虫，还是有些惧怕。儿子被我的自言自语吸引过来，“怎么了？妈妈？”“给你爸打电话，问问怎么办？”“我爸说打死算了”“我不敢”。说完了，我真的不知道儿子会有什么反应。据以往的经验，我的儿子不是那种大胆豪爽型的，儿子是不是也会和我有同样的答案？“你不敢我敢”。语气里透着男子汉的刚毅，我真的喜出望外。接下来一系列的举动，无一不流露出男子汉的勇敢和气势，找工具-瞄准-出击-跑偏-溜走，最后以失败而告终。但是我心里开了花，耳边还时时听见儿子在自语，我随时观察敌情，别然我看见你出来，，，，，看来儿子真的长大了。我家里的新一代男子汉茁壮成长起来了，一个六岁半的小男子汉。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1414', '2000', '好开心的平安夜啊.!真是幸福.我觉得跟他们在一起比她们好多了.我的心很纯净.和包包在街上玩烟火,真的很幸福.我希望以后还可以是这样.希望一切美好的,都可以forever.飞飞和小满其实都好可爱的.我在途中走失了.他们显出很担心.其实我心里蛮高兴的.只是为什么公园没有开门呢?如果去划船就更好了.想到就忍不住笑啊.跟可分了.很踏实的分.我希望他不要跟熙在一起.那样我会伤心.真的伤心.我知道这个要求很过分.不过,我说的是真心话.我今天真的好幸福.只希望这个幸福可以继续下去.一切就这样继续下去.不要停止.永远.....至此祝我爱的人,一切安好.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1415', '2000', '啊哦...今年的平安夜怎么这么热闹,街上的人打堆,我荤哦....受不鸟老哦,⒈点也不好玩,还是跑来上网,玩了,人又多.还难的挤勒,走到那里都是人,情侣又多,会荤s\'我克,我们⒊个女在街上不晓得玩什么,冒的我们的地位,还不如来上网,!(忘了她)好听....电话响把我吵醒请留口讯不想跟你聊天都说好分手怎么你还是不断的给我留言我憎恨爱迪生他利用电力让你不能放弃Ringtone不停的响走到那里都无法跟你保持距离过去就让它过断了线就走既然已经说出口何必想回头不想收到你的信息我不想回应不想接你的电话未接来电都是你的每天27个也许\\我应该更改号码（不接她的电话信息删不掉她）', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1416', '2000', '瑞.带我走的是你,还是命?我离开他.你却注视她.瑞.我讨厌,因为我在乎.不要对我这么冷漠.不要让我被命带走.唯一,想你.记得.我在灯火阑珊处.等你,回头.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1417', '2000', '祝所有在95886网站里的全有成员:圣诞快乐!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1418', '2000', '刚刚很奇怪的接了我老爸的电话，本来是很开心的，可我听我爸说过之后我心里就一直郁闷，爸说你有个同学打电话给你说要交学费了，要你回合肥去，天那！我一下子就想到了安中红，对是他可能是他，除了他之外我想不出还有谁会告诉我交学费，可是他在上海呀，难道他回去了，这个人我都很常时间没和他联系了，我不想在提起他了，我想把这个人彻底的从我的生活里删除，可我刚才听我爸要交什么学费我就在想了，安中红会不会把我的学费给交了呀，记得第一学期的学费还是他帮的忙呢，可我现在一点都不感谢他，我现在认为他为我做的这么多都是理所当然的，都是他欠我的，他欠我的是用金钱也换不回来的，他这样做可能是对他心里有点小小的补尝吧？如果安中在帮我交学费的话，我心里又有一种想法，他真的很爱我吗？是我做错了，不我没有，我不喜欢他这以成为事实，我们分开都快有半年了，合肥让我想念的是小月，还有我的前任男友，至于安中我没有放在心上过，只不过有时候心情很随闷的时候无处诉苦的时候才会偶尔的想起他，至于我现在对他这样都是他自己告成，本来我只是想和他做个普通朋友的，可是没想到眼前会发生这么多的事，我恨你^^^^^^!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1419', '2000', 'Mygad!我该怎么办,对你的思念是一天又一天,孤单的我,还是没改变,一颗爱你的心在向你朝手，在向你微笑,亲爱的你能明白我对你的一片痴心吗?你是否感受到我的这份远在他乡的爱在向你哀求吗?你是否感受到我这份隔山、隔海、隔省、隔市的爱在向你祈祷是否有明天吗？眼前的这一切的一切都只是一个远离他乡，心怀着耻辱的女孩子的一番肺腑之言，炎热的夏季夹杂着女孩子孤寂的汗水，有谁能知道这汗水背后隐藏多少心酸泪？永远也挥散不去女孩子身心的侮辱，她永也忘不了那场谁都没想到的恶梦，刻苦持家岂惮劳？夜深犹补仲由袍。谁怜素手抽针冷？绕砌虫吟秋月高！05．8．19', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1420', '2000', '为什么每天的心情都如此的压抑，为什么小谢他总是在我脑海中浮现，为什么那个恶梦始终阴魂不散，那段不堪回首的往事纠缠她那颗柔弱的心，难道这是她应得的惩罚吗？不我不应该有什么惩罚的,上天到底是怎么了,为什么总是让这么有让进的女孩受到如此屈辱，上帝、主啊、神啊……我现在才知道什么叫着叫天天不灵叫地地不应的说法了，我天天带着痛不欲生的恶梦上班下班，好像全世界就是我一个人的了，少了那时的欢乐笑语，少了那时网吧里建盘的敲击声，更少了天真无邪的青春幻语，现在乘下的就只是我一个虚壳，在乘下的虚壳在寻找丢失的自己，自己呢，自己到那里去了？自己到那里去了？说着说着我就被不堪回首的往事给缠住了，几刻不得自拔，每想到和小谢在一起的甜密的日子我就会不由自主微微的露出幸福的笑意，在想到小谢温柔的吻我时整个人就像是触电了似的一动不动厚受着他那曾经的吻，等到一切的回忆都将醒来时我的心是那么的巨痛，这巨痛如刀铰般疼痛，痛的不能呼吸，有时候我还以为是我的肺结核法作了呢？其时根本不是，现在我可以段定这是一种心病，无药可医，天哪，此时我是怎么了，难道这就叫着爱吗？这就是相思吗？眼前的这种事件只有在小说里才可以看到什么“心病”什么“相思”的这种鬼东东。今儿在网上又见到小谢了，本来就是因为想看看他才去线上的，可见到他却又无言以对，错不是无言以对，而是无脸以对，我好想对他说：“小谢我想你了，天天想并想的好苦，你想我了吗？你要我回去吗？你想和我从头在来吗？小谢我想，我想回去，想和你重新开始，可以吗？小谢你和我说可以吗？咱们之间还可能吗？还可以在回到从前吗？这些我都不关了，我只想说，你想不想？你还爱不爱我？我只要听你说想还是不想，爱还是不爱，我要知道结果就构了，小谢你可知道你的每句话都牵着我的心，系着我的魂，你可以说你不爱我但不许你骗我，因为我是真心爱你，整颗心的爱你，我想对于我这点小小的要求你应该满足我。”可是我没有说，这些话我也就只能放在心里，一个人想过来想过去，我知道我的那些要求太苛刻了，对于他现在是根本不能给我什么，在说我和他分开这么久他也不一定在爱我，还有最重要的是我已不是处女，已不纯洁，我那有什么资格和脸面在说重新开始，在去要求你什么…………？？？05-9-3晚又是好久都没有打开这不堪回首的日记本了，心中有无限的言语又忽然不知从何说起了！也就是今早的一阵阵清风才让我知道炎热的夏季就这样无声无息的告别了这可爱的二零零五年，往常中可爱的我又如同年的穿上了去年的这个时候的衣服，随之那种莫明的伤感也随着清风吹进我心理，工作工作工作……我也工作了好长的时间了，可我什么也都没有学会，不知道为什么，离开合肥的我，心却永远都流在那不干敢回想的城市里，还依然留恋着那几个学校的淋淋总总，“慧愿”好名子，我艳艳将此生铭记在心里，“皖深”——你是培育我的母亲，不论我口中说了你些什么什么对你不利的话，但我始终改变不了，我是你培育出来的垃圾，05-10-25', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1421', '2000', '真是可怜!圣诞节也没有收到一位好友的祝福,上班也是这么的无聊,心情很抑郁,很想自己能够开心起来,可开心是那么的难^^^^^???', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1422', '2000', '以前的今天都是在学校里度过的,往年的今天我都会收到好多好多的祝福,唯有今天我才感觉自己是那么的孤独,感觉自己活了那么久好像什么都没有一样,整个人空空的,好想学校更想上学^^^^^!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1423', '2000', '唐你什么时候能来呢?你手机还在停机,怎么了???我还你钱了,我想你现在还不知道吧!我都快急疯了,你是不是换号了呀,好无聊呀!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1424', '2000', '不知道该从何说起,仿佛是很久以前的事,又好象是在昨天,每天我都会想起他,但不知道想他什么.只是思念,一种不肯放过自己的难过.认识他很突然,在他对我表白以后我考虑了很久,喜欢他是种不能骗自己的感觉,但我知道我一旦决定谈恋爱就会很认真,我怕他不认真,会辜负我,在他说了好多之后,我们在一起了,那是段很美好的时光,只是...很短暂的两个半月,其中有一个月放假我们根本没有见过面.两个半月,却让我用尽了半生的快乐,离开了,走了,不能再见面了,我听到自己的心被撕裂的声音.我假装很坚强,不流眼泪,告诉自己不难过,要开心.要笑着生活,不能让任何人看到自己的脆弱,可这些有什么用，这么久了,我每天都要想起他,虽然记不得他的摸样,想不起来有那短短的一个多月有什么可想的,但还是想,一种不肯放过自己的难过,每天侵蚀着自己.前几天终于受不了,因为生活中其他的事情压抑着,喝醉了,不知道自己怎么回的家,不知道自己哭了多久,只是难过,只是哭,不知道别人失恋都是怎么医治的,我始终找不到自己的方法,因为我失恋和恋爱时一样,认真和固执,固执的不可理喻.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1425', '2000', '今天是圣诞节!而昨天又骗了爸爸,妈妈说学校搞活动然后就和柳星在她家看一晚上的vcd其实是蛮累的但是,我们两个傻瓜都没尝试过以为会很happy哪晓得今天补课都打瞌睡!一个上午我都没有画多少笔(基本上是一笔都没动啦,嘻嘻~!)但是到学校看到同学们都一个个疲惫不堪的样子就觉得好好笑都是爱玩的傻瓜啦!(以后就要好好学习了哦,记得自己的梦想哦!加油bb,qq!)2005.12.25', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1426', '2000', '-真的要走吗?-别哭,我只想去看更广阔的世界-去看桑托林的白色建筑和醉人的蓝色-去看春天普罗旺斯紫色的熏衣草田,如何在堇色的天空下奔腾而去越过平原,延绵接天......-去看地中海七月的九重葛,于是墙上蜿蜒层叠,描画成思念的凉荫.......-然后,我会带着礼物回来告诉你,这世界有多美......', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1427', '2000', '我不想再这样麻木的等下去，爱下去了，付出了四年我想已经足够了，笑过，乐过，同时也哭过，伤过，我已经很知足了。其实在感情上没有谁对不起谁的，想付出的就付出，不想付出的话就别付出了。在感情的世界里很简单的，只有存在爱与不爱，想开了想清楚了，一切就不会在变的这么复杂。你知道吗？我已经找到一个值得让我去爱，去付出的人。以前我跟他的感情只有他一个人在那里维持着，可是我发现他一个人支撑的很累了，是时候我跟他一起去努力，一起为自己的幸福而努力了。但是我还是会支持你的，因为你是我喜欢的人，昨天晚上真的很开心你能打电话给我，因为在你不开心的时候你还记得有我这个朋友，再说了有时候有些话放在心里很难受的，说出来会舒服很多，真的。我希望你能把我当你的好朋友，能信任我，而不希望在我面前伪装自己。有时候偶尔放松一下自己会好点。如果你打电话给我聊天的话，无论多晚多想睡觉我都会睁开眼睛接你的电话，树起耳朵听你讲话，以前一样，现在也一样，将来也不会变的。真的很希望你晚上能过来跟我一起过noel。。。。。。。。。。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1428', '2000', '那天拿着袮的手機.髮現有個女的怎么那么在乎袮!那么緊張袮!電話幾時個.信息顯的更在乎!更緊張.我看勒.材髮現自己其實更緊張袮說過隻有我一個的!別騙我哦.袮知道我不喜歡別人騙我的!昨晚(平安夜)好開心哦.好愛好愛袮呀!老公!袮昨晚說什么不想跟妳一世我覺得好無奈握!說的我那么不在乎是我昨天接到祂電話無言而已!就在燒烤場祂兜狂打來我暈死!艾.我說祂對袮有意思袮說祂對袮有袮不會對祂有的我害怕袮丟下我一開始我不敢去愛袮我隻覺得一場遊戲而已隻以為開開玩笑但日子長勒我並不這么認為問心的那句我是愛伱的!也許我們的感情恨深我們認識7年勒.希望我們的愛一直延續到無數個7年直到我們老死!哈哈.伱願意嗎.老公.我愛伱呀.伱說過有我不會有第二個的別忘勒哦現在婷我不知道祂怎么想的但我絕對不會離伱而去除非伱黎我而去我一輩子在伱身邊可以嗎每日想我一次便夠勒哈哈.說好拉不許吵架.有什么問題要好好麵對的み.呆櫫&!18:46:07第3日``第一次自己哎我老公啊!118:48:32第三日.?..み.呆櫫&!18:47:25系啊``哩3日我觉得你都晤理到我!從那刻起.我佷在乎佷在乎伱み.呆櫫&!13:42:128`8`老婆!!着多件吖!!伱也要註意身體呀.知道嗎.!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1429', '2000', '很想小瑞,想他的动作,想他的脸.但是想到他,我总是很难过.我关心他的时候,他在关系旖旎.我没必要恨什么.这是命.也许爱就是子弹.爱了,就要受伤.我不悔.一个人背两个人的债,很适合可.他替我背了债.我伤了他.我欠了他.如果下辈子我还记得他,我死都会跟他在一起.而这辈子,我会为小瑞这样.瑞,拜托,不要让我太难过.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1430', '2000', '我快乐么.？连我自己都不知道..!所以人看到我都以为我是快乐滴..没有一个人知道我内心的想法..每次当我发呆时老公总问我是不是有心事，而我却否认了..我不想让他知道我不快乐，我不想看到他为了我而不快乐..虽然不想让别人知道自己不快乐，但我真的不想在伪装了，这样好累啊.压力好大..但我又能怎么办呢？我只能一个人承受所有的事情，让香烟来麻醉自己...~~~~~~~~一个人承受所有事情.好累啊..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1431', '2000', '现在是圣诞节的晚上8：50只是在伤感这一天有过了我们在一起的时间又少了一天刚刚去放了烟火虽然看到烟花那么美丽的绽放心里有几许羡慕几许嫉妒但是当她们又以一种美丽无奈的方式在我眼前渐渐以美丽的姿态消失的时候我突然感到她们那么脆弱那么短暂那么寂寞于是我无理由的想起了你我突然觉得眼前嬉笑牵手拥抱的情侣那么扎眼心像陋了风一样冷飕飕凉冰冰的我看着手上即将幻灭的焰火依然寂寞孤独无奈但是我却深刻的感觉到我比烟花更寂寞', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1432', '2000', 'KK相信你现在已经看完,我最后的来信了~~~你一定很开心吧~~今年的圣诞节,一定过的很快乐吧~~有她在你身边,你一定很幸福吧~~~就让我平静的过完高中的最后一个圣诞节~~~为什么这么想你呢??为什么会这样??要学会忘记啊~~圣诞节快乐~~~JJ这是我对自己的祝福~~~~~~~~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1433', '2000', '[FACE=隶书][/FACE]......今天是圣诞节,亲爱德,之前你说你会陪我过..你说你会找我,让我⒈直⒈直的期待着今天的到来..但到最好才知道始终还是⒈个人,就这样,孤孤单单⒈个人的过着..好失望,你再⒈次食言..好难过,我再⒈次被遗忘..好沮丧,你会和谁在⒈起..亲爱德,我有想你,而你有吗.?今天我又不回家,我也不知道你是否打勒电话找我.就当你没有打吧.应该没有打..本来我也并没有抱太大的希望,又何来如此心痛的失望.?算勒吧,我是彻底死勒心绝勒望,我们这样到底还可以持续多久.?昨夜睡觉点燃⒈根烟,却在我手中被弹断,今夜坐在电脑前,却有⒈滴泪滴在键盘上,亲爱德,你没有来..还是考虑放弃吧,!你,圣诞快乐.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1434', '2000', '豬.平安夜有伱陪住硪.真系好开心吖.虽然都系度兜但系硪觉得只要伱系硪身边.真系好满足吖.好开心.硪对伱.你应该好清楚.伱讲过隻準有我.無準有其他人呀.听完真系好感动吖.真枷!硪要既就系哩种,不过硪晤明点解你晤卑硪去学校接你.到依家你都未同硪讲过.硪真系好想知.点解吖.硪说过.有你很舒服.没错.伱卑既就果种系好舒服.虽然你要返学.但系硪总觉你系硪身边.硪可以等你.真系可以吖.硪最惊既就要你丢抵硪.你成日话除非硪丢抵你.根本就無可能.硪都晤会甘做.一定.ㄍ.情定今生隻愛她.zmzの)', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1435', '2000', '昨天是我们在一起过的第一个节日，我真的很开心~.可是真的我不敢让自己更喜欢你了，因为我发现只要有她在的地方对于你来说我就象一个隐形的一样......不知道是我不相信你还是不相信自己了，但是我已经可以确定了，你让我越来越没自信了。真的害怕看到你们在一起了，但我之能当作无所谓.....', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1436', '2000', '哦`！郁闷列~在体育委员的威逼下我也要参加那个要命的拔河比赛~！哎~~也不知道我们班会不会又是个倒数第一不过就算那样我们也要好好努力！马上就要放元旦了，好爽哦！不过蛮着急的是过了元旦就要期末考试了！哎~！烦列`！考不好我就死定了！所以一定要努力！加油哦~青青！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1437', '2000', '耶~拔河我们赢也哈哈~好开心哦我们终于赢了我看到从大家脸上流露出的那么无暇的笑那是一种从内心发出的不可能伪装的笑容那一刻我才发现原来202班的每一个人都那么可爱当我们尖叫当我们击掌当我们拥抱我才突然觉得和他们相处在一起原来这么轻松~我触摸到幸福的感觉是在202班哦~！^-^', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1438', '2000', '[COLOR=#8a2be2][/COLOR]2個朲評評啖啖才是眞.細氺長流才昰愛.☆擁哊袮是wǒ゛①輩子dё婞福oо', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1439', '2000', '我还是决定要安静的等待你的爱.我对你的感情若是跟你说了,你会有困扰.我不想这样.只想好好的跟你相处.但是,瑞,你能不能不当我的面对她那么好.我会伤心,很伤心...即使心里有再怎么样的痛,我也不会让你知道,我只愿等.安静的等.等你回头,回头时,你会看见我,在灯火阑珊处等你.安静的等你.永远....只希望你不要拒绝我对你的好.没什么值不值得.只有愿不愿意.我愿意,愿意为你.只愿为你.我的要求其实真的很简单.不管给你幸福的会不会是我,我都会祝福的.祝你快乐,永远的快乐.为什么你总是要在我心灰意冷的时候给我一丝希望.一丝温暖.难道这就是命,是我欠你的?或许,包包的举动,已经给你带来了困扰.我不愿这样.我会跟包包说.我只希望,你关心我.就够了.我不在乎你是否属于我.不在乎.因为希望越大,失望越大.我不想你让我失望,因为那样,我根本没办法说服自己祝福你.我不是要把自己说的很伟大.只是想这样简单的拥有,简单的幸福.一切简简单单就好.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1440', '2000', '好郁闷哦~！晚上又和别人吵架了~本来还不是很hate他的有时甚至还觉得他好帅可是他今天太过分了都那么说我我最讨厌别人说我穿滴怎么怎么样还一直说一直说烦人列·不过我今天好像也有些过火哦那么大声在老师同学面前骂他哎哟~~~烦人列谁叫他先不对啊不过今天也有蛮轻松的事啊今天我已经把那个人彻彻底底的从我心里t出去了他应该不会再从我心里跳出来烦我了吧今天走在他身边都没有心跳的感觉就是看着他也没有原来那种温度了感觉的只有烦不想听到他的声音懒得去想他什么都不愿提起他想他的时候我会调节自己想想他有多对不起自己他做了多少让我是伤心的事反正就是忘了这样我倒觉得轻松了好多哦！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1441', '2000', '明明每次都伤的那么重……那么那么的重……甚至到可以夜夜如此透支生命，甚至到会一瞬间感觉天旋地转，象溺在水中，窒息……可是我不明白为什么我总是会在平和的日子里忘却这些，还是那样开心的笑？还是那样相信那些儿时的侥幸带给自己的已经破烂不堪的自信和自豪感。事实一次次证明，那些已经永远成为尘封的往事，被无情的翻了过去。现在的我已经被这些荣誉舍弃，已经被幸运之神唾弃。你们对我失望了吧？……对不起……只会说对不起的人是世界上最没用的人，但是我却这样一次次用无力的声音重复着……我还妄想着用这苟延残喘破破烂烂的一点点信念抓住希望的衣角，躲在父母的庇护下乞求着幸福……可是我悲哀的发现，这样的资格，我早已失去……我还能站起来吗？我还能站起来吧……为了我最爱的父母，即使已经残破不堪，我还是会往前走，即使已经不再纯真，我还是会对他们露出笑脸，因为……我爱他们……可是我却总在对他们默念着“对不起”……我不是一个坚强的人，也不是一个真正能够专心致志的人，我总是浸泡在失败的阴影中，起来后却不能把悲伤化为力量全力以赴的奔向光明，所以我才沦落成为了最失败的人……我没有资格怨天尤人……坚强、全力以赴，如果不能拥有这些，等到我的只有灭亡，我没有丝毫的信心能够使自己拥有它们任何一个。冰冷残酷的事实……我想笑……大概也只有凄苦一个味道……从来……都没有如此无助……', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1442', '2000', '笑容是美丽女孩最好的化妆品，冷漠是美丽的女孩最大的致命伤', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1443', '2000', '爱情不难，难在离别，怀念常常会美化爱情，最难的爱情，是天天相见如今能有几个人可以真正做到时时想见刻刻不厌呢？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1444', '2000', '人天性里有喜新厌旧的本能，得不到的永远是最好的，', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1445', '2000', '有的人主张爱要爱的潇洒分也要分的潇洒，其实爱情这东西是无法潇洒的，如果真可以作到潇洒，我可以说你那根本就不是爱！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1446', '2000', '用笔尖诉说心灵的语言，用语言概述心灵的沧桑。用沧桑来掩饰心灵的事非，用事非来证实一个人的心醉。写于二零零五年元月二十五日', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1447', '2000', '不伴明窗独坐，不午剩人儿一个，世上何来孤独，人间焉有寂莫，此情无计可消除，才下眉头，却上心头', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1448', '2000', '从来，我没有如此痛楚过，我承认那些小说家笔下的“心碎”的字样。那“心碎”两字实在是不科学，医学的字典里从没有“心碎”这种病，想想看“心碎”的场面，再大的撞击力，也不会把心撞“碎”呀！这种即不合复逻辑的名词真不知道那些没“知识”的人怎么会发明出来，可是我承认“心碎”，因为我就是活生生的例子。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1449', '2000', '因为语文老师点我在班上背书而我又压根就没被所以我就中头彩到她办公室背书~~~oh~~~no~~~~我最最最讨厌的事就是背书而且啊还是文言文~~~啊~~郁闷开始在画室还背得顺溜溜的一道她办公室就半天哽不出一个字~~哦~~~我的命怎么这么苦啊~~~不过为了梦想我一定要努力哦~~呵呵~加油~``~~~~``耶~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1450', '2000', '上专业课又和土耳其疯疯打打的结果连画都没画好~~烦人列~~马上都要期末考试了~~~5555555555555~~~~```好郁闷啊~~我觉得天天早上过的好累啊~~`那么冷的早上在学校住还要6：30就要起床7：10必须离寝难啊~~~``可是如果不那样后果~~~~~~~~~555555555~~~~````我今天起床就晚了那么一点点而已就造成我成了学校回头率120%的人物---t_t眼看时间就要到关门的时间了我就一只手抓着包扣着牙刷牙膏杯子另一只手提着水瓶拼了命奔跑然后在大家的瞩目下用学校的公用水管刷牙洗脸55555555555555````````可是我本来就够狼狈了竟然还有一个不只好歹的家伙在后面疑惑的问“咦?她为什么在这里刷牙啊?!”oh~~~拜托```换做是你你也要和一样的~~神啊~~~救救我吧~~555555555555555555555555555555~~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1451', '2000', '[COLOR=#DA70D6][/COLOR]文字因ぐ爲よ囿伱才让我忘了曾经深爱的那个人,因ぐ爲よ囿伱让我忘记了等待.因为现在,我的心已经完完全全被人占据,而这个人,便是你.是你让我忘记等待的痛苦,是你让我忘记自己曾经多么的爱他.现在我爱的人是你,我的心再也容不下别人,所以请你相信我们之间的爱情,我对你的爱,是一份完完整整的爱.也请你全心全意的来爱我.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1452', '2000', '老公!伱今天怎么勒.係米嬲我呀.?我吾係吾卑妳黎接我我都想每日見到伱可以陪多點伱但係我每日放學之后隻想返屋企休息因為我每日兜好纍好纍希望伱會明白拉!好嗎.伱今日叫我不要離開伱我一定不會離開伱的除非伱不要我我是不會丟下伱的!今晚打電話給伱的時候伱的語氣我超級無奈伱到底是怎么想的伱又不肯說我聽!以前說過.有什么問題我們要一起麵對的說過的不要忘記伱吾好咩兜話自己吾好我想多點了解袮袮點唸嘎就講我聽好無呀.!?.老公.我好愛好愛袮的我們不要分開.可以嗎.我們一起要幾輩子的≮;*幾輩子不變\'。永恆的愛.就是我們伱永遠是我的最愛!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1453', '2000', 'み.呆豬&!　——〖我愛伱〗/.豬ㄍ,-.pIg.mY.LovER°]≮;*幾輩子不變\'。真棏好瑷伱隻準有我.無準有其他人呀.1″我只想要讓伱開心﹑--ㄍ.情定今生隻愛她.zMzの)', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1454', '2000', 'み.苯豬&!　——〖我愛伱〗/.欽ㄍ,-.qIn.mY.LovER°]有袮在身邊直到永遠!ｑ【&&-------------------】ㄍ.情定今生隻愛他.cJqの)', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1455', '2000', '▓05.12.15′', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1456', '2000', '真的不晓得最近在做些什么，真的好无聊的勒,白天睡上中午才起来，起来就不回克乐,到了晚上11.12点才回克,在这样下克我自己都不晓得自己天天在做什么哦,今天折腾了⒈下午,中午起来,就出克,有2点勒,去南街派出所,办身份证,讲搬迁到高山背克乐.又克了那里,找了好久都冒找到办证的地方,到了⒋点,才问到,天又下起雨,烦s\'勒,累s\'我勒,找到就照相,照完又讲要2张相片怎么的,又到附近去找照相馆,马上照完就拿起克,搞到5点,终于搞完勒,问她多久可以拿,要过完年才可以,昏......还要这么久,搞起今天走了这么久,累s\'我勒,办这东西也蛮麻烦的,这几都这样.今天还做勒件事情,天天就是打摆子的,下午出克走到晚上才回克,时间就这样⒈天⒈天打发勒.!差不多每天都在上网,这几天都下雨,出来也麻烦,不出克,又不好玩.!(故意)你说你想放弃　而他　却不能说忘就忘掉　强自镇定　但泪已满眶啊何不　你只（且）当它　是做一场戏　试着去将它演完我想感情不能勉强　不是互相讨好就好　苦苦哀求　其实不能怎样再说　他越是在乎　真的只会　会让我心里想逃不是我要故意对你好　只是已经付出我还能怎么样难道这样的要求也算高　是要我消失面前　痛苦才不来到不是我要故意对你好　你可曾明白到我为何要这样难道真情逃不过煎熬　是你不敢要　还是你根本不需要', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1457', '2000', '为你翻山越岭,却无心看风景.我只愿为你.请不要把我的关心丢在一边.不要把我的感情当作不值得的事.喜欢是无罪的,爱亦无罪.就像上面这幅图,叫勇往直前.我喜欢.包包可能是累了,伤了,难过了.所以才会说不撑了.但是她不会那么容易放弃的.我知道,我了解.天蝎就是嘴硬心软.我还是会帮助她的,但是我永远尊重她的意思.我不能说我是爱,但却是深深的喜欢.也许你不明白.你是我勇敢的力量,坚定的信仰.你已经几天没有跟我说过温暖的话了.我不要.....我的遗憾,我的期盼,你知道吗?你就是我温暖的力量.忠于自己的,忠于灵魂的信仰.我的感情已如潮水,将我向你推.你也放下你心中的闸门吧!爱就一个字.我只会说一次,但不是现在.我现在不会让你知道.我不愿...我想毕业再告诉你.不管结果是什么.起码我无悔了.我说出来了.我争取过了.只是不希望,你让我太失望.莫名的喜欢了张信哲的歌.因为他的歌词很适合我的心情.每次听到我都会想你.想你的怀抱,我什么时候可以感受.也许这是个奢侈的梦,但是,是那么的幸福.那么的让我勇敢.心中莫名的激动.因为有你,因为想到你.爱,就一个字.而我,对你,千言万语.不说,只要你可以在我需要的时候,让我牵你的手.不在乎是否走进过你的心里.只是,求你不要忘记我,无论我在什么位置.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1458', '2000', '其实我并不想哭只是眼泪不曾知道其实我并不想哭只是我的心有些痛其实我并不在乎你用什么方式对我其实我只是有些难过难过你为何不肯告诉我你想的是什么要的是什么我从来不知道你想的是什么要的是什么你从不对我说爱与不爱教我应该如何选择其实我真的好想明白在你冷漠的眼中是否有我', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1459', '2000', '[COLOR=#ff00ff][/COLOR]ｗǒ[].^╱眞啲..好__(_熹歡)伱㊣^ヤ_愛伱↘就吥会oo轻易說ツ放棄_ヤ㊣─---のミ^ō^ミγ┈┈。ˋのˊ.ひ.┈不管結局如何゛ヾo.┈---→我都會勇敢撐下去..ひ`ヾヽ.讓時間去證明....o.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1460', '2000', '每壹滴﹎;[眼淚]﹏▽ǐ都哊它落下啲→.感情．o___每①个︷罒[拥抱]▽︷ю都哊它碰触啲→.理由．^+┈o．ɑ□﹎珍惜﹎℡永逺啲依靠の㈠世啲愛綪', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1461', '2000', '今天好搞笑的,⒈个人加起我,问我是不是在骇客上班,我讲原来是的,他讲他在找⒈个女孩子,是在这样上班的,现在没有看见她勒,他和我讲从来没有这样,还说⒈见钟情,什么什么什么的......偶荤.他说我不理解他,他讲他原来不相信⒈见钟情....现在明白了...!呵呵..真是搞笑哦......现在让回想原来...真的好有趣哦.想起原来在骇客的时候........想起原来我怎么认得猪的时候,就是那种感觉...让我想接近你...所以才有我们现在.....哪个时候哪种怪怪的感觉,自己都不清楚....那个时候慢慢让我清楚的是..对你也是⒈见钟情的感觉....就是这样慢慢的让我晓得的...慢慢又这么快的接受....⒈切的⒈切..都和我以前不一样..自己都不晓得自己.....我只相信我是这么快的爱上你....相信你....渐渐的容纳不下任何人....我的心里只有你⒈个人.....自己都搞不懂..!s\'猪,为什么我这么爱你......(你是我的幸福吗)总是相信有更好的会在前方就不顾一切的飘洋过海去用尽一生寻找倦了累了渴望拥抱却找不到才忽然想起你还在我身后静静等着我给我依靠你是我的幸福吗?为何幸福让人如此犹豫爱情渐渐模糊你的付出我总不够清楚你是我的幸福吗?为何幸福让人变的忧郁我爱你不再怀疑只想对你说我愿意', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1462', '2000', '放学后和儿子一起早在回家的路上，雪后路滑，我踩在一块塑料布上，嗖的滑倒在地，手里拎得饭盒甩出去老远，咣当一声重重得摔在地上，儿子的一只手套也躺在地上，原来领着儿子的手，从儿子的小手里滑出来顺便把他的小手套也带掉了，两个膝盖沾满了雪，手套上也沾满了雪，好在不怎么疼。儿子把我拽起来，妈妈疼吗？不疼，吓死我了。呵呵，没事。继续赶路，忽然儿子说，妈妈咱们回来的时候把那块塑料布捡起来扔到垃圾箱里吧，要不然别人再踩倒又摔倒怎么办。儿子的话，是那么自然，没有任何企图，没有任何目的，就是浑然天成，发自肺腑的一句话，当时给我的震撼却是非常强烈。我一方面在庆幸儿子有一颗善良的心，另一方面又在担忧，将来当儿子面临险恶的社会环境时，是不是显得过于愚钝，他能够融入这个社会，适应这个社会，游刃有余的在社会中穿行吗？真的不敢继续想象了。', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1463', '2000', '你不肯为我唱歌,你只为你心爱的人唱.你只为旖旎唱过.你这样,叫我情何以堪.我很难受.我的心里现在很乱.我不该跟宪太过亲密了.这样不好.过去的总会过去,不堪回首.我要忘记.今天旖旎那样做,你伤心了吧?但是我也伤心了,伤心你这样对我了.每天都伤.真的.我现在都是再掩饰,过分的掩饰.不怕别人的误会.我犯贱而已.我想让你给我取暖,你不懂吗?我觉得你懂.只是你不喜欢我.没关系,事实就是我要承受暗恋这没有结果的苦.也许你不会觉得对不起我,我会记得.要你幸福,是我一生在乎的事.也许我做不到,但是我不会阻碍.你该奔向幸福的时候,你就走吧.你心里想的人不是我,我又何必寻找这一刻的麻醉药?或许你已经给我了温暖,只是我太贪心了.对,是我太贪心了.你这样做,我应该满足.我还伤心什么,还要求什么呢?喜欢的人会让你难受,爱的人会让你伤心.瑞,不要这样.我,情何以堪?你不要的东西,也许我不该拿出来.太傻了.看吧,看我是怎样为你孤注一掷.等吧,等着我遍体鳞伤.听吧,你永远听不到我内心的呼喊.笑吧,在你得到幸福的时候,我也会笑的.说吧,说你在乎的不是我,我却不能放下.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1464', '2000', '最多握握手一起散散步你大量你宽容你是未来滨崎步无论是为什么都好首先最错我的态度懊悔昨日那么嘈然后在霎时之间想起我父母我也不想记起为当天衬衫似你便心急妒忌其实我都很小器对不起只因常常在你附近便拿着你出气原来朋友仔感情再天真亦是我永远也会爱惜的人明日爱他人也记住学会不要紧原来朋友比恋人更高分亦让我开始懂得不记恨若大家都敏感我更要永远记得拒绝再因小事怪人为何没有这条校训再次握握手只想你以后有眼泪放心流冷淡令人很难受无论日后路怎么走彼此老友角色似旧以后在动气关头回望着这场争吵想想也很丑像望着自己的至亲往往太奋勇斗嘴以后再不懂事过人如何共我恋人热吻', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1465', '2000', '老公可能明天就要去廣州勒!好不捨得握.要記得註意身體哇!別病着囬來哇!想伱想伱想伱想伱想伱想伱想伱想伱', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1466', '2000', '呵。唔只点解，硪总系有种讲晤出既Feel。可能系自己太无聊先谂多佐。哎哟！烦S。。。。。。猪。硪真系好爱祢啊。今日问你是否愿意嫁卑硪。你答。。。（愿意）真系好开心。好开心。我唔知道系眯真系可以做到。9我想做到）哈哈但系我想你知道我好在乎你。很在乎。我每次同你行既感觉好舒服。如果你不爱我。同我讲。一定但系我一定晤会不爱你。猪。今日系我地13日一起。但系我觉得我地系一起已经好耐好耐。可能系我地识佐7年既关系。我知道我有时系好蠢。系话有时啊。所以如果我做错乜。老婆。一定要提点吓我啊。知吗？哈哈。最醒既猪眼训拉。去训。娶定你。（我爱你）猪', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1467', '2000', '從來未曾為誰[┈動心..☆情☆.┈⊕゛却因袮┊我格外認真[︵.從來未曾為誰[┈認真oо┈⊕゛祗因伱〃我愛得最深┈--→.o從沒想到我會如此[在乎伱]o...ｌοvё.o.如果ωǒ说我愛袮。ω说dē..yoｕ是如果。袮會喜欢ω吗？┈', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1468', '2000', '老公.我愛妳!我要嫁給伱!說好拉.非伱不嫁的伱也說勒非我不娶的噢不可以繙悔的哇!豬佷愛欽呢!心裏隻有伱一個!~~~愛人永遠隻有一個伱~!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1469', '2000', '▲,【⒈個秂滴精彩.』.哈哈,又有一个属于自己的日记本。?!今天我们不读书,好高兴,上午我们考试.,么港起我考得还可以呢.?!但是呢,那哈不是我自己的成绩，我们那里面不乱晓得拨.哈是抄呢,么港起那老师也好呢,不管我们.!?啊``今天晚上又不回去,舒服.明天早上肯定要好早就起来.?', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1470', '2000', '爱情,其实是一个陌生的字眼.我可能不懂爱情.所以我想尝试,但是真的尝到了,我会幸福吗?即使我什么都不懂,但是瑞,我还是希望能靠近你温暖的怀抱.我我怎么能就这样的放弃呢?爱是不怕辛苦的,我已经为你跑了这么久,终点应该不远了.如果家是支持我的信念.那你就是我一生的信仰.永远的信仰.也许爱情并不适合我来考虑,我只是想要心中有一个信仰,能够鼓励我向前的信仰.我只要每天能看到你就好了.我现在很想你,应该是说每一夜都想你.但从你的眼神,我看不到什么.什么都没有.这种东西让人琢磨不定,其实我不喜欢.但现在,偏偏爱上了这种感觉.只属于我爱你的感觉.淡淡的忧伤和淡淡的甜.有时候会悄悄的上心头.好奇妙的力量,是你.对你我看不到你对我有什么不同,但是你可以看到,我对你的不同.你不曾注意,我也不想提及.还是就这样算了.包包说,你不在乎旖旎了.真的吗?是真的吗?我不信,不会信,你对我说我都不信,因为我知道,骗别人比骗自己容易,我要怎么跟你说我的心事,可能现在跟宪飞我都比较随便.但是跟你,我随便不起来.只能形式上的接触.你不会为了我而不管谁了,我只是平凡的一个,并不是唯一的一个.就这样,这样下去.我只为你孤注一掷.真的.以前被你的痴心伤了,伤的不敢爱你.停滞了这么久,直到我发现你的关心,你的善良.你还是你.我很自私,没有从头到尾的爱你,没有一直守着.以后不会了,我会一直守着,守着你不知道,但是是我对你的诺言.我不相信天长地久了,没有什么是天长地久的.我不会让我的爱成为遗憾,不管怎么样,我只对你好,只要对你好.我很满足.如果付出想要回报,那会很累.我觉得,你对我的好,是我赚的.你不会明白,我们的关系,很不一般.一边是母子,有深深的爱.一边是朋友,有淡淡的喜欢.不管是哪种,我都深深的.....深深的....想你.想你的怀抱,能不能属于我?白月光,那么亮,却那么冰凉.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1471', '2000', '艾!好煩哇!呵呵!我吾想亂唸!希望伱明白!不愛我也要坦白說我吾仲意人地呃我嘎!今天.超級無奈我仲以為兩個大男人去添!呵呵!!最后還髮我脾氣!暈死.我吾仲意幹擾人地所以先吾髮卑伱架!儍嘎!之后打電話卑伱聽到全部女仔聲.吾想再繼續講落去勒!唉,不想勒.係蘇嘿身上我已經知道伱有伱嘎交友權利我兜管吾到嘎!呵奇怪係伱今日問我同創仔!可以肯定甘答伱係無我心度隻想有伱一個但我驚我認真過頭!卑伱傷害到!希望伱係認真架拉!玩玩下嘎.就早點同我講.ok.?今日真係好鬼煩..從未試過係班主任課訓.點知道今晚晚自習竟然會訓着!還好上音樂課仲有個小胖陪我玩但係佢.我訓着佐竟然係甘吵醒我隻好同佢玩咯!害我沒的睡到現在纍死!不過最開心嘎就係上埋聽日嘎晚自習就吾使上咯!聽到呢個消息!真係開心嘎姐!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1472', '2000', '\"其实今天也没什么好开心的.就是把小瑞的笔带回家了,但是我却有一种异常的快乐,不知道为什么.好奇怪哟.....嘻嘻,但是上午我有点不开心,为什么我总是等他,但是他不等我呢?我等他只是为了那个拜拜呀...!可是,他可能以为我们是在等宪和飞,才没有,我真的好想让你等我,真的想告诉你,我等......只为你.哪怕只是一声\"\"拜拜\"\"我都很开心.真的.怎么说,我今天还是很高兴的.我不想再掩饰,不可避免的心中有一些不悦.但是我不会让它再发生.我知道我想要什么.一刻的幸福不是我要的.我要的是forever的爱和幸福.那样甜蜜的过我的一生,我不会让它有遗憾.至于,过去的一切.我觉得不值得我提.现在很想小瑞,我想,如果他多在乎我一点,我可以什么都不要.只是他没有这样做,所以我会把包包摆在第一位.永远的第一.人有时候是要往美好的事务去想,一切才会美好.我想,我可以幸福的过完这个初三.因为瑞,因为包包.我只是怕,怕下个学期,我不能和瑞坐这么近了.那心的距离就会越来越远.我怕,我真的怕.我现在心里很矛盾...但是,我宁愿跟刀刀坐一起.以前的感觉很快乐啊.同桌才是比较重要的.其他的,是我的,就会在我身边,不是我的,求也求不来.应该是这样吧,我只是想好好的过我的初三,就这样....如果瑞可以对我好一点的话.....我会更幸福的.\"', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1473', '2000', '过去就是永远.既不回头,何必不忘.我不会放弃,属于我的幸福.我会等,等幸福就这样降临.然后,牵着他的手.forever夕阳下,黎明时.两颗永远温暖的心.瑞,不是代替品.而是我应该追求的幸福.我把你给我的温暖藏在心里的,你是我永远的力量.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1474', '2000', '-佬嘙聽好:1.要恏恏噯俄.吥要花惢.吥要去泡仔.發現﹎﹎.打.2.要學做家務.吥要佬是指望老公我.因為我什麽也不會.否則﹎﹎.罵.3.要兲兲陪俄.每兲在床上說一個僾情故事再睡覺.吥然﹎﹎.踢.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1475', '2000', '-︴.漸漸dé`...ωǒɑɑ.ɑ.嘻歡仩了伱ɑɑ.ɑ.壞壞啲感觉灬ミ.o從沒想到﹊莪會茹佌[在苸伱]o..o.不管莪們結局寔否[唍羙]o.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1476', '2000', '想怎样就怎样，就是问你要怎么样，怎么样啊？？？？', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1477', '2000', '[COLOR=#ff7f50][/COLOR]呵呵。好高兴又有一个新的日记本本了诶~哈々..', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1478', '2000', 'エ゛茜苽頭~15:44:08爽晤爽啊み.呆豬&!18:00:15mie咩爽吾爽啊.エ゛茜苽頭~15:46:20呵呵，你自己唸拉み.呆豬&!18:01:47咩啊.エ゛茜苽頭~15:46:47哎，同李清~~~~~~~~み.呆豬&!18:02:20李清邊個.!?エ゛茜苽頭~15:47:58你晤系本人啊み.呆豬&!18:03:29係啊.么事.!李清邊個!エ゛茜苽頭~15:48:29冇野啊鬱悶.!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1479', '2000', '今天拼命拼命在网上申请了一个日记本,想要把这些日子以来所有的委屈,所有的快乐和不快乐.以及所有的眼泪都记录下来.可是等到注册完毕后,才发现我不想了.但是无论如何,我一定要记点什么下来.我没有了工作,应该说是我从来就没有工作,只是我的实习期已经满了.到期.我必须回家了.回到这个安静的,干净的空间里面,也许我真的很洒脱,我不在乎这个,可是,为什么真的当我安静的坐下来的时候,却情不自禁的回忆呢,回忆那里的一切,一切,也许,那里的设备是很破烂,也许那里的人都不是那么的友好,也许那里并没有什么值得留恋的人,也许.....很多也许,可是为什么,当我一想到,今天下午还在节目当中边笑边侃的时候会觉得从未有过的伤心,我真的走了.其实也真的没有什么,不过是在找下一份工作.有什么大不了的.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1480', '2000', '中午去给包包和刀刀买了香水百合,她们都很高兴.我也觉得很幸福,我觉得我可能会气得旖旎要吐血吧?现在的时光,我真的觉得好幸福.是否是一颗心的奇遇呢?今天小瑞对我的好,我真的很高兴.也觉得很温暖.今天又要笑着睡了.虽然我不知道包包是否是真心的.只是从她的话语中,我听得出,我愿意这样.这样一直在她们身边守着.哪都不去了.就这样决定了,幸福不可能永远都是一瞬间得事.我知道,我也在等待.等小瑞,能够明白,并且回头.看见我,在灯火阑珊处,守护我的爱,给他的爱.这就是爱,给你的爱.没有名字,却停不下来.现在我明白了,甜蜜就是这么简单的事.付出了就会收获一些什么.是的,我感觉你离我并不远,但是我依然不会抱太大希望了.我怕拒绝,怕受伤之后的难受.我,小小的爱,在这大城里.好甜蜜.我在花田里放了错,甜蜜的错.但愿永远不要被揭穿.这样很快乐.瑞,我爱你.真的.发誓,我会等你.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1481', '2000', '今日係2005年最后一日咯!希望下一年將有更開心嘎日子吾開心嘎事通通行開!·passthe05.1willhappyつ.·thelastdaywishyou\'reつ.·cjbqfhcmydbpつ.過勒05年/我將會開心過在最后的這天祝福袮們!有些.也許是我給的最后祝福但不知道她們能不能收到怎么兜好.我兜祝福她們以后能開心雖然可能不再相遇.但那也是美好的過去能淡忘就忘記我們當初的所有可能已經不再重要的喇唉.想起.悲哀死!和祂說好喇.過去的不再提.明天就是06.1.1希望能和欽一直走到最后和臘腸的感情永遠不會變我們要一起長大.不變的約定希望伱跟我條靚.啊雄感情吾會變喇開開心心甘係一起啊.哈哈!祝身邊的人.兜開開心心甘過以后嘎每一日喇!06喇.快告別荔香咯.好開心又好吾捨得!哈哈.05年.12月31號晚上11點59分.哈哈.~~~~~~qin!今日見到我英語老師病佐.坐係講臺甘嘎樣.n心痛呀.!missliu謝謝伱喇!給我的支持.我會學好英語吾會卑伱失望嘎.希望伱身體快好返喇!唉..好悶哦!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1482', '2000', '2005年最后一天就要过啦..明天就是新的一天了,我也该有个新的开始..呵呵..~~!!!!!打算明年克学哈英语..要好好学习..做过好伢..!今天要妈妈跟我寄钱我克上学..真tm丢人冒给屋里一分钱却还找他们要,唉.....我要好好工作..不想在让妈妈操心..加油噢...~~~~~~!!!!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1483', '2000', '呵呵.今晚本身心情好低落.饮完酒.都系无变到.直到你打电话卑硪.真系好开心.我每次接你电话都系好兴奋.你话你系海上世界要倒数.我话去稳你..到佐`见到你就马上锡佐你.因为我真系好挂住你..好似好多日無见你啊.我好好爱你.豬.就算见你得一分钟`,我都会好好珍惜.我知道你系学校读书好辛苦`.好累晚晚都唔够训...就黎考试拉.努力.都晤知你间乜鬼死人学校啊.想读死我老婆啊.(靠靠)...新既一年又黎拉.老婆``硪地要长长久久*幸福硪已经碰箌', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1484', '2000', '钦很爱嫒瑷暧嗳僾噯嬡愛懓曖璦皧瞹薆鑀靉鱫豬', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1485', '2000', '已经好几天没上网了虽然今天是元旦但心里还是不怎么高兴因为家里没人就我一个人过节好寂寞哦~爸爸要工作妈妈也要上班哎~~好郁闷哦~明天就又要上学了他们也不陪陪我~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1486', '2000', '我现在才发现啾啾说的那句话好对要给自己带个面具就算是讨厌一个人也还是要给自己留条后路啾啾说我傻我知道那时因为我把所有的事都分得很清楚把自己所有的一面都表现出来但有些事就是要装糊才能让自己好过我也才晓得原来同学们一直议论的那个女生真的是那样哎~~平时我还一直帮她说话列~真是郁闷反正现在把她看清楚还不迟以后列就要好好的生活把一切事情都看开些才能让自己快乐~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1487', '2000', '有人说鱼和鸟是不同的世界的两种东西，鱼永远都不会体会到飞的感觉的，可是我却不觉得是那样，因为成几何时鱼儿会跃出水面曾几何时鱼儿回跃出水面去体验那一瞬即失的感觉！~我会是那一只跃出水面的鱼！有人说鱼和鸟是不同的世界的两种东西，鱼永远都不会体会到飞的感觉的[sound]http://music.73658.com/...拳妈妈lara合唱).mp3[/sound]', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1488', '2000', '[SIZE=3][/SIZE]纳木错我的爱！', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1489', '2000', '爱上一个人也许只要零点几秒忘记一个人可能就要一生我们都逃脱不了这样一个逻辑我们都走在爱与痛的边缘爱了就爱了不要说错了痛也好苦也罢都能让你更懂爱不要再让自己徘徊该是你的就是你的不是你的就放掉至少我们还能自由呼吸还能来到这里听听我们互不熟悉的声音看看我们都能看懂的文字我觉得这很惬意我该惬意不是么因为我已经学会忘记学会坦然也已经学会祝福学会祈祷[/size]爱', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1490', '2000', '06年的第一天真的悶死咯!在傢呆了一個下午.!唉..~實在悶死拉!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1491', '2000', '看勒伱寫的日記!我先知道原來伱有吾開心嘎事兜無肯講講!!吾開心嘎事吾好收埋係心度哦要同我講啊就算我幫吾到伱但係至少卑我知道伱嘎心情兜好啊知道沒有啊!本來我係度唸.伱尋晚係米吾會同我一起過但點知道係我去到車站等車返屋企果陣伱話伱來穩我.我實在太開心勒可以同伱過05最后一日我果陣好希望伱係12點前到嘎但我吾敢同妳講因為我驚伱趕住來岀事.但係伱係12點前真係來到真係好開心啊.哈哈.59分我見到伱啊!我會記得啊.哈哈!一聞到伱的酒味想說伱.但係伱仲係肯係同伱f一起果陣趕來穩我所以就不責怪伱哇老公.我們會永遠的!06年的開始.到世界末日.哈哈老公.伱說過非我不娶的握別忘記啊!哈哈!!雖然伱今天沒和我過但06年第一天伱是在我身邊我也感到高興勒!我不想沒有伱的消息ok.?保持同我聯絡哦!想伱想伱想伱!!愛妳愛妳愛妳', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1492', '2000', '瑞,今天又想起你了.我很快乐.想到你对我的好.昨晚我好像是笑着睡着的,真的很幸福啊.我希望幸福就这样下去,永远在这里.永远不要离开.永远永远......最近喜欢上了forever这个词,是个美好的词.就是爱你,爱着你.我一直都想对你说,你对我的好,就像绿洲给了沙漠.让我们在一起吧...?可是我又怕你的回答.是不是很蠢呢?包包总是跟我说有希望,真的有吗?还是昨天你只是偶然的对我好?我只对你好,明白吗?我只想你对我好.....淡淡的爱,汹涌的扑面而来.我要幸福的崩溃了.还是包包好,是她净化了我的灵魂.让我重新认识活着的意义,也许她还不明白.可我明白了.深深的明白.爱,没什么大不了的.心里的爱,永远是最好的.瑞,如果你不想温暖我.那就让我温暖你吧...我会抹去你心中的伤.毕竟我们都是受了伤的人.珍惜,对我来说.只对我的现在有意义.以前,不重要.你哪里都好,所以谁也代替不了.如果你真的忘记了过去的伤,就让我给你快乐.不要吝啬,我也想要你温暖的怀抱.紧紧的拥抱,爱,很简单.瑞,打开你的怀抱吧.如果你不想拥抱我,就拥抱这温暖的阳光吧.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1493', '2000', '我醉了.一点醉.现实最残酷的,就是必须接受.为什么一定要这样?我的心真的很痛.可我又能怎么样呢?最后就连哭我都要忍着.难道这就是爱,错误的爱.我后悔了.本来我可以很快乐的.听着喆的歌.心里更难受.眼泪就这样下来了.天哪,我做错了什么.为什么你要这样对我.什么叫不弃不离?什么叫一生一世?真的是骗人的.我看明白了.原来输的最彻底的是我.我真的犯贱,有谁来可怜.?谁会可怜?难道哭有用吗?到底我在为谁难过?真傻.既不回头,何必不忘.如果真的可以忘,我早就忘记了.', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1494', '2000', 'み.呆豬&!22:45:25你记住我讲既野..我对你不是玩玩吓!1系好真好真!``我仲要养你枷!1我只有爱你`同更爱你``无晤要你!み.呆豬&!22:45:55一定记住!み.呆豬&!22:48:06恩恩!1记得我讲过既说话!!爱S你拉``猪!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1495', '2000', '老婆。我来武汉这么长的时间.12月18号以后我心情特别好.因为你会跟我说话了.有时间也会打电话或者发短信给我,前面的日子我过的真的很辛苦,我也感受到自己很没有安全感,担心你会跟别人跑掉.又担心你会学坏,一切都因为我不在你身边,这样才让我懂得珍惜.我有时一个晚上都睡不着,在想着你,我好想好想回家,能天天守在你身边.陪你到处走走.弥补我以前不懂得珍惜,说实话,我都觉得我以前那样做真的不是人,我现在体会到,因为我自己也亲身体验过.那种滋味是无法形容的.总之心里好难受,希望我这次回去能改变你对我的看法,我还会是以前那个高中时期的凯凯.今天是新年的第一天.我写下我新的一年里对你的诺言,新的一年新的开始,祝愿,我们的感情在新年里要更上一层楼,我们的生活都是大红大紫的.!2006年1月1日.¨尐豬凱凯﹏', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1496', '2000', '工作的这几个月，我发现自己真是长大了，对待事物的看法也不同了，这几个月我学会了坚强和忘记，我忘记了小谢，不过我真的要谢谢我现在的男朋友安中，我真的要谢谢他一直以来对我的爱，今天我决定要好好的珍惜这份爱', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1497', '2000', '昨在是2006年的第一天，也是我们部门第一次放假，也真是难得，', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1498', '2000', '早上起来.舌头还是苦苦的味道,也许还有一点酒吧,不知道是不是昨天的事,晚上我感觉一晚没睡好.其实我什么都不想回忆了,甩甩头,大步往前走.就是如此潇洒,如此潇洒才是我.我一直很潇洒的.昨天是出了点毛病吧.有些事,越想越苦恼,有些人,越想越难受.何必呢?我又没欠谁的.还是好好的漱漱口吧.这味道太苦了.但是,有一点新发现,原来我额酒量还不错的哟.我还以为我会睡着回来呢.其实是走着回来的.神智还很清醒.就是总是想上厕所.喝酒什么都好,就是这个不好.唉,我想我是爱上喝酒了.这样其实不好吧.一个女孩子喜欢喝酒?有时还会大失仪态.但是,啤酒是液态面包,老师说的,喜欢吃面包,总没错吧.期末考试之后,我一定要好好的喝几杯.宪看起来酒量也不错的,.其实,我还是想要瑞陪我喝,那样倒在他身上也没关系了.嘻嘻.这个想法有点过哟.怎么可以想这些呢?女孩子要矜持一点类下午可能爸爸会给我买衣服,心情可以好一点了.嘻嘻.happynewyear!', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1499', '2000', '今天和柳星又在a区上网真是不听话oh~我早上好倒霉啊~妈妈在客厅拖地我在房间看电视等我迷迷糊糊的从房间走出来要去洗澡的时候一下子因为地太滑又重心不稳狠狠的摔在地下忽忽~~~~害我又被我妈说我“勺”mmd~~~今天又哭了~~~啊哟哟~~因为身上好痛哦~~还有最痛的还是心啊~~妈妈那么说她的宝贝女儿~~不过我们很快就和解了因为我洗澡的时候她还帮我搓背列~~嘻嘻~~~~哈哈~~~~', '', '', '');
INSERT INTO `dede_addonarticle` VALUES ('1500', '2000', '专业期末考试终于开始了今天考的是速写恩~~~~~~~我感觉考的还阔以的拉~~就是最后时间有点紧画的不是想象中的那么好~~不过还好拉~~西西~~过几天就要考石膏素描了~~忽忽`~~我一定要加油加油哦~~恩~~~加油~~还有哦~文化也要加油~