<?php
// +---------------------------------------------+
// |     Copyright  2008 - 2018 weenBizz         |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+

if(!defined('IN_WEENBIZZ'))
  die('File not found!');


// ############################### PRINT HEADER ################################

function PrintHeader($pagetitle, $includetinymce = 0)
{
  global $DB, $stylepath;

  SetPageCharacterSet();

  echo '<html>
        <head>
          <META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE">
          <link rel=stylesheet href="'.$stylepath.'style.css" />
          <script type="text/javascript" src="javascript/admin_functions.js"></script>
          <SCRIPT LANGUAGE="JAVASCRIPT" TYPE="TEXT/JAVASCRIPT">
          <!--
          if(top.location == self.location)
          {
            top.location.replace("index.php");
          }
          -->
          </SCRIPT></head>
        <body>

        <table width=100%" border="0" cellpadding="0" cellspacing="0" class="header">
        <tr>
          <td align="center"><p class="pagetitle">'.$pagetitle.'</p></td>
        </tr>
        </table>

        <br /><br />';
}



// ############################### PRINT SUBMIT ################################

function PrintSubmit($name, $value)
{

  echo '<table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td align="center">
            <input type="hidden" name="'.$name.'" value="'.$value.'" />
            <input type="submit" value="'.$value.'" />
          </td>
        </tr>
        </table>';
}



// ############################### PRINT SECTION ###############################

function PrintSection($sectionname)
{
  global $stylepath;

  echo '<table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td width="15" height="30"><img src="'.$stylepath.'images/section/section_top_left.gif" /></td>
          <td width="100%" background="'.$stylepath.'images/section/section_top_bg.gif" valign="bottom" align="center">
            <div style="font-family:verdana;font-size:10pt;color:#5D729B"><b>'.$sectionname.'</b></div>
          </td>
          <td width="1" height="30"><img src="'.$stylepath.'images/section/section_top_right.gif" /></td>
        </tr>
        <tr>
          <td width="15" height="4"><img src="'.$stylepath.'images/section/section_top_left2.gif" /></td>
          <td background="'.$stylepath.'images/section/section_top_bg2.gif"></td>
          <td width="15" height="4"><img src="'.$stylepath.'images/section/section_top_right2.gif" /></td>
        </tr>
        <tr>
          <td colspan="3">

          <table width="100%" border="0" cellpadding="0" cellspacing="0">
          <tr>
            <td width="7" background="'.$stylepath.'images/section/section_middle_left.gif"></td>
            <td>';
}



// ################################ END SECTION ################################

function EndSection()
{
  global $stylepath;

  echo '    </td>
            <td width="7" background="'.$stylepath.'images/section/section_middle_right.gif"></td>
          </tr>
          </table>

          </td>
        </tr>
        </table>

        <br /><br />';
}



// ############################### PAGE REDIRECT ###############################

function PrintRedirect($gotopage, $timeout = 0)
{

  $gotopage = str_replace('&amp;', '&', $gotopage);

  PrintSection('完成更新!');
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow1"  colspan="2">跳转中...</td>
        </tr>
        <tr>
          <td class="tdrow2" width="70%">';

  echo '<a href="'.$gotopage.'" onclick="javascript:clearTimeout(timerID);">
        完成更新! 如果网页没有跳转，请点击这里.</a>';

  echo '    </font>
          </td>
        </tr>
        </table>';

  echo '<script type="text/javascript">';
  if($timeout == 0)
  {
    echo 'window.location="'.$gotopage.'"';
  }
  else
  {
    echo 'timeout = '.($timeout*10).';

          function Refresh()
          {
            timerID = setTimeout("Refresh();", 100);

            if (timeout > 0)
            {
              timeout -= 1;
            }
            else
            {
              clearTimeout(timerID);
              window.location="'.$gotopage.'";
            }
          }

          Refresh();';
  }

  echo '</script>';

  EndSection();
  PrintFooter();

  exit();
}

// ############################### PRINT FOOTER ################################

function PrintFooter()
{
  global $DB;
  global $stylepath;
  
  $getversion = $DB->query_first("SELECT value FROM " . TABLE_PREFIX . "mainsettings WHERE  title = 'version'");
  $version    = $getversion['value']; 

  echo '<br /><br />

        <table width="48%" border="0" cellpadding="0" cellspacing="0" align="center">
        <tr><td align="center"><p class="copyright">&copy; 2008-'.date("Y").' 闻泰网络. weenBizz V' . $version . '</p><br><a href="http://www.weentech.com" target="_blank"><img src="'.$stylepath.'images/wenlo.gif" alt="闻泰网络" /></a><br></td></tr>
        </table>

        </body>
        </html>';
}


// ############################### GET USER INFO ###############################

function GetUserInfo($user)
{
  global $DB;

  // load guest usergroup at the end of this function unless this var turns true
  $userinfocreated = false;

  // usergroupids that were filled in the usersystem file, needs to be an array
  $usergroupids = is_array($user['usergroupids']) ? $user['usergroupids'] : array($user['usergroupids']);

  // if integrating with a forum, then the usergroupids in $user are from a forum database and not weenbizz
  $usergroupidcolumn = 'usergroupid';

  // start building empty array
  $userinfo                          = array();
  $userinfo['usergroupids']          = array();

  $userinfo['userid']                = $user['userid'];
  $userinfo['username']              = $user['username'];
  $userinfo['loggedin']              = $user['loggedin'];

  for($i = 0; $i < count($usergroupids); $i++)
  {
    if($usergroupids[$i] != 0 AND $usergroup = $DB->query_first("SELECT * FROM " . TABLE_PREFIX . "usergroups WHERE " . $usergroupidcolumn . " = " . $usergroupids[$i]))
    {
      $userinfocreated = true;

      $userinfo['usergroupids'][]        = $usergroup['usergroupid'];

    }
  }


  return $userinfo;
}




// ############################### PRINT ERROR #################################

function PrintErrors($errors, $errortitle = '运行错误')
{
  echo '<table width="100%" border="0" cellpadding="5" cellspacing="6">
        <tr>
          <td style="border: 1px solid #FF0000; font-size: 12px;" bgcolor="#FFE1E1"><u>' . $errortitle . '</u><br /><br />系统运行过程中发现如下错误:<br /><br />';

  if(is_array($errors))
  {
    for($i = 0; $i < count($errors); $i++)
      echo '<b>' . ($i + 1) . ') ' . $errors[$i] . '</b><br /><br />';
  }
  else
    echo '<b>1) ' . $errors . '</b><br /><br />';

  echo '  </td>
        </tr>
        </table><br /><br />';
}



// ############################## CONFIRM DELETE ###############################

function ConfirmDelete($description = '<b>请确认删除:</b>', $hiddenvalues = '', $formredirect = '')
{
  PrintSection('确认删除');
  echo '<form method="post" action="' . $formredirect . '">
        ' . $hiddenvalues . '
        <table width="100%" border="0" cellpadding="5" cellspacing="0">
        <tr>
          <td class="tdrow2" style="padding: 25px;">' . $description . '</td>
        </tr>
        <tr>
          <td class="tdrow1" colspan="2" align="center"><input type="submit" name="confirmdelete" value=" 确定 " /> &nbsp;&nbsp;&nbsp;&nbsp;<input type="submit" name="confirmdelete" value=" 取消 " /></td>
        </table>

        </form>';
  EndSection();
}



// ############################## CLEAN FORM VALUE #############################

function CleanFormValue($value)
{
  return htmlspecialchars(unhtmlspecialchars($value), ENT_QUOTES);
}

// ########################### SET PAGE CHARACTER SET ##############################

function SetPageCharacterSet()
{
  header("Content-Type: text/html; charset=utf-8");
}


// ########################### Show Error Message ##############################

function Errmsg($string) {
echo "<script> alert('$string');  history.back(); </script> "; exit;
}





// weenbizz needs to remove slashes that PHP might have added if magic quotes was turned on

function StripSlashesArray($data)
{
  if(is_array($data))
  {
    foreach($data as $key => $val)
    {
      $return[$key] = StripSlashesArray($val);
    }
    return ($return);
  }
  else
  {
    return (stripslashes($data));
  }
}



// ############################# ADDSLASHES ARRAY ##############################

function AddSlashesArray($data)
{
  if(is_array($data))
  {
    foreach($data as $key => $val)
    {
      $return[$key] = AddSlashesArray($val);
    }
    return ($return);
  }
  else
  {
    return (addslashes($data));
  }
}



// ############################ UNHTMLSPECIALCHARS #############################

function unhtmlspecialchars($string)
{
  // special character handling
  // utf8_decode and reconvert HTML entities (e.g. &uuml; ==> ?
  $trans = get_html_translation_table(HTML_ENTITIES);

  // ipb uses different (or old) entities, so lets fix em to our style!
  $string = str_replace('&#39;', '&#039;', $string);
  $string = str_replace('&#33;', '&#033;', $string);

  // some versions of PHP match single quotes to &#39;
  $trans["'"] = '&#039;';
  $trans["!"] = '&#033;';
  $trans["$"] = '&#036;';

  $trans = array_flip ($trans);

  return strtr($string, $trans);
}



// #################################### IIF ####################################

function iif($expression, $returntrue, $returnfalse = '')
{
  if($expression == 0)
  {
    return $returnfalse;
  }
  else
  {
    return $returntrue;
  }
}


?>