<?php
// +---------------------------------------------+
// |     Copyright  2008 - 2018 weenBizz         |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+

if(!defined('IN_WEENBIZZ'))
  die('File not found!');

// ########################## LOAD ADMIN SESSION #############################

$userip = ( !empty($HTTP_SERVER_VARS['REMOTE_ADDR']) ) ? $HTTP_SERVER_VARS['REMOTE_ADDR'] : ( ( !empty($HTTP_ENV_VARS['REMOTE_ADDR']) ) ? $HTTP_ENV_VARS['REMOTE_ADDR'] : $REMOTE_ADDR );

define('USERIP',                 addslashes(substr($userip, 0, 15)));
define('USERAGENT',         $_SERVER['HTTP_USER_AGENT']);
define('COOKIE_PREFIX', 'bizzmp');
define('ONE_YEAR',                 60*60*24*365);

$sessioncreated = false;

$loginerrors = array();

$usersettings = array();

if(!isset($mainsettings['admincookietimeout']) || !is_numeric($mainsettings['admincookietimeout']) || $mainsettings['admincookietimeout'] <= 0)
{
  $mainsettings['admincookietimeout'] = 1800;
}

function CreateSession($userid)
{
  global $DB;

  $loggedin = $userid == 0 ? 0 : 1;

  $session = array('sessionid'    => md5(uniqid(USERIP)),
                   'userid'       => intval($userid),
                   'ipaddress'    => USERIP,
                   'useragent'    => USERAGENT,
                   'lastactivity' => TIMENOW,
                   'location'     => 'Admin Panel',
                   'loggedin'     => $loggedin);

  $DB->query("REPLACE INTO " . TABLE_PREFIX . "sessions (sessionid, userid, ipaddress, useragent, lastactivity, location, loggedin, admin)
              VALUES ('" . addslashes($session['sessionid']) . "', '" . $session['userid'] . "', '" . addslashes($session['ipaddress']) . "',
                      '" . addslashes($session['useragent']) . "', '" . $session['lastactivity'] . "',
                      '" . addslashes($session['location'])  . "',  '" . $session['loggedin'] . "', 1) ");

  setcookie(COOKIE_PREFIX . "sessionid", $session['sessionid'], TIMENOW + ONE_YEAR, "/");

  return $session;
}


// ############################### USER SYSTEM  ################################
// usersystem is fetched in core.php

// check and secure login info
if(isset($_POST['loginusername']) OR isset($_POST['loginpassword']))
{
  // first secure the data
  $_POST['loginusername'] = trim(strip_tags($_POST['loginusername']));
  $_POST['loginpassword'] = trim(strip_tags($_POST['loginpassword']));

  // the admin panel addslashes to post data, lets get rid of that here
  // it's okay becuase addslashes is actually performed in the usersystem files
  $_POST['loginusername'] = stripslashes($_POST['loginusername']);
	// weenBizz may be integrated with a forum in the same database,
	// or is using the weenBizz User System
	require('login/adminlogin_weenbizz.php');
	$usersettings = LoginUser($_POST['loginusername'], $_POST['loginpassword']);
	
	if(!is_array($usersettings))
	{
			$loginerrors[] = $usersettings;
			$kickuser = true;
	}
	else
	{
			$session = CreateSession($usersettings['userid']);
	}
}
else if (isset($_GET['logout']))
{
        setcookie(COOKIE_PREFIX . "sessionid", "", TIMENOW + ONE_YEAR, "/");

        if($session['userid'] > 0)
        {
                $DB->query("DELETE FROM " . TABLE_PREFIX . "sessions WHERE userid = $session[userid] AND admin = 1");
        }

        if(!empty($sessionid))
        {
                // delete sessions with same sessionid
                  $DB->query("DELETE FROM " . TABLE_PREFIX . "sessions WHERE sessionid = '" . addslashes($sessionid) . "'");
        }
}
else
{
        // ############################## FIND SESSIONID ###############################

        if(!empty($_POST['s']))
        {
                $sessionid = $_POST['s'];
        }
        else if(!empty($_GET['s']))
        {
                $sessionid = $_GET['s'];
        }
        else
        {
                $sessionid = isset($_COOKIE[COOKIE_PREFIX . 'sessionid']) ? $_COOKIE[COOKIE_PREFIX . 'sessionid'] : '';
        }

        // ############################# CHECK IF SESSION ##############################

        if(!empty($sessionid))
        {
                $sql = "SELECT * FROM " . TABLE_PREFIX . "sessions
                               WHERE sessionid    = '$sessionid'
                               AND   ipaddress    = '" . USERIP . "'
                               AND   lastactivity > " . (TIMENOW - $mainsettings['admincookietimeout']) . "
                               AND   useragent    = '" . USERAGENT . "'
                               AND         admin = 1";

                $session = $DB->query_first($sql);
        }

        if(isset($session))
        {
                $DB->query("UPDATE " . TABLE_PREFIX . "sessions SET useragent    = '" . addslashes(USERAGENT) . "',
                                                      lastactivity = " . TIMENOW . ",
                                                      location     = '$location'
                                                WHERE sessionid    = '" . addslashes($session['sessionid']) . "' ");

				require('login/adminlogin_weenbizz.php');
				$usersettings = GetUser($session['userid']);
        }
}

// This will also delete 'normal' weenBizz sessions but that's OK
$DB->query("DELETE FROM " . TABLE_PREFIX . "sessions WHERE lastactivity < " . intval(TIMENOW - $mainsettings['admincookietimeout']));


if(count($usersettings) <= 0)
{
        $usersettings = array('userid'         => -1,
                      'usergroupids'   => '',
                      'username'       => '',
                      'loggedin'       => 0,
                      'timezoneoffset' => 0,
                      'dstonoff'       => 0,
                      'dstauto'        => 0);
}

unset($userinfo);
$userinfo = GetUserInfo($usersettings);
unset($usersettings);

// ############################# AUTHENTICATE USER #############################

if($userinfo['userid'] <= 0)
{
  $kickuser = true;
}


if(isset($kickuser) OR isset($_GET['login']))
{
  if(defined('ADMIN_LOGIN') OR $_GET['login'])
  {
    LogIn();
    exit;
  }
  else
  {
    header("Location: index.php");
    exit;
  }
}



// ############################# LOAD ADMIN STYLE ##############################

$stylefolder = 'advanced';
$stylepath   = 'styles/' . $stylefolder . '/';

?>