<?php
require get_stylesheet_directory() . '/function/poster/poster.php';
/********************
 * 添加菜单
 ********************/
function bit_add_menu_setup() {
    register_nav_menus([
        'top-menu' => __('顶部菜单'),
        'bottom-menu' => __('底部菜单'),
        'mobile-phone-menu' => __('手机菜单'),
    ]);
}
add_action('after_setup_theme', 'bit_add_menu_setup');

/********************
 * 给菜单li添加class
 ********************/
function MBT_menu_classes($classes, $item,$depth) {
    if (0 == $depth) {
        $classes[] = 'nav__item';
    }
    if (1 == $depth) {
        $classes[] = 'nav__item';
    }
    if (2 == $depth) {
        $classes[] = 'nav__item';
    }
    if (3 == $depth) {
        $classes[] = 'nav__item';
    }
    return $classes;
}

add_filter('nav_menu_css_class','MBT_menu_classes',1,3);

/********************
 * 直接获取WordPress用户头像链接
 ********************/
function themetuts_gravatar_url() {
    $user_email = get_the_author_meta('user_email');
    $user_gravatar_url = 'https://cdn.v2ex.com/gravatar/' . md5($user_email) . '?s=200';
    echo $user_gravatar_url;
}

/********************
 * 自定义文章特色图
 ********************/
function post_thumbnail_src() {
    $thumb = get_post_meta(get_the_ID(), 'my_post_options', true);
    global $post;
    if ($values = $thumb['thumbnail']) {
        $values = $thumb['thumbnail'];
        $post_thumbnail_src = $thumb['thumbnail'];
    } elseif (has_post_thumbnail()) {
        $thumbnail_src = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'full');
        $post_thumbnail_src = $thumbnail_src [0];
    } else {
        $post_thumbnail_src = '';
        ob_start();
        ob_end_clean();
        $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
        $post_thumbnail_src = $matches [1] [0];
        if (empty($post_thumbnail_src)) {}
    }
    ;
    echo $post_thumbnail_src;
}

/********************
 * ajax搜索
 ********************/
add_action('wp_ajax_data_fetch' , 'data_fetch');
add_action('wp_ajax_nopriv_data_fetch','data_fetch');
function data_fetch() {
    $the_query = new WP_Query(array('posts_per_page' => -1, 's' => esc_attr($_POST['js-search-input']), 'post_type' => 'post'));
    if ($the_query->have_posts()) :
    while ($the_query->have_posts()): $the_query->the_post();
    ?>
    <div class="search-results__item gh-search-item">
        <a class="search-results__link" href="<?php echo esc_url(post_permalink());
            ?>">
            <div class="result-title">
                <?php the_title();
                ?>
            </div>
            <span class="search-results-date"><?php the_time('Y-n-j');
                ?></span>
        </a>
    </div>
    <?php endwhile;
    wp_reset_postdata();
    endif;
    die();
}

/********************
 * 内链卡片
 ********************/
function xx_insert_posts($atts, $content = null) {
    extract(shortcode_atts(array('station_article' => ''), $atts));
    global $post;
    $content = '';
    $postids = explode(',', $station_article);
    $inset_posts = get_posts(array('post__in' => $postids));
    $thumb = get_post_meta(get_the_ID(), 'my_post_options', true);
    foreach ($inset_posts as $key => $post) {
        setup_postdata($post);
        $content .= '
                                        <div class="col col-12 col-d-12 col-t-12 grid__post animate">
                                            <div class="article__inner">
                                                <a class="article__image" href="'. get_the_permalink() .'">
                                                    <img src="'.get_bloginfo('template_url').'/function/timthumb.php?src='.get_post_meta(get_the_ID(), 'my_post_options', true)['thumbnail'].'&w=800&h=175&zc=1" alt="'. get_the_title() .'">
                                                </a>
                                                <div class="article__content">
                                                    <h2 class="article__title">
                                                        <a href="'. get_the_permalink() .'">'. get_the_title() .'</a>
                                                    </h2>
                                                    <p class="article__excerpt">'.mb_strimwidth(strip_tags($post->post_content),0,160,'...').'</p>
                                                    <div class="article__meta">
                                                        <div class="article__author">
                                                            <div class="article__author-link">'.get_the_author_posts_link().'</div>
                                                        </div>
                                                        <span class="article__date"><time datetime="'.get_the_time('Y-n-j').'">'.get_the_time('Y-n-j').'</time></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        </br>
			';
    }
    wp_reset_postdata();
    return $content;
}
add_shortcode('xx_insert_post', 'xx_insert_posts');

/********************
 * 动态版权
 ********************/
function copyrightDate() {
    global $wpdb;
    $copyright_dates = $wpdb->get_results("
		SELECT
			YEAR(min(post_date_gmt)) AS firstdate,
			YEAR(max(post_date_gmt)) AS lastdate
		FROM
			$wpdb->posts
		WHERE post_status = 'publish'
	");
    if ($copyright_dates) {
        $date = date('Y-m-d');
        $date = explode('-', $date);
        $copyright = "" . $copyright_dates[0]->firstdate;
        if ($copyright_dates[0]->firstdate != $date[0]) {
            $copyright .= '-' . $date[0];
        }
        echo $copyright;
    }
}

/********************
 * 外链卡片
 ********************/
function quoting_external_articles($atts) {
    extract(shortcode_atts(array(
        'off_site_article_address' => 'off_site_article_address',
    ), $atts));
    return '<iframe class="outer-chain-card" style="width:100%" src="https://hatenablog-parts.com/embed?url=' . $off_site_article_address . '" frameborder="0" scrolling="no"></iframe></br>';
}
add_shortcode('quoting_external_articles', 'quoting_external_articles');

/********************
 * 隐藏内容（微信版）
 ********************/
function hidden_content_wechat_version($atts, $content = null) {
    extract(shortcode_atts(array(
        'extraction_code' => null,
        'hidden_content' => null,
        'key_word' => null),
        $atts));
    if(isset($_POST['extraction_code']) && $_POST['extraction_code']==$extraction_code){
        return '
                        <div class="signin animate" style="width: 100%;border-radius: 30px;overflow: hidden;-webkit-box-shadow: 0px 10px 15px 0px #B1B1BB;box-shadow: 0px 10px 15px 0px #B1B1BB;background-color: #878997;padding: 10px;">
                            <div class="signin__inner">
                                <form name="loginform" method="post" action="'.get_permalink().'" class="ludou-login signin-form" style="margin: 20px auto;">
                                    <p class="signin__desc" style="color: #09112B;font-size: 24px;"><span class="iconfont icon-Drawingpin"></span> 隐藏内容</p>
                                    <p class="signin__bottom-text" style="color: #fff;font-size: 16px;">
                                    '.$hidden_content.'
                                    </p>
                                </form>
                            </div>
                        </div>
                        </br>
        ';
    } else {
        return
        '
                        <div class="signin animate" style="width: 100%;border-radius: 30px;overflow: hidden;-webkit-box-shadow: 0px 10px 15px 0px #B1B1BB;box-shadow: 0px 10px 15px 0px #B1B1BB;background-color: #878997;padding: 10px;">
                            <div class="signin__inner">
                                <form name="loginform" method="post" action="'.get_permalink().'" class="ludou-login signin-form" style="margin: 20px auto;">
                                    <p class="signin__desc" style="color: #09112B;font-size: 24px;"><span class="iconfont icon-Info" style="color: #323a96;font-size: 24px;font-weight: bolder;"></span> 此处内容已经隐藏，请输入提取码查看内容！</p>
                                    <div class="signin__box">
                                        <input id="pwbox" type="input" required="true" autocomplete="false" name="extraction_code" />
                                        <button class="signin__button button button--primary" type="submit"><span class="button-content">提交 <span class="iconfont icon-Entry"></span></span>
                                        </button>
                                    </div>
                                    <p class="signin__bottom-text" style="color: #fff;font-size: 16px;">
                                    <small>请关注官方微信公众号，回复：<a style="color: #323a96;">'.$key_word.'</a>，获取提取码。</small>
                                    </br>
                                    <small>官方微信公众号：<a style="color: #323a96;">'.bittheme('Wechat_official_account_name').'</a>或扫描<a style="color: #323a96;">右侧二维码</a>关注。</small>
                                    <img style="width: 100px;margin-bottom: 0px;margin-top: -30px;" src="'.bittheme('wechat_official_account').'" width="130" height="130" alt="微信公众号二维码">
                                    </p>
                                </form>
                            </div>
                        </div>
                        </br>
        ';
    }
}
add_shortcode('hidden_content_wechat_version', 'hidden_content_wechat_version');

add_filter('the_content', 'fancybox');
function fancybox ($content){
    global $post;
    $pattern = "/<a(.*?)href=('|\")([^>]*).(bmp|gif|jpeg|jpg|png|swf)('|\")(.*?)>(.*?)<\/a>/i";
    $replacement = '<a$1href=$2$3.$4$5 data-fancybox="images"$6>$7</a>';
    $content = preg_replace($pattern, $replacement, $content);
    return $content;
}