<?php
/*****************************************************************
 _____   _   _____   _____   _   _   _____       ___  ___   _____
|  _  \ | | |_   _| |_   _| | | | | | ____|     /   |/   | | ____|
| |_| | | |   | |     | |   | |_| | | |__      / /|   /| | | |__
|  _  { | |   | |     | |   |  _  | |  __|    / / |__/ | | |  __|
| |_| | | |   | |     | |   | | | | | |___   / /       | | | |___
|_____/ |_|   |_|     |_|   |_| |_| |_____| /_/        |_| |_____|

 HTTPS://WWW.WPBIT.CN/
 ****************************************************************/
?>
<?php
if (! function_exists('bittheme')) {
    function bittheme($option = '', $default = null) {
        $options = get_option('my_framework');
        return (isset($options[$option])) ? $options[$option] : $default;
    }
}
if (bittheme('upload_file_rename_automatically') == true) {
    //WordPress上传文件自动重命名
    add_filter('wp_handle_upload_prefilter', 'custom_upload_filter');
    function custom_upload_filter($file) {
        $info = pathinfo($file['name']);
        $ext = '.' . $info['extension'];
        $md5 = md5($file['name']);
        $file['name'] = $md5.$ext;
        return $file;
    }
}
if (bittheme('the_article_page_realizes_the_label_automatically_adding_inner_chain') == true) {
    //WordPress文章页实现标签自动添加内链
    $match_num_from = 20;
    $match_num_to = 1;
    function tag_sort($a, $b) {
        if ($a->name == $b->name) return 0;
        return (strlen($a->name) > strlen($b->name)) ? -1 : 1;
    }
    function tag_link($content) {
        global $match_num_from,$match_num_to;
        $posttags = get_the_tags();
        if ($posttags) {
            usort($posttags, "tag_sort");
            foreach ($posttags as $tag) {
                $link = get_tag_link($tag->term_id);
                $keyword = $tag->name;
                $cleankeyword = stripslashes($keyword);
                $url = "<a href=\"$link\" title=\"".str_replace('%s',addcslashes($cleankeyword, '$'),__('查看含有【%s】标签的文章'))."\"";
                $url .= ' target="_blank"';
                $url .= ">".addcslashes($cleankeyword, '$')."</a>";
                $limit = rand($match_num_from,$match_num_to);
                $content = preg_replace('|(<a[^>]+>)(.*)('.$ex_word.')(.*)(</a[^>]*>)|U'.$case, '$1$2%&&&&&%$4$5', $content);
                $content = preg_replace('|(<img)(.*?)('.$ex_word.')(.*?)(>)|U'.$case, '$1$2%&&&&&%$4$5', $content);
                $cleankeyword = preg_quote($cleankeyword,'\'');
                $regEx = '\'(?!((<.*?)|(<a.*?)))('. $cleankeyword . ')(?!(([^<>]*?)>)|([^>]*?</a>))\'s' . $case;
                $content = preg_replace($regEx,$url,$content,$limit);
                $content = str_replace('%&&&&&%', stripslashes($ex_word), $content);
            }
        }
        return $content;
    }
    add_filter('the_content','tag_link',1);
}
if (bittheme('automatically_tag_articles') == true) {
    //WordPress自动给文章添加标签
    add_action('save_post', 'auto_add_tags');
    function auto_add_tags() {
        $tags = get_tags(array('hide_empty' => false));
        $post_id = get_the_ID();
        $post_content = get_post($post_id)->post_content;
        if ($tags) {
            foreach ($tags as $tag) {
                if (strpos($post_content, $tag->name) !== false)
                    wp_set_post_tags($post_id, $tag->name, true);
            }
        }
    }
}
if (bittheme('database_cleanup_optimization_plug_in') == true) {
    //WordPress集成数据库清理优化插件
    require_once get_template_directory() . '/function/wp-clean-up/wp-clean-up.php';
}
function ihuan_avatar($avatar) {
    $avatar = str_replace(array("gravatar.loli.net","sdn.geekzu.org","cdn.v2ex.com"),"gravatar.ihuan.me",$avatar);
    return $avatar;
}
add_filter('get_avatar', 'ihuan_avatar', 10, 3);