<?php
add_action('wp_ajax_nopriv_create-bigger-image','get_bigger_img');
add_action('wp_ajax_create-bigger-image','get_bigger_img');

/**
 * 图像裁切
 */
function timthumb( $src, $size = null, $set = null ){

// 	$modular = QGG_Options('thumbnail_handle');
	
	if( is_numeric( $src ) ){
		if( $modular == 'timthumb_mi' ){
			$src = image_downsize( $src, $size['w'].'-'.$size['h'] );
		}else{
			$src = image_downsize( $src, 'full' );
		}
		$src = $src[0];
	}

	if( $set == 'original' ){
		return $src;
	}

	if( $modular == 'timthumb_php' || empty($modular) || $set == 'tim' ){

		return get_stylesheet_directory_uri().'/function/poster/function/timthumb.php?src='.$src.'&h='.$size["h"].'&w='.$size['w'].'&zc=1&a=c&q=100&s=1';

	}else{
		return $src;
	}	

} 

function substr_ext($str, $start = 0, $length, $charset = 'utf-8', $suffix = ''){
    if (function_exists('mb_substr')) {
        return mb_substr($str, $start, $length, $charset) . $suffix;
    }
    if (function_exists('iconv_substr')) {
        return iconv_substr($str, $start, $length, $charset) . $suffix;
    }
    $re['utf-8'] = '/[-]|[?-?][?-?]|[?-?][?-?]{2}|[?-?][?-?]{3}/';
    $re['gb2312'] = '/[-]|[?-?][?-?]/';
    $re['gbk'] = '/[-]|[?-?][@-?]/';
    $re['big5'] = '/[-]|[?-?]([@-~]|?-?])/';
    preg_match_all($re[$charset], $str, $match);
    $slice = join('', array_slice($match[0], $start, $length));
    return $slice . $suffix;
}

function mi_str_encode($string){
    return $string;
	$len = strlen($string);
    $buf = '';
    $i = 0;
    while ($i < $len) {
        if (ord($string[$i]) <= 127) {
            $buf .= $string[$i];
        } elseif (ord($string[$i]) < 192) {
            $buf .= '&#xfffd;';
        } elseif (ord($string[$i]) < 224) {
            $buf .= sprintf('&#%d;', ord($string[$i + 0]) + ord($string[$i + 1]));
            $i = $i + 1;
            $i += 1;
        } elseif (ord($string[$i]) < 240) {
            ord($string[$i + 2]);
            $buf .= sprintf('&#%d;', ord($string[$i + 0]) + ord($string[$i + 1]) + ord($string[$i + 2]));
            $i = $i + 2;
            $i += 2;
        } else {
            ord($string[$i + 2]);
            ord($string[$i + 3]);
            $buf .= sprintf('&#%d;', ord($string[$i + 0]) + ord($string[$i + 1]) + ord($string[$i + 2]) + ord($string[$i + 3]));
            $i = $i + 3;
            $i += 3;
        }
        $i = $i + 1;
    }
    return $buf;
}

function draw_txt_to($card, $pos, $str, $iswrite, $font_file){
    $_str_h = $pos['top'];
    $fontsize = $pos['fontsize'];
    $width = $pos['width'];
    $margin_lift = $pos['left'];
    $hang_size = $pos['hang_size'];
    $temp_string = '';
    $tp = 0;
    $font_color = imagecolorallocate($card, $pos['color'][0], $pos['color'][1], $pos['color'][2]);
    $i = 0;
    while ($i < mb_strlen($str)) {
        $box = imagettfbbox($fontsize, 0, $font_file, mi_str_encode($temp_string));
        $_string_length = $box[2] - $box[0];
        $temptext = mb_substr($str, $i, 1);
        $temp = imagettfbbox($fontsize, 0, $font_file, mi_str_encode($temptext));
        if ($_string_length + $temp[2] - $temp[0] < $width) {
            $temp_string .= mb_substr($str, $i, 1);
            if ($i == mb_strlen($str) - 1) {
                $_str_h = $_str_h + $hang_size;
                $_str_h += $hang_size;
                $tp = $tp + 1;
                if ($iswrite) {
                    imagettftext($card, $fontsize, 0, $margin_lift, $_str_h, $font_color, $font_file, mi_str_encode($temp_string));
                }
            }
        } else {
            $texts = mb_substr($str, $i, 1);
            $isfuhao = preg_match('/[\\pP]/u', $texts) ? true : false;
            if ($isfuhao) {
                $temp_string .= $texts;
                $f = mb_substr($str, $i + 1, 1);
                $fh = preg_match('/[\\pP]/u', $f) ? true : false;
                if ($fh) {
                    $temp_string .= $f;
                    $i = $i + 1;
                }
            } else {
                $i = $i + -1;
            }
            $tmp_str_len = mb_strlen($temp_string);
            $s = mb_substr($temp_string, $tmp_str_len - 1, 1);
            if (is_firstfuhao($s)) {
                $temp_string = rtrim($temp_string, $s);
                $i = $i + -1;
            }
            $_str_h = $_str_h + $hang_size;
            $_str_h += $hang_size;
            $tp = $tp + 1;
            if ($iswrite) {
                imagettftext($card, $fontsize, 0, $margin_lift, $_str_h, $font_color, $font_file, mi_str_encode($temp_string));
            }
            $temp_string = '';
        }
        $i = $i + 1;
    }
    return $tp * $hang_size;
}

function is_firstfuhao($str){
    $fuhaos = array('0' => '"', '1' => '“', '2' => '\'', '3' => '<', '4' => '《');
    return in_array($str, $fuhaos);
}

//生成封面
function create_bigger_image($post_id,$date,$title,$content,$head_img,$qrcode_img=null,$author,$category,$modified){
	$im = imagecreatetruecolor(800,1360);      //设置海报整体的宽高
	$white = imagecolorallocate($im,255,255,255);    // 海报背景色
	$gray = imagecolorallocate($im,200,200,200);     // 海报水平图文分割线颜色
	$red = imagecolorallocate($im,240,66,66);     // 海报水平图文分割线颜色
	$foot_text_color = imagecolorallocate($im,153,153,153);    // 海报左下角文字（网站副标题）颜色
	$black = imagecolorallocate($im,0,0,0);      // 设置偏移标题的字体颜色
	$title_text_color = imagecolorallocate($im,255,51,51);    // 不知道有啥用的参数。。。
	$english_font = get_template_directory().'/function/poster/fonts/Montserrat-Regular.ttf';      // 海报中用到的英文字体（图像日期）
	$chinese_font = get_template_directory().'/function/poster/fonts/MFShangYa_Regular.otf';      // 海报中用到的中文字体（文章标题）
	$chinese_font_2 = get_template_directory().'/function/poster/fonts/hanyixizhongyuan.ttf';      // 海报中用到的中文字体2（文章摘要/网站副标题）
	imagefill($im,0,0,$white);      //设置海报底色填充
	$head_img = imagecreatefromstring(file_get_contents(timthumb($head_img,array('w'=>800,'h'=>'520'),'tim')));      // 海报头部图片宽高尺寸
	imagecopy($im,$head_img,0,0,0,0,800,520);      // 海报头部图片框宽高尺寸
	$day = $date['day'];        // 获取海报中显示的文章发布日期（天）
	$day_width = imagettfbbox(80,0,$english_font,$day);      // 计算并返回一个包围着 TrueType 文本范围的虚拟方框的像素大小（字体大小,旋转角度，字体文件，文本字符）
    $day_width = abs($day_width[2]-$day_width[0]);
	$year = $date['year'];      // 获取海报中显示的文章发布日期（年）
	$year_width = imagettfbbox(24,0,$english_font,$year);      // 计算并返回一个包围着 TrueType 文本范围的虚拟方框的像素大小（字体大小,旋转角度，字体文件，文本字符）
	$year_width = abs($year_width[2]-$year_width[0]);
	$day_left = ($year_width-$day_width)/2;          // 海报头部图片悬浮日期（天）距离左侧边缘
	imagettftext($im,80,0,50+$day_left,420,$white,$english_font,$day);      // 海报头部图片中绘制日期（天）（源图像，字体大小，旋转角度，X轴坐标，Y轴坐标，字体颜色，字体文件，文本字符）
	imageline($im,50,440,50+$year_width,440,$white);      // 海报头部图片中绘制日期间隔线的属性
	imagettftext($im,24,0,50,480,$white,$english_font,$year);      // 海报头部图片中绘制日期（年）（源图像，字体大小，旋转角度，X轴坐标，Y轴坐标，字体颜色，字体文件，文本字符）
	$title = mi_str_encode($title);
  	
	$title_conf = array('color'=>array('0'=>0,'1'=>0,'2'=>0),'fontsize'=>28,'width'=>680,'left'=>60,'top'=>540,'hang_size'=>24);
 	draw_txt_to($im,$title_conf ,$title,true,$chinese_font);     // 在海报上绘制文章标题 
	
	//$title_width = imagettfbbox(28,0,$chinese_font,$title);
	//$title_width = abs($title_width[2] - $title_width[0]);
	//$title_left = 350 - $title_width / 2;
	//imagettftext($im,28,0,$title_left,800,$black,$chinese_font,$title);   // 在海报上绘制偏移标题
	$des_conf = array('color'=>array('0'=>99,'1'=>99,'2'=>99),'fontsize'=>20,'width'=>680,'left'=>60,'top'=>660,'hang_size'=>18);
	draw_txt_to($im,$des_conf,$content,true,$chinese_font_2);    // 在海报上绘制文章摘要 
	
	// 增加作者、分类及更新日期
	$meta = $modified.' 由『 '. $author.' 』最后更新于『 '.$category.' 』分类下';
	$meta_conf = array('color'=>array('0'=>0,'1'=>120,'2'=>6),'fontsize'=>22,'width'=>680,'left'=>60,'top'=>900,'hang_size'=>18);
	draw_txt_to($im,$meta_conf,''.$meta,true,$chinese_font); 
	
	$style = array();
	imagesetstyle($im,$style);
	imageline($im,0,1020,800,1020,$gray);      // 文章摘要下方间隔线条设置（源图像，X1坐标，Y1坐标，X2坐标，Y2坐标，线条颜色）
	// 获取海报底部网站描述文字（网站副标题）
// 	$foot_text = QGG_Options('poster_desc');
	$foot_text = $foot_text ? $foot_text : get_bloginfo('description');
	$foot_text = mi_str_encode($foot_text);
	// 获取海报底部 Logo 文件
// 	$poster_logo = QGG_Options('poster_logo');
	if($poster_logo){
		//$att = wp_get_attachment_image_src($poster_logo,'full');
		//$logo_img = $att[0];
		$logo_img = $poster_logo;
	}else{
// 		$site_logo = QGG_Options('logo_src');
		if($site_logo){
			//$att = wp_get_attachment_image_src($site_logo,'full');
			//$logo_img = $att[0];
            //  $logo_img = QGG_Options('logo_src');
		}else{
			$logo_img = '';
		}
	}
	$logo_img = imagecreatefromstring(file_get_contents(timthumb($logo_img,array('w'=>240,'h'=>50),'tim')));
	
	// 判断海报中是否生成二维码图片
	if($qrcode_img){
		$foot_text_width = imagettfbbox(20,0,$chinese_font,$foot_text);
		$foot_text_width = abs($foot_text_width[2]-$foot_text_width[0]);
		$foot_text_left = 200-$foot_text_width/2;
		imagecopy($im,$logo_img,80,1120,0,0,240,50);
		imagettftext($im,20,0,$foot_text_left,1240,$foot_text_color,$chinese_font_2,$foot_text);      // 网站描述文字（副标题）（源图像，字体大小，旋转角度，X轴坐标，Y轴坐标，字体颜色，字体文件，文本字符）
		$qrcode_str = file_get_contents($qrcode_img);
		$qrcode_size = getimagesizefromstring($qrcode_str);
		$qrcode_img = imagecreatefromstring($qrcode_str);
		imagecopyresized($im,$qrcode_img,440,1030,0,0,320,320,$qrcode_size[0],$qrcode_size[1]);    // 复制并重定义二维码尺寸（源图像，目标图像，源X轴，源Y轴，目标X轴，目标Y轴，宽度，高度）
	}else{
		$foot_text_width = imagettfbbox(20,0,$chinese_font,$foot_text);
		$foot_text_width = abs($foot_text_width[2]-$foot_text_width[0]);
		$foot_text_left = 400-$foot_text_width/2;
		imagecopy($im,$logo_img,280,1120,0,0,240,50);
		imagettftext($im,20,0,$foot_text_left,1240,$foot_text_color,$chinese_font_2,$foot_text);
	}
	// 上传生成的海报图片至指定文件夹
	$upload_dir = wp_upload_dir();
	$poster_dir = $upload_dir['basedir'].'/posterimg';
	if (!is_dir($poster_dir)){
		wp_mkdir_p($poster_dir);
	}	
	$filename='/poster-'.$post_id.'.png';
	$file=$poster_dir.$filename;
	imagepng($im,$file);
	require_once ABSPATH.'wp-admin/includes/image.php';
	require_once ABSPATH.'wp-admin/includes/file.php';
	require_once ABSPATH.'wp-admin/includes/media.php';
	//$src = media_sideload_image($upload_dir['baseurl'].$filename,$post_id,NULL,'src');      // 不建议使用该方式，会将文件与文章关联，每次都会从新生成，浪费网站空间
	//unlink($file);
	$src = $upload_dir['baseurl'].'/posterimg'.$filename;
	error_reporting(0);
	imagedestroy($im);
	if(is_wp_error($src)){
		return false;
	}
	return $src;
}

function get_bigger_img(){
	$post_id = sanitize_text_field($_POST['id']);
	if(wp_verify_nonce($_POST['nonce'],'mi-create-bigger-image-'.$post_id)){
		get_the_time('d',$post_id);
		get_the_time('Y/m',$post_id);
		$date = array('day'=>get_the_time('d',$post_id),'year'=>get_the_time('Y/m',$post_id));
		$post_extend = get_post_meta($post_id,'post_extend',true);
		$post_extend = wp_parse_args((array)$xz_data[$xz_k],array('bigger_head_img'=>'','bigger_title'=>'','bigger_desc'=>''));
		$post_title = $post_extend['bigger_title'] ? $post_extend['bigger_title'] : get_the_title($post_id);
		$share_title = $post_extend['bigger_title'] ? $post_extend['bigger_title'] : get_the_title($post_id);
		
		// 增加作者、分类及更新日期
		$post_author_id = get_post($post_id)->post_author;
		$post_author = $post_extend['bigger_author'] ? $post_extend['bigger_author'] : get_the_author_meta('display_name',$post_author_id);
		$post_cat_id = get_the_category($post_id);
		$post_category = $post_extend['bigger_category'] ? $post_extend['bigger_category'] : $post_cat_id[0]->cat_name;
		$post_modified_id = get_post($post_id)->post_modified;
		$post_modified = $post_extend['bigger_modified'] ? $post_extend['bigger_modified'] : $post_modified_id;
		
		$title = substr_ext($post_title,0,28,'utf-8','');
		// 增加作者、分类及更新日期
		$author = substr_ext($post_author,0,6,'utf-8','');
		$category = substr_ext($post_category,0,6,'utf-8','');
		$modified = substr_ext($post_modified,0,10,'utf-8','');
		
		if($post_extend['bigger_desc']){
			$content = $post_extend['bigger_desc'];
		}else{
			$post = get_post($post_id);
			$content = $post->post_excerpt ? $post->post_excerpt : $post->post_content;
		}
		$content = substr_ext(strip_tags(strip_shortcodes($content)),0,150,'utf-8','...');
		$share_content = '【'.$share_title.'】'.substr_ext(strip_tags(strip_shortcodes($content)),0,120,'utf-8','');
		$content = str_replace(PHP_EOL,'',strip_tags(apply_filters('the_excerpt',$content)));
		if($post_extend['bigger_head_img']){
			$att = wp_get_attachment_image_src($post_extend['bigger_head_img'],'full');
			$head_img = $att[0];
		}else{
			$head_img = post_thumbnail_src($post ? $post : get_post($post_id));
			$att = wp_get_attachment_image_src($head_img,'full');
			$head_img = $att[0];
		}
		// 获取海报底部二维码图片
		//if(QGG_Options('share_poster_img_qrcode')){
			$qrcode_img = get_template_directory_uri().'/function/poster/function/qrcode.php?data='.get_the_permalink($post_id);
		//}else{
			//$qrcode_img = NULL;
		//}
		$result = create_bigger_image($post_id,$date,$title,$content,$head_img,$qrcode_img,$author,$category,$modified);
		if($result){
			$pic = '&pic='.urlencode($result);
			if(get_post_meta($post_id,'bigger_cover',true)){
				update_post_meta($post_id,'bigger_cover',$result);
			}else{
				add_post_meta($post_id,'bigger_cover',$result);
			}
			
			$share_link_weibo = sprintf('https://service.weibo.com/share/share.php?url=%s&type=button&language=zh_cn&searchPic=true%s&title=%s',urlencode(get_the_permalink($post_id)),$pic,$share_content);
			$share_link_qzone = sprintf('https://sns.qzone.qq.com/cgi-bin/qzshare/cgi_qzshare_onekey?url=%s&title=%s&desc=&summary=%s',urlencode(get_the_permalink($post_id)),$title,$share_content);
			$share_link_qq = sprintf('https://connect.qq.com/widget/shareqq/index.html?url=%s&title=%s&desc=&summary=%s',urlencode(get_the_permalink($post_id)),$title,$share_content);
			$share_link_renren = sprintf('http://widget.renren.com/dialog/share?resourceUrl=%s&title=%s&description=%s',urlencode(get_the_permalink($post_id)),$title,$share_content);
			
			if(get_post_meta($post_id,'bigger_cover_share_weibo',true)){
				update_post_meta($post_id,'bigger_cover_share_weibo',$share_link_weibo);
			}else{
				add_post_meta($post_id,'bigger_cover_share_weibo',$share_link_weibo);
			}
			if(get_post_meta($post_id,'bigger_cover_share_qzone',true)){
				update_post_meta($post_id,'bigger_cover_share_qzone',$share_link_qzone);
			}else{
				add_post_meta($post_id,'bigger_cover_share_qzone',$share_link_qzone);
			}
			if(get_post_meta($post_id,'bigger_cover_share_qq',true)){
				update_post_meta($post_id,'bigger_cover_share_qq',$share_link_qq);
			}else{
				add_post_meta($post_id,'bigger_cover_share_qq',$share_link_qq);
			}
			if(get_post_meta($post_id,'bigger_cover_share_renren',true)){
				update_post_meta($post_id,'bigger_cover_share_renren',$share_link_renren);
			}else{
				add_post_meta($post_id,'bigger_cover_share_renren',$share_link_renren);
			}
			$msg=array('s'=>200,'src'=>$result,'share_weibo'=>$share_link_weibo,'share_qzone'=>$share_link_qzone,'share_qq'=>$share_link_qq,'share_renren'=>$share_link_renren);
		}else{
			$msg=array('s'=>404,'m'=>'ERROR:404,封面生成失败，请稍后再试！');
		}
    }else{
		$msg=array('s'=>404,'m'=>'ERROR:404,图片消失啦~请联系管理员解决此问题！');
	}
	echo json_encode($msg);
	exit(0);
}