<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php if ( is_home() ) {
		bloginfo('name'); echo " - "; bloginfo('description');
	} elseif ( is_category() ) {
		single_cat_title(); echo " - "; bloginfo('name');
	} elseif (is_single() || is_page() ) {
		single_post_title();
	} elseif (is_search() ) {
		echo "搜索结果"; echo " - "; bloginfo('name');
	} elseif (is_404() ) {
		echo '页面未找到!';
	} else {
		wp_title('',true);
	} ?></title>
	    <link href="https://cdn.bootcss.com/fancybox/3.5.7/jquery.fancybox.min.css" rel="stylesheet">
	    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/static/css/bittheme.css">
        <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/static/css/theme.css">
        <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/static/fonts/iconfont.css">
        <script src="https://cdn.bootcss.com/jquery/3.4.1/jquery.min.js"></script>
        <script src="<?php bloginfo('template_url'); ?>/static/js/bittheme.js"></script>
        <script src="https://cdn.bootcss.com/fancybox/3.5.7/jquery.fancybox.min.js"></script>
        <script src="https://cdn.bootcss.com/jquery_lazyload/1.9.7/jquery.lazyload.min.js"></script>
        <meta name="description" content="" />
        <link rel="shortcut icon" href="<?php echo bittheme('website_icon'); ?>" type="image/x-icon" />
        <link rel="alternate" type="application/rss+xml" title="RSS 2.0 - 所有文章" href="<?php echo get_bloginfo('rss2_url'); ?>" />
        <link rel="alternate" type="application/rss+xml" title="RSS 2.0 - 所有评论" href="<?php bloginfo('comments_rss2_url'); ?>" />
<?php wp_head(); ?>
    </head>
<?php if (is_single()) { ?>
    <body class="home-template single-template">
<?php } else { ?>
    <body class="home-template">
<?php } ?>
        <div class="header">
            <div class="container">
                <div class="row">
                    <div class="header__inner col col-12">
                        <div class="logo">
<?php if (empty(bittheme('logo'))) { ?>
                            <a class="logo__link" href="<?php echo get_option('home'); ?>"><?php bloginfo('name'); ?></a>
<?php } else { ?>
                            <a class="logo__link" href="<?php echo get_option('home'); ?>"><img data-original="<?php echo bittheme('logo'); ?>" src="<?php bloginfo('template_url');?>/static/images/loading.gif" class="logo__img lazyload"></a>
<?php } ?>
                        </div>
                        <div class="menu-overlay">
                            <nav class="main-nav">
                                <div class="main-nav__box">
                                    <div class="nav__icon-close">
                                        <div class="ion">
                                            <span class="iconfont icon-Close_"></span>
                                        </div>
                                    </div>
                                    <div class="nav-grid">
                                        <div class="nav-grid__item">
                                            <h2 class="nav-grid__title">Menu</h2>
                                            <div class="mobile-nav">
                                                <ul class="nav__list list-reset">
<?php wp_nav_menu( array(
'theme_location' => 'mobile-phone-menu',
'menu' => '',
'container' => 'false',
'echo' => true,
'fallback_cb' => 'wp_page_menu',
'link_before' => '<div class="nav__link">',
'link_after' => '</div>',
'items_wrap' => '%3$s',
'depth' => 2,
'walker' => ''
) );
?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </nav>
                        </div>
                        <div class="navigation">
                            <div class="top-nav">
                                <ul class="nav__list list-reset">
<?php wp_nav_menu( array(
'theme_location' => 'top-menu',
'menu' => '',
'container' => 'false',
'echo' => true,
'fallback_cb' => 'wp_page_menu',
'link_before' => '<div class="nav__link">',
'link_after' => '</div>',
'items_wrap' => '%3$s',
'depth' => 2,
'walker' => ''
) );
?>
<?php
if ( is_user_logged_in() ) { ?>
                                    <li class="nav__item">
                                        <a class="nav__link signup-link" href="<?php echo get_option('home'); ?>/wp-admin">仪表盘</a>
                                    </li>
<?php } else { ?>
                                    <li class="nav__item">
                                        <a class="nav__link signup-link" href="<?php echo get_option('home'); ?>/wp-login">登录</a>
                                    </li>
<?php } ?>
                                </ul>
                            </div>
                            <div class="nav-buttons">
                                <div class="nav__icon nav__icon-menu ion">
                                    <span class="iconfont icon-Options_1"></span>
                                </div>
                                <div class="nav__icon nav__icon-search ion">
                                    <span class="iconfont icon-Search"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="search">
            <div class="container">
                <div class="row">
                    <div class="col col-12">
                        <div class="search__box">
                            <div class="search__close">
                                <div class="ion">
                                    <span class="iconfont icon-Close_"></span>
                                </div>
                            </div>
                            <div class="search__group">
                                <label for="js-search-input" class="screen-reader-text">搜索 - Search</label>
                                <input type="text" name="js-search-input" id="js-search-input" class="search__text" autocomplete="off" placeholder="输入关键词以搜索..." onkeyup="fetch()">
                            </div>
                            <div id="js-search-results" class="search-results-list"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>