<?php get_header(); ?>
<?php if (have_posts()) : the_post(); update_post_caches($posts); ?>
        <main class="content" aria-label="Content">
<?php if (empty(get_post_meta(get_the_ID(), 'my_post_options', true)['thumbnail'])) { ?>
<?php } else { ?>
            <div class="container">
                <div class="row">
                    <div class="col col-12">
                        <div class="image-box">
                            <img class="post-image lazyload" data-original="<?php echo post_thumbnail_src(); ?>" src="<?php bloginfo('template_url');?>/static/images/loading.gif" alt="<?php the_title(); ?>">
                        </div>
                    </div>
                </div>
            </div>
<?php } ?>
            <div class="container">
                <div class="row">
                    <div class="col col-8 col-d-10 push-2 push-d-1 col-t-12 push-t-0">
                        <article class="post animate">
                            <div class="post-head">
                                <div class="post-tags">
                                    <?php the_category(', '); ?>
                                </div>
                                <h1 class="post-title"><?php the_title(); ?></h1>
                                <div class="post__meta">
                                    <div class="post__author">
                                        <a class="post__author-image" style="background-image: url(<?php themetuts_gravatar_url() ?>)" aria-label=""></a>
                                        <div class="post__author-link"><?php the_author_posts_link(); ?></div>
                                    </div>
                                    <span class="post__date"><time datetime="<?php the_time('Y-n-j'); ?>"><?php the_time('Y-n-j'); ?></time></span>
                                </div>
                            </div>
                            <div class="post__content">
                                <?php the_content(); ?>
                            </div>
                            <div class="post__share">
                                <div class="share__head">
                                    <div class="share__title">分享这篇文章</div>
                                </div>
                                <ul class="share__list list-reset">
<?php if (bittheme('qq_share_switch') == true) { ?>
                                    <li class="share__item">
                                        <a class="share__link share__qq" target="_blank" href="http://connect.qq.com/widget/shareqq/index.html?url=<?php the_permalink(); ?>&title=<?php the_title(); ?>" title="分享至QQ" rel="nofollow"><span class="iconfont icon-qq"></span></a>
                                    </li>
<?php } ?>
<?php if (bittheme('wechat_sharing_switch') == true) { ?>
                                    <li class="share__item">
                                        <a data-fancybox data-animation-duration="500" data-src="#article-wechat-sharing-qr-code" class="share__link share__weixin" href="javascript:;" title="文章微信分享二维码" rel="nofollow"><span class="iconfont icon-weixin"></span></a>
                                    </li>
                                    <div style="display: none;" id="article-wechat-sharing-qr-code" class="animated-modal text-center p-5 wechat-share">
                                        <h2>微信扫一扫，分享给朋友</h2>
                                        <p>Scan wechat and share with friends</p>
                                        <p class="mb-0" style="text-align: center;">
                                            <img src="https://wenhairu.com/static/api/qr/?size=300&text=<?php the_permalink(); ?>">
                                        </p>
                                    </div>
<?php } ?>
<?php if (bittheme('qq_space_sharing_switch') == true) { ?>
                                    <li class="share__item">
                                        <a class="share__link share__qqkongjian" target="_blank" href="http://sns.qzone.qq.com/cgi-bin/qzshare/cgi_qzshare_onekey?url=<?php the_permalink(); ?>&title=<?php the_title(); ?>" title="分享至QQ空间" rel="nofollow"><span class="iconfont icon-qqkongjian"></span></a>
                                    </li>
<?php } ?>
<?php if (bittheme('quick_reading_switch') == true) { ?>
                                    <li class="share__item">
                                        <a href="<?php echo post_thumbnail_src(); ?>" class="share__link btn btn-primary quick_view" data-fancybox="quick-view" data-qw-form="article-sharing-card" title="文章分享卡片"><span class="iconfont icon-Paper_3"></span></a>
                                        <span class="hidden">
                                            <!--<a class="quick_view" data-fancybox="quick-view" href=""></a>-->
                                        </span>
                                        <div id="article-sharing-card" class="hidden">
                                            <h3><?php the_title(); ?></h3>
                                            <p><?php echo mb_strimwidth(strip_tags($post->post_content),0,230,'...'); ?></p>
                                        </div>
                                    </li>
<?php } ?>
<?php if (bittheme('article_poster_switch') == true) { ?>
                                    <li class="share__item">
                                        <a class="btn-bigger-cover share__link btn btn-primary load-poster-img" data-nonce="<?php echo wp_create_nonce('mi-create-bigger-image-'.$post->ID );?>" data-id="<?php echo $post->ID; ?>" data-action="create-bigger-image" id="bigger-cover" href="javascript:;"><span><span class="iconfont icon-Send"></span></span></a>
                                    </li>
<?php } ?>
                                </ul>
                            </div>
                            <div class="post__navigation">
<?php
$next_post = get_next_post();
if (!empty( $next_post )): ?>
                                <a class="prev" href="<?php echo get_permalink( $next_post->ID ); ?>" style="background-image: url(<?php echo get_post_meta($next_post->ID, 'my_post_options', true)['thumbnail']; ?>)">
                                    <div class="post__nav-box">
                                        <div class="post__nav post__nav__prev"><span class="iconfont icon-Left_1"></span> 上一篇</div>
                                         <h4 class="post__nav__title"><?php echo $next_post->post_title; ?></h4>
                                    </div>
                                </a>
<?php endif; ?>
<?php
$prev_post = get_previous_post();
if (!empty( $prev_post )): ?>
                                <a class="next" href="<?php echo get_permalink( $prev_post->ID ); ?>" style="background-image: url(<?php echo get_post_meta($prev_post->ID, 'my_post_options', true)['thumbnail']; ?>)">
                                    <div class="post__nav-box">
                                        <div class="post__nav post__nav__next">下一篇 <span class="iconfont icon-Right_1"></span>
                                        </div>
                                         <h4 class="post__nav__title"><?php echo $prev_post->post_title; ?></h4>
                                    </div>
                                </a>
<?php endif; ?>
                            </div>

                    </div>
                </div>
            </div>
        </main>
<?php else : ?>
<?php endif; ?>
<?php get_footer(); ?>