/********************
 * 点击事件
 ********************/
$(document).ready(function() {
    'use strict';
    var menuOpenIcon = $(".nav__icon-menu"),
        menuCloseIcon = $(".nav__icon-close"),
        menuList = $(".menu-overlay"),
        searchOpenIcon = $(".nav__icon-search"),
        searchCloseIcon = $(".search__close"),
        searchBox = $(".search");
    menuOpenIcon.click(function() {
        menuOpen();
    })
    menuCloseIcon.click(function() {
        menuClose();
    })
    searchOpenIcon.click(function() {
        searchOpen();
    });
    searchCloseIcon.click(function() {
        searchClose();
    });

    function menuOpen() {
        menuList.addClass("is-open");
    }

    function menuClose() {
        menuList.removeClass("is-open");
    }

    function searchOpen() {
        searchBox.addClass("is-visible");
    }

    function searchClose() {
        searchBox.removeClass("is-visible");
    }
    setTimeout(function() {
        $('body').addClass('is-in');
    }, 150)

    /********************
     * 返回顶部
     ********************/
    $(".top").click(function() {
        $("html, body")
            .stop()
            .animate({
            scrollTop: 0
        }, "slow", "swing");
    });
    $(window).scroll(function() {
        if ($(this).scrollTop() > $(window).height()) {
            $(".top").addClass("is-active");
        } else {
            $(".top").removeClass("is-active");
        }
    });
});

/********************
 * ajax加载
 ********************/
$('#pagination a').click(function() {
    $this = $(this);
    $this.addClass('loading').text("正在努力加载..."); //给a标签加载一个loading的class属性，可以用来添加一些加载效果
    var href = $this.attr("href"); //获取下一页的链接地址
    if (href != undefined) {
        //如果地址存在
        $.ajax({
            //发起ajax请求
            url: href, //请求的地址就是下一页的链接
            type: "get", //请求类型是get
            error: function(request) {
                //如果发生错误怎么处理
                console.log(request)
            },
            success: function(data) {
                //请求成功
                console.log(data)
                setTimeout(function() {
                    $(function() {
                        $("img.lazyload").lazyload({
                            effect: "fadeIn"
                        });
                    });
                    console.log(data)
                    $this.removeClass('loading').text("点击查看更多"); //移除loading属性
                    var $res = $(data).find(".ajax-item"); //从数据中挑出文章数据，请根据实际情况更改
                    $('.ajax-main').append($res.fadeIn(500)); //将数据加载加进posts-loop的标签中。
                    var newhref = $(data).find("#pagination a").attr("href"); //找出新的下一页链接
                    if (newhref != undefined) {
                        $("#pagination a").attr("href", newhref);
                    } else {
                        $("#pagination").html('全部已加载完毕'); //如果没有下一页了，隐藏
                    }
                }, 500);
            }
        });
    }
    return false;
});

/********************
 * 图片懒加载
 ********************/
$(function() {
    $("img.lazyload").lazyload({
        effect: "fadeIn"
    });
});

/********************
 * 2
 ********************/
$.fancyConfirm = function(opts) {
    opts = $.extend(
        true, {
        title: "Are you sure?",
        message: "",
        okButton: "OK",
        callback: $.noop
    },
        opts || {});

    $.fancybox.open({
        type: "html",
        src: '<div class="fc-content p-5 rounded" style="text-align: center;">' + '<h2 class="mb-3">' + opts.title + "</h2>" + "<p>" + opts.message + "</p>" + '<p class="text-right">' + '<button data-value="1" data-fancybox-close class="button button--primary">' + opts.okButton + "</button>" + "</p>" + "</div>",
        opts: {
            animationDuration: 350,
            animationEffect: "material",
            modal: true,
            baseTpl: '<div class="fancybox-container fc-container" role="dialog" tabindex="-1">' + '<div class="fancybox-bg"></div>' + '<div class="fancybox-inner">' + '<div class="fancybox-stage"></div>' + "</div>" + "</div>",
            afterClose: function(instance, current, e) {
                var button = e ? e.target || e.currentTarget : null;
                var value = button ? $(button).data("value") : 0;

                opts.callback(value);
            }
        }
    });
};

console.log('\n' + ' %c Designed by BitTheme %c https://www.wpbit.cn/ ' + '\n', 'color: #fadfa3; background: #030307; padding:5px 0; font-size:12px;', 'background: #fadfa3; padding:5px 0; font-size:12px;');

$('[data-fancybox]').fancybox({
    caption: function(instance, item) {
        return $(this).find('img').attr("alt");
    }
});

var addComment = {
    moveForm: function(a, b, c, d) {
        var e, f = this,
            g = f.I(a),
            h = f.I(c),
            i = f.I("cancel-comment-reply-link"),
            j = f.I("comment_parent"),
            k = f.I("comment_post_ID");
        if (g && h && i && j) {
            f.respondId = c, d = d || !1, f.I("wp-temp-form-div") || (e = document.createElement("div"), e.id = "wp-temp-form-div", e.style.display = "none", h.parentNode.insertBefore(e, h)), g.parentNode.insertBefore(h, g.nextSibling), k && d && (k.value = d), j.value = b, i.style.display = "", i.onclick = function() {
                var a = addComment,
                    b = a.I("wp-temp-form-div"),
                    c = a.I(a.respondId);
                if (b && c) return a.I("comment_parent").value = "0", b.parentNode.insertBefore(c, b), b.parentNode.removeChild(b), this.style.display = "none", this.onclick = null, !1
            };
            try {
                f.I("comment").focus()
            } catch (l) {}
            return !1
        }
    },
    I: function(a) {
        return document.getElementById(a)
    }
};