<?php
 namespace App\Web\Controller; use App\Web\Controller\BaseController; use Illuminate\Support\Facades\Session; use Mews\Captcha\Facades\Captcha; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\PageHtmlUtil; use Module\Vendor\SoftApi\SoftApiUtil; class MessageController extends BaseController { public function index() { $input = InputPackage::buildFromInput(); $page = $input->getPage(); $pageSize = 20; $option = []; $option['where'] = []; $option['order'] = ['id', 'desc']; $paginateData = ModelUtil::paginate('message', $page, $pageSize, $option); $pageHtml = PageHtmlUtil::render($paginateData['total'], $pageSize, $page, '?' . Request::mergeQueries(['page' => ['{page}']])); $messages = $paginateData['records']; return $this->view('message.index', compact('pageHtml', 'messages')); } public function submit() { $data = []; $input = InputPackage::buildFromInput(); $data['username'] = $input->getTrimString('username'); $data['content'] = $input->getTrimString('content'); $data['email'] = $input->getTrimString('email'); $data['url'] = $input->getTrimString('url'); if (SoftApiUtil::captchaIsEnable()) { $captchaKey = $input->getTrimString('captchaKey'); if (empty($captchaKey)) { return Response::send(-1, '请先进行安全验证'); } if (!SoftApiUtil::captchaValidate($captchaKey)) { return Response::send(-1, '请重新进行安全验证', null, '[js]window.tsCaptcha.reset();'); } } else { $captcha = $input->getTrimString('captcha'); if (!Captcha::check($captcha)) { return Response::send(-1, '图片验证码错误', null, '[js]$(\'[data-captcha]\').click();'); } } if (empty($data['content'])) { return Response::send(-1, '留言内容为空'); } ModelUtil::insert('message', $data); return Response::send(0, null, null, '[js]__app.success();'); } public function up($id) { $message = ModelUtil::get('message', ['id' => $id]); if (empty($message)) { return Response::send(-1, 'message not found'); } if (Session::has('message-up-' . $message['id'])) { return Response::send(0, null, ['count' => $message['upCount']]); } Session::put('message-up-' . $message['id'], true); $message = ModelUtil::update('message', ['id' => $message['id']], ['upCount' => $message['upCount'] + 1]); return Response::send(0, null, ['count' => intval($message['upCount'] + 1)]); } public function down($id) { $message = ModelUtil::get('message', ['id' => $id]); if (empty($message)) { return Response::send(-1, 'message not found'); } if (Session::has('message-down-' . $message['id'])) { return Response::send(0, null, ['count' => $message['downCount']]); } Session::put('message-down-' . $message['id'], true); $message = ModelUtil::update('message', ['id' => $message['id']], ['downCount' => $message['downCount'] + 1]); return Response::send(0, null, ['count' => intval($message['downCount'] + 1)]); } public function submitCaptcha() { return Captcha::create('formula'); } public function captchaVerify() { return SoftApiUtil::captchaVerify(); } } 