<?php
 namespace Module\Vendor\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelManageUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Util\TreeUtil; use ModStart\Module\ModuleManager; class WidgetLinkController extends Controller { private function build($groupName, $titleLinks) { if (empty($titleLinks)) { return null; } return [ 'title' => $groupName, 'list' => array_filter(array_map(function ($item) { return $item ? [ 'title' => $item[0], 'link' => $item[1], ] : null; }, $titleLinks)) ]; } public function select() { $links = []; $links[] = $this->build('应用模块', [ ['首页', '/'], ]); if (ModuleManager::isModuleInstalled('LandingPage')) { $prefix = ModuleManager::getModuleConfig('LandingPage', 'prefix', '/p/'); $links[] = $this->build('落地页', array_map(function ($record) use ($prefix) { return [$record['title'], $prefix . $record['url']]; }, ModelUtil::all('landing_page'))); } if (ModuleManager::isModuleInstalled('Product')) { $links[] = $this->build('产品', array_merge( [['产品', '/product']], array_map(function ($record) { return [$record['title'], "/product?categoryId=$record[id]"]; }, ModelUtil::all('product_category')) )); } if (ModuleManager::isModuleInstalled('Post')) { $links[] = $this->build('文章', array_merge( [['文章', '/post']], array_map(function ($record) { return [$record['title'], "/post?categoryId=$record[id]"]; }, ModelUtil::all('post_category')) )); } if (ModuleManager::isModuleInstalled('News')) { $links[] = $this->build('新闻资讯', array_merge( [['新闻资讯', '/news']], array_map(function ($record) { return [$record['title'], "/news?categoryId=$record[id]"]; }, ModelUtil::all('news_category')) )); } if (ModuleManager::isModuleInstalled('Cases')) { $links[] = $this->build('案例', array_merge( [['案例', '/case']], array_map(function ($record) { return [$record['title'], "/news?categoryId=$record[id]"]; }, ModelUtil::all('news_category')) )); } if (ModuleManager::isModuleInstalled('CmsJob')) { $links[] = $this->build('招聘', array_merge( [['招聘', '/job']], array_map(function ($record) { return [$record['title'], "/job/$record[id]"]; }, ModelUtil::all('cms_job')) )); } if (ModuleManager::isModuleInstalled('CmsHelp')) { $tree = TreeUtil::modelToTree('cms_help_category', ['name' => 'name',]); $categories = TreeUtil::treeToListWithIndent($tree, 'id', 'name'); $links[] = $this->build('帮助', array_merge( [['帮助', '/help']], array_map(function ($record) { return ['分类 - ' . $record['title'], "/help/category/$record[id]"]; }, $categories) )); } if (ModuleManager::isModuleInstalled('Member')) { $links[] = $this->build('会员相关', [ ['注册', '/register'], ['登录', '/login'], ]); } if (ModuleManager::isModuleInstalled('Article')) { $links[] = $this->build('单页文章', array_map(function ($record) { return [$record['title'], "/article/$record[id]"]; }, ModelUtil::all('article'))); } return view('modstart::admin.dialog.linkSelector', [ 'links' => array_filter($links), ]); } }