@extends('theme.default.pc.frame')

@section('pageTitleMain',htmlspecialchars($blog['title']))
@section('pageKeywords',htmlspecialchars($blog['seoKeywords']))
@section('pageDescription',htmlspecialchars($blog['seoDescription']))

{!! \ModStart\ModStart::js('asset/vendor/jqueryTimeago.js') !!}
@section('bodyAppend')
    <script>
        $(function () {
            $.timeago.settings.allowFuture = true;
            $("[datetime]").timeago();
        });
    </script>
    @if(\Module\Vendor\SoftApi\SoftApiUtil::captchaIsEnable())
        {!! \Module\Vendor\SoftApi\SoftApiUtil::captchaScript() !!}
        <script>
            $(function () {
                window.tsCaptcha = window.TSCaptcha.init({
                    server: '/blog/captcha_verify',
                    selector: '.pb-captcha-box',
                    appId: '{{\Module\Vendor\SoftApi\SoftApiUtil::captchaAppId()}}',
                    onValidate: function (key) {
                        $('[name=captchaKey]').val(key);
                    },
                    onReset:function () {
                        $('[name=captchaKey]').val('');
                    }
                });
            });
        </script>
    @endif
@endsection

@section('bodyContent')

    <div class="blog">
        <div class="head">
            <h1>
                <a href="javascript:;" onclick="window.history.back();"><i class="iconfont icon-angleleft"></i></a>
                {{$blog['title']}}
            </h1>
            <div class="attr">
                <time datetime="{{$blog['postTime']}}"></time>发布，{{$blog['clickCount'] or 0}} 人读过
            </div>
            @if(!empty($blog['tag']))
                <div class="tag">
                    @foreach($blog['tag'] as $tag)
                        <span>{{$tag}}</span>
                    @endforeach
                </div>
            @endif
        </div>
        <div class="body">
            @if(!empty($blog['summary']))
                <div class="summary">
                    {!! \ModStart\Core\Util\HtmlUtil::text2html($blog['summary']) !!}
                </div>
            @endif
            @if(!empty($blog['images']))
                <div class="images">
                    @foreach($blog['images'] as $image)
                        <div class="image">
                            <img src="{{\ModStart\Core\Assets\AssetsUtil::fix($image)}}" />
                        </div>
                    @endforeach
                </div>
            @endif
            @if(!empty($blog['content']))
                <div class="content">
                    {!! \ModStart\Core\Util\HtmlUtil::replaceImageSrcToLazyLoad($blog['content'],'src',true) !!}
                </div>
            @endif
            <div class="share">
                <div data-share-buttons data-sites="weibo,qq,qzone,wechat"></div>
            </div>
        </div>
        <div class="nav">
            <div class="row">
                <div class="col-md-6 ub-text-left">
                    @if($prevBlog)
                        <a href="/blog/{{$prevBlog['id']}}">上一篇：{{$prevBlog['title']}}</a>
                    @endif
                </div>
                <div class="col-md-6 ub-text-right">
                    @if($nextBlog)
                        <a href="/blog/{{$nextBlog['id']}}">下一篇：{{$nextBlog['title']}}</a>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if(modstart_config('blogCommentEnable',false))

        <div class="comment page-block">
            <form action="/blog/{{$blog['id']}}/comment" method="post" data-ajax-form>
                <div class="head">
                    <a href="javascript:;" class="avatar">
                        <img src="@asset('asset/image/avatar.png')" />
                    </a>
                    <div class="input">
                        <input type="text" class="form" name="username" placeholder="输入你的称呼" />
                    </div>
                </div>
                <div class="body">
                    <textarea name="content" placeholder="输入想说的话"></textarea>
                </div>
                <div class="contact">
                    <div class="row">
                        <div class="col-md-3">
                            <input type="text" name="email" placeholder="Email地址" />
                        </div>
                        <div class="col-md-3">
                            <input type="text" name="url" placeholder="主页或微博" />
                        </div>
                        @if(\Module\Vendor\SoftApi\SoftApiUtil::captchaIsEnable())
                            <div class="col-md-4">
                                <input type="hidden" name="captchaKey"/>
                                <div class="pb-captcha-box" style="transform:scale(0.95);transform-origin: 0 0;"></div>
                            </div>
                        @else
                            <div class="col-md-2 col-6">
                                <img src="/blog/comment_captcha?{{time()}}" data-captcha onclick="this.src='/blog/comment_captcha?'+Math.random();" style="height:2rem;border:1px solid #DDD;border-radius:3px;width:100%;" />
                            </div>
                            <div class="col-md-2 col-6">
                                <input type="text" name="captcha" placeholder="图片验证" />
                            </div>
                        @endif
                        <div class="col-md-2">
                            <button type="submit">提交</button>
                        </div>
                    </div>
                </div>
                <div class="desc">
                    <strong>隐私说明：</strong>你个人主页网址会被公开链接，但 Email 地址不会被公开显示。
                </div>
            </form>
        </div>

        <div class="comment-list">
            @foreach($comments as $comment)
                <section class="item page-block">
                    <div class="head">
                        <div class="avatar">
                            <img src="@asset('asset/image/avatar.png')" />
                        </div>
                        @if(empty($comment['username']))
                            <h3 class="ub-text-muted">匿名</h3>
                        @else
                            <h3>
                                @if($comment['url'])
                                    <a href="{{$comment['url']}}" target="_blank">{{$comment['username']}}</a>
                                @else
                                    {{$comment['username']}}
                                @endif
                            </h3>
                        @endif
                        <h4><time datetime="{{$comment['created_at']}}"></time>说：</h4>
                    </div>
                    <div class="content">
                        {!! \ModStart\Core\Util\HtmlUtil::text2html($comment['content']) !!}
                    </div>
                </section>
            @endforeach
        </div>

        <div class="ub-page">
            {!! $commentPageHtml !!}
        </div>

    @endif

@endsection
