@extends($_viewFrame)

@section('pageTitle',modstart_config('siteName').' - '.modstart_config('siteSlogan'))

{!! \ModStart\ModStart::js('asset/vendor/imagesloaded.js') !!}
{!! \ModStart\ModStart::js('asset/vendor/masonry.js') !!}
@section('bodyAppend')
    @parent
    @if(!empty($blogList))
        <script>
            var list = $('.blog-list').masonry({
                columnWidth: $('.blog-list .blog-list-block')[0],
                itemSelector: '.blog-list-block'
            });
            $('.blog-list').find('img').on('load', function () {
                list.data('masonry').layout();
            });
        </script>
    @endif
@endsection

@section('bodyContent')

    <div class="blog-list">
        @foreach($blogList as $blog)
            <div class="blog-list-block">
                <a class="item page-block" href="/blog/{{$blog['id']}}">
                    @if(empty($blog['summary']) && !empty($blog['images'][0]))
                        <div class="cover cover-only">
                            <img src="{{\ModStart\Core\Assets\AssetsUtil::fix($blog['images'][0])}}"/>
                        </div>
                    @else
                        <h2>{{$blog['title']}}</h2>
                        @if(!empty($blog['images'][0]))
                            <div class="cover">
                                <img src="{{\ModStart\Core\Assets\AssetsUtil::fix($blog['images'][0])}}"/>
                            </div>
                        @endif
                        @if(!empty($blog['summary']))
                            <div class="summary">
                                {!! \ModStart\Core\Util\HtmlUtil::text2html($blog['summary']) !!}
                            </div>
                        @endif
                    @endif
                </a>
            </div>
        @endforeach
        @if(empty($blogs))
            <div class="ub-empty">
                暂无记录
            </div>
        @endif
    </div>

    @if(!empty($blogList))
        <div class="ub-page">
            {!! $pageHtml !!}
        </div>
    @endif

@endsection