<?php
 namespace ModStart\Grid; use Closure; use ModStart\Core\Dao\DynamicModel; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\TreeUtil; use ModStart\Field\AbstractField; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Concerns\HasGridFilter; use ModStart\Grid\Concerns\HasItemOperate; use ModStart\Grid\Concerns\HasPaginator; use ModStart\Grid\Concerns\HasSort; use ModStart\Grid\Type\GridEngine; use ModStart\Support\Concern\HasBuilder; use ModStart\Support\Concern\HasFields; use ModStart\Support\Concern\HasFluentAttribute; use ModStart\Support\Concern\HasSetting; use ModStart\Support\Manager\FieldManager; class Grid { use HasBuilder, HasFields, HasFluentAttribute, HasGridFilter, HasItemOperate, HasPaginator, HasSort; private $id; private $model; protected $fluentAttributes = [ 'engine', 'title', 'titleAdd', 'titleEdit', 'titleShow', 'canAdd', 'canEdit', 'canDelete', 'canShow', 'canExport', 'canMultiSelectItem', 'canBatchDelete', 'canBatchSelect', 'canSort', 'urlAdd', 'urlEdit', 'urlDelete', 'urlShow', 'urlExport', 'urlSort', 'addBlankPage', 'editBlankPage', 'enablePagination', 'defaultOrder', 'treeMaxLevel', 'treeRootPid', 'batchOperatePrepend', ]; private $engine = 'basic'; private $title; private $titleAdd; private $titleEdit; private $titleShow; private $canAdd = true; private $canEdit = true; private $canDelete = true; private $canShow = true; private $canExport = false; private $canMultiSelectItem = false; private $canBatchDelete = false; private $canBatchSelect = false; private $canSort = false; private $urlAdd; private $urlEdit; private $urlDelete; private $urlShow; private $urlExport; private $urlSort; private $addBlankPage = false; private $editBlankPage = false; private $enablePagination = true; private $defaultOrder = []; private $treeMaxLevel = 0; private $treeRootPid = 0; private $batchOperatePrepend = ''; private $view = 'modstart::core.grid.index'; public function __construct($repository = null, \Closure $builder = null) { $this->id = IdUtil::generate('Grid'); $this->model = new Model($this, $repository); $this->setupFields(); $this->fieldDefaultRenderMode(FieldRenderMode::GRID); $this->setupGridFilter(); $this->setupItemOperate(); $this->builder($builder); } public static function make($model, \Closure $builder = null) { if (class_exists($model) && is_subclass_of($model, \Illuminate\Database\Eloquent\Model::class)) { return new Grid($model, $builder); } return new Grid(DynamicModel::make($model), $builder); } public function asTree($keyName = 'id', $pidColumn = 'pid', $sortColumn = 'sort', $titleColumn = 'title') { $this->repository()->setKeyName($keyName); $this->repository()->setTreePidColumn($pidColumn); $this->repository()->setSortColumn($sortColumn); $this->repository()->setTreeTitleColumn($titleColumn); $this->engine = GridEngine::TREE; $this->enablePagination(false); $this->canSort(true); return $this; } public function asTreeMass($rootPid = 0, $keyName = 'id', $pidColumn = 'pid', $sortColumn = 'sort', $titleColumn = 'title') { $this->repository()->setKeyName($keyName); $this->repository()->setTreePidColumn($pidColumn); $this->repository()->setSortColumn($sortColumn); $this->repository()->setTreeTitleColumn($titleColumn); $this->engine = GridEngine::TREE_MASS; $this->enablePagination(false); $this->canSort(true); return $this; } public function canBatchDelete($value = null) { if (null === $value) { return $this->canBatchDelete; } $this->canBatchDelete = true; $this->canMultiSelectItem(true); return $this; } public function canBatchSelect($value = null) { if (null === $value) { return $this->canBatchSelect; } $this->canBatchSelect = true; $this->canMultiSelectItem(true); return $this; } public function disableCUD() { $this->canAdd(false)->canEdit(false)->canDelete(false); return $this; } public function repository() { return $this->model->repository(); } public function getRepositoryKeyName() { return $this->model->repository()->getKeyName(); } public function filter(Closure $callback) { call_user_func($callback, $this->filter); } private function build() { $this->runBuilder(); $this->prepareItemOperateField(); } public function request() { $addition = null; $this->build(); $input = InputPackage::buildFromInput(); $this->repository()->setArgument([ 'page' => $input->getPage(), 'pageSize' => $input->getPageSize(), 'order' => $input->getArray($this->model->getOrderName()), 'orderDefault' => $this->defaultOrder, ]); $treeAncestors = []; if ($this->engine === GridEngine::TREE_MASS) { $pid = $input->get('_pid', $this->treeRootPid); $this->repository()->setArgument([ 'treeRootPid' => $this->treeRootPid, 'treePid' => $pid, ]); if ($pid != $this->treeRootPid) { $treeAncestors = $this->repository()->getTreeAncestorItems(); } $addition = view('modstart::core.grid.treeAncestor', [ 'treeAncestors' => $treeAncestors, 'grid' => $this, ])->render(); } $this->filter->setSearch($input->getArray('search')); $items = $this->filter->execute(); if ($this->engine == GridEngine::TREE) { $treeIdName = $this->repository()->getKeyName(); $treePidName = $this->repository()->getTreePidColumn(); $treeSortName = $this->repository()->getTreeSortColumn(); $items = TreeUtil::itemsMergeLevel($items, $treeIdName, $treePidName, $treeSortName); } $paginator = $this->model->paginator(); $records = []; foreach ($items as $index => $item) { $itemColumns = []; if ($item instanceof \Illuminate\Database\Eloquent\Model) { $itemColumns = array_keys($item->getAttributes()); } else if ($item instanceof \stdClass) { $itemColumns = array_keys(get_object_vars($item)); } else { BizException::throws('Grid item support Model|stdClass only'); } $record = []; $record['_id'] = $item->{$this->repository()->getKeyName()}; foreach ($this->listableFields() as $field) { if ($field->isLayoutField()) { continue; } $value = null; if (in_array($field->column(), $itemColumns) || ($item instanceof \Illuminate\Database\Eloquent\Model && method_exists($item, $field->column())) ) { $value = $item->{$field->column()}; $field->item($item); if ($field->hookValueUnserialize()) { $value = call_user_func($field->hookValueUnserialize(), $value, $field); } $field->item($item); $value = $field->unserializeValue($value, $field); if ($field->hookFormatValue()) { $value = call_user_func($field->hookFormatValue(), $value, $field); } $item->{$field->column()} = $value; } else { $field->item($item); if ($field->hookValueUnserialize()) { $value = call_user_func($field->hookValueUnserialize(), $value, $field); } $value = $field->unserializeValue($value, $field); if ($field->hookFormatValue()) { $value = call_user_func($field->hookFormatValue(), $value, $field); } } $field->setValue($value); $field->item($item); $record[$field->column()] = $field->renderView($field, $item, $index); if ($this->engine == GridEngine::TREE && $field->column() == $this->repository()->getTreeTitleColumn()) { $treePrefix = str_repeat('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', $item->_level - 1) . '<a class="tree-arrow-icon ub-text-muted" href="javascript:;"><i class="icon iconfont icon-angle2"></i></a> '; $record[$field->column()] = $treePrefix . htmlspecialchars($record[$field->column()]); } else if ($this->engine == GridEngine::TREE_MASS && $field->column() == $this->repository()->getTreeTitleColumn()) { $record[$field->column()] = '<span class="tree-arrow-icon ub-text-muted"><i class="icon iconfont icon-angle2"></i></span>' . '<a class="ub-text-primary" href="?_pid=' . $record['_id'] . '" title="' . L('Manage') . '"><i class="icon iconfont icon-sign1"></i> ' . htmlspecialchars($record[$field->column()]) . '</a>'; } } $records[] = $record; } $head = []; foreach ($this->listableFields() as $field) { if ($field->isLayoutField()) { continue; } $record = [ 'field' => $field->column(), 'title' => $field->label(), 'sort' => $field->sortable(), ]; if ($field->width()) { $record['width'] = $field->width(); } $head[] = $record; } return Response::jsonSuccessData([ 'head' => $head, 'page' => $paginator ? $paginator->currentPage() : 1, 'pageSize' => $paginator ? $paginator->perPage() : count($records), 'total' => $paginator ? $paginator->total() : count($records), 'records' => $records, 'addition' => $addition, ]); } public function render() { $this->build(); $data = array_merge($this->fluentAttributeVariables(), [ 'id' => $this->id, 'filters' => $this->filter->filters(), 'grid' => $this, ]); return view($this->view, $data)->render(); } public function __toString() { return $this->render(); } public function __call($method, $arguments) { switch ($method) { case 'hookSaved': case 'hookDeleting': case 'hookChanged': case 'hookDeleted': return $this; } if ($this->isFluentAttribute($method)) { return $this->fluentAttribute($method, $arguments); } return FieldManager::call($this, $method, $arguments); } }