<?php

namespace app\admin\validate;

use think\Validate;

class Article extends Validate {
    protected $rule = [
        'category_id' =>  'checkId',
        'title'  =>  'require|max:100|token',
        'keywords' =>  'max:100',
        'description' =>  'max:200',
        'meta_keywords' =>  'max:200',
        'meta_description' =>  'max:200',
    ];

    protected $message = [
        'title.require'  =>  '标题为必填',
        'title.max'  =>  '标题最多100个字符',
        'keywords.max'  =>  '关键词最多100个字符',
        'description.max' =>  '栏目描述最多200个字符',
        'meta_keywords.max' =>  '关键字最多200个字符',
        'meta_description.max' =>  '描述最多200个字符',
    ];

    protected function checkId($value,$rule,$data){
        if($value < 1){
            return '栏目ID错误';
        }
        return true;
    }
}