<?php

namespace app\admin\validate;

use think\Validate;

class Category extends Validate {
    protected $rule = [
        'name'  =>  'require|max:100',
        'description' =>  'max:200',
        'meta_keywords' =>  'max:200',
        'meta_description' =>  'max:200',
    ];

    protected $message = [
        'name.require'  =>  '栏目名称为必填',
        'name.max'  =>  '栏目名称最多100个字符',
        'description.max' =>  '栏目描述最多200个字符',
        'meta_keywords.max' =>  '关键字最多200个字符',
        'meta_description.max' =>  '描述最多200个字符',
    ];

}