<?php

//删除目录（包括下面的文件）
function delDir($directory, $subdir = true) {
    if (is_dir($directory) == false) {
        return false;
    }
    $handle = opendir($directory);
    while (($file = readdir($handle)) !== false) {
        if ($file != "." && $file != "..") {
            is_dir("$directory/$file") ?delDir("$directory/$file") : unlink("$directory/$file");
        }
    }
    if (readdir($handle) == false) {
        closedir($handle);
        rmdir($directory);
    }
}

//对一个给定的二维数组按照指定的键值进行排序
function array_sort($arr,$keys,$type='asc'){
    $keysvalue = $new_array = array();
    foreach ($arr as $k=>$v){
        $keysvalue[$k] = $v[$keys];
    }
    if($type == 'asc'){
        asort($keysvalue);
    }else{
        arsort($keysvalue);
    }
    reset($keysvalue);
    foreach ($keysvalue as $k=>$v){
        $new_array[$k] = $arr[$k];
    }
    return $new_array;
}

//时间日期格式化为多少天前
function format_datetime($date_time,$type=1,$format=false){
    if($type == 1){
        $timestamp = strtotime($date_time);
    }elseif($type == 2){
        $timestamp = $date_time;
        $date_time = date('Y-m-d H:i:s',$date_time);
    }
    if($format==true){
        return date($format,$timestamp);
    }
    $difference = time()-$timestamp;
    if($difference <= 180){
        return '刚刚';
    }elseif($difference <= 3600){
        return ceil($difference/60).'分钟前';
    }elseif($difference <= 86400){
        return ceil($difference/3600).'小时前';
    }elseif($difference <= 2592000){
        return ceil($difference/86400).'天前';
    }elseif($difference <= 31536000){
        return ceil($difference/2592000).'个月前';
    }else{
        return ceil($difference/31536000).'年前';
        //return $date_time;
    }
}

//获取随机字符串
function getRandomString($len, $chars=null)
{
    if (is_null($chars)){
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    }
    mt_srand(10000000*(double)microtime());
    for ($i = 0, $str = '', $lc = strlen($chars)-1; $i < $len; $i++){
        $str .= $chars[mt_rand(0, $lc)];
    }
    return $str;
}

//获取一个加密过的md5密码
function uum_get_pwd($str){
    return $pwd=md5(md5($str).CMS_NAME);
}

//密码比较
function uum_check_pwd($pwd,$db_pwd){
    return uum_get_pwd($pwd) == $db_pwd;
}

//访问量增加
function uum_hits_add($id, $tableName){
    \think\Db::name($tableName)->where('id', $id)->setInc('hits');
}

//留言增加
function uum_comment_add($id, $tableName){
    \think\Db::name($tableName)->where('id', $id)->setInc('comment_num');
}

function uum_get_wangEditor($value=''){
    $str = '<div id="content"></div><textarea id="text" name="content" style="display: none"></textarea>';
    $str .='<script type="text/javascript" src="/static/wangEditor/wangEditor.min.js"></script>';
    $str .='<script>
            var E = window.wangEditor;
            var editor = new E("#content");
            var $text = $("#text");
            editor.customConfig.uploadFileName = "file";
            editor.customConfig.uploadImgServer = "'.url('upload/wangEditor_upimage').'"; // 上传图片到服务器
            editor.customConfig.onchange = function (html) {
                // 监控变化，同步更新到 textarea
                $text.val(html)
            }
            editor.create();
            editor.txt.html(\''.$value.'\');
            $text.val(editor.txt.html())
        </script>';
    return $str;
}
//评论者头像
function getNickeNameAndImg(){
    $data=\think\Db::name('comment')->field('id,send')->order('id desc')->limit(50)->select();
    $arr=[];
    foreach ($data as $v){
        $v['send']=json_decode($v['send'],true);
        $arr[]=$v['send']['image'];
    }
    return array_unique($arr);
}
