<?php

namespace app\index\controller;

use think\Controller;
use think\Request;
use think\Db;

class Common extends Controller{
    public $category;
    protected $model_data;  //获取当前model数据信息
    public $setting;
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub

        //获取设置
        $this->setting=model('setting')->getSetting();
        $this->assign('setting',$this->setting);
        if($this->setting['site_status'] == 0){
            $this->redirect('/404.html');
        }

        //动态模板设置
        $temp=scandir('./template');
        unset($temp[0]);
        unset($temp[1]);
        unset($temp[2]);
        $this->assign('temp',$temp);

        $cookie_temp_name=cookie('temp_name');
        //var_dump($cookie_temp_name);
        if(!is_null($cookie_temp_name)){
            $this->setting['template_name']=$cookie_temp_name;
        }

        //动态设置模板
        $this->view->config('view_path','./template/'. $this->setting['template_name'] .'/');
        //动态设置模板替换变量
        $this->view->replace('__TEMPLATE__','/template/' . $this->setting['template_name']);

        //如果是pjax 修改ajax 返回类型
        if($this->request->isPjax()){
            config('default_ajax_return','html');
        }
        //增加访问量
        Db::name('setting')->where('key','visit_num')->setInc('value');
        //获取
        $visit_num=Db::name('setting')->where('key','visit_num')->find();
        $visit_num=$visit_num['value'];
        $this->assign('visit_num',$visit_num);

        //获取评论数量
        $pinglun=Db::name("comment")->count("id");
        $this->assign('pinglun',$pinglun);

        //获取文章数量
        $article=Db::name("article")->count("id");
        $this->assign('article',$article);

        //获取视频数量
        $video=Db::name("video")->count("id");
        $this->assign('video',$video);

        //获取头部导航
        $this->category=model('category')->homeGetCategoryTreeArray();
        $this->assign('category',$this->category);

        //评论者头像
        $this->assign('image',getNickeNameAndImg());
        $request= Request::instance();

        //根据当前controller获取模型数据
        $this->model_data=model('admin/models')->adminGetModelDataToTableName(strtolower($request->controller()));

    }
}