<?php

namespace app\index\controller;

class Page extends Common{

    //单页显示
    public function index(){
        $category_id=$this->request->param('category/d', 0 ,'intval');

        $data=model('page')->getPageDataToCategoryId($category_id);
        if(count($data) == 0){
            //没有数据则跳转到404
            $this->redirect('/404.html');
        }
        $this->assign('data',$data);
        //访问量增加
        uum_hits_add($data['id'],$this->model_data['tablename']);
        //获取面包屑导航
        $category_breadcrumb=model('category')->indexGetCategoryBreadcrumbToModelId($data['category_id'],$this->model_data['id']);
        $this->assign('category_breadcrumb',$category_breadcrumb);
        //栏目导航
        $second_categorys=model('category')->indexGetSecondCategoryToModelId($this->model_data['id'],$category_id);
        $this->assign('second_categorys',$second_categorys);
        //栏目数据
        //推荐文章
        $this->recommend_list=model('article')->indexGetArticleToOrder(['is_recommend'=>1],['is_top','desc']);
        //热门文章
        $this->hot_list=model('article')->indexGetArticleToOrder([],['hits','desc']);
        $this->assign('recommend_list',$this->recommend_list);
        $this->assign('hot_list',$this->hot_list);

        $category_data=model('category')->indexFindCategoryDataToId($category_id);
        $temp=(!empty($category_data['index_template']) ? $category_data['index_template'] : '');
        return $this->fetch($temp);
    }
}