<?php require_once ('txq_chkadmin.php');?>

<!DOCTYPE html>

<html>

<head>

	<meta charset="utf-8">

	<title>用户列表</title>

	<meta name="renderer" content="webkit">

	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">

	<?php require_once 'txq_header.php';?>



</head>

<body >



<div class="layui-fluid">

	<div class="layui-card txq-card" >

		<div class="layui-form layui-card-header layuiadmin-card-header-auto" lay-filter="layadmin-useradmin-formlist">

			<div class="layui-form-item">

				<div class="layui-inline">

					<label class="layui-form-label">用户名</label>

					<div class="layui-input-block">

						<input type="text" id="loginname" name="loginname" placeholder="请输入" autocomplete="off" class="layui-input">

					</div>

				</div>

				<div class="layui-inline">

					<label class="layui-form-label">手机</label>

					<div class="layui-input-block">

						<input type="text" name="telphone" placeholder="请输入" autocomplete="off" class="layui-input">

					</div>

				</div>

				<div class="layui-inline">

					<label class="layui-form-label">邮箱</label>

					<div class="layui-input-block">

						<input type="text" name="email" placeholder="请输入" autocomplete="off" class="layui-input">

					</div>

				</div>

				<div class="layui-inline">

					<label class="layui-form-label">角色</label>

					<div class="layui-input-block">

						<select name="role">

							<option value="">请选择</option>

							<option value="1">超级管理员</option>

							<option value="2">普通管理员</option>

							<option value="3">普通用户</option>

						</select>

					</div>

				</div>

				<div class="layui-inline">

					<button class="layui-btn layuiadmin-btn-admin" lay-submit lay-filter="txq-search" id="txq-search">

						<i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>

					</button>

				</div>

			</div>

		</div>



		<div class="layui-card-body">



			<table class="layui-hide" id="adminlist" lay-filter="adminlist"></table>



			<script type="text/html" id="toolbarDemo">

				<div class="layui-btn-container">

					<button class="layui-btn layui-btn-sm" lay-event="getCheckData">批量删除</button>

					<button class="layui-btn layui-btn-sm" lay-event="add">添加用户</button>



				</div>



			</script>



			<script type="text/html" id="barDemo">

				<a class="layui-btn layui-btn-xs" lay-event="edit">编辑</a>

				<a class="layui-btn layui-btn-danger layui-btn-xs" lay-event="del">删除</a>



			</script>





		</div>

	</div>

</div>





<script type="text/html" id="switchzt">



	<input type="checkbox" name="zt" value="{{d.id}}" lay-skin="switch" lay-text="正常|锁定" lay-filter="switchzt" {{ d.a_zt ==1 ? 'checked' : '' }}>

</script>

<?php require_once 'txq_footer.php';?>

<script>

    layui.use(['form','table'], function(){

        var form = layui.form; var table = layui.table;



        table.render({

            elem: '#adminlist'

            , url: 'txq_ajax.class.php?a=adminlist'

            , toolbar: '#toolbarDemo' //开启头部工具栏，并为其绑定左侧模板

            ,defaultToolbar: ['filter', 'exports']

            , title: '用户数据表'

            , cols: [[

                  {type: 'checkbox', fixed: 'left'}

                , {field: 'id', title: 'ID', width: 80, fixed: 'left', unresize: true, sort: true}

                , {field: 'a_name', title: '用户名', width: 120, }

                , {field: 'a_email', title: '邮箱', width: 150, }



                , {field: 'a_sex', title: '性别', width: 80,  unresize: true, sort: true}

                , {field: 'a_nick', title: '昵称', width: 100}

                , {field: 'a_cellphone', title: '电话',width:120}

                , {field: 'a_ip', title: 'IP', width: 120}

                , {field: 'a_dltime', title: '登入时间', width: 100, sort: true}

                , {field: 'a_tjtime', title: '加入时间', width: 120}

                , {field: 'a_xgtime', title: '更新时间', width: 120}

                , {field: 'a_qx', title: '角色',templet:function(d){

                    if(d.a_qx==1){return "超级管理员";} if(d.a_qx==2){return "普通管理员";} if(d.a_qx==3){return "会员";}}, width: 120}

                , {field: 'a_zt', title: '状态', width: 120,templet:function(d){return d.a_zt==1 ? "正常" : "锁定";}, unresize: true,}

                , {fixed: 'right', title: '操作', toolbar: '#barDemo', width: 150}



            ]]

 		    , page: true

            , limit: 10



        });



        //监听性别操作

        form.on('switch(switchzt)', function(obj){

           // layer.tips(this.value + ' ' + this.name + '：'+ obj.elem.checked, obj.othis);

          jq_get("txq_ajax.class.php?a=adminzt&id="+this.value+"&zt="+obj.elem.checked);



        });



        //监听搜索

        form.on('submit(txq-search)', function(data){

            var field = data.field;



            //执行重载

            table.reload('adminlist', {

                where: field

            });

        });



        //监听单元格编辑

        table.on('edit(adminlist)', function (obj) {

            var value = obj.value //得到修改后的值

                , data = obj.data //得到所在行所有键值

                , field = obj.field; //得到字段

            //layer.msg('[ID: ' + data.id + '] ' + field + ' 字段更改为：' + value);





        });

        //头工具栏事件

        table.on('toolbar(adminlist)', function(obj){

            var checkStatus = table.checkStatus(obj.config.id);

            switch(obj.event){

                case 'getCheckData':

                   // var data = checkStatus.data;

                    var selectCount = checkStatus.data.length;

         			if(!selectCount){

                        layer.msg('批量删除至少选中一项数据',function(){});

                        return false;

					}



                    layer.confirm('真的要删除选中的项吗？',function(index){

                        layer.close(index);

                        index = layer.load(1, {shade: [0.1,'#fff']});



                        var isStr="";

                        for(var i=0; i<selectCount; i++){

                            isStr = isStr + "," + checkStatus.data[i].id;

                        }



                        $.ajax({

                            type:'post',

                            data:{"isStr":isStr},

                            url:"txq_ajax.class.php?a=adminalldel",

                            success:function(data){

                                var js=JSON.parse(data);

                                if(js.zt){

                                    layer.msg(js.msg,{icon: 6,time:2000});

                                    $('#txq-search').click();

                                }else{

                                    layer.msg(js.msg,{icon: 5,time:1000});

								}

                                layer.close(index);

                               },error:function(code){

                                parent.layer.msg('操作失败!',{icon: 5,time:1000});

                            }

                        });





                        });

                    // alert(JSON.stringify(data));

                    break;

                 case 'add':

                    layer.open({

                        type: 2

                        ,title: '添加用户'

                        ,content: 'txq_addadmin.php'

                        ,maxmin: true

                        ,area: ['550px', '550px']

                        ,btn: ['确定', '取消']

                        ,yes: function(index, layero){

                            var submit = layero.find('iframe').contents().find("#layuiadmin-app-form-submit");

                             submit.click();

                        }

                    });

                    break;





            };

        });



        //监听行工具事件

        table.on('tool(adminlist)', function (obj) {

            var data = obj.data;

            //console.log(obj)

            if (obj.event === 'del') {

                layer.confirm('真的删除行么', function (index) {

                    jq_get("txq_ajax.class.php?a=admindel&id="+data.id);

                    obj.del();

                    layer.close(index);

                });

            } else if (obj.event === 'edit') {

                layer.open({

                    type: 2

                    ,title: '修改管理员'

                    ,content: 'txq_editadmin.php?id='+data.id

                    ,maxmin: true

                    ,area: ['550px', '550px']

                    ,btn: ['确定', '取消']

                    ,yes: function(index, layero){

                        var submit = layero.find('iframe').contents().find("#layuiadmin-app-form-submit");

                        submit.click();

                    }

                });

            }

        });



        $('.layui-btn.layuiadmin-btn-list').on('click', function(){

            var type = $(this).data('type');

            active[type] ? active[type].call(this) : '';

        });



    });

</script>



</body>

</html>