<?php require_once ('txq_chkadmin.php');?>

<!DOCTYPE html>

<html>

<head>

	<meta charset="utf-8">

	<title>标签列表</title>

	<meta name="renderer" content="webkit">

	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">

	<?php require_once 'txq_header.php';?>



</head>

<body >



<div class="layui-fluid">

	<div class="layui-card txq-card" >

		<div class="layui-form layui-card-header layuiadmin-card-header-auto" lay-filter="layadmin-useradmin-formlist">

			<div class="layui-form-item">

				<div class="layui-inline">

					<label class="layui-form-label">标签名称</label>

					<div class="layui-input-block">

						<input type="text" id="t_name" name="t_name" placeholder="请输入" autocomplete="off" class="layui-input">

					</div>

				</div>



				<div class="layui-inline">

					<button class="layui-btn layuiadmin-btn-admin" lay-submit lay-filter="txq-search" id="txq-search">

						<i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>

					</button>

				</div>

			</div>

		</div>

		<div class="layui-card-body">



			<table class="layui-hide" id="adminlist" lay-filter="adminlist"></table>



			<script type="text/html" id="toolbarDemo">

				<div class="layui-btn-container">

					<button class="layui-btn layui-btn-sm" lay-event="getCheckData">批量删除</button>

					<button class="layui-btn layui-btn-sm" lay-event="add">添加标签</button>



				</div>



			</script>



			<script type="text/html" id="barDemo">



				<a class="layui-btn layui-btn-danger layui-btn-xs" lay-event="del">删除</a>



			</script>





		</div>

	</div>

</div>





<?php require_once 'txq_footer.php';?>

<script>

    layui.use(['form','table'], function(){

        var form = layui.form; var table = layui.table;



        table.render({

            elem: '#adminlist'

            , url: 'txq_ajax.class.php?a=taglist'

            , toolbar: '#toolbarDemo' //开启头部工具栏，并为其绑定左侧模板

            ,defaultToolbar: ['filter', 'exports']

            , title: '标签管理'

            , cols: [[

                {type: 'checkbox', fixed: 'left'}

                , {field: 'id', title: 'ID', width: 80, fixed: 'left', unresize: true, sort: true}

                , {field: 't_name', title: '网站名称-可编辑', width: 150,edit: 'text' }

                , {field: 't_time', title: '入录时间', width: 200, sort: true}

                , {field: 't_xgtime', title: '更新时间', width: 200, sort: true}

                , {fixed: 'right', title: '操作', toolbar: '#barDemo', width: 150}



            ]]

            , page: true

            , limit: 20



        });







        //监听搜索

        form.on('submit(txq-search)', function(data){

            var field = data.field;



            //执行重载

            table.reload('adminlist', {

                where: field

            });

        });



        //监听单元格编辑

        table.on('edit(adminlist)', function (obj) {

            var value = obj.value //得到修改后的值

                , data = obj.data //得到所在行所有键值

                , field = obj.field; //得到字段

            //layer.msg('[ID: ' + data.id + '] ' + field + ' 字段更改为：' + value);

            jq_get("txq_ajax.class.php?a=tagxg&field="+field+"&wzid="+data.id,"POST",{name:value});



        });

        //头工具栏事件

        table.on('toolbar(adminlist)', function(obj){

            var checkStatus = table.checkStatus(obj.config.id);

            switch(obj.event){

                case 'getCheckData':

                    var data = checkStatus.data;

                    var selectCount = checkStatus.data.length;

                    if(!selectCount){

                        layer.msg('批量删除至少选中一项数据',function(){});

                        return false;

                    }



                    layer.confirm('真的要删除选中的项吗？',function(index){

                        layer.close(index);

                        index = layer.load(1, {shade: [0.1,'#fff']});



                        var isStr="";

                        for(var i=0; i<selectCount; i++){

                            isStr = isStr + "," + checkStatus.data[i].id;

                        }



                        $.ajax({

                            type:'post',

                            data:{"isStr":isStr},

                            url:"txq_ajax.class.php?a=tagalldel",

                            success:function(data){

                                var js=JSON.parse(data);

                                if(js.zt){

                                    layer.msg(js.msg,{icon: 6,time:1000});

                                    $('#txq-search').click();

                                }else{

                                    layer.msg(js.msg,{icon: 5,time:1500});

                                }

                                layer.close(index);

                            },error:function(code){

                                parent.layer.msg('操作失败!',{icon: 5,time:1000});

                            }

                        });





                    });

                    // alert(JSON.stringify(data));

                    break;

                case 'add':

                    layer.open({

                        type: 2

                        ,title: '添加链接'

                        ,content: 'txq_addtag.php'

                        ,maxmin: true

                        ,area: ['400px', '300px']

                        ,btn: ['确定', '取消']

                        ,yes: function(index, layero){

                            var submit = layero.find('iframe').contents().find("#layuiadmin-app-form-submit");

                            submit.click();

                        }

                    });

                    break;



            };

        });



        //监听行工具事件

        table.on('tool(adminlist)', function (obj) {

            var data = obj.data;

            //console.log(obj)

            if (obj.event === 'del') {

                layer.confirm('真的删除行么', function (index) {

                    jq_get("txq_ajax.class.php?a=tagdel&id="+data.id);

                    obj.del();

                    layer.close(index);

                });

            }

        });



        $('.layui-btn.layuiadmin-btn-list').on('click', function(){

            var type = $(this).data('type');

            active[type] ? active[type].call(this) : '';

        });



    });

</script>



</body>

</html>