<?php



/**

 * @Created by TXQPHP

 * @author: Tian xinqiu

 * @Time:2020/4/21-20:29

 * @qq:190066120

 */



	if (!defined('ROOT'))

	{

	    exit;

	}



	require_once ('txq_Config.php');



	class Txqsql extends config

	{

	    //私有的属性

	    private static $dbcon = false;

	    private $host;

	    private $port;

	    private $user;

	    private $pass;

	    private $db;



	    private $mysqli;



	    //私有的构造方法

	    private function __construct()

	    {



	        $this->host = Config::db()["host"] ? Config::db()["host"] : '127.0.0.1';

	        $this->port = Config::db()["port"] ? Config::db()["port"] : '3306';

	        $this->user = Config::db()["user"] ? Config::db()["user"] : 'root';

	        $this->pass = Config::db()["pass"] ? Config::db()["pass"] : 'root';

	        $this->db = Config::db()["db"] ? Config::db()["db"] : 'myphp';

	        if (Config::db()["driver"] == "pdo")

	        {

	            //连接数据库

	            $this->pdo_connect();

	        }

	        else

	        {



	            $this->db_connect();

	        }



	    }



	    //PDO连接数据库

	    function pdo_connect()

	    {

	        try

	        {

	            $this->mysqli = new PDO('mysql:host=' . $this->host . ';port=' . $this->port .

	                ';dbname=' . $this->db . ';charset=utf8', $this->user, $this->pass);

	            $this->mysqli->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

	        }

	        catch (PDOException $e)

	        {

	            if (Config::db()['debug'])

	            {

	                $this->write($e->getMessage());

	            }

	            echo 'database connect error.';

	            exit;

	        }

	        return $this->mysqli;

	    }





	    //连接数据库

	    private function db_connect()

	    {

	        $this->mysqli = new mysqli($this->host . ':' . $this->port, $this->user, $this->

	            pass, $this->db);



	        if ($this->mysqli == null || !$this->mysqli)

	        {



	            if ($this->mysqli->connect_errno())

	            {

	                printf("连接数据出错: %s\n", $this->mysqli->connect_error());

	                exit();

	            }

	        }



	        if (!$this->mysqli->set_charset("utf8"))

	        {

	            printf("Error loading character set utf8: %s\n", $this->mysqli->error);

	        }

	        else

	        {

	            $this->mysqli->character_set_name();

	        }



	    }





	    //公用的静态方法

	    public static function getIntance()

	    {

	        if (self::$dbcon == false)

	        {

	            self::$dbcon = new Txqsql();

	        }

	        return self::$dbcon;

	    }





	    function prepare($sql)

	    {

	        $stm = $this->mysqli->prepare($sql);

	        return $stm;

	    }



	    function bindValue($stm, $params)

	    {

	        if (!$params)

	        {

	            return false;

	        }

	        foreach ($params as $key => $val)

	        {

	            $key++;

	            $stm->bindValue($key, $val);

	        }

	    }



	    function bindParam($stm, $params)

	    {

	        if (!$params)

	        {

	            return false;

	        }

	        foreach ($params as $key => $val)

	        {

	            $key++;

	            $stm->bindParam($key, $val);

	        }

	    }



	    function parseQues($data)

	    {

	        $result = [];

	        foreach ($data as $key => $val)

	        {

	            $result['fields'][] = $key;

	            $result['ques'][] = '?';

	            $result['values'][] = $val;

	        }

	        return $result;

	    }



	    function parseWhere($where)

	    {

	        if (!$where)

	        {

	            return false;

	        }

	        if (!$where['fields'])

	        {

	            return false;

	        }

	        return ['where' => 'where ' . $where['fields'], 'values' => $where['values']];

	    }



	    function pdo_execute($stm)

	    {



	        try

	        {

	            $stm->execute();

	        }

	        catch (PDOException $e)

	        {

	            $trace = $e->getTrace();

	            $str = '';

	            foreach ($trace[2] as $key => $val)

	            {

	                if ($key == 'file' || $key == 'line' || $key == 'class')

	                {

	                    $str .= $str ? "\n" : '';

	                    $str .= '[' . $key . ']' . $val;

	                }

	            }

	            $this->write('error in ' . $e->getFile() . ' ' . $e->getLine() . "\n" . $e->

	                getMessage() . "\n" . $stm->queryString . "\n" . $str, "pdo_execute");

	        }

	    }



	    function pdo_query($sql)

	    {



	        try

	        {

	            return $this->mysqli->query($sql);

	        }

	        catch (PDOException $e)

	        {

	            $this->write('error in ' . $e->getFile() . ' ' . $e->getLine() . "\n" . $e->

	                getMessage() . "\n" . $stm->queryString, "pdo_query");

	        }

	    }



	    function pdo_exec($sql)

	    {





	        try

	        {

	            return $this->mysqli->exec($sql);

	        }

	        catch (PDOException $e)

	        {

	            $this->write('error in ' . $e->getFile() . ' ' . $e->getLine() . "\n" . $e->

	                getMessage() . "\n" . $stm->queryString, "pdo_exec");

	        }

	    }



	    function fetchAll($stm)

	    {



	        return $stm->fetchAll(PDO::FETCH_ASSOC);

	    }



	    function fetchRow($stm)

	    {



	        return $stm->fetch(PDO::FETCH_ASSOC);

	    }





	    function pdo_count($table, $where = array())

	    {



	        $result = $this->parseWhere($where);

	        $where = $result && $result['where'] ? $result['where'] : '';

	        $sql = "SELECT COUNT(*) AS num FROM " . $table . " " . $where;

	        $stm = $this->prepare($sql);

	        if ($result && $result['values'])

	        {

	            $this->bindValue($stm, $result['values']);

	        }

	        $this->pdo_execute($stm);

	        $result = $this->fetchRow($stm);

	        return $result['num'];

	        $stm = null;

	        $this->pdo_Close();

	    }



	    function pdo_sum($table, $fields = array(), $where = array())

	    {

	        $result = $this->parseWhere($where);

	        $where = $result && $result['where'] ? $result['where'] : '';

	        if (!$fields || !is_array($fields))

	        {

	            return 0;

	        }

	        $sum = '';

	        foreach ($fields as $key => $val)

	        {

	            $sum .= $sum ? ',' : '';

	            $sum .= 'sum(' . $val . ') as ' . $key;

	        }

	        $sql = "SELECT " . $sum . " FROM " . $table . " " . $where;

	        $stm = $this->prepare($sql);

	        if ($result && $result['values'])

	        {

	            $this->bindValue($stm, $result['values']);

	        }

	        $this->pdo_execute($stm);

	        $result = $this->fetchRow($stm);

	        if ($result && is_array($result))

	        {

	            foreach ($result as $key => $val)

	            {

	                $result[$key] = $val == null ? 0 : number_format($val, 2, '.', '');

	            }

	        }



	        return $result;

	        $stm = null;

	        $this->pdo_Close();

	    }





	    function pdo_insert($table, $data)

	    {



	        if (!$data)

	        {

	            return false;

	        }

	        $result = $this->parseQues($data);

	        $sql = "INSERT INTO " . $table . " (" . implode(',', $result['fields']) .

	            ") VALUES(" . implode(',', $result['ques']) . ")";

	        $stm = $this->prepare($sql);

	        $this->bindValue($stm, $result['values']);

	        $this->pdo_execute($stm);

	        return $this->mysqli->lastInsertId();

	        $stm = null;

	        $this->pdo_Close();

	    }



	    function getTable($table)

	    {

	        return Config::db()['prefix'] . $table;

	    }



	    function pdo_delete($table, $where = [])

	    {



	        $result = $this->parseWhere($where);

	        $where = $result && $result['where'] ? $result['where'] : '';

	        $sql = "DELETE FROM " . $table . " " . $where;

	        $stm = $this->prepare($sql);

	        if ($result && $result['values'])

	        {

	            $this->bindValue($stm, $result['values']);

	        }

	        $this->pdo_execute($stm);

	        return $stm->rowCount();

	        $stm = null;

	        $this->pdo_Close();

	    }



	    function pdo_deleteIn($table, $where = [])

	    {

     	   $cons = '';

	        if ($where)

	        {

	            foreach ($where as $key => $val)

	            {

	                $cons = 'WHERE ' . $key . ' IN (' . implode(',', $val) . ')';

	            }

            //   $this->write($cons, "pdo_deleteIn");

	        }

	        return $this->pdo_exec("DELETE FROM " . $table . " " . $cons);



	        $this->pdo_Close();

	    }











	    /**

	     * @param $table 表名

	     * @param $set  更新的字段

	     * @param array $where 条件

	     * @return mixed

	     * @Created by TXQPHP

	     * @author: Tian xinqiu

	     * @Time:2020/4/22-10:44

	     * @qq:190066120

	     */

	    function pdo_update($table, $set, $where = [])

	    {



	        $result = $this->parseWhere($where);

	        $where = $result && $result['where'] ? $result['where'] : '';

	        $data = $this->parseQues($set);



	        $fields = '';

	        foreach ($data['fields'] as $field)

	        {

	            $fields .= $fields ? ',' : '';

	            $fields .= $field . '=?';

	        }

	        $sql = "UPDATE " . $table . " SET " . $fields . " " . $where;



	        $stm = $this->prepare($sql);

	        if ($result && $result['values'])

	        {

	            $arr = array_merge($data['values'], $result['values']);

	        }

	        else

	        {

	            $arr = $data['values'];

	        }

	        $this->bindValue($stm, $arr);

	        $this->pdo_execute($stm);

	        return $stm->rowCount();

	        $stm = null;

	        $this->pdo_Close();

	    }



	    //-------------------------------------------------------------以上PDO



	    //执行sql语句的方法

	    public function query($sql)

	    {

	        $res = $this->mysqli->query($sql);

	        if (!$res)

	        {

	            self::error();

	        }

	        return $res;

	    }





	    /**

	     * @Created by TXQPHP

	     * @author: Tian xinqiu

	     * @Time:2020/4/22-9:06

	     * @qq:190066120

	     * @查询所有记录

	     */



	    public function fetall($table, $filed = "*", $where = "1=1", $order = "id desc",

	        $limit = "0,10")

	    {



	        $arr = [];

	        if (is_array($where))

	        {

	            foreach ($where as $key => $val)

	            {

	                $condition = $key . '=' . $val;

	            }

	        }

	        else

	        {

	            $condition = $where;

	        }

	        $sql = "select $filed  from $table where $condition order by $order limit $limit";

	        $ret = $this->query($sql);





	        while ($row = $ret->fetch_assoc())

	        {



	            $arr[] = $row;

	        }





	        return $arr;



	    }



	    /**

	     * @Created by TXQPHP

	     * @author: Tian xinqiu

	     * @Time:2020/4/22-8:59

	     * @qq:190066120

	     * @查询总和

	     */

	    public function sum($table, $filed = "id", $where = "1=1")

	    {

	        if (is_array($where))

	        {

	            foreach ($where as $key => $val)

	            {

	                $condition = $key . '=' . $val;

	            }

	        }

	        else

	        {

	            $condition = $where;

	        }

	        $sql = "select sum($filed) as mysum from $table where $condition";



	        $result = $this->query($sql)->fetch_assoc();





	        return $result['mysum'];



	    }



	    /**

	     * @Created by TXQPHP

	     * @author: Tian xinqiu

	     * @Time:2020/4/21-23:17

	     * @qq:190066120

	     * @查询条数

	     */

	    public function num($table, $where = "1=1")

	    {



	        if (is_array($where))

	        {

	            foreach ($where as $key => $val)

	            {

	                $condition = $key . '=' . $val;

	            }

	        }

	        else

	        {

	            $condition = $where;

	        }

	        $sql = "select id from $table where $condition";

	        $nums = $this->query($sql)->num_rows;

	        //返回结果集中行的数量：num_rows

	        return $nums;



	    }





	    /**

	     * @param $table  表名

	     * @param string $feild 字段

	     * @param $where 条件

	     * @return 执行sql语句查询一条记录

	     * @Created by TXQPHP

	     * @author: Tian xinqiu

	     * @Time:2020/4/21-23:15

	     * @qq:190066120

	     */

	    public function getone($table, $feild = "*", $where = "1=1")

	    {

	        if (is_array($where))

	        {

	            foreach ($where as $key => $val)

	            {

	                $condition = $key . '=' . $val;

	            }

	        }

	        else

	        {

	            $condition = $where;

	        }

	        $sql = "select $feild from $table where $condition";





	        $result = $this->query($sql)->fetch_assoc();





	        //从结果集中取得一行作为关联数组

	        return $result;

	    }





	    /**

	     * 修改

	     * @param string $table_name 表名

	     * @param array $params array('列名'=》$value)

	     * @param array $conditions array('列名'=》$value)

	     * @return bool true 修改成功； false 修改失败

	     * @author aaron

	     */

	    public function update($table_name, $params, $conditions)

	    {

	        // 更改的值

	        $arr_params = [];

	        foreach ($params as $key => $value)

	        {

	            if (is_null($value))

	            {

	                $arr_params[] = "`" . $key . "` = NULL";

	            }

	            else

	            {

	                $arr_params[] = "`" . $key . "` = '" . $value . "'";

	            }

	        }

	        // 更改条件

	        $arr_conditions = [];

	        foreach ($conditions as $key => $value)

	        {

	            $arr_conditions[] = "`" . $key . "` = '" . $value . "'";

	        }



	        $str_fileds = implode(',', $arr_params);

	        $str_where = implode(' and ', $arr_conditions);



	        $sql = "update `" . $table_name . "` set " . $str_fileds . " where " . $str_where;

	        if ($res = $this->query($sql))

	        {

	            $rows = $this->mysqli->affected_rows;

	        }

	        else

	        {

	            $rows = false;

	        }



	        return $rows;

	    }



	    /**

	     * 新增

	     * @param string $table_name 表名

	     * @param array $params array('列名'=》'value')

	     * @param bool $boo 默认false返回操作是否成功 true返回新增ID

	     * @author aaron

	     */

	    public function insert($table_name, $params)

	    {

	        // 列名

	        $fileds = [];

	        // 值

	        $values = [];

	        foreach ($params as $key => $value)

	        {

	            $fileds[] = "`" . $key . "`";

	            $values[] = "'" . $value . "'";

	        }





	        $str_fileds = implode(',', $fileds);

	        $str_values = implode(',', $values);

	        $sql = "insert into `" . $table_name . "` (" . $str_fileds . ") values(" . $str_values .

	            ")";

	        $this->query($sql);

	        $result = $this->mysqli->insert_id;



	        return $result;

	    }



	    /*

	    * 删除一条数据方法

	    * @param1 $table, $where=array('id'=>'1') 表名 条件

	    * @return 受影响的行数

	    */

	    public function deleteOne($table, $where)

	    {

	        if (is_array($where))

	        {

	            foreach ($where as $key => $val)

	            {

	                $condition = $key . '=' . $val;

	            }

	        }

	        else

	        {

	            $condition = $where;

	        }

	        $sql = "delete from $table where $condition";

	        $this->query($sql);

	        //返回受影响的行数

	        return $this->mysqli->affected_rows;

	    }



	    /*

	    * 删除多条数据方法

	    * @param1 $table, $where 表名 条件

	    * @return 受影响的行数

	    */

	    public function deleteAll($table, $where = "1=1")

	    {

	        if (is_array($where))

	        {

	            foreach ($where as $key => $val)

	            {

	                if (is_array($val))

	                {

	                    $condition = $key . ' in (' . implode(',', $val) . ')';

	                }

	                else

	                {

	                    $condition = $key . '=' . $val;

	                }

	            }

	        }

	        else

	        {

	            $condition = $where;

	        }

	        $sql = "delete from $table where $condition";

	        $this->query($sql);

	        //返回受影响的行数

	        return $this->mysqli->affected_rows;

	    }





	    /**

	     * 关闭数据库连接.

	     */

	    public function pdo_Close()

	    {

	        if (is_object($this->mysqli))

	        {



	            $this->mysqli = null;

	        }

	    }





	    /**

	     * 关闭数据库连接.

	     */

	    public function Close()

	    {

	        if (is_object($this->mysqli))

	        {

	            mysqli_close($this->mysqli);

	            $this->mysqli = null;

	        }

	    }





	    /**

	     * @Created by TXQPHP

	     * @author: Tian xinqiu

	     * @Time:2020/4/21-21:31

	     * @qq:190066120

	     */

	    public function error()

	    {



	        die($this->mysqli->errno . "<br/>" . $this->mysqli->error . "<br/>" . $this->

	            mysqli->close());



	    }





	}



?>